<?php
/**
 * DefaultApi
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Locator
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Locator
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Locator\Request;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use UPS\Locator\ApiException;
use UPS\Locator\Configuration;
use UPS\Locator\HeaderSelector;
use UPS\Locator\ObjectSerializer;

/**
 * DefaultApi Class Doc Comment
 *
 * @category Class
 * @package  UPS\Locator
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DefaultApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation locator
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API  Valid values: - v2 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \UPS\Locator\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Locator\Locator\LOCATORResponseWrapper
     */
    public function locator($body, $version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        list($response) = $this->locatorWithHttpInfo($body, $version, $req_option, $trans_id, $transaction_src, $locale);
        return $response;
    }

    /**
     * Operation locatorWithHttpInfo
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API  Valid values: - v2 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \UPS\Locator\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Locator\Locator\LOCATORResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function locatorWithHttpInfo($body, $version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        $returnType = '\UPS\Locator\Locator\LOCATORResponseWrapper';
        $request = $this->locatorRequest($body, $version, $req_option, $trans_id, $transaction_src, $locale);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\LOCATORResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation locatorAsync
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API  Valid values: - v2 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function locatorAsync($body, $version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        return $this->locatorAsyncWithHttpInfo($body, $version, $req_option, $trans_id, $transaction_src, $locale)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation locatorAsyncWithHttpInfo
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API  Valid values: - v2 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function locatorAsyncWithHttpInfo($body, $version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        $returnType = '\UPS\Locator\Locator\LOCATORResponseWrapper';
        $request = $this->locatorRequest($body, $version, $req_option, $trans_id, $transaction_src, $locale);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'locator'
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API  Valid values: - v2 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function locatorRequest($body, $version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling locator'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling locator'
            );
        }
        // verify the required parameter 'req_option' is set
        if ($req_option === null || (is_array($req_option) && count($req_option) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $req_option when calling locator'
            );
        }

        $resourcePath = '/locations/{version}/search/availabilities/{reqOption}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($locale !== null) {
            $queryParams['Locale'] = ObjectSerializer::toQueryValue($locale, null);
        }
        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }
        // path params
        if ($req_option !== null) {
            $resourcePath = str_replace(
                '{' . 'reqOption' . '}',
                ObjectSerializer::toPathValue($req_option),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation locator_0
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of API  Valid values: - v1 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \UPS\Locator\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Locator\Locator\LOCATORResponseWrapper
     */
    public function locator_0($body, $deprecated_version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        list($response) = $this->locator_0WithHttpInfo($body, $deprecated_version, $req_option, $trans_id, $transaction_src, $locale);
        return $response;
    }

    /**
     * Operation locator_0WithHttpInfo
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of API  Valid values: - v1 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \UPS\Locator\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Locator\Locator\LOCATORResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function locator_0WithHttpInfo($body, $deprecated_version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        $returnType = '\UPS\Locator\Locator\LOCATORResponseWrapper';
        $request = $this->locator_0Request($body, $deprecated_version, $req_option, $trans_id, $transaction_src, $locale);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\LOCATORResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Locator\Locator\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation locator_0Async
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of API  Valid values: - v1 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function locator_0Async($body, $deprecated_version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        return $this->locator_0AsyncWithHttpInfo($body, $deprecated_version, $req_option, $trans_id, $transaction_src, $locale)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation locator_0AsyncWithHttpInfo
     *
     * Locator
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of API  Valid values: - v1 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function locator_0AsyncWithHttpInfo($body, $deprecated_version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        $returnType = '\UPS\Locator\Locator\LOCATORResponseWrapper';
        $request = $this->locator_0Request($body, $deprecated_version, $req_option, $trans_id, $transaction_src, $locale);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'locator_0'
     *
     * @param  \UPS\Locator\Locator\LOCATORRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of API  Valid values: - v1 (required)
     * @param  string $req_option Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations. (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $locale Locale of request (optional, default to en_US)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function locator_0Request($body, $deprecated_version, $req_option, $trans_id = null, $transaction_src = 'testing', $locale = 'en_US')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling locator_0'
            );
        }
        // verify the required parameter 'deprecated_version' is set
        if ($deprecated_version === null || (is_array($deprecated_version) && count($deprecated_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deprecated_version when calling locator_0'
            );
        }
        // verify the required parameter 'req_option' is set
        if ($req_option === null || (is_array($req_option) && count($req_option) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $req_option when calling locator_0'
            );
        }

        $resourcePath = '/locations/{deprecatedVersion}/search/availabilities/{reqOption}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($locale !== null) {
            $queryParams['Locale'] = ObjectSerializer::toQueryValue($locale, null);
        }
        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($deprecated_version !== null) {
            $resourcePath = str_replace(
                '{' . 'deprecatedVersion' . '}',
                ObjectSerializer::toPathValue($deprecated_version),
                $resourcePath
            );
        }
        // path params
        if ($req_option !== null) {
            $resourcePath = str_replace(
                '{' . 'reqOption' . '}',
                ObjectSerializer::toPathValue($req_option),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
