# Paperless
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 
- Package version: 1.0.8
- Build package: io.swagger.codegen.v3.generators.php.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/abantecart/ups-paperless.git"
    }
  ],
  "require": {
    "abantecart/ups-paperless": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/Paperless/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Paperless\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Paperless\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$version = "version_example"; // string | Version of API  Valid values: - v2
$shipper_number = "shipper_number_example"; // string | Your Shipper Number
$document_id = "document_id_example"; // string | DocumentId representing uploaded document to Forms History. Only one DocumentID will be accepted for delete request.
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->delete($version, $shipper_number, $document_id, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->delete: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Paperless\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Paperless\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$deprecated_version = "deprecated_version_example"; // string | Version of API  Valid values: - v1
$shipper_number = "shipper_number_example"; // string | Your Shipper Number
$document_id = "document_id_example"; // string | DocumentId representing uploaded document to Forms History. Only one DocumentID will be accepted for delete request.
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->deprecatedDelete($deprecated_version, $shipper_number, $document_id, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedDelete: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Paperless\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Paperless\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Paperless\Paperless\PAPERLESSDOCUMENTRequestWrapper(); // \UPS\Paperless\Paperless\PAPERLESSDOCUMENTRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$shipper_number = "shipper_number_example"; // string | Shipper Number
$deprecated_version = "deprecated_version_example"; // string | Version of API  Valid values: - v1
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->deprecatedPushToImageRepository($body, $shipper_number, $deprecated_version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedPushToImageRepository: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Paperless\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Paperless\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Paperless\Paperless\PAPERLESSDOCUMENTUploadRequestWrapper(); // \UPS\Paperless\Paperless\PAPERLESSDOCUMENTUploadRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$shipper_number = "shipper_number_example"; // string | Shipper Number
$deprecated_version = "deprecated_version_example"; // string | Version of API  Valid values: - v1
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->deprecatedUpload($body, $shipper_number, $deprecated_version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedUpload: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Paperless\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Paperless\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Paperless\Paperless\PAPERLESSDOCUMENTRequestWrapper(); // \UPS\Paperless\Paperless\PAPERLESSDOCUMENTRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$shipper_number = "shipper_number_example"; // string | Shipper Number
$version = "version_example"; // string | Version of API  Valid values: - v2
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pushToImageRepository($body, $shipper_number, $version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pushToImageRepository: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Paperless\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Paperless\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Paperless\Paperless\PAPERLESSDOCUMENTUploadRequestWrapper(); // \UPS\Paperless\Paperless\PAPERLESSDOCUMENTUploadRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$shipper_number = "shipper_number_example"; // string | Shipper Number
$version = "version_example"; // string | Version of API  Valid values: - v2
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->upload($body, $shipper_number, $version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->upload: ', $e->getMessage(), PHP_EOL;
}
?>
```

## Documentation for API Endpoints

All URIs are relative to *https://wwwcie.ups.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**delete**](docs/Api/DefaultApi.md#delete) | **DELETE** /paperlessdocuments/{version}/DocumentId/ShipperNumber | Delete Paperless Document
*DefaultApi* | [**deprecatedDelete**](docs/Api/DefaultApi.md#deprecateddelete) | **DELETE** /paperlessdocuments/{deprecatedVersion}/DocumentId/ShipperNumber | Delete Paperless Document
*DefaultApi* | [**deprecatedPushToImageRepository**](docs/Api/DefaultApi.md#deprecatedpushtoimagerepository) | **POST** /paperlessdocuments/{deprecatedVersion}/image | Paperless Document Push Image
*DefaultApi* | [**deprecatedUpload**](docs/Api/DefaultApi.md#deprecatedupload) | **POST** /paperlessdocuments/{deprecatedVersion}/upload | Upload Paperless Document
*DefaultApi* | [**pushToImageRepository**](docs/Api/DefaultApi.md#pushtoimagerepository) | **POST** /paperlessdocuments/{version}/image | Paperless Document Push Image
*DefaultApi* | [**upload**](docs/Api/DefaultApi.md#upload) | **POST** /paperlessdocuments/{version}/upload | Upload Paperless Document

## Documentation For Models

 - [CommonErrorResponse](docs/Model/CommonErrorResponse.md)
 - [DeleteRequest](docs/Model/DeleteRequest.md)
 - [DeleteRequestRequest](docs/Model/DeleteRequestRequest.md)
 - [DeleteResponse](docs/Model/DeleteResponse.md)
 - [DeleteResponseResponse](docs/Model/DeleteResponseResponse.md)
 - [ErrorMessage](docs/Model/ErrorMessage.md)
 - [ErrorResponse](docs/Model/ErrorResponse.md)
 - [PAPERLESSDOCUMENTDeleteRequestWrapper](docs/Model/PAPERLESSDOCUMENTDeleteRequestWrapper.md)
 - [PAPERLESSDOCUMENTDeleteResponseWrapper](docs/Model/PAPERLESSDOCUMENTDeleteResponseWrapper.md)
 - [PAPERLESSDOCUMENTRequestWrapper](docs/Model/PAPERLESSDOCUMENTRequestWrapper.md)
 - [PAPERLESSDOCUMENTResponseWrapper](docs/Model/PAPERLESSDOCUMENTResponseWrapper.md)
 - [PAPERLESSDOCUMENTUploadRequestWrapper](docs/Model/PAPERLESSDOCUMENTUploadRequestWrapper.md)
 - [PAPERLESSDOCUMENTUploadResponseWrapper](docs/Model/PAPERLESSDOCUMENTUploadResponseWrapper.md)
 - [PushToImageRepositoryRequest](docs/Model/PushToImageRepositoryRequest.md)
 - [PushToImageRepositoryRequestFormsHistoryDocumentID](docs/Model/PushToImageRepositoryRequestFormsHistoryDocumentID.md)
 - [PushToImageRepositoryRequestRequest](docs/Model/PushToImageRepositoryRequestRequest.md)
 - [PushToImageRepositoryResponse](docs/Model/PushToImageRepositoryResponse.md)
 - [PushToImageRepositoryResponseResponse](docs/Model/PushToImageRepositoryResponseResponse.md)
 - [RequestTransactionReference](docs/Model/RequestTransactionReference.md)
 - [ResponseAlert](docs/Model/ResponseAlert.md)
 - [ResponseResponseStatus](docs/Model/ResponseResponseStatus.md)
 - [ResponseTransactionReference](docs/Model/ResponseTransactionReference.md)
 - [UploadRequest](docs/Model/UploadRequest.md)
 - [UploadRequestRequest](docs/Model/UploadRequestRequest.md)
 - [UploadRequestUserCreatedForm](docs/Model/UploadRequestUserCreatedForm.md)
 - [UploadResponse](docs/Model/UploadResponse.md)
 - [UploadResponseFormsHistoryDocumentID](docs/Model/UploadResponseFormsHistoryDocumentID.md)
 - [UploadResponseResponse](docs/Model/UploadResponseResponse.md)

## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 


## Author



