<?php
/**
 * FacilityTimeDayOfWeek
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Pickup
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Pickup\Pickup;

use \ArrayAccess;
use \UPS\Pickup\ObjectSerializer;

/**
 * FacilityTimeDayOfWeek Class Doc Comment
 *
 * @category Class
 * @description Facility Hours of Operation Container
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class FacilityTimeDayOfWeek implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'FacilityTime_DayOfWeek';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'day' => 'string',
        'earliest_drop_offor_pickup' => 'string',
        'latest_drop_offor_pickup' => 'string',
        'open_hours' => 'string',
        'close_hours' => 'string',
        'prep_time' => 'string',
        'last_drop' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'day' => null,
        'earliest_drop_offor_pickup' => null,
        'latest_drop_offor_pickup' => null,
        'open_hours' => null,
        'close_hours' => null,
        'prep_time' => null,
        'last_drop' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'day' => 'Day',
        'earliest_drop_offor_pickup' => 'EarliestDropOfforPickup',
        'latest_drop_offor_pickup' => 'LatestDropOfforPickup',
        'open_hours' => 'OpenHours',
        'close_hours' => 'CloseHours',
        'prep_time' => 'PrepTime',
        'last_drop' => 'LastDrop'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'day' => 'setDay',
        'earliest_drop_offor_pickup' => 'setEarliestDropOfforPickup',
        'latest_drop_offor_pickup' => 'setLatestDropOfforPickup',
        'open_hours' => 'setOpenHours',
        'close_hours' => 'setCloseHours',
        'prep_time' => 'setPrepTime',
        'last_drop' => 'setLastDrop'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'day' => 'getDay',
        'earliest_drop_offor_pickup' => 'getEarliestDropOfforPickup',
        'latest_drop_offor_pickup' => 'getLatestDropOfforPickup',
        'open_hours' => 'getOpenHours',
        'close_hours' => 'getCloseHours',
        'prep_time' => 'getPrepTime',
        'last_drop' => 'getLastDrop'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['day'] = isset($data['day']) ? $data['day'] : null;
        $this->container['earliest_drop_offor_pickup'] = isset($data['earliest_drop_offor_pickup']) ? $data['earliest_drop_offor_pickup'] : null;
        $this->container['latest_drop_offor_pickup'] = isset($data['latest_drop_offor_pickup']) ? $data['latest_drop_offor_pickup'] : null;
        $this->container['open_hours'] = isset($data['open_hours']) ? $data['open_hours'] : null;
        $this->container['close_hours'] = isset($data['close_hours']) ? $data['close_hours'] : null;
        $this->container['prep_time'] = isset($data['prep_time']) ? $data['prep_time'] : null;
        $this->container['last_drop'] = isset($data['last_drop']) ? $data['last_drop'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['day'] === null) {
            $invalidProperties[] = "'day' can't be null";
        }
        if ($this->container['open_hours'] === null) {
            $invalidProperties[] = "'open_hours' can't be null";
        }
        if ($this->container['close_hours'] === null) {
            $invalidProperties[] = "'close_hours' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets day
     *
     * @return string
     */
    public function getDay()
    {
        return $this->container['day'];
    }

    /**
     * Sets day
     *
     * @param string $day Day of the week. Mon-Sun
     *
     * @return $this
     */
    public function setDay($day)
    {
        $this->container['day'] = $day;

        return $this;
    }

    /**
     * Gets earliest_drop_offor_pickup
     *
     * @return string
     */
    public function getEarliestDropOfforPickup()
    {
        return $this->container['earliest_drop_offor_pickup'];
    }

    /**
     * Sets earliest_drop_offor_pickup
     *
     * @param string $earliest_drop_offor_pickup Earliest time that a customer can drop-off a package.
     *
     * @return $this
     */
    public function setEarliestDropOfforPickup($earliest_drop_offor_pickup)
    {
        $this->container['earliest_drop_offor_pickup'] = $earliest_drop_offor_pickup;

        return $this;
    }

    /**
     * Gets latest_drop_offor_pickup
     *
     * @return string
     */
    public function getLatestDropOfforPickup()
    {
        return $this->container['latest_drop_offor_pickup'];
    }

    /**
     * Sets latest_drop_offor_pickup
     *
     * @param string $latest_drop_offor_pickup Latest time that a customer can drop-off a package.
     *
     * @return $this
     */
    public function setLatestDropOfforPickup($latest_drop_offor_pickup)
    {
        $this->container['latest_drop_offor_pickup'] = $latest_drop_offor_pickup;

        return $this;
    }

    /**
     * Gets open_hours
     *
     * @return string
     */
    public function getOpenHours()
    {
        return $this->container['open_hours'];
    }

    /**
     * Sets open_hours
     *
     * @param string $open_hours Facility Open Hours. The latest local open time. Format: HHmm - Hour: 0-23 - Minute: 0-59
     *
     * @return $this
     */
    public function setOpenHours($open_hours)
    {
        $this->container['open_hours'] = $open_hours;

        return $this;
    }

    /**
     * Gets close_hours
     *
     * @return string
     */
    public function getCloseHours()
    {
        return $this->container['close_hours'];
    }

    /**
     * Sets close_hours
     *
     * @param string $close_hours Facility Close Hours. The latest local close time. Format: HHmm - Hour: 0-23 - Minute: 0-59
     *
     * @return $this
     */
    public function setCloseHours($close_hours)
    {
        $this->container['close_hours'] = $close_hours;

        return $this;
    }

    /**
     * Gets prep_time
     *
     * @return string
     */
    public function getPrepTime()
    {
        return $this->container['prep_time'];
    }

    /**
     * Sets prep_time
     *
     * @param string $prep_time Time required by the facility to prepare your shipment for movement
     *
     * @return $this
     */
    public function setPrepTime($prep_time)
    {
        $this->container['prep_time'] = $prep_time;

        return $this;
    }

    /**
     * Gets last_drop
     *
     * @return string
     */
    public function getLastDrop()
    {
        return $this->container['last_drop'];
    }

    /**
     * Sets last_drop
     *
     * @param string $last_drop Cut-off time for drop off that day.
     *
     * @return $this
     */
    public function setLastDrop($last_drop)
    {
        $this->container['last_drop'] = $last_drop;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
