<?php
/**
 * PickupCreationRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Pickup
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Pickup\Pickup;

use \ArrayAccess;
use \UPS\Pickup\ObjectSerializer;

/**
 * PickupCreationRequest Class Doc Comment
 *
 * @category Class
 * @description This request is for scheduling an on-call pickup
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PickupCreationRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'PickupCreationRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'request' => '\UPS\Pickup\Pickup\PickupCreationRequestRequest',
        'rate_pickup_indicator' => 'string',
        'rate_chart_type' => 'string',
        'tax_information_indicator' => 'string',
        'user_level_discount_indicator' => 'string',
        'shipper' => '\UPS\Pickup\Pickup\PickupCreationRequestShipper',
        'pickup_date_info' => '\UPS\Pickup\Pickup\PickupCreationRequestPickupDateInfo',
        'pickup_address' => '\UPS\Pickup\Pickup\PickupCreationRequestPickupAddress',
        'alternate_address_indicator' => 'string',
        'pickup_piece' => '\UPS\Pickup\Pickup\PickupCreationRequestPickupPiece[]',
        'total_weight' => '\UPS\Pickup\Pickup\PickupCreationRequestTotalWeight',
        'overweight_indicator' => 'string',
        'tracking_data' => '\UPS\Pickup\Pickup\PickupCreationRequestTrackingData[]',
        'tracking_data_with_reference_number' => '\UPS\Pickup\Pickup\PickupCreationRequestTrackingDataWithReferenceNumber',
        'payment_method' => 'string',
        'special_instruction' => 'string',
        'reference_number' => 'string',
        'freight_options' => '\UPS\Pickup\Pickup\PickupCreationRequestFreightOptions',
        'service_category' => 'string',
        'cash_type' => 'string',
        'shipping_labels_available' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'request' => null,
        'rate_pickup_indicator' => null,
        'rate_chart_type' => null,
        'tax_information_indicator' => null,
        'user_level_discount_indicator' => null,
        'shipper' => null,
        'pickup_date_info' => null,
        'pickup_address' => null,
        'alternate_address_indicator' => null,
        'pickup_piece' => null,
        'total_weight' => null,
        'overweight_indicator' => null,
        'tracking_data' => null,
        'tracking_data_with_reference_number' => null,
        'payment_method' => null,
        'special_instruction' => null,
        'reference_number' => null,
        'freight_options' => null,
        'service_category' => null,
        'cash_type' => null,
        'shipping_labels_available' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'request' => 'Request',
        'rate_pickup_indicator' => 'RatePickupIndicator',
        'rate_chart_type' => 'RateChartType',
        'tax_information_indicator' => 'TaxInformationIndicator',
        'user_level_discount_indicator' => 'UserLevelDiscountIndicator',
        'shipper' => 'Shipper',
        'pickup_date_info' => 'PickupDateInfo',
        'pickup_address' => 'PickupAddress',
        'alternate_address_indicator' => 'AlternateAddressIndicator',
        'pickup_piece' => 'PickupPiece',
        'total_weight' => 'TotalWeight',
        'overweight_indicator' => 'OverweightIndicator',
        'tracking_data' => 'TrackingData',
        'tracking_data_with_reference_number' => 'TrackingDataWithReferenceNumber',
        'payment_method' => 'PaymentMethod',
        'special_instruction' => 'SpecialInstruction',
        'reference_number' => 'ReferenceNumber',
        'freight_options' => 'FreightOptions',
        'service_category' => 'ServiceCategory',
        'cash_type' => 'CashType',
        'shipping_labels_available' => 'ShippingLabelsAvailable'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'request' => 'setRequest',
        'rate_pickup_indicator' => 'setRatePickupIndicator',
        'rate_chart_type' => 'setRateChartType',
        'tax_information_indicator' => 'setTaxInformationIndicator',
        'user_level_discount_indicator' => 'setUserLevelDiscountIndicator',
        'shipper' => 'setShipper',
        'pickup_date_info' => 'setPickupDateInfo',
        'pickup_address' => 'setPickupAddress',
        'alternate_address_indicator' => 'setAlternateAddressIndicator',
        'pickup_piece' => 'setPickupPiece',
        'total_weight' => 'setTotalWeight',
        'overweight_indicator' => 'setOverweightIndicator',
        'tracking_data' => 'setTrackingData',
        'tracking_data_with_reference_number' => 'setTrackingDataWithReferenceNumber',
        'payment_method' => 'setPaymentMethod',
        'special_instruction' => 'setSpecialInstruction',
        'reference_number' => 'setReferenceNumber',
        'freight_options' => 'setFreightOptions',
        'service_category' => 'setServiceCategory',
        'cash_type' => 'setCashType',
        'shipping_labels_available' => 'setShippingLabelsAvailable'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'request' => 'getRequest',
        'rate_pickup_indicator' => 'getRatePickupIndicator',
        'rate_chart_type' => 'getRateChartType',
        'tax_information_indicator' => 'getTaxInformationIndicator',
        'user_level_discount_indicator' => 'getUserLevelDiscountIndicator',
        'shipper' => 'getShipper',
        'pickup_date_info' => 'getPickupDateInfo',
        'pickup_address' => 'getPickupAddress',
        'alternate_address_indicator' => 'getAlternateAddressIndicator',
        'pickup_piece' => 'getPickupPiece',
        'total_weight' => 'getTotalWeight',
        'overweight_indicator' => 'getOverweightIndicator',
        'tracking_data' => 'getTrackingData',
        'tracking_data_with_reference_number' => 'getTrackingDataWithReferenceNumber',
        'payment_method' => 'getPaymentMethod',
        'special_instruction' => 'getSpecialInstruction',
        'reference_number' => 'getReferenceNumber',
        'freight_options' => 'getFreightOptions',
        'service_category' => 'getServiceCategory',
        'cash_type' => 'getCashType',
        'shipping_labels_available' => 'getShippingLabelsAvailable'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['request'] = isset($data['request']) ? $data['request'] : null;
        $this->container['rate_pickup_indicator'] = isset($data['rate_pickup_indicator']) ? $data['rate_pickup_indicator'] : null;
        $this->container['rate_chart_type'] = isset($data['rate_chart_type']) ? $data['rate_chart_type'] : null;
        $this->container['tax_information_indicator'] = isset($data['tax_information_indicator']) ? $data['tax_information_indicator'] : null;
        $this->container['user_level_discount_indicator'] = isset($data['user_level_discount_indicator']) ? $data['user_level_discount_indicator'] : null;
        $this->container['shipper'] = isset($data['shipper']) ? $data['shipper'] : null;
        $this->container['pickup_date_info'] = isset($data['pickup_date_info']) ? $data['pickup_date_info'] : null;
        $this->container['pickup_address'] = isset($data['pickup_address']) ? $data['pickup_address'] : null;
        $this->container['alternate_address_indicator'] = isset($data['alternate_address_indicator']) ? $data['alternate_address_indicator'] : null;
        $this->container['pickup_piece'] = isset($data['pickup_piece']) ? $data['pickup_piece'] : null;
        $this->container['total_weight'] = isset($data['total_weight']) ? $data['total_weight'] : null;
        $this->container['overweight_indicator'] = isset($data['overweight_indicator']) ? $data['overweight_indicator'] : null;
        $this->container['tracking_data'] = isset($data['tracking_data']) ? $data['tracking_data'] : null;
        $this->container['tracking_data_with_reference_number'] = isset($data['tracking_data_with_reference_number']) ? $data['tracking_data_with_reference_number'] : null;
        $this->container['payment_method'] = isset($data['payment_method']) ? $data['payment_method'] : null;
        $this->container['special_instruction'] = isset($data['special_instruction']) ? $data['special_instruction'] : null;
        $this->container['reference_number'] = isset($data['reference_number']) ? $data['reference_number'] : null;
        $this->container['freight_options'] = isset($data['freight_options']) ? $data['freight_options'] : null;
        $this->container['service_category'] = isset($data['service_category']) ? $data['service_category'] : null;
        $this->container['cash_type'] = isset($data['cash_type']) ? $data['cash_type'] : null;
        $this->container['shipping_labels_available'] = isset($data['shipping_labels_available']) ? $data['shipping_labels_available'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['request'] === null) {
            $invalidProperties[] = "'request' can't be null";
        }
        if ($this->container['rate_pickup_indicator'] === null) {
            $invalidProperties[] = "'rate_pickup_indicator' can't be null";
        }
        if ($this->container['pickup_date_info'] === null) {
            $invalidProperties[] = "'pickup_date_info' can't be null";
        }
        if ($this->container['pickup_address'] === null) {
            $invalidProperties[] = "'pickup_address' can't be null";
        }
        if ($this->container['alternate_address_indicator'] === null) {
            $invalidProperties[] = "'alternate_address_indicator' can't be null";
        }
        if ($this->container['pickup_piece'] === null) {
            $invalidProperties[] = "'pickup_piece' can't be null";
        }
        if ($this->container['payment_method'] === null) {
            $invalidProperties[] = "'payment_method' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets request
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestRequest
     */
    public function getRequest()
    {
        return $this->container['request'];
    }

    /**
     * Sets request
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestRequest $request request
     *
     * @return $this
     */
    public function setRequest($request)
    {
        $this->container['request'] = $request;

        return $this;
    }

    /**
     * Gets rate_pickup_indicator
     *
     * @return string
     */
    public function getRatePickupIndicator()
    {
        return $this->container['rate_pickup_indicator'];
    }

    /**
     * Sets rate_pickup_indicator
     *
     * @param string $rate_pickup_indicator Indicates whether to rate the on-callpickup or not.  Valid values: Y = Rate this pickup N = Do not rate this pickup (default)
     *
     * @return $this
     */
    public function setRatePickupIndicator($rate_pickup_indicator)
    {
        $this->container['rate_pickup_indicator'] = $rate_pickup_indicator;

        return $this;
    }

    /**
     * Gets rate_chart_type
     *
     * @return string
     */
    public function getRateChartType()
    {
        return $this->container['rate_chart_type'];
    }

    /**
     * Sets rate_chart_type
     *
     * @param string $rate_chart_type Rate Type with which pickup is rated. Possible RateChart values for different regions will be:  US 48 origin: - 1 – Daily Rates - 3 – Standard List Rates - 4 – Retail Rates.   Alaska/Hawaii origin: - 1 – Daily Rates - 3 – Standard List Rates - 4 – Retail Rates.  All Other origins: - 1 – Rates - 5 - Regional Rates - 6 - General List Rates.  3 and 4 do not apply
     *
     * @return $this
     */
    public function setRateChartType($rate_chart_type)
    {
        $this->container['rate_chart_type'] = $rate_chart_type;

        return $this;
    }

    /**
     * Gets tax_information_indicator
     *
     * @return string
     */
    public function getTaxInformationIndicator()
    {
        return $this->container['tax_information_indicator'];
    }

    /**
     * Sets tax_information_indicator
     *
     * @param string $tax_information_indicator Indicates whether to return detailed taxes for the on-callpickups.  Valid values: Y = Rate this pickup with taxes N = Do not rate this pickup with taxes (default)
     *
     * @return $this
     */
    public function setTaxInformationIndicator($tax_information_indicator)
    {
        $this->container['tax_information_indicator'] = $tax_information_indicator;

        return $this;
    }

    /**
     * Gets user_level_discount_indicator
     *
     * @return string
     */
    public function getUserLevelDiscountIndicator()
    {
        return $this->container['user_level_discount_indicator'];
    }

    /**
     * Sets user_level_discount_indicator
     *
     * @param string $user_level_discount_indicator Indicates whether to return user level promo discount for the on-callpickups.  Valid values: Y = Rate this pickup with user level promo discount N = Do not rate this pickup with user level promo discount(default)
     *
     * @return $this
     */
    public function setUserLevelDiscountIndicator($user_level_discount_indicator)
    {
        $this->container['user_level_discount_indicator'] = $user_level_discount_indicator;

        return $this;
    }

    /**
     * Gets shipper
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestShipper
     */
    public function getShipper()
    {
        return $this->container['shipper'];
    }

    /**
     * Sets shipper
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestShipper $shipper shipper
     *
     * @return $this
     */
    public function setShipper($shipper)
    {
        $this->container['shipper'] = $shipper;

        return $this;
    }

    /**
     * Gets pickup_date_info
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestPickupDateInfo
     */
    public function getPickupDateInfo()
    {
        return $this->container['pickup_date_info'];
    }

    /**
     * Sets pickup_date_info
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestPickupDateInfo $pickup_date_info pickup_date_info
     *
     * @return $this
     */
    public function setPickupDateInfo($pickup_date_info)
    {
        $this->container['pickup_date_info'] = $pickup_date_info;

        return $this;
    }

    /**
     * Gets pickup_address
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestPickupAddress
     */
    public function getPickupAddress()
    {
        return $this->container['pickup_address'];
    }

    /**
     * Sets pickup_address
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestPickupAddress $pickup_address pickup_address
     *
     * @return $this
     */
    public function setPickupAddress($pickup_address)
    {
        $this->container['pickup_address'] = $pickup_address;

        return $this;
    }

    /**
     * Gets alternate_address_indicator
     *
     * @return string
     */
    public function getAlternateAddressIndicator()
    {
        return $this->container['alternate_address_indicator'];
    }

    /**
     * Sets alternate_address_indicator
     *
     * @param string $alternate_address_indicator Indicates if pickup address is a different address than that specified in a customer's profile.  Valid values: Y = Alternate address N = Original pickup address (default)
     *
     * @return $this
     */
    public function setAlternateAddressIndicator($alternate_address_indicator)
    {
        $this->container['alternate_address_indicator'] = $alternate_address_indicator;

        return $this;
    }

    /**
     * Gets pickup_piece
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestPickupPiece[]
     */
    public function getPickupPiece()
    {
        return $this->container['pickup_piece'];
    }

    /**
     * Sets pickup_piece
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestPickupPiece[] $pickup_piece pickup_piece
     *
     * @return $this
     */
    public function setPickupPiece($pickup_piece)
    {
        $this->container['pickup_piece'] = $pickup_piece;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestTotalWeight
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestTotalWeight $total_weight total_weight
     *
     * @return $this
     */
    public function setTotalWeight($total_weight)
    {
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets overweight_indicator
     *
     * @return string
     */
    public function getOverweightIndicator()
    {
        return $this->container['overweight_indicator'];
    }

    /**
     * Sets overweight_indicator
     *
     * @param string $overweight_indicator Indicates if at least any package is over 70 lbs or 32 kgs.  Valid values:  Y = Over weight  N = Not over weight (default)  Not required for WWEF service.
     *
     * @return $this
     */
    public function setOverweightIndicator($overweight_indicator)
    {
        $this->container['overweight_indicator'] = $overweight_indicator;

        return $this;
    }

    /**
     * Gets tracking_data
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestTrackingData[]
     */
    public function getTrackingData()
    {
        return $this->container['tracking_data'];
    }

    /**
     * Sets tracking_data
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestTrackingData[] $tracking_data tracking_data
     *
     * @return $this
     */
    public function setTrackingData($tracking_data)
    {
        $this->container['tracking_data'] = $tracking_data;

        return $this;
    }

    /**
     * Gets tracking_data_with_reference_number
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestTrackingDataWithReferenceNumber
     */
    public function getTrackingDataWithReferenceNumber()
    {
        return $this->container['tracking_data_with_reference_number'];
    }

    /**
     * Sets tracking_data_with_reference_number
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestTrackingDataWithReferenceNumber $tracking_data_with_reference_number tracking_data_with_reference_number
     *
     * @return $this
     */
    public function setTrackingDataWithReferenceNumber($tracking_data_with_reference_number)
    {
        $this->container['tracking_data_with_reference_number'] = $tracking_data_with_reference_number;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param string $payment_method The payment method to pay for this on call pickup. 00 = No payment needed 01 = Pay by shipper account 03 = Pay by charge card 04 = Pay by 1Z tracking number 05 = Pay by check or money order 06 = Cash(applicable only for these countries - BE,FR,DE,IT,MX,NL,PL,ES,GB,CZ,HU,FI,NO) 07=Pay by PayPal Refer to Appendix # for valid payment methods for CZ, HU, FI and NO   For countries and (or) zip codes where pickup is free of charge, please submit 00, means no payment needed as payment method.  - If 01 is the payment method, then ShipperAccountNumber and ShipperAccount CountryCode must be provided. - If 03 is selected, then CreditCard information should be provided. - If 04 is selected, then the shipper agreed to pay for the pickup packages. - If 05 is selected, then the shipper will pay for the pickup packages with a check or money order.
     *
     * @return $this
     */
    public function setPaymentMethod($payment_method)
    {
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets special_instruction
     *
     * @return string
     */
    public function getSpecialInstruction()
    {
        return $this->container['special_instruction'];
    }

    /**
     * Sets special_instruction
     *
     * @param string $special_instruction Special handling instruction from the customer
     *
     * @return $this
     */
    public function setSpecialInstruction($special_instruction)
    {
        $this->container['special_instruction'] = $special_instruction;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string $reference_number Information entered by a customer for Privileged reference
     *
     * @return $this
     */
    public function setReferenceNumber($reference_number)
    {
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets freight_options
     *
     * @return \UPS\Pickup\Pickup\PickupCreationRequestFreightOptions
     */
    public function getFreightOptions()
    {
        return $this->container['freight_options'];
    }

    /**
     * Sets freight_options
     *
     * @param \UPS\Pickup\Pickup\PickupCreationRequestFreightOptions $freight_options freight_options
     *
     * @return $this
     */
    public function setFreightOptions($freight_options)
    {
        $this->container['freight_options'] = $freight_options;

        return $this;
    }

    /**
     * Gets service_category
     *
     * @return string
     */
    public function getServiceCategory()
    {
        return $this->container['service_category'];
    }

    /**
     * Sets service_category
     *
     * @param string $service_category Service Category. Applicable to the following countries: BE, FR, DE, IT, MX, NL, PL, ES, GB  Valid values:  01 - domestic (default) 02 - international 03 - transborder
     *
     * @return $this
     */
    public function setServiceCategory($service_category)
    {
        $this->container['service_category'] = $service_category;

        return $this;
    }

    /**
     * Gets cash_type
     *
     * @return string
     */
    public function getCashType()
    {
        return $this->container['cash_type'];
    }

    /**
     * Sets cash_type
     *
     * @param string $cash_type Describes the type of cash funds that the driver will collect. Applicable to the following countries: BE,FR,DE,IT,MX,NL,PL,ES,GB Valid values:  01 - Pickup only (default) 02 - Transportation only 03 - Pickup and Transportation
     *
     * @return $this
     */
    public function setCashType($cash_type)
    {
        $this->container['cash_type'] = $cash_type;

        return $this;
    }

    /**
     * Gets shipping_labels_available
     *
     * @return string
     */
    public function getShippingLabelsAvailable()
    {
        return $this->container['shipping_labels_available'];
    }

    /**
     * Sets shipping_labels_available
     *
     * @param string $shipping_labels_available This element should be set to \"Y\" in the request to indicate that user has pre-printed shipping labels for all the packages, otherwise this will be treated as false.
     *
     * @return $this
     */
    public function setShippingLabelsAvailable($shipping_labels_available)
    {
        $this->container['shipping_labels_available'] = $shipping_labels_available;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
