<?php
/**
 * InternationalFormsUPSPremiumCareForm
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * InternationalFormsUPSPremiumCareForm Class Doc Comment
 *
 * @category Class
 * @description UPS Premium Care Form is required if UPS Premium Care Indicator is present on a package.  Valid only for Canada to Canada movements.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class InternationalFormsUPSPremiumCareForm implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'InternationalForms_UPSPremiumCareForm';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'shipment_date' => 'string',
        'page_size' => 'string',
        'print_type' => 'string',
        'num_of_copies' => 'string',
        'language_for_ups_premium_care' => '\UPS\Shipping\Shipping\UPSPremiumCareFormLanguageForUPSPremiumCare'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'shipment_date' => null,
        'page_size' => null,
        'print_type' => null,
        'num_of_copies' => null,
        'language_for_ups_premium_care' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipment_date' => 'ShipmentDate',
        'page_size' => 'PageSize',
        'print_type' => 'PrintType',
        'num_of_copies' => 'NumOfCopies',
        'language_for_ups_premium_care' => 'LanguageForUPSPremiumCare'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipment_date' => 'setShipmentDate',
        'page_size' => 'setPageSize',
        'print_type' => 'setPrintType',
        'num_of_copies' => 'setNumOfCopies',
        'language_for_ups_premium_care' => 'setLanguageForUpsPremiumCare'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipment_date' => 'getShipmentDate',
        'page_size' => 'getPageSize',
        'print_type' => 'getPrintType',
        'num_of_copies' => 'getNumOfCopies',
        'language_for_ups_premium_care' => 'getLanguageForUpsPremiumCare'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shipment_date'] = isset($data['shipment_date']) ? $data['shipment_date'] : null;
        $this->container['page_size'] = isset($data['page_size']) ? $data['page_size'] : null;
        $this->container['print_type'] = isset($data['print_type']) ? $data['print_type'] : null;
        $this->container['num_of_copies'] = isset($data['num_of_copies']) ? $data['num_of_copies'] : null;
        $this->container['language_for_ups_premium_care'] = isset($data['language_for_ups_premium_care']) ? $data['language_for_ups_premium_care'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['shipment_date'] === null) {
            $invalidProperties[] = "'shipment_date' can't be null";
        }
        if ($this->container['page_size'] === null) {
            $invalidProperties[] = "'page_size' can't be null";
        }
        if ($this->container['print_type'] === null) {
            $invalidProperties[] = "'print_type' can't be null";
        }
        if ($this->container['num_of_copies'] === null) {
            $invalidProperties[] = "'num_of_copies' can't be null";
        }
        if ($this->container['language_for_ups_premium_care'] === null) {
            $invalidProperties[] = "'language_for_ups_premium_care' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shipment_date
     *
     * @return string
     */
    public function getShipmentDate()
    {
        return $this->container['shipment_date'];
    }

    /**
     * Sets shipment_date
     *
     * @param string $shipment_date Shipment Date associated with UPS Premium Care Shipment.   Valid Format: yyyyMMdd
     *
     * @return $this
     */
    public function setShipmentDate($shipment_date)
    {
        $this->container['shipment_date'] = $shipment_date;

        return $this;
    }

    /**
     * Gets page_size
     *
     * @return string
     */
    public function getPageSize()
    {
        return $this->container['page_size'];
    }

    /**
     * Sets page_size
     *
     * @param string $page_size Size of UPS Premium Care Form.  Valid values:  01 = A4 Size 02 = Letter Size
     *
     * @return $this
     */
    public function setPageSize($page_size)
    {
        $this->container['page_size'] = $page_size;

        return $this;
    }

    /**
     * Gets print_type
     *
     * @return string
     */
    public function getPrintType()
    {
        return $this->container['print_type'];
    }

    /**
     * Sets print_type
     *
     * @param string $print_type Format of UPS Premium Care Form.  Valid values:  01 = PNG 02 = PDF
     *
     * @return $this
     */
    public function setPrintType($print_type)
    {
        $this->container['print_type'] = $print_type;

        return $this;
    }

    /**
     * Gets num_of_copies
     *
     * @return string
     */
    public function getNumOfCopies()
    {
        return $this->container['num_of_copies'];
    }

    /**
     * Sets num_of_copies
     *
     * @param string $num_of_copies Number of Copies of UPS Premium Care Form.  Valid value is 02.
     *
     * @return $this
     */
    public function setNumOfCopies($num_of_copies)
    {
        $this->container['num_of_copies'] = $num_of_copies;

        return $this;
    }

    /**
     * Gets language_for_ups_premium_care
     *
     * @return \UPS\Shipping\Shipping\UPSPremiumCareFormLanguageForUPSPremiumCare
     */
    public function getLanguageForUpsPremiumCare()
    {
        return $this->container['language_for_ups_premium_care'];
    }

    /**
     * Sets language_for_ups_premium_care
     *
     * @param \UPS\Shipping\Shipping\UPSPremiumCareFormLanguageForUPSPremiumCare $language_for_ups_premium_care language_for_ups_premium_care
     *
     * @return $this
     */
    public function setLanguageForUpsPremiumCare($language_for_ups_premium_care)
    {
        $this->container['language_for_ups_premium_care'] = $language_for_ups_premium_care;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
