<?php
/**
 * Services
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Time In Transit
 *
 * The Time In Transit API provides estimated delivery times for various UPS shipping services, between specified locations.  Key Business Values: - **Enhanced Customer Experience**: Allows businesses provide accurate delivery estimates to their customers, enhancing customer service. - **Operational Efficiency**: Helps in logistics planning by providing transit times for different UPS services.
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\TimeInTransit\TimeInTransit;

use \ArrayAccess;
use \UPS\TimeInTransit\ObjectSerializer;

/**
 * Services Class Doc Comment
 *
 * @category Class
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Services implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'services';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'service_level' => 'string',
        'service_level_description' => 'string',
        'ship_date' => 'string',
        'delivery_date' => 'string',
        'commit_time' => 'string',
        'delivery_time' => 'string',
        'delivery_day_of_week' => 'string',
        'next_day_pickup_indicator' => 'string',
        'saturday_pickup_indicator' => 'string',
        'saturday_delivery_date' => 'string',
        'saturday_delivery_time' => 'string',
        'service_remarks_text' => 'string',
        'guarantee_indicator' => 'string',
        'total_transit_days' => 'int',
        'business_transit_days' => 'int',
        'rest_days_count' => 'int',
        'holiday_count' => 'int',
        'delay_count' => 'int',
        'pickup_date' => 'string',
        'pickup_time' => 'string',
        'cstccutoff_time' => 'string',
        'poddate' => 'string',
        'poddays' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'service_level' => null,
        'service_level_description' => null,
        'ship_date' => null,
        'delivery_date' => null,
        'commit_time' => null,
        'delivery_time' => null,
        'delivery_day_of_week' => null,
        'next_day_pickup_indicator' => null,
        'saturday_pickup_indicator' => null,
        'saturday_delivery_date' => null,
        'saturday_delivery_time' => null,
        'service_remarks_text' => null,
        'guarantee_indicator' => null,
        'total_transit_days' => null,
        'business_transit_days' => null,
        'rest_days_count' => null,
        'holiday_count' => null,
        'delay_count' => null,
        'pickup_date' => null,
        'pickup_time' => null,
        'cstccutoff_time' => null,
        'poddate' => null,
        'poddays' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'service_level' => 'serviceLevel',
        'service_level_description' => 'serviceLevelDescription',
        'ship_date' => 'shipDate',
        'delivery_date' => 'deliveryDate',
        'commit_time' => 'commitTime',
        'delivery_time' => 'deliveryTime',
        'delivery_day_of_week' => 'deliveryDayOfWeek',
        'next_day_pickup_indicator' => 'nextDayPickupIndicator',
        'saturday_pickup_indicator' => 'saturdayPickupIndicator',
        'saturday_delivery_date' => 'saturdayDeliveryDate',
        'saturday_delivery_time' => 'saturdayDeliveryTime',
        'service_remarks_text' => 'serviceRemarksText',
        'guarantee_indicator' => 'guaranteeIndicator',
        'total_transit_days' => 'totalTransitDays',
        'business_transit_days' => 'businessTransitDays',
        'rest_days_count' => 'restDaysCount',
        'holiday_count' => 'holidayCount',
        'delay_count' => 'delayCount',
        'pickup_date' => 'pickupDate',
        'pickup_time' => 'pickupTime',
        'cstccutoff_time' => 'cstccutoffTime',
        'poddate' => 'poddate',
        'poddays' => 'poddays'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'service_level' => 'setServiceLevel',
        'service_level_description' => 'setServiceLevelDescription',
        'ship_date' => 'setShipDate',
        'delivery_date' => 'setDeliveryDate',
        'commit_time' => 'setCommitTime',
        'delivery_time' => 'setDeliveryTime',
        'delivery_day_of_week' => 'setDeliveryDayOfWeek',
        'next_day_pickup_indicator' => 'setNextDayPickupIndicator',
        'saturday_pickup_indicator' => 'setSaturdayPickupIndicator',
        'saturday_delivery_date' => 'setSaturdayDeliveryDate',
        'saturday_delivery_time' => 'setSaturdayDeliveryTime',
        'service_remarks_text' => 'setServiceRemarksText',
        'guarantee_indicator' => 'setGuaranteeIndicator',
        'total_transit_days' => 'setTotalTransitDays',
        'business_transit_days' => 'setBusinessTransitDays',
        'rest_days_count' => 'setRestDaysCount',
        'holiday_count' => 'setHolidayCount',
        'delay_count' => 'setDelayCount',
        'pickup_date' => 'setPickupDate',
        'pickup_time' => 'setPickupTime',
        'cstccutoff_time' => 'setCstccutoffTime',
        'poddate' => 'setPoddate',
        'poddays' => 'setPoddays'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'service_level' => 'getServiceLevel',
        'service_level_description' => 'getServiceLevelDescription',
        'ship_date' => 'getShipDate',
        'delivery_date' => 'getDeliveryDate',
        'commit_time' => 'getCommitTime',
        'delivery_time' => 'getDeliveryTime',
        'delivery_day_of_week' => 'getDeliveryDayOfWeek',
        'next_day_pickup_indicator' => 'getNextDayPickupIndicator',
        'saturday_pickup_indicator' => 'getSaturdayPickupIndicator',
        'saturday_delivery_date' => 'getSaturdayDeliveryDate',
        'saturday_delivery_time' => 'getSaturdayDeliveryTime',
        'service_remarks_text' => 'getServiceRemarksText',
        'guarantee_indicator' => 'getGuaranteeIndicator',
        'total_transit_days' => 'getTotalTransitDays',
        'business_transit_days' => 'getBusinessTransitDays',
        'rest_days_count' => 'getRestDaysCount',
        'holiday_count' => 'getHolidayCount',
        'delay_count' => 'getDelayCount',
        'pickup_date' => 'getPickupDate',
        'pickup_time' => 'getPickupTime',
        'cstccutoff_time' => 'getCstccutoffTime',
        'poddate' => 'getPoddate',
        'poddays' => 'getPoddays'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['service_level'] = isset($data['service_level']) ? $data['service_level'] : null;
        $this->container['service_level_description'] = isset($data['service_level_description']) ? $data['service_level_description'] : null;
        $this->container['ship_date'] = isset($data['ship_date']) ? $data['ship_date'] : null;
        $this->container['delivery_date'] = isset($data['delivery_date']) ? $data['delivery_date'] : null;
        $this->container['commit_time'] = isset($data['commit_time']) ? $data['commit_time'] : null;
        $this->container['delivery_time'] = isset($data['delivery_time']) ? $data['delivery_time'] : null;
        $this->container['delivery_day_of_week'] = isset($data['delivery_day_of_week']) ? $data['delivery_day_of_week'] : null;
        $this->container['next_day_pickup_indicator'] = isset($data['next_day_pickup_indicator']) ? $data['next_day_pickup_indicator'] : null;
        $this->container['saturday_pickup_indicator'] = isset($data['saturday_pickup_indicator']) ? $data['saturday_pickup_indicator'] : null;
        $this->container['saturday_delivery_date'] = isset($data['saturday_delivery_date']) ? $data['saturday_delivery_date'] : null;
        $this->container['saturday_delivery_time'] = isset($data['saturday_delivery_time']) ? $data['saturday_delivery_time'] : null;
        $this->container['service_remarks_text'] = isset($data['service_remarks_text']) ? $data['service_remarks_text'] : null;
        $this->container['guarantee_indicator'] = isset($data['guarantee_indicator']) ? $data['guarantee_indicator'] : null;
        $this->container['total_transit_days'] = isset($data['total_transit_days']) ? $data['total_transit_days'] : null;
        $this->container['business_transit_days'] = isset($data['business_transit_days']) ? $data['business_transit_days'] : null;
        $this->container['rest_days_count'] = isset($data['rest_days_count']) ? $data['rest_days_count'] : null;
        $this->container['holiday_count'] = isset($data['holiday_count']) ? $data['holiday_count'] : null;
        $this->container['delay_count'] = isset($data['delay_count']) ? $data['delay_count'] : null;
        $this->container['pickup_date'] = isset($data['pickup_date']) ? $data['pickup_date'] : null;
        $this->container['pickup_time'] = isset($data['pickup_time']) ? $data['pickup_time'] : null;
        $this->container['cstccutoff_time'] = isset($data['cstccutoff_time']) ? $data['cstccutoff_time'] : null;
        $this->container['poddate'] = isset($data['poddate']) ? $data['poddate'] : null;
        $this->container['poddays'] = isset($data['poddays']) ? $data['poddays'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['service_level'] === null) {
            $invalidProperties[] = "'service_level' can't be null";
        }
        if ($this->container['service_level_description'] === null) {
            $invalidProperties[] = "'service_level_description' can't be null";
        }
        if ($this->container['ship_date'] === null) {
            $invalidProperties[] = "'ship_date' can't be null";
        }
        if ($this->container['delivery_date'] === null) {
            $invalidProperties[] = "'delivery_date' can't be null";
        }
        if ($this->container['commit_time'] === null) {
            $invalidProperties[] = "'commit_time' can't be null";
        }
        if ($this->container['delivery_time'] === null) {
            $invalidProperties[] = "'delivery_time' can't be null";
        }
        if ($this->container['delivery_day_of_week'] === null) {
            $invalidProperties[] = "'delivery_day_of_week' can't be null";
        }
        if ($this->container['next_day_pickup_indicator'] === null) {
            $invalidProperties[] = "'next_day_pickup_indicator' can't be null";
        }
        if ($this->container['saturday_pickup_indicator'] === null) {
            $invalidProperties[] = "'saturday_pickup_indicator' can't be null";
        }
        if ($this->container['guarantee_indicator'] === null) {
            $invalidProperties[] = "'guarantee_indicator' can't be null";
        }
        if ($this->container['total_transit_days'] === null) {
            $invalidProperties[] = "'total_transit_days' can't be null";
        }
        if ($this->container['business_transit_days'] === null) {
            $invalidProperties[] = "'business_transit_days' can't be null";
        }
        if ($this->container['rest_days_count'] === null) {
            $invalidProperties[] = "'rest_days_count' can't be null";
        }
        if ($this->container['holiday_count'] === null) {
            $invalidProperties[] = "'holiday_count' can't be null";
        }
        if ($this->container['delay_count'] === null) {
            $invalidProperties[] = "'delay_count' can't be null";
        }
        if ($this->container['pickup_date'] === null) {
            $invalidProperties[] = "'pickup_date' can't be null";
        }
        if ($this->container['pickup_time'] === null) {
            $invalidProperties[] = "'pickup_time' can't be null";
        }
        if ($this->container['cstccutoff_time'] === null) {
            $invalidProperties[] = "'cstccutoff_time' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets service_level
     *
     * @return string
     */
    public function getServiceLevel()
    {
        return $this->container['service_level'];
    }

    /**
     * Sets service_level
     *
     * @param string $service_level Service level code     Valid domestic service codes: \"1DMS\",\"1DAS\",\"1DM\",\"1DA\",\"1DP\",\"2DM\",\"2DA\",\"3DS\",\"GND\".      Valid International service codes (not a complete list) ,\"01\",\"02\",\"03\",\"05\",\"08\",\"09\",\"10\",\"11\",\"18\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"28\",\"29\",\"33\",\"68\".
     *
     * @return $this
     */
    public function setServiceLevel($service_level)
    {
        $this->container['service_level'] = $service_level;

        return $this;
    }

    /**
     * Gets service_level_description
     *
     * @return string
     */
    public function getServiceLevelDescription()
    {
        return $this->container['service_level_description'];
    }

    /**
     * Sets service_level_description
     *
     * @param string $service_level_description Service name. Examples are: UPS Next Day Air, UPS Ground, UPS Expedited, UPS Worldwide Express Freight
     *
     * @return $this
     */
    public function setServiceLevelDescription($service_level_description)
    {
        $this->container['service_level_description'] = $service_level_description;

        return $this;
    }

    /**
     * Gets ship_date
     *
     * @return string
     */
    public function getShipDate()
    {
        return $this->container['ship_date'];
    }

    /**
     * Sets ship_date
     *
     * @param string $ship_date The date the shipment is tendered to UPS for shipping (can be dropped off at UPS or picked up by UPS).  This date may or may not be the UPS business date.     Valid Format: YYYY-MM-DD
     *
     * @return $this
     */
    public function setShipDate($ship_date)
    {
        $this->container['ship_date'] = $ship_date;

        return $this;
    }

    /**
     * Gets delivery_date
     *
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->container['delivery_date'];
    }

    /**
     * Sets delivery_date
     *
     * @param string $delivery_date Scheduled delivery date.     Valid format: YYYY-MM-DD
     *
     * @return $this
     */
    public function setDeliveryDate($delivery_date)
    {
        $this->container['delivery_date'] = $delivery_date;

        return $this;
    }

    /**
     * Gets commit_time
     *
     * @return string
     */
    public function getCommitTime()
    {
        return $this->container['commit_time'];
    }

    /**
     * Sets commit_time
     *
     * @param string $commit_time Scheduled commit time.     For international shipments the value always come back from SE (OPSYS data) but for domestic, value may be used from NRF commit time.      Valid format: HH:MM:SS
     *
     * @return $this
     */
    public function setCommitTime($commit_time)
    {
        $this->container['commit_time'] = $commit_time;

        return $this;
    }

    /**
     * Gets delivery_time
     *
     * @return string
     */
    public function getDeliveryTime()
    {
        return $this->container['delivery_time'];
    }

    /**
     * Sets delivery_time
     *
     * @param string $delivery_time Scheduled Delivery Time, value may be later then commit time.     Valid format: HH:MM:SS
     *
     * @return $this
     */
    public function setDeliveryTime($delivery_time)
    {
        $this->container['delivery_time'] = $delivery_time;

        return $this;
    }

    /**
     * Gets delivery_day_of_week
     *
     * @return string
     */
    public function getDeliveryDayOfWeek()
    {
        return $this->container['delivery_day_of_week'];
    }

    /**
     * Sets delivery_day_of_week
     *
     * @param string $delivery_day_of_week Three character scheduled delivery day of week.     Valid values: \"MON\",\"TUE\",\"WED\",\"THU\",\"FRI\", \"SAT\"
     *
     * @return $this
     */
    public function setDeliveryDayOfWeek($delivery_day_of_week)
    {
        $this->container['delivery_day_of_week'] = $delivery_day_of_week;

        return $this;
    }

    /**
     * Gets next_day_pickup_indicator
     *
     * @return string
     */
    public function getNextDayPickupIndicator()
    {
        return $this->container['next_day_pickup_indicator'];
    }

    /**
     * Sets next_day_pickup_indicator
     *
     * @param string $next_day_pickup_indicator Returns a \"1\" if the requested shipped on date was changed. This data is available only for international transactions.     When this flag is set, WWDTDisclaimer.getNextDayDisclaimer method could be called to return the next day disclaimer message.
     *
     * @return $this
     */
    public function setNextDayPickupIndicator($next_day_pickup_indicator)
    {
        $this->container['next_day_pickup_indicator'] = $next_day_pickup_indicator;

        return $this;
    }

    /**
     * Gets saturday_pickup_indicator
     *
     * @return string
     */
    public function getSaturdayPickupIndicator()
    {
        return $this->container['saturday_pickup_indicator'];
    }

    /**
     * Sets saturday_pickup_indicator
     *
     * @param string $saturday_pickup_indicator Returns \"1\" if Saturday Pickup is available for an extra charge otherwise it will return \"0\".     When this flag is set, WWDTDisclaimer.getSaturdayPickupDisclaimer method could be called to return the Saturday pickup extra charge message
     *
     * @return $this
     */
    public function setSaturdayPickupIndicator($saturday_pickup_indicator)
    {
        $this->container['saturday_pickup_indicator'] = $saturday_pickup_indicator;

        return $this;
    }

    /**
     * Gets saturday_delivery_date
     *
     * @return string
     */
    public function getSaturdayDeliveryDate()
    {
        return $this->container['saturday_delivery_date'];
    }

    /**
     * Sets saturday_delivery_date
     *
     * @param string $saturday_delivery_date Delivery date of Saturday Delivery     Valid Format: YYYY-MM-DD
     *
     * @return $this
     */
    public function setSaturdayDeliveryDate($saturday_delivery_date)
    {
        $this->container['saturday_delivery_date'] = $saturday_delivery_date;

        return $this;
    }

    /**
     * Gets saturday_delivery_time
     *
     * @return string
     */
    public function getSaturdayDeliveryTime()
    {
        return $this->container['saturday_delivery_time'];
    }

    /**
     * Sets saturday_delivery_time
     *
     * @param string $saturday_delivery_time Delivery time of Saturday deliver     Valid format: HH:MM:SS
     *
     * @return $this
     */
    public function setSaturdayDeliveryTime($saturday_delivery_time)
    {
        $this->container['saturday_delivery_time'] = $saturday_delivery_time;

        return $this;
    }

    /**
     * Gets service_remarks_text
     *
     * @return string
     */
    public function getServiceRemarksText()
    {
        return $this->container['service_remarks_text'];
    }

    /**
     * Sets service_remarks_text
     *
     * @param string $service_remarks_text Service remarks text. The contents of this field will represent text that the back end application/function needs to display to clarify the time in transit calculation.
     *
     * @return $this
     */
    public function setServiceRemarksText($service_remarks_text)
    {
        $this->container['service_remarks_text'] = $service_remarks_text;

        return $this;
    }

    /**
     * Gets guarantee_indicator
     *
     * @return string
     */
    public function getGuaranteeIndicator()
    {
        return $this->container['guarantee_indicator'];
    }

    /**
     * Sets guarantee_indicator
     *
     * @param string $guarantee_indicator Return \"1\" Guaranteed, or \"0\" Not Guaranteed based on below conditions:     If the ship date, delivery date, and system date are not within a defined peak date range, and a value for service guarantee is available in SE (OPSYS data) that will be returned.     If the ship date or delivery date or system date are within a defined peak date range and the service is within the list of services to remove guarantees for, \"0\" wil be returned.
     *
     * @return $this
     */
    public function setGuaranteeIndicator($guarantee_indicator)
    {
        $this->container['guarantee_indicator'] = $guarantee_indicator;

        return $this;
    }

    /**
     * Gets total_transit_days
     *
     * @return int
     */
    public function getTotalTransitDays()
    {
        return $this->container['total_transit_days'];
    }

    /**
     * Sets total_transit_days
     *
     * @param int $total_transit_days Available for International requests. Number of calendar days from origin location to destination location.  TotalTransitDays = BusinessTransitDays + RestDaysCount + HolidayCount.     Defaults to 0.
     *
     * @return $this
     */
    public function setTotalTransitDays($total_transit_days)
    {
        $this->container['total_transit_days'] = $total_transit_days;

        return $this;
    }

    /**
     * Gets business_transit_days
     *
     * @return int
     */
    public function getBusinessTransitDays()
    {
        return $this->container['business_transit_days'];
    }

    /**
     * Sets business_transit_days
     *
     * @param int $business_transit_days Returns the number of UPS business days from origin location to destination location.
     *
     * @return $this
     */
    public function setBusinessTransitDays($business_transit_days)
    {
        $this->container['business_transit_days'] = $business_transit_days;

        return $this;
    }

    /**
     * Gets rest_days_count
     *
     * @return int
     */
    public function getRestDaysCount()
    {
        return $this->container['rest_days_count'];
    }

    /**
     * Sets rest_days_count
     *
     * @param int $rest_days_count Returns the number of rest days encountered at the origin location.  this data is available only for international transactions.     Defaults to 0.
     *
     * @return $this
     */
    public function setRestDaysCount($rest_days_count)
    {
        $this->container['rest_days_count'] = $rest_days_count;

        return $this;
    }

    /**
     * Gets holiday_count
     *
     * @return int
     */
    public function getHolidayCount()
    {
        return $this->container['holiday_count'];
    }

    /**
     * Sets holiday_count
     *
     * @param int $holiday_count Returns the number of holidays encountered at the origin and destination location, if it effects the time and transit.  This data is available only for international transactions.     Defaults to 0.
     *
     * @return $this
     */
    public function setHolidayCount($holiday_count)
    {
        $this->container['holiday_count'] = $holiday_count;

        return $this;
    }

    /**
     * Gets delay_count
     *
     * @return int
     */
    public function getDelayCount()
    {
        return $this->container['delay_count'];
    }

    /**
     * Sets delay_count
     *
     * @param int $delay_count Returns the number of delay needed for customs encounter at the origin or destination location.  This data is available only for international transactions.      Defaults to 0.
     *
     * @return $this
     */
    public function setDelayCount($delay_count)
    {
        $this->container['delay_count'] = $delay_count;

        return $this;
    }

    /**
     * Gets pickup_date
     *
     * @return string
     */
    public function getPickupDate()
    {
        return $this->container['pickup_date'];
    }

    /**
     * Sets pickup_date
     *
     * @param string $pickup_date Planned pickup date.     Note: This value may not equal the shipped on value requested.  This could happen when the requested shipped on date is a holiday or for locations needing 24 hour notice before a pickup could be made.
     *
     * @return $this
     */
    public function setPickupDate($pickup_date)
    {
        $this->container['pickup_date'] = $pickup_date;

        return $this;
    }

    /**
     * Gets pickup_time
     *
     * @return string
     */
    public function getPickupTime()
    {
        return $this->container['pickup_time'];
    }

    /**
     * Sets pickup_time
     *
     * @param string $pickup_time Latest possible pickup time. This data is available only for international transactions. If the package was not actually picked by UPS before this time, the services will not meet the guarantee commitment.
     *
     * @return $this
     */
    public function setPickupTime($pickup_time)
    {
        $this->container['pickup_time'] = $pickup_time;

        return $this;
    }

    /**
     * Gets cstccutoff_time
     *
     * @return string
     */
    public function getCstccutoffTime()
    {
        return $this->container['cstccutoff_time'];
    }

    /**
     * Sets cstccutoff_time
     *
     * @param string $cstccutoff_time Latest time a customer can contact UPS CST to be notified for requesting a pickup. This data is available only for international transactions. If customer does not notify UPS for a pickup before this time, the services will not meet the guarantee commitment.
     *
     * @return $this
     */
    public function setCstccutoffTime($cstccutoff_time)
    {
        $this->container['cstccutoff_time'] = $cstccutoff_time;

        return $this;
    }

    /**
     * Gets poddate
     *
     * @return string
     */
    public function getPoddate()
    {
        return $this->container['poddate'];
    }

    /**
     * Sets poddate
     *
     * @param string $poddate Returns the date proof of delivery information would be available.  This data is available only for international transactions.
     *
     * @return $this
     */
    public function setPoddate($poddate)
    {
        $this->container['poddate'] = $poddate;

        return $this;
    }

    /**
     * Gets poddays
     *
     * @return int
     */
    public function getPoddays()
    {
        return $this->container['poddays'];
    }

    /**
     * Sets poddays
     *
     * @param int $poddays Returns the number of days proof of delivery information will be available.  This data is available only for international transactions.
     *
     * @return $this
     */
    public function setPoddays($poddays)
    {
        $this->container['poddays'] = $poddays;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
