<?php
/**
 * Milestones
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Tracking
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * UPS TrackService API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Tracking\Tracking;

use \ArrayAccess;
use \UPS\Tracking\ObjectSerializer;

/**
 * Milestones Class Doc Comment
 *
 * @category Class
 * @description The list of milestones associated with the package. Milestones will be returned in chronological order, with the oldest first and most recent/future milestones last.
 * @package  UPS\Tracking
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Milestones implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Milestones';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'category' => 'string',
        'code' => 'string',
        'current' => 'bool',
        'description' => 'string',
        'linked_activity' => 'string',
        'state' => 'string',
        'sub_milestone' => '\UPS\Tracking\Tracking\SubMilestone'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'category' => null,
        'code' => null,
        'current' => null,
        'description' => null,
        'linked_activity' => null,
        'state' => null,
        'sub_milestone' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'category' => 'category',
        'code' => 'code',
        'current' => 'current',
        'description' => 'description',
        'linked_activity' => 'linkedActivity',
        'state' => 'state',
        'sub_milestone' => 'subMilestone'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'category' => 'setCategory',
        'code' => 'setCode',
        'current' => 'setCurrent',
        'description' => 'setDescription',
        'linked_activity' => 'setLinkedActivity',
        'state' => 'setState',
        'sub_milestone' => 'setSubMilestone'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'category' => 'getCategory',
        'code' => 'getCode',
        'current' => 'getCurrent',
        'description' => 'getDescription',
        'linked_activity' => 'getLinkedActivity',
        'state' => 'getState',
        'sub_milestone' => 'getSubMilestone'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['category'] = isset($data['category']) ? $data['category'] : null;
        $this->container['code'] = isset($data['code']) ? $data['code'] : null;
        $this->container['current'] = isset($data['current']) ? $data['current'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['linked_activity'] = isset($data['linked_activity']) ? $data['linked_activity'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['sub_milestone'] = isset($data['sub_milestone']) ? $data['sub_milestone'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets category
     *
     * @return string
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string $category The milestone category. This will be present only when a milestone is in a COMPLETE state.
     *
     * @return $this
     */
    public function setCategory($category)
    {
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string $code The milestone code.
     *
     * @return $this
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets current
     *
     * @return bool
     */
    public function getCurrent()
    {
        return $this->container['current'];
    }

    /**
     * Sets current
     *
     * @param bool $current The indication if the milestone represents the current state of the package. Valid values: 'true' this milestone is the current state of the package.  'false' this milestone is not current.
     *
     * @return $this
     */
    public function setCurrent($current)
    {
        $this->container['current'] = $current;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description The milestone description. Note: this is not translated at this time and is returned in US English.
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets linked_activity
     *
     * @return string
     */
    public function getLinkedActivity()
    {
        return $this->container['linked_activity'];
    }

    /**
     * Sets linked_activity
     *
     * @param string $linked_activity The 0-based index of the activity that triggered this milestone. This will be returned only when a milestone is in a COMPLETE state. For example the most recent activity on the response is index 0.
     *
     * @return $this
     */
    public function setLinkedActivity($linked_activity)
    {
        $this->container['linked_activity'] = $linked_activity;

        return $this;
    }

    /**
     * Gets state
     *
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param string $state The milestone state. Valid values: 'This milestone has already occurred'/'This milestone has not yet been completed'.
     *
     * @return $this
     */
    public function setState($state)
    {
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets sub_milestone
     *
     * @return \UPS\Tracking\Tracking\SubMilestone
     */
    public function getSubMilestone()
    {
        return $this->container['sub_milestone'];
    }

    /**
     * Sets sub_milestone
     *
     * @param \UPS\Tracking\Tracking\SubMilestone $sub_milestone sub_milestone
     *
     * @return $this
     */
    public function setSubMilestone($sub_milestone)
    {
        $this->container['sub_milestone'] = $sub_milestone;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
