
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `abante142`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addresses`
--

CREATE TABLE `[[dbprefix]]addresses` (
  `address_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `company` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `address_1` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_2` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `postcode` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` int NOT NULL DEFAULT '0',
  `zone_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_id`),
  KEY `[[dbprefix]]addresses_idx` (`customer_id`,`country_id`,`zone_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]addresses`
--

INSERT INTO `[[dbprefix]]addresses` VALUES
(1, 2, '', 'Juliana', 'Davis', '9778 Golden Crescent', 'Apt 10', '85804-7365', 'Humansville', 223, 3616),
(2, 3, '', 'Keely', 'Mccoy', '5071 Misty Pond Farm', 'Suite #101', '63406-9081', 'Bumble Bee', 223, 3648),
(3, 4, 'BelfastCo', 'Zelda', 'Weiss', '6944 Sleepy Fawn Abbey', 'Suite #31', '86014-8121', 'Lawyers', 223, 3616),
(4, 5, '', 'Gloria', 'Macias', '7590 Easy Robin Hollow', '', '73477-3842', 'Sandymush', 223, 3660),
(5, 6, '', 'Bernard', 'Horne', '5607 Umber Branch Via', '', '86301-9785', 'Spook City', 223, 3616),
(6, 7, '', 'James', 'Curtis', '6500 Arapahoe Road', '', '80303', 'Boulder', 223, 3634),
(7, 8, '', 'Bruce', 'Rosarini', '61 Cumberland ST', '', '68624-2273', 'Skokie', 223, 3650),
(8, 9, '', 'Carlos', 'Compton', '31 Capital Drive', '', '63142-0892', 'Fort Misery', 223, 3648),
(9, 10, '', 'Garrison', 'Baxter', 'Eddie Hoffman Highway', '', '64034-2948', 'Shell Pile', 223, 3648),
(10, 11, '', 'Anthony', 'Blair', '104 Main Street', '', '29181-8284', 'Gassaway', 223, 3666),
(11, 12, '', 'Allen', 'Waters', '110 Shenandoah Avenue', '', '86565-1710', 'Honohina', 223, 3616),
(12, 13, '', 'Tom', 'Kipling', '100 Main Str', '', '64034-2948', 'Shell Pile', 223, 3648),
(13, 14, 'Eaton Stevenson Inc', 'Yuri', 'Howard', '22555 Jensen Ave', '', '93654', 'Reedley', 223, 3624),
(14, 15, 'Day and Rivera Traders', 'Regan', 'Shields', '2355 Boulevard Bastien', '', 'G2B 1B3', 'Québec', 38, 612),
(15, 16, '', 'Randall', 'Richards', '500 N Nebraska Ave', '', '33603', 'Tampa', 223, 3630),
(16, 16, 'Guzman and Morin Inc', 'Mallory', 'Ballard', '2430 S French Ave', '', '32771', 'Sanford', 223, 3630),
(17, 17, '', 'Michelle', 'Barnett', '3180 S Redwood Rd', '', '84119', 'West Valley City', 223, 3670),
(18, 18, '', 'Elmer', 'West', '1433 Armand-Frappier', '', 'J3E 3R6', 'Sainte-Julie', 38, 612),
(19, 18, '', 'Elmer', 'West', '291 Central Ave', '', '10606', 'White Plains', 223, 3657);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ant_messages`
--

CREATE TABLE `[[dbprefix]]ant_messages` (
  `id` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL DEFAULT '0',
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `viewed_date` timestamp NULL DEFAULT NULL,
  `viewed` int NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `html` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `language_code` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`language_code`),
  KEY `daterange_idx` (`start_date`,`end_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners`
--

CREATE TABLE `[[dbprefix]]banners` (
  `banner_id` int NOT NULL AUTO_INCREMENT,
  `status` int NOT NULL DEFAULT '0',
  `banner_type` int NOT NULL DEFAULT '1',
  `banner_group_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `blank` tinyint(1) NOT NULL DEFAULT '0',
  `target_url` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`banner_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]banners`
--

INSERT INTO `[[dbprefix]]banners` VALUES
(8, 1, 2, 'Main Page Banners', '[[regtime]]', NULL, 0, '', 1, '[[regtime]]', '[[regtime]]'),
(9, 1, 2, 'Main Page Banners', '[[regtime]]', NULL, 0, '', 2, '[[regtime]]', '[[regtime]]'),
(10, 1, 2, 'Main Page Banners', '[[regtime]]', NULL, 0, '', 3, '[[regtime]]', '[[regtime]]'),
(11, 1, 2, 'Main Page Banners', '[[regtime]]', NULL, 0, '', 4, '[[regtime]]', '[[regtime]]'),
(13, 1, 1, 'Main bottom banners', '[[regtime]]', NULL, 0, 'https://www.abantecart.com', 1, '[[regtime]]', '[[regtime]]'),
(14, 1, 1, 'Main bottom banners', '[[regtime]]', NULL, 0, 'https://www.abantecart.com', 2, '[[regtime]]', '[[regtime]]'),
(15, 1, 1, 'Main bottom banners', '[[regtime]]', NULL, 0, 'https://www.abantecart.com', 3, '[[regtime]]', '[[regtime]]'),
(16, 1, 1, 'Main bottom banners', '[[regtime]]', NULL, 0, 'https://www.abantecart.com', 4, '[[regtime]]', '[[regtime]]'),
(17, 1, 2, 'Main Page Banners', '[[regtime]]', NULL, 0, '', 5, '[[regtime]]', '[[regtime]]'),
(18, 1, 1, 'Main Page Banners', '[[regtime]]', NULL, 0, '', 6, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banner_descriptions`
--

CREATE TABLE `[[dbprefix]]banner_descriptions` (
  `banner_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `meta` text COLLATE utf8mb4_unicode_ci COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`banner_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]banner_descriptions`
--

INSERT INTO `[[dbprefix]]banner_descriptions` VALUES
(8, 1, 'Main Banner 1', '&lt;p&gt;\r\n	&lt;img alt=&quot;&quot; class=&quot;wp1_3 slide1_bot&quot; src=&quot;storefront/view/default/image/banner_image_1.png&quot; width=&quot;600&quot; height=&quot;300&quot; /&gt; &lt;span class=&quot;txt1&quot;&gt;HTML5 Responsive Storefront to look great on&lt;/span&gt; &lt;span class=&quot;txt2&quot;&gt;ALL Screen Sizes&lt;/span&gt; &lt;span class=&quot;txt3 short&quot;&gt;Natively responsive template implemented with bootstrap library and HTML5. Will look good on most mobile devices and tablets.&lt;/span&gt; &lt;span class=&quot;txt4 txt4up&quot;&gt;&lt;a class=&quot;btn btn-wht&quot; href=&quot;&quot;&gt;Try on your device!&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;\r\n', '', '[[regtime]]', '[[regtime]]'),
(9, 1, 'Main Banner 2', '&lt;p&gt;\r\n	&lt;img alt=&quot;&quot; class=&quot;wp1_3 wp1_left slide2_bot&quot; src=&quot;storefront/view/default/image/banner_image_2.png&quot; width=&quot;600&quot; height=&quot;300&quot; /&gt; &lt;span class=&quot;txt1 blue txt_right2&quot;&gt;Highly flexible layout on any page&lt;/span&gt; &lt;span class=&quot;txt2 blue txt_right2&quot;&gt;SEO Friendly&lt;/span&gt; &lt;span class=&quot;txt2 blue txt_right2&quot;&gt;Fast Loading&lt;/span&gt; &lt;span class=&quot;txt4 txt_right2 txt4up&quot;&gt;&lt;a class=&quot;btn btn-wht&quot; href=&quot;#&quot;&gt;Try Now!&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;\r\n', '', '[[regtime]]', '[[regtime]]'),
(10, 1, 'Main Banner 3', '&lt;p&gt;\r\n	&lt;img alt=&quot;&quot; class=&quot;wp1_3 slide2_bot&quot; src=&quot;storefront/view/default/image/banner_image_3.png&quot; width=&quot;600&quot; height=&quot;300&quot; /&gt; &lt;span class=&quot;txt1&quot;&gt;Feature rich with smart UI&lt;/span&gt; &lt;span class=&quot;txt2&quot;&gt;Easy &amp;amp; fun to manage&lt;/span&gt; &lt;span class=&quot;txt3&quot;&gt;Feature reach shopping cart application right out of the box. Standard features allow to set up complete eCommerce site with all the tools needed to sell products online.&lt;/span&gt; &lt;span class=&quot;txt4&quot;&gt;&lt;a class=&quot;btn btn-wht&quot; href=&quot;#&quot;&gt;Install Now!&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;\r\n', '', '[[regtime]]', '[[regtime]]'),
(11, 1, 'Main Banner 4', '&lt;p&gt;\r\n	&lt;img alt=&quot;&quot; class=&quot;wp1_3 slide3_bot&quot; src=&quot;storefront/view/default/image/banner_image_4.png&quot; width=&quot;600&quot; height=&quot;300&quot; /&gt; &lt;span class=&quot;txt1 blue&quot;&gt;Stay in control&lt;/span&gt; &lt;span class=&quot;txt2 blue&quot;&gt;Easy updates&lt;/span&gt; &lt;span class=&quot;txt3 short&quot;&gt;Upgrade right from admin. Backward supportability in upgrades and automatic backups. Easy extension download with one step installation.&lt;/span&gt; &lt;span class=&quot;txt4 txt4up&quot;&gt;&lt;a class=&quot;btn btn-wht&quot; href=&quot;#&quot;&gt;Get Yours!&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;\r\n', '', '[[regtime]]', '[[regtime]]'),
(13, 1, 'banner1', '', '', '[[regtime]]', '[[regtime]]'),
(14, 1, 'banner2', '', '', '[[regtime]]', '[[regtime]]'),
(15, 1, 'banner3', '', '', '[[regtime]]', '[[regtime]]'),
(16, 1, 'banner4', '', '', '[[regtime]]', '[[regtime]]'),
(17, 1, 'Main Banner 5', '&lt;p&gt;\r\n	&lt;img alt=&quot;&quot; class=&quot;wp1_3 slide2_bot&quot; src=&quot;storefront/view/default/image/banner_image_5.png&quot; width=&quot;600&quot; height=&quot;300&quot; /&gt; &lt;span class=&quot;txt1&quot;&gt;Application and data security&lt;/span&gt; &lt;span class=&quot;txt2&quot;&gt;Secure Solution&lt;/span&gt; &lt;span class=&quot;txt3&quot;&gt;Very secure solution with up to date industry security practices and inline with PCI compliance. Customer information protection with data encryption&lt;/span&gt; &lt;span class=&quot;txt4&quot;&gt;&lt;a class=&quot;btn btn-wht&quot; href=&quot;#&quot;&gt;Install Now!&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;\r\n', '', '[[regtime]]', '[[regtime]]'),
(18, 1, 'fallback', '', '', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banner_stat`
--

CREATE TABLE `[[dbprefix]]banner_stat` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `banner_id` int NOT NULL,
  `type` int NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `store_id` int NOT NULL,
  `user_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rowid`),
  KEY `[[dbprefix]]banner_stat_idx` (`banner_id`,`type`,`time`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blocks`
--

CREATE TABLE `[[dbprefix]]blocks` (
  `block_id` int NOT NULL AUTO_INCREMENT,
  `block_txt_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `controller` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`block_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=41 ;

--
-- Dumping data for table `[[dbprefix]]blocks`
--

INSERT INTO `[[dbprefix]]blocks` VALUES
(1, 'header', 'common/header', '[[regtime]]', '[[regtime]]'),
(2, 'header_bottom', 'common/header_bottom', '[[regtime]]', '[[regtime]]'),
(3, 'column_left', 'common/column_left', '[[regtime]]', '[[regtime]]'),
(4, 'content_top', 'common/content_top', '[[regtime]]', '[[regtime]]'),
(5, 'content_bottom', 'common/content_bottom', '[[regtime]]', '[[regtime]]'),
(6, 'column_right', 'common/column_right', '[[regtime]]', '[[regtime]]'),
(7, 'footer_top', 'common/footer_top', '[[regtime]]', '[[regtime]]'),
(8, 'footer', 'common/footer', '[[regtime]]', '[[regtime]]'),
(9, 'category', 'blocks/category', '[[regtime]]', '[[regtime]]'),
(10, 'manufacturer', 'blocks/manufacturer', '[[regtime]]', '[[regtime]]'),
(11, 'content', 'blocks/content', '[[regtime]]', '[[regtime]]'),
(12, 'latest', 'blocks/latest', '[[regtime]]', '[[regtime]]'),
(13, 'language', 'blocks/language', '[[regtime]]', '[[regtime]]'),
(14, 'currency', 'blocks/currency', '[[regtime]]', '[[regtime]]'),
(15, 'cart', 'blocks/cart', '[[regtime]]', '[[regtime]]'),
(16, 'order_summary', 'blocks/order_summary', '[[regtime]]', '[[regtime]]'),
(17, 'html_block', 'blocks/html_block', '[[regtime]]', '[[regtime]]'),
(18, 'bestsellers', 'blocks/bestseller', '[[regtime]]', '[[regtime]]'),
(19, 'featured', 'blocks/featured', '[[regtime]]', '[[regtime]]'),
(20, 'listing_block', 'blocks/listing_block', '[[regtime]]', '[[regtime]]'),
(21, 'donate', 'blocks/donate', '[[regtime]]', '[[regtime]]'),
(22, 'special', 'blocks/special', '[[regtime]]', '[[regtime]]'),
(23, 'banner_block', 'blocks/banner_block', '[[regtime]]', '[[regtime]]'),
(24, 'credit_cards', 'blocks/credit_cards', '[[regtime]]', '[[regtime]]'),
(25, 'newsletter_signup', 'blocks/newsletter_signup', '[[regtime]]', '[[regtime]]'),
(26, 'search', 'blocks/search', '[[regtime]]', '[[regtime]]'),
(27, 'menu', 'blocks/menu', '[[regtime]]', '[[regtime]]'),
(28, 'breadcrumbs', 'blocks/breadcrumbs', '[[regtime]]', '[[regtime]]'),
(29, 'account', 'blocks/account', '[[regtime]]', '[[regtime]]'),
(30, 'custom_form_block', 'blocks/custom_form_block', '[[regtime]]', '[[regtime]]'),
(31, 'customer', 'blocks/customer', '[[regtime]]', '[[regtime]]'),
(32, 'fast_checkout_cart_btn', 'blocks/fast_checkout_cart_btn', '[[regtime]]', '[[regtime]]'),
(33, 'fast_checkout_summary', 'blocks/fast_checkout_summary', '[[regtime]]', '[[regtime]]'),
(34, 'viewed_products', 'blocks/viewed_products', '[[regtime]]', '[[regtime]]'),
(35, 'new_content', 'blocks/new_content', '[[regtime]]', '[[regtime]]'),
(36, 'content_search', 'blocks/content_search', '[[regtime]]', '[[regtime]]'),
(37, 'store_hours', 'blocks/store_hours', '[[regtime]]', '[[regtime]]'),
(38, 'mega_menu_header', 'blocks/mega_menu', '[[regtime]]', '[[regtime]]'),
(39, 'category_slides', 'blocks/category_slides', '[[regtime]]', '[[regtime]]'),
(40, 'category_filter', 'blocks/category_filter', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_descriptions`
--

CREATE TABLE `[[dbprefix]]block_descriptions` (
  `block_description_id` int NOT NULL AUTO_INCREMENT,
  `custom_block_id` int NOT NULL,
  `language_id` int NOT NULL,
  `block_wrapper` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `block_framed` tinyint(1) DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`block_description_id`,`custom_block_id`,`language_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=21 ;

--
-- Dumping data for table `[[dbprefix]]block_descriptions`
--

INSERT INTO `[[dbprefix]]block_descriptions` VALUES
(1, 1, 1, '0', 0, 'Social Icons', 'social_icons', '', '&lt;div class=&quot;social_icons nav navbar&quot;&gt; &lt;a class=&quot;nav-link m-3&quot; href=&quot;https://www.facebook.com/AbanteCart&quot; target=&quot;_blank&quot; title=&quot;Facebook&quot; &gt;&lt;i class=&quot; fa-brands fa-facebook fa-xl&quot; &gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot; href=&quot;https://twitter.com/abantecart&quot; target=&quot;_blank&quot; title=&quot;Twitter&quot;&gt;&lt;i class=&quot; fa-brands fa-x-twitter fa-xl&quot; &gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; title=&quot;Linkedin&quot; &gt;&lt;i class=&quot;fa-brands fa-linkedin fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; title=&quot;rss&quot; &gt;&lt;i class=&quot;fa-solid fa-square-rss fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; target=&quot;_blank&quot; title=&quot;Skype&quot; &gt;&lt;i class=&quot;fa-brands fa-skype fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; target=&quot;_blank&quot; title=&quot;Flickr&quot;&gt;&lt;i class=&quot;fa-brands fa-flickr fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;      &lt;/div&gt;', '[[regtime]]', '[[regtime]]'),
(2, 2, 1, 'blocks/html_block_footer.tpl', 1, 'About Us', 'About Us', '', '&lt;p class=&quot;small lh-lg&quot;&gt;AbanteCart is a free eCommerce solution for merchants to provide ability creating online business and sell products or services online. AbanteCart application is built and supported by experienced enthusiasts that are passionate about their work and contribution to rapidly evolving eCommerce industry. AbanteCart is more than just a shopping cart, it is rapidly growing eCommerce platform with many benefits.&lt;/p&gt;', '[[regtime]]', '[[regtime]]'),
(3, 3, 1, 'blocks/html_block_footer.tpl', 1, 'Contact us', 'Contact Us', '', '&lt;ul class=&quot;list-unstyled contact small&quot;&gt;   &lt;li class=&quot;mb-2&quot;&gt;&lt;i class=&quot;fa-solid fa-phone&quot;&gt;&lt;/i&gt;&lt;/i&gt; 123 456 7890,  123 456 7890&lt;/li&gt;    &lt;li class=&quot;mb-2&quot;&gt;&lt;i class=&quot;fa-solid fa-mobile-screen&quot;&gt;&lt;/i&gt;&lt;a class=&quot;text-decoration-none&quot;  href=&quot;tel:123 456 7890&quot;&gt; 123 456 7890&lt;/a&gt;,  123 456 78900&lt;/li&gt;    &lt;li class=&quot;mb-2&quot;&gt;&lt;i class=&quot;fa-solid fa-at&quot;&gt;&lt;/i&gt; help at abantecart.com&lt;/li&gt;&lt;/ul&gt;', '[[regtime]]', '[[regtime]]'),
(4, 4, 1, '0', 1, 'Testimonials', 'Testimonials', '', '&lt;div id=&quot;testimonial_sidebar&quot; class=&quot;carousel carousel-dark slide&quot; data-bs-ride=&quot;carousel&quot;&gt; &lt;div class=&quot;carousel-inner&quot;&gt;                   &lt;div class=&quot;carousel-item active&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; I was working with many shopping carts, free and hosted for my clients. There is always something missing. In AbanteCart I find this gap to be much less. Interface is very easy to use and support is very responsive. This is considering its is free. Go AbanteCart go!&quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : TopShop on reviewcentre.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                    &lt;div class=&quot;carousel-item&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; Without a doubt the best cart I have used. The title says it all - AbanteCart is undoubtedly the best I have used. I''m not an expert in site setup, so something this great looking and easy to use is absolutely perfect ... &quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : johnstenson80 on venturebeat.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                    &lt;div class=&quot;carousel-item&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; Will not regret using this cart. All good is already mentioned, I want to add my experience with support. My problems with some configuration were resolved quick. Faster than paid shopping cart we had before.&quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : shopper23 at bestshoppingcartreviews.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                    &lt;div class=&quot;carousel-item&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; Love the cart. I installed it a while back and use it since when. Some features a hidden, but fun to discover them.&quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : Liz Wattkins at shopping-cart-reviews.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                &lt;/div&gt;            &lt;/div&gt;', '[[regtime]]', '[[regtime]]'),
(5, 5, 1, '0', 0, 'Main Page Carousel', 'Main Page Carousel', '', '&lt;div id=&quot;mainPageSliderIndicators&quot; class=&quot;carousel carousel-dark slide bg-light&quot; data-bs-ride=&quot;carousel&quot;&gt;  &lt;div class=&quot;carousel-indicators&quot;&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;0&quot; class=&quot;active&quot;  aria-current=&quot;true&quot; aria-label=&quot;Slide 1&quot;&gt;&lt;/button&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;1&quot;  aria-label=&quot;Slide 2&quot;&gt;&lt;/button&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;2&quot;  aria-label=&quot;Slide 3&quot;&gt;&lt;/button&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;3&quot;  aria-label=&quot;Slide 4&quot;&gt;&lt;/button&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-inner&quot;&gt;  &lt;div class=&quot;carousel-item banner active&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3 m-5&quot;&gt;  &lt;h5&gt;HTML5 Responsive Storefront to look great on&lt;/h5&gt;  &lt;h5&gt;ALL Screen Sizes&lt;/h5&gt;  &lt;p&gt;Natively responsive template implemented with bootstrap library and HTML5. Will look good on most  mobile devices and tablets.&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt; Try on your device!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-item banner&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3  m-5&quot;&gt;  &lt;h5&gt;Highly flexible layout on any page&lt;/h5&gt;  &lt;h5&gt;SEO Friendly&lt;/h5&gt;  &lt;p&gt;Fast Loading&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt; Try Now!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-item banner&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3  m-5&quot;&gt;  &lt;h5&gt;Feature rich with smart UI&lt;/h5&gt;  &lt;h5&gt;Easy &amp;amp; fun to manage&lt;/h5&gt;  &lt;p&gt;Feature reach shopping cart application right out of the box. Standard features allow to set up  complete eCommerce site with all the tools needed to sell products online.&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt;Install Now!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-item banner&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3  m-5&quot;&gt;  &lt;h5&gt;Stay in control&lt;/h5&gt;  &lt;h5&gt;Easy updates&lt;/h5&gt;  &lt;p&gt;Upgrade right from admin. Backward supportability in upgrades and automatic backups. Easy  extension download with one step installation.&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt;Get Yours!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;button class=&quot;carousel-control-prev&quot; type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide=&quot;prev&quot;&gt;  &lt;span class=&quot;carousel-control-prev-icon&quot; aria-hidden=&quot;true&quot;&gt;&lt;/span&gt;  &lt;span class=&quot;visually-hidden&quot;&gt;Previous&lt;/span&gt;  &lt;/button&gt;  &lt;button class=&quot;carousel-control-next&quot; type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide=&quot;next&quot;&gt;  &lt;span class=&quot;carousel-control-next-icon&quot; aria-hidden=&quot;true&quot;&gt;&lt;/span&gt;  &lt;span class=&quot;visually-hidden&quot;&gt;Next&lt;/span&gt; &lt;/button&gt; &lt;/div&gt;', '[[regtime]]', '[[regtime]]'),
(6, 6, 1, '0', 0, 'Main Page Promo', 'Promo', '', '&lt;section class=&quot;d-flex flex-wrap justify-content-evenly border m-3&quot;&gt;	&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;		&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-truck fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;Free shipping&lt;/h2&gt;All over in world over $200&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-money-bill-1 fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;Easy Payment&lt;/h2&gt;Payment Gateway support&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;		&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-clock fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;24hrs Shipping&lt;/h2&gt;For All US States&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-tags fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;Large Variety&lt;/h2&gt;50,000  Products&lt;/div&gt;&lt;/div&gt;&lt;/section&gt;', '[[regtime]]', '[[regtime]]'),
(7, 7, 1, '0', 0, 'Main Page Banner Bottom', 'Bottom Banners', '', 'a:1:{s:17:""banner_group_name"";s:19:""Main bottom banners"";}', '[[regtime]]', '[[regtime]]'),
(8, 8, 1, 'blocks/listing_block/popular_brands_content_bottom.tpl', 0, 'Brands Scrolling List', 'Brands Scrolling List', '', 'a:1:{s:18:""listing_datasource"";s:20:""custom_manufacturers"";}', '[[regtime]]', '[[regtime]]'),
(9, 9, 1, 'blocks/html_block_footer.tpl', 0, 'Novator About Us', 'Novator About Us', 'Novator About Us', '&lt;div class=&quot;footer-abtus text-center text-md-start&quot;&gt;\n&lt;h3 class=&quot;h5 text-white mb-4&quot;&gt;\n  Where art and fashion fuse. Elevate your style with Balenciaga.&lt;/h3&gt;\n  &lt;ul class=&quot;list-inline&quot;&gt;\n    &lt;li class=&quot;list-inline-item&quot;&gt;&lt;a href=&quot;#&quot;&gt;&lt;i class=&quot;bi bi-layers&quot;&gt;&lt;/i&gt; Top Brands&lt;/a&gt;&lt;/li&gt;\n    &lt;li class=&quot;list-inline-item&quot;&gt;&lt;a href=&quot;#&quot;&gt;&lt;i class=&quot;bi bi-tag&quot;&gt;&lt;/i&gt; Discount&lt;/a&gt;&lt;/li&gt;\n  &lt;/ul&gt;\n  &lt;div class=&quot;social_icons&quot;&gt;\n    &lt;ul class=&quot;list-inline&quot;&gt;\n      &lt;li class=&quot;list-inline-item&quot;&gt;&lt;a href=&quot;https://www.facebook.com/AbanteCart&quot; target=&quot;_blank&quot; title=&quot;Facebook&quot; class=&quot;facebook&quot;&gt;&lt;i class=&quot;fa-brands fa-facebook-f&quot;&gt;&lt;/i&gt;&lt;/a&gt;&lt;/li&gt;\n      &lt;li class=&quot;list-inline-item&quot;&gt;&lt;a href=&quot;https://twitter.com/abantecart&quot; target=&quot;_blank&quot; title=&quot;Twitter&quot; class=&quot;twitter&quot;&gt;&lt;i class=&quot;fa-brands fa-x-twitter&quot;&gt;&lt;/i&gt;&lt;/a&gt;&lt;/li&gt;\n      &lt;li class=&quot;list-inline-item&quot;&gt;&lt;a href=&quot;#&quot; title=&quot;Linkedin&quot; class=&quot;linkedin&quot;&gt;&lt;i class=&quot;fa-brands fa-linkedin-in&quot;&gt;&lt;/i&gt;&lt;/a&gt;&lt;/li&gt;\n     &lt;/ul&gt;\n  &lt;/div&gt;\n&lt;/div&gt;', '[[regtime]]', '[[regtime]]'),
(10, 10, 1, '0', 0, 'Novator Footer link block main', 'Footer link block main', 'Footer link block main', '&lt;div class=&quot;footer-main-links row&quot;&gt;\n  &lt;div class=&quot;col-md-4&quot;&gt;\n  &lt;h3 class=&quot;h5 text-white text-start&quot;&gt;Product&lt;/h3&gt;\n  &lt;ul class=&quot;list-unstyled footer-link&quot;&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Smart&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Habits&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Tasks&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Calendar Sync&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Buffer Time&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Use Cases&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;\n  &lt;/div&gt;\n  &lt;div class=&quot;col-md-4&quot;&gt;\n  &lt;h3 class=&quot;h5 text-white text-start&quot;&gt;Product&lt;/h3&gt;\n  &lt;ul class=&quot;list-unstyled footer-link&quot;&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Smart&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Habits&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Tasks&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Calendar Sync&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Buffer Time&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Use Cases&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;\n  &lt;/div&gt;\n  &lt;div class=&quot;col-md-4&quot;&gt;\n  &lt;h3 class=&quot;h5 text-white text-start&quot;&gt;Product&lt;/h3&gt;\n  &lt;ul class=&quot;list-unstyled footer-link&quot;&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Smart&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Habits&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Tasks&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Calendar Sync&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Buffer Time&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;#&quot; target=&quot;_blank&quot;&gt;Use Cases&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;\n  &lt;/div&gt;\n  &lt;/div&gt;', '[[regtime]]', '[[regtime]]'),
(11, 11, 1, 'blocks/html_block_footer.tpl', 0, 'Novator Contact us', 'Contact us', '', '&lt;div class=&quot;contactus-block text-center text-md-start&quot;&gt;\n&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/5.svg&quot; alt=&quot;images&quot; class=&quot;img-fluid h-auto&quot; width=&quot;350&quot; height=&quot;79&quot;&gt;&lt;p class=&quot;text-white&quot;&gt;1487 Rocky Horse Carrefour&lt;br&gt;Arlington, TX 16819&lt;/p&gt;&lt;h4 class=&quot;text-white&quot;&gt;&lt;i class=&quot;bi bi-telephone&quot;&gt;&lt;/i&gt; (444) 019 120 0401&lt;/h4&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-success d-inline-block&quot;&gt;Live Chat&lt;/a&gt; &lt;a href=&quot;#&quot; class=&quot;btn btn-outline-light d-inline-block&quot;&gt;Help Desk&lt;/a&gt;\n&lt;/div&gt;', '[[regtime]]', '[[regtime]]'),
(12, 12, 1, '0', 0, 'Novator Main Page Carousel', 'Novator Main Page Carousel', '', '&lt;section class=&quot;hero-slider-sec top-section&quot;&gt;\n    &lt;div id=&quot;carouselExample&quot; class=&quot;carousel slide carousel-dark&quot;&gt;\n      &lt;div class=&quot;carousel-inner&quot;&gt;\n        &lt;div class=&quot;carousel-item active&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/e.png&quot;\n            class=&quot;d-none d-lg-block w-100 h-auto&quot; alt=&quot;images&quot; width=&quot;1920&quot; height=&quot;750&quot;&gt; &lt;img\n            src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/f.png&quot; class=&quot;d-block d-lg-none w-100 h-auto&quot; alt=&quot;images&quot; width=&quot;1920&quot;\n            height=&quot;750&quot;&gt;\n          &lt;div class=&quot;carousel-caption d-none d-lg-flex&quot;&gt;\n            &lt;div class=&quot;container&quot;&gt;\n              &lt;div class=&quot;row&quot;&gt;\n                &lt;div class=&quot;col-md-5 text-start&quot;&gt;\n                  &lt;p class=&quot;h5&quot;&gt;Feature rich with smart UI&lt;/p&gt;\n                  &lt;h1 class=&quot;my-4 h2&quot;&gt;&lt;span class=&quot;text-primary&quot;&gt;Easy &amp; Fun&lt;/span&gt; To Manage&lt;/h1&gt;\n                  &lt;p class=&quot;mb-4&quot;&gt;Feature reach shopping cart application right out of the box. Standard features allow\n                    to set up complete eCommerce site with all the tools needed to sell products online.&lt;/p&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-outline-dark&quot;&gt;Install Now&lt;/a&gt;\n                &lt;/div&gt;\n              &lt;/div&gt;\n            &lt;/div&gt;\n          &lt;/div&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;carousel-item&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/0.png&quot; class=&quot;d-none d-lg-block w-100 h-auto&quot;\n            alt=&quot;images&quot; width=&quot;1920&quot; height=&quot;750&quot;&gt; &lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/1.png&quot;\n            class=&quot;d-block d-lg-none w-100 h-auto&quot; alt=&quot;images&quot; width=&quot;1920&quot; height=&quot;750&quot;&gt;\n          &lt;div class=&quot;carousel-caption d-none d-lg-flex&quot;&gt;\n            &lt;div class=&quot;container&quot;&gt;\n              &lt;div class=&quot;row&quot;&gt;\n                &lt;div class=&quot;col-md-5 text-start&quot;&gt;\n                  &lt;h1 class=&quot;mb-4&quot;&gt;All Screen Size&lt;/h1&gt;\n                  &lt;p class=&quot;mb-4&quot;&gt;Natively responsive template implemented with bootstrap library and HTML5. Will look\n                    good on most mobile devices and tablets.&lt;/p&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-outline-dark&quot;&gt;Try On Your\n                    Device&lt;/a&gt;\n                &lt;/div&gt;\n              &lt;/div&gt;\n            &lt;/div&gt;\n          &lt;/div&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;carousel-item&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/4.png&quot; class=&quot;d-none d-lg-block w-100 h-auto&quot;\n            alt=&quot;images&quot; width=&quot;1920&quot; height=&quot;750&quot;&gt; &lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/3.png&quot;\n            class=&quot;d-block d-lg-none w-100 h-auto&quot; alt=&quot;images&quot; width=&quot;1920&quot; height=&quot;750&quot;&gt;\n          &lt;div class=&quot;carousel-caption d-none d-lg-flex&quot;&gt;\n            &lt;div class=&quot;container&quot;&gt;\n              &lt;div class=&quot;row&quot;&gt;\n                &lt;div class=&quot;col-md-5 text-start&quot;&gt;\n                  &lt;h1 class=&quot;mb-4 h2 slide-3-title&quot;&gt;SEO Friendly&lt;/h1&gt;\n                  &lt;h1 class=&quot;mb-4 h2 slide-3-title&quot;&gt;Fast Loadnig&lt;/h1&gt;\n                  &lt;p class=&quot;mb-4 text-white&quot;&gt;Natively responsive template implemented with bootstrap library and HTML5.\n                    Will look good on most mobile devices and tablets.&lt;/p&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-outline-light&quot;&gt;Try On\n                    Your Device&lt;/a&gt;\n                &lt;/div&gt;\n              &lt;/div&gt;\n            &lt;/div&gt;\n          &lt;/div&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;&lt;button class=&quot;carousel-control-prev&quot; type=&quot;button&quot; data-bs-target=&quot;#carouselExample&quot;\n        data-bs-slide=&quot;prev&quot;&gt;&lt;span class=&quot;header-arrow rounded-end&quot;&gt;&lt;i class=&quot;bi bi-arrow-left&quot;&gt;&lt;/i&gt;&lt;/span&gt;&lt;/button&gt;\n      &lt;button class=&quot;carousel-control-next&quot; type=&quot;button&quot; data-bs-target=&quot;#carouselExample&quot; data-bs-slide=&quot;next&quot;&gt;&lt;span\n          class=&quot;header-arrow rounded-start&quot;&gt;&lt;i class=&quot;bi bi-arrow-right&quot;&gt;&lt;/i&gt;&lt;/span&gt;&lt;/button&gt;\n    &lt;/div&gt;\n  &lt;/section&gt;', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]block_descriptions` VALUES
(13, 13, 1, '0', 0, 'Novator Icon block', 'Promo', '', '&lt;section&gt;\n  &lt;div class=&quot;container&quot;&gt;\n    &lt;div class=&quot;row g-4&quot;&gt;\n      &lt;div class=&quot;col-sm-6 col-lg-3&quot;&gt;\n        &lt;div class=&quot;icon-block-card rounded-3 p-4&quot;&gt;\n          &lt;svg xmlns=&quot;http://www.w3.org/2000/svg&quot; width=&quot;50&quot; height=&quot;49&quot; viewBox=&quot;0 0 50 49&quot;\n            fill=&quot;none&quot;&gt;\n            &lt;g clip-path=&quot;url(#clip0_375_6590)&quot;&gt;\n              &lt;path\n                d=&quot;M46.0698 22.1421L44.8009 17.0665C45.1478 16.9928 45.4081 16.685 45.4081 16.3163V15.4979C45.4081 13.7211 43.9625 12.2756 42.1858 12.2756H36.4061V10.5876C36.4061 9.71322 35.6948 9.00195 34.8205 9.00195H5.35904C4.48469 9.00195 3.77343 9.71322 3.77343 10.5876V24.4999C3.77343 24.9236 4.11691 25.2672 4.54068 25.2672C4.96436 25.2672 5.30793 24.9237 5.30793 24.4999V10.5876C5.30793 10.5593 5.33081 10.5365 5.35904 10.5365H34.8204C34.8486 10.5365 34.8715 10.5593 34.8715 10.5876V24.5001C34.8715 24.9238 35.215 25.2674 35.6387 25.2674C36.0624 25.2674 36.406 24.9239 36.406 24.5001V23.6304H45.4565C45.4573 23.6304 45.4579 23.6306 45.4585 23.6306C45.4593 23.6306 45.46 23.6305 45.4607 23.6305C46.5743 23.6312 47.52 24.3622 47.8448 25.3695H45.4591C45.0354 25.3695 44.6919 25.713 44.6919 26.1367V27.7735C44.6919 29.099 45.7703 30.1774 47.0958 30.1774H47.9654V33.5532H45.9593C45.3003 31.6503 43.4914 30.2796 41.3672 30.2796C39.2431 30.2796 37.4341 31.6503 36.7752 33.5532H36.4058V27.7734C36.4058 27.3497 36.0623 27.0061 35.6385 27.0061C35.2149 27.0061 34.8713 27.3496 34.8713 27.7734V33.553H18.9532C18.2942 31.6501 16.4853 30.2794 14.3612 30.2794C12.237 30.2794 10.428 31.6501 9.76913 33.553H5.35904C5.33081 33.553 5.30793 33.5301 5.30793 33.5019V31.8139H8.63256C9.05624 31.8139 9.39982 31.4705 9.39982 31.0467C9.39982 30.6229 9.05634 30.2794 8.63256 30.2794H1.26725C0.843574 30.2794 0.5 30.6229 0.5 31.0467C0.5 31.4705 0.843478 31.8139 1.26725 31.8139H3.77352V33.5019C3.77352 34.3762 4.48479 35.0875 5.35913 35.0875H9.50346C9.50327 35.1045 9.50212 35.1214 9.50212 35.1386C9.50212 37.8179 11.682 39.9976 14.3612 39.9976C17.0404 39.9976 19.2202 37.8179 19.2202 35.1386C19.2202 35.1213 19.219 35.1045 19.2189 35.0875H36.5095C36.5093 35.1045 36.5082 35.1214 36.5082 35.1386C36.5082 37.8179 38.688 39.9976 41.3672 39.9976C44.0464 39.9976 46.2263 37.8179 46.2263 35.1386C46.2263 35.1213 46.2251 35.1045 46.2249 35.0875H48.7326C49.1563 35.0875 49.4999 34.744 49.4999 34.3202V26.1365C49.5 24.1161 48.0092 22.4373 46.0698 22.1421ZM36.4061 13.81H42.1858C43.1165 13.81 43.8737 14.5672 43.8737 15.4979V15.549H36.4061V13.81ZM36.4061 22.096V17.0834H43.2235L44.4766 22.096H36.4061ZM14.3612 38.4634C12.528 38.4634 11.0365 36.9721 11.0365 35.1388C11.0365 33.3055 12.528 31.8141 14.3612 31.8141C16.1944 31.8141 17.6858 33.3055 17.6858 35.1388C17.6858 36.9721 16.1944 38.4634 14.3612 38.4634ZM41.3674 38.4634C39.5342 38.4634 38.0428 36.9721 38.0428 35.1388C38.0428 33.3055 39.5342 31.8141 41.3674 31.8141C43.2006 31.8141 44.6921 33.3055 44.6921 35.1388C44.6921 36.9721 43.2006 38.4634 41.3674 38.4634ZM47.9656 28.6429H47.096C46.6166 28.6429 46.2265 28.2528 46.2265 27.7734V26.9038H47.9655V28.6429H47.9656Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M14.363 33.5532C13.4886 33.5532 12.7773 34.2645 12.7773 35.1388C12.7773 36.0132 13.4886 36.7244 14.363 36.7244C15.2373 36.7244 15.9486 36.0132 15.9486 35.1388C15.9486 34.2645 15.2373 33.5532 14.363 33.5532Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M41.3669 33.5532C40.4925 33.5532 39.7812 34.2645 39.7812 35.1388C39.7812 36.0132 40.4925 36.7244 41.3669 36.7244C42.2412 36.7244 42.9525 36.0132 42.9525 35.1388C42.9525 34.2645 42.2412 33.5532 41.3669 33.5532Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M32.3651 30.2798H20.9079C20.4842 30.2798 20.1406 30.6233 20.1406 31.047C20.1406 31.4708 20.4841 31.8143 20.9079 31.8143H32.3651C32.7887 31.8143 33.1323 31.4708 33.1323 31.047C33.1323 30.6233 32.7888 30.2798 32.3651 30.2798Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M12.7245 27.0063H2.90397C2.48029 27.0063 2.13672 27.3498 2.13672 27.7736C2.13672 28.1974 2.4802 28.5409 2.90397 28.5409H12.7245C13.1481 28.5409 13.4917 28.1974 13.4917 27.7736C13.4917 27.3498 13.1481 27.0063 12.7245 27.0063Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M27.181 16.5918C26.8814 16.2923 26.3955 16.2923 26.096 16.5919L19.2731 23.4147L15.7238 19.8654C15.4241 19.5657 14.9383 19.5657 14.6388 19.8654C14.3392 20.165 14.3392 20.6507 14.6388 20.9504L18.7307 25.0422C18.8805 25.1921 19.0768 25.2669 19.2731 25.2669C19.4694 25.2669 19.6659 25.1921 19.8156 25.0422L27.1809 17.6769C27.4805 17.3772 27.4805 16.8915 27.181 16.5918Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n            &lt;/g&gt;\n            &lt;defs&gt;\n              &lt;clipPath id=&quot;clip0_375_6590&quot;&gt;\n                &lt;rect width=&quot;49&quot; height=&quot;49&quot; fill=&quot;white&quot; transform=&quot;translate(0.5)&quot; /&gt;\n              &lt;/clipPath&gt;\n            &lt;/defs&gt;\n          &lt;/svg&gt;\n          &lt;h2 class=&quot;feature-title mt-4 mb-3 d-block&quot;&gt;Free Shipping&lt;/h2&gt;\n          &lt;p class=&quot;mb-0&quot;&gt;A commerce solution for growing digital brands&lt;/p&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n      &lt;div class=&quot;col-sm-6 col-lg-3&quot;&gt;\n        &lt;div class=&quot;icon-block-card rounded-3 p-4&quot;&gt;&lt;svg xmlns=&quot;http://www.w3.org/2000/svg&quot; width=&quot;50&quot; height=&quot;49&quot; viewBox=&quot;0 0 50 49&quot;\n            fill=&quot;none&quot;&gt;\n            &lt;g clip-path=&quot;url(#clip0_375_6613)&quot;&gt;\n              &lt;path\n                d=&quot;M38.3789 8.12346C38.4002 8.12501 38.4215 8.12656 38.4432 8.12656C38.48 8.12656 38.5169 8.12346 38.5529 8.11842C39.5177 8.13819 40.2899 8.92509 40.2911 9.88991C40.2911 10.3283 40.6465 10.6838 41.0849 10.6838C41.5234 10.6838 41.8788 10.3283 41.8788 9.88991C41.8769 8.31185 40.7783 6.9466 39.2371 6.60703V5.84417C39.2371 5.40575 38.8816 5.05029 38.4432 5.05029C38.0048 5.05029 37.6493 5.40575 37.6493 5.84417V6.64308C36.0197 7.07879 34.9654 8.6553 35.1851 10.3279C35.4049 12.0006 36.8307 13.2511 38.5176 13.2511C39.4972 13.2511 40.2911 14.0454 40.2911 15.0249C40.2911 16.0041 39.4972 16.7983 38.5176 16.7983C37.5381 16.7983 36.7442 16.0041 36.7442 15.0249C36.7442 14.5865 36.3888 14.231 35.9503 14.231C35.5119 14.231 35.1565 14.5865 35.1565 15.0249C35.1584 16.546 36.1802 17.8767 37.6493 18.2717V19.1416C37.6493 19.58 38.0048 19.9355 38.4432 19.9355C38.8816 19.9355 39.2371 19.58 39.2371 19.1416V18.3082C40.9136 17.9411 42.0443 16.3696 41.8594 14.6632C41.6749 12.9569 40.2341 11.6637 38.5176 11.6641C37.5652 11.6645 36.7826 10.9125 36.745 9.96085C36.7078 9.00921 37.4292 8.19789 38.3789 8.12385V8.12346Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M38.5617 1.16895C33.6779 1.16895 29.51 4.35569 27.9486 8.62277H8.24477C7.80829 8.62277 7.454 9.01622 7.45089 9.45231L7.26328 37.3015H1.64684C1.20842 37.3015 0.832031 37.619 0.832031 38.0582V41.5923C0.84211 44.9193 3.46252 47.6526 6.7861 47.803V47.8204H31.297V47.7971C31.4955 47.8045 31.5773 47.8204 31.7029 47.8204H31.7199C35.1598 47.815 37.9457 45.0248 37.9457 41.5849V23.7165C38.1442 23.7274 38.3543 23.7332 38.5597 23.7332C44.7747 23.7332 49.8322 18.666 49.8322 12.4507C49.8322 6.23572 44.777 1.16895 38.5617 1.16895ZM7.08807 46.2327H7.08303C4.51495 46.2292 2.43141 44.1526 2.41978 41.5841V38.8893H25.4422V41.5729C25.4433 43.2296 26.105 44.8178 27.2803 45.9857C27.3637 46.0691 27.4672 46.1334 27.5544 46.2327H7.08807ZM36.358 41.5841C36.3584 44.148 34.2826 46.2276 31.7192 46.2327H31.704C29.1301 46.228 27.0427 44.1472 27.0299 41.5737V38.0582C27.0365 37.8551 26.959 37.6586 26.8152 37.5151C26.6714 37.3717 26.4748 37.2946 26.2721 37.3015H8.85103L9.03322 10.2105H27.5079C27.3672 10.9373 27.2943 11.6754 27.2904 12.4154C27.2889 13.9803 27.6153 15.5277 28.2487 16.9585H20.7503C20.3115 16.9585 19.9564 17.3139 19.9564 17.7523C19.9564 18.1908 20.3115 18.5462 20.7503 18.5462H29.11C30.7477 21.1217 33.3658 22.9172 36.358 23.518V41.5841ZM38.5617 22.1458C33.2139 22.1458 28.8782 17.8105 28.8786 12.4623C28.8786 7.1141 33.2139 2.77879 38.5621 2.77879C43.9099 2.77879 48.2452 7.11449 48.2452 12.4623C48.2394 17.8078 43.9076 22.14 38.5617 22.1458Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M15.6542 22.2422C14.2529 22.2422 13.1133 23.3458 13.1133 24.7025C13.1133 26.0592 14.2529 27.1628 15.6542 27.1628C17.0555 27.1628 18.1956 26.0592 18.1956 24.7025C18.1956 23.3458 17.0555 22.2422 15.6542 22.2422ZM15.6542 25.5751C15.1282 25.5751 14.701 25.1836 14.701 24.7025C14.701 24.2211 15.1286 23.8299 15.6542 23.8299C16.1799 23.8299 16.6078 24.2215 16.6078 24.7025C16.6078 25.1836 16.1799 25.5751 15.6542 25.5751Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M19.957 24.6987C19.957 25.1371 20.3121 25.4925 20.7509 25.4925H31.3349C31.7733 25.4925 32.1288 25.1371 32.1288 24.6987C32.1288 24.2602 31.7733 23.9048 31.3349 23.9048H20.7509C20.3121 23.9048 19.957 24.2602 19.957 24.6987Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M15.6542 15.3408C14.2529 15.3408 13.1133 16.4448 13.1133 17.8015C13.1133 19.1582 14.2529 20.2618 15.6542 20.2618C17.0555 20.2618 18.1956 19.1582 18.1956 17.8015C18.1956 16.4448 17.0555 15.3408 15.6542 15.3408ZM15.6542 18.6741C15.1282 18.6741 14.701 18.2826 14.701 17.8015C14.701 17.3205 15.1286 16.9286 15.6542 16.9286C16.1799 16.9286 16.6078 17.3201 16.6078 17.8015C16.6078 18.2826 16.1799 18.6745 15.6542 18.6745V18.6741Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M15.6542 29.1421C14.2529 29.1421 13.1133 30.2457 13.1133 31.6024C13.1133 32.9591 14.2529 34.0627 15.6542 34.0627C17.0555 34.0627 18.1956 32.9591 18.1956 31.6024C18.1956 30.2457 17.0555 29.1421 15.6542 29.1421ZM15.6542 32.475C15.1282 32.475 14.701 32.0838 14.701 31.6024C14.701 31.1214 15.1286 30.7298 15.6542 30.7298C16.1799 30.7298 16.6078 31.1214 16.6078 31.6024C16.6078 32.0835 16.1799 32.475 15.6542 32.475Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M31.3349 30.8516H20.7509C20.3121 30.8516 19.957 31.207 19.957 31.6454C19.957 32.0839 20.3121 32.4393 20.7509 32.4393H31.3349C31.7733 32.4393 32.1288 32.0839 32.1288 31.6454C32.1288 31.207 31.7733 30.8516 31.3349 30.8516Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n            &lt;/g&gt;\n            &lt;defs&gt;\n              &lt;clipPath id=&quot;clip0_375_6613&quot;&gt;\n                &lt;rect width=&quot;49&quot; height=&quot;49&quot; fill=&quot;white&quot; transform=&quot;translate(0.832031)&quot; /&gt;\n              &lt;/clipPath&gt;\n            &lt;/defs&gt;\n          &lt;/svg&gt;\n          &lt;h2 class=&quot;feature-title mt-4 mb-3 d-block&quot;&gt;Free Shipping&lt;/h2&gt;\n          &lt;p class=&quot;mb-0&quot;&gt;A commerce solution for growing digital brands&lt;/p&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n      &lt;div class=&quot;col-sm-6 col-lg-3&quot;&gt;\n        &lt;div class=&quot;icon-block-card rounded-3 p-4&quot;&gt;&lt;svg xmlns=&quot;http://www.w3.org/2000/svg&quot; width=&quot;50&quot; height=&quot;49&quot; viewBox=&quot;0 0 50 49&quot;\n            fill=&quot;none&quot;&gt;\n            &lt;path\n              d=&quot;M2.39507 24.5033C2.39447 20.3202 3.57194 16.2215 5.79264 12.6764C8.01334 9.13141 11.1875 6.28344 14.9516 4.45865C18.7158 2.63385 22.9178 1.906 27.0764 2.35844C31.235 2.81088 35.1821 4.42531 38.4658 7.01688H35.0773C34.7838 7.01972 34.5032 7.13832 34.2967 7.34688C34.0901 7.55545 33.9742 7.83712 33.9742 8.13066C33.9742 8.42419 34.0901 8.70586 34.2967 8.91443C34.5032 9.12299 34.7838 9.24159 35.0773 9.24443H41.3778C41.6732 9.24443 41.9565 9.12708 42.1654 8.9182C42.3742 8.70932 42.4916 8.42601 42.4916 8.1306V1.82992C42.493 1.68275 42.4653 1.53675 42.4099 1.40037C42.3546 1.26399 42.2728 1.13993 42.1692 1.03536C42.0656 0.930787 41.9424 0.847776 41.8065 0.791125C41.6707 0.734474 41.525 0.705305 41.3778 0.705305C41.2306 0.705305 41.0849 0.734474 40.9491 0.791125C40.8132 0.847776 40.69 0.930787 40.5864 1.03536C40.4829 1.13993 40.401 1.26399 40.3457 1.40037C40.2904 1.53675 40.2626 1.68275 40.264 1.82992V5.60149C35.4074 1.59511 29.195 -0.388149 22.9153 0.0630496C16.6356 0.514248 10.7705 3.36528 6.53652 8.02483C2.30253 12.6844 0.0245208 18.7949 0.174974 25.089C0.325427 31.383 2.8928 37.3777 7.34459 41.8296C7.44757 41.935 7.57043 42.0189 7.70605 42.0765C7.84168 42.134 7.98738 42.1641 8.13472 42.165C8.28205 42.1658 8.42809 42.1374 8.56437 42.0814C8.70065 42.0254 8.82447 41.943 8.92866 41.8388C9.03284 41.7346 9.11531 41.6108 9.1713 41.4745C9.22729 41.3382 9.25569 41.1922 9.25484 41.0448C9.25399 40.8975 9.22392 40.7518 9.16636 40.6162C9.1088 40.4805 9.0249 40.3577 8.91953 40.2547C6.84455 38.191 5.19949 35.7363 4.07957 33.0325C2.95965 30.3288 2.3871 27.4298 2.39507 24.5033Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M14.9353 44.5466C14.3034 44.2393 13.678 43.8973 13.0768 43.5308C12.8247 43.3769 12.5218 43.3295 12.2347 43.3989C11.9476 43.4683 11.6998 43.649 11.5459 43.9011C11.392 44.1532 11.3446 44.4561 11.414 44.7432C11.4835 45.0303 11.6641 45.278 11.9162 45.4319C12.5781 45.836 13.2665 46.2118 13.9621 46.55C14.0936 46.6139 14.2365 46.6513 14.3825 46.66C14.5284 46.6687 14.6747 46.6486 14.8129 46.6008C14.9511 46.5529 15.0786 46.4784 15.188 46.3813C15.2974 46.2842 15.3866 46.1666 15.4505 46.035C15.5144 45.9035 15.5518 45.7606 15.5605 45.6146C15.5692 45.4687 15.5491 45.3224 15.5013 45.1842C15.4534 45.046 15.3789 44.9185 15.2818 44.8091C15.1847 44.6997 15.0671 44.6105 14.9355 44.5466H14.9353Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M44.7226 14.7893C44.7863 14.921 44.8754 15.0387 44.9847 15.136C45.0939 15.2332 45.2213 15.3079 45.3594 15.3559C45.4976 15.4039 45.6439 15.4242 45.7899 15.4157C45.9359 15.4071 46.0788 15.3699 46.2104 15.3062C46.3421 15.2424 46.4598 15.1534 46.5571 15.0441C46.6543 14.9348 46.729 14.8074 46.777 14.6693C46.825 14.5311 46.8453 14.3849 46.8368 14.2388C46.8282 14.0928 46.791 13.9499 46.7273 13.8183C46.3917 13.1249 46.0165 12.4365 45.6125 11.7718C45.5364 11.6468 45.4365 11.5381 45.3185 11.4517C45.2004 11.3653 45.0665 11.3031 44.9244 11.2685C44.6373 11.1985 44.3343 11.2455 44.0819 11.3991C43.8295 11.5526 43.6484 11.8001 43.5785 12.0872C43.5086 12.3742 43.5556 12.6773 43.7091 12.9296C44.0765 13.5339 44.4175 14.1596 44.7226 14.7893Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M27.3149 46.6232C26.6117 46.7067 25.9004 46.7564 25.2 46.7733C24.91 46.7844 24.6357 46.9083 24.4357 47.1186C24.2357 47.3289 24.1256 47.6089 24.129 47.8991C24.1324 48.1893 24.2489 48.4668 24.4538 48.6723C24.6586 48.8779 24.9357 48.9954 25.2259 48.9997C25.2345 48.9997 25.2438 48.9997 25.2525 48.9992C26.0225 48.9812 26.804 48.9261 27.5762 48.8349C27.8693 48.8 28.1365 48.6502 28.3192 48.4183C28.5019 48.1865 28.5851 47.8916 28.5505 47.5985C28.5159 47.3054 28.3664 47.0379 28.1348 46.855C27.9031 46.672 27.6083 46.5885 27.3152 46.6228L27.3149 46.6232Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M20.9759 46.4721C20.2831 46.3563 19.5864 46.2056 18.9056 46.0231C18.6201 45.9468 18.3161 45.9871 18.0603 46.135C17.8045 46.2828 17.618 46.5263 17.5417 46.8117C17.4654 47.0971 17.5056 47.4012 17.6535 47.657C17.8014 47.9127 18.0448 48.0993 18.3303 48.1756C19.0796 48.3757 19.8464 48.5416 20.6094 48.6688C20.7536 48.6929 20.9012 48.6883 21.0437 48.6553C21.1862 48.6224 21.3208 48.5616 21.4398 48.4767C21.5588 48.3917 21.66 48.2841 21.7374 48.16C21.8148 48.0359 21.8671 47.8978 21.8911 47.7536C21.9152 47.6093 21.9106 47.4617 21.8776 47.3192C21.8447 47.1767 21.7839 47.0421 21.699 46.9231C21.614 46.8041 21.5064 46.703 21.3823 46.6255C21.2582 46.5481 21.1201 46.4959 20.9759 46.4718V46.4721Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M48.0789 23.9666C47.7837 23.9595 47.4976 24.0698 47.2837 24.2734C47.0698 24.477 46.9454 24.7573 46.938 25.0525C46.9201 25.7568 46.869 26.468 46.7852 27.1674C46.7503 27.4607 46.8332 27.7559 47.0159 27.9881C47.1985 28.2203 47.4658 28.3704 47.7591 28.4056C47.8035 28.4106 47.8482 28.4131 47.8929 28.4132C48.1651 28.4128 48.4277 28.3128 48.6312 28.1319C48.8347 27.9511 48.9649 27.7021 48.9973 27.4318C49.0887 26.6634 49.1453 25.8819 49.1644 25.1081C49.1681 24.9618 49.143 24.8163 49.0904 24.6798C49.0379 24.5433 48.959 24.4184 48.8582 24.3124C48.7574 24.2064 48.6367 24.1213 48.503 24.062C48.3692 24.0027 48.2252 23.9703 48.0789 23.9666Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M44.6596 36.7062C44.4152 36.5405 44.115 36.4786 43.825 36.5339C43.5349 36.5893 43.2787 36.7574 43.1124 37.0015C42.7165 37.5839 42.2885 38.1544 41.8393 38.6965C41.7438 38.8089 41.6716 38.939 41.6268 39.0795C41.582 39.22 41.5656 39.368 41.5785 39.5148C41.5913 39.6617 41.6332 39.8046 41.7018 39.9351C41.7703 40.0657 41.864 40.1813 41.9776 40.2754C42.0912 40.3694 42.2223 40.4399 42.3633 40.4829C42.5044 40.5258 42.6526 40.5403 42.7993 40.5255C42.946 40.5108 43.0883 40.467 43.2179 40.3968C43.3476 40.3266 43.462 40.2313 43.5545 40.1165C44.0483 39.5205 44.5198 38.8934 44.9548 38.2529C45.037 38.1319 45.0945 37.996 45.1242 37.8528C45.1538 37.7096 45.1549 37.562 45.1275 37.4184C45.1001 37.2748 45.0447 37.138 44.9644 37.0158C44.8841 36.8936 44.7806 36.7884 44.6596 36.7062Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M46.1975 18.7573C46.378 19.4354 46.5281 20.1321 46.6439 20.8281C46.6871 21.0881 46.821 21.3244 47.0219 21.4949C47.2229 21.6655 47.4777 21.7593 47.7413 21.7597C47.8027 21.7595 47.864 21.7544 47.9245 21.7444C48.0689 21.7205 48.207 21.6684 48.3312 21.591C48.4554 21.5137 48.5631 21.4126 48.6481 21.2936C48.7332 21.1747 48.7941 21.0401 48.8271 20.8976C48.8602 20.7551 48.8649 20.6075 48.8409 20.4632C48.7141 19.6975 48.5485 18.9304 48.3501 18.1841C48.2741 17.8986 48.0878 17.6551 47.8322 17.507C47.5767 17.3589 47.2727 17.3184 46.9873 17.3944C46.7019 17.4705 46.4583 17.6567 46.3102 17.9123C46.1621 18.1679 46.1217 18.4719 46.1977 18.7573H46.1975Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M38.8439 41.6894C38.2995 42.1397 37.7291 42.5676 37.1489 42.9608C37.0278 43.0429 36.9241 43.148 36.8437 43.2701C36.7633 43.3922 36.7077 43.529 36.6801 43.6726C36.6526 43.8163 36.6535 43.9639 36.683 44.1071C36.7125 44.2504 36.7699 44.3864 36.852 44.5074C36.934 44.6285 37.0391 44.7322 37.1613 44.8126C37.2834 44.893 37.4202 44.9486 37.5638 44.9762C37.7074 45.0038 37.8551 45.0028 37.9983 44.9733C38.1415 44.9438 38.2775 44.8864 38.3986 44.8043C39.0371 44.372 39.6641 43.9016 40.2633 43.4068C40.491 43.2186 40.6347 42.9476 40.6626 42.6534C40.6906 42.3593 40.6005 42.0661 40.4123 41.8384C40.2241 41.6107 39.9531 41.467 39.659 41.4391C39.3648 41.4111 39.0716 41.5012 38.8439 41.6894Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M47.2844 30.5821C47.003 30.4927 46.6977 30.5186 46.4354 30.6541C46.1731 30.7896 45.9752 31.0236 45.8853 31.3048C45.6721 31.9731 45.4231 32.6405 45.1451 33.2892C45.0844 33.4241 45.0511 33.5697 45.0473 33.7176C45.0434 33.8654 45.0691 34.0126 45.1227 34.1504C45.1764 34.2883 45.257 34.4141 45.3598 34.5204C45.4626 34.6268 45.5856 34.7116 45.7215 34.7699C45.8575 34.8282 46.0037 34.8588 46.1516 34.86C46.2995 34.8612 46.4462 34.8329 46.583 34.7767C46.7199 34.7206 46.8442 34.6377 46.9487 34.533C47.0532 34.4283 47.1357 34.3038 47.1916 34.1669C47.4984 33.4528 47.7724 32.7171 48.0067 31.9813C48.0513 31.842 48.0679 31.6953 48.0557 31.5496C48.0435 31.4038 48.0026 31.2619 47.9356 31.132C47.8685 31.0021 47.7764 30.8866 47.6647 30.7922C47.553 30.6979 47.4238 30.6265 47.2844 30.5821Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M33.436 44.9884C32.7938 45.2635 32.126 45.5121 31.4511 45.7274C31.3118 45.7718 31.1826 45.8433 31.0709 45.9376C30.9591 46.032 30.8671 46.1474 30.8 46.2773C30.7329 46.4073 30.692 46.5491 30.6797 46.6949C30.6674 46.8406 30.684 46.9873 30.7284 47.1266C30.7728 47.266 30.8442 47.3952 30.9386 47.5069C31.033 47.6186 31.1484 47.7107 31.2783 47.7778C31.4083 47.8449 31.5501 47.8858 31.6959 47.8981C31.8416 47.9103 31.9883 47.8938 32.1276 47.8494C32.8699 47.6128 33.6052 47.3393 34.3127 47.0364C34.5842 46.9201 34.7985 46.7007 34.9083 46.4264C35.0181 46.1521 35.0145 45.8455 34.8981 45.5739C34.7818 45.3023 34.5624 45.088 34.2881 44.9782C34.0138 44.8684 33.7072 44.8721 33.4356 44.9884H33.436Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M15.2525 22.2278C15.2525 20.4024 14.0522 18.9398 12.1946 18.5013C11.1742 18.2596 10.1019 18.3709 9.1528 18.8172C8.20375 19.2634 7.43397 20.0182 6.96913 20.9582C6.83897 21.2222 6.81859 21.527 6.91244 21.806C7.00629 22.085 7.20675 22.3154 7.47001 22.4471C7.73327 22.5787 8.03793 22.6008 8.31742 22.5085C8.59692 22.4162 8.82852 22.2171 8.96163 21.9545C9.19941 21.4611 9.5994 21.0642 10.0947 20.8302C10.59 20.5962 11.1506 20.5394 11.6828 20.6692C11.9977 20.7435 13.0249 21.0757 13.0249 22.2278C13.0249 23.3894 11.6833 24.2853 10.2629 25.234C8.66353 26.3015 6.85156 27.5115 6.85156 29.5149C6.85156 29.8103 6.96891 30.0936 7.17778 30.3025C7.38665 30.5113 7.66994 30.6287 7.96533 30.6287H14.1387C14.2859 30.6301 14.4318 30.6024 14.5682 30.547C14.7046 30.4917 14.8286 30.4099 14.9332 30.3063C15.0378 30.2028 15.1208 30.0795 15.1774 29.9437C15.2341 29.8078 15.2632 29.6621 15.2632 29.515C15.2632 29.3678 15.2341 29.2221 15.1774 29.0863C15.1208 28.9504 15.0378 28.8272 14.9332 28.7236C14.8286 28.6201 14.7046 28.5382 14.5682 28.4829C14.4318 28.4276 14.2859 28.3998 14.1387 28.4013H9.72624C10.1929 27.9592 10.8524 27.5187 11.4996 27.0863C13.259 25.9117 15.2525 24.5804 15.2525 22.2278Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M25.7825 25.895C25.7825 25.5997 25.6652 25.3164 25.4563 25.1076C25.2474 24.8987 24.9641 24.7814 24.6688 24.7814H23.7638V18.8647C23.7638 18.634 23.6921 18.409 23.5588 18.2208C23.4254 18.0326 23.2369 17.8905 23.0193 17.814C22.8017 17.7375 22.5657 17.7305 22.3439 17.7938C22.1221 17.8572 21.9255 17.9879 21.7811 18.1678L16.1429 25.1985C16.0117 25.3623 15.9295 25.5598 15.9056 25.7683C15.8818 25.9768 15.9173 26.1877 16.0082 26.3769C16.099 26.5661 16.2414 26.7258 16.4189 26.8376C16.5965 26.9493 16.8021 27.0087 17.0119 27.0088H21.5364V30.1412C21.535 30.2883 21.5627 30.4343 21.6181 30.5707C21.6734 30.7071 21.7552 30.8311 21.8588 30.9357C21.9623 31.0402 22.0856 31.1233 22.2214 31.1799C22.3572 31.2366 22.5029 31.2657 22.6501 31.2657C22.7973 31.2657 22.943 31.2366 23.0788 31.1799C23.2147 31.1233 23.3379 31.0402 23.4415 30.9357C23.545 30.8311 23.6268 30.7071 23.6822 30.5707C23.7375 30.4343 23.7653 30.2883 23.7638 30.1412V27.0088H24.6688C24.9642 27.0088 25.2474 26.8915 25.4563 26.6826C25.6652 26.4737 25.7825 26.1904 25.7825 25.895ZM21.5364 24.7814H19.3333L21.5364 22.0335V24.7814Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M31.4866 17.1465C31.3431 17.1176 31.1954 17.1172 31.0518 17.1454C30.9082 17.1737 30.7716 17.23 30.6499 17.3112C30.5281 17.3923 30.4235 17.4967 30.3422 17.6184C30.2609 17.7401 30.2044 17.8766 30.176 18.0202L27.6701 30.5496C27.6121 30.8392 27.6716 31.14 27.8354 31.3858C27.9992 31.6316 28.2539 31.8022 28.5435 31.8602C28.6157 31.8746 28.6892 31.8819 28.7628 31.8819C29.02 31.8816 29.2692 31.7923 29.4681 31.6292C29.6669 31.466 29.8032 31.239 29.8537 30.9868L32.3596 18.4573C32.3884 18.3139 32.3886 18.1663 32.3603 18.0228C32.332 17.8793 32.2757 17.7428 32.1947 17.621C32.1136 17.4993 32.0093 17.3948 31.8878 17.3133C31.7663 17.2319 31.63 17.1752 31.4866 17.1465Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n            &lt;path\n              d=&quot;M37.2009 30.6296C37.4209 30.6294 37.6359 30.5642 37.8189 30.4422C38.0018 30.3202 38.1446 30.1468 38.2293 29.9438L42.4058 19.9202C42.4764 19.751 42.5041 19.5669 42.4865 19.3844C42.4689 19.2018 42.4065 19.0265 42.3048 18.8739C42.2031 18.7213 42.0653 18.5962 41.9036 18.5097C41.7419 18.4231 41.5613 18.3779 41.378 18.3779H35.7397C35.4462 18.3808 35.1657 18.4994 34.9591 18.7079C34.7526 18.9165 34.6367 19.1981 34.6367 19.4916C34.6367 19.7852 34.7526 20.0668 34.9591 20.2754C35.1657 20.4839 35.4462 20.6025 35.7397 20.6054H39.7074L36.1736 29.0872C36.1034 29.2564 36.0759 29.4404 36.0936 29.6228C36.1113 29.8052 36.1737 29.9804 36.2753 30.1329C36.3769 30.2854 36.5145 30.4106 36.6759 30.4973C36.8374 30.584 37.0177 30.6296 37.2009 30.63V30.6296Z&quot;\n              fill=&quot;currentcolor&quot; /&gt;\n          &lt;/svg&gt;\n          &lt;h2 class=&quot;feature-title mt-4 mb-3 d-block&quot;&gt;Free Shipping&lt;/h2&gt;\n          &lt;p class=&quot;mb-0&quot;&gt;A commerce solution for growing digital brands&lt;/p&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n      &lt;div class=&quot;col-sm-6 col-lg-3&quot;&gt;\n        &lt;div class=&quot;icon-block-card rounded-3 p-4&quot;&gt;&lt;svg xmlns=&quot;http://www.w3.org/2000/svg&quot; width=&quot;50&quot; height=&quot;49&quot; viewBox=&quot;0 0 50 49&quot;\n            fill=&quot;none&quot;&gt;\n            &lt;g clip-path=&quot;url(#clip0_375_6645)&quot;&gt;\n              &lt;path\n                d=&quot;M46.2339 21.2334C45.5117 21.2361 44.8109 21.478 44.2408 21.9212C43.6708 22.3645 43.2637 22.9842 43.0832 23.6834H38.0672V17.15C38.0649 16.5766 37.8594 16.0225 37.4874 15.5861C37.4784 15.5739 37.4686 15.5632 37.4588 15.5518C37.0654 15.0998 36.5189 14.809 35.9243 14.7351L38.3636 12.2958C39.0474 12.6985 39.8546 12.8381 40.6339 12.6884C41.4132 12.5386 42.1112 12.1098 42.597 11.4824C43.0829 10.8549 43.3232 10.0718 43.273 9.2798C43.2229 8.48782 42.8856 7.74131 42.3245 7.18016C41.7025 6.58572 40.8753 6.25398 40.0149 6.25398C39.1546 6.25398 38.3274 6.58572 37.7054 7.18016C37.1915 7.68969 36.8633 8.35681 36.7733 9.07486C36.6833 9.7929 36.8367 10.5204 37.2089 11.141L33.6458 14.7H25.8172V6.4174C26.587 6.21862 27.2579 5.74591 27.7042 5.08786C28.1504 4.4298 28.3413 3.63159 28.2412 2.84285C28.141 2.0541 27.7566 1.32896 27.16 0.803366C26.5634 0.277769 25.7956 -0.012207 25.0005 -0.012207C24.2054 -0.012207 23.4376 0.277769 22.8411 0.803366C22.2445 1.32896 21.8601 2.0541 21.7599 2.84285C21.6597 3.63159 21.8506 4.4298 22.2969 5.08786C22.7431 5.74591 23.414 6.21862 24.1839 6.4174V14.7H16.3553L12.7922 11.1369C13.1644 10.5163 13.3177 9.78882 13.2277 9.07077C13.1377 8.35273 12.8095 7.68561 12.2956 7.17608C11.6737 6.58163 10.8465 6.24989 9.9861 6.24989C9.12575 6.24989 8.29853 6.58163 7.67657 7.17608C7.11005 7.73579 6.76812 8.48358 6.71536 9.27821C6.6626 10.0728 6.90267 10.8593 7.39022 11.489C7.87777 12.1186 8.57904 12.548 9.36156 12.6959C10.1441 12.8438 10.9537 12.7 11.6374 12.2917L14.0768 14.7311C13.4821 14.8049 12.9357 15.0957 12.5423 15.5477C12.5325 15.5592 12.5227 15.5698 12.5137 15.582C12.1406 16.0194 11.9351 16.5751 11.9339 17.15V23.6834H6.91788C6.71911 22.9135 6.2464 22.2426 5.58835 21.7964C4.93029 21.3501 4.13208 21.1592 3.34333 21.2594C2.55459 21.3596 1.82945 21.744 1.30385 22.3406C0.778257 22.9372 0.488281 23.7049 0.488281 24.5C0.488281 25.2951 0.778257 26.0629 1.30385 26.6595C1.82945 27.2561 2.55459 27.6405 3.34333 27.7407C4.13208 27.8408 4.93029 27.6499 5.58835 27.2037C6.2464 26.7575 6.71911 26.0865 6.91788 25.3167H11.9339V31.85C11.9357 32.4449 12.1543 33.0187 12.5487 33.464C12.9432 33.9093 13.4865 34.1955 14.0768 34.269L11.6268 36.719C11.0022 36.3665 10.281 36.2239 9.56925 36.3121C8.85752 36.4003 8.19292 36.7147 7.6733 37.209C7.23571 37.6403 6.9282 38.1859 6.78586 38.7835C6.64352 39.3812 6.67209 40.0068 6.86831 40.5891C7.06453 41.1713 7.42049 41.6866 7.89557 42.0761C8.37064 42.4657 8.94568 42.7139 9.55504 42.7923C10.1644 42.8707 10.7835 42.7762 11.3417 42.5196C11.9 42.2629 12.3748 41.8545 12.712 41.341C13.0492 40.8274 13.2352 40.2294 13.2488 39.6151C13.2624 39.0009 13.1031 38.3952 12.7889 37.8672L16.3553 34.3H24.1839V42.5827C23.414 42.7814 22.7431 43.2542 22.2969 43.9122C21.8506 44.5703 21.6597 45.3685 21.7599 46.1572C21.8601 46.946 22.2445 47.6711 22.8411 48.1967C23.4376 48.7223 24.2054 49.0123 25.0005 49.0123C25.7956 49.0123 26.5634 48.7223 27.16 48.1967C27.7566 47.6711 28.141 46.946 28.2412 46.1572C28.3413 45.3685 28.1504 44.5703 27.7042 43.9122C27.2579 43.2542 26.587 42.7814 25.8172 42.5827V34.3H33.6458L37.2089 37.8631C36.9006 38.389 36.7458 38.9907 36.7623 39.6C36.7787 40.2093 36.9656 40.8018 37.3018 41.3103C37.638 41.8187 38.11 42.2227 38.6642 42.4765C39.2184 42.7302 39.8327 42.8234 40.4373 42.7456C41.0418 42.6679 41.6125 42.4221 42.0844 42.0364C42.5564 41.6506 42.9107 41.1403 43.1072 40.5633C43.3038 39.9863 43.3346 39.3658 43.1962 38.7721C43.0579 38.1785 42.7559 37.6356 42.3245 37.2049C41.8049 36.7106 41.1403 36.3962 40.4285 36.308C39.7168 36.2198 38.9956 36.3624 38.371 36.7149L35.921 34.2649C36.5112 34.1922 37.0547 33.9069 37.4497 33.4624C37.8448 33.0179 38.0643 32.4447 38.0672 31.85V25.3167H43.0832C43.2369 25.9068 43.5531 26.4419 43.9958 26.8614C44.4384 27.2808 44.9898 27.5677 45.5873 27.6895C46.1848 27.8113 46.8045 27.7632 47.376 27.5505C47.9475 27.3378 48.4479 26.9692 48.8205 26.4864C49.193 26.0036 49.4227 25.426 49.4834 24.8193C49.5442 24.2125 49.4336 23.6009 49.1642 23.0538C48.8948 22.5067 48.4775 22.0461 47.9595 21.7243C47.4415 21.4026 46.8437 21.2325 46.2339 21.2334ZM23.3672 3.2667C23.3672 2.94365 23.463 2.62787 23.6425 2.35926C23.8219 2.09066 24.077 1.88132 24.3755 1.75769C24.6739 1.63407 25.0023 1.60172 25.3192 1.66475C25.636 1.72777 25.927 1.88333 26.1555 2.11175C26.3839 2.34018 26.5394 2.63121 26.6025 2.94805C26.6655 3.26488 26.6331 3.59329 26.5095 3.89175C26.3859 4.1902 26.1766 4.44529 25.908 4.62476C25.6394 4.80424 25.3236 4.90003 25.0005 4.90003C24.5673 4.90003 24.1519 4.72795 23.8456 4.42164C23.5393 4.11533 23.3672 3.69988 23.3672 3.2667ZM3.76718 26.1334C3.44414 26.1334 3.12835 26.0376 2.85975 25.8581C2.59115 25.6786 2.3818 25.4235 2.25818 25.1251C2.13456 24.8266 2.10221 24.4982 2.16524 24.1814C2.22826 23.8645 2.38382 23.5735 2.61224 23.3451C2.84067 23.1167 3.1317 22.9611 3.44854 22.8981C3.76537 22.8351 4.09378 22.8674 4.39223 22.991C4.69069 23.1146 4.94578 23.324 5.12525 23.5926C5.30472 23.8612 5.40052 24.177 5.40052 24.5C5.40052 24.9332 5.22844 25.3487 4.92213 25.655C4.61582 25.9613 4.20037 26.1334 3.76718 26.1334ZM26.6339 45.7334C26.6339 46.0564 26.5381 46.3722 26.3586 46.6408C26.1791 46.9094 25.924 47.1187 25.6256 47.2424C25.3271 47.366 24.9987 47.3983 24.6819 47.3353C24.365 47.2723 24.074 47.1167 23.8456 46.8883C23.6172 46.6599 23.4616 46.3688 23.3986 46.052C23.3356 45.7352 23.3679 45.4068 23.4915 45.1083C23.6151 44.8099 23.8245 44.5548 24.0931 44.3753C24.3617 44.1958 24.6775 44.1 25.0005 44.1C25.4337 44.1 25.8492 44.2721 26.1555 44.5784C26.4618 44.8847 26.6339 45.3002 26.6339 45.7334ZM31.5339 30.2167V32.6667H18.4672V30.2167C18.4672 29.5669 18.2091 28.9438 17.7496 28.4843C17.2901 28.0248 16.667 27.7667 16.0172 27.7667H13.5672V18.5808L16.2385 23.5878C16.5166 24.1105 16.9318 24.5477 17.4396 24.8522C17.9473 25.1568 18.5284 25.3174 19.1205 25.3167H20.1005C20.3171 25.3167 20.5248 25.2307 20.678 25.0775C20.8311 24.9243 20.9172 24.7166 20.9172 24.5C20.9172 24.2834 20.8311 24.0757 20.678 23.9226C20.5248 23.7694 20.3171 23.6834 20.1005 23.6834H19.1205C18.8243 23.6835 18.5336 23.6032 18.2795 23.4508C18.0255 23.2985 17.8177 23.0799 17.6783 22.8185L14.2352 16.3668C14.2835 16.3507 14.3333 16.3394 14.3839 16.3334H35.6172C35.6676 16.3384 35.7174 16.3485 35.7658 16.3636L32.3211 22.8193C32.1818 23.0803 31.9741 23.2986 31.7204 23.4507C31.4667 23.6029 31.1764 23.6833 30.8805 23.6834H29.9005C29.6839 23.6834 29.4762 23.7694 29.3231 23.9226C29.1699 24.0757 29.0839 24.2834 29.0839 24.5C29.0839 24.7166 29.1699 24.9243 29.3231 25.0775C29.4762 25.2307 29.6839 25.3167 29.9005 25.3167H30.8805C31.4727 25.3176 32.0538 25.1571 32.5616 24.8525C33.0694 24.5479 33.4846 24.1107 33.7625 23.5878L36.4339 18.58V27.7667H33.9839C33.3341 27.7667 32.7109 28.0248 32.2514 28.4843C31.792 28.9438 31.5339 29.5669 31.5339 30.2167ZM38.8602 8.33003C39.0119 8.17833 39.192 8.05799 39.3902 7.9759C39.5884 7.8938 39.8008 7.85154 40.0154 7.85154C40.2299 7.85154 40.4423 7.8938 40.6405 7.9759C40.8387 8.05799 41.0188 8.17833 41.1705 8.33003C41.3222 8.48173 41.4426 8.66182 41.5247 8.86003C41.6068 9.05823 41.649 9.27067 41.649 9.4852C41.649 9.69974 41.6068 9.91218 41.5247 10.1104C41.4426 10.3086 41.3222 10.4887 41.1705 10.6404C40.8595 10.9375 40.4459 11.1033 40.0158 11.1033C39.5856 11.1033 39.172 10.9375 38.861 10.6404C38.5548 10.3341 38.3828 9.91871 38.3828 9.48561C38.3828 9.05251 38.5548 8.63714 38.861 8.33085L38.8602 8.33003ZM8.83052 10.6404C8.60204 10.412 8.44643 10.1209 8.38337 9.80409C8.32031 9.48724 8.35263 9.15881 8.47623 8.86033C8.59984 8.56185 8.80919 8.30673 9.0778 8.12723C9.34641 7.94774 9.66222 7.85193 9.98529 7.85193C10.3083 7.85193 10.6242 7.94774 10.8928 8.12723C11.1614 8.30673 11.3707 8.56185 11.4943 8.86033C11.6179 9.15881 11.6503 9.48724 11.5872 9.80409C11.5241 10.1209 11.3685 10.412 11.1401 10.6404C10.829 10.9375 10.4154 11.1033 9.98529 11.1033C9.55514 11.1033 9.14155 10.9375 8.83052 10.6404ZM13.5672 31.85V29.4H16.0172C16.2338 29.4 16.4415 29.4861 16.5947 29.6392C16.7478 29.7924 16.8339 30.0001 16.8339 30.2167V32.6667H14.3839C14.1673 32.6667 13.9595 32.5807 13.8064 32.4275C13.6532 32.2743 13.5672 32.0666 13.5672 31.85ZM11.1409 40.67C10.8298 40.9672 10.4162 41.133 9.9861 41.133C9.55596 41.133 9.14236 40.9672 8.83134 40.67C8.60286 40.4416 8.44725 40.1506 8.38419 39.8337C8.32113 39.5169 8.35344 39.1885 8.47705 38.89C8.60066 38.5915 8.81001 38.3364 9.07862 38.1569C9.34723 37.9774 9.66304 37.8816 9.9861 37.8816C10.3092 37.8816 10.625 37.9774 10.8936 38.1569C11.1622 38.3364 11.3715 38.5915 11.4952 38.89C11.6188 39.1885 11.6511 39.5169 11.588 39.8337C11.525 40.1506 11.3693 40.4416 11.1409 40.67ZM40.0149 37.8819C40.338 37.8818 40.6538 37.9776 40.9225 38.157C41.1912 38.3364 41.4006 38.5914 41.5243 38.8899C41.648 39.1883 41.6804 39.5168 41.6174 39.8336C41.5544 40.1505 41.3989 40.4416 41.1705 40.67C40.8595 40.9672 40.4459 41.133 40.0158 41.133C39.5856 41.133 39.172 40.9672 38.861 40.67C38.6326 40.4416 38.4771 40.1506 38.4141 39.8338C38.3511 39.517 38.3835 39.1887 38.5071 38.8903C38.6307 38.5919 38.84 38.3368 39.1085 38.1573C39.377 37.9778 39.6928 37.882 40.0158 37.8819H40.0149ZM35.6172 32.6667H33.1672V30.2167C33.1672 30.0001 33.2532 29.7924 33.4064 29.6392C33.5595 29.4861 33.7673 29.4 33.9839 29.4H36.4339V31.85C36.4339 32.0666 36.3478 32.2743 36.1947 32.4275C36.0415 32.5807 35.8338 32.6667 35.6172 32.6667ZM46.2339 26.1334C45.9108 26.1334 45.595 26.0376 45.3264 25.8581C45.0578 25.6786 44.8485 25.4235 44.7249 25.1251C44.6012 24.8266 44.5689 24.4982 44.6319 24.1814C44.6949 23.8645 44.8505 23.5735 45.0789 23.3451C45.3073 23.1167 45.5984 22.9611 45.9152 22.8981C46.232 22.8351 46.5605 22.8674 46.8589 22.991C47.1574 23.1146 47.4125 23.324 47.5919 23.5926C47.7714 23.8612 47.8672 24.177 47.8672 24.5C47.8672 24.9332 47.6951 25.3487 47.3888 25.655C47.0825 25.9613 46.667 26.1334 46.2339 26.1334Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n              &lt;path\n                d=&quot;M24.9997 23.6834C24.8564 23.6833 24.7156 23.6454 24.5916 23.5737C24.4675 23.5019 24.3645 23.3988 24.2929 23.2746C24.2214 23.1504 24.1837 23.0096 24.1838 22.8663C24.1839 22.7229 24.2217 22.5822 24.2934 22.4581C24.3652 22.334 24.4683 22.231 24.5924 22.1594C24.7166 22.0877 24.8574 22.0501 25.0007 22.0501C25.144 22.0501 25.2848 22.0879 25.4089 22.1596C25.533 22.2312 25.6361 22.3343 25.7078 22.4584C25.8195 22.639 25.9971 22.769 26.203 22.8208C26.4089 22.8726 26.6269 22.8421 26.8108 22.7359C26.9946 22.6297 27.1299 22.4561 27.1879 22.2518C27.2459 22.0475 27.222 21.8287 27.1214 21.6418C26.8257 21.1446 26.3633 20.7684 25.8164 20.5801V20.4168C25.8164 20.2002 25.7303 19.9924 25.5772 19.8393C25.424 19.6861 25.2163 19.6001 24.9997 19.6001C24.7831 19.6001 24.5754 19.6861 24.4222 19.8393C24.2691 19.9924 24.183 20.2002 24.183 20.4168V20.567C23.6386 20.7588 23.1796 21.1371 22.8873 21.6348C22.595 22.1326 22.4883 22.7178 22.5861 23.2867C22.684 23.8556 22.9799 24.3715 23.4217 24.7431C23.8635 25.1146 24.4225 25.3179 24.9997 25.3168C25.143 25.3169 25.2838 25.3548 25.4078 25.4265C25.5319 25.4983 25.6349 25.6014 25.7065 25.7256C25.778 25.8498 25.8157 25.9906 25.8156 26.1339C25.8155 26.2773 25.7777 26.418 25.706 26.5421C25.6342 26.6662 25.5311 26.7692 25.407 26.8408C25.2828 26.9124 25.142 26.9501 24.9987 26.9501C24.8554 26.9501 24.7146 26.9123 24.5905 26.8406C24.4664 26.769 24.3633 26.6659 24.2917 26.5418C24.1799 26.3612 24.0023 26.2312 23.7964 26.1794C23.5905 26.1276 23.3725 26.1581 23.1886 26.2643C23.0048 26.3705 22.8695 26.5441 22.8115 26.7484C22.7535 26.9526 22.7774 27.1715 22.878 27.3584C23.1741 27.8559 23.6371 28.2321 24.1847 28.4201V28.5834C24.1847 28.8 24.2707 29.0077 24.4239 29.1609C24.577 29.3141 24.7847 29.4001 25.0013 29.4001C25.2179 29.4001 25.4257 29.3141 25.5788 29.1609C25.732 29.0077 25.818 28.8 25.818 28.5834V28.4332C26.3626 28.2414 26.8217 27.8629 27.114 27.365C27.4062 26.867 27.5128 26.2817 27.4148 25.7127C27.3167 25.1437 27.0205 24.6278 26.5784 24.2563C26.1364 23.8849 25.5771 23.6819 24.9997 23.6834Z&quot;\n                fill=&quot;currentcolor&quot; /&gt;\n            &lt;/g&gt;\n            &lt;defs&gt;\n              &lt;clipPath id=&quot;clip0_375_6645&quot;&gt;\n                &lt;rect width=&quot;49&quot; height=&quot;49&quot; fill=&quot;white&quot; transform=&quot;translate(0.5)&quot; /&gt;\n              &lt;/clipPath&gt;\n            &lt;/defs&gt;\n          &lt;/svg&gt;\n          &lt;h2 class=&quot;feature-title mt-4 mb-3 d-block&quot;&gt;Free Shipping&lt;/h2&gt;\n          &lt;p class=&quot;mb-0&quot;&gt;A commerce solution for growing digital brands&lt;/p&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n  &lt;/div&gt;\n&lt;/section&gt;', '[[regtime]]', '[[regtime]]'),
(14, 14, 1, '0', 0, 'Novator Featured Banner', 'Featured Banner 1', 'Featured Banner2', '&lt;section&gt;\n&lt;div class=&quot;container&quot;&gt;\n  &lt;div class=&quot;row sec-heading-block justify-content-center text-center&quot;&gt;\n    &lt;div class=&quot;col-xl-8&quot;&gt;\n      &lt;h2&gt;Featured Banner&lt;/h2&gt;\n    &lt;/div&gt;\n  &lt;/div&gt;\n  &lt;div class=&quot;row g-4&quot;&gt;\n    &lt;div class=&quot;col-md-4&quot;&gt;\n      &lt;div class=&quot;banner-card&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/7.png&quot; alt=&quot;images&quot;\n          class=&quot;img-fluid w-100 h-auto&quot; width=&quot;100&quot; height=&quot;100&quot;&gt;\n        &lt;div class=&quot;banner-overlay&quot;&gt;\n          &lt;h2 class=&quot;banner-title text-white&quot;&gt;Hawaiian Shirts&lt;/h2&gt;&lt;span class=&quot;banner-text text-white&quot;&gt;Dress up in\n            summer vibe&lt;/span&gt;\n          &lt;h3 class=&quot;banner-sales text-white&quot;&gt;UPTO 50% OFF&lt;/h3&gt;\n          &lt;div class=&quot;banner-arrow text-white&quot;&gt;&lt;i class=&quot;bi bi-arrow-down&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;a href=&quot;#&quot;\n            class=&quot;btn btn-outline-light&quot;&gt;SHOP NOW&lt;/a&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;col-md-4&quot;&gt;\n      &lt;div class=&quot;banner-card&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/8.png&quot; alt=&quot;images&quot;\n          class=&quot;img-fluid w-100 h-auto&quot; width=&quot;100&quot; height=&quot;100&quot;&gt;\n        &lt;div class=&quot;banner-overlay right text-end&quot;&gt;\n          &lt;h2 class=&quot;banner-title text-white&quot;&gt;Printed T-Shirt&lt;/h2&gt;&lt;span class=&quot;banner-text text-white&quot;&gt;New Designs\n            Every Week&lt;/span&gt;\n          &lt;h3 class=&quot;banner-sales text-white&quot;&gt;UPTO 40% OFF&lt;/h3&gt;\n          &lt;div class=&quot;banner-arrow text-white&quot;&gt;&lt;i class=&quot;bi bi-arrow-down&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;a href=&quot;#&quot;\n            class=&quot;btn btn-outline-light&quot;&gt;SHOP NOW&lt;/a&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;col-md-4&quot;&gt;\n      &lt;div class=&quot;banner-card&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/9.png&quot; alt=&quot;images&quot;\n          class=&quot;img-fluid w-100 h-auto&quot; width=&quot;100&quot; height=&quot;100&quot;&gt;\n        &lt;div class=&quot;banner-overlay right&quot;&gt;\n          &lt;h2 class=&quot;banner-title&quot;&gt;Cargo Joggers&lt;/h2&gt;&lt;span class=&quot;banner-text&quot;&gt;Move with style &amp; comfort&lt;/span&gt;\n          &lt;h3 class=&quot;banner-sales&quot;&gt;UPTO 50% OFF&lt;/h3&gt;\n          &lt;div class=&quot;banner-arrow&quot;&gt;&lt;i class=&quot;bi bi-arrow-down&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-outline-dark&quot;&gt;SHOP\n            NOW&lt;/a&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;col-md-6&quot;&gt;\n      &lt;div class=&quot;banner-card&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/a.png&quot; alt=&quot;images&quot;\n          class=&quot;img-fluid w-100 h-auto&quot; width=&quot;100&quot; height=&quot;100&quot;&gt;\n        &lt;div class=&quot;banner-overlay right big&quot;&gt;\n          &lt;h2 class=&quot;banner-title&quot;&gt;Urban Shirts&lt;/h2&gt;&lt;span class=&quot;banner-text&quot;&gt;Live In Confort&lt;/span&gt;\n          &lt;h3 class=&quot;banner-sales&quot;&gt;FLAT 60% OFF&lt;/h3&gt;\n          &lt;div class=&quot;banner-arrow&quot;&gt;&lt;i class=&quot;bi bi-arrow-down&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-outline-dark&quot;&gt;SHOP\n            NOW&lt;/a&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;col-md-6&quot;&gt;\n      &lt;div class=&quot;banner-card&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/b.png&quot; alt=&quot;images&quot;\n          class=&quot;img-fluid w-100 h-auto&quot; width=&quot;100&quot; height=&quot;100&quot;&gt;\n        &lt;div class=&quot;banner-overlay right big&quot;&gt;\n          &lt;h2 class=&quot;banner-title&quot;&gt;Oversized T-Shirts&lt;/h2&gt;&lt;span class=&quot;banner-text&quot;&gt;Street Style Icon&lt;/span&gt;\n          &lt;h3 class=&quot;banner-sales&quot;&gt;FLAT 60% OFF&lt;/h3&gt;\n          &lt;div class=&quot;banner-arrow&quot;&gt;&lt;i class=&quot;bi bi-arrow-down&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-outline-dark&quot;&gt;SHOP\n            NOW&lt;/a&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n  &lt;/div&gt;\n&lt;/div&gt;\n&lt;/section&gt;', '[[regtime]]', '[[regtime]]'),
(15, 15, 1, '0', 0, 'Novator Making Commerce', 'Making Commerce', 'Making Commerce', '&lt;section class=&quot;cta position-relative&quot;&gt;\n  &lt;div class=&quot;cta-data&quot;&gt;\n    &lt;div class=&quot;container&quot;&gt;\n      &lt;div class=&quot;row g-4&quot;&gt;\n        &lt;div class=&quot;col-lg-6&quot;&gt;\n          &lt;div class=&quot;cta-content&quot;&gt;\n          &lt;h2 class=&quot;text-white&quot;&gt;Making Commerce&lt;br&gt;Better for Everyone&lt;/h2&gt;\n          &lt;div class=&quot;cta-price text-white&quot;&gt;&lt;small class=&quot;me-2&quot;&gt;Start From&lt;/small&gt; $56&lt;/div&gt;&lt;br&gt;&lt;a href=&quot;#&quot;\n            class=&quot;cta-btn btn btn-warning&quot;&gt;Try Now&lt;/a&gt;\n          &lt;/div&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n  &lt;/div&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/c.png&quot; alt=&quot;images&quot; class=&quot;w-100 h-auto img-fluid d-none d-lg-block&quot;\n    width=&quot;1920&quot; height=&quot;612&quot;&gt; &lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7a/d.png&quot; alt=&quot;images&quot;\n    class=&quot;w-100 h-auto img-fluid d-block d-lg-none&quot; width=&quot;1920&quot; height=&quot;612&quot;&gt;\n&lt;/section&gt;', '[[regtime]]', '[[regtime]]'),
(16, 16, 1, '0', 0, 'Novator See Our Most Featured Product', 'See Our Most Featured Product', '', '&lt;section class=&quot;pt-0&quot;&gt;\n    &lt;div class=&quot;container&quot;&gt;\n      &lt;div class=&quot;row title justify-content-center text-center&quot;&gt;\n        &lt;div class=&quot;col-12&quot;&gt;\n          &lt;h2&gt;See Our Most Featured Product&lt;/h2&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;col-12 text-center mt-4&quot;&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-warning&quot;&gt;Get Started&lt;/a&gt;&lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n  &lt;/section&gt;', '[[regtime]]', '[[regtime]]'),
(17, 17, 1, 'blocks/listing_block/popular_brands_content_bottom.tpl', 1, 'Novator Brands Scrolling List', 'Brands Scrolling List', 'Brands Scrolling ListBrands Scrolling List', 'a:2:{s:18:"listing_datasource";s:33:"catalog_category_getmanufacturers";s:5:"limit";s:0:"";}', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]block_descriptions` VALUES
(18, 18, 1, '0', 0, 'Novator Testimonials', 'Novator Testimonials', '', '&lt;section class=&quot;comment-section&quot;&gt;\n    &lt;div class=&quot;container&quot;&gt;\n      &lt;div class=&quot;row title justify-content-center sec-heading-block&quot;&gt;\n        &lt;div class=&quot;col-xl-8&quot;&gt;\n          &lt;h2 class=&quot;text-center&quot;&gt;What Our Clients Say About Us&lt;/h2&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n      &lt;div class=&quot;comment-carousel owl-carousel owl-theme&quot;&gt;\n        &lt;div class=&quot;item&quot;&gt;\n          &lt;div class=&quot;card comment-card&quot;&gt;\n            &lt;div class=&quot;row g-0 align-items-center&quot;&gt;\n              &lt;div class=&quot;col-4&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/6.png&quot; class=&quot;img-fluid rounded-start&quot;\n                  alt=&quot;images&quot;&gt;&lt;/div&gt;\n              &lt;div class=&quot;col-8&quot;&gt;\n                &lt;div class=&quot;card-body&quot;&gt;&lt;span&gt;On reviewcentre.com&lt;/span&gt;\n                  &lt;h3 class=&quot;h4&quot;&gt;Lorem ipsum it amet, consectetur adipiscing elit.&lt;/h3&gt;\n                  &lt;p class=&quot;text-muted&quot;&gt;&quot; I was working with many shopping carts, free and hosted for my clients. There\n                    is always something missing. In abantecart I find this gap to be much less. Interface is very easy\n                    to use and support is very responsive. This is considering its is free. Go abantecart go!&quot;&lt;/p&gt;\n                  &lt;p class=&quot;text-primary mb-0&quot;&gt;TopShop&lt;/p&gt;\n                &lt;/div&gt;\n              &lt;/div&gt;\n            &lt;/div&gt;\n          &lt;/div&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;item&quot;&gt;\n          &lt;div class=&quot;card comment-card&quot;&gt;\n            &lt;div class=&quot;row g-0 align-items-center&quot;&gt;\n              &lt;div class=&quot;col-4&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/7.png&quot; class=&quot;img-fluid rounded-start&quot;\n                  alt=&quot;images&quot;&gt;&lt;/div&gt;\n              &lt;div class=&quot;col-8&quot;&gt;\n                &lt;div class=&quot;card-body&quot;&gt;&lt;span&gt;On reviewcentre.com&lt;/span&gt;\n                  &lt;h3 class=&quot;h4&quot;&gt;Lorem ipsum it amet, consectetur adipiscing elit.&lt;/h3&gt;\n                  &lt;p class=&quot;text-muted&quot;&gt;&quot; I was working with many shopping carts, free and hosted for my clients. There\n                    is always something missing. In abantecart I find this gap to be much less. Interface is very easy\n                    to use and support is very responsive. This is considering its is free. Go abantecart go!&quot;&lt;/p&gt;\n                  &lt;p class=&quot;text-primary mb-0&quot;&gt;TopShop&lt;/p&gt;\n                &lt;/div&gt;\n              &lt;/div&gt;\n            &lt;/div&gt;\n          &lt;/div&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;item&quot;&gt;\n          &lt;div class=&quot;card comment-card&quot;&gt;\n            &lt;div class=&quot;row g-0 align-items-center&quot;&gt;\n              &lt;div class=&quot;col-4&quot;&gt;&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/8.png&quot; class=&quot;img-fluid rounded-start&quot;\n                  alt=&quot;images&quot;&gt;&lt;/div&gt;\n              &lt;div class=&quot;col-8&quot;&gt;\n                &lt;div class=&quot;card-body&quot;&gt;&lt;span&gt;On reviewcentre.com&lt;/span&gt;\n                  &lt;h3 class=&quot;h4&quot;&gt;Lorem ipsum it amet, consectetur adipiscing elit.&lt;/h3&gt;\n                  &lt;p class=&quot;text-muted&quot;&gt;&quot; I was working with many shopping carts, free and hosted for my clients. There\n                    is always something missing. In abantecart I find this gap to be much less. Interface is very easy\n                    to use and support is very responsive. This is considering its is free. Go abantecart go!&quot;&lt;/p&gt;\n                  &lt;p class=&quot;text-primary mb-0&quot;&gt;TopShop&lt;/p&gt;\n                &lt;/div&gt;\n              &lt;/div&gt;\n            &lt;/div&gt;\n          &lt;/div&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;\n    &lt;/div&gt;\n  &lt;/section&gt;\n&lt;script&gt;\n$(document).ready(function () {\n      var owl = $(''.comment-carousel'');\n      owl.owlCarousel({\n        loop: true,\n        margin: 24,\n        navText: [''&lt;i class=&quot;bi bi-chevron-left&quot;&gt;&lt;/i&gt;'', ''&lt;i class=&quot;bi bi-chevron-right&quot;&gt;&lt;/i&gt;''],\n        nav: true,\n        center: true,\n        autoWidth: true,\n        items: 1.8\n      });\n    });\n&lt;/script&gt;', '[[regtime]]', '[[regtime]]'),
(19, 19, 1, '0', 0, 'Novator Left banner 1', 'Left banner 1', '', '&lt;div class=&quot;left-right-banner card p-0 border-0&quot;&gt;\n&lt;a href=&quot;#&quot;&gt;\n  &lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/a.jpg&quot; class=&quot;img-fluid&quot;&gt;\n&lt;/a&gt;\n&lt;/div&gt;', '[[regtime]]', '[[regtime]]'),
(20, 20, 1, '0', 0, 'Novator Left banner 2', 'Left banner 2', '', '&lt;div class=&quot;left-right-banner card p-0 border-0&quot;&gt;\n&lt;a href=&quot;#&quot;&gt;\n&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/b.jpg&quot; class=&quot;img-fluid&quot;&gt;\n&lt;/a&gt;\n&lt;/div&gt;', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_layouts`
--

CREATE TABLE `[[dbprefix]]block_layouts` (
  `instance_id` int NOT NULL AUTO_INCREMENT,
  `layout_id` int NOT NULL DEFAULT '0',
  `block_id` int NOT NULL DEFAULT '0',
  `custom_block_id` int NOT NULL DEFAULT '0',
  `parent_instance_id` int NOT NULL DEFAULT '0',
  `position` smallint NOT NULL DEFAULT '0',
  `status` smallint NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`instance_id`),
  UNIQUE KEY `[[dbprefix]]block_layouts_idx` (`instance_id`,`layout_id`,`block_id`,`parent_instance_id`,`custom_block_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=887 ;

--
-- Dumping data for table `[[dbprefix]]block_layouts`
--

INSERT INTO `[[dbprefix]]block_layouts` VALUES
(1, 1, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(2, 1, 15, 0, 1, 10, 1, '[[regtime]]', '[[regtime]]'),
(3, 1, 31, 0, 1, 20, 1, '[[regtime]]', '[[regtime]]'),
(4, 1, 27, 0, 1, 30, 1, '[[regtime]]', '[[regtime]]'),
(5, 1, 26, 0, 1, 40, 1, '[[regtime]]', '[[regtime]]'),
(6, 1, 13, 0, 1, 50, 1, '[[regtime]]', '[[regtime]]'),
(7, 1, 14, 0, 1, 60, 1, '[[regtime]]', '[[regtime]]'),
(8, 1, 17, 1, 1, 70, 1, '[[regtime]]', '[[regtime]]'),
(9, 1, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(10, 1, 9, 0, 9, 10, 1, '[[regtime]]', '[[regtime]]'),
(11, 1, 28, 0, 9, 20, 1, '[[regtime]]', '[[regtime]]'),
(12, 1, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(13, 1, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(14, 1, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(15, 1, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(16, 1, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(17, 1, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(18, 1, 17, 2, 17, 10, 1, '[[regtime]]', '[[regtime]]'),
(19, 1, 17, 3, 17, 20, 1, '[[regtime]]', '[[regtime]]'),
(20, 1, 17, 4, 17, 30, 1, '[[regtime]]', '[[regtime]]'),
(21, 1, 25, 0, 17, 40, 1, '[[regtime]]', '[[regtime]]'),
(22, 1, 11, 0, 17, 50, 1, '[[regtime]]', '[[regtime]]'),
(23, 1, 17, 1, 17, 60, 1, '[[regtime]]', '[[regtime]]'),
(24, 1, 24, 0, 17, 70, 1, '[[regtime]]', '[[regtime]]'),
(25, 1, 21, 0, 17, 80, 1, '[[regtime]]', '[[regtime]]'),
(26, 2, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(27, 2, 15, 0, 26, 10, 1, '[[regtime]]', '[[regtime]]'),
(28, 2, 31, 0, 26, 20, 1, '[[regtime]]', '[[regtime]]'),
(29, 2, 27, 0, 26, 30, 1, '[[regtime]]', '[[regtime]]'),
(30, 2, 26, 0, 26, 40, 1, '[[regtime]]', '[[regtime]]'),
(31, 2, 13, 0, 26, 50, 1, '[[regtime]]', '[[regtime]]'),
(32, 2, 14, 0, 26, 60, 1, '[[regtime]]', '[[regtime]]'),
(33, 2, 17, 1, 26, 70, 1, '[[regtime]]', '[[regtime]]'),
(34, 2, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(35, 2, 9, 0, 34, 10, 1, '[[regtime]]', '[[regtime]]'),
(36, 2, 17, 5, 34, 20, 1, '[[regtime]]', '[[regtime]]'),
(37, 2, 17, 6, 34, 30, 1, '[[regtime]]', '[[regtime]]'),
(38, 2, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(39, 2, 12, 0, 38, 10, 1, '[[regtime]]', '[[regtime]]'),
(40, 2, 4, 0, 0, 40, 0, '[[regtime]]', '[[regtime]]'),
(41, 2, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(42, 2, 19, 0, 41, 10, 1, '[[regtime]]', '[[regtime]]'),
(43, 2, 12, 0, 41, 20, 1, '[[regtime]]', '[[regtime]]'),
(44, 2, 18, 0, 41, 30, 1, '[[regtime]]', '[[regtime]]'),
(45, 2, 22, 0, 41, 40, 1, '[[regtime]]', '[[regtime]]'),
(46, 2, 6, 0, 0, 60, 0, '[[regtime]]', '[[regtime]]'),
(47, 2, 12, 0, 46, 10, 1, '[[regtime]]', '[[regtime]]'),
(48, 2, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(49, 2, 23, 7, 48, 10, 1, '[[regtime]]', '[[regtime]]'),
(50, 2, 20, 8, 48, 20, 1, '[[regtime]]', '[[regtime]]'),
(51, 2, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(52, 2, 17, 2, 51, 10, 1, '[[regtime]]', '[[regtime]]'),
(53, 2, 17, 3, 51, 20, 1, '[[regtime]]', '[[regtime]]'),
(54, 2, 17, 4, 51, 30, 1, '[[regtime]]', '[[regtime]]'),
(55, 2, 25, 0, 51, 40, 1, '[[regtime]]', '[[regtime]]'),
(56, 2, 11, 0, 51, 50, 1, '[[regtime]]', '[[regtime]]'),
(57, 2, 17, 1, 51, 60, 1, '[[regtime]]', '[[regtime]]'),
(58, 2, 24, 0, 51, 70, 1, '[[regtime]]', '[[regtime]]'),
(59, 2, 21, 0, 51, 80, 1, '[[regtime]]', '[[regtime]]'),
(60, 3, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(61, 3, 15, 0, 60, 10, 1, '[[regtime]]', '[[regtime]]'),
(62, 3, 31, 0, 60, 20, 1, '[[regtime]]', '[[regtime]]'),
(63, 3, 27, 0, 60, 30, 1, '[[regtime]]', '[[regtime]]'),
(64, 3, 26, 0, 60, 40, 1, '[[regtime]]', '[[regtime]]'),
(65, 3, 13, 0, 60, 50, 1, '[[regtime]]', '[[regtime]]'),
(66, 3, 14, 0, 60, 60, 1, '[[regtime]]', '[[regtime]]'),
(67, 3, 17, 1, 60, 70, 1, '[[regtime]]', '[[regtime]]'),
(68, 3, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(69, 3, 9, 0, 68, 10, 1, '[[regtime]]', '[[regtime]]'),
(70, 3, 28, 0, 68, 20, 1, '[[regtime]]', '[[regtime]]'),
(71, 3, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(72, 3, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(73, 3, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(74, 3, 6, 0, 0, 60, 0, '[[regtime]]', '[[regtime]]'),
(75, 3, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(76, 3, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(77, 3, 17, 2, 76, 10, 1, '[[regtime]]', '[[regtime]]'),
(78, 3, 17, 3, 76, 20, 1, '[[regtime]]', '[[regtime]]'),
(79, 3, 17, 4, 76, 30, 1, '[[regtime]]', '[[regtime]]'),
(80, 3, 25, 0, 76, 40, 1, '[[regtime]]', '[[regtime]]'),
(81, 3, 11, 0, 76, 50, 1, '[[regtime]]', '[[regtime]]'),
(82, 3, 17, 1, 76, 60, 1, '[[regtime]]', '[[regtime]]'),
(83, 3, 24, 0, 76, 70, 1, '[[regtime]]', '[[regtime]]'),
(84, 3, 21, 0, 76, 80, 1, '[[regtime]]', '[[regtime]]'),
(85, 4, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(86, 4, 15, 0, 85, 10, 1, '[[regtime]]', '[[regtime]]'),
(87, 4, 31, 0, 85, 20, 1, '[[regtime]]', '[[regtime]]'),
(88, 4, 27, 0, 85, 30, 1, '[[regtime]]', '[[regtime]]'),
(89, 4, 26, 0, 85, 40, 1, '[[regtime]]', '[[regtime]]'),
(90, 4, 13, 0, 85, 50, 1, '[[regtime]]', '[[regtime]]'),
(91, 4, 14, 0, 85, 60, 1, '[[regtime]]', '[[regtime]]'),
(92, 4, 17, 1, 85, 70, 1, '[[regtime]]', '[[regtime]]'),
(93, 4, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(94, 4, 9, 0, 93, 10, 1, '[[regtime]]', '[[regtime]]'),
(95, 4, 28, 0, 93, 20, 1, '[[regtime]]', '[[regtime]]'),
(96, 4, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(97, 4, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(98, 4, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(99, 4, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(100, 4, 37, 0, 99, 10, 1, '[[regtime]]', '[[regtime]]'),
(101, 4, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(102, 4, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(103, 4, 17, 2, 102, 10, 1, '[[regtime]]', '[[regtime]]'),
(104, 4, 17, 3, 102, 20, 1, '[[regtime]]', '[[regtime]]'),
(105, 4, 17, 4, 102, 30, 1, '[[regtime]]', '[[regtime]]'),
(106, 4, 25, 0, 102, 40, 1, '[[regtime]]', '[[regtime]]'),
(107, 4, 11, 0, 102, 50, 1, '[[regtime]]', '[[regtime]]'),
(108, 4, 17, 1, 102, 60, 1, '[[regtime]]', '[[regtime]]'),
(109, 4, 24, 0, 102, 70, 1, '[[regtime]]', '[[regtime]]'),
(110, 4, 21, 0, 102, 80, 1, '[[regtime]]', '[[regtime]]'),
(111, 5, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(112, 5, 15, 0, 111, 10, 1, '[[regtime]]', '[[regtime]]'),
(113, 5, 31, 0, 111, 20, 1, '[[regtime]]', '[[regtime]]'),
(114, 5, 27, 0, 111, 30, 1, '[[regtime]]', '[[regtime]]'),
(115, 5, 26, 0, 111, 40, 1, '[[regtime]]', '[[regtime]]'),
(116, 5, 13, 0, 111, 50, 1, '[[regtime]]', '[[regtime]]'),
(117, 5, 14, 0, 111, 60, 1, '[[regtime]]', '[[regtime]]'),
(118, 5, 17, 1, 111, 70, 1, '[[regtime]]', '[[regtime]]'),
(119, 5, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(120, 5, 9, 0, 119, 10, 1, '[[regtime]]', '[[regtime]]'),
(121, 5, 28, 0, 119, 20, 1, '[[regtime]]', '[[regtime]]'),
(122, 5, 3, 0, 0, 30, 1, '[[regtime]]', '[[regtime]]'),
(123, 5, 12, 0, 122, 10, 1, '[[regtime]]', '[[regtime]]'),
(124, 5, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(125, 5, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(126, 5, 6, 0, 0, 60, 0, '[[regtime]]', '[[regtime]]'),
(127, 5, 7, 0, 0, 70, 0, '[[regtime]]', '[[regtime]]'),
(128, 5, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(129, 5, 17, 2, 128, 10, 1, '[[regtime]]', '[[regtime]]'),
(130, 5, 17, 3, 128, 20, 1, '[[regtime]]', '[[regtime]]'),
(131, 5, 17, 4, 128, 30, 1, '[[regtime]]', '[[regtime]]'),
(132, 5, 25, 0, 128, 40, 1, '[[regtime]]', '[[regtime]]'),
(133, 5, 11, 0, 128, 50, 1, '[[regtime]]', '[[regtime]]'),
(134, 5, 17, 1, 128, 60, 1, '[[regtime]]', '[[regtime]]'),
(135, 5, 24, 0, 128, 70, 1, '[[regtime]]', '[[regtime]]'),
(136, 5, 21, 0, 128, 80, 1, '[[regtime]]', '[[regtime]]'),
(137, 6, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(138, 6, 15, 0, 137, 10, 1, '[[regtime]]', '[[regtime]]'),
(139, 6, 31, 0, 137, 20, 1, '[[regtime]]', '[[regtime]]'),
(140, 6, 27, 0, 137, 30, 1, '[[regtime]]', '[[regtime]]'),
(141, 6, 26, 0, 137, 40, 1, '[[regtime]]', '[[regtime]]'),
(142, 6, 13, 0, 137, 50, 1, '[[regtime]]', '[[regtime]]'),
(143, 6, 14, 0, 137, 60, 1, '[[regtime]]', '[[regtime]]'),
(144, 6, 17, 1, 137, 70, 1, '[[regtime]]', '[[regtime]]'),
(145, 6, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(146, 6, 9, 0, 145, 10, 1, '[[regtime]]', '[[regtime]]'),
(147, 6, 28, 0, 145, 20, 1, '[[regtime]]', '[[regtime]]'),
(148, 6, 3, 0, 0, 30, 1, '[[regtime]]', '[[regtime]]'),
(149, 6, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(150, 6, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(151, 6, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(152, 6, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(153, 6, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(154, 6, 17, 2, 153, 10, 1, '[[regtime]]', '[[regtime]]'),
(155, 6, 17, 3, 153, 20, 1, '[[regtime]]', '[[regtime]]'),
(156, 6, 17, 4, 153, 30, 1, '[[regtime]]', '[[regtime]]'),
(157, 6, 25, 0, 153, 40, 1, '[[regtime]]', '[[regtime]]'),
(158, 6, 11, 0, 153, 50, 1, '[[regtime]]', '[[regtime]]'),
(159, 6, 17, 1, 153, 60, 1, '[[regtime]]', '[[regtime]]'),
(160, 6, 24, 0, 153, 70, 1, '[[regtime]]', '[[regtime]]'),
(161, 6, 21, 0, 153, 80, 1, '[[regtime]]', '[[regtime]]'),
(162, 7, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(163, 7, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(164, 7, 3, 0, 0, 30, 1, '[[regtime]]', '[[regtime]]'),
(165, 7, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(166, 7, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(167, 7, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(168, 7, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(169, 7, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(170, 8, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(171, 8, 15, 0, 170, 10, 1, '[[regtime]]', '[[regtime]]'),
(172, 8, 31, 0, 170, 20, 1, '[[regtime]]', '[[regtime]]'),
(173, 8, 27, 0, 170, 30, 1, '[[regtime]]', '[[regtime]]'),
(174, 8, 26, 0, 170, 40, 1, '[[regtime]]', '[[regtime]]'),
(175, 8, 13, 0, 170, 50, 1, '[[regtime]]', '[[regtime]]'),
(176, 8, 14, 0, 170, 60, 1, '[[regtime]]', '[[regtime]]'),
(177, 8, 17, 1, 170, 70, 1, '[[regtime]]', '[[regtime]]'),
(178, 8, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(179, 8, 9, 0, 178, 10, 1, '[[regtime]]', '[[regtime]]'),
(180, 8, 28, 0, 178, 20, 1, '[[regtime]]', '[[regtime]]'),
(181, 8, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(182, 8, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(183, 8, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(184, 8, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(185, 8, 29, 0, 184, 10, 1, '[[regtime]]', '[[regtime]]'),
(186, 8, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(187, 8, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(188, 8, 17, 2, 187, 10, 1, '[[regtime]]', '[[regtime]]'),
(189, 8, 17, 3, 187, 20, 1, '[[regtime]]', '[[regtime]]'),
(190, 8, 17, 4, 187, 30, 1, '[[regtime]]', '[[regtime]]'),
(191, 8, 25, 0, 187, 40, 1, '[[regtime]]', '[[regtime]]'),
(192, 8, 11, 0, 187, 50, 1, '[[regtime]]', '[[regtime]]'),
(193, 8, 17, 1, 187, 60, 1, '[[regtime]]', '[[regtime]]'),
(194, 8, 24, 0, 187, 70, 1, '[[regtime]]', '[[regtime]]'),
(195, 8, 21, 0, 187, 80, 1, '[[regtime]]', '[[regtime]]'),
(196, 9, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(197, 9, 15, 0, 196, 10, 1, '[[regtime]]', '[[regtime]]'),
(198, 9, 31, 0, 196, 20, 1, '[[regtime]]', '[[regtime]]'),
(199, 9, 27, 0, 196, 30, 1, '[[regtime]]', '[[regtime]]'),
(200, 9, 26, 0, 196, 40, 1, '[[regtime]]', '[[regtime]]'),
(201, 9, 13, 0, 196, 50, 1, '[[regtime]]', '[[regtime]]'),
(202, 9, 14, 0, 196, 60, 1, '[[regtime]]', '[[regtime]]'),
(203, 9, 17, 1, 196, 70, 1, '[[regtime]]', '[[regtime]]'),
(204, 9, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(205, 9, 9, 0, 204, 10, 1, '[[regtime]]', '[[regtime]]'),
(206, 9, 28, 0, 204, 20, 1, '[[regtime]]', '[[regtime]]'),
(207, 9, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(208, 9, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(209, 9, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(210, 9, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(211, 9, 29, 0, 210, 10, 1, '[[regtime]]', '[[regtime]]'),
(212, 9, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(213, 9, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(214, 9, 17, 2, 213, 10, 1, '[[regtime]]', '[[regtime]]'),
(215, 9, 17, 3, 213, 20, 1, '[[regtime]]', '[[regtime]]'),
(216, 9, 17, 4, 213, 30, 1, '[[regtime]]', '[[regtime]]'),
(217, 9, 25, 0, 213, 40, 1, '[[regtime]]', '[[regtime]]'),
(218, 9, 11, 0, 213, 50, 1, '[[regtime]]', '[[regtime]]'),
(219, 9, 17, 1, 213, 60, 1, '[[regtime]]', '[[regtime]]'),
(220, 9, 24, 0, 213, 70, 1, '[[regtime]]', '[[regtime]]'),
(221, 9, 21, 0, 213, 80, 1, '[[regtime]]', '[[regtime]]'),
(222, 10, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(223, 10, 15, 0, 222, 10, 1, '[[regtime]]', '[[regtime]]'),
(224, 10, 31, 0, 222, 20, 1, '[[regtime]]', '[[regtime]]'),
(225, 10, 27, 0, 222, 30, 1, '[[regtime]]', '[[regtime]]'),
(226, 10, 26, 0, 222, 40, 1, '[[regtime]]', '[[regtime]]'),
(227, 10, 13, 0, 222, 50, 1, '[[regtime]]', '[[regtime]]'),
(228, 10, 14, 0, 222, 60, 1, '[[regtime]]', '[[regtime]]'),
(229, 10, 17, 1, 222, 70, 1, '[[regtime]]', '[[regtime]]'),
(230, 10, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(231, 10, 9, 0, 230, 10, 1, '[[regtime]]', '[[regtime]]'),
(232, 10, 28, 0, 230, 20, 1, '[[regtime]]', '[[regtime]]'),
(233, 10, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(234, 10, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(235, 10, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(236, 10, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(237, 10, 29, 0, 236, 10, 1, '[[regtime]]', '[[regtime]]'),
(238, 10, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(239, 10, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(240, 10, 17, 2, 239, 10, 1, '[[regtime]]', '[[regtime]]'),
(241, 10, 17, 3, 239, 20, 1, '[[regtime]]', '[[regtime]]'),
(242, 10, 17, 4, 239, 30, 1, '[[regtime]]', '[[regtime]]'),
(243, 10, 25, 0, 239, 40, 1, '[[regtime]]', '[[regtime]]'),
(244, 10, 11, 0, 239, 50, 1, '[[regtime]]', '[[regtime]]'),
(245, 10, 17, 1, 239, 60, 1, '[[regtime]]', '[[regtime]]'),
(246, 10, 24, 0, 239, 70, 1, '[[regtime]]', '[[regtime]]'),
(247, 10, 21, 0, 239, 80, 1, '[[regtime]]', '[[regtime]]'),
(248, 11, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(249, 11, 15, 0, 248, 10, 1, '[[regtime]]', '[[regtime]]'),
(250, 11, 31, 0, 248, 20, 1, '[[regtime]]', '[[regtime]]'),
(251, 11, 27, 0, 248, 30, 1, '[[regtime]]', '[[regtime]]'),
(252, 11, 26, 0, 248, 40, 1, '[[regtime]]', '[[regtime]]'),
(253, 11, 13, 0, 248, 50, 1, '[[regtime]]', '[[regtime]]'),
(254, 11, 14, 0, 248, 60, 1, '[[regtime]]', '[[regtime]]'),
(255, 11, 17, 1, 248, 70, 1, '[[regtime]]', '[[regtime]]'),
(256, 11, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(257, 11, 9, 0, 256, 10, 1, '[[regtime]]', '[[regtime]]'),
(258, 11, 28, 0, 256, 20, 1, '[[regtime]]', '[[regtime]]'),
(259, 11, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(260, 11, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(261, 11, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(262, 11, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(263, 11, 29, 0, 262, 10, 1, '[[regtime]]', '[[regtime]]'),
(264, 11, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(265, 11, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(266, 11, 17, 2, 265, 10, 1, '[[regtime]]', '[[regtime]]'),
(267, 11, 17, 3, 265, 20, 1, '[[regtime]]', '[[regtime]]'),
(268, 11, 17, 4, 265, 30, 1, '[[regtime]]', '[[regtime]]'),
(269, 11, 25, 0, 265, 40, 1, '[[regtime]]', '[[regtime]]'),
(270, 11, 11, 0, 265, 50, 1, '[[regtime]]', '[[regtime]]'),
(271, 11, 17, 1, 265, 60, 1, '[[regtime]]', '[[regtime]]'),
(272, 11, 24, 0, 265, 70, 1, '[[regtime]]', '[[regtime]]'),
(273, 11, 21, 0, 265, 80, 1, '[[regtime]]', '[[regtime]]'),
(274, 12, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(275, 12, 15, 0, 274, 10, 1, '[[regtime]]', '[[regtime]]'),
(276, 12, 31, 0, 274, 20, 1, '[[regtime]]', '[[regtime]]'),
(277, 12, 27, 0, 274, 30, 1, '[[regtime]]', '[[regtime]]'),
(278, 12, 26, 0, 274, 40, 1, '[[regtime]]', '[[regtime]]'),
(279, 12, 13, 0, 274, 50, 1, '[[regtime]]', '[[regtime]]'),
(280, 12, 14, 0, 274, 60, 1, '[[regtime]]', '[[regtime]]'),
(281, 12, 17, 1, 274, 70, 1, '[[regtime]]', '[[regtime]]'),
(282, 12, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(283, 12, 9, 0, 282, 10, 1, '[[regtime]]', '[[regtime]]'),
(284, 12, 28, 0, 282, 20, 1, '[[regtime]]', '[[regtime]]'),
(285, 12, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(286, 12, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(287, 12, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(288, 12, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(289, 12, 29, 0, 288, 10, 1, '[[regtime]]', '[[regtime]]'),
(290, 12, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(291, 12, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(292, 12, 17, 2, 291, 10, 1, '[[regtime]]', '[[regtime]]'),
(293, 12, 17, 3, 291, 20, 1, '[[regtime]]', '[[regtime]]'),
(294, 12, 17, 4, 291, 30, 1, '[[regtime]]', '[[regtime]]'),
(295, 12, 25, 0, 291, 40, 1, '[[regtime]]', '[[regtime]]'),
(296, 12, 11, 0, 291, 50, 1, '[[regtime]]', '[[regtime]]'),
(297, 12, 17, 1, 291, 60, 1, '[[regtime]]', '[[regtime]]'),
(298, 12, 24, 0, 291, 70, 1, '[[regtime]]', '[[regtime]]'),
(299, 12, 21, 0, 291, 80, 1, '[[regtime]]', '[[regtime]]'),
(300, 13, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(301, 13, 15, 0, 300, 10, 1, '[[regtime]]', '[[regtime]]'),
(302, 13, 31, 0, 300, 20, 1, '[[regtime]]', '[[regtime]]'),
(303, 13, 27, 0, 300, 30, 1, '[[regtime]]', '[[regtime]]'),
(304, 13, 26, 0, 300, 40, 1, '[[regtime]]', '[[regtime]]'),
(305, 13, 13, 0, 300, 50, 1, '[[regtime]]', '[[regtime]]'),
(306, 13, 14, 0, 300, 60, 1, '[[regtime]]', '[[regtime]]'),
(307, 13, 17, 1, 300, 70, 1, '[[regtime]]', '[[regtime]]'),
(308, 13, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(309, 13, 9, 0, 308, 10, 1, '[[regtime]]', '[[regtime]]'),
(310, 13, 28, 0, 308, 20, 1, '[[regtime]]', '[[regtime]]'),
(311, 13, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(312, 13, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(313, 13, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(314, 13, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(315, 13, 29, 0, 314, 10, 1, '[[regtime]]', '[[regtime]]'),
(316, 13, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(317, 13, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(318, 13, 17, 2, 317, 10, 1, '[[regtime]]', '[[regtime]]'),
(319, 13, 17, 3, 317, 20, 1, '[[regtime]]', '[[regtime]]'),
(320, 13, 17, 4, 317, 30, 1, '[[regtime]]', '[[regtime]]'),
(321, 13, 25, 0, 317, 40, 1, '[[regtime]]', '[[regtime]]'),
(322, 13, 11, 0, 317, 50, 1, '[[regtime]]', '[[regtime]]'),
(323, 13, 17, 1, 317, 60, 1, '[[regtime]]', '[[regtime]]'),
(324, 13, 24, 0, 317, 70, 1, '[[regtime]]', '[[regtime]]'),
(325, 13, 21, 0, 317, 80, 1, '[[regtime]]', '[[regtime]]'),
(326, 14, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(327, 14, 15, 0, 326, 10, 1, '[[regtime]]', '[[regtime]]'),
(328, 14, 31, 0, 326, 20, 1, '[[regtime]]', '[[regtime]]'),
(329, 14, 27, 0, 326, 30, 1, '[[regtime]]', '[[regtime]]'),
(330, 14, 26, 0, 326, 40, 1, '[[regtime]]', '[[regtime]]'),
(331, 14, 13, 0, 326, 50, 1, '[[regtime]]', '[[regtime]]'),
(332, 14, 14, 0, 326, 60, 1, '[[regtime]]', '[[regtime]]'),
(333, 14, 17, 1, 326, 70, 1, '[[regtime]]', '[[regtime]]'),
(334, 14, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(335, 14, 9, 0, 334, 10, 1, '[[regtime]]', '[[regtime]]'),
(336, 14, 28, 0, 334, 20, 1, '[[regtime]]', '[[regtime]]'),
(337, 14, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(338, 14, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(339, 14, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(340, 14, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(341, 14, 29, 0, 340, 10, 1, '[[regtime]]', '[[regtime]]'),
(342, 14, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(343, 14, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(344, 14, 17, 2, 343, 10, 1, '[[regtime]]', '[[regtime]]'),
(345, 14, 17, 3, 343, 20, 1, '[[regtime]]', '[[regtime]]'),
(346, 14, 17, 4, 343, 30, 1, '[[regtime]]', '[[regtime]]'),
(347, 14, 25, 0, 343, 40, 1, '[[regtime]]', '[[regtime]]'),
(348, 14, 11, 0, 343, 50, 1, '[[regtime]]', '[[regtime]]'),
(349, 14, 17, 1, 343, 60, 1, '[[regtime]]', '[[regtime]]'),
(350, 14, 24, 0, 343, 70, 1, '[[regtime]]', '[[regtime]]'),
(351, 14, 21, 0, 343, 80, 1, '[[regtime]]', '[[regtime]]'),
(352, 15, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(353, 15, 15, 0, 352, 10, 1, '[[regtime]]', '[[regtime]]'),
(354, 15, 31, 0, 352, 20, 1, '[[regtime]]', '[[regtime]]'),
(355, 15, 27, 0, 352, 30, 1, '[[regtime]]', '[[regtime]]'),
(356, 15, 26, 0, 352, 40, 1, '[[regtime]]', '[[regtime]]'),
(357, 15, 13, 0, 352, 50, 1, '[[regtime]]', '[[regtime]]'),
(358, 15, 14, 0, 352, 60, 1, '[[regtime]]', '[[regtime]]'),
(359, 15, 17, 1, 352, 70, 1, '[[regtime]]', '[[regtime]]'),
(360, 15, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(361, 15, 9, 0, 360, 10, 1, '[[regtime]]', '[[regtime]]'),
(362, 15, 28, 0, 360, 20, 1, '[[regtime]]', '[[regtime]]'),
(363, 15, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(364, 15, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(365, 15, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(366, 15, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(367, 15, 29, 0, 366, 10, 1, '[[regtime]]', '[[regtime]]'),
(368, 15, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(369, 15, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(370, 15, 17, 2, 369, 10, 1, '[[regtime]]', '[[regtime]]'),
(371, 15, 17, 3, 369, 20, 1, '[[regtime]]', '[[regtime]]'),
(372, 15, 17, 4, 369, 30, 1, '[[regtime]]', '[[regtime]]'),
(373, 15, 25, 0, 369, 40, 1, '[[regtime]]', '[[regtime]]'),
(374, 15, 11, 0, 369, 50, 1, '[[regtime]]', '[[regtime]]'),
(375, 15, 17, 1, 369, 60, 1, '[[regtime]]', '[[regtime]]'),
(376, 15, 24, 0, 369, 70, 1, '[[regtime]]', '[[regtime]]'),
(377, 15, 21, 0, 369, 80, 1, '[[regtime]]', '[[regtime]]'),
(378, 16, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(379, 16, 15, 0, 378, 10, 1, '[[regtime]]', '[[regtime]]'),
(380, 16, 31, 0, 378, 20, 1, '[[regtime]]', '[[regtime]]'),
(381, 16, 27, 0, 378, 30, 1, '[[regtime]]', '[[regtime]]'),
(382, 16, 26, 0, 378, 40, 1, '[[regtime]]', '[[regtime]]'),
(383, 16, 13, 0, 378, 50, 1, '[[regtime]]', '[[regtime]]'),
(384, 16, 14, 0, 378, 60, 1, '[[regtime]]', '[[regtime]]'),
(385, 16, 17, 1, 378, 70, 1, '[[regtime]]', '[[regtime]]'),
(386, 16, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(387, 16, 9, 0, 386, 10, 1, '[[regtime]]', '[[regtime]]'),
(388, 16, 28, 0, 386, 20, 1, '[[regtime]]', '[[regtime]]'),
(389, 16, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(390, 16, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(391, 16, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(392, 16, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(393, 16, 29, 0, 392, 10, 1, '[[regtime]]', '[[regtime]]'),
(394, 16, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(395, 16, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(396, 16, 17, 2, 395, 10, 1, '[[regtime]]', '[[regtime]]'),
(397, 16, 17, 3, 395, 20, 1, '[[regtime]]', '[[regtime]]'),
(398, 16, 17, 4, 395, 30, 1, '[[regtime]]', '[[regtime]]'),
(399, 16, 25, 0, 395, 40, 1, '[[regtime]]', '[[regtime]]'),
(400, 16, 11, 0, 395, 50, 1, '[[regtime]]', '[[regtime]]'),
(401, 16, 17, 1, 395, 60, 1, '[[regtime]]', '[[regtime]]'),
(402, 16, 24, 0, 395, 70, 1, '[[regtime]]', '[[regtime]]'),
(403, 16, 21, 0, 395, 80, 1, '[[regtime]]', '[[regtime]]'),
(404, 17, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(405, 17, 15, 0, 404, 10, 1, '[[regtime]]', '[[regtime]]'),
(406, 17, 31, 0, 404, 20, 1, '[[regtime]]', '[[regtime]]'),
(407, 17, 27, 0, 404, 30, 1, '[[regtime]]', '[[regtime]]'),
(408, 17, 26, 0, 404, 40, 1, '[[regtime]]', '[[regtime]]'),
(409, 17, 13, 0, 404, 50, 1, '[[regtime]]', '[[regtime]]'),
(410, 17, 14, 0, 404, 60, 1, '[[regtime]]', '[[regtime]]'),
(411, 17, 17, 1, 404, 70, 1, '[[regtime]]', '[[regtime]]'),
(412, 17, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(413, 17, 9, 0, 412, 10, 1, '[[regtime]]', '[[regtime]]'),
(414, 17, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(415, 17, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(416, 17, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(417, 17, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(418, 17, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(419, 17, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(420, 17, 11, 0, 419, 50, 1, '[[regtime]]', '[[regtime]]'),
(421, 17, 24, 0, 419, 70, 1, '[[regtime]]', '[[regtime]]'),
(422, 17, 21, 0, 419, 80, 1, '[[regtime]]', '[[regtime]]'),
(423, 18, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(424, 18, 32, 0, 423, 40, 1, '[[regtime]]', '[[regtime]]'),
(425, 18, 2, 0, 0, 20, 0, '[[regtime]]', '[[regtime]]'),
(426, 18, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(427, 18, 4, 0, 0, 40, 0, '[[regtime]]', '[[regtime]]'),
(428, 18, 5, 0, 0, 50, 0, '[[regtime]]', '[[regtime]]'),
(429, 18, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(430, 18, 33, 0, 429, 10, 1, '[[regtime]]', '[[regtime]]'),
(431, 18, 7, 0, 0, 70, 0, '[[regtime]]', '[[regtime]]'),
(432, 18, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(433, 19, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(434, 19, 2, 0, 0, 20, 0, '[[regtime]]', '[[regtime]]'),
(435, 19, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(436, 19, 4, 0, 0, 40, 0, '[[regtime]]', '[[regtime]]'),
(437, 19, 5, 0, 0, 50, 0, '[[regtime]]', '[[regtime]]'),
(438, 19, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(439, 19, 7, 0, 0, 70, 0, '[[regtime]]', '[[regtime]]'),
(440, 19, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(441, 20, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(442, 20, 15, 0, 441, 10, 1, '[[regtime]]', '[[regtime]]'),
(443, 20, 31, 0, 441, 20, 1, '[[regtime]]', '[[regtime]]'),
(444, 20, 27, 0, 441, 30, 1, '[[regtime]]', '[[regtime]]'),
(445, 20, 26, 0, 441, 40, 1, '[[regtime]]', '[[regtime]]'),
(446, 20, 13, 0, 441, 50, 1, '[[regtime]]', '[[regtime]]'),
(447, 20, 14, 0, 441, 60, 1, '[[regtime]]', '[[regtime]]'),
(448, 20, 17, 1, 441, 70, 1, '[[regtime]]', '[[regtime]]'),
(449, 20, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(450, 20, 9, 0, 449, 10, 1, '[[regtime]]', '[[regtime]]'),
(451, 20, 28, 0, 449, 20, 1, '[[regtime]]', '[[regtime]]'),
(452, 20, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(453, 20, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(454, 20, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(455, 20, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(456, 20, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(457, 20, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(458, 20, 17, 2, 457, 10, 1, '[[regtime]]', '[[regtime]]'),
(459, 20, 17, 3, 457, 20, 1, '[[regtime]]', '[[regtime]]'),
(460, 20, 17, 4, 457, 30, 1, '[[regtime]]', '[[regtime]]'),
(461, 20, 25, 0, 457, 40, 1, '[[regtime]]', '[[regtime]]'),
(462, 20, 11, 0, 457, 50, 1, '[[regtime]]', '[[regtime]]'),
(463, 20, 17, 1, 457, 60, 1, '[[regtime]]', '[[regtime]]'),
(464, 20, 24, 0, 457, 70, 1, '[[regtime]]', '[[regtime]]'),
(465, 20, 21, 0, 457, 80, 1, '[[regtime]]', '[[regtime]]'),
(466, 21, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(467, 21, 26, 0, 466, 10, 1, '[[regtime]]', '[[regtime]]'),
(468, 21, 13, 0, 466, 20, 1, '[[regtime]]', '[[regtime]]'),
(469, 21, 14, 0, 466, 30, 1, '[[regtime]]', '[[regtime]]'),
(470, 21, 15, 0, 466, 40, 1, '[[regtime]]', '[[regtime]]'),
(471, 21, 31, 0, 466, 50, 1, '[[regtime]]', '[[regtime]]'),
(472, 21, 38, 0, 466, 60, 1, '[[regtime]]', '[[regtime]]'),
(473, 21, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(474, 21, 38, 0, 473, 10, 1, '[[regtime]]', '[[regtime]]'),
(475, 21, 28, 0, 473, 20, 1, '[[regtime]]', '[[regtime]]'),
(476, 21, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(477, 21, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(478, 21, 11, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(479, 21, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(480, 21, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(481, 21, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(482, 21, 25, 0, 481, 10, 1, '[[regtime]]', '[[regtime]]'),
(483, 21, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(484, 21, 17, 9, 483, 10, 1, '[[regtime]]', '[[regtime]]'),
(485, 21, 17, 10, 483, 20, 1, '[[regtime]]', '[[regtime]]'),
(486, 21, 17, 11, 483, 30, 1, '[[regtime]]', '[[regtime]]'),
(487, 21, 11, 0, 483, 40, 1, '[[regtime]]', '[[regtime]]'),
(488, 22, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(489, 22, 26, 0, 488, 10, 1, '[[regtime]]', '[[regtime]]'),
(490, 22, 13, 0, 488, 20, 1, '[[regtime]]', '[[regtime]]'),
(491, 22, 14, 0, 488, 30, 1, '[[regtime]]', '[[regtime]]'),
(492, 22, 15, 0, 488, 40, 1, '[[regtime]]', '[[regtime]]'),
(493, 22, 31, 0, 488, 50, 1, '[[regtime]]', '[[regtime]]'),
(494, 22, 38, 0, 488, 60, 1, '[[regtime]]', '[[regtime]]'),
(495, 22, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(496, 22, 38, 0, 495, 10, 1, '[[regtime]]', '[[regtime]]'),
(497, 22, 17, 12, 495, 20, 1, '[[regtime]]', '[[regtime]]'),
(498, 22, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(499, 22, 4, 0, 0, 40, 0, '[[regtime]]', '[[regtime]]'),
(500, 22, 11, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(501, 22, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(502, 22, 17, 13, 501, 10, 1, '[[regtime]]', '[[regtime]]'),
(503, 22, 12, 0, 501, 20, 1, '[[regtime]]', '[[regtime]]'),
(504, 22, 19, 0, 501, 30, 1, '[[regtime]]', '[[regtime]]'),
(505, 22, 17, 14, 501, 40, 1, '[[regtime]]', '[[regtime]]'),
(506, 22, 18, 0, 501, 50, 1, '[[regtime]]', '[[regtime]]'),
(507, 22, 22, 0, 501, 60, 1, '[[regtime]]', '[[regtime]]'),
(508, 22, 17, 15, 501, 70, 1, '[[regtime]]', '[[regtime]]'),
(509, 22, 17, 16, 501, 80, 1, '[[regtime]]', '[[regtime]]'),
(510, 22, 20, 17, 501, 90, 1, '[[regtime]]', '[[regtime]]'),
(511, 22, 17, 18, 501, 100, 1, '[[regtime]]', '[[regtime]]'),
(512, 22, 6, 0, 0, 60, 0, '[[regtime]]', '[[regtime]]'),
(513, 22, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(514, 22, 25, 0, 513, 10, 1, '[[regtime]]', '[[regtime]]'),
(515, 22, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(516, 22, 17, 9, 515, 10, 1, '[[regtime]]', '[[regtime]]'),
(517, 22, 17, 10, 515, 20, 1, '[[regtime]]', '[[regtime]]'),
(518, 22, 17, 11, 515, 30, 1, '[[regtime]]', '[[regtime]]'),
(519, 22, 11, 0, 515, 40, 1, '[[regtime]]', '[[regtime]]'),
(520, 23, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(521, 23, 26, 0, 520, 10, 1, '[[regtime]]', '[[regtime]]'),
(522, 23, 13, 0, 520, 20, 1, '[[regtime]]', '[[regtime]]'),
(523, 23, 14, 0, 520, 30, 1, '[[regtime]]', '[[regtime]]'),
(524, 23, 15, 0, 520, 40, 1, '[[regtime]]', '[[regtime]]'),
(525, 23, 31, 0, 520, 50, 1, '[[regtime]]', '[[regtime]]'),
(526, 23, 38, 0, 520, 60, 1, '[[regtime]]', '[[regtime]]'),
(527, 23, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(528, 23, 38, 0, 527, 10, 1, '[[regtime]]', '[[regtime]]'),
(529, 23, 28, 0, 527, 20, 1, '[[regtime]]', '[[regtime]]'),
(530, 23, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(531, 23, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(532, 23, 11, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(533, 23, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(534, 23, 6, 0, 0, 60, 0, '[[regtime]]', '[[regtime]]'),
(535, 23, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(536, 23, 25, 0, 535, 10, 1, '[[regtime]]', '[[regtime]]'),
(537, 23, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(538, 23, 17, 9, 537, 10, 1, '[[regtime]]', '[[regtime]]'),
(539, 23, 17, 10, 537, 20, 1, '[[regtime]]', '[[regtime]]'),
(540, 23, 17, 11, 537, 30, 1, '[[regtime]]', '[[regtime]]'),
(541, 23, 11, 0, 537, 40, 1, '[[regtime]]', '[[regtime]]'),
(542, 24, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(543, 24, 26, 0, 542, 10, 1, '[[regtime]]', '[[regtime]]'),
(544, 24, 13, 0, 542, 20, 1, '[[regtime]]', '[[regtime]]'),
(545, 24, 14, 0, 542, 30, 1, '[[regtime]]', '[[regtime]]'),
(546, 24, 15, 0, 542, 40, 1, '[[regtime]]', '[[regtime]]'),
(547, 24, 31, 0, 542, 50, 1, '[[regtime]]', '[[regtime]]'),
(548, 24, 38, 0, 542, 60, 1, '[[regtime]]', '[[regtime]]'),
(549, 24, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(550, 24, 38, 0, 549, 10, 1, '[[regtime]]', '[[regtime]]'),
(551, 24, 28, 0, 549, 20, 1, '[[regtime]]', '[[regtime]]'),
(552, 24, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(553, 24, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(554, 24, 11, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(555, 24, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(556, 24, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(557, 24, 37, 0, 556, 10, 1, '[[regtime]]', '[[regtime]]'),
(558, 24, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(559, 24, 25, 0, 558, 10, 1, '[[regtime]]', '[[regtime]]'),
(560, 24, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(561, 24, 17, 9, 560, 10, 1, '[[regtime]]', '[[regtime]]'),
(562, 24, 17, 10, 560, 20, 1, '[[regtime]]', '[[regtime]]'),
(563, 24, 17, 11, 560, 30, 1, '[[regtime]]', '[[regtime]]'),
(564, 24, 11, 0, 560, 40, 1, '[[regtime]]', '[[regtime]]'),
(565, 25, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(566, 25, 26, 0, 565, 10, 1, '[[regtime]]', '[[regtime]]'),
(567, 25, 13, 0, 565, 20, 1, '[[regtime]]', '[[regtime]]'),
(568, 25, 14, 0, 565, 30, 1, '[[regtime]]', '[[regtime]]'),
(569, 25, 15, 0, 565, 40, 1, '[[regtime]]', '[[regtime]]'),
(570, 25, 31, 0, 565, 50, 1, '[[regtime]]', '[[regtime]]'),
(571, 25, 38, 0, 565, 60, 1, '[[regtime]]', '[[regtime]]'),
(572, 25, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(573, 25, 38, 0, 572, 10, 1, '[[regtime]]', '[[regtime]]'),
(574, 25, 28, 0, 572, 20, 1, '[[regtime]]', '[[regtime]]'),
(575, 25, 3, 0, 0, 30, 1, '[[regtime]]', '[[regtime]]'),
(576, 25, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(577, 25, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(578, 25, 34, 0, 577, 10, 1, '[[regtime]]', '[[regtime]]'),
(579, 25, 6, 0, 0, 60, 0, '[[regtime]]', '[[regtime]]'),
(580, 25, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(581, 25, 25, 0, 580, 10, 1, '[[regtime]]', '[[regtime]]'),
(582, 25, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(583, 25, 17, 9, 582, 10, 1, '[[regtime]]', '[[regtime]]'),
(584, 25, 17, 10, 582, 20, 1, '[[regtime]]', '[[regtime]]'),
(585, 25, 17, 11, 582, 30, 1, '[[regtime]]', '[[regtime]]'),
(586, 25, 11, 0, 582, 40, 1, '[[regtime]]', '[[regtime]]'),
(587, 26, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(588, 26, 26, 0, 587, 10, 1, '[[regtime]]', '[[regtime]]'),
(589, 26, 13, 0, 587, 20, 1, '[[regtime]]', '[[regtime]]'),
(590, 26, 14, 0, 587, 30, 1, '[[regtime]]', '[[regtime]]'),
(591, 26, 15, 0, 587, 40, 1, '[[regtime]]', '[[regtime]]'),
(592, 26, 31, 0, 587, 50, 1, '[[regtime]]', '[[regtime]]'),
(593, 26, 38, 0, 587, 60, 1, '[[regtime]]', '[[regtime]]'),
(594, 26, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(595, 26, 38, 0, 594, 10, 1, '[[regtime]]', '[[regtime]]'),
(596, 26, 39, 0, 594, 20, 1, '[[regtime]]', '[[regtime]]'),
(597, 26, 28, 0, 594, 30, 1, '[[regtime]]', '[[regtime]]'),
(598, 26, 3, 0, 0, 30, 1, '[[regtime]]', '[[regtime]]'),
(599, 26, 40, 0, 598, 10, 1, '[[regtime]]', '[[regtime]]'),
(600, 26, 17, 19, 598, 20, 1, '[[regtime]]', '[[regtime]]'),
(601, 26, 17, 20, 598, 30, 1, '[[regtime]]', '[[regtime]]'),
(602, 26, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(603, 26, 11, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(604, 26, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(605, 26, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(606, 26, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(607, 26, 25, 0, 606, 10, 1, '[[regtime]]', '[[regtime]]'),
(608, 26, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(609, 26, 17, 9, 608, 10, 1, '[[regtime]]', '[[regtime]]'),
(610, 26, 17, 10, 608, 20, 1, '[[regtime]]', '[[regtime]]'),
(611, 26, 17, 11, 608, 30, 1, '[[regtime]]', '[[regtime]]'),
(612, 26, 11, 0, 608, 40, 1, '[[regtime]]', '[[regtime]]'),
(613, 27, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(614, 27, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(615, 27, 3, 0, 0, 30, 1, '[[regtime]]', '[[regtime]]'),
(616, 27, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(617, 27, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(618, 27, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(619, 27, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(620, 27, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(621, 28, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(622, 28, 26, 0, 621, 10, 1, '[[regtime]]', '[[regtime]]'),
(623, 28, 13, 0, 621, 20, 1, '[[regtime]]', '[[regtime]]'),
(624, 28, 14, 0, 621, 30, 1, '[[regtime]]', '[[regtime]]'),
(625, 28, 15, 0, 621, 40, 1, '[[regtime]]', '[[regtime]]'),
(626, 28, 31, 0, 621, 50, 1, '[[regtime]]', '[[regtime]]'),
(627, 28, 38, 0, 621, 60, 1, '[[regtime]]', '[[regtime]]'),
(628, 28, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(629, 28, 38, 0, 628, 10, 1, '[[regtime]]', '[[regtime]]'),
(630, 28, 28, 0, 628, 20, 1, '[[regtime]]', '[[regtime]]'),
(631, 28, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(632, 28, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(633, 28, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(634, 28, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(635, 28, 29, 0, 634, 10, 1, '[[regtime]]', '[[regtime]]'),
(636, 28, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(637, 28, 25, 0, 636, 10, 1, '[[regtime]]', '[[regtime]]'),
(638, 28, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(639, 28, 17, 9, 638, 10, 1, '[[regtime]]', '[[regtime]]'),
(640, 28, 17, 10, 638, 20, 1, '[[regtime]]', '[[regtime]]'),
(641, 28, 17, 11, 638, 30, 1, '[[regtime]]', '[[regtime]]'),
(642, 28, 11, 0, 638, 40, 1, '[[regtime]]', '[[regtime]]'),
(643, 29, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(644, 29, 26, 0, 643, 10, 1, '[[regtime]]', '[[regtime]]'),
(645, 29, 13, 0, 643, 20, 1, '[[regtime]]', '[[regtime]]'),
(646, 29, 14, 0, 643, 30, 1, '[[regtime]]', '[[regtime]]'),
(647, 29, 15, 0, 643, 40, 1, '[[regtime]]', '[[regtime]]'),
(648, 29, 31, 0, 643, 50, 1, '[[regtime]]', '[[regtime]]'),
(649, 29, 38, 0, 643, 60, 1, '[[regtime]]', '[[regtime]]'),
(650, 29, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(651, 29, 38, 0, 650, 10, 1, '[[regtime]]', '[[regtime]]'),
(652, 29, 28, 0, 650, 20, 1, '[[regtime]]', '[[regtime]]'),
(653, 29, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(654, 29, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(655, 29, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(656, 29, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(657, 29, 29, 0, 656, 10, 1, '[[regtime]]', '[[regtime]]'),
(658, 29, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(659, 29, 25, 0, 658, 10, 1, '[[regtime]]', '[[regtime]]'),
(660, 29, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(661, 29, 17, 9, 660, 10, 1, '[[regtime]]', '[[regtime]]'),
(662, 29, 17, 10, 660, 20, 1, '[[regtime]]', '[[regtime]]'),
(663, 29, 17, 11, 660, 30, 1, '[[regtime]]', '[[regtime]]'),
(664, 29, 11, 0, 660, 40, 1, '[[regtime]]', '[[regtime]]'),
(665, 30, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(666, 30, 26, 0, 665, 10, 1, '[[regtime]]', '[[regtime]]'),
(667, 30, 13, 0, 665, 20, 1, '[[regtime]]', '[[regtime]]'),
(668, 30, 14, 0, 665, 30, 1, '[[regtime]]', '[[regtime]]'),
(669, 30, 15, 0, 665, 40, 1, '[[regtime]]', '[[regtime]]'),
(670, 30, 31, 0, 665, 50, 1, '[[regtime]]', '[[regtime]]'),
(671, 30, 38, 0, 665, 60, 1, '[[regtime]]', '[[regtime]]'),
(672, 30, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(673, 30, 38, 0, 672, 10, 1, '[[regtime]]', '[[regtime]]'),
(674, 30, 28, 0, 672, 20, 1, '[[regtime]]', '[[regtime]]'),
(675, 30, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(676, 30, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(677, 30, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(678, 30, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(679, 30, 29, 0, 678, 10, 1, '[[regtime]]', '[[regtime]]'),
(680, 30, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(681, 30, 25, 0, 680, 10, 1, '[[regtime]]', '[[regtime]]'),
(682, 30, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(683, 30, 17, 9, 682, 10, 1, '[[regtime]]', '[[regtime]]'),
(684, 30, 17, 10, 682, 20, 1, '[[regtime]]', '[[regtime]]'),
(685, 30, 17, 11, 682, 30, 1, '[[regtime]]', '[[regtime]]'),
(686, 30, 11, 0, 682, 40, 1, '[[regtime]]', '[[regtime]]'),
(687, 31, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(688, 31, 26, 0, 687, 10, 1, '[[regtime]]', '[[regtime]]'),
(689, 31, 13, 0, 687, 20, 1, '[[regtime]]', '[[regtime]]'),
(690, 31, 14, 0, 687, 30, 1, '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]block_layouts` VALUES
(691, 31, 15, 0, 687, 40, 1, '[[regtime]]', '[[regtime]]'),
(692, 31, 31, 0, 687, 50, 1, '[[regtime]]', '[[regtime]]'),
(693, 31, 38, 0, 687, 60, 1, '[[regtime]]', '[[regtime]]'),
(694, 31, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(695, 31, 38, 0, 694, 10, 1, '[[regtime]]', '[[regtime]]'),
(696, 31, 28, 0, 694, 20, 1, '[[regtime]]', '[[regtime]]'),
(697, 31, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(698, 31, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(699, 31, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(700, 31, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(701, 31, 29, 0, 700, 10, 1, '[[regtime]]', '[[regtime]]'),
(702, 31, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(703, 31, 25, 0, 702, 10, 1, '[[regtime]]', '[[regtime]]'),
(704, 31, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(705, 31, 17, 9, 704, 10, 1, '[[regtime]]', '[[regtime]]'),
(706, 31, 17, 10, 704, 20, 1, '[[regtime]]', '[[regtime]]'),
(707, 31, 17, 11, 704, 30, 1, '[[regtime]]', '[[regtime]]'),
(708, 31, 11, 0, 704, 40, 1, '[[regtime]]', '[[regtime]]'),
(709, 32, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(710, 32, 26, 0, 709, 10, 1, '[[regtime]]', '[[regtime]]'),
(711, 32, 13, 0, 709, 20, 1, '[[regtime]]', '[[regtime]]'),
(712, 32, 14, 0, 709, 30, 1, '[[regtime]]', '[[regtime]]'),
(713, 32, 15, 0, 709, 40, 1, '[[regtime]]', '[[regtime]]'),
(714, 32, 31, 0, 709, 50, 1, '[[regtime]]', '[[regtime]]'),
(715, 32, 38, 0, 709, 60, 1, '[[regtime]]', '[[regtime]]'),
(716, 32, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(717, 32, 38, 0, 716, 10, 1, '[[regtime]]', '[[regtime]]'),
(718, 32, 28, 0, 716, 20, 1, '[[regtime]]', '[[regtime]]'),
(719, 32, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(720, 32, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(721, 32, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(722, 32, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(723, 32, 29, 0, 722, 10, 1, '[[regtime]]', '[[regtime]]'),
(724, 32, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(725, 32, 25, 0, 724, 10, 1, '[[regtime]]', '[[regtime]]'),
(726, 32, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(727, 32, 17, 9, 726, 10, 1, '[[regtime]]', '[[regtime]]'),
(728, 32, 17, 10, 726, 20, 1, '[[regtime]]', '[[regtime]]'),
(729, 32, 17, 11, 726, 30, 1, '[[regtime]]', '[[regtime]]'),
(730, 32, 11, 0, 726, 40, 1, '[[regtime]]', '[[regtime]]'),
(731, 33, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(732, 33, 26, 0, 731, 10, 1, '[[regtime]]', '[[regtime]]'),
(733, 33, 13, 0, 731, 20, 1, '[[regtime]]', '[[regtime]]'),
(734, 33, 14, 0, 731, 30, 1, '[[regtime]]', '[[regtime]]'),
(735, 33, 15, 0, 731, 40, 1, '[[regtime]]', '[[regtime]]'),
(736, 33, 31, 0, 731, 50, 1, '[[regtime]]', '[[regtime]]'),
(737, 33, 38, 0, 731, 60, 1, '[[regtime]]', '[[regtime]]'),
(738, 33, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(739, 33, 38, 0, 738, 10, 1, '[[regtime]]', '[[regtime]]'),
(740, 33, 28, 0, 738, 20, 1, '[[regtime]]', '[[regtime]]'),
(741, 33, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(742, 33, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(743, 33, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(744, 33, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(745, 33, 29, 0, 744, 10, 1, '[[regtime]]', '[[regtime]]'),
(746, 33, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(747, 33, 25, 0, 746, 10, 1, '[[regtime]]', '[[regtime]]'),
(748, 33, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(749, 33, 17, 9, 748, 10, 1, '[[regtime]]', '[[regtime]]'),
(750, 33, 17, 10, 748, 20, 1, '[[regtime]]', '[[regtime]]'),
(751, 33, 17, 11, 748, 30, 1, '[[regtime]]', '[[regtime]]'),
(752, 33, 11, 0, 748, 40, 1, '[[regtime]]', '[[regtime]]'),
(753, 34, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(754, 34, 26, 0, 753, 10, 1, '[[regtime]]', '[[regtime]]'),
(755, 34, 13, 0, 753, 20, 1, '[[regtime]]', '[[regtime]]'),
(756, 34, 14, 0, 753, 30, 1, '[[regtime]]', '[[regtime]]'),
(757, 34, 15, 0, 753, 40, 1, '[[regtime]]', '[[regtime]]'),
(758, 34, 31, 0, 753, 50, 1, '[[regtime]]', '[[regtime]]'),
(759, 34, 38, 0, 753, 60, 1, '[[regtime]]', '[[regtime]]'),
(760, 34, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(761, 34, 38, 0, 760, 10, 1, '[[regtime]]', '[[regtime]]'),
(762, 34, 28, 0, 760, 20, 1, '[[regtime]]', '[[regtime]]'),
(763, 34, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(764, 34, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(765, 34, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(766, 34, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(767, 34, 29, 0, 766, 10, 1, '[[regtime]]', '[[regtime]]'),
(768, 34, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(769, 34, 25, 0, 768, 10, 1, '[[regtime]]', '[[regtime]]'),
(770, 34, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(771, 34, 17, 9, 770, 10, 1, '[[regtime]]', '[[regtime]]'),
(772, 34, 17, 10, 770, 20, 1, '[[regtime]]', '[[regtime]]'),
(773, 34, 17, 11, 770, 30, 1, '[[regtime]]', '[[regtime]]'),
(774, 34, 11, 0, 770, 40, 1, '[[regtime]]', '[[regtime]]'),
(775, 35, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(776, 35, 26, 0, 775, 10, 1, '[[regtime]]', '[[regtime]]'),
(777, 35, 13, 0, 775, 20, 1, '[[regtime]]', '[[regtime]]'),
(778, 35, 14, 0, 775, 30, 1, '[[regtime]]', '[[regtime]]'),
(779, 35, 15, 0, 775, 40, 1, '[[regtime]]', '[[regtime]]'),
(780, 35, 31, 0, 775, 50, 1, '[[regtime]]', '[[regtime]]'),
(781, 35, 38, 0, 775, 60, 1, '[[regtime]]', '[[regtime]]'),
(782, 35, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(783, 35, 38, 0, 782, 10, 1, '[[regtime]]', '[[regtime]]'),
(784, 35, 28, 0, 782, 20, 1, '[[regtime]]', '[[regtime]]'),
(785, 35, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(786, 35, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(787, 35, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(788, 35, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(789, 35, 29, 0, 788, 10, 1, '[[regtime]]', '[[regtime]]'),
(790, 35, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(791, 35, 25, 0, 790, 10, 1, '[[regtime]]', '[[regtime]]'),
(792, 35, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(793, 35, 17, 9, 792, 10, 1, '[[regtime]]', '[[regtime]]'),
(794, 35, 17, 10, 792, 20, 1, '[[regtime]]', '[[regtime]]'),
(795, 35, 17, 11, 792, 30, 1, '[[regtime]]', '[[regtime]]'),
(796, 35, 11, 0, 792, 40, 1, '[[regtime]]', '[[regtime]]'),
(797, 36, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(798, 36, 26, 0, 797, 10, 1, '[[regtime]]', '[[regtime]]'),
(799, 36, 13, 0, 797, 20, 1, '[[regtime]]', '[[regtime]]'),
(800, 36, 14, 0, 797, 30, 1, '[[regtime]]', '[[regtime]]'),
(801, 36, 15, 0, 797, 40, 1, '[[regtime]]', '[[regtime]]'),
(802, 36, 31, 0, 797, 50, 1, '[[regtime]]', '[[regtime]]'),
(803, 36, 38, 0, 797, 60, 1, '[[regtime]]', '[[regtime]]'),
(804, 36, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(805, 36, 38, 0, 804, 10, 1, '[[regtime]]', '[[regtime]]'),
(806, 36, 28, 0, 804, 20, 1, '[[regtime]]', '[[regtime]]'),
(807, 36, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(808, 36, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(809, 36, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(810, 36, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(811, 36, 29, 0, 810, 10, 1, '[[regtime]]', '[[regtime]]'),
(812, 36, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(813, 36, 25, 0, 812, 10, 1, '[[regtime]]', '[[regtime]]'),
(814, 36, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(815, 36, 17, 9, 814, 10, 1, '[[regtime]]', '[[regtime]]'),
(816, 36, 17, 10, 814, 20, 1, '[[regtime]]', '[[regtime]]'),
(817, 36, 17, 11, 814, 30, 1, '[[regtime]]', '[[regtime]]'),
(818, 36, 11, 0, 814, 40, 1, '[[regtime]]', '[[regtime]]'),
(819, 37, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(820, 37, 26, 0, 819, 10, 1, '[[regtime]]', '[[regtime]]'),
(821, 37, 13, 0, 819, 20, 1, '[[regtime]]', '[[regtime]]'),
(822, 37, 14, 0, 819, 30, 1, '[[regtime]]', '[[regtime]]'),
(823, 37, 15, 0, 819, 40, 1, '[[regtime]]', '[[regtime]]'),
(824, 37, 31, 0, 819, 50, 1, '[[regtime]]', '[[regtime]]'),
(825, 37, 38, 0, 819, 60, 1, '[[regtime]]', '[[regtime]]'),
(826, 37, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(827, 37, 38, 0, 826, 10, 1, '[[regtime]]', '[[regtime]]'),
(828, 37, 28, 0, 826, 20, 1, '[[regtime]]', '[[regtime]]'),
(829, 37, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(830, 37, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(831, 37, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(832, 37, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(833, 37, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(834, 37, 25, 0, 833, 10, 1, '[[regtime]]', '[[regtime]]'),
(835, 37, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(836, 37, 17, 9, 835, 10, 1, '[[regtime]]', '[[regtime]]'),
(837, 37, 17, 10, 835, 20, 1, '[[regtime]]', '[[regtime]]'),
(838, 37, 17, 11, 835, 30, 1, '[[regtime]]', '[[regtime]]'),
(839, 37, 11, 0, 835, 40, 1, '[[regtime]]', '[[regtime]]'),
(840, 38, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(841, 38, 32, 0, 840, 40, 1, '[[regtime]]', '[[regtime]]'),
(842, 38, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(843, 38, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(844, 38, 4, 0, 0, 40, 0, '[[regtime]]', '[[regtime]]'),
(845, 38, 5, 0, 0, 50, 0, '[[regtime]]', '[[regtime]]'),
(846, 38, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(847, 38, 33, 0, 846, 10, 1, '[[regtime]]', '[[regtime]]'),
(848, 38, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(849, 38, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(850, 39, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(851, 39, 26, 0, 850, 10, 1, '[[regtime]]', '[[regtime]]'),
(852, 39, 13, 0, 850, 20, 1, '[[regtime]]', '[[regtime]]'),
(853, 39, 14, 0, 850, 30, 1, '[[regtime]]', '[[regtime]]'),
(854, 39, 15, 0, 850, 40, 1, '[[regtime]]', '[[regtime]]'),
(855, 39, 31, 0, 850, 50, 1, '[[regtime]]', '[[regtime]]'),
(856, 39, 38, 0, 850, 60, 1, '[[regtime]]', '[[regtime]]'),
(857, 39, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(858, 39, 38, 0, 857, 10, 1, '[[regtime]]', '[[regtime]]'),
(859, 39, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(860, 39, 4, 0, 0, 40, 0, '[[regtime]]', '[[regtime]]'),
(861, 39, 5, 0, 0, 50, 0, '[[regtime]]', '[[regtime]]'),
(862, 39, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(863, 39, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(864, 39, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(865, 40, 1, 0, 0, 10, 1, '[[regtime]]', '[[regtime]]'),
(866, 40, 26, 0, 865, 10, 1, '[[regtime]]', '[[regtime]]'),
(867, 40, 13, 0, 865, 20, 1, '[[regtime]]', '[[regtime]]'),
(868, 40, 14, 0, 865, 30, 1, '[[regtime]]', '[[regtime]]'),
(869, 40, 15, 0, 865, 40, 1, '[[regtime]]', '[[regtime]]'),
(870, 40, 31, 0, 865, 50, 1, '[[regtime]]', '[[regtime]]'),
(871, 40, 38, 0, 865, 60, 1, '[[regtime]]', '[[regtime]]'),
(872, 40, 2, 0, 0, 20, 1, '[[regtime]]', '[[regtime]]'),
(873, 40, 38, 0, 872, 10, 1, '[[regtime]]', '[[regtime]]'),
(874, 40, 28, 0, 872, 20, 1, '[[regtime]]', '[[regtime]]'),
(875, 40, 3, 0, 0, 30, 0, '[[regtime]]', '[[regtime]]'),
(876, 40, 4, 0, 0, 40, 1, '[[regtime]]', '[[regtime]]'),
(877, 40, 11, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(878, 40, 5, 0, 0, 50, 1, '[[regtime]]', '[[regtime]]'),
(879, 40, 6, 0, 0, 60, 1, '[[regtime]]', '[[regtime]]'),
(880, 40, 7, 0, 0, 70, 1, '[[regtime]]', '[[regtime]]'),
(881, 40, 25, 0, 880, 10, 1, '[[regtime]]', '[[regtime]]'),
(882, 40, 8, 0, 0, 80, 1, '[[regtime]]', '[[regtime]]'),
(883, 40, 17, 9, 882, 10, 1, '[[regtime]]', '[[regtime]]'),
(884, 40, 17, 10, 882, 20, 1, '[[regtime]]', '[[regtime]]'),
(885, 40, 17, 11, 882, 30, 1, '[[regtime]]', '[[regtime]]'),
(886, 40, 11, 0, 882, 40, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_templates`
--

CREATE TABLE `[[dbprefix]]block_templates` (
  `block_id` int NOT NULL AUTO_INCREMENT,
  `parent_block_id` int NOT NULL DEFAULT '0',
  `template` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`block_id`,`parent_block_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=41 ;

--
-- Dumping data for table `[[dbprefix]]block_templates`
--

INSERT INTO `[[dbprefix]]block_templates` VALUES
(9, 1, 'blocks/category_top.tpl', '[[regtime]]', '[[regtime]]'),
(9, 2, 'blocks/category_top.tpl', '[[regtime]]', '[[regtime]]'),
(9, 3, 'blocks/category.tpl', '[[regtime]]', '[[regtime]]'),
(9, 6, 'blocks/category.tpl', '[[regtime]]', '[[regtime]]'),
(9, 7, 'blocks/category_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(9, 8, 'blocks/category_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(10, 3, 'blocks/manufacturer.tpl', '[[regtime]]', '[[regtime]]'),
(10, 6, 'blocks/manufacturer.tpl', '[[regtime]]', '[[regtime]]'),
(11, 1, 'blocks/content_header.tpl', '[[regtime]]', '[[regtime]]'),
(11, 3, 'blocks/content.tpl', '[[regtime]]', '[[regtime]]'),
(11, 6, 'blocks/content.tpl', '[[regtime]]', '[[regtime]]'),
(11, 8, 'blocks/content_footer.tpl', '[[regtime]]', '[[regtime]]'),
(12, 3, 'blocks/latest.tpl', '[[regtime]]', '[[regtime]]'),
(12, 4, 'blocks/latest_home.tpl', '[[regtime]]', '[[regtime]]'),
(12, 5, 'blocks/latest_home.tpl', '[[regtime]]', '[[regtime]]'),
(12, 6, 'blocks/latest.tpl', '[[regtime]]', '[[regtime]]'),
(13, 1, 'blocks/language.tpl', '[[regtime]]', '[[regtime]]'),
(14, 1, 'blocks/currency.tpl', '[[regtime]]', '[[regtime]]'),
(15, 1, 'blocks/cart_top.tpl', '[[regtime]]', '[[regtime]]'),
(15, 6, 'blocks/cart.tpl', '[[regtime]]', '[[regtime]]'),
(16, 6, 'blocks/order_summary.tpl', '[[regtime]]', '[[regtime]]'),
(17, 1, 'blocks/html_block_header.tpl', '[[regtime]]', '[[regtime]]'),
(17, 2, 'blocks/html_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(17, 3, 'blocks/html_block.tpl', '[[regtime]]', '[[regtime]]'),
(17, 4, 'blocks/html_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(17, 5, 'blocks/html_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(17, 6, 'blocks/html_block.tpl', '[[regtime]]', '[[regtime]]'),
(17, 7, 'blocks/html_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(17, 8, 'blocks/html_block_footer.tpl', '[[regtime]]', '[[regtime]]'),
(18, 3, 'blocks/bestseller.tpl', '[[regtime]]', '[[regtime]]'),
(18, 5, 'blocks/bestseller_home.tpl', '[[regtime]]', '[[regtime]]'),
(18, 6, 'blocks/bestseller.tpl', '[[regtime]]', '[[regtime]]'),
(19, 3, 'blocks/featured.tpl', '[[regtime]]', '[[regtime]]'),
(19, 5, 'blocks/featured_home.tpl', '[[regtime]]', '[[regtime]]'),
(19, 6, 'blocks/featured.tpl', '[[regtime]]', '[[regtime]]'),
(20, 1, 'blocks/listing_block_header.tpl', '[[regtime]]', '[[regtime]]'),
(20, 2, 'blocks/listing_block_header_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(20, 3, 'blocks/listing_block_column_left.tpl', '[[regtime]]', '[[regtime]]'),
(20, 4, 'blocks/listing_block_content_top.tpl', '[[regtime]]', '[[regtime]]'),
(20, 5, 'blocks/listing_block_content_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(20, 6, 'blocks/listing_block_column_right.tpl', '[[regtime]]', '[[regtime]]'),
(20, 7, 'blocks/listing_block_footer_top.tpl', '[[regtime]]', '[[regtime]]'),
(20, 8, 'blocks/listing_block_footer.tpl', '[[regtime]]', '[[regtime]]'),
(21, 8, 'blocks/donate.tpl', '[[regtime]]', '[[regtime]]'),
(22, 3, 'blocks/special.tpl', '[[regtime]]', '[[regtime]]'),
(22, 5, 'blocks/special_home.tpl', '[[regtime]]', '[[regtime]]'),
(22, 6, 'blocks/special.tpl', '[[regtime]]', '[[regtime]]'),
(23, 1, 'blocks/banner_block_header.tpl', '[[regtime]]', '[[regtime]]'),
(23, 2, 'blocks/banner_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(23, 3, 'blocks/banner_block.tpl', '[[regtime]]', '[[regtime]]'),
(23, 4, 'blocks/banner_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(23, 5, 'blocks/banner_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(23, 6, 'blocks/banner_block.tpl', '[[regtime]]', '[[regtime]]'),
(23, 7, 'blocks/banner_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(23, 8, 'blocks/banner_block_header.tpl', '[[regtime]]', '[[regtime]]'),
(24, 8, 'blocks/credit_cards.tpl', '[[regtime]]', '[[regtime]]'),
(25, 1, 'blocks/newsletter_signup_header.tpl', '[[regtime]]', '[[regtime]]'),
(25, 2, 'blocks/newsletter_signup_header_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(25, 3, 'blocks/newsletter_signup_column_left.tpl', '[[regtime]]', '[[regtime]]'),
(25, 4, 'blocks/newsletter_signup_content_top.tpl', '[[regtime]]', '[[regtime]]'),
(25, 5, 'blocks/newsletter_signup_content_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(25, 6, 'blocks/newsletter_signup_column_right.tpl', '[[regtime]]', '[[regtime]]'),
(25, 7, 'blocks/newsletter_signup_footer_top.tpl', '[[regtime]]', '[[regtime]]'),
(25, 8, 'blocks/newsletter_signup_footer.tpl', '[[regtime]]', '[[regtime]]'),
(26, 1, 'blocks/search_top.tpl', '[[regtime]]', '[[regtime]]'),
(26, 2, 'blocks/search_top.tpl', '[[regtime]]', '[[regtime]]'),
(26, 3, 'blocks/search.tpl', '[[regtime]]', '[[regtime]]'),
(26, 6, 'blocks/search.tpl', '[[regtime]]', '[[regtime]]'),
(27, 1, 'blocks/menu_top.tpl', '[[regtime]]', '[[regtime]]'),
(27, 2, 'blocks/menu.tpl', '[[regtime]]', '[[regtime]]'),
(27, 3, 'blocks/menu.tpl', '[[regtime]]', '[[regtime]]'),
(27, 6, 'blocks/menu.tpl', '[[regtime]]', '[[regtime]]'),
(27, 8, 'blocks/menu_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(28, 2, 'blocks/breadcrumbs.tpl', '[[regtime]]', '[[regtime]]'),
(29, 3, 'blocks/account.tpl', '[[regtime]]', '[[regtime]]'),
(29, 6, 'blocks/account.tpl', '[[regtime]]', '[[regtime]]'),
(30, 1, 'blocks/custom_form_block_header.tpl', '[[regtime]]', '[[regtime]]'),
(30, 2, 'blocks/custom_form_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(30, 3, 'blocks/custom_form_block.tpl', '[[regtime]]', '[[regtime]]'),
(30, 4, 'blocks/custom_form_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(30, 5, 'blocks/custom_form_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(30, 6, 'blocks/custom_form_block.tpl', '[[regtime]]', '[[regtime]]'),
(30, 7, 'blocks/custom_form_block_content.tpl', '[[regtime]]', '[[regtime]]'),
(30, 8, 'blocks/custom_form_block_header.tpl', '[[regtime]]', '[[regtime]]'),
(31, 1, 'blocks/customer.tpl', '[[regtime]]', '[[regtime]]'),
(32, 1, 'blocks/fast_checkout_cart_btn.tpl', '[[regtime]]', '[[regtime]]'),
(33, 6, 'blocks/fast_checkout_summary.tpl', '[[regtime]]', '[[regtime]]'),
(34, 1, 'blocks/viewed_block_column_header.tpl', '[[regtime]]', '[[regtime]]'),
(34, 2, 'blocks/viewed_block_column_header_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(34, 3, 'blocks/viewed_block_column_left.tpl', '[[regtime]]', '[[regtime]]'),
(34, 4, 'blocks/viewed_block_column_content_top.tpl', '[[regtime]]', '[[regtime]]'),
(34, 5, 'blocks/viewed_block_column_footer_top.tpl', '[[regtime]]', '[[regtime]]'),
(34, 6, 'blocks/viewed_block_column_right.tpl', '[[regtime]]', '[[regtime]]'),
(34, 7, 'blocks/viewed_block_column_footer_top.tpl', '[[regtime]]', '[[regtime]]'),
(34, 8, 'blocks/viewed_block_column_footer.tpl', '[[regtime]]', '[[regtime]]'),
(35, 3, 'blocks/new_content.tpl', '[[regtime]]', '[[regtime]]'),
(35, 6, 'blocks/new_content.tpl', '[[regtime]]', '[[regtime]]'),
(36, 1, 'blocks/content_search.tpl', '[[regtime]]', '[[regtime]]'),
(36, 2, 'blocks/content_search.tpl', '[[regtime]]', '[[regtime]]'),
(36, 3, 'blocks/content_search.tpl', '[[regtime]]', '[[regtime]]'),
(36, 4, 'blocks/content_search.tpl', '[[regtime]]', '[[regtime]]'),
(36, 5, 'blocks/content_search.tpl', '[[regtime]]', '[[regtime]]'),
(36, 6, 'blocks/content_search.tpl', '[[regtime]]', '[[regtime]]'),
(37, 3, 'blocks/store_hours.tpl', '[[regtime]]', '[[regtime]]'),
(37, 6, 'blocks/store_hours.tpl', '[[regtime]]', '[[regtime]]'),
(38, 1, 'blocks/mega_menu_header.tpl', '[[regtime]]', '[[regtime]]'),
(38, 2, 'blocks/mega_menu_header_bottom.tpl', '[[regtime]]', '[[regtime]]'),
(39, 2, 'blocks/category_slides.tpl', '[[regtime]]', '[[regtime]]'),
(40, 3, 'blocks/category_filter.tpl', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `parent_id` int NOT NULL DEFAULT '0',
  `sort_order` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '1',
  `supplier_code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `[[dbprefix]]categories_supplier_idx` (`supplier_code`,`supplier_id`),
  KEY `[[dbprefix]]categories_idx` (`category_id`,`parent_id`,`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=71 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(36, 0, 1, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(37, 36, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(38, 36, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(39, 36, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(40, 36, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(41, 36, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(42, 36, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(43, 0, 2, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(44, 43, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(45, 43, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(46, 43, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(47, 43, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(48, 43, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(49, 0, 3, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(50, 49, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(51, 49, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(52, 0, 98, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(53, 52, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(54, 52, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(58, 0, 4, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(59, 58, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(60, 58, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(61, 58, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(62, 58, 0, 0, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(63, 58, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(64, 0, 99, 0, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(65, 0, 100, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(66, 65, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(67, 65, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(68, 0, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(69, 68, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(70, 68, 0, 1, NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories_to_stores`
--

CREATE TABLE `[[dbprefix]]categories_to_stores` (
  `category_id` int NOT NULL,
  `store_id` int NOT NULL,
  PRIMARY KEY (`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]categories_to_stores`
--

INSERT INTO `[[dbprefix]]categories_to_stores` VALUES
(36, 0),
(37, 0),
(38, 0),
(39, 0),
(40, 0),
(41, 0),
(42, 0),
(43, 0),
(44, 0),
(45, 0),
(46, 0),
(47, 0),
(48, 0),
(49, 0),
(50, 0),
(51, 0),
(52, 0),
(53, 0),
(54, 0),
(58, 0),
(59, 0),
(60, 0),
(61, 0),
(62, 0),
(63, 0),
(64, 0),
(65, 0),
(66, 0),
(67, 0),
(68, 0),
(69, 0),
(70, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]category_descriptions`
--

CREATE TABLE `[[dbprefix]]category_descriptions` (
  `category_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `meta_keywords` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`category_id`,`language_id`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]category_descriptions`
--

INSERT INTO `[[dbprefix]]category_descriptions` VALUES
(36, 1, 'Makeup', 'Makeup', '', '&lt;p&gt;\r\n	All your makeup needs, from foundation to eye shadow in hundreds of different assortments and colors.&lt;/p&gt;\r\n'),
(37, 1, 'Value Sets', 'value sets makeup', '', ''),
(38, 1, 'Face', '', '', ''),
(39, 1, 'Eyes', '', '', ''),
(40, 1, 'Cheeks', '', '', ''),
(41, 1, 'Lips', '', '', ''),
(42, 1, 'Nails', '', '', ''),
(43, 1, 'Skincare', '', '', '&lt;p&gt;\r\n	Products from award-winning skin care brands&lt;/p&gt;\r\n'),
(44, 1, 'Sun', '', '', ''),
(45, 1, 'Gift Ideas &amp; Sets', '', '', ''),
(46, 1, 'Facial', '', '', '&lt;p&gt;\r\n	Find face skin care solutions&lt;/p&gt;\r\n'),
(47, 1, 'Eye Care', '', '', ''),
(48, 1, 'Hands &amp; Nails', '', '', '&lt;p&gt;\r\n	Keep your hands looking fresh&lt;/p&gt;\r\n'),
(49, 1, 'Fragrance', '', '', '&lt;p&gt;\r\n	Looking for a new scent? Check out our fragrance&lt;/p&gt;\r\n'),
(50, 1, 'Women', '', '', '&lt;p&gt;\r\n	Fragrance for Women&lt;/p&gt;\r\n'),
(51, 1, 'Men', '', '', ''),
(52, 1, 'Hair Care', '', '', '&lt;p&gt;\r\n	The widest range of premium hair products&lt;/p&gt;\r\n'),
(53, 1, 'Shampoo', '', '', ''),
(54, 1, 'Conditioner', '', '', ''),
(58, 1, 'Men', '', '', ''),
(59, 1, 'Fragrance Sets', '', '', ''),
(60, 1, 'Skincare', '', '', ''),
(61, 1, 'Pre-Shave &amp; Shaving', '', '', ''),
(62, 1, 'Post-Shave &amp; Moisturizers', '', '', ''),
(63, 1, 'Body &amp; Shower', '', '', ''),
(64, 1, 'Bath &amp; Body', '', '', ''),
(65, 1, 'Books', '', '', 'Find the Items You&amp;#39;d Like to read'),
(66, 1, 'Audio CD', '', '', ''),
(67, 1, 'Paperback', '', '', ''),
(68, 1, 'Apparel &amp; accessories', '', '', ''),
(69, 1, 'Shoes', '', '', ''),
(70, 1, 'T-shirts', '', '', 'Shop men&amp;#39;s T-shirts');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]collections`
--

CREATE TABLE `[[dbprefix]]collections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `status` tinyint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin,
  `conditions` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin,
  `store_id` int NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]collection_descriptions`
--

CREATE TABLE `[[dbprefix]]collection_descriptions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `collection_id` int NOT NULL,
  `language_id` int NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `meta_keywords` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin,
  `meta_description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `collection_language_idx` (`collection_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contents`
--

CREATE TABLE `[[dbprefix]]contents` (
  `content_id` int NOT NULL AUTO_INCREMENT,
  `parent_content_id` int NOT NULL DEFAULT '0',
  `sort_order` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '0',
  `content_bar` int NOT NULL DEFAULT '0',
  `author` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `icon_rl_id` int DEFAULT NULL,
  `publish_date` timestamp NULL DEFAULT NULL,
  `expire_date` timestamp NULL DEFAULT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]contents`
--

INSERT INTO `[[dbprefix]]contents` VALUES
(1, 0, 1, 1, 0, '', NULL, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(2, 0, 2, 1, 0, '', NULL, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(3, 0, 3, 1, 0, '', NULL, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(4, 0, 4, 1, 0, '', NULL, NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contents_to_stores`
--

CREATE TABLE `[[dbprefix]]contents_to_stores` (
  `content_id` int NOT NULL,
  `store_id` int NOT NULL,
  PRIMARY KEY (`content_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]contents_to_stores`
--

INSERT INTO `[[dbprefix]]contents_to_stores` VALUES
(1, 0),
(2, 0),
(3, 0),
(4, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_descriptions`
--

CREATE TABLE `[[dbprefix]]content_descriptions` (
  `content_id` int NOT NULL DEFAULT '0',
  `language_id` int NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `meta_keywords` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`content_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]content_descriptions`
--

INSERT INTO `[[dbprefix]]content_descriptions` VALUES
(1, 1, 'About Us', 'some description', '', '', 'text about your store', '[[regtime]]', '[[regtime]]'),
(2, 1, 'Privacy Policy', 'some description', '', '', 'some text about privacy policy', '[[regtime]]', '[[regtime]]'),
(3, 1, 'Return Policy', 'some description', '', '', 'some text about return policy', '[[regtime]]', '[[regtime]]'),
(4, 1, 'Shipping', 'some description', '', '', 'some text about shipping', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_tags`
--

CREATE TABLE `[[dbprefix]]content_tags` (
  `content_id` int NOT NULL,
  `tag` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `language_id` int NOT NULL,
  PRIMARY KEY (`content_id`,`tag`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `country_id` int NOT NULL AUTO_INCREMENT,
  `iso_code_2` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `iso_code_3` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `address_format` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL DEFAULT '1',
  `sort_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`country_id`),
  KEY `[[dbprefix]]countries_idx` (`iso_code_2`,`iso_code_3`,`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=244 ;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
(1, 'AF', 'AFG', '', 1, 0),
(2, 'AL', 'ALB', '', 1, 0),
(3, 'DZ', 'DZA', '', 1, 0),
(4, 'AS', 'ASM', '', 1, 0),
(5, 'AD', 'AND', '', 1, 0),
(6, 'AO', 'AGO', '', 1, 0),
(7, 'AI', 'AIA', '', 1, 0),
(8, 'AQ', 'ATA', '', 1, 0),
(9, 'AG', 'ATG', '', 1, 0),
(10, 'AR', 'ARG', '', 1, 0),
(11, 'AM', 'ARM', '', 1, 0),
(12, 'AW', 'ABW', '', 1, 0),
(13, 'AU', 'AUS', '', 1, 0),
(14, 'AT', 'AUT', '', 1, 0),
(15, 'AZ', 'AZE', '', 1, 0),
(16, 'BS', 'BHS', '', 1, 0),
(17, 'BH', 'BHR', '', 1, 0),
(18, 'BD', 'BGD', '', 1, 0),
(19, 'BB', 'BRB', '', 1, 0),
(20, 'BY', 'BLR', '', 1, 0),
(21, 'BE', 'BEL', '', 1, 0),
(22, 'BZ', 'BLZ', '', 1, 0),
(23, 'BJ', 'BEN', '', 1, 0),
(24, 'BM', 'BMU', '', 1, 0),
(25, 'BT', 'BTN', '', 1, 0),
(26, 'BO', 'BOL', '', 1, 0),
(27, 'BA', 'BIH', '', 1, 0),
(28, 'BW', 'BWA', '', 1, 0),
(29, 'BV', 'BVT', '', 1, 0),
(30, 'BR', 'BRA', '', 1, 0),
(31, 'IO', 'IOT', '', 1, 0),
(32, 'BN', 'BRN', '', 1, 0),
(33, 'BG', 'BGR', '', 1, 0),
(34, 'BF', 'BFA', '', 1, 0),
(35, 'BI', 'BDI', '', 1, 0),
(36, 'KH', 'KHM', '', 1, 0),
(37, 'CM', 'CMR', '', 1, 0),
(38, 'CA', 'CAN', '', 1, 0),
(39, 'CV', 'CPV', '', 1, 0),
(40, 'KY', 'CYM', '', 1, 0),
(41, 'CF', 'CAF', '', 1, 0),
(42, 'TD', 'TCD', '', 1, 0),
(43, 'CL', 'CHL', '', 1, 0),
(44, 'CN', 'CHN', '', 1, 0),
(45, 'CX', 'CXR', '', 1, 0),
(46, 'CC', 'CCK', '', 1, 0),
(47, 'CO', 'COL', '', 1, 0),
(48, 'KM', 'COM', '', 1, 0),
(49, 'CG', 'COG', '', 1, 0),
(50, 'CK', 'COK', '', 1, 0),
(51, 'CR', 'CRI', '', 1, 0),
(52, 'CI', 'CIV', '', 1, 0),
(53, 'HR', 'HRV', '', 1, 0),
(54, 'CU', 'CUB', '', 1, 0),
(55, 'CY', 'CYP', '', 1, 0),
(56, 'CZ', 'CZE', '', 1, 0),
(57, 'DK', 'DNK', '', 1, 0),
(58, 'DJ', 'DJI', '', 1, 0),
(59, 'DM', 'DMA', '', 1, 0),
(60, 'DO', 'DOM', '', 1, 0),
(61, 'TL', 'TLS', '', 1, 0),
(62, 'EC', 'ECU', '', 1, 0),
(63, 'EG', 'EGY', '', 1, 0),
(64, 'SV', 'SLV', '', 1, 0),
(65, 'GQ', 'GNQ', '', 1, 0),
(66, 'ER', 'ERI', '', 1, 0),
(67, 'EE', 'EST', '', 1, 0),
(68, 'ET', 'ETH', '', 1, 0),
(69, 'FK', 'FLK', '', 1, 0),
(70, 'FO', 'FRO', '', 1, 0),
(71, 'FJ', 'FJI', '', 1, 0),
(72, 'FI', 'FIN', '', 1, 0),
(73, 'FR', 'FRA', '', 1, 0),
(74, 'FX', 'FXX', '', 1, 0),
(75, 'GF', 'GUF', '', 1, 0),
(76, 'PF', 'PYF', '', 1, 0),
(77, 'TF', 'ATF', '', 1, 0),
(78, 'GA', 'GAB', '', 1, 0),
(79, 'GM', 'GMB', '', 1, 0),
(80, 'GE', 'GEO', '', 1, 0),
(81, 'DE', 'DEU', '', 1, 0),
(82, 'GH', 'GHA', '', 1, 0),
(83, 'GI', 'GIB', '', 1, 0),
(84, 'GR', 'GRC', '', 1, 0),
(85, 'GL', 'GRL', '', 1, 0),
(86, 'GD', 'GRD', '', 1, 0),
(87, 'GP', 'GLP', '', 1, 0),
(88, 'GU', 'GUM', '', 1, 0),
(89, 'GT', 'GTM', '', 1, 0),
(90, 'GN', 'GIN', '', 1, 0),
(91, 'GW', 'GNB', '', 1, 0),
(92, 'GY', 'GUY', '', 1, 0),
(93, 'HT', 'HTI', '', 1, 0),
(94, 'HM', 'HMD', '', 1, 0),
(95, 'HN', 'HND', '', 1, 0),
(96, 'HK', 'HKG', '', 1, 0),
(97, 'HU', 'HUN', '', 1, 0),
(98, 'IS', 'ISL', '', 1, 0),
(99, 'IN', 'IND', '', 1, 0),
(100, 'ID', 'IDN', '', 1, 0),
(101, 'IR', 'IRN', '', 1, 0),
(102, 'IQ', 'IRQ', '', 1, 0),
(103, 'IE', 'IRL', '', 1, 0),
(104, 'IL', 'ISR', '', 1, 0),
(105, 'IT', 'ITA', '', 1, 0),
(106, 'JM', 'JAM', '', 1, 0),
(107, 'JP', 'JPN', '', 1, 0),
(108, 'JO', 'JOR', '', 1, 0),
(109, 'KZ', 'KAZ', '', 1, 0),
(110, 'KE', 'KEN', '', 1, 0),
(111, 'KI', 'KIR', '', 1, 0),
(112, 'KP', 'PRK', '', 1, 0),
(113, 'KR', 'KOR', '', 1, 0),
(114, 'KW', 'KWT', '', 1, 0),
(115, 'KG', 'KGZ', '', 1, 0),
(116, 'LA', 'LAO', '', 1, 0),
(117, 'LV', 'LVA', '', 1, 0),
(118, 'LB', 'LBN', '', 1, 0),
(119, 'LS', 'LSO', '', 1, 0),
(120, 'LR', 'LBR', '', 1, 0),
(121, 'LY', 'LBY', '', 1, 0),
(122, 'LI', 'LIE', '', 1, 0),
(123, 'LT', 'LTU', '', 1, 0),
(124, 'LU', 'LUX', '', 1, 0),
(125, 'MO', 'MAC', '', 1, 0),
(126, 'MK', 'MKD', '', 1, 0),
(127, 'MG', 'MDG', '', 1, 0),
(128, 'MW', 'MWI', '', 1, 0),
(129, 'MY', 'MYS', '', 1, 0),
(130, 'MV', 'MDV', '', 1, 0),
(131, 'ML', 'MLI', '', 1, 0),
(132, 'MT', 'MLT', '', 1, 0),
(133, 'MH', 'MHL', '', 1, 0),
(134, 'MQ', 'MTQ', '', 1, 0),
(135, 'MR', 'MRT', '', 1, 0),
(136, 'MU', 'MUS', '', 1, 0),
(137, 'YT', 'MYT', '', 1, 0),
(138, 'MX', 'MEX', '', 1, 0),
(139, 'FM', 'FSM', '', 1, 0),
(140, 'MD', 'MDA', '', 1, 0),
(141, 'MC', 'MCO', '', 1, 0),
(142, 'MN', 'MNG', '', 1, 0),
(143, 'MS', 'MSR', '', 1, 0),
(144, 'MA', 'MAR', '', 1, 0),
(145, 'MZ', 'MOZ', '', 1, 0),
(146, 'MM', 'MMR', '', 1, 0),
(147, 'NA', 'NAM', '', 1, 0),
(148, 'NR', 'NRU', '', 1, 0),
(149, 'NP', 'NPL', '', 1, 0),
(150, 'NL', 'NLD', '', 1, 0),
(151, 'AN', 'ANT', '', 1, 0),
(152, 'NC', 'NCL', '', 1, 0),
(153, 'NZ', 'NZL', '', 1, 0),
(154, 'NI', 'NIC', '', 1, 0),
(155, 'NE', 'NER', '', 1, 0),
(156, 'NG', 'NGA', '', 1, 0),
(157, 'NU', 'NIU', '', 1, 0),
(158, 'NF', 'NFK', '', 1, 0),
(159, 'MP', 'MNP', '', 1, 0),
(160, 'NO', 'NOR', '', 1, 0),
(161, 'OM', 'OMN', '', 1, 0),
(162, 'PK', 'PAK', '', 1, 0),
(163, 'PW', 'PLW', '', 1, 0),
(164, 'PA', 'PAN', '', 1, 0),
(165, 'PG', 'PNG', '', 1, 0),
(166, 'PY', 'PRY', '', 1, 0),
(167, 'PE', 'PER', '', 1, 0),
(168, 'PH', 'PHL', '', 1, 0),
(169, 'PN', 'PCN', '', 1, 0),
(170, 'PL', 'POL', '', 1, 0),
(171, 'PT', 'PRT', '', 1, 0),
(172, 'PR', 'PRI', '', 1, 0),
(173, 'QA', 'QAT', '', 1, 0),
(174, 'RE', 'REU', '', 1, 0),
(175, 'RO', 'ROM', '', 1, 0),
(176, 'RU', 'RUS', '', 1, 0),
(177, 'RW', 'RWA', '', 1, 0),
(178, 'KN', 'KNA', '', 1, 0),
(179, 'LC', 'LCA', '', 1, 0),
(180, 'VC', 'VCT', '', 1, 0),
(181, 'WS', 'WSM', '', 1, 0),
(182, 'SM', 'SMR', '', 1, 0),
(183, 'ST', 'STP', '', 1, 0),
(184, 'SA', 'SAU', '', 1, 0),
(185, 'SN', 'SEN', '', 1, 0),
(186, 'SC', 'SYC', '', 1, 0),
(187, 'SL', 'SLE', '', 1, 0),
(188, 'SG', 'SGP', '', 1, 0),
(189, 'SK', 'SVK', '', 1, 0),
(190, 'SI', 'SVN', '', 1, 0),
(191, 'SB', 'SLB', '', 1, 0),
(192, 'SO', 'SOM', '', 1, 0),
(193, 'ZA', 'ZAF', '', 1, 0),
(194, 'GS', 'SGS', '', 1, 0),
(195, 'ES', 'ESP', '', 1, 0),
(196, 'LK', 'LKA', '', 1, 0),
(197, 'SH', 'SHN', '', 1, 0),
(198, 'PM', 'SPM', '', 1, 0),
(199, 'SD', 'SDN', '', 1, 0),
(200, 'SR', 'SUR', '', 1, 0),
(201, 'SJ', 'SJM', '', 1, 0),
(202, 'SZ', 'SWZ', '', 1, 0),
(203, 'SE', 'SWE', '', 1, 0),
(204, 'CH', 'CHE', '', 1, 0),
(205, 'SY', 'SYR', '', 1, 0),
(206, 'TW', 'TWN', '', 1, 0),
(207, 'TJ', 'TJK', '', 1, 0),
(208, 'TZ', 'TZA', '', 1, 0),
(209, 'TH', 'THA', '', 1, 0),
(210, 'TG', 'TGO', '', 1, 0),
(211, 'TK', 'TKL', '', 1, 0),
(212, 'TO', 'TON', '', 1, 0),
(213, 'TT', 'TTO', '', 1, 0),
(214, 'TN', 'TUN', '', 1, 0),
(215, 'TR', 'TUR', '', 1, 0),
(216, 'TM', 'TKM', '', 1, 0),
(217, 'TC', 'TCA', '', 1, 0),
(218, 'TV', 'TUV', '', 1, 0),
(219, 'UG', 'UGA', '', 1, 0),
(220, 'UA', 'UKR', '', 1, 0),
(221, 'AE', 'ARE', '', 1, 0),
(222, 'GB', 'GBR', '', 1, 0),
(223, 'US', 'USA', '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 1, 0),
(224, 'UM', 'UMI', '', 1, 0),
(225, 'UY', 'URY', '', 1, 0),
(226, 'UZ', 'UZB', '', 1, 0),
(227, 'VU', 'VUT', '', 1, 0),
(228, 'VA', 'VAT', '', 1, 0),
(229, 'VE', 'VEN', '', 1, 0),
(230, 'VN', 'VNM', '', 1, 0),
(231, 'VG', 'VGB', '', 1, 0),
(232, 'VI', 'VIR', '', 1, 0),
(233, 'WF', 'WLF', '', 1, 0),
(234, 'EH', 'ESH', '', 1, 0),
(235, 'YE', 'YEM', '', 1, 0),
(236, 'ME', 'MNE', '', 1, 0),
(237, 'CW', 'CUW', '', 1, 0),
(238, 'ZM', 'ZMB', '', 1, 0),
(239, 'ZW', 'ZWE', '', 1, 0),
(240, 'GB', 'NIR', '', 1, 0),
(241, 'RS', 'SRB', '', 1, 0),
(242, 'XK', 'XXK', '', 1, 0),
(243, 'SS', 'RSS', '', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]country_descriptions`
--

CREATE TABLE `[[dbprefix]]country_descriptions` (
  `country_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`country_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]country_descriptions`
--

INSERT INTO `[[dbprefix]]country_descriptions` VALUES
(1, 1, 'Afghanistan'),
(2, 1, 'Albania'),
(3, 1, 'Algeria'),
(4, 1, 'American Samoa'),
(5, 1, 'Andorra'),
(6, 1, 'Angola'),
(7, 1, 'Anguilla'),
(8, 1, 'Antarctica'),
(9, 1, 'Antigua and Barbuda'),
(10, 1, 'Argentina'),
(11, 1, 'Armenia'),
(12, 1, 'Aruba'),
(13, 1, 'Australia'),
(14, 1, 'Austria'),
(15, 1, 'Azerbaijan'),
(16, 1, 'Bahamas'),
(17, 1, 'Bahrain'),
(18, 1, 'Bangladesh'),
(19, 1, 'Barbados'),
(20, 1, 'Belarus'),
(21, 1, 'Belgium'),
(22, 1, 'Belize'),
(23, 1, 'Benin'),
(24, 1, 'Bermuda'),
(25, 1, 'Bhutan'),
(26, 1, 'Bolivia'),
(27, 1, 'Bosnia and Herzegowina'),
(28, 1, 'Botswana'),
(29, 1, 'Bouvet Island'),
(30, 1, 'Brazil'),
(31, 1, 'British Indian Ocean Territory'),
(32, 1, 'Brunei Darussalam'),
(33, 1, 'Bulgaria'),
(34, 1, 'Burkina Faso'),
(35, 1, 'Burundi'),
(36, 1, 'Cambodia'),
(37, 1, 'Cameroon'),
(38, 1, 'Canada'),
(39, 1, 'Cabo Verde'),
(40, 1, 'Cayman Islands'),
(41, 1, 'Central African Republic'),
(42, 1, 'Chad'),
(43, 1, 'Chile'),
(44, 1, 'China'),
(45, 1, 'Christmas Island'),
(46, 1, 'Cocos (Keeling) Islands'),
(47, 1, 'Colombia'),
(48, 1, 'Comoros'),
(49, 1, 'Congo'),
(50, 1, 'Cook Islands'),
(51, 1, 'Costa Rica'),
(52, 1, 'Côte d''Ivoire'),
(53, 1, 'Croatia'),
(54, 1, 'Cuba'),
(55, 1, 'Cyprus'),
(56, 1, 'Czech Republic'),
(57, 1, 'Denmark'),
(58, 1, 'Djibouti'),
(59, 1, 'Dominica'),
(60, 1, 'Dominican Republic'),
(61, 1, 'Timor-Leste'),
(62, 1, 'Ecuador'),
(63, 1, 'Egypt'),
(64, 1, 'El Salvador'),
(65, 1, 'Equatorial Guinea'),
(66, 1, 'Eritrea'),
(67, 1, 'Estonia'),
(68, 1, 'Ethiopia'),
(69, 1, 'Falkland Islands (Malvinas)'),
(70, 1, 'Faroe Islands'),
(71, 1, 'Fiji'),
(72, 1, 'Finland'),
(73, 1, 'France'),
(74, 1, 'France, Metropolitan'),
(75, 1, 'French Guiana'),
(76, 1, 'French Polynesia'),
(77, 1, 'French Southern Territories'),
(78, 1, 'Gabon'),
(79, 1, 'Gambia'),
(80, 1, 'Georgia'),
(81, 1, 'Germany'),
(82, 1, 'Ghana'),
(83, 1, 'Gibraltar'),
(84, 1, 'Greece'),
(85, 1, 'Greenland'),
(86, 1, 'Grenada'),
(87, 1, 'Guadeloupe'),
(88, 1, 'Guam'),
(89, 1, 'Guatemala'),
(90, 1, 'Guinea'),
(91, 1, 'Guinea-bissau'),
(92, 1, 'Guyana'),
(93, 1, 'Haiti'),
(94, 1, 'Heard and Mc Donald Islands'),
(95, 1, 'Honduras'),
(96, 1, 'Hong Kong'),
(97, 1, 'Hungary'),
(98, 1, 'Iceland'),
(99, 1, 'India'),
(100, 1, 'Indonesia'),
(101, 1, 'Iran (Islamic Republic of)'),
(102, 1, 'Iraq'),
(103, 1, 'Ireland'),
(104, 1, 'Israel'),
(105, 1, 'Italy'),
(106, 1, 'Jamaica'),
(107, 1, 'Japan'),
(108, 1, 'Jordan'),
(109, 1, 'Kazakhstan'),
(110, 1, 'Kenya'),
(111, 1, 'Kiribati'),
(112, 1, 'North Korea'),
(113, 1, 'Korea, Republic of'),
(114, 1, 'Kuwait'),
(115, 1, 'Kyrgyzstan'),
(116, 1, 'Lao People''s Democratic Republic'),
(117, 1, 'Latvia'),
(118, 1, 'Lebanon'),
(119, 1, 'Lesotho'),
(120, 1, 'Liberia'),
(121, 1, 'Libyan Arab Jamahiriya'),
(122, 1, 'Liechtenstein'),
(123, 1, 'Lithuania'),
(124, 1, 'Luxembourg'),
(125, 1, 'Macau'),
(126, 1, 'North Macedonia'),
(127, 1, 'Madagascar'),
(128, 1, 'Malawi'),
(129, 1, 'Malaysia'),
(130, 1, 'Maldives'),
(131, 1, 'Mali'),
(132, 1, 'Malta'),
(133, 1, 'Marshall Islands'),
(134, 1, 'Martinique'),
(135, 1, 'Mauritania'),
(136, 1, 'Mauritius'),
(137, 1, 'Mayotte'),
(138, 1, 'Mexico'),
(139, 1, 'Micronesia, Federated States of'),
(140, 1, 'Moldova, Republic of'),
(141, 1, 'Monaco'),
(142, 1, 'Mongolia'),
(143, 1, 'Montserrat'),
(144, 1, 'Morocco'),
(145, 1, 'Mozambique'),
(146, 1, 'Myanmar'),
(147, 1, 'Namibia'),
(148, 1, 'Nauru'),
(149, 1, 'Nepal'),
(150, 1, 'Netherlands'),
(151, 1, 'Netherlands Antilles'),
(152, 1, 'New Caledonia'),
(153, 1, 'New Zealand'),
(154, 1, 'Nicaragua'),
(155, 1, 'Niger'),
(156, 1, 'Nigeria'),
(157, 1, 'Niue'),
(158, 1, 'Norfolk Island'),
(159, 1, 'Northern Mariana Islands'),
(160, 1, 'Norway'),
(161, 1, 'Oman'),
(162, 1, 'Pakistan'),
(163, 1, 'Palau'),
(164, 1, 'Panama'),
(165, 1, 'Papua New Guinea'),
(166, 1, 'Paraguay'),
(167, 1, 'Peru'),
(168, 1, 'Philippines'),
(169, 1, 'Pitcairn'),
(170, 1, 'Poland'),
(171, 1, 'Portugal'),
(172, 1, 'Puerto Rico'),
(173, 1, 'Qatar'),
(174, 1, 'Reunion'),
(175, 1, 'Romania'),
(176, 1, 'Russia'),
(177, 1, 'Rwanda'),
(178, 1, 'Saint Kitts and Nevis'),
(179, 1, 'Saint Lucia'),
(180, 1, 'Saint Vincent and the Grenadines'),
(181, 1, 'Samoa'),
(182, 1, 'San Marino'),
(183, 1, 'Sao Tome and Principe'),
(184, 1, 'Saudi Arabia'),
(185, 1, 'Senegal'),
(186, 1, 'Seychelles'),
(187, 1, 'Sierra Leone'),
(188, 1, 'Singapore'),
(189, 1, 'Slovak Republic'),
(190, 1, 'Slovenia'),
(191, 1, 'Solomon Islands'),
(192, 1, 'Somalia'),
(193, 1, 'South Africa'),
(194, 1, 'South Georgia &amp; South Sandwich Islands'),
(195, 1, 'Spain'),
(196, 1, 'Sri Lanka'),
(197, 1, 'St. Helena'),
(198, 1, 'St. Pierre and Miquelon'),
(199, 1, 'Sudan'),
(200, 1, 'Suriname'),
(201, 1, 'Svalbard and Jan Mayen Islands'),
(202, 1, 'Eswatini'),
(203, 1, 'Sweden'),
(204, 1, 'Switzerland'),
(205, 1, 'Syrian Arab Republic'),
(206, 1, 'Taiwan'),
(207, 1, 'Tajikistan'),
(208, 1, 'Tanzania, United Republic of'),
(209, 1, 'Thailand'),
(210, 1, 'Togo'),
(211, 1, 'Tokelau'),
(212, 1, 'Tonga'),
(213, 1, 'Trinidad and Tobago'),
(214, 1, 'Tunisia'),
(215, 1, 'Turkey'),
(216, 1, 'Turkmenistan'),
(217, 1, 'Turks and Caicos Islands'),
(218, 1, 'Tuvalu'),
(219, 1, 'Uganda'),
(220, 1, 'Ukraine'),
(221, 1, 'United Arab Emirates'),
(222, 1, 'United Kingdom'),
(223, 1, 'United States'),
(224, 1, 'United States Minor Outlying Islands'),
(225, 1, 'Uruguay'),
(226, 1, 'Uzbekistan'),
(227, 1, 'Vanuatu'),
(228, 1, 'Vatican City State (Holy See)'),
(229, 1, 'Venezuela'),
(230, 1, 'Viet Nam'),
(231, 1, 'Virgin Islands (British)'),
(232, 1, 'Virgin Islands (U.S.)'),
(233, 1, 'Wallis and Futuna Islands'),
(234, 1, 'Western Sahara'),
(235, 1, 'Yemen'),
(236, 1, 'Montenegro'),
(237, 1, 'Curaçao'),
(238, 1, 'Zambia'),
(239, 1, 'Zimbabwe'),
(240, 1, 'Northern Ireland'),
(241, 1, 'Serbia'),
(242, 1, 'Kosovo'),
(243, 1, 'South Sudan');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons`
--

CREATE TABLE `[[dbprefix]]coupons` (
  `coupon_id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` decimal(15,4) NOT NULL,
  `logged` int NOT NULL,
  `shipping` int NOT NULL,
  `total` decimal(15,4) NOT NULL,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `uses_total` int NOT NULL,
  `uses_customer` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL,
  `condition_rule` enum('OR','AND') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'OR',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`coupon_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]coupons`
--

INSERT INTO `[[dbprefix]]coupons` VALUES
(4, '2222', 'P', '10.0000', 0, 0, '0.0000', '2021-01-01', '2022-01-01', 30, '3', 0, 'OR', '[[regtime]]', '[[regtime]]'),
(5, '3333', 'P', '0.0000', 0, 1, '100.0000', '2021-01-01', '2022-01-01', 40, '1', 0, 'OR', '[[regtime]]', '[[regtime]]'),
(6, '1111', 'F', '10.0000', 0, 0, '10.0000', '2021-01-01', '2022-01-01', 100, '2', 0, 'OR', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons_categories`
--

CREATE TABLE `[[dbprefix]]coupons_categories` (
  `coupon_category_id` int NOT NULL AUTO_INCREMENT,
  `coupon_id` int NOT NULL,
  `category_id` int NOT NULL,
  PRIMARY KEY (`coupon_category_id`),
  KEY `[[dbprefix]]coupons_categories_idx` (`coupon_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons_products`
--

CREATE TABLE `[[dbprefix]]coupons_products` (
  `coupon_product_id` int NOT NULL AUTO_INCREMENT,
  `coupon_id` int NOT NULL,
  `product_id` int NOT NULL,
  PRIMARY KEY (`coupon_product_id`),
  KEY `[[dbprefix]]coupons_products_idx` (`coupon_id`,`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]coupons_products`
--

INSERT INTO `[[dbprefix]]coupons_products` VALUES
(10, 6, 68);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupon_descriptions`
--

CREATE TABLE `[[dbprefix]]coupon_descriptions` (
  `coupon_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`coupon_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]coupon_descriptions`
--

INSERT INTO `[[dbprefix]]coupon_descriptions` VALUES
(4, 1, 'Coupon (-10%)', '10% Discount'),
(5, 1, 'Coupon (Free Shipping)', 'Free Shipping'),
(6, 1, 'Coupon (-10.00)', 'Fixed Amount Discount');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `currency_id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `symbol_left` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol_right` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_place` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(15,8) NOT NULL,
  `status` int NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`currency_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
(1, 'US Dollar', 'USD', '$', '', '2', '1.00000000', 1, '2011-06-21 01:00:00'),
(2, 'Euro', 'EUR', '', '€', '2', '0.93850000', 1, '2011-06-21 01:00:00'),
(3, 'Pound Sterling', 'GBP', '£', '', '2', '0.79330000', 1, '2011-06-21 01:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers`
--

CREATE TABLE `[[dbprefix]]customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `store_id` int NOT NULL DEFAULT '0',
  `firstname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `loginname` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `telephone` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sms` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'mobile phone number',
  `salt` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cart` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `wishlist` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `newsletter` int NOT NULL DEFAULT '0',
  `address_id` int NOT NULL DEFAULT '0',
  `status` int NOT NULL,
  `approved` int NOT NULL DEFAULT '0',
  `customer_group_id` int NOT NULL,
  `ip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `customers_loginname` (`loginname`),
  KEY `[[dbprefix]]customers_idx` (`store_id`,`address_id`,`customer_group_id`),
  FULLTEXT KEY `[[dbprefix]]customers_name_idx` (`firstname`,`lastname`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]customers`
--

INSERT INTO `[[dbprefix]]customers` VALUES
(2, 0, 'Juliana', 'Davis', 'julidavis@abantecart.com', 'julidavis@abantecart.com', '(602) 141-7191', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 1, 1, 1, 1, '109.104.166.98', NULL, '2013-08-31 18:25:37', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(3, 0, 'Keely', 'Mccoy', 'keelymccoy@abantecart.com', 'keelymccoy@abantecart.com', '(602) 916-1822', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 2, 1, 1, 1, '109.104.166.98', NULL, '2013-08-31 18:39:08', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(4, 0, 'Zelda', 'Weiss', 'zeldaweiss@abantecart.com', 'zeldaweiss@abantecart.com', '(539) 838-9210', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 3, 1, 1, 1, '109.104.166.138', NULL, '2013-08-31 18:42:58', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(5, 0, 'Gloria', 'Macias', 'gloriamacias@abantecart.com', 'gloriamacias@abantecart.com', '(573) 500-2105', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 4, 1, 1, 1, '109.104.166.98', NULL, '2013-08-31 18:46:58', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(6, 0, 'Bernard', 'Horne', 'bernardhorne@abantecart.com', 'bernardhorne@abantecart.com', '(573) 500-2105', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 5, 1, 1, 1, '109.104.166.138', NULL, '2013-08-31 18:50:27', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(7, 0, 'James', 'Curtis', 'jamescurtis@abantecart.com', 'jamescurtis@abantecart.com', '(602) 916-1822', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 6, 1, 1, 1, '109.104.166.138', NULL, '2013-08-31 19:00:03', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(8, 0, 'Bruce', 'Rosarini', 'brucerosarini@abantecart.com', 'brucerosarini@abantecart.com', '(539) 838-9210', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 7, 1, 1, 1, '109.104.166.98', NULL, '2013-08-31 19:08:23', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(9, 0, 'Carlos', 'Compton', 'carloscmpton@abantecart.com', 'carloscmpton@abantecart.com', '(928) 205-0511', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 8, 1, 1, 1, '109.104.166.98', NULL, '2013-08-31 19:13:14', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(10, 0, 'Garrison', 'Baxter', 'garrisonbaxter@abantecart.com', 'garrisonbaxter@abantecart.com', '(803) 189-5001', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 9, 1, 1, 1, '109.104.166.138', NULL, '2013-09-01 16:51:47', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(11, 0, 'Anthony', 'Blair', 'anthonyblair@abantecart.com', 'anthonyblair@abantecart.com', '(402) 456-6398', '', '', '', '6b006ba67f3c172e146991a2ad46d865', 'a:0:{}', NULL, 0, 10, 1, 1, 1, '171.98.12.12', NULL, '2013-09-01 16:54:26', '2015-06-12 13:56:24', '0000-00-00 00:00:00'),
(12, 0, 'Allen', 'Waters', 'allenwaters', 'allenwaters@abantecart.com', '(417) 280-7406', '', '', 'vkmQqxNw', 'e9aa1fed0f5c85e84ef9c9e8860c2732326e790b', 'a:0:{}', NULL, 0, 11, 1, 1, 1, '77.111.246.147', NULL, '2013-09-01 17:12:56', '2019-05-06 10:20:01', '2019-03-18 16:19:54'),
(13, 0, 'Brock', 'Wheeler', 'michael', 'cotan@abantecart.com', '12893654499', '', '', 'QqHpW6DV', '189212083ca9de5f584e624b7a7c256af90fdcfb', 'a:0:{}', 'a:2:{i:108;i:1552911485;i:111;i:1552911579;}', 1, 12, 1, 1, 1, '77.111.246.167', NULL, '2013-09-08 19:28:20', '2022-06-28 12:38:05', '2019-03-18 16:12:59'),
(14, 0, 'Yuri', 'Howard', 'howard566', 'howardinc@abantecart.com', '16943733146', '', '', '1IVINJ6A', '9980a6c101c48ba14277e5fcc7277fed31a8eb34', 'a:0:{}', NULL, 1, 13, 1, 1, 1, '77.111.247.7', 'N;', '2019-03-18 17:37:18', '2022-06-28 12:44:14', '2019-03-18 17:37:18'),
(15, 0, 'Regan', 'Shields', 'RiaGardner', 'ricuvif@abantecart.com', '+1 (267) 125-5153', '', '', 'QaPiKdCR', '30a96d6489cc8089d2f66f1b3407334cfd5a5490', 'a:0:{}', NULL, 1, 14, 1, 1, 1, '23.129.64.106', 'N;', '2019-03-19 12:32:50', '2019-03-19 12:33:16', '2019-03-19 12:32:50'),
(16, 0, 'Randall', 'Richards', 'randallri', 'randallri@abantecart.com', '17887737896', '', '', 'KGtkpKGm', '0664a4c600337892f120b53b81de10646e68ee91', 'a:1:{s:7:"store_0";a:1:{i:96;a:2:{s:3:"qty";i:2;s:7:"options";a:0:{}}}}', NULL, 0, 15, 1, 1, 1, '77.111.247.7', 'N;', '2019-03-21 16:08:29', '2022-06-28 12:48:15', '2022-06-28 12:48:15'),
(17, 0, 'Michelle', 'Barnett', 'mbarnett', 'mbarnett@abantecart.com', '1 469 537-8505', '', '', 'XlUAn9uJ', 'f47de9ec3628658a74e781634caf9a76b1153ee6', NULL, NULL, 0, 17, 1, 1, 1, '', 'N;', '2022-06-28 12:05:34', '2022-06-28 12:06:15', '0000-00-00 00:00:00'),
(18, 0, 'Elmer', 'West', 'X6QDsfu', 'elmer@abantecart.com', ' 1 (128) 392-8036', '', '', 'qkN3jME3', 'c05a1acf9a9c189533b8ce63db274a61e91e622b', 'a:1:{s:7:"store_0";a:0:{}}', NULL, 0, 18, 1, 1, 1, '77.111.246.40', 'N;', '2022-06-28 12:11:49', '2022-07-13 10:51:46', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_groups`
--

CREATE TABLE `[[dbprefix]]customer_groups` (
  `customer_group_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_exempt` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customer_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]customer_groups`
--

INSERT INTO `[[dbprefix]]customer_groups` VALUES
(1, 'Default', 0),
(2, 'Wholesalers', 1),
(3, 'Newsletter Subscribers', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_notifications`
--

CREATE TABLE `[[dbprefix]]customer_notifications` (
  `customer_id` int NOT NULL,
  `sendpoint` varchar(255) NOT NULL,
  `protocol` varchar(30) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_id`,`sendpoint`,`protocol`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_sessions`
--

CREATE TABLE `[[dbprefix]]customer_sessions` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `session_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `last_active` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_id`,`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_transactions`
--

CREATE TABLE `[[dbprefix]]customer_transactions` (
  `customer_transaction_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL DEFAULT '0',
  `order_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL COMMENT 'user_id for admin, customer_id for storefront section',
  `section` smallint NOT NULL DEFAULT '0' COMMENT '1 - admin, 0 - customer',
  `credit` decimal(15,4) DEFAULT '0.0000',
  `debit` decimal(15,4) DEFAULT '0.0000',
  `transaction_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'text type of transaction',
  `comment` text COLLATE utf8mb4_unicode_ci COMMENT 'comment for internal use',
  `description` text COLLATE utf8mb4_unicode_ci COMMENT 'text for customer',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_transaction_id`),
  KEY `[[dbprefix]]customer_transactions_idx` (`customer_id`,`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_blocks`
--

CREATE TABLE `[[dbprefix]]custom_blocks` (
  `custom_block_id` int NOT NULL AUTO_INCREMENT,
  `block_id` int NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`custom_block_id`,`block_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=21 ;

--
-- Dumping data for table `[[dbprefix]]custom_blocks`
--

INSERT INTO `[[dbprefix]]custom_blocks` VALUES
(1, 17, '[[regtime]]', '[[regtime]]'),
(2, 17, '[[regtime]]', '[[regtime]]'),
(3, 17, '[[regtime]]', '[[regtime]]'),
(4, 17, '[[regtime]]', '[[regtime]]'),
(5, 17, '[[regtime]]', '[[regtime]]'),
(6, 17, '[[regtime]]', '[[regtime]]'),
(7, 23, '[[regtime]]', '[[regtime]]'),
(8, 20, '[[regtime]]', '[[regtime]]'),
(9, 17, '[[regtime]]', '[[regtime]]'),
(10, 17, '[[regtime]]', '[[regtime]]'),
(11, 17, '[[regtime]]', '[[regtime]]'),
(12, 17, '[[regtime]]', '[[regtime]]'),
(13, 17, '[[regtime]]', '[[regtime]]'),
(14, 17, '[[regtime]]', '[[regtime]]'),
(15, 17, '[[regtime]]', '[[regtime]]'),
(16, 17, '[[regtime]]', '[[regtime]]'),
(17, 20, '[[regtime]]', '[[regtime]]'),
(18, 17, '[[regtime]]', '[[regtime]]'),
(19, 17, '[[regtime]]', '[[regtime]]'),
(20, 17, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_lists`
--

CREATE TABLE `[[dbprefix]]custom_lists` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `custom_block_id` int NOT NULL,
  `data_type` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` int NOT NULL,
  `store_id` int DEFAULT NULL,
  `sort_order` int NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  KEY `[[dbprefix]]custom_block_id_list_idx` (`custom_block_id`,`store_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]custom_lists`
--

INSERT INTO `[[dbprefix]]custom_lists` VALUES
(1, 12, 'manufacturer_id', 12, 0, 0, '[[regtime]]', '[[regtime]]'),
(2, 12, 'manufacturer_id', 14, 0, 0, '[[regtime]]', '[[regtime]]'),
(3, 12, 'manufacturer_id', 13, 0, 0, '[[regtime]]', '[[regtime]]'),
(4, 12, 'manufacturer_id', 18, 0, 0, '[[regtime]]', '[[regtime]]'),
(5, 12, 'manufacturer_id', 19, 0, 0, '[[regtime]]', '[[regtime]]'),
(6, 12, 'manufacturer_id', 20, 0, 0, '[[regtime]]', '[[regtime]]'),
(7, 12, 'manufacturer_id', 15, 0, 0, '[[regtime]]', '[[regtime]]'),
(8, 12, 'manufacturer_id', 11, 0, 0, '[[regtime]]', '[[regtime]]'),
(9, 12, 'manufacturer_id', 17, 0, 0, '[[regtime]]', '[[regtime]]'),
(10, 12, 'manufacturer_id', 16, 0, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]datasets`
--

CREATE TABLE `[[dbprefix]]datasets` (
  `dataset_id` int NOT NULL AUTO_INCREMENT,
  `dataset_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `dataset_key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT '',
  PRIMARY KEY (`dataset_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]datasets`
--

INSERT INTO `[[dbprefix]]datasets` VALUES
(1, 'menu', 'storefront'),
(2, 'menu', 'admin'),
(3, 'menu', 'storefront_description'),
(4, 'install_upgrade_history', 'admin'),
(5, 'file_uploads', 'admin');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dataset_column_properties`
--

CREATE TABLE `[[dbprefix]]dataset_column_properties` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `dataset_column_id` int NOT NULL,
  `dataset_column_property_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dataset_column_property_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `dataset_column_properties_idx` (`dataset_column_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dataset_definition`
--

CREATE TABLE `[[dbprefix]]dataset_definition` (
  `dataset_id` int NOT NULL,
  `dataset_column_id` int NOT NULL AUTO_INCREMENT,
  `dataset_column_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dataset_column_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dataset_column_sort_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dataset_column_id`),
  KEY `dataset_definition_idx` (`dataset_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=41 ;

--
-- Dumping data for table `[[dbprefix]]dataset_definition`
--

INSERT INTO `[[dbprefix]]dataset_definition` VALUES
(1, 1, 'item_id', 'varchar', 1),
(1, 2, 'item_icon', 'varchar', 2),
(1, 3, 'item_url', 'varchar', 3),
(1, 4, 'parent_id', 'varchar', 4),
(1, 5, 'sort_order', 'integer', 5),
(1, 6, 'item_type', 'varchar', 6),
(1, 7, 'item_icon_rl_id', 'integer', 7),
(1, 8, 'settings', 'text', 8),
(2, 10, 'item_id', 'varchar', 1),
(2, 11, 'item_text', 'varchar', 2),
(2, 12, 'item_url', 'varchar', 3),
(2, 13, 'parent_id', 'varchar', 4),
(2, 14, 'sort_order', 'integer', 5),
(2, 15, 'item_type', 'varchar', 6),
(3, 16, 'item_id', 'varchar', 1),
(3, 17, 'item_text', 'varchar', 2),
(3, 18, 'language_id', 'integer', 3),
(4, 20, 'date_added', 'timestamp', 1),
(4, 21, 'name', 'varchar', 2),
(4, 22, 'version', 'varchar', 3),
(4, 23, 'backup_file', 'varchar', 4),
(4, 24, 'backup_date', 'timestamp', 5),
(4, 25, 'type', 'varchar', 6),
(4, 26, 'user', 'varchar', 7),
(5, 30, 'date_added', 'timestamp', 1),
(5, 31, 'name', 'varchar', 2),
(5, 32, 'type', 'varchar', 3),
(5, 33, 'section', 'varchar', 4),
(5, 34, 'section_id', 'integer', 5),
(5, 35, 'path', 'varchar', 6),
(2, 40, 'item_icon_rl_id', 'varchar', 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dataset_properties`
--

CREATE TABLE `[[dbprefix]]dataset_properties` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `dataset_id` int NOT NULL,
  `dataset_property_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dataset_property_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `dataset_property_idx` (`dataset_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]dataset_properties`
--

INSERT INTO `[[dbprefix]]dataset_properties` VALUES
(1, 1, 'controller', 'design/menu'),
(2, 4, 'controller', 'tool/install_upgrade_history'),
(3, 5, 'controller', 'tool/files');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dataset_values`
--

CREATE TABLE `[[dbprefix]]dataset_values` (
  `dataset_column_id` int NOT NULL,
  `value_integer` int DEFAULT NULL,
  `value_float` float DEFAULT NULL,
  `value_varchar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value_text` text COLLATE utf8mb4_unicode_ci,
  `value_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `value_boolean` tinyint(1) DEFAULT NULL,
  `value_sort_order` int NOT NULL AUTO_INCREMENT,
  `row_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`value_sort_order`),
  KEY `dataset_values_idx` (`value_integer`,`value_float`,`value_varchar`,`value_boolean`,`row_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=790 ;

--
-- Dumping data for table `[[dbprefix]]dataset_values`
--

INSERT INTO `[[dbprefix]]dataset_values` VALUES
(1, NULL, NULL, 'home', NULL, '[[regtime]]', NULL, 1, 1),
(1, NULL, NULL, 'login', NULL, '[[regtime]]', NULL, 2, 2),
(1, NULL, NULL, 'logout', NULL, '[[regtime]]', NULL, 3, 3),
(1, NULL, NULL, 'account', NULL, '[[regtime]]', NULL, 4, 4),
(1, NULL, NULL, 'cart', NULL, '[[regtime]]', NULL, 5, 5),
(1, NULL, NULL, 'checkout', NULL, '[[regtime]]', NULL, 6, 6),
(1, NULL, NULL, 'specials', NULL, '[[regtime]]', NULL, 7, 7),
(1, NULL, NULL, 'order', NULL, '[[regtime]]', NULL, 8, 8),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 9, 1),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 10, 2),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 11, 3),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 12, 4),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 13, 5),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 14, 6),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 15, 7),
(2, NULL, NULL, '', NULL, '[[regtime]]', NULL, 16, 8),
(3, NULL, NULL, 'index/home', NULL, '[[regtime]]', NULL, 17, 1),
(3, NULL, NULL, 'account/login', NULL, '[[regtime]]', NULL, 18, 2),
(3, NULL, NULL, 'account/logout', NULL, '[[regtime]]', NULL, 19, 3),
(3, NULL, NULL, 'account/account', NULL, '[[regtime]]', NULL, 20, 4),
(3, NULL, NULL, 'checkout/cart', NULL, '[[regtime]]', NULL, 21, 5),
(3, NULL, NULL, 'checkout/fast_checkout', NULL, '[[regtime]]', NULL, 22, 6),
(3, NULL, NULL, 'product/special', NULL, '[[regtime]]', NULL, 23, 7),
(3, NULL, NULL, 'account/order_details', NULL, '[[regtime]]', NULL, 24, 8),
(4, NULL, NULL, '', NULL, '[[regtime]]', NULL, 25, 1),
(4, NULL, NULL, 'account', NULL, '[[regtime]]', NULL, 26, 2),
(4, NULL, NULL, 'account', NULL, '[[regtime]]', NULL, 27, 3),
(4, NULL, NULL, '', NULL, '[[regtime]]', NULL, 28, 4),
(4, NULL, NULL, '', NULL, '[[regtime]]', NULL, 29, 5),
(4, NULL, NULL, '', NULL, '[[regtime]]', NULL, 30, 6),
(4, NULL, NULL, '', NULL, '[[regtime]]', NULL, 31, 7),
(4, NULL, NULL, 'account', NULL, '[[regtime]]', NULL, 32, 8),
(5, 10, NULL, NULL, NULL, '[[regtime]]', NULL, 33, 1),
(5, 11, NULL, NULL, NULL, '[[regtime]]', NULL, 34, 2),
(5, 12, NULL, NULL, NULL, '[[regtime]]', NULL, 35, 3),
(5, 20, NULL, NULL, NULL, '[[regtime]]', NULL, 36, 4),
(5, 30, NULL, NULL, NULL, '[[regtime]]', NULL, 37, 5),
(5, 50, NULL, NULL, NULL, '[[regtime]]', NULL, 38, 6),
(5, 60, NULL, NULL, NULL, '[[regtime]]', NULL, 39, 7),
(5, 13, NULL, NULL, NULL, '[[regtime]]', NULL, 40, 8),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 41, 1),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 42, 2),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 43, 3),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 44, 4),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 45, 5),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 46, 6),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 47, 7),
(6, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 48, 8),
(7, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 49, 1),
(7, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 50, 2),
(7, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 51, 3),
(7, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 52, 4),
(7, 250, NULL, NULL, NULL, '[[regtime]]', NULL, 53, 5),
(7, 260, NULL, NULL, NULL, '[[regtime]]', NULL, 54, 6),
(7, 244, NULL, NULL, NULL, '[[regtime]]', NULL, 55, 7),
(7, 266, NULL, NULL, NULL, '[[regtime]]', NULL, 56, 8),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 57, 1),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 58, 2),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 59, 3),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 60, 4),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 61, 5),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 62, 6),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 63, 7),
(8, NULL, NULL, NULL, 'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}', '[[regtime]]', NULL, 64, 8),
(10, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 65, 1),
(10, NULL, NULL, 'sale', NULL, '[[regtime]]', NULL, 66, 2),
(10, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 67, 3),
(10, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 68, 4),
(10, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 69, 5),
(10, NULL, NULL, 'reports', NULL, '[[regtime]]', NULL, 70, 6),
(10, NULL, NULL, 'help', NULL, '[[regtime]]', NULL, 71, 7),
(11, NULL, NULL, 'text_catalog', NULL, '[[regtime]]', NULL, 72, 1),
(11, NULL, NULL, 'text_sale', NULL, '[[regtime]]', NULL, 73, 2),
(11, NULL, NULL, 'text_design', NULL, '[[regtime]]', NULL, 74, 3),
(11, NULL, NULL, 'text_extension', NULL, '[[regtime]]', NULL, 75, 4),
(11, NULL, NULL, 'text_system', NULL, '[[regtime]]', NULL, 76, 5),
(11, NULL, NULL, 'text_reports', NULL, '[[regtime]]', NULL, 77, 6),
(11, NULL, NULL, 'text_help', NULL, '[[regtime]]', NULL, 78, 7),
(12, NULL, NULL, 'catalog/category', NULL, '[[regtime]]', NULL, 79, 1),
(12, NULL, NULL, 'sale/order', NULL, '[[regtime]]', NULL, 80, 2),
(12, NULL, NULL, 'design/template', NULL, '[[regtime]]', NULL, 81, 3),
(12, NULL, NULL, 'extension/extensions/extensions', NULL, '[[regtime]]', NULL, 82, 4),
(12, NULL, NULL, 'setting/setting', NULL, '[[regtime]]', NULL, 83, 5),
(12, NULL, NULL, 'report/sale/orders', NULL, '[[regtime]]', NULL, 84, 6),
(12, NULL, NULL, '', NULL, '[[regtime]]', NULL, 85, 7),
(13, NULL, NULL, '', NULL, '[[regtime]]', NULL, 86, 1),
(13, NULL, NULL, '', NULL, '[[regtime]]', NULL, 87, 2),
(13, NULL, NULL, '', NULL, '[[regtime]]', NULL, 88, 3),
(13, NULL, NULL, '', NULL, '[[regtime]]', NULL, 89, 4),
(13, NULL, NULL, '', NULL, '[[regtime]]', NULL, 90, 5),
(13, NULL, NULL, '', NULL, '[[regtime]]', NULL, 91, 6),
(13, NULL, NULL, '', NULL, '[[regtime]]', NULL, 92, 7),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 93, 1),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 94, 2),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 95, 3),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 96, 4),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 97, 5),
(14, 6, NULL, NULL, NULL, '[[regtime]]', NULL, 98, 6),
(14, 7, NULL, NULL, NULL, '[[regtime]]', NULL, 99, 7),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 100, 1),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 101, 2),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 102, 3),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 103, 4),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 104, 5),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 105, 6),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 106, 7),
(40, NULL, NULL, '200', NULL, '[[regtime]]', NULL, 107, 1),
(40, NULL, NULL, '201', NULL, '[[regtime]]', NULL, 108, 2),
(40, NULL, NULL, '202', NULL, '[[regtime]]', NULL, 109, 3),
(40, NULL, NULL, '203', NULL, '[[regtime]]', NULL, 110, 4),
(40, NULL, NULL, '204', NULL, '[[regtime]]', NULL, 111, 5),
(40, NULL, NULL, '205', NULL, '[[regtime]]', NULL, 112, 6),
(40, NULL, NULL, '206', NULL, '[[regtime]]', NULL, 113, 7),
(10, NULL, NULL, 'category', NULL, '[[regtime]]', NULL, 114, 11),
(10, NULL, NULL, 'product', NULL, '[[regtime]]', NULL, 115, 12),
(10, NULL, NULL, 'manufacturer', NULL, '[[regtime]]', NULL, 116, 13),
(10, NULL, NULL, 'download', NULL, '[[regtime]]', NULL, 117, 14),
(10, NULL, NULL, 'review', NULL, '[[regtime]]', NULL, 118, 15),
(10, NULL, NULL, 'attributes', NULL, '[[regtime]]', NULL, 119, 16),
(10, NULL, NULL, 'collections', NULL, '[[regtime]]', NULL, 120, 17),
(10, NULL, NULL, 'rl_manager', NULL, '[[regtime]]', NULL, 121, 220),
(11, NULL, NULL, 'text_category', NULL, '[[regtime]]', NULL, 122, 11),
(11, NULL, NULL, 'text_product', NULL, '[[regtime]]', NULL, 123, 12),
(11, NULL, NULL, 'text_manufacturer', NULL, '[[regtime]]', NULL, 124, 13),
(11, NULL, NULL, 'text_download', NULL, '[[regtime]]', NULL, 125, 14),
(11, NULL, NULL, 'text_review', NULL, '[[regtime]]', NULL, 126, 15),
(11, NULL, NULL, 'text_attribute', NULL, '[[regtime]]', NULL, 127, 16),
(11, NULL, NULL, 'text_collection', NULL, '[[regtime]]', NULL, 128, 17),
(11, NULL, NULL, 'text_rl_manager', NULL, '[[regtime]]', NULL, 129, 220),
(12, NULL, NULL, 'catalog/category', NULL, '[[regtime]]', NULL, 130, 11),
(12, NULL, NULL, 'catalog/product', NULL, '[[regtime]]', NULL, 131, 12),
(12, NULL, NULL, 'catalog/manufacturer', NULL, '[[regtime]]', NULL, 132, 13),
(12, NULL, NULL, 'catalog/download', NULL, '[[regtime]]', NULL, 133, 14),
(12, NULL, NULL, 'catalog/review', NULL, '[[regtime]]', NULL, 134, 15),
(12, NULL, NULL, 'catalog/attribute', NULL, '[[regtime]]', NULL, 135, 16),
(12, NULL, NULL, 'catalog/collections', NULL, '[[regtime]]', NULL, 136, 17),
(12, NULL, NULL, 'tool/rl_manager', NULL, '[[regtime]]', NULL, 137, 220),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 138, 11),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 139, 12),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 140, 13),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 141, 14),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 142, 15),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 143, 16),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 144, 17),
(13, NULL, NULL, 'catalog', NULL, '[[regtime]]', NULL, 145, 220),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 146, 11),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 147, 12),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 148, 13),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 149, 14),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 150, 15),
(14, 6, NULL, NULL, NULL, '[[regtime]]', NULL, 151, 16),
(14, 8, NULL, NULL, NULL, '[[regtime]]', NULL, 152, 17),
(14, 7, NULL, NULL, NULL, '[[regtime]]', NULL, 153, 220),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 154, 11),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 155, 12),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 156, 13),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 157, 14),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 158, 15),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 159, 16),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 160, 17),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 161, 220),
(40, NULL, NULL, '207', NULL, '[[regtime]]', NULL, 162, 11),
(40, NULL, NULL, '208', NULL, '[[regtime]]', NULL, 163, 12),
(40, NULL, NULL, '209', NULL, '[[regtime]]', NULL, 164, 13),
(40, NULL, NULL, '210', NULL, '[[regtime]]', NULL, 165, 14),
(40, NULL, NULL, '211', NULL, '[[regtime]]', NULL, 166, 15),
(40, NULL, NULL, '212', NULL, '[[regtime]]', NULL, 167, 16),
(40, NULL, NULL, '279', NULL, '[[regtime]]', NULL, 168, 17),
(40, NULL, NULL, '277', NULL, '[[regtime]]', NULL, 169, 220),
(10, NULL, NULL, 'extensions', NULL, '[[regtime]]', NULL, 170, 31),
(10, NULL, NULL, 'shipping', NULL, '[[regtime]]', NULL, 171, 32),
(10, NULL, NULL, 'payment', NULL, '[[regtime]]', NULL, 172, 33),
(10, NULL, NULL, 'templates', NULL, '[[regtime]]', NULL, 173, 34),
(10, NULL, NULL, 'languages', NULL, '[[regtime]]', NULL, 174, 35),
(10, NULL, NULL, 'taxes', NULL, '[[regtime]]', NULL, 175, 36),
(10, NULL, NULL, 'total', NULL, '[[regtime]]', NULL, 176, 37),
(10, NULL, NULL, 'add_extension', NULL, '[[regtime]]', NULL, 177, 38),
(10, NULL, NULL, 'extensions_stores', NULL, '[[regtime]]', NULL, 178, 39),
(11, NULL, NULL, 'text_extensions', NULL, '[[regtime]]', NULL, 179, 31),
(11, NULL, NULL, 'text_shipping', NULL, '[[regtime]]', NULL, 180, 32),
(11, NULL, NULL, 'text_payment', NULL, '[[regtime]]', NULL, 181, 33),
(11, NULL, NULL, 'text_templates', NULL, '[[regtime]]', NULL, 182, 34),
(11, NULL, NULL, 'text_language', NULL, '[[regtime]]', NULL, 183, 35),
(11, NULL, NULL, 'text_taxes', NULL, '[[regtime]]', NULL, 184, 36),
(11, NULL, NULL, 'text_total', NULL, '[[regtime]]', NULL, 185, 37),
(11, NULL, NULL, 'text_add_extension', NULL, '[[regtime]]', NULL, 186, 38),
(11, NULL, NULL, 'text_extensions_store', NULL, '[[regtime]]', NULL, 187, 39),
(12, NULL, NULL, 'extension/extensions/extensions', NULL, '[[regtime]]', NULL, 188, 31),
(12, NULL, NULL, 'extension/extensions/shipping', NULL, '[[regtime]]', NULL, 189, 32),
(12, NULL, NULL, 'extension/extensions/payment', NULL, '[[regtime]]', NULL, 190, 33),
(12, NULL, NULL, 'extension/extensions/template', NULL, '[[regtime]]', NULL, 191, 34),
(12, NULL, NULL, 'extension/extensions/language', NULL, '[[regtime]]', NULL, 192, 35),
(12, NULL, NULL, 'extension/extensions/tax', NULL, '[[regtime]]', NULL, 193, 36),
(12, NULL, NULL, 'extension/total', NULL, '[[regtime]]', NULL, 194, 37),
(12, NULL, NULL, 'tool/package_installer', NULL, '[[regtime]]', NULL, 195, 38),
(12, NULL, NULL, 'extension/extensions_store', NULL, '[[regtime]]', NULL, 196, 39),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 197, 31),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 198, 32),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 199, 33),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 200, 34),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 201, 35),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 202, 36),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 203, 37),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 204, 38),
(13, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 205, 39),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 206, 31),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 207, 32),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 208, 33),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 209, 34),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 210, 35),
(14, 6, NULL, NULL, NULL, '[[regtime]]', NULL, 211, 36),
(14, 7, NULL, NULL, NULL, '[[regtime]]', NULL, 212, 37),
(14, 8, NULL, NULL, NULL, '[[regtime]]', NULL, 213, 38),
(14, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 214, 39),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 215, 31),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 216, 32),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 217, 33),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 218, 34),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 219, 35),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 220, 36),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 221, 37),
(40, NULL, NULL, '213', NULL, '[[regtime]]', NULL, 222, 31),
(40, NULL, NULL, '214', NULL, '[[regtime]]', NULL, 223, 32),
(40, NULL, NULL, '260', NULL, '[[regtime]]', NULL, 224, 33),
(40, NULL, NULL, '216', NULL, '[[regtime]]', NULL, 225, 34),
(40, NULL, NULL, '217', NULL, '[[regtime]]', NULL, 226, 35),
(40, NULL, NULL, '215', NULL, '[[regtime]]', NULL, 227, 36),
(40, NULL, NULL, '218', NULL, '[[regtime]]', NULL, 228, 37),
(40, NULL, NULL, '219', NULL, '[[regtime]]', NULL, 229, 38),
(40, NULL, NULL, '220', NULL, '[[regtime]]', NULL, 230, 39),
(10, NULL, NULL, 'order', NULL, '[[regtime]]', NULL, 231, 51),
(10, NULL, NULL, 'customer', NULL, '[[regtime]]', NULL, 232, 52),
(10, NULL, NULL, 'customer_group', NULL, '[[regtime]]', NULL, 233, 53),
(10, NULL, NULL, 'coupon', NULL, '[[regtime]]', NULL, 234, 54),
(10, NULL, NULL, 'contact', NULL, '[[regtime]]', NULL, 235, 55),
(11, NULL, NULL, 'text_order', NULL, '[[regtime]]', NULL, 236, 51),
(11, NULL, NULL, 'text_customer', NULL, '[[regtime]]', NULL, 237, 52),
(11, NULL, NULL, 'text_customer_group', NULL, '[[regtime]]', NULL, 238, 53),
(11, NULL, NULL, 'text_coupon', NULL, '[[regtime]]', NULL, 239, 54),
(11, NULL, NULL, 'text_contact', NULL, '[[regtime]]', NULL, 240, 55),
(12, NULL, NULL, 'sale/order', NULL, '[[regtime]]', NULL, 241, 51),
(12, NULL, NULL, 'sale/customer', NULL, '[[regtime]]', NULL, 242, 52),
(12, NULL, NULL, 'sale/customer_group', NULL, '[[regtime]]', NULL, 243, 53),
(12, NULL, NULL, 'sale/coupon', NULL, '[[regtime]]', NULL, 244, 54),
(12, NULL, NULL, 'sale/contact', NULL, '[[regtime]]', NULL, 245, 55),
(13, NULL, NULL, 'sale', NULL, '[[regtime]]', NULL, 246, 51),
(13, NULL, NULL, 'sale', NULL, '[[regtime]]', NULL, 247, 52),
(13, NULL, NULL, 'sale', NULL, '[[regtime]]', NULL, 248, 53),
(13, NULL, NULL, 'sale', NULL, '[[regtime]]', NULL, 249, 54),
(13, NULL, NULL, 'sale', NULL, '[[regtime]]', NULL, 250, 55),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 251, 51),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 252, 52),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 253, 53),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 254, 54),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 255, 55),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 256, 51),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 257, 52),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 258, 53),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 259, 54),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 260, 55),
(40, NULL, NULL, '221', NULL, '[[regtime]]', NULL, 261, 51),
(40, NULL, NULL, '222', NULL, '[[regtime]]', NULL, 262, 52),
(40, NULL, NULL, '223', NULL, '[[regtime]]', NULL, 263, 53),
(40, NULL, NULL, '224', NULL, '[[regtime]]', NULL, 264, 54),
(40, NULL, NULL, '225', NULL, '[[regtime]]', NULL, 265, 55),
(10, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 266, 71),
(10, NULL, NULL, 'users', NULL, '[[regtime]]', NULL, 267, 72),
(10, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 268, 73),
(10, NULL, NULL, 'data', NULL, '[[regtime]]', NULL, 269, 74),
(10, NULL, NULL, 'updater', NULL, '[[regtime]]', NULL, 270, 77),
(10, NULL, NULL, 'cache', NULL, '[[regtime]]', NULL, 271, 78),
(10, NULL, NULL, 'messages', NULL, '[[regtime]]', NULL, 272, 79),
(10, NULL, NULL, 'logs', NULL, '[[regtime]]', NULL, 273, 80),
(11, NULL, NULL, 'text_setting', NULL, '[[regtime]]', NULL, 274, 71),
(11, NULL, NULL, 'text_users', NULL, '[[regtime]]', NULL, 275, 72),
(11, NULL, NULL, 'text_localisation', NULL, '[[regtime]]', NULL, 276, 73),
(11, NULL, NULL, 'text_data', NULL, '[[regtime]]', NULL, 277, 74),
(11, NULL, NULL, 'text_updater', NULL, '[[regtime]]', NULL, 278, 77),
(11, NULL, NULL, 'text_cache', NULL, '[[regtime]]', NULL, 279, 78),
(11, NULL, NULL, 'text_messages', NULL, '[[regtime]]', NULL, 280, 79),
(11, NULL, NULL, 'text_logs', NULL, '[[regtime]]', NULL, 281, 80),
(12, NULL, NULL, 'setting/setting', NULL, '[[regtime]]', NULL, 282, 71),
(12, NULL, NULL, '', NULL, '[[regtime]]', NULL, 283, 72),
(12, NULL, NULL, '', NULL, '[[regtime]]', NULL, 284, 73),
(12, NULL, NULL, '', NULL, '[[regtime]]', NULL, 285, 74),
(12, NULL, NULL, 'tool/updater', NULL, '[[regtime]]', NULL, 286, 77),
(12, NULL, NULL, 'tool/cache', NULL, '[[regtime]]', NULL, 287, 78),
(12, NULL, NULL, 'tool/message_manager', NULL, '[[regtime]]', NULL, 288, 79),
(12, NULL, NULL, '', NULL, '[[regtime]]', NULL, 289, 80),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 290, 71),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 291, 72),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 292, 73),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 293, 74),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 294, 77),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 295, 78),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 296, 79),
(13, NULL, NULL, 'system', NULL, '[[regtime]]', NULL, 297, 80),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 298, 71),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 299, 72),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 300, 73),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 301, 74),
(14, 7, NULL, NULL, NULL, '[[regtime]]', NULL, 302, 77),
(14, 8, NULL, NULL, NULL, '[[regtime]]', NULL, 303, 78),
(14, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 304, 79),
(14, 10, NULL, NULL, NULL, '[[regtime]]', NULL, 305, 80),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 306, 71),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 307, 72),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 308, 73),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 309, 74),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 310, 77),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 311, 78),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 312, 79),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 313, 80),
(40, NULL, NULL, '226', NULL, '[[regtime]]', NULL, 314, 71),
(40, NULL, NULL, '227', NULL, '[[regtime]]', NULL, 315, 72),
(40, NULL, NULL, '228', NULL, '[[regtime]]', NULL, 316, 73),
(40, NULL, NULL, '229', NULL, '[[regtime]]', NULL, 317, 74),
(40, NULL, NULL, '230', NULL, '[[regtime]]', NULL, 318, 77),
(40, NULL, NULL, '231', NULL, '[[regtime]]', NULL, 319, 78),
(40, NULL, NULL, '232', NULL, '[[regtime]]', NULL, 320, 79),
(40, NULL, NULL, '233', NULL, '[[regtime]]', NULL, 321, 80),
(10, NULL, NULL, 'report_sale', NULL, '[[regtime]]', NULL, 322, 91),
(10, NULL, NULL, 'report_customer', NULL, '[[regtime]]', NULL, 323, 92),
(10, NULL, NULL, 'report_product', NULL, '[[regtime]]', NULL, 324, 93),
(10, NULL, NULL, 'report_analytics', NULL, '[[regtime]]', NULL, 325, 221),
(10, NULL, NULL, 'banner_manager_stat', NULL, '[[regtime]]', NULL, 326, 94),
(11, NULL, NULL, 'text_report_sale', NULL, '[[regtime]]', NULL, 327, 91),
(11, NULL, NULL, 'text_customer', NULL, '[[regtime]]', NULL, 328, 92),
(11, NULL, NULL, 'text_product', NULL, '[[regtime]]', NULL, 329, 93),
(11, NULL, NULL, 'text_analytics', NULL, '[[regtime]]', NULL, 330, 221),
(11, NULL, NULL, 'banner_manager_name_stat', NULL, '[[regtime]]', NULL, 331, 94),
(12, NULL, NULL, 'report/sale/orders', NULL, '[[regtime]]', NULL, 332, 91),
(12, NULL, NULL, 'report/customer/online', NULL, '[[regtime]]', NULL, 333, 92),
(12, NULL, NULL, '', NULL, '[[regtime]]', NULL, 334, 93),
(12, NULL, NULL, '', NULL, '[[regtime]]', NULL, 335, 221),
(12, NULL, NULL, 'extension/banner_manager_stat', NULL, '[[regtime]]', NULL, 336, 94),
(13, NULL, NULL, 'reports', NULL, '[[regtime]]', NULL, 337, 91),
(13, NULL, NULL, 'reports', NULL, '[[regtime]]', NULL, 338, 92),
(13, NULL, NULL, 'reports', NULL, '[[regtime]]', NULL, 339, 93),
(13, NULL, NULL, 'reports', NULL, '[[regtime]]', NULL, 340, 221),
(13, NULL, NULL, 'reports', NULL, '[[regtime]]', NULL, 341, 94),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 342, 91),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 343, 92),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 344, 93),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 345, 221),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 346, 94),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 347, 91),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 348, 92),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 349, 93),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 350, 221),
(15, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 351, 94),
(40, NULL, NULL, '234', NULL, '[[regtime]]', NULL, 352, 91),
(40, NULL, NULL, '222', NULL, '[[regtime]]', NULL, 353, 92),
(40, NULL, NULL, '208', NULL, '[[regtime]]', NULL, 354, 93),
(40, NULL, NULL, '234', NULL, '[[regtime]]', NULL, 355, 221),
(40, NULL, NULL, '237', NULL, '[[regtime]]', NULL, 356, 94),
(10, NULL, NULL, 'abantecart', NULL, '[[regtime]]', NULL, 357, 111),
(10, NULL, NULL, 'documentation', NULL, '[[regtime]]', NULL, 358, 112),
(10, NULL, NULL, 'support', NULL, '[[regtime]]', NULL, 359, 113),
(10, NULL, NULL, 'marketplace', NULL, '[[regtime]]', NULL, 360, 114),
(11, NULL, NULL, 'text_abantecart', NULL, '[[regtime]]', NULL, 361, 111),
(11, NULL, NULL, 'text_documentation', NULL, '[[regtime]]', NULL, 362, 112),
(11, NULL, NULL, 'text_support', NULL, '[[regtime]]', NULL, 363, 113),
(11, NULL, NULL, 'text_extensions_store', NULL, '[[regtime]]', NULL, 364, 114),
(12, NULL, NULL, 'window.open(''https://www.abantecart.com'');', NULL, '[[regtime]]', NULL, 365, 111),
(12, NULL, NULL, 'window.open(''https://docs.abantecart.com'');', NULL, '[[regtime]]', NULL, 366, 112),
(12, NULL, NULL, 'window.open(''https://forum.abantecart.com'');', NULL, '[[regtime]]', NULL, 367, 113),
(12, NULL, NULL, 'window.open(''https://marketplace.abantecart.com'');', NULL, '[[regtime]]', NULL, 368, 114),
(13, NULL, NULL, 'help', NULL, '[[regtime]]', NULL, 369, 111),
(13, NULL, NULL, 'help', NULL, '[[regtime]]', NULL, 370, 112),
(13, NULL, NULL, 'help', NULL, '[[regtime]]', NULL, 371, 113),
(13, NULL, NULL, 'help', NULL, '[[regtime]]', NULL, 372, 114),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 373, 111),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 374, 112),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 375, 113),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 376, 114),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 377, 111),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 378, 112),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 379, 113),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 380, 114),
(40, NULL, NULL, '238', NULL, '[[regtime]]', NULL, 381, 111),
(40, NULL, NULL, '239', NULL, '[[regtime]]', NULL, 382, 112),
(40, NULL, NULL, '240', NULL, '[[regtime]]', NULL, 383, 113),
(40, NULL, NULL, '203', NULL, '[[regtime]]', NULL, 384, 114),
(10, NULL, NULL, 'template', NULL, '[[regtime]]', NULL, 385, 131),
(10, NULL, NULL, 'layout', NULL, '[[regtime]]', NULL, 386, 132),
(10, NULL, NULL, 'blocks', NULL, '[[regtime]]', NULL, 387, 133),
(10, NULL, NULL, 'menu', NULL, '[[regtime]]', NULL, 388, 134),
(10, NULL, NULL, 'content', NULL, '[[regtime]]', NULL, 389, 135),
(10, NULL, NULL, 'banner_manager', NULL, '[[regtime]]', NULL, 390, 136),
(10, NULL, NULL, 'forms_manager', NULL, '[[regtime]]', NULL, 391, 200),
(10, NULL, NULL, 'email_templates', NULL, '[[regtime]]', NULL, 392, 137),
(11, NULL, NULL, 'text_templates', NULL, '[[regtime]]', NULL, 393, 131),
(11, NULL, NULL, 'text_layout', NULL, '[[regtime]]', NULL, 394, 132),
(11, NULL, NULL, 'text_blocks', NULL, '[[regtime]]', NULL, 395, 133),
(11, NULL, NULL, 'text_menu', NULL, '[[regtime]]', NULL, 396, 134),
(11, NULL, NULL, 'text_content', NULL, '[[regtime]]', NULL, 397, 135),
(11, NULL, NULL, 'banner_manager_name', NULL, '[[regtime]]', NULL, 398, 136),
(11, NULL, NULL, 'forms_manager_name', NULL, '[[regtime]]', NULL, 399, 200),
(11, NULL, NULL, 'email_templates', NULL, '[[regtime]]', NULL, 400, 137),
(12, NULL, NULL, 'design/template', NULL, '[[regtime]]', NULL, 401, 131),
(12, NULL, NULL, 'design/layout', NULL, '[[regtime]]', NULL, 402, 132),
(12, NULL, NULL, 'design/blocks', NULL, '[[regtime]]', NULL, 403, 133),
(12, NULL, NULL, 'design/menu', NULL, '[[regtime]]', NULL, 404, 134),
(12, NULL, NULL, 'design/content', NULL, '[[regtime]]', NULL, 405, 135),
(12, NULL, NULL, 'extension/banner_manager', NULL, '[[regtime]]', NULL, 406, 136),
(12, NULL, NULL, 'design/email_templates', NULL, '[[regtime]]', NULL, 407, 137),
(12, NULL, NULL, 'tool/forms_manager', NULL, '[[regtime]]', NULL, 408, 200),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 409, 131),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 410, 132),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 411, 133),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 412, 134),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 413, 135),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 414, 136),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 415, 137),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 416, 200),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 417, 131),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 418, 132),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 419, 133),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 420, 134),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 421, 135),
(14, 6, NULL, NULL, NULL, '[[regtime]]', NULL, 422, 136),
(14, 8, NULL, NULL, NULL, '[[regtime]]', NULL, 423, 137),
(14, 7, NULL, NULL, NULL, '[[regtime]]', NULL, 424, 200),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 425, 131),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 426, 132),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 427, 133),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 428, 134),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 429, 135),
(15, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 430, 136),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 431, 137),
(15, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 432, 200),
(40, NULL, NULL, '241', NULL, '[[regtime]]', NULL, 433, 131),
(40, NULL, NULL, '242', NULL, '[[regtime]]', NULL, 434, 132),
(40, NULL, NULL, '243', NULL, '[[regtime]]', NULL, 435, 133),
(40, NULL, NULL, '244', NULL, '[[regtime]]', NULL, 436, 134),
(40, NULL, NULL, '245', NULL, '[[regtime]]', NULL, 437, 135),
(40, NULL, NULL, '246', NULL, '[[regtime]]', NULL, 438, 136),
(40, NULL, NULL, '280', NULL, '[[regtime]]', NULL, 439, 137),
(40, NULL, NULL, '248', NULL, '[[regtime]]', NULL, 440, 200),
(10, NULL, NULL, 'all_settings', NULL, '[[regtime]]', NULL, 441, 191),
(10, NULL, NULL, 'settings_details', NULL, '[[regtime]]', NULL, 442, 192),
(10, NULL, NULL, 'settings_general', NULL, '[[regtime]]', NULL, 443, 193),
(10, NULL, NULL, 'settings_checkout', NULL, '[[regtime]]', NULL, 444, 194),
(10, NULL, NULL, 'settings_appearance', NULL, '[[regtime]]', NULL, 445, 195),
(10, NULL, NULL, 'settings_mail', NULL, '[[regtime]]', NULL, 446, 196),
(10, NULL, NULL, 'settings_im', NULL, '[[regtime]]', NULL, 447, 219),
(10, NULL, NULL, 'settings_api', NULL, '[[regtime]]', NULL, 448, 197),
(10, NULL, NULL, 'settings_system', NULL, '[[regtime]]', NULL, 449, 198),
(10, NULL, NULL, 'settings_newstore', NULL, '[[regtime]]', NULL, 450, 199),
(11, NULL, NULL, 'text_all_settings', NULL, '[[regtime]]', NULL, 451, 191),
(11, NULL, NULL, 'text_settings_details', NULL, '[[regtime]]', NULL, 452, 192),
(11, NULL, NULL, 'text_settings_general', NULL, '[[regtime]]', NULL, 453, 193),
(11, NULL, NULL, 'text_settings_checkout', NULL, '[[regtime]]', NULL, 454, 194),
(11, NULL, NULL, 'text_settings_appearance', NULL, '[[regtime]]', NULL, 455, 195),
(11, NULL, NULL, 'text_settings_mail', NULL, '[[regtime]]', NULL, 456, 196),
(11, NULL, NULL, 'text_settings_im', NULL, '[[regtime]]', NULL, 457, 219),
(11, NULL, NULL, 'text_settings_api', NULL, '[[regtime]]', NULL, 458, 197),
(11, NULL, NULL, 'text_settings_system', NULL, '[[regtime]]', NULL, 459, 198),
(11, NULL, NULL, 'text_settings_newstore', NULL, '[[regtime]]', NULL, 460, 199),
(12, NULL, NULL, 'setting/setting/all', NULL, '[[regtime]]', NULL, 461, 191),
(12, NULL, NULL, 'setting/setting/details', NULL, '[[regtime]]', NULL, 462, 192),
(12, NULL, NULL, 'setting/setting/general', NULL, '[[regtime]]', NULL, 463, 193),
(12, NULL, NULL, 'setting/setting/checkout', NULL, '[[regtime]]', NULL, 464, 194),
(12, NULL, NULL, 'setting/setting/appearance', NULL, '[[regtime]]', NULL, 465, 195),
(12, NULL, NULL, 'setting/setting/mail', NULL, '[[regtime]]', NULL, 466, 196),
(12, NULL, NULL, 'setting/setting/im', NULL, '[[regtime]]', NULL, 467, 219),
(12, NULL, NULL, 'setting/setting/api', NULL, '[[regtime]]', NULL, 468, 197),
(12, NULL, NULL, 'setting/setting/system', NULL, '[[regtime]]', NULL, 469, 198),
(12, NULL, NULL, 'setting/store/insert', NULL, '[[regtime]]', NULL, 470, 199),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 471, 191),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 472, 192),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 473, 193),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 474, 194),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 475, 195),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 476, 196),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 477, 219),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 478, 197),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 479, 198),
(13, NULL, NULL, 'setting', NULL, '[[regtime]]', NULL, 480, 199),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 481, 191),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 482, 192),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 483, 193),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 484, 194),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 485, 195),
(14, 6, NULL, NULL, NULL, '[[regtime]]', NULL, 486, 196),
(14, 7, NULL, NULL, NULL, '[[regtime]]', NULL, 487, 219),
(14, 8, NULL, NULL, NULL, '[[regtime]]', NULL, 488, 197),
(14, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 489, 198),
(14, 10, NULL, NULL, NULL, '[[regtime]]', NULL, 490, 199),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 491, 191),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 492, 192),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 493, 193),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 494, 194),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 495, 195),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 496, 196),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 497, 219),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 498, 197),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 499, 198),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 500, 199),
(40, NULL, NULL, '247', NULL, '[[regtime]]', NULL, 501, 191),
(40, NULL, NULL, '248', NULL, '[[regtime]]', NULL, 502, 192),
(40, NULL, NULL, '249', NULL, '[[regtime]]', NULL, 503, 193),
(40, NULL, NULL, '250', NULL, '[[regtime]]', NULL, 504, 194),
(40, NULL, NULL, '251', NULL, '[[regtime]]', NULL, 505, 195),
(40, NULL, NULL, '252', NULL, '[[regtime]]', NULL, 506, 196),
(40, NULL, NULL, '276', NULL, '[[regtime]]', NULL, 507, 219),
(40, NULL, NULL, '253', NULL, '[[regtime]]', NULL, 508, 197),
(40, NULL, NULL, '254', NULL, '[[regtime]]', NULL, 509, 198),
(40, NULL, NULL, '255', NULL, '[[regtime]]', NULL, 510, 199),
(10, NULL, NULL, 'user', NULL, '[[regtime]]', NULL, 511, 151),
(10, NULL, NULL, 'permission', NULL, '[[regtime]]', NULL, 512, 152),
(11, NULL, NULL, 'text_user', NULL, '[[regtime]]', NULL, 513, 151),
(11, NULL, NULL, 'text_user_group', NULL, '[[regtime]]', NULL, 514, 152),
(12, NULL, NULL, 'user/user', NULL, '[[regtime]]', NULL, 515, 151),
(12, NULL, NULL, 'user/user_permission', NULL, '[[regtime]]', NULL, 516, 152),
(13, NULL, NULL, 'users', NULL, '[[regtime]]', NULL, 517, 151),
(13, NULL, NULL, 'users', NULL, '[[regtime]]', NULL, 518, 152),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 519, 151),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 520, 152),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 521, 151),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 522, 152),
(40, NULL, NULL, '256', NULL, '[[regtime]]', NULL, 523, 151),
(40, NULL, NULL, '257', NULL, '[[regtime]]', NULL, 524, 152),
(10, NULL, NULL, 'language', NULL, '[[regtime]]', NULL, 525, 171),
(10, NULL, NULL, 'language_definitions', NULL, '[[regtime]]', NULL, 526, 172),
(10, NULL, NULL, 'currency', NULL, '[[regtime]]', NULL, 527, 173),
(10, NULL, NULL, 'stockstatus', NULL, '[[regtime]]', NULL, 528, 174),
(10, NULL, NULL, 'orderstatus', NULL, '[[regtime]]', NULL, 529, 175),
(10, NULL, NULL, 'country', NULL, '[[regtime]]', NULL, 530, 176),
(10, NULL, NULL, 'zone', NULL, '[[regtime]]', NULL, 531, 177),
(10, NULL, NULL, 'location', NULL, '[[regtime]]', NULL, 532, 178),
(10, NULL, NULL, 'taxclass', NULL, '[[regtime]]', NULL, 533, 179),
(10, NULL, NULL, 'lengthclass', NULL, '[[regtime]]', NULL, 534, 180),
(10, NULL, NULL, 'weightclass', NULL, '[[regtime]]', NULL, 535, 181),
(11, NULL, NULL, 'text_language', NULL, '[[regtime]]', NULL, 536, 171),
(11, NULL, NULL, 'text_language_definitions', NULL, '[[regtime]]', NULL, 537, 172),
(11, NULL, NULL, 'text_currency', NULL, '[[regtime]]', NULL, 538, 173),
(11, NULL, NULL, 'text_stock_status', NULL, '[[regtime]]', NULL, 539, 174),
(11, NULL, NULL, 'text_order_status', NULL, '[[regtime]]', NULL, 540, 175),
(11, NULL, NULL, 'text_country', NULL, '[[regtime]]', NULL, 541, 176),
(11, NULL, NULL, 'text_zone', NULL, '[[regtime]]', NULL, 542, 177),
(11, NULL, NULL, 'text_location', NULL, '[[regtime]]', NULL, 543, 178),
(11, NULL, NULL, 'text_tax_class', NULL, '[[regtime]]', NULL, 544, 179),
(11, NULL, NULL, 'text_length_class', NULL, '[[regtime]]', NULL, 545, 180),
(11, NULL, NULL, 'text_weight_class', NULL, '[[regtime]]', NULL, 546, 181),
(12, NULL, NULL, 'localisation/language', NULL, '[[regtime]]', NULL, 547, 171),
(12, NULL, NULL, 'localisation/language_definitions', NULL, '[[regtime]]', NULL, 548, 172),
(12, NULL, NULL, 'localisation/currency', NULL, '[[regtime]]', NULL, 549, 173),
(12, NULL, NULL, 'localisation/stock_status', NULL, '[[regtime]]', NULL, 550, 174),
(12, NULL, NULL, 'localisation/order_status', NULL, '[[regtime]]', NULL, 551, 175),
(12, NULL, NULL, 'localisation/country', NULL, '[[regtime]]', NULL, 552, 176),
(12, NULL, NULL, 'localisation/zone', NULL, '[[regtime]]', NULL, 553, 177),
(12, NULL, NULL, 'localisation/location', NULL, '[[regtime]]', NULL, 554, 178),
(12, NULL, NULL, 'localisation/tax_class', NULL, '[[regtime]]', NULL, 555, 179),
(12, NULL, NULL, 'localisation/length_class', NULL, '[[regtime]]', NULL, 556, 180),
(12, NULL, NULL, 'localisation/weight_class', NULL, '[[regtime]]', NULL, 557, 181),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 558, 171),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 559, 172),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 560, 173),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 561, 174),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 562, 175),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 563, 176),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 564, 177),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 565, 178),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 566, 179),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 567, 180),
(13, NULL, NULL, 'localisation', NULL, '[[regtime]]', NULL, 568, 181),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 569, 171),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 570, 172),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 571, 173),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 572, 174),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 573, 175),
(14, 6, NULL, NULL, NULL, '[[regtime]]', NULL, 574, 176),
(14, 7, NULL, NULL, NULL, '[[regtime]]', NULL, 575, 177),
(14, 8, NULL, NULL, NULL, '[[regtime]]', NULL, 576, 178),
(14, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 577, 179),
(14, 10, NULL, NULL, NULL, '[[regtime]]', NULL, 578, 180),
(14, 11, NULL, NULL, NULL, '[[regtime]]', NULL, 579, 181),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 580, 171),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 581, 172),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 582, 173),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 583, 174),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 584, 175),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 585, 176),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 586, 177),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 587, 178),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 588, 179),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 589, 180),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 590, 181),
(40, NULL, NULL, '258', NULL, '[[regtime]]', NULL, 591, 171),
(40, NULL, NULL, '259', NULL, '[[regtime]]', NULL, 592, 172),
(40, NULL, NULL, '260', NULL, '[[regtime]]', NULL, 593, 173),
(40, NULL, NULL, '261', NULL, '[[regtime]]', NULL, 594, 174),
(40, NULL, NULL, '262', NULL, '[[regtime]]', NULL, 595, 175),
(40, NULL, NULL, '263', NULL, '[[regtime]]', NULL, 596, 176),
(40, NULL, NULL, '264', NULL, '[[regtime]]', NULL, 597, 177),
(40, NULL, NULL, '265', NULL, '[[regtime]]', NULL, 598, 178),
(40, NULL, NULL, '266', NULL, '[[regtime]]', NULL, 599, 179),
(40, NULL, NULL, '267', NULL, '[[regtime]]', NULL, 600, 180),
(40, NULL, NULL, '268', NULL, '[[regtime]]', NULL, 601, 181),
(10, NULL, NULL, 'backup', NULL, '[[regtime]]', NULL, 602, 183),
(10, NULL, NULL, 'migrate', NULL, '[[regtime]]', NULL, 603, 184),
(10, NULL, NULL, 'datasets', NULL, '[[regtime]]', NULL, 604, 185),
(10, NULL, NULL, 'import_export', NULL, '[[regtime]]', NULL, 605, 182),
(10, NULL, NULL, 'file_uploads', NULL, '[[regtime]]', NULL, 606, 188),
(11, NULL, NULL, 'text_backup', NULL, '[[regtime]]', NULL, 607, 183),
(11, NULL, NULL, 'text_migrate', NULL, '[[regtime]]', NULL, 608, 184),
(11, NULL, NULL, 'text_datasets_manager', NULL, '[[regtime]]', NULL, 609, 185),
(11, NULL, NULL, 'text_import_export', NULL, '[[regtime]]', NULL, 610, 182),
(11, NULL, NULL, 'text_file_uploads', NULL, '[[regtime]]', NULL, 611, 188),
(12, NULL, NULL, 'tool/backup', NULL, '[[regtime]]', NULL, 612, 183),
(12, NULL, NULL, 'tool/migration/step_one', NULL, '[[regtime]]', NULL, 613, 184),
(12, NULL, NULL, 'tool/datasets_manager', NULL, '[[regtime]]', NULL, 614, 185),
(12, NULL, NULL, 'tool/import_export', NULL, '[[regtime]]', NULL, 615, 182),
(12, NULL, NULL, 'tool/files', NULL, '[[regtime]]', NULL, 616, 188),
(13, NULL, NULL, 'data', NULL, '[[regtime]]', NULL, 617, 183),
(13, NULL, NULL, 'data', NULL, '[[regtime]]', NULL, 618, 184),
(13, NULL, NULL, 'data', NULL, '[[regtime]]', NULL, 619, 185),
(13, NULL, NULL, 'data', NULL, '[[regtime]]', NULL, 620, 182),
(13, NULL, NULL, 'data', NULL, '[[regtime]]', NULL, 621, 188),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 622, 183),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 623, 184),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 624, 185),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 625, 182),
(14, 5, NULL, NULL, NULL, '[[regtime]]', NULL, 626, 188),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 627, 183),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 628, 184),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 629, 185),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 630, 182),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 631, 188),
(40, NULL, NULL, '269', NULL, '[[regtime]]', NULL, 632, 183),
(40, NULL, NULL, '270', NULL, '[[regtime]]', NULL, 633, 184),
(40, NULL, NULL, '271', NULL, '[[regtime]]', NULL, 634, 185),
(40, NULL, NULL, '272', NULL, '[[regtime]]', NULL, 635, 182),
(40, NULL, NULL, '273', NULL, '[[regtime]]', NULL, 636, 188),
(10, NULL, NULL, 'installlog', NULL, '[[regtime]]', NULL, 637, 186),
(10, NULL, NULL, 'error_log', NULL, '[[regtime]]', NULL, 638, 187),
(10, NULL, NULL, 'task', NULL, '[[regtime]]', NULL, 639, 189),
(11, NULL, NULL, 'text_install_upgrade_history', NULL, '[[regtime]]', NULL, 640, 186),
(11, NULL, NULL, 'text_error_log', NULL, '[[regtime]]', NULL, 641, 187),
(11, NULL, NULL, 'text_tasks', NULL, '[[regtime]]', NULL, 642, 189),
(12, NULL, NULL, 'tool/install_upgrade_history', NULL, '[[regtime]]', NULL, 643, 186),
(12, NULL, NULL, 'tool/error_log', NULL, '[[regtime]]', NULL, 644, 187),
(12, NULL, NULL, 'tool/task', NULL, '[[regtime]]', NULL, 645, 189),
(13, NULL, NULL, 'logs', NULL, '[[regtime]]', NULL, 646, 186),
(13, NULL, NULL, 'logs', NULL, '[[regtime]]', NULL, 647, 187),
(13, NULL, NULL, 'logs', NULL, '[[regtime]]', NULL, 648, 189),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 649, 186),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 650, 187),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 651, 189),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 652, 186),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 653, 187),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 654, 189),
(40, NULL, NULL, '274', NULL, '[[regtime]]', NULL, 655, 186),
(40, NULL, NULL, '275', NULL, '[[regtime]]', NULL, 656, 187),
(40, NULL, NULL, '254', NULL, '[[regtime]]', NULL, 657, 189),
(10, NULL, NULL, 'report_sale_orders', NULL, '[[regtime]]', NULL, 658, 210),
(10, NULL, NULL, 'report_sale_tax', NULL, '[[regtime]]', NULL, 659, 211),
(10, NULL, NULL, 'report_sale_shipping', NULL, '[[regtime]]', NULL, 660, 212),
(10, NULL, NULL, 'report_sale_coupon', NULL, '[[regtime]]', NULL, 661, 213),
(11, NULL, NULL, 'text_order', NULL, '[[regtime]]', NULL, 662, 210),
(11, NULL, NULL, 'text_tax', NULL, '[[regtime]]', NULL, 663, 211),
(11, NULL, NULL, 'text_shipping', NULL, '[[regtime]]', NULL, 664, 212),
(11, NULL, NULL, 'text_discount', NULL, '[[regtime]]', NULL, 665, 213),
(12, NULL, NULL, 'report/sale/orders', NULL, '[[regtime]]', NULL, 666, 210),
(12, NULL, NULL, 'report/sale/taxes', NULL, '[[regtime]]', NULL, 667, 211),
(12, NULL, NULL, 'report/sale/shipping', NULL, '[[regtime]]', NULL, 668, 212),
(12, NULL, NULL, 'report/sale/coupons', NULL, '[[regtime]]', NULL, 669, 213),
(13, NULL, NULL, 'report_sale', NULL, '[[regtime]]', NULL, 670, 210),
(13, NULL, NULL, 'report_sale', NULL, '[[regtime]]', NULL, 671, 211),
(13, NULL, NULL, 'report_sale', NULL, '[[regtime]]', NULL, 672, 212),
(13, NULL, NULL, 'report_sale', NULL, '[[regtime]]', NULL, 673, 213),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 674, 210),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 675, 211),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 676, 212),
(14, 4, NULL, NULL, NULL, '[[regtime]]', NULL, 677, 213),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 678, 210),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 679, 211),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 680, 212),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 681, 213),
(40, NULL, NULL, '221', NULL, '[[regtime]]', NULL, 682, 210),
(40, NULL, NULL, '266', NULL, '[[regtime]]', NULL, 683, 211),
(40, NULL, NULL, '214', NULL, '[[regtime]]', NULL, 684, 212),
(40, NULL, NULL, '224', NULL, '[[regtime]]', NULL, 685, 213),
(10, NULL, NULL, 'report_customer_online', NULL, '[[regtime]]', NULL, 686, 214);
INSERT INTO `[[dbprefix]]dataset_values` VALUES
(10, NULL, NULL, 'report_customer_order', NULL, '[[regtime]]', NULL, 687, 215),
(10, NULL, NULL, 'report_customer_transactions', NULL, '[[regtime]]', NULL, 688, 216),
(11, NULL, NULL, 'text_online', NULL, '[[regtime]]', NULL, 689, 214),
(11, NULL, NULL, 'text_order', NULL, '[[regtime]]', NULL, 690, 215),
(11, NULL, NULL, 'text_transactions', NULL, '[[regtime]]', NULL, 691, 216),
(12, NULL, NULL, 'report/customer/online', NULL, '[[regtime]]', NULL, 692, 214),
(12, NULL, NULL, 'report/customer/orders', NULL, '[[regtime]]', NULL, 693, 215),
(12, NULL, NULL, 'report/customer/transactions', NULL, '[[regtime]]', NULL, 694, 216),
(13, NULL, NULL, 'report_customer', NULL, '[[regtime]]', NULL, 695, 214),
(13, NULL, NULL, 'report_customer', NULL, '[[regtime]]', NULL, 696, 215),
(13, NULL, NULL, 'report_customer', NULL, '[[regtime]]', NULL, 697, 216),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 698, 214),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 699, 215),
(14, 3, NULL, NULL, NULL, '[[regtime]]', NULL, 700, 216),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 701, 214),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 702, 215),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 703, 216),
(40, NULL, NULL, '222', NULL, '[[regtime]]', NULL, 704, 214),
(40, NULL, NULL, '221', NULL, '[[regtime]]', NULL, 705, 215),
(40, NULL, NULL, '260', NULL, '[[regtime]]', NULL, 706, 216),
(10, NULL, NULL, 'report_product_viewed', NULL, '[[regtime]]', NULL, 707, 217),
(10, NULL, NULL, 'report_product_purchased', NULL, '[[regtime]]', NULL, 708, 218),
(11, NULL, NULL, 'text_report_viewed', NULL, '[[regtime]]', NULL, 709, 217),
(11, NULL, NULL, 'text_report_purchased', NULL, '[[regtime]]', NULL, 710, 218),
(12, NULL, NULL, 'report/viewed', NULL, '[[regtime]]', NULL, 711, 217),
(12, NULL, NULL, 'report/purchased', NULL, '[[regtime]]', NULL, 712, 218),
(13, NULL, NULL, 'report_product', NULL, '[[regtime]]', NULL, 713, 217),
(13, NULL, NULL, 'report_product', NULL, '[[regtime]]', NULL, 714, 218),
(14, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 715, 217),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 716, 218),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 717, 217),
(15, NULL, NULL, 'core', NULL, '[[regtime]]', NULL, 718, 218),
(40, NULL, NULL, '235', NULL, '[[regtime]]', NULL, 719, 217),
(40, NULL, NULL, '236', NULL, '[[regtime]]', NULL, 720, 218),
(16, NULL, NULL, 'home', NULL, '[[regtime]]', NULL, 721, 1),
(16, NULL, NULL, 'login', NULL, '[[regtime]]', NULL, 722, 2),
(16, NULL, NULL, 'logout', NULL, '[[regtime]]', NULL, 723, 3),
(16, NULL, NULL, 'account', NULL, '[[regtime]]', NULL, 724, 4),
(16, NULL, NULL, 'cart', NULL, '[[regtime]]', NULL, 725, 5),
(16, NULL, NULL, 'checkout', NULL, '[[regtime]]', NULL, 726, 6),
(16, NULL, NULL, 'specials', NULL, '[[regtime]]', NULL, 727, 14),
(16, NULL, NULL, 'order', NULL, '[[regtime]]', NULL, 728, 15),
(17, NULL, NULL, 'Home', NULL, '[[regtime]]', NULL, 729, 1),
(17, NULL, NULL, 'Login', NULL, '[[regtime]]', NULL, 730, 2),
(17, NULL, NULL, 'Logout', NULL, '[[regtime]]', NULL, 731, 3),
(17, NULL, NULL, 'Account', NULL, '[[regtime]]', NULL, 732, 4),
(17, NULL, NULL, 'Cart', NULL, '[[regtime]]', NULL, 733, 5),
(17, NULL, NULL, 'Checkout', NULL, '[[regtime]]', NULL, 734, 6),
(17, NULL, NULL, 'Specials', NULL, '[[regtime]]', NULL, 735, 14),
(17, NULL, NULL, 'Check Your Order', NULL, '[[regtime]]', NULL, 736, 15),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 737, 1),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 738, 2),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 739, 3),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 740, 4),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 741, 5),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 742, 6),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 743, 14),
(18, 1, NULL, NULL, NULL, '[[regtime]]', NULL, 744, 15),
(16, NULL, NULL, 'home', NULL, '[[regtime]]', NULL, 745, 7),
(16, NULL, NULL, 'login', NULL, '[[regtime]]', NULL, 746, 8),
(16, NULL, NULL, 'logout', NULL, '[[regtime]]', NULL, 747, 9),
(16, NULL, NULL, 'account', NULL, '[[regtime]]', NULL, 748, 10),
(16, NULL, NULL, 'cart', NULL, '[[regtime]]', NULL, 749, 11),
(16, NULL, NULL, 'checkout', NULL, '[[regtime]]', NULL, 750, 12),
(16, NULL, NULL, 'specials', NULL, '[[regtime]]', NULL, 751, 13),
(16, NULL, NULL, 'order', NULL, '[[regtime]]', NULL, 752, 16),
(17, NULL, NULL, 'Casa', NULL, '[[regtime]]', NULL, 753, 7),
(17, NULL, NULL, 'Iniciar Sesión', NULL, '[[regtime]]', NULL, 754, 8),
(17, NULL, NULL, 'Cerrar sesión', NULL, '[[regtime]]', NULL, 755, 9),
(17, NULL, NULL, 'Cuenta', NULL, '[[regtime]]', NULL, 756, 10),
(17, NULL, NULL, 'Carro', NULL, '[[regtime]]', NULL, 757, 11),
(17, NULL, NULL, 'Caja', NULL, '[[regtime]]', NULL, 758, 12),
(17, NULL, NULL, 'Especiales', NULL, '[[regtime]]', NULL, 759, 13),
(17, NULL, NULL, 'Comprobar el Orden', NULL, '[[regtime]]', NULL, 760, 16),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 761, 7),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 762, 8),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 763, 9),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 764, 10),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 765, 11),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 766, 12),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 767, 13),
(18, 9, NULL, NULL, NULL, '[[regtime]]', NULL, 768, 16),
(20, NULL, NULL, NULL, NULL, '[[regtime]]', NULL, 769, 1),
(21, NULL, NULL, 'AbanteCart', NULL, '[[regtime]]', NULL, 770, 1),
(22, NULL, NULL, '1.4.2', NULL, '[[regtime]]', NULL, 771, 1),
(23, NULL, NULL, '', NULL, '[[regtime]]', NULL, 772, 1),
(24, NULL, NULL, '', NULL, '[[regtime]]', NULL, 773, 1),
(25, NULL, NULL, 'install', NULL, '[[regtime]]', NULL, 774, 1),
(26, NULL, NULL, 'admin', NULL, '[[regtime]]', NULL, 775, 1),
(20, NULL, NULL, NULL, NULL, '[[regtime]]', NULL, 776, 2),
(21, NULL, NULL, 'novator', NULL, '[[regtime]]', NULL, 777, 2),
(22, NULL, NULL, '', NULL, '[[regtime]]', NULL, 778, 2),
(23, NULL, NULL, '', NULL, '[[regtime]]', NULL, 779, 2),
(24, NULL, NULL, NULL, NULL, '0000-00-00 00:00:00', NULL, 780, 2),
(25, NULL, NULL, 'install', NULL, '[[regtime]]', NULL, 781, 2),
(26, NULL, NULL, 'install', NULL, '[[regtime]]', NULL, 782, 2),
(10, NULL, NULL, 'page_builder', NULL, '[[regtime]]', NULL, 783, 222),
(13, NULL, NULL, 'design', NULL, '[[regtime]]', NULL, 784, 222),
(11, NULL, NULL, 'page_builder_name', NULL, '[[regtime]]', NULL, 785, 222),
(12, NULL, NULL, 'design/page_builder', NULL, '[[regtime]]', NULL, 786, 222),
(40, NULL, NULL, '100263', NULL, '[[regtime]]', NULL, 787, 222),
(15, NULL, NULL, 'extension', NULL, '[[regtime]]', NULL, 788, 222),
(14, 2, NULL, NULL, NULL, '[[regtime]]', NULL, 789, 222);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]downloads`
--

CREATE TABLE `[[dbprefix]]downloads` (
  `download_id` int NOT NULL AUTO_INCREMENT,
  `filename` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `max_downloads` int DEFAULT NULL,
  `expire_days` int DEFAULT NULL,
  `sort_order` int NOT NULL,
  `activate` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `activate_order_status_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shared` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`download_id`),
  KEY `[[dbprefix]]downloads_idx` (`activate_order_status_id`,`shared`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]downloads`
--

INSERT INTO `[[dbprefix]]downloads` VALUES
(1, '100196', 'audio-cd.mp3', 50, NULL, 2, 'order_status', 'a:1:{i:0;s:1:"5";}', 0, 1, '[[regtime]]', '[[regtime]]'),
(2, '100197', 'sample.mp3', NULL, NULL, 1, 'before_order', 'a:1:{i:0;s:0:"";}', 0, 1, '[[regtime]]', '[[regtime]]'),
(5, 'download/18/79/f.pdf', 'size-fit-guide-print.pdf', NULL, NULL, 0, 'before_order', 'a:1:{i:0;s:0:"";}', 1, 1, '[[regtime]]', '[[regtime]]'),
(6, '100261', 'file-sample_150kB.pdf', NULL, NULL, 0, 'immediately', '0', 0, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]download_attribute_values`
--

CREATE TABLE `[[dbprefix]]download_attribute_values` (
  `download_attribute_id` int NOT NULL AUTO_INCREMENT,
  `attribute_id` int NOT NULL,
  `download_id` int NOT NULL,
  `attribute_value_ids` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`download_attribute_id`),
  KEY `[[dbprefix]]download_attribute_values_idx` (`attribute_id`,`download_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]download_descriptions`
--

CREATE TABLE `[[dbprefix]]download_descriptions` (
  `download_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`download_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]download_descriptions`
--

INSERT INTO `[[dbprefix]]download_descriptions` VALUES
(1, 1, 'Audio CD1'),
(2, 1, 'audio sample mp3'),
(5, 1, 'Find your fit'),
(6, 1, 'Sample PDF');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_templates`
--

CREATE TABLE `[[dbprefix]]email_templates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL,
  `text_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `language_id` int NOT NULL,
  `headers` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `html_body` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `text_body` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `allowed_placeholders` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_deleted` timestamp NULL DEFAULT NULL,
  `store_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email_templates_text_id_idx` (`text_id`,`language_id`,`store_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]email_templates`
--

INSERT INTO `[[dbprefix]]email_templates` VALUES
(1, 1, 'storefront_reset_password_link', 1, '', '{{store_name}} - Password reset', 'A password reset was requested from {{store_name}}&lt;br /&gt;\r\nTo reset your password click link below:&lt;br /&gt;\r\n&lt;a href="{{ reset_link }}"&gt;{{ reset_link }}&lt;/a &gt;\r\n&lt;br /&gt;&lt;br /&gt;\r\n{{{ text_project_label }}}', 'A password reset was requested from {{store_name}} \r\nTo reset your password click link below:\r\n{{ reset_link }}\r\n\r\n\r\n{{{ text_project_label }}}', 'store_name, reset_link, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(2, 1, 'storefront_welcome_email_activated', 1, '', 'Welcome, {{store_name}}', '&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;', 'Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}', 'store_name, login_url, store_url, logo_html, logo_uri, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(3, 1, 'storefront_welcome_email_approval', 1, '', 'Welcome, {{store_name}}', '&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n					&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n				{{#logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/logo_uri}}\r\n                                                 {{^logo_uri}}\r\n                                                       {{#logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/logo_html}}\r\n                                                 {{/logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;', 'Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}', 'store_name, login_url, store_url, logo_html, logo_uri, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(4, 1, 'storefront_send_activate_link', 1, '', '{{store_name}} - Thank you for registering', '&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n					&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n					{{#logo_uri}}\r\n							&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/logo_uri}}\r\n                                                 {{^logo_uri}}\r\n                                                       {{#logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/logo_html}}\r\n                                                 {{/logo_uri}}\r\n					&lt;/a&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Before we can activate your account one last step must be taken to complete your registration.&lt;br/&gt;\r\nYou must complete this last step to become a registered member. Please click the following link to activate your account:&lt;br/&gt;\r\n{{{ activate_url }}}&lt;br/&gt;\r\n\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;\r\n&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n			 	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;', 'Welcome and thank you for registering at {{ store_name }}!\r\n\r\nBefore we can activate your account one last step must be taken to complete your registration.\r\nYou must complete this last step to become a registered member. Please click the following link to activate your account\r\n{{ activate_url }}\r\n\r\nThank you,\r\n{{ store_name }}\r\n\r\n{{{ text_project_label }}}', 'store_name, activate_url, logo_uri, logo_html, store_url, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(5, 1, 'storefront_reset_password_notify', 1, '', '{{store_name}} - Password reset', 'Your password was successfully reset on {{store_name}}\r\n&lt;br/&gt;\r\n{{{ text_project_label }}}', 'Your password was successfully reset on {{store_name}}\r\n\r\n{{{ text_project_label }}}', 'store_name, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(6, 1, 'storefront_send_login_name', 1, '', '{{store_name}} - Login name reminder', 'Login name reminder was requested from {{store_name}} &lt;br/&gt;\r\n&lt;br/&gt;\r\nYour login name is: {{ login_name }}\r\n\r\n&lt;br/&gt;\r\n{{store_name}} \r\n&lt;br/&gt;\r\n&lt;br/&gt;\r\n{{{ text_project_label }}}', 'Login name reminder was requested from {{store_name}} \r\n\r\nYour login name is: {{ login_name }}\r\n\r\n{{store_name}} \r\n\r\n{{{ text_project_label }}}', 'store_name, login_name, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(7, 1, 'storefront_order_confirm', 1, '', '{{store_name}} - Order {{ order_id }}', '&lt;html&gt;\r\n&lt;head&gt;\r\n	&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;title&gt; {{store_name}} - Order {{ order_id }} &lt;/title&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n					&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n			&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;Order Details&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;Order ID: &lt;span\r\n					style=&quot;color: #069; font-weight: bold;&quot;&gt;{{ order_id }}&lt;/span&gt;&lt;br/&gt;\r\n			Date Ordered: {{ date_added }}&lt;br&gt;\r\n			Payment Method: &lt;strong&gt;{{ payment_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			Shipping Method: &lt;strong&gt;{{ shipping_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			&lt;br/&gt;\r\n			Email: &lt;strong&gt;{{ customer_email }}&lt;/strong&gt;&lt;br/&gt;\r\n			Telephone: &lt;strong&gt;{{ customer_telephone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{# customer_mobile_phone }}\r\n                            Telephone: &lt;strong&gt;{{ customer_mobile_phone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_mobile_phone }}\r\n		         {{# customer_fax }}\r\n                            Fax: &lt;strong&gt;{{ customer_fax }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_fax }}\r\n                         IP Address:&lt;strong&gt;{{ customer_ip }}&lt;/strong&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;&quot;&gt;\r\n				&lt;tr style=&quot;background-color: #CCCCCC; text-transform: uppercase;&quot;&gt;\r\n		&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Shipping Address&lt;/th&gt;\r\n					&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Payment Address&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				&lt;tr&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# shipping_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n&lt;/td&gt;\r\n&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# payment_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n&lt;/td&gt;\r\n				&lt;/tr&gt;\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;&quot;&gt;\r\n				&lt;tr style=&quot;background-color: #CCCCCC;&quot;&gt;\r\n					&lt;th style=&quot;width: 40%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Product&lt;/th&gt;\r\n					&lt;th class=&quot;align_left&quot; style=&quot;color: #FFFFFF;&quot;&gt;Model&lt;/th&gt;\r\n&lt;th class=&quot;align_right&quot;\r\n		    style=&quot;width: 10%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Price&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n					    style=&quot;width: 15%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Quantity&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n	    style=&quot;width: 20%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Total&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				{{# products }}\r\n					&lt;tr style=&quot;background-color: #EEEEEE; text-align: center;&quot;&gt;\r\n						&lt;td class=&quot;align_left&quot; style=&quot;text-align: left;&quot;&gt;{{ name }}\r\n	{{# option }}\r\n								&lt;br/&gt;\r\n								&amp;nbsp;&amp;nbsp;- {{ name}} {{ value }} \r\n	{{/ option }}\r\n						&lt;td class=&quot;align_left&quot;&gt; {{ model }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ price }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ quantity }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ total }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                {{/ products }}\r\n                                         {{# totals }}\r\n			&lt;tr style=&quot;text-align: right;&quot;&gt;\r\n						&lt;td colspan=&quot;3&quot;&gt;&amp;nbsp;&lt;/td&gt;\r\n						&lt;td style=&quot;background-color: #EEEEEE; font-weight: bold; padding: 0.3em;&quot;&gt;{{ title }} &lt;/td&gt;\r\n						&lt;td style=&quot;background-color: #EEEEEE; padding: 0.3em;&quot;&gt; {{ text }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                         {{/ totals }}\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n {{# comment }}\r\n	&lt;tr&gt;\r\n&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;The comments for your order are:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;&gt; {{{ comment }}} &lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n {{/ comment }}\r\n {{# invoice }}\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;To view your order click on the link below:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;&lt;a href=&quot;{{ invoice }}&quot;&gt; {{ invoice }}&lt;/a&gt;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n{{/ invoice }}\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_center&quot;\r\n		    style=&quot;font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot;\r\n			   style=&quot;color: #069; font-weight: bold; text-decoration: none;&quot;&gt;{{ store_name }}&lt;/a&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n', 'Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{ shipping_method }}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{ title }}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}', 'store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, ', '[[regtime]]', '[[regtime]]', NULL, 0),
(8, 1, 'storefront_order_confirm_admin_notify', 1, '', '{{store_name}} - Order {{ order_id }}', '&lt;html&gt;\r\n&lt;head&gt;\r\n	&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;title&gt; {{store_name}} - Order {{ order_id }} &lt;/title&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;You have received an order.&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;Order Details&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;Order ID: &lt;span\r\n			style=&quot;color: #069; font-weight: bold;&quot;&gt;{{ order_id }}&lt;/span&gt;&lt;br/&gt;\r\n			Date Ordered: {{ date_added }}&lt;br&gt;\r\n			Payment Method: &lt;strong&gt;{{ payment_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			Shipping Method: &lt;strong&gt;{{ shipping_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			&lt;br/&gt;\r\n			Email: &lt;strong&gt;{{ customer_email }}&lt;/strong&gt;&lt;br/&gt;\r\n			Telephone: &lt;strong&gt;{{ customer_telephone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{# customer_mobile_phone }}\r\n                            Telephone: &lt;strong&gt;{{ customer_mobile_phone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_mobile_phone }}\r\n		         {{# customer_fax }}\r\n                            Fax: &lt;strong&gt;{{ customer_fax }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_fax }}\r\n                         IP Address:&lt;strong&gt;{{ customer_ip }}&lt;/strong&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;&quot;&gt;\r\n		&lt;tr style=&quot;background-color: #CCCCCC; text-transform: uppercase;&quot;&gt;\r\n					&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Shipping Address&lt;/th&gt;\r\n		&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Payment Address&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				&lt;tr&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# shipping_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n&lt;/td&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# payment_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n&lt;/td&gt;\r\n				&lt;/tr&gt;\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;&quot;&gt;\r\n				&lt;tr style=&quot;background-color: #CCCCCC;&quot;&gt;\r\n					&lt;th style=&quot;width: 40%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Product&lt;/th&gt;\r\n					&lt;th class=&quot;align_left&quot; style=&quot;color: #FFFFFF;&quot;&gt;Model&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n		    style=&quot;width: 10%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Price&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n					    style=&quot;width: 15%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Quantity&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n					    style=&quot;width: 20%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Total&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				{{# products }}\r\n					&lt;tr style=&quot;background-color: #EEEEEE; text-align: center;&quot;&gt;\r\n						&lt;td class=&quot;align_left&quot; style=&quot;text-align: left;&quot;&gt;{{ name }}\r\n					{{# option }}\r\n			&lt;br/&gt;\r\n								&amp;nbsp;&amp;nbsp;- {{ name}} {{ value }} \r\n	{{/ option }}\r\n						&lt;td class=&quot;align_left&quot;&gt; {{ model }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ price }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ quantity }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ total }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                {{/ products }}\r\n                                         {{# totals }}\r\n			&lt;tr style=&quot;text-align: right;&quot;&gt;\r\n						&lt;td colspan=&quot;3&quot;&gt;&amp;nbsp;&lt;/td&gt;\r\n						&lt;td style=&quot;background-color: #EEEEEE; font-weight: bold; padding: 0.3em;&quot;&gt;{{ title }} &lt;/td&gt;\r\n					&lt;td style=&quot;background-color: #EEEEEE; padding: 0.3em;&quot;&gt; {{ text }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                         {{/ totals }}\r\n		&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n {{# comment }}\r\n	&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;The comments for your order are:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;&gt; {{{ comment }}} &lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n {{/ comment }}\r\n {{# invoice }}\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;To view your order click on the link below:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n&lt;td class=&quot;align_left&quot;&gt;&lt;a href=&quot;{{ invoice }}&quot;&gt; {{ invoice }}&lt;/a&gt;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n{{/ invoice }}\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_center&quot;\r\n		    style=&quot;font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot;\r\n			   style=&quot;color: #069; font-weight: bold; text-decoration: none;&quot;&gt;{{ store_name }}&lt;/a&gt;\r\n{{{ text_project_label }}}\r\n	&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n', 'You have received an order.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{ shipping_method }}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}}\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}} \r\n{{{ company }}}\r\n{{{ address_1 }}}\r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{ title }}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}', 'store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, order_total', '[[regtime]]', '[[regtime]]', NULL, 0),
(11, 1, 'admin_order_status_notify', 1, '', '{{ store_name }} - Order Update {{ order_id }}', 'Order:  {{ order_id }} &lt;br/&gt;\r\nDate added: {{ order_date_added }} &lt;br/&gt;\r\nOrder status: {{ order_status }} &lt;br/&gt;\r\nInvoice: {{ invoice }}&lt;br/&gt;\r\n&lt;br/&gt;\r\n\r\nComment:&lt;br/&gt;\r\n{{{ comment }}}&lt;br/&gt;\r\n\r\n&lt;br/&gt;\r\n\r\nPlease reply to this email if you have any questions.\r\n', 'Order:  {{ order_id }} \r\nDate added: {{ order_date_added }} \r\nOrder status: {{ order_status }} \r\nInvoice: {{ invoice }}\r\n\r\nComment:\r\n{{{ comment }}}\r\n\r\nPlease reply to this email if you have any questions.\r\n', 'store_name, order_id, order_date_added, order_status, invoice, comment', '[[regtime]]', '[[regtime]]', NULL, 0),
(12, 1, 'admin_new_transaction_notify', 1, '', 'New transaction has been posted to your {{store_name}} account', 'New transaction has been posted to your {{ store_name }} account in the amount of {{ amount }}. For more details, login to {{ store_name }} account', 'New transaction has been posted to your {{ store_name }} account in the amount of {{ amount }}. For more details, login to {{ store_name }} account', 'store_name, amount, transactions_url', '[[regtime]]', '[[regtime]]', NULL, 0),
(13, 1, 'admin_approval_email', 1, '', '{{ store_name}} - Your Account has been activated!', '&lt;a href="{{ store_url }}" title="{{ store_name }}"&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src="{{ logo_uri }}" alt="{{store_name}}" style="border: none;"&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n\r\nWelcome and thank you for registering at {{ store_name }} &lt;br/&gt;\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL: &lt;br/&gt;\r\n{{ store_url }}&lt;br/&gt;\r\n&lt;br/&gt;\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.&lt;br/&gt;\r\n&lt;br/&gt;\r\nThank you,&lt;br/&gt;\r\n {{ store_name}} &lt;br/&gt;\r\n\r\n{{ text_project_label }}', 'Welcome and thank you for registering at {{ store_name }} \r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL: \r\n{{ store_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you,\r\n {{ store_name}} \r\n\r\n{{text_project_label}}', 'store_name, store_url, text_project_label, logo_uri, logo_html', '[[regtime]]', '[[regtime]]', NULL, 0),
(14, 1, 'storefront_password_reset_notify', 1, '', '{{store_name}} Notification', 'Your password has been updated! If you did not do any changes, please contact site owner&lt;br/&gt;', 'Your password has been updated! If you did not do any changes, please contact site owner', 'store_name, loginname, customer_id, firstname, lastname', '[[regtime]]', '[[regtime]]', NULL, 0),
(15, 1, 'storefront_customer_account_update', 1, '', '{{store_name}} Account update notification', 'Your account has been updated! If you did not do any changes, please contact site owner ', ' Your account has been updated! If you did not do any changes, please contact site owner ', 'store_name, firstname, lastname, telephone, fax, email, loginname, customer_id, old_loginname, old_email', '[[regtime]]', '[[regtime]]', NULL, 0),
(16, 1, 'storefront_contact_us_mail', 1, '', 'Enquiry from {{ first_name }}', '&lt;html&gt;\r\n&lt;head&gt;\r\n	&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;title&gt;{{ title }}&lt;/title&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n				{{# logo_uri }}\r\n					&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{ store_name }}&quot; style=&quot;border: none;&quot;&gt;\r\n				{{/ logo_uri }}\r\n				{{# logo_html }}\r\n					{{ logo_html }}\r\n				{{/ logo_html }}				 \r\n			&lt;/a&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;{{ entry_enquiry }}&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot; font-size: 12px; padding: 0.5em 1em;&quot;&gt;{{{ enquiry }}}&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;&quot;&gt;\r\n				{{# tpl_form_fields }}\r\n				&lt;tr&gt;\r\n				&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;{{ name }}&lt;/td&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;{{ value }}&lt;/td&gt;\r\n				&lt;/tr&gt;\r\n				{{/ tpl_form_fields }}\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_center&quot;\r\n		    style=&quot;font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot;\r\n			   style=&quot;color: #069; font-weight: bold; text-decoration: none;&quot;&gt;{{ store_name }}&lt;/a&gt;&lt;br&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n', '{{ store_name }}\r\n\r\n{{ entry_enquiry }}\r\n{{{ enquiry }}}\r\n\r\n\r\n{{# tpl_form_fields }}\r\n{{ name }}  {{ value }}\r\n{{/ tpl_form_fields }}\r\n\r\n{{{ text_project_label }}}', 'first_name, title, store_url, store_name, logo_uri, logo_html, entry_enquiry, enquiry, tpl_form_fields, form_fields, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(17, 1, 'storefront_contact_us_mail_admin_notify', 1, '', 'New enquiry from customer', ' You have got new enquiry from customer ({{first_name}}, {{email}})!', ' You have got new enquiry from customer ({{first_name}}, {{email}})! ', 'first_name, email', '[[regtime]]', '[[regtime]]', NULL, 0),
(18, 1, 'storefront_new_customer_admin_notify', 1, '', ' New Customer {{ firstname }} {{ lastname }} has been registered!', ' New Customer {{ firstname }} {{ lastname }}  has been registered!', ' New Customer {{ firstname }} {{ lastname }}  has been registered!', 'firstname, lastname', '[[regtime]]', '[[regtime]]', NULL, 0),
(19, 1, 'storefront_new_subscriber_admin_notify', 1, '', ' New Subscriber {{ firstname }} {{ lastname }} has been registered!', ' New Subscriber {{ firstname }} {{ lastname }} has been registered!', ' New Subscriber {{ firstname }} {{ lastname }} has been registered!', 'firstname, lastname', '[[regtime]]', '[[regtime]]', NULL, 0),
(21, 1, 'storefront_product_out_of_stock_admin_notify', 1, '', 'Product with ID #{{ product_id }} is out of Stock. ', ' Product with ID #{{ product_id }} is out of Stock. \r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}', ' Product with ID #{{ product_id }} is out of Stock. \r\n\r\n{{{ text_project_label }}}', 'product_id, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(22, 1, 'storefront_product_review_admin_notify', 1, '', ' New product review has been added.', ' New product review has been added. See details {{ product_url }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}', ' New product review has been added. See details {{ product_url }}\r\n\r\n{{{ text_project_label }}}', 'product_url, product_id, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(23, 1, 'storefront_welcome_email_approved', 1, '', 'Welcome, {{store_name}} ', '&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;', 'Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}', 'store_name, login_url, store_url, logo_html, logo_uri, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0),
(24, 1, 'fast_checkout_welcome_email_guest_registration', 1, '', 'Welcome, {{store_name}}', '&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\n&lt;br/&gt;\r\nYour Login Name: {{login}}  &lt;br/&gt;\r\nYour Password: {{password}}  &lt;br/&gt;\r\n	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;', 'Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nYour Login Name: {{login}}\r\nYour Password: {{password}}\r\n\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}', 'store_name, login_url, store_url, logo_html, logo_uri, text_project_label, login, password', '[[regtime]]', '[[regtime]]', NULL, 0),
(25, 1, 'admin_reset_password_link', 1, '', '{{store_name}} - Password reset', 'A password reset was requested from {{store_name}}&lt;br /&gt;\r\nTo reset your password click link below:&lt;br /&gt;\r\n&lt;a href="{{ reset_link }}"&gt;{{ reset_link }}&lt;/a &gt;\r\n&lt;br /&gt;&lt;br /&gt;\r\n{{{ text_project_label }}}', 'A password reset was requested from {{store_name}} \r\nTo reset your password click link below:\r\n{{ reset_link }}\r\n\r\n\r\n{{{ text_project_label }}}', 'store_name, reset_link, text_project_label', '[[regtime]]', '[[regtime]]', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]encryption_keys`
--

CREATE TABLE `[[dbprefix]]encryption_keys` (
  `key_id` int NOT NULL AUTO_INCREMENT,
  `key_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` int NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key_id`),
  UNIQUE KEY `encryption_keys_key_name` (`key_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extensions`
--

CREATE TABLE `[[dbprefix]]extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint NOT NULL,
  `priority` smallint NOT NULL DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_key` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_installed` timestamp NULL DEFAULT NULL,
  `support_expiration` datetime DEFAULT NULL,
  `mp_product_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`extension_id`),
  UNIQUE KEY `extension_key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=23 ;

--
-- Dumping data for table `[[dbprefix]]extensions`
--

INSERT INTO `[[dbprefix]]extensions` VALUES
(1, 'total', 'coupon', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(2, 'total', 'shipping', 'shipping', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(3, 'total', 'low_order_fee', '', 0, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(4, 'total', 'handling', '', 0, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(5, 'total', 'sub_total', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(6, 'total', 'tax', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(7, 'total', 'total', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(8, 'total', 'balance', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(9, 'block', 'cart', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(10, 'block', 'category', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(11, 'block', 'content', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(12, 'block', 'manufacturer', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(13, 'block', 'bestseller', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(14, 'block', 'latest', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(15, 'block', 'featured', '', 1, 1, '', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(16, 'extensions', 'banner_manager', 'extensions', 1, 1, '1.1.1', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(17, 'extensions', 'forms_manager', 'extensions', 1, 1, '1.4.1', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(18, 'template', 'novator', 'template', 1, 0, '1.0.3', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(19, 'extensions', 'page_builder', 'tools', 1, 10000, '1.4.0', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(20, 'payment', 'default_cod', 'payment', 1, 1, '1.1.2', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(21, 'shipping', 'default_flat_rate_shipping', 'shipping', 1, 1, '1.1.1', NULL, '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]'),
(22, 'shipping', 'default_local_delivery', 'shipping', 1, 10, '1.1.1', '', '[[regtime]]', NULL, '', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extension_dependencies`
--

CREATE TABLE `[[dbprefix]]extension_dependencies` (
  `extension_id` int NOT NULL,
  `extension_parent_id` int NOT NULL,
  PRIMARY KEY (`extension_id`,`extension_parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields`
--

CREATE TABLE `[[dbprefix]]fields` (
  `field_id` int NOT NULL AUTO_INCREMENT,
  `form_id` int NOT NULL DEFAULT '0',
  `field_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'I',
  `sort_order` int NOT NULL,
  `attributes` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'N',
  `status` smallint NOT NULL DEFAULT '0',
  `regexp_pattern` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`field_id`),
  KEY `field_id` (`field_id`,`form_id`,`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]fields`
--

INSERT INTO `[[dbprefix]]fields` VALUES
(11, 2, 'first_name', 'I', 1, '', '', 'Y', 1, '/^.{3,100}$/u'),
(12, 2, 'email', 'I', 2, '', '', 'Y', 1, '/^[A-Z0-9._%-]+@[A-Z0-9.-]{0,61}[A-Z0-9].[A-Z]{2,16}$/i'),
(13, 2, 'enquiry', 'T', 3, 'cols="50" rows="8"', '', 'Y', 1, '/^.{3,1000}$/su'),
(14, 2, 'captcha', 'K', 4, '', '', 'Y', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_groups`
--

CREATE TABLE `[[dbprefix]]fields_groups` (
  `field_id` int NOT NULL,
  `group_id` int NOT NULL,
  `sort_order` int NOT NULL,
  PRIMARY KEY (`field_id`),
  KEY `field_id` (`field_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_group_descriptions`
--

CREATE TABLE `[[dbprefix]]fields_group_descriptions` (
  `group_id` int NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `language_id` int NOT NULL,
  PRIMARY KEY (`group_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_history`
--

CREATE TABLE `[[dbprefix]]fields_history` (
  `hist_id` int NOT NULL AUTO_INCREMENT,
  `table_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `record_id` int NOT NULL,
  `field` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int NOT NULL DEFAULT '1',
  `language_id` int NOT NULL,
  `text` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`hist_id`),
  KEY `[[dbprefix]]fields_history_idx` (`table_name`,`record_id`,`field`,`language_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]fields_history`
--

INSERT INTO `[[dbprefix]]fields_history` VALUES
(1, 'block_descriptions', 11, 'content', 1, 1, '&lt;div class=&quot;contactus-block text-center text-md-start&quot;&gt;\n&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/5.svg&quot; alt=&quot;images&quot; class=&quot;img-fluid h-auto&quot; width=&quot;350&quot; height=&quot;79&quot;&gt;&lt;p class=&quot;text-white&quot;&gt;1487 Rocky Horse Carrefour&lt;br&gt;Arlington, TX 16819&lt;/p&gt;&lt;h4 class=&quot;text-white&quot;&gt;&lt;i class=&quot;bi bi-telephone&quot;&gt;&lt;/i&gt; (444) 019 120 0401&lt;/h4&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-success d-inline-block&quot;&gt;Live Chat&lt;/a&gt; &lt;a href=&quot;#&quot; class=&quot;btn btn-outline-light d-inline-block&quot;&gt;Help Desk&lt;/a&gt;\n&lt;/div&gt;', '[[regtime]]'),
(2, 'block_descriptions', 11, 'content', 2, 1, '&lt;div class=&quot;contactus-block text-center text-md-start&quot;&gt;\n&lt;img src=&quot;extensions/novator/storefront/view/novator/image/presets/18/7b/5.svg&quot; alt=&quot;images&quot; class=&quot;img-fluid h-auto&quot; width=&quot;350&quot; height=&quot;79&quot;&gt;&lt;p class=&quot;text-white&quot;&gt;1487 Rocky Horse Carrefour&lt;br&gt;Arlington, TX 16819&lt;/p&gt;&lt;h4 class=&quot;text-white&quot;&gt;&lt;i class=&quot;bi bi-telephone&quot;&gt;&lt;/i&gt; (444) 019 120 0401&lt;/h4&gt;&lt;a href=&quot;#&quot; class=&quot;btn btn-success&quot;&gt;Live Chat&lt;/a&gt; &lt;a href=&quot;#&quot; class=&quot;btn btn-outline-light d-inline-block&quot;&gt;Help Desk&lt;/a&gt;\n&lt;/div&gt;', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_descriptions`
--

CREATE TABLE `[[dbprefix]]field_descriptions` (
  `field_id` int NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `language_id` int NOT NULL,
  `error_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`field_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]field_descriptions`
--

INSERT INTO `[[dbprefix]]field_descriptions` VALUES
(11, 'First name:', '', 1, 'Name must be between 3 and 32 characters!'),
(12, 'Email:', '', 1, 'E-Mail Address does not appear to be valid!'),
(13, 'Enquiry:', '', 1, 'Enquiry must be between 10 and 3000 characters!'),
(14, 'Enter the code in the box below:', '', 1, 'Human verification has failed! Please try agan.');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_values`
--

CREATE TABLE `[[dbprefix]]field_values` (
  `value_id` int NOT NULL AUTO_INCREMENT,
  `field_id` int NOT NULL DEFAULT '0',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `language_id` int NOT NULL,
  PRIMARY KEY (`value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms`
--

CREATE TABLE `[[dbprefix]]forms` (
  `form_id` int NOT NULL AUTO_INCREMENT,
  `form_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `controller` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `success_page` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`form_id`),
  UNIQUE KEY `form_name` (`form_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]forms`
--

INSERT INTO `[[dbprefix]]forms` VALUES
(2, 'ContactUsFrm', 'content/contact', 'content/contact/success', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_descriptions`
--

CREATE TABLE `[[dbprefix]]form_descriptions` (
  `form_id` int NOT NULL DEFAULT '0',
  `language_id` int NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`form_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]form_descriptions`
--

INSERT INTO `[[dbprefix]]form_descriptions` VALUES
(2, 1, 'Contact Us Form');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_groups`
--

CREATE TABLE `[[dbprefix]]form_groups` (
  `group_id` int NOT NULL AUTO_INCREMENT,
  `group_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `form_id` int NOT NULL DEFAULT '0',
  `sort_order` int NOT NULL,
  `status` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`),
  KEY `group_id` (`group_id`,`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes`
--

CREATE TABLE `[[dbprefix]]global_attributes` (
  `attribute_id` int NOT NULL AUTO_INCREMENT,
  `attribute_parent_id` int NOT NULL DEFAULT '0',
  `attribute_group_id` int DEFAULT NULL,
  `attribute_type_id` int NOT NULL,
  `element_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'I',
  `sort_order` int NOT NULL DEFAULT '0',
  `required` smallint NOT NULL DEFAULT '0',
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint NOT NULL DEFAULT '0',
  `regexp_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attribute_id`),
  KEY `[[dbprefix]]global_attributes_idx` (`attribute_parent_id`,`attribute_group_id`,`attribute_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]global_attributes`
--

INSERT INTO `[[dbprefix]]global_attributes` VALUES
(1, 0, 0, 1, 'S', 1, 1, '', 1, NULL),
(2, 0, 0, 1, 'C', 0, 0, '', 1, NULL),
(5, 0, 0, 1, 'G', 1, 1, '', 1, NULL),
(6, 0, 0, 1, 'S', 0, 0, 'a:4:{s:10:"extensions";s:0:"";s:8:"min_size";s:0:"";s:8:"max_size";s:0:"";s:9:"directory";s:0:"";}', 1, ''),
(7, 6, 0, 1, 'S', 0, 0, 'a:4:{s:10:"extensions";s:0:"";s:8:"min_size";s:0:"";s:8:"max_size";s:0:"";s:9:"directory";s:0:"";}', 1, ''),
(8, 6, 0, 1, 'S', 0, 0, 'a:4:{s:10:"extensions";s:0:"";s:8:"min_size";s:0:"";s:8:"max_size";s:0:"";s:9:"directory";s:0:"";}', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes_descriptions`
--

CREATE TABLE `[[dbprefix]]global_attributes_descriptions` (
  `attribute_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `placeholder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'translatable',
  `error_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`attribute_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]global_attributes_descriptions`
--

INSERT INTO `[[dbprefix]]global_attributes_descriptions` VALUES
(1, 1, 'Size', '', ''),
(2, 1, 'Gift Wrapping', '', ''),
(5, 1, 'Fragrance Type', '', ''),
(6, 1, 'Color&amp;Size', '', ''),
(7, 1, 'UK Size', '', ''),
(8, 1, 'Color', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes_groups`
--

CREATE TABLE `[[dbprefix]]global_attributes_groups` (
  `attribute_group_id` int NOT NULL AUTO_INCREMENT,
  `sort_order` int NOT NULL DEFAULT '0',
  `status` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`attribute_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes_groups_descriptions`
--

CREATE TABLE `[[dbprefix]]global_attributes_groups_descriptions` (
  `attribute_group_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`attribute_group_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes_types`
--

CREATE TABLE `[[dbprefix]]global_attributes_types` (
  `attribute_type_id` int NOT NULL AUTO_INCREMENT,
  `type_key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `controller` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int NOT NULL DEFAULT '0',
  `status` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`attribute_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]global_attributes_types`
--

INSERT INTO `[[dbprefix]]global_attributes_types` VALUES
(1, 'product_option', 'responses/catalog/attribute/getProductOptionSubform', 1, 1),
(2, 'download_attribute', 'responses/catalog/attribute/getDownloadAttributeSubform', 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes_type_descriptions`
--

CREATE TABLE `[[dbprefix]]global_attributes_type_descriptions` (
  `attribute_type_id` int NOT NULL,
  `language_id` int NOT NULL,
  `type_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`attribute_type_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]global_attributes_type_descriptions`
--

INSERT INTO `[[dbprefix]]global_attributes_type_descriptions` VALUES
(1, 1, 'Product Option', '[[regtime]]', '[[regtime]]'),
(2, 1, 'Download Attribute', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes_values`
--

CREATE TABLE `[[dbprefix]]global_attributes_values` (
  `attribute_value_id` int NOT NULL AUTO_INCREMENT,
  `attribute_id` int NOT NULL,
  `price_modifier` float DEFAULT '0',
  `price_prefix` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int NOT NULL DEFAULT '0',
  `txt_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attribute_value_id`),
  UNIQUE KEY `ga_value_txt_id_idx` (`txt_id`),
  KEY `[[dbprefix]]global_attributes_values_idx` (`attribute_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=99 ;

--
-- Dumping data for table `[[dbprefix]]global_attributes_values`
--

INSERT INTO `[[dbprefix]]global_attributes_values` VALUES
(32, 2, 0, NULL, 0, NULL),
(43, 1, 0, NULL, 0, NULL),
(44, 1, 0, NULL, 0, NULL),
(45, 1, 0, NULL, 0, NULL),
(46, 1, 0, NULL, 0, NULL),
(47, 1, 0, NULL, 0, NULL),
(48, 1, 0, NULL, 0, NULL),
(49, 1, 0, NULL, 0, NULL),
(50, 1, 0, NULL, 0, NULL),
(51, 1, 0, NULL, 0, NULL),
(52, 1, 0, NULL, 0, NULL),
(53, 1, 0, NULL, 0, NULL),
(75, 5, 0, NULL, 0, NULL),
(76, 5, 0, NULL, 0, NULL),
(77, 5, 0, NULL, 0, NULL),
(78, 6, 0, NULL, 0, NULL),
(79, 7, 0, NULL, 0, NULL),
(80, 7, 0, NULL, 0, NULL),
(81, 7, 0, NULL, 0, NULL),
(82, 7, 0, NULL, 0, NULL),
(83, 7, 0, NULL, 0, NULL),
(84, 7, 0, NULL, 0, NULL),
(85, 7, 0, NULL, 0, NULL),
(86, 7, 0, NULL, 0, NULL),
(87, 7, 0, NULL, 0, NULL),
(88, 8, 0, NULL, 0, NULL),
(89, 8, 0, NULL, 0, NULL),
(90, 8, 0, NULL, 0, NULL),
(91, 8, 0, NULL, 0, NULL),
(92, 8, 0, NULL, 0, NULL),
(93, 7, 0, NULL, 0, NULL),
(94, 7, 0, NULL, 0, NULL),
(95, 7, 0, NULL, 0, NULL),
(96, 7, 0, NULL, 0, NULL),
(97, 7, 0, NULL, 0, NULL),
(98, 8, 0, NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_attributes_value_descriptions`
--

CREATE TABLE `[[dbprefix]]global_attributes_value_descriptions` (
  `attribute_value_id` int NOT NULL,
  `attribute_id` int NOT NULL,
  `language_id` int NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`attribute_value_id`,`attribute_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]global_attributes_value_descriptions`
--

INSERT INTO `[[dbprefix]]global_attributes_value_descriptions` VALUES
(32, 2, 1, ''),
(42, 1, 1, '1.7 oz'),
(43, 1, 1, '3.4 oz'),
(44, 1, 1, '100ml'),
(45, 1, 1, '8.45 oz'),
(46, 1, 1, '15.2 oz'),
(47, 1, 1, '33.8 oz'),
(48, 1, 1, '1.5 oz'),
(49, 1, 1, '2.5 oz'),
(50, 1, 1, '30ml'),
(51, 1, 1, '50ml'),
(52, 1, 1, '75ml'),
(53, 1, 1, '1 oz'),
(75, 5, 1, 'Eau de Parfum'),
(76, 5, 1, 'Eau de Toilette'),
(77, 5, 1, 'Eau de Cologne'),
(78, 6, 1, ''),
(79, 7, 1, 'UK 3'),
(80, 7, 1, 'UK 3.5'),
(81, 7, 1, 'UK 4'),
(82, 7, 1, 'UK 4.5'),
(83, 7, 1, 'UK 5'),
(84, 7, 1, 'UK 5.5'),
(85, 7, 1, 'UK 6'),
(86, 7, 1, 'UK 7'),
(87, 7, 1, 'UK 8'),
(88, 8, 1, 'Red'),
(89, 8, 1, 'White'),
(90, 8, 1, 'Black'),
(91, 8, 1, 'Blue'),
(92, 8, 1, 'Green'),
(93, 7, 1, 'XXL'),
(94, 7, 1, 'XL'),
(95, 7, 1, 'S'),
(96, 7, 1, 'L'),
(97, 7, 1, 'M'),
(98, 8, 1, 'Yellow');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `language_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `directory` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int NOT NULL DEFAULT '0',
  `status` int NOT NULL,
  PRIMARY KEY (`language_id`),
  UNIQUE KEY `[[dbprefix]]languages_idx` (`language_id`,`code`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
(1, 'English', 'en', 'en_US.UTF-8,en_US,en-gb,english', '', 'english', 'english', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]language_definitions`
--

CREATE TABLE `[[dbprefix]]language_definitions` (
  `language_definition_id` int NOT NULL AUTO_INCREMENT,
  `language_id` int NOT NULL,
  `section` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-SF, 1-ADMIN',
  `block` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language_key` varchar(170) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language_value` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`language_definition_id`,`language_id`,`section`,`block`,`language_key`),
  KEY `[[dbprefix]]lang_definition_idx` (`language_value`(500))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4845 ;

--
-- Dumping data for table `[[dbprefix]]language_definitions`
--

INSERT INTO `[[dbprefix]]language_definitions` VALUES
(1, 1, 1, 'english', 'code', 'en', '[[regtime]]', '[[regtime]]'),
(2, 1, 1, 'english', 'direction', 'ltr', '[[regtime]]', '[[regtime]]'),
(3, 1, 1, 'english', 'date_format_short', 'm/d/Y', '[[regtime]]', '[[regtime]]'),
(4, 1, 1, 'english', 'date_format_long', 'l dS F Y', '[[regtime]]', '[[regtime]]'),
(5, 1, 1, 'english', 'time_format', 'h:i:s A', '[[regtime]]', '[[regtime]]'),
(6, 1, 1, 'english', 'time_format_short', 'H:i', '[[regtime]]', '[[regtime]]'),
(7, 1, 1, 'english', 'decimal_point', '.', '[[regtime]]', '[[regtime]]'),
(8, 1, 1, 'english', 'thousand_point', ',', '[[regtime]]', '[[regtime]]'),
(9, 1, 1, 'english', 'text_yes', 'Yes', '[[regtime]]', '[[regtime]]'),
(10, 1, 1, 'english', 'text_no', 'No', '[[regtime]]', '[[regtime]]'),
(11, 1, 1, 'english', 'text_plus', '+', '[[regtime]]', '[[regtime]]'),
(12, 1, 1, 'english', 'text_minus', '-', '[[regtime]]', '[[regtime]]'),
(13, 1, 1, 'english', 'text_enabled', 'Enabled', '[[regtime]]', '[[regtime]]'),
(14, 1, 1, 'english', 'text_disabled', 'Disabled', '[[regtime]]', '[[regtime]]'),
(15, 1, 1, 'english', 'text_none', ' --- None --- ', '[[regtime]]', '[[regtime]]'),
(16, 1, 1, 'english', 'text_select', ' --- Please Select --- ', '[[regtime]]', '[[regtime]]'),
(17, 1, 1, 'english', 'text_select_all', 'Select All', '[[regtime]]', '[[regtime]]'),
(18, 1, 1, 'english', 'text_unselect_all', 'Unselect All', '[[regtime]]', '[[regtime]]'),
(19, 1, 1, 'english', 'text_all_zones', 'All Zones', '[[regtime]]', '[[regtime]]'),
(20, 1, 1, 'english', 'text_default', '(Default)', '[[regtime]]', '[[regtime]]'),
(21, 1, 1, 'english', 'text_close', 'Close', '[[regtime]]', '[[regtime]]'),
(22, 1, 1, 'english', 'text_pagination', 'Showing {start} to {end} of {total} ({pages} Pages)', '[[regtime]]', '[[regtime]]'),
(23, 1, 1, 'english', 'text_per_page', 'Per Page', '[[regtime]]', '[[regtime]]'),
(24, 1, 1, 'english', 'text_no_results', 'No result found.', '[[regtime]]', '[[regtime]]'),
(25, 1, 1, 'english', 'text_separator', ' &gt; ', '[[regtime]]', '[[regtime]]'),
(26, 1, 1, 'english', 'text_edit', 'Edit ', '[[regtime]]', '[[regtime]]'),
(27, 1, 1, 'english', 'text_view', 'View', '[[regtime]]', '[[regtime]]'),
(28, 1, 1, 'english', 'text_home', 'Home', '[[regtime]]', '[[regtime]]'),
(29, 1, 1, 'english', 'button_insert', 'Insert', '[[regtime]]', '[[regtime]]'),
(30, 1, 1, 'english', 'button_delete', 'Delete', '[[regtime]]', '[[regtime]]'),
(31, 1, 1, 'english', 'button_save', 'Save', '[[regtime]]', '[[regtime]]'),
(32, 1, 1, 'english', 'button_save_and_close', 'Save & Close', '[[regtime]]', '[[regtime]]'),
(33, 1, 1, 'english', 'button_cancel', 'Cancel', '[[regtime]]', '[[regtime]]'),
(34, 1, 1, 'english', 'button_reset', 'Reset', '[[regtime]]', '[[regtime]]'),
(35, 1, 1, 'english', 'button_reload', 'Reload', '[[regtime]]', '[[regtime]]'),
(36, 1, 1, 'english', 'button_clear', 'Clear Log', '[[regtime]]', '[[regtime]]'),
(37, 1, 1, 'english', 'button_close', 'Close', '[[regtime]]', '[[regtime]]'),
(38, 1, 1, 'english', 'button_upgrade', 'Upgrade', '[[regtime]]', '[[regtime]]'),
(39, 1, 1, 'english', 'button_filter', 'Filter', '[[regtime]]', '[[regtime]]'),
(40, 1, 1, 'english', 'button_send', 'Send', '[[regtime]]', '[[regtime]]'),
(41, 1, 1, 'english', 'button_edit', 'Edit', '[[regtime]]', '[[regtime]]'),
(42, 1, 1, 'english', 'button_copy', 'Copy', '[[regtime]]', '[[regtime]]'),
(43, 1, 1, 'english', 'button_agree', 'Agree', '[[regtime]]', '[[regtime]]'),
(44, 1, 1, 'english', 'button_back', 'Back', '[[regtime]]', '[[regtime]]'),
(45, 1, 1, 'english', 'button_continue', 'Continue', '[[regtime]]', '[[regtime]]'),
(46, 1, 1, 'english', 'button_remove', 'Remove', '[[regtime]]', '[[regtime]]'),
(47, 1, 1, 'english', 'button_backup', 'Backup', '[[regtime]]', '[[regtime]]'),
(48, 1, 1, 'english', 'button_restore', 'Restore', '[[regtime]]', '[[regtime]]'),
(49, 1, 1, 'english', 'button_invoice', 'Print Invoice', '[[regtime]]', '[[regtime]]'),
(50, 1, 1, 'english', 'button_invoices', 'Print Invoices', '[[regtime]]', '[[regtime]]'),
(51, 1, 1, 'english', 'button_add_option', 'Add Option', '[[regtime]]', '[[regtime]]'),
(52, 1, 1, 'english', 'button_add_option_value', 'Add Option Value', '[[regtime]]', '[[regtime]]'),
(53, 1, 1, 'english', 'button_add_discount', 'Add Discount', '[[regtime]]', '[[regtime]]'),
(54, 1, 1, 'english', 'button_add_special', 'Add Special', '[[regtime]]', '[[regtime]]'),
(55, 1, 1, 'english', 'button_add_image', 'Add Image', '[[regtime]]', '[[regtime]]'),
(56, 1, 1, 'english', 'button_add_location_zone', 'Add Location Zone', '[[regtime]]', '[[regtime]]'),
(57, 1, 1, 'english', 'button_add_rate', 'Add Tax Rate', '[[regtime]]', '[[regtime]]'),
(58, 1, 1, 'english', 'button_add_history', 'Add Order History', '[[regtime]]', '[[regtime]]'),
(59, 1, 1, 'english', 'button_actas', 'Act on behalf of', '[[regtime]]', '[[regtime]]'),
(60, 1, 1, 'english', 'button_message', 'Contact this customer', '[[regtime]]', '[[regtime]]'),
(61, 1, 1, 'english', 'button_approve', 'Approve', '[[regtime]]', '[[regtime]]'),
(62, 1, 1, 'english', 'button_generate', 'Generate', '[[regtime]]', '[[regtime]]'),
(63, 1, 1, 'english', 'tab_admin', 'Admin', '[[regtime]]', '[[regtime]]'),
(64, 1, 1, 'english', 'tab_data', 'Data', '[[regtime]]', '[[regtime]]'),
(65, 1, 1, 'english', 'tab_discount', 'Discounts', '[[regtime]]', '[[regtime]]'),
(66, 1, 1, 'english', 'tab_details', 'Store Details', '[[regtime]]', '[[regtime]]'),
(67, 1, 1, 'english', 'tab_checkout', 'Checkout', '[[regtime]]', '[[regtime]]'),
(68, 1, 1, 'english', 'tab_appearance', 'Appearance', '[[regtime]]', '[[regtime]]'),
(69, 1, 1, 'english', 'tab_im', 'IM', '[[regtime]]', '[[regtime]]'),
(70, 1, 1, 'english', 'tab_api', 'API', '[[regtime]]', '[[regtime]]'),
(71, 1, 1, 'english', 'tab_general', 'General', '[[regtime]]', '[[regtime]]'),
(72, 1, 1, 'english', 'tab_image', 'Additional Images', '[[regtime]]', '[[regtime]]'),
(73, 1, 1, 'english', 'tab_option', 'Options', '[[regtime]]', '[[regtime]]'),
(74, 1, 1, 'english', 'tab_system', 'System', '[[regtime]]', '[[regtime]]'),
(75, 1, 1, 'english', 'tab_store', 'Store', '[[regtime]]', '[[regtime]]'),
(76, 1, 1, 'english', 'tab_special', 'Specials', '[[regtime]]', '[[regtime]]'),
(77, 1, 1, 'english', 'tab_local', 'Local', '[[regtime]]', '[[regtime]]'),
(78, 1, 1, 'english', 'tab_mail', 'Mail', '[[regtime]]', '[[regtime]]'),
(79, 1, 1, 'english', 'tab_order', 'Order Details', '[[regtime]]', '[[regtime]]'),
(80, 1, 1, 'english', 'tab_history', 'Order History', '[[regtime]]', '[[regtime]]'),
(81, 1, 1, 'english', 'tab_product', 'Products', '[[regtime]]', '[[regtime]]'),
(82, 1, 1, 'english', 'tab_shipping', 'Shipping Address', '[[regtime]]', '[[regtime]]'),
(83, 1, 1, 'english', 'tab_payment', 'Payment Address', '[[regtime]]', '[[regtime]]'),
(84, 1, 1, 'english', 'entry_discount', 'Discount', '[[regtime]]', '[[regtime]]'),
(85, 1, 1, 'english', 'entry_special', 'Special', '[[regtime]]', '[[regtime]]'),
(86, 1, 1, 'english', 'error_upload_1', 'Warning: The uploaded file exceeds the upload_max_filesize directive in php.ini!', '[[regtime]]', '[[regtime]]'),
(87, 1, 1, 'english', 'error_upload_2', 'Warning: The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form!', '[[regtime]]', '[[regtime]]'),
(88, 1, 1, 'english', 'error_upload_3', 'Warning: The uploaded file was only partially uploaded!', '[[regtime]]', '[[regtime]]'),
(89, 1, 1, 'english', 'error_upload_4', 'Warning: No file was uploaded!', '[[regtime]]', '[[regtime]]'),
(90, 1, 1, 'english', 'error_upload_6', 'Warning: Missing a temporary folder!', '[[regtime]]', '[[regtime]]'),
(91, 1, 1, 'english', 'error_upload_7', 'Warning: Failed to write file to disk!', '[[regtime]]', '[[regtime]]'),
(92, 1, 1, 'english', 'error_upload_8', 'Warning: File upload stopped by extension!', '[[regtime]]', '[[regtime]]'),
(93, 1, 1, 'english', 'error_upload_999', 'Warning: No error code available!', '[[regtime]]', '[[regtime]]'),
(94, 1, 1, 'english', 'text_choose_action', 'choose action..', '[[regtime]]', '[[regtime]]'),
(95, 1, 1, 'english', 'text_delete', 'Delete', '[[regtime]]', '[[regtime]]'),
(96, 1, 1, 'english', 'text_delete_selected', 'delete selected', '[[regtime]]', '[[regtime]]'),
(97, 1, 1, 'english', 'text_save_selected', 'Save Selected', '[[regtime]]', '[[regtime]]'),
(98, 1, 1, 'english', 'text_save_all', 'save all', '[[regtime]]', '[[regtime]]'),
(99, 1, 1, 'english', 'text_select_status', '- Select Status -', '[[regtime]]', '[[regtime]]'),
(100, 1, 1, 'english', 'text_all_orders', 'All Orders', '[[regtime]]', '[[regtime]]'),
(101, 1, 1, 'english', 'text_confirm_password', 'confirm password', '[[regtime]]', '[[regtime]]'),
(102, 1, 1, 'english', 'text_insert', 'Insert ', '[[regtime]]', '[[regtime]]'),
(103, 1, 1, 'english', 'text_select_items', 'Please Select Items', '[[regtime]]', '[[regtime]]'),
(104, 1, 1, 'english', 'button_go', 'GO', '[[regtime]]', '[[regtime]]'),
(105, 1, 1, 'english', 'search_everywhere', 'Search Entire Site', '[[regtime]]', '[[regtime]]'),
(106, 1, 1, 'english', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(107, 1, 1, 'english', 'error_permission_access', 'Warning: You do not have permission to access %s!', '[[regtime]]', '[[regtime]]'),
(108, 1, 1, 'english', 'error_permission_modify', 'Warning: You do not have permission to modify %s!', '[[regtime]]', '[[regtime]]'),
(109, 1, 1, 'english', 'text_add', 'Add', '[[regtime]]', '[[regtime]]'),
(110, 1, 1, 'english', 'text_add_block', 'Add Block', '[[regtime]]', '[[regtime]]'),
(111, 1, 1, 'english', 'text_resource_library', 'Resource Library', '[[regtime]]', '[[regtime]]'),
(112, 1, 1, 'english', 'text_add_media', 'Add Media', '[[regtime]]', '[[regtime]]'),
(113, 1, 1, 'english', 'confirm_unmap_title', 'Confirm resource(s) Unlink', '[[regtime]]', '[[regtime]]'),
(114, 1, 1, 'english', 'text_confirm_unmap', 'Are you sure you want to unlink resource(s)?', '[[regtime]]', '[[regtime]]'),
(115, 1, 1, 'english', 'confirm_del_title', 'Confirm resource(s) Delete', '[[regtime]]', '[[regtime]]'),
(116, 1, 1, 'english', 'text_confirm_del', 'Are you sure you want to delete resource(s)?', '[[regtime]]', '[[regtime]]'),
(117, 1, 1, 'english', 'text_type_image', 'Images', '[[regtime]]', '[[regtime]]'),
(118, 1, 1, 'english', 'text_type_audio', 'Audio', '[[regtime]]', '[[regtime]]'),
(119, 1, 1, 'english', 'text_type_video', 'Video', '[[regtime]]', '[[regtime]]'),
(120, 1, 1, 'english', 'text_type_pdf', 'PDF Document', '[[regtime]]', '[[regtime]]'),
(121, 1, 1, 'english', 'text_type_archive', 'Archive', '[[regtime]]', '[[regtime]]'),
(122, 1, 1, 'english', 'text_type_download', 'Download File', '[[regtime]]', '[[regtime]]'),
(123, 1, 1, 'english', 'button_unmap', 'Unlink', '[[regtime]]', '[[regtime]]'),
(124, 1, 1, 'english', 'button_select_resource', 'select', '[[regtime]]', '[[regtime]]'),
(125, 1, 1, 'english', 'text_click_to_change', 'Click image to change it', '[[regtime]]', '[[regtime]]'),
(126, 1, 1, 'english', 'text_select_from_list', 'Select from the list', '[[regtime]]', '[[regtime]]'),
(127, 1, 1, 'english', 'text_count_selected', 'Count of selected items:', '[[regtime]]', '[[regtime]]'),
(128, 1, 1, 'english', 'text_delete_confirm', 'Please, confirm delete', '[[regtime]]', '[[regtime]]'),
(129, 1, 1, 'english', 'text_save_edit', 'Add/Edit', '[[regtime]]', '[[regtime]]'),
(130, 1, 1, 'english', 'text_apply', 'Apply', '[[regtime]]', '[[regtime]]'),
(131, 1, 1, 'english', 'text_on_top', 'back on top', '[[regtime]]', '[[regtime]]'),
(132, 1, 1, 'english', 'text_all', 'All', '[[regtime]]', '[[regtime]]'),
(133, 1, 1, 'english', 'text_all_stores', 'All Stores', '[[regtime]]', '[[regtime]]'),
(134, 1, 1, 'english', 'text_create_new_block', ' Create New Block ', '[[regtime]]', '[[regtime]]'),
(135, 1, 1, 'english', 'button_unlink', 'Unlink', '[[regtime]]', '[[regtime]]'),
(136, 1, 1, 'english', 'text_confirm_unlink', 'Are you sure you want to unlink resource?', '[[regtime]]', '[[regtime]]'),
(137, 1, 1, 'english', 'confirm_unlink_title', 'Confirm resource Unlink', '[[regtime]]', '[[regtime]]'),
(138, 1, 1, 'english', 'text_select_store', 'Select a different store', '[[regtime]]', '[[regtime]]'),
(139, 1, 1, 'english', 'text_click_browse_file', 'Click to browse file', '[[regtime]]', '[[regtime]]'),
(140, 1, 1, 'english', 'text_browse', 'Browse', '[[regtime]]', '[[regtime]]'),
(141, 1, 1, 'english', 'text_or', 'or', '[[regtime]]', '[[regtime]]'),
(142, 1, 1, 'english', 'error_seo_keyword', 'SEO keyword <a target="_blank" href="%s">"%s"</a> is already exists!', '[[regtime]]', '[[regtime]]'),
(143, 1, 1, 'english', 'column_update_date', 'Update Date', '[[regtime]]', '[[regtime]]'),
(144, 1, 1, 'english', 'text_automatic', 'Automatic', '[[regtime]]', '[[regtime]]'),
(145, 1, 1, 'english', 'text_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(146, 1, 1, 'english', 'text_select_copy_layout', 'Select to copy layout from', '[[regtime]]', '[[regtime]]'),
(147, 1, 1, 'english', 'text_apply_layout', 'Apply Now', '[[regtime]]', '[[regtime]]'),
(148, 1, 1, 'english', 'text_new_download', 'New Download', '[[regtime]]', '[[regtime]]'),
(149, 1, 1, 'english', 'text_free', 'Free', '[[regtime]]', '[[regtime]]'),
(150, 1, 1, 'english', 'text_sure', 'Are you sure?', '[[regtime]]', '[[regtime]]'),
(151, 1, 1, 'english', 'button_add', 'Add', '[[regtime]]', '[[regtime]]'),
(152, 1, 1, 'english', 'text_please_confirm', 'Please Confirm', '[[regtime]]', '[[regtime]]'),
(153, 1, 1, 'english', 'button_confirm', 'Confirm', '[[regtime]]', '[[regtime]]'),
(154, 1, 1, 'english', 'button_download', 'Download', '[[regtime]]', '[[regtime]]'),
(155, 1, 1, 'english', 'recent_customers', 'Recently Registered Customers', '[[regtime]]', '[[regtime]]'),
(156, 1, 1, 'english', 'new_orders', 'New Orders', '[[regtime]]', '[[regtime]]'),
(157, 1, 1, 'english', 'text_saved', 'Saved Successfully', '[[regtime]]', '[[regtime]]'),
(158, 1, 1, 'english', 'text_processing', 'Processing ...', '[[regtime]]', '[[regtime]]'),
(159, 1, 1, 'english', 'text_next', 'Next', '[[regtime]]', '[[regtime]]'),
(160, 1, 1, 'english', 'text_previous', 'Previous', '[[regtime]]', '[[regtime]]'),
(161, 1, 1, 'english', 'text_on', 'ON', '[[regtime]]', '[[regtime]]'),
(162, 1, 1, 'english', 'text_off', 'OFF', '[[regtime]]', '[[regtime]]'),
(163, 1, 1, 'english', 'text_external_help', 'External Help', '[[regtime]]', '[[regtime]]'),
(164, 1, 1, 'english', 'text_select_from_lookup', 'Start typing (name, model, sku, etc.) to look up and select result', '[[regtime]]', '[[regtime]]'),
(165, 1, 1, 'english', 'text_continue_typing', 'Continue typing ...', '[[regtime]]', '[[regtime]]'),
(166, 1, 1, 'english', 'text_looking_for', 'Looking for', '[[regtime]]', '[[regtime]]'),
(167, 1, 1, 'english', 'button_manage_extensions', 'Manage Extensions', '[[regtime]]', '[[regtime]]'),
(168, 1, 1, 'english', 'text_abc_notification', 'Software Updates & Notifications', '[[regtime]]', '[[regtime]]'),
(169, 1, 1, 'english', 'text_not_applicable', 'NA', '[[regtime]]', '[[regtime]]'),
(170, 1, 1, 'english', 'text_share_embed_code', 'Get Embed Code', '[[regtime]]', '[[regtime]]'),
(171, 1, 1, 'english', 'text_copy_embed_code', 'Сopy and paste this into your HTML-code where you''d like to sell', '[[regtime]]', '[[regtime]]'),
(172, 1, 1, 'english', 'text_copy_embed_url', 'Сopy and paste this URL into your another site where you''d like to sell', '[[regtime]]', '[[regtime]]'),
(173, 1, 1, 'english', 'button_retry', 'Retry', '[[regtime]]', '[[regtime]]'),
(174, 1, 1, 'english', 'text_system_error', 'System error has been encountered. Check system <a target="_blank" href="%s">messages</a> or <a target="_blank" href="%s">error log</a>', '[[regtime]]', '[[regtime]]'),
(175, 1, 1, 'english', 'text_system_warning', 'System warning has been reported. Check system <a target="_blank" href="%s">messages</a>', '[[regtime]]', '[[regtime]]'),
(176, 1, 1, 'english', 'text_system_notice', 'System notice has been reported. Check system <a target="_blank" href="%s">messages</a>', '[[regtime]]', '[[regtime]]'),
(177, 1, 1, 'english', 'text_set_related', 'Set Related', '[[regtime]]', '[[regtime]]'),
(178, 1, 1, 'english', 'tab_text', 'HTML/Text', '[[regtime]]', '[[regtime]]'),
(179, 1, 1, 'english', 'tab_visual', 'Visual', '[[regtime]]', '[[regtime]]'),
(180, 1, 1, 'english', 'button_add_media', 'Add Media', '[[regtime]]', '[[regtime]]'),
(181, 1, 1, 'english', 'button_field_history', 'View Field History', '[[regtime]]', '[[regtime]]'),
(182, 1, 1, 'english', 'text_view_more', 'View More', '[[regtime]]', '[[regtime]]'),
(183, 1, 1, 'english', 'text_admin', 'Control Panel', '[[regtime]]', '[[regtime]]'),
(184, 1, 1, 'english', 'text_storefront', 'Storefront', '[[regtime]]', '[[regtime]]'),
(185, 1, 1, 'english', 'text_texteditor_extended_mode', '<a class="texteditor_ext_mode" href="%s" ><i class="fa fa-external-link"></i> Edit in Extended Mode</a>', '[[regtime]]', '[[regtime]]'),
(186, 1, 1, 'english', 'text_quick_view', 'Quick View', '[[regtime]]', '[[regtime]]'),
(187, 1, 1, 'english', 'text_more_current', 'Full page edit', '[[regtime]]', '[[regtime]]'),
(188, 1, 1, 'english', 'text_more_new', 'New tab edit', '[[regtime]]', '[[regtime]]'),
(189, 1, 1, 'english', 'text_back_to_list', 'Back to listing', '[[regtime]]', '[[regtime]]'),
(190, 1, 1, 'english', 'text_help_link', '<a href="http://www.abantecart.com/contact-us" target="_abantecart">Need help?</a>', '[[regtime]]', '[[regtime]]'),
(191, 1, 1, 'english', 'text_subtract_order', 'Subtract Order', '[[regtime]]', '[[regtime]]'),
(192, 1, 1, 'english', 'button_preview', 'Preview', '[[regtime]]', '[[regtime]]'),
(193, 1, 1, 'english', 'warning_extensions_with_layouts', ' Following extensions <br> %s <br> includes pages or layouts that are not present in the selected template. To include features from these extensions you will need to reinstall extensions after you enable new template. If reinstallation does not help, contact original developers of the above extensions for help.  ', '[[regtime]]', '[[regtime]]'),
(194, 1, 1, 'english', 'column_sku', 'SKU', '[[regtime]]', '[[regtime]]'),
(195, 1, 1, 'english', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(196, 1, 1, 'english', 'text_data_history', 'Data Change History', '[[regtime]]', '[[regtime]]'),
(197, 1, 1, 'english', 'text_design', 'Design', '[[regtime]]', '[[regtime]]'),
(198, 1, 1, 'english', 'text_select_brand', '-Select Brand-', '[[regtime]]', '[[regtime]]'),
(199, 1, 1, 'english', 'text_advanced_settings', 'Advanced', '[[regtime]]', '[[regtime]]'),
(200, 1, 1, 'banner_manager_banner_manager', 'banner_manager_name', 'Banner Manager', '[[regtime]]', '[[regtime]]'),
(201, 1, 1, 'banner_manager_banner_manager', 'banner_manager_note', 'To manage banners follow menu <b>Design -> Banner Mannger</b> after extension is enabled <br>\n		To see banner statistic follow <b>Reports -> Banner Statistic</b> after extension is enabled and banners created', '[[regtime]]', '[[regtime]]'),
(202, 1, 1, 'banner_manager_banner_manager', 'banner_manager_list', 'Banner List', '[[regtime]]', '[[regtime]]'),
(203, 1, 1, 'banner_manager_banner_manager', 'banner_manager_name_stat', 'Banner Statistic', '[[regtime]]', '[[regtime]]'),
(204, 1, 1, 'banner_manager_banner_manager', 'column_banner_id', ' Id ', '[[regtime]]', '[[regtime]]'),
(205, 1, 1, 'banner_manager_banner_manager', 'column_banner_name', ' Name ', '[[regtime]]', '[[regtime]]'),
(206, 1, 1, 'banner_manager_banner_manager', 'column_banner_group', ' Group ', '[[regtime]]', '[[regtime]]'),
(207, 1, 1, 'banner_manager_banner_manager', 'column_banner_type', ' Type ', '[[regtime]]', '[[regtime]]'),
(208, 1, 1, 'banner_manager_banner_manager', 'column_status', ' Status ', '[[regtime]]', '[[regtime]]'),
(209, 1, 1, 'banner_manager_banner_manager', 'column_update_date', ' Update Date ', '[[regtime]]', '[[regtime]]'),
(210, 1, 1, 'banner_manager_banner_manager', 'column_clicked', ' Clicks ', '[[regtime]]', '[[regtime]]'),
(211, 1, 1, 'banner_manager_banner_manager', 'column_viewed', ' Viewed ', '[[regtime]]', '[[regtime]]'),
(212, 1, 1, 'banner_manager_banner_manager', 'column_percent', ' Conversion ', '[[regtime]]', '[[regtime]]'),
(213, 1, 1, 'banner_manager_banner_manager', 'text_create', ' Create New Banner ', '[[regtime]]', '[[regtime]]'),
(214, 1, 1, 'banner_manager_banner_manager', 'text_graphic_banner', ' Graphic Banner ', '[[regtime]]', '[[regtime]]'),
(215, 1, 1, 'banner_manager_banner_manager', 'text_text_banner', ' Text Banner ', '[[regtime]]', '[[regtime]]'),
(216, 1, 1, 'banner_manager_banner_manager', 'entry_banner_name', ' Name: ', '[[regtime]]', '[[regtime]]'),
(217, 1, 1, 'banner_manager_banner_manager', 'entry_banner_status', ' Status: ', '[[regtime]]', '[[regtime]]'),
(218, 1, 1, 'banner_manager_banner_manager', 'entry_banner_group_name', ' Banner Group Name: ', '[[regtime]]', '[[regtime]]'),
(219, 1, 1, 'banner_manager_banner_manager', 'entry_banner_description', ' Description: ', '[[regtime]]', '[[regtime]]'),
(220, 1, 1, 'banner_manager_banner_manager', 'entry_banner_html', ' Banner HTML-code: ', '[[regtime]]', '[[regtime]]'),
(221, 1, 1, 'banner_manager_banner_manager', 'entry_banner_meta', ' Meta information: <span class="help">SEO keywords etc</span> ', '[[regtime]]', '[[regtime]]'),
(222, 1, 1, 'banner_manager_banner_manager', 'entry_banner_url', ' URL: ', '[[regtime]]', '[[regtime]]'),
(223, 1, 1, 'banner_manager_banner_manager', 'entry_banner_blank', ' Open in New Window: ', '[[regtime]]', '[[regtime]]'),
(224, 1, 1, 'banner_manager_banner_manager', 'entry_banner_sort_order', ' Sort Order in Group: ', '[[regtime]]', '[[regtime]]'),
(225, 1, 1, 'banner_manager_banner_manager', 'entry_banner_date_start', ' Date Start: ', '[[regtime]]', '[[regtime]]'),
(226, 1, 1, 'banner_manager_banner_manager', 'entry_banner_date_end', ' Date End: ', '[[regtime]]', '[[regtime]]'),
(227, 1, 1, 'banner_manager_banner_manager', 'text_add_new_group', ' -- Add New Group -- ', '[[regtime]]', '[[regtime]]'),
(228, 1, 1, 'banner_manager_banner_manager', 'text_put_new_group', ' Put New Group Name Here ', '[[regtime]]', '[[regtime]]'),
(229, 1, 1, 'banner_manager_banner_manager', 'error_empty', ' Error: Please Fill All Required Fields of Form. ', '[[regtime]]', '[[regtime]]'),
(230, 1, 1, 'banner_manager_banner_manager', 'text_banner_success', ' Success : You have modified banner. ', '[[regtime]]', '[[regtime]]'),
(231, 1, 1, 'banner_manager_banner_manager', 'text_view_stat', ' View Statistic ', '[[regtime]]', '[[regtime]]'),
(232, 1, 1, 'banner_manager_banner_manager', 'text_banner_block', ' Banner Block ', '[[regtime]]', '[[regtime]]'),
(233, 1, 1, 'banner_manager_banner_manager', 'text_create_block', ' Create Banner Block ', '[[regtime]]', '[[regtime]]'),
(234, 1, 1, 'banner_manager_banner_manager', 'text_banner', ' Banner ', '[[regtime]]', '[[regtime]]'),
(235, 1, 1, 'banner_manager_banner_manager', 'entry_banners_selected', ' Selected banners: ', '[[regtime]]', '[[regtime]]'),
(236, 1, 1, 'banner_manager_banner_manager', 'text_select_banners', ' Select banners ', '[[regtime]]', '[[regtime]]'),
(237, 1, 1, 'banner_manager_banner_manager', 'text_hours', ' hours ', '[[regtime]]', '[[regtime]]'),
(238, 1, 1, 'banner_manager_banner_manager', 'text_weeks', ' week days ', '[[regtime]]', '[[regtime]]'),
(239, 1, 1, 'banner_manager_banner_manager', 'text_days', ' days ', '[[regtime]]', '[[regtime]]'),
(240, 1, 1, 'banner_manager_banner_manager', 'text_months', ' months ', '[[regtime]]', '[[regtime]]'),
(241, 1, 1, 'banner_manager_banner_manager', 'text_count', ' count ', '[[regtime]]', '[[regtime]]'),
(242, 1, 1, 'banner_manager_banner_manager', 'text_banners', ' Banners ', '[[regtime]]', '[[regtime]]'),
(243, 1, 1, 'banner_manager_banner_manager', 'text_delete_statistic', ' Delete Statistic ', '[[regtime]]', '[[regtime]]'),
(244, 1, 1, 'banner_manager_banner_manager', 'text_delete_success', ' Statistic have been successfully deleted! ', '[[regtime]]', '[[regtime]]'),
(245, 1, 1, 'forms_manager_forms_manager', 'forms_manager_name', 'Forms Manager', '[[regtime]]', '[[regtime]]'),
(246, 1, 1, 'forms_manager_forms_manager', 'forms_manager_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(247, 1, 1, 'forms_manager_forms_manager', 'forms_manager_note', 'To manage forms please enable extension and follow Design-><a href="#admin#rt=tool/forms_manager">Forms Manager</a>', '[[regtime]]', '[[regtime]]'),
(248, 1, 1, 'forms_manager_forms_manager', 'custom_forms_block', 'Custom Forms Block', '[[regtime]]', '[[regtime]]'),
(249, 1, 1, 'forms_manager_forms_manager', 'entry_form_name', 'Form Name<br/><span class="help">Latin letters, underscore, minus only</span>', '[[regtime]]', '[[regtime]]'),
(250, 1, 1, 'forms_manager_forms_manager', 'entry_controller_path', 'Processing Controller', '[[regtime]]', '[[regtime]]'),
(251, 1, 1, 'forms_manager_forms_manager', 'entry_success_page', 'Success page<br/><span class="help">Leave it empty if you want to redirect to the same page as controller</span>', '[[regtime]]', '[[regtime]]'),
(252, 1, 1, 'forms_manager_forms_manager', 'entry_form_description', 'Description', '[[regtime]]', '[[regtime]]'),
(253, 1, 1, 'forms_manager_forms_manager', 'text_default_email', 'Default Email', '[[regtime]]', '[[regtime]]'),
(254, 1, 1, 'forms_manager_forms_manager', 'text_contactus_page', 'Contact Us Page', '[[regtime]]', '[[regtime]]'),
(255, 1, 1, 'forms_manager_forms_manager', 'text_form', 'Form', '[[regtime]]', '[[regtime]]'),
(256, 1, 1, 'forms_manager_forms_manager', 'column_name', 'Name', '[[regtime]]', '[[regtime]]'),
(257, 1, 1, 'forms_manager_forms_manager', 'column_description', 'Description', '[[regtime]]', '[[regtime]]'),
(258, 1, 1, 'forms_manager_forms_manager', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(259, 1, 1, 'forms_manager_forms_manager', 'filter_exact_match', 'The exact phrase', '[[regtime]]', '[[regtime]]'),
(260, 1, 1, 'forms_manager_forms_manager', 'filter_any_word', 'Any of these words', '[[regtime]]', '[[regtime]]'),
(261, 1, 1, 'forms_manager_forms_manager', 'filter_all_words', 'All of these words', '[[regtime]]', '[[regtime]]'),
(262, 1, 1, 'forms_manager_forms_manager', 'text_clone', 'Clone', '[[regtime]]', '[[regtime]]'),
(263, 1, 1, 'forms_manager_forms_manager', 'filter_form', 'Search for form', '[[regtime]]', '[[regtime]]'),
(264, 1, 1, 'forms_manager_forms_manager', 'text_add_new_field', '-- Add new field --', '[[regtime]]', '[[regtime]]'),
(265, 1, 1, 'forms_manager_forms_manager', 'button_add_field', 'Add Field', '[[regtime]]', '[[regtime]]'),
(266, 1, 1, 'forms_manager_forms_manager', 'button_reset', 'Reset', '[[regtime]]', '[[regtime]]'),
(267, 1, 1, 'forms_manager_forms_manager', 'text_field_type', 'Field type:', '[[regtime]]', '[[regtime]]'),
(268, 1, 1, 'forms_manager_forms_manager', 'button_remove_field', 'Remove field', '[[regtime]]', '[[regtime]]'),
(269, 1, 1, 'forms_manager_forms_manager', 'entry_field', 'Field', '[[regtime]]', '[[regtime]]'),
(270, 1, 1, 'forms_manager_forms_manager', 'entry_field_name', 'Field name (latin letters, underscore, minus only)', '[[regtime]]', '[[regtime]]'),
(271, 1, 1, 'forms_manager_forms_manager', 'entry_sort_order', 'Sort order', '[[regtime]]', '[[regtime]]'),
(272, 1, 1, 'forms_manager_forms_manager', 'entry_required', 'Required', '[[regtime]]', '[[regtime]]'),
(273, 1, 1, 'forms_manager_forms_manager', 'entry_edit_fields', 'Edit Fields', '[[regtime]]', '[[regtime]]'),
(274, 1, 1, 'forms_manager_forms_manager', 'entry_field_value', 'Field value', '[[regtime]]', '[[regtime]]'),
(275, 1, 1, 'forms_manager_forms_manager', 'error_required', 'This field is required!', '[[regtime]]', '[[regtime]]'),
(276, 1, 1, 'forms_manager_forms_manager', 'error_duplicate_form_name', 'There is already Form with such Name attribute.', '[[regtime]]', '[[regtime]]'),
(277, 1, 1, 'forms_manager_forms_manager', 'error_duplicate_field_name', 'There is already Field with such Name in the current Form.', '[[regtime]]', '[[regtime]]'),
(278, 1, 1, 'forms_manager_forms_manager', 'text_field_removed', 'The field has been successfully removed.', '[[regtime]]', '[[regtime]]'),
(279, 1, 1, 'forms_manager_forms_manager', 'text_success_form', 'The form has been successfully updated.', '[[regtime]]', '[[regtime]]'),
(280, 1, 1, 'forms_manager_forms_manager', 'text_success_field', 'The field has been successfully updated.', '[[regtime]]', '[[regtime]]'),
(281, 1, 1, 'forms_manager_forms_manager', 'text_success_added_form', 'The new Form has been successfully added.', '[[regtime]]', '[[regtime]]'),
(282, 1, 1, 'forms_manager_forms_manager', 'text_success_added_field', 'The new field has been successfully added.', '[[regtime]]', '[[regtime]]'),
(283, 1, 1, 'forms_manager_forms_manager', 'text_add_field', 'Add new field', '[[regtime]]', '[[regtime]]'),
(284, 1, 1, 'forms_manager_forms_manager', 'entry_field_description', 'Display name', '[[regtime]]', '[[regtime]]'),
(285, 1, 1, 'forms_manager_forms_manager', 'entry_add_new_form', 'Add New Form', '[[regtime]]', '[[regtime]]'),
(286, 1, 1, 'forms_manager_forms_manager', 'text_create_block', 'Create Form Block', '[[regtime]]', '[[regtime]]'),
(287, 1, 1, 'forms_manager_forms_manager', 'entry_no_set_values', 'You can''t set values for this field type.', '[[regtime]]', '[[regtime]]'),
(288, 1, 1, 'forms_manager_forms_manager', 'text_field_values', 'Field Values', '[[regtime]]', '[[regtime]]'),
(289, 1, 1, 'forms_manager_forms_manager', 'note_create_form_block', 'NOTE: To see this form shown on storefront, create form block at Design-><a href="%s">Blocks</a> and add it to appropriate page at Design-><a href="%s">Layouts</a> page.', '[[regtime]]', '[[regtime]]'),
(290, 1, 1, 'forms_manager_forms_manager', 'note_edit_layout', 'NOTE: To see this block shown on storefront, add it to appropriate page	at Design-><a href="%s">Layouts</a>. To create new form go to Design-><a href="%s">Form Manager</a> page.', '[[regtime]]', '[[regtime]]'),
(291, 1, 1, 'forms_manager_forms_manager', 'text_select_field_type', '--- Please select ---', '[[regtime]]', '[[regtime]]'),
(292, 1, 1, 'forms_manager_forms_manager', 'entry_field_note', 'Field note', '[[regtime]]', '[[regtime]]'),
(293, 1, 1, 'forms_manager_forms_manager', 'forms_manager_default_sender_name', 'Default Sender:', '[[regtime]]', '[[regtime]]'),
(294, 1, 1, 'forms_manager_forms_manager', 'forms_manager_default_sender_email', 'Default Sender Email:', '[[regtime]]', '[[regtime]]'),
(295, 1, 1, 'forms_manager_forms_manager', 'entry_field_placeholder', 'Placeholder:', '[[regtime]]', '[[regtime]]'),
(296, 1, 1, 'forms_manager_forms_manager', 'entry_regexp_pattern', 'Regular Expression Pattern:', '[[regtime]]', '[[regtime]]'),
(297, 1, 1, 'forms_manager_forms_manager', 'entry_error_text', 'Error Message about invalid Value:', '[[regtime]]', '[[regtime]]'),
(298, 1, 1, 'forms_manager_forms_manager', 'entry_form', 'Form', '[[regtime]]', '[[regtime]]'),
(299, 1, 1, 'forms_manager_forms_manager', 'error_fill_required', 'Please fill all required fields of form!', '[[regtime]]', '[[regtime]]'),
(300, 1, 1, 'forms_manager_forms_manager', 'error_form_name', 'Name of form cannot be empty!', '[[regtime]]', '[[regtime]]'),
(301, 1, 1, 'forms_manager_forms_manager', 'error_form_description', 'Description of form cannot be empty!', '[[regtime]]', '[[regtime]]'),
(302, 1, 1, 'forms_manager_forms_manager', 'error_field_name_exists', 'Field With Name %s already present in the Form!', '[[regtime]]', '[[regtime]]'),
(303, 1, 1, 'forms_manager_forms_manager', 'forms_manager_error_empty_sender', 'Warning! Please set default sender name and default sender email in <a href="#admin#rt=extension/extensions/edit&extension=forms_manager" target="_blank">forms manager settings</a>', '[[regtime]]', '[[regtime]]'),
(304, 1, 1, '2checkout_2checkout', '2checkout_name', '2Checkout', '[[regtime]]', '[[regtime]]'),
(305, 1, 1, '2checkout_2checkout', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(306, 1, 1, '2checkout_2checkout', 'text_success', 'Success: You have modified 2Checkout account details!', '[[regtime]]', '[[regtime]]'),
(307, 1, 1, '2checkout_2checkout', '2checkout_note', 'With this extension you can use 2Checkout payment system to accept payments from your customers.<br>\n<b>Sign up free today!  Use promo code ABANTECART2CO for a waiver of your application service fee (a savings of $10.99) and start selling online today! </b> Visit <a href="https://www.2checkout.com/signup/">www.2checkout.com</a>, complete the application, and then enter the code into the promo code field to take advantage of this special offer today!\n<br> Once register login to get account credentials to configure this extension\n<br>Don''t forget to setup INS URL and Redirect URL here <a href="https://secure.2checkout.com/cpanel/webhooks_api.php">https://secure.2checkout.com/cpanel/webhooks_api.php</a>.\n<br><br>Your INS URL is <h4>#storefront#rt=extension/2checkout/callback</h4>\n<br><br>Also setup the Redirect URL and choose Return method "Header redirect".\n<br><br>Your Redirect URL is <h4>#storefront#rt=checkout/success</h4>\n		 ', '[[regtime]]', '[[regtime]]'),
(308, 1, 1, '2checkout_2checkout', '2checkout_account', '2Checkout Merchant Code:', '[[regtime]]', '[[regtime]]'),
(309, 1, 1, '2checkout_2checkout', '2checkout_secret', 'Secret Key:<br /><span class="help">The secret word to confirm transactions with (must be the same as defined on the merchant account configuration page.</span>', '[[regtime]]', '[[regtime]]'),
(310, 1, 1, '2checkout_2checkout', '2checkout_test', 'Test Mode:', '[[regtime]]', '[[regtime]]'),
(311, 1, 1, '2checkout_2checkout', '2checkout_test_1', 'Yes', '[[regtime]]', '[[regtime]]'),
(312, 1, 1, '2checkout_2checkout', '2checkout_test_0', 'No', '[[regtime]]', '[[regtime]]'),
(313, 1, 1, '2checkout_2checkout', '2checkout_order_status_id', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(314, 1, 1, '2checkout_2checkout', '2checkout_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(315, 1, 1, '2checkout_2checkout', '2checkout_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(316, 1, 1, '2checkout_2checkout', 'error_permission', 'Warning: You do not have permission to modify payment 2Checkout!', '[[regtime]]', '[[regtime]]'),
(317, 1, 1, '2checkout_2checkout', 'error_account', 'Merchant Code Required!', '[[regtime]]', '[[regtime]]'),
(318, 1, 1, '2checkout_2checkout', 'error_secret', 'Secret Key Required!', '[[regtime]]', '[[regtime]]'),
(319, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_name', 'Avatax integration', '[[regtime]]', '[[regtime]]'),
(320, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_note', 'If you have standard tax enabled, it will function together with Avatax and you might need to disable standard taxes. Check System -> Localization -> <a target="_new" href="#admin#rt=localisation/tax_class">Tax Class</a><br>Also don''t forget to enable extension <a href="#admin#rt=total/avatax_integration_total">Avatax Integration Total</a><br>Important! Avatax Integration Total calculation order in extension totals must be after subtotal. Subtotal calculation should precede this extension total calculation. Check this in extensions total settings.', '[[regtime]]', '[[regtime]]'),
(321, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_account_number', 'Account Number:<br /><span class="help">Account number provided by Avalara</span>', '[[regtime]]', '[[regtime]]'),
(322, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_license_key', 'License Key:<br /><span class="help">License key provided by Avalara</span>', '[[regtime]]', '[[regtime]]'),
(323, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_service_url', 'Service URL:<br /><span class="help">Avalara service URL (live or development)</span>', '[[regtime]]', '[[regtime]]'),
(324, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_service_url_https://avatax.avalara.net', 'https://avatax.avalara.net', '[[regtime]]', '[[regtime]]'),
(325, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_service_url_https://development.avalara.net', 'https://development.avalara.net', '[[regtime]]', '[[regtime]]'),
(326, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_tax_name', 'Tax Name:<br /><span class="help">Tax name to be shown to the customer in the totals section</span>', '[[regtime]]', '[[regtime]]'),
(327, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_company_code', 'Company Code:<br /><span class="help">Company code to be used with Avalara</span>', '[[regtime]]', '[[regtime]]'),
(328, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_postal_code', 'Store ZIP/Postal code:', '[[regtime]]', '[[regtime]]'),
(329, 1, 1, 'avatax_integration_avatax_integration', 'error_turn_extension_on', 'Error! Please check if extension is turned ON.', '[[regtime]]', '[[regtime]]'),
(330, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_default_taxcode', 'Product Default TaxCode', '[[regtime]]', '[[regtime]]'),
(331, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_shipping_taxcode', 'Shipping Methods Default TaxCodes', '[[regtime]]', '[[regtime]]'),
(332, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_text_shipping_method', 'Shipping Method', '[[regtime]]', '[[regtime]]'),
(333, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_text_shipping_taxcode', 'Freight Tax Code', '[[regtime]]', '[[regtime]]'),
(334, 1, 1, 'avatax_integration_avatax_integration', 'text_test', 'Test connection', '[[regtime]]', '[[regtime]]'),
(335, 1, 1, 'avatax_integration_avatax_integration', 'text_connection_success', 'Connection is successful and API Credentials are configured correctly.', '[[regtime]]', '[[regtime]]'),
(336, 1, 1, 'avatax_integration_avatax_integration', 'text_test_connection', 'Test connection:', '[[regtime]]', '[[regtime]]'),
(337, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_address_validation', 'Address Validation:<br /><span class="help">Address validation will be performed at customer checkout step</span>', '[[regtime]]', '[[regtime]]'),
(338, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_address_validate_button_title', 'Title for Address Validation Button:', '[[regtime]]', '[[regtime]]'),
(339, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_commit_documents', 'Commit documents on Avatax Service:<br /><span class="help">If enable tax document will be committed at specified order status</span>', '[[regtime]]', '[[regtime]]'),
(340, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_return_documents', 'Return documents on Avatax Service:<br /><span class="help">Return will be recorded at specified order status</span>', '[[regtime]]', '[[regtime]]'),
(341, 1, 1, 'avatax_integration_avatax_integration', 'button_add_tax_code', 'Save', '[[regtime]]', '[[regtime]]'),
(342, 1, 1, 'avatax_integration_avatax_integration', 'button_delete_tax_code', 'Clear TaxCode', '[[regtime]]', '[[regtime]]'),
(343, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_taxcode_name', 'Product TaxCode:', '[[regtime]]', '[[regtime]]'),
(344, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_button_find_taxcode', 'Find Tax Code', '[[regtime]]', '[[regtime]]'),
(345, 1, 1, 'avatax_integration_avatax_integration', 'exemption_status', 'Exemption Status:', '[[regtime]]', '[[regtime]]'),
(346, 1, 1, 'avatax_integration_avatax_integration', 'exemption_status_pending', 'Pending', '[[regtime]]', '[[regtime]]'),
(347, 1, 1, 'avatax_integration_avatax_integration', 'exemption_status_approved', 'Approved', '[[regtime]]', '[[regtime]]'),
(348, 1, 1, 'avatax_integration_avatax_integration', 'exemption_status_declined', 'Declined', '[[regtime]]', '[[regtime]]'),
(349, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_subject', 'Your tax exempt number has been declined', '[[regtime]]', '[[regtime]]'),
(350, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_mail_text', 'Your tax exempt number has been declined. To check validity please visit your account details page %s', '[[regtime]]', '[[regtime]]'),
(351, 1, 1, 'avatax_integration_avatax_integration', 'exemption_number_name', 'Exemption Number:<br /><span class="help">Tax exemption number</span>', '[[regtime]]', '[[regtime]]'),
(352, 1, 1, 'avatax_integration_avatax_integration', 'entity_use_code_name', 'Entity\\Use Code:<br /><span class="help">AvaTax has a group of codes that indicate the type of exemption. See the standard codes or create custom codes in AvaTax site</span>', '[[regtime]]', '[[regtime]]'),
(353, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_status_success_settled', 'Commit on Order status:', '[[regtime]]', '[[regtime]]'),
(354, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_status_return_settled', 'Return on Order status:', '[[regtime]]', '[[regtime]]'),
(355, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_status_cancel_settled', 'Cancel on Order status:', '[[regtime]]', '[[regtime]]'),
(356, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_account_number_validation_error', 'Account Number error. Check it!', '[[regtime]]', '[[regtime]]'),
(357, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_address_validation_countries_Both', 'Both', '[[regtime]]', '[[regtime]]'),
(358, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_address_validation_countries_US', 'USA', '[[regtime]]', '[[regtime]]'),
(359, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_address_validation_countries_CA', 'Canada', '[[regtime]]', '[[regtime]]'),
(360, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_address_validation_countries', 'Countries for address validation', '[[regtime]]', '[[regtime]]'),
(361, 1, 1, 'avatax_integration_avatax_integration', 'total_name', 'Avatax Integration Total', '[[regtime]]', '[[regtime]]'),
(362, 1, 1, 'avatax_integration_avatax_integration', 'avatax_integration_logging', 'Enable transaction logging', '[[regtime]]', '[[regtime]]'),
(363, 1, 1, 'cardconnect_cardconnect', 'cardconnect_name', 'CardConnect', '[[regtime]]', '[[regtime]]'),
(364, 1, 1, 'cardconnect_cardconnect', 'cardconnect_note', 'To obtain API Credentials please visit https://cardconnect.com/signup/developer', '[[regtime]]', '[[regtime]]'),
(365, 1, 1, 'cardconnect_cardconnect', 'cardconnect_merchant_id', 'Merchant ID', '[[regtime]]', '[[regtime]]'),
(366, 1, 1, 'cardconnect_cardconnect', 'cardconnect_username', 'API Username', '[[regtime]]', '[[regtime]]'),
(367, 1, 1, 'cardconnect_cardconnect', 'cardconnect_password', 'API Password', '[[regtime]]', '[[regtime]]'),
(368, 1, 1, 'cardconnect_cardconnect', 'cardconnect_logging', 'Logging:<br /><span class="help">Log file is located in system/logs/cardconnect.txt file</span>', '[[regtime]]', '[[regtime]]'),
(369, 1, 1, 'cardconnect_cardconnect', 'cardconnect_test', 'Test', '[[regtime]]', '[[regtime]]'),
(370, 1, 1, 'cardconnect_cardconnect', 'cardconnect_test_connection', 'Test Connection', '[[regtime]]', '[[regtime]]'),
(371, 1, 1, 'cardconnect_cardconnect', 'cardconnect_get_test_api_credentials', 'Get Test API Credentials', '[[regtime]]', '[[regtime]]'),
(372, 1, 1, 'cardconnect_cardconnect', 'cardconnect_test_mode', 'Test Mode', '[[regtime]]', '[[regtime]]'),
(373, 1, 1, 'cardconnect_cardconnect', 'cardconnect_site', 'Domain portion to API:<br /><span class="help">This value should not be changed, unless different specified by cardConnent.</span>', '[[regtime]]', '[[regtime]]'),
(374, 1, 1, 'cardconnect_cardconnect', 'cardconnect_connection_success', 'Connection is successful and API Credentials are configured correctly.', '[[regtime]]', '[[regtime]]'),
(375, 1, 1, 'cardconnect_cardconnect', 'cardconnect_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(376, 1, 1, 'cardconnect_cardconnect', 'cardconnect_location_id', 'Location', '[[regtime]]', '[[regtime]]'),
(377, 1, 1, 'cardconnect_cardconnect', 'cardconnect_status_refund', 'Refunded:<br /><span class="help">Order status you want to be set if payment is refunded in admin/order', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(378, 1, 1, 'cardconnect_cardconnect', 'cardconnect_status_decline', 'Decline:<br /><span class="help">Order status you want to record in history in response to payment processor status. Main order status is not affected. Order will not be placed only after payment is a success.</span>', '[[regtime]]', '[[regtime]]'),
(379, 1, 1, 'cardconnect_cardconnect', 'cardconnect_status_success_unsettled', 'Success & not settled:<br /><span class="help">Select main order status you want to set in response to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(380, 1, 1, 'cardconnect_cardconnect', 'cardconnect_status_success_settled', 'Success & settled:<br /><span class="help">Select main order status you want to set in response to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(381, 1, 1, 'cardconnect_cardconnect', 'cardconnect_status_void', 'Voided:<br /><span class="help">Order status you want to be set if payment is voided in admin/order.</span>', '[[regtime]]', '[[regtime]]'),
(382, 1, 1, 'cardconnect_cardconnect', 'cardconnect_settlement_payment', 'Auto (authorize and capture)', '[[regtime]]', '[[regtime]]'),
(383, 1, 1, 'cardconnect_cardconnect', 'cardconnect_settlement_auth', 'Delayed (authorize only)', '[[regtime]]', '[[regtime]]'),
(384, 1, 1, 'cardconnect_cardconnect', 'cardconnect_settlement', 'Settlement type:<br /><span class="help">If set to "auto", then the transaction will be included in today''s settlement. If set to ''delayed'', then the transaction will be authorised but not settled(captured). You must manually capture transactions within 7 days of authorisation</span>', '[[regtime]]', '[[regtime]]'),
(385, 1, 1, 'cardconnect_cardconnect', 'cardconnect_save_cards_limit', 'Max credit cards saved: <br/><span class="help">Set maximum number of credit cards to be saved by customers (up to 100). If set to 0 or blank saving of cards will not be allowed. Security note: Customer credit card details are saved on CardConnect secure servers to ensure maximum data security measures. No credit card details will be saved on your site.</span>', '[[regtime]]', '[[regtime]]'),
(386, 1, 1, 'cardconnect_cardconnect', 'text_column_date_added', 'Transaction Date', '[[regtime]]', '[[regtime]]'),
(387, 1, 1, 'cardconnect_cardconnect', 'text_column_amount', 'Amount', '[[regtime]]', '[[regtime]]'),
(388, 1, 1, 'cardconnect_cardconnect', 'text_captured_ok', 'Funds were captured successfully', '[[regtime]]', '[[regtime]]'),
(389, 1, 1, 'cardconnect_cardconnect', 'text_captured_order', 'Capture was successful, order status updated to success - settled', '[[regtime]]', '[[regtime]]'),
(390, 1, 1, 'cardconnect_cardconnect', 'text_refunded_ok', 'Refund was processed successfully', '[[regtime]]', '[[regtime]]'),
(391, 1, 1, 'cardconnect_cardconnect', 'text_refund_order', 'Refund was successful, order status updated to refunded', '[[regtime]]', '[[regtime]]'),
(392, 1, 1, 'cardconnect_cardconnect', 'text_voided', 'Void was successful, order status updated to voided', '[[regtime]]', '[[regtime]]'),
(393, 1, 1, 'cardconnect_cardconnect', 'text_payment_info', 'Payment Details', '[[regtime]]', '[[regtime]]'),
(394, 1, 1, 'cardconnect_cardconnect', 'text_capture_status', 'Payment captured', '[[regtime]]', '[[regtime]]'),
(395, 1, 1, 'cardconnect_cardconnect', 'text_void_status', 'Payment voided', '[[regtime]]', '[[regtime]]'),
(396, 1, 1, 'cardconnect_cardconnect', 'text_refund_status', 'Payment refunded', '[[regtime]]', '[[regtime]]'),
(397, 1, 1, 'cardconnect_cardconnect', 'text_capture_amount', 'Capture Amount', '[[regtime]]', '[[regtime]]'),
(398, 1, 1, 'cardconnect_cardconnect', 'text_refund_amount', 'Refund Amount', '[[regtime]]', '[[regtime]]'),
(399, 1, 1, 'cardconnect_cardconnect', 'text_order_ref', 'CardConnect Charge ID', '[[regtime]]', '[[regtime]]'),
(400, 1, 1, 'cardconnect_cardconnect', 'text_authorized_ammount', 'Total amount authorized', '[[regtime]]', '[[regtime]]'),
(401, 1, 1, 'cardconnect_cardconnect', 'text_balance', 'Balance amount', '[[regtime]]', '[[regtime]]'),
(402, 1, 1, 'cardconnect_cardconnect', 'text_transactions', 'Refund Transactions', '[[regtime]]', '[[regtime]]'),
(403, 1, 1, 'cardconnect_cardconnect', 'text_confirm_void', 'Please confirm you want to void the payment?', '[[regtime]]', '[[regtime]]'),
(404, 1, 1, 'cardconnect_cardconnect', 'text_confirm_capture', 'Please confirm you want to capture the payment?', '[[regtime]]', '[[regtime]]'),
(405, 1, 1, 'cardconnect_cardconnect', 'text_confirm_refund', 'Please confirm you want to refund the payment?', '[[regtime]]', '[[regtime]]'),
(406, 1, 1, 'cardconnect_cardconnect', 'button_refund', 'Refund', '[[regtime]]', '[[regtime]]'),
(407, 1, 1, 'cardconnect_cardconnect', 'button_void', 'Void', '[[regtime]]', '[[regtime]]'),
(408, 1, 1, 'cardconnect_cardconnect', 'button_capture', 'Capture', '[[regtime]]', '[[regtime]]'),
(409, 1, 1, 'cardconnect_cardconnect', 'error_system', 'Internal error. Check error log or input parameters!', '[[regtime]]', '[[regtime]]'),
(410, 1, 1, 'cardconnect_cardconnect', 'error_missing_amount', 'Please enter positive amount', '[[regtime]]', '[[regtime]]'),
(411, 1, 1, 'cardconnect_cardconnect', 'error_unable_to_void', 'Unable to void transaction, refresh and check transaction details', '[[regtime]]', '[[regtime]]'),
(412, 1, 1, 'cardconnect_cardconnect', 'error_unable_to_capture', 'Unable to capture, refresh transaction details and check capture amount', '[[regtime]]', '[[regtime]]'),
(413, 1, 1, 'cardconnect_cardconnect', 'error_unable_to_refund', 'Unable to refund, refresh transaction details and check refund amount', '[[regtime]]', '[[regtime]]'),
(414, 1, 1, 'cardconnect_cardconnect', 'text_settlement_status', 'Current Settlement Status', '[[regtime]]', '[[regtime]]'),
(415, 1, 1, 'cardknox_cardknox', 'cardknox_name', 'CardKnox', '[[regtime]]', '[[regtime]]'),
(416, 1, 1, 'cardknox_cardknox', 'cardknox_note', '', '[[regtime]]', '[[regtime]]'),
(417, 1, 1, 'cardknox_cardknox', 'cardknox_transaction_key', 'Transaction Key (xKey)', '[[regtime]]', '[[regtime]]'),
(418, 1, 1, 'cardknox_cardknox', 'cardknox_transaction_token', 'Transaction Token (xToken)', '[[regtime]]', '[[regtime]]'),
(419, 1, 1, 'cardknox_cardknox', 'cardknox_test', 'Test Mode', '[[regtime]]', '[[regtime]]'),
(420, 1, 1, 'cardknox_cardknox', 'cardknox_success_order_status', 'Order Status:<br /><span class="help">Order status to be set after customer''s order finished based on set Transaction Method</span>', '[[regtime]]', '[[regtime]]'),
(421, 1, 1, 'cardknox_cardknox', 'cardknox_location_id', 'Location:<br /><span class="help">Restrict to allow only selected locations to use this payment method.', '[[regtime]]', '[[regtime]]'),
(422, 1, 1, 'cardknox_cardknox', 'cardknox_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(423, 1, 1, 'cardknox_cardknox', 'cardknox_transaction_method', 'Transaction Method:<br /><span class="help">CardKnox transaction to run at customer''s checkout before order status is set. Authorization only or capture.</span>', '[[regtime]]', '[[regtime]]'),
(424, 1, 1, 'cardknox_cardknox', 'cardknox_transaction_method_capture', 'Capture', '[[regtime]]', '[[regtime]]'),
(425, 1, 1, 'cardknox_cardknox', 'cardknox_transaction_method_authorization', 'Authorization Only', '[[regtime]]', '[[regtime]]'),
(426, 1, 1, 'cardknox_cardknox', 'cardknox_ifields_key', 'iFields Key', '[[regtime]]', '[[regtime]]'),
(427, 1, 1, 'cardknox_cardknox', 'cardknox_text_pending_authorization', 'Pending Authorization', '[[regtime]]', '[[regtime]]'),
(428, 1, 1, 'cardknox_cardknox', 'cardknox_text_capture_funds', 'Capture Funds', '[[regtime]]', '[[regtime]]'),
(429, 1, 1, 'cardknox_cardknox', 'cardknox_text_capture', 'Capture', '[[regtime]]', '[[regtime]]'),
(430, 1, 1, 'cardknox_cardknox', 'cardknox_text_payment_status', 'Payment Status', '[[regtime]]', '[[regtime]]'),
(431, 1, 1, 'cardknox_cardknox', 'cardknox_text_capture_success', 'Success! Funds have been captured successfully.', '[[regtime]]', '[[regtime]]'),
(432, 1, 1, 'cardknox_cardknox', 'cardknox_text_processing', 'Processing', '[[regtime]]', '[[regtime]]'),
(433, 1, 1, 'cardknox_cardknox', 'cardknox_text_do_refund', 'Do CardKnox Refund:<span class="help">You can enter amount that needs to be refunded.</span>', '[[regtime]]', '[[regtime]]'),
(434, 1, 1, 'cardknox_cardknox', 'cardknox_text_refunded', 'Refunded', '[[regtime]]', '[[regtime]]'),
(435, 1, 1, 'cardknox_cardknox', 'cardknox_text_refund', 'Refund', '[[regtime]]', '[[regtime]]'),
(436, 1, 1, 'cardknox_cardknox', 'cardknox_refund_title', 'CardKnox Refund', '[[regtime]]', '[[regtime]]'),
(437, 1, 1, 'cardknox_cardknox', 'cardknox_text_refund_success', 'Success! Order has been refunded successfully.', '[[regtime]]', '[[regtime]]'),
(438, 1, 1, 'cardknox_cardknox', 'cardknox_error_empty_amount', 'Error! Amount is wrong.', '[[regtime]]', '[[regtime]]'),
(439, 1, 1, 'cardknox_cardknox', 'cardknox_error_no_payment_method_data', 'Error! There is no payment method data for this order.', '[[regtime]]', '[[regtime]]'),
(440, 1, 1, 'cardknox_cardknox', 'cardknox_error_no_order_id', 'Error! There is no order ID.', '[[regtime]]', '[[regtime]]'),
(441, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_name', 'Authorize.Net Payment', '[[regtime]]', '[[regtime]]'),
(442, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_note', 'Additional settings are required to complete Authorize.Net payment setup. See additional settings tab.', '[[regtime]]', '[[regtime]]'),
(443, 1, 1, 'default_authorizenet_default_authorizenet', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(444, 1, 1, 'default_authorizenet_default_authorizenet', 'text_success', 'Success: You have modified Authorize.Net payment settings!', '[[regtime]]', '[[regtime]]'),
(445, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(446, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(447, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_api_login_id', 'API Login ID:', '[[regtime]]', '[[regtime]]'),
(448, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_test_mode', 'Test mode:<br /><span class="help">Set to ON if you want to use test key</span>', '[[regtime]]', '[[regtime]]'),
(449, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_api_transaction_key', 'Transaction Key:', '[[regtime]]', '[[regtime]]'),
(450, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_api_public_key', 'Public Key:', '[[regtime]]', '[[regtime]]'),
(451, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_autoselect', '            Auto Select:<br /><span class="help">You can set to skip payment selection page if there is only one payment option. This payment method will be selected automatically</span>', '[[regtime]]', '[[regtime]]'),
(452, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_save_cards_limit', '            Can save credit cards:<br /><span class="help">Set maximum number of credit cards to be saved by customers (up to 100). If set to 0 or blank saving of cards will not be allowed. Security note: Customer credit card details are saved on authorizenet secure servers to ensure maximum data security measures. No credit card details will be saved on your site.</span>', '[[regtime]]', '[[regtime]]'),
(453, 1, 1, 'default_authorizenet_default_authorizenet', 'text_authorizenet_connect', 'You need to connect with authorizenet to set up payment details', '[[regtime]]', '[[regtime]]'),
(454, 1, 1, 'default_authorizenet_default_authorizenet', 'text_authorizenet_settings', 'Authorize.Net settings', '[[regtime]]', '[[regtime]]'),
(455, 1, 1, 'default_authorizenet_default_authorizenet', 'text_connect', 'Connect with Authorize.Net', '[[regtime]]', '[[regtime]]'),
(456, 1, 1, 'default_authorizenet_default_authorizenet', 'text_disconnect', 'Disconnect Authorize.Net', '[[regtime]]', '[[regtime]]'),
(457, 1, 1, 'default_authorizenet_default_authorizenet', 'text_skip_connect', 'Cannot connect?', '[[regtime]]', '[[regtime]]'),
(458, 1, 1, 'default_authorizenet_default_authorizenet', 'text_connect_success', 'Connected to Authorize.Net successfully', '[[regtime]]', '[[regtime]]'),
(459, 1, 1, 'default_authorizenet_default_authorizenet', 'text_disconnect_success', 'Disconnected from Authorize.Net successfully', '[[regtime]]', '[[regtime]]'),
(460, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(461, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_sk_live', 'Live Secret Key:<br /><span class="help">Locate this in Authorize.Net API Keys Section. Key starts with sk_live_... </span>', '[[regtime]]', '[[regtime]]'),
(462, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_pk_live', 'Live Publishable Key:<br /><span class="help">Locate this in Authorize.Net API Keys Section. Key starts with pk_live_... </span>', '[[regtime]]', '[[regtime]]'),
(463, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_sk_test', 'Test Secret Key:<br /><span class="help">Locate this in Authorize.Net API Keys Section. Key starts with sk_test_... </span>', '[[regtime]]', '[[regtime]]'),
(464, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_pk_test', 'Test Publishable Key:<br /><span class="help">Locate this in Authorize.Net API Keys Section. Key starts with pk_test_... </span>', '[[regtime]]', '[[regtime]]'),
(465, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_settlement', 'Settlement type:', '[[regtime]]', '[[regtime]]'),
(466, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_settlement_auth', 'Authorize Only', '[[regtime]]', '[[regtime]]'),
(467, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_settlement_authcapture', 'Authorize & Capture ', '[[regtime]]', '[[regtime]]'),
(468, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_status_success_settled', 'Success & settled:<br /><span class="help">Select main order status you want to set in responce to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(469, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_status_success_unsettled', 'Success & not settled:<br /><span class="help">Select main order status you want to set in responce to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(470, 1, 1, 'default_authorizenet_default_authorizenet', 'text_column_date_added', 'Transaction Date', '[[regtime]]', '[[regtime]]'),
(471, 1, 1, 'default_authorizenet_default_authorizenet', 'text_column_amount', 'Amount', '[[regtime]]', '[[regtime]]'),
(472, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_settlement_auto', 'Auto (authorize and capture)', '[[regtime]]', '[[regtime]]'),
(473, 1, 1, 'default_authorizenet_default_authorizenet', 'default_authorizenet_settlement_delayed', 'Delayed (authorize only)', '[[regtime]]', '[[regtime]]'),
(474, 1, 1, 'default_authorizenet_default_authorizenet', 'text_payment_info', 'Payment Details', '[[regtime]]', '[[regtime]]'),
(475, 1, 1, 'default_authorizenet_default_authorizenet', 'text_order_ref', 'Authorize.Net Transaction ID', '[[regtime]]', '[[regtime]]'),
(476, 1, 1, 'default_authorizenet_default_authorizenet', 'text_transaction_status', 'Transaction Status', '[[regtime]]', '[[regtime]]'),
(477, 1, 1, 'default_authorizenet_default_authorizenet', 'text_order_total', 'Total amount authorized', '[[regtime]]', '[[regtime]]'),
(478, 1, 1, 'default_authorizenet_default_authorizenet', 'text_balance', 'Balance amount', '[[regtime]]', '[[regtime]]'),
(479, 1, 1, 'default_authorizenet_default_authorizenet', 'error_system', 'Internal error. Check error log or input parameters!', '[[regtime]]', '[[regtime]]'),
(480, 1, 1, 'default_authorizenet_default_authorizenet', 'error_missing_amount', 'Please enter positive amount', '[[regtime]]', '[[regtime]]'),
(481, 1, 1, 'default_authorizenet_default_authorizenet', 'error_authorizenet_sk_test', 'Authorize.Net test key is required', '[[regtime]]', '[[regtime]]'),
(482, 1, 1, 'default_authorizenet_default_authorizenet', 'error_authorizenet_sk_live', 'Authorize.Net live key is required', '[[regtime]]', '[[regtime]]'),
(483, 1, 1, 'default_authorizenet_default_authorizenet', 'error_permission', 'Warning: You do not have permission to modify Authorize.Net Payment!', '[[regtime]]', '[[regtime]]'),
(484, 1, 1, 'default_banktransfer_default_banktransfer', 'default_banktransfer_name', 'Bank Transfer', '[[regtime]]', '[[regtime]]'),
(485, 1, 1, 'default_banktransfer_default_banktransfer', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(486, 1, 1, 'default_banktransfer_default_banktransfer', 'text_success', 'Success: You have modified bank transfer settings and details!', '[[regtime]]', '[[regtime]]'),
(487, 1, 1, 'default_banktransfer_default_banktransfer', 'default_banktransfer_instructions', 'Bank Transfer Instructions:<span class="help">Instruction shown to customers to make bank or wire transfer into your bank account</span>', '[[regtime]]', '[[regtime]]'),
(488, 1, 1, 'default_banktransfer_default_banktransfer', 'default_banktransfer_order_min', 'Total Order limit:<span class="help">Minimum order amount to be reached to allow this payment</span>', '[[regtime]]', '[[regtime]]'),
(489, 1, 1, 'default_banktransfer_default_banktransfer', 'default_banktransfer_order_status_id', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(490, 1, 1, 'default_banktransfer_default_banktransfer', 'default_banktransfer_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(491, 1, 1, 'default_banktransfer_default_banktransfer', 'default_banktransfer_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(492, 1, 1, 'default_banktransfer_default_banktransfer', 'error_permission', 'Warning: You do not have permission to modify payment banktransfer!', '[[regtime]]', '[[regtime]]'),
(493, 1, 1, 'default_banktransfer_default_banktransfer', 'error_instructions', 'Bank Transfer Instructions are required!', '[[regtime]]', '[[regtime]]'),
(494, 1, 1, 'default_cheque_default_cheque', 'default_cheque_name', 'Cheque / Money Order', '[[regtime]]', '[[regtime]]'),
(495, 1, 1, 'default_cheque_default_cheque', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(496, 1, 1, 'default_cheque_default_cheque', 'text_success', 'Success: You have modified cheque / money order account details!', '[[regtime]]', '[[regtime]]'),
(497, 1, 1, 'default_cheque_default_cheque', 'default_cheque_payable', 'Payable To:<br /><span class="help">Provide name check needs to be written to</span>', '[[regtime]]', '[[regtime]]'),
(498, 1, 1, 'default_cheque_default_cheque', 'default_cheque_address', 'Mail or Send To:<br /><span class="help">Provide address where to send the check. Main store address will be used if blank</span>', '[[regtime]]', '[[regtime]]'),
(499, 1, 1, 'default_cheque_default_cheque', 'default_cheque_order_status_id', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(500, 1, 1, 'default_cheque_default_cheque', 'default_cheque_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(501, 1, 1, 'default_cheque_default_cheque', 'default_cheque_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(502, 1, 1, 'default_cheque_default_cheque', 'error_permission', 'Warning: You do not have permission to modify payment cheque / money order!', '[[regtime]]', '[[regtime]]'),
(503, 1, 1, 'default_cheque_default_cheque', 'error_payable', 'Payable To Required!', '[[regtime]]', '[[regtime]]'),
(504, 1, 1, 'default_cod_default_cod', 'default_cod_name', 'Cash On Delivery', '[[regtime]]', '[[regtime]]'),
(505, 1, 1, 'default_cod_default_cod', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(506, 1, 1, 'default_cod_default_cod', 'text_success', 'Success: You have modified Cash On Delivery payment module!', '[[regtime]]', '[[regtime]]'),
(507, 1, 1, 'default_cod_default_cod', 'default_cod_order_status_id', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(508, 1, 1, 'default_cod_default_cod', 'default_cod_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(509, 1, 1, 'default_cod_default_cod', 'default_cod_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(510, 1, 1, 'default_cod_default_cod', 'error_permission', 'Warning: You do not have permission to modify payment Cash On Delivery!', '[[regtime]]', '[[regtime]]'),
(511, 1, 1, 'default_fedex_default_fedex', 'default_fedex_name', 'FEDEX', '[[regtime]]', '[[regtime]]'),
(512, 1, 1, 'default_fedex_default_fedex', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(513, 1, 1, 'default_fedex_default_fedex', 'text_success', 'Success: You have modified shipping FEDEX!', '[[regtime]]', '[[regtime]]'),
(514, 1, 1, 'default_fedex_default_fedex', 'default_fedex_key', 'Fedex Production Key:<br /><span class="help">Enter the Fedex Production Key Assigned to You, Required. </span>', '[[regtime]]', '[[regtime]]'),
(515, 1, 1, 'default_fedex_default_fedex', 'default_fedex_password', 'Fedex Production Password:<br /><span class="help"></span>', '[[regtime]]', '[[regtime]]'),
(516, 1, 1, 'default_fedex_default_fedex', 'default_fedex_account', 'Account Number:<br /><span class="help">Enter the fedex Account Number assigned to you, required.</span>', '[[regtime]]', '[[regtime]]'),
(517, 1, 1, 'default_fedex_default_fedex', 'default_fedex_meter', 'Fedex Meter Number:<br /><span class="help">Enter FedEx Meter Number.</span>', '[[regtime]]', '[[regtime]]'),
(518, 1, 1, 'default_fedex_default_fedex', 'default_fedex_address', 'Address:<br /><span class="help">Shipping from street address.</span>', '[[regtime]]', '[[regtime]]'),
(519, 1, 1, 'default_fedex_default_fedex', 'default_fedex_city', 'City:<br /><span class="help">Shipping from city.</span>', '[[regtime]]', '[[regtime]]'),
(520, 1, 1, 'default_fedex_default_fedex', 'default_fedex_state', 'State:<br /><span class="help">Shipping from state (two letters).</span>', '[[regtime]]', '[[regtime]]'),
(521, 1, 1, 'default_fedex_default_fedex', 'default_fedex_zip', 'Zip/postal code:<br /><span class="help">Shipping from Zip-code.</span>', '[[regtime]]', '[[regtime]]'),
(522, 1, 1, 'default_fedex_default_fedex', 'default_fedex_country', 'Country:<br /><span class="help">Shipping from country(two letters).</span>', '[[regtime]]', '[[regtime]]'),
(523, 1, 1, 'default_fedex_default_fedex', 'default_fedex_quote_type', 'Quote Type:<br /><span class="help">Quote for Residential or Commercial Delivery.</span>', '[[regtime]]', '[[regtime]]'),
(524, 1, 1, 'default_fedex_default_fedex', 'default_fedex_quote_type_residential', 'Residential', '[[regtime]]', '[[regtime]]'),
(525, 1, 1, 'default_fedex_default_fedex', 'default_fedex_quote_type_commercial', 'Commercial', '[[regtime]]', '[[regtime]]'),
(526, 1, 1, 'default_fedex_default_fedex', 'default_fedex_add_chrg', 'Additional Charges:<br /><span class="help">Additional charge applied to fedex quote.</span>', '[[regtime]]', '[[regtime]]'),
(527, 1, 1, 'default_fedex_default_fedex', 'default_fedex_default_fedex_us_01', ' FEDEX First Overnight ', '[[regtime]]', '[[regtime]]'),
(528, 1, 1, 'default_fedex_default_fedex', 'default_fedex_default_fedex_us_02', ' FEDEX Priority Overnight  ', '[[regtime]]', '[[regtime]]'),
(529, 1, 1, 'default_fedex_default_fedex', 'default_fedex_default_fedex_us_03', ' FEDEX Standard Overnight  ', '[[regtime]]', '[[regtime]]'),
(530, 1, 1, 'default_fedex_default_fedex', 'default_fedex_default_fedex_us_04', ' FEDEX 2nd Day ', '[[regtime]]', '[[regtime]]'),
(531, 1, 1, 'default_fedex_default_fedex', 'default_fedex_default_fedex_us_05', ' FEDEX Express Saver  ', '[[regtime]]', '[[regtime]]'),
(532, 1, 1, 'default_fedex_default_fedex', 'default_fedex_default_fedex_us_06', ' FEDEX Ground  ', '[[regtime]]', '[[regtime]]'),
(533, 1, 1, 'default_fedex_default_fedex', 'error_permission', 'Warning: You do not have permission to modify shipping FEDEX!', '[[regtime]]', '[[regtime]]'),
(534, 1, 1, 'default_fedex_default_fedex', 'error_account', 'Account ID Required!', '[[regtime]]', '[[regtime]]'),
(535, 1, 1, 'default_fedex_default_fedex', 'error_meter', 'Fedex Meter ID Required!', '[[regtime]]', '[[regtime]]'),
(536, 1, 1, 'default_fedex_default_fedex', 'default_fedex_note', 'To obtain your Meter Number and Authorization Key, you will need to follow these steps:</br>\n            Go to <a href="http://fedex.com/us/developer" target="_blank">http://fedex.com/us/developer</a><br>\n            Login in with FedEx username and password or click Register Now if they don''t have one.<br>\n            Click "Technical Resources" (left side).<br>\n            Under that click "FedEx web services for shipping.<br>\n            Click on "Move To Production" (right side).<br>\n            Scroll down to button and click "Obtain Production Key".<br>\n            On form choose "No" on question 1.<br>\n            Check the first box on question 2.<br>\n            Choose "Corporate Developer" on question 3.<br>\n            Accept agreement.<br>\n            Fill out the form (do not use dashes in the account number).<br>\n            Receive meter number and key instantly.  Your Production Password will be emailed to you once you complete the above steps.', '[[regtime]]', '[[regtime]]'),
(537, 1, 1, 'default_fedex_default_fedex', 'default_fedex_test', 'Test Mode:<br /><span class="help">Use the live or testing gateway server?</span>', '[[regtime]]', '[[regtime]]'),
(538, 1, 1, 'default_fedex_default_fedex', 'default_fedex_test_1', ' Yes ', '[[regtime]]', '[[regtime]]'),
(539, 1, 1, 'default_fedex_default_fedex', 'default_fedex_test_0', ' No ', '[[regtime]]', '[[regtime]]'),
(540, 1, 1, 'default_fedex_default_fedex', 'text_test_connection', 'Test Your Connection:<span class="help">You can test if API credentials that you''ve entered are correct.</span>', '[[regtime]]', '[[regtime]]'),
(541, 1, 1, 'default_fedex_default_fedex', 'text_test', 'Test', '[[regtime]]', '[[regtime]]'),
(542, 1, 1, 'default_fedex_default_fedex', 'text_connection_success', 'Connection is successful and API Credentials are configured correctly.', '[[regtime]]', '[[regtime]]'),
(543, 1, 1, 'default_fedex_default_fedex', 'error_turn_extension_on', 'Error! Please check if extension is turned ON.', '[[regtime]]', '[[regtime]]'),
(544, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_name', 'Flat Rate', '[[regtime]]', '[[regtime]]'),
(545, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(546, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'text_success', 'Success: You have modified flat rate shipping!', '[[regtime]]', '[[regtime]]'),
(547, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_rates', 'Rates:', '[[regtime]]', '[[regtime]]'),
(548, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(549, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_cost', 'Cost:', '[[regtime]]', '[[regtime]]'),
(550, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_tax_class_id', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(551, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_tax_class_id_0', ' ---None---', '[[regtime]]', '[[regtime]]'),
(552, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(553, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'default_flat_rate_shipping_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(554, 1, 1, 'default_flat_rate_shipping_default_flat_rate_shipping', 'error_permission', 'Warning: You do not have permission to modify flat rate shipping!', '[[regtime]]', '[[regtime]]'),
(555, 1, 1, 'default_free_shipping_default_free_shipping', 'default_free_shipping_name', 'Free Shipping', '[[regtime]]', '[[regtime]]'),
(556, 1, 1, 'default_free_shipping_default_free_shipping', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(557, 1, 1, 'default_free_shipping_default_free_shipping', 'text_success', 'Success: You have modified free shipping!', '[[regtime]]', '[[regtime]]'),
(558, 1, 1, 'default_free_shipping_default_free_shipping', 'default_free_shipping_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(559, 1, 1, 'default_free_shipping_default_free_shipping', 'default_free_shipping_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(560, 1, 1, 'default_free_shipping_default_free_shipping', 'error_permission', 'Warning: You do not have permission to modify free shipping!', '[[regtime]]', '[[regtime]]'),
(561, 1, 1, 'default_italian_default_italian', 'default_italian_name', 'Italian Language', '[[regtime]]', '[[regtime]]'),
(562, 1, 1, 'default_italian_default_italian', 'default_italian_status', 'Status', '[[regtime]]', '[[regtime]]'),
(563, 1, 1, 'default_italian_default_italian', 'default_italian_note', '<b>Attention!</b> Please enable extension and enable language in System->Localizations-><a href="#admin#rt=localisation/language">Languages</a>. \n		<br><b>Edit text</b>: If you notice incorrect translations, you can correct language text in System->Localizations-><a href="#admin#rt=localisation/language_definitions">Language Definitions</a>\n		<br><b>Missing text:</b> If you add new language you need to update store content (dynamic shopping cart data) to have new language translation.   ', '[[regtime]]', '[[regtime]]'),
(564, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_name', 'LIQPAY', '[[regtime]]', '[[regtime]]'),
(565, 1, 1, 'default_liqpay_default_liqpay', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(566, 1, 1, 'default_liqpay_default_liqpay', 'text_success', 'Success: You have modified LIQPAY account details!', '[[regtime]]', '[[regtime]]'),
(567, 1, 1, 'default_liqpay_default_liqpay', 'text_pay', 'LIQPAY', '[[regtime]]', '[[regtime]]'),
(568, 1, 1, 'default_liqpay_default_liqpay', 'text_card', 'Credit Card', '[[regtime]]', '[[regtime]]'),
(569, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_merchant', 'Merchant ID:', '[[regtime]]', '[[regtime]]'),
(570, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_signature', 'Signature:', '[[regtime]]', '[[regtime]]'),
(571, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_public_key', 'Public Key:', '[[regtime]]', '[[regtime]]'),
(572, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_private_key', 'Private Key:', '[[regtime]]', '[[regtime]]'),
(573, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_type', 'Type:', '[[regtime]]', '[[regtime]]'),
(574, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_type_pay', 'Pay', '[[regtime]]', '[[regtime]]'),
(575, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_type_card', 'Card', '[[regtime]]', '[[regtime]]'),
(576, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_test_mode', 'Test Mode:', '[[regtime]]', '[[regtime]]'),
(577, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_order_status_id', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(578, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(579, 1, 1, 'default_liqpay_default_liqpay', 'default_liqpay_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(580, 1, 1, 'default_liqpay_default_liqpay', 'error_permission', 'Warning: You do not have permission to modify payment LIQPAY!', '[[regtime]]', '[[regtime]]'),
(581, 1, 1, 'default_liqpay_default_liqpay', 'error_merchant', 'Merchant ID Required!', '[[regtime]]', '[[regtime]]'),
(582, 1, 1, 'default_liqpay_default_liqpay', 'error_signature', 'Signature Required!', '[[regtime]]', '[[regtime]]'),
(583, 1, 1, 'default_local_delivery_default_local_delivery', 'default_local_delivery_name', 'Local Delivery', '[[regtime]]', '[[regtime]]'),
(584, 1, 1, 'default_local_delivery_default_local_delivery', 'text_shipping', 'Delivery', '[[regtime]]', '[[regtime]]'),
(585, 1, 1, 'default_local_delivery_default_local_delivery', 'text_success', 'Success: You have modified local delivery!', '[[regtime]]', '[[regtime]]'),
(586, 1, 1, 'default_local_delivery_default_local_delivery', 'default_local_delivery_total', 'Min order amount:<br /><span class="help">Minimum sub-total amount to be met for delivery option to be available.</span>', '[[regtime]]', '[[regtime]]'),
(587, 1, 1, 'default_local_delivery_default_local_delivery', 'default_local_delivery_cost', 'Delivery Fee:', '[[regtime]]', '[[regtime]]'),
(588, 1, 1, 'default_local_delivery_default_local_delivery', 'default_local_delivery_tax_class_id', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(589, 1, 1, 'default_local_delivery_default_local_delivery', 'default_local_delivery_tax_class_id_0', ' -------- ', '[[regtime]]', '[[regtime]]'),
(590, 1, 1, 'default_local_delivery_default_local_delivery', 'default_local_delivery_postal_codes', 'Postal Codes:<br /><span class="help"> Comma separated postal codes list. Wildcard * supported. Example 30001,3002,40*,*ND</span>', '[[regtime]]', '[[regtime]]'),
(591, 1, 1, 'default_local_delivery_default_local_delivery', 'error_permission', 'Warning: You do not have permission to modify local delivery!', '[[regtime]]', '[[regtime]]'),
(592, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_name', 'Parcelforce 48', '[[regtime]]', '[[regtime]]'),
(593, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(594, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'text_success', 'Success: You have modified Parcelforce 48 shipping!', '[[regtime]]', '[[regtime]]'),
(595, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_rate', 'Parcelforce 48 Rates:<br /><span class="help">Example: 0:0,10:15.99,12:19.99, - Weights less than or equal to 10 pounds would cost $15.99, Weights less than 12 pounds but more than 10 pounds will cost $19.99. Where Pound is your Store Weight class and $ is Store Base currency. You can change both in the Store Settings. Do not enter KG or any symbols. Enter values upto 5,2 decimal places. (12345.67) </span>', '[[regtime]]', '[[regtime]]'),
(596, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_weight', 'Display Delivery Weight:<br /><span class="help">Do you want to display the shipping weight? (e.g. Delivery Weight : 2.7674 Kg''s)</span>', '[[regtime]]', '[[regtime]]'),
(597, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_weight_1', 'Yes', '[[regtime]]', '[[regtime]]'),
(598, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_weight_0', 'No', '[[regtime]]', '[[regtime]]'),
(599, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_insurance', 'Display Insurance:<br /><span class="help">Do you want to display the shipping insurance? (e.g. Insured upto 500)</span>', '[[regtime]]', '[[regtime]]'),
(600, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_insurance_1', 'Yes', '[[regtime]]', '[[regtime]]'),
(601, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_insurance_0', 'No', '[[regtime]]', '[[regtime]]'),
(602, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_time', 'Display Delivery Time:<br /><span class="help">Do you want to display the shipping time? (e.g. Ships within 3 to 5 days)</span>', '[[regtime]]', '[[regtime]]'),
(603, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_time_1', 'Yes', '[[regtime]]', '[[regtime]]'),
(604, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_display_time_0', 'No', '[[regtime]]', '[[regtime]]'),
(605, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_compensation', 'Parcelforce48 Compensation Rates:<br /><span class="help">Enter values upto 5,2 decimal places. (12345.67) Example: 34:0,100:1,250:2.25 - Insurance cover for cart values upto 34 would cost 0.00 extra, those values more than 100 and upto 250 will cost 2.25 extra. Do not enter currency symbols.</span>', '[[regtime]]', '[[regtime]]'),
(606, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_tax', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(607, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_tax_0', '---None---', '[[regtime]]', '[[regtime]]'),
(608, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(609, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'default_parcelforce_48_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(610, 1, 1, 'default_parcelforce_48_default_parcelforce_48', 'error_permission', 'Warning: You do not have permission to modify Parcelforce 48 shipping!', '[[regtime]]', '[[regtime]]'),
(611, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'default_per_item_shipping_name', 'Per Item', '[[regtime]]', '[[regtime]]'),
(612, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(613, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'text_success', 'Success: You have modified shipping per item rates!', '[[regtime]]', '[[regtime]]'),
(614, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'default_per_item_shipping_cost', 'Cost:', '[[regtime]]', '[[regtime]]'),
(615, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'default_per_item_shipping_tax', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(616, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'default_per_item_shipping_tax_0', '---None---', '[[regtime]]', '[[regtime]]'),
(617, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'default_per_item_shipping_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(618, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'default_per_item_shipping_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(619, 1, 1, 'default_per_item_shipping_default_per_item_shipping', 'error_permission', 'Warning: You do not have permission to modify shipping per item rates!', '[[regtime]]', '[[regtime]]'),
(620, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_name', 'Royal Mail', '[[regtime]]', '[[regtime]]'),
(621, 1, 1, 'default_royal_mail_default_royal_mail', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(622, 1, 1, 'default_royal_mail_default_royal_mail', 'text_success', 'Success: You have modified Royal Mail shipping!', '[[regtime]]', '[[regtime]]'),
(623, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_1st_class', '1st Class (for GB only)<br/><span class="help">Next-day delivery aim for letters and parcels</span>', '[[regtime]]', '[[regtime]]'),
(624, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_1st_class_rates', '1st Class Rates:<br/><span class="help">Example: .1:1.58,.25:1.96,.5:2.48 Weight:Cost,Weight:Cost, etc. In this example 0.1kg = £1.58. Where KG is your Weight class set in the Royal Mail settings and £ is Store Base currency. Store Weight class will be ignored.</span>', '[[regtime]]', '[[regtime]]'),
(625, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_1st_class_compensation_rates', '1st Class Compensation Rates', '[[regtime]]', '[[regtime]]'),
(626, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_2nd_class', '2nd Class (for GB only)', '[[regtime]]', '[[regtime]]'),
(627, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_2nd_class_rates', '2nd Class Rates', '[[regtime]]', '[[regtime]]'),
(628, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_2nd_class_compensation_rates', '2nd Class Compensation Rates', '[[regtime]]', '[[regtime]]'),
(629, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked24', 'Tracked 24® (for GB only)', '[[regtime]]', '[[regtime]]'),
(630, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked24_rates', 'Tracked 24® Rates', '[[regtime]]', '[[regtime]]'),
(631, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked24_compensation_rates', 'Tracked 24® Compensation Rates', '[[regtime]]', '[[regtime]]'),
(632, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked48', 'Tracked 48® (for GB only)', '[[regtime]]', '[[regtime]]'),
(633, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked48_rates', 'Tracked 48® Rates', '[[regtime]]', '[[regtime]]'),
(634, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked48_compensation_rates', 'Tracked 48® Compensation Rates', '[[regtime]]', '[[regtime]]'),
(635, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail24', 'Mail 24® (for GB only)', '[[regtime]]', '[[regtime]]'),
(636, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail24_rates', 'Mail 24® Rates', '[[regtime]]', '[[regtime]]'),
(637, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail24_compensation_rates', 'Mail 24® Compensation Rates', '[[regtime]]', '[[regtime]]'),
(638, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail48', 'Mail 48® (for GB only)', '[[regtime]]', '[[regtime]]'),
(639, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail48_rates', 'Mail 48® Rates', '[[regtime]]', '[[regtime]]'),
(640, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail48_compensation_rates', 'Mail 48® Compensation Rates', '[[regtime]]', '[[regtime]]'),
(641, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_sameday', 'Sameday® (for GB only)', '[[regtime]]', '[[regtime]]'),
(642, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_sameday_rates', 'Sameday® Rates', '[[regtime]]', '[[regtime]]'),
(643, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_sameday_compensation_rates', 'Sameday® Compensation Rates', '[[regtime]]', '[[regtime]]'),
(644, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_special_delivery_guaranteed', 'Special Delivery Guaranteed® (for GB only)', '[[regtime]]', '[[regtime]]'),
(645, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_special_delivery_guaranteed_rates', 'Special Delivery Guaranteed® Rates', '[[regtime]]', '[[regtime]]'),
(646, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_special_delivery_guaranteed_compensation_rates', 'Special Delivery Guaranteed® Compensation Rates', '[[regtime]]', '[[regtime]]'),
(647, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb', 'Shipping method for free shipping (GB only)<span class="help">Please select what method will chosen for case when cart contains only products with free shipping</span>', '[[regtime]]', '[[regtime]]'),
(648, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_1st_class', '1st Class', '[[regtime]]', '[[regtime]]'),
(649, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_2nd_class', '2nd Class', '[[regtime]]', '[[regtime]]'),
(650, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_tracked24', 'Tracked 24®', '[[regtime]]', '[[regtime]]'),
(651, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_tracked48', 'Tracked 48®', '[[regtime]]', '[[regtime]]'),
(652, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_mail24', 'Mail 24®', '[[regtime]]', '[[regtime]]'),
(653, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_mail48', 'Mail 48®', '[[regtime]]', '[[regtime]]'),
(654, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_sameday', 'Sameday®', '[[regtime]]', '[[regtime]]'),
(655, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_free_gb_special_delivery_guaranteed', 'Special Delivery Guaranteed®', '[[regtime]]', '[[regtime]]'),
(656, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_europe_zone_1', 'International Pricing Europe Zone 1', '[[regtime]]', '[[regtime]]'),
(657, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_europe_zone_2', 'International Pricing Europe Zone 2', '[[regtime]]', '[[regtime]]'),
(658, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_europe_zone_3', 'International Pricing Europe Zone 3', '[[regtime]]', '[[regtime]]'),
(659, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_world_zone_1', 'International Pricing World Zone 1', '[[regtime]]', '[[regtime]]'),
(660, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_world_zone_2', 'International Pricing World Zone 2', '[[regtime]]', '[[regtime]]'),
(661, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_world_zone_3', 'International Pricing World Zone 3', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(662, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_europe_zone_1', 'International Standard Economy (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(663, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_europe_zone_1_rates', 'Standard Economy Rates (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(664, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_europe_zone_2', 'International Standard Economy (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(665, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_europe_zone_2_rates', 'Standard Economy Rates (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(666, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_europe_zone_3', 'International Standard Economy (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(667, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_europe_zone_3_rates', 'Standard Economy Rates (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(668, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_world_zone_1', 'International Standard Economy (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(669, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_world_zone_1_rates', 'Standard Economy Rates (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(670, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_world_zone_2', 'International Standard Economy (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(671, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_world_zone_2_rates', 'Standard Economy Rates (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(672, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_world_zone_3', 'International Standard Economy (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(673, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy_world_zone_3_rates', 'Standard Economy Rates (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(674, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_europe_zone_1', 'International Standard Priority (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(675, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_europe_zone_1_rates', 'Standard Priority Rates (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(676, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_europe_zone_2', 'International Standard Priority (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(677, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_europe_zone_2_rates', 'Standard Priority Rates (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(678, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_europe_zone_3', 'International Standard Priority (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(679, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_europe_zone_3_rates', 'Standard Priority Rates (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(680, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_world_zone_1', 'International Standard Priority (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(681, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_world_zone_1_rates', 'Standard Priority Rates (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(682, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_world_zone_2', 'International Standard Priority (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(683, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_world_zone_2_rates', 'Standard Priority Rates (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(684, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_world_zone_3', 'International Standard Priority (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(685, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority_world_zone_3_rates', 'Standard Priority Rates (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(686, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_europe_zone_1', 'International Signed (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(687, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_europe_zone_1_rates', 'Signed Rates (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(688, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_europe_zone_2', 'International Signed (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(689, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_europe_zone_2_rates', 'Signed Rates (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(690, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_europe_zone_3', 'International Signed (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(691, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_europe_zone_3_rates', 'Signed Rates (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(692, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_world_zone_1', 'International Signed (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(693, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_world_zone_1_rates', 'Signed Rates (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(694, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_world_zone_2', 'International Signed (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(695, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_world_zone_2_rates', 'Signed Rates (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(696, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_world_zone_3', 'International Signed (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(697, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed_world_zone_3_rates', 'Signed Rates (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(698, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_europe_zone_1', 'International Tracked Signed (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(699, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_europe_zone_1_rates', 'Tracked Signed Rates (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(700, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_europe_zone_2', 'International Tracked Signed (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(701, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_europe_zone_2_rates', 'Tracked Signed Rates (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(702, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_europe_zone_3', 'International Tracked Signed (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(703, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_europe_zone_3_rates', 'Tracked Signed Rates (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(704, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_world_zone_1', 'International Tracked Signed (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(705, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_world_zone_1_rates', 'Tracked Signed Rates (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(706, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_world_zone_2', 'International Tracked Signed (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(707, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_world_zone_2_rates', 'Tracked Signed Rates (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(708, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_world_zone_3', 'International Tracked Signed (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(709, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed_world_zone_3_rates', 'Tracked Signed Rates (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(710, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_europe_zone_1', 'International Tracked (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(711, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_europe_zone_1_rates', 'Tracked Rates (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(712, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_europe_zone_2', 'International Tracked (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(713, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_europe_zone_2_rates', 'Tracked Rates (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(714, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_europe_zone_3', 'International Tracked (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(715, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_europe_zone_3_rates', 'Tracked Rates (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(716, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_world_zone_1', 'International Tracked (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(717, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_world_zone_1_rates', 'Tracked Rates (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(718, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_world_zone_2', 'International Tracked (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(719, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_world_zone_2_rates', 'Tracked Rates (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(720, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_world_zone_3', 'International Tracked (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(721, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_world_zone_3_rates', 'Tracked Rates (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(722, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_europe_zone_1', 'International Tracked Heavier (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(723, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_europe_zone_1_rates', 'Tracked Heavier Rates (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(724, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_europe_zone_2', 'International Tracked Heavier (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(725, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_europe_zone_2_rates', 'Tracked Heavier Rates (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(726, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_europe_zone_3', 'International Tracked Heavier (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(727, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_europe_zone_3_rates', 'Tracked Heavier Rates (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(728, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_world_zone_1', 'International Tracked Heavier (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(729, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_world_zone_1_rates', 'Tracked Heavier Rates (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(730, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_world_zone_2', 'International Tracked Heavier (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(731, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_world_zone_2_rates', 'Tracked Heavier Rates (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(732, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_world_zone_3', 'International Tracked Heavier (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(733, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier_world_zone_3_rates', 'Tracked Heavier Rates (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(734, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free', 'International Shipping Method for free shipping <span class="help">Please select what method will chosen for case when cart contains only products with free shipping</span>', '[[regtime]]', '[[regtime]]'),
(735, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_economy_europe_zone_1', 'Standard Economy (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(736, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_economy_europe_zone_2', 'Standard Economy (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(737, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_economy_europe_zone_3', 'Standard Economy (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(738, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_economy_world_zone_1', 'Standard Economy (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(739, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_economy_world_zone_2', 'Standard Economy (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(740, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_economy_world_zone_3', 'Standard Economy (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(741, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_priority_europe_zone_1', 'Standard Priority (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(742, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_priority_europe_zone_2', 'Standard Priority (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(743, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_priority_europe_zone_3', 'Standard Priority (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(744, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_priority_world_zone_1', 'Standard Priority (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(745, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_priority_world_zone_2', 'Standard Priority (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(746, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_standard_priority_world_zone_3', 'Standard Priority (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(747, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_signed_europe_zone_1', 'Signed (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(748, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_signed_europe_zone_2', 'Signed (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(749, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_signed_europe_zone_3', 'Signed (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(750, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_signed_world_zone_1', 'Signed (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(751, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_signed_world_zone_2', 'Signed (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(752, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_signed_world_zone_3', 'Signed (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(753, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_signed_europe_zone_1', 'Tracked Signed (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(754, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_signed_europe_zone_2', 'Tracked Signed (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(755, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_signed_europe_zone_3', 'Tracked Signed (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(756, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_signed_world_zone_1', 'Tracked Signed (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(757, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_signed_world_zone_2', 'Tracked Signed (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(758, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_signed_world_zone_3', 'Tracked Signed (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(759, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_europe_zone_1', 'Tracked (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(760, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_europe_zone_2', 'Tracked (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(761, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_europe_zone_3', 'Tracked (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(762, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_world_zone_1', 'Tracked (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(763, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_world_zone_2', 'Tracked (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(764, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_world_zone_3', 'Tracked (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(765, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_heavier_europe_zone_1', 'Tracked Heavier (Europe Zone 1)', '[[regtime]]', '[[regtime]]'),
(766, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_heavier_europe_zone_2', 'Tracked Heavier (Europe Zone 2)', '[[regtime]]', '[[regtime]]'),
(767, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_heavier_europe_zone_3', 'Tracked Heavier (Europe Zone 3)', '[[regtime]]', '[[regtime]]'),
(768, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_heavier_world_zone_1', 'Tracked Heavier (World Zone 1)', '[[regtime]]', '[[regtime]]'),
(769, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_heavier_world_zone_2', 'Tracked Heavier (World Zone 2)', '[[regtime]]', '[[regtime]]'),
(770, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_free_tracked_heavier_world_zone_3', 'Tracked Heavier (World Zone 3)', '[[regtime]]', '[[regtime]]'),
(771, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_display_weight', 'Display Delivery Weight:<br /><span class="help">Do you want to display the shipping weight? (e.g. Delivery Weight : 2.7674 Kg''s)</span>', '[[regtime]]', '[[regtime]]'),
(772, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_display_insurance', 'Display Insurance:<br /><span class="help">Do you want to display the shipping insurance? (e.g. Insured upto &pound;500)</span>', '[[regtime]]', '[[regtime]]'),
(773, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_display_time', 'Display Delivery Time:<br /><span class="help">Do you want to display the shipping time? (e.g. Ships within 3 to 5 days)</span>', '[[regtime]]', '[[regtime]]'),
(774, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_weight_class', 'Weight Class:<br /><span class="help">Your rates weight class. Store weight class will be ignored</span>', '[[regtime]]', '[[regtime]]'),
(775, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tax', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(776, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tax_0', '---None---', '[[regtime]]', '[[regtime]]'),
(777, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(778, 1, 1, 'default_royal_mail_default_royal_mail', 'default_royal_mail_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(779, 1, 1, 'default_royal_mail_default_royal_mail', 'error_permission', 'Warning: You do not have permission to modify Royal Mail shipping!', '[[regtime]]', '[[regtime]]'),
(780, 1, 1, 'default_russian_default_russian', 'default_russian_name', 'Russian Language', '[[regtime]]', '[[regtime]]'),
(781, 1, 1, 'default_russian_default_russian', 'default_russian_note', '<b>Attention!</b> Please enable extension and enable language in System->Localizations-><a href="#admin#rt=localisation/language">Languages</a>.\n		<br><b>Edit text</b>: If you notice incorrect translations, you can correct language text in System->Localizations-><a href="#admin#rt=localisation/language_definitions">Language Definitions</a>\n		<br><b>Missing text:</b> If you add new language you need to update store content (dynamic shopping cart data) to have new language translation.\n		<br>This can be done automatically with "Load missing language data" in edit language section', '[[regtime]]', '[[regtime]]'),
(782, 1, 1, 'default_spanish_default_spanish', 'default_spanish_name', 'Spanish Language', '[[regtime]]', '[[regtime]]'),
(783, 1, 1, 'default_spanish_default_spanish', 'default_spanish_note', '<b>Attention!</b> Please enable extension and enable language in System->Localizations-><a href="#admin#rt=localisation/language">Languages</a>.\n		<br><b>Edit text</b>: If you notice incorrect translations, you can correct language text in System->Localizations-><a href="#admin#rt=localisation/language_definitions">Language Definitions</a>\n		<br><b>Missing text:</b> If you add new language you need to update store content (dynamic shopping cart data) to have new language translation.\n		<br>This can be done automatically with "Load missing language data" in edit language section', '[[regtime]]', '[[regtime]]'),
(784, 1, 1, 'default_store_pickup_default_store_pickup', 'default_store_pickup_name', 'Pickup From Store', '[[regtime]]', '[[regtime]]'),
(785, 1, 1, 'default_store_pickup_default_store_pickup', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(786, 1, 1, 'default_store_pickup_default_store_pickup', 'text_success', 'Success: You have modified pickup from store!', '[[regtime]]', '[[regtime]]'),
(787, 1, 1, 'default_store_pickup_default_store_pickup', 'default_store_pickup_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(788, 1, 1, 'default_store_pickup_default_store_pickup', 'default_store_pickup_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(789, 1, 1, 'default_store_pickup_default_store_pickup', 'error_permission', 'Warning: You do not have permission to modify pickup from store!', '[[regtime]]', '[[regtime]]'),
(790, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_name', 'TextMarketer', '[[regtime]]', '[[regtime]]'),
(791, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_note', 'To enable sms-messaging go to System -> Settings -> <a href="#admin#rt=setting/setting/im" target="_im">IM</a> <br/>\n		and choose TextMarketer as default sms-driver. Do not forget to enable section where you wish to receive sms from (admin or storefront).<br/>\n		This extension will enable Mobile Phone field for admins and customers to provide. Remember that disabling of this extension will hide this field.\n		If added to existing store with customers, keep in mind that this information will be missing.', '[[regtime]]', '[[regtime]]'),
(792, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_username', 'API Username', '[[regtime]]', '[[regtime]]'),
(793, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_password', 'API Password', '[[regtime]]', '[[regtime]]'),
(794, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_originator', 'Originator: <span class="help">Who the message is from (the originator or sender ID). This can be 11 alpha-numeric or 16 numeric only characters.</span>', '[[regtime]]', '[[regtime]]'),
(795, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_test', 'Test Mode', '[[regtime]]', '[[regtime]]'),
(796, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_test_0', 'No', '[[regtime]]', '[[regtime]]'),
(797, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_test_1', 'Yes', '[[regtime]]', '[[regtime]]'),
(798, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_logging', 'Error Logging Status<span class="help">If you want to log all errors of TextMarketer extension turn this setting ON.</span>', '[[regtime]]', '[[regtime]]'),
(799, 1, 1, 'default_textmarketer_default_textmarketer', 'entry_sms', ' Mobile Phone ', '[[regtime]]', '[[regtime]]'),
(800, 1, 1, 'default_textmarketer_default_textmarketer', 'default_textmarketer_test_connection', 'Test Your Connection:<span class="help">You can test if API credentials that you''ve entered are correct.</span>', '[[regtime]]', '[[regtime]]'),
(801, 1, 1, 'default_textmarketer_default_textmarketer', 'text_test', ' Test ', '[[regtime]]', '[[regtime]]'),
(802, 1, 1, 'default_textmarketer_default_textmarketer', 'error_turn_extension_on', 'Error! Please check if extension is turned ON.', '[[regtime]]', '[[regtime]]'),
(803, 1, 1, 'default_textmarketer_default_textmarketer', 'error_empty_test_phone_number', 'Error! Please place recipient phone number.', '[[regtime]]', '[[regtime]]'),
(804, 1, 1, 'default_textmarketer_default_textmarketer', 'text_see_log', 'See error log for details.', '[[regtime]]', '[[regtime]]'),
(805, 1, 1, 'default_textmarketer_default_textmarketer', 'text_connection_success', 'Connection is successful and API Credentials are configured correctly.', '[[regtime]]', '[[regtime]]'),
(806, 1, 1, 'default_twilio_default_twilio', 'default_twilio_name', 'Twilio', '[[regtime]]', '[[regtime]]'),
(807, 1, 1, 'default_twilio_default_twilio', 'default_twilio_note', 'To enable sms-messaging go to System -> Settings -> <a href="#admin#rt=setting/setting/im" target="_im">IM</a> <br/>\n		and choose Twilio as default sms-driver. Do not forget to enable section where you wish to receive sms from (admin or storefront).<br/>\n		This extension will enable Mobile Phone field for admins and customers to provide. Remember that disabling of this extension will hide this field.\n		If added to existing store with customers, keep in mind that this information will be missing.', '[[regtime]]', '[[regtime]]'),
(808, 1, 1, 'default_twilio_default_twilio', 'default_twilio_username', 'API AccountSID', '[[regtime]]', '[[regtime]]'),
(809, 1, 1, 'default_twilio_default_twilio', 'default_twilio_token', 'API AuthToken', '[[regtime]]', '[[regtime]]'),
(810, 1, 1, 'default_twilio_default_twilio', 'default_twilio_test', 'Test Mode', '[[regtime]]', '[[regtime]]'),
(811, 1, 1, 'default_twilio_default_twilio', 'default_twilio_sender_phone', 'Sender (Twilio) Phone: <span class="help">Phone number of sender in international format (ex. +14158675309)</span>', '[[regtime]]', '[[regtime]]'),
(812, 1, 1, 'default_twilio_default_twilio', 'default_twilio_send_to', 'Send test SMS to: ', '[[regtime]]', '[[regtime]]'),
(813, 1, 1, 'default_twilio_default_twilio', 'default_twilio_test_0', 'No', '[[regtime]]', '[[regtime]]'),
(814, 1, 1, 'default_twilio_default_twilio', 'default_twilio_test_1', 'Yes', '[[regtime]]', '[[regtime]]'),
(815, 1, 1, 'default_twilio_default_twilio', 'default_twilio_test_connection', 'Test Your Connection:<span class="help">You can test if API credentials that you''ve entered are correct.</span>', '[[regtime]]', '[[regtime]]'),
(816, 1, 1, 'default_twilio_default_twilio', 'default_twilio_logging', 'Error Logging Status<span class="help">If you want to log all errors of Twilio extension turn this setting ON.</span>', '[[regtime]]', '[[regtime]]'),
(817, 1, 1, 'default_twilio_default_twilio', 'entry_sms', ' Mobile Phone ', '[[regtime]]', '[[regtime]]'),
(818, 1, 1, 'default_twilio_default_twilio', 'text_test', ' Test ', '[[regtime]]', '[[regtime]]'),
(819, 1, 1, 'default_twilio_default_twilio', 'error_turn_extension_on', 'Error! Please check if extension is turned ON.', '[[regtime]]', '[[regtime]]'),
(820, 1, 1, 'default_twilio_default_twilio', 'text_connection_success', 'Connection is successful and API Credentials are configured correctly.', '[[regtime]]', '[[regtime]]'),
(821, 1, 1, 'default_usps_default_usps', 'default_usps_name', 'United States Postal Service', '[[regtime]]', '[[regtime]]'),
(822, 1, 1, 'default_usps_default_usps', 'text_shipping', ' Shipping', '[[regtime]]', '[[regtime]]'),
(823, 1, 1, 'default_usps_default_usps', 'text_additional_settings', 'USPS Settings', '[[regtime]]', '[[regtime]]'),
(824, 1, 1, 'default_usps_default_usps', 'text_success', 'Success: You have modified United States Postal Service!', '[[regtime]]', '[[regtime]]'),
(825, 1, 1, 'default_usps_default_usps', 'text_international_1', 'Express Mail International', '[[regtime]]', '[[regtime]]'),
(826, 1, 1, 'default_usps_default_usps', 'text_international_2', 'Priority Mail International', '[[regtime]]', '[[regtime]]'),
(827, 1, 1, 'default_usps_default_usps', 'text_international_4', 'Global Express Guaranteed (Document and Non-document)', '[[regtime]]', '[[regtime]]'),
(828, 1, 1, 'default_usps_default_usps', 'text_international_5', 'Global Express Guaranteed Document used', '[[regtime]]', '[[regtime]]'),
(829, 1, 1, 'default_usps_default_usps', 'text_international_6', 'Global Express Guaranteed Non-Document Rectangular shape', '[[regtime]]', '[[regtime]]'),
(830, 1, 1, 'default_usps_default_usps', 'text_international_7', 'Global Express Guaranteed Non-Document Non-Rectangular', '[[regtime]]', '[[regtime]]'),
(831, 1, 1, 'default_usps_default_usps', 'text_international_8', 'Priority Mail Flat Rate Envelope', '[[regtime]]', '[[regtime]]'),
(832, 1, 1, 'default_usps_default_usps', 'text_international_9', 'Priority Mail Flat Rate Box', '[[regtime]]', '[[regtime]]'),
(833, 1, 1, 'default_usps_default_usps', 'text_international_10', 'Express Mail International Flat Rate Envelope', '[[regtime]]', '[[regtime]]'),
(834, 1, 1, 'default_usps_default_usps', 'text_international_11', 'Priority Mail Large Flat Rate Box', '[[regtime]]', '[[regtime]]'),
(835, 1, 1, 'default_usps_default_usps', 'text_international_12', 'Global Express Guaranteed Envelope', '[[regtime]]', '[[regtime]]'),
(836, 1, 1, 'default_usps_default_usps', 'text_international_13', 'First Class Mail International Letters', '[[regtime]]', '[[regtime]]'),
(837, 1, 1, 'default_usps_default_usps', 'text_international_14', 'First Class Mail International Flats', '[[regtime]]', '[[regtime]]'),
(838, 1, 1, 'default_usps_default_usps', 'text_international_15', 'First Class Mail International Parcels', '[[regtime]]', '[[regtime]]'),
(839, 1, 1, 'default_usps_default_usps', 'text_international_16', 'Priority Mail Small Flat Rate Box', '[[regtime]]', '[[regtime]]'),
(840, 1, 1, 'default_usps_default_usps', 'text_international_21', 'Postcards', '[[regtime]]', '[[regtime]]'),
(841, 1, 1, 'default_usps_default_usps', 'text_regular', 'Regular', '[[regtime]]', '[[regtime]]'),
(842, 1, 1, 'default_usps_default_usps', 'text_large', 'Large', '[[regtime]]', '[[regtime]]'),
(843, 1, 1, 'default_usps_default_usps', 'text_oversize', 'Oversize', '[[regtime]]', '[[regtime]]'),
(844, 1, 1, 'default_usps_default_usps', 'text_rectangular', 'Rectangular', '[[regtime]]', '[[regtime]]'),
(845, 1, 1, 'default_usps_default_usps', 'text_non_rectangular', 'Non Rectangular', '[[regtime]]', '[[regtime]]'),
(846, 1, 1, 'default_usps_default_usps', 'text_variable', 'Variable', '[[regtime]]', '[[regtime]]'),
(847, 1, 1, 'default_usps_default_usps', 'entry_user_id', 'User ID:<span class="help">USPS should email you the user id and password. If not contact USPS to confirm your USPS User ID. You should call USPS to activate your account on the production servers.</span>', '[[regtime]]', '[[regtime]]'),
(848, 1, 1, 'default_usps_default_usps', 'entry_password', 'Password:', '[[regtime]]', '[[regtime]]'),
(849, 1, 1, 'default_usps_default_usps', 'entry_postcode', 'Zip Code:<span class="help">Zip/Postal code of the starting location of your package.</span>', '[[regtime]]', '[[regtime]]'),
(850, 1, 1, 'default_usps_default_usps', 'entry_domestic', 'Domestic Services:', '[[regtime]]', '[[regtime]]'),
(851, 1, 1, 'default_usps_default_usps', 'entry_international', 'International Services:', '[[regtime]]', '[[regtime]]'),
(852, 1, 1, 'default_usps_default_usps', 'entry_size', 'Size:<span class="help">Select the container size that you typically use to package the products ordered from your store.</span>', '[[regtime]]', '[[regtime]]'),
(853, 1, 1, 'default_usps_default_usps', 'entry_container', 'Container:<span class="help">Select the container type that you typically use to package the products ordered from your store. USPS will only deliver packages weighing up to 70 lbs</span>', '[[regtime]]', '[[regtime]]'),
(854, 1, 1, 'default_usps_default_usps', 'entry_machinable', 'Machinable:<br /><span class="help"> It is recommended that you select Yes. Specify whether it is OK to handle your shipments by machines. Enabling this option reduces the shipping costs.</span>', '[[regtime]]', '[[regtime]]'),
(855, 1, 1, 'default_usps_default_usps', 'entry_dimension', 'Dimensions (L x W x H):', '[[regtime]]', '[[regtime]]'),
(856, 1, 1, 'default_usps_default_usps', 'entry_length', 'Dimensions Length:<br /><span class="help">Average package dimension for shipping package.</span>', '[[regtime]]', '[[regtime]]'),
(857, 1, 1, 'default_usps_default_usps', 'entry_width', 'Dimensions Width:<br /><span class="help">Average package dimension for shipping package.</span>', '[[regtime]]', '[[regtime]]'),
(858, 1, 1, 'default_usps_default_usps', 'entry_height', 'Dimensions Height:<br /><span class="help">Average package dimension for shipping package.</span>', '[[regtime]]', '[[regtime]]'),
(859, 1, 1, 'default_usps_default_usps', 'entry_girth', 'Girth:<br /><span class="help">To find the girth of your package, measure the distance around the thickest part of the non-rectangular package.</span>', '[[regtime]]', '[[regtime]]'),
(860, 1, 1, 'default_usps_default_usps', 'entry_display_time', 'Display Delivery Time:<br /><span class="help">Do you want to display the shipping time? (e.g. Ships within 3 to 5 days)</span>', '[[regtime]]', '[[regtime]]'),
(861, 1, 1, 'default_usps_default_usps', 'entry_display_weight', 'Display Delivery Weight:<br /><span class="help">Do you want to display the shipping weight? (e.g. Delivery Weight : 2.7674 Kg''s)</span>', '[[regtime]]', '[[regtime]]'),
(862, 1, 1, 'default_usps_default_usps', 'entry_weight_class', 'Weight Class:<br /><span class="help">Set to pounds.</span>', '[[regtime]]', '[[regtime]]'),
(863, 1, 1, 'default_usps_default_usps', 'entry_length_class', 'Length Class:<br /><span class="help">The dimension or default length class of your store.</span>', '[[regtime]]', '[[regtime]]'),
(864, 1, 1, 'default_usps_default_usps', 'entry_tax', 'Tax Class:<br /><span class="help">If you are required to charge tax on this item, select tax class.</span>', '[[regtime]]', '[[regtime]]'),
(865, 1, 1, 'default_usps_default_usps', 'entry_location', 'Location:', '[[regtime]]', '[[regtime]]'),
(866, 1, 1, 'default_usps_default_usps', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(867, 1, 1, 'default_usps_default_usps', 'error_permission', 'Warning: You do not have permission to modify United States Postal Service!', '[[regtime]]', '[[regtime]]'),
(868, 1, 1, 'default_usps_default_usps', 'error_user_id', 'User ID Required!', '[[regtime]]', '[[regtime]]'),
(869, 1, 1, 'default_usps_default_usps', 'error_postcode', 'Zip Code Required!', '[[regtime]]', '[[regtime]]'),
(870, 1, 1, 'default_usps_default_usps', 'entry_free_domestic_method', 'Option for free shipping <span class="help">Please select what method will chosen for case when cart contains only products with free shipping</span>', '[[regtime]]', '[[regtime]]'),
(871, 1, 1, 'default_usps_default_usps', 'entry_free_international_method', 'Option for free shipping of international parcels  <span class="help">Please select what method will chosen for case when cart contains only products with free shipping</span>', '[[regtime]]', '[[regtime]]'),
(872, 1, 1, 'default_usps_default_usps', 'default_usps_debug', 'Debug Logging Status', '[[regtime]]', '[[regtime]]'),
(873, 1, 1, 'default_weight_default_weight', 'default_weight_name', 'Weight Based Shipping', '[[regtime]]', '[[regtime]]'),
(874, 1, 1, 'default_weight_default_weight', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(875, 1, 1, 'default_weight_default_weight', 'text_additional_settings', ' Additional Settings ', '[[regtime]]', '[[regtime]]'),
(876, 1, 1, 'default_weight_default_weight', 'text_success', 'Success: You have modified weight based shipping!', '[[regtime]]', '[[regtime]]'),
(877, 1, 1, 'default_weight_default_weight', 'entry_rate', 'Rates:<br /><span class="help">Example: 5:10.00,7:12.00 Weight:Cost,Weight:Cost, etc. In this example 5 pounds = $10.00. Where Pound is your Store Weight class and $ is Store Base currency. You can change both in the Store Settings</span>', '[[regtime]]', '[[regtime]]'),
(878, 1, 1, 'default_weight_default_weight', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(879, 1, 1, 'default_weight_default_weight', 'entry_tax', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(880, 1, 1, 'default_weight_default_weight', 'entry_location', 'Location:', '[[regtime]]', '[[regtime]]'),
(881, 1, 1, 'default_weight_default_weight', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(882, 1, 1, 'default_weight_default_weight', 'error_permission', 'Warning: You do not have permission to modify weight based shipping!', '[[regtime]]', '[[regtime]]'),
(883, 1, 1, 'default_weight_default_weight', 'example_weight_text', 'Weight: ', '[[regtime]]', '[[regtime]]'),
(884, 1, 1, 'default_weight_default_weight', 'example_currency_text', 'Currency: ', '[[regtime]]', '[[regtime]]'),
(885, 1, 1, 'encryption_data_manager_encryption_data_manager', 'encryption_data_manager_name', 'Encryption Data Manager', '[[regtime]]', '[[regtime]]'),
(886, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_extensions', 'Extensions', '[[regtime]]', '[[regtime]]'),
(887, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_additional_settings', ' Encryption Data Tools ', '[[regtime]]', '[[regtime]]'),
(888, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(889, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(890, 1, 1, 'encryption_data_manager_encryption_data_manager', 'button_generate_keys', 'Generate Key Pair', '[[regtime]]', '[[regtime]]'),
(891, 1, 1, 'encryption_data_manager_encryption_data_manager', 'button_encrypt_data', 'Encrypt Data', '[[regtime]]', '[[regtime]]'),
(892, 1, 1, 'encryption_data_manager_encryption_data_manager', 'error_permission', 'Warning: You do not have permission to modify weight based shipping!', '[[regtime]]', '[[regtime]]'),
(893, 1, 1, 'encryption_data_manager_encryption_data_manager', 'error_duplicate_key', 'Error: Selected key name pair already exists!', '[[regtime]]', '[[regtime]]'),
(894, 1, 1, 'encryption_data_manager_encryption_data_manager', 'encryption_data_manager_note', '  <b>This extension requires ADVANCED configuration and attention</b><br/> \n		  <b>Once enabled and data encrypted, there is NO undo and extension can not be disabled! </b><br/> \n		  This extension helps managing encryption keys creation and data migration from open to encrypted tables (initial migration)<br/> \n		  <b>PLEASE NOTE:</b> you need to have PHP with SSL Encryption  <b>ENABLED</b>\n          <br/>\n          <br/>To enable data encryption please read help instructions (HOW TO button)', '[[regtime]]', '[[regtime]]'),
(895, 1, 1, 'encryption_data_manager_encryption_data_manager', 'error_openssl_disabled', 'Warning: OpenSSL for PHP is not available or not activated. You can not use encryption or this extension! <br> Check HELP for this extension for more details.', '[[regtime]]', '[[regtime]]'),
(896, 1, 1, 'encryption_data_manager_encryption_data_manager', 'error_data_encryption_disabled', 'Warning: Data Encryption is not enabled on your AbanteCart. You can not encrypt/decrypt data using this extension! <br> Check HELP for this extension for more details.', '[[regtime]]', '[[regtime]]'),
(897, 1, 1, 'encryption_data_manager_encryption_data_manager', 'key_gen_section_name', 'Generate Key Pair', '[[regtime]]', '[[regtime]]'),
(898, 1, 1, 'encryption_data_manager_encryption_data_manager', 'data_encryption', 'Encrypt Data', '[[regtime]]', '[[regtime]]'),
(899, 1, 1, 'encryption_data_manager_encryption_data_manager', 'error_required_data_missing', 'Missing required data field(s). Please check provided values', '[[regtime]]', '[[regtime]]'),
(900, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_key_name', 'Unique key pair name:<br /><span class="help">Name should not contain any spaces or special characters. Keeps it short and simple.</span>', '[[regtime]]', '[[regtime]]'),
(901, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_key_length', 'Key length (bits):<br /><span class="help">Specify key encryption bit length. Larger number represent stronger encryption, but can slower performance (Range 256 - 8192 )</span>', '[[regtime]]', '[[regtime]]'),
(902, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_private_key_type', 'Ecncryption type:<br /><span class="help">This is an encryption algorithm. Use default RSA if you are not advanced user.</span>', '[[regtime]]', '[[regtime]]'),
(903, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_encrypt_key', 'Enable password based key:<br /><span class="help">If enable, addtional passphrase will be required to decrypt text with use of private key. NOTE. This is not currently supported in data encryption.</span>', '[[regtime]]', '[[regtime]]'),
(904, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_passphrase', 'Passphrase or key password:<br /><span class="help">Remember the passphrase or key(s) will be useless and data might be lost</span>', '[[regtime]]', '[[regtime]]'),
(905, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_success_key_get', '<b>Key pair has been created. See keys below and keep them safe.</b> <br/><br/> %s <br/><br/> %s ', '[[regtime]]', '[[regtime]]'),
(906, 1, 1, 'encryption_data_manager_encryption_data_manager', 'error_generating_keys_failed', 'Key pair generation failed. Check your settings and check error log.', '[[regtime]]', '[[regtime]]'),
(907, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_enc_key', 'Key pair name:<br /><span class="help">Select key to be used for encryption. IMPORTANT: Remember key that you used</span>', '[[regtime]]', '[[regtime]]'),
(908, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_enc_tables', 'Table(s) to encrypt:<br /><span class="help">Shown table(s) will be encryted with the key selected. Data can only be opened with this key</span>', '[[regtime]]', '[[regtime]]'),
(909, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_enc_test_mode', 'Test Mode:<br /><span class="help">Check first that all is OK to be encrepted.</span>', '[[regtime]]', '[[regtime]]'),
(910, 1, 1, 'encryption_data_manager_encryption_data_manager', 'entry_enc_remove_original', 'Remove source data:<br /><span class="help">Remove source un-encrepted data records after encryption is complete</span>', '[[regtime]]', '[[regtime]]'),
(911, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_success_encrypting', '<b>Data has been encrypted. <br />  See details:</b> <br/><br/> %s <br /><br /> <b>If you want this key to be used for new data encryption, add following line to file system/config.php : define(''DATA_ENCRYPTION_KEYPAIR'', ''%s''); </b> ', '[[regtime]]', '[[regtime]]'),
(912, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_encryption_test', '<b>Data encryption test result</b> Check error log for any possible errors! <br/><br/> %s ', '[[regtime]]', '[[regtime]]'),
(913, 1, 1, 'encryption_data_manager_encryption_data_manager', 'error_encrypting', 'Data encryption failed. Check your settings and check error log.', '[[regtime]]', '[[regtime]]'),
(914, 1, 1, 'encryption_data_manager_encryption_data_manager', 'post_encrypting_notice', '<b>Important notes! After encryption is completed data will be copied to mirror tables with data encrypted in them. \n    		<br />Follow instructions to add configuration to system/config.php for AbanteCart to switch read/write operations to encrypted tables. </b><br /> Add following line to configuration file: define(''DATA_ENCRYPTION_KEYPAIR'', ''your_key_name''); <br> This will be default key for read/write operations ', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(915, 1, 1, 'encryption_data_manager_encryption_data_manager', 'encryption_usage', 'Encryption Usage', '[[regtime]]', '[[regtime]]'),
(916, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_unencrepted_records', 'Un-encrypted data records', '[[regtime]]', '[[regtime]]'),
(917, 1, 1, 'encryption_data_manager_encryption_data_manager', 'warn_encrypt_open_data', 'Use ''Encrypt Data'' Tab for initial encryption', '[[regtime]]', '[[regtime]]'),
(918, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_encrepted_records', 'Encrypted data records', '[[regtime]]', '[[regtime]]'),
(919, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_usage_heading_key_id', 'Key ID', '[[regtime]]', '[[regtime]]'),
(920, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_usage_heading_key_name', 'Key Name', '[[regtime]]', '[[regtime]]'),
(921, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_usage_heading_key_tables', 'Encrypted Tables Usage', '[[regtime]]', '[[regtime]]'),
(922, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_usage_heading_key_rotate', 'Rotate (change) Encryption to new key', '[[regtime]]', '[[regtime]]'),
(923, 1, 1, 'encryption_data_manager_encryption_data_manager', 'text_usage_records', 'record(s)', '[[regtime]]', '[[regtime]]'),
(924, 1, 1, 'novator_novator', 'novator_name', 'novator', '[[regtime]]', '[[regtime]]'),
(925, 1, 1, 'novator_novator', 'novator_note', '', '[[regtime]]', '[[regtime]]'),
(926, 1, 1, 'novator_novator', 'novator_category_form_info_alert', '<div class="alert alert-info">All images following the first one can be used in the ''category slides'' block. (see block in the category page layout)</div>', '[[regtime]]', '[[regtime]]'),
(927, 1, 1, 'page_builder_page_builder', 'page_builder_name', 'Page Builder', '[[regtime]]', '[[regtime]]'),
(928, 1, 1, 'page_builder_page_builder', 'page_builder_logging', 'Logging <span class="help">Enable to save javascript exceptions into AbanteCart error log</span>', '[[regtime]]', '[[regtime]]'),
(929, 1, 1, 'page_builder_page_builder', 'text_select_template', 'Select template: ', '[[regtime]]', '[[regtime]]'),
(930, 1, 1, 'page_builder_page_builder', 'page_builder_text_preset', 'Preset: ', '[[regtime]]', '[[regtime]]'),
(931, 1, 1, 'page_builder_page_builder', 'page_builder_button_load_preset', 'Load Preset', '[[regtime]]', '[[regtime]]'),
(932, 1, 1, 'page_builder_page_builder', 'page_builder_text_load_preset_confirm_text', 'Do you really wish to load preset? Already saved changes will be rewritten.', '[[regtime]]', '[[regtime]]'),
(933, 1, 1, 'page_builder_page_builder', 'page_builder_text_delete_preset_confirm_text', 'Do you really wish to delete preset?', '[[regtime]]', '[[regtime]]'),
(934, 1, 1, 'page_builder_page_builder', 'page_builder_text_select_preset', ' -- please select -- ', '[[regtime]]', '[[regtime]]'),
(935, 1, 1, 'page_builder_page_builder', 'page_builder_text_prompt', 'Please enter preset name:', '[[regtime]]', '[[regtime]]'),
(936, 1, 1, 'page_builder_page_builder', 'page_builder_button_undo_title', ' Rollback to Save Point', '[[regtime]]', '[[regtime]]'),
(937, 1, 1, 'page_builder_page_builder', 'page_builder_button_undo', ' Undo', '[[regtime]]', '[[regtime]]'),
(938, 1, 1, 'page_builder_page_builder', 'page_builder_button_undo_confirm_text', ' Do you really wish to rollback changes to save point state?', '[[regtime]]', '[[regtime]]'),
(939, 1, 1, 'page_builder_page_builder', 'page_builder_undo_success_text', ' Success!', '[[regtime]]', '[[regtime]]'),
(940, 1, 1, 'page_builder_page_builder', 'page_builder_button_publish_title', ' Publish Page on a Storefront', '[[regtime]]', '[[regtime]]'),
(941, 1, 1, 'page_builder_page_builder', 'page_builder_button_publish', ' Publish', '[[regtime]]', '[[regtime]]'),
(942, 1, 1, 'page_builder_page_builder', 'page_builder_button_publish_success', ' Published successfully.', '[[regtime]]', '[[regtime]]'),
(943, 1, 1, 'page_builder_page_builder', 'page_builder_button_remove_custom_page_title', ' Remove Custom page to Default State', '[[regtime]]', '[[regtime]]'),
(944, 1, 1, 'page_builder_page_builder', 'page_builder_button_remove_custom_page', ' Delete Design ', '[[regtime]]', '[[regtime]]'),
(945, 1, 1, 'page_builder_page_builder', 'page_builder_button_remove_custom_page_confirm_text', 'Do you really wish to remove your design? ', '[[regtime]]', '[[regtime]]'),
(946, 1, 1, 'page_builder_page_builder', 'page_builder_remove_custom_page_success_text', 'Page has been successfully removed', '[[regtime]]', '[[regtime]]'),
(947, 1, 1, 'page_builder_page_builder', 'page_builder_save_preset_confirm_text', 'Do you really wish to save preset? ', '[[regtime]]', '[[regtime]]'),
(948, 1, 1, 'page_builder_page_builder', 'page_builder_save_preset_success_text', 'Preset %s has been saved successfully!', '[[regtime]]', '[[regtime]]'),
(949, 1, 1, 'page_builder_page_builder', 'page_builder_remove_preset_success_text', 'Preset %s has been deleted successfully!', '[[regtime]]', '[[regtime]]'),
(950, 1, 1, 'page_builder_page_builder', 'page_builder_text_abantecart_blocks', 'Storefront Blocks', '[[regtime]]', '[[regtime]]'),
(951, 1, 1, 'page_builder_page_builder', 'page_builder_text_basic_blocks', 'Basic', '[[regtime]]', '[[regtime]]'),
(952, 1, 1, 'page_builder_page_builder', 'page_builder_text_extra', 'Extra', '[[regtime]]', '[[regtime]]'),
(953, 1, 1, 'page_builder_page_builder', 'page_builder_text_forms', 'Forms', '[[regtime]]', '[[regtime]]'),
(954, 1, 1, 'page_builder_page_builder', 'page_builder_error_storage_permissions', 'PageBuilder Error: Directory %s does not exist or not writable. Please check permissions!', '[[regtime]]', '[[regtime]]'),
(955, 1, 1, 'page_builder_page_builder', 'page_builder_error_preset_permissions', 'Cannot to delete preset! Please check permissions of file %s', '[[regtime]]', '[[regtime]]'),
(956, 1, 1, 'page_builder_page_builder', 'page_builder_error_empty_preset_name', 'Preset name is empty!', '[[regtime]]', '[[regtime]]'),
(957, 1, 1, 'page_builder_page_builder', 'page_builder_error_route_not_found', 'Current Route not Found! Cannot to save.', '[[regtime]]', '[[regtime]]'),
(958, 1, 1, 'page_builder_page_builder', 'page_builder_error_preset_not_found', 'Preset not Found!', '[[regtime]]', '[[regtime]]'),
(959, 1, 1, 'page_builder_page_builder', 'page_builder_error_remove_page', 'Cannot to delete custom page! Please check permissions of file %s', '[[regtime]]', '[[regtime]]'),
(960, 1, 1, 'page_builder_page_builder', 'page_builder_error_cannot_copy', 'Cannot to copy file %s.json to %s! Please check permissions or existing of target', '[[regtime]]', '[[regtime]]'),
(961, 1, 1, 'page_builder_page_builder', 'page_builder_error_nothing_to_publish', 'Nothing to publish. No any save points found.', '[[regtime]]', '[[regtime]]'),
(962, 1, 1, 'page_builder_page_builder', 'page_builder_error_cannot_undo', 'Rollback is unavailable. Save point not found', '[[regtime]]', '[[regtime]]'),
(963, 1, 1, 'page_builder_page_builder', 'page_builder_error_cannot_save', 'Cannot save changes. Please check permissions for directory %s', '[[regtime]]', '[[regtime]]'),
(964, 1, 1, 'page_builder_page_builder', 'page_builder_tab_title', 'To start building a page, please create the layout first.', '[[regtime]]', '[[regtime]]'),
(965, 1, 1, 'page_builder_page_builder', 'page_builder_text_already_published', 'This page is already published by Page Builder.', '[[regtime]]', '[[regtime]]'),
(966, 1, 1, 'page_builder_page_builder', 'page_builder_text_can_try', '...or this page can be customized with Page Builder.', '[[regtime]]', '[[regtime]]'),
(967, 1, 1, 'page_builder_page_builder', 'page_builder_button_click_to_edit_page', 'Click to Edit page', '[[regtime]]', '[[regtime]]'),
(968, 1, 1, 'page_builder_page_builder', 'page_builder_button_click_to_try', 'Click to Try', '[[regtime]]', '[[regtime]]'),
(969, 1, 1, 'paypal_commerce_paypal_commerce', 'text_title', 'Credit Card / Debit Card (Via Paypal)', '[[regtime]]', '[[regtime]]'),
(970, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_name', 'Paypal Commerce', '[[regtime]]', '[[regtime]]'),
(971, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_manual_connect', '&nbsp;', '[[regtime]]', '[[regtime]]'),
(972, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_client_id', 'Your API Client ID<br /><span class="help">Locate this in My Apps & Credentials Section Of Paypal Dashboard -> Developer</span>', '[[regtime]]', '[[regtime]]'),
(973, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_client_secret', 'Your API Secret Key<br /><span class="help">Locate this in My Apps & Credentials Section Of Paypal Dashboard -> Developer</span>', '[[regtime]]', '[[regtime]]'),
(974, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_test_mode', 'Test mode:<br /><span class="help">Set to ON if you want to use test key</span>', '[[regtime]]', '[[regtime]]'),
(975, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_transaction_type', 'Transaction Method:<br/><span class="help">PayPal transaction to run at customer''s checkout before order status is set. Authorization only or capture.</span>', '[[regtime]]', '[[regtime]]'),
(976, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_transaction_type_capture', 'Capture', '[[regtime]]', '[[regtime]]'),
(977, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_transaction_type_authorize', 'Authorize Only', '[[regtime]]', '[[regtime]]'),
(978, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_test_connection', 'Test Connection', '[[regtime]]', '[[regtime]]'),
(979, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_text_test', 'Test Now', '[[regtime]]', '[[regtime]]'),
(980, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_text_update_webhooks', 'Update Webhooks', '[[regtime]]', '[[regtime]]'),
(981, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_tooltip_update_webhooks', ' Webhooks will be set up automatically during connection to PayPal. Use this button to update webhooks in PayPal ', '[[regtime]]', '[[regtime]]'),
(982, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_connection_success', 'Connection has been established successfully.', '[[regtime]]', '[[regtime]]'),
(983, 1, 1, 'paypal_commerce_paypal_commerce', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(984, 1, 1, 'paypal_commerce_paypal_commerce', 'text_success', 'Success: You have modified Paypal payment settings!', '[[regtime]]', '[[regtime]]'),
(985, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(986, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(987, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(988, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_autoselect', 'Auto Select:<br /><span class="help">You can set to skip payment selection page if there is only one payment option. This payment method will be selected automatically</span>', '[[regtime]]', '[[regtime]]'),
(989, 1, 1, 'paypal_commerce_paypal_commerce', 'text_paypal_commerce_connect', 'You need to connect with paypal to set up payment details', '[[regtime]]', '[[regtime]]'),
(990, 1, 1, 'paypal_commerce_paypal_commerce', 'text_paypal_commerce_settings', 'Paypal settings', '[[regtime]]', '[[regtime]]'),
(991, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(992, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_text_register_webhooks', 'Update Webhooks Endpoints on API side', '[[regtime]]', '[[regtime]]'),
(993, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_text_register_webhooks_success', 'Webhooks Endpoints has been updated successfully!', '[[regtime]]', '[[regtime]]'),
(994, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_status_success_settled', 'Success & captured:<br /><span class="help">Select main order status you want to set in response to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(995, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_status_success_unsettled', 'Success & not captured:<br /><span class="help">Select main order status you want to set in response to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(996, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_status_decline', 'Decline:<br /><span class="help">Order status you want to record in history in response to payment processor status. Main order status is not affected. Order will not be placed only after payment is a success.</span>', '[[regtime]]', '[[regtime]]'),
(997, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_status_capture_pending', 'Pending:</span>', '[[regtime]]', '[[regtime]]'),
(998, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_status_refund', 'Refunded:<br /><span class="help">Order status you want to be set if payment is refunded in admin/order.</span>', '[[regtime]]', '[[regtime]]'),
(999, 1, 1, 'paypal_commerce_paypal_commerce', 'text_column_date_added', 'Transaction Date', '[[regtime]]', '[[regtime]]'),
(1000, 1, 1, 'paypal_commerce_paypal_commerce', 'text_column_amount', 'Amount', '[[regtime]]', '[[regtime]]'),
(1001, 1, 1, 'paypal_commerce_paypal_commerce', 'text_captured_ok', 'Funds were captured successfully', '[[regtime]]', '[[regtime]]'),
(1002, 1, 1, 'paypal_commerce_paypal_commerce', 'text_captured_order', 'Capture was successful, order status updated to success - captured', '[[regtime]]', '[[regtime]]'),
(1003, 1, 1, 'paypal_commerce_paypal_commerce', 'text_refunded_ok', 'Refund was processed successfully', '[[regtime]]', '[[regtime]]'),
(1004, 1, 1, 'paypal_commerce_paypal_commerce', 'text_refund_order', 'Refund was successful, order status updated to refunded', '[[regtime]]', '[[regtime]]'),
(1005, 1, 1, 'paypal_commerce_paypal_commerce', 'text_voided', 'Void was successful, order status updated to voided', '[[regtime]]', '[[regtime]]'),
(1006, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_settlement_auto', 'Auto (authorize and capture)', '[[regtime]]', '[[regtime]]'),
(1007, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_settlement_delayed', 'Delayed (authorize only)', '[[regtime]]', '[[regtime]]'),
(1008, 1, 1, 'paypal_commerce_paypal_commerce', 'text_payment_info', 'Payment Details', '[[regtime]]', '[[regtime]]'),
(1009, 1, 1, 'paypal_commerce_paypal_commerce', 'text_capture_status', 'Payment was captured', '[[regtime]]', '[[regtime]]'),
(1010, 1, 1, 'paypal_commerce_paypal_commerce', 'text_void_status', 'Payment was voided', '[[regtime]]', '[[regtime]]'),
(1011, 1, 1, 'paypal_commerce_paypal_commerce', 'text_refund_status', 'Payment was refunded', '[[regtime]]', '[[regtime]]'),
(1012, 1, 1, 'paypal_commerce_paypal_commerce', 'text_capture_amount', 'Capture Amount', '[[regtime]]', '[[regtime]]'),
(1013, 1, 1, 'paypal_commerce_paypal_commerce', 'text_refund_amount', 'Refund Amount', '[[regtime]]', '[[regtime]]'),
(1014, 1, 1, 'paypal_commerce_paypal_commerce', 'text_order_ref', 'Paypal Charge ID', '[[regtime]]', '[[regtime]]'),
(1015, 1, 1, 'paypal_commerce_paypal_commerce', 'text_order_total', 'Total amount authorized', '[[regtime]]', '[[regtime]]'),
(1016, 1, 1, 'paypal_commerce_paypal_commerce', 'text_balance', 'Balance amount', '[[regtime]]', '[[regtime]]'),
(1017, 1, 1, 'paypal_commerce_paypal_commerce', 'text_transactions', 'Refund Transactions', '[[regtime]]', '[[regtime]]'),
(1018, 1, 1, 'paypal_commerce_paypal_commerce', 'text_confirm_void', 'Please confirm you want to void the payment?', '[[regtime]]', '[[regtime]]'),
(1019, 1, 1, 'paypal_commerce_paypal_commerce', 'text_confirm_capture', 'Please confirm you want to capture the payment?', '[[regtime]]', '[[regtime]]'),
(1020, 1, 1, 'paypal_commerce_paypal_commerce', 'text_confirm_refund', 'Please confirm you want to refund the payment?', '[[regtime]]', '[[regtime]]'),
(1021, 1, 1, 'paypal_commerce_paypal_commerce', 'button_refund', 'Refund', '[[regtime]]', '[[regtime]]'),
(1022, 1, 1, 'paypal_commerce_paypal_commerce', 'button_void', 'Void', '[[regtime]]', '[[regtime]]'),
(1023, 1, 1, 'paypal_commerce_paypal_commerce', 'button_capture', 'Capture', '[[regtime]]', '[[regtime]]'),
(1024, 1, 1, 'paypal_commerce_paypal_commerce', 'error_system', 'Internal error. Check error log or input parameters!', '[[regtime]]', '[[regtime]]'),
(1025, 1, 1, 'paypal_commerce_paypal_commerce', 'error_missing_amount', 'Please enter positive amount', '[[regtime]]', '[[regtime]]'),
(1026, 1, 1, 'paypal_commerce_paypal_commerce', 'error_unable_to_capture', 'Unable to capture, refresh transaction details and check capture amount', '[[regtime]]', '[[regtime]]'),
(1027, 1, 1, 'paypal_commerce_paypal_commerce', 'error_unable_to_void', 'Unable to void transaction, refresh and check transaction details', '[[regtime]]', '[[regtime]]'),
(1028, 1, 1, 'paypal_commerce_paypal_commerce', 'error_unable_to_refund', 'Unable to refund, refresh transaction details and check refund amount', '[[regtime]]', '[[regtime]]'),
(1029, 1, 1, 'paypal_commerce_paypal_commerce', 'text_connect', 'Connect with Paypal', '[[regtime]]', '[[regtime]]'),
(1030, 1, 1, 'paypal_commerce_paypal_commerce', 'text_disconnect', 'Disconnect Paypal', '[[regtime]]', '[[regtime]]'),
(1031, 1, 1, 'paypal_commerce_paypal_commerce', 'text_skip_connect', 'Cannot connect?', '[[regtime]]', '[[regtime]]'),
(1032, 1, 1, 'paypal_commerce_paypal_commerce', 'text_connect_success', 'Connected to Paypal successfully', '[[regtime]]', '[[regtime]]'),
(1033, 1, 1, 'paypal_commerce_paypal_commerce', 'text_disconnect_success', 'Disconnected from Paypal successfully', '[[regtime]]', '[[regtime]]'),
(1034, 1, 1, 'paypal_commerce_paypal_commerce', 'error_permission', 'Warning: You do not have permission to modify Paypal Commerce Payment!', '[[regtime]]', '[[regtime]]'),
(1035, 1, 1, 'paypal_commerce_paypal_commerce', 'error_paypal_commerce_client_id', 'App Client ID is required', '[[regtime]]', '[[regtime]]'),
(1036, 1, 1, 'paypal_commerce_paypal_commerce', 'error_paypal_commerce_client_secret', 'App Secret key is required', '[[regtime]]', '[[regtime]]'),
(1037, 1, 1, 'paypal_commerce_paypal_commerce', 'error_turn_extension_on', 'Error! Please check if extension is turned ON.', '[[regtime]]', '[[regtime]]'),
(1038, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_text_back', 'Back', '[[regtime]]', '[[regtime]]'),
(1039, 1, 1, 'paypal_commerce_paypal_commerce', 'paypal_commerce_webhook_howto_text', 'Note: To complete setup you should to create webhooks on Paypal Account Side.\n<br> Go to Your <a href="https://dashboard.paypal.com/webhooks" target="_new">Paypal Dashboard Developer Section</a>\nand Add Endpoints receiving events from your account. After Endpoint has been created copy Signing Secret and save into Paypal Subscription Extension settings belong.', '[[regtime]]', '[[regtime]]'),
(1040, 1, 1, 'stripe_stripe', 'stripe_name', 'Stripe Payment', '[[regtime]]', '[[regtime]]'),
(1041, 1, 1, 'stripe_stripe', 'stripe_note', 'Additional settings are required to complete Stripe payment setup. See additional settings tab.', '[[regtime]]', '[[regtime]]'),
(1042, 1, 1, 'stripe_stripe', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(1043, 1, 1, 'stripe_stripe', 'text_success', 'Success: You have modified Stripe payment settings!', '[[regtime]]', '[[regtime]]'),
(1044, 1, 1, 'stripe_stripe', 'stripe_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(1045, 1, 1, 'stripe_stripe', 'stripe_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(1046, 1, 1, 'stripe_stripe', 'stripe_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(1047, 1, 1, 'stripe_stripe', 'stripe_published_key', 'Published Key:', '[[regtime]]', '[[regtime]]'),
(1048, 1, 1, 'stripe_stripe', 'stripe_autoselect', 'Auto Select:<br /><span class="help">You can set to skip payment selection page if there is only one payment option. This payment method will be selected automatically</span>', '[[regtime]]', '[[regtime]]'),
(1049, 1, 1, 'stripe_stripe', 'stripe_payment_method_list', 'Allowed payment methods. <br /><span class="help">Leave empty for automatic selection</span>', '[[regtime]]', '[[regtime]]'),
(1050, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_card', 'Cards', '[[regtime]]', '[[regtime]]'),
(1051, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_klarna', 'Klarna', '[[regtime]]', '[[regtime]]'),
(1052, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_acss_debit', 'ACSS', '[[regtime]]', '[[regtime]]'),
(1053, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_afterpay_clearpay', 'Afterpay/Clearpay', '[[regtime]]', '[[regtime]]'),
(1054, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_alipay', 'Alipay', '[[regtime]]', '[[regtime]]'),
(1055, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_au_becs_debit', 'BECS Direct Debit', '[[regtime]]', '[[regtime]]'),
(1056, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_bacs_debit', 'Bacs Direct Debit', '[[regtime]]', '[[regtime]]'),
(1057, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_affirm', 'Affirm', '[[regtime]]', '[[regtime]]'),
(1058, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_bancontact', 'Bancontact', '[[regtime]]', '[[regtime]]'),
(1059, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_blik', 'Blik', '[[regtime]]', '[[regtime]]'),
(1060, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_boleto', 'Boleto', '[[regtime]]', '[[regtime]]'),
(1061, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_interac_present', 'Interac', '[[regtime]]', '[[regtime]]'),
(1062, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_pix', 'Pix', '[[regtime]]', '[[regtime]]'),
(1063, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_revolut_pay', 'Revolut Pay', '[[regtime]]', '[[regtime]]'),
(1064, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_swish', 'Swish', '[[regtime]]', '[[regtime]]'),
(1065, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_mobilepay', 'MobilePay', '[[regtime]]', '[[regtime]]'),
(1066, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_zip', 'Zip', '[[regtime]]', '[[regtime]]'),
(1067, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_eps', 'EPS', '[[regtime]]', '[[regtime]]'),
(1068, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_fpx', 'FPX', '[[regtime]]', '[[regtime]]'),
(1069, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_giropay', 'giropay', '[[regtime]]', '[[regtime]]'),
(1070, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_grabpay', 'Grabpay', '[[regtime]]', '[[regtime]]'),
(1071, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_ideal', 'iDEAL', '[[regtime]]', '[[regtime]]'),
(1072, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_konbini', 'Konbini', '[[regtime]]', '[[regtime]]'),
(1073, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_link', 'Link', '[[regtime]]', '[[regtime]]'),
(1074, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_oxxo', 'OXXO', '[[regtime]]', '[[regtime]]'),
(1075, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_sofort', 'Sofort', '[[regtime]]', '[[regtime]]'),
(1076, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_p24', 'Przelewy24', '[[regtime]]', '[[regtime]]'),
(1077, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_paynow', 'PayNow', '[[regtime]]', '[[regtime]]'),
(1078, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_promptpay', 'PromptPay', '[[regtime]]', '[[regtime]]'),
(1079, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_sepa_debit', 'SEPA Direct Debit', '[[regtime]]', '[[regtime]]'),
(1080, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_us_bank_account', 'ACH Direct Debit', '[[regtime]]', '[[regtime]]'),
(1081, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_wechat_pay', 'WeChat Pay', '[[regtime]]', '[[regtime]]'),
(1082, 1, 1, 'stripe_stripe', 'stripe_payment_method_list_twint', 'TWINT', '[[regtime]]', '[[regtime]]'),
(1083, 1, 1, 'stripe_stripe', 'text_stripe_connect', 'You need to connect with stripe to set up payment details', '[[regtime]]', '[[regtime]]'),
(1084, 1, 1, 'stripe_stripe', 'text_stripe_settings', 'Stripe settings', '[[regtime]]', '[[regtime]]'),
(1085, 1, 1, 'stripe_stripe', 'text_connect', 'Connect with Stripe', '[[regtime]]', '[[regtime]]'),
(1086, 1, 1, 'stripe_stripe', 'text_disconnect', 'Disconnect Stripe', '[[regtime]]', '[[regtime]]'),
(1087, 1, 1, 'stripe_stripe', 'text_skip_connect', 'Cannot connect?', '[[regtime]]', '[[regtime]]'),
(1088, 1, 1, 'stripe_stripe', 'text_connect_success', 'Connected to Stripe successfully', '[[regtime]]', '[[regtime]]'),
(1089, 1, 1, 'stripe_stripe', 'text_disconnect_success', 'Disconnected from Stripe successfully', '[[regtime]]', '[[regtime]]'),
(1090, 1, 1, 'stripe_stripe', 'stripe_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(1091, 1, 1, 'stripe_stripe', 'stripe_test_mode', 'Test mode:<br /><span class="help">Set to ON if you want to use test key</span>', '[[regtime]]', '[[regtime]]'),
(1092, 1, 1, 'stripe_stripe', 'stripe_sk_live', 'Live Secret Key:<br /><span class="help">Locate this in Stripe API Keys Section. Key starts with sk_live_... </span>', '[[regtime]]', '[[regtime]]'),
(1093, 1, 1, 'stripe_stripe', 'stripe_pk_live', 'Live Publishable Key:<br /><span class="help">Locate this in Stripe API Keys Section. Key starts with pk_live_... </span>', '[[regtime]]', '[[regtime]]'),
(1094, 1, 1, 'stripe_stripe', 'stripe_sk_test', 'Test Secret Key:<br /><span class="help">Locate this in Stripe API Keys Section. Key starts with sk_test_... </span>', '[[regtime]]', '[[regtime]]'),
(1095, 1, 1, 'stripe_stripe', 'stripe_pk_test', 'Test Publishable Key:<br /><span class="help">Locate this in Stripe API Keys Section. Key starts with pk_test_... </span>', '[[regtime]]', '[[regtime]]'),
(1096, 1, 1, 'stripe_stripe', 'stripe_settlement', 'Settlement type:<br /><span class="help">If set to ''auto'', then the transaction will be included in today''s settlement. If set to ''delayed'', then the transaction will be authorised but not settled(captured). You must manually capture transactions within 7 days of authorisation</span>', '[[regtime]]', '[[regtime]]'),
(1097, 1, 1, 'stripe_stripe', 'stripe_status_success_settled', 'Success & settled:<br /><span class="help">Select main order status you want to set in response to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(1098, 1, 1, 'stripe_stripe', 'stripe_status_success_unsettled', 'Success & not settled:<br /><span class="help">Select main order status you want to set in response to payment processor status</span>', '[[regtime]]', '[[regtime]]'),
(1099, 1, 1, 'stripe_stripe', 'stripe_status_decline', 'Decline:<br /><span class="help">Order status you want to record in history in response to payment processor status. Main order status is not affected. Order will not be placed only after payment is a success.</span>', '[[regtime]]', '[[regtime]]'),
(1100, 1, 1, 'stripe_stripe', 'stripe_status_void', 'Voided:<br /><span class="help">Order status you want to be set if payment is voided in admin/order.</span>', '[[regtime]]', '[[regtime]]'),
(1101, 1, 1, 'stripe_stripe', 'stripe_status_refund', 'Refunded:<br /><span class="help">Order status you want to be set if payment is refunded in admin/order.</span>', '[[regtime]]', '[[regtime]]'),
(1102, 1, 1, 'stripe_stripe', 'text_column_date_added', 'Transaction Date', '[[regtime]]', '[[regtime]]'),
(1103, 1, 1, 'stripe_stripe', 'text_column_amount', 'Amount', '[[regtime]]', '[[regtime]]'),
(1104, 1, 1, 'stripe_stripe', 'text_captured_ok', 'Funds were captured successfully', '[[regtime]]', '[[regtime]]'),
(1105, 1, 1, 'stripe_stripe', 'text_captured_order', 'Capture was successful, order status updated to success - settled', '[[regtime]]', '[[regtime]]'),
(1106, 1, 1, 'stripe_stripe', 'text_refunded_ok', 'Refund was processed successfully', '[[regtime]]', '[[regtime]]'),
(1107, 1, 1, 'stripe_stripe', 'text_refund_order', 'Refund was successful, order status updated to refunded', '[[regtime]]', '[[regtime]]'),
(1108, 1, 1, 'stripe_stripe', 'text_voided', 'Void was successful, order status updated to voided', '[[regtime]]', '[[regtime]]'),
(1109, 1, 1, 'stripe_stripe', 'stripe_settlement_auto', 'Auto (authorize and capture)', '[[regtime]]', '[[regtime]]'),
(1110, 1, 1, 'stripe_stripe', 'stripe_settlement_delayed', 'Delayed (authorize only)', '[[regtime]]', '[[regtime]]'),
(1111, 1, 1, 'stripe_stripe', 'text_payment_info', 'Payment Details', '[[regtime]]', '[[regtime]]'),
(1112, 1, 1, 'stripe_stripe', 'text_capture_status', 'Payment was captured', '[[regtime]]', '[[regtime]]'),
(1113, 1, 1, 'stripe_stripe', 'text_void_status', 'Payment was voided', '[[regtime]]', '[[regtime]]'),
(1114, 1, 1, 'stripe_stripe', 'text_refund_status', 'Payment was refunded', '[[regtime]]', '[[regtime]]'),
(1115, 1, 1, 'stripe_stripe', 'text_capture_amount', 'Capture Amount', '[[regtime]]', '[[regtime]]'),
(1116, 1, 1, 'stripe_stripe', 'text_refund_amount', 'Refund Amount', '[[regtime]]', '[[regtime]]'),
(1117, 1, 1, 'stripe_stripe', 'text_order_ref', 'Stripe Charge ID', '[[regtime]]', '[[regtime]]'),
(1118, 1, 1, 'stripe_stripe', 'text_order_total', 'Total amount authorized', '[[regtime]]', '[[regtime]]'),
(1119, 1, 1, 'stripe_stripe', 'text_balance', 'Balance amount', '[[regtime]]', '[[regtime]]'),
(1120, 1, 1, 'stripe_stripe', 'text_transactions', 'Refund Transactions', '[[regtime]]', '[[regtime]]'),
(1121, 1, 1, 'stripe_stripe', 'text_confirm_void', 'Please confirm you want to void the payment?', '[[regtime]]', '[[regtime]]'),
(1122, 1, 1, 'stripe_stripe', 'text_confirm_capture', 'Please confirm you want to capture the payment?', '[[regtime]]', '[[regtime]]'),
(1123, 1, 1, 'stripe_stripe', 'text_confirm_refund', 'Please confirm you want to refund the payment?', '[[regtime]]', '[[regtime]]'),
(1124, 1, 1, 'stripe_stripe', 'button_refund', 'Refund', '[[regtime]]', '[[regtime]]'),
(1125, 1, 1, 'stripe_stripe', 'button_void', 'Void', '[[regtime]]', '[[regtime]]'),
(1126, 1, 1, 'stripe_stripe', 'button_capture', 'Capture', '[[regtime]]', '[[regtime]]'),
(1127, 1, 1, 'stripe_stripe', 'error_system', 'Internal error. Check error log or input parameters!', '[[regtime]]', '[[regtime]]'),
(1128, 1, 1, 'stripe_stripe', 'error_missing_amount', 'Please enter positive amount', '[[regtime]]', '[[regtime]]'),
(1129, 1, 1, 'stripe_stripe', 'error_unable_to_capture', 'Unable to capture, refresh transaction details and check capture amount', '[[regtime]]', '[[regtime]]'),
(1130, 1, 1, 'stripe_stripe', 'error_unable_to_void', 'Unable to void transaction, refresh and check transaction details', '[[regtime]]', '[[regtime]]'),
(1131, 1, 1, 'stripe_stripe', 'error_unable_to_refund', 'Unable to refund, refresh transaction details and check refund amount', '[[regtime]]', '[[regtime]]'),
(1132, 1, 1, 'stripe_stripe', 'error_stripe_pk_test', 'Stripe Published key is required', '[[regtime]]', '[[regtime]]'),
(1133, 1, 1, 'stripe_stripe', 'error_stripe_pk_live', 'Stripe Published key is required', '[[regtime]]', '[[regtime]]'),
(1134, 1, 1, 'stripe_stripe', 'error_stripe_sk_test', 'Stripe test key is required', '[[regtime]]', '[[regtime]]'),
(1135, 1, 1, 'stripe_stripe', 'error_stripe_sk_live', 'Stripe live key is required', '[[regtime]]', '[[regtime]]'),
(1136, 1, 1, 'stripe_stripe', 'error_permission', 'Warning: You do not have permission to modify Stripe Payment!', '[[regtime]]', '[[regtime]]'),
(1137, 1, 1, 'stripe_stripe', 'stripe_webhook_howto_text', 'Note: To complete setup you should to create webhooks on Stripe Account Side.\n<br> Go to Your <a href="https://dashboard.stripe.com/webhooks" target="_new">Stripe Dashboard Developer Section</a>\nand Add Endpoints receiving events from your account. After Endpoint has been created copy Signing Secret and save into Stripe Subscription Extension settings belong.', '[[regtime]]', '[[regtime]]'),
(1138, 1, 1, 'stripe_stripe', 'stripe_entry_endpoint_url', 'Endpoint URL:', '[[regtime]]', '[[regtime]]'),
(1139, 1, 1, 'stripe_stripe', 'stripe_entry_endpoint_signing_secret', 'Endpoint Signing Secret:', '[[regtime]]', '[[regtime]]'),
(1140, 1, 1, 'ups_ups', 'ups_name', 'United Parcel Service', '[[regtime]]', '[[regtime]]'),
(1141, 1, 1, 'ups_ups', 'heading_title', 'UPS', '[[regtime]]', '[[regtime]]'),
(1142, 1, 1, 'ups_ups', 'ups_account_number', 'Account(Shipper) Number', '[[regtime]]', '[[regtime]]'),
(1143, 1, 1, 'ups_ups', 'ups_client_id', 'API Client ID<br/><span class="help">You can find it in your application section on https://developer.ups.com/apps </span>', '[[regtime]]', '[[regtime]]'),
(1144, 1, 1, 'ups_ups', 'ups_password', 'API Password<br/><span class="help">You can find it in your application section on https://developer.ups.com/apps </span>', '[[regtime]]', '[[regtime]]'),
(1145, 1, 1, 'ups_ups', 'ups_validate_address', 'Address Validation', '[[regtime]]', '[[regtime]]'),
(1146, 1, 1, 'ups_ups', 'ups_country', 'Shipper Country & Zone', '[[regtime]]', '[[regtime]]'),
(1147, 1, 1, 'ups_ups', 'ups_telephone', 'Shipper Phone Number (10 digits or more)', '[[regtime]]', '[[regtime]]'),
(1148, 1, 1, 'ups_ups', 'ups_address', 'Shipper Address', '[[regtime]]', '[[regtime]]'),
(1149, 1, 1, 'ups_ups', 'ups_city', 'Shipper City', '[[regtime]]', '[[regtime]]'),
(1150, 1, 1, 'ups_ups', 'ups_postcode', 'Shipper Postal Code', '[[regtime]]', '[[regtime]]'),
(1151, 1, 1, 'ups_ups', 'ups_weight_code', 'Weight Code:<br /><span class="help">Allowed kgs, lbs.</span>', '[[regtime]]', '[[regtime]]'),
(1152, 1, 1, 'ups_ups', 'ups_test_connection', 'Test Connection', '[[regtime]]', '[[regtime]]'),
(1153, 1, 1, 'ups_ups', 'ups_length_code', 'Length Code:<br /><span class="help">Allowed inches or centimeters.</span>', '[[regtime]]', '[[regtime]]'),
(1154, 1, 1, 'ups_ups', 'ups_tax_class_id', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(1155, 1, 1, 'ups_ups', 'ups_tax_class_id_0', '-- None --', '[[regtime]]', '[[regtime]]'),
(1156, 1, 1, 'ups_ups', 'ups_location_id', 'Location:', '[[regtime]]', '[[regtime]]'),
(1157, 1, 1, 'ups_ups', 'ups_location_id_0', 'All Locations', '[[regtime]]', '[[regtime]]'),
(1158, 1, 1, 'ups_ups', 'ups_default_weight', 'Default Product Weight:<br /><span class="help">Weight of products if not set</span>', '[[regtime]]', '[[regtime]]'),
(1159, 1, 1, 'ups_ups', 'ups_default_length', 'Default Product Length:<br /><span class="help">Length of product if not set</span>', '[[regtime]]', '[[regtime]]'),
(1160, 1, 1, 'ups_ups', 'ups_default_width', 'Default  Product Width:<br /><span class="help">Width of product if not set</span>', '[[regtime]]', '[[regtime]]'),
(1161, 1, 1, 'ups_ups', 'ups_default_height', 'Default  Product Height:<br /><span class="help">Height of product if not set</span>', '[[regtime]]', '[[regtime]]'),
(1162, 1, 1, 'ups_ups', 'ups_packaging', 'Packaging', '[[regtime]]', '[[regtime]]'),
(1163, 1, 1, 'ups_ups', 'ups_packaging_02', 'Box', '[[regtime]]', '[[regtime]]'),
(1164, 1, 1, 'catalog_attribute', 'heading_title', 'Global Attributes', '[[regtime]]', '[[regtime]]'),
(1165, 1, 1, 'catalog_attribute', 'text_attribute', 'Global Attribute', '[[regtime]]', '[[regtime]]'),
(1166, 1, 1, 'catalog_attribute', 'text_success', 'Success: You have modified attributes!', '[[regtime]]', '[[regtime]]'),
(1167, 1, 1, 'catalog_attribute', 'text_select_type', '- Select Type -', '[[regtime]]', '[[regtime]]'),
(1168, 1, 1, 'catalog_attribute', 'text_select_parent', '- Select Parent -', '[[regtime]]', '[[regtime]]'),
(1169, 1, 1, 'catalog_attribute', 'column_name', 'Name', '[[regtime]]', '[[regtime]]'),
(1170, 1, 1, 'catalog_attribute', 'column_type', 'Type', '[[regtime]]', '[[regtime]]'),
(1171, 1, 1, 'catalog_attribute', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(1172, 1, 1, 'catalog_attribute', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1173, 1, 1, 'catalog_attribute', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(1174, 1, 1, 'catalog_attribute', 'column_txt_id', 'Unique Text ID', '[[regtime]]', '[[regtime]]'),
(1175, 1, 1, 'catalog_attribute', 'entry_name', 'Name:', '[[regtime]]', '[[regtime]]'),
(1176, 1, 1, 'catalog_attribute', 'entry_attribute_parent', 'Attribute Parent:', '[[regtime]]', '[[regtime]]'),
(1177, 1, 1, 'catalog_attribute', 'entry_attribute_group', 'Attribute Group:', '[[regtime]]', '[[regtime]]'),
(1178, 1, 1, 'catalog_attribute', 'entry_attribute_type', 'Attribute Type:', '[[regtime]]', '[[regtime]]'),
(1179, 1, 1, 'catalog_attribute', 'entry_element_type', 'Element Type:', '[[regtime]]', '[[regtime]]'),
(1180, 1, 1, 'catalog_attribute', 'entry_element_values', 'Element Values:', '[[regtime]]', '[[regtime]]'),
(1181, 1, 1, 'catalog_attribute', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(1182, 1, 1, 'catalog_attribute', 'entry_required', 'Required:', '[[regtime]]', '[[regtime]]'),
(1183, 1, 1, 'catalog_attribute', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(1184, 1, 1, 'catalog_attribute', 'entry_children_attributes', 'Children Attributes:', '[[regtime]]', '[[regtime]]'),
(1185, 1, 1, 'catalog_attribute', 'error_permission', 'Warning: You do not have permission to modify global attributes!', '[[regtime]]', '[[regtime]]'),
(1186, 1, 1, 'catalog_attribute', 'error_name', 'Group Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(1187, 1, 1, 'catalog_attribute', 'error_required', 'This field is required!', '[[regtime]]', '[[regtime]]'),
(1188, 1, 1, 'catalog_attribute', 'text_parent_note', 'If this is a parent attribute with children attributes, it can only be of type SelectBox, MultiSelect Box, Checkbox and Checkbox group.<br>Children values combination will be shown as one set.', '[[regtime]]', '[[regtime]]'),
(1189, 1, 1, 'catalog_attribute', 'entry_allowed_extensions', 'Allowed File Extensions (txt, jpg …)', '[[regtime]]', '[[regtime]]'),
(1190, 1, 1, 'catalog_attribute', 'entry_min_size', 'Min file size (Kb)', '[[regtime]]', '[[regtime]]'),
(1191, 1, 1, 'catalog_attribute', 'entry_max_size', 'Max file size (Kb)', '[[regtime]]', '[[regtime]]'),
(1192, 1, 1, 'catalog_attribute', 'entry_upload_dir', 'Upload directory name<br>%s', '[[regtime]]', '[[regtime]]'),
(1193, 1, 1, 'catalog_attribute', 'entry_regexp_pattern', 'Regular Expression Pattern for Validation of Values:', '[[regtime]]', '[[regtime]]'),
(1194, 1, 1, 'catalog_attribute', 'entry_error_text', 'Error Message of invalid Value:', '[[regtime]]', '[[regtime]]'),
(1195, 1, 1, 'catalog_attribute', 'entry_placeholder', 'Placeholder:', '[[regtime]]', '[[regtime]]'),
(1196, 1, 1, 'catalog_attribute', 'error_attribute_name', 'Attribute Name must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(1197, 1, 1, 'catalog_attribute', 'error_error_text', 'Error text about invalid attribute value must be between 2 and 255 characters!', '[[regtime]]', '[[regtime]]'),
(1198, 1, 1, 'catalog_attribute', 'error_regexp_pattern', 'Regular Expression Pattern is invalid!', '[[regtime]]', '[[regtime]]'),
(1199, 1, 1, 'catalog_attribute', 'entry_show_to_customer', 'Show to Customer', '[[regtime]]', '[[regtime]]'),
(1200, 1, 1, 'catalog_attribute', 'entry_price_prefix', 'Modify Price By:', '[[regtime]]', '[[regtime]]'),
(1201, 1, 1, 'catalog_attribute', 'entry_price_modifier', 'Price Modifier:', '[[regtime]]', '[[regtime]]'),
(1202, 1, 1, 'catalog_attribute', 'error_not_unique', 'Value Text ID is not unique!', '[[regtime]]', '[[regtime]]'),
(1203, 1, 1, 'catalog_attribute_groups', 'heading_title', 'Global Attribute Groups', '[[regtime]]', '[[regtime]]'),
(1204, 1, 1, 'catalog_attribute_groups', 'text_group', 'Attribute Group', '[[regtime]]', '[[regtime]]'),
(1205, 1, 1, 'catalog_attribute_groups', 'text_success', 'Success: You have modified groups!', '[[regtime]]', '[[regtime]]'),
(1206, 1, 1, 'catalog_attribute_groups', 'column_name', 'Group Name', '[[regtime]]', '[[regtime]]'),
(1207, 1, 1, 'catalog_attribute_groups', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(1208, 1, 1, 'catalog_attribute_groups', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1209, 1, 1, 'catalog_attribute_groups', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(1210, 1, 1, 'catalog_attribute_groups', 'entry_name', 'Group Name:', '[[regtime]]', '[[regtime]]'),
(1211, 1, 1, 'catalog_attribute_groups', 'entry_sort_order', 'Group Sort Order:', '[[regtime]]', '[[regtime]]'),
(1212, 1, 1, 'catalog_attribute_groups', 'entry_status', 'Group Status:', '[[regtime]]', '[[regtime]]'),
(1213, 1, 1, 'catalog_attribute_groups', 'error_permission', 'Warning: You do not have permission to modify attribute groups!', '[[regtime]]', '[[regtime]]'),
(1214, 1, 1, 'catalog_attribute_groups', 'error_name', 'Group Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(1215, 1, 1, 'catalog_category', 'heading_title', 'Categories', '[[regtime]]', '[[regtime]]'),
(1216, 1, 1, 'catalog_category', 'text_category', 'Category', '[[regtime]]', '[[regtime]]'),
(1217, 1, 1, 'catalog_category', 'text_success', 'Success: You have modified categories!', '[[regtime]]', '[[regtime]]'),
(1218, 1, 1, 'catalog_category', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(1219, 1, 1, 'catalog_category', 'text_image_manager', 'Image Manager', '[[regtime]]', '[[regtime]]'),
(1220, 1, 1, 'catalog_category', 'update_title', 'Update Category', '[[regtime]]', '[[regtime]]'),
(1221, 1, 1, 'catalog_category', 'column_image', 'Image', '[[regtime]]', '[[regtime]]'),
(1222, 1, 1, 'catalog_category', 'column_name', 'Category Name', '[[regtime]]', '[[regtime]]'),
(1223, 1, 1, 'catalog_category', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(1224, 1, 1, 'catalog_category', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1225, 1, 1, 'catalog_category', 'column_products', 'Products count', '[[regtime]]', '[[regtime]]'),
(1226, 1, 1, 'catalog_category', 'column_subcategories', 'Subcategories count', '[[regtime]]', '[[regtime]]'),
(1227, 1, 1, 'catalog_category', 'entry_name', 'Category Name:', '[[regtime]]', '[[regtime]]'),
(1228, 1, 1, 'catalog_category', 'entry_meta_keywords', 'Meta Tag Keywords:', '[[regtime]]', '[[regtime]]'),
(1229, 1, 1, 'catalog_category', 'entry_meta_description', 'Meta Tag Description:', '[[regtime]]', '[[regtime]]'),
(1230, 1, 1, 'catalog_category', 'entry_description', 'Description:', '[[regtime]]', '[[regtime]]'),
(1231, 1, 1, 'catalog_category', 'entry_status', 'Category Status:', '[[regtime]]', '[[regtime]]'),
(1232, 1, 1, 'catalog_category', 'entry_parent_category', 'Parent Category:', '[[regtime]]', '[[regtime]]'),
(1233, 1, 1, 'catalog_category', 'entry_store', 'Stores:', '[[regtime]]', '[[regtime]]'),
(1234, 1, 1, 'catalog_category', 'entry_keyword', 'SEO Keyword:', '[[regtime]]', '[[regtime]]'),
(1235, 1, 1, 'catalog_category', 'entry_image', 'Image:', '[[regtime]]', '[[regtime]]'),
(1236, 1, 1, 'catalog_category', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(1237, 1, 1, 'catalog_category', 'error_permission', 'Warning: You do not have permission to modify categories!', '[[regtime]]', '[[regtime]]'),
(1238, 1, 1, 'catalog_category', 'error_name', 'Category Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(1239, 1, 1, 'catalog_category', 'error_required_data', 'Required Data has not been entered. Check for field errors!', '[[regtime]]', '[[regtime]]'),
(1240, 1, 1, 'catalog_category', 'text_select_all', '- All Categories -', '[[regtime]]', '[[regtime]]'),
(1241, 1, 1, 'catalog_category', 'text_top_level', '- Top Level -', '[[regtime]]', '[[regtime]]'),
(1242, 1, 1, 'catalog_category', 'text_select_parent', '- Select Parent -', '[[regtime]]', '[[regtime]]'),
(1243, 1, 1, 'catalog_category', 'text_success_layout', 'Success: You have modified category page layout.', '[[regtime]]', '[[regtime]]'),
(1244, 1, 1, 'catalog_category', 'tab_image', 'Images', '[[regtime]]', '[[regtime]]'),
(1245, 1, 1, 'catalog_collections', 'heading_title', 'Collections', '[[regtime]]', '[[regtime]]'),
(1246, 1, 1, 'catalog_collections', 'collection_column_name', 'Collection Name', '[[regtime]]', '[[regtime]]'),
(1247, 1, 1, 'catalog_collections', 'collection_column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1248, 1, 1, 'catalog_collections', 'collection_column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(1249, 1, 1, 'catalog_collections', 'entry_name', 'Collection Name:', '[[regtime]]', '[[regtime]]'),
(1250, 1, 1, 'catalog_collections', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(1251, 1, 1, 'catalog_collections', 'entry_description', 'Internal description:', '[[regtime]]', '[[regtime]]'),
(1252, 1, 1, 'catalog_collections', 'save_error_name', 'Collection Name is required.', '[[regtime]]', '[[regtime]]'),
(1253, 1, 1, 'catalog_collections', 'collection_new', 'New Collection', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(1254, 1, 1, 'catalog_collections', 'collection_update', 'Update Collection', '[[regtime]]', '[[regtime]]'),
(1255, 1, 1, 'catalog_collections', 'conditions_title', 'Conditions:', '[[regtime]]', '[[regtime]]'),
(1256, 1, 1, 'catalog_collections', 'text_if_1', 'If:', '[[regtime]]', '[[regtime]]'),
(1257, 1, 1, 'catalog_collections', 'text_all', 'All', '[[regtime]]', '[[regtime]]'),
(1258, 1, 1, 'catalog_collections', 'text_any', 'Any', '[[regtime]]', '[[regtime]]'),
(1259, 1, 1, 'catalog_collections', 'text_if_2', 'of these conditions are', '[[regtime]]', '[[regtime]]'),
(1260, 1, 1, 'catalog_collections', 'text_true', 'True', '[[regtime]]', '[[regtime]]'),
(1261, 1, 1, 'catalog_collections', 'text_false', 'False', '[[regtime]]', '[[regtime]]'),
(1262, 1, 1, 'catalog_collections', 'entry_condition_object', 'Add Condition:', '[[regtime]]', '[[regtime]]'),
(1263, 1, 1, 'catalog_collections', 'text_product_price', 'Product Price', '[[regtime]]', '[[regtime]]'),
(1264, 1, 1, 'catalog_collections', 'text_categories', 'Categories', '[[regtime]]', '[[regtime]]'),
(1265, 1, 1, 'catalog_collections', 'text_brands', 'Brands', '[[regtime]]', '[[regtime]]'),
(1266, 1, 1, 'catalog_collections', 'text_products', 'Products', '[[regtime]]', '[[regtime]]'),
(1267, 1, 1, 'catalog_collections', 'text_tags', 'Tags', '[[regtime]]', '[[regtime]]'),
(1268, 1, 1, 'catalog_collections', 'entry_categories', 'Categories:', '[[regtime]]', '[[regtime]]'),
(1269, 1, 1, 'catalog_collections', 'text_in', 'In', '[[regtime]]', '[[regtime]]'),
(1270, 1, 1, 'catalog_collections', 'text_not_in', 'Not in', '[[regtime]]', '[[regtime]]'),
(1271, 1, 1, 'catalog_collections', 'text_select_category', '-Select Category-', '[[regtime]]', '[[regtime]]'),
(1272, 1, 1, 'catalog_collections', 'entry_product_price', 'Product Price:', '[[regtime]]', '[[regtime]]'),
(1273, 1, 1, 'catalog_collections', 'text_equal', 'Equal', '[[regtime]]', '[[regtime]]'),
(1274, 1, 1, 'catalog_collections', 'text_not_equal', 'Not Equal', '[[regtime]]', '[[regtime]]'),
(1275, 1, 1, 'catalog_collections', 'text_equal_or_less', 'Equal or Less', '[[regtime]]', '[[regtime]]'),
(1276, 1, 1, 'catalog_collections', 'text_equal_or_greater', 'Equal or Greater', '[[regtime]]', '[[regtime]]'),
(1277, 1, 1, 'catalog_collections', 'text_greater', 'Greater', '[[regtime]]', '[[regtime]]'),
(1278, 1, 1, 'catalog_collections', 'text_less', 'Less', '[[regtime]]', '[[regtime]]'),
(1279, 1, 1, 'catalog_collections', 'entry_brands', 'Brands:', '[[regtime]]', '[[regtime]]'),
(1280, 1, 1, 'catalog_collections', 'entry_products', 'Products:', '[[regtime]]', '[[regtime]]'),
(1281, 1, 1, 'catalog_collections', 'entry_tags', 'Tags:', '[[regtime]]', '[[regtime]]'),
(1282, 1, 1, 'catalog_collections', 'text_select_tags', '-Select Tag-', '[[regtime]]', '[[regtime]]'),
(1283, 1, 1, 'catalog_collections', 'text_select_tag', '-Select Tag-', '[[regtime]]', '[[regtime]]'),
(1284, 1, 1, 'catalog_collections', 'save_complete', 'Save Complete', '[[regtime]]', '[[regtime]]'),
(1285, 1, 1, 'catalog_collections', 'entry_meta_keywords', 'Meta Keywords:', '[[regtime]]', '[[regtime]]'),
(1286, 1, 1, 'catalog_collections', 'entry_meta_description', 'Meta Description:', '[[regtime]]', '[[regtime]]'),
(1287, 1, 1, 'catalog_collections', 'entry_keyword', 'SEO Keyword:', '[[regtime]]', '[[regtime]]'),
(1288, 1, 1, 'catalog_collections', 'tab_design', 'Design', '[[regtime]]', '[[regtime]]'),
(1289, 1, 1, 'catalog_collections', 'text_collection', 'Collection', '[[regtime]]', '[[regtime]]'),
(1290, 1, 1, 'catalog_collections', 'text_success_layout', 'Layout Save Complete', '[[regtime]]', '[[regtime]]'),
(1291, 1, 1, 'catalog_collections', 'entry_title', 'Title:', '[[regtime]]', '[[regtime]]'),
(1292, 1, 1, 'catalog_collections', 'entry_products_count', 'Products Count:', '[[regtime]]', '[[regtime]]'),
(1293, 1, 1, 'catalog_collections', 'entry_collection_id', 'Select Collection:', '[[regtime]]', '[[regtime]]'),
(1294, 1, 1, 'catalog_collections', 'save_error_unique_keyword', 'Keyword must be unique!', '[[regtime]]', '[[regtime]]'),
(1295, 1, 1, 'catalog_download', 'heading_title', 'Shared Downloads', '[[regtime]]', '[[regtime]]'),
(1296, 1, 1, 'catalog_download', 'text_download', 'Shared Download', '[[regtime]]', '[[regtime]]'),
(1297, 1, 1, 'catalog_download', 'insert_title', 'Insert Download', '[[regtime]]', '[[regtime]]'),
(1298, 1, 1, 'catalog_download', 'update_title', 'Update Download', '[[regtime]]', '[[regtime]]'),
(1299, 1, 1, 'catalog_download', 'text_success', 'Success: You have modified downloads!', '[[regtime]]', '[[regtime]]'),
(1300, 1, 1, 'catalog_download', 'column_name', 'Download Name', '[[regtime]]', '[[regtime]]'),
(1301, 1, 1, 'catalog_download', 'column_remaining', 'Total Downloads Allowed', '[[regtime]]', '[[regtime]]'),
(1302, 1, 1, 'catalog_download', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(1303, 1, 1, 'catalog_download', 'entry_name', 'Download Name:', '[[regtime]]', '[[regtime]]'),
(1304, 1, 1, 'catalog_download', 'entry_filename', 'Filename:', '[[regtime]]', '[[regtime]]'),
(1305, 1, 1, 'catalog_download', 'entry_remaining', 'Total Downloads Allowed:', '[[regtime]]', '[[regtime]]'),
(1306, 1, 1, 'catalog_download', 'entry_update', 'Push to Previous Customers:<br /><span class="help">Check this to update previously purchased versions as well.</span>', '[[regtime]]', '[[regtime]]'),
(1307, 1, 1, 'catalog_download', 'error_permission', 'Warning: You do not have permission to modify downloads!', '[[regtime]]', '[[regtime]]'),
(1308, 1, 1, 'catalog_download', 'error_name', 'Name must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(1309, 1, 1, 'catalog_download', 'error_file', 'Please set the file for download.', '[[regtime]]', '[[regtime]]'),
(1310, 1, 1, 'catalog_download', 'error_product', 'Warning: This download cannot be deleted as it is currently assigned to %s products!', '[[regtime]]', '[[regtime]]'),
(1311, 1, 1, 'catalog_download', 'column_image', 'Image', '[[regtime]]', '[[regtime]]'),
(1312, 1, 1, 'catalog_download', 'column_products_count', 'Products Count', '[[regtime]]', '[[regtime]]'),
(1313, 1, 1, 'catalog_files', 'heading_title', 'Product Files', '[[regtime]]', '[[regtime]]'),
(1314, 1, 1, 'catalog_files', 'text_product', 'Product', '[[regtime]]', '[[regtime]]'),
(1315, 1, 1, 'catalog_files', 'text_edit_product_file', 'Edit Product File', '[[regtime]]', '[[regtime]]'),
(1316, 1, 1, 'catalog_files', 'tab_files', 'Files', '[[regtime]]', '[[regtime]]'),
(1317, 1, 1, 'catalog_files', 'tab_general', 'General', '[[regtime]]', '[[regtime]]'),
(1318, 1, 1, 'catalog_files', 'tab_attributes', 'Download Attributes', '[[regtime]]', '[[regtime]]'),
(1319, 1, 1, 'catalog_files', 'entry_file_icon', 'File Icon', '[[regtime]]', '[[regtime]]'),
(1320, 1, 1, 'catalog_files', 'entry_status', ' Status', '[[regtime]]', '[[regtime]]'),
(1321, 1, 1, 'catalog_files', 'entry_resource', ' Resource', '[[regtime]]', '[[regtime]]'),
(1322, 1, 1, 'catalog_files', 'entry_name', ' Name', '[[regtime]]', '[[regtime]]'),
(1323, 1, 1, 'catalog_files', 'entry_download_name', 'Download Name', '[[regtime]]', '[[regtime]]'),
(1324, 1, 1, 'catalog_files', 'entry_mask', 'Download mask <span class="help">Filename alias for customer download output</span>', '[[regtime]]', '[[regtime]]'),
(1325, 1, 1, 'catalog_files', 'entry_file_full_path', 'File Server Path ', '[[regtime]]', '[[regtime]]'),
(1326, 1, 1, 'catalog_files', 'entry_file_max_downloads', 'Max Download', '[[regtime]]', '[[regtime]]'),
(1327, 1, 1, 'catalog_files', 'entry_file_sort_order', 'Sort order', '[[regtime]]', '[[regtime]]'),
(1328, 1, 1, 'catalog_files', 'entry_file_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1329, 1, 1, 'catalog_files', 'entry_also_mapped_to', 'Shared With', '[[regtime]]', '[[regtime]]'),
(1330, 1, 1, 'catalog_files', 'entry_file_push_to_customers', 'Push to customers', '[[regtime]]', '[[regtime]]'),
(1331, 1, 1, 'catalog_files', 'entry_file_activation', 'Activation Mode', '[[regtime]]', '[[regtime]]'),
(1332, 1, 1, 'catalog_files', 'text_add_file', 'Add File', '[[regtime]]', '[[regtime]]'),
(1333, 1, 1, 'catalog_files', 'text_new_file', 'Add New File', '[[regtime]]', '[[regtime]]'),
(1334, 1, 1, 'catalog_files', 'text_download_attributes', 'Download Attributes', '[[regtime]]', '[[regtime]]'),
(1335, 1, 1, 'catalog_files', 'text_download_information', 'General', '[[regtime]]', '[[regtime]]'),
(1336, 1, 1, 'catalog_files', 'entry_date_added', 'Added on ', '[[regtime]]', '[[regtime]]'),
(1337, 1, 1, 'catalog_files', 'entry_date_modified', 'Modified ', '[[regtime]]', '[[regtime]]'),
(1338, 1, 1, 'catalog_files', 'entry_max_downloads', 'Max downloads <span class="help">Count of downloads allowed for customer</span>', '[[regtime]]', '[[regtime]]'),
(1339, 1, 1, 'catalog_files', 'entry_activate', 'Activated<span class="help">Download will be activates on the event selected.<br>Example: Immediately. Download is activate  after order is placed, regardless of the order status</span>', '[[regtime]]', '[[regtime]]'),
(1340, 1, 1, 'catalog_files', 'entry_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(1341, 1, 1, 'catalog_files', 'entry_expire_days', 'Expire days<span class="help">Count of days from date of purchase</span>', '[[regtime]]', '[[regtime]]'),
(1342, 1, 1, 'catalog_files', 'text_before_order', 'Before Order', '[[regtime]]', '[[regtime]]'),
(1343, 1, 1, 'catalog_files', 'text_immediately', 'Immediately', '[[regtime]]', '[[regtime]]'),
(1344, 1, 1, 'catalog_files', 'text_on_order_status', 'on Order Status', '[[regtime]]', '[[regtime]]'),
(1345, 1, 1, 'catalog_files', 'text_manually', 'Manually', '[[regtime]]', '[[regtime]]'),
(1346, 1, 1, 'catalog_files', 'text_success_download_save', 'Success: You have modified file! ', '[[regtime]]', '[[regtime]]'),
(1347, 1, 1, 'catalog_files', 'error_download_exists', 'Error: Cannot to update download because it does not exists in database! ', '[[regtime]]', '[[regtime]]'),
(1348, 1, 1, 'catalog_files', 'error_download_name', 'Error: Download name must have length between 2 and 128 characters! ', '[[regtime]]', '[[regtime]]'),
(1349, 1, 1, 'catalog_files', 'error_max_downloads', 'Error: maximum downloads count must be greater 0! ', '[[regtime]]', '[[regtime]]'),
(1350, 1, 1, 'catalog_files', 'error_activate', 'Error: select action for activation of download! ', '[[regtime]]', '[[regtime]]'),
(1351, 1, 1, 'catalog_files', 'error_order_status', 'Error: select order status for activation of download! ', '[[regtime]]', '[[regtime]]'),
(1352, 1, 1, 'catalog_files', 'error_download_attributes', 'Download Attributes Error(s):', '[[regtime]]', '[[regtime]]'),
(1353, 1, 1, 'catalog_files', 'text_shared_downloads', 'Shared Downloads', '[[regtime]]', '[[regtime]]'),
(1354, 1, 1, 'catalog_files', 'text_create_download', 'Create new download', '[[regtime]]', '[[regtime]]'),
(1355, 1, 1, 'catalog_files', 'text_path', 'Relative path to file', '[[regtime]]', '[[regtime]]'),
(1356, 1, 1, 'catalog_files', 'text_preview', 'Preview', '[[regtime]]', '[[regtime]]'),
(1357, 1, 1, 'catalog_files', 'entry_shared', 'Shared Download', '[[regtime]]', '[[regtime]]'),
(1358, 1, 1, 'catalog_files', 'text_assign', ' Save ', '[[regtime]]', '[[regtime]]'),
(1359, 1, 1, 'catalog_files', 'text_assigned_to', 'Also assigned to: ', '[[regtime]]', '[[regtime]]'),
(1360, 1, 1, 'catalog_files', 'text_select_shared_downloads', 'Select shared downloads', '[[regtime]]', '[[regtime]]'),
(1361, 1, 1, 'catalog_files', 'error_selected_downloads', 'Warning: Please select the shared downloads for assign.', '[[regtime]]', '[[regtime]]'),
(1362, 1, 1, 'catalog_files', 'text_map_success', 'Success: You have assigned shared downloads to product!', '[[regtime]]', '[[regtime]]'),
(1363, 1, 1, 'catalog_files', 'text_delete_or_refuse', 'delete or refuse (for shared)', '[[regtime]]', '[[regtime]]'),
(1364, 1, 1, 'catalog_files', 'text_confirm_delete', 'Confirm download delete/refuse', '[[regtime]]', '[[regtime]]'),
(1365, 1, 1, 'catalog_files', 'text_success_remove', 'Success: product files list changed!', '[[regtime]]', '[[regtime]]'),
(1366, 1, 1, 'catalog_files', 'text_push', 'Push', '[[regtime]]', '[[regtime]]'),
(1367, 1, 1, 'catalog_files', 'text_push_to_customers', 'Push to Customers', '[[regtime]]', '[[regtime]]'),
(1368, 1, 1, 'catalog_files', 'text_push_to_orders', 'Push Download to %s Orders', '[[regtime]]', '[[regtime]]'),
(1369, 1, 1, 'catalog_files', 'success_push_to_orders', 'Success: Download was pushed  to %s order(s) successfully', '[[regtime]]', '[[regtime]]'),
(1370, 1, 1, 'catalog_files', 'text_no_download_attributes_yet', ' No download attributes yet. <a href="%s" target="_blank">Click to add</a>', '[[regtime]]', '[[regtime]]'),
(1371, 1, 1, 'catalog_files', 'text_confirm_push', ' Confirm? ', '[[regtime]]', '[[regtime]]'),
(1372, 1, 1, 'catalog_files', 'error_downloads_disabled', 'Warning: Downloads are disabled in store settings. <a href="#admin#rt=setting/setting&active=general" target="new">Click to Edit</a>!', '[[regtime]]', '[[regtime]]'),
(1373, 1, 1, 'catalog_files', 'error_permission', 'Warning: You do not have permission to modify product files!', '[[regtime]]', '[[regtime]]'),
(1374, 1, 1, 'catalog_files', 'error_file', 'Please set the file for download.', '[[regtime]]', '[[regtime]]'),
(1375, 1, 1, 'catalog_files', 'attention_shared', 'You are about to edit shared download. Edit will effect other products.', '[[regtime]]', '[[regtime]]'),
(1376, 1, 1, 'catalog_files', 'text_shared_with', 'Shared with:', '[[regtime]]', '[[regtime]]'),
(1377, 1, 1, 'catalog_manufacturer', 'heading_title', 'Brands', '[[regtime]]', '[[regtime]]'),
(1378, 1, 1, 'catalog_manufacturer', 'text_manufacturer', 'Brand', '[[regtime]]', '[[regtime]]'),
(1379, 1, 1, 'catalog_manufacturer', 'text_success', 'Success: You have modified brands!', '[[regtime]]', '[[regtime]]'),
(1380, 1, 1, 'catalog_manufacturer', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(1381, 1, 1, 'catalog_manufacturer', 'text_image_manager', 'Image Manager', '[[regtime]]', '[[regtime]]'),
(1382, 1, 1, 'catalog_manufacturer', 'column_name', 'Brand Name', '[[regtime]]', '[[regtime]]'),
(1383, 1, 1, 'catalog_manufacturer', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(1384, 1, 1, 'catalog_manufacturer', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(1385, 1, 1, 'catalog_manufacturer', 'column_products', 'Products count', '[[regtime]]', '[[regtime]]'),
(1386, 1, 1, 'catalog_manufacturer', 'entry_name', 'Brand Name:', '[[regtime]]', '[[regtime]]'),
(1387, 1, 1, 'catalog_manufacturer', 'entry_store', 'Stores:', '[[regtime]]', '[[regtime]]'),
(1388, 1, 1, 'catalog_manufacturer', 'entry_keyword', 'SEO Keyword:', '[[regtime]]', '[[regtime]]'),
(1389, 1, 1, 'catalog_manufacturer', 'entry_edit', 'Edit', '[[regtime]]', '[[regtime]]'),
(1390, 1, 1, 'catalog_manufacturer', 'entry_image', 'Image:', '[[regtime]]', '[[regtime]]'),
(1391, 1, 1, 'catalog_manufacturer', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(1392, 1, 1, 'catalog_manufacturer', 'error_manufacturer_not_found', 'Error: Brand not found!', '[[regtime]]', '[[regtime]]'),
(1393, 1, 1, 'catalog_manufacturer', 'error_permission', 'Warning: You do not have permission to modify brands!', '[[regtime]]', '[[regtime]]'),
(1394, 1, 1, 'catalog_manufacturer', 'error_name', 'Brand Name must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(1395, 1, 1, 'catalog_manufacturer', 'error_product', 'Warning: This brand cannot be deleted as it is currently assigned to %s products!', '[[regtime]]', '[[regtime]]'),
(1396, 1, 1, 'catalog_manufacturer', 'text_success_layout', 'Success: You have modified category page layout.', '[[regtime]]', '[[regtime]]'),
(1397, 1, 1, 'catalog_product', 'heading_title', 'Products', '[[regtime]]', '[[regtime]]'),
(1398, 1, 1, 'catalog_product', 'text_product', 'Product', '[[regtime]]', '[[regtime]]'),
(1399, 1, 1, 'catalog_product', 'tab_media', 'Media', '[[regtime]]', '[[regtime]]'),
(1400, 1, 1, 'catalog_product', 'tab_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(1401, 1, 1, 'catalog_product', 'tab_files', 'Files', '[[regtime]]', '[[regtime]]'),
(1402, 1, 1, 'catalog_product', 'tab_relations', 'Relations', '[[regtime]]', '[[regtime]]'),
(1403, 1, 1, 'catalog_product', 'tab_promotions', 'Promotions', '[[regtime]]', '[[regtime]]'),
(1404, 1, 1, 'catalog_product', 'tab_extensions', 'Extensions', '[[regtime]]', '[[regtime]]'),
(1405, 1, 1, 'catalog_product', 'text_success', 'Success: You have modified products!', '[[regtime]]', '[[regtime]]'),
(1406, 1, 1, 'catalog_product', 'text_success_copy', 'Success: You have successfully cloned product <b>%s</b>!', '[[regtime]]', '[[regtime]]'),
(1407, 1, 1, 'catalog_product', 'text_success_copy_layout', ' Note: Custom product layout has been cloned as well.', '[[regtime]]', '[[regtime]]'),
(1408, 1, 1, 'catalog_product', 'text_error_copy', 'Cloning has failed! Original product is not available', '[[regtime]]', '[[regtime]]'),
(1409, 1, 1, 'catalog_product', 'text_plus', '+', '[[regtime]]', '[[regtime]]'),
(1410, 1, 1, 'catalog_product', 'text_minus', '-', '[[regtime]]', '[[regtime]]'),
(1411, 1, 1, 'catalog_product', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(1412, 1, 1, 'catalog_product', 'text_product_summary', 'Product Summary', '[[regtime]]', '[[regtime]]'),
(1413, 1, 1, 'catalog_product', 'text_image_manager', 'Image Manager', '[[regtime]]', '[[regtime]]'),
(1414, 1, 1, 'catalog_product', 'text_option', 'Option', '[[regtime]]', '[[regtime]]'),
(1415, 1, 1, 'catalog_product', 'text_option_value', 'Option Value', '[[regtime]]', '[[regtime]]'),
(1416, 1, 1, 'catalog_product', 'column_name', 'Product Name', '[[regtime]]', '[[regtime]]'),
(1417, 1, 1, 'catalog_product', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(1418, 1, 1, 'catalog_product', 'column_sku', 'SKU', '[[regtime]]', '[[regtime]]'),
(1419, 1, 1, 'catalog_product', 'column_image', 'Image', '[[regtime]]', '[[regtime]]'),
(1420, 1, 1, 'catalog_product', 'column_quantity', 'Quantity', '[[regtime]]', '[[regtime]]'),
(1421, 1, 1, 'catalog_product', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1422, 1, 1, 'catalog_product', 'column_price', 'Price', '[[regtime]]', '[[regtime]]'),
(1423, 1, 1, 'catalog_product', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(1424, 1, 1, 'catalog_product', 'entry_featured', 'Featured Product:', '[[regtime]]', '[[regtime]]'),
(1425, 1, 1, 'catalog_product', 'entry_name', 'Product Name:', '[[regtime]]', '[[regtime]]'),
(1426, 1, 1, 'catalog_product', 'entry_meta_keywords', 'Meta Tag Keywords:', '[[regtime]]', '[[regtime]]'),
(1427, 1, 1, 'catalog_product', 'entry_meta_description', 'Meta Tag Description:', '[[regtime]]', '[[regtime]]'),
(1428, 1, 1, 'catalog_product', 'entry_description', 'Description:', '[[regtime]]', '[[regtime]]'),
(1429, 1, 1, 'catalog_product', 'entry_blurb', 'Blurb:', '[[regtime]]', '[[regtime]]'),
(1430, 1, 1, 'catalog_product', 'entry_store', 'Stores:', '[[regtime]]', '[[regtime]]'),
(1431, 1, 1, 'catalog_product', 'entry_keyword', 'SEO Keyword:<br/><span class="help">SEO key that will show in URL for this product. You can generate key from product name</span>', '[[regtime]]', '[[regtime]]'),
(1432, 1, 1, 'catalog_product', 'entry_model', 'Model:', '[[regtime]]', '[[regtime]]'),
(1433, 1, 1, 'catalog_product', 'entry_sku', 'SKU:', '[[regtime]]', '[[regtime]]'),
(1434, 1, 1, 'catalog_product', 'entry_location', 'Misc Location:', '[[regtime]]', '[[regtime]]'),
(1435, 1, 1, 'catalog_product', 'entry_manufacturer', 'Brand:', '[[regtime]]', '[[regtime]]'),
(1436, 1, 1, 'catalog_product', 'entry_shipping', 'Requires Shipping:', '[[regtime]]', '[[regtime]]'),
(1437, 1, 1, 'catalog_product', 'entry_ship_individually', 'Ship Product Individually:<br/><span class="help">Product will be shipped in a separate package and additional shipping cost will be added to the order with multiple items. If enabled, Fixed Shipping Price needs to be set.</span>', '[[regtime]]', '[[regtime]]'),
(1438, 1, 1, 'catalog_product', 'entry_shipping_price', 'Fixed Shipping Price:<br/><span class="help">Master setting with fixed shipping price for this product.</span>', '[[regtime]]', '[[regtime]]'),
(1439, 1, 1, 'catalog_product', 'entry_free_shipping', 'Free Shipping:<br/><span class="help">Master setting to enable free shipping for this product.</span>', '[[regtime]]', '[[regtime]]'),
(1440, 1, 1, 'catalog_product', 'entry_date_available', 'Date Available:', '[[regtime]]', '[[regtime]]'),
(1441, 1, 1, 'catalog_product', 'entry_option_quantity', 'Quantity:', '[[regtime]]', '[[regtime]]'),
(1442, 1, 1, 'catalog_product', 'entry_quantity', 'Quantity:<br/><span class="help">Connected to Track Stock setting</span>', '[[regtime]]', '[[regtime]]'),
(1443, 1, 1, 'catalog_product', 'entry_minimum', 'Minimum Quantity:<br/><span class="help">Force a minimum ordered amount</span>', '[[regtime]]', '[[regtime]]'),
(1444, 1, 1, 'catalog_product', 'entry_maximum', 'Maximum Quantity:<br/><span class="help">Set a limit on quantity that can be selected per each order. 0 = no limit</span>', '[[regtime]]', '[[regtime]]'),
(1445, 1, 1, 'catalog_product', 'entry_stock_status', 'Pre-Order Stock Status:<br/><span class="help">Text shown when a product is out of stock and purchase allowed</span>', '[[regtime]]', '[[regtime]]'),
(1446, 1, 1, 'catalog_product', 'entry_stock_checkout', 'Stock Checkout:<br /><span class="help">Allow customers to checkout even if the products are out of stock.</span>', '[[regtime]]', '[[regtime]]'),
(1447, 1, 1, 'catalog_product', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(1448, 1, 1, 'catalog_product', 'entry_tax_class', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(1449, 1, 1, 'catalog_product', 'entry_cost', 'Cost:<br/><span class="help">The wholesale cost used for profit reporting</span>', '[[regtime]]', '[[regtime]]'),
(1450, 1, 1, 'catalog_product', 'entry_price', 'Price:', '[[regtime]]', '[[regtime]]'),
(1451, 1, 1, 'catalog_product', 'entry_product_option_cost', 'Actual Cost (total):<span class="help">Enter the actual cost (total) of this product option.</span>', '[[regtime]]', '[[regtime]]'),
(1452, 1, 1, 'catalog_product', 'entry_track_option_stock', 'Track Stock:', '[[regtime]]', '[[regtime]]'),
(1453, 1, 1, 'catalog_product', 'entry_subtract', 'Track Stock:<br/><span class="help">Set YES if you need to track stock quantity for this product. If options are used check subtract setting for each option value</span>', '[[regtime]]', '[[regtime]]'),
(1454, 1, 1, 'catalog_product', 'entry_weight_class', 'Weight Class:', '[[regtime]]', '[[regtime]]'),
(1455, 1, 1, 'catalog_product', 'entry_weight', 'Weight:', '[[regtime]]', '[[regtime]]'),
(1456, 1, 1, 'catalog_product', 'entry_weight_change', 'Weight: <span class="help">Important! If value provided as %(percent) option weight will be changed by specified percent based on the main product weight. If weight value provided it will be used as absolute value for the option, main weight will be ignored.</span>', '[[regtime]]', '[[regtime]]'),
(1457, 1, 1, 'catalog_product', 'entry_length_class', 'Length Class:', '[[regtime]]', '[[regtime]]'),
(1458, 1, 1, 'catalog_product', 'entry_length', 'Product package length: <span class="help">The package dimension refers to the size of the box, pouch, or parcel that your item will be shipped in</span>', '[[regtime]]', '[[regtime]]'),
(1459, 1, 1, 'catalog_product', 'entry_width', 'Product package Width: <span class="help">The package dimension refers to the size of the box, pouch, or parcel that your item will be shipped in</span>', '[[regtime]]', '[[regtime]]'),
(1460, 1, 1, 'catalog_product', 'entry_height', 'Product package Height:<span class="help">The package dimension refers to the size of the box, pouch, or parcel that your item will be shipped in</span>', '[[regtime]]', '[[regtime]]'),
(1461, 1, 1, 'catalog_product', 'entry_dimension', 'Dimensions (L x W x H):', '[[regtime]]', '[[regtime]]'),
(1462, 1, 1, 'catalog_product', 'entry_image', 'Image:<br /><span class="help">Click image to change it.</span>', '[[regtime]]', '[[regtime]]'),
(1463, 1, 1, 'catalog_product', 'entry_customer_group', 'Customer Group:', '[[regtime]]', '[[regtime]]'),
(1464, 1, 1, 'catalog_product', 'entry_date_start', 'Date Start:', '[[regtime]]', '[[regtime]]'),
(1465, 1, 1, 'catalog_product', 'entry_date_end', 'Date End:', '[[regtime]]', '[[regtime]]'),
(1466, 1, 1, 'catalog_product', 'entry_priority', 'Priority:', '[[regtime]]', '[[regtime]]'),
(1467, 1, 1, 'catalog_product', 'entry_option', 'Option:', '[[regtime]]', '[[regtime]]'),
(1468, 1, 1, 'catalog_product', 'entry_option_name', 'Option Name:', '[[regtime]]', '[[regtime]]'),
(1469, 1, 1, 'catalog_product', 'entry_option_value', 'Option Value:', '[[regtime]]', '[[regtime]]'),
(1470, 1, 1, 'catalog_product', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(1471, 1, 1, 'catalog_product', 'entry_prefix', 'Prefix:', '[[regtime]]', '[[regtime]]'),
(1472, 1, 1, 'catalog_product', 'entry_option_prefix', 'Modify Price By:', '[[regtime]]', '[[regtime]]'),
(1473, 1, 1, 'catalog_product', 'entry_option_price', 'Price Modifier:', '[[regtime]]', '[[regtime]]'),
(1474, 1, 1, 'catalog_product', 'entry_category', 'Categories:', '[[regtime]]', '[[regtime]]'),
(1475, 1, 1, 'catalog_product', 'entry_download', 'Downloads:', '[[regtime]]', '[[regtime]]'),
(1476, 1, 1, 'catalog_product', 'entry_related', 'Related Products:', '[[regtime]]', '[[regtime]]'),
(1477, 1, 1, 'catalog_product', 'entry_tags', 'Product Tags:<br /><span class="help">comma separated</span>', '[[regtime]]', '[[regtime]]'),
(1478, 1, 1, 'catalog_product', 'error_permission', 'Warning: You do not have permission to modify products!', '[[regtime]]', '[[regtime]]'),
(1479, 1, 1, 'catalog_product', 'error_name', 'Product Name must be greater than 3 and less than 255 characters!', '[[regtime]]', '[[regtime]]'),
(1480, 1, 1, 'catalog_product', 'error_model', 'Product Model must be less than 64 characters! Recommended 5-25 characters', '[[regtime]]', '[[regtime]]'),
(1481, 1, 1, 'catalog_product', 'error_required_data', 'Required Data has not been entered. Check for field errors!', '[[regtime]]', '[[regtime]]'),
(1482, 1, 1, 'catalog_product', 'error_product_not_found', 'Error: Product not found!', '[[regtime]]', '[[regtime]]'),
(1483, 1, 1, 'catalog_product', 'error_sku', 'Error: SKU not found!', '[[regtime]]', '[[regtime]]'),
(1484, 1, 1, 'catalog_product', 'filter_product', 'Search for product', '[[regtime]]', '[[regtime]]'),
(1485, 1, 1, 'catalog_product', 'filter_any_word', 'Any of these words', '[[regtime]]', '[[regtime]]'),
(1486, 1, 1, 'catalog_product', 'filter_all_words', 'All of these words', '[[regtime]]', '[[regtime]]'),
(1487, 1, 1, 'catalog_product', 'filter_exact_match', 'The exact phrase', '[[regtime]]', '[[regtime]]'),
(1488, 1, 1, 'catalog_product', 'filter_all_categories', '- All Categories -', '[[regtime]]', '[[regtime]]'),
(1489, 1, 1, 'catalog_product', 'filter_price_max', 'max', '[[regtime]]', '[[regtime]]'),
(1490, 1, 1, 'catalog_product', 'text_view', 'view', '[[regtime]]', '[[regtime]]'),
(1491, 1, 1, 'catalog_product', 'text_delete', 'delete', '[[regtime]]', '[[regtime]]'),
(1492, 1, 1, 'catalog_product', 'text_choose_action', 'Choose action', '[[regtime]]', '[[regtime]]'),
(1493, 1, 1, 'catalog_product', 'text_clone_selected', 'Clone selected', '[[regtime]]', '[[regtime]]'),
(1494, 1, 1, 'catalog_product', 'text_export_selected', 'Export selected', '[[regtime]]', '[[regtime]]'),
(1495, 1, 1, 'catalog_product', 'text_delete_selected', 'Delete selected', '[[regtime]]', '[[regtime]]'),
(1496, 1, 1, 'catalog_product', 'text_edit_selected', 'Edit selected', '[[regtime]]', '[[regtime]]'),
(1497, 1, 1, 'catalog_product', 'text_clone', 'Clone', '[[regtime]]', '[[regtime]]'),
(1498, 1, 1, 'catalog_product', 'text_export', 'Export', '[[regtime]]', '[[regtime]]'),
(1499, 1, 1, 'catalog_product', 'text_select_category', '- Select Category -', '[[regtime]]', '[[regtime]]'),
(1500, 1, 1, 'catalog_product', 'text_select_product', '- Select Product -', '[[regtime]]', '[[regtime]]'),
(1501, 1, 1, 'catalog_product', 'text_option_name', 'Option Name', '[[regtime]]', '[[regtime]]'),
(1502, 1, 1, 'catalog_product', 'text_group_option', 'Group Option', '[[regtime]]', '[[regtime]]'),
(1503, 1, 1, 'catalog_product', 'text_option_type', 'Option Type', '[[regtime]]', '[[regtime]]'),
(1504, 1, 1, 'catalog_product', 'text_option_values', 'Option Values', '[[regtime]]', '[[regtime]]'),
(1505, 1, 1, 'catalog_product', 'text_no_option_values', 'No Option Values', '[[regtime]]', '[[regtime]]'),
(1506, 1, 1, 'catalog_product', 'text_edit_option_values', 'Edit Option Value', '[[regtime]]', '[[regtime]]'),
(1507, 1, 1, 'catalog_product', 'text_save_option_values', 'Save Option Value', '[[regtime]]', '[[regtime]]'),
(1508, 1, 1, 'catalog_product', 'button_remove_option', 'Remove Option', '[[regtime]]', '[[regtime]]'),
(1509, 1, 1, 'catalog_product', 'text_option_removed', 'Option Removed', '[[regtime]]', '[[regtime]]'),
(1510, 1, 1, 'catalog_product', 'entry_weight_type', 'Weight Type', '[[regtime]]', '[[regtime]]'),
(1511, 1, 1, 'catalog_product', 'text_product_pagination', 'Product(s) {start} to {end} of {total}', '[[regtime]]', '[[regtime]]'),
(1512, 1, 1, 'catalog_product', 'entry_product_id', 'Product ID', '[[regtime]]', '[[regtime]]'),
(1513, 1, 1, 'catalog_product', 'error_product_load', 'Warning: No product with such ID!', '[[regtime]]', '[[regtime]]'),
(1514, 1, 1, 'catalog_product', 'error_attribute_not_selected', 'Please select option to add!', '[[regtime]]', '[[regtime]]'),
(1515, 1, 1, 'catalog_product', 'error_date', '"Date End" can not be less than "Date Start"!', '[[regtime]]', '[[regtime]]'),
(1516, 1, 1, 'catalog_product', 'error_required', 'This field is required!', '[[regtime]]', '[[regtime]]'),
(1517, 1, 1, 'catalog_product', 'error_option_in_group', 'Option cannot be added to product as it is already a part of group option!', '[[regtime]]', '[[regtime]]'),
(1518, 1, 1, 'catalog_product', 'text_success_layout', 'Success: You have modified product page layout.', '[[regtime]]', '[[regtime]]'),
(1519, 1, 1, 'catalog_product', 'text_success_option', 'Success: You have modified product option.', '[[regtime]]', '[[regtime]]'),
(1520, 1, 1, 'catalog_product', 'text_add_new_option', '- Add New Option -', '[[regtime]]', '[[regtime]]'),
(1521, 1, 1, 'catalog_product', 'entry_required', 'Required:', '[[regtime]]', '[[regtime]]'),
(1522, 1, 1, 'catalog_product', 'entry_element_type', 'Element Type:', '[[regtime]]', '[[regtime]]'),
(1523, 1, 1, 'catalog_product', 'entry_element_values', 'Element Values:', '[[regtime]]', '[[regtime]]'),
(1524, 1, 1, 'catalog_product', 'text_expand', '+ expand', '[[regtime]]', '[[regtime]]'),
(1525, 1, 1, 'catalog_product', 'text_hide', '- hide', '[[regtime]]', '[[regtime]]'),
(1526, 1, 1, 'catalog_product', 'entry_option_placeholder', 'Placeholder:', '[[regtime]]', '[[regtime]]'),
(1527, 1, 1, 'catalog_product', 'entry_regexp_pattern', 'Regular Expression Pattern:', '[[regtime]]', '[[regtime]]'),
(1528, 1, 1, 'catalog_product', 'entry_error_text', 'Error Message about invalid Value:', '[[regtime]]', '[[regtime]]'),
(1529, 1, 1, 'catalog_product', 'text_product_condition', 'Product Condition:', '[[regtime]]', '[[regtime]]'),
(1530, 1, 1, 'catalog_product', 'text_product_available', 'Available', '[[regtime]]', '[[regtime]]'),
(1531, 1, 1, 'catalog_product', 'text_product_disabled', 'Disabled', '[[regtime]]', '[[regtime]]'),
(1532, 1, 1, 'catalog_product', 'text_product_unavailable', 'Unavailable', '[[regtime]]', '[[regtime]]'),
(1533, 1, 1, 'catalog_product', 'text_product_out_of_stock', 'Out of Stock', '[[regtime]]', '[[regtime]]'),
(1534, 1, 1, 'catalog_product', 'text_product_in_stock', 'In Stock', '[[regtime]]', '[[regtime]]'),
(1535, 1, 1, 'catalog_product', 'text_product_option_out_of_stock', 'Product Option(s) Out of Stock', '[[regtime]]', '[[regtime]]'),
(1536, 1, 1, 'catalog_product', 'text_call_to_order', 'Call To Order', '[[regtime]]', '[[regtime]]'),
(1537, 1, 1, 'catalog_product', 'entry_call_to_order', 'Block Product From Ordering:<br /><span class="help">This will put product to display mode only with no ability to order. Contact us for order message will be displayed.</span>', '[[regtime]]', '[[regtime]]'),
(1538, 1, 1, 'catalog_product', 'text_new_option', 'New Option', '[[regtime]]', '[[regtime]]'),
(1539, 1, 1, 'catalog_product', 'text_total_orders', 'Total Orders', '[[regtime]]', '[[regtime]]'),
(1540, 1, 1, 'catalog_product', 'error_measure_value', 'The limit of 999.99 has been reached. Provide smaller number.', '[[regtime]]', '[[regtime]]'),
(1541, 1, 1, 'catalog_product', 'error_dimension_value', 'This product requires shipping. Please fill all dimension values.', '[[regtime]]', '[[regtime]]'),
(1542, 1, 1, 'catalog_product', 'error_weight_value', 'This product requires shipping. Please set weight value.', '[[regtime]]', '[[regtime]]'),
(1543, 1, 1, 'catalog_product', 'error_weight_class', 'Please set weight class.', '[[regtime]]', '[[regtime]]'),
(1544, 1, 1, 'catalog_product', 'error_length_class', 'Please set length class.', '[[regtime]]', '[[regtime]]'),
(1545, 1, 1, 'catalog_product', 'entry_allowed_extensions', 'Allowed File Extensions (txt, jpg …)', '[[regtime]]', '[[regtime]]'),
(1546, 1, 1, 'catalog_product', 'entry_min_size', 'Min file size (Kb)', '[[regtime]]', '[[regtime]]'),
(1547, 1, 1, 'catalog_product', 'entry_max_size', 'Max file size (Kb)', '[[regtime]]', '[[regtime]]'),
(1548, 1, 1, 'catalog_product', 'entry_upload_dir', 'Upload directory name<br>%s', '[[regtime]]', '[[regtime]]'),
(1549, 1, 1, 'catalog_product', 'text_success_relation_set', 'Relations of selected products was set successfully!', '[[regtime]]', '[[regtime]]'),
(1550, 1, 1, 'catalog_product', 'entry_stock_locations', 'Stock Locations:', '[[regtime]]', '[[regtime]]'),
(1551, 1, 1, 'catalog_product', 'entry_locations', 'Locations:', '[[regtime]]', '[[regtime]]'),
(1552, 1, 1, 'catalog_product', 'text_create_collection', 'Create Collection', '[[regtime]]', '[[regtime]]'),
(1553, 1, 1, 'catalog_product', 'text_warning_empty_set', 'Please select at least one product', '[[regtime]]', '[[regtime]]'),
(1554, 1, 1, 'catalog_product', 'text_enable_selected', 'Enable Selected', '[[regtime]]', '[[regtime]]'),
(1555, 1, 1, 'catalog_product', 'text_disable_selected', 'Disable Selected', '[[regtime]]', '[[regtime]]'),
(1556, 1, 1, 'catalog_product', 'entry_tax_rule', 'Tax Rule', '[[regtime]]', '[[regtime]]'),
(1557, 1, 1, 'catalog_product', 'entry_price_with_tax', 'Price With Taxes:', '[[regtime]]', '[[regtime]]'),
(1558, 1, 1, 'catalog_product', 'entry_txt_id', 'Unique Text ID:', '[[regtime]]', '[[regtime]]'),
(1559, 1, 1, 'catalog_product', 'entry_html_attributes', 'html-attributes:<br /><span class="help">You can add your custom html-attributes for option element. Example: data-some-attribute="some value"</span>', '[[regtime]]', '[[regtime]]'),
(1560, 1, 1, 'catalog_review', 'heading_title', 'Reviews', '[[regtime]]', '[[regtime]]'),
(1561, 1, 1, 'catalog_review', 'text_review', 'Review', '[[regtime]]', '[[regtime]]'),
(1562, 1, 1, 'catalog_review', 'insert_title', 'Insert Review', '[[regtime]]', '[[regtime]]'),
(1563, 1, 1, 'catalog_review', 'update_title', 'Update Review', '[[regtime]]', '[[regtime]]'),
(1564, 1, 1, 'catalog_review', 'text_success', 'Success: You have modified reviews!', '[[regtime]]', '[[regtime]]'),
(1565, 1, 1, 'catalog_review', 'column_product', 'Product', '[[regtime]]', '[[regtime]]'),
(1566, 1, 1, 'catalog_review', 'column_author', 'Author', '[[regtime]]', '[[regtime]]'),
(1567, 1, 1, 'catalog_review', 'column_rating', 'Rating', '[[regtime]]', '[[regtime]]'),
(1568, 1, 1, 'catalog_review', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1569, 1, 1, 'catalog_review', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(1570, 1, 1, 'catalog_review', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(1571, 1, 1, 'catalog_review', 'entry_product', 'Product:', '[[regtime]]', '[[regtime]]'),
(1572, 1, 1, 'catalog_review', 'entry_author', 'Author:', '[[regtime]]', '[[regtime]]'),
(1573, 1, 1, 'catalog_review', 'entry_rating', 'Rating:', '[[regtime]]', '[[regtime]]'),
(1574, 1, 1, 'catalog_review', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(1575, 1, 1, 'catalog_review', 'entry_text', 'Text:', '[[regtime]]', '[[regtime]]'),
(1576, 1, 1, 'catalog_review', 'entry_good', 'Good', '[[regtime]]', '[[regtime]]'),
(1577, 1, 1, 'catalog_review', 'entry_bad', 'Bad', '[[regtime]]', '[[regtime]]'),
(1578, 1, 1, 'catalog_review', 'error_permission', 'Warning: You do not have permission to modify reviews!', '[[regtime]]', '[[regtime]]'),
(1579, 1, 1, 'catalog_review', 'error_product', 'Product required!', '[[regtime]]', '[[regtime]]'),
(1580, 1, 1, 'catalog_review', 'error_author', 'Author must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(1581, 1, 1, 'catalog_review', 'error_text', 'Review Text must be between 25 and 1000 characters!', '[[regtime]]', '[[regtime]]'),
(1582, 1, 1, 'catalog_review', 'error_rating', 'Review rating required!', '[[regtime]]', '[[regtime]]'),
(1583, 1, 1, 'catalog_review', 'text_select_product', '- Select Product -', '[[regtime]]', '[[regtime]]'),
(1584, 1, 1, 'catalog_review', 'text_select_category', '- Select Category -', '[[regtime]]', '[[regtime]]'),
(1585, 1, 1, 'catalog_review', 'column_verified_purchase', 'Verified purchase', '[[regtime]]', '[[regtime]]'),
(1586, 1, 1, 'catalog_review', 'entry_verified_purchase', 'Verified purchase:', '[[regtime]]', '[[regtime]]'),
(1587, 1, 1, 'common_action_commands', 'text_possible_commands', 'Bellow are possible Commands. You can speak more details after command keyword. Example, "open page messages" or "insert product"', '[[regtime]]', '[[regtime]]'),
(1588, 1, 1, 'common_action_commands', 'text_multiple_result_found', 'Multiple action result found:', '[[regtime]]', '[[regtime]]'),
(1589, 1, 1, 'common_action_commands', 'text_action_confirm', 'Please confirm your request:', '[[regtime]]', '[[regtime]]'),
(1590, 1, 1, 'common_action_commands', 'command_open', 'open, open page, open menu', '[[regtime]]', '[[regtime]]'),
(1591, 1, 1, 'common_action_commands', 'command_find', 'locate, find, search, search for, search 4', '[[regtime]]', '[[regtime]]'),
(1592, 1, 1, 'common_action_commands', 'command_clear_cache', 'clear cache, cache clear, clear all cache', '[[regtime]]', '[[regtime]]'),
(1593, 1, 1, 'common_action_commands', 'command_view_log', 'view log, log view, inspect log, see log, view error log, view errors', '[[regtime]]', '[[regtime]]'),
(1594, 1, 1, 'common_action_commands', 'command_clear_log', 'clear log, log clear, delete log, log delete', '[[regtime]]', '[[regtime]]'),
(1595, 1, 1, 'common_action_commands', 'command_view_order', 'view order, order number, open order, show order, open order number, view order number, show order number, order #', '[[regtime]]', '[[regtime]]'),
(1596, 1, 1, 'common_action_commands', 'command_view_product', 'view product, product number, open product, show product, open product number, view product number, show product number, product #', '[[regtime]]', '[[regtime]]'),
(1597, 1, 1, 'common_action_commands', 'command_create_new', 'insert, create, add, new, insert new, create new, add new', '[[regtime]]', '[[regtime]]'),
(1598, 1, 1, 'common_action_commands', 'category', 'category', '[[regtime]]', '[[regtime]]'),
(1599, 1, 1, 'common_action_commands', 'product', 'product', '[[regtime]]', '[[regtime]]'),
(1600, 1, 1, 'common_action_commands', 'brand', 'brand', '[[regtime]]', '[[regtime]]'),
(1601, 1, 1, 'common_action_commands', 'manufacturer', 'brand', '[[regtime]]', '[[regtime]]'),
(1602, 1, 1, 'common_action_commands', 'review', 'review', '[[regtime]]', '[[regtime]]'),
(1603, 1, 1, 'common_action_commands', 'download', 'download', '[[regtime]]', '[[regtime]]'),
(1604, 1, 1, 'common_action_commands', 'attribute', 'attribute', '[[regtime]]', '[[regtime]]'),
(1605, 1, 1, 'common_action_commands', 'customer', 'customer', '[[regtime]]', '[[regtime]]'),
(1606, 1, 1, 'common_action_commands', 'coupon', 'coupon', '[[regtime]]', '[[regtime]]'),
(1607, 1, 1, 'common_action_commands', 'discount', 'discount', '[[regtime]]', '[[regtime]]'),
(1608, 1, 1, 'common_action_commands', 'block', 'block', '[[regtime]]', '[[regtime]]'),
(1609, 1, 1, 'common_action_commands', 'menu', 'menu', '[[regtime]]', '[[regtime]]'),
(1610, 1, 1, 'common_action_commands', 'content', 'content', '[[regtime]]', '[[regtime]]'),
(1611, 1, 1, 'common_action_commands', 'banner', 'banner', '[[regtime]]', '[[regtime]]'),
(1612, 1, 1, 'common_action_commands', 'page', 'page', '[[regtime]]', '[[regtime]]'),
(1613, 1, 1, 'common_action_commands', 'store', 'store', '[[regtime]]', '[[regtime]]'),
(1614, 1, 1, 'common_action_commands', 'language', 'language', '[[regtime]]', '[[regtime]]'),
(1615, 1, 1, 'common_action_commands', 'currency', 'currency', '[[regtime]]', '[[regtime]]'),
(1616, 1, 1, 'common_action_commands', 'location', 'location', '[[regtime]]', '[[regtime]]'),
(1617, 1, 1, 'common_action_commands', 'tax', 'tax', '[[regtime]]', '[[regtime]]'),
(1618, 1, 1, 'common_ant', 'notification', 'Attention!', '[[regtime]]', '[[regtime]]'),
(1619, 1, 1, 'common_ant', 'warning', 'Warning!', '[[regtime]]', '[[regtime]]'),
(1620, 1, 1, 'common_do_embed', 'text_get_product_embed_code', 'Product Embed Code', '[[regtime]]', '[[regtime]]'),
(1621, 1, 1, 'common_do_embed', 'text_get_category_embed_code', 'Category Embed Code', '[[regtime]]', '[[regtime]]'),
(1622, 1, 1, 'common_do_embed', 'text_get_manufacturer_embed_code', 'Brand Embed Code', '[[regtime]]', '[[regtime]]'),
(1623, 1, 1, 'common_do_embed', 'entry_image', 'Show Image', '[[regtime]]', '[[regtime]]'),
(1624, 1, 1, 'common_do_embed', 'entry_name', 'Show Name', '[[regtime]]', '[[regtime]]'),
(1625, 1, 1, 'common_do_embed', 'entry_price', 'Show Price', '[[regtime]]', '[[regtime]]'),
(1626, 1, 1, 'common_do_embed', 'entry_limit', 'Limit ', '[[regtime]]', '[[regtime]]'),
(1627, 1, 1, 'common_do_embed', 'entry_rating', 'Show Reviews And Rating', '[[regtime]]', '[[regtime]]'),
(1628, 1, 1, 'common_do_embed', 'entry_blurb', 'Show Blurb', '[[regtime]]', '[[regtime]]'),
(1629, 1, 1, 'common_do_embed', 'entry_quantity', 'Show Quantity', '[[regtime]]', '[[regtime]]'),
(1630, 1, 1, 'common_do_embed', 'entry_addtocart', 'Show Button', '[[regtime]]', '[[regtime]]'),
(1631, 1, 1, 'common_do_embed', 'entry_language', 'Select Language', '[[regtime]]', '[[regtime]]'),
(1632, 1, 1, 'common_do_embed', 'entry_currency', 'Select Currency', '[[regtime]]', '[[regtime]]'),
(1633, 1, 1, 'common_do_embed', 'entry_products_count', 'Products Count', '[[regtime]]', '[[regtime]]'),
(1634, 1, 1, 'common_filemanager', 'heading_title', 'Image Manager', '[[regtime]]', '[[regtime]]'),
(1635, 1, 1, 'common_filemanager', 'text_uploaded', 'Success: Your file has been uploaded!', '[[regtime]]', '[[regtime]]'),
(1636, 1, 1, 'common_filemanager', 'text_file_delete', 'File has been deleted!', '[[regtime]]', '[[regtime]]'),
(1637, 1, 1, 'common_filemanager', 'text_create', 'Success: Directory created!', '[[regtime]]', '[[regtime]]'),
(1638, 1, 1, 'common_filemanager', 'text_delete', 'Success: Your file or directory has been deleted!', '[[regtime]]', '[[regtime]]'),
(1639, 1, 1, 'common_filemanager', 'text_move', 'Success: Your file or directory has been moved!', '[[regtime]]', '[[regtime]]'),
(1640, 1, 1, 'common_filemanager', 'text_copy', 'Success: Your file or directory has been copied!', '[[regtime]]', '[[regtime]]'),
(1641, 1, 1, 'common_filemanager', 'text_rename', 'Success: Your file or directory has been renamed!', '[[regtime]]', '[[regtime]]'),
(1642, 1, 1, 'common_filemanager', 'entry_folder', 'New Folder:', '[[regtime]]', '[[regtime]]'),
(1643, 1, 1, 'common_filemanager', 'entry_move', 'Move:', '[[regtime]]', '[[regtime]]'),
(1644, 1, 1, 'common_filemanager', 'entry_copy', 'Name:', '[[regtime]]', '[[regtime]]'),
(1645, 1, 1, 'common_filemanager', 'entry_rename', 'Name:', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(1646, 1, 1, 'common_filemanager', 'error_select', 'Warning: Please select a directory or file!', '[[regtime]]', '[[regtime]]'),
(1647, 1, 1, 'common_filemanager', 'error_file', 'Warning: Please select a file!', '[[regtime]]', '[[regtime]]'),
(1648, 1, 1, 'common_filemanager', 'error_directory', 'Warning: Please select a directory!', '[[regtime]]', '[[regtime]]'),
(1649, 1, 1, 'common_filemanager', 'error_default', 'Warning: Can not alter your default directory!', '[[regtime]]', '[[regtime]]'),
(1650, 1, 1, 'common_filemanager', 'error_delete', 'Warning: You can not delete this directory!', '[[regtime]]', '[[regtime]]'),
(1651, 1, 1, 'common_filemanager', 'error_filename', 'Warning: Filename must be a between 3 and 255!', '[[regtime]]', '[[regtime]]'),
(1652, 1, 1, 'common_filemanager', 'error_missing', 'Warning: File or directory does not exist!', '[[regtime]]', '[[regtime]]'),
(1653, 1, 1, 'common_filemanager', 'error_exists', 'Warning: A file or directory with the same name already exists!', '[[regtime]]', '[[regtime]]'),
(1654, 1, 1, 'common_filemanager', 'error_name', 'Warning: Please enter a new name!', '[[regtime]]', '[[regtime]]'),
(1655, 1, 1, 'common_filemanager', 'error_move', 'Warning: Move to directory does not exists!', '[[regtime]]', '[[regtime]]'),
(1656, 1, 1, 'common_filemanager', 'error_copy', 'Warning: Can not copy this file or directory!', '[[regtime]]', '[[regtime]]'),
(1657, 1, 1, 'common_filemanager', 'error_rename', 'Warning: Can not rename this directory!', '[[regtime]]', '[[regtime]]'),
(1658, 1, 1, 'common_filemanager', 'error_file_type', 'Warning: Incorrect file type!', '[[regtime]]', '[[regtime]]'),
(1659, 1, 1, 'common_filemanager', 'error_file_size', 'Warning: File to big please keep below 300kb and no more than 1000px height or width!', '[[regtime]]', '[[regtime]]'),
(1660, 1, 1, 'common_filemanager', 'error_uploaded', 'Warning: File could not be uploaded for an unknown reason!', '[[regtime]]', '[[regtime]]'),
(1661, 1, 1, 'common_filemanager', 'error_permission', 'Warning: Permission Denied!', '[[regtime]]', '[[regtime]]'),
(1662, 1, 1, 'common_filemanager', 'button_folder', 'New Folder', '[[regtime]]', '[[regtime]]'),
(1663, 1, 1, 'common_filemanager', 'button_delete', 'Delete', '[[regtime]]', '[[regtime]]'),
(1664, 1, 1, 'common_filemanager', 'button_move', 'Move', '[[regtime]]', '[[regtime]]'),
(1665, 1, 1, 'common_filemanager', 'button_copy', 'Copy', '[[regtime]]', '[[regtime]]'),
(1666, 1, 1, 'common_filemanager', 'button_rename', 'Rename', '[[regtime]]', '[[regtime]]'),
(1667, 1, 1, 'common_filemanager', 'button_upload', 'Upload', '[[regtime]]', '[[regtime]]'),
(1668, 1, 1, 'common_filemanager', 'button_refresh', 'Refresh', '[[regtime]]', '[[regtime]]'),
(1669, 1, 1, 'common_footer', 'text_footer_left', ' AbanteCart is a trademark of Belavier Commerce LLC<br /> Copyright &copy; 2009 - %s All Rights Reserved ', '[[regtime]]', '[[regtime]]'),
(1670, 1, 1, 'common_footer', 'text_footer', '<a href="http://www.abantecart.com" target="_blank">AbanteCart</a> Version ', '[[regtime]]', '[[regtime]]'),
(1671, 1, 1, 'common_forgot_password', 'heading_title', 'Forgot Password?', '[[regtime]]', '[[regtime]]'),
(1672, 1, 1, 'common_forgot_password', 'text_heading', 'Forgot Password?', '[[regtime]]', '[[regtime]]'),
(1673, 1, 1, 'common_forgot_password', 'text_heading_reset', 'Reset Password', '[[regtime]]', '[[regtime]]'),
(1674, 1, 1, 'common_forgot_password', 'text_forgot', 'Please enter your username and email.', '[[regtime]]', '[[regtime]]'),
(1675, 1, 1, 'common_forgot_password', 'text_login', 'back to login page', '[[regtime]]', '[[regtime]]'),
(1676, 1, 1, 'common_forgot_password', 'text_instructions', 'Email with instructions on how to reset password sent to your email', '[[regtime]]', '[[regtime]]'),
(1677, 1, 1, 'common_forgot_password', 'text_enter_new_password', 'Enter new password and confirmation below', '[[regtime]]', '[[regtime]]'),
(1678, 1, 1, 'common_forgot_password', 'text_instructions_reset', 'Your password has been reset. Now you can login with your new password ', '[[regtime]]', '[[regtime]]'),
(1679, 1, 1, 'common_forgot_password', 'reset_email_subject', '%s - Password Reset Request ', '[[regtime]]', '[[regtime]]'),
(1680, 1, 1, 'common_forgot_password', 'reset_email_body_html', 'Password reset was requested for user with this email. Please click on link below to proceed.\n<br/>\n<br/><a href="%s">%s</a>\n<br/>\n<br/>Link is valid for one day.\n<br/>\n<br/>If you do not send request - just ignore this email.', '[[regtime]]', '[[regtime]]'),
(1681, 1, 1, 'common_forgot_password', 'reset_email_body_text', 'Password reset was requested for user with this email. Please click on link below to proceed.\n\n<a href="%s">%s</a>\n\nPlease note: Link is valid for one day.\n\nIf you do not send request - just ignore this email.', '[[regtime]]', '[[regtime]]'),
(1682, 1, 1, 'common_forgot_password', 'new_password_email_body', 'Your administration password was successfully reset!', '[[regtime]]', '[[regtime]]'),
(1683, 1, 1, 'common_forgot_password', 'entry_username', 'Username:', '[[regtime]]', '[[regtime]]'),
(1684, 1, 1, 'common_forgot_password', 'entry_email', 'Email:', '[[regtime]]', '[[regtime]]'),
(1685, 1, 1, 'common_forgot_password', 'entry_captcha', 'Enter the code:', '[[regtime]]', '[[regtime]]'),
(1686, 1, 1, 'common_forgot_password', 'button_reset_password', 'Reset Password', '[[regtime]]', '[[regtime]]'),
(1687, 1, 1, 'common_forgot_password', 'error_match', 'No match for Username and Email.', '[[regtime]]', '[[regtime]]'),
(1688, 1, 1, 'common_forgot_password', 'error_hash', 'Reset Password Hash is not valid .', '[[regtime]]', '[[regtime]]'),
(1689, 1, 1, 'common_forgot_password', 'error_username', 'Username cannot be empty', '[[regtime]]', '[[regtime]]'),
(1690, 1, 1, 'common_forgot_password', 'error_email', 'E-Mail Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(1691, 1, 1, 'common_forgot_password', 'error_captcha', 'Human verification Failed!', '[[regtime]]', '[[regtime]]'),
(1692, 1, 1, 'common_header', 'heading_title', 'Administration', '[[regtime]]', '[[regtime]]'),
(1693, 1, 1, 'common_header', 'text_backup', 'Backup / Restore', '[[regtime]]', '[[regtime]]'),
(1694, 1, 1, 'common_header', 'text_welcome', 'Welcome, <b>%s</b>', '[[regtime]]', '[[regtime]]'),
(1695, 1, 1, 'common_header', 'text_last_login', 'Last login: %s', '[[regtime]]', '[[regtime]]'),
(1696, 1, 1, 'common_header', 'text_edit_details', 'Edit Profile Details', '[[regtime]]', '[[regtime]]'),
(1697, 1, 1, 'common_header', 'text_edit_notifications', 'Edit Notification Settings', '[[regtime]]', '[[regtime]]'),
(1698, 1, 1, 'common_header', 'text_catalog', 'Catalog', '[[regtime]]', '[[regtime]]'),
(1699, 1, 1, 'common_header', 'text_category', 'Categories', '[[regtime]]', '[[regtime]]'),
(1700, 1, 1, 'common_header', 'text_confirm', 'Confirm?', '[[regtime]]', '[[regtime]]'),
(1701, 1, 1, 'common_header', 'text_country', 'Countries', '[[regtime]]', '[[regtime]]'),
(1702, 1, 1, 'common_header', 'text_coupon', 'Coupons', '[[regtime]]', '[[regtime]]'),
(1703, 1, 1, 'common_header', 'text_discount', 'Discounts', '[[regtime]]', '[[regtime]]'),
(1704, 1, 1, 'common_header', 'text_currency', 'Currencies', '[[regtime]]', '[[regtime]]'),
(1705, 1, 1, 'common_header', 'text_customer', 'Customers', '[[regtime]]', '[[regtime]]'),
(1706, 1, 1, 'common_header', 'text_customer_group', 'Customer Groups', '[[regtime]]', '[[regtime]]'),
(1707, 1, 1, 'common_header', 'text_dashboard', 'Dashboard', '[[regtime]]', '[[regtime]]'),
(1708, 1, 1, 'common_header', 'text_download', 'Downloads', '[[regtime]]', '[[regtime]]'),
(1709, 1, 1, 'common_header', 'text_error_log', 'Error Logs', '[[regtime]]', '[[regtime]]'),
(1710, 1, 1, 'common_header', 'text_extension', 'Extensions', '[[regtime]]', '[[regtime]]'),
(1711, 1, 1, 'common_header', 'text_extensions_short', 'Extensions', '[[regtime]]', '[[regtime]]'),
(1712, 1, 1, 'common_header', 'text_front', 'Storefront', '[[regtime]]', '[[regtime]]'),
(1713, 1, 1, 'common_header', 'text_location', 'Locations', '[[regtime]]', '[[regtime]]'),
(1714, 1, 1, 'common_header', 'text_help', 'Help', '[[regtime]]', '[[regtime]]'),
(1715, 1, 1, 'common_header', 'text_information', 'Information', '[[regtime]]', '[[regtime]]'),
(1716, 1, 1, 'common_header', 'text_language', 'Languages', '[[regtime]]', '[[regtime]]'),
(1717, 1, 1, 'common_header', 'text_language_definitions', 'Language Definitions', '[[regtime]]', '[[regtime]]'),
(1718, 1, 1, 'common_header', 'text_localisation', 'Localization', '[[regtime]]', '[[regtime]]'),
(1719, 1, 1, 'common_header', 'text_logged', 'You are logged in as <span>%s</span>', '[[regtime]]', '[[regtime]]'),
(1720, 1, 1, 'common_header', 'text_logout', 'Logout', '[[regtime]]', '[[regtime]]'),
(1721, 1, 1, 'common_header', 'text_contact', 'Send Mail', '[[regtime]]', '[[regtime]]'),
(1722, 1, 1, 'common_header', 'text_manufacturer', 'Brands', '[[regtime]]', '[[regtime]]'),
(1723, 1, 1, 'common_header', 'text_order', 'Orders', '[[regtime]]', '[[regtime]]'),
(1724, 1, 1, 'common_header', 'text_order_status', 'Order Statuses', '[[regtime]]', '[[regtime]]'),
(1725, 1, 1, 'common_header', 'text_abantecart', 'Homepage', '[[regtime]]', '[[regtime]]'),
(1726, 1, 1, 'common_header', 'text_payment', 'Payments', '[[regtime]]', '[[regtime]]'),
(1727, 1, 1, 'common_header', 'text_product', 'Products', '[[regtime]]', '[[regtime]]'),
(1728, 1, 1, 'common_header', 'text_reports', 'Reports', '[[regtime]]', '[[regtime]]'),
(1729, 1, 1, 'common_header', 'text_online', 'Online', '[[regtime]]', '[[regtime]]'),
(1730, 1, 1, 'common_header', 'text_transactions', 'Transactions', '[[regtime]]', '[[regtime]]'),
(1731, 1, 1, 'common_header', 'text_tax', 'Tax', '[[regtime]]', '[[regtime]]'),
(1732, 1, 1, 'common_header', 'text_report_purchased', 'Products Purchased', '[[regtime]]', '[[regtime]]'),
(1733, 1, 1, 'common_header', 'text_report_sale', 'Sales', '[[regtime]]', '[[regtime]]'),
(1734, 1, 1, 'common_header', 'text_analytics', 'Analytics & Insights', '[[regtime]]', '[[regtime]]'),
(1735, 1, 1, 'common_header', 'text_report_viewed', 'Products Viewed', '[[regtime]]', '[[regtime]]'),
(1736, 1, 1, 'common_header', 'text_review', 'Reviews', '[[regtime]]', '[[regtime]]'),
(1737, 1, 1, 'common_header', 'text_sale', 'Sales', '[[regtime]]', '[[regtime]]'),
(1738, 1, 1, 'common_header', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(1739, 1, 1, 'common_header', 'text_setting', 'Settings', '[[regtime]]', '[[regtime]]'),
(1740, 1, 1, 'common_header', 'text_stock_status', 'Stock Statuses', '[[regtime]]', '[[regtime]]'),
(1741, 1, 1, 'common_header', 'text_support', 'Support Forum', '[[regtime]]', '[[regtime]]'),
(1742, 1, 1, 'common_header', 'text_system', 'System', '[[regtime]]', '[[regtime]]'),
(1743, 1, 1, 'common_header', 'text_tax_class', 'Tax Classes', '[[regtime]]', '[[regtime]]'),
(1744, 1, 1, 'common_header', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(1745, 1, 1, 'common_header', 'text_user', 'Users', '[[regtime]]', '[[regtime]]'),
(1746, 1, 1, 'common_header', 'text_documentation', 'Documentation', '[[regtime]]', '[[regtime]]'),
(1747, 1, 1, 'common_header', 'text_users', 'Users', '[[regtime]]', '[[regtime]]'),
(1748, 1, 1, 'common_header', 'text_user_group', 'User Groups', '[[regtime]]', '[[regtime]]'),
(1749, 1, 1, 'common_header', 'text_weight_class', 'Weight Classes', '[[regtime]]', '[[regtime]]'),
(1750, 1, 1, 'common_header', 'text_length_class', 'Length Classes', '[[regtime]]', '[[regtime]]'),
(1751, 1, 1, 'common_header', 'text_zone', 'Zones', '[[regtime]]', '[[regtime]]'),
(1752, 1, 1, 'common_header', 'text_extensions', 'All Extensions', '[[regtime]]', '[[regtime]]'),
(1753, 1, 1, 'common_header', 'text_add_extension', ' Install Extension ', '[[regtime]]', '[[regtime]]'),
(1754, 1, 1, 'common_header', 'text_extensions_store', 'Get Extensions', '[[regtime]]', '[[regtime]]'),
(1755, 1, 1, 'common_header', 'text_migrate', 'Migration Tool', '[[regtime]]', '[[regtime]]'),
(1756, 1, 1, 'common_header', 'text_updater', 'Updater', '[[regtime]]', '[[regtime]]'),
(1757, 1, 1, 'common_header', 'text_templates', 'Templates', '[[regtime]]', '[[regtime]]'),
(1758, 1, 1, 'common_header', 'text_layout', 'Layouts', '[[regtime]]', '[[regtime]]'),
(1759, 1, 1, 'common_header', 'text_blocks', 'Blocks', '[[regtime]]', '[[regtime]]'),
(1760, 1, 1, 'common_header', 'text_menu', 'Menu', '[[regtime]]', '[[regtime]]'),
(1761, 1, 1, 'common_header', 'text_cache', 'Clear data', '[[regtime]]', '[[regtime]]'),
(1762, 1, 1, 'common_header', 'text_messages', 'Messages', '[[regtime]]', '[[regtime]]'),
(1763, 1, 1, 'common_header', 'text_content', 'Content', '[[regtime]]', '[[regtime]]'),
(1764, 1, 1, 'common_header', 'text_datasets_manager', 'Datasets', '[[regtime]]', '[[regtime]]'),
(1765, 1, 1, 'common_header', 'text_install_upgrade_history', ' Install/Upgrade History ', '[[regtime]]', '[[regtime]]'),
(1766, 1, 1, 'common_header', 'text_attribute', 'Global Attributes', '[[regtime]]', '[[regtime]]'),
(1767, 1, 1, 'common_header', 'text_attribute_groups', 'Global Attributes Groups', '[[regtime]]', '[[regtime]]'),
(1768, 1, 1, 'common_header', 'text_import_export', 'Import / Export', '[[regtime]]', '[[regtime]]'),
(1769, 1, 1, 'common_header', 'text_data', 'Data', '[[regtime]]', '[[regtime]]'),
(1770, 1, 1, 'common_header', 'text_logs', 'Logs', '[[regtime]]', '[[regtime]]'),
(1771, 1, 1, 'common_header', 'text_quick_edit_form', 'Quick Edit Form', '[[regtime]]', '[[regtime]]'),
(1772, 1, 1, 'common_header', 'text_all_matches', 'all matches', '[[regtime]]', '[[regtime]]'),
(1773, 1, 1, 'common_header', 'text_file_uploads', 'File Uploads', '[[regtime]]', '[[regtime]]'),
(1774, 1, 1, 'common_header', 'text_all_settings', 'All Settings', '[[regtime]]', '[[regtime]]'),
(1775, 1, 1, 'common_header', 'text_settings_details', 'Store Details', '[[regtime]]', '[[regtime]]'),
(1776, 1, 1, 'common_header', 'text_settings_general', 'General', '[[regtime]]', '[[regtime]]'),
(1777, 1, 1, 'common_header', 'text_settings_checkout', 'Checkout', '[[regtime]]', '[[regtime]]'),
(1778, 1, 1, 'common_header', 'text_settings_appearance', 'Appearance', '[[regtime]]', '[[regtime]]'),
(1779, 1, 1, 'common_header', 'text_settings_mail', 'Mail', '[[regtime]]', '[[regtime]]'),
(1780, 1, 1, 'common_header', 'text_settings_im', 'IM', '[[regtime]]', '[[regtime]]'),
(1781, 1, 1, 'common_header', 'text_settings_api', 'API', '[[regtime]]', '[[regtime]]'),
(1782, 1, 1, 'common_header', 'text_settings_system', 'System', '[[regtime]]', '[[regtime]]'),
(1783, 1, 1, 'common_header', 'text_settings_newstore', 'Create New Store', '[[regtime]]', '[[regtime]]'),
(1784, 1, 1, 'common_header', 'text_voice_command_prompt', 'Voice Command Prompt.', '[[regtime]]', '[[regtime]]'),
(1785, 1, 1, 'common_header', 'text_voice_select_dialect', 'Select your dialect', '[[regtime]]', '[[regtime]]'),
(1786, 1, 1, 'common_header', 'text_voice_confirm_action', 'Confirm this action or cancel', '[[regtime]]', '[[regtime]]'),
(1787, 1, 1, 'common_header', 'text_voice_speak_now', 'Speak now.', '[[regtime]]', '[[regtime]]'),
(1788, 1, 1, 'common_header', 'text_voice_no_speach_detected', 'No speech was detected. You may need to adjust your <a href="//support.google.com/chrome/bin/answer.py?hl=en&amp;answer=1407892">microphone settings</a>.', '[[regtime]]', '[[regtime]]'),
(1789, 1, 1, 'common_header', 'text_voice_no_mic_detected', 'No microphone was found. Ensure that a microphone is installed and that <a href="//support.google.com/chrome/bin/answer.py?hl=en&amp;answer=1407892"> microphone settings</a> are configured correctly.', '[[regtime]]', '[[regtime]]'),
(1790, 1, 1, 'common_header', 'text_voice_click_allow', 'Click the "Allow" button above to enable your microphone.', '[[regtime]]', '[[regtime]]'),
(1791, 1, 1, 'common_header', 'text_voice_mic_denied', 'Permission to use microphone was denied.', '[[regtime]]', '[[regtime]]'),
(1792, 1, 1, 'common_header', 'text_voice_mic_permission', 'Permission to use microphone is blocked. To change, go to browser <a href="chrome://settings/contentExceptions#media-stream">media settings</a>', '[[regtime]]', '[[regtime]]'),
(1793, 1, 1, 'common_header', 'text_voice_not_supported', 'Voice control is not supported by this browser. <a href="//www.google.com/chrome" target="_new">Chrome</a> version 25 or later required.', '[[regtime]]', '[[regtime]]'),
(1794, 1, 1, 'common_header', 'text_tasks', 'Scheduled Tasks', '[[regtime]]', '[[regtime]]'),
(1795, 1, 1, 'common_header', 'text_read_all_messages', 'Read All Messages', '[[regtime]]', '[[regtime]]'),
(1796, 1, 1, 'common_header', 'text_short_stats', 'Quick Stats', '[[regtime]]', '[[regtime]]'),
(1797, 1, 1, 'common_header', 'text_online_now', 'Online Customers', '[[regtime]]', '[[regtime]]'),
(1798, 1, 1, 'common_header', 'text_online_new', 'New', '[[regtime]]', '[[regtime]]'),
(1799, 1, 1, 'common_header', 'text_online_registered', 'Logged In', '[[regtime]]', '[[regtime]]'),
(1800, 1, 1, 'common_header', 'text_today_orders', 'New Orders Today', '[[regtime]]', '[[regtime]]'),
(1801, 1, 1, 'common_header', 'text_today_sales', 'Total Sales Today', '[[regtime]]', '[[regtime]]'),
(1802, 1, 1, 'common_header', 'text_today_customers', 'New Customers Today', '[[regtime]]', '[[regtime]]'),
(1803, 1, 1, 'common_header', 'text_today_reviews', 'New Reviews Today', '[[regtime]]', '[[regtime]]'),
(1804, 1, 1, 'common_header', 'text_rl_manager', 'Media Manager', '[[regtime]]', '[[regtime]]'),
(1805, 1, 1, 'common_header', 'text_server_time', 'Server Time', '[[regtime]]', '[[regtime]]'),
(1806, 1, 1, 'common_header', 'text_taxes', 'Taxes', '[[regtime]]', '[[regtime]]'),
(1807, 1, 1, 'common_header', 'email_templates', 'Email Templates', '[[regtime]]', '[[regtime]]'),
(1808, 1, 1, 'common_header', 'text_collection', 'Collections', '[[regtime]]', '[[regtime]]'),
(1809, 1, 1, 'common_home', 'heading_title', 'Dashboard', '[[regtime]]', '[[regtime]]'),
(1810, 1, 1, 'common_home', 'text_overview', 'Overview', '[[regtime]]', '[[regtime]]'),
(1811, 1, 1, 'common_home', 'text_statistics', 'Statistics', '[[regtime]]', '[[regtime]]'),
(1812, 1, 1, 'common_home', 'text_latest_10_orders', 'Latest 10 Orders', '[[regtime]]', '[[regtime]]'),
(1813, 1, 1, 'common_home', 'text_total_sale', 'Total Sales:', '[[regtime]]', '[[regtime]]'),
(1814, 1, 1, 'common_home', 'text_total_sale_year', 'Total Sales This Year:', '[[regtime]]', '[[regtime]]'),
(1815, 1, 1, 'common_home', 'text_total_order', 'Total Orders:', '[[regtime]]', '[[regtime]]'),
(1816, 1, 1, 'common_home', 'text_total_customer', 'No. Of Customers:', '[[regtime]]', '[[regtime]]'),
(1817, 1, 1, 'common_home', 'text_total_customer_approval', 'Customers Waiting Approval:', '[[regtime]]', '[[regtime]]'),
(1818, 1, 1, 'common_home', 'text_total_product', 'No. Products:', '[[regtime]]', '[[regtime]]'),
(1819, 1, 1, 'common_home', 'text_total_review', 'No. Of Reviews:', '[[regtime]]', '[[regtime]]'),
(1820, 1, 1, 'common_home', 'text_total_review_approval', 'Reviews Waiting Approval:', '[[regtime]]', '[[regtime]]'),
(1821, 1, 1, 'common_home', 'text_day', 'Today', '[[regtime]]', '[[regtime]]'),
(1822, 1, 1, 'common_home', 'text_week', 'This Week', '[[regtime]]', '[[regtime]]'),
(1823, 1, 1, 'common_home', 'text_month', 'This Month', '[[regtime]]', '[[regtime]]'),
(1824, 1, 1, 'common_home', 'text_year', 'This Year', '[[regtime]]', '[[regtime]]'),
(1825, 1, 1, 'common_home', 'text_order', 'Total Orders', '[[regtime]]', '[[regtime]]'),
(1826, 1, 1, 'common_home', 'text_order_short', 'Total Orders', '[[regtime]]', '[[regtime]]'),
(1827, 1, 1, 'common_home', 'text_customer', 'Total Customers', '[[regtime]]', '[[regtime]]'),
(1828, 1, 1, 'common_home', 'column_order', 'Order ID', '[[regtime]]', '[[regtime]]'),
(1829, 1, 1, 'common_home', 'column_name', 'Customer Name', '[[regtime]]', '[[regtime]]'),
(1830, 1, 1, 'common_home', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(1831, 1, 1, 'common_home', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(1832, 1, 1, 'common_home', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(1833, 1, 1, 'common_home', 'column_firstname', 'First Name', '[[regtime]]', '[[regtime]]'),
(1834, 1, 1, 'common_home', 'column_lastname', 'Last Name', '[[regtime]]', '[[regtime]]'),
(1835, 1, 1, 'common_home', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(1836, 1, 1, 'common_home', 'entry_range', 'Select Range:', '[[regtime]]', '[[regtime]]'),
(1837, 1, 1, 'common_home', 'orders_text_all', 'All Orders', '[[regtime]]', '[[regtime]]'),
(1838, 1, 1, 'common_home', 'text_customer_all', 'All Customers', '[[regtime]]', '[[regtime]]'),
(1839, 1, 1, 'common_home', 'text_latest_10_customers', 'Latest Registrations', '[[regtime]]', '[[regtime]]'),
(1840, 1, 1, 'common_home', 'column_email', 'Email', '[[regtime]]', '[[regtime]]'),
(1841, 1, 1, 'common_im', 'im_text_notification', 'Notifications', '[[regtime]]', '[[regtime]]'),
(1842, 1, 1, 'common_im', 'im_sendpoint_name_order_update', 'Order Updates', '[[regtime]]', '[[regtime]]'),
(1843, 1, 1, 'common_im', 'im_order_update_text_to_customer', 'Your order <a href="%s">#%s</a> has been updated. For more details, login to %s account.', '[[regtime]]', '[[regtime]]'),
(1844, 1, 1, 'common_im', 'im_order_update_text_to_guest', 'Your order <a href="%s">#%s</a> has been updated. For more details, please visit order page %s.', '[[regtime]]', '[[regtime]]'),
(1845, 1, 1, 'common_im', 'im_sendpoint_name_new_order', 'New Orders', '[[regtime]]', '[[regtime]]'),
(1846, 1, 1, 'common_im', 'im_new_order_text_to_admin', 'New Order <a href="#admin#rt=sale/order/details&order_id=%s">#%s</a> has been created!', '[[regtime]]', '[[regtime]]'),
(1847, 1, 1, 'common_im', 'im_sendpoint_name_new_customer', 'Customer Registrations', '[[regtime]]', '[[regtime]]'),
(1848, 1, 1, 'common_im', 'im_new_customer_text_to_admin', ' New Customer #%s has been registered!', '[[regtime]]', '[[regtime]]'),
(1849, 1, 1, 'common_im', 'im_sendpoint_name_account_update', 'Administrator User Account Updates', '[[regtime]]', '[[regtime]]'),
(1850, 1, 1, 'common_im', 'im_account_update_text_to_admin', 'Your administrator user account details have been changed.', '[[regtime]]', '[[regtime]]'),
(1851, 1, 1, 'common_im', 'im_customer_account_update_text_to_admin', ' New Customer #%s has been updated!', '[[regtime]]', '[[regtime]]'),
(1852, 1, 1, 'common_im', 'im_sendpoint_name_customer_contact', 'Customer Enquiries', '[[regtime]]', '[[regtime]]'),
(1853, 1, 1, 'common_im', 'im_sendpoint_name_product_out_of_stock', 'Products Out of Stock', '[[regtime]]', '[[regtime]]'),
(1854, 1, 1, 'common_im', 'im_sendpoint_name_product_review', 'New Product Reviews', '[[regtime]]', '[[regtime]]'),
(1855, 1, 1, 'common_im', 'im_sendpoint_name_newsletter', ' Newsletters ', '[[regtime]]', '[[regtime]]'),
(1856, 1, 1, 'common_im', 'im_sendpoint_name_system_messages', ' System Messages ', '[[regtime]]', '[[regtime]]'),
(1857, 1, 1, 'common_im', 'im_customer_account_update_text_to_customer', 'New transaction has been posted to your %s account in the amount of %s. For more details, login to %s account.', '[[regtime]]', '[[regtime]]'),
(1858, 1, 1, 'common_im', 'text_notification_for', 'Notifications for user %s', '[[regtime]]', '[[regtime]]'),
(1859, 1, 1, 'common_im', 'error_unknown_sendpoint', 'Sendpoint %s does not found in sendpoints list!', '[[regtime]]', '[[regtime]]'),
(1860, 1, 1, 'common_im', 'text_settings_success_saved', 'Notification settings saved successfully!', '[[regtime]]', '[[regtime]]'),
(1861, 1, 1, 'common_im', 'im_error_mail_address', 'Email address %s looks like invalid!', '[[regtime]]', '[[regtime]]'),
(1862, 1, 1, 'common_im', 'im_threshold', 'Minimum stock level threshold', '[[regtime]]', '[[regtime]]'),
(1863, 1, 1, 'common_login', 'heading_title', 'Administration', '[[regtime]]', '[[regtime]]'),
(1864, 1, 1, 'common_login', 'text_heading', 'Administration', '[[regtime]]', '[[regtime]]'),
(1865, 1, 1, 'common_login', 'text_login', 'Please enter your login details.', '[[regtime]]', '[[regtime]]'),
(1866, 1, 1, 'common_login', 'entry_username', 'Username:', '[[regtime]]', '[[regtime]]'),
(1867, 1, 1, 'common_login', 'entry_password', 'Password:', '[[regtime]]', '[[regtime]]'),
(1868, 1, 1, 'common_login', 'entry_forgot_password', 'Forgot Password?', '[[regtime]]', '[[regtime]]'),
(1869, 1, 1, 'common_login', 'button_login', 'Login', '[[regtime]]', '[[regtime]]'),
(1870, 1, 1, 'common_login', 'error_login', 'No match for Username and/or Password.', '[[regtime]]', '[[regtime]]'),
(1871, 1, 1, 'common_login', 'error_token', 'Invalid token session. Please login again.', '[[regtime]]', '[[regtime]]'),
(1872, 1, 1, 'common_login', 'error_login_message', 'Failed login to admin attempt from IP:', '[[regtime]]', '[[regtime]]'),
(1873, 1, 1, 'common_login', 'error_login_message_text', 'Given user login: ', '[[regtime]]', '[[regtime]]'),
(1874, 1, 1, 'common_login', 'error_login_secure', 'You are trying to login in non-secure unsafe mode! Please switch to secure <a href="%s">HTTPS</a> to proceed ', '[[regtime]]', '[[regtime]]'),
(1875, 1, 1, 'common_quick_start', 'text_quick_start', 'Quick Start Wizard', '[[regtime]]', '[[regtime]]'),
(1876, 1, 1, 'common_quick_start', 'text_quick_start_note', '    	Welcome to AbanteCart administration.<br />\n    	This is a wizard to help you quickly set up your shopping cart with most common settings.\n		<br />\n    ', '[[regtime]]', '[[regtime]]'),
(1877, 1, 1, 'common_quick_start', 'text_quick_start_general', '    	Below are most common general settings. \n    	More settings are available <a href="%s" target="_new_admin"><i class="fa fa-link fa-fw"></i></a>\n    ', '[[regtime]]', '[[regtime]]'),
(1878, 1, 1, 'common_quick_start', 'text_quick_start_details', '    	Below are most common settings about your store. \n    	More settings are available <a href="%s" target="_new_admin"><i class="fa fa-link fa-fw"></i></a>\n    ', '[[regtime]]', '[[regtime]]'),
(1879, 1, 1, 'common_quick_start', 'text_quick_start_checkout', '    	Below are most common settings for checkout process. \n    	More settings are available <a href="%s" target="_new_admin"><i class="fa fa-link fa-fw"></i></a>\n    ', '[[regtime]]', '[[regtime]]'),
(1880, 1, 1, 'common_quick_start', 'text_quick_start_appearance', '    	Below are most common settings for storefront appearance. \n    	More settings are available <a href="%s" target="_new_admin"><i class="fa fa-link fa-fw"></i></a>\n    ', '[[regtime]]', '[[regtime]]'),
(1881, 1, 1, 'common_quick_start', 'text_quick_start_mail', '    	Below are most common settings to enable email. If you use external email server (google, etc) to send emails, you need to use SMTP option. For emails to be sent from this server use Mail option. \n    	More settings are available <a href="%s" target="_new_admin"><i class="fa fa-link fa-fw"></i></a>\n    ', '[[regtime]]', '[[regtime]]'),
(1882, 1, 1, 'common_quick_start', 'text_quick_start_last', '    	Bellow you can select desired payments and shipping methods, additional languages and many other features to extend your eCommerce functionality.\n    	Remember to check a selection of extensions on <a href="#admin#rt=extension/extensions_store" target="_extension">AbanteCart marketplace</a> offered by community of professional developers.\n    ', '[[regtime]]', '[[regtime]]'),
(1883, 1, 1, 'common_quick_start', 'text_quick_start_last_footer', '    	You have completed quick starter wizard. <br /><br /> \n    	You can locate all the settings <a href="%s">this link <i class="fa fa-link fa-fw"></i></a>\n    ', '[[regtime]]', '[[regtime]]'),
(1884, 1, 1, 'common_quick_start', 'payments_selection', '    <div class="info alert alert-info">\n    <i class="fa fa-money fa-fw"></i> Select your payment methods.\n    </div>\n    <div class="row">\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=stripe" target="_extension">\n	        <img style="width: 94px; width: height: 94px;" src="extensions/stripe/image/icon.png"><br>Stripe</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=cardknox" target="_extension">\n	        <img style="width: 94px; width: height: 94px;" src="extensions/cardknox/image/icon.png"><br>CardKnox</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=paypal_commerce" target="_extension">\n	        <img style="width: 94px; width: height: 94px;" src="extensions/paypal_commerce/image/icon.png"><br>Paypal Commerce</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/payment" target="_extension">\n	        <img src="admin/view/default/image/default_extension.png"><br>More Payments</a>\n	    </div>\n    </div>\n    ', '[[regtime]]', '[[regtime]]'),
(1885, 1, 1, 'common_quick_start', 'shipping_selection', '    <div class="info alert alert-info">\n    <i class="fa fa-truck fa-fw"></i> Select your shipping methods.\n    </div>\n    <div class="row">\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=default_free_shipping" target="_extension">\n	        <img src="extensions/default_free_shipping/image/icon.png"><br>Free shipping</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=default_fedex" target="_extension">\n	        <img src="extensions/default_fedex/image/icon.png"><br>Fedex</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=default_local_delivery" target="_extension">\n	        <img src="extensions/default_local_delivery/image/icon.png"><br>Local Delivery</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/shipping" target="_extension">\n	        <img src="admin/view/default/image/default_extension.png"><br>More Shippings</a>\n	    </div>\n    </div>\n    ', '[[regtime]]', '[[regtime]]'),
(1886, 1, 1, 'common_quick_start', 'language_selection', '    <div class="info alert alert-info">\n    <i class="fa fa-language fa-fw"></i> Select additional languages.\n    </div>\n    <div class="row">\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=default_italian" target="_extension">\n	        <img src="extensions/default_italian/image/icon.png"><br>Italian</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=default_spanish" target="_extension">\n	        <img src="extensions/default_spanish/image/icon.png"><br>Spanish</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=default_russian" target="_extension">\n	        <img src="extensions/default_russian/image/icon.png"><br>Russian</a>\n	    </div>\n	    <div class="col-sm-3 h5 center">\n	        <a href="#admin#rt=extension/extensions_store&category_id=67&sidx=date_modified" target="_extension">\n	        <img src="admin/view/default/image/default_extension.png"><br>More Languages</a>\n	    </div>\n    </div>\n    ', '[[regtime]]', '[[regtime]]'),
(1887, 1, 1, 'common_quick_start', 'more_extensions', '    <div class="info alert alert-info">\n    <i class="fa fa-puzzle-piece fa-fw"></i> More extensions on AbanteCart marketplace.\n    </div>\n    <div class="row center">\n		<div class="btn-group center">\n		    <a class="btn btn-primary" href="#admin#rt=extension/extensions_store" target="_extension">\n		    	<i class="fa fa-cloud-download fa-fw"></i> Extensions Marketplace\n		    </a>\n		</div>\n    </div>\n    ', '[[regtime]]', '[[regtime]]'),
(1888, 1, 1, 'common_resource_library', 'heading_title', 'Resource Library', '[[regtime]]', '[[regtime]]'),
(1889, 1, 1, 'common_resource_library', 'view_title', 'View Object Resources', '[[regtime]]', '[[regtime]]'),
(1890, 1, 1, 'common_resource_library', 'confirm_title', 'Confirm resource(s) delete', '[[regtime]]', '[[regtime]]'),
(1891, 1, 1, 'common_resource_library', 'text_confirm_delete', 'Some resources might be included in the text. We can not check this automatically.  Delete?', '[[regtime]]', '[[regtime]]'),
(1892, 1, 1, 'common_resource_library', 'text_cant_delete_title', 'Resource(s) delete', '[[regtime]]', '[[regtime]]'),
(1893, 1, 1, 'common_resource_library', 'text_cant_delete', 'Cant delete resource(s) because one or more resources is linked to object', '[[regtime]]', '[[regtime]]'),
(1894, 1, 1, 'common_resource_library', 'text_edit_resource', 'Edit Resource', '[[regtime]]', '[[regtime]]'),
(1895, 1, 1, 'common_resource_library', 'text_resource_details', 'Resource Details', '[[regtime]]', '[[regtime]]'),
(1896, 1, 1, 'common_resource_library', 'text_mapped_to', 'Linked To', '[[regtime]]', '[[regtime]]'),
(1897, 1, 1, 'common_resource_library', 'text_products', 'Products', '[[regtime]]', '[[regtime]]'),
(1898, 1, 1, 'common_resource_library', 'text_add_file', 'Add Resource File', '[[regtime]]', '[[regtime]]'),
(1899, 1, 1, 'common_resource_library', 'text_add_code', 'Add Resource HTML', '[[regtime]]', '[[regtime]]'),
(1900, 1, 1, 'common_resource_library', 'text_add_files', 'Add files...', '[[regtime]]', '[[regtime]]'),
(1901, 1, 1, 'common_resource_library', 'text_upload_files', 'Upload files', '[[regtime]]', '[[regtime]]'),
(1902, 1, 1, 'common_resource_library', 'text_drag', 'or Drag them here to start upload', '[[regtime]]', '[[regtime]]'),
(1903, 1, 1, 'common_resource_library', 'text_start_upload', 'Start upload', '[[regtime]]', '[[regtime]]'),
(1904, 1, 1, 'common_resource_library', 'text_cancel_upload', 'Cancel upload', '[[regtime]]', '[[regtime]]'),
(1905, 1, 1, 'common_resource_library', 'text_start', 'Start', '[[regtime]]', '[[regtime]]'),
(1906, 1, 1, 'common_resource_library', 'text_cancel', 'Cancel', '[[regtime]]', '[[regtime]]'),
(1907, 1, 1, 'common_resource_library', 'text_save_sort_order', 'Save Sort Order', '[[regtime]]', '[[regtime]]'),
(1908, 1, 1, 'common_resource_library', 'text_error', 'Error', '[[regtime]]', '[[regtime]]'),
(1909, 1, 1, 'common_resource_library', 'text_delete_files', 'Delete files', '[[regtime]]', '[[regtime]]'),
(1910, 1, 1, 'common_resource_library', 'text_search', 'search', '[[regtime]]', '[[regtime]]'),
(1911, 1, 1, 'common_resource_library', 'text_type', 'Type', '[[regtime]]', '[[regtime]]'),
(1912, 1, 1, 'common_resource_library', 'text_resource_code', 'Resource HTML', '[[regtime]]', '[[regtime]]'),
(1913, 1, 1, 'common_resource_library', 'text_name', 'Name', '[[regtime]]', '[[regtime]]'),
(1914, 1, 1, 'common_resource_library', 'text_title', 'Title', '[[regtime]]', '[[regtime]]'),
(1915, 1, 1, 'common_resource_library', 'text_description', 'Description', '[[regtime]]', '[[regtime]]'),
(1916, 1, 1, 'common_resource_library', 'text_uploaded', 'Success: Resource has been uploaded!', '[[regtime]]', '[[regtime]]'),
(1917, 1, 1, 'common_resource_library', 'text_add', 'Add', '[[regtime]]', '[[regtime]]'),
(1918, 1, 1, 'common_resource_library', 'text_edit', 'Edit', '[[regtime]]', '[[regtime]]'),
(1919, 1, 1, 'common_resource_library', 'text_map', 'Link to Object', '[[regtime]]', '[[regtime]]'),
(1920, 1, 1, 'common_resource_library', 'text_map_to', 'Link to %s', '[[regtime]]', '[[regtime]]'),
(1921, 1, 1, 'common_resource_library', 'text_unmap', 'Unlink from Object', '[[regtime]]', '[[regtime]]'),
(1922, 1, 1, 'common_resource_library', 'text_unmap_from', 'Unlink from %s', '[[regtime]]', '[[regtime]]'),
(1923, 1, 1, 'common_resource_library', 'text_success_unmap', 'Success: Resource has been unlinked.', '[[regtime]]', '[[regtime]]'),
(1924, 1, 1, 'common_resource_library', 'text_file_delete', 'Resource has been deleted!', '[[regtime]]', '[[regtime]]'),
(1925, 1, 1, 'common_resource_library', 'text_delete', 'Success: Your Resource has been deleted!', '[[regtime]]', '[[regtime]]'),
(1926, 1, 1, 'common_resource_library', 'error_file_type', 'Warning: Incorrect file type!', '[[regtime]]', '[[regtime]]'),
(1927, 1, 1, 'common_resource_library', 'error_file_size', 'Warning: File to big please keep below 300kb and no more than 1000px height or width!', '[[regtime]]', '[[regtime]]'),
(1928, 1, 1, 'common_resource_library', 'error_maxFileSize', 'File is too big', '[[regtime]]', '[[regtime]]'),
(1929, 1, 1, 'common_resource_library', 'error_minFileSize', 'File is too small', '[[regtime]]', '[[regtime]]'),
(1930, 1, 1, 'common_resource_library', 'error_acceptFileTypes', 'Filetype not allowed', '[[regtime]]', '[[regtime]]'),
(1931, 1, 1, 'common_resource_library', 'error_maxNumberOfFiles', 'Max number of files exceeded', '[[regtime]]', '[[regtime]]'),
(1932, 1, 1, 'common_resource_library', 'error_uploadedBytes', 'Uploaded bytes exceed file size', '[[regtime]]', '[[regtime]]'),
(1933, 1, 1, 'common_resource_library', 'error_emptyResult', 'Empty file upload result. Possibly file is corrupted or too big. File size limited to 16MB. If file size is less than limit please check php settings for upload_max_filesize & post_max_size  ', '[[regtime]]', '[[regtime]]'),
(1934, 1, 1, 'common_resource_library', 'error_1', 'File exceeds upload_max_filesize (php.ini directive)', '[[regtime]]', '[[regtime]]'),
(1935, 1, 1, 'common_resource_library', 'error_2', 'File exceeds MAX_FILE_SIZE (HTML form directive)', '[[regtime]]', '[[regtime]]'),
(1936, 1, 1, 'common_resource_library', 'error_3', 'File was only partially uploaded', '[[regtime]]', '[[regtime]]'),
(1937, 1, 1, 'common_resource_library', 'error_4', 'No File was uploaded', '[[regtime]]', '[[regtime]]'),
(1938, 1, 1, 'common_resource_library', 'error_5', 'Missing a temporary folder', '[[regtime]]', '[[regtime]]'),
(1939, 1, 1, 'common_resource_library', 'error_6', 'Failed to write file to disk', '[[regtime]]', '[[regtime]]'),
(1940, 1, 1, 'common_resource_library', 'error_7', 'File upload stopped by extension', '[[regtime]]', '[[regtime]]'),
(1941, 1, 1, 'common_resource_library', 'error_uploaded', 'Warning: File could not be uploaded for an unknown reason!', '[[regtime]]', '[[regtime]]'),
(1942, 1, 1, 'common_resource_library', 'error_no_type', 'Please select resource type', '[[regtime]]', '[[regtime]]'),
(1943, 1, 1, 'common_resource_library', 'error_required_data', 'Required Data has not been entered', '[[regtime]]', '[[regtime]]'),
(1944, 1, 1, 'common_resource_library', 'error_not_added', 'Resource not added. Please check error log for more info', '[[regtime]]', '[[regtime]]'),
(1945, 1, 1, 'common_resource_library', 'error_ajax', 'Load data error. Please check error log for more info', '[[regtime]]', '[[regtime]]'),
(1946, 1, 1, 'common_resource_library', 'error_permission', 'Warning: Permission Denied!', '[[regtime]]', '[[regtime]]'),
(1947, 1, 1, 'common_resource_library', 'error_name', 'Error: Name field is required!', '[[regtime]]', '[[regtime]]'),
(1948, 1, 1, 'common_resource_library', 'button_delete', 'Delete', '[[regtime]]', '[[regtime]]'),
(1949, 1, 1, 'common_resource_library', 'button_add', 'Add Resource', '[[regtime]]', '[[regtime]]'),
(1950, 1, 1, 'common_resource_library', 'button_done', 'Done', '[[regtime]]', '[[regtime]]'),
(1951, 1, 1, 'common_resource_library', 'button_select', 'Select Resources', '[[regtime]]', '[[regtime]]'),
(1952, 1, 1, 'common_resource_library', 'text_with_selected', 'With selected:', '[[regtime]]', '[[regtime]]'),
(1953, 1, 1, 'common_resource_library', 'text_success', 'Resource successfully updated', '[[regtime]]', '[[regtime]]'),
(1954, 1, 1, 'common_resource_library', 'text_map_success', 'Resource successfully linked', '[[regtime]]', '[[regtime]]'),
(1955, 1, 1, 'common_resource_library', 'text_no_resources', 'No resources available', '[[regtime]]', '[[regtime]]'),
(1956, 1, 1, 'common_resource_library', 'text_preview', 'Preview/Download', '[[regtime]]', '[[regtime]]'),
(1957, 1, 1, 'common_resource_library', 'error_file size', 'Attention: Maximum size of file for upload is %s. You can increase this value in php.ini.', '[[regtime]]', '[[regtime]]'),
(1958, 1, 1, 'common_resource_library', 'text_product_option_value', 'Product options value', '[[regtime]]', '[[regtime]]'),
(1959, 1, 1, 'common_resource_library', 'text_categories', 'Categories', '[[regtime]]', '[[regtime]]'),
(1960, 1, 1, 'common_resource_library', 'text_manufacturers', 'Brands', '[[regtime]]', '[[regtime]]'),
(1961, 1, 1, 'common_resource_library', 'error_delete', 'Cannot delete resource linked to multiple objects', '[[regtime]]', '[[regtime]]'),
(1962, 1, 1, 'common_resource_library', 'error_unmap', 'Cannot unlink resource. Object wasn''t set.', '[[regtime]]', '[[regtime]]'),
(1963, 1, 1, 'common_resource_library', 'text_replace_file', 'Replace File', '[[regtime]]', '[[regtime]]'),
(1964, 1, 1, 'common_resource_library', 'error_not_replaced', 'File Replacement Error. ID required!', '[[regtime]]', '[[regtime]]'),
(1965, 1, 1, 'common_resource_library', 'error_not_exists', 'File Replacement Error. Resource does not exists!', '[[regtime]]', '[[regtime]]'),
(1966, 1, 1, 'common_resource_library', 'error_cannot_move', 'Error: Cannot move file %s to resources directory.', '[[regtime]]', '[[regtime]]'),
(1967, 1, 1, 'common_resource_library', 'button_save_n_apply', 'Save and Apply', '[[regtime]]', '[[regtime]]'),
(1968, 1, 1, 'common_resource_library', 'text_image_size', 'Image size:', '[[regtime]]', '[[regtime]]'),
(1969, 1, 1, 'common_resource_library', 'text_file_size', 'File size:', '[[regtime]]', '[[regtime]]'),
(1970, 1, 1, 'common_resource_library', 'text_file_mime', 'MIME:', '[[regtime]]', '[[regtime]]'),
(1971, 1, 1, 'common_resource_library', 'text_file_path', 'File location:', '[[regtime]]', '[[regtime]]'),
(1972, 1, 1, 'common_resource_library', 'text_file_url', 'Resource URL:', '[[regtime]]', '[[regtime]]'),
(1973, 1, 1, 'common_resource_library', 'text_sorting_date_asc', 'Date Old &gt; New', '[[regtime]]', '[[regtime]]'),
(1974, 1, 1, 'common_resource_library', 'text_sorting_date_desc', 'Date New &gt; Old', '[[regtime]]', '[[regtime]]'),
(1975, 1, 1, 'common_resource_library', 'text_sorting_name_asc', 'Name A - Z', '[[regtime]]', '[[regtime]]'),
(1976, 1, 1, 'common_resource_library', 'text_sorting_name_desc', 'Name Z - A', '[[regtime]]', '[[regtime]]'),
(1977, 1, 1, 'common_resource_library', 'text_sorting_asc', 'Sort Order Low &gt; High', '[[regtime]]', '[[regtime]]'),
(1978, 1, 1, 'common_resource_library', 'text_sorting_desc', 'Sort Order High &gt; Low', '[[regtime]]', '[[regtime]]'),
(1979, 1, 1, 'common_template_debug', 'text_block_id', 'Block ID:', '[[regtime]]', '[[regtime]]'),
(1980, 1, 1, 'common_template_debug', 'text_block_name', 'Name:', '[[regtime]]', '[[regtime]]'),
(1981, 1, 1, 'common_template_debug', 'text_block_controller', 'Controller:', '[[regtime]]', '[[regtime]]'),
(1982, 1, 1, 'common_template_debug', 'text_block_path', 'Path:', '[[regtime]]', '[[regtime]]'),
(1983, 1, 1, 'common_template_debug', 'text_block_template', 'Template:', '[[regtime]]', '[[regtime]]'),
(1984, 1, 1, 'common_template_debug', 'text_block_parent', 'Parent:', '[[regtime]]', '[[regtime]]'),
(1985, 1, 1, 'common_template_debug', 'text_parent_id', 'Parent ID:', '[[regtime]]', '[[regtime]]'),
(1986, 1, 1, 'common_template_debug', 'text_close', 'Close', '[[regtime]]', '[[regtime]]'),
(1987, 1, 1, 'common_template_debug', 'text_click', 'Click Me', '[[regtime]]', '[[regtime]]'),
(1988, 1, 1, 'common_tips', 'text_tip', 'Tip', '[[regtime]]', '[[regtime]]'),
(1989, 1, 1, 'common_tips', 'no_enabled_payments_tip', '    <div class="info alert alert-warning"><i class="fa fa fa-exclamation-triangle fa-fw"></i> You have no payment method enabled yet.</div>\n    <label class="h4 heading">Check most common payments:</label>\n    <div class="row">\n	    <div class="col-sm-4 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=stripe">\n	        <img src="extensions/stripe/image/icon.png"><br>Install Stripe Extension</a>\n	    </div>\n	    <div class="col-sm-4 h5 center">\n	        <a href="#admin#rt=extension/extensions/install&extension=paypal_commerce">\n	        <img src="extensions/paypal_commerce/image/icon.png"><br>Install Paypal Extension</a>\n	    </div>\n	    <div class="col-sm-4 h5 center">\n	        <a href="#admin#rt=extension/extensions/payment" target="_extension">\n	        <img src="admin/view/default/image/default_extension.png"><br>More Payments</a>\n	    </div>\n    </div>\n\n    ', '[[regtime]]', '[[regtime]]'),
(1990, 1, 1, 'design_blocks', 'heading_title', 'Blocks', '[[regtime]]', '[[regtime]]'),
(1991, 1, 1, 'design_blocks', 'text_delete', 'delete block', '[[regtime]]', '[[regtime]]'),
(1992, 1, 1, 'design_blocks', 'text_edit', 'edit block', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(1993, 1, 1, 'design_blocks', 'text_enable', 'Enable/Disable', '[[regtime]]', '[[regtime]]'),
(1994, 1, 1, 'design_blocks', 'text_details', 'Details', '[[regtime]]', '[[regtime]]'),
(1995, 1, 1, 'design_blocks', 'text_create', 'Create block', '[[regtime]]', '[[regtime]]'),
(1996, 1, 1, 'design_blocks', 'text_success', 'Success: You have modified block!', '[[regtime]]', '[[regtime]]'),
(1997, 1, 1, 'design_blocks', 'column_block_id', 'ID', '[[regtime]]', '[[regtime]]'),
(1998, 1, 1, 'design_blocks', 'column_block_txt_id', ' Unique Text ID ', '[[regtime]]', '[[regtime]]'),
(1999, 1, 1, 'design_blocks', 'column_block_name', 'Name', '[[regtime]]', '[[regtime]]'),
(2000, 1, 1, 'design_blocks', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(2001, 1, 1, 'design_blocks', 'column_block_type', ' Type ', '[[regtime]]', '[[regtime]]'),
(2002, 1, 1, 'design_blocks', 'column_action', ' Action ', '[[regtime]]', '[[regtime]]'),
(2003, 1, 1, 'design_blocks', 'column_sort_order', ' Sort Order ', '[[regtime]]', '[[regtime]]'),
(2004, 1, 1, 'design_blocks', 'column_image', ' Image ', '[[regtime]]', '[[regtime]]'),
(2005, 1, 1, 'design_blocks', 'entry_block_status', ' Status ', '[[regtime]]', '[[regtime]]'),
(2006, 1, 1, 'design_blocks', 'entry_block_status_note', ' Note: You need to add this block in the <a style="text-decoration: underline; font-weight: bold;" href="#admin#rt=design/layout">LAYOUT</a> on desired page to see it working ', '[[regtime]]', '[[regtime]]'),
(2007, 1, 1, 'design_blocks', 'entry_block_type', ' Custom Block Type ', '[[regtime]]', '[[regtime]]'),
(2008, 1, 1, 'design_blocks', 'entry_block_name', ' Custom Block Name ', '[[regtime]]', '[[regtime]]'),
(2009, 1, 1, 'design_blocks', 'entry_block_wrapper', ' Use block wrapper (appearance) ', '[[regtime]]', '[[regtime]]'),
(2010, 1, 1, 'design_blocks', 'entry_block_framed', ' Use block''s frame ', '[[regtime]]', '[[regtime]]'),
(2011, 1, 1, 'design_blocks', 'entry_block_title', ' Custom Block Title ', '[[regtime]]', '[[regtime]]'),
(2012, 1, 1, 'design_blocks', 'entry_block_description', ' Custom Block description <p>Note: internal use only </p> ', '[[regtime]]', '[[regtime]]'),
(2013, 1, 1, 'design_blocks', 'entry_block_content', ' Custom Block content ', '[[regtime]]', '[[regtime]]'),
(2014, 1, 1, 'design_blocks', 'entry_listing_datasource', ' Listing Data Source ', '[[regtime]]', '[[regtime]]'),
(2015, 1, 1, 'design_blocks', 'text_delete_confirm', ' Confirm to delete block? ', '[[regtime]]', '[[regtime]]'),
(2016, 1, 1, 'design_blocks', 'error_empty', 'Please Fill All Required Fields!', '[[regtime]]', '[[regtime]]'),
(2017, 1, 1, 'design_blocks', 'error_delete', 'Can''t delete because this block is in use. Please visit Layout section. ', '[[regtime]]', '[[regtime]]'),
(2018, 1, 1, 'design_blocks', 'error_text_status', 'Can''t change status because this block is not in use. Please visit Layout section. ', '[[regtime]]', '[[regtime]]'),
(2019, 1, 1, 'design_blocks', 'text_success_deleted', 'Success: You have deleted custom block!', '[[regtime]]', '[[regtime]]'),
(2020, 1, 1, 'design_blocks', 'entry_data_source', 'Data Source:', '[[regtime]]', '[[regtime]]'),
(2021, 1, 1, 'design_blocks', 'entry_limit', 'Limit:', '[[regtime]]', '[[regtime]]'),
(2022, 1, 1, 'design_blocks', 'text_listing_auto', 'Auto listing', '[[regtime]]', '[[regtime]]'),
(2023, 1, 1, 'design_blocks', 'text_listing_manual', 'Custom listing', '[[regtime]]', '[[regtime]]'),
(2024, 1, 1, 'design_blocks', 'text_select_listing', '--- select data listing source ---', '[[regtime]]', '[[regtime]]'),
(2025, 1, 1, 'design_blocks', 'text_products_special', 'Special Offers', '[[regtime]]', '[[regtime]]'),
(2026, 1, 1, 'design_blocks', 'text_products_related', 'Related Products', '[[regtime]]', '[[regtime]]'),
(2027, 1, 1, 'design_blocks', 'text_products_popular', 'Popular Products', '[[regtime]]', '[[regtime]]'),
(2028, 1, 1, 'design_blocks', 'text_categories', 'All Categories', '[[regtime]]', '[[regtime]]'),
(2029, 1, 1, 'design_blocks', 'text_manufacturers', 'All Brands', '[[regtime]]', '[[regtime]]'),
(2030, 1, 1, 'design_blocks', 'text_featured', 'Featured Products', '[[regtime]]', '[[regtime]]'),
(2031, 1, 1, 'design_blocks', 'text_latest', 'Latest Products', '[[regtime]]', '[[regtime]]'),
(2032, 1, 1, 'design_blocks', 'text_bestsellers', 'Bestsellers Products', '[[regtime]]', '[[regtime]]'),
(2033, 1, 1, 'design_blocks', 'text_media', 'Media', '[[regtime]]', '[[regtime]]'),
(2034, 1, 1, 'design_blocks', 'entry_resource_type', 'Media Type:', '[[regtime]]', '[[regtime]]'),
(2035, 1, 1, 'design_blocks', 'text_custom_products', 'Selected Products', '[[regtime]]', '[[regtime]]'),
(2036, 1, 1, 'design_blocks', 'text_custom_categories', 'Selected Categories', '[[regtime]]', '[[regtime]]'),
(2037, 1, 1, 'design_blocks', 'text_custom_manufacturers', 'Selected Brands', '[[regtime]]', '[[regtime]]'),
(2038, 1, 1, 'design_blocks', 'text_selected_content', 'Selected Content', '[[regtime]]', '[[regtime]]'),
(2039, 1, 1, 'design_blocks', 'text_html_block', 'HTML', '[[regtime]]', '[[regtime]]'),
(2040, 1, 1, 'design_blocks', 'text_listing_block', 'Data Listing', '[[regtime]]', '[[regtime]]'),
(2041, 1, 1, 'design_blocks', 'text_selected', ' Selected items: ', '[[regtime]]', '[[regtime]]'),
(2042, 1, 1, 'design_blocks', 'text_data_listed', ' Data to be listed ', '[[regtime]]', '[[regtime]]'),
(2043, 1, 1, 'design_blocks', 'text_save_edit', ' Add / Edit ', '[[regtime]]', '[[regtime]]'),
(2044, 1, 1, 'design_blocks', 'text_apply', ' Apply selection ', '[[regtime]]', '[[regtime]]'),
(2045, 1, 1, 'design_blocks', 'text_block_id', ' Block ID ', '[[regtime]]', '[[regtime]]'),
(2046, 1, 1, 'design_blocks', 'text_block_txt_id', ' Block Text ID ', '[[regtime]]', '[[regtime]]'),
(2047, 1, 1, 'design_blocks', 'text_controller', ' Controller ', '[[regtime]]', '[[regtime]]'),
(2048, 1, 1, 'design_blocks', 'text_templates', ' Block Templates ', '[[regtime]]', '[[regtime]]'),
(2049, 1, 1, 'design_blocks', 'text_block_date_added', ' Block Creation Date ', '[[regtime]]', '[[regtime]]'),
(2050, 1, 1, 'design_blocks', 'text_layouts', ' Used in layouts ', '[[regtime]]', '[[regtime]]'),
(2051, 1, 1, 'design_blocks', 'text_block_info', ' Information About Custom Block ', '[[regtime]]', '[[regtime]]'),
(2052, 1, 1, 'design_blocks', 'text_add_block', 'Adding block to section', '[[regtime]]', '[[regtime]]'),
(2053, 1, 1, 'design_blocks', 'text_available_block', 'Available Blocks', '[[regtime]]', '[[regtime]]'),
(2054, 1, 1, 'design_blocks', 'error_block_not_available', 'This block will not be displayed in selected position on a storefront!', '[[regtime]]', '[[regtime]]'),
(2055, 1, 1, 'design_blocks', 'text_collection', 'Collection', '[[regtime]]', '[[regtime]]'),
(2056, 1, 1, 'design_blocks', 'entry_collection_resource_type', 'Selected Collection:', '[[regtime]]', '[[regtime]]'),
(2057, 1, 1, 'design_blocks', 'text_top_level', 'Top Level', '[[regtime]]', '[[regtime]]'),
(2058, 1, 1, 'design_content', 'heading_title', 'Content Manager', '[[regtime]]', '[[regtime]]'),
(2059, 1, 1, 'design_content', 'insert_title', 'Add New Content', '[[regtime]]', '[[regtime]]'),
(2060, 1, 1, 'design_content', 'update_title', 'Update Content', '[[regtime]]', '[[regtime]]'),
(2061, 1, 1, 'design_content', 'text_success', 'Success: You have modified content!', '[[regtime]]', '[[regtime]]'),
(2062, 1, 1, 'design_content', 'text_success_layout', 'Success: You have modified content page layout.', '[[regtime]]', '[[regtime]]'),
(2063, 1, 1, 'design_content', 'text_hidden', 'Hidden', '[[regtime]]', '[[regtime]]'),
(2064, 1, 1, 'design_content', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(2065, 1, 1, 'design_content', 'column_title', 'Content Title', '[[regtime]]', '[[regtime]]'),
(2066, 1, 1, 'design_content', 'column_parent', 'Parent Content', '[[regtime]]', '[[regtime]]'),
(2067, 1, 1, 'design_content', 'entry_parent', 'Parent Content Page', '[[regtime]]', '[[regtime]]'),
(2068, 1, 1, 'design_content', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(2069, 1, 1, 'design_content', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2070, 1, 1, 'design_content', 'column_publish_date', 'Publish Date', '[[regtime]]', '[[regtime]]'),
(2071, 1, 1, 'design_content', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2072, 1, 1, 'design_content', 'entry_title', 'Content Title:', '[[regtime]]', '[[regtime]]'),
(2073, 1, 1, 'design_content', 'entry_description', 'Description:<br /><span class="help">HTML tags are not suggested for the content description! This depends on your storefront template</span>', '[[regtime]]', '[[regtime]]'),
(2074, 1, 1, 'design_content', 'entry_content', 'Content:', '[[regtime]]', '[[regtime]]'),
(2075, 1, 1, 'design_content', 'entry_store', 'Stores:', '[[regtime]]', '[[regtime]]'),
(2076, 1, 1, 'design_content', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2077, 1, 1, 'design_content', 'entry_keyword', 'SEO Keyword:', '[[regtime]]', '[[regtime]]'),
(2078, 1, 1, 'design_content', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(2079, 1, 1, 'design_content', 'entry_publish_date', 'Publish Date:', '[[regtime]]', '[[regtime]]'),
(2080, 1, 1, 'design_content', 'entry_expire_date', 'Expiration Date:', '[[regtime]]', '[[regtime]]'),
(2081, 1, 1, 'design_content', 'entry_content_bar', 'Content Details Bar:<br /><span class="help">Enable this setting to show the bar with the author and publish date on the content page</span>', '[[regtime]]', '[[regtime]]'),
(2082, 1, 1, 'design_content', 'entry_icon', 'Main Image or Icon:', '[[regtime]]', '[[regtime]]'),
(2083, 1, 1, 'design_content', 'entry_tags', 'Content Tags:<br /><span class="help">comma separated list</span>', '[[regtime]]', '[[regtime]]'),
(2084, 1, 1, 'design_content', 'entry_author', 'Author:', '[[regtime]]', '[[regtime]]'),
(2085, 1, 1, 'design_content', 'error_permission', 'Warning: You do not have permission to modify content!', '[[regtime]]', '[[regtime]]'),
(2086, 1, 1, 'design_content', 'error_title', 'Content Title must be between 2 and 255 characters!', '[[regtime]]', '[[regtime]]'),
(2087, 1, 1, 'design_content', 'error_title_html', 'Content Title cannot contain HTML tags!', '[[regtime]]', '[[regtime]]'),
(2088, 1, 1, 'design_content', 'error_description', 'Description must be more than 1 characters!', '[[regtime]]', '[[regtime]]'),
(2089, 1, 1, 'design_content', 'error_description_html', 'Content description HTML tags are not supported!', '[[regtime]]', '[[regtime]]'),
(2090, 1, 1, 'design_content', 'error_content', 'Content must be more than 1 characters!', '[[regtime]]', '[[regtime]]'),
(2091, 1, 1, 'design_content', 'error_seo_url', 'SEO URL must be more than 1 characters!', '[[regtime]]', '[[regtime]]'),
(2092, 1, 1, 'design_content', 'error_account', 'Warning: This content cannot be deleted as it is currently assigned as the default store account terms!', '[[regtime]]', '[[regtime]]'),
(2093, 1, 1, 'design_content', 'error_checkout', 'Warning: This content cannot be deleted as it is currently assigned as the default store checkout terms!', '[[regtime]]', '[[regtime]]'),
(2094, 1, 1, 'design_content', 'error_delete_parent', 'Warning: Parent contents cannot be deleted! Move or delete child content pages first.', '[[regtime]]', '[[regtime]]'),
(2095, 1, 1, 'design_content', 'error_required_data', 'Required Data has not been entered. Check for field errors!', '[[regtime]]', '[[regtime]]'),
(2096, 1, 1, 'design_content', 'text_top_level', 'Top Level', '[[regtime]]', '[[regtime]]'),
(2097, 1, 1, 'design_content', 'text_any', 'any', '[[regtime]]', '[[regtime]]'),
(2098, 1, 1, 'design_content', 'tab_form', ' Edit ', '[[regtime]]', '[[regtime]]'),
(2099, 1, 1, 'design_content', 'entry_meta_description', ' Meta Tag Description: ', '[[regtime]]', '[[regtime]]'),
(2100, 1, 1, 'design_content', 'entry_meta_keywords', 'Meta Tag Keywords:', '[[regtime]]', '[[regtime]]'),
(2101, 1, 1, 'design_content', 'text_clone', 'Clone', '[[regtime]]', '[[regtime]]'),
(2102, 1, 1, 'design_content', 'text_success_copy', 'Success: You have successfully copied content page <b>%s</b>!', '[[regtime]]', '[[regtime]]'),
(2103, 1, 1, 'design_content', 'text_success_copy_layout', ' Note: Content page layout has been cloned as well.', '[[regtime]]', '[[regtime]]'),
(2104, 1, 1, 'design_content', 'text_error_copy', 'Cloning has failed! Original content page is not available', '[[regtime]]', '[[regtime]]'),
(2105, 1, 1, 'design_email_templates', 'email_templates', 'Email Templates', '[[regtime]]', '[[regtime]]'),
(2106, 1, 1, 'design_email_templates', 'heading_title', 'Email Templates', '[[regtime]]', '[[regtime]]'),
(2107, 1, 1, 'design_email_templates', 'column_text_id', 'Email Template Text ID', '[[regtime]]', '[[regtime]]'),
(2108, 1, 1, 'design_email_templates', 'column_language', 'Language', '[[regtime]]', '[[regtime]]'),
(2109, 1, 1, 'design_email_templates', 'column_subject', 'Subject', '[[regtime]]', '[[regtime]]'),
(2110, 1, 1, 'design_email_templates', 'button_save', 'Save', '[[regtime]]', '[[regtime]]'),
(2111, 1, 1, 'design_email_templates', 'entry_status', 'Status: ', '[[regtime]]', '[[regtime]]'),
(2112, 1, 1, 'design_email_templates', 'entry_text_id', 'Text ID: ', '[[regtime]]', '[[regtime]]'),
(2113, 1, 1, 'design_email_templates', 'entry_language_id', 'Language: ', '[[regtime]]', '[[regtime]]'),
(2114, 1, 1, 'design_email_templates', 'entry_headers', 'Custom Headers: ', '[[regtime]]', '[[regtime]]'),
(2115, 1, 1, 'design_email_templates', 'entry_subject', 'Subject: ', '[[regtime]]', '[[regtime]]'),
(2116, 1, 1, 'design_email_templates', 'entry_html_body', 'Html Body: ', '[[regtime]]', '[[regtime]]'),
(2117, 1, 1, 'design_email_templates', 'entry_text_body', 'Text Body: ', '[[regtime]]', '[[regtime]]'),
(2118, 1, 1, 'design_email_templates', 'entry_allowed_placeholders', 'Allowed Placeholders:<br /><span class="help">Coma separated list of variable names</span>', '[[regtime]]', '[[regtime]]'),
(2119, 1, 1, 'design_email_templates', 'save_complete', 'Save Complete', '[[regtime]]', '[[regtime]]'),
(2120, 1, 1, 'design_email_templates', 'save_error', 'Save Error. Please see log.', '[[regtime]]', '[[regtime]]'),
(2121, 1, 1, 'design_email_templates', 'save_error_text_id', 'Text ID is required and must be up to 254 characters! One word. Charsets: A-Z a-z and _ ', '[[regtime]]', '[[regtime]]'),
(2122, 1, 1, 'design_email_templates', 'save_error_text_id_unique', 'Text ID must be unique!', '[[regtime]]', '[[regtime]]'),
(2123, 1, 1, 'design_email_templates', 'save_error_text_header', 'Headers must be up to 254 characters!', '[[regtime]]', '[[regtime]]'),
(2124, 1, 1, 'design_email_templates', 'save_error_text_subject', 'Subject is required and must be up to 254 characters!', '[[regtime]]', '[[regtime]]'),
(2125, 1, 1, 'design_email_templates', 'save_error_html_body', 'Html Body is required!', '[[regtime]]', '[[regtime]]'),
(2126, 1, 1, 'design_email_templates', 'save_error_text_body', 'Text Body is required!', '[[regtime]]', '[[regtime]]'),
(2127, 1, 1, 'design_email_templates', 'save_error_language_id', 'Language is required!', '[[regtime]]', '[[regtime]]'),
(2128, 1, 1, 'design_email_templates', 'text_preview', 'Preview', '[[regtime]]', '[[regtime]]'),
(2129, 1, 1, 'design_layout', 'heading_title', 'Layout &amp; Blocks Manager', '[[regtime]]', '[[regtime]]'),
(2130, 1, 1, 'design_layout', 'text_select_template', 'Select template: ', '[[regtime]]', '[[regtime]]'),
(2131, 1, 1, 'design_layout', 'text_delete_success', 'Success: Page Layout has been removed!', '[[regtime]]', '[[regtime]]'),
(2132, 1, 1, 'design_layout', 'text_delete_restricted', 'Error: Page Layout is restricted and can not be removed!', '[[regtime]]', '[[regtime]]'),
(2133, 1, 1, 'design_layout', 'text_success', 'Success: You have modified layout &amp; blocks!', '[[regtime]]', '[[regtime]]'),
(2134, 1, 1, 'design_layout', 'text_preview_generated', 'Preview Generated!', '[[regtime]]', '[[regtime]]'),
(2135, 1, 1, 'design_layout', 'text_click_here', 'Click here', '[[regtime]]', '[[regtime]]'),
(2136, 1, 1, 'design_layout', 'text_create_new_layout', 'Create New Page Layout', '[[regtime]]', '[[regtime]]'),
(2137, 1, 1, 'design_layout', 'entry_page_name', 'Page Name:', '[[regtime]]', '[[regtime]]'),
(2138, 1, 1, 'design_layout', 'entry_seo_keyword', 'SEO Keyword:', '[[regtime]]', '[[regtime]]'),
(2139, 1, 1, 'design_layout', 'entry_page_title', 'Page Title:', '[[regtime]]', '[[regtime]]'),
(2140, 1, 1, 'design_layout', 'entry_page_rt', 'Page Route:', '[[regtime]]', '[[regtime]]'),
(2141, 1, 1, 'design_layout', 'entry_key_parameter_name', 'Key Parameter Name:', '[[regtime]]', '[[regtime]]'),
(2142, 1, 1, 'design_layout', 'entry_key_parameter_value', 'Key Parameter Value:', '[[regtime]]', '[[regtime]]'),
(2143, 1, 1, 'design_layout', 'error_template', 'Template Name is Required!', '[[regtime]]', '[[regtime]]'),
(2144, 1, 1, 'design_layout', 'error_page_name', 'Page Name is Required!', '[[regtime]]', '[[regtime]]'),
(2145, 1, 1, 'design_layout', 'error_page_exists', 'Page Name "%s" is already exists.', '[[regtime]]', '[[regtime]]'),
(2146, 1, 1, 'design_layout', 'error_page_rt', '''Page Route is Required!''', '[[regtime]]', '[[regtime]]'),
(2147, 1, 1, 'design_layout', 'error_key_parameter_name', 'Parameter Name is required when value exists.', '[[regtime]]', '[[regtime]]'),
(2148, 1, 1, 'design_layout', 'error_key_parameter_value', 'Parameter Value is required when name is set.', '[[regtime]]', '[[regtime]]'),
(2149, 1, 1, 'design_layout', 'error_seo_keyword', 'SEO-Keyword "%s" is already taken.', '[[regtime]]', '[[regtime]]'),
(2150, 1, 1, 'design_layout', 'error_page_parameters', 'Page with these rt and parameters is already exists.', '[[regtime]]', '[[regtime]]'),
(2151, 1, 1, 'design_menu', 'heading_title', 'Menu', '[[regtime]]', '[[regtime]]'),
(2152, 1, 1, 'design_menu', 'text_success', 'Success: You have modified menu!', '[[regtime]]', '[[regtime]]'),
(2153, 1, 1, 'design_menu', 'entry_item_id', 'Unique ID', '[[regtime]]', '[[regtime]]'),
(2154, 1, 1, 'design_menu', 'entry_item_icon', 'Icon', '[[regtime]]', '[[regtime]]'),
(2155, 1, 1, 'design_menu', 'entry_item_text', 'Text', '[[regtime]]', '[[regtime]]'),
(2156, 1, 1, 'design_menu', 'entry_item_url', 'Link<br /><span class="help">For external links add http:// or https:// in the beginning. You can also use relative URL such as ../subfolder/index.php</span>', '[[regtime]]', '[[regtime]]'),
(2157, 1, 1, 'design_menu', 'entry_item_target', 'Target<br/><span class="help">_self - opens the linked document in the same frame as it was clicked.<br>_blank - opens the linked document in a new window or tab</span>', '[[regtime]]', '[[regtime]]'),
(2158, 1, 1, 'design_menu', 'entry_parent_id', 'Parent', '[[regtime]]', '[[regtime]]'),
(2159, 1, 1, 'design_menu', 'entry_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(2160, 1, 1, 'design_menu', 'entry_link_type', 'Link Type', '[[regtime]]', '[[regtime]]'),
(2161, 1, 1, 'design_menu', 'text_select_parent_id', '- Root Menu -', '[[regtime]]', '[[regtime]]'),
(2162, 1, 1, 'design_menu', 'error_empty', 'Field cannot be Empty!', '[[regtime]]', '[[regtime]]'),
(2163, 1, 1, 'design_menu', 'error_non_unique', 'Item ID not unique!', '[[regtime]]', '[[regtime]]'),
(2164, 1, 1, 'design_menu', 'error_non_ascii', 'Only alphanumeric characters allowed for menu ID field!', '[[regtime]]', '[[regtime]]'),
(2165, 1, 1, 'design_menu', 'text_category_link_type', 'Category Page', '[[regtime]]', '[[regtime]]'),
(2166, 1, 1, 'design_menu', 'text_content_link_type', 'Content Page', '[[regtime]]', '[[regtime]]'),
(2167, 1, 1, 'design_menu', 'text_custom_link_type', 'Custom Link or URL', '[[regtime]]', '[[regtime]]'),
(2168, 1, 1, 'design_menu', 'entry_include_children_items', 'Include children items', '[[regtime]]', '[[regtime]]'),
(2169, 1, 1, 'design_template', 'heading_title', 'Template Manager', '[[regtime]]', '[[regtime]]'),
(2170, 1, 1, 'design_template', 'text_success', 'Success: You have set a new storefront template!', '[[regtime]]', '[[regtime]]'),
(2171, 1, 1, 'design_template', 'text_storefront_templates', 'Available Storefront Templates', '[[regtime]]', '[[regtime]]'),
(2172, 1, 1, 'design_template', 'text_edit_extension', 'Extension Settings', '[[regtime]]', '[[regtime]]'),
(2173, 1, 1, 'design_template', 'text_error', 'Error: Missing required parameter in your request!', '[[regtime]]', '[[regtime]]'),
(2174, 1, 1, 'design_template', 'error_permission', 'Warning: You do not have permission to modify templates!', '[[regtime]]', '[[regtime]]'),
(2175, 1, 1, 'error_error', 'heading_title', 'Application Error!', '[[regtime]]', '[[regtime]]'),
(2176, 1, 1, 'error_error', 'text_error', 'Please check error log for more information', '[[regtime]]', '[[regtime]]'),
(2177, 1, 1, 'error_login', 'heading_title', 'Login Error!', '[[regtime]]', '[[regtime]]'),
(2178, 1, 1, 'error_login', 'text_login', 'You are not logged in. You will be redirected to login page. If problem still presents try to clear cookie. However, your page must be opened in secure mode (https).', '[[regtime]]', '[[regtime]]'),
(2179, 1, 1, 'error_permission', 'heading_title', 'Permission Denied!', '[[regtime]]', '[[regtime]]'),
(2180, 1, 1, 'error_permission', 'text_permission', 'You do not have permission to access this page, please refer to your system administrator.', '[[regtime]]', '[[regtime]]'),
(2181, 1, 1, 'extension_extensions', 'heading_title', 'Extensions', '[[regtime]]', '[[regtime]]'),
(2182, 1, 1, 'extension_extensions', 'text_install', 'Install', '[[regtime]]', '[[regtime]]'),
(2183, 1, 1, 'extension_extensions', 'text_uninstall', 'Uninstall', '[[regtime]]', '[[regtime]]'),
(2184, 1, 1, 'extension_extensions', 'text_uninstall_delete', 'Uninstall/Delete', '[[regtime]]', '[[regtime]]'),
(2185, 1, 1, 'extension_extensions', 'text_uninstall_confirm', ' Please confirm you want to uninstall extension. All extension settings and related data might be deleted and lost. ', '[[regtime]]', '[[regtime]]'),
(2186, 1, 1, 'extension_extensions', 'text_delete', 'Delete', '[[regtime]]', '[[regtime]]'),
(2187, 1, 1, 'extension_extensions', 'text_enlarge', 'Click Image to Enlarge', '[[regtime]]', '[[regtime]]'),
(2188, 1, 1, 'extension_extensions', 'text_activate', 'Activate', '[[regtime]]', '[[regtime]]'),
(2189, 1, 1, 'extension_extensions', 'text_deactivate', 'Deactivate', '[[regtime]]', '[[regtime]]'),
(2190, 1, 1, 'extension_extensions', 'text_left', 'Left', '[[regtime]]', '[[regtime]]'),
(2191, 1, 1, 'extension_extensions', 'text_right', 'Right', '[[regtime]]', '[[regtime]]'),
(2192, 1, 1, 'extension_extensions', 'text_date_added', 'Added on', '[[regtime]]', '[[regtime]]'),
(2193, 1, 1, 'extension_extensions', 'column_icon', 'Icon', '[[regtime]]', '[[regtime]]'),
(2194, 1, 1, 'extension_extensions', 'column_id', 'Extension ID', '[[regtime]]', '[[regtime]]'),
(2195, 1, 1, 'extension_extensions', 'column_required', 'Required', '[[regtime]]', '[[regtime]]'),
(2196, 1, 1, 'extension_extensions', 'column_name', 'Extension Name', '[[regtime]]', '[[regtime]]'),
(2197, 1, 1, 'extension_extensions', 'column_position', 'Position', '[[regtime]]', '[[regtime]]'),
(2198, 1, 1, 'extension_extensions', 'column_update_date', 'Update Date', '[[regtime]]', '[[regtime]]'),
(2199, 1, 1, 'extension_extensions', 'column_category', 'Category', '[[regtime]]', '[[regtime]]'),
(2200, 1, 1, 'extension_extensions', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2201, 1, 1, 'extension_extensions', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(2202, 1, 1, 'extension_extensions', 'column_action', 'Quick Actions', '[[regtime]]', '[[regtime]]'),
(2203, 1, 1, 'extension_extensions', 'error_permission', 'Warning: You do not have permission to modify extensions!', '[[regtime]]', '[[regtime]]'),
(2204, 1, 1, 'extension_extensions', 'error_required_field', 'Error: Please provide required fields. Nothing was updated! ', '[[regtime]]', '[[regtime]]'),
(2205, 1, 1, 'extension_extensions', 'error_payment_uninstall', 'Warning: Disable extension before uninstall!', '[[regtime]]', '[[regtime]]'),
(2206, 1, 1, 'extension_extensions', 'error_uninstall', 'Warning: Uninstall extension before delete!', '[[regtime]]', '[[regtime]]'),
(2207, 1, 1, 'extension_extensions', 'text_save_success', 'Success: You have modified extension settings!', '[[regtime]]', '[[regtime]]'),
(2208, 1, 1, 'extension_extensions', 'text_restore_success', 'Success: You have restored default extension settings!', '[[regtime]]', '[[regtime]]'),
(2209, 1, 1, 'extension_extensions', 'text_extensions_store', 'Get Extensions', '[[regtime]]', '[[regtime]]'),
(2210, 1, 1, 'extension_extensions', 'text_required', 'Required', '[[regtime]]', '[[regtime]]'),
(2211, 1, 1, 'extension_extensions', 'text_optional', 'Optional', '[[regtime]]', '[[regtime]]'),
(2212, 1, 1, 'extension_extensions', 'text_add_new', 'Install Extension', '[[regtime]]', '[[regtime]]'),
(2213, 1, 1, 'extension_extensions', 'text_search', 'Search', '[[regtime]]', '[[regtime]]'),
(2214, 1, 1, 'extension_extensions', 'text_search_for_extension', 'Search for Extension', '[[regtime]]', '[[regtime]]'),
(2215, 1, 1, 'extension_extensions', 'text_missing_extension', '"Extension %s:  Source can not be located! Please delete it and visit extension provider to get complete source and install it again  "', '[[regtime]]', '[[regtime]]'),
(2216, 1, 1, 'extension_extensions', 'text_broken_extension', '"Extension %s:  Source probably broken! Can''t find config.xml or main.php files. Please delete it and visit extension provider to get complete source and install it again  "', '[[regtime]]', '[[regtime]]'),
(2217, 1, 1, 'extension_extensions', 'text_extension_pagination', 'Extension(s) {start} to {end} of {total}', '[[regtime]]', '[[regtime]]'),
(2218, 1, 1, 'extension_extensions', 'text_per_page', 'per page', '[[regtime]]', '[[regtime]]'),
(2219, 1, 1, 'extension_extensions', 'text_error_in_ajax', 'Error in ajax call', '[[regtime]]', '[[regtime]]'),
(2220, 1, 1, 'extension_extensions', 'text_saved', 'Saved', '[[regtime]]', '[[regtime]]'),
(2221, 1, 1, 'extension_extensions', 'text_save', 'Save', '[[regtime]]', '[[regtime]]'),
(2222, 1, 1, 'extension_extensions', 'text_reset', 'Reset', '[[regtime]]', '[[regtime]]'),
(2223, 1, 1, 'extension_extensions', 'text_back', 'Back', '[[regtime]]', '[[regtime]]'),
(2224, 1, 1, 'extension_extensions', 'text_additional_settings', 'Additional settings', '[[regtime]]', '[[regtime]]'),
(2225, 1, 1, 'extension_extensions', 'text_reload', 'Reload', '[[regtime]]', '[[regtime]]'),
(2226, 1, 1, 'extension_extensions', 'text_version', 'Version', '[[regtime]]', '[[regtime]]'),
(2227, 1, 1, 'extension_extensions', 'text_installed_on', 'Installed on', '[[regtime]]', '[[regtime]]'),
(2228, 1, 1, 'extension_extensions', 'text_installed', 'Installed', '[[regtime]]', '[[regtime]]'),
(2229, 1, 1, 'extension_extensions', 'text_not_installed', 'Not Installed', '[[regtime]]', '[[regtime]]'),
(2230, 1, 1, 'extension_extensions', 'text_visit_repository', 'Please visit extension repository</a> to download extension', '[[regtime]]', '[[regtime]]'),
(2231, 1, 1, 'extension_extensions', 'text_license', 'License', '[[regtime]]', '[[regtime]]'),
(2232, 1, 1, 'extension_extensions', 'text_dependency', 'Dependency', '[[regtime]]', '[[regtime]]'),
(2233, 1, 1, 'extension_extensions', 'text_configuration_settings', 'Configuration Settings', '[[regtime]]', '[[regtime]]'),
(2234, 1, 1, 'extension_extensions', 'text_upgrade', 'Upgrade', '[[regtime]]', '[[regtime]]'),
(2235, 1, 1, 'extension_extensions', 'text_help', 'Help', '[[regtime]]', '[[regtime]]'),
(2236, 1, 1, 'extension_extensions', 'text_dependencies', 'Dependencies', '[[regtime]]', '[[regtime]]'),
(2237, 1, 1, 'extension_extensions', 'text_update_available', 'New version (%s) is available. <a href="%s">Click to update now.</a>', '[[regtime]]', '[[regtime]]'),
(2238, 1, 1, 'extension_extensions', 'text_delete_confirm', 'Are you sure you want to delete extension?', '[[regtime]]', '[[regtime]]'),
(2239, 1, 1, 'extension_extensions', 'error_config_load', 'Error: Could not load config for <b>%s</b>!', '[[regtime]]', '[[regtime]]'),
(2240, 1, 1, 'extension_extensions', 'error_required_extension', '<b>%s</b> extension cannot be installed: <b>%s</b> extension required', '[[regtime]]', '[[regtime]]'),
(2241, 1, 1, 'extension_extensions', 'error_required_phpmodule', '<b>%s</b> extension cannot be installed: <b>%s</b> php module required', '[[regtime]]', '[[regtime]]'),
(2242, 1, 1, 'extension_extensions', 'button_restore_defaults', 'Restore Default Settings', '[[regtime]]', '[[regtime]]'),
(2243, 1, 1, 'extension_extensions', 'additional_settings_confirm', 'To set additional settings of extension of another store you need to login into control panel on another domain name. Ok? ', '[[regtime]]', '[[regtime]]'),
(2244, 1, 1, 'extension_extensions', 'error_no_help_file', 'Sorry, there is no help file for this extension.', '[[regtime]]', '[[regtime]]'),
(2245, 1, 1, 'extension_extensions', 'text_more_help', 'More help', '[[regtime]]', '[[regtime]]'),
(2246, 1, 1, 'extension_extensions', 'entry_total_type', 'Type', '[[regtime]]', '[[regtime]]'),
(2247, 1, 1, 'extension_extensions', 'text_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2248, 1, 1, 'extension_extensions', 'text_subtotal', 'Sub-total', '[[regtime]]', '[[regtime]]'),
(2249, 1, 1, 'extension_extensions', 'text_shipping', 'Shipping', '[[regtime]]', '[[regtime]]'),
(2250, 1, 1, 'extension_extensions', 'text_tax', 'Tax', '[[regtime]]', '[[regtime]]'),
(2251, 1, 1, 'extension_extensions', 'text_fee', 'Fee', '[[regtime]]', '[[regtime]]'),
(2252, 1, 1, 'extension_extensions', 'text_discount', 'Discount', '[[regtime]]', '[[regtime]]'),
(2253, 1, 1, 'extension_extensions', 'text_confirm_disable_dependants', 'Extension %s have dependants are: <br>%s<br> It will be disabled automatically too.<br> Do you confirm?', '[[regtime]]', '[[regtime]]'),
(2254, 1, 1, 'extension_extensions', 'text_status', 'Status:<span class="help">This is to control storefront extension status.</span>', '[[regtime]]', '[[regtime]]'),
(2255, 1, 1, 'extension_extensions', 'text_sort_order', 'Run Order:<span class="help">Number to set display position order for this extension in relation to other enabled extensions. (Sorting is from lower to higher number, ignoring 0 and empty values) </span>', '[[regtime]]', '[[regtime]]'),
(2256, 1, 1, 'extension_extensions', 'text_payment_minimum_total', 'Total Order Minimum:<span class="help">Minimum order amount to be reached to allow this payment</span>', '[[regtime]]', '[[regtime]]'),
(2257, 1, 1, 'extension_extensions', 'text_payment_maximum_total', 'Total Order Maximum:<span class="help">Maximum order amount to be reached to disallow this payment</span>', '[[regtime]]', '[[regtime]]'),
(2258, 1, 1, 'extension_extensions', 'text_payment_storefront_icon', 'Storefront Icon:<span class="help">Payment Icon to be displayed at checkout payment selection</span>', '[[regtime]]', '[[regtime]]'),
(2259, 1, 1, 'extension_extensions', 'text_shipping_storefront_icon', 'Storefront Icon:<span class="help">Shipping Icon to be displayed at checkout shipping selection</span>', '[[regtime]]', '[[regtime]]'),
(2260, 1, 1, 'extension_extensions', 'text_autoselect_payment', 'Auto Select:<span class="help">Streamlines the checkout process by automatically choosing a payment method when multiple options are available.</span>', '[[regtime]]', '[[regtime]]'),
(2261, 1, 1, 'extension_extensions', 'text_autoselect_shipping', 'Auto Select:<span class="help">Streamlines the checkout process by automatically choosing a delivery method when multiple options are available.</span>', '[[regtime]]', '[[regtime]]'),
(2262, 1, 1, 'extension_extensions', 'text_accept_payments_shipping', 'Select to restrict payments:<span class="help">If only specific payment methods are needed for this shipping method, select them here. If nothing selected, all available payment methods will be shown</span>', '[[regtime]]', '[[regtime]]'),
(2263, 1, 1, 'extension_extensions', 'text_ready_to_install', 'Ready to install', '[[regtime]]', '[[regtime]]'),
(2264, 1, 1, 'extension_extensions', 'button_install', 'Install', '[[regtime]]', '[[regtime]]'),
(2265, 1, 1, 'extension_extensions', 'error_dependencies', 'This extension cannot be enabled because required dependency missing or not enabled.', '[[regtime]]', '[[regtime]]'),
(2266, 1, 1, 'extension_extensions', 'button_howto', 'How To', '[[regtime]]', '[[regtime]]'),
(2267, 1, 1, 'extension_extensions', 'text_developer_site', 'External support site', '[[regtime]]', '[[regtime]]'),
(2268, 1, 1, 'extension_extensions', 'text_preview', 'Preview', '[[regtime]]', '[[regtime]]'),
(2269, 1, 1, 'extension_extensions', 'text_confirmation', 'Confirmation', '[[regtime]]', '[[regtime]]'),
(2270, 1, 1, 'extension_extensions', 'button_confirm', 'Confirm', '[[regtime]]', '[[regtime]]'),
(2271, 1, 1, 'extension_extensions', 'button_continue', 'Continue', '[[regtime]]', '[[regtime]]'),
(2272, 1, 1, 'extension_extensions', 'button_cancel', 'Cancel', '[[regtime]]', '[[regtime]]'),
(2273, 1, 1, 'extension_extensions', 'error_could_not_load_config', 'Error: Could not load config for <b>%s</b> (%s)!', '[[regtime]]', '[[regtime]]'),
(2274, 1, 1, 'extension_extensions', 'error_could_not_load_override', 'Error: Cannot load override template %s in extension %s!', '[[regtime]]', '[[regtime]]'),
(2275, 1, 1, 'extension_extensions', 'tab_general', 'General', '[[regtime]]', '[[regtime]]'),
(2276, 1, 1, 'extension_extensions', 'tab_additional_settings', 'Additional Settings', '[[regtime]]', '[[regtime]]'),
(2277, 1, 1, 'extension_extensions', 'text_more_extensions', 'More extensions are available for easy install.', '[[regtime]]', '[[regtime]]'),
(2278, 1, 1, 'extension_extensions', 'text_support_expiration', 'Support is active until', '[[regtime]]', '[[regtime]]'),
(2279, 1, 1, 'extension_extensions', 'text_support_expired', 'Support expired', '[[regtime]]', '[[regtime]]'),
(2280, 1, 1, 'extension_extensions', 'text_license_expired', 'Extension support has expired or not connected to marketplace', '[[regtime]]', '[[regtime]]'),
(2281, 1, 1, 'extension_extensions', 'button_get_support', 'Get Support', '[[regtime]]', '[[regtime]]'),
(2282, 1, 1, 'extension_extensions', 'text_min_volume', 'Minimal order parcel size volume in (cubic %s) <span class="help">Minimal value for shipment option to be available for customer. This value is based on combined products sizes in the order</span>', '[[regtime]]', '[[regtime]]'),
(2283, 1, 1, 'extension_extensions', 'text_max_volume', 'Maximal order parcel size volume in (cubic %s) <span class="help">Maximum value for shipment option to be available for customer. This value is based on combined products sizes in the order</span>', '[[regtime]]', '[[regtime]]'),
(2284, 1, 1, 'extension_extensions', 'text_min_weight', 'Minimal Weight of Parcel (%s)', '[[regtime]]', '[[regtime]]'),
(2285, 1, 1, 'extension_extensions', 'text_max_weight', 'Maximum Weight of Parcel (%s)', '[[regtime]]', '[[regtime]]'),
(2286, 1, 1, 'extension_extensions', 'text_min_order_subtotal', 'Minimum Order Subtotal: <span class="help">Enter the minimum order subtotal value for shipment option to be available for customer. This field is optional.</span>', '[[regtime]]', '[[regtime]]'),
(2287, 1, 1, 'extension_extensions', 'text_max_order_subtotal', 'Maximum Order Subtotal: <span class="help">Enter the maximum order subtotal value for shipment option to be available for customer. This field is optional.</span>', '[[regtime]]', '[[regtime]]'),
(2288, 1, 1, 'extension_extensions_store', 'heading_title', 'Extensions Marketplace', '[[regtime]]', '[[regtime]]'),
(2289, 1, 1, 'extension_extensions_store', 'text_install', 'Install', '[[regtime]]', '[[regtime]]'),
(2290, 1, 1, 'extension_extensions_store', 'text_uninstall', 'Uninstall', '[[regtime]]', '[[regtime]]'),
(2291, 1, 1, 'extension_extensions_store', 'text_uninstall_delete', 'Uninstall/Delete', '[[regtime]]', '[[regtime]]'),
(2292, 1, 1, 'extension_extensions_store', 'text_uninstall_confirm', ' Please confirm you want to uninstall extension [ %extension% ]. All extension settings and related data might be deleted and lost. ', '[[regtime]]', '[[regtime]]'),
(2293, 1, 1, 'extension_extensions_store', 'text_delete', 'Delete', '[[regtime]]', '[[regtime]]'),
(2294, 1, 1, 'extension_extensions_store', 'text_enlarge', 'Click Image to Enlarge', '[[regtime]]', '[[regtime]]'),
(2295, 1, 1, 'extension_extensions_store', 'text_activate', 'Activate', '[[regtime]]', '[[regtime]]'),
(2296, 1, 1, 'extension_extensions_store', 'text_deactivate', 'Deactivate', '[[regtime]]', '[[regtime]]'),
(2297, 1, 1, 'extension_extensions_store', 'text_left', 'Left', '[[regtime]]', '[[regtime]]'),
(2298, 1, 1, 'extension_extensions_store', 'text_right', 'Right', '[[regtime]]', '[[regtime]]'),
(2299, 1, 1, 'extension_extensions_store', 'text_date_added', 'Added on', '[[regtime]]', '[[regtime]]'),
(2300, 1, 1, 'extension_extensions_store', 'error_permission', 'Warning: You do not have permission to modify extensions!', '[[regtime]]', '[[regtime]]'),
(2301, 1, 1, 'extension_extensions_store', 'error_required_field', 'Warning: Please fill required fields! ', '[[regtime]]', '[[regtime]]'),
(2302, 1, 1, 'extension_extensions_store', 'error_payment_uninstall', 'Warning: Disable extension before uninstall!', '[[regtime]]', '[[regtime]]'),
(2303, 1, 1, 'extension_extensions_store', 'error_uninstall', 'Warning: Uninstall extension before delete!', '[[regtime]]', '[[regtime]]'),
(2304, 1, 1, 'extension_extensions_store', 'text_success', 'Success: You have modified extension settings!', '[[regtime]]', '[[regtime]]'),
(2305, 1, 1, 'extension_extensions_store', 'text_extensions_store', 'Extensions Marketplace', '[[regtime]]', '[[regtime]]'),
(2306, 1, 1, 'extension_extensions_store', 'text_required', 'Required', '[[regtime]]', '[[regtime]]'),
(2307, 1, 1, 'extension_extensions_store', 'text_optional', 'Optional', '[[regtime]]', '[[regtime]]'),
(2308, 1, 1, 'extension_extensions_store', 'text_add_new', 'Install Extension', '[[regtime]]', '[[regtime]]'),
(2309, 1, 1, 'extension_extensions_store', 'error_connect', 'Oops, Your AbanteCart cannot connect with extensions marketplace. Please see System->Error logs for details.', '[[regtime]]', '[[regtime]]'),
(2310, 1, 1, 'extension_extensions_store', 'text_sorting_review_asc', 'Review Count Low > High', '[[regtime]]', '[[regtime]]'),
(2311, 1, 1, 'extension_extensions_store', 'text_sorting_review_desc', 'Review Count High > Low', '[[regtime]]', '[[regtime]]'),
(2312, 1, 1, 'extension_extensions_store', 'text_sorting_price_asc', 'Price Low > High', '[[regtime]]', '[[regtime]]'),
(2313, 1, 1, 'extension_extensions_store', 'text_sorting_price_desc', 'Price High > Low', '[[regtime]]', '[[regtime]]'),
(2314, 1, 1, 'extension_extensions_store', 'text_sorting_rating_desc', 'Rating Highest', '[[regtime]]', '[[regtime]]'),
(2315, 1, 1, 'extension_extensions_store', 'text_sorting_rating_asc', 'Rating Lowest', '[[regtime]]', '[[regtime]]'),
(2316, 1, 1, 'extension_extensions_store', 'text_sorting_date_modified_asc', 'Date New To Old', '[[regtime]]', '[[regtime]]'),
(2317, 1, 1, 'extension_extensions_store', 'text_sorting_date_modified_desc', 'Date Old to New', '[[regtime]]', '[[regtime]]'),
(2318, 1, 1, 'extension_extensions_store', 'text_my_extensions', 'My Extensions', '[[regtime]]', '[[regtime]]'),
(2319, 1, 1, 'extension_extensions_store', 'text_my_account', 'My Account', '[[regtime]]', '[[regtime]]'),
(2320, 1, 1, 'extension_extensions_store', 'text_marketplace_site', 'Marketplace Site', '[[regtime]]', '[[regtime]]'),
(2321, 1, 1, 'extension_extensions_store', 'text_all_categories', 'All Categories', '[[regtime]]', '[[regtime]]'),
(2322, 1, 1, 'extension_extensions_store', 'text_connect', 'Connect', '[[regtime]]', '[[regtime]]'),
(2323, 1, 1, 'extension_extensions_store', 'text_marketplace_connect', 'Connect to the marketplace', '[[regtime]]', '[[regtime]]'),
(2324, 1, 1, 'extension_extensions_store', 'text_marketplace_extension', 'Extension preview & order ', '[[regtime]]', '[[regtime]]'),
(2325, 1, 1, 'extension_extensions_store', 'text_marketplace_buy', 'Get this extension now', '[[regtime]]', '[[regtime]]'),
(2326, 1, 1, 'extension_extensions_store', 'text_connected', 'Connected to the marketplace. Click to disconnect', '[[regtime]]', '[[regtime]]'),
(2327, 1, 1, 'extension_extensions_store', 'text_disconnect_confirm', 'Are you sure you want to disconnect?', '[[regtime]]', '[[regtime]]'),
(2328, 1, 1, 'extension_extensions_store', 'text_disconnect_success', 'This store was disconnected!', '[[regtime]]', '[[regtime]]'),
(2329, 1, 1, 'extension_extensions_store', 'text_connection_required', 'You need to connect AbanteCart to the Marketplace to see your extensions! Click "connect" button in the above panel.', '[[regtime]]', '[[regtime]]'),
(2330, 1, 1, 'extension_extensions_store', 'text_in_other_store', 'Extension for this order was installed in the other AbanteCart. Check your connected stores for history.', '[[regtime]]', '[[regtime]]'),
(2331, 1, 1, 'extension_extensions_store', 'text_no_purchase_or_not_connected', 'You have no purchases for this store or this store was disconnected from the Marketplace.', '[[regtime]]', '[[regtime]]'),
(2332, 1, 1, 'extension_extensions_store', 'text_no_extensions_loaded', 'No extensions are available. Check your selection or try again.', '[[regtime]]', '[[regtime]]'),
(2333, 1, 1, 'extension_extensions_store', 'text_compatibility', 'This extension is not confirmed to work with your version of AbanteCart. Contact extension developer to confirm compatibility.', '[[regtime]]', '[[regtime]]'),
(2334, 1, 1, 'extension_extensions_store', 'error_mp_connection', 'Oops, can not connect to AbanteCart MarketPlace. Please try to check later or ask your hosting service provider for help.', '[[regtime]]', '[[regtime]]'),
(2335, 1, 1, 'extension_extensions_store', 'text_search', 'search', '[[regtime]]', '[[regtime]]'),
(2336, 1, 1, 'extension_shipping', 'heading_title', 'Shipping', '[[regtime]]', '[[regtime]]'),
(2337, 1, 1, 'extension_shipping', 'text_install', 'Install', '[[regtime]]', '[[regtime]]'),
(2338, 1, 1, 'extension_shipping', 'text_uninstall', 'Uninstall', '[[regtime]]', '[[regtime]]'),
(2339, 1, 1, 'extension_shipping', 'column_name', 'Shipping Method', '[[regtime]]', '[[regtime]]'),
(2340, 1, 1, 'extension_shipping', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2341, 1, 1, 'extension_shipping', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(2342, 1, 1, 'extension_shipping', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2343, 1, 1, 'extension_total', 'heading_title', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(2344, 1, 1, 'extension_total', 'text_install', 'Install', '[[regtime]]', '[[regtime]]'),
(2345, 1, 1, 'extension_total', 'text_uninstall', 'Uninstall', '[[regtime]]', '[[regtime]]'),
(2346, 1, 1, 'extension_total', 'column_name', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(2347, 1, 1, 'extension_total', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2348, 1, 1, 'extension_total', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(2349, 1, 1, 'extension_total', 'column_calculation_order', 'Calculation Order', '[[regtime]]', '[[regtime]]'),
(2350, 1, 1, 'extension_total', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2351, 1, 1, 'localisation_country', 'heading_title', 'Countries', '[[regtime]]', '[[regtime]]'),
(2352, 1, 1, 'localisation_country', 'text_country', 'Country', '[[regtime]]', '[[regtime]]'),
(2353, 1, 1, 'localisation_country', 'text_success', 'Success: You have modified countries!', '[[regtime]]', '[[regtime]]'),
(2354, 1, 1, 'localisation_country', 'column_name', 'Country Name', '[[regtime]]', '[[regtime]]'),
(2355, 1, 1, 'localisation_country', 'column_iso_code_2', 'ISO Code (2)', '[[regtime]]', '[[regtime]]'),
(2356, 1, 1, 'localisation_country', 'column_iso_code_3', 'ISO Code (3)', '[[regtime]]', '[[regtime]]'),
(2357, 1, 1, 'localisation_country', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2358, 1, 1, 'localisation_country', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2359, 1, 1, 'localisation_country', 'entry_status', 'Country Status:', '[[regtime]]', '[[regtime]]'),
(2360, 1, 1, 'localisation_country', 'entry_name', 'Country Name:', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(2361, 1, 1, 'localisation_country', 'entry_iso_code_2', 'ISO Code (2):', '[[regtime]]', '[[regtime]]'),
(2362, 1, 1, 'localisation_country', 'entry_iso_code_3', 'ISO Code (3):', '[[regtime]]', '[[regtime]]'),
(2363, 1, 1, 'localisation_country', 'entry_address_format', 'Address Format:<br /><span class="help">\nFirst Name = {firstname}<br />\nLast Name = {lastname}<br />\nCompany = {company}<br />\nAddress 1 = {address_1}<br />\nAddress 2 = {address_2}<br />\nCity = {city}<br />\nPostcode = {postcode}<br />\nZone = {zone}<br />\nZone Code = {zone_code}<br />\nCountry = {country}</span>', '[[regtime]]', '[[regtime]]'),
(2364, 1, 1, 'localisation_country', 'error_permission', 'Warning: You do not have permission to modify countries!', '[[regtime]]', '[[regtime]]'),
(2365, 1, 1, 'localisation_country', 'error_name', 'Country Name must be between 2 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(2366, 1, 1, 'localisation_country', 'error_default', 'Warning: This country cannot be deleted as it is currently assigned as the default store country!', '[[regtime]]', '[[regtime]]'),
(2367, 1, 1, 'localisation_country', 'error_store', 'Warning: This country cannot be deleted as it is currently assigned to %s stores!', '[[regtime]]', '[[regtime]]'),
(2368, 1, 1, 'localisation_country', 'error_address', 'Warning: This country cannot be deleted as it is currently assigned to %s address book entries!', '[[regtime]]', '[[regtime]]'),
(2369, 1, 1, 'localisation_country', 'error_zone', 'Warning: This country cannot be deleted as it is currently assigned to %s zones!', '[[regtime]]', '[[regtime]]'),
(2370, 1, 1, 'localisation_country', 'error_zone_to_location', 'Warning: This country cannot be deleted as it is currently assigned to %s zones to locations!', '[[regtime]]', '[[regtime]]'),
(2371, 1, 1, 'localisation_currency', 'heading_title', 'Currencies', '[[regtime]]', '[[regtime]]'),
(2372, 1, 1, 'localisation_currency', 'text_currency', 'Currency', '[[regtime]]', '[[regtime]]'),
(2373, 1, 1, 'localisation_currency', 'text_success', 'Success: You have modified currencies!', '[[regtime]]', '[[regtime]]'),
(2374, 1, 1, 'localisation_currency', 'column_title', 'Currency Title', '[[regtime]]', '[[regtime]]'),
(2375, 1, 1, 'localisation_currency', 'column_code', 'Code', '[[regtime]]', '[[regtime]]'),
(2376, 1, 1, 'localisation_currency', 'column_value', 'Value', '[[regtime]]', '[[regtime]]'),
(2377, 1, 1, 'localisation_currency', 'column_date_modified', 'Last Updated', '[[regtime]]', '[[regtime]]'),
(2378, 1, 1, 'localisation_currency', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2379, 1, 1, 'localisation_currency', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2380, 1, 1, 'localisation_currency', 'entry_title', 'Currency Title:', '[[regtime]]', '[[regtime]]'),
(2381, 1, 1, 'localisation_currency', 'entry_code', 'Code:<br /><span class="help">Do not change if this is your default currency.</span>', '[[regtime]]', '[[regtime]]'),
(2382, 1, 1, 'localisation_currency', 'entry_value', 'Value:<br /><span class="help">Set to 1.00000 if this is your default currency.</span>', '[[regtime]]', '[[regtime]]'),
(2383, 1, 1, 'localisation_currency', 'entry_symbol_left', 'Symbol Left:', '[[regtime]]', '[[regtime]]'),
(2384, 1, 1, 'localisation_currency', 'entry_symbol_right', 'Symbol Right:', '[[regtime]]', '[[regtime]]'),
(2385, 1, 1, 'localisation_currency', 'entry_decimal_place', 'Decimal Places:', '[[regtime]]', '[[regtime]]'),
(2386, 1, 1, 'localisation_currency', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2387, 1, 1, 'localisation_currency', 'error_permission', 'Warning: You do not have permission to modify currencies!', '[[regtime]]', '[[regtime]]'),
(2388, 1, 1, 'localisation_currency', 'error_title', 'Currency Title must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2389, 1, 1, 'localisation_currency', 'error_code', 'Currency Code must contain 3 characters!', '[[regtime]]', '[[regtime]]'),
(2390, 1, 1, 'localisation_currency', 'error_default', 'Warning: This currency cannot be deleted as it is currently assigned as the default store currency!', '[[regtime]]', '[[regtime]]'),
(2391, 1, 1, 'localisation_currency', 'error_store', 'Warning: This currency cannot be deleted as it is currently assigned to %s stores!', '[[regtime]]', '[[regtime]]'),
(2392, 1, 1, 'localisation_currency', 'error_order', 'Warning: This currency cannot be deleted as it is currently assigned to %s orders!', '[[regtime]]', '[[regtime]]'),
(2393, 1, 1, 'localisation_language', 'heading_title', 'Languages', '[[regtime]]', '[[regtime]]'),
(2394, 1, 1, 'localisation_language', 'text_language', 'Language', '[[regtime]]', '[[regtime]]'),
(2395, 1, 1, 'localisation_language', 'text_success', 'Success: You have modified languages!', '[[regtime]]', '[[regtime]]'),
(2396, 1, 1, 'localisation_language', 'column_name', 'Language Name', '[[regtime]]', '[[regtime]]'),
(2397, 1, 1, 'localisation_language', 'column_code', 'Code', '[[regtime]]', '[[regtime]]'),
(2398, 1, 1, 'localisation_language', 'column_sort_order', 'Sort Order', '[[regtime]]', '[[regtime]]'),
(2399, 1, 1, 'localisation_language', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2400, 1, 1, 'localisation_language', 'entry_name', 'Language Name:', '[[regtime]]', '[[regtime]]'),
(2401, 1, 1, 'localisation_language', 'entry_code', 'Code:<br /><span class="help">Do not change if this is your default language.</span>', '[[regtime]]', '[[regtime]]'),
(2402, 1, 1, 'localisation_language', 'entry_locale', 'Locale:', '[[regtime]]', '[[regtime]]'),
(2403, 1, 1, 'localisation_language', 'entry_image', 'Image:', '[[regtime]]', '[[regtime]]'),
(2404, 1, 1, 'localisation_language', 'entry_directory', 'Directory:', '[[regtime]]', '[[regtime]]'),
(2405, 1, 1, 'localisation_language', 'entry_filename', 'Filename:', '[[regtime]]', '[[regtime]]'),
(2406, 1, 1, 'localisation_language', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2407, 1, 1, 'localisation_language', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(2408, 1, 1, 'localisation_language', 'error_permission', 'Warning: You do not have permission to modify languages!', '[[regtime]]', '[[regtime]]'),
(2409, 1, 1, 'localisation_language', 'error_name', 'Language Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2410, 1, 1, 'localisation_language', 'error_code', 'Language Code must at least 2 characters!', '[[regtime]]', '[[regtime]]'),
(2411, 1, 1, 'localisation_language', 'error_locale', 'Locale required!', '[[regtime]]', '[[regtime]]'),
(2412, 1, 1, 'localisation_language', 'error_image', 'Image Filename must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(2413, 1, 1, 'localisation_language', 'error_directory', 'Directory required!', '[[regtime]]', '[[regtime]]'),
(2414, 1, 1, 'localisation_language', 'error_filename', 'Filename must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(2415, 1, 1, 'localisation_language', 'error_default', 'Warning: This language cannot be deleted as it is currently assigned as the default store language!', '[[regtime]]', '[[regtime]]'),
(2416, 1, 1, 'localisation_language', 'error_admin', 'Warning: This Language cannot be deleted as it is currently assigned as the administration language!', '[[regtime]]', '[[regtime]]'),
(2417, 1, 1, 'localisation_language', 'error_store', 'Warning: This language cannot be deleted as it is currently assigned to %s stores!', '[[regtime]]', '[[regtime]]'),
(2418, 1, 1, 'localisation_language', 'error_order', 'Warning: This language cannot be deleted as it is currently assigned to %s orders!', '[[regtime]]', '[[regtime]]'),
(2419, 1, 1, 'localisation_language', 'language_edit_title', 'Edit Language Details', '[[regtime]]', '[[regtime]]'),
(2420, 1, 1, 'localisation_language', 'load_language_title', 'Load missing language data', '[[regtime]]', '[[regtime]]'),
(2421, 1, 1, 'localisation_language', 'entry_language_selector', 'Source Language: ', '[[regtime]]', '[[regtime]]'),
(2422, 1, 1, 'localisation_language', 'entry_translate_method_selector', 'Text translation method: ', '[[regtime]]', '[[regtime]]'),
(2423, 1, 1, 'localisation_language', 'load_language_note', 'NOTE: This operation might take few minutes to run. Do NOT close browser, leave or refresh the page!  ', '[[regtime]]', '[[regtime]]'),
(2424, 1, 1, 'localisation_language', 'create_language_note', 'NOTE: We recommend creating language as an extension. Check existing language extensions. If you still want to create new language manually, you need to add language Flag to  admin/language/[Language Directory]/flag.png and  storefront/language/[Language Directory]flag.png\n    After language is created load missing language data to translate or copy text content from source language.  ', '[[regtime]]', '[[regtime]]'),
(2425, 1, 1, 'localisation_language', 'button_load_language', 'Load', '[[regtime]]', '[[regtime]]'),
(2426, 1, 1, 'localisation_language', 'text_incomplete_tasks', 'Incomplete Tasks', '[[regtime]]', '[[regtime]]'),
(2427, 1, 1, 'localisation_language', 'text_task_id', 'Task ID:', '[[regtime]]', '[[regtime]]'),
(2428, 1, 1, 'localisation_language', 'text_title', 'Title:', '[[regtime]]', '[[regtime]]'),
(2429, 1, 1, 'localisation_language', 'text_last_time_run', 'Last Time Run:', '[[regtime]]', '[[regtime]]'),
(2430, 1, 1, 'localisation_language', 'text_date_added', 'Created:', '[[regtime]]', '[[regtime]]'),
(2431, 1, 1, 'localisation_language', 'text_starter_name', 'Created by:', '[[regtime]]', '[[regtime]]'),
(2432, 1, 1, 'localisation_language', 'text_restart', 'Restart', '[[regtime]]', '[[regtime]]'),
(2433, 1, 1, 'localisation_language', 'text_remove', 'Remove', '[[regtime]]', '[[regtime]]'),
(2434, 1, 1, 'localisation_language', 'text_task_title', 'Translation of Descriptions From %s to %s', '[[regtime]]', '[[regtime]]'),
(2435, 1, 1, 'localisation_language', 'error_nothing_to_do', 'Error: Please Set Source Language and Translation Method!', '[[regtime]]', '[[regtime]]'),
(2436, 1, 1, 'localisation_language', 'text_translate_override_existing', 'Note: All existing descriptions in target language will be replaced with new translation. You can disable overriding in <a href="%s">System->Settings->Store Details</a>.', '[[regtime]]', '[[regtime]]'),
(2437, 1, 1, 'localisation_language', 'text_copy_source_text', 'Copy Source Language Text', '[[regtime]]', '[[regtime]]'),
(2438, 1, 1, 'localisation_language_definitions', 'heading_title', 'Language Definitions', '[[regtime]]', '[[regtime]]'),
(2439, 1, 1, 'localisation_language_definitions', 'text_definition', 'Language Definition', '[[regtime]]', '[[regtime]]'),
(2440, 1, 1, 'localisation_language_definitions', 'text_success', 'Success: You have modified languages!', '[[regtime]]', '[[regtime]]'),
(2441, 1, 1, 'localisation_language_definitions', 'column_language', 'Language', '[[regtime]]', '[[regtime]]'),
(2442, 1, 1, 'localisation_language_definitions', 'column_key', 'Key', '[[regtime]]', '[[regtime]]'),
(2443, 1, 1, 'localisation_language_definitions', 'column_translation', 'Translation', '[[regtime]]', '[[regtime]]'),
(2444, 1, 1, 'localisation_language_definitions', 'column_block', 'Block', '[[regtime]]', '[[regtime]]'),
(2445, 1, 1, 'localisation_language_definitions', 'column_update_date', 'Update date', '[[regtime]]', '[[regtime]]'),
(2446, 1, 1, 'localisation_language_definitions', 'column_action', 'Actions', '[[regtime]]', '[[regtime]]'),
(2447, 1, 1, 'localisation_language_definitions', 'entry_language_key', 'Key', '[[regtime]]', '[[regtime]]'),
(2448, 1, 1, 'localisation_language_definitions', 'entry_language_value', 'Value', '[[regtime]]', '[[regtime]]'),
(2449, 1, 1, 'localisation_language_definitions', 'entry_translation', 'Translation', '[[regtime]]', '[[regtime]]'),
(2450, 1, 1, 'localisation_language_definitions', 'entry_block', 'Block', '[[regtime]]', '[[regtime]]'),
(2451, 1, 1, 'localisation_language_definitions', 'entry_section', 'Section', '[[regtime]]', '[[regtime]]'),
(2452, 1, 1, 'localisation_language_definitions', 'text_admin', 'Admin', '[[regtime]]', '[[regtime]]'),
(2453, 1, 1, 'localisation_language_definitions', 'text_storefront', 'Storefront', '[[regtime]]', '[[regtime]]'),
(2454, 1, 1, 'localisation_language_definitions', 'error_language_key', 'Language key required!', '[[regtime]]', '[[regtime]]'),
(2455, 1, 1, 'localisation_language_definitions', 'error_language_value', 'Translation required!', '[[regtime]]', '[[regtime]]'),
(2456, 1, 1, 'localisation_language_definitions', 'error_block', 'Block required!', '[[regtime]]', '[[regtime]]'),
(2457, 1, 1, 'localisation_language_definitions', 'error_section', 'Section required!', '[[regtime]]', '[[regtime]]'),
(2458, 1, 1, 'localisation_language_definitions', 'text_all_section', 'All Sections', '[[regtime]]', '[[regtime]]'),
(2459, 1, 1, 'localisation_language_definitions', 'text_all_languages', 'All Languages', '[[regtime]]', '[[regtime]]'),
(2460, 1, 1, 'localisation_language_definitions', 'error_already exists', 'Error!<br>Language definition with key "%s" and block "%s" for %s section already exists!<br>Click <a target="_blank" href="%s">this link</a> to view', '[[regtime]]', '[[regtime]]'),
(2461, 1, 1, 'localisation_length_class', 'heading_title', 'Length Classes', '[[regtime]]', '[[regtime]]'),
(2462, 1, 1, 'localisation_length_class', 'text_class', 'Length Class', '[[regtime]]', '[[regtime]]'),
(2463, 1, 1, 'localisation_length_class', 'text_success', 'Success: You have modified length classes!', '[[regtime]]', '[[regtime]]'),
(2464, 1, 1, 'localisation_length_class', 'column_title', 'Length Title', '[[regtime]]', '[[regtime]]'),
(2465, 1, 1, 'localisation_length_class', 'column_unit', 'Length Unit', '[[regtime]]', '[[regtime]]'),
(2466, 1, 1, 'localisation_length_class', 'column_value', 'Value', '[[regtime]]', '[[regtime]]'),
(2467, 1, 1, 'localisation_length_class', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2468, 1, 1, 'localisation_length_class', 'entry_title', 'Length Title:', '[[regtime]]', '[[regtime]]'),
(2469, 1, 1, 'localisation_length_class', 'entry_unit', 'Length Unit:', '[[regtime]]', '[[regtime]]'),
(2470, 1, 1, 'localisation_length_class', 'entry_value', 'Value:', '[[regtime]]', '[[regtime]]'),
(2471, 1, 1, 'localisation_length_class', 'error_permission', 'Warning: You do not have permission to modify length classes!', '[[regtime]]', '[[regtime]]'),
(2472, 1, 1, 'localisation_length_class', 'error_title', 'Length Title must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2473, 1, 1, 'localisation_length_class', 'error_unit', 'Length Unit must be between 1 and 4 characters!', '[[regtime]]', '[[regtime]]'),
(2474, 1, 1, 'localisation_length_class', 'error_default', 'Warning: This length class cannot be deleted as it is currently assigned as the default store length class!', '[[regtime]]', '[[regtime]]'),
(2475, 1, 1, 'localisation_length_class', 'error_product', 'Warning: This length class cannot be deleted as it is currently assigned to %s products!', '[[regtime]]', '[[regtime]]'),
(2476, 1, 1, 'localisation_length_class', 'error_iso_code', 'ISO-code must be 4 characters and must be unique!', '[[regtime]]', '[[regtime]]'),
(2477, 1, 1, 'localisation_length_class', 'entry_iso_code', 'ISO-code:', '[[regtime]]', '[[regtime]]'),
(2478, 1, 1, 'localisation_length_class', 'column_iso_code', 'ISO-code', '[[regtime]]', '[[regtime]]'),
(2479, 1, 1, 'localisation_location', 'heading_title', 'Locations', '[[regtime]]', '[[regtime]]'),
(2480, 1, 1, 'localisation_location', 'text_location', 'Location', '[[regtime]]', '[[regtime]]'),
(2481, 1, 1, 'localisation_location', 'text_location_zone', 'Location Zone', '[[regtime]]', '[[regtime]]'),
(2482, 1, 1, 'localisation_location', 'text_location_zones', 'Location Zones', '[[regtime]]', '[[regtime]]'),
(2483, 1, 1, 'localisation_location', 'text_success', 'Success: You have modified locations!', '[[regtime]]', '[[regtime]]'),
(2484, 1, 1, 'localisation_location', 'column_name', 'Location Name', '[[regtime]]', '[[regtime]]'),
(2485, 1, 1, 'localisation_location', 'column_description', 'Description', '[[regtime]]', '[[regtime]]'),
(2486, 1, 1, 'localisation_location', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2487, 1, 1, 'localisation_location', 'tab_details', 'Details', '[[regtime]]', '[[regtime]]'),
(2488, 1, 1, 'localisation_location', 'tab_locations', 'Location Zones', '[[regtime]]', '[[regtime]]'),
(2489, 1, 1, 'localisation_location', 'entry_name', 'Location Name:', '[[regtime]]', '[[regtime]]'),
(2490, 1, 1, 'localisation_location', 'entry_description', 'Description:', '[[regtime]]', '[[regtime]]'),
(2491, 1, 1, 'localisation_location', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(2492, 1, 1, 'localisation_location', 'entry_zone', 'Zone(s):', '[[regtime]]', '[[regtime]]'),
(2493, 1, 1, 'localisation_location', 'error_permission', 'Warning: You do not have permission to modify locations!', '[[regtime]]', '[[regtime]]'),
(2494, 1, 1, 'localisation_location', 'error_name', 'Location Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2495, 1, 1, 'localisation_location', 'error_description', 'Description Name must be between 2 and 255 characters!', '[[regtime]]', '[[regtime]]'),
(2496, 1, 1, 'localisation_location', 'error_tax_rate', 'Warning: This location cannot be deleted as it is currently assigned to one or more tax rates!', '[[regtime]]', '[[regtime]]'),
(2497, 1, 1, 'localisation_order_status', 'heading_title', 'Order Statuses', '[[regtime]]', '[[regtime]]'),
(2498, 1, 1, 'localisation_order_status', 'text_status', 'Order Status', '[[regtime]]', '[[regtime]]'),
(2499, 1, 1, 'localisation_order_status', 'text_success', 'Success: You have modified order statuses!', '[[regtime]]', '[[regtime]]'),
(2500, 1, 1, 'localisation_order_status', 'column_name', 'Order Status Name', '[[regtime]]', '[[regtime]]'),
(2501, 1, 1, 'localisation_order_status', 'column_text_id', 'Order Status Text ID', '[[regtime]]', '[[regtime]]'),
(2502, 1, 1, 'localisation_order_status', 'entry_text_id', 'Order Status Text ID:', '[[regtime]]', '[[regtime]]'),
(2503, 1, 1, 'localisation_order_status', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2504, 1, 1, 'localisation_order_status', 'entry_name', 'Order Status Name:', '[[regtime]]', '[[regtime]]'),
(2505, 1, 1, 'localisation_order_status', 'error_permission', 'Warning: You do not have permission to modify order statues!', '[[regtime]]', '[[regtime]]'),
(2506, 1, 1, 'localisation_order_status', 'error_name', 'Order Status Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2507, 1, 1, 'localisation_order_status', 'error_default', 'Warning: This order status cannot be deleted as it is currently assigned as the default store order status!', '[[regtime]]', '[[regtime]]'),
(2508, 1, 1, 'localisation_order_status', 'error_download', 'Warning: This order status cannot be deleted as it is currently assigned as the default download status!', '[[regtime]]', '[[regtime]]'),
(2509, 1, 1, 'localisation_order_status', 'error_store', 'Warning: This order status cannot be deleted as it is currently assigned to %s stores!', '[[regtime]]', '[[regtime]]'),
(2510, 1, 1, 'localisation_order_status', 'error_order', 'Warning: This order status cannot be deleted as it is currently assigned to %s orders!', '[[regtime]]', '[[regtime]]'),
(2511, 1, 1, 'localisation_order_status', 'error_nondeletable', 'Warning: This is important order status that is linked to payments. You can not delete this status.', '[[regtime]]', '[[regtime]]'),
(2512, 1, 1, 'localisation_order_status', 'error_status_text_id', 'Order Status Text Id must be Unique and between 2 and 32 latin characters!', '[[regtime]]', '[[regtime]]'),
(2513, 1, 1, 'localisation_stock_status', 'heading_title', 'Stock Statuses', '[[regtime]]', '[[regtime]]'),
(2514, 1, 1, 'localisation_stock_status', 'text_status', 'Stock Status', '[[regtime]]', '[[regtime]]'),
(2515, 1, 1, 'localisation_stock_status', 'text_success', 'Success: You have modified stock statuses!', '[[regtime]]', '[[regtime]]'),
(2516, 1, 1, 'localisation_stock_status', 'column_name', 'Stock Status Name', '[[regtime]]', '[[regtime]]'),
(2517, 1, 1, 'localisation_stock_status', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2518, 1, 1, 'localisation_stock_status', 'entry_name', 'Stock Status Name:', '[[regtime]]', '[[regtime]]'),
(2519, 1, 1, 'localisation_stock_status', 'error_permission', 'Warning: You do not have permission to modify stock statues!', '[[regtime]]', '[[regtime]]'),
(2520, 1, 1, 'localisation_stock_status', 'error_name', 'Stock Status Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2521, 1, 1, 'localisation_stock_status', 'error_product', 'Warning: This stock status cannot be deleted as it is currently assigned to %s products!', '[[regtime]]', '[[regtime]]'),
(2522, 1, 1, 'localisation_tax_class', 'heading_title', 'Tax Classes', '[[regtime]]', '[[regtime]]'),
(2523, 1, 1, 'localisation_tax_class', 'text_class', 'Tax Class', '[[regtime]]', '[[regtime]]'),
(2524, 1, 1, 'localisation_tax_class', 'text_rate', 'Tax Rate', '[[regtime]]', '[[regtime]]'),
(2525, 1, 1, 'localisation_tax_class', 'text_success', 'Success: You have modified tax classes!', '[[regtime]]', '[[regtime]]'),
(2526, 1, 1, 'localisation_tax_class', 'column_title', 'Tax Class Title', '[[regtime]]', '[[regtime]]'),
(2527, 1, 1, 'localisation_tax_class', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2528, 1, 1, 'localisation_tax_class', 'tab_details', 'Details', '[[regtime]]', '[[regtime]]'),
(2529, 1, 1, 'localisation_tax_class', 'tab_rates', 'Rates', '[[regtime]]', '[[regtime]]'),
(2530, 1, 1, 'localisation_tax_class', 'entry_title', 'Tax Class Title:', '[[regtime]]', '[[regtime]]'),
(2531, 1, 1, 'localisation_tax_class', 'entry_description', 'Description visible to customers', '[[regtime]]', '[[regtime]]'),
(2532, 1, 1, 'localisation_tax_class', 'entry_location', 'Location', '[[regtime]]', '[[regtime]]'),
(2533, 1, 1, 'localisation_tax_class', 'entry_zone', 'Location zone', '[[regtime]]', '[[regtime]]'),
(2534, 1, 1, 'localisation_tax_class', 'entry_priority', 'Priority', '[[regtime]]', '[[regtime]]'),
(2535, 1, 1, 'localisation_tax_class', 'entry_rate', 'Tax Rate', '[[regtime]]', '[[regtime]]'),
(2536, 1, 1, 'localisation_tax_class', 'error_permission', 'Warning: You do not have permission to modify tax classes!', '[[regtime]]', '[[regtime]]'),
(2537, 1, 1, 'localisation_tax_class', 'error_tax_title', 'Tax Class Title must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2538, 1, 1, 'localisation_tax_class', 'error_rate', 'Tax Rate required!', '[[regtime]]', '[[regtime]]'),
(2539, 1, 1, 'localisation_tax_class', 'error_product', 'Warning: This tax class cannot be deleted as it is currently assigned to %s products!', '[[regtime]]', '[[regtime]]'),
(2540, 1, 1, 'localisation_tax_class', 'text_tax_all_zones', 'all location zones', '[[regtime]]', '[[regtime]]'),
(2541, 1, 1, 'localisation_tax_class', 'entry_tax_rate_threshold', 'Apply tax if<br /><span class="help">Apply this tax only if, taxed amount (product, shipping, subtotal, etc.) is ...</span>', '[[regtime]]', '[[regtime]]'),
(2542, 1, 1, 'localisation_tax_class', 'entry_tax_exempt_groups', 'Tax Exempt Groups<br /><span class="help">Select customer groups to exempt from this tax</span>', '[[regtime]]', '[[regtime]]'),
(2543, 1, 1, 'localisation_tax_class', 'text_absolute', 'Absolute', '[[regtime]]', '[[regtime]]'),
(2544, 1, 1, 'localisation_tax_class', 'text_percent', 'Percent', '[[regtime]]', '[[regtime]]'),
(2545, 1, 1, 'localisation_weight_class', 'heading_title', 'Weight Classes', '[[regtime]]', '[[regtime]]'),
(2546, 1, 1, 'localisation_weight_class', 'text_class', 'Weight Class', '[[regtime]]', '[[regtime]]'),
(2547, 1, 1, 'localisation_weight_class', 'text_success', 'Success: You have modified weight classes!', '[[regtime]]', '[[regtime]]'),
(2548, 1, 1, 'localisation_weight_class', 'column_title', 'Weight Title', '[[regtime]]', '[[regtime]]'),
(2549, 1, 1, 'localisation_weight_class', 'column_unit', 'Weight Unit', '[[regtime]]', '[[regtime]]'),
(2550, 1, 1, 'localisation_weight_class', 'column_value', 'Value', '[[regtime]]', '[[regtime]]'),
(2551, 1, 1, 'localisation_weight_class', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2552, 1, 1, 'localisation_weight_class', 'entry_title', 'Weight Title:', '[[regtime]]', '[[regtime]]'),
(2553, 1, 1, 'localisation_weight_class', 'entry_unit', 'Weight Unit:', '[[regtime]]', '[[regtime]]'),
(2554, 1, 1, 'localisation_weight_class', 'entry_value', 'Value:', '[[regtime]]', '[[regtime]]'),
(2555, 1, 1, 'localisation_weight_class', 'error_permission', 'Warning: You do not have permission to modify weight classes!', '[[regtime]]', '[[regtime]]'),
(2556, 1, 1, 'localisation_weight_class', 'error_title', 'Weight Title must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2557, 1, 1, 'localisation_weight_class', 'error_unit', 'Weight Unit must be between 1 and 4 characters!', '[[regtime]]', '[[regtime]]'),
(2558, 1, 1, 'localisation_weight_class', 'error_default', 'Warning: This weight class cannot be deleted as it is currently assigned as the default store weight class!', '[[regtime]]', '[[regtime]]'),
(2559, 1, 1, 'localisation_weight_class', 'error_product', 'Warning: This weight class cannot be deleted as it is currently assigned to %s products!', '[[regtime]]', '[[regtime]]'),
(2560, 1, 1, 'localisation_weight_class', 'error_iso_code', 'ISO-code must be 4 characters and must be unique!', '[[regtime]]', '[[regtime]]'),
(2561, 1, 1, 'localisation_weight_class', 'entry_iso_code', 'ISO-code:', '[[regtime]]', '[[regtime]]'),
(2562, 1, 1, 'localisation_weight_class', 'column_iso_code', 'ISO-code', '[[regtime]]', '[[regtime]]'),
(2563, 1, 1, 'localisation_zone', 'heading_title', 'Zones', '[[regtime]]', '[[regtime]]'),
(2564, 1, 1, 'localisation_zone', 'text_zone', 'Zone', '[[regtime]]', '[[regtime]]'),
(2565, 1, 1, 'localisation_zone', 'text_success', 'Success: You have modified zones!', '[[regtime]]', '[[regtime]]'),
(2566, 1, 1, 'localisation_zone', 'column_name', 'Zone Name', '[[regtime]]', '[[regtime]]'),
(2567, 1, 1, 'localisation_zone', 'column_code', 'Zone Code', '[[regtime]]', '[[regtime]]'),
(2568, 1, 1, 'localisation_zone', 'column_country', 'Country', '[[regtime]]', '[[regtime]]'),
(2569, 1, 1, 'localisation_zone', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2570, 1, 1, 'localisation_zone', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2571, 1, 1, 'localisation_zone', 'entry_status', 'Zone Status:', '[[regtime]]', '[[regtime]]'),
(2572, 1, 1, 'localisation_zone', 'entry_name', 'Zone Name:', '[[regtime]]', '[[regtime]]'),
(2573, 1, 1, 'localisation_zone', 'entry_code', 'Zone Code:', '[[regtime]]', '[[regtime]]'),
(2574, 1, 1, 'localisation_zone', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(2575, 1, 1, 'localisation_zone', 'text_select_country', '- Select Country -', '[[regtime]]', '[[regtime]]'),
(2576, 1, 1, 'localisation_zone', 'error_permission', 'Warning: You do not have permission to modify zones!', '[[regtime]]', '[[regtime]]'),
(2577, 1, 1, 'localisation_zone', 'error_name', 'Zone Name must be between 2 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(2578, 1, 1, 'localisation_zone', 'error_default', 'Warning: This zone cannot be deleted as it is currently assigned as the default store zone!', '[[regtime]]', '[[regtime]]'),
(2579, 1, 1, 'localisation_zone', 'error_store', 'Warning: This zone cannot be deleted as it is currently assigned to %s stores!', '[[regtime]]', '[[regtime]]'),
(2580, 1, 1, 'localisation_zone', 'error_address', 'Warning: This zone cannot be deleted as it is currently assigned to %s address book entries!', '[[regtime]]', '[[regtime]]'),
(2581, 1, 1, 'localisation_zone', 'error_zone_to_location', 'Warning: This zone cannot be deleted as it is currently assigned to %s zones to locations!', '[[regtime]]', '[[regtime]]'),
(2582, 1, 1, 'mail_customer', 'text_subject', '%s - Your Account has been activated!', '[[regtime]]', '[[regtime]]'),
(2583, 1, 1, 'mail_customer', 'text_welcome', 'Welcome and thank you for registering at %s!', '[[regtime]]', '[[regtime]]'),
(2584, 1, 1, 'mail_customer', 'text_login', 'Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:', '[[regtime]]', '[[regtime]]'),
(2585, 1, 1, 'mail_customer', 'text_services', 'Once you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.', '[[regtime]]', '[[regtime]]'),
(2586, 1, 1, 'mail_customer', 'text_thanks', 'Thank you,', '[[regtime]]', '[[regtime]]'),
(2587, 1, 1, 'mail_order', 'text_subject', '%s - Order Update %s', '[[regtime]]', '[[regtime]]'),
(2588, 1, 1, 'mail_order', 'text_order', 'Order ID:', '[[regtime]]', '[[regtime]]'),
(2589, 1, 1, 'mail_order', 'text_date_added', 'Date Ordered:', '[[regtime]]', '[[regtime]]'),
(2590, 1, 1, 'mail_order', 'text_order_status', 'Your order has been updated to the following status:', '[[regtime]]', '[[regtime]]'),
(2591, 1, 1, 'mail_order', 'text_comment', 'The comments for your order are:', '[[regtime]]', '[[regtime]]'),
(2592, 1, 1, 'mail_order', 'text_invoice', 'To view your order click on the link below:', '[[regtime]]', '[[regtime]]'),
(2593, 1, 1, 'mail_order', 'text_footer', 'Please reply to this email if you have any questions.', '[[regtime]]', '[[regtime]]'),
(2594, 1, 1, 'report_customer_online', 'heading_title', 'Customers Online', '[[regtime]]', '[[regtime]]'),
(2595, 1, 1, 'report_customer_online', 'column_customer', 'Customer Name', '[[regtime]]', '[[regtime]]'),
(2596, 1, 1, 'report_customer_online', 'column_ip', 'Customer IP', '[[regtime]]', '[[regtime]]'),
(2597, 1, 1, 'report_customer_online', 'column_time', 'Last Accessed', '[[regtime]]', '[[regtime]]'),
(2598, 1, 1, 'report_customer_online', 'column_url', 'Url Accessed', '[[regtime]]', '[[regtime]]'),
(2599, 1, 1, 'report_customer_online', 'text_referer', 'Referer:', '[[regtime]]', '[[regtime]]'),
(2600, 1, 1, 'report_customer_orders', 'heading_title', 'Customer Orders', '[[regtime]]', '[[regtime]]'),
(2601, 1, 1, 'report_customer_orders', 'column_customer_id', 'Customer ID', '[[regtime]]', '[[regtime]]'),
(2602, 1, 1, 'report_customer_orders', 'column_customer', 'Customer Name', '[[regtime]]', '[[regtime]]'),
(2603, 1, 1, 'report_customer_orders', 'column_group', 'Customer Group', '[[regtime]]', '[[regtime]]'),
(2604, 1, 1, 'report_customer_orders', 'column_order_count', 'Orders Count', '[[regtime]]', '[[regtime]]'),
(2605, 1, 1, 'report_customer_orders', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2606, 1, 1, 'report_customer_transactions', 'heading_title', 'Customer Transactions', '[[regtime]]', '[[regtime]]'),
(2607, 1, 1, 'report_customer_transactions', 'column_transaction_date', 'Transaction Date', '[[regtime]]', '[[regtime]]'),
(2608, 1, 1, 'report_customer_transactions', 'column_customer', 'Customer Name', '[[regtime]]', '[[regtime]]'),
(2609, 1, 1, 'report_customer_transactions', 'column_created_by', 'Created By', '[[regtime]]', '[[regtime]]'),
(2610, 1, 1, 'report_customer_transactions', 'column_debit', 'Debit', '[[regtime]]', '[[regtime]]'),
(2611, 1, 1, 'report_customer_transactions', 'column_credit', 'Credit', '[[regtime]]', '[[regtime]]'),
(2612, 1, 1, 'report_customer_transactions', 'column_transaction_type', 'Transaction Type', '[[regtime]]', '[[regtime]]'),
(2613, 1, 1, 'report_purchased', 'heading_title', 'Products Purchased Report', '[[regtime]]', '[[regtime]]'),
(2614, 1, 1, 'report_purchased', 'column_name', 'Product Name', '[[regtime]]', '[[regtime]]'),
(2615, 1, 1, 'report_purchased', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(2616, 1, 1, 'report_purchased', 'column_quantity', 'Quantity', '[[regtime]]', '[[regtime]]'),
(2617, 1, 1, 'report_purchased', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2618, 1, 1, 'report_sale_coupons', 'heading_title', 'Discounts Report', '[[regtime]]', '[[regtime]]'),
(2619, 1, 1, 'report_sale_coupons', 'column_coupon_name', 'Discount/Coupon Name', '[[regtime]]', '[[regtime]]'),
(2620, 1, 1, 'report_sale_coupons', 'column_code', 'Code', '[[regtime]]', '[[regtime]]'),
(2621, 1, 1, 'report_sale_coupons', 'column_orders', 'No. Orders', '[[regtime]]', '[[regtime]]'),
(2622, 1, 1, 'report_sale_coupons', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2623, 1, 1, 'report_sale_coupons', 'column_discount_total', 'Total Discount', '[[regtime]]', '[[regtime]]'),
(2624, 1, 1, 'report_sale_coupons', 'entry_date_start', 'Date Start:', '[[regtime]]', '[[regtime]]'),
(2625, 1, 1, 'report_sale_coupons', 'entry_date_end', 'Date End:', '[[regtime]]', '[[regtime]]'),
(2626, 1, 1, 'report_sale_orders', 'heading_title', 'Sales Report', '[[regtime]]', '[[regtime]]'),
(2627, 1, 1, 'report_sale_orders', 'text_year', 'Years', '[[regtime]]', '[[regtime]]'),
(2628, 1, 1, 'report_sale_orders', 'text_month', 'Months', '[[regtime]]', '[[regtime]]'),
(2629, 1, 1, 'report_sale_orders', 'text_week', 'Weeks', '[[regtime]]', '[[regtime]]'),
(2630, 1, 1, 'report_sale_orders', 'text_day', 'Days', '[[regtime]]', '[[regtime]]'),
(2631, 1, 1, 'report_sale_orders', 'text_all_status', 'All Statuses', '[[regtime]]', '[[regtime]]'),
(2632, 1, 1, 'report_sale_orders', 'column_date_start', 'Date Start', '[[regtime]]', '[[regtime]]'),
(2633, 1, 1, 'report_sale_orders', 'column_date_end', 'Date End', '[[regtime]]', '[[regtime]]'),
(2634, 1, 1, 'report_sale_orders', 'column_orders', 'No. Orders', '[[regtime]]', '[[regtime]]'),
(2635, 1, 1, 'report_sale_orders', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2636, 1, 1, 'report_sale_orders', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2637, 1, 1, 'report_sale_orders', 'entry_date_start', 'Date Start:', '[[regtime]]', '[[regtime]]'),
(2638, 1, 1, 'report_sale_orders', 'entry_date_end', 'Date End:', '[[regtime]]', '[[regtime]]'),
(2639, 1, 1, 'report_sale_orders', 'entry_group', 'Group By:', '[[regtime]]', '[[regtime]]'),
(2640, 1, 1, 'report_sale_shipping', 'heading_title', 'Shipping Report', '[[regtime]]', '[[regtime]]'),
(2641, 1, 1, 'report_sale_shipping', 'text_year', 'Years', '[[regtime]]', '[[regtime]]'),
(2642, 1, 1, 'report_sale_shipping', 'text_month', 'Months', '[[regtime]]', '[[regtime]]'),
(2643, 1, 1, 'report_sale_shipping', 'text_week', 'Weeks', '[[regtime]]', '[[regtime]]'),
(2644, 1, 1, 'report_sale_shipping', 'text_day', 'Days', '[[regtime]]', '[[regtime]]'),
(2645, 1, 1, 'report_sale_shipping', 'text_all_status', 'All Statuses', '[[regtime]]', '[[regtime]]'),
(2646, 1, 1, 'report_sale_shipping', 'column_date_start', 'Date Start', '[[regtime]]', '[[regtime]]'),
(2647, 1, 1, 'report_sale_shipping', 'column_date_end', 'Date End', '[[regtime]]', '[[regtime]]'),
(2648, 1, 1, 'report_sale_shipping', 'column_orders', 'No. Orders', '[[regtime]]', '[[regtime]]'),
(2649, 1, 1, 'report_sale_shipping', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2650, 1, 1, 'report_sale_shipping', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2651, 1, 1, 'report_sale_shipping', 'entry_date_start', 'Date Start:', '[[regtime]]', '[[regtime]]'),
(2652, 1, 1, 'report_sale_shipping', 'entry_date_end', 'Date End:', '[[regtime]]', '[[regtime]]'),
(2653, 1, 1, 'report_sale_shipping', 'entry_group', 'Group By:', '[[regtime]]', '[[regtime]]'),
(2654, 1, 1, 'report_sale_taxes', 'heading_title', 'Taxes Report', '[[regtime]]', '[[regtime]]'),
(2655, 1, 1, 'report_sale_taxes', 'text_year', 'Years', '[[regtime]]', '[[regtime]]'),
(2656, 1, 1, 'report_sale_taxes', 'text_month', 'Months', '[[regtime]]', '[[regtime]]'),
(2657, 1, 1, 'report_sale_taxes', 'text_week', 'Weeks', '[[regtime]]', '[[regtime]]'),
(2658, 1, 1, 'report_sale_taxes', 'text_day', 'Days', '[[regtime]]', '[[regtime]]'),
(2659, 1, 1, 'report_sale_taxes', 'text_all_status', 'All Statuses', '[[regtime]]', '[[regtime]]'),
(2660, 1, 1, 'report_sale_taxes', 'column_date_start', 'Date Start', '[[regtime]]', '[[regtime]]'),
(2661, 1, 1, 'report_sale_taxes', 'column_date_end', 'Date End', '[[regtime]]', '[[regtime]]'),
(2662, 1, 1, 'report_sale_taxes', 'column_orders', 'No. Orders', '[[regtime]]', '[[regtime]]'),
(2663, 1, 1, 'report_sale_taxes', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2664, 1, 1, 'report_sale_taxes', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2665, 1, 1, 'report_sale_taxes', 'entry_date_start', 'Date Start:', '[[regtime]]', '[[regtime]]'),
(2666, 1, 1, 'report_sale_taxes', 'entry_date_end', 'Date End:', '[[regtime]]', '[[regtime]]'),
(2667, 1, 1, 'report_sale_taxes', 'entry_group', 'Group By:', '[[regtime]]', '[[regtime]]'),
(2668, 1, 1, 'report_viewed', 'heading_title', 'Products Viewed Report', '[[regtime]]', '[[regtime]]'),
(2669, 1, 1, 'report_viewed', 'text_success', 'Success: You have reset the product viewed report!', '[[regtime]]', '[[regtime]]'),
(2670, 1, 1, 'report_viewed', 'column_product_id', 'Product ID', '[[regtime]]', '[[regtime]]'),
(2671, 1, 1, 'report_viewed', 'column_name', 'Product Name', '[[regtime]]', '[[regtime]]'),
(2672, 1, 1, 'report_viewed', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(2673, 1, 1, 'report_viewed', 'column_sku', 'SKU', '[[regtime]]', '[[regtime]]'),
(2674, 1, 1, 'report_viewed', 'column_category', 'Category', '[[regtime]]', '[[regtime]]'),
(2675, 1, 1, 'report_viewed', 'column_viewed', 'Viewed', '[[regtime]]', '[[regtime]]'),
(2676, 1, 1, 'report_viewed', 'column_percent', 'Percent', '[[regtime]]', '[[regtime]]'),
(2677, 1, 1, 'sale_contact', 'text_send_email', 'Send Mail', '[[regtime]]', '[[regtime]]'),
(2678, 1, 1, 'sale_contact', 'text_send_sms', 'Send SMS', '[[regtime]]', '[[regtime]]'),
(2679, 1, 1, 'sale_contact', 'text_success', 'Your message has been successfully sent!', '[[regtime]]', '[[regtime]]'),
(2680, 1, 1, 'sale_contact', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(2681, 1, 1, 'sale_contact', 'text_custom_send', 'Manualy selected customers', '[[regtime]]', '[[regtime]]'),
(2682, 1, 1, 'sale_contact', 'text_all_subscribers', 'All Subscribers', '[[regtime]]', '[[regtime]]'),
(2683, 1, 1, 'sale_contact', 'text_subscribers_only', 'Newsletter Subscribers Only (non-customers)', '[[regtime]]', '[[regtime]]'),
(2684, 1, 1, 'sale_contact', 'text_customers_only', 'All Customers', '[[regtime]]', '[[regtime]]'),
(2685, 1, 1, 'sale_contact', 'entry_store', 'From store:<span class="help">Store email address to send email from. Value is set in store settings</span>', '[[regtime]]', '[[regtime]]'),
(2686, 1, 1, 'sale_contact', 'text_customers_who_ordered', 'To customers who ordered selected products', '[[regtime]]', '[[regtime]]'),
(2687, 1, 1, 'sale_contact', 'entry_to', 'To:<span class="help">List of customers to receive this message. NOTE: Large customer lists will require long time to be processed and might require alternative methods. Refer to your web and email server configurations</span>', '[[regtime]]', '[[regtime]]'),
(2688, 1, 1, 'sale_contact', 'text_customers_from_lookup', 'Start typing customer name to look up and select', '[[regtime]]', '[[regtime]]'),
(2689, 1, 1, 'sale_contact', 'text_products_from_lookup', 'Start typing product name to look up and select', '[[regtime]]', '[[regtime]]'),
(2690, 1, 1, 'sale_contact', 'entry_subject', 'Subject:', '[[regtime]]', '[[regtime]]'),
(2691, 1, 1, 'sale_contact', 'entry_message', 'Message body:', '[[regtime]]', '[[regtime]]'),
(2692, 1, 1, 'sale_contact', 'error_permission', 'Warning: You do not have permission to send emails!', '[[regtime]]', '[[regtime]]'),
(2693, 1, 1, 'sale_contact', 'error_subject', 'Email subject is required!', '[[regtime]]', '[[regtime]]'),
(2694, 1, 1, 'sale_contact', 'error_message_email', 'Email message body is required!', '[[regtime]]', '[[regtime]]'),
(2695, 1, 1, 'sale_contact', 'error_message_sms', 'SMS message body is required!', '[[regtime]]', '[[regtime]]'),
(2696, 1, 1, 'sale_contact', 'error_recipients', 'Recipients list, subscribers or products ordered are required!', '[[regtime]]', '[[regtime]]'),
(2697, 1, 1, 'sale_contact', 'error_not_sent', '''Error: No emails were sent! Please see error log for details.''', '[[regtime]]', '[[regtime]]'),
(2698, 1, 1, 'sale_contact', 'text_unsubscribe', 'This email was sent to %s, because your email preferences are set to receive newsletters. Click <a href="%s">here to Unsubscribe</a>. ', '[[regtime]]', '[[regtime]]'),
(2699, 1, 1, 'sale_contact', 'text_total_to_be_sent', '(Total to be sent to: %s )', '[[regtime]]', '[[regtime]]'),
(2700, 1, 1, 'sale_contact', 'text_select_products', '- Select Products -', '[[regtime]]', '[[regtime]]'),
(2701, 1, 1, 'sale_contact', 'text_select_customers', '- Select Customers -', '[[regtime]]', '[[regtime]]'),
(2702, 1, 1, 'sale_contact', 'text_email', 'Email', '[[regtime]]', '[[regtime]]'),
(2703, 1, 1, 'sale_contact', 'text_sms', 'SMS', '[[regtime]]', '[[regtime]]'),
(2704, 1, 1, 'sale_contact', 'text_incomplete_tasks', 'Incomplete Tasks', '[[regtime]]', '[[regtime]]'),
(2705, 1, 1, 'sale_contact', 'text_task_id', 'Task ID:', '[[regtime]]', '[[regtime]]'),
(2706, 1, 1, 'sale_contact', 'text_last_time_run', 'Last Time Run:', '[[regtime]]', '[[regtime]]'),
(2707, 1, 1, 'sale_contact', 'text_date_added', 'Created:', '[[regtime]]', '[[regtime]]'),
(2708, 1, 1, 'sale_contact', 'text_subject', 'Subject:', '[[regtime]]', '[[regtime]]'),
(2709, 1, 1, 'sale_contact', 'text_message', 'Message:', '[[regtime]]', '[[regtime]]'),
(2710, 1, 1, 'sale_contact', 'text_starter_name', 'Created by:', '[[regtime]]', '[[regtime]]'),
(2711, 1, 1, 'sale_contact', 'text_restart', 'Restart', '[[regtime]]', '[[regtime]]'),
(2712, 1, 1, 'sale_contact', 'text_remove', 'Remove', '[[regtime]]', '[[regtime]]'),
(2713, 1, 1, 'sale_contact', 'error_email_no_recipients', 'Attention! Message will not be sent.', '[[regtime]]', '[[regtime]]'),
(2714, 1, 1, 'sale_contact', 'error_sms_no_recipients', 'Attention! No customers with mobile phone numbers. ', '[[regtime]]', '[[regtime]]'),
(2715, 1, 1, 'sale_contact', 'text_attention_recipients_count', 'Attention! The message will be sent to %s customers.', '[[regtime]]', '[[regtime]]'),
(2716, 1, 1, 'sale_contact', 'text_success_abort', 'Task interrupted successfully.', '[[regtime]]', '[[regtime]]'),
(2717, 1, 1, 'sale_contact', 'text_success_sent', '%s messages have been sent.', '[[regtime]]', '[[regtime]]'),
(2718, 1, 1, 'sale_contact', 'text_task_failed', 'Some errors occured during task process. Please see log for details or restart this task.', '[[regtime]]', '[[regtime]]'),
(2719, 1, 1, 'sale_contact', 'text_sent', ' %s of %s messages are sent', '[[regtime]]', '[[regtime]]'),
(2720, 1, 1, 'sale_coupon', 'heading_title', 'Coupons', '[[regtime]]', '[[regtime]]'),
(2721, 1, 1, 'sale_coupon', 'text_coupon', 'Coupon', '[[regtime]]', '[[regtime]]'),
(2722, 1, 1, 'sale_coupon', 'text_success', 'Success: You have modified coupons!', '[[regtime]]', '[[regtime]]'),
(2723, 1, 1, 'sale_coupon', 'text_percent', 'Percentage', '[[regtime]]', '[[regtime]]'),
(2724, 1, 1, 'sale_coupon', 'text_amount', 'Fixed Amount', '[[regtime]]', '[[regtime]]'),
(2725, 1, 1, 'sale_coupon', 'column_name', 'Coupon Name', '[[regtime]]', '[[regtime]]'),
(2726, 1, 1, 'sale_coupon', 'column_code', 'Code', '[[regtime]]', '[[regtime]]'),
(2727, 1, 1, 'sale_coupon', 'column_discount', 'Discount', '[[regtime]]', '[[regtime]]'),
(2728, 1, 1, 'sale_coupon', 'column_date_start', 'Date Start', '[[regtime]]', '[[regtime]]'),
(2729, 1, 1, 'sale_coupon', 'column_date_end', 'Date End', '[[regtime]]', '[[regtime]]'),
(2730, 1, 1, 'sale_coupon', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2731, 1, 1, 'sale_coupon', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2732, 1, 1, 'sale_coupon', 'entry_name', 'Coupon Name:', '[[regtime]]', '[[regtime]]'),
(2733, 1, 1, 'sale_coupon', 'entry_description', 'Coupon Description:', '[[regtime]]', '[[regtime]]'),
(2734, 1, 1, 'sale_coupon', 'entry_code', 'Code:<br /><span class="help">The code the customer enters to get the discount</span>', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(2735, 1, 1, 'sale_coupon', 'entry_type', 'Type:<br /><span class="help">Percentage or Fixed Amount</span>', '[[regtime]]', '[[regtime]]'),
(2736, 1, 1, 'sale_coupon', 'entry_discount', 'Discount:', '[[regtime]]', '[[regtime]]'),
(2737, 1, 1, 'sale_coupon', 'entry_logged', 'Customer Login:<br /><span class="help">Customer must be logged in to use the coupon.</span>', '[[regtime]]', '[[regtime]]'),
(2738, 1, 1, 'sale_coupon', 'entry_shipping', 'Free Shipping:', '[[regtime]]', '[[regtime]]'),
(2739, 1, 1, 'sale_coupon', 'entry_total', 'Total Amount:<br/><span class="help">The sub-total amount that must reached before the coupon is valid.</span>', '[[regtime]]', '[[regtime]]'),
(2740, 1, 1, 'sale_coupon', 'entry_category', 'Categories:<br/><span class="help">Apply Coupon When Products From One Of Selected Categories.</span>', '[[regtime]]', '[[regtime]]'),
(2741, 1, 1, 'sale_coupon', 'entry_product', 'Products:<br/><span class="help">Apply Coupon When Cart Contains One Of Selected Products.</span>', '[[regtime]]', '[[regtime]]'),
(2742, 1, 1, 'sale_coupon', 'entry_date_start', 'Date Start:', '[[regtime]]', '[[regtime]]'),
(2743, 1, 1, 'sale_coupon', 'entry_date_end', 'Date End:', '[[regtime]]', '[[regtime]]'),
(2744, 1, 1, 'sale_coupon', 'entry_uses_total', 'Uses Per Coupon:<br /><span class="help">The maximum number of times the coupon can be used by any customer. Leave blank for unlimited</span>', '[[regtime]]', '[[regtime]]'),
(2745, 1, 1, 'sale_coupon', 'entry_uses_customer', 'Uses Per Customer:<br /><span class="help">The maximum number of times the coupon can be used by a single customer. Leave blank for unlimited</span>', '[[regtime]]', '[[regtime]]'),
(2746, 1, 1, 'sale_coupon', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2747, 1, 1, 'sale_coupon', 'entry_total_coupon_usage', 'Total Coupon Usage:<br /><span class="help">Count of all orders placed using this coupon</span>', '[[regtime]]', '[[regtime]]'),
(2748, 1, 1, 'sale_coupon', 'error_permission', 'Warning: You do not have permission to modify coupons!', '[[regtime]]', '[[regtime]]'),
(2749, 1, 1, 'sale_coupon', 'error_name', 'Coupon Name must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(2750, 1, 1, 'sale_coupon', 'error_description', 'Coupon Description must be between 2 characters!', '[[regtime]]', '[[regtime]]'),
(2751, 1, 1, 'sale_coupon', 'error_code', 'Code must be between 2 and 10 characters!', '[[regtime]]', '[[regtime]]'),
(2752, 1, 1, 'sale_coupon', 'error_date', 'Please set date range!', '[[regtime]]', '[[regtime]]'),
(2753, 1, 1, 'sale_coupon', 'text_select_category', '- Select Category -', '[[regtime]]', '[[regtime]]'),
(2754, 1, 1, 'sale_coupon', 'text_or', 'OR', '[[regtime]]', '[[regtime]]'),
(2755, 1, 1, 'sale_coupon', 'text_and', 'AND', '[[regtime]]', '[[regtime]]'),
(2756, 1, 1, 'sale_customer', 'heading_title', 'Customers', '[[regtime]]', '[[regtime]]'),
(2757, 1, 1, 'sale_customer', 'text_customer', 'Customer', '[[regtime]]', '[[regtime]]'),
(2758, 1, 1, 'sale_customer', 'text_success', 'Success: You have modified customers!', '[[regtime]]', '[[regtime]]'),
(2759, 1, 1, 'sale_customer', 'text_approved', 'You have approved %s account!', '[[regtime]]', '[[regtime]]'),
(2760, 1, 1, 'sale_customer', 'tab_customer_address', 'Address', '[[regtime]]', '[[regtime]]'),
(2761, 1, 1, 'sale_customer', 'text_customer_addresses', 'Customer Addresses', '[[regtime]]', '[[regtime]]'),
(2762, 1, 1, 'sale_customer', 'text_add_address', 'Add New Address', '[[regtime]]', '[[regtime]]'),
(2763, 1, 1, 'sale_customer', 'button_add', 'Add', '[[regtime]]', '[[regtime]]'),
(2764, 1, 1, 'sale_customer', 'column_id', 'ID', '[[regtime]]', '[[regtime]]'),
(2765, 1, 1, 'sale_customer', 'column_name', 'Customer Name', '[[regtime]]', '[[regtime]]'),
(2766, 1, 1, 'sale_customer', 'column_email', 'E-Mail', '[[regtime]]', '[[regtime]]'),
(2767, 1, 1, 'sale_customer', 'column_customer_group', 'Customer Group', '[[regtime]]', '[[regtime]]'),
(2768, 1, 1, 'sale_customer', 'column_group', 'Group', '[[regtime]]', '[[regtime]]'),
(2769, 1, 1, 'sale_customer', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2770, 1, 1, 'sale_customer', 'column_approved', 'Approved', '[[regtime]]', '[[regtime]]'),
(2771, 1, 1, 'sale_customer', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(2772, 1, 1, 'sale_customer', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2773, 1, 1, 'sale_customer', 'entry_loginname', 'Login Name:', '[[regtime]]', '[[regtime]]'),
(2774, 1, 1, 'sale_customer', 'entry_firstname', 'First Name:', '[[regtime]]', '[[regtime]]'),
(2775, 1, 1, 'sale_customer', 'entry_lastname', 'Last Name:', '[[regtime]]', '[[regtime]]'),
(2776, 1, 1, 'sale_customer', 'entry_email', 'E-Mail:', '[[regtime]]', '[[regtime]]'),
(2777, 1, 1, 'sale_customer', 'entry_telephone', 'Telephone:', '[[regtime]]', '[[regtime]]'),
(2778, 1, 1, 'sale_customer', 'entry_fax', 'Fax:', '[[regtime]]', '[[regtime]]'),
(2779, 1, 1, 'sale_customer', 'entry_newsletter', 'Newsletter:', '[[regtime]]', '[[regtime]]'),
(2780, 1, 1, 'sale_customer', 'entry_customer_group', 'Customer Group:', '[[regtime]]', '[[regtime]]'),
(2781, 1, 1, 'sale_customer', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(2782, 1, 1, 'sale_customer', 'entry_approved', 'Approved:', '[[regtime]]', '[[regtime]]'),
(2783, 1, 1, 'sale_customer', 'entry_password', 'Password:', '[[regtime]]', '[[regtime]]'),
(2784, 1, 1, 'sale_customer', 'entry_confirm', 'Confirm:', '[[regtime]]', '[[regtime]]'),
(2785, 1, 1, 'sale_customer', 'entry_company', 'Company:', '[[regtime]]', '[[regtime]]'),
(2786, 1, 1, 'sale_customer', 'entry_address_1', 'Address 1:', '[[regtime]]', '[[regtime]]'),
(2787, 1, 1, 'sale_customer', 'entry_address_2', 'Address 2:', '[[regtime]]', '[[regtime]]'),
(2788, 1, 1, 'sale_customer', 'entry_city', 'City:', '[[regtime]]', '[[regtime]]'),
(2789, 1, 1, 'sale_customer', 'entry_postcode', 'Postcode:', '[[regtime]]', '[[regtime]]'),
(2790, 1, 1, 'sale_customer', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(2791, 1, 1, 'sale_customer', 'entry_country_id', 'Country:', '[[regtime]]', '[[regtime]]'),
(2792, 1, 1, 'sale_customer', 'entry_zone', 'Region / State:', '[[regtime]]', '[[regtime]]'),
(2793, 1, 1, 'sale_customer', 'error_permission', 'Warning: You do not have permission to modify customers!', '[[regtime]]', '[[regtime]]'),
(2794, 1, 1, 'sale_customer', 'error_loginname', 'Login name must be alphanumeric only and between 5 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(2795, 1, 1, 'sale_customer', 'error_loginname_notunique', 'This login name is not available. Try different login name!', '[[regtime]]', '[[regtime]]'),
(2796, 1, 1, 'sale_customer', 'error_firstname', 'First Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2797, 1, 1, 'sale_customer', 'error_lastname', 'Last Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2798, 1, 1, 'sale_customer', 'error_email', 'E-Mail Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(2799, 1, 1, 'sale_customer', 'error_telephone', 'Telephone must be between 3 and 32 numeric only characters!', '[[regtime]]', '[[regtime]]'),
(2800, 1, 1, 'sale_customer', 'error_password', 'Password must be between 3 and 20 characters!', '[[regtime]]', '[[regtime]]'),
(2801, 1, 1, 'sale_customer', 'error_confirm', 'Password and password confirmation do not match!', '[[regtime]]', '[[regtime]]'),
(2802, 1, 1, 'sale_customer', 'error_address_firstname', 'First Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2803, 1, 1, 'sale_customer', 'error_address_lastname', 'Last Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(2804, 1, 1, 'sale_customer', 'error_address_1', 'Address must be between 3 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(2805, 1, 1, 'sale_customer', 'error_city', 'City must be between 3 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(2806, 1, 1, 'sale_customer', 'error_country', 'Please select a country!', '[[regtime]]', '[[regtime]]'),
(2807, 1, 1, 'sale_customer', 'error_zone', 'Please select a region / state!', '[[regtime]]', '[[regtime]]'),
(2808, 1, 1, 'sale_customer', 'text_select_approved', '- Select Approved -', '[[regtime]]', '[[regtime]]'),
(2809, 1, 1, 'sale_customer', 'text_select_group', '- Select Group -', '[[regtime]]', '[[regtime]]'),
(2810, 1, 1, 'sale_customer', 'tab_customer_details', 'Customer details', '[[regtime]]', '[[regtime]]'),
(2811, 1, 1, 'sale_customer', 'tab_transactions', 'Transactions', '[[regtime]]', '[[regtime]]'),
(2812, 1, 1, 'sale_customer', 'heading_title_transactions', 'Customer''s transactions', '[[regtime]]', '[[regtime]]'),
(2813, 1, 1, 'sale_customer', 'column_create_date', 'Date Created', '[[regtime]]', '[[regtime]]'),
(2814, 1, 1, 'sale_customer', 'column_created_by', 'Created By', '[[regtime]]', '[[regtime]]'),
(2815, 1, 1, 'sale_customer', 'column_debit', 'Debit', '[[regtime]]', '[[regtime]]'),
(2816, 1, 1, 'sale_customer', 'column_credit', 'Credit', '[[regtime]]', '[[regtime]]'),
(2817, 1, 1, 'sale_customer', 'column_transaction_type', 'Transaction Type', '[[regtime]]', '[[regtime]]'),
(2818, 1, 1, 'sale_customer', 'text_balance', 'Balance:', '[[regtime]]', '[[regtime]]'),
(2819, 1, 1, 'sale_customer', 'text_last_login', 'Last Log-in:', '[[regtime]]', '[[regtime]]'),
(2820, 1, 1, 'sale_customer', 'text_never', 'Never', '[[regtime]]', '[[regtime]]'),
(2821, 1, 1, 'sale_customer', 'popup_title_info', 'Transaction information', '[[regtime]]', '[[regtime]]'),
(2822, 1, 1, 'sale_customer', 'popup_title_insert', 'Insert New Transaction', '[[regtime]]', '[[regtime]]'),
(2823, 1, 1, 'sale_customer', 'entry_credit', 'Credit (increase balance)', '[[regtime]]', '[[regtime]]'),
(2824, 1, 1, 'sale_customer', 'entry_debit', 'Debit (decrease balance)', '[[regtime]]', '[[regtime]]'),
(2825, 1, 1, 'sale_customer', 'entry_transaction_type', 'Transaction Type: ', '[[regtime]]', '[[regtime]]'),
(2826, 1, 1, 'sale_customer', 'entry_other_type', 'Add New Custom Transaction Type: ', '[[regtime]]', '[[regtime]]'),
(2827, 1, 1, 'sale_customer', 'text_other_type_placeholder', 'type new name here ', '[[regtime]]', '[[regtime]]'),
(2828, 1, 1, 'sale_customer', 'text_option_other_type', 'Other... ', '[[regtime]]', '[[regtime]]'),
(2829, 1, 1, 'sale_customer', 'entry_transaction_description', 'Description (for customer):', '[[regtime]]', '[[regtime]]'),
(2830, 1, 1, 'sale_customer', 'entry_transaction_comment', 'Comment (for internal use):', '[[regtime]]', '[[regtime]]'),
(2831, 1, 1, 'sale_customer', 'entry_update_date', 'Update Date:', '[[regtime]]', '[[regtime]]'),
(2832, 1, 1, 'sale_customer', 'entry_create_date', 'Create Date:', '[[regtime]]', '[[regtime]]'),
(2833, 1, 1, 'sale_customer', 'error_transaction_type', 'Error: Please fill transaction type form field.', '[[regtime]]', '[[regtime]]'),
(2834, 1, 1, 'sale_customer', 'error_empty_debit_credit', 'Error: Please fill debit or credit value for customer transaction.', '[[regtime]]', '[[regtime]]'),
(2835, 1, 1, 'sale_customer', 'error_incorrect_debit_credit', 'Error: debit or credit value cannot be greater than 99999999999.9999', '[[regtime]]', '[[regtime]]'),
(2836, 1, 1, 'sale_customer', 'text_transaction_success', 'Success: You have modified transaction!', '[[regtime]]', '[[regtime]]'),
(2837, 1, 1, 'sale_customer', 'text_edit_address', 'Edit Address', '[[regtime]]', '[[regtime]]'),
(2838, 1, 1, 'sale_customer', 'entry_default', 'Default Address:', '[[regtime]]', '[[regtime]]'),
(2839, 1, 1, 'sale_customer', 'error_delete_default', 'Error: Default address cannot be deleted!', '[[regtime]]', '[[regtime]]'),
(2840, 1, 1, 'sale_customer', 'error_delete_last', 'Error: you must have at least one address!', '[[regtime]]', '[[regtime]]'),
(2841, 1, 1, 'sale_customer', 'entry_date_added', 'Date Added:', '[[regtime]]', '[[regtime]]'),
(2842, 1, 1, 'sale_customer', 'entry_date_modified', 'Date Modified:', '[[regtime]]', '[[regtime]]'),
(2843, 1, 1, 'sale_customer', 'warning_actonbehalf_additional_store', 'To act on behalf of customer in additional store you should to login into another store''s admin side. Continue?', '[[regtime]]', '[[regtime]]'),
(2844, 1, 1, 'sale_customer', 'entry_notify', 'Notify Customer:', '[[regtime]]', '[[regtime]]'),
(2845, 1, 1, 'sale_customer', 'text_transaction_notification_subject', 'New transaction has been posted to your %s account', '[[regtime]]', '[[regtime]]'),
(2846, 1, 1, 'sale_customer', 'text_transaction_notification_message', 'New transaction has been posted to your %s account in the amount of %s. For more details, login to %s account', '[[regtime]]', '[[regtime]]'),
(2847, 1, 1, 'sale_customer', 'text_total_order', 'Total Orders:', '[[regtime]]', '[[regtime]]'),
(2848, 1, 1, 'sale_customer', 'text_register_date', 'Register Date:', '[[regtime]]', '[[regtime]]'),
(2849, 1, 1, 'sale_customer', 'error_email_exists', 'Customer with this email address already exists!', '[[regtime]]', '[[regtime]]'),
(2850, 1, 1, 'sale_customer_group', 'heading_title', 'Customer Group', '[[regtime]]', '[[regtime]]'),
(2851, 1, 1, 'sale_customer_group', 'breadcrumb_title', 'Customer Groups', '[[regtime]]', '[[regtime]]'),
(2852, 1, 1, 'sale_customer_group', 'text_success', 'Success: You have modified customer groups!', '[[regtime]]', '[[regtime]]'),
(2853, 1, 1, 'sale_customer_group', 'column_name', 'Customer Group Name', '[[regtime]]', '[[regtime]]'),
(2854, 1, 1, 'sale_customer_group', 'column_tax_exempt', 'Tax Exempt', '[[regtime]]', '[[regtime]]'),
(2855, 1, 1, 'sale_customer_group', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2856, 1, 1, 'sale_customer_group', 'entry_name', 'Customer Group Name:', '[[regtime]]', '[[regtime]]'),
(2857, 1, 1, 'sale_customer_group', 'entry_tax_exempt', 'Exempt from all taxes:', '[[regtime]]', '[[regtime]]'),
(2858, 1, 1, 'sale_customer_group', 'error_permission', 'Warning: You do not have permission to modify customer groups!', '[[regtime]]', '[[regtime]]'),
(2859, 1, 1, 'sale_customer_group', 'error_name', 'Customer Group Name must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(2860, 1, 1, 'sale_customer_group', 'error_default', 'Warning: This customer group cannot be deleted as it is currently assigned as the default store customer group!', '[[regtime]]', '[[regtime]]'),
(2861, 1, 1, 'sale_customer_group', 'error_store', 'Warning: This customer group cannot be deleted as it is currently assigned to %s stores!', '[[regtime]]', '[[regtime]]'),
(2862, 1, 1, 'sale_customer_group', 'error_customer', 'Warning: This customer group cannot be deleted as it is currently assigned to %s customers!', '[[regtime]]', '[[regtime]]'),
(2863, 1, 1, 'sale_order', 'heading_title', 'Orders', '[[regtime]]', '[[regtime]]'),
(2864, 1, 1, 'sale_order', 'edit_title_details', 'Edit Order Details', '[[regtime]]', '[[regtime]]'),
(2865, 1, 1, 'sale_order', 'edit_title_shipping', 'Edit Shipping Address', '[[regtime]]', '[[regtime]]'),
(2866, 1, 1, 'sale_order', 'edit_title_payment', 'Edit Payment Address', '[[regtime]]', '[[regtime]]'),
(2867, 1, 1, 'sale_order', 'title_payment_details', 'Payment Details', '[[regtime]]', '[[regtime]]'),
(2868, 1, 1, 'sale_order', 'text_success', 'Success: Order details have been updated!', '[[regtime]]', '[[regtime]]'),
(2869, 1, 1, 'sale_order', 'text_invoice', 'Invoice', '[[regtime]]', '[[regtime]]'),
(2870, 1, 1, 'sale_order', 'text_order_id', 'Order ID:', '[[regtime]]', '[[regtime]]'),
(2871, 1, 1, 'sale_order', 'text_invoice_id', 'Invoice No.:', '[[regtime]]', '[[regtime]]'),
(2872, 1, 1, 'sale_order', 'text_date_added', 'Invoice Date:', '[[regtime]]', '[[regtime]]'),
(2873, 1, 1, 'sale_order', 'text_telephone', 'Telephone', '[[regtime]]', '[[regtime]]'),
(2874, 1, 1, 'sale_order', 'text_fax', 'Fax', '[[regtime]]', '[[regtime]]'),
(2875, 1, 1, 'sale_order', 'text_select_country', '- Select Country -', '[[regtime]]', '[[regtime]]'),
(2876, 1, 1, 'sale_order', 'text_to', 'To', '[[regtime]]', '[[regtime]]'),
(2877, 1, 1, 'sale_order', 'text_ship_to', 'Ship To (if different address)', '[[regtime]]', '[[regtime]]'),
(2878, 1, 1, 'sale_order', 'text_missing_orders', 'Missing Orders', '[[regtime]]', '[[regtime]]'),
(2879, 1, 1, 'sale_order', 'text_wait', 'Please Wait!', '[[regtime]]', '[[regtime]]'),
(2880, 1, 1, 'sale_order', 'column_order', 'Order ID', '[[regtime]]', '[[regtime]]'),
(2881, 1, 1, 'sale_order', 'column_name', 'Customer Name', '[[regtime]]', '[[regtime]]'),
(2882, 1, 1, 'sale_order', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(2883, 1, 1, 'sale_order', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(2884, 1, 1, 'sale_order', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(2885, 1, 1, 'sale_order', 'column_product', 'Product', '[[regtime]]', '[[regtime]]'),
(2886, 1, 1, 'sale_order', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(2887, 1, 1, 'sale_order', 'column_quantity', 'Quantity', '[[regtime]]', '[[regtime]]'),
(2888, 1, 1, 'sale_order', 'column_price', 'Unit Price', '[[regtime]]', '[[regtime]]'),
(2889, 1, 1, 'sale_order', 'column_sku', 'SKU', '[[regtime]]', '[[regtime]]'),
(2890, 1, 1, 'sale_order', 'column_download', 'Download Name', '[[regtime]]', '[[regtime]]'),
(2891, 1, 1, 'sale_order', 'column_file', 'File', '[[regtime]]', '[[regtime]]'),
(2892, 1, 1, 'sale_order', 'column_remaining', 'Remaining', '[[regtime]]', '[[regtime]]'),
(2893, 1, 1, 'sale_order', 'column_expire_date', 'Expire Date', '[[regtime]]', '[[regtime]]'),
(2894, 1, 1, 'sale_order', 'column_mask', 'Mask', '[[regtime]]', '[[regtime]]'),
(2895, 1, 1, 'sale_order', 'column_notify', 'Customer Notified', '[[regtime]]', '[[regtime]]'),
(2896, 1, 1, 'sale_order', 'column_comment', 'Customer''s order comment', '[[regtime]]', '[[regtime]]'),
(2897, 1, 1, 'sale_order', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(2898, 1, 1, 'sale_order', 'entry_order_id', 'Order ID:', '[[regtime]]', '[[regtime]]'),
(2899, 1, 1, 'sale_order', 'entry_invoice_id', 'Invoice ID:', '[[regtime]]', '[[regtime]]'),
(2900, 1, 1, 'sale_order', 'entry_customer', 'Customer:', '[[regtime]]', '[[regtime]]'),
(2901, 1, 1, 'sale_order', 'entry_firstname', 'First Name:', '[[regtime]]', '[[regtime]]'),
(2902, 1, 1, 'sale_order', 'entry_lastname', 'Last Name:', '[[regtime]]', '[[regtime]]'),
(2903, 1, 1, 'sale_order', 'entry_customer_group', 'Customer Group:', '[[regtime]]', '[[regtime]]'),
(2904, 1, 1, 'sale_order', 'entry_email', 'E-Mail:', '[[regtime]]', '[[regtime]]'),
(2905, 1, 1, 'sale_order', 'entry_ip', 'IP Address:', '[[regtime]]', '[[regtime]]'),
(2906, 1, 1, 'sale_order', 'entry_telephone', 'Telephone:', '[[regtime]]', '[[regtime]]'),
(2907, 1, 1, 'sale_order', 'entry_fax', 'Fax:', '[[regtime]]', '[[regtime]]'),
(2908, 1, 1, 'sale_order', 'entry_store_name', 'Store Name:', '[[regtime]]', '[[regtime]]'),
(2909, 1, 1, 'sale_order', 'entry_store_url', 'Store Url:', '[[regtime]]', '[[regtime]]'),
(2910, 1, 1, 'sale_order', 'entry_date_added', 'Date Added:', '[[regtime]]', '[[regtime]]'),
(2911, 1, 1, 'sale_order', 'entry_shipping_method', 'Shipping Method:', '[[regtime]]', '[[regtime]]'),
(2912, 1, 1, 'sale_order', 'entry_payment_method', 'Payment Method:', '[[regtime]]', '[[regtime]]'),
(2913, 1, 1, 'sale_order', 'entry_total', 'Original Order Total:', '[[regtime]]', '[[regtime]]'),
(2914, 1, 1, 'sale_order', 'entry_order_status', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(2915, 1, 1, 'sale_order', 'entry_comment', 'Comment:', '[[regtime]]', '[[regtime]]'),
(2916, 1, 1, 'sale_order', 'entry_company', 'Company:', '[[regtime]]', '[[regtime]]'),
(2917, 1, 1, 'sale_order', 'entry_address_1', 'Address 1:', '[[regtime]]', '[[regtime]]'),
(2918, 1, 1, 'sale_order', 'entry_address_2', 'Address 2:', '[[regtime]]', '[[regtime]]'),
(2919, 1, 1, 'sale_order', 'entry_postcode', 'ZIP/Post Code:', '[[regtime]]', '[[regtime]]'),
(2920, 1, 1, 'sale_order', 'entry_city', 'City:', '[[regtime]]', '[[regtime]]'),
(2921, 1, 1, 'sale_order', 'entry_zone', 'Region / State:', '[[regtime]]', '[[regtime]]'),
(2922, 1, 1, 'sale_order', 'entry_zone_code', 'Region / State Code:', '[[regtime]]', '[[regtime]]'),
(2923, 1, 1, 'sale_order', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(2924, 1, 1, 'sale_order', 'entry_status', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(2925, 1, 1, 'sale_order', 'entry_notify', 'Notify Customer:', '[[regtime]]', '[[regtime]]'),
(2926, 1, 1, 'sale_order', 'entry_append', 'Append Comments:', '[[regtime]]', '[[regtime]]'),
(2927, 1, 1, 'sale_order', 'entry_add_product', 'Add Available Product:', '[[regtime]]', '[[regtime]]'),
(2928, 1, 1, 'sale_order', 'error_permission', 'Warning: You do not have permission to modify orders!', '[[regtime]]', '[[regtime]]'),
(2929, 1, 1, 'sale_order', 'error_order_load', 'Warning: No order with such ID!', '[[regtime]]', '[[regtime]]'),
(2930, 1, 1, 'sale_order', 'text_order_summary', 'Order Summary', '[[regtime]]', '[[regtime]]'),
(2931, 1, 1, 'sale_order', 'tab_order_details', 'Order Details', '[[regtime]]', '[[regtime]]'),
(2932, 1, 1, 'sale_order', 'tab_address', 'Order Address', '[[regtime]]', '[[regtime]]'),
(2933, 1, 1, 'sale_order', 'tab_history', 'Status & Comments', '[[regtime]]', '[[regtime]]'),
(2934, 1, 1, 'sale_order', 'tab_files', 'Order Files', '[[regtime]]', '[[regtime]]'),
(2935, 1, 1, 'sale_order', 'tab_payment_details', 'Payment Details', '[[regtime]]', '[[regtime]]'),
(2936, 1, 1, 'sale_order', 'edit_title_files', 'Edit Order Files', '[[regtime]]', '[[regtime]]'),
(2937, 1, 1, 'sale_order', 'text_missing_file', 'Missing File', '[[regtime]]', '[[regtime]]'),
(2938, 1, 1, 'sale_order', 'order_download_history', 'Download History', '[[regtime]]', '[[regtime]]'),
(2939, 1, 1, 'sale_order', 'text_time', 'Time', '[[regtime]]', '[[regtime]]'),
(2940, 1, 1, 'sale_order', 'text_filename', 'Filename', '[[regtime]]', '[[regtime]]'),
(2941, 1, 1, 'sale_order', 'text_mask', 'Mask', '[[regtime]]', '[[regtime]]'),
(2942, 1, 1, 'sale_order', 'text_download_percent', 'Download Percents', '[[regtime]]', '[[regtime]]'),
(2943, 1, 1, 'sale_order', 'text_download_expired', 'Date Expired', '[[regtime]]', '[[regtime]]'),
(2944, 1, 1, 'sale_order', 'text_download_remaining_count', 'Remaining Count', '[[regtime]]', '[[regtime]]'),
(2945, 1, 1, 'sale_order', 'text_order_status_required', 'Order Status "%s" Required', '[[regtime]]', '[[regtime]]'),
(2946, 1, 1, 'sale_order', 'text_select_product', '- Select Product -', '[[regtime]]', '[[regtime]]'),
(2947, 1, 1, 'sale_order', 'text_push_download', '- Push Download -', '[[regtime]]', '[[regtime]]'),
(2948, 1, 1, 'sale_order', 'text_add_product_to_order', 'Add Product to Order #%s', '[[regtime]]', '[[regtime]]'),
(2949, 1, 1, 'sale_order', 'text_edit_order_product', 'Edit Product', '[[regtime]]', '[[regtime]]'),
(2950, 1, 1, 'sale_order', 'attention_check_total', 'Note: Order product details has changed. Total was recalculated automatically. Review is required.', '[[regtime]]', '[[regtime]]'),
(2951, 1, 1, 'sale_order', 'text_order_total_add', 'Add new amount to total calculation', '[[regtime]]', '[[regtime]]'),
(2952, 1, 1, 'sale_order', 'text_order_total_title', 'Title to show', '[[regtime]]', '[[regtime]]'),
(2953, 1, 1, 'sale_order', 'text_order_total_amount', 'Amount', '[[regtime]]', '[[regtime]]'),
(2954, 1, 1, 'sale_order', 'text_recalc', 'Recalculate using settings', '[[regtime]]', '[[regtime]]'),
(2955, 1, 1, 'sale_order', 'entry_im', 'IM:', '[[regtime]]', '[[regtime]]'),
(2956, 1, 1, 'sale_order', 'entry_stock_locations', 'Stock Locations:', '[[regtime]]', '[[regtime]]'),
(2957, 1, 1, 'sale_order', 'edit_title_map', 'On the map', '[[regtime]]', '[[regtime]]'),
(2958, 1, 1, 'sale_order', 'text_enable_google_map', 'To view addresses on the interactive Google map provide Google API key in the general settings', '[[regtime]]', '[[regtime]]'),
(2959, 1, 1, 'setting_setting', 'heading_title', 'Settings', '[[regtime]]', '[[regtime]]'),
(2960, 1, 1, 'setting_setting', 'column_store_alias', 'Store', '[[regtime]]', '[[regtime]]'),
(2961, 1, 1, 'setting_setting', 'column_group', 'Group', '[[regtime]]', '[[regtime]]'),
(2962, 1, 1, 'setting_setting', 'column_key', 'Key', '[[regtime]]', '[[regtime]]'),
(2963, 1, 1, 'setting_setting', 'column_value', 'Value', '[[regtime]]', '[[regtime]]'),
(2964, 1, 1, 'setting_setting', 'text_success', 'Success: You have successfully saved your settings!', '[[regtime]]', '[[regtime]]'),
(2965, 1, 1, 'setting_setting', 'text_image_manager', 'Image Manager', '[[regtime]]', '[[regtime]]'),
(2966, 1, 1, 'setting_setting', 'text_select_group', '- Select Group -', '[[regtime]]', '[[regtime]]'),
(2967, 1, 1, 'setting_setting', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(2968, 1, 1, 'setting_setting', 'text_edit_store_settings', 'Edit Settings:', '[[regtime]]', '[[regtime]]'),
(2969, 1, 1, 'setting_setting', 'text_edit_template_settings', 'Edit Template Settings:', '[[regtime]]', '[[regtime]]'),
(2970, 1, 1, 'setting_setting', 'text_common_template_settings', 'Template Selection', '[[regtime]]', '[[regtime]]'),
(2971, 1, 1, 'setting_setting', 'text_edit_store', 'Edit Store', '[[regtime]]', '[[regtime]]'),
(2972, 1, 1, 'setting_setting', 'text_mail', 'Inner Mailer', '[[regtime]]', '[[regtime]]'),
(2973, 1, 1, 'setting_setting', 'text_smtp', 'SMTP', '[[regtime]]', '[[regtime]]'),
(2974, 1, 1, 'setting_setting', 'text_native', 'Native ( sendmail binary and options "sendmail_path" setting of php.ini)', '[[regtime]]', '[[regtime]]'),
(2975, 1, 1, 'setting_setting', 'text_dsn', 'Take from system/config.php', '[[regtime]]', '[[regtime]]'),
(2976, 1, 1, 'setting_setting', 'text_dsn_description', 'Mailer combines a <a target="_blank" href="https://en.wikipedia.org/wiki/Data_source_name">DSN</a> from config.php file. Please read <a target="_blank" href="https://abantecart.atlassian.net/wiki/spaces/AD/pages/7372837/Mail+Settings">our documentation</a> for details  ', '[[regtime]]', '[[regtime]]'),
(2977, 1, 1, 'setting_setting', 'tab_all', 'All', '[[regtime]]', '[[regtime]]'),
(2978, 1, 1, 'setting_setting', 'entry_name', 'Store Name:', '[[regtime]]', '[[regtime]]'),
(2979, 1, 1, 'setting_setting', 'entry_url', 'Store URL:<br /><span class="help">Include the full URL to your store. Make sure to add ''/'' at the end. Example: http://www.yourdomain.com/path/</span>', '[[regtime]]', '[[regtime]]'),
(2980, 1, 1, 'setting_setting', 'entry_owner', 'Store Owner:', '[[regtime]]', '[[regtime]]'),
(2981, 1, 1, 'setting_setting', 'entry_address', 'Address:', '[[regtime]]', '[[regtime]]'),
(2982, 1, 1, 'setting_setting', 'entry_email', 'E-Mail:', '[[regtime]]', '[[regtime]]'),
(2983, 1, 1, 'setting_setting', 'entry_alert_emails', 'Additional Alert E-Mails:<br /><span class="help">Any additional emails you want to receive the alert email, in addition to the main store email. (comma separated)</span>', '[[regtime]]', '[[regtime]]'),
(2984, 1, 1, 'setting_setting', 'error_alert_emails', 'Alert E-Mails must be valid and comma-separated!', '[[regtime]]', '[[regtime]]'),
(2985, 1, 1, 'setting_setting', 'entry_telephone', 'Telephone:', '[[regtime]]', '[[regtime]]'),
(2986, 1, 1, 'setting_setting', 'entry_fax', 'Fax:', '[[regtime]]', '[[regtime]]'),
(2987, 1, 1, 'setting_setting', 'entry_title', 'Title:<br /><span class="help">This is displayed in storefront browser title</span>', '[[regtime]]', '[[regtime]]'),
(2988, 1, 1, 'setting_setting', 'entry_meta_description', 'Meta Tag Description:<br /><span class="help">Storefront main page meta tag description</span>', '[[regtime]]', '[[regtime]]'),
(2989, 1, 1, 'setting_setting', 'entry_meta_keywords', 'Meta Keywords:<br /><span class="help">Storefront main page meta tag keywords (comma separated)</span>', '[[regtime]]', '[[regtime]]'),
(2990, 1, 1, 'setting_setting', 'entry_description', 'Welcome Message:', '[[regtime]]', '[[regtime]]'),
(2991, 1, 1, 'setting_setting', 'entry_template', 'Template:<span class="help">Storefront template. This can be main or extension template</span>', '[[regtime]]', '[[regtime]]'),
(2992, 1, 1, 'setting_setting', 'entry_admin_template', 'Control Panel Template:', '[[regtime]]', '[[regtime]]'),
(2993, 1, 1, 'setting_setting', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(2994, 1, 1, 'setting_setting', 'entry_zone', 'Region / State:', '[[regtime]]', '[[regtime]]'),
(2995, 1, 1, 'setting_setting', 'entry_language', 'Storefront Language:', '[[regtime]]', '[[regtime]]'),
(2996, 1, 1, 'setting_setting', 'entry_admin_language', 'Administration Language: <span class="help">NOTE: works if no user preferred language is found in the browser</span>', '[[regtime]]', '[[regtime]]'),
(2997, 1, 1, 'setting_setting', 'entry_currency', 'Base Currency:<span class="help">This is a base currency for all stores. Do not change if you do not understand what will happen. Warning: Changing of base currency will not change your base prices for products. You will need to review and adjust all the prices if needed. Base currency exchange rate will be set to 1.00 and all other currencies exchange rates will be adjusted in respect to new base currency.</span>', '[[regtime]]', '[[regtime]]'),
(2998, 1, 1, 'setting_setting', 'entry_currency_auto', 'Auto Update Currency:<br /><span class="help">Set your store to automatically update currencies daily.</span>', '[[regtime]]', '[[regtime]]'),
(2999, 1, 1, 'setting_setting', 'entry_weight_class', 'Weight Class:', '[[regtime]]', '[[regtime]]'),
(3000, 1, 1, 'setting_setting', 'entry_length_class', 'Length Class:', '[[regtime]]', '[[regtime]]'),
(3001, 1, 1, 'setting_setting', 'entry_auto_translate_status', 'Autotranslate Status:<br /><span class="help">This enabled translation of missing text definitions or language specific data if text values are missing for used language.</span>', '[[regtime]]', '[[regtime]]'),
(3002, 1, 1, 'setting_setting', 'entry_translate_src_lang_code', 'Source language for translation:<br /><span class="help">Select source language to be used for autotranslation.</span>', '[[regtime]]', '[[regtime]]'),
(3003, 1, 1, 'setting_setting', 'entry_translate_method', 'Text Translation Method:<br /><span class="help">Select method you want to use for translation. Default method is a straight copy of source language text</span>', '[[regtime]]', '[[regtime]]'),
(3004, 1, 1, 'setting_setting', 'entry_translate_override_existing', 'Override if source language text was changed:<br /><span class="help">If set, text in all languages will be replaced with new translation if source language text is edited. NOTE: Can cause many translations.</span>', '[[regtime]]', '[[regtime]]'),
(3005, 1, 1, 'setting_setting', 'entry_warn_lang_text_missing', 'Warn for missing language text:<br /><span class="help">Get warning message if missing language text is detected.</span>', '[[regtime]]', '[[regtime]]'),
(3006, 1, 1, 'setting_setting', 'entry_tax', 'Display Prices With Tax:', '[[regtime]]', '[[regtime]]'),
(3007, 1, 1, 'setting_setting', 'entry_tax_store', 'Default Store Tax Rate:', '[[regtime]]', '[[regtime]]'),
(3008, 1, 1, 'setting_setting', 'entry_tax_store_0', 'No Tax', '[[regtime]]', '[[regtime]]'),
(3009, 1, 1, 'setting_setting', 'entry_tax_store_1', 'Store Default Zone', '[[regtime]]', '[[regtime]]'),
(3010, 1, 1, 'setting_setting', 'entry_tax_customer', 'Use Customer Tax Address:', '[[regtime]]', '[[regtime]]'),
(3011, 1, 1, 'setting_setting', 'entry_tax_customer_0', 'Shipping Address', '[[regtime]]', '[[regtime]]'),
(3012, 1, 1, 'setting_setting', 'entry_tax_customer_1', 'Billing Address', '[[regtime]]', '[[regtime]]'),
(3013, 1, 1, 'setting_setting', 'entry_invoice', 'Invoice Start No.:<br /><span class="help">Set the starting number the invoices will begin from.</span>', '[[regtime]]', '[[regtime]]'),
(3014, 1, 1, 'setting_setting', 'entry_invoice_prefix', 'Invoice Prefix:<br /><span class="help">Set the invoice prefix e.g. IN/001</span>', '[[regtime]]', '[[regtime]]'),
(3015, 1, 1, 'setting_setting', 'entry_customer_group', 'Customer Group:<br /><span class="help">Default customer group.</span>', '[[regtime]]', '[[regtime]]'),
(3016, 1, 1, 'setting_setting', 'entry_customer_price', 'Login Display Prices:<br /><span class="help">Show prices even if customer is not logged in.</span>', '[[regtime]]', '[[regtime]]'),
(3017, 1, 1, 'setting_setting', 'entry_customer_approval', 'Review New Registrations:<br /><span class="help">If enabled, do not allow new customer to login until their account has been approved.</span>', '[[regtime]]', '[[regtime]]'),
(3018, 1, 1, 'setting_setting', 'entry_prevent_email_as_login', 'Require Login Name:<br /><span class="help">To improve security, require customers to create unique login name instead of using email address as login name. If set to ON, existing customers will be asked to create new login name at the first login. If OFF, login name is set as customer email address.</span>', '[[regtime]]', '[[regtime]]'),
(3019, 1, 1, 'setting_setting', 'entry_guest_checkout', 'Guest Checkout:<br /><span class="help">Allow customers to checkout without creating an account. This will not be available when a downloadable product is in the shopping cart.</span>', '[[regtime]]', '[[regtime]]'),
(3020, 1, 1, 'setting_setting', 'entry_account', 'Account Terms:<br /><span class="help">Forces people to agree to terms before an account can be created.</span>', '[[regtime]]', '[[regtime]]'),
(3021, 1, 1, 'setting_setting', 'entry_checkout', 'Checkout Terms:<br /><span class="help">Forces people to agree to terms before an a customer can checkout.</span>', '[[regtime]]', '[[regtime]]'),
(3022, 1, 1, 'setting_setting', 'entry_order_status', 'Order Status:<br /><span class="help">Set the default order status when an order is processed.</span>', '[[regtime]]', '[[regtime]]'),
(3023, 1, 1, 'setting_setting', 'entry_customer_cancelation_order_status', 'Allow Customer to Cancel Order on Status:', '[[regtime]]', '[[regtime]]'),
(3024, 1, 1, 'setting_setting', 'entry_stock_display', 'Display Stock Quantity:<br /><span class="help">Display stock quantity on the product page.</span>', '[[regtime]]', '[[regtime]]'),
(3025, 1, 1, 'setting_setting', 'entry_nostock_autodisable', 'No Stock Auto Disable:<br /><span class="help">Disable your product or option value for view if stock drops to 0. Message notification will be send </span>', '[[regtime]]', '[[regtime]]'),
(3026, 1, 1, 'setting_setting', 'entry_stock_checkout', 'Default Stock Checkout:<br /><span class="help">Set default setting to allow customers checkout even if the products are out of stock</span>', '[[regtime]]', '[[regtime]]'),
(3027, 1, 1, 'setting_setting', 'entry_stock_status', 'Default Pre-Order Stock Status:<br /><span class="help">Default setting for Pre-order status message for product. Used on product edit page.</span>', '[[regtime]]', '[[regtime]]'),
(3028, 1, 1, 'setting_setting', 'entry_logo', 'Store Logo:', '[[regtime]]', '[[regtime]]'),
(3029, 1, 1, 'setting_setting', 'entry_mail_logo', 'Email Logo:', '[[regtime]]', '[[regtime]]'),
(3030, 1, 1, 'setting_setting', 'entry_icon', 'Icon:<br /><span class="help">The icon can be a PNG or ICON type that is 16px x 16px.</span>', '[[regtime]]', '[[regtime]]'),
(3031, 1, 1, 'setting_setting', 'entry_width', 'Width:', '[[regtime]]', '[[regtime]]'),
(3032, 1, 1, 'setting_setting', 'entry_height', 'Height:', '[[regtime]]', '[[regtime]]'),
(3033, 1, 1, 'setting_setting', 'entry_image_thumb', 'Product Image Thumb Size:', '[[regtime]]', '[[regtime]]'),
(3034, 1, 1, 'setting_setting', 'entry_image_thumb_width', 'Product Image Thumb Width:', '[[regtime]]', '[[regtime]]'),
(3035, 1, 1, 'setting_setting', 'entry_image_thumb_height', 'Product Image Thumb Height:', '[[regtime]]', '[[regtime]]'),
(3036, 1, 1, 'setting_setting', 'entry_image_popup', 'Product Image Popup Size:', '[[regtime]]', '[[regtime]]'),
(3037, 1, 1, 'setting_setting', 'entry_image_popup_width', 'Large Window Preview Width:', '[[regtime]]', '[[regtime]]'),
(3038, 1, 1, 'setting_setting', 'entry_image_popup_height', 'Large Window Preview Height:', '[[regtime]]', '[[regtime]]'),
(3039, 1, 1, 'setting_setting', 'entry_image_category', 'Category List Size:', '[[regtime]]', '[[regtime]]'),
(3040, 1, 1, 'setting_setting', 'entry_image_category_width', 'Category List Width:', '[[regtime]]', '[[regtime]]'),
(3041, 1, 1, 'setting_setting', 'entry_image_category_height', 'Category List Height:', '[[regtime]]', '[[regtime]]'),
(3042, 1, 1, 'setting_setting', 'entry_image_manufacturer_width', 'Brand Icon List Width:', '[[regtime]]', '[[regtime]]'),
(3043, 1, 1, 'setting_setting', 'entry_image_manufacturer_height', 'Brand Icon List Height:', '[[regtime]]', '[[regtime]]'),
(3044, 1, 1, 'setting_setting', 'entry_image_product', 'Product List Size:', '[[regtime]]', '[[regtime]]'),
(3045, 1, 1, 'setting_setting', 'entry_image_product_height', 'Product List Height:<br /><span class="help">This is to control height of a preview image in the listing pages of admin and other places in the storefront. Note, this setting is shared between admin and default storefront template.</span>', '[[regtime]]', '[[regtime]]'),
(3046, 1, 1, 'setting_setting', 'entry_image_product_width', 'Product List Width:<br /><span class="help">This is to control width of a preview image in the listing pages of admin and other places in the storefront. Note, this setting is shared between admin and default storefront template.</span>', '[[regtime]]', '[[regtime]]'),
(3047, 1, 1, 'setting_setting', 'entry_image_additional', 'Additional Product Image Size:', '[[regtime]]', '[[regtime]]'),
(3048, 1, 1, 'setting_setting', 'entry_image_additional_width', 'Additional Product Image Width:', '[[regtime]]', '[[regtime]]'),
(3049, 1, 1, 'setting_setting', 'entry_image_additional_height', 'Additional Product Image Height:', '[[regtime]]', '[[regtime]]'),
(3050, 1, 1, 'setting_setting', 'entry_image_related', 'Related Product Image Size:', '[[regtime]]', '[[regtime]]'),
(3051, 1, 1, 'setting_setting', 'entry_image_related_width', 'Related Product Image Width:', '[[regtime]]', '[[regtime]]'),
(3052, 1, 1, 'setting_setting', 'entry_image_related_height', 'Related Product Image Height:', '[[regtime]]', '[[regtime]]'),
(3053, 1, 1, 'setting_setting', 'entry_image_cart', 'Cart Image Size:', '[[regtime]]', '[[regtime]]'),
(3054, 1, 1, 'setting_setting', 'entry_image_cart_width', 'Cart Image Width:', '[[regtime]]', '[[regtime]]'),
(3055, 1, 1, 'setting_setting', 'entry_image_cart_height', 'Cart Image Height:', '[[regtime]]', '[[regtime]]'),
(3056, 1, 1, 'setting_setting', 'entry_image_grid', 'Grid Image Size:', '[[regtime]]', '[[regtime]]'),
(3057, 1, 1, 'setting_setting', 'entry_image_grid_width', 'Grid Image Width:<br /><span class="help">This is to control width of a very small preview image in the listing grids of admin and other places in the storefront. Note, this setting is shared between admin and default storefront template.</span>', '[[regtime]]', '[[regtime]]'),
(3058, 1, 1, 'setting_setting', 'entry_image_grid_height', 'Grid Image Height:<br /><span class="help">This is to control height of a very small preview image in the listing grids of admin and other places in the storefront. Note, this setting is shared between admin and default storefront template.</span>', '[[regtime]]', '[[regtime]]'),
(3059, 1, 1, 'setting_setting', 'entry_alert_mail', 'Alert Mail:<br /><span class="help">Send a email to the store owner when a new order is created.</span>', '[[regtime]]', '[[regtime]]'),
(3060, 1, 1, 'setting_setting', 'entry_download', 'Allow Downloads:', '[[regtime]]', '[[regtime]]'),
(3061, 1, 1, 'setting_setting', 'entry_download_status', 'Download Order Status:<br /><span class="help">Set the order status the customers order must reach before they are allowed to access their downloadable products.</span>', '[[regtime]]', '[[regtime]]'),
(3062, 1, 1, 'setting_setting', 'entry_mail_transporting', 'Mail Transporting:', '[[regtime]]', '[[regtime]]'),
(3063, 1, 1, 'setting_setting', 'text_native_mail_description', 'Mailer uses the sendmail binary and options configured in the sendmail_path setting of php.ini. ', '[[regtime]]', '[[regtime]]'),
(3064, 1, 1, 'setting_setting', 'entry_smtp_host', 'SMTP Host:<br /><span class="help">Use ssl://smtp.yourdomain.com for secure smtp connection', '[[regtime]]', '[[regtime]]'),
(3065, 1, 1, 'setting_setting', 'entry_smtp_username', 'SMTP Username:', '[[regtime]]', '[[regtime]]'),
(3066, 1, 1, 'setting_setting', 'entry_smtp_password', 'SMTP Password:', '[[regtime]]', '[[regtime]]'),
(3067, 1, 1, 'setting_setting', 'entry_smtp_port', 'SMTP Port:', '[[regtime]]', '[[regtime]]'),
(3068, 1, 1, 'setting_setting', 'entry_smtp_timeout', 'SMTP Timeout:', '[[regtime]]', '[[regtime]]'),
(3069, 1, 1, 'setting_setting', 'entry_ssl', 'Use SSL:<br /><span class="help">To use SSL check with your host if a SSL certificate is installed.</span>', '[[regtime]]', '[[regtime]]'),
(3070, 1, 1, 'setting_setting', 'entry_session_ttl', 'Control Panel Session Expiration:<br /><span class="help">This value controls time interval in minutes before you will be asked to login again due to no activity.</span>', '[[regtime]]', '[[regtime]]'),
(3071, 1, 1, 'setting_setting', 'entry_encryption', 'Encryption Key:<br /><span class="help">Setting migrated to config file starting in v1.2.1.</span>', '[[regtime]]', '[[regtime]]'),
(3072, 1, 1, 'setting_setting', 'entry_seo_url', 'Use SEO URL''s:<br /><span class="help">To use SEO URL''s apache module mod-rewrite must be installed and you need to rename the htaccess.txt to .htaccess. Note: If abantecart not installed in the root of domain must be changed rewriteBase rule inside .htaccess file.</span>', '[[regtime]]', '[[regtime]]'),
(3073, 1, 1, 'setting_setting', 'entry_retina_enable', 'Generate high-res (retina) images:<br /><span class="help">To use this apache module mod-rewrite must be installed and you need to rename the htaccess.txt to .htaccess. Note: If abantecart not installed in the root of domain must be changed rewriteBase rule inside .htaccess file. <br>After enabling should clear the cache images. </span>', '[[regtime]]', '[[regtime]]'),
(3074, 1, 1, 'setting_setting', 'entry_image_quality', 'Jpeg Images Compression Level', '[[regtime]]', '[[regtime]]'),
(3075, 1, 1, 'setting_setting', 'entry_compression', 'Output Compression Level:<br /><span class="help">GZIP for more efficient transfer to requesting clients. Compression level must be between 0 - 9</span>', '[[regtime]]', '[[regtime]]'),
(3076, 1, 1, 'setting_setting', 'entry_error_display', 'Display Errors:<br /><span class="help">Set to yes if you want to see the exceptions and errors</span>', '[[regtime]]', '[[regtime]]'),
(3077, 1, 1, 'setting_setting', 'entry_error_log', 'Log Errors:<br /><span class="help">Set to yes if you want to save the exceptions and errors to the log</span>', '[[regtime]]', '[[regtime]]'),
(3078, 1, 1, 'setting_setting', 'entry_enable_reviews', 'Enable Reviews:<br /><span class="help"></span>', '[[regtime]]', '[[regtime]]'),
(3079, 1, 1, 'setting_setting', 'entry_cache_enable', 'Cache enabled:<br /><span class="help">Please be careful when disable caching. Cached pages will not be re-created and site might start loading slow. </span>', '[[regtime]]', '[[regtime]]'),
(3080, 1, 1, 'setting_setting', 'text_setting_cache_drivers', ' Currently using cache <b>%s</b> driver. Other drivers available for configuration are <i>%s</i> ', '[[regtime]]', '[[regtime]]'),
(3081, 1, 1, 'setting_setting', 'entry_storefront_api_status', 'Storefront API status:', '[[regtime]]', '[[regtime]]'),
(3082, 1, 1, 'setting_setting', 'entry_storefront_api_key', 'Storefront API Key:<br /><span class="help">Set this key to provide restricted (more secure) access to storefront API.</span>', '[[regtime]]', '[[regtime]]'),
(3083, 1, 1, 'setting_setting', 'entry_storefront_api_stock_check', 'Storefront API Stock Access:<br /><span class="help">Enable if you allow storefront API to check stock availability</span>', '[[regtime]]', '[[regtime]]'),
(3084, 1, 1, 'setting_setting', 'entry_admin_api_status', 'Admin API status:', '[[regtime]]', '[[regtime]]'),
(3085, 1, 1, 'setting_setting', 'entry_admin_api_key', 'Admin API Key:<br /><span class="help">Set this key to provide restricted (more secure) access to admin API.</span>', '[[regtime]]', '[[regtime]]'),
(3086, 1, 1, 'setting_setting', 'entry_admin_access_ip_list', 'Admin API Access IPs:<br /><span class="help">Provide list of IPs (comma separated) that will be allowed to access admin API. Other IPs will be blocked</span>', '[[regtime]]', '[[regtime]]'),
(3087, 1, 1, 'setting_setting', 'entry_upload_max_size', 'Resource Library Upload Max File Size, kB', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(3088, 1, 1, 'setting_setting', 'entry_debug', 'Show Debug Info:<br /><span class="help">Set this ON if you want to see the execution details and show debug details.</span>', '[[regtime]]', '[[regtime]]'),
(3089, 1, 1, 'setting_setting', 'entry_debug_0', 'Off', '[[regtime]]', '[[regtime]]'),
(3090, 1, 1, 'setting_setting', 'entry_debug_1', 'Show', '[[regtime]]', '[[regtime]]'),
(3091, 1, 1, 'setting_setting', 'entry_debug_2', 'Log', '[[regtime]]', '[[regtime]]'),
(3092, 1, 1, 'setting_setting', 'entry_debug_level', 'Debug Level:<br /><span class="help">Select the depth of the details you need to see in the debug output.</span>', '[[regtime]]', '[[regtime]]'),
(3093, 1, 1, 'setting_setting', 'entry_debug_level_0', 'Level 0 - no logs , only exception errors ', '[[regtime]]', '[[regtime]]'),
(3094, 1, 1, 'setting_setting', 'entry_debug_level_1', 'Level 1 - errors and warnings', '[[regtime]]', '[[regtime]]'),
(3095, 1, 1, 'setting_setting', 'entry_debug_level_2', 'Level 2 - #1 + mysql site load, php file execution time and page elements load time ', '[[regtime]]', '[[regtime]]'),
(3096, 1, 1, 'setting_setting', 'entry_debug_level_3', 'Level 3 - #2 + basic logs and stack of execution', '[[regtime]]', '[[regtime]]'),
(3097, 1, 1, 'setting_setting', 'entry_debug_level_4', 'Level 4 - #3 + dump mysql statements ', '[[regtime]]', '[[regtime]]'),
(3098, 1, 1, 'setting_setting', 'entry_debug_level_5', 'Level 5 - #4 + intermediate variable ', '[[regtime]]', '[[regtime]]'),
(3099, 1, 1, 'setting_setting', 'entry_template_debug', 'Template debug:<br /><span class="help">Enable this setting if you need to check issues with template in storefront and control panel.</span>', '[[regtime]]', '[[regtime]]'),
(3100, 1, 1, 'setting_setting', 'entry_error_filename', 'Error Log Filename:<br /><span class="help">This is a file where errors are saved.</span>', '[[regtime]]', '[[regtime]]'),
(3101, 1, 1, 'setting_setting', 'entry_shipping_session', 'Use Shipping Session:<br /><span class="help">Saves shipping quotes to session to avoid re-quoting unnecessarily. Quotes will only be re-quoted if cart or address is changed.</span>', '[[regtime]]', '[[regtime]]'),
(3102, 1, 1, 'setting_setting', 'entry_catalog_limit', 'Default Items per Page (Storefront):<br /><span class="help">Sets how many storefront items are shown per page (products, categories, etc)</span>', '[[regtime]]', '[[regtime]]'),
(3103, 1, 1, 'setting_setting', 'entry_admin_limit', 'Default Items per Page (Admin):<br /><span class="help">Sets how many admin items are shown per page in listing grids (orders, customers, etc)</span>', '[[regtime]]', '[[regtime]]'),
(3104, 1, 1, 'setting_setting', 'entry_bestseller_limit', 'Number of Items In Bestseller Block ', '[[regtime]]', '[[regtime]]'),
(3105, 1, 1, 'setting_setting', 'entry_featured_limit', 'Number of Items In Featured Block ', '[[regtime]]', '[[regtime]]'),
(3106, 1, 1, 'setting_setting', 'entry_latest_limit', 'Number of Items In Latest Block ', '[[regtime]]', '[[regtime]]'),
(3107, 1, 1, 'setting_setting', 'entry_special_limit', 'Number of Items In Special Block ', '[[regtime]]', '[[regtime]]'),
(3108, 1, 1, 'setting_setting', 'entry_content_limit', 'Number of Items In Content Blocks ', '[[regtime]]', '[[regtime]]'),
(3109, 1, 1, 'setting_setting', 'entry_cart_weight', 'Display Weight on Cart Page:<br /><span class="help">Show the cart weight on the cart page</span>', '[[regtime]]', '[[regtime]]'),
(3110, 1, 1, 'setting_setting', 'entry_reviews', 'Post Reviews:<br /><span class="help">Restrict who can post review for the products</span>', '[[regtime]]', '[[regtime]]'),
(3111, 1, 1, 'setting_setting', 'entry_maintenance', 'Maintenance Mode:<br /><span class="help">Prevents customers from browsing your store. They will instead see a maintenance message. If logged in as admin, you will see the store as normal.</span>', '[[regtime]]', '[[regtime]]'),
(3112, 1, 1, 'setting_setting', 'entry_voicecontrol', 'Voice Control:<br /><span class="help">Enable admin voice control to activate voice commands feature. Currently only supported in Chrome version 25 or later.</span>', '[[regtime]]', '[[regtime]]'),
(3113, 1, 1, 'setting_setting', 'entry_help_links', 'Help Links:<br /><span class="help">If you want to see Help Icons and links to AbanteCart site. This will help you learn about features and how to use them. If you advanced user and do not want to see these help icons, you can disable.</span>', '[[regtime]]', '[[regtime]]'),
(3114, 1, 1, 'setting_setting', 'entry_show_tree_data', 'Enable Tree Grid:<br /><span class="help">Enables admin grids to show parent/children types in one grid listing. NOTE: Pagination and multi-actions are disabled for these grids</span>', '[[regtime]]', '[[regtime]]'),
(3115, 1, 1, 'setting_setting', 'entry_cart_ajax', 'Same Page Add To Cart:<br /><span class="help">This will enable AJAX add to cart feature. Product can be added to cart without redirecting to cart page</span>', '[[regtime]]', '[[regtime]]'),
(3116, 1, 1, 'setting_setting', 'entry_storefront_width', 'Storefront Site Width:<br /><span class="help">Example: 100% or 1000px </span>', '[[regtime]]', '[[regtime]]'),
(3117, 1, 1, 'setting_setting', 'entry_admin_width', 'Admin Site Width:<br /><span class="help">Example: 100% or 1000px </span>', '[[regtime]]', '[[regtime]]'),
(3118, 1, 1, 'setting_setting', 'entry_total_order_maximum', 'Maximum order amount allowed:<br /><span class="help">Prevent checkout with large order sub-total amounts. 0 = NO LIMIT</span>', '[[regtime]]', '[[regtime]]'),
(3119, 1, 1, 'setting_setting', 'entry_total_order_minimum', 'Minimum order amount:<br /><span class="help">Prevent checkout if order sub-total does not reach minimum amount set. 0 = NO MINIMUM</span>', '[[regtime]]', '[[regtime]]'),
(3120, 1, 1, 'setting_setting', 'entry_system_check', 'System Check:<br /><span class="help">Enable this setting if you want to check your system condition in respect to AbanteCart functionality. System issues effecting AbanteCart will be reported as messages visible in admin.</span>', '[[regtime]]', '[[regtime]]'),
(3121, 1, 1, 'setting_setting', 'button_add_store', 'New Store', '[[regtime]]', '[[regtime]]'),
(3122, 1, 1, 'setting_setting', 'error_permission', 'Warning: You do not have permission to modify settings!', '[[regtime]]', '[[regtime]]'),
(3123, 1, 1, 'setting_setting', 'error_loginname', 'Login name must be alphanumeric only and between 5 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(3124, 1, 1, 'setting_setting', 'error_loginname_notunique', 'This login name is not available. Try different login name!', '[[regtime]]', '[[regtime]]'),
(3125, 1, 1, 'setting_setting', 'error_name', 'Store Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3126, 1, 1, 'setting_setting', 'error_url', 'Valid Store URL required!', '[[regtime]]', '[[regtime]]'),
(3127, 1, 1, 'setting_setting', 'error_title', 'Title must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3128, 1, 1, 'setting_setting', 'error_owner', 'Store Owner must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(3129, 1, 1, 'setting_setting', 'error_address', 'Store Address must be between 10 and 256 characters!', '[[regtime]]', '[[regtime]]'),
(3130, 1, 1, 'setting_setting', 'error_email', 'E-Mail Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(3131, 1, 1, 'setting_setting', 'error_telephone', 'Telephone must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3132, 1, 1, 'setting_setting', 'error_image_thumb', 'Product Image Thumb Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3133, 1, 1, 'setting_setting', 'error_image_popup', 'Product Image Popup Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3134, 1, 1, 'setting_setting', 'error_image_category', 'Category List Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3135, 1, 1, 'setting_setting', 'error_image_manufacturer', 'Brand Icon List Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3136, 1, 1, 'setting_setting', 'error_image_product', 'Product List Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3137, 1, 1, 'setting_setting', 'error_image_additional', 'Additional Product Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3138, 1, 1, 'setting_setting', 'error_image_related', 'Related Product Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3139, 1, 1, 'setting_setting', 'error_image_cart', 'Cart Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3140, 1, 1, 'setting_setting', 'error_image_grid', 'Grid Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3141, 1, 1, 'setting_setting', 'error_error_filename', 'Error Log Filename required!', '[[regtime]]', '[[regtime]]'),
(3142, 1, 1, 'setting_setting', 'error_required_data', 'Required Data has not been entered. Check for field errors!', '[[regtime]]', '[[regtime]]'),
(3143, 1, 1, 'setting_setting', 'error_uploaded_image', 'Uploaded file %s is not image or broken!', '[[regtime]]', '[[regtime]]'),
(3144, 1, 1, 'setting_setting', 'error_limit', 'Limit required!', '[[regtime]]', '[[regtime]]'),
(3145, 1, 1, 'setting_setting', 'text_front', 'Store Front', '[[regtime]]', '[[regtime]]'),
(3146, 1, 1, 'setting_setting', 'text_admin', 'Admin', '[[regtime]]', '[[regtime]]'),
(3147, 1, 1, 'setting_setting', 'error_mail', 'Please fill required fields for smtp-protocol!', '[[regtime]]', '[[regtime]]'),
(3148, 1, 1, 'setting_setting', 'text_sorting_sort_order_asc', 'Product''s Sort Order Low &gt; High', '[[regtime]]', '[[regtime]]'),
(3149, 1, 1, 'setting_setting', 'text_sorting_name_asc', 'Name A - Z', '[[regtime]]', '[[regtime]]'),
(3150, 1, 1, 'setting_setting', 'text_sorting_name_desc', 'Name Z - A', '[[regtime]]', '[[regtime]]'),
(3151, 1, 1, 'setting_setting', 'text_sorting_price_asc', 'Price Low &gt; High', '[[regtime]]', '[[regtime]]'),
(3152, 1, 1, 'setting_setting', 'text_sorting_price_desc', 'Price High &gt; Low', '[[regtime]]', '[[regtime]]'),
(3153, 1, 1, 'setting_setting', 'text_sorting_rating_asc', 'Rating Lowest', '[[regtime]]', '[[regtime]]'),
(3154, 1, 1, 'setting_setting', 'text_sorting_rating_desc', 'Rating Highest', '[[regtime]]', '[[regtime]]'),
(3155, 1, 1, 'setting_setting', 'text_sorting_date_asc', 'Date Old &gt; New', '[[regtime]]', '[[regtime]]'),
(3156, 1, 1, 'setting_setting', 'text_sorting_date_desc', 'Date New &gt; Old', '[[regtime]]', '[[regtime]]'),
(3157, 1, 1, 'setting_setting', 'entry_product_default_sort_order', 'Sort Products as default by:', '[[regtime]]', '[[regtime]]'),
(3158, 1, 1, 'setting_setting', 'entry_zero_customer_balance', 'Show Zero Customer Balance:<br /><span class="help">Note: Enable/disable display of balance message if customer account balance is 0</span>', '[[regtime]]', '[[regtime]]'),
(3159, 1, 1, 'setting_setting', 'entry_shipping_tax_estimate', 'Shipping and Tax Estimate:<br /><span class="help">Allow customers to get quick shipping and tax estimate in the shopping cart.</span>', '[[regtime]]', '[[regtime]]'),
(3160, 1, 1, 'setting_setting', 'entry_coupon_on_cart_page', 'Coupon on shopping cart page:<br /><span class="help">Allow customers to enter coupon code and see discount in the shopping cart.</span>', '[[regtime]]', '[[regtime]]'),
(3161, 1, 1, 'setting_setting', 'entry_google_analytics', 'Google Analytics 4 tag ID:<br /><span class="help">Add your <a href="https://support.google.com/analytics/answer/9539598?hl=en" target="_blank">Google Analytics tag ID</a> to enable site activity tracking. This also enables ecommerce activity tracking. You must enable ecommerce tracking in google on the profile settings page for your website</span>', '[[regtime]]', '[[regtime]]'),
(3162, 1, 1, 'setting_setting', 'entry_google_api_key', 'Google API Key (to enable google maps):<br /><span class="help">You can see address on the map. To enable google maps add your Google maps API key <a href="https://console.cloud.google.com/apis/credentials" target="_blank">Google Credentials Page</a>.</span>', '[[regtime]]', '[[regtime]]'),
(3163, 1, 1, 'setting_setting', 'entry_viewed_products_limit', 'Viewed products limit:', '[[regtime]]', '[[regtime]]'),
(3164, 1, 1, 'setting_setting', 'entry_viewed_products_image_width', 'Viewed products image width:', '[[regtime]]', '[[regtime]]'),
(3165, 1, 1, 'setting_setting', 'entry_viewed_products_image_height', 'Viewed products image height:', '[[regtime]]', '[[regtime]]'),
(3166, 1, 1, 'setting_setting', 'entry_ssl_url', 'Secure Store URL:<br /><span class="help">Include the full SSL URL(HTTPS) to your store. Make sure to add ''/'' at the end. Example: https://www.yourdomain.com/path/</span>', '[[regtime]]', '[[regtime]]'),
(3167, 1, 1, 'setting_setting', 'error_ssl_url', 'Valid Secure URL required!', '[[regtime]]', '[[regtime]]'),
(3168, 1, 1, 'setting_setting', 'entry_customer_email_activation', 'Email Activation for New Customers:<br /><span class="help">Don''t allow new customer to login until their account has been confirmed by activation link sent via email. For this to work, make sure "Approve New Customers" is set to OFF.</span>', '[[regtime]]', '[[regtime]]'),
(3169, 1, 1, 'setting_setting', 'text_clone_template', 'Clone Template With AbanteCart Developer Tools', '[[regtime]]', '[[regtime]]'),
(3170, 1, 1, 'setting_setting', 'text_set_template', 'Set this template for the storefront', '[[regtime]]', '[[regtime]]'),
(3171, 1, 1, 'setting_setting', 'entry_embed_status', 'Enable Storefront Embed:', '[[regtime]]', '[[regtime]]'),
(3172, 1, 1, 'setting_setting', 'entry_embed_click_action', 'Embed Click Action:', '[[regtime]]', '[[regtime]]'),
(3173, 1, 1, 'setting_setting', 'text_embed_click_action_modal', 'Same page Modal Dialog', '[[regtime]]', '[[regtime]]'),
(3174, 1, 1, 'setting_setting', 'text_embed_click_action_new_window', 'Open new page in new tab', '[[regtime]]', '[[regtime]]'),
(3175, 1, 1, 'setting_setting', 'text_embed_click_action_same_window', 'Open new page in same window', '[[regtime]]', '[[regtime]]'),
(3176, 1, 1, 'setting_setting', 'entry_account_create_captcha', 'Captcha on create account form :<br /><span class="help">Prevent spam/robot account creation with enabling human verification captcha</span>', '[[regtime]]', '[[regtime]]'),
(3177, 1, 1, 'setting_setting', 'entry_recaptcha_site_key', 'Google reCAPTCHA Site Key:<br /><span class="help">Add <a href="https://www.google.com/recaptcha" target="_blank">Google reCAPTCHA v2</a> to help your visitors with better captcha entry. If you enable reCAPTCHA site/secret keys, Google reCAPTCHA v2 will be activated instead of default AbanteCart captcha image</span>', '[[regtime]]', '[[regtime]]'),
(3178, 1, 1, 'setting_setting', 'entry_recaptcha_secret_key', 'Google reCAPTCHA Secret Key:<br /><span class="help">Add <a href="https://www.google.com/recaptcha" target="_blank">Google reCAPTCHA v2</a> to help your visitors with better captcha entry. If you enable reCAPTCHA site/secret keys, Google reCAPTCHA v2 will be activated instead of default AbanteCart captcha image</span>', '[[regtime]]', '[[regtime]]'),
(3179, 1, 1, 'setting_setting', 'text_setting_php_exceed', 'This value can not exceed your php.ini directive %s (<=%s)', '[[regtime]]', '[[regtime]]'),
(3180, 1, 1, 'setting_setting', 'entry_start_order_id', 'Order Start No.:<br /><span class="help">Set the starting number the orders will begin from.</span>', '[[regtime]]', '[[regtime]]'),
(3181, 1, 1, 'setting_setting', 'error_start_order_id', 'Order start number must be a numeric!', '[[regtime]]', '[[regtime]]'),
(3182, 1, 1, 'setting_setting', 'error_starting_invoice_id', 'Invoice start number must be a numeric!', '[[regtime]]', '[[regtime]]'),
(3183, 1, 1, 'setting_setting', 'entry_expire_order_days', 'Incomplete Order Expiration:<br /><span class="help">This value controls time interval in days before incomplete orders will be deleted. Empty value means that no orders will be to deleted.</span>', '[[regtime]]', '[[regtime]]'),
(3184, 1, 1, 'setting_setting', 'error_expire_order_days', 'Incomplete Order Expiration value must be a numeric!', '[[regtime]]', '[[regtime]]'),
(3185, 1, 1, 'setting_setting', 'text_storefront', 'Storefront', '[[regtime]]', '[[regtime]]'),
(3186, 1, 1, 'setting_setting', 'text_im_driver', 'Driver', '[[regtime]]', '[[regtime]]'),
(3187, 1, 1, 'setting_setting', 'text_im_protocol', 'IM Protocol', '[[regtime]]', '[[regtime]]'),
(3188, 1, 1, 'setting_setting', 'entry_sms_driver', 'SMS Provider', '[[regtime]]', '[[regtime]]'),
(3189, 1, 1, 'setting_setting', 'entry_sms_driver_tooltip', 'Select an extension for SMS service provider', '[[regtime]]', '[[regtime]]'),
(3190, 1, 1, 'setting_setting', 'entry_storefront_status_tooltip', 'Enable SMS for customers', '[[regtime]]', '[[regtime]]'),
(3191, 1, 1, 'setting_setting', 'entry_admin_status_tooltip', 'Enable SMS for administrators', '[[regtime]]', '[[regtime]]'),
(3192, 1, 1, 'setting_setting', 'text_no_driver', ' No IM Driver Found', '[[regtime]]', '[[regtime]]'),
(3193, 1, 1, 'setting_setting', 'text_im_settings_attention', 'These settings are for instant messages sent automatically during AbanteCart events in storefront and admin. ', '[[regtime]]', '[[regtime]]'),
(3194, 1, 1, 'setting_setting', 'entry_task_api_key', 'Tasks API Key:<br/><span class="help">This is a secret key to allow AbanteCart to run scheduled processes from the browser with /task.php file. If not set, tasks will not run via browser.<br/>NOTE: This API Key is not required for running tasks command line.</span>', '[[regtime]]', '[[regtime]]'),
(3195, 1, 1, 'setting_setting', 'entry_duplicate_contact_us', 'Duplicate Contact Enquiries to Messages', '[[regtime]]', '[[regtime]]'),
(3196, 1, 1, 'setting_setting', 'entry_tax_class', 'Default Tax Class:<br/><span class="help">Default value will be taken as default value for tax class of new creating product.</span>', '[[regtime]]', '[[regtime]]'),
(3197, 1, 1, 'setting_setting', 'entry_account_recaptcha_v3', 'Enable reCaptcha v3', '[[regtime]]', '[[regtime]]'),
(3198, 1, 1, 'setting_setting', 'text_review_disable', 'Do not allow', '[[regtime]]', '[[regtime]]'),
(3199, 1, 1, 'setting_setting', 'text_review_allow_all', 'Any customer or visitor', '[[regtime]]', '[[regtime]]'),
(3200, 1, 1, 'setting_setting', 'text_review_allow_only_registered', 'Registered Customer', '[[regtime]]', '[[regtime]]'),
(3201, 1, 1, 'setting_setting', 'text_review_allow_who_purchase', 'Customer with verified order', '[[regtime]]', '[[regtime]]'),
(3202, 1, 1, 'setting_setting', 'entry_display_reviews', 'Display Reviews:', '[[regtime]]', '[[regtime]]'),
(3203, 1, 1, 'setting_setting', 'entry_city', 'City:', '[[regtime]]', '[[regtime]]'),
(3204, 1, 1, 'setting_setting', 'entry_postcode', 'Postal Code:', '[[regtime]]', '[[regtime]]'),
(3205, 1, 1, 'setting_setting', 'entry_latitude', 'Latitude:', '[[regtime]]', '[[regtime]]'),
(3206, 1, 1, 'setting_setting', 'entry_longitude', 'Longitude:', '[[regtime]]', '[[regtime]]'),
(3207, 1, 1, 'setting_setting', 'entry_opening_hours', 'Opening Hours:', '[[regtime]]', '[[regtime]]'),
(3208, 1, 1, 'setting_setting', 'error_postcode', 'Postal code is required', '[[regtime]]', '[[regtime]]'),
(3209, 1, 1, 'setting_setting', 'error_city', 'City name is required', '[[regtime]]', '[[regtime]]'),
(3210, 1, 1, 'setting_setting', 'entry_image_resize_fill_color', 'Color of fill for image resize<br/><span class="help">Color that will be filled into empty areas during image resizing from rectangle into square</span>', '[[regtime]]', '[[regtime]]'),
(3211, 1, 1, 'setting_setting', 'warning_https_store_url', 'To maintain correct platform functionality in all browsers and maintain data security, HTTPS protocol is required. All requests should be sent to HTTPS', '[[regtime]]', '[[regtime]]'),
(3212, 1, 1, 'setting_setting', 'entry_default_logo', 'Default Store Logo:', '[[regtime]]', '[[regtime]]'),
(3213, 1, 1, 'setting_setting', 'entry_default_mail_logo', 'Default Email Logo:', '[[regtime]]', '[[regtime]]'),
(3214, 1, 1, 'setting_setting', 'entry_phone_validation_pattern', 'Phone Validation Regex Pattern:', '[[regtime]]', '[[regtime]]'),
(3215, 1, 1, 'setting_setting', 'entry_cron_command', 'Crontab in Linux command <span class="help">Run command crontab -e with the same Linux user running a web server for the AbanteCart. In the editor add the command</span>', '[[regtime]]', '[[regtime]]'),
(3216, 1, 1, 'setting_setting', 'entry_fast_checkout_allow_coupon', 'Allow Coupon Entry at Checkout <br /><span class="help">Enable coupon entry by customers and guests</span>', '[[regtime]]', '[[regtime]]'),
(3217, 1, 1, 'setting_setting', 'entry_fast_checkout_payment_address_equal_shipping', 'Require Payment Address Be the same as Shipping Address', '[[regtime]]', '[[regtime]]'),
(3218, 1, 1, 'setting_setting', 'entry_fast_checkout_require_phone_number', 'Require Phone Number at Checkout <br /><span class="help">When enabled, this setting requires customers or guests to provide a phone number during the checkout process.</span>', '[[regtime]]', '[[regtime]]'),
(3219, 1, 1, 'setting_setting', 'entry_fast_checkout_create_account', 'Guest Checkout Create Account <br /><span class="help">Offer the guest to create an account at the end of the checkout. This is transparent to guests and email will be sent with the login details.</span>', '[[regtime]]', '[[regtime]]'),
(3220, 1, 1, 'setting_setting', 'entry_fast_checkout_buy_now_status', ' Show "Buy Now" Button ', '[[regtime]]', '[[regtime]]'),
(3221, 1, 1, 'setting_setting', 'entry_fast_checkout_show_order_comment_field', 'Show order comment field<br/><span class="help">Comment textarea will be shown during checkout process</span>', '[[regtime]]', '[[regtime]]'),
(3222, 1, 1, 'setting_store', 'heading_title', 'Store Details', '[[regtime]]', '[[regtime]]'),
(3223, 1, 1, 'setting_store', 'text_success', 'Success: You have modified settings!', '[[regtime]]', '[[regtime]]'),
(3224, 1, 1, 'setting_store', 'text_image_manager', 'Image Manager', '[[regtime]]', '[[regtime]]'),
(3225, 1, 1, 'setting_store', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(3226, 1, 1, 'setting_store', 'text_edit_store', 'Edit Store:', '[[regtime]]', '[[regtime]]'),
(3227, 1, 1, 'setting_store', 'entry_name', 'Store Name:<br /><span class="help">Copied to settings and shown on a storefront section.</span>', '[[regtime]]', '[[regtime]]'),
(3228, 1, 1, 'setting_store', 'entry_url', '            Store URL:<br /><span class="help">Include the full URL to your store. Make sure to add ''/'' at the end. Example: http://www.yourdomain.com/path/<br /><br />Don''t use directories to create a new store. You should always point another domain or sub domain to your hosting.</span>', '[[regtime]]', '[[regtime]]'),
(3229, 1, 1, 'setting_store', 'entry_ssl', 'Use SSL:<br /><span class="help">To use SSL check with your host if a SSL certificate is installed.</span>', '[[regtime]]', '[[regtime]]'),
(3230, 1, 1, 'setting_store', 'entry_title', 'Title:', '[[regtime]]', '[[regtime]]'),
(3231, 1, 1, 'setting_store', 'entry_meta_description', 'Meta Tag Description:', '[[regtime]]', '[[regtime]]'),
(3232, 1, 1, 'setting_store', 'entry_template', 'Template:', '[[regtime]]', '[[regtime]]'),
(3233, 1, 1, 'setting_store', 'entry_description', 'Welcome Message:', '[[regtime]]', '[[regtime]]'),
(3234, 1, 1, 'setting_store', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(3235, 1, 1, 'setting_store', 'entry_zone', 'Region / State:', '[[regtime]]', '[[regtime]]'),
(3236, 1, 1, 'setting_store', 'entry_language', 'Language:', '[[regtime]]', '[[regtime]]'),
(3237, 1, 1, 'setting_store', 'entry_status', '            Store Status<br /><span class="help">Store status in a storefront. Status OFF will direct to default store. Use Maintenance Mode setting to set temporary store maintenance message</span>', '[[regtime]]', '[[regtime]]'),
(3238, 1, 1, 'setting_store', 'entry_alias', 'Name Alias<br /><span class="help">Store Name Alias. If left blank, will be based on shortened name</span>', '[[regtime]]', '[[regtime]]'),
(3239, 1, 1, 'setting_store', 'button_add_store', 'New Store', '[[regtime]]', '[[regtime]]'),
(3240, 1, 1, 'setting_store', 'button_delete_store', 'Delete Store', '[[regtime]]', '[[regtime]]'),
(3241, 1, 1, 'setting_store', 'button_edit_settings', 'Edit Settings', '[[regtime]]', '[[regtime]]'),
(3242, 1, 1, 'setting_store', 'error_permission', 'Warning: You do not have permission to modify stores!', '[[regtime]]', '[[regtime]]'),
(3243, 1, 1, 'setting_store', 'error_name', 'Store Name must be between 3 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3244, 1, 1, 'setting_store', 'error_url', 'Store URL required!', '[[regtime]]', '[[regtime]]'),
(3245, 1, 1, 'setting_store', 'error_title', 'Title must be between 3 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3246, 1, 1, 'setting_store', 'error_image_thumb', 'Product Image Thumb Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3247, 1, 1, 'setting_store', 'error_image_popup', 'Product Image Popup Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3248, 1, 1, 'setting_store', 'error_image_category', 'Category List Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3249, 1, 1, 'setting_store', 'error_image_product', 'Product List Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3250, 1, 1, 'setting_store', 'error_image_additional', 'Additional Product Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3251, 1, 1, 'setting_store', 'error_image_related', 'Related Product Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3252, 1, 1, 'setting_store', 'error_image_cart', 'Cart Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3253, 1, 1, 'setting_store', 'error_image_grid', 'Grid Image Size dimensions required!', '[[regtime]]', '[[regtime]]'),
(3254, 1, 1, 'setting_store', 'error_store', 'Warning: This Store cannot be deleted as it is currently assigned to %s orders!', '[[regtime]]', '[[regtime]]'),
(3255, 1, 1, 'setting_store', 'error_required_data', 'Required Data has not been entered. Check for field errors!', '[[regtime]]', '[[regtime]]'),
(3256, 1, 1, 'setting_store', 'error_limit', 'Limit required!', '[[regtime]]', '[[regtime]]'),
(3257, 1, 1, 'setting_store', 'entry_clone_store', ' Copy Settings:<br/><span class="help">You can select copy of all settings from some existing store</span> ', '[[regtime]]', '[[regtime]]'),
(3258, 1, 1, 'setting_store', 'entry_ssl_url', 'Secure Store URL:<br /><span class="help">Include the full SSL URL(HTTPS) to your store. Make sure to add ''/'' at the end. Example: https://www.yourdomain.com/path/</span>', '[[regtime]]', '[[regtime]]'),
(3259, 1, 1, 'setting_store', 'error_ssl_url', 'Secure URL required!', '[[regtime]]', '[[regtime]]'),
(3260, 1, 1, 'tool_backup', 'heading_title', 'Backup / Restore / Load', '[[regtime]]', '[[regtime]]'),
(3261, 1, 1, 'tool_backup', 'text_backup', 'Download Backup', '[[regtime]]', '[[regtime]]'),
(3262, 1, 1, 'tool_backup', 'text_success_backup', 'Success: You have successfully created backup file!', '[[regtime]]', '[[regtime]]'),
(3263, 1, 1, 'tool_backup', 'text_success', 'Success: You have successfully imported your database!', '[[regtime]]', '[[regtime]]'),
(3264, 1, 1, 'tool_backup', 'text_success_xml', 'Success: You have successfully imported your xml!', '[[regtime]]', '[[regtime]]'),
(3265, 1, 1, 'tool_backup', 'entry_restore', 'Restore from sql or xml file:', '[[regtime]]', '[[regtime]]'),
(3266, 1, 1, 'tool_backup', 'entry_tables', 'Backup Tables:', '[[regtime]]', '[[regtime]]'),
(3267, 1, 1, 'tool_backup', 'entry_loadxml', 'Load XML-file:', '[[regtime]]', '[[regtime]]'),
(3268, 1, 1, 'tool_backup', 'tab_backup', 'Backup', '[[regtime]]', '[[regtime]]'),
(3269, 1, 1, 'tool_backup', 'tab_restore', 'Restore', '[[regtime]]', '[[regtime]]'),
(3270, 1, 1, 'tool_backup', 'tab_loadxml', 'Layout and dataset load XML', '[[regtime]]', '[[regtime]]'),
(3271, 1, 1, 'tool_backup', 'error_permission', 'Warning: You do not have permission to modify backups!', '[[regtime]]', '[[regtime]]'),
(3272, 1, 1, 'tool_backup', 'error_nothing_to_do', 'Warning: Please set what you want to backup or import!', '[[regtime]]', '[[regtime]]'),
(3273, 1, 1, 'tool_backup', 'error_empty', 'Warning: The file you uploaded was empty or had wrong file type!', '[[regtime]]', '[[regtime]]'),
(3274, 1, 1, 'tool_backup', 'error_upload', 'Warning: The file was not uploaded. Check post_max_size or file_upload directives of your php.ini file. ', '[[regtime]]', '[[regtime]]'),
(3275, 1, 1, 'tool_backup', 'error_xml', 'Warning: The file you uploaded does not loaded as XML! Please, see log-file for details', '[[regtime]]', '[[regtime]]'),
(3276, 1, 1, 'tool_backup', 'entry_backup_code', 'Backup Code (%s)<br/><span class="help">Sub-directories with code files excluding dynamic files such as cache, log files, images, resources etc </span>', '[[regtime]]', '[[regtime]]'),
(3277, 1, 1, 'tool_backup', 'entry_backup_content', 'Backup Content (%s)<br/><span class="help">Sub-directories with dynamic files such as images, downloads, resources etc </span>', '[[regtime]]', '[[regtime]]'),
(3278, 1, 1, 'tool_backup', 'entry_compress_backup', 'Compress Backup Directory  %s ?<br/><span class="help">Archive *.tar.gz will be created.<br/> Note: it could to take a long time. Otherwise you can disable compression and find your backup in folder %s</span>', '[[regtime]]', '[[regtime]]'),
(3279, 1, 1, 'tool_backup', 'button_backup_now', 'Backup Now', '[[regtime]]', '[[regtime]]'),
(3280, 1, 1, 'tool_backup', 'button_load', 'Load', '[[regtime]]', '[[regtime]]'),
(3281, 1, 1, 'tool_backup', 'button_backup_schedule', 'Schedule Backup', '[[regtime]]', '[[regtime]]'),
(3282, 1, 1, 'tool_backup', 'text_success_scheduled', 'Success: You have successfully created scheduled backup task! <a href="%s">See details</a>', '[[regtime]]', '[[regtime]]'),
(3283, 1, 1, 'tool_backup', 'text_fail_note', 'NOTE: This process execution depends on your AbanteCart data size as well as your server virtual memory size. If process terminates with errors, check directory %s permissions to be set to -rw-rw-rw and <a href="http://php.net/manual/en/ini.core.php#ini.memory-limit" target="_blank">[PHP memory setting]</a>. Increase memory setting or run backup manually if process still fail.', '[[regtime]]', '[[regtime]]'),
(3284, 1, 1, 'tool_backup', 'backup_complete_text_file', 'To download backup-file please visit <a href="#admin#rt=tool/install_upgrade_history">Install/Upgrade History</a> ', '[[regtime]]', '[[regtime]]'),
(3285, 1, 1, 'tool_backup', 'backup_complete_text_dir', 'Directory with backup-files is %s</a> ', '[[regtime]]', '[[regtime]]'),
(3286, 1, 1, 'tool_cache', 'heading_title', 'Cache Management', '[[regtime]]', '[[regtime]]'),
(3287, 1, 1, 'tool_cache', 'text_success', 'Success: You have successfully deleted the cache files!', '[[regtime]]', '[[regtime]]'),
(3288, 1, 1, 'tool_cache', 'text_configuration', 'Configuration', '[[regtime]]', '[[regtime]]'),
(3289, 1, 1, 'tool_cache', 'text_layouts_blocks', 'Layouts &amp; Blocks', '[[regtime]]', '[[regtime]]'),
(3290, 1, 1, 'tool_cache', 'text_flexyforms', 'Flexy Forms', '[[regtime]]', '[[regtime]]'),
(3291, 1, 1, 'tool_cache', 'text_images', 'Images', '[[regtime]]', '[[regtime]]'),
(3292, 1, 1, 'tool_cache', 'text_products', 'Products', '[[regtime]]', '[[regtime]]'),
(3293, 1, 1, 'tool_cache', 'text_categories', 'Categories', '[[regtime]]', '[[regtime]]'),
(3294, 1, 1, 'tool_cache', 'text_manufacturers', 'Brands', '[[regtime]]', '[[regtime]]'),
(3295, 1, 1, 'tool_cache', 'text_localisations', 'Localisations', '[[regtime]]', '[[regtime]]'),
(3296, 1, 1, 'tool_cache', 'text_error_log', 'Error Log', '[[regtime]]', '[[regtime]]'),
(3297, 1, 1, 'tool_cache', 'text_clear_cache', 'Clear Selected Cache', '[[regtime]]', '[[regtime]]'),
(3298, 1, 1, 'tool_cache', 'text_clear_all_cache', 'Clear all data', '[[regtime]]', '[[regtime]]'),
(3299, 1, 1, 'tool_cache', 'desc_configuration', 'System and store configurations', '[[regtime]]', '[[regtime]]'),
(3300, 1, 1, 'tool_cache', 'desc_layouts_blocks', 'Pages, page layouts, blocks', '[[regtime]]', '[[regtime]]'),
(3301, 1, 1, 'tool_cache', 'desc_flexyforms', 'Flexy forms data', '[[regtime]]', '[[regtime]]'),
(3302, 1, 1, 'tool_cache', 'desc_images', 'Image thumbnails', '[[regtime]]', '[[regtime]]'),
(3303, 1, 1, 'tool_cache', 'desc_products', 'Product data', '[[regtime]]', '[[regtime]]'),
(3304, 1, 1, 'tool_cache', 'desc_categories', 'Category data', '[[regtime]]', '[[regtime]]'),
(3305, 1, 1, 'tool_cache', 'desc_manufacturers', 'Brand data', '[[regtime]]', '[[regtime]]'),
(3306, 1, 1, 'tool_cache', 'desc_localisations', 'Currency, Language, Country, Zone, Length, Weight, &amp; other', '[[regtime]]', '[[regtime]]'),
(3307, 1, 1, 'tool_cache', 'desc_error_log', 'Error Log', '[[regtime]]', '[[regtime]]'),
(3308, 1, 1, 'tool_cache', 'column_type', 'Cache Type', '[[regtime]]', '[[regtime]]'),
(3309, 1, 1, 'tool_cache', 'column_description', 'Description', '[[regtime]]', '[[regtime]]'),
(3310, 1, 1, 'tool_cache', 'text_install_upgrade_history', 'Install/Upgrade History', '[[regtime]]', '[[regtime]]'),
(3311, 1, 1, 'tool_cache', 'desc_install_upgrade_history', 'Clear All Install/Upgrade History', '[[regtime]]', '[[regtime]]'),
(3312, 1, 1, 'tool_cache', 'text_edits_history', 'Text Edits History', '[[regtime]]', '[[regtime]]'),
(3313, 1, 1, 'tool_cache', 'desc_edits_history', 'Clear All Text Edits History', '[[regtime]]', '[[regtime]]'),
(3314, 1, 1, 'tool_datasets_manager', 'heading_title', 'Datasets Manager', '[[regtime]]', '[[regtime]]'),
(3315, 1, 1, 'tool_datasets_manager', 'text_success', 'Success: You have modified message list!', '[[regtime]]', '[[regtime]]'),
(3316, 1, 1, 'tool_datasets_manager', 'column_id', ' Id ', '[[regtime]]', '[[regtime]]'),
(3317, 1, 1, 'tool_datasets_manager', 'column_name', ' Dataset Name ', '[[regtime]]', '[[regtime]]'),
(3318, 1, 1, 'tool_datasets_manager', 'column_key', ' Dataset Key', '[[regtime]]', '[[regtime]]'),
(3319, 1, 1, 'tool_datasets_manager', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(3320, 1, 1, 'tool_datasets_manager', 'text_dataset_name', ' Dataset Name', '[[regtime]]', '[[regtime]]'),
(3321, 1, 1, 'tool_datasets_manager', 'text_dataset_key', ' Dataset Key', '[[regtime]]', '[[regtime]]'),
(3322, 1, 1, 'tool_datasets_manager', 'text_dataset_properties', ' Dataset Properties', '[[regtime]]', '[[regtime]]'),
(3323, 1, 1, 'tool_datasets_manager', 'text_dataset_column_properties', ' Dataset Column Properties', '[[regtime]]', '[[regtime]]'),
(3324, 1, 1, 'tool_datasets_manager', 'text_dataset_column_definition', ' Dataset Columns', '[[regtime]]', '[[regtime]]'),
(3325, 1, 1, 'tool_datasets_manager', 'text_num_rows', ' Dataset Row Count', '[[regtime]]', '[[regtime]]'),
(3326, 1, 1, 'tool_datasets_manager', 'text_popup_title', ' Information About Dataset', '[[regtime]]', '[[regtime]]'),
(3327, 1, 1, 'tool_datasets_manager', 'text_confirm', 'Confirm?', '[[regtime]]', '[[regtime]]'),
(3328, 1, 1, 'tool_datasets_manager', 'text_date', 'Date', '[[regtime]]', '[[regtime]]'),
(3329, 1, 1, 'tool_datasets_manager', 'text_show', 'Show', '[[regtime]]', '[[regtime]]'),
(3330, 1, 1, 'tool_datasets_manager', 'text_repeats', 'Number of repetitions:', '[[regtime]]', '[[regtime]]'),
(3331, 1, 1, 'tool_error_log', 'heading_title', 'Error Log', '[[regtime]]', '[[regtime]]'),
(3332, 1, 1, 'tool_error_log', 'text_success', 'Success: You have successfully cleared your error log!', '[[regtime]]', '[[regtime]]'),
(3333, 1, 1, 'tool_error_log', 'text_file_tail', 'Due to large size of the log file, only last 500Kb of data can be viewed in here.<br>To view complete log, get it from your server directly.Path:       ', '[[regtime]]', '[[regtime]]'),
(3334, 1, 1, 'tool_error_log', 'text_file_error', ' File does not exists or not readable! ', '[[regtime]]', '[[regtime]]'),
(3335, 1, 1, 'tool_files', 'heading_title', 'File Uploads', '[[regtime]]', '[[regtime]]'),
(3336, 1, 1, 'tool_files', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(3337, 1, 1, 'tool_files', 'column_path', 'File', '[[regtime]]', '[[regtime]]'),
(3338, 1, 1, 'tool_files', 'column_section', 'Section', '[[regtime]]', '[[regtime]]'),
(3339, 1, 1, 'tool_files', 'text_download', 'to download file', '[[regtime]]', '[[regtime]]'),
(3340, 1, 1, 'tool_global_search', 'heading_title', 'Global Search Results', '[[regtime]]', '[[regtime]]'),
(3341, 1, 1, 'tool_global_search', 'no_results_message', 'Sorry, but we have no results.', '[[regtime]]', '[[regtime]]'),
(3342, 1, 1, 'tool_global_search', 'error_permission', 'Warning: You do not have permission to search!', '[[regtime]]', '[[regtime]]'),
(3343, 1, 1, 'tool_global_search', 'text_orders', 'Orders', '[[regtime]]', '[[regtime]]'),
(3344, 1, 1, 'tool_global_search', 'text_customers', 'Customers', '[[regtime]]', '[[regtime]]'),
(3345, 1, 1, 'tool_global_search', 'text_downloads', 'Downloads', '[[regtime]]', '[[regtime]]'),
(3346, 1, 1, 'tool_global_search', 'text_product_categories', 'Product Categories', '[[regtime]]', '[[regtime]]'),
(3347, 1, 1, 'tool_global_search', 'text_products', 'Products', '[[regtime]]', '[[regtime]]'),
(3348, 1, 1, 'tool_global_search', 'text_reviews', 'Reviews', '[[regtime]]', '[[regtime]]'),
(3349, 1, 1, 'tool_global_search', 'text_manufacturers', 'Brands', '[[regtime]]', '[[regtime]]'),
(3350, 1, 1, 'tool_global_search', 'text_languages', 'Languages', '[[regtime]]', '[[regtime]]'),
(3351, 1, 1, 'tool_global_search', 'text_pages', 'Pages', '[[regtime]]', '[[regtime]]'),
(3352, 1, 1, 'tool_global_search', 'text_settings', 'Settings', '[[regtime]]', '[[regtime]]'),
(3353, 1, 1, 'tool_global_search', 'text_messages', 'Messages', '[[regtime]]', '[[regtime]]'),
(3354, 1, 1, 'tool_global_search', 'text_extensions', 'Extensions', '[[regtime]]', '[[regtime]]'),
(3355, 1, 1, 'tool_global_search', 'text_commands', 'Quick Commands', '[[regtime]]', '[[regtime]]'),
(3356, 1, 1, 'tool_global_search', 'text_contents', 'Content Pages', '[[regtime]]', '[[regtime]]'),
(3357, 1, 1, 'tool_import_export', 'import_export_title', 'Import & Export', '[[regtime]]', '[[regtime]]'),
(3358, 1, 1, 'tool_import_export', 'import_wizard_title', 'Import Data Wizard', '[[regtime]]', '[[regtime]]'),
(3359, 1, 1, 'tool_import_export', 'tab_import', 'Import', '[[regtime]]', '[[regtime]]'),
(3360, 1, 1, 'tool_import_export', 'tab_import_wizard', 'Import Wizard', '[[regtime]]', '[[regtime]]'),
(3361, 1, 1, 'tool_import_export', 'tab_export', 'Export', '[[regtime]]', '[[regtime]]'),
(3362, 1, 1, 'tool_import_export', 'text_tables', 'Tables', '[[regtime]]', '[[regtime]]'),
(3363, 1, 1, 'tool_import_export', 'text_options', 'Options', '[[regtime]]', '[[regtime]]'),
(3364, 1, 1, 'tool_import_export', 'text_file_format', 'File Format: ', '[[regtime]]', '[[regtime]]'),
(3365, 1, 1, 'tool_import_export', 'text_file_name', 'File Name: ', '[[regtime]]', '[[regtime]]'),
(3366, 1, 1, 'tool_import_export', 'text_load_file', 'Upload Import File', '[[regtime]]', '[[regtime]]'),
(3367, 1, 1, 'tool_import_export', 'text_load_file_notes', 'You can upload CSV or Text file to import data. For data structure, you can follow proprietary format (see export) or free format. <br/> For data with the free format, you will need to map data elements manually or use JSON map. <br/>Only product, categories and brands/manufacturers supported for free format import. <br/>Action column can be included to instruct import to ''insert'', ''update'' or ''delete''. Default action is update_or_insert. ', '[[regtime]]', '[[regtime]]'),
(3368, 1, 1, 'tool_import_export', 'text_import_wizard_notes', 'Select a destination table and corresponding database field to each provided import data column. If no field is selected, input column data will be ignored. <br/> <b>Note:</b> Language and store specific data values will be assigned to current content store & language selected', '[[regtime]]', '[[regtime]]'),
(3369, 1, 1, 'tool_import_export', 'text_records_to_be_loaded', 'There will be %s records loaded and processed in this import!', '[[regtime]]', '[[regtime]]'),
(3370, 1, 1, 'tool_import_export', 'text_import_task_title', 'Running Import Process', '[[regtime]]', '[[regtime]]'),
(3371, 1, 1, 'tool_import_export', 'text_load', 'Load', '[[regtime]]', '[[regtime]]'),
(3372, 1, 1, 'tool_import_export', 'text_import_loaded', 'Total loaded: ', '[[regtime]]', '[[regtime]]'),
(3373, 1, 1, 'tool_import_export', 'text_file_field', 'File to import:<br><span class="help">Supported formats for import files: CSV, TXT</span>', '[[regtime]]', '[[regtime]]'),
(3374, 1, 1, 'tool_import_export', 'text_id_range_from', 'ID range from: ', '[[regtime]]', '[[regtime]]'),
(3375, 1, 1, 'tool_import_export', 'text_to', 'to: ', '[[regtime]]', '[[regtime]]'),
(3376, 1, 1, 'tool_import_export', 'text_csv_delimiter', 'CSV/TXT delimiter: ', '[[regtime]]', '[[regtime]]'),
(3377, 1, 1, 'tool_import_export', 'text_export_note_csv_delimiter', '<span class="help">All fields will be enclosed in double quotes.</span>', '[[regtime]]', '[[regtime]]'),
(3378, 1, 1, 'tool_import_export', 'text_import_note_csv_delimiter', '<span class="help">All fields must be enclosed in double quotes.</span>', '[[regtime]]', '[[regtime]]'),
(3379, 1, 1, 'tool_import_export', 'text_test_mode', 'Run in a test mode <br><span class="help">It is recommended to run data import in a test mode first to see if any issues are present.</span>', '[[regtime]]', '[[regtime]]'),
(3380, 1, 1, 'tool_import_export', 'text_import_file_col', 'Import File Column', '[[regtime]]', '[[regtime]]'),
(3381, 1, 1, 'tool_import_export', 'text_import_file_data', 'Import Data Sample', '[[regtime]]', '[[regtime]]'),
(3382, 1, 1, 'tool_import_export', 'text_destination_col', 'Select destination table', '[[regtime]]', '[[regtime]]'),
(3383, 1, 1, 'tool_import_export', 'text_import_update_on', 'Update if exists', '[[regtime]]', '[[regtime]]'),
(3384, 1, 1, 'tool_import_export', 'text_import_split', 'Split data by', '[[regtime]]', '[[regtime]]'),
(3385, 1, 1, 'tool_import_export', 'title_export_map', 'Select, copy and save this mapping for future use.', '[[regtime]]', '[[regtime]]'),
(3386, 1, 1, 'tool_import_export', 'text_export_map', 'Export mapping', '[[regtime]]', '[[regtime]]'),
(3387, 1, 1, 'tool_import_export', 'title_load_map', 'Post to the field below pre-saved mapping data', '[[regtime]]', '[[regtime]]'),
(3388, 1, 1, 'tool_import_export', 'text_load_map', 'Load mapping', '[[regtime]]', '[[regtime]]'),
(3389, 1, 1, 'tool_import_export', 'error_file_format', 'Unsupported import file format!', '[[regtime]]', '[[regtime]]'),
(3390, 1, 1, 'tool_import_export', 'error_xml_import', 'Error during import XML file!', '[[regtime]]', '[[regtime]]'),
(3391, 1, 1, 'tool_import_export', 'error_csv_import', 'Error during import CSV/TXT file! Please check fields delimiter.', '[[regtime]]', '[[regtime]]'),
(3392, 1, 1, 'tool_import_export', 'error_data_corrupted', 'Data is empty or corrupted.', '[[regtime]]', '[[regtime]]'),
(3393, 1, 1, 'tool_import_export', 'error_file_empty', 'File is empty.', '[[regtime]]', '[[regtime]]'),
(3394, 1, 1, 'tool_import_export', 'error_writable_backup', 'Backup directory needs to be writable for CSV/TXT export to work.', '[[regtime]]', '[[regtime]]'),
(3395, 1, 1, 'tool_import_export', 'text_updated', 'Updated: ', '[[regtime]]', '[[regtime]]'),
(3396, 1, 1, 'tool_import_export', 'text_created', 'Created: ', '[[regtime]]', '[[regtime]]'),
(3397, 1, 1, 'tool_import_export', 'text_errors', 'Errors: ', '[[regtime]]', '[[regtime]]'),
(3398, 1, 1, 'tool_import_export', 'text_show_details', 'Show details', '[[regtime]]', '[[regtime]]'),
(3399, 1, 1, 'tool_import_export', 'text_no_children', 'No child items', '[[regtime]]', '[[regtime]]'),
(3400, 1, 1, 'tool_import_export', 'text_some_errors', 'There are some errors.', '[[regtime]]', '[[regtime]]'),
(3401, 1, 1, 'tool_import_export', 'text_test_completed', 'Test run completed. Total SQL queries: ', '[[regtime]]', '[[regtime]]'),
(3402, 1, 1, 'tool_import_export', 'text_sort_by', 'Sort by: ', '[[regtime]]', '[[regtime]]'),
(3403, 1, 1, 'tool_import_export', 'error_table_selection', 'No import destination table or fields selected!', '[[regtime]]', '[[regtime]]'),
(3404, 1, 1, 'tool_import_export', 'error_required_selection', 'Missing required data field ''%s'' for destination table!', '[[regtime]]', '[[regtime]]'),
(3405, 1, 1, 'tool_import_export', 'error_tmp_dir_non_writable', 'Temporary Directory %s is not writable! Please change permissions to proceed.', '[[regtime]]', '[[regtime]]'),
(3406, 1, 1, 'tool_import_export', 'error_empty_request', 'Empty request.', '[[regtime]]', '[[regtime]]'),
(3407, 1, 1, 'tool_import_export', 'text_complete_import', 'Import Process has been completed. %s row(s) processed.', '[[regtime]]', '[[regtime]]'),
(3408, 1, 1, 'tool_import_export', 'text_complete_import_with_errors', '%s row(s) with errors.', '[[regtime]]', '[[regtime]]'),
(3409, 1, 1, 'tool_import_export', 'text_see_log', 'For more details see <a href="%s" target="_new">log file %s</a>', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(3410, 1, 1, 'tool_import_export', 'text_success_abort', 'Task interrupted successfully.', '[[regtime]]', '[[regtime]]'),
(3411, 1, 1, 'tool_import_export', 'button_schedule_import', 'Schedule Import', '[[regtime]]', '[[regtime]]'),
(3412, 1, 1, 'tool_import_export', 'text_success_scheduled', 'Success: You have successfully created scheduled import task! <a href="%s">See details</a>', '[[regtime]]', '[[regtime]]'),
(3413, 1, 1, 'tool_install_upgrade_history', 'heading_title', 'install/Upgrade History', '[[regtime]]', '[[regtime]]'),
(3414, 1, 1, 'tool_install_upgrade_history', 'column_type', ' Type', '[[regtime]]', '[[regtime]]'),
(3415, 1, 1, 'tool_install_upgrade_history', 'column_date_added', ' Date Added', '[[regtime]]', '[[regtime]]'),
(3416, 1, 1, 'tool_install_upgrade_history', 'column_name', ' Package Key ', '[[regtime]]', '[[regtime]]'),
(3417, 1, 1, 'tool_install_upgrade_history', 'column_version', ' Version ', '[[regtime]]', '[[regtime]]'),
(3418, 1, 1, 'tool_install_upgrade_history', 'column_backup_date', ' Backup Date', '[[regtime]]', '[[regtime]]'),
(3419, 1, 1, 'tool_install_upgrade_history', 'column_backup_file', ' Backup File ', '[[regtime]]', '[[regtime]]'),
(3420, 1, 1, 'tool_install_upgrade_history', 'column_user', ' User Name', '[[regtime]]', '[[regtime]]'),
(3421, 1, 1, 'tool_install_upgrade_history', 'text_download', ' to download file', '[[regtime]]', '[[regtime]]'),
(3422, 1, 1, 'tool_install_upgrade_history', 'text_delete_history', ' Delete History', '[[regtime]]', '[[regtime]]'),
(3423, 1, 1, 'tool_install_upgrade_history', 'text_delete_success', ' Your Install/Upgrade History has been deleted successfully.', '[[regtime]]', '[[regtime]]'),
(3424, 1, 1, 'tool_message_manager', 'heading_title', 'Message Manager', '[[regtime]]', '[[regtime]]'),
(3425, 1, 1, 'tool_message_manager', 'text_success', 'Success: You have modified message list!', '[[regtime]]', '[[regtime]]'),
(3426, 1, 1, 'tool_message_manager', 'column_title', 'Message Title', '[[regtime]]', '[[regtime]]'),
(3427, 1, 1, 'tool_message_manager', 'column_create_date', 'Date', '[[regtime]]', '[[regtime]]'),
(3428, 1, 1, 'tool_message_manager', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(3429, 1, 1, 'tool_message_manager', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(3430, 1, 1, 'tool_message_manager', 'entry_error', 'Critical', '[[regtime]]', '[[regtime]]'),
(3431, 1, 1, 'tool_message_manager', 'entry_warning', 'Warning', '[[regtime]]', '[[regtime]]'),
(3432, 1, 1, 'tool_message_manager', 'entry_notice', 'Notice', '[[regtime]]', '[[regtime]]'),
(3433, 1, 1, 'tool_message_manager', 'error_permission', 'Warning: You do not have permission to modify message list!', '[[regtime]]', '[[regtime]]'),
(3434, 1, 1, 'tool_message_manager', 'error_name', 'Message title must be between 3 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3435, 1, 1, 'tool_message_manager', 'text_show', 'Show', '[[regtime]]', '[[regtime]]'),
(3436, 1, 1, 'tool_message_manager', 'text_not_found', 'Ooops. We can''t find this message.', '[[regtime]]', '[[regtime]]'),
(3437, 1, 1, 'tool_message_manager', 'text_status', 'Message status: ', '[[regtime]]', '[[regtime]]'),
(3438, 1, 1, 'tool_message_manager', 'text_date', 'Date:', '[[regtime]]', '[[regtime]]'),
(3439, 1, 1, 'tool_message_manager', 'text_repeats', 'Number of repetitions:', '[[regtime]]', '[[regtime]]'),
(3440, 1, 1, 'tool_message_manager', 'text_warning', 'warning', '[[regtime]]', '[[regtime]]'),
(3441, 1, 1, 'tool_message_manager', 'text_error', 'critical', '[[regtime]]', '[[regtime]]'),
(3442, 1, 1, 'tool_message_manager', 'text_notice', 'notice', '[[regtime]]', '[[regtime]]'),
(3443, 1, 1, 'tool_message_manager', 'text_delete', 'delete', '[[regtime]]', '[[regtime]]'),
(3444, 1, 1, 'tool_message_manager', 'text_close', 'close', '[[regtime]]', '[[regtime]]'),
(3445, 1, 1, 'tool_message_manager', 'text_confirm', 'Confirm?', '[[regtime]]', '[[regtime]]'),
(3446, 1, 1, 'tool_message_manager', 'text_linktext', ' this link', '[[regtime]]', '[[regtime]]'),
(3447, 1, 1, 'tool_message_manager', 'text_notifier_title', ' You Have %s New Message(s)', '[[regtime]]', '[[regtime]]'),
(3448, 1, 1, 'tool_migration', 'heading_title', 'Cart Migration', '[[regtime]]', '[[regtime]]'),
(3449, 1, 1, 'tool_migration', 'heading_title_step_one', ' - Step 1', '[[regtime]]', '[[regtime]]'),
(3450, 1, 1, 'tool_migration', 'heading_title_step_two', ' - Step 2', '[[regtime]]', '[[regtime]]'),
(3451, 1, 1, 'tool_migration', 'heading_title_step_three', ' - Finish', '[[regtime]]', '[[regtime]]'),
(3452, 1, 1, 'tool_migration', 'text_description', '            Migration tool allow you import data from another carts.<br>Note: AbanteCart support import for mysql only for now.<br> Press start migration button to continue... ', '[[regtime]]', '[[regtime]]'),
(3453, 1, 1, 'tool_migration', 'text_success', 'Success: You data successfully transfeerd to Abantecart!', '[[regtime]]', '[[regtime]]'),
(3454, 1, 1, 'tool_migration', 'text_cart_info', '            Source Cart Info<span class="help">Source shopping cart application details.</span>', '[[regtime]]', '[[regtime]]'),
(3455, 1, 1, 'tool_migration', 'text_db_info', '            Database Info<span class="help">Note: AbanteCart support import for mysql only for now.</span>', '[[regtime]]', '[[regtime]]'),
(3456, 1, 1, 'tool_migration', 'entry_cart_type', 'Source cart type:', '[[regtime]]', '[[regtime]]'),
(3457, 1, 1, 'tool_migration', 'entry_cart_url', 'Source cart URL:', '[[regtime]]', '[[regtime]]'),
(3458, 1, 1, 'tool_migration', 'entry_db_host', 'Database Host:', '[[regtime]]', '[[regtime]]'),
(3459, 1, 1, 'tool_migration', 'entry_db_user', 'Database User:', '[[regtime]]', '[[regtime]]'),
(3460, 1, 1, 'tool_migration', 'entry_db_password', 'Password:', '[[regtime]]', '[[regtime]]'),
(3461, 1, 1, 'tool_migration', 'entry_db_name', 'Database Name:', '[[regtime]]', '[[regtime]]'),
(3462, 1, 1, 'tool_migration', 'entry_db_prefix', 'Database Prefix:', '[[regtime]]', '[[regtime]]'),
(3463, 1, 1, 'tool_migration', 'entry_cart_select', ' - select cart type - ', '[[regtime]]', '[[regtime]]'),
(3464, 1, 1, 'tool_migration', 'entry_cart_osc', 'Oscommerce 2.2RC2', '[[regtime]]', '[[regtime]]'),
(3465, 1, 1, 'tool_migration', 'entry_cart_oscmax', 'OscMAX', '[[regtime]]', '[[regtime]]'),
(3466, 1, 1, 'tool_migration', 'entry_cart_zen', 'ZenCart 1.3.9h', '[[regtime]]', '[[regtime]]'),
(3467, 1, 1, 'tool_migration', 'entry_cart_cre', 'CRE Loaded 6.4.1 STD', '[[regtime]]', '[[regtime]]'),
(3468, 1, 1, 'tool_migration', 'entry_cart_opencart', 'OpenCart 1.4.9', '[[regtime]]', '[[regtime]]'),
(3469, 1, 1, 'tool_migration', 'entry_migrate_data', 'Select data to migrate', '[[regtime]]', '[[regtime]]'),
(3470, 1, 1, 'tool_migration', 'entry_migrate_data_categories', 'Categories', '[[regtime]]', '[[regtime]]'),
(3471, 1, 1, 'tool_migration', 'entry_migrate_data_products', 'Products, Categories, Brands', '[[regtime]]', '[[regtime]]'),
(3472, 1, 1, 'tool_migration', 'entry_migrate_data_customers', 'Customers', '[[regtime]]', '[[regtime]]'),
(3473, 1, 1, 'tool_migration', 'entry_migrate_data_orders', 'Orders', '[[regtime]]', '[[regtime]]'),
(3474, 1, 1, 'tool_migration', 'entry_erase_existing_data', 'Erase existing data?', '[[regtime]]', '[[regtime]]'),
(3475, 1, 1, 'tool_migration', 'button_start_migration', 'Start Migration', '[[regtime]]', '[[regtime]]'),
(3476, 1, 1, 'tool_migration', 'button_continue', 'Continue', '[[regtime]]', '[[regtime]]'),
(3477, 1, 1, 'tool_migration', 'button_back', 'Back', '[[regtime]]', '[[regtime]]'),
(3478, 1, 1, 'tool_migration', 'button_cancel', 'Cancel', '[[regtime]]', '[[regtime]]'),
(3479, 1, 1, 'tool_migration', 'error_permission', 'Warning: You do not have permission to perform migration!', '[[regtime]]', '[[regtime]]'),
(3480, 1, 1, 'tool_migration', 'error_db_host', 'Host required!', '[[regtime]]', '[[regtime]]'),
(3481, 1, 1, 'tool_migration', 'error_db_user', 'User required!', '[[regtime]]', '[[regtime]]'),
(3482, 1, 1, 'tool_migration', 'error_db_name', 'Database Name required!', '[[regtime]]', '[[regtime]]'),
(3483, 1, 1, 'tool_migration', 'error_db_connection', '            Error: Could not connect to the database please make sure the database server, username and password is correct!', '[[regtime]]', '[[regtime]]'),
(3484, 1, 1, 'tool_migration', 'error_db_not_exist', 'Error: Database does not exist!', '[[regtime]]', '[[regtime]]'),
(3485, 1, 1, 'tool_migration', 'error_cart_type', 'Error: Please select cart type!', '[[regtime]]', '[[regtime]]'),
(3486, 1, 1, 'tool_migration', 'error_cart_url', 'Error: Cart URL required!', '[[regtime]]', '[[regtime]]'),
(3487, 1, 1, 'tool_migration', 'error_cart_not_supported', 'Warning: Chosen cart not supported now!', '[[regtime]]', '[[regtime]]'),
(3488, 1, 1, 'tool_migration', 'error_migrate_data', 'Error: Please select at least one item!', '[[regtime]]', '[[regtime]]'),
(3489, 1, 1, 'tool_migration', 'text_no_customers', 'Note: No one customer was imported.', '[[regtime]]', '[[regtime]]'),
(3490, 1, 1, 'tool_migration', 'text_no_products', 'Note: No one product was imported.', '[[regtime]]', '[[regtime]]'),
(3491, 1, 1, 'tool_migration', 'text_no_orders', 'Note: No one order was imported.', '[[regtime]]', '[[regtime]]'),
(3492, 1, 1, 'tool_migration', 'text_no_brands', 'Note: No one brand was imported.', '[[regtime]]', '[[regtime]]'),
(3493, 1, 1, 'tool_migration', 'text_no_categories', 'Note: No one product category was imported.', '[[regtime]]', '[[regtime]]'),
(3494, 1, 1, 'tool_migration', 'error_empty_source_cart', 'Warning: Chosen source cart is empty! Please check database and table prefix.', '[[regtime]]', '[[regtime]]'),
(3495, 1, 1, 'tool_migration', 'text_finished', 'Migration has finished.', '[[regtime]]', '[[regtime]]'),
(3496, 1, 1, 'tool_package_installer', 'text_success', ' Success: Package was installed successfully. ', '[[regtime]]', '[[regtime]]'),
(3497, 1, 1, 'tool_package_installer', 'heading_title', 'Package Installer', '[[regtime]]', '[[regtime]]'),
(3498, 1, 1, 'tool_package_installer', 'heading_title_license', 'Package License Agreement', '[[regtime]]', '[[regtime]]'),
(3499, 1, 1, 'tool_package_installer', 'heading_title_ftp', 'FTP access parameters', '[[regtime]]', '[[regtime]]'),
(3500, 1, 1, 'tool_package_installer', 'heading_title_download', 'Package Loading', '[[regtime]]', '[[regtime]]'),
(3501, 1, 1, 'tool_package_installer', 'text_preloading', ' Package file %file% will be downloaded.', '[[regtime]]', '[[regtime]]'),
(3502, 1, 1, 'tool_package_installer', 'text_loading', 'Downloading file. Size: %s .<br/>It might take few seconds depending on your connection.', '[[regtime]]', '[[regtime]]'),
(3503, 1, 1, 'tool_package_installer', 'text_key_hint', 'Enter Installation Key Here', '[[regtime]]', '[[regtime]]'),
(3504, 1, 1, 'tool_package_installer', 'text_ftp_user', ' FTP User Name: ', '[[regtime]]', '[[regtime]]'),
(3505, 1, 1, 'tool_package_installer', 'text_ftp_password', ' FTP User Password: ', '[[regtime]]', '[[regtime]]'),
(3506, 1, 1, 'tool_package_installer', 'text_ftp_host', ' FTP Host:', '[[regtime]]', '[[regtime]]'),
(3507, 1, 1, 'tool_package_installer', 'text_i_agree', ' I agree to the license ', '[[regtime]]', '[[regtime]]'),
(3508, 1, 1, 'tool_package_installer', 'text_agree', ' Agree ', '[[regtime]]', '[[regtime]]'),
(3509, 1, 1, 'tool_package_installer', 'text_retry', ' Retry ', '[[regtime]]', '[[regtime]]'),
(3510, 1, 1, 'tool_package_installer', 'text_disagree', ' Disagree ', '[[regtime]]', '[[regtime]]'),
(3511, 1, 1, 'tool_package_installer', 'text_download_error', ' We are sorry, but error occurred while uploading the file.</br>Try one more time.</br>If problem persist download file in your order history and install manually. ', '[[regtime]]', '[[regtime]]'),
(3512, 1, 1, 'tool_package_installer', 'text_continue', ' Continue ', '[[regtime]]', '[[regtime]]'),
(3513, 1, 1, 'tool_package_installer', 'text_disclaimer_heading', ' Disclaimer ', '[[regtime]]', '[[regtime]]'),
(3514, 1, 1, 'tool_package_installer', 'text_disclaimer', ' <h3>Dear AbanteCart customer,</h3><br>\nYou are about to install third party extension to your AbanteCart.<br><br>\nPlease read and understand this disclaimer about third party extension that you about to install.<br><br>\nThird party extensions and services  are provided by third party vendors.<br><br>\nAlthough, AbanteCart validate quality of extensions and services provided by third party, AbanterCart does not guaranty that all third party extension work correctly or will not cause any conflicts in the system.\nAbanteCart members and affiliates are in no way liable or responsible for claims made related to the products or services provided by third party vendors. AbanteCart does not guarantee the quality of third party extensions or services.  Please direct your inquiries regarding third party extensions or services to the appropriate third party vendor.\nIf you have concern about any third party provider please contact AbanteCart at <a href="http://www.abantecart.com/contact-us" target="_blank">http://www.abantecart.com/contact-us</a><br><br>\nSincerely,<br>\nAbanteCart<br>\nIdeal OpenSource Ecommerce Solution ', '[[regtime]]', '[[regtime]]'),
(3515, 1, 1, 'tool_package_installer', 'warning_ftp', ' Warning: Some directory or file does not have write permission (<span id="see_details">see more details</span>)<br>You can change permissions on your server or<br>use ftp access to your server for installation (usually, hosting provider sends this info via email or you can manage it in hosting control tools)<br> ', '[[regtime]]', '[[regtime]]'),
(3516, 1, 1, 'tool_package_installer', 'warning_already_installed', '<p class="success">You already have %EXTENSION% extension installed! If you want to proceed and upgrade, please confirm.</p>', '[[regtime]]', '[[regtime]]'),
(3517, 1, 1, 'tool_package_installer', 'warning_already_installed_uninstall', 'You already have this extension "%EXTENSION%" installed! If you want to proceed to reinstall, please uninstall and delete extension first.', '[[regtime]]', '[[regtime]]'),
(3518, 1, 1, 'tool_package_installer', 'error_pack_file_not_found', 'Error: Can not extract extension from the archive to %s. Check <a href="#admin#rt=tool/error_log" target="_blank">log</a> for errors ', '[[regtime]]', '[[regtime]]'),
(3519, 1, 1, 'tool_package_installer', 'error_mp', ' Marketplace error: ', '[[regtime]]', '[[regtime]]'),
(3520, 1, 1, 'tool_package_installer', 'error_repository', ' Error: Cannot download file. Repository error or invalid extension key. Try one more time. If problem persist download file in your order history and install manually. ', '[[regtime]]', '[[regtime]]'),
(3521, 1, 1, 'tool_package_installer', 'error_ftp_user', ' Error: FTP User Name is empty. ', '[[regtime]]', '[[regtime]]'),
(3522, 1, 1, 'tool_package_installer', 'error_ftp_password', ' Error: FTP User Password is empty. ', '[[regtime]]', '[[regtime]]'),
(3523, 1, 1, 'tool_package_installer', 'error_ftp_connect', ' Error: Can''t connect to ftp-server ', '[[regtime]]', '[[regtime]]'),
(3524, 1, 1, 'tool_package_installer', 'error_ftp_login', ' Error: Can''t login to ftp-server. Invalid Username or Password. ', '[[regtime]]', '[[regtime]]'),
(3525, 1, 1, 'tool_package_installer', 'error_ftp_path', ' Error: Can''t find root directory of AbanteCart by FTP path.<br>Try leave it empty for automatic search. ', '[[regtime]]', '[[regtime]]'),
(3526, 1, 1, 'tool_package_installer', 'error_ftp_path_array', ' Error: Can''t automatic recognize root directory of AbanteCart in FTP-mode.<br>Please fill FTP-path form field.<br>Path suggestions are:  ', '[[regtime]]', '[[regtime]]'),
(3527, 1, 1, 'tool_package_installer', 'error_dir_permission', ' Can''t to save file because directory is not writable: ', '[[regtime]]', '[[regtime]]'),
(3528, 1, 1, 'tool_package_installer', 'error_package_structure', ' Error: Probably package is broken. Structure of package error. ', '[[regtime]]', '[[regtime]]'),
(3529, 1, 1, 'tool_package_installer', 'error_package_config_xml', ' Error: Cannot locate file package.xml inside of extracted extension. Possibly extension was not extracted correctly. Check <a href="#admin#rt=tool/error_log" target="_blank">log</a> for errors ', '[[regtime]]', '[[regtime]]'),
(3530, 1, 1, 'tool_package_installer', 'error_package_config2', ' Error: Can''t find installation mode in package.xml inside package. ', '[[regtime]]', '[[regtime]]'),
(3531, 1, 1, 'tool_package_installer', 'error_package_info_not_exists', ' Error: Can''t find package session info about this download. ', '[[regtime]]', '[[regtime]]'),
(3532, 1, 1, 'tool_package_installer', 'error_unpack', ' Error: Can''t unpack package "%PACKAGE%" after download. Archive error. See error log for details. ', '[[regtime]]', '[[regtime]]'),
(3533, 1, 1, 'tool_package_installer', 'error_move', ' Error: Can''t move package code after unpacking. Please try check write permissions of directory: ', '[[regtime]]', '[[regtime]]'),
(3534, 1, 1, 'tool_package_installer', 'error_install_mode', ' Error: Can''t install extension "%package%" because it already installed. You need deinstall and delete it first or get package for upgrade. ', '[[regtime]]', '[[regtime]]'),
(3535, 1, 1, 'tool_package_installer', 'error_install_mode2', ' Error: Can''t upgrade extension "%package%" because it not installed. You need get package for install. ', '[[regtime]]', '[[regtime]]'),
(3536, 1, 1, 'tool_package_installer', 'error_version_compatibility', ' Error: Can''t install package. Your cart version is <b>%CURRENT_VERSION%</b>. Version(s) <b>%VERSIONS%</b>  required. ', '[[regtime]]', '[[regtime]]'),
(3537, 1, 1, 'tool_package_installer', 'error_package_version_compatibility', ' Error: Can''t upgrade package. Newer package version is already installed. ', '[[regtime]]', '[[regtime]]'),
(3538, 1, 1, 'tool_package_installer', 'error_install', ' Error: Can''t install package. Please see System -> Error Log for details. ', '[[regtime]]', '[[regtime]]'),
(3539, 1, 1, 'tool_package_installer', 'error_core_version', ' Error: You have AbanteCart version %VERSION% installed.<br>This upgrade package only for versions lower than  ', '[[regtime]]', '[[regtime]]'),
(3540, 1, 1, 'tool_package_installer', 'text_interrupt', ' Interrupt ', '[[regtime]]', '[[regtime]]'),
(3541, 1, 1, 'tool_package_installer', 'confirm_version_incompatibility', ' Current copy of this extension is not verified for your version of AbanteCart (v%s).<br>Extension build is specified for AbanteCart v%s.<br>\n		This is not a problem, but if you notice issues or incompatibility, please contact extension developer. ', '[[regtime]]', '[[regtime]]'),
(3542, 1, 1, 'tool_package_installer', 'error_move_ftp', ' Error: Can''t move package code after unpacking. Probably FTP path is incorrect.<br>Also, please, try to check write permissions of directory: ', '[[regtime]]', '[[regtime]]'),
(3543, 1, 1, 'tool_package_installer', 'text_network_install', ' Network Install ', '[[regtime]]', '[[regtime]]'),
(3544, 1, 1, 'tool_package_installer', 'text_extension_upload', ' Extension Upload ', '[[regtime]]', '[[regtime]]'),
(3545, 1, 1, 'tool_package_installer', 'error_archive_extension', ' Error: Only .tar.gz files supported. ', '[[regtime]]', '[[regtime]]'),
(3546, 1, 1, 'tool_package_installer', 'entry_upload_file', ' Upload file: ', '[[regtime]]', '[[regtime]]'),
(3547, 1, 1, 'tool_package_installer', 'entry_upload_url', ' Insert URL: ', '[[regtime]]', '[[regtime]]'),
(3548, 1, 1, 'tool_package_installer', 'error_move_backup', ' Error: Can''t backup files before upgrade. Check write permissions of directory: ', '[[regtime]]', '[[regtime]]'),
(3549, 1, 1, 'tool_package_installer', 'text_core_upgrade_title', ' Abantecart Core Upgrade ', '[[regtime]]', '[[regtime]]'),
(3550, 1, 1, 'tool_package_installer', 'text_core_upgrade_attention', ' Attention!\nAbanteCart is about to be upgraded to version %s!\n ', '[[regtime]]', '[[regtime]]'),
(3551, 1, 1, 'tool_package_installer', 'text_core_upgrade_warning', ' There is no undo after starting upgrade process.\nComplete database and code backup is highly recommended.\nTest upgrade on non-live sites first. Upgrade on live sites should be done only after testing. ', '[[regtime]]', '[[regtime]]'),
(3552, 1, 1, 'tool_package_installer', 'text_upgrade_now', ' Upgrade Now! ', '[[regtime]]', '[[regtime]]'),
(3553, 1, 1, 'tool_package_installer', 'error_additional_help_text', ' Stuck? Not a problem. You can install extensions another way. Check <a href="http://docs.abantecart.com/pages/extensions/install.html#FTPinstall" target="_blank">this help link</a> ', '[[regtime]]', '[[regtime]]'),
(3554, 1, 1, 'tool_package_installer', 'error_notconnected', ' Can not upgrade or install extensions from the marketplace. This store is not authenticated/connected. Please authenticate and connect to the <a href="%s">marketplace</a> ', '[[regtime]]', '[[regtime]]'),
(3555, 1, 1, 'tool_rl_manager', 'heading_title', 'Media Resource Library Manager', '[[regtime]]', '[[regtime]]'),
(3556, 1, 1, 'tool_rl_manager', 'text_rl_latest', 'Latest added resources', '[[regtime]]', '[[regtime]]'),
(3557, 1, 1, 'tool_rl_manager', 'text_rl_type', 'resource type', '[[regtime]]', '[[regtime]]'),
(3558, 1, 1, 'tool_rl_manager', 'entry_type_name', 'Resource Type Key<br/><span class="help">This resource type key/name value can not be changed</span>', '[[regtime]]', '[[regtime]]'),
(3559, 1, 1, 'tool_rl_manager', 'entry_default_directory', 'Resource directory<br/><span class="help">Directory locating resource for this type. If changed, existing resources will not be accessible and will need to be copied to new directory!</span>', '[[regtime]]', '[[regtime]]'),
(3560, 1, 1, 'tool_rl_manager', 'entry_default_icon', 'Default icon<br/><span class="help">Icon image to be shown in the listing of resources (Location: /image/... ).</span>', '[[regtime]]', '[[regtime]]'),
(3561, 1, 1, 'tool_rl_manager', 'entry_file_types', 'Allowed file extensions<br/><span class="help">Regex with a list of allowed file extensions for this resource type</span>', '[[regtime]]', '[[regtime]]'),
(3562, 1, 1, 'tool_rl_manager', 'text_success', 'Success: You have updated resource type!', '[[regtime]]', '[[regtime]]'),
(3563, 1, 1, 'tool_rl_manager', 'error_missing_type_id', 'Error: Missing resource type ID!', '[[regtime]]', '[[regtime]]'),
(3564, 1, 1, 'tool_rl_manager', 'error_type_name', 'Error: Resource type name needs to be between 2 and 40 characters', '[[regtime]]', '[[regtime]]'),
(3565, 1, 1, 'tool_rl_manager', 'error_default_directory', 'Error: Resource type directory needs to be between 2 and 64 characters', '[[regtime]]', '[[regtime]]'),
(3566, 1, 1, 'tool_rl_manager', 'error_default_icon', 'Error: Resource type icon needs to be between 2 and 64 characters', '[[regtime]]', '[[regtime]]'),
(3567, 1, 1, 'tool_rl_manager', 'error_file_types', 'Error: Resource type file extensions regex needs to be between 2 and 40 characters', '[[regtime]]', '[[regtime]]'),
(3568, 1, 1, 'tool_task', 'heading_title', 'Scheduled Tasks', '[[regtime]]', '[[regtime]]'),
(3569, 1, 1, 'tool_task', 'column_id', ' Id', '[[regtime]]', '[[regtime]]'),
(3570, 1, 1, 'tool_task', 'column_date_created', ' Date Created', '[[regtime]]', '[[regtime]]'),
(3571, 1, 1, 'tool_task', 'column_name', ' Name ', '[[regtime]]', '[[regtime]]'),
(3572, 1, 1, 'tool_task', 'column_status', ' Status ', '[[regtime]]', '[[regtime]]'),
(3573, 1, 1, 'tool_task', 'column_start_time', ' Start Time', '[[regtime]]', '[[regtime]]'),
(3574, 1, 1, 'tool_task', 'text_stuck', ' Stuck', '[[regtime]]', '[[regtime]]'),
(3575, 1, 1, 'tool_task', 'text_ready', ' Ready', '[[regtime]]', '[[regtime]]'),
(3576, 1, 1, 'tool_task', 'text_running', ' Running', '[[regtime]]', '[[regtime]]'),
(3577, 1, 1, 'tool_task', 'text_scheduled', ' Scheduled', '[[regtime]]', '[[regtime]]'),
(3578, 1, 1, 'tool_task', 'text_disabled', ' Disabled', '[[regtime]]', '[[regtime]]'),
(3579, 1, 1, 'tool_task', 'text_failed', ' Failed', '[[regtime]]', '[[regtime]]'),
(3580, 1, 1, 'tool_task', 'text_incomplete', ' Incomplete', '[[regtime]]', '[[regtime]]'),
(3581, 1, 1, 'tool_task', 'text_completed', ' Completed', '[[regtime]]', '[[regtime]]'),
(3582, 1, 1, 'tool_task', 'text_restart', ' Restart Task', '[[regtime]]', '[[regtime]]'),
(3583, 1, 1, 'tool_task', 'text_run', ' Run Task', '[[regtime]]', '[[regtime]]'),
(3584, 1, 1, 'tool_task', 'text_task_started', ' Task started', '[[regtime]]', '[[regtime]]'),
(3585, 1, 1, 'tool_task', 'text_task_not_found', ' Task not Found.', '[[regtime]]', '[[regtime]]'),
(3586, 1, 1, 'tool_task', 'text_empty_task', ' Task does not contains steps. Removed.', '[[regtime]]', '[[regtime]]'),
(3587, 1, 1, 'tool_task', 'text_forbidden_to_restart', ' Forbidden To restart!', '[[regtime]]', '[[regtime]]'),
(3588, 1, 1, 'tool_updater', 'heading_title', 'Update manager', '[[regtime]]', '[[regtime]]'),
(3589, 1, 1, 'tool_updater', 'text_checkupdates', 'check for updates', '[[regtime]]', '[[regtime]]'),
(3590, 1, 1, 'tool_updater', 'column_name', 'Extension Name', '[[regtime]]', '[[regtime]]'),
(3591, 1, 1, 'tool_updater', 'column_type', 'Type', '[[regtime]]', '[[regtime]]'),
(3592, 1, 1, 'tool_updater', 'column_category', 'Category', '[[regtime]]', '[[regtime]]'),
(3593, 1, 1, 'tool_updater', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(3594, 1, 1, 'tool_updater', 'column_version', 'Current version', '[[regtime]]', '[[regtime]]'),
(3595, 1, 1, 'tool_updater', 'column_new_version', 'New version', '[[regtime]]', '[[regtime]]'),
(3596, 1, 1, 'tool_updater', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(3597, 1, 1, 'tool_updater', 'text_success', 'Success: Extensions was successfully updated!', '[[regtime]]', '[[regtime]]'),
(3598, 1, 1, 'tool_updater', 'text_update', 'Update', '[[regtime]]', '[[regtime]]'),
(3599, 1, 1, 'tool_updater', 'entry_restore_exts', 'Restore Backuped extension:', '[[regtime]]', '[[regtime]]'),
(3600, 1, 1, 'tool_updater', 'entry_update', 'Updates:', '[[regtime]]', '[[regtime]]'),
(3601, 1, 1, 'tool_updater', 'error_permission', 'Warning: You do not have permission to modify directory: ', '[[regtime]]', '[[regtime]]'),
(3602, 1, 1, 'tool_updater', 'warning_server', 'Server with updates is inaccesible.', '[[regtime]]', '[[regtime]]'),
(3603, 1, 1, 'tool_updater', 'text_notice_title', 'Update Notice for %EXTENSION%', '[[regtime]]', '[[regtime]]'),
(3604, 1, 1, 'tool_updater', 'text_notice_text', '''New version of extension "%EXTENSION%" is available. Please, go to %LINK% and upgrade it.''', '[[regtime]]', '[[regtime]]'),
(3605, 1, 1, 'tool_updater', 'warning_updates', 'Can''t get information about updates.', '[[regtime]]', '[[regtime]]'),
(3606, 1, 1, 'tool_updater', 'error_empty', 'Warning: The file you uploaded was empty!', '[[regtime]]', '[[regtime]]'),
(3607, 1, 1, 'tool_updater', 'error_exts_list', 'Warning: Extension list is not array!', '[[regtime]]', '[[regtime]]'),
(3608, 1, 1, 'tool_updater', 'text_nothing_todo', ' Your''s extensions are up to date. Nothing to do. ', '[[regtime]]', '[[regtime]]'),
(3609, 1, 1, 'tool_updater', 'text_connect', 'Connect', '[[regtime]]', '[[regtime]]'),
(3610, 1, 1, 'tool_updater', 'text_marketplace_connect', 'Connect to the marketplace', '[[regtime]]', '[[regtime]]'),
(3611, 1, 1, 'tool_updater', 'text_marketplace_connect_your_store', 'Please Connect Your Store to the Marketplace', '[[regtime]]', '[[regtime]]'),
(3612, 1, 1, 'tool_updater', 'text_note', 'Note: Update available only for connected stores with purchased history.', '[[regtime]]', '[[regtime]]'),
(3613, 1, 1, 'total_balance', 'heading_title', 'Balance', '[[regtime]]', '[[regtime]]'),
(3614, 1, 1, 'total_balance', 'total_name', 'Balance', '[[regtime]]', '[[regtime]]'),
(3615, 1, 1, 'total_balance', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3616, 1, 1, 'total_balance', 'text_success', 'Success: You have modified total balance!', '[[regtime]]', '[[regtime]]'),
(3617, 1, 1, 'total_balance', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3618, 1, 1, 'total_balance', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3619, 1, 1, 'total_balance', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3620, 1, 1, 'total_balance', 'error_permission', 'Warning: You do not have permission to modify total balance!', '[[regtime]]', '[[regtime]]'),
(3621, 1, 1, 'total_coupon', 'heading_title', 'Coupon', '[[regtime]]', '[[regtime]]'),
(3622, 1, 1, 'total_coupon', 'total_name', 'Coupon', '[[regtime]]', '[[regtime]]'),
(3623, 1, 1, 'total_coupon', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3624, 1, 1, 'total_coupon', 'text_success', 'Success: You have modified total coupon!', '[[regtime]]', '[[regtime]]'),
(3625, 1, 1, 'total_coupon', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3626, 1, 1, 'total_coupon', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3627, 1, 1, 'total_coupon', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3628, 1, 1, 'total_coupon', 'error_permission', 'Warning: You do not have permission to modify total coupon!', '[[regtime]]', '[[regtime]]'),
(3629, 1, 1, 'total_discount', 'heading_title', 'Discount', '[[regtime]]', '[[regtime]]'),
(3630, 1, 1, 'total_discount', 'total_name', 'Discount', '[[regtime]]', '[[regtime]]'),
(3631, 1, 1, 'total_discount', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3632, 1, 1, 'total_discount', 'text_success', 'Success: You have modified total Discount!', '[[regtime]]', '[[regtime]]'),
(3633, 1, 1, 'total_discount', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3634, 1, 1, 'total_discount', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3635, 1, 1, 'total_discount', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3636, 1, 1, 'total_discount', 'error_permission', 'Warning: You do not have permission to modify total Discount!', '[[regtime]]', '[[regtime]]'),
(3637, 1, 1, 'total_handling', 'heading_title', 'Handling Fee', '[[regtime]]', '[[regtime]]'),
(3638, 1, 1, 'total_handling', 'total_name', 'Handling Fee', '[[regtime]]', '[[regtime]]'),
(3639, 1, 1, 'total_handling', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3640, 1, 1, 'total_handling', 'text_success', 'Success: You have updated total handling fee!', '[[regtime]]', '[[regtime]]'),
(3641, 1, 1, 'total_handling', 'entry_total', 'Order Total:<span class="help">Minimum order amount to be reached to apply the fee. If customer order total will exceed this amount, handling fee will not be applied. This value is overridden with payment specific setting.</span>', '[[regtime]]', '[[regtime]]'),
(3642, 1, 1, 'total_handling', 'entry_total_placeholder', 'Order Amount', '[[regtime]]', '[[regtime]]'),
(3643, 1, 1, 'total_handling', 'entry_fee', 'Fee:<span class="help">Fee to be added to order total if minimum amount condition is not met. This amount is overridden by payment specific setting</span>', '[[regtime]]', '[[regtime]]'),
(3644, 1, 1, 'total_handling', 'entry_payment_fee', 'Fee:<span class="help">Fee to be added to order total if minimum sub-total amount condition is not met. This amount override main fee setting</span>', '[[regtime]]', '[[regtime]]'),
(3645, 1, 1, 'total_handling', 'entry_payment', 'Payment:<span class="help">Select a specific payment you need to add the fee to. These settings will override the main settings if payment is used by customer.</span>', '[[regtime]]', '[[regtime]]'),
(3646, 1, 1, 'total_handling', 'entry_order_subtotal', 'Order Sub-Total:<span class="help">Minimum order sub-total amount to be reached to apply the fee. This overrides main setting</span>', '[[regtime]]', '[[regtime]]'),
(3647, 1, 1, 'total_handling', 'entry_tax', 'Tax Class:<span class="help">Select if you need tax to be applied on-top of the handling fee</span>', '[[regtime]]', '[[regtime]]'),
(3648, 1, 1, 'total_handling', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3649, 1, 1, 'total_handling', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3650, 1, 1, 'total_handling', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3651, 1, 1, 'total_handling', 'error_permission', 'Warning: You do not have permission to modify total handling fee!', '[[regtime]]', '[[regtime]]'),
(3652, 1, 1, 'total_handling', 'error_number', 'Warning: Order total and handling fee must be a numbers!', '[[regtime]]', '[[regtime]]'),
(3653, 1, 1, 'total_low_order_fee', 'heading_title', 'Low Order Fee', '[[regtime]]', '[[regtime]]'),
(3654, 1, 1, 'total_low_order_fee', 'total_name', 'Low Order Fee', '[[regtime]]', '[[regtime]]'),
(3655, 1, 1, 'total_low_order_fee', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3656, 1, 1, 'total_low_order_fee', 'text_success', 'Success: You have modified total low order fee!', '[[regtime]]', '[[regtime]]'),
(3657, 1, 1, 'total_low_order_fee', 'entry_total', 'Order Total:', '[[regtime]]', '[[regtime]]'),
(3658, 1, 1, 'total_low_order_fee', 'entry_fee', 'Fee:', '[[regtime]]', '[[regtime]]'),
(3659, 1, 1, 'total_low_order_fee', 'entry_tax', 'Tax Class:', '[[regtime]]', '[[regtime]]'),
(3660, 1, 1, 'total_low_order_fee', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3661, 1, 1, 'total_low_order_fee', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3662, 1, 1, 'total_low_order_fee', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3663, 1, 1, 'total_low_order_fee', 'error_permission', 'Warning: You do not have permission to modify total low order fee!', '[[regtime]]', '[[regtime]]'),
(3664, 1, 1, 'total_shipping', 'heading_title', 'Shipping', '[[regtime]]', '[[regtime]]'),
(3665, 1, 1, 'total_shipping', 'total_name', 'Shipping', '[[regtime]]', '[[regtime]]'),
(3666, 1, 1, 'total_shipping', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3667, 1, 1, 'total_shipping', 'text_success', 'Success: You have modified total shipping!', '[[regtime]]', '[[regtime]]'),
(3668, 1, 1, 'total_shipping', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3669, 1, 1, 'total_shipping', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3670, 1, 1, 'total_shipping', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3671, 1, 1, 'total_shipping', 'error_permission', 'Warning: You do not have permission to modify total shipping!', '[[regtime]]', '[[regtime]]'),
(3672, 1, 1, 'total_sub_total', 'heading_title', 'Sub-Total', '[[regtime]]', '[[regtime]]'),
(3673, 1, 1, 'total_sub_total', 'total_name', 'Sub-Total', '[[regtime]]', '[[regtime]]'),
(3674, 1, 1, 'total_sub_total', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3675, 1, 1, 'total_sub_total', 'text_success', 'Success: You have modified total sub-total!', '[[regtime]]', '[[regtime]]'),
(3676, 1, 1, 'total_sub_total', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3677, 1, 1, 'total_sub_total', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3678, 1, 1, 'total_sub_total', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3679, 1, 1, 'total_sub_total', 'error_permission', 'Warning: You do not have permission to modify total sub-total!', '[[regtime]]', '[[regtime]]'),
(3680, 1, 1, 'total_tax', 'heading_title', 'Taxes', '[[regtime]]', '[[regtime]]'),
(3681, 1, 1, 'total_tax', 'total_name', 'Taxes', '[[regtime]]', '[[regtime]]'),
(3682, 1, 1, 'total_tax', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3683, 1, 1, 'total_tax', 'text_success', 'Success: You have modified total taxes!', '[[regtime]]', '[[regtime]]'),
(3684, 1, 1, 'total_tax', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3685, 1, 1, 'total_tax', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3686, 1, 1, 'total_tax', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3687, 1, 1, 'total_tax', 'error_permission', 'Warning: You do not have permission to modify total taxes!', '[[regtime]]', '[[regtime]]'),
(3688, 1, 1, 'total_total', 'heading_title', 'Total', '[[regtime]]', '[[regtime]]'),
(3689, 1, 1, 'total_total', 'total_name', 'Total', '[[regtime]]', '[[regtime]]'),
(3690, 1, 1, 'total_total', 'text_total', 'Order Totals', '[[regtime]]', '[[regtime]]'),
(3691, 1, 1, 'total_total', 'text_success', 'Success: You have modified total total!', '[[regtime]]', '[[regtime]]'),
(3692, 1, 1, 'total_total', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3693, 1, 1, 'total_total', 'entry_sort_order', 'Sort Order:', '[[regtime]]', '[[regtime]]'),
(3694, 1, 1, 'total_total', 'entry_calculation_order', 'Calculation Order:', '[[regtime]]', '[[regtime]]'),
(3695, 1, 1, 'total_total', 'error_permission', 'Warning: You do not have permission to modify total total!', '[[regtime]]', '[[regtime]]'),
(3696, 1, 1, 'user_user', 'heading_title', 'Users', '[[regtime]]', '[[regtime]]'),
(3697, 1, 1, 'user_user', 'text_edit_details', 'Edit Profile Details', '[[regtime]]', '[[regtime]]'),
(3698, 1, 1, 'user_user', 'text_user', 'User', '[[regtime]]', '[[regtime]]'),
(3699, 1, 1, 'user_user', 'text_success', 'Success: You have modified users!', '[[regtime]]', '[[regtime]]'),
(3700, 1, 1, 'user_user', 'text_success_details', 'Success: You have modified your profile!', '[[regtime]]', '[[regtime]]'),
(3701, 1, 1, 'user_user', 'column_username', 'Username', '[[regtime]]', '[[regtime]]'),
(3702, 1, 1, 'user_user', 'column_group', 'Group', '[[regtime]]', '[[regtime]]'),
(3703, 1, 1, 'user_user', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(3704, 1, 1, 'user_user', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(3705, 1, 1, 'user_user', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(3706, 1, 1, 'user_user', 'entry_username', 'Username:', '[[regtime]]', '[[regtime]]'),
(3707, 1, 1, 'user_user', 'entry_password', 'Password:', '[[regtime]]', '[[regtime]]'),
(3708, 1, 1, 'user_user', 'entry_confirm', 'Confirm:', '[[regtime]]', '[[regtime]]'),
(3709, 1, 1, 'user_user', 'entry_firstname', 'First Name:', '[[regtime]]', '[[regtime]]'),
(3710, 1, 1, 'user_user', 'entry_lastname', 'Last Name:', '[[regtime]]', '[[regtime]]'),
(3711, 1, 1, 'user_user', 'entry_email', 'E-Mail:', '[[regtime]]', '[[regtime]]'),
(3712, 1, 1, 'user_user', 'entry_user_group', 'User Group:', '[[regtime]]', '[[regtime]]'),
(3713, 1, 1, 'user_user', 'entry_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(3714, 1, 1, 'user_user', 'entry_ims', 'Notifications', '[[regtime]]', '[[regtime]]'),
(3715, 1, 1, 'user_user', 'entry_captcha', 'Enter the code in the box below:', '[[regtime]]', '[[regtime]]'),
(3716, 1, 1, 'user_user', 'error_permission', 'Warning: You do not have permission to modify users!', '[[regtime]]', '[[regtime]]'),
(3717, 1, 1, 'user_user', 'error_account', 'Warning: You can not delete your own account!', '[[regtime]]', '[[regtime]]'),
(3718, 1, 1, 'user_user', 'error_username', 'Username must be between 2 and 20 characters and must be unique!', '[[regtime]]', '[[regtime]]'),
(3719, 1, 1, 'user_user', 'error_password', 'Password must be more than 3 characters!', '[[regtime]]', '[[regtime]]'),
(3720, 1, 1, 'user_user', 'error_confirm', 'Password and password confirmation do not match!', '[[regtime]]', '[[regtime]]'),
(3721, 1, 1, 'user_user', 'error_firstname', 'First Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3722, 1, 1, 'user_user', 'error_lastname', 'Last Name must be between 2 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(3723, 1, 1, 'user_user', 'error_email', 'E-Mail Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(3724, 1, 1, 'user_user', 'error_captcha', 'Human Verification Failed!', '[[regtime]]', '[[regtime]]'),
(3725, 1, 1, 'user_user', 'error_user_group', 'You have no permissions to change user group.', '[[regtime]]', '[[regtime]]'),
(3726, 1, 1, 'user_user', 'text_select_group', '- Select Group -', '[[regtime]]', '[[regtime]]'),
(3727, 1, 1, 'user_user', 'entry_im_email', 'E-Mail:<span class="help">One or more comma separated email addresses</span>', '[[regtime]]', '[[regtime]]'),
(3728, 1, 1, 'user_user', 'entry_im_sms', 'Mobile Phone:<span class="help">Phone number in international format. ex. +14566887777</span>', '[[regtime]]', '[[regtime]]'),
(3729, 1, 1, 'user_user', 'text_edit_im', 'Edit Notifications', '[[regtime]]', '[[regtime]]'),
(3730, 1, 1, 'user_user', 'text_sendpoints', 'Notification settings', '[[regtime]]', '[[regtime]]'),
(3731, 1, 1, 'user_user', 'text_change_im_addresses', 'Edit Notification Addresses for this SendPoint', '[[regtime]]', '[[regtime]]'),
(3732, 1, 1, 'user_user_group', 'heading_title', 'User Groups', '[[regtime]]', '[[regtime]]'),
(3733, 1, 1, 'user_user_group', 'text_group', 'User Group', '[[regtime]]', '[[regtime]]'),
(3734, 1, 1, 'user_user_group', 'text_success', 'Success: You have modified user groups!', '[[regtime]]', '[[regtime]]'),
(3735, 1, 1, 'user_user_group', 'text_success_group_added', 'Success: You have created user group successfully!', '[[regtime]]', '[[regtime]]'),
(3736, 1, 1, 'user_user_group', 'text_go_to_page', 'Go to Page', '[[regtime]]', '[[regtime]]'),
(3737, 1, 1, 'user_user_group', 'text_delete_confirm', ' Delete User Group?', '[[regtime]]', '[[regtime]]'),
(3738, 1, 1, 'user_user_group', 'column_name', 'User Group Name', '[[regtime]]', '[[regtime]]'),
(3739, 1, 1, 'user_user_group', 'column_action', 'Action', '[[regtime]]', '[[regtime]]'),
(3740, 1, 1, 'user_user_group', 'entry_name', 'User Group Name:', '[[regtime]]', '[[regtime]]'),
(3741, 1, 1, 'user_user_group', 'column_controller', 'Controller', '[[regtime]]', '[[regtime]]'),
(3742, 1, 1, 'user_user_group', 'column_access', 'Access', '[[regtime]]', '[[regtime]]'),
(3743, 1, 1, 'user_user_group', 'column_modify', 'Modify', '[[regtime]]', '[[regtime]]'),
(3744, 1, 1, 'user_user_group', 'error_permission', 'Warning: You do not have permission to modify user groups!', '[[regtime]]', '[[regtime]]'),
(3745, 1, 1, 'user_user_group', 'error_name', 'User Group Name must be between 2 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(3746, 1, 1, 'user_user_group', 'error_user', 'Warning: This user group cannot be deleted as it is currently assigned to %s users!', '[[regtime]]', '[[regtime]]'),
(3747, 1, 0, '2checkout_2checkout', 'text_title', 'Credit Card / Debit Card (2Checkout)', '[[regtime]]', '[[regtime]]'),
(3748, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_name', 'Avatax integration', '[[regtime]]', '[[regtime]]'),
(3749, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_address_validation_error', 'We failed to verify your shipping address. Please check and correct address below.', '[[regtime]]', '[[regtime]]'),
(3750, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_text_tax_exemption', 'Tax Exemption details', '[[regtime]]', '[[regtime]]'),
(3751, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_exemption_number', 'Tax Exemption Certificate Number', '[[regtime]]', '[[regtime]]'),
(3752, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_entity_use_code', 'Tax Exemption Customer Usage Type ', '[[regtime]]', '[[regtime]]'),
(3753, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_status', 'Current Exempt Status', '[[regtime]]', '[[regtime]]'),
(3754, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_status_pending', 'Pending Review', '[[regtime]]', '[[regtime]]'),
(3755, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_status_declined', 'Declined', '[[regtime]]', '[[regtime]]'),
(3756, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_status_approved', 'Approved', '[[regtime]]', '[[regtime]]'),
(3757, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_review_number_title', 'Customer Avatax Exemption Number needs to be reviewed!', '[[regtime]]', '[[regtime]]'),
(3758, 1, 0, 'avatax_integration_avatax_integration', 'avatax_integration_review_number_message', 'Please review customer''s tax exemption number. Visit #admin#rt=sale/avatax_customer_data&customer_id=%s', '[[regtime]]', '[[regtime]]'),
(3759, 1, 0, 'cardconnect_cardconnect', 'text_title', 'Credit Card / Debit Card (Via CardConnect)', '[[regtime]]', '[[regtime]]'),
(3760, 1, 0, 'cardconnect_cardconnect', 'text_credit_card', 'Credit Card Details', '[[regtime]]', '[[regtime]]'),
(3761, 1, 0, 'cardconnect_cardconnect', 'text_wait', 'Please wait!', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(3762, 1, 0, 'cardconnect_cardconnect', 'entry_cc_owner', 'Name on the card:', '[[regtime]]', '[[regtime]]'),
(3763, 1, 0, 'cardconnect_cardconnect', 'entry_cc_number', 'Card Number:', '[[regtime]]', '[[regtime]]'),
(3764, 1, 0, 'cardconnect_cardconnect', 'entry_cc_expire_date', 'Card Expiry Date:', '[[regtime]]', '[[regtime]]'),
(3765, 1, 0, 'cardconnect_cardconnect', 'entry_cc_cvv2', 'Card Security Code', '[[regtime]]', '[[regtime]]'),
(3766, 1, 0, 'cardconnect_cardconnect', 'entry_cc_cvv2_short', '(CVV2 ?)', '[[regtime]]', '[[regtime]]'),
(3767, 1, 0, 'cardconnect_cardconnect', 'entry_what_cvv2', 'What is CVV2?', '[[regtime]]', '[[regtime]]'),
(3768, 1, 0, 'cardconnect_cardconnect', 'entry_cc_type', 'Card Type', '[[regtime]]', '[[regtime]]'),
(3769, 1, 0, 'cardconnect_cardconnect', 'entry_cc_save', 'Save', '[[regtime]]', '[[regtime]]'),
(3770, 1, 0, 'cardconnect_cardconnect', 'entry_cc_save_details', 'Credit Card details will be securely saved by CardConnect', '[[regtime]]', '[[regtime]]'),
(3771, 1, 0, 'cardconnect_cardconnect', 'entry_billing_address', 'for billing Address', '[[regtime]]', '[[regtime]]'),
(3772, 1, 0, 'cardconnect_cardconnect', 'entry_edit', 'Edit', '[[regtime]]', '[[regtime]]'),
(3773, 1, 0, 'cardconnect_cardconnect', 'text_saved_credit_card', 'Select saved credit card', '[[regtime]]', '[[regtime]]'),
(3774, 1, 0, 'cardconnect_cardconnect', 'text_delete_saved_credit_card', 'Delete card', '[[regtime]]', '[[regtime]]'),
(3775, 1, 0, 'cardconnect_cardconnect', 'text_new_credit_card', 'New card', '[[regtime]]', '[[regtime]]'),
(3776, 1, 0, 'cardconnect_cardconnect', 'error_incorrect_number', 'Invalid Credit Card Number', '[[regtime]]', '[[regtime]]'),
(3777, 1, 0, 'cardconnect_cardconnect', 'error_incorrect_name', 'Invalid Card Owner Name', '[[regtime]]', '[[regtime]]'),
(3778, 1, 0, 'cardconnect_cardconnect', 'error_incorrect_expiration', 'Invalid Card Expiration Date', '[[regtime]]', '[[regtime]]'),
(3779, 1, 0, 'cardconnect_cardconnect', 'error_incorrect_cvv', 'Invalid Card CVV', '[[regtime]]', '[[regtime]]'),
(3780, 1, 0, 'cardconnect_cardconnect', 'error_system', 'Apologies, we have encounter system error. Please try again or contact site administrator!', '[[regtime]]', '[[regtime]]'),
(3781, 1, 0, 'cardknox_cardknox', 'text_title', 'Credit or Debit Card (Processed securely by CardKnox)', '[[regtime]]', '[[regtime]]'),
(3782, 1, 0, 'cardknox_cardknox', 'text_credit_card', 'Credit Card Details', '[[regtime]]', '[[regtime]]'),
(3783, 1, 0, 'cardknox_cardknox', 'text_account_number', 'ACH Account Number', '[[regtime]]', '[[regtime]]'),
(3784, 1, 0, 'cardknox_cardknox', 'cardknox_text_your_name', 'Your Name', '[[regtime]]', '[[regtime]]'),
(3785, 1, 0, 'cardknox_cardknox', 'cardknox_text_routing_number', 'Routing Number', '[[regtime]]', '[[regtime]]'),
(3786, 1, 0, 'cardknox_cardknox', 'cardknox_text_check_ach', 'Check (ACH)', '[[regtime]]', '[[regtime]]'),
(3787, 1, 0, 'cardknox_cardknox', 'cardknox_text_ebt', 'EBT Online', '[[regtime]]', '[[regtime]]'),
(3788, 1, 0, 'cardknox_cardknox', 'cardknox_text_ebt_number', 'EBT Card Number', '[[regtime]]', '[[regtime]]'),
(3789, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error', 'Oops. Something went wrong. (%s)', '[[regtime]]', '[[regtime]]'),
(3790, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error_accu200', 'Cancelled', '[[regtime]]', '[[regtime]]'),
(3791, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error_accu400', 'inactivity timeout', '[[regtime]]', '[[regtime]]'),
(3792, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error_accu600', 'Invalid Data received by Terminal', '[[regtime]]', '[[regtime]]'),
(3793, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error_accu710', 'Terminal Security Issue', '[[regtime]]', '[[regtime]]'),
(3794, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error_accu720', 'Terminal Communication Issue', '[[regtime]]', '[[regtime]]'),
(3795, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error_accu730', 'Terminal Internal Error', '[[regtime]]', '[[regtime]]'),
(3796, 1, 0, 'cardknox_cardknox', 'cardknox_pinpad_error_accu800', 'General Error Encountered', '[[regtime]]', '[[regtime]]'),
(3797, 1, 0, 'cardknox_cardknox', 'cardknox_ebt_declined', 'EBT card declined', '[[regtime]]', '[[regtime]]'),
(3798, 1, 0, 'default_authorizenet_default_authorizenet', 'text_title', 'Credit Card / Debit Card (Via Authorize.Net)', '[[regtime]]', '[[regtime]]'),
(3799, 1, 0, 'default_authorizenet_default_authorizenet', 'text_credit_card', 'Credit Card Details', '[[regtime]]', '[[regtime]]'),
(3800, 1, 0, 'default_authorizenet_default_authorizenet', 'text_wait', 'Please wait!', '[[regtime]]', '[[regtime]]'),
(3801, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_owner', 'Name on the card:', '[[regtime]]', '[[regtime]]'),
(3802, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_number', 'Card Number:', '[[regtime]]', '[[regtime]]'),
(3803, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_expire_date', 'Card Expiry Date:', '[[regtime]]', '[[regtime]]'),
(3804, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_cvv2', 'Card Security Code', '[[regtime]]', '[[regtime]]'),
(3805, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_cvv2_short', '(CVV2 ?)', '[[regtime]]', '[[regtime]]'),
(3806, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_what_cvv2', 'What is CVV2?', '[[regtime]]', '[[regtime]]'),
(3807, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_type', 'Card Type', '[[regtime]]', '[[regtime]]'),
(3808, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_save', 'Save', '[[regtime]]', '[[regtime]]'),
(3809, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_cc_save_details', 'Credit Card details will be securely saved by Stipe', '[[regtime]]', '[[regtime]]'),
(3810, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_billing_address', 'for billing Address', '[[regtime]]', '[[regtime]]'),
(3811, 1, 0, 'default_authorizenet_default_authorizenet', 'entry_edit', 'Edit', '[[regtime]]', '[[regtime]]'),
(3812, 1, 0, 'default_authorizenet_default_authorizenet', 'text_saved_credit_card', 'Select saved credit card', '[[regtime]]', '[[regtime]]'),
(3813, 1, 0, 'default_authorizenet_default_authorizenet', 'text_delete_saved_credit_card', 'Delete card', '[[regtime]]', '[[regtime]]'),
(3814, 1, 0, 'default_authorizenet_default_authorizenet', 'text_new_credit_card', 'New card', '[[regtime]]', '[[regtime]]'),
(3815, 1, 0, 'default_authorizenet_default_authorizenet', 'error_incorrect_number', 'Invalid Credit Card Number', '[[regtime]]', '[[regtime]]'),
(3816, 1, 0, 'default_authorizenet_default_authorizenet', 'error_incorrect_name', 'Invalid Card Owner Name', '[[regtime]]', '[[regtime]]'),
(3817, 1, 0, 'default_authorizenet_default_authorizenet', 'error_incorrect_expiration', 'Invalid Card Expiration Date', '[[regtime]]', '[[regtime]]'),
(3818, 1, 0, 'default_authorizenet_default_authorizenet', 'error_incorrect_cvv', 'Invalid Card CVV', '[[regtime]]', '[[regtime]]'),
(3819, 1, 0, 'default_authorizenet_default_authorizenet', 'error_system', 'Apologies, we have encounter system error. Please try again or contact site administrator!', '[[regtime]]', '[[regtime]]'),
(3820, 1, 0, 'default_banktransfer_default_banktransfer', 'text_title', 'Bank Transfer', '[[regtime]]', '[[regtime]]'),
(3821, 1, 0, 'default_banktransfer_default_banktransfer', 'text_instructions', 'Follow instructions to make your payment: ', '[[regtime]]', '[[regtime]]'),
(3822, 1, 0, 'default_banktransfer_default_banktransfer', 'text_payment', 'Your order will not ship or completed until payment is received.', '[[regtime]]', '[[regtime]]'),
(3823, 1, 0, 'default_banktransfer_default_banktransfer', 'text_minimum_notmet', 'Order total minimum is not met for bank transfer payment.', '[[regtime]]', '[[regtime]]'),
(3824, 1, 0, 'default_cheque_default_cheque', 'text_title', 'Cheque / Money Order', '[[regtime]]', '[[regtime]]'),
(3825, 1, 0, 'default_cheque_default_cheque', 'text_payable', 'Make Check Payable To: ', '[[regtime]]', '[[regtime]]'),
(3826, 1, 0, 'default_cheque_default_cheque', 'text_address', 'Send To: ', '[[regtime]]', '[[regtime]]'),
(3827, 1, 0, 'default_cheque_default_cheque', 'text_payment', 'Your order will not ship until we receive payment.', '[[regtime]]', '[[regtime]]'),
(3828, 1, 0, 'default_cheque_default_cheque', 'text_wait', 'Please wait!', '[[regtime]]', '[[regtime]]'),
(3829, 1, 0, 'default_cod_default_cod', 'text_title', 'Cash On Delivery', '[[regtime]]', '[[regtime]]'),
(3830, 1, 0, 'default_cod_default_cod', 'text_note', 'Payment needs to be established upon delivery or pickup of the product', '[[regtime]]', '[[regtime]]'),
(3831, 1, 0, 'default_cod_default_cod', 'text_wait', 'Please wait!', '[[regtime]]', '[[regtime]]'),
(3832, 1, 0, 'default_fedex_default_fedex', 'text_title', 'Fedex', '[[regtime]]', '[[regtime]]'),
(3833, 1, 0, 'default_fedex_default_fedex', 'text_description', 'Fedex', '[[regtime]]', '[[regtime]]'),
(3834, 1, 0, 'default_fedex_default_fedex', 'fedex_error_empty_postcode', 'Error: Empty postal code.', '[[regtime]]', '[[regtime]]'),
(3835, 1, 0, 'default_fedex_default_fedex', 'fedex_error_no_service', 'Service is not available in your area. Check if your shipping address is correct', '[[regtime]]', '[[regtime]]'),
(3836, 1, 0, 'default_flat_rate_shipping_default_flat_rate_shipping', 'text_title', 'Flat Rate', '[[regtime]]', '[[regtime]]'),
(3837, 1, 0, 'default_flat_rate_shipping_default_flat_rate_shipping', 'text_description', 'Flat Shipping Rate', '[[regtime]]', '[[regtime]]'),
(3838, 1, 0, 'default_free_shipping_default_free_shipping', 'text_title', 'Free Shipping', '[[regtime]]', '[[regtime]]'),
(3839, 1, 0, 'default_free_shipping_default_free_shipping', 'text_description', 'Free Shipping', '[[regtime]]', '[[regtime]]'),
(3840, 1, 0, 'default_liqpay_default_liqpay', 'text_title', 'Credit Card / Debit Card (LiqPay)', '[[regtime]]', '[[regtime]]'),
(3841, 1, 0, 'default_local_delivery_default_local_delivery', 'text_title', 'Local Delivery', '[[regtime]]', '[[regtime]]'),
(3842, 1, 0, 'default_local_delivery_default_local_delivery', 'text_description', 'Local Delivery', '[[regtime]]', '[[regtime]]'),
(3843, 1, 0, 'default_local_delivery_default_local_delivery', 'error_telephone', 'Please set your telephone number', '[[regtime]]', '[[regtime]]'),
(3844, 1, 0, 'default_local_delivery_default_local_delivery', 'text_apply', 'Apply', '[[regtime]]', '[[regtime]]'),
(3845, 1, 0, 'default_parcelforce_48_default_parcelforce_48', 'text_title', 'Parcelforce 48', '[[regtime]]', '[[regtime]]'),
(3846, 1, 0, 'default_parcelforce_48_default_parcelforce_48', 'text_description', 'Parcelforce 48', '[[regtime]]', '[[regtime]]'),
(3847, 1, 0, 'default_parcelforce_48_default_parcelforce_48', 'text_weight', 'Weight:', '[[regtime]]', '[[regtime]]'),
(3848, 1, 0, 'default_parcelforce_48_default_parcelforce_48', 'text_insurance', 'Insured upto:', '[[regtime]]', '[[regtime]]'),
(3849, 1, 0, 'default_parcelforce_48_default_parcelforce_48', 'text_time', 'Estimated Time: Within 48 Hours', '[[regtime]]', '[[regtime]]'),
(3850, 1, 0, 'default_per_item_shipping_default_per_item_shipping', 'text_title', 'Per Item', '[[regtime]]', '[[regtime]]'),
(3851, 1, 0, 'default_per_item_shipping_default_per_item_shipping', 'text_description', 'Per Item Shipping Rate', '[[regtime]]', '[[regtime]]'),
(3852, 1, 0, 'default_royal_mail_default_royal_mail', 'text_title', 'Royal Mail', '[[regtime]]', '[[regtime]]'),
(3853, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_weight', 'Weight:', '[[regtime]]', '[[regtime]]'),
(3854, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_insurance', 'Insured upto:', '[[regtime]]', '[[regtime]]'),
(3855, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_eta', 'Estimated Time:', '[[regtime]]', '[[regtime]]'),
(3856, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_1st_class', '1st Class®', '[[regtime]]', '[[regtime]]'),
(3857, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_2nd_class', '2nd Class®', '[[regtime]]', '[[regtime]]'),
(3858, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked24', 'Tracked 24®', '[[regtime]]', '[[regtime]]'),
(3859, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_tracked48', 'Tracked 48®', '[[regtime]]', '[[regtime]]'),
(3860, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail24', 'Mail 24®', '[[regtime]]', '[[regtime]]'),
(3861, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_mail48', 'Mail 48®', '[[regtime]]', '[[regtime]]'),
(3862, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_sameday', 'Sameday®', '[[regtime]]', '[[regtime]]'),
(3863, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_special_delivery_guaranteed', 'Special Delivery Guaranteed®', '[[regtime]]', '[[regtime]]'),
(3864, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_economy', 'Standard Economy', '[[regtime]]', '[[regtime]]'),
(3865, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_standard_priority', 'Standard Priority', '[[regtime]]', '[[regtime]]'),
(3866, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_signed', 'Signed', '[[regtime]]', '[[regtime]]'),
(3867, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_signed', 'Tracked Signed', '[[regtime]]', '[[regtime]]'),
(3868, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked', 'Tracked', '[[regtime]]', '[[regtime]]'),
(3869, 1, 0, 'default_royal_mail_default_royal_mail', 'default_royal_mail_intl_tracked_heavier', 'Tracked Heavier', '[[regtime]]', '[[regtime]]'),
(3870, 1, 0, 'default_store_pickup_default_store_pickup', 'text_title', 'Pickup', '[[regtime]]', '[[regtime]]'),
(3871, 1, 0, 'default_store_pickup_default_store_pickup', 'text_description', 'Pickup From Store', '[[regtime]]', '[[regtime]]'),
(3872, 1, 0, 'default_textmarketer_default_textmarketer', 'entry_sms', 'Mobile Phone (SMS Notification)', '[[regtime]]', '[[regtime]]'),
(3873, 1, 0, 'default_textmarketer_default_textmarketer', 'default_textmarketer_protocol_title', ' SMS ', '[[regtime]]', '[[regtime]]'),
(3874, 1, 0, 'default_twilio_default_twilio', 'entry_sms', ' Mobile Phone (SMS Notification) ', '[[regtime]]', '[[regtime]]'),
(3875, 1, 0, 'default_twilio_default_twilio', 'default_twilio_protocol_title', ' SMS ', '[[regtime]]', '[[regtime]]'),
(3876, 1, 0, 'default_usps_default_usps', 'text_title', 'United States Postal Service', '[[regtime]]', '[[regtime]]'),
(3877, 1, 0, 'default_usps_default_usps', 'text_weight', 'Weight:', '[[regtime]]', '[[regtime]]'),
(3878, 1, 0, 'default_usps_default_usps', 'text_eta', 'Estimated Time:', '[[regtime]]', '[[regtime]]'),
(3879, 1, 0, 'default_usps_default_usps', 'text_domestic_0', 'First-Class', '[[regtime]]', '[[regtime]]'),
(3880, 1, 0, 'default_usps_default_usps', 'text_domestic_1', 'Priority Mail', '[[regtime]]', '[[regtime]]'),
(3881, 1, 0, 'default_usps_default_usps', 'text_domestic_2', 'Express Mail Hold for Pickup', '[[regtime]]', '[[regtime]]'),
(3882, 1, 0, 'default_usps_default_usps', 'text_domestic_3', 'Express Mail PO to Addressee', '[[regtime]]', '[[regtime]]'),
(3883, 1, 0, 'default_usps_default_usps', 'text_domestic_4', 'Parcel Post', '[[regtime]]', '[[regtime]]'),
(3884, 1, 0, 'default_usps_default_usps', 'text_domestic_5', 'Bound Printed Matter', '[[regtime]]', '[[regtime]]'),
(3885, 1, 0, 'default_usps_default_usps', 'text_domestic_6', 'Media Mail', '[[regtime]]', '[[regtime]]'),
(3886, 1, 0, 'default_usps_default_usps', 'text_domestic_7', 'Library', '[[regtime]]', '[[regtime]]'),
(3887, 1, 0, 'default_usps_default_usps', 'text_domestic_12', 'First-Class Postcard Stamped', '[[regtime]]', '[[regtime]]'),
(3888, 1, 0, 'default_usps_default_usps', 'text_domestic_13', 'Express Mail Flat-Rate Envelope', '[[regtime]]', '[[regtime]]'),
(3889, 1, 0, 'default_usps_default_usps', 'text_domestic_16', 'Priority Mail Flat-Rate Envelope', '[[regtime]]', '[[regtime]]'),
(3890, 1, 0, 'default_usps_default_usps', 'text_domestic_17', 'Priority Mail Regular Flat-Rate Box', '[[regtime]]', '[[regtime]]'),
(3891, 1, 0, 'default_usps_default_usps', 'text_domestic_18', 'Priority Mail Keys and IDs', '[[regtime]]', '[[regtime]]'),
(3892, 1, 0, 'default_usps_default_usps', 'text_domestic_19', 'First-Class Keys and IDs', '[[regtime]]', '[[regtime]]'),
(3893, 1, 0, 'default_usps_default_usps', 'text_domestic_22', 'Priority Mail Flat-Rate Large Box', '[[regtime]]', '[[regtime]]'),
(3894, 1, 0, 'default_usps_default_usps', 'text_domestic_23', 'Express Mail Sunday/Holiday', '[[regtime]]', '[[regtime]]'),
(3895, 1, 0, 'default_usps_default_usps', 'text_domestic_25', 'Express Mail Flat-Rate Envelope Sunday/Holiday', '[[regtime]]', '[[regtime]]'),
(3896, 1, 0, 'default_usps_default_usps', 'text_domestic_27', 'Express Mail Flat-Rate Envelope Hold For Pickup', '[[regtime]]', '[[regtime]]'),
(3897, 1, 0, 'default_usps_default_usps', 'text_domestic_28', 'Priority Mail Small Flat-Rate Box', '[[regtime]]', '[[regtime]]'),
(3898, 1, 0, 'default_usps_default_usps', 'text_international_1', 'Express Mail International', '[[regtime]]', '[[regtime]]'),
(3899, 1, 0, 'default_usps_default_usps', 'text_international_2', 'Priority Mail International', '[[regtime]]', '[[regtime]]'),
(3900, 1, 0, 'default_usps_default_usps', 'text_international_4', 'Global Express Guaranteed (Document and Non-document)', '[[regtime]]', '[[regtime]]'),
(3901, 1, 0, 'default_usps_default_usps', 'text_international_5', 'Global Express Guaranteed Document used', '[[regtime]]', '[[regtime]]'),
(3902, 1, 0, 'default_usps_default_usps', 'text_international_6', 'Global Express Guaranteed Non-Document Rectangular shape', '[[regtime]]', '[[regtime]]'),
(3903, 1, 0, 'default_usps_default_usps', 'text_international_7', 'Global Express Guaranteed Non-Document Non-Rectangular', '[[regtime]]', '[[regtime]]'),
(3904, 1, 0, 'default_usps_default_usps', 'text_international_8', 'Priority Mail Flat Rate Envelope', '[[regtime]]', '[[regtime]]'),
(3905, 1, 0, 'default_usps_default_usps', 'text_international_9', 'Priority Mail Flat Rate Box', '[[regtime]]', '[[regtime]]'),
(3906, 1, 0, 'default_usps_default_usps', 'text_international_10', 'Express Mail International Flat Rate Envelope', '[[regtime]]', '[[regtime]]'),
(3907, 1, 0, 'default_usps_default_usps', 'text_international_11', 'Priority Mail Large Flat Rate Box', '[[regtime]]', '[[regtime]]'),
(3908, 1, 0, 'default_usps_default_usps', 'text_international_12', 'Global Express Guaranteed Envelope', '[[regtime]]', '[[regtime]]'),
(3909, 1, 0, 'default_usps_default_usps', 'text_international_13', 'First Class Mail International Letters', '[[regtime]]', '[[regtime]]'),
(3910, 1, 0, 'default_usps_default_usps', 'text_international_14', 'First Class Mail International Flats', '[[regtime]]', '[[regtime]]'),
(3911, 1, 0, 'default_usps_default_usps', 'text_international_15', 'First Class Mail International Parcels', '[[regtime]]', '[[regtime]]'),
(3912, 1, 0, 'default_usps_default_usps', 'text_international_16', 'Priority Mail Small Flat Rate Box', '[[regtime]]', '[[regtime]]'),
(3913, 1, 0, 'default_usps_default_usps', 'text_international_21', 'Postcards', '[[regtime]]', '[[regtime]]'),
(3914, 1, 0, 'default_weight_default_weight', 'text_title', 'Weight Based Shipping', '[[regtime]]', '[[regtime]]'),
(3915, 1, 0, 'default_weight_default_weight', 'text_weight', 'Weight:', '[[regtime]]', '[[regtime]]'),
(3916, 1, 0, 'forms_manager_default_email', 'default_subject', 'No subject', '[[regtime]]', '[[regtime]]'),
(3917, 1, 0, 'forms_manager_default_email', 'text_default_email_title', 'Form has been submited', '[[regtime]]', '[[regtime]]'),
(3918, 1, 0, 'forms_manager_default_email', 'text_error_message', 'There were some errors in the process.', '[[regtime]]', '[[regtime]]'),
(3919, 1, 0, 'forms_manager_default_email', 'text_success_message', 'Form was submited successfully!', '[[regtime]]', '[[regtime]]'),
(3920, 1, 0, 'forms_manager_default_email', 'error_required', 'This field is required!', '[[regtime]]', '[[regtime]]'),
(3921, 1, 0, 'forms_manager_forms_manager', 'error_required', 'This field is required!', '[[regtime]]', '[[regtime]]'),
(3922, 1, 0, 'forms_manager_forms_manager', 'error_email_not_valid', 'Not valid email format.', '[[regtime]]', '[[regtime]]'),
(3923, 1, 0, 'forms_manager_forms_manager', 'error_number_not_valid', 'Not valid number format.', '[[regtime]]', '[[regtime]]'),
(3924, 1, 0, 'forms_manager_forms_manager', 'error_phone_not_valid', 'Not valid phone format.', '[[regtime]]', '[[regtime]]'),
(3925, 1, 0, 'forms_manager_forms_manager', 'error_captcha_not_valid', 'Human verification has failed! Please try agan.', '[[regtime]]', '[[regtime]]'),
(3926, 1, 0, 'forms_manager_forms_manager', 'error_file_extension', 'Only files with extension(s) %s is(are) allowed!', '[[regtime]]', '[[regtime]]'),
(3927, 1, 0, 'forms_manager_forms_manager', 'error_min_file_size', 'Minimum file size for upload is %s Mb.', '[[regtime]]', '[[regtime]]'),
(3928, 1, 0, 'forms_manager_forms_manager', 'error_max_file_size', 'Maximum file size for upload is %s Mb.', '[[regtime]]', '[[regtime]]'),
(3929, 1, 0, 'novator_novator', 'novator_name', 'Novator', '[[regtime]]', '[[regtime]]'),
(3930, 1, 0, 'novator_novator', 'text_categories', 'Categories', '[[regtime]]', '[[regtime]]'),
(3931, 1, 0, 'novator_novator', 'text_ratings', 'Ratings', '[[regtime]]', '[[regtime]]'),
(3932, 1, 0, 'novator_novator', 'text_brands', 'Brands', '[[regtime]]', '[[regtime]]'),
(3933, 1, 0, 'novator_novator', 'text_per_page', 'Per Page', '[[regtime]]', '[[regtime]]'),
(3934, 1, 0, 'novator_novator', 'percentage_review', 'of buyers have recommended this.', '[[regtime]]', '[[regtime]]'),
(3935, 1, 0, 'paypal_commerce_paypal_commerce', 'text_title', 'Paypal', '[[regtime]]', '[[regtime]]'),
(3936, 1, 0, 'paypal_commerce_paypal_commerce', 'text_credit_card', 'Credit Card Details', '[[regtime]]', '[[regtime]]'),
(3937, 1, 0, 'paypal_commerce_paypal_commerce', 'text_wait', 'Please wait!', '[[regtime]]', '[[regtime]]'),
(3938, 1, 0, 'paypal_commerce_paypal_commerce', 'error_system', 'Apologies, we have encounter system error. Please try again or contact site administrator!', '[[regtime]]', '[[regtime]]'),
(3939, 1, 0, 'paypal_commerce_paypal_commerce', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(3940, 1, 0, 'paypal_commerce_paypal_commerce', 'paypal_commerce_loading', 'Loading...', '[[regtime]]', '[[regtime]]'),
(3941, 1, 0, 'paypal_commerce_paypal_commerce', 'paypal_commerce_table_invoice', 'Invoice', '[[regtime]]', '[[regtime]]'),
(3942, 1, 0, 'paypal_commerce_paypal_commerce', 'paypal_commerce_table_paid', 'Paid', '[[regtime]]', '[[regtime]]'),
(3943, 1, 0, 'paypal_commerce_paypal_commerce', 'text_paypal_commerce_cancel', 'Cancel', '[[regtime]]', '[[regtime]]'),
(3944, 1, 0, 'paypal_commerce_paypal_commerce', 'text_paypal_commerce_continue', 'Continue', '[[regtime]]', '[[regtime]]'),
(3945, 1, 0, 'paypal_commerce_paypal_commerce', 'paypal_commerce_text_download_pdf', ' Download PDF Invoice ', '[[regtime]]', '[[regtime]]'),
(3946, 1, 0, 'stripe_stripe', 'text_title', 'Credit Card / Debit Card (Via Stripe)', '[[regtime]]', '[[regtime]]'),
(3947, 1, 0, 'stripe_stripe', 'text_credit_card', 'Credit Card Details', '[[regtime]]', '[[regtime]]'),
(3948, 1, 0, 'stripe_stripe', 'text_wait', 'Please wait!', '[[regtime]]', '[[regtime]]'),
(3949, 1, 0, 'stripe_stripe', 'entry_cc_owner', 'Name on the card:', '[[regtime]]', '[[regtime]]'),
(3950, 1, 0, 'stripe_stripe', 'entry_cc_number', 'Card Number:', '[[regtime]]', '[[regtime]]'),
(3951, 1, 0, 'stripe_stripe', 'entry_cc_save', 'Save', '[[regtime]]', '[[regtime]]'),
(3952, 1, 0, 'stripe_stripe', 'entry_cc_save_details', 'Credit Card details will be securely saved by Stripe', '[[regtime]]', '[[regtime]]'),
(3953, 1, 0, 'stripe_stripe', 'entry_billing_address', 'for billing address', '[[regtime]]', '[[regtime]]'),
(3954, 1, 0, 'stripe_stripe', 'entry_edit', 'Edit', '[[regtime]]', '[[regtime]]'),
(3955, 1, 0, 'stripe_stripe', 'text_saved_credit_card', 'Select saved credit card', '[[regtime]]', '[[regtime]]'),
(3956, 1, 0, 'stripe_stripe', 'text_delete_saved_credit_card', 'Delete card', '[[regtime]]', '[[regtime]]'),
(3957, 1, 0, 'stripe_stripe', 'text_new_credit_card', 'New card', '[[regtime]]', '[[regtime]]'),
(3958, 1, 0, 'stripe_stripe', 'error_incorrect_number', 'Invalid Credit Card Number', '[[regtime]]', '[[regtime]]'),
(3959, 1, 0, 'stripe_stripe', 'error_incorrect_name', 'Invalid Card Owner Name', '[[regtime]]', '[[regtime]]'),
(3960, 1, 0, 'stripe_stripe', 'error_incorrect_expiration', 'Invalid Card Expiration Date', '[[regtime]]', '[[regtime]]'),
(3961, 1, 0, 'stripe_stripe', 'error_incorrect_cvv', 'Invalid Card CVV', '[[regtime]]', '[[regtime]]'),
(3962, 1, 0, 'stripe_stripe', 'error_system', 'Apologies, we have encounter system error. Please try again or contact site administrator!', '[[regtime]]', '[[regtime]]'),
(3963, 1, 0, 'stripe_stripe', 'error_payment_method', 'Please try again or choose another payment method', '[[regtime]]', '[[regtime]]'),
(3964, 1, 0, 'stripe_stripe', 'stripe_error_guest_subscription', 'You need to <a href="%s">create an account</a> to complete your subscription!', '[[regtime]]', '[[regtime]]'),
(3965, 1, 0, 'ups_ups', 'ups_text_title', 'United Parcel Service', '[[regtime]]', '[[regtime]]'),
(3966, 1, 0, 'ups_ups', 'ups_text_weight', 'Weight:', '[[regtime]]', '[[regtime]]'),
(3967, 1, 0, 'ups_ups', 'ups_text_us_origin_01', 'UPS Next Day Air', '[[regtime]]', '[[regtime]]'),
(3968, 1, 0, 'ups_ups', 'ups_text_us_origin_02', 'UPS 2nd Day Air', '[[regtime]]', '[[regtime]]'),
(3969, 1, 0, 'ups_ups', 'ups_text_us_origin_03', 'UPS Ground', '[[regtime]]', '[[regtime]]'),
(3970, 1, 0, 'ups_ups', 'ups_text_us_origin_07', 'UPS Worldwide Express', '[[regtime]]', '[[regtime]]'),
(3971, 1, 0, 'ups_ups', 'ups_text_us_origin_08', 'UPS Worldwide Expedited', '[[regtime]]', '[[regtime]]'),
(3972, 1, 0, 'ups_ups', 'ups_text_us_origin_11', 'UPS Standard', '[[regtime]]', '[[regtime]]'),
(3973, 1, 0, 'ups_ups', 'ups_text_us_origin_12', 'UPS 3 Day Select', '[[regtime]]', '[[regtime]]'),
(3974, 1, 0, 'ups_ups', 'ups_text_us_origin_13', 'UPS Next Day Air Saver', '[[regtime]]', '[[regtime]]'),
(3975, 1, 0, 'ups_ups', 'ups_text_us_origin_14', 'UPS Next Day Air Early A.M.', '[[regtime]]', '[[regtime]]'),
(3976, 1, 0, 'ups_ups', 'ups_text_us_origin_54', 'UPS Worldwide Express Plus', '[[regtime]]', '[[regtime]]'),
(3977, 1, 0, 'ups_ups', 'ups_text_us_origin_59', 'UPS 2nd Day Air A.M.', '[[regtime]]', '[[regtime]]'),
(3978, 1, 0, 'ups_ups', 'ups_text_us_origin_65', 'UPS Saver', '[[regtime]]', '[[regtime]]'),
(3979, 1, 0, 'ups_ups', 'ups_text_ca_origin_01', 'UPS Express', '[[regtime]]', '[[regtime]]'),
(3980, 1, 0, 'ups_ups', 'ups_text_ca_origin_02', 'UPS Expedited', '[[regtime]]', '[[regtime]]'),
(3981, 1, 0, 'ups_ups', 'ups_text_ca_origin_07', 'UPS Worldwide Express', '[[regtime]]', '[[regtime]]'),
(3982, 1, 0, 'ups_ups', 'ups_text_ca_origin_08', 'UPS Worldwide Expedited', '[[regtime]]', '[[regtime]]'),
(3983, 1, 0, 'ups_ups', 'ups_text_ca_origin_11', 'UPS Standard', '[[regtime]]', '[[regtime]]'),
(3984, 1, 0, 'ups_ups', 'ups_text_ca_origin_12', 'UPS 3 Day Select', '[[regtime]]', '[[regtime]]'),
(3985, 1, 0, 'ups_ups', 'ups_text_ca_origin_13', 'UPS Saver', '[[regtime]]', '[[regtime]]'),
(3986, 1, 0, 'ups_ups', 'ups_text_ca_origin_14', 'UPS Express Early A.M.', '[[regtime]]', '[[regtime]]'),
(3987, 1, 0, 'ups_ups', 'ups_text_ca_origin_54', 'UPS Worldwide Express Plus', '[[regtime]]', '[[regtime]]'),
(3988, 1, 0, 'ups_ups', 'ups_text_ca_origin_65', 'UPS Saver', '[[regtime]]', '[[regtime]]'),
(3989, 1, 0, 'ups_ups', 'ups_text_eu_origin_07', 'UPS Worldwide Express', '[[regtime]]', '[[regtime]]'),
(3990, 1, 0, 'ups_ups', 'ups_text_eu_origin_08', 'UPS Worldwide Expedited', '[[regtime]]', '[[regtime]]'),
(3991, 1, 0, 'ups_ups', 'ups_text_eu_origin_11', 'UPS Standard', '[[regtime]]', '[[regtime]]'),
(3992, 1, 0, 'ups_ups', 'ups_text_eu_origin_54', 'UPS Worldwide Express Plus', '[[regtime]]', '[[regtime]]'),
(3993, 1, 0, 'ups_ups', 'ups_text_eu_origin_65', 'UPS Saver', '[[regtime]]', '[[regtime]]'),
(3994, 1, 0, 'ups_ups', 'ups_text_eu_origin_82', 'UPS Today Standard', '[[regtime]]', '[[regtime]]'),
(3995, 1, 0, 'ups_ups', 'ups_text_eu_origin_83', 'UPS Today Dedicated Courier', '[[regtime]]', '[[regtime]]'),
(3996, 1, 0, 'ups_ups', 'ups_text_eu_origin_84', 'UPS Today Intercity', '[[regtime]]', '[[regtime]]'),
(3997, 1, 0, 'ups_ups', 'ups_text_eu_origin_85', 'UPS Today Express', '[[regtime]]', '[[regtime]]'),
(3998, 1, 0, 'ups_ups', 'ups_text_eu_origin_86', 'UPS Today Express Saver', '[[regtime]]', '[[regtime]]'),
(3999, 1, 0, 'ups_ups', 'ups_text_eu_origin_01', 'UPS Next Day Air', '[[regtime]]', '[[regtime]]'),
(4000, 1, 0, 'ups_ups', 'ups_text_eu_origin_02', 'UPS 2nd Day Air', '[[regtime]]', '[[regtime]]'),
(4001, 1, 0, 'ups_ups', 'ups_text_eu_origin_03', 'UPS Ground', '[[regtime]]', '[[regtime]]'),
(4002, 1, 0, 'ups_ups', 'ups_text_eu_origin_14', 'UPS Next Day Air Early A.M.', '[[regtime]]', '[[regtime]]'),
(4003, 1, 0, 'ups_ups', 'ups_text_mx_origin_07', 'UPS Express', '[[regtime]]', '[[regtime]]'),
(4004, 1, 0, 'ups_ups', 'ups_text_mx_origin_08', 'UPS Expedited', '[[regtime]]', '[[regtime]]'),
(4005, 1, 0, 'ups_ups', 'ups_text_mx_origin_54', 'UPS Express Plus', '[[regtime]]', '[[regtime]]'),
(4006, 1, 0, 'ups_ups', 'ups_text_mx_origin_65', 'UPS Saver', '[[regtime]]', '[[regtime]]'),
(4007, 1, 0, 'ups_ups', 'ups_text_other_origin_07', 'UPS Express', '[[regtime]]', '[[regtime]]'),
(4008, 1, 0, 'ups_ups', 'ups_text_other_origin_08', 'UPS Worldwide Expedited', '[[regtime]]', '[[regtime]]'),
(4009, 1, 0, 'ups_ups', 'ups_text_other_origin_11', 'UPS Standard', '[[regtime]]', '[[regtime]]'),
(4010, 1, 0, 'ups_ups', 'ups_text_other_origin_54', 'UPS Worldwide Express Plus', '[[regtime]]', '[[regtime]]'),
(4011, 1, 0, 'ups_ups', 'ups_text_other_origin_65', 'UPS Saver', '[[regtime]]', '[[regtime]]'),
(4012, 1, 0, 'account_account', 'heading_title', 'My Account', '[[regtime]]', '[[regtime]]'),
(4013, 1, 0, 'account_account', 'text_account_dashboard', 'Account Dashboard', '[[regtime]]', '[[regtime]]'),
(4014, 1, 0, 'account_account', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4015, 1, 0, 'account_account', 'text_my_account', 'My Account', '[[regtime]]', '[[regtime]]'),
(4016, 1, 0, 'account_account', 'text_my_orders', 'My Orders', '[[regtime]]', '[[regtime]]'),
(4017, 1, 0, 'account_account', 'text_my_notifications', 'Notifications', '[[regtime]]', '[[regtime]]'),
(4018, 1, 0, 'account_account', 'text_information', 'Edit account details', '[[regtime]]', '[[regtime]]'),
(4019, 1, 0, 'account_account', 'text_password', 'Change password', '[[regtime]]', '[[regtime]]'),
(4020, 1, 0, 'account_account', 'text_address', 'Manage Address Book', '[[regtime]]', '[[regtime]]'),
(4021, 1, 0, 'account_account', 'text_history', 'Order history', '[[regtime]]', '[[regtime]]'),
(4022, 1, 0, 'account_account', 'text_transactions', 'Transaction history', '[[regtime]]', '[[regtime]]'),
(4023, 1, 0, 'account_account', 'text_download', 'Downloads', '[[regtime]]', '[[regtime]]'),
(4024, 1, 0, 'account_account', 'text_newsletter', 'Newsletter Subscription', '[[regtime]]', '[[regtime]]'),
(4025, 1, 0, 'account_account', 'text_account_wishlist', 'My wish list', '[[regtime]]', '[[regtime]]'),
(4026, 1, 0, 'account_address', 'heading_title', 'Address Book', '[[regtime]]', '[[regtime]]'),
(4027, 1, 0, 'account_address', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4028, 1, 0, 'account_address', 'text_address_book', 'Address Book Entries', '[[regtime]]', '[[regtime]]'),
(4029, 1, 0, 'account_address', 'text_edit_address', 'Edit Address', '[[regtime]]', '[[regtime]]'),
(4030, 1, 0, 'account_address', 'text_insert', 'Your address has been successfully inserted', '[[regtime]]', '[[regtime]]'),
(4031, 1, 0, 'account_address', 'text_update', 'Your address has been successfully updated', '[[regtime]]', '[[regtime]]'),
(4032, 1, 0, 'account_address', 'text_delete', 'Your address has been successfully deleted', '[[regtime]]', '[[regtime]]'),
(4033, 1, 0, 'account_address', 'entry_firstname', 'First Name:', '[[regtime]]', '[[regtime]]'),
(4034, 1, 0, 'account_address', 'entry_lastname', 'Last Name:', '[[regtime]]', '[[regtime]]'),
(4035, 1, 0, 'account_address', 'entry_company', 'Company:', '[[regtime]]', '[[regtime]]'),
(4036, 1, 0, 'account_address', 'entry_address_1', 'Address 1:', '[[regtime]]', '[[regtime]]'),
(4037, 1, 0, 'account_address', 'entry_address_2', 'Address 2:', '[[regtime]]', '[[regtime]]'),
(4038, 1, 0, 'account_address', 'entry_postcode', 'ZIP/Post Code:', '[[regtime]]', '[[regtime]]'),
(4039, 1, 0, 'account_address', 'entry_city', 'City:', '[[regtime]]', '[[regtime]]'),
(4040, 1, 0, 'account_address', 'error_postcode', 'Zip/postal code must be between 2 and 10 characters!', '[[regtime]]', '[[regtime]]'),
(4041, 1, 0, 'account_address', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(4042, 1, 0, 'account_address', 'entry_zone', 'Region / State:', '[[regtime]]', '[[regtime]]'),
(4043, 1, 0, 'account_address', 'entry_default', 'Default Address:', '[[regtime]]', '[[regtime]]'),
(4044, 1, 0, 'account_address', 'error_delete', 'Error: you must have at least one address!', '[[regtime]]', '[[regtime]]'),
(4045, 1, 0, 'account_address', 'error_default', 'Error: you can not delete your default address!', '[[regtime]]', '[[regtime]]'),
(4046, 1, 0, 'account_address', 'error_firstname', 'First Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(4047, 1, 0, 'account_address', 'error_lastname', 'Last Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(4048, 1, 0, 'account_address', 'error_address_1', 'Address must be between 3 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(4049, 1, 0, 'account_address', 'error_city', 'City must be between 3 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(4050, 1, 0, 'account_address', 'error_country', 'Please select a country!', '[[regtime]]', '[[regtime]]'),
(4051, 1, 0, 'account_address', 'error_zone', 'Please select a region / state!', '[[regtime]]', '[[regtime]]'),
(4052, 1, 0, 'account_create', 'heading_title', 'Create Account', '[[regtime]]', '[[regtime]]'),
(4053, 1, 0, 'account_create', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4054, 1, 0, 'account_create', 'text_create', 'Register', '[[regtime]]', '[[regtime]]'),
(4055, 1, 0, 'account_create', 'text_account_already', 'If you already have an account with us, please login at the <a style="text-decoration: underline" href="%s">login page</a>.', '[[regtime]]', '[[regtime]]'),
(4056, 1, 0, 'account_create', 'text_your_details', 'Your Personal Details', '[[regtime]]', '[[regtime]]'),
(4057, 1, 0, 'account_create', 'text_your_address', 'Your Address', '[[regtime]]', '[[regtime]]'),
(4058, 1, 0, 'account_create', 'text_newsletter', 'Newsletter', '[[regtime]]', '[[regtime]]'),
(4059, 1, 0, 'account_create', 'text_your_password', 'Your Password', '[[regtime]]', '[[regtime]]'),
(4060, 1, 0, 'account_create', 'text_login_details', 'Login Details', '[[regtime]]', '[[regtime]]'),
(4061, 1, 0, 'account_create', 'text_agree', 'I have read and agree to the', '[[regtime]]', '[[regtime]]'),
(4062, 1, 0, 'account_create', 'entry_loginname', 'Login name:', '[[regtime]]', '[[regtime]]'),
(4063, 1, 0, 'account_create', 'entry_firstname', 'First Name:', '[[regtime]]', '[[regtime]]'),
(4064, 1, 0, 'account_create', 'entry_lastname', 'Last Name:', '[[regtime]]', '[[regtime]]'),
(4065, 1, 0, 'account_create', 'entry_email', 'E-Mail:', '[[regtime]]', '[[regtime]]'),
(4066, 1, 0, 'account_create', 'entry_telephone', 'Telephone:', '[[regtime]]', '[[regtime]]'),
(4067, 1, 0, 'account_create', 'entry_fax', 'Fax:', '[[regtime]]', '[[regtime]]'),
(4068, 1, 0, 'account_create', 'entry_company', 'Company:', '[[regtime]]', '[[regtime]]'),
(4069, 1, 0, 'account_create', 'entry_address_1', 'Address 1:', '[[regtime]]', '[[regtime]]'),
(4070, 1, 0, 'account_create', 'entry_address_2', 'Address 2:', '[[regtime]]', '[[regtime]]'),
(4071, 1, 0, 'account_create', 'entry_postcode', 'ZIP Code:', '[[regtime]]', '[[regtime]]'),
(4072, 1, 0, 'account_create', 'entry_city', 'City:', '[[regtime]]', '[[regtime]]'),
(4073, 1, 0, 'account_create', 'entry_country', 'Country:', '[[regtime]]', '[[regtime]]'),
(4074, 1, 0, 'account_create', 'entry_zone', 'Region / State:', '[[regtime]]', '[[regtime]]'),
(4075, 1, 0, 'account_create', 'entry_newsletter', 'Subscribe:', '[[regtime]]', '[[regtime]]'),
(4076, 1, 0, 'account_create', 'entry_password', 'Password:', '[[regtime]]', '[[regtime]]'),
(4077, 1, 0, 'account_create', 'entry_confirm', 'Password Confirm:', '[[regtime]]', '[[regtime]]'),
(4078, 1, 0, 'account_create', 'error_exists', 'Error: E-Mail Address is already registered!', '[[regtime]]', '[[regtime]]'),
(4079, 1, 0, 'account_create', 'error_loginname', 'Login name must be alphanumeric only and between 5 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(4080, 1, 0, 'account_create', 'error_loginname_notunique', 'This login name is not available. Try different login name!', '[[regtime]]', '[[regtime]]'),
(4081, 1, 0, 'account_create', 'error_firstname', 'First Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(4082, 1, 0, 'account_create', 'error_lastname', 'Last Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(4083, 1, 0, 'account_create', 'error_email', 'Email Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(4084, 1, 0, 'account_create', 'error_email_exists', 'Email Address is Already Exists!', '[[regtime]]', '[[regtime]]'),
(4085, 1, 0, 'account_create', 'error_password', 'Password must be between 4 and 20 characters!', '[[regtime]]', '[[regtime]]'),
(4086, 1, 0, 'account_create', 'error_confirm', 'Password confirmation does not match password!', '[[regtime]]', '[[regtime]]'),
(4087, 1, 0, 'account_create', 'error_address_1', 'Address 1 must be between 3 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(4088, 1, 0, 'account_create', 'error_city', 'City must be between 3 and 128 characters!', '[[regtime]]', '[[regtime]]'),
(4089, 1, 0, 'account_create', 'error_postcode', 'Zip/postal code must be between 3 and 10 characters!', '[[regtime]]', '[[regtime]]'),
(4090, 1, 0, 'account_create', 'error_country', 'Please select a country!', '[[regtime]]', '[[regtime]]'),
(4091, 1, 0, 'account_create', 'error_zone', 'Please select a region / state!', '[[regtime]]', '[[regtime]]'),
(4092, 1, 0, 'account_create', 'error_telephone', 'Telephone must be between 3 and 32 numeric only characters!', '[[regtime]]', '[[regtime]]'),
(4093, 1, 0, 'account_create', 'error_agree', 'Error: You must agree to the %s!', '[[regtime]]', '[[regtime]]'),
(4094, 1, 0, 'account_create', 'text_full_register', 'Become a customer and register with your details', '[[regtime]]', '[[regtime]]'),
(4095, 1, 0, 'account_create', 'text_subscribe_register', 'Become a newsletter subscriber', '[[regtime]]', '[[regtime]]'),
(4096, 1, 0, 'account_create', 'text_success_subscribe_heading', 'You have subscribed successfully!', '[[regtime]]', '[[regtime]]'),
(4097, 1, 0, 'account_create', 'text_success_subscribe', 'Success: Your newsletter subscription has been successfully created!', '[[regtime]]', '[[regtime]]'),
(4098, 1, 0, 'account_create', 'error_subscriber_exists', 'Our records indicate that you have an account with us. Please login to your account to manage your newsletter subscription.', '[[regtime]]', '[[regtime]]'),
(4099, 1, 0, 'account_create', 'text_new_customer', 'New customer registration approval is pending', '[[regtime]]', '[[regtime]]'),
(4100, 1, 0, 'account_create', 'text_pending_customer_approval', 'Customer %s has registered with new account. Action of approval is required! Click to view #admin#rt=sale/customer/update&customer_id=%s', '[[regtime]]', '[[regtime]]'),
(4101, 1, 0, 'account_create', 'text_pending_subscriber_approval', 'Subscriber %s has registered with new account. Action of approval is required! Click to view #admin#rt=sale/customer/update&customer_id=%s', '[[regtime]]', '[[regtime]]'),
(4102, 1, 0, 'account_download', 'heading_title', 'Account Downloads', '[[regtime]]', '[[regtime]]'),
(4103, 1, 0, 'account_download', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4104, 1, 0, 'account_download', 'text_downloads', 'Downloads', '[[regtime]]', '[[regtime]]'),
(4105, 1, 0, 'account_download', 'text_order', 'Order ID:', '[[regtime]]', '[[regtime]]'),
(4106, 1, 0, 'account_download', 'text_date_added', 'Date Added:', '[[regtime]]', '[[regtime]]'),
(4107, 1, 0, 'account_download', 'text_date_purchased', 'Date Purchased:', '[[regtime]]', '[[regtime]]'),
(4108, 1, 0, 'account_download', 'text_name', 'Name:', '[[regtime]]', '[[regtime]]'),
(4109, 1, 0, 'account_download', 'text_remaining', 'Remaining:', '[[regtime]]', '[[regtime]]'),
(4110, 1, 0, 'account_download', 'text_size', 'Size:', '[[regtime]]', '[[regtime]]'),
(4111, 1, 0, 'account_download', 'text_download', 'Download', '[[regtime]]', '[[regtime]]'),
(4112, 1, 0, 'account_download', 'text_error', 'You have not made any previous downloadable orders!', '[[regtime]]', '[[regtime]]'),
(4113, 1, 0, 'account_download', 'text_expire_date', 'Expire Date:', '[[regtime]]', '[[regtime]]'),
(4114, 1, 0, 'account_download', 'text_expired', 'Expired', '[[regtime]]', '[[regtime]]'),
(4115, 1, 0, 'account_download', 'text_pending', 'Pending', '[[regtime]]', '[[regtime]]'),
(4116, 1, 0, 'account_download', 'text_unavailable', 'Unavailable', '[[regtime]]', '[[regtime]]'),
(4117, 1, 0, 'account_download', 'text_reached_limit', 'Reached Limit', '[[regtime]]', '[[regtime]]'),
(4118, 1, 0, 'account_download', 'error_download_not_exists', 'Requested file does not exists!', '[[regtime]]', '[[regtime]]'),
(4119, 1, 0, 'account_edit', 'heading_title', 'My Account Information', '[[regtime]]', '[[regtime]]'),
(4120, 1, 0, 'account_edit', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4121, 1, 0, 'account_edit', 'text_edit', 'Edit Information', '[[regtime]]', '[[regtime]]'),
(4122, 1, 0, 'account_edit', 'text_your_details', 'Your Personal Details', '[[regtime]]', '[[regtime]]'),
(4123, 1, 0, 'account_edit', 'text_success', 'Success: Your account has been successfully updated.', '[[regtime]]', '[[regtime]]'),
(4124, 1, 0, 'account_edit', 'entry_loginname', 'Login Name:', '[[regtime]]', '[[regtime]]'),
(4125, 1, 0, 'account_edit', 'entry_firstname', 'First Name:', '[[regtime]]', '[[regtime]]'),
(4126, 1, 0, 'account_edit', 'entry_lastname', 'Last Name:', '[[regtime]]', '[[regtime]]'),
(4127, 1, 0, 'account_edit', 'entry_date_of_birth', 'Date Of Birth:', '[[regtime]]', '[[regtime]]'),
(4128, 1, 0, 'account_edit', 'entry_email', 'E-Mail:', '[[regtime]]', '[[regtime]]'),
(4129, 1, 0, 'account_edit', 'entry_telephone', 'Telephone:', '[[regtime]]', '[[regtime]]'),
(4130, 1, 0, 'account_edit', 'entry_fax', 'Fax:', '[[regtime]]', '[[regtime]]'),
(4131, 1, 0, 'account_edit', 'error_exists', 'Error: E-Mail address is already registered!', '[[regtime]]', '[[regtime]]'),
(4132, 1, 0, 'account_edit', 'error_loginname', 'Login name must be alphanumeric only and between 5 and 64 characters!', '[[regtime]]', '[[regtime]]'),
(4133, 1, 0, 'account_edit', 'error_loginname_notunique', 'This login name is not available. Try different login name!', '[[regtime]]', '[[regtime]]'),
(4134, 1, 0, 'account_edit', 'error_firstname', 'First Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(4135, 1, 0, 'account_edit', 'error_lastname', 'Last Name must be between 1 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(4136, 1, 0, 'account_edit', 'error_email', 'E-Mail Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(4137, 1, 0, 'account_edit', 'error_telephone', 'Telephone must be between 3 and 32 numeric only characters!', '[[regtime]]', '[[regtime]]'),
(4138, 1, 0, 'account_edit', 'loginname_update_required', 'Your login name is the same as your email. To keep your account protected, please create a new unique login name', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(4139, 1, 0, 'account_forgotten', 'heading_title', 'Forgot Your Password?', '[[regtime]]', '[[regtime]]'),
(4140, 1, 0, 'account_forgotten', 'heading_title_loginname', 'Forgot Your Login Name?', '[[regtime]]', '[[regtime]]'),
(4141, 1, 0, 'account_forgotten', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4142, 1, 0, 'account_forgotten', 'text_forgotten', 'Forgotten Password', '[[regtime]]', '[[regtime]]'),
(4143, 1, 0, 'account_forgotten', 'text_your_email', 'Your E-Mail Address', '[[regtime]]', '[[regtime]]'),
(4144, 1, 0, 'account_forgotten', 'text_email', 'Enter the e-mail address associated with your account. Click submit to have your password emailed to you', '[[regtime]]', '[[regtime]]'),
(4145, 1, 0, 'account_forgotten', 'text_loginname_email', 'Enter the login name and e-mail address associated with your account. Click submit to request password reset', '[[regtime]]', '[[regtime]]'),
(4146, 1, 0, 'account_forgotten', 'text_lastname_email', 'Enter the last name and e-mail address associated with your account. Click submit to have your login name emailed to you', '[[regtime]]', '[[regtime]]'),
(4147, 1, 0, 'account_forgotten', 'text_success', 'Success: Password reset link has been sent to your e-mail address.', '[[regtime]]', '[[regtime]]'),
(4148, 1, 0, 'account_forgotten', 'text_success_loginname', 'Success: Your login name reminder has been sent to your e-mail address.', '[[regtime]]', '[[regtime]]'),
(4149, 1, 0, 'account_forgotten', 'entry_loginname', 'Login Name:', '[[regtime]]', '[[regtime]]'),
(4150, 1, 0, 'account_forgotten', 'entry_lastname', 'Last Name:', '[[regtime]]', '[[regtime]]'),
(4151, 1, 0, 'account_forgotten', 'entry_email', 'E-Mail Address:', '[[regtime]]', '[[regtime]]'),
(4152, 1, 0, 'account_forgotten', 'error_email', 'Error: The Email address was not provided or not found in our records, please try again!', '[[regtime]]', '[[regtime]]'),
(4153, 1, 0, 'account_forgotten', 'error_loginname', 'Error: The Login name was not provided or not found in our records, please try again!', '[[regtime]]', '[[regtime]]'),
(4154, 1, 0, 'account_forgotten', 'error_lastname', 'Error: The Last name was not provided or not found in our records, please try again!', '[[regtime]]', '[[regtime]]'),
(4155, 1, 0, 'account_forgotten', 'error_not_found', 'Error: No records found matching information your provided, please check your information and try again!', '[[regtime]]', '[[regtime]]'),
(4156, 1, 0, 'account_forgotten', 'text_forgotten_loginname', 'Forgotten Login Name', '[[regtime]]', '[[regtime]]'),
(4157, 1, 0, 'account_history', 'heading_title', 'My Order History', '[[regtime]]', '[[regtime]]'),
(4158, 1, 0, 'account_history', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4159, 1, 0, 'account_history', 'text_history', 'Order History', '[[regtime]]', '[[regtime]]'),
(4160, 1, 0, 'account_history', 'text_order', 'Order ID:', '[[regtime]]', '[[regtime]]'),
(4161, 1, 0, 'account_history', 'text_status', 'Status:', '[[regtime]]', '[[regtime]]'),
(4162, 1, 0, 'account_history', 'text_date_added', 'Date Added:', '[[regtime]]', '[[regtime]]'),
(4163, 1, 0, 'account_history', 'text_customer', 'Customer:', '[[regtime]]', '[[regtime]]'),
(4164, 1, 0, 'account_history', 'text_products', 'Products:', '[[regtime]]', '[[regtime]]'),
(4165, 1, 0, 'account_history', 'text_total', 'Total:', '[[regtime]]', '[[regtime]]'),
(4166, 1, 0, 'account_history', 'text_error', 'You have not made any previous orders!', '[[regtime]]', '[[regtime]]'),
(4167, 1, 0, 'account_login', 'heading_title', 'Account Login', '[[regtime]]', '[[regtime]]'),
(4168, 1, 0, 'account_login', 'text_account', 'Register Account', '[[regtime]]', '[[regtime]]'),
(4169, 1, 0, 'account_login', 'text_login', 'Login', '[[regtime]]', '[[regtime]]'),
(4170, 1, 0, 'account_login', 'text_i_am_new_customer', 'I am a new customer.', '[[regtime]]', '[[regtime]]'),
(4171, 1, 0, 'account_login', 'text_checkout', 'Checkout Options:', '[[regtime]]', '[[regtime]]'),
(4172, 1, 0, 'account_login', 'text_guest', 'Guest Checkout', '[[regtime]]', '[[regtime]]'),
(4173, 1, 0, 'account_login', 'text_create_account', 'By creating an account you will be able to shop faster, be up to date on an order''s status, and keep track of the orders you have previously made.', '[[regtime]]', '[[regtime]]'),
(4174, 1, 0, 'account_login', 'text_returning_customer', 'Returning Customer', '[[regtime]]', '[[regtime]]'),
(4175, 1, 0, 'account_login', 'text_i_am_returning_customer', 'I am a returning customer.', '[[regtime]]', '[[regtime]]'),
(4176, 1, 0, 'account_login', 'text_forgotten_login', 'Forgot your login?', '[[regtime]]', '[[regtime]]'),
(4177, 1, 0, 'account_login', 'text_forgotten_password', 'Forgot your password?', '[[regtime]]', '[[regtime]]'),
(4178, 1, 0, 'account_login', 'entry_loginname', 'Login Name:', '[[regtime]]', '[[regtime]]'),
(4179, 1, 0, 'account_login', 'entry_email_address', 'E-Mail Address:', '[[regtime]]', '[[regtime]]'),
(4180, 1, 0, 'account_login', 'entry_password', 'Password:', '[[regtime]]', '[[regtime]]'),
(4181, 1, 0, 'account_login', 'error_login', 'Error: Incorrect login or password provided.', '[[regtime]]', '[[regtime]]'),
(4182, 1, 0, 'account_login', 'text_success_activated', 'Success: Your account was activated successfully. Please login with your credentials.', '[[regtime]]', '[[regtime]]'),
(4183, 1, 0, 'account_login', 'text_already_activated', 'Your account is already activated. Please login with your credentials.', '[[regtime]]', '[[regtime]]'),
(4184, 1, 0, 'account_login', 'text_resend_activation_email', 'Error: Your email address was not yet confirmed. To resend new confirmation email please click this <a href=" %s ">link</a>', '[[regtime]]', '[[regtime]]'),
(4185, 1, 0, 'account_logout', 'heading_title', 'Account Logout', '[[regtime]]', '[[regtime]]'),
(4186, 1, 0, 'account_logout', 'text_message', '<p>You have been logged off your account. It is now safe to leave the computer.</p><p>Your shopping cart has been saved, the items inside it will be restored whenever you log back into your account.</p>', '[[regtime]]', '[[regtime]]'),
(4187, 1, 0, 'account_logout', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4188, 1, 0, 'account_logout', 'text_logout', 'Logout', '[[regtime]]', '[[regtime]]'),
(4189, 1, 0, 'account_newsletter', 'heading_title', 'Newsletter Subscription', '[[regtime]]', '[[regtime]]'),
(4190, 1, 0, 'account_newsletter', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4191, 1, 0, 'account_newsletter', 'text_newsletter', 'Newsletter', '[[regtime]]', '[[regtime]]'),
(4192, 1, 0, 'account_newsletter', 'text_success', 'Success: Your newsletter subscription has been successfully updated!', '[[regtime]]', '[[regtime]]'),
(4193, 1, 0, 'account_newsletter', 'entry_newsletter', 'Subscribe:', '[[regtime]]', '[[regtime]]'),
(4194, 1, 0, 'account_newsletter', 'text_customer_registration', 'Customer Registration', '[[regtime]]', '[[regtime]]'),
(4195, 1, 0, 'account_newsletter', 'entry_captcha', 'Enter code: ', '[[regtime]]', '[[regtime]]'),
(4196, 1, 0, 'account_newsletter', 'error_captcha', 'Human verification has failed! Please try agan.', '[[regtime]]', '[[regtime]]'),
(4197, 1, 0, 'account_notification', 'heading_title', 'Notifications and Newsletter', '[[regtime]]', '[[regtime]]'),
(4198, 1, 0, 'account_notification', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4199, 1, 0, 'account_notification', 'text_notifications', 'Notifications', '[[regtime]]', '[[regtime]]'),
(4200, 1, 0, 'account_notification', 'text_success', 'Success: Your notification settings has been successfully updated!', '[[regtime]]', '[[regtime]]'),
(4201, 1, 0, 'account_notification', 'text_sendpoint', 'Notifications', '[[regtime]]', '[[regtime]]'),
(4202, 1, 0, 'account_order_details', 'heading_title', 'Order Details', '[[regtime]]', '[[regtime]]'),
(4203, 1, 0, 'account_order_details', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4204, 1, 0, 'account_order_details', 'text_history', 'Order History', '[[regtime]]', '[[regtime]]'),
(4205, 1, 0, 'account_order_details', 'text_invoice', 'Invoice', '[[regtime]]', '[[regtime]]'),
(4206, 1, 0, 'account_order_details', 'text_invoice_id', 'Invoice ID', '[[regtime]]', '[[regtime]]'),
(4207, 1, 0, 'account_order_details', 'text_order_id', 'Order ID', '[[regtime]]', '[[regtime]]'),
(4208, 1, 0, 'account_order_details', 'text_email', 'E-Mail', '[[regtime]]', '[[regtime]]'),
(4209, 1, 0, 'account_order_details', 'text_telephone', 'Telephone', '[[regtime]]', '[[regtime]]'),
(4210, 1, 0, 'account_order_details', 'text_mobile_phone', 'Mobile Phone:', '[[regtime]]', '[[regtime]]'),
(4211, 1, 0, 'account_order_details', 'text_fax', 'Fax', '[[regtime]]', '[[regtime]]'),
(4212, 1, 0, 'account_order_details', 'text_shipping_address', 'Shipping Address', '[[regtime]]', '[[regtime]]'),
(4213, 1, 0, 'account_order_details', 'text_shipping_method', 'Shipping Method', '[[regtime]]', '[[regtime]]'),
(4214, 1, 0, 'account_order_details', 'text_payment_address', 'Payment Address', '[[regtime]]', '[[regtime]]'),
(4215, 1, 0, 'account_order_details', 'text_payment_method', 'Payment Method', '[[regtime]]', '[[regtime]]'),
(4216, 1, 0, 'account_order_details', 'text_order_history', 'Order History', '[[regtime]]', '[[regtime]]'),
(4217, 1, 0, 'account_order_details', 'text_product', 'Product', '[[regtime]]', '[[regtime]]'),
(4218, 1, 0, 'account_order_details', 'text_model', 'Model', '[[regtime]]', '[[regtime]]'),
(4219, 1, 0, 'account_order_details', 'text_sku', 'SKU', '[[regtime]]', '[[regtime]]'),
(4220, 1, 0, 'account_order_details', 'text_quantity', 'Quantity', '[[regtime]]', '[[regtime]]'),
(4221, 1, 0, 'account_order_details', 'text_price', 'Unit Price', '[[regtime]]', '[[regtime]]'),
(4222, 1, 0, 'account_order_details', 'text_total', 'Total', '[[regtime]]', '[[regtime]]'),
(4223, 1, 0, 'account_order_details', 'text_comment', 'Order Comments', '[[regtime]]', '[[regtime]]'),
(4224, 1, 0, 'account_order_details', 'text_image', 'Image', '[[regtime]]', '[[regtime]]'),
(4225, 1, 0, 'account_order_details', 'text_error', 'The order you have requested could not be found!', '[[regtime]]', '[[regtime]]'),
(4226, 1, 0, 'account_order_details', 'column_date_added', 'Date Added', '[[regtime]]', '[[regtime]]'),
(4227, 1, 0, 'account_order_details', 'column_status', 'Status', '[[regtime]]', '[[regtime]]'),
(4228, 1, 0, 'account_order_details', 'column_comment', 'Customer''s order comment', '[[regtime]]', '[[regtime]]'),
(4229, 1, 0, 'account_order_details', 'text_order_cancelation', 'Request Cancellation of Order', '[[regtime]]', '[[regtime]]'),
(4230, 1, 0, 'account_order_details', 'text_request_cancellation_from_customer', 'Request an Order cancellation from Customer ', '[[regtime]]', '[[regtime]]'),
(4231, 1, 0, 'account_order_details', 'text_order_cancelation_confirm', 'Your cancellation request may not be made in some cases, for example, when the goods have been shipped. Continue?', '[[regtime]]', '[[regtime]]'),
(4232, 1, 0, 'account_order_details', 'text_order_cancelation_success', 'Order cancellation request has been submitted', '[[regtime]]', '[[regtime]]'),
(4233, 1, 0, 'account_order_details', 'text_order_cancelation_message_title', 'Order #%s cancellation request', '[[regtime]]', '[[regtime]]'),
(4234, 1, 0, 'account_order_details', 'text_order_cancelation_message_body', 'Customer %s has requested order cancellation for order #%s . To review go to %s', '[[regtime]]', '[[regtime]]'),
(4235, 1, 0, 'account_order_details', 'error_email', 'E-Mail Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(4236, 1, 0, 'account_order_details', 'error_order_id', 'Order ID is required field!', '[[regtime]]', '[[regtime]]'),
(4237, 1, 0, 'account_password', 'heading_title', 'Change Password', '[[regtime]]', '[[regtime]]'),
(4238, 1, 0, 'account_password', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4239, 1, 0, 'account_password', 'text_password', 'To update your password, please provide current and new password details', '[[regtime]]', '[[regtime]]'),
(4240, 1, 0, 'account_password', 'text_success', 'Success: Your password has been successfully updated.', '[[regtime]]', '[[regtime]]'),
(4241, 1, 0, 'account_password', 'entry_current_password', 'Current Password:', '[[regtime]]', '[[regtime]]'),
(4242, 1, 0, 'account_password', 'entry_password', 'New Password:', '[[regtime]]', '[[regtime]]'),
(4243, 1, 0, 'account_password', 'entry_confirm', 'New Password Confirm:', '[[regtime]]', '[[regtime]]'),
(4244, 1, 0, 'account_password', 'error_current_password', 'Your current password is incorrect! Please try again.', '[[regtime]]', '[[regtime]]'),
(4245, 1, 0, 'account_password', 'error_password', 'Password must be between 4 and 20 characters!', '[[regtime]]', '[[regtime]]'),
(4246, 1, 0, 'account_password', 'error_confirm', 'Password confirmation does not match password!', '[[regtime]]', '[[regtime]]'),
(4247, 1, 0, 'account_success', 'heading_title', 'Your Account Has Been Created!', '[[regtime]]', '[[regtime]]'),
(4248, 1, 0, 'account_success', 'text_message', '<p>Congratulations! Your new account has been successfully created!</p> <p>You can now take advantage of member privileges to enhance your online shopping experience with us.</p> <p>If you have ANY questions about the operation of this online shop, please email the store owner.</p> <p>A confirmation has been sent to the provided email address. If you have not received it within the hour, please <a href="%s">contact us</a>.</p>', '[[regtime]]', '[[regtime]]'),
(4249, 1, 0, 'account_success', 'text_approval', '<p>Thank you for registering with %s!</p><p>You will be notified by email once your account has been activated by the store owner.</p><p>If you have ANY questions about the operation of this online shop, please <a href="%s">contact the store owner</a>.</p>', '[[regtime]]', '[[regtime]]'),
(4250, 1, 0, 'account_success', 'heading_title_activation', 'Your Account Has Been Created But Activation Required. Please Follow instructions.', '[[regtime]]', '[[regtime]]'),
(4251, 1, 0, 'account_success', 'text_activate', '<p>Thank you for registering with %s!</p><p>You will be notified via email with your account activation instructions. You must click the link provided in the email to activate your account. If you do not receive email, please check in your junk or spam folders. </p><p>If you have ANY questions about the operation of this online shop, please <a href="%s">contact the store owner</a>.</p>', '[[regtime]]', '[[regtime]]'),
(4252, 1, 0, 'account_success', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4253, 1, 0, 'account_success', 'text_success', 'Success', '[[regtime]]', '[[regtime]]'),
(4254, 1, 0, 'account_transactions', 'heading_title', 'My Transactions', '[[regtime]]', '[[regtime]]'),
(4255, 1, 0, 'account_transactions', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4256, 1, 0, 'account_transactions', 'text_transactions', 'Transactions History', '[[regtime]]', '[[regtime]]'),
(4257, 1, 0, 'account_transactions', 'text_order', 'Order Number', '[[regtime]]', '[[regtime]]'),
(4258, 1, 0, 'account_transactions', 'text_transaction_id', 'ID', '[[regtime]]', '[[regtime]]'),
(4259, 1, 0, 'account_transactions', 'text_transaction_type', 'Type', '[[regtime]]', '[[regtime]]'),
(4260, 1, 0, 'account_transactions', 'text_transaction_description', 'Description', '[[regtime]]', '[[regtime]]'),
(4261, 1, 0, 'account_transactions', 'text_date_added', 'Date Created', '[[regtime]]', '[[regtime]]'),
(4262, 1, 0, 'account_transactions', 'text_debit', 'Debit', '[[regtime]]', '[[regtime]]'),
(4263, 1, 0, 'account_transactions', 'text_credit', 'Credit', '[[regtime]]', '[[regtime]]'),
(4264, 1, 0, 'account_transactions', 'text_total', 'Total', '[[regtime]]', '[[regtime]]'),
(4265, 1, 0, 'account_transactions', 'text_error', 'You have no transactions recorded on your account!', '[[regtime]]', '[[regtime]]'),
(4266, 1, 0, 'account_unsubscribe', 'heading_title', 'Your Has Been successfully unsubscribed !', '[[regtime]]', '[[regtime]]'),
(4267, 1, 0, 'account_unsubscribe', 'text_message', 'You have been successfully unsubscribed from email communications.', '[[regtime]]', '[[regtime]]'),
(4268, 1, 0, 'account_unsubscribe', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4269, 1, 0, 'account_unsubscribe', 'text_success', 'Success', '[[regtime]]', '[[regtime]]'),
(4270, 1, 0, 'account_wishlist', 'heading_title', 'My wish list', '[[regtime]]', '[[regtime]]'),
(4271, 1, 0, 'account_wishlist', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4272, 1, 0, 'account_wishlist', 'text_empty_wishlist', 'Wish list is empty', '[[regtime]]', '[[regtime]]'),
(4273, 1, 0, 'account_wishlist', 'button_cart', 'View Cart', '[[regtime]]', '[[regtime]]'),
(4274, 1, 0, 'account_wishlist', 'button_continue', 'Continue Shopping', '[[regtime]]', '[[regtime]]'),
(4275, 1, 0, 'account_wishlist', 'column_image', 'Image', '[[regtime]]', '[[regtime]]'),
(4276, 1, 0, 'account_wishlist', 'column_name', 'Name', '[[regtime]]', '[[regtime]]'),
(4277, 1, 0, 'account_wishlist', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(4278, 1, 0, 'account_wishlist', 'column_added', 'Added to wish list', '[[regtime]]', '[[regtime]]'),
(4279, 1, 0, 'account_wishlist', 'column_price', 'Unit Price', '[[regtime]]', '[[regtime]]'),
(4280, 1, 0, 'account_wishlist', 'column_actions', 'Actions', '[[regtime]]', '[[regtime]]'),
(4281, 1, 0, 'blocks_bestseller', 'heading_title', 'Bestsellers', '[[regtime]]', '[[regtime]]'),
(4282, 1, 0, 'blocks_bestseller', 'heading_subtitle', 'See Best Selling Products', '[[regtime]]', '[[regtime]]'),
(4283, 1, 0, 'blocks_bestseller', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4284, 1, 0, 'blocks_cart', 'heading_title', 'Shopping Cart', '[[regtime]]', '[[regtime]]'),
(4285, 1, 0, 'blocks_cart', 'text_subtotal', 'Sub-Total:', '[[regtime]]', '[[regtime]]'),
(4286, 1, 0, 'blocks_cart', 'text_empty', '0 items', '[[regtime]]', '[[regtime]]'),
(4287, 1, 0, 'blocks_cart', 'text_confirm', 'Confirm?', '[[regtime]]', '[[regtime]]'),
(4288, 1, 0, 'blocks_cart', 'text_remove', 'Remove', '[[regtime]]', '[[regtime]]'),
(4289, 1, 0, 'blocks_cart', 'text_view', 'View Cart', '[[regtime]]', '[[regtime]]'),
(4290, 1, 0, 'blocks_cart', 'text_checkout', 'Checkout', '[[regtime]]', '[[regtime]]'),
(4291, 1, 0, 'blocks_cart', 'text_items', 'Items', '[[regtime]]', '[[regtime]]'),
(4292, 1, 0, 'blocks_category', 'heading_title', 'Categories', '[[regtime]]', '[[regtime]]'),
(4293, 1, 0, 'blocks_content', 'heading_title', 'Information', '[[regtime]]', '[[regtime]]'),
(4294, 1, 0, 'blocks_content', 'text_contact', 'Contact Us', '[[regtime]]', '[[regtime]]'),
(4295, 1, 0, 'blocks_content', 'text_sitemap', 'Site Map', '[[regtime]]', '[[regtime]]'),
(4296, 1, 0, 'blocks_content', 'heading_title_new', 'New publications', '[[regtime]]', '[[regtime]]'),
(4297, 1, 0, 'blocks_currency', 'heading_title', 'Currency', '[[regtime]]', '[[regtime]]'),
(4298, 1, 0, 'blocks_featured', 'heading_title', 'Featured', '[[regtime]]', '[[regtime]]'),
(4299, 1, 0, 'blocks_featured', 'heading_subtitle', 'See Our Most featured Products', '[[regtime]]', '[[regtime]]'),
(4300, 1, 0, 'blocks_featured', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4301, 1, 0, 'blocks_language', 'heading_title', 'Language', '[[regtime]]', '[[regtime]]'),
(4302, 1, 0, 'blocks_latest', 'heading_title', 'Latest Products', '[[regtime]]', '[[regtime]]'),
(4303, 1, 0, 'blocks_latest', 'heading_subtitle', 'See New Products', '[[regtime]]', '[[regtime]]'),
(4304, 1, 0, 'blocks_latest', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4305, 1, 0, 'blocks_manufacturer', 'heading_title', 'Brands', '[[regtime]]', '[[regtime]]'),
(4306, 1, 0, 'blocks_menu', 'heading_title', 'Main Menu', '[[regtime]]', '[[regtime]]'),
(4307, 1, 0, 'blocks_newsletter_signup', 'heading_title', 'Newsletter Signup', '[[regtime]]', '[[regtime]]'),
(4308, 1, 0, 'blocks_newsletter_signup', 'text_signup', 'Sign up to Our Newsletter &amp; get attractive Offers by subscribing to our newsletters.', '[[regtime]]', '[[regtime]]'),
(4309, 1, 0, 'blocks_newsletter_signup', 'text_sign_in', 'Sign In', '[[regtime]]', '[[regtime]]'),
(4310, 1, 0, 'blocks_newsletter_signup', 'text_subscribe', 'Subscribe to Newsletter', '[[regtime]]', '[[regtime]]'),
(4311, 1, 0, 'blocks_newsletter_signup', 'button_subscribe', 'Subscribe', '[[regtime]]', '[[regtime]]'),
(4312, 1, 0, 'blocks_order_summary', 'heading_title', 'Order Summary', '[[regtime]]', '[[regtime]]'),
(4313, 1, 0, 'blocks_order_summary', 'text_subtotal', 'Sub-Total:', '[[regtime]]', '[[regtime]]'),
(4314, 1, 0, 'blocks_order_summary', 'text_empty', '0 items', '[[regtime]]', '[[regtime]]'),
(4315, 1, 0, 'blocks_order_summary', 'text_confirm', 'Confirm?', '[[regtime]]', '[[regtime]]'),
(4316, 1, 0, 'blocks_order_summary', 'text_remove', 'Remove', '[[regtime]]', '[[regtime]]'),
(4317, 1, 0, 'blocks_order_summary', 'text_view', 'View Cart', '[[regtime]]', '[[regtime]]'),
(4318, 1, 0, 'blocks_order_summary', 'text_checkout', 'Checkout', '[[regtime]]', '[[regtime]]'),
(4319, 1, 0, 'blocks_order_summary', 'text_items', 'Items', '[[regtime]]', '[[regtime]]'),
(4320, 1, 0, 'blocks_search', 'heading_title', 'Search', '[[regtime]]', '[[regtime]]'),
(4321, 1, 0, 'blocks_search', 'text_keyword', 'Search Keywords', '[[regtime]]', '[[regtime]]'),
(4322, 1, 0, 'blocks_search', 'text_advanced', 'Advanced Search', '[[regtime]]', '[[regtime]]'),
(4323, 1, 0, 'blocks_search', 'text_category', 'All Categories', '[[regtime]]', '[[regtime]]'),
(4324, 1, 0, 'blocks_special', 'heading_title', 'Specials', '[[regtime]]', '[[regtime]]'),
(4325, 1, 0, 'blocks_special', 'heading_subtitle', 'See Products On Sale', '[[regtime]]', '[[regtime]]'),
(4326, 1, 0, 'blocks_special', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4327, 1, 0, 'blocks_store_hours', 'heading_title', 'Store Hours', '[[regtime]]', '[[regtime]]'),
(4328, 1, 0, 'blocks_store_hours', 'closed', 'Closed', '[[regtime]]', '[[regtime]]'),
(4329, 1, 0, 'blocks_store_hours', 'open', 'Open', '[[regtime]]', '[[regtime]]'),
(4330, 1, 0, 'blocks_store_hours', 'sunday', 'Sunday', '[[regtime]]', '[[regtime]]'),
(4331, 1, 0, 'blocks_store_hours', 'monday', 'Monday', '[[regtime]]', '[[regtime]]'),
(4332, 1, 0, 'blocks_store_hours', 'tuesday', 'Tuesday', '[[regtime]]', '[[regtime]]'),
(4333, 1, 0, 'blocks_store_hours', 'wednesday', 'Wednesday', '[[regtime]]', '[[regtime]]'),
(4334, 1, 0, 'blocks_store_hours', 'thursday', 'Thursday', '[[regtime]]', '[[regtime]]'),
(4335, 1, 0, 'blocks_store_hours', 'friday', 'Friday', '[[regtime]]', '[[regtime]]'),
(4336, 1, 0, 'blocks_store_hours', 'saturday', 'Saturday', '[[regtime]]', '[[regtime]]'),
(4337, 1, 0, 'blocks_viewed', 'text_recently_viewed', 'Recently Viewed', '[[regtime]]', '[[regtime]]'),
(4338, 1, 0, 'checkout_cart', 'heading_title', 'Shopping Cart', '[[regtime]]', '[[regtime]]'),
(4339, 1, 0, 'checkout_cart', 'text_basket', 'Cart', '[[regtime]]', '[[regtime]]'),
(4340, 1, 0, 'checkout_cart', 'text_sub_total', 'Sub-Total:', '[[regtime]]', '[[regtime]]'),
(4341, 1, 0, 'checkout_cart', 'text_weight', 'Cart Weight:', '[[regtime]]', '[[regtime]]'),
(4342, 1, 0, 'checkout_cart', 'text_error', 'Your shopping cart is empty!', '[[regtime]]', '[[regtime]]'),
(4343, 1, 0, 'checkout_cart', 'column_remove', 'Remove', '[[regtime]]', '[[regtime]]'),
(4344, 1, 0, 'checkout_cart', 'column_image', 'Image', '[[regtime]]', '[[regtime]]'),
(4345, 1, 0, 'checkout_cart', 'column_name', 'Name', '[[regtime]]', '[[regtime]]'),
(4346, 1, 0, 'checkout_cart', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(4347, 1, 0, 'checkout_cart', 'column_sku', 'SKU', '[[regtime]]', '[[regtime]]'),
(4348, 1, 0, 'checkout_cart', 'column_quantity', 'Quantity', '[[regtime]]', '[[regtime]]'),
(4349, 1, 0, 'checkout_cart', 'column_price', 'Unit Price', '[[regtime]]', '[[regtime]]'),
(4350, 1, 0, 'checkout_cart', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(4351, 1, 0, 'checkout_cart', 'text_continue_shopping', 'Continue Shopping', '[[regtime]]', '[[regtime]]'),
(4352, 1, 0, 'checkout_cart', 'text_coupon_codes', 'Apply Coupon Code', '[[regtime]]', '[[regtime]]'),
(4353, 1, 0, 'checkout_cart', 'text_estimate_shipping_tax', 'Estimate Shipping & Taxes', '[[regtime]]', '[[regtime]]'),
(4354, 1, 0, 'checkout_cart', 'text_estimate_country', 'Country and State', '[[regtime]]', '[[regtime]]'),
(4355, 1, 0, 'checkout_cart', 'text_estimate_postcode', 'ZIP/Post Code', '[[regtime]]', '[[regtime]]'),
(4356, 1, 0, 'checkout_cart', 'button_text_estimate', 'Estimate', '[[regtime]]', '[[regtime]]'),
(4357, 1, 0, 'checkout_cart', 'text_estimate_shipments', 'Shipments', '[[regtime]]', '[[regtime]]'),
(4358, 1, 0, 'checkout_cart', 'error_coupon', 'Error: Coupon is either invalid, expired or reached it''s usage limit!', '[[regtime]]', '[[regtime]]'),
(4359, 1, 0, 'checkout_cart', 'error_stock', 'Products marked with *** are not available in the desired quantity or out of stock!', '[[regtime]]', '[[regtime]]'),
(4360, 1, 0, 'checkout_cart', 'error_required_options', 'Please select all required options!', '[[regtime]]', '[[regtime]]'),
(4361, 1, 0, 'checkout_cart', 'error_order_minimum', 'Your order sub-total amount does not meet minimum amount of %s required. Please add more products to your cart!', '[[regtime]]', '[[regtime]]'),
(4362, 1, 0, 'checkout_cart', 'error_order_maximum', 'Your order sub-total amount exceeds maximum amount of %s allowed per order. Please remove some items from your cart!', '[[regtime]]', '[[regtime]]'),
(4363, 1, 0, 'checkout_cart', 'error_empty_file_data', 'File data is corrupted or empty.', '[[regtime]]', '[[regtime]]'),
(4364, 1, 0, 'checkout_cart', 'error_empty_file_name', 'File name is empty!', '[[regtime]]', '[[regtime]]'),
(4365, 1, 0, 'checkout_cart', 'error_file_extension', 'Only files with extension(s) %s is(are) allowed!', '[[regtime]]', '[[regtime]]'),
(4366, 1, 0, 'checkout_cart', 'error_min_file_size', 'Minimum file size for upload is %s Kb.', '[[regtime]]', '[[regtime]]'),
(4367, 1, 0, 'checkout_cart', 'error_max_file_size', 'Maximum file size for upload is %s Kb.', '[[regtime]]', '[[regtime]]'),
(4368, 1, 0, 'checkout_cart', 'text_coupon_success', 'Success: Your coupon discount has been applied!', '[[regtime]]', '[[regtime]]'),
(4369, 1, 0, 'checkout_cart', 'text_coupon_removal', 'Success: Coupon has been removed!', '[[regtime]]', '[[regtime]]'),
(4370, 1, 0, 'checkout_cart', 'error_quantity_maximum', 'Allowed product''s quantity exceeds. Quantity was set to maximum.', '[[regtime]]', '[[regtime]]'),
(4371, 1, 0, 'checkout_cart', 'error_quantity_minimum', 'Allowed product''s quantity is below minimum required. Quantity was set to minimum amount.', '[[regtime]]', '[[regtime]]'),
(4372, 1, 0, 'checkout_fast_checkout', 'text_basket', 'Cart', '[[regtime]]', '[[regtime]]'),
(4373, 1, 0, 'checkout_fast_checkout', 'text_edit_basket', 'Edit Cart', '[[regtime]]', '[[regtime]]'),
(4374, 1, 0, 'checkout_fast_checkout', 'text_accept_agree', 'By clicking Confirm Order, you accept and agree to all terms of', '[[regtime]]', '[[regtime]]'),
(4375, 1, 0, 'checkout_fast_checkout', 'text_cart_items', 'Items in your cart', '[[regtime]]', '[[regtime]]'),
(4376, 1, 0, 'checkout_fast_checkout', 'text_shipping', 'Shipping ', '[[regtime]]', '[[regtime]]'),
(4377, 1, 0, 'checkout_fast_checkout', 'text_edit_shipping', 'Edit Shipping', '[[regtime]]', '[[regtime]]'),
(4378, 1, 0, 'checkout_fast_checkout', 'text_payment', 'Payment', '[[regtime]]', '[[regtime]]'),
(4379, 1, 0, 'checkout_fast_checkout', 'text_edit_payment', 'Edit Payment', '[[regtime]]', '[[regtime]]'),
(4380, 1, 0, 'checkout_fast_checkout', 'text_confirm', 'Confirm', '[[regtime]]', '[[regtime]]'),
(4381, 1, 0, 'checkout_fast_checkout', 'text_shipping_address', 'Shipping Address', '[[regtime]]', '[[regtime]]'),
(4382, 1, 0, 'checkout_fast_checkout', 'text_shipping_method', 'Shipping Method', '[[regtime]]', '[[regtime]]'),
(4383, 1, 0, 'checkout_fast_checkout', 'text_payment_address', 'Payment Address', '[[regtime]]', '[[regtime]]'),
(4384, 1, 0, 'checkout_fast_checkout', 'text_payment_method', 'Payment Method', '[[regtime]]', '[[regtime]]'),
(4385, 1, 0, 'checkout_fast_checkout', 'text_change', 'Change', '[[regtime]]', '[[regtime]]'),
(4386, 1, 0, 'checkout_fast_checkout', 'text_comment', 'Your Comments', '[[regtime]]', '[[regtime]]'),
(4387, 1, 0, 'checkout_fast_checkout', 'text_discount', 'Discount Coupon', '[[regtime]]', '[[regtime]]'),
(4388, 1, 0, 'checkout_fast_checkout', 'column_product', 'Product', '[[regtime]]', '[[regtime]]'),
(4389, 1, 0, 'checkout_fast_checkout', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(4390, 1, 0, 'checkout_fast_checkout', 'column_quantity', 'Quantity', '[[regtime]]', '[[regtime]]'),
(4391, 1, 0, 'checkout_fast_checkout', 'column_price', 'Price', '[[regtime]]', '[[regtime]]'),
(4392, 1, 0, 'checkout_fast_checkout', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(4393, 1, 0, 'checkout_fast_checkout', 'text_add_coupon', 'Edit Coupon', '[[regtime]]', '[[regtime]]'),
(4394, 1, 0, 'checkout_fast_checkout', 'fast_checkout_name', 'Fast Checkout', '[[regtime]]', '[[regtime]]'),
(4395, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_fast_checkout_title', 'Fast Checkout', '[[regtime]]', '[[regtime]]'),
(4396, 1, 0, 'checkout_fast_checkout', 'heading_title', 'Fast Checkout', '[[regtime]]', '[[regtime]]'),
(4397, 1, 0, 'checkout_fast_checkout', 'fast_checkout_buy_now', 'Buy Now', '[[regtime]]', '[[regtime]]'),
(4398, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_incorrect_request', 'Oops! Incorrect request.', '[[regtime]]', '[[regtime]]'),
(4399, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_handler', 'Unable to locate payment handler! Please check files %s or %s', '[[regtime]]', '[[regtime]]'),
(4400, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_no_handler', 'No payment processor available.', '[[regtime]]', '[[regtime]]'),
(4401, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_unknown_payment', 'Unknown payment!', '[[regtime]]', '[[regtime]]'),
(4402, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_unexpected', 'Unexpected error has occurred! Please try again.', '[[regtime]]', '[[regtime]]'),
(4403, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_unexpected_log', 'Unexpected error has occurred. Unable to build order data based on array: %s', '[[regtime]]', '[[regtime]]'),
(4404, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_handler_object', 'Unable to confirm order. Payment handler is not object.', '[[regtime]]', '[[regtime]]'),
(4405, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_system_issue', 'Oops! System issue. Contact site administrator.', '[[regtime]]', '[[regtime]]'),
(4406, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_no_payment', 'No payments are available.', '[[regtime]]', '[[regtime]]'),
(4407, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_product_option', 'Product option error. %s', '[[regtime]]', '[[regtime]]'),
(4408, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_no_address', 'No addresses found in your account! Please add an address in your account.', '[[regtime]]', '[[regtime]]'),
(4409, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_low_balance', 'You do not have sufficient account balance for this order!', '[[regtime]]', '[[regtime]]'),
(4410, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_balance_pay', 'There is a issue processing account credit payment! Please try again.', '[[regtime]]', '[[regtime]]'),
(4411, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_payment_address', 'Payment address is missing or not selected.', '[[regtime]]', '[[regtime]]'),
(4412, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_payment_unavailable', 'Payment is not available in your location.', '[[regtime]]', '[[regtime]]'),
(4413, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_shipping_address', 'Delivery address is missing or not selected.', '[[regtime]]', '[[regtime]]'),
(4414, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_shipping_method', 'Delivery method was not selected.', '[[regtime]]', '[[regtime]]'),
(4415, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_phone', 'Your contact phone number is not provided.', '[[regtime]]', '[[regtime]]'),
(4416, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_owner', 'Your name is not provided.', '[[regtime]]', '[[regtime]]'),
(4417, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_email', 'Your email is not provided or invalid.', '[[regtime]]', '[[regtime]]'),
(4418, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_card_number', 'Credit card number is not provided.', '[[regtime]]', '[[regtime]]'),
(4419, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_cvv', 'CVV number is not provided.', '[[regtime]]', '[[regtime]]'),
(4420, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_expire', 'Credit cart expiration date is not provided or invalid.', '[[regtime]]', '[[regtime]]'),
(4421, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_balance_apply', 'Credit cart expiration date is not provided or invalid.', '[[regtime]]', '[[regtime]]'),
(4422, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_account_created', 'Account has been created and login instruction sent to your email.', '[[regtime]]', '[[regtime]]'),
(4423, 1, 0, 'checkout_fast_checkout', 'fast_checkout_mail_login_password', 'Your Login Name: %s <br>Your Password: %s', '[[regtime]]', '[[regtime]]'),
(4424, 1, 0, 'checkout_fast_checkout', 'fast_checkout_order_success_message', 'Success! Your order has been successfully created!', '[[regtime]]', '[[regtime]]'),
(4425, 1, 0, 'checkout_fast_checkout', 'fast_checkout_order_processing_message', 'Success! Order now processing!', '[[regtime]]', '[[regtime]]'),
(4426, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_payment_address', 'Payment Address', '[[regtime]]', '[[regtime]]'),
(4427, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_shipping_address', 'Delivery Address', '[[regtime]]', '[[regtime]]'),
(4428, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_select_shipping_method', 'Choose a delivery method', '[[regtime]]', '[[regtime]]'),
(4429, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_pay_with', 'Pay With:', '[[regtime]]', '[[regtime]]'),
(4430, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_credit_card', 'Credit Card', '[[regtime]]', '[[regtime]]'),
(4431, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_account_credit', 'Account Credit (%s)', '[[regtime]]', '[[regtime]]'),
(4432, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_pay', 'Pay', '[[regtime]]', '[[regtime]]'),
(4433, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_enter_cc_details', 'Enter Credit Card details below', '[[regtime]]', '[[regtime]]'),
(4434, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_your_balance', 'Your account credit balance is', '[[regtime]]', '[[regtime]]'),
(4435, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_pay_from_balance', 'Pay %s with credit', '[[regtime]]', '[[regtime]]'),
(4436, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_telephone_placeholder', 'Contact telephone Number Ex. +1.212.555.5555', '[[regtime]]', '[[regtime]]'),
(4437, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_same_as_shipping_address', 'Same for delivery', '[[regtime]]', '[[regtime]]'),
(4438, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_enter_address', 'Continue', '[[regtime]]', '[[regtime]]'),
(4439, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_card_number', 'Card number', '[[regtime]]', '[[regtime]]'),
(4440, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_bill_me_monthly', 'Bill me monthly', '[[regtime]]', '[[regtime]]'),
(4441, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_create_account', 'Create account', '[[regtime]]', '[[regtime]]'),
(4442, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_please_login', 'Please Login with details below', '[[regtime]]', '[[regtime]]'),
(4443, 1, 0, 'checkout_fast_checkout', 'fast_checkout_button_login', 'LOGIN', '[[regtime]]', '[[regtime]]'),
(4444, 1, 0, 'checkout_fast_checkout', 'fast_checkout_button_reset_login', 'Register / Reset login', '[[regtime]]', '[[regtime]]'),
(4445, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_login', 'Login', '[[regtime]]', '[[regtime]]'),
(4446, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_logout', 'Logout', '[[regtime]]', '[[regtime]]'),
(4447, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_address', 'Address', '[[regtime]]', '[[regtime]]'),
(4448, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_new_customer', 'I am new customer', '[[regtime]]', '[[regtime]]'),
(4449, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_loading', 'Loading...', '[[regtime]]', '[[regtime]]'),
(4450, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_order_is_completed', 'Order is completed!', '[[regtime]]', '[[regtime]]'),
(4451, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_thank_you', 'Thank you for your order!', '[[regtime]]', '[[regtime]]'),
(4452, 1, 0, 'checkout_fast_checkout', 'fast_checkout_button_start_download', 'Start Download', '[[regtime]]', '[[regtime]]'),
(4453, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_order_downloads', 'Order Downloads', '[[regtime]]', '[[regtime]]'),
(4454, 1, 0, 'checkout_fast_checkout', 'fast_checkout_button_order_details', 'Order Details', '[[regtime]]', '[[regtime]]'),
(4455, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_select_delivery', 'Please select the delivery options', '[[regtime]]', '[[regtime]]'),
(4456, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_select_payment', 'Please select the payment option', '[[regtime]]', '[[regtime]]'),
(4457, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_order_download_pending', 'Product download in your order is not yet available. Please wait for order verification!', '[[regtime]]', '[[regtime]]'),
(4458, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_info_duplicate_order', 'It looks like you just placed a different order. <a href="%s">See order details</a>', '[[regtime]]', '[[regtime]]'),
(4459, 1, 0, 'checkout_fast_checkout', 'fast_checkout_email_start_download', 'You can access your download(s) with the link below.', '[[regtime]]', '[[regtime]]'),
(4460, 1, 0, 'checkout_fast_checkout', 'fast_checkout_email_order_downloads', 'You can access order downloads with the link below.', '[[regtime]]', '[[regtime]]'),
(4461, 1, 0, 'checkout_fast_checkout', 'fast_checkout_download_subject', 'Your order download.', '[[regtime]]', '[[regtime]]'),
(4462, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_apply', 'Apply', '[[regtime]]', '[[regtime]]'),
(4463, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_remove', 'Remove', '[[regtime]]', '[[regtime]]'),
(4464, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_coupon_code', 'Enter coupon code', '[[regtime]]', '[[regtime]]'),
(4465, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_order_comment', 'Add the order comment', '[[regtime]]', '[[regtime]]'),
(4466, 1, 0, 'checkout_fast_checkout', 'fast_checkout_error_coupon', 'Coupon is invalid or expired!', '[[regtime]]', '[[regtime]]'),
(4467, 1, 0, 'checkout_fast_checkout', 'fast_checkout_back_to_cart', 'Back to Cart', '[[regtime]]', '[[regtime]]'),
(4468, 1, 0, 'checkout_fast_checkout', 'fast_checkout_order_summary', 'Order Summary', '[[regtime]]', '[[regtime]]'),
(4469, 1, 0, 'checkout_fast_checkout', 'fast_checkout_no_shipments_available', 'No shipments are available.', '[[regtime]]', '[[regtime]]'),
(4470, 1, 0, 'checkout_fast_checkout', 'fast_checkout_telephone_placeholder', 'Your phone number', '[[regtime]]', '[[regtime]]'),
(4471, 1, 0, 'checkout_fast_checkout', 'fast_checkout_email_placeholder', 'Your email', '[[regtime]]', '[[regtime]]'),
(4472, 1, 0, 'checkout_fast_checkout', 'button_history', 'History', '[[regtime]]', '[[regtime]]'),
(4473, 1, 0, 'checkout_fast_checkout', 'error_postcode', 'Postcode incorrect', '[[regtime]]', '[[regtime]]'),
(4474, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_comment_placeholder', 'Add an order comment', '[[regtime]]', '[[regtime]]'),
(4475, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_not_enough_stock', 'Not Enough Stock', '[[regtime]]', '[[regtime]]'),
(4476, 1, 0, 'checkout_fast_checkout', 'order_confirm', 'Order Confirm', '[[regtime]]', '[[regtime]]'),
(4477, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_login_or_email', 'Login name or Email Address', '[[regtime]]', '[[regtime]]'),
(4478, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_password', 'Password', '[[regtime]]', '[[regtime]]'),
(4479, 1, 0, 'checkout_fast_checkout', 'fast_checkout_text_authenticating', 'Authenticating ... ', '[[regtime]]', '[[regtime]]'),
(4480, 1, 0, 'checkout_fast_checkout', 'text_message_account', '<p>Your order #%s has been created!</p>\n			<p>You can view your order details by going to the <a href="%s">invoice page</a>.</p>\n			<p>Please direct any questions you have to the <a href="%s">store owner</a>.</p>\n			<p>Thank you for shopping with us!</p>', '[[regtime]]', '[[regtime]]'),
(4481, 1, 0, 'checkout_fast_checkout', 'text_message_guest', '<p>Your order has been successfully processed!</p>\n			<p>You can view your order details by going to the <a href="%s">invoice page</a>.</p>\n			<p>Please direct any questions you have to the <a href="%s">store owner</a>.</p>\n			<p>Thank you for shopping with us!</p>', '[[regtime]]', '[[regtime]]'),
(4482, 1, 0, 'checkout_fast_checkout', 'text_guest', 'Guest Checkout', '[[regtime]]', '[[regtime]]'),
(4483, 1, 0, 'checkout_fast_checkout', 'text_success', 'Success', '[[regtime]]', '[[regtime]]'),
(4484, 1, 0, 'checkout_fast_checkout', 'text_message_failed_order', 'Oops! We have experienced some issue with your transaction. Your order will be verified manually by administrator.', '[[regtime]]', '[[regtime]]'),
(4485, 1, 0, 'checkout_fast_checkout', 'text_title_failed_order_to_admin', 'Failed order #%s', '[[regtime]]', '[[regtime]]'),
(4486, 1, 0, 'checkout_fast_checkout', 'text_message_failed_order_to_admin', 'Failed or missing response from payment verification. Manual verification is required!', '[[regtime]]', '[[regtime]]'),
(4487, 1, 0, 'common_footer', 'text_powered_by', 'Powered By ', '[[regtime]]', '[[regtime]]'),
(4488, 1, 0, 'common_header', 'text_home', 'Home', '[[regtime]]', '[[regtime]]'),
(4489, 1, 0, 'common_header', 'text_special', 'Special Offers', '[[regtime]]', '[[regtime]]'),
(4490, 1, 0, 'common_header', 'text_contact', 'Contact', '[[regtime]]', '[[regtime]]'),
(4491, 1, 0, 'common_header', 'text_sitemap', 'Sitemap', '[[regtime]]', '[[regtime]]'),
(4492, 1, 0, 'common_header', 'text_bookmark', 'Bookmark', '[[regtime]]', '[[regtime]]'),
(4493, 1, 0, 'common_header', 'text_account', 'Account', '[[regtime]]', '[[regtime]]'),
(4494, 1, 0, 'common_header', 'text_login', 'Login', '[[regtime]]', '[[regtime]]'),
(4495, 1, 0, 'common_header', 'text_logout', 'Logoff', '[[regtime]]', '[[regtime]]'),
(4496, 1, 0, 'common_header', 'text_cart', 'Cart', '[[regtime]]', '[[regtime]]'),
(4497, 1, 0, 'common_header', 'text_checkout', 'Checkout', '[[regtime]]', '[[regtime]]'),
(4498, 1, 0, 'common_header', 'text_keyword', 'Keywords', '[[regtime]]', '[[regtime]]'),
(4499, 1, 0, 'common_header', 'text_advanced', 'Advanced Search', '[[regtime]]', '[[regtime]]'),
(4500, 1, 0, 'common_header', 'text_category', 'All Categories', '[[regtime]]', '[[regtime]]'),
(4501, 1, 0, 'common_header', 'entry_search', 'Search:', '[[regtime]]', '[[regtime]]'),
(4502, 1, 0, 'common_header', 'text_welcome', 'Welcome back', '[[regtime]]', '[[regtime]]'),
(4503, 1, 0, 'common_header', 'text_not', 'Not', '[[regtime]]', '[[regtime]]'),
(4504, 1, 0, 'common_header', 'text_login_or_register', 'Login or register', '[[regtime]]', '[[regtime]]'),
(4505, 1, 0, 'common_im', 'im_text_notification', ' Notification ', '[[regtime]]', '[[regtime]]'),
(4506, 1, 0, 'common_im', 'im_error_mail_address', ' Email Address %s is not valid! ', '[[regtime]]', '[[regtime]]'),
(4507, 1, 0, 'common_im', 'im_protocol_email_title', ' E-mail ', '[[regtime]]', '[[regtime]]'),
(4508, 1, 0, 'common_im', 'im_protocol_sms_title', ' SMS ', '[[regtime]]', '[[regtime]]'),
(4509, 1, 0, 'common_im', 'im_protocol_sms_empty_warn', ' SMS notifications are not possible. Mobile number is not saved in your account records. ', '[[regtime]]', '[[regtime]]');
INSERT INTO `[[dbprefix]]language_definitions` VALUES
(4510, 1, 0, 'common_im', 'im_sendpoint_name_order_update', ' Order Update ', '[[regtime]]', '[[regtime]]'),
(4511, 1, 0, 'common_im', 'im_sendpoint_name_order_update_note', ' Select to receive notifications about your orders'' updates.', '[[regtime]]', '[[regtime]]'),
(4512, 1, 0, 'common_im', 'im_order_update_text_to_admin', ' Order #%s has been updated! Order status ID %s', '[[regtime]]', '[[regtime]]'),
(4513, 1, 0, 'common_im', 'im_order_update_text_to_customer', ' Your order #%s Updated. New Order Status is %s ', '[[regtime]]', '[[regtime]]'),
(4514, 1, 0, 'common_im', 'im_new_order_text_to_admin', ' New Order #%s has been placed!', '[[regtime]]', '[[regtime]]'),
(4515, 1, 0, 'common_im', 'im_new_customer_text_to_admin', ' New Customer #%s %s has been registered!', '[[regtime]]', '[[regtime]]'),
(4516, 1, 0, 'common_im', 'im_new_subscriber_text_to_admin', ' New Subscriber #%s %s has been registered!', '[[regtime]]', '[[regtime]]'),
(4517, 1, 0, 'common_im', 'im_sendpoint_name_customer_account_update', ' Account Update ', '[[regtime]]', '[[regtime]]'),
(4518, 1, 0, 'common_im', 'im_sendpoint_name_customer_account_update_note', ' Select to receive notifications about your account updates.', '[[regtime]]', '[[regtime]]'),
(4519, 1, 0, 'common_im', 'im_customer_account_update_text_to_customer', ' Your account has been updated! If you did not do any changes, please contact site owner ', '[[regtime]]', '[[regtime]]'),
(4520, 1, 0, 'common_im', 'im_customer_account_update_email_to_customer', ' Your account email address was changed to %s! If you did not do this change, please contact site owner ', '[[regtime]]', '[[regtime]]'),
(4521, 1, 0, 'common_im', 'im_customer_account_update_login_to_customer', ' Your account login name was changed to %s! If you did not do this change, please contact site owner ', '[[regtime]]', '[[regtime]]'),
(4522, 1, 0, 'common_im', 'im_customer_account_update_password_to_customer', ' Your account password has been changed! If you did not do this change, please contact site owner ', '[[regtime]]', '[[regtime]]'),
(4523, 1, 0, 'common_im', 'im_customer_contact_admin_text', ' You''ve got new enquiry from customer (%s, %s)! ', '[[regtime]]', '[[regtime]]'),
(4524, 1, 0, 'common_im', 'im_sendpoint_name_newsletter', ' Newsletters ', '[[regtime]]', '[[regtime]]'),
(4525, 1, 0, 'common_im', 'im_sendpoint_name_newsletter_note', ' Select to receive notifications about our products and service updates.', '[[regtime]]', '[[regtime]]'),
(4526, 1, 0, 'common_im', 'im_product_review_text_to_admin', ' New product review has been added. See details #admin#rt=catalog/review/update&review_id=%s ', '[[regtime]]', '[[regtime]]'),
(4527, 1, 0, 'common_im', 'im_product_out_of_stock_admin_text', ' Product with ID #%s is out of Stock. ', '[[regtime]]', '[[regtime]]'),
(4528, 1, 0, 'common_template_debug', 'text_block_id', 'Block ID:', '[[regtime]]', '[[regtime]]'),
(4529, 1, 0, 'common_template_debug', 'text_block_name', 'Name:', '[[regtime]]', '[[regtime]]'),
(4530, 1, 0, 'common_template_debug', 'text_block_controller', 'Controller:', '[[regtime]]', '[[regtime]]'),
(4531, 1, 0, 'common_template_debug', 'text_block_path', 'Path:', '[[regtime]]', '[[regtime]]'),
(4532, 1, 0, 'common_template_debug', 'text_block_template', 'Template:', '[[regtime]]', '[[regtime]]'),
(4533, 1, 0, 'common_template_debug', 'text_block_parent', 'Parent:', '[[regtime]]', '[[regtime]]'),
(4534, 1, 0, 'common_template_debug', 'text_parent_id', 'Parent ID:', '[[regtime]]', '[[regtime]]'),
(4535, 1, 0, 'common_template_debug', 'text_close', 'Close', '[[regtime]]', '[[regtime]]'),
(4536, 1, 0, 'common_template_debug', 'text_click', 'Click Me', '[[regtime]]', '[[regtime]]'),
(4537, 1, 0, 'content_contact', 'heading_title', 'Contact Us', '[[regtime]]', '[[regtime]]'),
(4538, 1, 0, 'content_contact', 'text_address', 'Address:', '[[regtime]]', '[[regtime]]'),
(4539, 1, 0, 'content_contact', 'text_email', 'E-Mail:', '[[regtime]]', '[[regtime]]'),
(4540, 1, 0, 'content_contact', 'text_telephone', 'Telephone:', '[[regtime]]', '[[regtime]]'),
(4541, 1, 0, 'content_contact', 'text_fax', 'Fax:', '[[regtime]]', '[[regtime]]'),
(4542, 1, 0, 'content_contact', 'text_message', '<p>Your enquiry has been successfully sent to the store owner!</p>', '[[regtime]]', '[[regtime]]'),
(4543, 1, 0, 'content_contact', 'entry_name', 'First Name:', '[[regtime]]', '[[regtime]]'),
(4544, 1, 0, 'content_contact', 'entry_email', 'E-Mail Address:', '[[regtime]]', '[[regtime]]'),
(4545, 1, 0, 'content_contact', 'entry_enquiry', 'Enquiry:', '[[regtime]]', '[[regtime]]'),
(4546, 1, 0, 'content_contact', 'entry_captcha', 'Enter the code in the box below:', '[[regtime]]', '[[regtime]]'),
(4547, 1, 0, 'content_contact', 'email_subject', 'Enquiry from %s', '[[regtime]]', '[[regtime]]'),
(4548, 1, 0, 'content_contact', 'error_name', 'Name must be between 3 and 32 characters!', '[[regtime]]', '[[regtime]]'),
(4549, 1, 0, 'content_contact', 'error_email', 'E-Mail Address does not appear to be valid!', '[[regtime]]', '[[regtime]]'),
(4550, 1, 0, 'content_contact', 'error_enquiry', 'Enquiry must be between 10 and 3000 characters!', '[[regtime]]', '[[regtime]]'),
(4551, 1, 0, 'content_contact', 'entry_duplicate_message_subject', 'New Enquiry From %s (%s)', '[[regtime]]', '[[regtime]]'),
(4552, 1, 0, 'content_content', 'heading_title', 'Content pages', '[[regtime]]', '[[regtime]]'),
(4553, 1, 0, 'content_content', 'text_author', 'Author:', '[[regtime]]', '[[regtime]]'),
(4554, 1, 0, 'content_content', 'text_published', 'Published:', '[[regtime]]', '[[regtime]]'),
(4555, 1, 0, 'content_content', 'text_sort', 'Sort By:', '[[regtime]]', '[[regtime]]'),
(4556, 1, 0, 'content_content', 'text_new', 'NEW', '[[regtime]]', '[[regtime]]'),
(4557, 1, 0, 'content_content', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(4558, 1, 0, 'content_content', 'content_not_found', 'No content found. Try again.', '[[regtime]]', '[[regtime]]'),
(4559, 1, 0, 'content_content', 'text_error', 'Information Page Not Found!', '[[regtime]]', '[[regtime]]'),
(4560, 1, 0, 'content_sitemap', 'heading_title', 'Site Map', '[[regtime]]', '[[regtime]]'),
(4561, 1, 0, 'content_sitemap', 'text_special', 'Special Offers', '[[regtime]]', '[[regtime]]'),
(4562, 1, 0, 'content_sitemap', 'text_account', 'My Account', '[[regtime]]', '[[regtime]]'),
(4563, 1, 0, 'content_sitemap', 'text_edit', 'Account Information', '[[regtime]]', '[[regtime]]'),
(4564, 1, 0, 'content_sitemap', 'text_password', 'Password', '[[regtime]]', '[[regtime]]'),
(4565, 1, 0, 'content_sitemap', 'text_address', 'Address Book', '[[regtime]]', '[[regtime]]'),
(4566, 1, 0, 'content_sitemap', 'text_history', 'Order History', '[[regtime]]', '[[regtime]]'),
(4567, 1, 0, 'content_sitemap', 'text_download', 'Downloads', '[[regtime]]', '[[regtime]]'),
(4568, 1, 0, 'content_sitemap', 'text_cart', 'Shopping Cart', '[[regtime]]', '[[regtime]]'),
(4569, 1, 0, 'content_sitemap', 'text_checkout', 'Checkout', '[[regtime]]', '[[regtime]]'),
(4570, 1, 0, 'content_sitemap', 'text_search', 'Search', '[[regtime]]', '[[regtime]]'),
(4571, 1, 0, 'content_sitemap', 'text_information', 'Information', '[[regtime]]', '[[regtime]]'),
(4572, 1, 0, 'content_sitemap', 'text_contact', 'Contact Us', '[[regtime]]', '[[regtime]]'),
(4573, 1, 0, 'english', 'code', 'en', '[[regtime]]', '[[regtime]]'),
(4574, 1, 0, 'english', 'direction', 'ltr', '[[regtime]]', '[[regtime]]'),
(4575, 1, 0, 'english', 'date_format_short', 'm/d/Y', '[[regtime]]', '[[regtime]]'),
(4576, 1, 0, 'english', 'date_format_long', 'l dS F Y', '[[regtime]]', '[[regtime]]'),
(4577, 1, 0, 'english', 'time_format', 'h:i:s A', '[[regtime]]', '[[regtime]]'),
(4578, 1, 0, 'english', 'time_format_short', 'H:i', '[[regtime]]', '[[regtime]]'),
(4579, 1, 0, 'english', 'decimal_point', '.', '[[regtime]]', '[[regtime]]'),
(4580, 1, 0, 'english', 'thousand_point', ',', '[[regtime]]', '[[regtime]]'),
(4581, 1, 0, 'english', 'text_home', 'Home', '[[regtime]]', '[[regtime]]'),
(4582, 1, 0, 'english', 'text_yes', 'Yes', '[[regtime]]', '[[regtime]]'),
(4583, 1, 0, 'english', 'text_no', 'No', '[[regtime]]', '[[regtime]]'),
(4584, 1, 0, 'english', 'text_none', ' --- None --- ', '[[regtime]]', '[[regtime]]'),
(4585, 1, 0, 'english', 'text_select', ' --- Please Select --- ', '[[regtime]]', '[[regtime]]'),
(4586, 1, 0, 'english', 'text_all_zones', 'All Zones', '[[regtime]]', '[[regtime]]'),
(4587, 1, 0, 'english', 'text_pagination', '{start} - {end} of {total}', '[[regtime]]', '[[regtime]]'),
(4588, 1, 0, 'english', 'text_per_page', 'Per Page', '[[regtime]]', '[[regtime]]'),
(4589, 1, 0, 'english', 'text_separator', ' &gt; ', '[[regtime]]', '[[regtime]]'),
(4590, 1, 0, 'english', 'button_continue', 'Continue', '[[regtime]]', '[[regtime]]'),
(4591, 1, 0, 'english', 'button_back', 'Back', '[[regtime]]', '[[regtime]]'),
(4592, 1, 0, 'english', 'button_add_to_cart', 'Add to Cart', '[[regtime]]', '[[regtime]]'),
(4593, 1, 0, 'english', 'button_add_wishlist', 'Add to wish list', '[[regtime]]', '[[regtime]]'),
(4594, 1, 0, 'english', 'button_remove_wishlist', 'Remove from wish list', '[[regtime]]', '[[regtime]]'),
(4595, 1, 0, 'english', 'text_wishlist_add_success', 'Added to wish list', '[[regtime]]', '[[regtime]]'),
(4596, 1, 0, 'english', 'text_wishlist_remove_success', 'Removed from wish list', '[[regtime]]', '[[regtime]]'),
(4597, 1, 0, 'english', 'button_add_address', 'Add Address', '[[regtime]]', '[[regtime]]'),
(4598, 1, 0, 'english', 'button_new_address', 'New Address', '[[regtime]]', '[[regtime]]'),
(4599, 1, 0, 'english', 'button_change_address', 'Change Address', '[[regtime]]', '[[regtime]]'),
(4600, 1, 0, 'english', 'button_edit', 'Edit', '[[regtime]]', '[[regtime]]'),
(4601, 1, 0, 'english', 'button_delete', 'Delete', '[[regtime]]', '[[regtime]]'),
(4602, 1, 0, 'english', 'button_reviews', 'Reviews', '[[regtime]]', '[[regtime]]'),
(4603, 1, 0, 'english', 'button_write', 'Write Review', '[[regtime]]', '[[regtime]]'),
(4604, 1, 0, 'english', 'button_login', 'Login', '[[regtime]]', '[[regtime]]'),
(4605, 1, 0, 'english', 'button_update', 'Update', '[[regtime]]', '[[regtime]]'),
(4606, 1, 0, 'english', 'button_wish', 'Wish', '[[regtime]]', '[[regtime]]'),
(4607, 1, 0, 'english', 'button_print', 'Print', '[[regtime]]', '[[regtime]]'),
(4608, 1, 0, 'english', 'button_shopping', 'Continue Shopping', '[[regtime]]', '[[regtime]]'),
(4609, 1, 0, 'english', 'button_checkout', 'Checkout', '[[regtime]]', '[[regtime]]'),
(4610, 1, 0, 'english', 'button_confirm', 'Confirm Order', '[[regtime]]', '[[regtime]]'),
(4611, 1, 0, 'english', 'button_view', 'View', '[[regtime]]', '[[regtime]]'),
(4612, 1, 0, 'english', 'button_search', 'Search', '[[regtime]]', '[[regtime]]'),
(4613, 1, 0, 'english', 'button_go', 'Go', '[[regtime]]', '[[regtime]]'),
(4614, 1, 0, 'english', 'button_coupon', 'Apply Coupon', '[[regtime]]', '[[regtime]]'),
(4615, 1, 0, 'english', 'button_guest', 'Guest Checkout', '[[regtime]]', '[[regtime]]'),
(4616, 1, 0, 'english', 'notice_out_of_stock_ttl', 'Out of stock notice for: %s', '[[regtime]]', '[[regtime]]'),
(4617, 1, 0, 'english', 'notice_out_of_stock_body', 'Product "%s" has reached zero or negative stock count for main product or all options. <br> As a result of autodisable setting, product (%s) was auto disabled!<br> For more details visit %s', '[[regtime]]', '[[regtime]]'),
(4618, 1, 0, 'english', 'no_payment_required', 'No Payment Required', '[[regtime]]', '[[regtime]]'),
(4619, 1, 0, 'english', 'gen_data_entry_error', 'Oops, there is an error with information provided!', '[[regtime]]', '[[regtime]]'),
(4620, 1, 0, 'english', 'text_sorting_name_asc', 'Name A - Z', '[[regtime]]', '[[regtime]]'),
(4621, 1, 0, 'english', 'text_sorting_name_desc', 'Name Z - A', '[[regtime]]', '[[regtime]]'),
(4622, 1, 0, 'english', 'text_sorting_price_asc', 'Price Low &gt; High', '[[regtime]]', '[[regtime]]'),
(4623, 1, 0, 'english', 'text_sorting_price_desc', 'Price High &gt; Low', '[[regtime]]', '[[regtime]]'),
(4624, 1, 0, 'english', 'text_sorting_rating_asc', 'Rating Lowest', '[[regtime]]', '[[regtime]]'),
(4625, 1, 0, 'english', 'text_sorting_rating_desc', 'Rating Highest', '[[regtime]]', '[[regtime]]'),
(4626, 1, 0, 'english', 'text_sorting_date_asc', 'Date Old &gt; New', '[[regtime]]', '[[regtime]]'),
(4627, 1, 0, 'english', 'text_sorting_date_desc', 'Date New &gt; Old', '[[regtime]]', '[[regtime]]'),
(4628, 1, 0, 'english', 'text_add_cart_confirm', 'Added to cart', '[[regtime]]', '[[regtime]]'),
(4629, 1, 0, 'english', 'text_close', 'Close', '[[regtime]]', '[[regtime]]'),
(4630, 1, 0, 'english', 'text_balance', 'Account Balance ', '[[regtime]]', '[[regtime]]'),
(4631, 1, 0, 'english', 'text_balance_checkout', 'Account Balance: ', '[[regtime]]', '[[regtime]]'),
(4632, 1, 0, 'english', 'button_pay_with_balance', 'Pay With Balance', '[[regtime]]', '[[regtime]]'),
(4633, 1, 0, 'english', 'button_apply_balance', 'Apply to Order', '[[regtime]]', '[[regtime]]'),
(4634, 1, 0, 'english', 'button_disapply_balance', 'Remove from Order', '[[regtime]]', '[[regtime]]'),
(4635, 1, 0, 'english', 'text_applied_balance', 'applied to order', '[[regtime]]', '[[regtime]]'),
(4636, 1, 0, 'english', 'text_applied_balance_to_order', '%s used for order #%s', '[[regtime]]', '[[regtime]]'),
(4637, 1, 0, 'english', 'text_maintenance_notice', 'Notice: Maintenance mode is on.', '[[regtime]]', '[[regtime]]'),
(4638, 1, 0, 'english', 'text_act_on_behalf', 'Notice: Impersonate mode for customer "%s" by "%s"', '[[regtime]]', '[[regtime]]'),
(4639, 1, 0, 'english', 'text_browse', 'Select File', '[[regtime]]', '[[regtime]]'),
(4640, 1, 0, 'english', 'button_cancel', 'Cancel', '[[regtime]]', '[[regtime]]'),
(4641, 1, 0, 'english', 'button_reset', 'Reset', '[[regtime]]', '[[regtime]]'),
(4642, 1, 0, 'english', 'button_submit', 'Submit', '[[regtime]]', '[[regtime]]'),
(4643, 1, 0, 'english', 'button_save', 'Save', '[[regtime]]', '[[regtime]]'),
(4644, 1, 0, 'english', 'text_field_required', 'is required field!', '[[regtime]]', '[[regtime]]'),
(4645, 1, 0, 'english', 'error_captcha', 'Human verification has failed! Please try again.', '[[regtime]]', '[[regtime]]'),
(4646, 1, 0, 'english', 'entry_attached', 'Attached', '[[regtime]]', '[[regtime]]'),
(4647, 1, 0, 'english', 'text_call_to_order', 'Call To Order', '[[regtime]]', '[[regtime]]'),
(4648, 1, 0, 'english', 'text_discount', 'Discount', '[[regtime]]', '[[regtime]]'),
(4649, 1, 0, 'english', 'text_download', 'Download', '[[regtime]]', '[[regtime]]'),
(4650, 1, 0, 'english', 'text_free', 'Free', '[[regtime]]', '[[regtime]]'),
(4651, 1, 0, 'english', 'text_free_shipping', 'Free Shipping', '[[regtime]]', '[[regtime]]'),
(4652, 1, 0, 'english', 'price_with_tax', 'Inc Tax', '[[regtime]]', '[[regtime]]'),
(4653, 1, 0, 'english', 'text_unavailable', 'Unavailable', '[[regtime]]', '[[regtime]]'),
(4654, 1, 0, 'english', 'error_unknown', 'Unknown error encountered. Please try again!', '[[regtime]]', '[[regtime]]'),
(4655, 1, 0, 'english', 'text_click_browse_file', 'Click to browse file', '[[regtime]]', '[[regtime]]'),
(4656, 1, 0, 'english', 'text_back_on_top', 'Back to top', '[[regtime]]', '[[regtime]]'),
(4657, 1, 0, 'english', 'text_out_of_stock', 'Out of Stock', '[[regtime]]', '[[regtime]]'),
(4658, 1, 0, 'english', 'text_badge_sale', 'SALE', '[[regtime]]', '[[regtime]]'),
(4659, 1, 0, 'english', 'text_pagination_pages_info', 'Showing {start} to {end} of {total} ({pages} Pages)', '[[regtime]]', '[[regtime]]'),
(4660, 1, 0, 'english', 'text_first', 'First', '[[regtime]]', '[[regtime]]'),
(4661, 1, 0, 'english', 'text_last', 'Last', '[[regtime]]', '[[regtime]]'),
(4662, 1, 0, 'english', 'text_next', 'Next', '[[regtime]]', '[[regtime]]'),
(4663, 1, 0, 'english', 'text_previous', 'Previous', '[[regtime]]', '[[regtime]]'),
(4664, 1, 0, 'english', 'warning_capslock', 'CapsLock is On!', '[[regtime]]', '[[regtime]]'),
(4665, 1, 0, 'error_error', 'heading_title', 'Application Error!', '[[regtime]]', '[[regtime]]'),
(4666, 1, 0, 'error_error', 'text_error', 'Please check error log for more information', '[[regtime]]', '[[regtime]]'),
(4667, 1, 0, 'error_login', 'heading_title', 'Login Error!', '[[regtime]]', '[[regtime]]'),
(4668, 1, 0, 'error_login', 'text_login', 'You are not logged in. You will be redirected to login page', '[[regtime]]', '[[regtime]]'),
(4669, 1, 0, 'error_not_found', 'heading_title', 'The page you requested cannot be found!', '[[regtime]]', '[[regtime]]'),
(4670, 1, 0, 'error_not_found', 'text_error', 'The page you requested cannot be found.', '[[regtime]]', '[[regtime]]'),
(4671, 1, 0, 'error_permission', 'heading_title', 'Permission Denied!', '[[regtime]]', '[[regtime]]'),
(4672, 1, 0, 'error_permission', 'text_permission', 'You do not have permission to access this page, please refer to your system administrator.', '[[regtime]]', '[[regtime]]'),
(4673, 1, 0, 'index_home', 'heading_title', 'Welcome to %s', '[[regtime]]', '[[regtime]]'),
(4674, 1, 0, 'index_home', 'text_latest', 'Latest Products', '[[regtime]]', '[[regtime]]'),
(4675, 1, 0, 'index_maintenance', 'heading_title', 'Maintenance', '[[regtime]]', '[[regtime]]'),
(4676, 1, 0, 'index_maintenance', 'text_maintenance', 'Maintenance', '[[regtime]]', '[[regtime]]'),
(4677, 1, 0, 'index_maintenance', 'text_message', '<h1 style="text-align:center;">We are currently performing some scheduled maintenance. <br/>We will be back as soon as possible. Please check back soon.</h1>', '[[regtime]]', '[[regtime]]'),
(4678, 1, 0, 'mail_account_create', 'text_subject', '%s - Thank you for registering', '[[regtime]]', '[[regtime]]'),
(4679, 1, 0, 'mail_account_create', 'text_welcome', 'Welcome and thank you for registering at %s!', '[[regtime]]', '[[regtime]]'),
(4680, 1, 0, 'mail_account_create', 'text_login', 'Your account has now been created and you can access it by visiting our website or at the following URL:', '[[regtime]]', '[[regtime]]'),
(4681, 1, 0, 'mail_account_create', 'text_approval', 'Your account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL:', '[[regtime]]', '[[regtime]]'),
(4682, 1, 0, 'mail_account_create', 'text_activate', 'Before we can activate your account one last step must be taken to complete your registration.<br>\n    You must complete this last step to become a registered member. Please click the following link to activate your account %s . ', '[[regtime]]', '[[regtime]]'),
(4683, 1, 0, 'mail_account_create', 'text_services', 'Upon logging in, you will be able to access other services including reviewing past orders, printing invoices and editing your account information.', '[[regtime]]', '[[regtime]]'),
(4684, 1, 0, 'mail_account_create', 'text_thanks', 'Thank you,', '[[regtime]]', '[[regtime]]'),
(4685, 1, 0, 'mail_account_forgotten', 'text_subject', '%s - Password reset', '[[regtime]]', '[[regtime]]'),
(4686, 1, 0, 'mail_account_forgotten', 'text_greeting', 'A password reset was requested from %s.', '[[regtime]]', '[[regtime]]'),
(4687, 1, 0, 'mail_account_forgotten', 'text_password', 'To reset your password click link below:', '[[regtime]]', '[[regtime]]'),
(4688, 1, 0, 'mail_account_forgotten', 'text_password_reset', 'Your password was successfully reset on %s.', '[[regtime]]', '[[regtime]]'),
(4689, 1, 0, 'mail_account_forgotten', 'text_new_password', 'Enter your new password below:', '[[regtime]]', '[[regtime]]'),
(4690, 1, 0, 'mail_account_forgotten', 'error_reset_token', 'Incorrect link for password request. Try to reset one more time and use link from most recent email.', '[[regtime]]', '[[regtime]]'),
(4691, 1, 0, 'mail_account_forgotten_login', 'text_subject', '%s - Login name reminder', '[[regtime]]', '[[regtime]]'),
(4692, 1, 0, 'mail_account_forgotten_login', 'text_greeting', 'Login name reminder was requested from %s.', '[[regtime]]', '[[regtime]]'),
(4693, 1, 0, 'mail_account_forgotten_login', 'text_your_loginname', 'Your login name is:', '[[regtime]]', '[[regtime]]'),
(4694, 1, 0, 'mail_order_confirm', 'text_subject', '%s - Order %s', '[[regtime]]', '[[regtime]]'),
(4695, 1, 0, 'mail_order_confirm', 'text_greeting', 'Thank you for your interest in %s products. Your order has been received and will be processed after payment is confirmed.', '[[regtime]]', '[[regtime]]'),
(4696, 1, 0, 'mail_order_confirm', 'text_received', 'You have received an order.', '[[regtime]]', '[[regtime]]'),
(4697, 1, 0, 'mail_order_confirm', 'text_order_detail', 'Order Details', '[[regtime]]', '[[regtime]]'),
(4698, 1, 0, 'mail_order_confirm', 'text_order_id', 'Order ID:', '[[regtime]]', '[[regtime]]'),
(4699, 1, 0, 'mail_order_confirm', 'text_date_added', 'Date Ordered:', '[[regtime]]', '[[regtime]]'),
(4700, 1, 0, 'mail_order_confirm', 'text_order_status', 'Order Status:', '[[regtime]]', '[[regtime]]'),
(4701, 1, 0, 'mail_order_confirm', 'text_invoice', 'To view your order click on the link below:', '[[regtime]]', '[[regtime]]'),
(4702, 1, 0, 'mail_order_confirm', 'text_shipping_method', 'Shipping Method:', '[[regtime]]', '[[regtime]]'),
(4703, 1, 0, 'mail_order_confirm', 'text_payment_method', 'Payment Method:', '[[regtime]]', '[[regtime]]'),
(4704, 1, 0, 'mail_order_confirm', 'text_shipping_address', 'Shipping Address', '[[regtime]]', '[[regtime]]'),
(4705, 1, 0, 'mail_order_confirm', 'text_payment_address', 'Payment Address', '[[regtime]]', '[[regtime]]'),
(4706, 1, 0, 'mail_order_confirm', 'text_email', 'Email:', '[[regtime]]', '[[regtime]]'),
(4707, 1, 0, 'mail_order_confirm', 'text_telephone', 'Telephone:', '[[regtime]]', '[[regtime]]'),
(4708, 1, 0, 'mail_order_confirm', 'text_mobile_phone', 'Mobile Phone:', '[[regtime]]', '[[regtime]]'),
(4709, 1, 0, 'mail_order_confirm', 'text_fax', 'Fax:', '[[regtime]]', '[[regtime]]'),
(4710, 1, 0, 'mail_order_confirm', 'text_ip', 'IP Address:', '[[regtime]]', '[[regtime]]'),
(4711, 1, 0, 'mail_order_confirm', 'text_product', 'Products:', '[[regtime]]', '[[regtime]]'),
(4712, 1, 0, 'mail_order_confirm', 'text_total', 'Totals:', '[[regtime]]', '[[regtime]]'),
(4713, 1, 0, 'mail_order_confirm', 'text_download', 'Once your payment has been confirmed you can click on the link below to access your downloadable products:', '[[regtime]]', '[[regtime]]'),
(4714, 1, 0, 'mail_order_confirm', 'text_comment', 'The comments for your order are:', '[[regtime]]', '[[regtime]]'),
(4715, 1, 0, 'mail_order_confirm', 'text_footer', 'Please reply to this email if you have any questions.', '[[regtime]]', '[[regtime]]'),
(4716, 1, 0, 'mail_order_confirm', 'text_powered_by', 'powered by', '[[regtime]]', '[[regtime]]'),
(4717, 1, 0, 'mail_order_confirm', 'text_new_order', 'New Order - #', '[[regtime]]', '[[regtime]]'),
(4718, 1, 0, 'mail_order_confirm', 'text_new_order_text', 'Customer %s added new order', '[[regtime]]', '[[regtime]]'),
(4719, 1, 0, 'mail_order_confirm', 'column_product', 'Product', '[[regtime]]', '[[regtime]]'),
(4720, 1, 0, 'mail_order_confirm', 'column_model', 'Model', '[[regtime]]', '[[regtime]]'),
(4721, 1, 0, 'mail_order_confirm', 'column_quantity', 'Quantity', '[[regtime]]', '[[regtime]]'),
(4722, 1, 0, 'mail_order_confirm', 'column_price', 'Price', '[[regtime]]', '[[regtime]]'),
(4723, 1, 0, 'mail_order_confirm', 'column_total', 'Total', '[[regtime]]', '[[regtime]]'),
(4724, 1, 0, 'mail_order_update', 'text_subject', '%s - Order Update %s', '[[regtime]]', '[[regtime]]'),
(4725, 1, 0, 'mail_order_update', 'text_order', 'Order ID:', '[[regtime]]', '[[regtime]]'),
(4726, 1, 0, 'mail_order_update', 'text_date_added', 'Date Ordered:', '[[regtime]]', '[[regtime]]'),
(4727, 1, 0, 'mail_order_update', 'text_order_status', 'Your order has been updated to the following status:', '[[regtime]]', '[[regtime]]'),
(4728, 1, 0, 'mail_order_update', 'text_comment', 'The comments for your order are:', '[[regtime]]', '[[regtime]]'),
(4729, 1, 0, 'mail_order_update', 'text_invoice', 'To view your order click on the link below:', '[[regtime]]', '[[regtime]]'),
(4730, 1, 0, 'mail_order_update', 'text_footer', 'Please reply to this email if you have any questions.', '[[regtime]]', '[[regtime]]'),
(4731, 1, 0, 'product_category', 'text_product', 'Products', '[[regtime]]', '[[regtime]]'),
(4732, 1, 0, 'product_category', 'text_error', 'Category not found!', '[[regtime]]', '[[regtime]]'),
(4733, 1, 0, 'product_category', 'text_empty', 'There are no products to list in this category.', '[[regtime]]', '[[regtime]]'),
(4734, 1, 0, 'product_category', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4735, 1, 0, 'product_category', 'text_sort', 'Sort By:', '[[regtime]]', '[[regtime]]'),
(4736, 1, 0, 'product_category', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(4737, 1, 0, 'product_category', 'text_name_asc', 'Name A - Z', '[[regtime]]', '[[regtime]]'),
(4738, 1, 0, 'product_category', 'text_name_desc', 'Name Z - A', '[[regtime]]', '[[regtime]]'),
(4739, 1, 0, 'product_category', 'text_price_asc', 'Price Low &gt; High', '[[regtime]]', '[[regtime]]'),
(4740, 1, 0, 'product_category', 'text_price_desc', 'Price High &gt; Low', '[[regtime]]', '[[regtime]]'),
(4741, 1, 0, 'product_category', 'text_rating_asc', 'Rating Lowest', '[[regtime]]', '[[regtime]]'),
(4742, 1, 0, 'product_category', 'text_rating_desc', 'Rating Highest', '[[regtime]]', '[[regtime]]'),
(4743, 1, 0, 'product_category', 'text_top_category', 'Top Category', '[[regtime]]', '[[regtime]]'),
(4744, 1, 0, 'product_collection', 'text_empty_collection', 'There are no products to list ', '[[regtime]]', '[[regtime]]'),
(4745, 1, 0, 'product_manufacturer', 'text_product', 'Products', '[[regtime]]', '[[regtime]]'),
(4746, 1, 0, 'product_manufacturer', 'text_error', 'Brand not found!', '[[regtime]]', '[[regtime]]'),
(4747, 1, 0, 'product_manufacturer', 'text_empty', 'There are no products to list from this brand.', '[[regtime]]', '[[regtime]]'),
(4748, 1, 0, 'product_manufacturer', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4749, 1, 0, 'product_manufacturer', 'text_sort', 'Sort By:', '[[regtime]]', '[[regtime]]'),
(4750, 1, 0, 'product_manufacturer', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(4751, 1, 0, 'product_manufacturer', 'text_name_asc', 'Name A - Z', '[[regtime]]', '[[regtime]]'),
(4752, 1, 0, 'product_manufacturer', 'text_name_desc', 'Name Z - A', '[[regtime]]', '[[regtime]]'),
(4753, 1, 0, 'product_manufacturer', 'text_price_asc', 'Price Low &gt; High', '[[regtime]]', '[[regtime]]'),
(4754, 1, 0, 'product_manufacturer', 'text_price_desc', 'Price High &gt; Low', '[[regtime]]', '[[regtime]]'),
(4755, 1, 0, 'product_manufacturer', 'text_rating_asc', 'Rating Lowest', '[[regtime]]', '[[regtime]]'),
(4756, 1, 0, 'product_manufacturer', 'text_rating_desc', 'Rating Highest', '[[regtime]]', '[[regtime]]'),
(4757, 1, 0, 'product_product', 'text_enlarge', 'Click image to enlarge', '[[regtime]]', '[[regtime]]'),
(4758, 1, 0, 'product_product', 'text_zoom', 'Move pointer over the image to zoom in', '[[regtime]]', '[[regtime]]'),
(4759, 1, 0, 'product_product', 'text_quantity_discount', 'Quantity Discount:', '[[regtime]]', '[[regtime]]'),
(4760, 1, 0, 'product_product', 'text_options', 'Available Options:', '[[regtime]]', '[[regtime]]'),
(4761, 1, 0, 'product_product', 'text_error', 'Product not found!', '[[regtime]]', '[[regtime]]'),
(4762, 1, 0, 'product_product', 'text_price', 'Price:', '[[regtime]]', '[[regtime]]'),
(4763, 1, 0, 'product_product', 'text_availability', 'Availability:', '[[regtime]]', '[[regtime]]'),
(4764, 1, 0, 'product_product', 'text_model', 'Model:', '[[regtime]]', '[[regtime]]'),
(4765, 1, 0, 'product_product', 'text_sku', 'SKU:', '[[regtime]]', '[[regtime]]'),
(4766, 1, 0, 'product_product', 'text_manufacturer', 'Brand:', '[[regtime]]', '[[regtime]]'),
(4767, 1, 0, 'product_product', 'text_instock', 'In Stock', '[[regtime]]', '[[regtime]]'),
(4768, 1, 0, 'product_product', 'text_out_of_stock', 'Out of Stock', '[[regtime]]', '[[regtime]]'),
(4769, 1, 0, 'product_product', 'text_order_quantity', 'Order Quantity', '[[regtime]]', '[[regtime]]'),
(4770, 1, 0, 'product_product', 'text_price_per_item', 'Price Per Item', '[[regtime]]', '[[regtime]]'),
(4771, 1, 0, 'product_product', 'text_write', 'Write Review', '[[regtime]]', '[[regtime]]'),
(4772, 1, 0, 'product_product', 'text_no_reviews', 'There are no reviews for this product.', '[[regtime]]', '[[regtime]]'),
(4773, 1, 0, 'product_product', 'text_average', 'Average Rating:', '[[regtime]]', '[[regtime]]'),
(4774, 1, 0, 'product_product', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4775, 1, 0, 'product_product', 'text_no_rating', 'Not Rated', '[[regtime]]', '[[regtime]]'),
(4776, 1, 0, 'product_product', 'text_no_images', 'There are no additional images for this product.', '[[regtime]]', '[[regtime]]'),
(4777, 1, 0, 'product_product', 'text_no_related', 'There are no related products for this product.', '[[regtime]]', '[[regtime]]'),
(4778, 1, 0, 'product_product', 'text_qty', 'Qty:', '[[regtime]]', '[[regtime]]'),
(4779, 1, 0, 'product_product', 'text_note', '<span style="color: #FF0000;">Note:</span> Do not use HTML in the text.', '[[regtime]]', '[[regtime]]'),
(4780, 1, 0, 'product_product', 'text_success', 'Thank you for your review. It has been submitted to the webmaster for approval.', '[[regtime]]', '[[regtime]]'),
(4781, 1, 0, 'product_product', 'text_wait', 'Please Wait!', '[[regtime]]', '[[regtime]]'),
(4782, 1, 0, 'product_product', 'text_search', 'Search', '[[regtime]]', '[[regtime]]'),
(4783, 1, 0, 'product_product', 'text_tags', 'Tags:', '[[regtime]]', '[[regtime]]'),
(4784, 1, 0, 'product_product', 'text_minimum', '(This product has a minimum quantity of %s)', '[[regtime]]', '[[regtime]]'),
(4785, 1, 0, 'product_product', 'text_maximum', '(This product has a limit set to %s item(s) per order)', '[[regtime]]', '[[regtime]]'),
(4786, 1, 0, 'product_product', 'entry_name', 'Your Name:', '[[regtime]]', '[[regtime]]'),
(4787, 1, 0, 'product_product', 'entry_review', 'Your Review:', '[[regtime]]', '[[regtime]]'),
(4788, 1, 0, 'product_product', 'entry_rating', 'Rating:', '[[regtime]]', '[[regtime]]'),
(4789, 1, 0, 'product_product', 'entry_good', 'Good', '[[regtime]]', '[[regtime]]'),
(4790, 1, 0, 'product_product', 'entry_bad', 'Bad', '[[regtime]]', '[[regtime]]'),
(4791, 1, 0, 'product_product', 'entry_captcha', 'Enter the code in the box below:', '[[regtime]]', '[[regtime]]'),
(4792, 1, 0, 'product_product', 'tab_description', 'Description', '[[regtime]]', '[[regtime]]'),
(4793, 1, 0, 'product_product', 'tab_image', 'Additional Images', '[[regtime]]', '[[regtime]]'),
(4794, 1, 0, 'product_product', 'tab_review', 'Reviews (%s)', '[[regtime]]', '[[regtime]]'),
(4795, 1, 0, 'product_product', 'tab_review_empty', 'Reviews', '[[regtime]]', '[[regtime]]'),
(4796, 1, 0, 'product_product', 'tab_related', 'Related Products', '[[regtime]]', '[[regtime]]'),
(4797, 1, 0, 'product_product', 'error_name', 'Error: Review Name must be between 3 and 25 characters!', '[[regtime]]', '[[regtime]]'),
(4798, 1, 0, 'product_product', 'error_text', 'Error: Review Text must be between 25 and 1000 characters!', '[[regtime]]', '[[regtime]]'),
(4799, 1, 0, 'product_product', 'error_rating', 'Error: Please select a review rating!', '[[regtime]]', '[[regtime]]'),
(4800, 1, 0, 'product_product', 'text_total_price', 'Total Price:', '[[regtime]]', '[[regtime]]'),
(4801, 1, 0, 'product_product', 'text_login_view_price', 'Please login or register to see price or to order.', '[[regtime]]', '[[regtime]]'),
(4802, 1, 0, 'product_product', 'tab_downloads', 'Downloads', '[[regtime]]', '[[regtime]]'),
(4803, 1, 0, 'product_product', 'text_start_download', 'Start Download', '[[regtime]]', '[[regtime]]'),
(4804, 1, 0, 'product_product', 'text_new_review', 'Product review approval is pending', '[[regtime]]', '[[regtime]]'),
(4805, 1, 0, 'product_product', 'text_pending_review_approval', 'Review for product id %s is posted. Action of approval is required! Click to view #admin#rt=catalog/review/update&review_id=%s', '[[regtime]]', '[[regtime]]'),
(4806, 1, 0, 'product_product', 'text_verified_review', 'Verified purchase', '[[regtime]]', '[[regtime]]'),
(4807, 1, 0, 'product_product', 'percentage_review', 'of buyers have recommended this.', '[[regtime]]', '[[regtime]]'),
(4808, 1, 0, 'product_product', 'feedback_customer_title', 'Customers Feedback', '[[regtime]]', '[[regtime]]'),
(4809, 1, 0, 'product_product', 'review_title', 'Reviews', '[[regtime]]', '[[regtime]]'),
(4810, 1, 0, 'product_product', 'write_review_title', 'Write a Review', '[[regtime]]', '[[regtime]]'),
(4811, 1, 0, 'product_product', 'product_rate_title', 'Product Rating', '[[regtime]]', '[[regtime]]'),
(4812, 1, 0, 'product_search', 'heading_title', 'Search', '[[regtime]]', '[[regtime]]'),
(4813, 1, 0, 'product_search', 'text_search', 'Products meeting the search criteria', '[[regtime]]', '[[regtime]]'),
(4814, 1, 0, 'product_search', 'text_keyword', 'Keywords', '[[regtime]]', '[[regtime]]'),
(4815, 1, 0, 'product_search', 'text_category', 'All Categories', '[[regtime]]', '[[regtime]]'),
(4816, 1, 0, 'product_search', 'text_critea', 'Search Criteria', '[[regtime]]', '[[regtime]]'),
(4817, 1, 0, 'product_search', 'text_empty', 'There is no product that matches the search criteria.', '[[regtime]]', '[[regtime]]'),
(4818, 1, 0, 'product_search', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4819, 1, 0, 'product_search', 'text_sort', 'Sort By:', '[[regtime]]', '[[regtime]]'),
(4820, 1, 0, 'product_search', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(4821, 1, 0, 'product_search', 'text_name_asc', 'Name A - Z', '[[regtime]]', '[[regtime]]'),
(4822, 1, 0, 'product_search', 'text_name_desc', 'Name Z - A', '[[regtime]]', '[[regtime]]'),
(4823, 1, 0, 'product_search', 'text_price_asc', 'Price Low &gt; High', '[[regtime]]', '[[regtime]]'),
(4824, 1, 0, 'product_search', 'text_price_desc', 'Price High &gt; Low', '[[regtime]]', '[[regtime]]'),
(4825, 1, 0, 'product_search', 'text_rating_asc', 'Rating Lowest', '[[regtime]]', '[[regtime]]'),
(4826, 1, 0, 'product_search', 'text_rating_desc', 'Rating Highest', '[[regtime]]', '[[regtime]]'),
(4827, 1, 0, 'product_search', 'entry_search', 'Search:', '[[regtime]]', '[[regtime]]'),
(4828, 1, 0, 'product_search', 'entry_description', 'Search in product descriptions', '[[regtime]]', '[[regtime]]'),
(4829, 1, 0, 'product_search', 'entry_model', 'Search in product model', '[[regtime]]', '[[regtime]]'),
(4830, 1, 0, 'product_special', 'heading_title', 'Special Offers', '[[regtime]]', '[[regtime]]'),
(4831, 1, 0, 'product_special', 'text_empty', 'There are no special offer products to list.', '[[regtime]]', '[[regtime]]'),
(4832, 1, 0, 'product_special', 'text_stars', '%s out of 5 Stars!', '[[regtime]]', '[[regtime]]'),
(4833, 1, 0, 'product_special', 'text_sort', 'Sort By:', '[[regtime]]', '[[regtime]]'),
(4834, 1, 0, 'product_special', 'text_default', 'Default', '[[regtime]]', '[[regtime]]'),
(4835, 1, 0, 'product_special', 'text_name_asc', 'Name A - Z', '[[regtime]]', '[[regtime]]'),
(4836, 1, 0, 'product_special', 'text_name_desc', 'Name Z - A', '[[regtime]]', '[[regtime]]'),
(4837, 1, 0, 'product_special', 'text_price_asc', 'Price Low &gt; High', '[[regtime]]', '[[regtime]]'),
(4838, 1, 0, 'product_special', 'text_price_desc', 'Price High &gt; Low', '[[regtime]]', '[[regtime]]'),
(4839, 1, 0, 'product_special', 'text_rating_asc', 'Rating Lowest', '[[regtime]]', '[[regtime]]'),
(4840, 1, 0, 'product_special', 'text_rating_desc', 'Rating Highest', '[[regtime]]', '[[regtime]]'),
(4841, 1, 0, 'total_handling', 'text_handling', 'Handling Fee:', '[[regtime]]', '[[regtime]]'),
(4842, 1, 0, 'total_low_order_fee', 'text_low_order_fee', 'Low Order Fee:', '[[regtime]]', '[[regtime]]'),
(4843, 1, 0, 'total_sub_total', 'text_sub_total', 'Sub-Total:', '[[regtime]]', '[[regtime]]'),
(4844, 1, 0, 'total_total', 'text_total', 'Total:', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]layouts`
--

CREATE TABLE `[[dbprefix]]layouts` (
  `layout_id` int NOT NULL AUTO_INCREMENT,
  `template_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `layout_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `layout_type` smallint NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`layout_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=41 ;

--
-- Dumping data for table `[[dbprefix]]layouts`
--

INSERT INTO `[[dbprefix]]layouts` VALUES
(1, 'default', 'Default Page Layout', 0, '[[regtime]]', '[[regtime]]'),
(2, 'default', 'Home Page', 1, '[[regtime]]', '[[regtime]]'),
(3, 'default', 'Login Page', 1, '[[regtime]]', '[[regtime]]'),
(4, 'default', 'Contact Us Page', 1, '[[regtime]]', '[[regtime]]'),
(5, 'default', 'Default Product Page', 1, '[[regtime]]', '[[regtime]]'),
(6, 'default', 'Product Listing Page', 1, '[[regtime]]', '[[regtime]]'),
(7, 'default', 'Maintenance Page', 1, '[[regtime]]', '[[regtime]]'),
(8, 'default', 'Customer Dashboard', 1, '[[regtime]]', '[[regtime]]'),
(9, 'default', 'Account Details', 1, '[[regtime]]', '[[regtime]]'),
(10, 'default', 'Change Password', 1, '[[regtime]]', '[[regtime]]'),
(11, 'default', 'Addresses', 1, '[[regtime]]', '[[regtime]]'),
(12, 'default', 'Wish List', 1, '[[regtime]]', '[[regtime]]'),
(13, 'default', 'Order History', 1, '[[regtime]]', '[[regtime]]'),
(14, 'default', 'Transaction History', 1, '[[regtime]]', '[[regtime]]'),
(15, 'default', 'Downloads', 1, '[[regtime]]', '[[regtime]]'),
(16, 'default', 'Notifications', 1, '[[regtime]]', '[[regtime]]'),
(17, 'default', 'Cart Page', 1, '[[regtime]]', '[[regtime]]'),
(18, 'default', 'Fast Checkout Page', 1, '[[regtime]]', '[[regtime]]'),
(19, 'default', 'Fast Checkout Success Page', 1, '[[regtime]]', '[[regtime]]'),
(20, 'default', 'Default Content Layout', 1, '[[regtime]]', '[[regtime]]'),
(21, 'novator', 'Default Page Layout', 0, '[[regtime]]', '[[regtime]]'),
(22, 'novator', 'Home Page', 1, '[[regtime]]', '[[regtime]]'),
(23, 'novator', 'Login Page', 1, '[[regtime]]', '[[regtime]]'),
(24, 'novator', 'Contact Us Page', 1, '[[regtime]]', '[[regtime]]'),
(25, 'novator', 'Default Product Page', 1, '[[regtime]]', '[[regtime]]'),
(26, 'novator', 'Product Listing Page', 1, '[[regtime]]', '[[regtime]]'),
(27, 'novator', 'Maintenance Page', 1, '[[regtime]]', '[[regtime]]'),
(28, 'novator', 'Customer Dashboard', 1, '[[regtime]]', '[[regtime]]'),
(29, 'novator', 'Account Details', 1, '[[regtime]]', '[[regtime]]'),
(30, 'novator', 'Change Password', 1, '[[regtime]]', '[[regtime]]'),
(31, 'novator', 'Addresses', 1, '[[regtime]]', '[[regtime]]'),
(32, 'novator', 'Wish List', 1, '[[regtime]]', '[[regtime]]'),
(33, 'novator', 'Order History', 1, '[[regtime]]', '[[regtime]]'),
(34, 'novator', 'Transaction History', 1, '[[regtime]]', '[[regtime]]'),
(35, 'novator', 'Downloads', 1, '[[regtime]]', '[[regtime]]'),
(36, 'novator', 'Notifications', 1, '[[regtime]]', '[[regtime]]'),
(37, 'novator', 'Cart Page', 1, '[[regtime]]', '[[regtime]]'),
(38, 'novator', 'Fast Checkout Page', 1, '[[regtime]]', '[[regtime]]'),
(39, 'novator', 'Fast Checkout Success Page', 1, '[[regtime]]', '[[regtime]]'),
(40, 'novator', 'Default Content Layout', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]length_classes`
--

CREATE TABLE `[[dbprefix]]length_classes` (
  `length_class_id` int NOT NULL AUTO_INCREMENT,
  `value` decimal(15,8) NOT NULL,
  `iso_code` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`length_class_id`,`iso_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]length_classes`
--

INSERT INTO `[[dbprefix]]length_classes` VALUES
(1, '1.00000000', 'CMET', '[[regtime]]', '[[regtime]]'),
(2, '10.00000000', 'MMET', '[[regtime]]', '[[regtime]]'),
(3, '0.39370000', 'INCH', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]length_class_descriptions`
--

CREATE TABLE `[[dbprefix]]length_class_descriptions` (
  `length_class_id` int NOT NULL,
  `language_id` int NOT NULL,
  `title` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  `unit` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`length_class_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]length_class_descriptions`
--

INSERT INTO `[[dbprefix]]length_class_descriptions` VALUES
(1, 1, 'Centimeter', 'cm'),
(2, 1, 'Millimeter', 'mm'),
(3, 1, 'Inch', 'in');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]locations`
--

CREATE TABLE `[[dbprefix]]locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]locations`
--

INSERT INTO `[[dbprefix]]locations` VALUES
(1, 'USA', 'All States', '[[regtime]]', '[[regtime]]'),
(2, 'Canada', 'All provinces', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]manufacturers`
--

CREATE TABLE `[[dbprefix]]manufacturers` (
  `manufacturer_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int NOT NULL,
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=21 ;

--
-- Dumping data for table `[[dbprefix]]manufacturers`
--

INSERT INTO `[[dbprefix]]manufacturers` VALUES
(11, 'M·A·C', 0),
(12, 'Benefit', 0),
(13, 'Calvin Klein', 0),
(14, 'Bvlgari', 0),
(15, 'Lancôme', 0),
(16, 'Sephora', 0),
(17, 'Pantene', 0),
(18, 'Dove', 0),
(19, 'Giorgio Armani', 0),
(20, 'Gucci', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]manufacturers_to_stores`
--

CREATE TABLE `[[dbprefix]]manufacturers_to_stores` (
  `manufacturer_id` int NOT NULL,
  `store_id` int NOT NULL,
  PRIMARY KEY (`manufacturer_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]manufacturers_to_stores`
--

INSERT INTO `[[dbprefix]]manufacturers_to_stores` VALUES
(11, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(16, 0),
(17, 0),
(18, 0),
(19, 0),
(20, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `msg_id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `viewed` int NOT NULL DEFAULT '0',
  `repeated` int NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_types`
--

CREATE TABLE `[[dbprefix]]object_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `related_to` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`,`name`,`related_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='list of types for mapping data';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]online_customers`
--

CREATE TABLE `[[dbprefix]]online_customers` (
  `customer_id` int NOT NULL,
  `ip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `referer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ip`),
  KEY `[[dbprefix]]online_customers_idx` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders`
--

CREATE TABLE `[[dbprefix]]orders` (
  `order_id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL DEFAULT '0',
  `invoice_prefix` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `store_id` int NOT NULL DEFAULT '0',
  `store_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `store_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` int NOT NULL DEFAULT '0',
  `customer_group_id` int NOT NULL DEFAULT '0',
  `firstname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telephone` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shipping_firstname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_lastname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shipping_company` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_address_1` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_address_2` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_city` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_postcode` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shipping_zone` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_zone_id` int NOT NULL,
  `shipping_country` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_country_id` int NOT NULL,
  `shipping_address_format` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_method` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shipping_method_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_firstname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_lastname` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_company` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_address_1` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_address_2` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_city` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_postcode` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_zone` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_zone_id` int NOT NULL,
  `payment_country` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_country_id` int NOT NULL,
  `payment_address_format` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_method` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_method_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `order_status_id` int NOT NULL DEFAULT '0',
  `language_id` int NOT NULL,
  `currency_id` int NOT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(15,8) NOT NULL,
  `coupon_id` int NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_method_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`order_id`,`customer_id`,`order_status_id`),
  KEY `[[dbprefix]]orders_idx` (`invoice_id`,`store_id`,`customer_group_id`,`shipping_zone_id`,`shipping_country_id`,`payment_zone_id`,`payment_country_id`,`language_id`,`currency_id`,`coupon_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]orders`
--

INSERT INTO `[[dbprefix]]orders` VALUES
(2, 0, '', 0, 'Web Store Name', 'demo', 11, 1, 'Anthony', 'Blair', '+1 907-842-2240', '', 'anthonyblair@abantecart.com', '', '', '', '', '', '', '', '', 0, '', 0, '', '', '', 'Anthony', 'Blair', '', '104 Main Street', '', 'Dillingham', '', 'North Dakota', 3657, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', '', '', '418.8100', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(3, 0, '', 0, 'Web Store Name', 'demo', 5, 1, 'Gloria', 'Macias', '+1 418-461-2440', '', 'gloriamacias@abantecart.com', 'Gloria', 'Macias', '', 'Camille Marcoux 15', '', 'Blanc-Sablon', '1569', 'Nunavut', 609, 'Canada', 38, '', 'Flat Shipping Rate', '', 'Gloria', 'Macias', '', 'Camille Marcoux 15', '', 'Blanc-Sablon', '1569', 'Nunavut', 609, 'Canada', 38, '', 'Cash On Delivery', '', 'Please ASAP', '246.0000', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(4, 0, '', 0, 'Web Store Name', 'demo', 5, 1, 'Gloria', 'Macias', '+1 418-461-2440', '', 'gloriamacias@abantecart.com', '', '', '', '', '', '', '', '', 0, '', 0, '', '', '', 'Gloria', 'Macias', '', 'Camille Marcoux 15', '', 'Blanc-Sablon', '1569', 'Nunavut', 609, 'Canada', 38, '', 'Cash On Delivery', '', '', '310.5270', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(5, 0, '', 0, 'Web Store Name', 'demo', 3, 1, 'Keely', 'Mccoy', '+44 1324 483784 ', '', 'keelymccoy@abantecart.com', 'Keely', 'Mccoy', '', '4842 Amet', '', 'Grangemouth', '', 'Gloucestershire', 3552, 'United Kingdom', 222, '', 'Flat Shipping Rate', '', 'Keely', 'Mccoy', '', '4842 Amet', '', 'Grangemouth', '', 'Gloucestershire', 3552, 'United Kingdom', 222, '', 'Cash On Delivery', '', '', '686.0925', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(6, 0, '', 0, 'Web Store Name', 'demo', 2, 1, 'Juliana', 'Davis', '+44 1688 308321', '', 'julidavis@abantecart.com', '', '', '', '', '', '', '', '', 0, '', 0, '', '', '', 'Juliana', 'Davis', '', 'Highlands and Islands PA75 6QE', '', 'Isle of Mull', '', 'Highlands', 3559, 'United Kingdom', 222, '', 'Cash On Delivery', '', 'Bulgari', '218.0850', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(7, 0, '', 0, 'Web Store Name', 'demo', 9, 1, 'Carlos', 'Compton', '+1 867-874-22391', '', 'carloscmpton@abantecart.com', '', '', '', '', '', '', '', '', 0, '', 0, '', '', '', 'Carlos', 'Compton', '', '31 Capital Drive', '', 'Hay River', '', 'Nova Scotia', 608, 'Canada', 38, '', 'Cash On Delivery', '', '', '175.7700', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(8, 0, '', 0, 'Web Store Name', 'demo', 8, 1, 'Bruce', 'Rosarini', '+1 807-346-10763', '', 'brucerosarini@abantecart.com', 'Bruce', 'Rosarini', '', '61 Cumberland ST', '', 'Thunder Bay', '', 'Minnesota', 3646, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', '', 'Bruce', 'Rosarini', '', '61 Cumberland ST', '', 'Thunder Bay', '', 'Minnesota', 3646, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', '', '', '62.0000', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(9, 0, '', 0, 'Web Store Name', 'demo', 8, 1, 'Bruce', 'Rosarini', '+1 807-346-10763', '', 'brucerosarini@abantecart.com', 'Bruce', 'Rosarini', '', '61 Cumberland ST', '', 'Thunder Bay', '', 'Minnesota', 3646, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', '', 'Bruce', 'Rosarini', '', '61 Cumberland ST', '', 'Thunder Bay', '', 'Minnesota', 3646, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', '', '', '352.0000', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(10, 0, '', 0, 'Web Store Name', 'demo', 12, 1, 'Allen', 'Waters', '+1 540-985-59700', '', 'allenwaters@abantecart.com', '', '', '', '', '', '', '', '', 0, '', 0, '', '', '', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Roanoke', '', 'Virginia', 3673, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', '', '', '155.1550', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(11, 0, '', 0, 'Web Store Name', 'demo', 12, 1, 'Allen', 'Waters', '+1 540-985-59700', '', 'allenwaters@abantecart.com', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Roanoke', '', 'Virginia', 3673, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', '', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Roanoke', '', 'Virginia', 3673, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', '', '', '21.0000', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '109.104.166.98', ''),
(12, 0, '', 0, 'Web Store Name', 'demo', 11, 1, 'Anthony', 'Blair', '+1 907-842-2240', '', 'anthonyblair@abantecart.com', 'Anthony', 'Blair', '', '104 Main Street', '', 'Dillingham', '', 'North Dakota', 3657, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', '', 'Anthony', 'Blair', '', '104 Main Street', '', 'Dillingham', '', 'North Dakota', 3657, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', '', '', '487.3750', 2, 1, 3, 'GBP', '0.63820000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '171.98.12.12', ''),
(13, 0, '', 0, 'Web Store Name', 'demo', 11, 1, 'Anthony', 'Blair', '+1 907-842-2240', '', 'anthonyblair@abantecart.com', 'Anthony', 'Blair', '', '104 Main Street', '', 'Dillingham', '', 'North Dakota', 3657, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', '', 'Anthony', 'Blair', '', '104 Main Street', '', 'Dillingham', '', 'North Dakota', 3657, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', '', '', '626.9600', 1, 1, 3, 'GBP', '0.63820000', 0, '2019-03-18 15:37:51', '2019-03-18 15:37:51', '171.98.12.12', ''),
(14, 0, '', 0, 'Web Store Name', 'demo', 13, 1, 'Michael', 'Neal', '55 555 5555 5555', '', 'michaelj@abantecart.com', 'Tom', 'Kipling', '', '100 Main Str', '', 'Shell Pile', '64034-2948', 'Missouri', 3648, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Tom', 'Kipling', '', '100 Main Str', '', 'Shell Pile', '64034-2948', 'Missouri', 3648, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', '', '94.2300', 5, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 16:13:24', '2019-03-18 16:14:29', '77.111.246.167', ''),
(15, 0, '', 0, 'Web Store Name', 'demo', 12, 1, 'Allen', 'Waters', '(417) 280-7406', '', 'allenwaters@abantecart.com', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Honohina', '86565-1710', 'Arizona', 3616, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Honohina', '86565-1710', 'Arizona', 3616, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', '', '30.2100', 3, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 16:20:54', '2019-03-18 16:26:40', '77.111.246.167', ''),
(16, 0, '', 0, 'Web Store Name', 'demo', 14, 1, 'Yuri', 'Howard', '+1 (694) 373-3146', '', 'howardinc@abantecart.com', 'Yuri', 'Howard', 'Eaton Stevenson Inc', '22555 Jensen Ave', '', 'Reedley', '93654', 'California', 3624, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Yuri', 'Howard', 'Eaton Stevenson Inc', '22555 Jensen Ave', '', 'Reedley', '93654', 'California', 3624, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', '', '15.1900', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-18 17:39:08', '2019-03-18 17:39:24', '85.235.65.198', ''),
(17, 0, '', 0, 'Web Store Name', 'demo', 15, 1, 'Regan', 'Shields', '+1 (267) 125-5153', '', 'ricuvif@abantecart.com', 'Regan', 'Shields', 'Day and Rivera Traders', '2355 Boulevard Bastien', '', 'Québec', 'G2B 1B3', 'Qu&eacute;bec', 612, 'Canada', 38, '', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Regan', 'Shields', 'Day and Rivera Traders', '2355 Boulevard Bastien', '', 'Québec', 'G2B 1B3', 'Qu&eacute;bec', 612, 'Canada', 38, '', 'Cash On Delivery', 'default_cod', '', '36.9000', 5, 1, 1, 'USD', '1.00000000', 0, '2019-03-19 12:32:53', '2019-03-19 12:36:46', '23.129.64.106', ''),
(18, 0, '', 0, 'Web Store Name', 'demo', 16, 1, 'Randall', 'Richards', ' 1 (788) 773-7896', ' 1 (706) 122-6856', 'randallri@abantecart.com', 'Randall', 'Richards', '', '500 N Nebraska Ave', '', 'Tampa', '33603', 'Florida', 3630, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Mallory', 'Ballard', 'Guzman and Morin Inc', '2430 S French Ave', '', 'Sanford', '32771', 'Florida', 3630, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', '', '50.8300', 1, 1, 1, 'USD', '1.00000000', 0, '2019-03-21 16:10:03', '2022-06-28 12:08:05', '205.185.126.56', ''),
(19, 0, '', 0, 'Web Store Name', 'demo', 12, 1, 'Allen', 'Waters', '(417) 280-7406', '', 'allenwaters@abantecart.com', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Honohina', '86565-1710', 'Arizona', 3616, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Honohina', '86565-1710', 'Arizona', 3616, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', '', '112.6700', 3, 1, 1, 'USD', '1.00000000', 0, '2019-05-06 10:05:01', '2022-06-28 12:07:42', '77.111.246.147', ''),
(20, 0, '', 0, 'Web Store Name', 'demo', 12, 1, 'Allen', 'Waters', '(417) 280-7406', '', 'allenwaters@abantecart.com', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Honohina', '86565-1710', 'Arizona', 3616, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Allen', 'Waters', '', '110 Shenandoah Avenue', '', 'Honohina', '86565-1710', 'Arizona', 3616, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', '', '47.5700', 1, 1, 1, 'USD', '1.00000000', 0, '2019-05-06 10:19:57', '2022-06-28 12:07:29', '77.111.246.147', ''),
(21, 0, '', 0, 'Web Store Name', 'https://demo.abantecart.com/', 17, 1, 'Michelle', 'Barnett', '1 469 537-8505', '', 'mbarnett@abantecart.com', 'Michelle', 'Barnett', '', '3180 S Redwood Rd', '', 'West Valley City', '84119', 'Utah', 3670, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Michelle', 'Barnett', '', '3180 S Redwood Rd', '', 'West Valley City', '84119', 'Utah', 3670, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', 'Please don''t deliver the shipment on Friday as I won''t be available', '202.1737', 1, 1, 2, 'EUR', '0.93850000', 0, '2022-06-28 12:05:30', '2022-06-28 15:15:55', '77.111.246.40', ''),
(22, 0, '', 0, 'Web Store Name', 'https://demo.abantecart.com/', 18, 1, 'Elmer', 'West', '(914) 328-0251', '', 'elmer@abantecart.com', 'Elmer', 'West', '', '1433 Armand-Frappier', '', 'Sainte-Julie', 'J3E 3R6', 'Qu&eacute;bec', 612, 'Canada', 38, '', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Elmer', 'West', '', '291 Central Ave', '', 'White Plains', '10606', 'North Dakota', 3657, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', 'Please drop the parcel on the doorstep if the house is locked', '8.0000', 1, 1, 2, 'EUR', '0.93850000', 0, '2022-06-28 12:11:43', '2022-06-28 15:15:55', '77.111.247.7', ''),
(23, 0, '', 0, 'Web Store Name', 'https://demo.abantecart.com/', 14, 1, 'Yuri', 'Howard', '16943733146', '', 'howardinc@abantecart.com', 'Yuri', 'Howard', 'Eaton Stevenson Inc', '22555 Jensen Ave', '', 'Reedley', '93654', 'California', 3624, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Yuri', 'Howard', 'Eaton Stevenson Inc', '22555 Jensen Ave', '', 'Reedley', '93654', 'California', 3624, 'United States', 223, '{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}', 'Cash On Delivery', 'default_cod', 'Please provide the order with gift wrap', '33.4700', 1, 1, 1, 'USD', '1.00000000', 0, '2022-06-28 12:44:08', '2022-06-28 15:15:55', '77.111.247.7', ''),
(24, 0, '', 0, 'Web Store Name', 'https://demo.abantecart.com/', 18, 1, 'Elmer', 'West', ' 1 (128) 392-8036', '', 'elmer@abantecart.com', 'Elmer', 'West', '', '1433 Armand-Frappier', '', 'Sainte-Julie', 'J3E 3R6', 'Qu&eacute;bec', 612, 'Canada', 38, '', 'Flat Shipping Rate', 'default_flat_rate_shipping.default_flat_rate_shipping', 'Elmer', 'West', '', '1433 Armand-Frappier', '', 'Sainte-Julie', 'J3E 3R6', 'Qu&eacute;bec', 612, 'Canada', 38, '', 'Cash On Delivery', 'default_cod', '', '166.0000', 0, 1, 1, 'USD', '1.00000000', 0, '2022-07-13 10:51:51', '2022-07-13 11:01:24', '77.111.246.40', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_data`
--

CREATE TABLE `[[dbprefix]]order_data` (
  `order_id` int NOT NULL,
  `type_id` int NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_id`,`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]order_data`
--

INSERT INTO `[[dbprefix]]order_data` VALUES
(14, 1, 'a:2:{s:3:"uri";s:23:"michaelj@abantecart.com";s:6:"status";s:1:"1";}', '2019-03-18 16:13:24', '2019-03-18 16:13:24'),
(15, 1, 'a:2:{s:3:"uri";s:26:"allenwaters@abantecart.com";s:6:"status";s:1:"1";}', '2019-03-18 16:20:54', '2019-03-18 16:20:54'),
(16, 1, 'a:2:{s:3:"uri";s:24:"howardinc@abantecart.com";s:6:"status";s:1:"1";}', '2019-03-18 17:39:08', '2019-03-18 17:39:08'),
(17, 1, 'a:2:{s:3:"uri";s:22:"ricuvif@abantecart.com";s:6:"status";s:1:"1";}', '2019-03-19 12:32:53', '2019-03-19 12:32:53'),
(19, 1, 'a:2:{s:3:"uri";s:26:"allenwaters@abantecart.com";s:6:"status";s:1:"1";}', '2019-05-06 10:05:01', '2019-05-06 10:05:01'),
(20, 1, 'a:2:{s:3:"uri";s:26:"allenwaters@abantecart.com";s:6:"status";s:1:"1";}', '2019-05-06 10:19:57', '2019-05-06 10:19:57'),
(21, 1, 'a:2:{s:3:"uri";s:23:"mbarnett@abantecart.com";s:6:"status";s:1:"1";}', '2022-06-28 12:05:30', '2022-06-28 12:05:30'),
(21, 3, 'Zg4n0EGvzxHOwqPgZvxKPxv69saEan1t', '2022-06-28 12:05:34', '2022-06-28 12:05:34'),
(22, 1, 'a:2:{s:3:"uri";s:20:"elmer@abantecart.com";s:6:"status";s:1:"1";}', '2022-06-28 12:11:43', '2022-06-28 12:11:43'),
(22, 3, 'Tb5bV8sMYxBMXGCLw6YkBS1gKBvhcdMf', '2022-06-28 12:11:49', '2022-06-28 12:11:49');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_data_types`
--

CREATE TABLE `[[dbprefix]]order_data_types` (
  `type_id` int NOT NULL AUTO_INCREMENT,
  `language_id` int NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]order_data_types`
--

INSERT INTO `[[dbprefix]]order_data_types` VALUES
(1, 1, 'email', '[[regtime]]', '[[regtime]]'),
(2, 1, 'sms', '[[regtime]]', '[[regtime]]'),
(3, 1, 'guest_token', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_downloads`
--

CREATE TABLE `[[dbprefix]]order_downloads` (
  `order_download_id` int NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `order_product_id` int NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `download_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `remaining_count` int DEFAULT NULL,
  `percentage` int DEFAULT '0',
  `expire_date` datetime DEFAULT NULL,
  `sort_order` int NOT NULL,
  `activate` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `activate_order_status_id` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `attributes_data` longtext COLLATE utf8mb4_unicode_ci,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_download_id`),
  KEY `[[dbprefix]]order_downloads_idx` (`order_id`,`order_product_id`,`download_id`,`status`,`activate_order_status_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]order_downloads`
--

INSERT INTO `[[dbprefix]]order_downloads` VALUES
(1, 14, 50, 'Audio CD1', 'download/18/76/4.mp3', 'audio-cd.mp3', 1, 1, 49, 0, NULL, 0, '', '5', 'a:0:{}', '2019-03-18 16:13:24', '2019-03-18 16:14:47'),
(2, 16, 52, 'Find your fit', 'download/18/79/f.pdf', 'size-fit-guide-print.pdf', 5, 1, NULL, 0, NULL, 0, '', '0', 'a:0:{}', '2019-03-18 17:47:47', '2019-03-18 17:47:47');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_downloads_history`
--

CREATE TABLE `[[dbprefix]]order_downloads_history` (
  `order_download_history_id` int NOT NULL AUTO_INCREMENT,
  `order_download_id` int NOT NULL,
  `order_id` int NOT NULL,
  `order_product_id` int NOT NULL,
  `filename` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `download_id` int NOT NULL,
  `download_percent` int DEFAULT '0',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_download_history_id`,`order_download_id`,`order_id`,`order_product_id`),
  KEY `[[dbprefix]]order_downloads_history_idx` (`download_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]order_downloads_history`
--

INSERT INTO `[[dbprefix]]order_downloads_history` VALUES
(1, 0, 0, 0, 'download/18/76/5.mp3', 'sample.mp3', 2, 100, '2015-07-08 14:36:06'),
(2, 1, 14, 50, 'download/18/76/4.mp3', 'audio-cd.mp3', 1, 100, '2019-03-18 16:14:47'),
(3, 0, 0, 0, 'download/18/76/5.mp3', 'sample.mp3', 2, 100, '2019-03-18 16:19:34'),
(4, 0, 0, 0, 'download/18/79/f.pdf', 'size-fit-guide-print.pdf', 5, 100, '2019-03-18 17:21:10'),
(5, 0, 0, 0, 'download/18/79/f.pdf', 'size-fit-guide-print.pdf', 5, 100, '2019-03-18 17:45:25'),
(6, 0, 0, 0, 'download/18/76/5.mp3', 'sample.mp3', 2, 100, '2019-03-18 17:47:11'),
(7, 0, 0, 0, 'download/18/79/f.pdf', 'size-fit-guide-print.pdf', 5, 100, '2019-03-19 14:17:30');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_history`
--

CREATE TABLE `[[dbprefix]]order_history` (
  `order_history_id` int NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `order_status_id` int NOT NULL,
  `notify` int NOT NULL DEFAULT '0',
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_history_id`),
  KEY `[[dbprefix]]order_history_idx` (`order_id`,`order_status_id`,`notify`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]order_history`
--

INSERT INTO `[[dbprefix]]order_history` VALUES
(2, 2, 1, 1, '', '2013-09-07 12:02:31', '2015-06-12 13:56:25'),
(3, 3, 1, 1, '', '2013-09-07 12:41:25', '2015-06-12 13:56:25'),
(4, 4, 1, 1, '', '2013-09-07 12:51:07', '2015-06-12 13:56:25'),
(5, 5, 1, 1, '', '2013-09-07 13:20:22', '2015-06-12 13:56:25'),
(6, 6, 1, 1, '', '2013-09-07 13:21:56', '2015-06-12 13:56:25'),
(7, 7, 1, 1, '', '2013-09-07 13:24:11', '2015-06-12 13:56:25'),
(8, 8, 1, 1, '', '2013-09-07 13:36:21', '2015-06-12 13:56:25'),
(9, 9, 1, 1, '', '2013-09-07 13:37:20', '2015-06-12 13:56:25'),
(10, 10, 1, 1, '', '2013-09-07 13:39:30', '2015-06-12 13:56:25'),
(11, 11, 1, 1, '', '2013-09-07 13:40:03', '2015-06-12 13:56:25'),
(12, 12, 1, 1, '', '2012-03-15 18:04:06', '2015-06-12 13:56:25'),
(13, 13, 1, 1, '', '2012-03-15 18:05:40', '2015-06-12 13:56:25'),
(14, 14, 1, 1, '', '2019-03-18 16:13:45', '2019-03-18 16:13:45'),
(15, 14, 5, 1, 'Thank you for your order!', '2019-03-18 16:14:29', '2019-03-18 16:14:29'),
(16, 15, 1, 1, '', '2019-03-18 16:21:03', '2019-03-18 16:21:03'),
(17, 15, 3, 1, 'Your order has been shipped. Tracking number is 4221736293', '2019-03-18 16:26:40', '2019-03-18 16:26:40'),
(18, 16, 1, 1, '', '2019-03-18 17:39:24', '2019-03-18 17:39:24'),
(19, 17, 1, 1, '', '2019-03-19 12:33:15', '2019-03-19 12:33:15'),
(20, 18, 1, 1, '', '2019-03-21 16:10:11', '2019-03-21 16:10:11'),
(21, 19, 1, 1, '', '2019-05-06 10:05:14', '2019-05-06 10:05:14'),
(22, 20, 1, 1, '', '2019-05-06 10:20:00', '2019-05-06 10:20:00'),
(23, 21, 1, 1, '', '2022-06-28 12:05:32', '2022-06-28 12:05:32'),
(24, 22, 1, 1, '', '2022-06-28 12:11:47', '2022-06-28 12:11:47'),
(25, 23, 1, 1, '', '2022-06-28 12:44:14', '2022-06-28 12:44:14');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_options`
--

CREATE TABLE `[[dbprefix]]order_options` (
  `order_option_id` int NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `order_product_id` int NOT NULL,
  `product_option_value_id` int NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `cost` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `prefix` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`order_option_id`),
  KEY `[[dbprefix]]order_options_idx` (`order_id`,`order_product_id`,`product_option_value_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=52 ;

--
-- Dumping data for table `[[dbprefix]]order_options`
--

INSERT INTO `[[dbprefix]]order_options` VALUES
(2, 2, 7, 684, 'Color', '', 'brown', '10.0000', '0.0000', '+', NULL),
(3, 3, 9, 651, 'Size', '', '33.8 oz', '49.0000', '0.0000', '+', NULL),
(4, 3, 10, 650, 'Size', '', '8 oz', '19.0000', '0.0000', '+', NULL),
(5, 3, 15, 646, 'Color', '', 'Brown', '20.0000', '0.0000', '-', NULL),
(6, 4, 16, 613, 'Color', '', 'Mandarin Sky', '29.5000', '0.0000', '+', NULL),
(7, 4, 18, 664, 'Fragrance Size', '', '3.4 oz', '84.0000', '0.0000', '+', NULL),
(8, 4, 19, 673, 'Fragrance Size', '', '6.7 oz', '92.0000', '0.0000', '+', NULL),
(9, 4, 21, 661, 'Fragrance Size', '', '150ml', '45.0000', '0.0000', '+', NULL),
(10, 5, 23, 627, 'Color', '', 'Jade Fever', '48.0000', '0.0000', '+', NULL),
(11, 5, 24, 626, 'Color', '', 'Gris Fatale', '48.0000', '0.0000', '+', NULL),
(12, 5, 25, 622, 'Color', '', 'Shirelle', '15.0000', '0.0000', '+', NULL),
(13, 5, 26, 619, 'Color', '', 'Lacewood', '27.0000', '0.0000', '+', NULL),
(14, 5, 27, 657, 'Color', '', 'Light Bisque', '30.5000', '0.0000', '+', NULL),
(15, 5, 30, 651, 'Size', '', '33.8 oz', '49.0000', '0.0000', '+', NULL),
(16, 6, 31, 666, 'Size', '', '30 ml', '30.0000', '0.0000', '+', NULL),
(17, 7, 33, 649, 'Fragrance Size', '', '1.7 oz', '88.0000', '0.0000', '+', NULL),
(18, 7, 34, 660, 'Fragrance Size', '', '100ml', '37.0000', '0.0000', '+', NULL),
(19, 8, 35, 646, 'Color', '', 'Brown', '20.0000', '0.0000', '-', NULL),
(20, 8, 36, 681, 'Color', '', 'beige', '10.0000', '0.0000', '+', NULL),
(21, 12, 45, 721, 'Size', '', 'Eau de Toilette', '78.5000', '0.0000', '$', NULL),
(22, 12, 45, 1, 'Gift Wrapping', '', '1', '78.5000', '0.0000', '$', NULL),
(23, 12, 47, 738, 'Size', '', '30ml', '90.0000', '0.0000', '$', NULL),
(24, 13, 49, 713, 'Size', '', '1.7 oz', '72.0000', '0.0000', '$', NULL),
(25, 13, 49, 1, 'Gift Wrapping', '', '1', '72.0000', '0.0000', '$', NULL),
(26, 15, 51, 747, 'UK size', '', '3 UK ', '26.0000', '0.0000', '$', ''),
(27, 15, 51, 754, 'Colour', '', 'black', '26.0000', '0.0000', '$', ''),
(28, 16, 52, 783, 'Color&amp;Size', '', 'S / Red', '14.0000', '0.0000', '$', 'a:4:{s:10:"extensions";s:0:"";s:8:"min_size";s:0:"";s:8:"max_size";s:0:"";s:9:"directory";s:0:"";}'),
(29, 17, 53, 778, 'Size EU', '', 'EU XS (Asia M)', '21.0000', '0.0000', '$', ''),
(32, 18, 59, 749, 'UK size', '', '5 UK ', '26.0000', '0.0000', '$', ''),
(33, 18, 59, 752, 'Colour', '', 'white', '26.0000', '0.0000', '$', ''),
(34, 20, 61, 778, 'Size EU', '', 'EU XS (Asia M)', '21.0000', '0.0000', '$', ''),
(45, 21, 71, 657, 'Color', '', 'Light Bisque', '30.5000', '0.0000', '$', ''),
(46, 21, 72, 653, 'Color', '', 'Natural Ambre', '38.5000', '0.0000', '$', ''),
(47, 20, 62, 778, 'Size EU', '', 'EU XS (Asia M)', '0.0000', '0.0000', '$', NULL),
(51, 23, 80, 662, 'Fragrance Size', '', '50ml', '29.0000', '0.0000', '$', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_products`
--

CREATE TABLE `[[dbprefix]]order_products` (
  `order_product_id` int NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `product_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `model` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sku` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `cost` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `weight` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `weight_iso_code` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `width` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `length` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `height` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `length_iso_code` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `quantity` int NOT NULL DEFAULT '0',
  `subtract` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_product_id`),
  KEY `[[dbprefix]]order_products_idx` (`order_id`,`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=84 ;

--
-- Dumping data for table `[[dbprefix]]order_products`
--

INSERT INTO `[[dbprefix]]order_products` VALUES
(6, 2, 97, 'Eye Rejuvenating Serum', 'GRMBC004', '', '126.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '126.0000', '8.5000', 1, 0),
(7, 2, 100, 'Smooth silk lip pencils', 'GRMBC007', '', '10.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '40.0000', '8.5000', 4, 0),
(8, 2, 93, 'Creme Precieuse Nuit 50ml', 'BVLG003', '', '220.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '220.0000', '8.5000', 1, 0),
(9, 3, 69, 'Seaweed Conditioner', 'SCND001', '', '49.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '49.0000', '0.0000', 1, 0),
(10, 3, 69, 'Seaweed Conditioner', 'SCND001', '', '19.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '19.0000', '0.0000', 1, 0),
(11, 3, 77, 'Men+Care Active Clean Shower Tool', 'DMBW0014', '', '6.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '6.0000', '0.0000', 1, 0),
(12, 3, 98, 'Shaving cream', 'GRMBC005', '', '98.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '98.0000', '0.0000', 1, 0),
(13, 3, 62, 'ck one shock for him Deodorant', '601232', '', '14.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '14.0000', '0.0000', 1, 0),
(14, 3, 66, 'Total Moisture Facial Cream', '556240', '', '38.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '38.0000', '0.0000', 1, 0),
(15, 3, 54, 'L''EXTRÊME Instant Extensions Lengthening Mascara', '74144', '', '20.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '20.0000', '0.0000', 1, 0),
(16, 4, 57, 'Delicate Oil-Free Powder Blush', '117148', '', '29.5000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '29.5000', '8.5000', 1, 0),
(17, 4, 67, 'Flash Bronzer Body Gel', '463686', '', '29.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '29.0000', '8.5000', 1, 0),
(18, 4, 80, 'Acqua Di Gio Pour Homme', 'GRM001', '', '84.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '84.0000', '8.5000', 1, 0),
(19, 4, 89, 'Secret Obsession Perfume', 'CK0012', '', '92.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '92.0000', '8.5000', 1, 0),
(20, 4, 75, 'Dove Men +Care Body Wash', 'DMBW0012', '', '6.7000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '6.7000', '8.5000', 1, 0),
(21, 4, 78, 'ck IN2U Eau De Toilette Spray for Him', 'Cl0001', '', '45.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '45.0000', '8.5000', 1, 0),
(22, 5, 97, 'Eye Rejuvenating Serum', 'GRMBC004', '', '126.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '126.0000', '8.5000', 1, 0),
(23, 5, 61, 'Color Design Eye Brightening All in One 5 Shadow &amp; Liner Palette', '529071', '', '48.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '48.0000', '8.5000', 1, 0),
(24, 5, 61, 'Color Design Eye Brightening All in One 5 Shadow &amp; Liner Palette', '529071', '', '48.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '96.0000', '8.5000', 2, 0),
(25, 5, 60, 'Nail Lacquer', '112423', '', '15.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '15.0000', '8.5000', 1, 0),
(26, 5, 55, 'LE ROUGE ABSOLU Reshaping &amp; Replenishing LipColour SPF 15', 'tw152236', '', '27.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '27.0000', '8.5000', 1, 0),
(27, 5, 56, 'Waterproof Protective Undereye Concealer', '35190', '', '30.5000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '30.5000', '8.5000', 1, 0),
(28, 5, 51, 'BeneFit Girl Meets Pearl', '483857', '', '19.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '19.0000', '8.5000', 1, 0),
(29, 5, 93, 'Creme Precieuse Nuit 50ml', 'BVLG003', '', '220.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '220.0000', '8.5000', 1, 0),
(30, 5, 69, 'Seaweed Conditioner', 'SCND001', '', '49.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '49.0000', '8.5000', 1, 0),
(31, 6, 84, 'Armani Code Pour Femme', 'GRM005', '', '30.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '30.0000', '8.5000', 1, 0),
(32, 6, 92, 'Body Cream by Bulgari', 'BVLG002', '', '57.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '171.0000', '8.5000', 3, 0),
(33, 7, 63, 'Pour Homme Eau de Toilette', '374622', '', '88.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '88.0000', '8.5000', 1, 0),
(34, 7, 78, 'ck IN2U Eau De Toilette Spray for Him', 'Cl0001', '', '37.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '74.0000', '8.5000', 2, 0),
(35, 8, 54, 'L''EXTRÊME Instant Extensions Lengthening Mascara', '74144', '', '20.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '20.0000', '0.0000', 1, 0),
(36, 8, 100, 'Smooth silk lip pencils', 'GRMBC007', '', '10.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '40.0000', '0.0000', 4, 0),
(37, 9, 94, 'Night Care Crema Nera Obsidian Mineral Complex', 'GRMBC001', '', '263.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '263.0000', '0.0000', 1, 0),
(38, 9, 67, 'Flash Bronzer Body Gel', '463686', '', '29.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '29.0000', '0.0000', 1, 0),
(39, 9, 91, 'Jasmin Noir Body Lotion 6.8 fl oz', 'BVLG001', '', '29.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '58.0000', '0.0000', 2, 0),
(40, 10, 72, 'Brunette expressions Conditioner', 'PCND002', '', '24.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '24.0000', '8.5000', 1, 0),
(41, 10, 81, 'Armani Eau de Toilette Spray ', 'GRM002', '', '61.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '61.0000', '8.5000', 1, 0),
(42, 10, 88, 'ck one Summer 3.4 oz', 'CK0011', '', '27.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '27.0000', '8.5000', 1, 0),
(43, 10, 70, 'Eau Parfumee au The Vert Shampoo', '522823', '', '31.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '31.0000', '8.5000', 1, 0),
(44, 11, 51, 'BeneFit Girl Meets Pearl', '483857', '', '19.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '19.0000', '0.0000', 1, 0),
(45, 12, 105, 'Bvlgari Aqua', 'PRF00273', '', '78.5000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '78.5000', '0.0000', 1, 0),
(46, 12, 65, 'Absolue Eye Precious Cells', '427847', '', '105.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '105.0000', '8.5000', 1, 0),
(47, 12, 110, 'Flora By Gucci Eau Fraiche', 'PRF00278', '', '90.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '270.0000', '8.5000', 3, 0),
(48, 12, 95, 'Skin Minerals For Men Cleansing Cream', 'GRMBC002', '', '104.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '0.0000', '8.5000', 0, 0),
(49, 13, 104, 'Calvin Klein Obsession For Women EDP Spray', 'PRF00271', '', '72.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '576.0000', '8.5000', 8, 0),
(50, 14, 111, 'New French With Ease (1 book + 1 mp3 CD)', '', '', '85.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '85.0000', '7.2250', 1, 1),
(51, 15, 116, 'New Ladies High Wedge Heel Toe Thong Diamante Flip Flop Sandals', '', '', '26.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '26.0000', '2.2100', 1, 1),
(52, 16, 123, 'Casual 3/4 Sleeve Baseball T-Shirt', 'LTQFX', '#2738', '14.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '14.0000', '1.1900', 1, 1),
(53, 17, 122, 'Mens Fine Cotton Giraffe Polo Shirts', 'JDSK36', '', '21.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '21.0000', '0.0000', 1, 1),
(54, 17, 75, 'Dove Men +Care Body Wash', 'DMBW0012', '', '6.7000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '6.7000', '0.0000', 1, 1),
(55, 17, 76, 'Men+Care Clean Comfort Deodorant', 'DMBW0013', '1235B', '7.2000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '7.2000', '0.0000', 1, 1),
(58, 18, 51, 'BeneFit Girl Meets Pearl', '483857', '', '19.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '19.0000', '1.6150', 1, 1),
(59, 18, 116, 'New Ladies High Wedge Heel Toe Thong Diamante Flip Flop Sandals', '', '', '26.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '26.0000', '2.2100', 1, 1),
(62, 20, 122, 'Product with options and stock locations', 'JDSK36', '', '21.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '42.0000', '0.0000', 2, 0),
(63, 19, 58, 'Product with stock locations', '374002', '', '34.0000', '0.0000', '0.0000', '', '0.0000', '0.0000', '0.0000', '', '102.0000', '0.0000', 3, 0),
(71, 21, 56, 'Waterproof Protective Undereye Concealer', '35190', '', '30.5000', '0.0000', '85.0000', 'g', '0.0000', '0.0000', '0.0000', 'cm', '30.5000', '2.5925', 1, 1),
(72, 21, 53, 'Tropiques Minerale Loose Bronzer', '380440', '', '38.5000', '22.0000', '100.0000', 'g', '0.0000', '0.0000', '0.0000', 'in', '154.0000', '13.0900', 4, 1),
(76, 22, 77, 'Men Care Active Clean Shower Tool', 'DMBW0014', '1234B', '6.0000', '2.0000', '0.3000', 'kg', '0.0000', '0.0000', '0.0000', 'in', '6.0000', '0.0000', 1, 1),
(80, 23, 78, 'ck IN2U Eau De Toilette Spray for Him', 'Cl0001', '', '29.0000', '0.0000', '125.0000', 'g', '0.0000', '0.0000', '0.0000', 'cm', '29.0000', '2.4650', 1, 1),
(83, 24, 96, 'Eye master', 'GRMBC003', '', '82.0000', '67.0000', '80.0000', 'g', '0.0000', '0.0000', '0.0000', 'cm', '164.0000', '0.0000', 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_product_stock_locations`
--

CREATE TABLE `[[dbprefix]]order_product_stock_locations` (
  `order_product_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_option_value_id` int DEFAULT NULL,
  `location_id` int NOT NULL,
  `location_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `sort_order` int DEFAULT '0',
  KEY `[[dbprefix]]product_options_value_idx` (`product_option_value_id`),
  KEY `[[dbprefix]]product_options_value_idx2` (`order_product_id`,`product_id`,`product_option_value_id`,`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]order_product_stock_locations`
--

INSERT INTO `[[dbprefix]]order_product_stock_locations` VALUES
(62, 122, 778, 2, 'Canada', 2, 0),
(62, 122, 778, 1, 'USA All States', 0, 0),
(63, 58, NULL, 2, 'Canada', 3, 0),
(63, 58, NULL, 1, 'USA All States', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_statuses`
--

CREATE TABLE `[[dbprefix]]order_statuses` (
  `order_status_id` int NOT NULL,
  `language_id` int NOT NULL,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`order_status_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data