# Locator
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 
- Package version: 1.0.8
- Build package: io.swagger.codegen.v3.generators.php.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/abantecart/ups-locator.git"
    }
  ],
  "require": {
    "abantecart/ups-locator": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/Locator/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Locator\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Locator\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Locator\Locator\LOCATORRequestWrapper(); // \UPS\Locator\Locator\LOCATORRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$version = "version_example"; // string | Version of API  Valid values: - v2
$req_option = "req_option_example"; // string | Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations.
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$locale = "en_US"; // string | Locale of request

try {
    $result = $apiInstance->locator($body, $version, $req_option, $trans_id, $transaction_src, $locale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->locator: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Locator\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Locator\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Locator\Locator\LOCATORRequestWrapper(); // \UPS\Locator\Locator\LOCATORRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$deprecated_version = "deprecated_version_example"; // string | Version of API  Valid values: - v1
$req_option = "req_option_example"; // string | Indicates the type of request. Valid values: 1-Locations (Drop Locations and Will call locations) 8-All available Additional Services 16-All available Program Types 24-All available Additional Services and Program types 32-All available Retail Locations 40-All available Retail Locations and Additional Services  48-All available Retail Locations and Program Types  56-All available Retail Locations, Additional Services and Program Types  64-Search for UPS Access Point Locations.
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$locale = "en_US"; // string | Locale of request

try {
    $result = $apiInstance->locator_0($body, $deprecated_version, $req_option, $trans_id, $transaction_src, $locale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->locator_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

## Documentation for API Endpoints

All URIs are relative to *https://wwwcie.ups.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**locator**](docs/Api/DefaultApi.md#locator) | **POST** /locations/{version}/search/availabilities/{reqOption} | Locator
*DefaultApi* | [**locator_0**](docs/Api/DefaultApi.md#locator_0) | **POST** /locations/{deprecatedVersion}/search/availabilities/{reqOption} | Locator

## Documentation For Models

 - [AccessPointInformationAccessPointStatus](docs/Model/AccessPointInformationAccessPointStatus.md)
 - [AccessPointInformationAvailability](docs/Model/AccessPointInformationAvailability.md)
 - [AccessPointInformationBusinessClassificationList](docs/Model/AccessPointInformationBusinessClassificationList.md)
 - [AccessPointInformationPrivateNetworkList](docs/Model/AccessPointInformationPrivateNetworkList.md)
 - [AccessPointSearchExcludeFromResult](docs/Model/AccessPointSearchExcludeFromResult.md)
 - [AccessPointSearchIncludeCriteria](docs/Model/AccessPointSearchIncludeCriteria.md)
 - [AdditionalCommentsCommentType](docs/Model/AdditionalCommentsCommentType.md)
 - [AvailabilityDCRAvailability](docs/Model/AvailabilityDCRAvailability.md)
 - [AvailabilityShippingAvailability](docs/Model/AvailabilityShippingAvailability.md)
 - [AvailableLocationAttributesOptionCode](docs/Model/AvailableLocationAttributesOptionCode.md)
 - [AvailableLocationAttributesOptionCodeTransportationPickUpSchedule](docs/Model/AvailableLocationAttributesOptionCodeTransportationPickUpSchedule.md)
 - [AvailableLocationAttributesOptionType](docs/Model/AvailableLocationAttributesOptionType.md)
 - [AvailableLocationAttributesPickUpPickUpDetails](docs/Model/AvailableLocationAttributesPickUpPickUpDetails.md)
 - [AvailableLocationAttributesTransportationPickUpSchedulePickUp](docs/Model/AvailableLocationAttributesTransportationPickUpSchedulePickUp.md)
 - [BusinessClassificationListBusinessClassification](docs/Model/BusinessClassificationListBusinessClassification.md)
 - [CommonErrorResponse](docs/Model/CommonErrorResponse.md)
 - [DCRAvailabilityUnavailableReason](docs/Model/DCRAvailabilityUnavailableReason.md)
 - [DistanceUnitOfMeasurement](docs/Model/DistanceUnitOfMeasurement.md)
 - [DropLocationAccessPointInformation](docs/Model/DropLocationAccessPointInformation.md)
 - [DropLocationAdditionalComments](docs/Model/DropLocationAdditionalComments.md)
 - [DropLocationAddressKeyFormat](docs/Model/DropLocationAddressKeyFormat.md)
 - [DropLocationDistance](docs/Model/DropLocationDistance.md)
 - [DropLocationGeocode](docs/Model/DropLocationGeocode.md)
 - [DropLocationIVR](docs/Model/DropLocationIVR.md)
 - [DropLocationLocalizedInstruction](docs/Model/DropLocationLocalizedInstruction.md)
 - [DropLocationLocationAttribute](docs/Model/DropLocationLocationAttribute.md)
 - [DropLocationLocationImage](docs/Model/DropLocationLocationImage.md)
 - [DropLocationOperatingHours](docs/Model/DropLocationOperatingHours.md)
 - [DropLocationPromotionInformation](docs/Model/DropLocationPromotionInformation.md)
 - [DropLocationServiceOfferingList](docs/Model/DropLocationServiceOfferingList.md)
 - [DropLocationSortCode](docs/Model/DropLocationSortCode.md)
 - [DropLocationSpecialInstructions](docs/Model/DropLocationSpecialInstructions.md)
 - [ErrorErrorLocation](docs/Model/ErrorErrorLocation.md)
 - [ErrorMessage](docs/Model/ErrorMessage.md)
 - [ErrorResponse](docs/Model/ErrorResponse.md)
 - [ExcludeFromResultPostalCodeList](docs/Model/ExcludeFromResultPostalCodeList.md)
 - [FreightWillCallSearchFacilityAddress](docs/Model/FreightWillCallSearchFacilityAddress.md)
 - [GeocodeCandidateAddressKeyFormat](docs/Model/GeocodeCandidateAddressKeyFormat.md)
 - [GeocodeCandidateGeocode](docs/Model/GeocodeCandidateGeocode.md)
 - [IncludeCriteriaMerchantAccountNumberList](docs/Model/IncludeCriteriaMerchantAccountNumberList.md)
 - [IncludeCriteriaSearchFilter](docs/Model/IncludeCriteriaSearchFilter.md)
 - [IncludeCriteriaServiceOfferingList](docs/Model/IncludeCriteriaServiceOfferingList.md)
 - [LOCATORRequestWrapper](docs/Model/LOCATORRequestWrapper.md)
 - [LOCATORResponseWrapper](docs/Model/LOCATORResponseWrapper.md)
 - [LocationAttributeOptionCode](docs/Model/LocationAttributeOptionCode.md)
 - [LocationAttributeOptionType](docs/Model/LocationAttributeOptionType.md)
 - [LocationSearchCriteriaAccessPointSearch](docs/Model/LocationSearchCriteriaAccessPointSearch.md)
 - [LocationSearchCriteriaFreightWillCallSearch](docs/Model/LocationSearchCriteriaFreightWillCallSearch.md)
 - [LocationSearchCriteriaOpenTimeCriteria](docs/Model/LocationSearchCriteriaOpenTimeCriteria.md)
 - [LocationSearchCriteriaSearchOption](docs/Model/LocationSearchCriteriaSearchOption.md)
 - [LocationSearchCriteriaServiceSearch](docs/Model/LocationSearchCriteriaServiceSearch.md)
 - [LocatorRequest](docs/Model/LocatorRequest.md)
 - [LocatorRequestLocationSearchCriteria](docs/Model/LocatorRequestLocationSearchCriteria.md)
 - [LocatorRequestOriginAddress](docs/Model/LocatorRequestOriginAddress.md)
 - [LocatorRequestRequest](docs/Model/LocatorRequestRequest.md)
 - [LocatorRequestServiceGeoUnit](docs/Model/LocatorRequestServiceGeoUnit.md)
 - [LocatorRequestSortCriteria](docs/Model/LocatorRequestSortCriteria.md)
 - [LocatorRequestTranslate](docs/Model/LocatorRequestTranslate.md)
 - [LocatorRequestUnitOfMeasurement](docs/Model/LocatorRequestUnitOfMeasurement.md)
 - [LocatorResponse](docs/Model/LocatorResponse.md)
 - [LocatorResponseGeocode](docs/Model/LocatorResponseGeocode.md)
 - [LocatorResponseResponse](docs/Model/LocatorResponseResponse.md)
 - [LocatorResponseSearchResults](docs/Model/LocatorResponseSearchResults.md)
 - [OperatingHoursStandardHours](docs/Model/OperatingHoursStandardHours.md)
 - [OptionCodeTransportationPickUpSchedule](docs/Model/OptionCodeTransportationPickUpSchedule.md)
 - [OriginAddressAddressKeyFormat](docs/Model/OriginAddressAddressKeyFormat.md)
 - [OriginAddressGeocode](docs/Model/OriginAddressGeocode.md)
 - [PickUpPickUpDetails](docs/Model/PickUpPickUpDetails.md)
 - [PostalCodeListPostalCode](docs/Model/PostalCodeListPostalCode.md)
 - [PrivateNetworkListPrivateNetwork](docs/Model/PrivateNetworkListPrivateNetwork.md)
 - [RequestTransactionReference](docs/Model/RequestTransactionReference.md)
 - [ResponseError](docs/Model/ResponseError.md)
 - [ResponseTransactionReference](docs/Model/ResponseTransactionReference.md)
 - [SearchOptionOptionCode](docs/Model/SearchOptionOptionCode.md)
 - [SearchOptionOptionType](docs/Model/SearchOptionOptionType.md)
 - [SearchOptionRelation](docs/Model/SearchOptionRelation.md)
 - [SearchResultsAvailableLocationAttributes](docs/Model/SearchResultsAvailableLocationAttributes.md)
 - [SearchResultsDropLocation](docs/Model/SearchResultsDropLocation.md)
 - [SearchResultsGeocodeCandidate](docs/Model/SearchResultsGeocodeCandidate.md)
 - [ServiceOfferingListServiceOffering](docs/Model/ServiceOfferingListServiceOffering.md)
 - [ServiceSearchServiceCode](docs/Model/ServiceSearchServiceCode.md)
 - [ServiceSearchServiceOptionCode](docs/Model/ServiceSearchServiceOptionCode.md)
 - [ShippingAvailabilityUnavailableReason](docs/Model/ShippingAvailabilityUnavailableReason.md)
 - [StandardHoursDayOfWeek](docs/Model/StandardHoursDayOfWeek.md)
 - [TransportationPickUpSchedulePickUp](docs/Model/TransportationPickUpSchedulePickUp.md)

## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 


## Author



