<?php
/**
 * InternationalFormsCN22Form
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * InternationalFormsCN22Form Class Doc Comment
 *
 * @category Class
 * @description Container for the CN22 form.  Required if the customer wants to use the UPS generated CN22.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class InternationalFormsCN22Form implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'InternationalForms_CN22Form';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'label_size' => 'string',
        'prints_per_page' => 'string',
        'label_print_type' => 'string',
        'cn22_type' => 'string',
        'cn22_other_description' => 'string',
        'fold_here_text' => 'string',
        'cn22_content' => '\UPS\Shipping\Shipping\CN22FormCN22Content[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'label_size' => null,
        'prints_per_page' => null,
        'label_print_type' => null,
        'cn22_type' => null,
        'cn22_other_description' => null,
        'fold_here_text' => null,
        'cn22_content' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'label_size' => 'LabelSize',
        'prints_per_page' => 'PrintsPerPage',
        'label_print_type' => 'LabelPrintType',
        'cn22_type' => 'CN22Type',
        'cn22_other_description' => 'CN22OtherDescription',
        'fold_here_text' => 'FoldHereText',
        'cn22_content' => 'CN22Content'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'label_size' => 'setLabelSize',
        'prints_per_page' => 'setPrintsPerPage',
        'label_print_type' => 'setLabelPrintType',
        'cn22_type' => 'setCn22Type',
        'cn22_other_description' => 'setCn22OtherDescription',
        'fold_here_text' => 'setFoldHereText',
        'cn22_content' => 'setCn22Content'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'label_size' => 'getLabelSize',
        'prints_per_page' => 'getPrintsPerPage',
        'label_print_type' => 'getLabelPrintType',
        'cn22_type' => 'getCn22Type',
        'cn22_other_description' => 'getCn22OtherDescription',
        'fold_here_text' => 'getFoldHereText',
        'cn22_content' => 'getCn22Content'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label_size'] = isset($data['label_size']) ? $data['label_size'] : null;
        $this->container['prints_per_page'] = isset($data['prints_per_page']) ? $data['prints_per_page'] : null;
        $this->container['label_print_type'] = isset($data['label_print_type']) ? $data['label_print_type'] : null;
        $this->container['cn22_type'] = isset($data['cn22_type']) ? $data['cn22_type'] : null;
        $this->container['cn22_other_description'] = isset($data['cn22_other_description']) ? $data['cn22_other_description'] : null;
        $this->container['fold_here_text'] = isset($data['fold_here_text']) ? $data['fold_here_text'] : null;
        $this->container['cn22_content'] = isset($data['cn22_content']) ? $data['cn22_content'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['label_size'] === null) {
            $invalidProperties[] = "'label_size' can't be null";
        }
        if ($this->container['prints_per_page'] === null) {
            $invalidProperties[] = "'prints_per_page' can't be null";
        }
        if ($this->container['label_print_type'] === null) {
            $invalidProperties[] = "'label_print_type' can't be null";
        }
        if ($this->container['cn22_type'] === null) {
            $invalidProperties[] = "'cn22_type' can't be null";
        }
        if ($this->container['cn22_content'] === null) {
            $invalidProperties[] = "'cn22_content' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets label_size
     *
     * @return string
     */
    public function getLabelSize()
    {
        return $this->container['label_size'];
    }

    /**
     * Sets label_size
     *
     * @param string $label_size Provide the valid values:  6 = 4X6 1 = 8.5X11   Required if the CN22 form container is present.
     *
     * @return $this
     */
    public function setLabelSize($label_size)
    {
        $this->container['label_size'] = $label_size;

        return $this;
    }

    /**
     * Gets prints_per_page
     *
     * @return string
     */
    public function getPrintsPerPage()
    {
        return $this->container['prints_per_page'];
    }

    /**
     * Sets prints_per_page
     *
     * @param string $prints_per_page Number of label per page. Currently 1 per page is supported.  Required if the CN22 form container is present.
     *
     * @return $this
     */
    public function setPrintsPerPage($prints_per_page)
    {
        $this->container['prints_per_page'] = $prints_per_page;

        return $this;
    }

    /**
     * Gets label_print_type
     *
     * @return string
     */
    public function getLabelPrintType()
    {
        return $this->container['label_print_type'];
    }

    /**
     * Sets label_print_type
     *
     * @param string $label_print_type Valid Values are pdf, png, gif, zpl, star, epl2 and spl.   Required if the CN22 form container is present.
     *
     * @return $this
     */
    public function setLabelPrintType($label_print_type)
    {
        $this->container['label_print_type'] = $label_print_type;

        return $this;
    }

    /**
     * Gets cn22_type
     *
     * @return string
     */
    public function getCn22Type()
    {
        return $this->container['cn22_type'];
    }

    /**
     * Sets cn22_type
     *
     * @param string $cn22_type Valid values:  1 = GIFT 2 = DOCUMENTS 3 = COMMERCIAL SAMPLE 4 = OTHER  Required if the CN22 form container is present.
     *
     * @return $this
     */
    public function setCn22Type($cn22_type)
    {
        $this->container['cn22_type'] = $cn22_type;

        return $this;
    }

    /**
     * Gets cn22_other_description
     *
     * @return string
     */
    public function getCn22OtherDescription()
    {
        return $this->container['cn22_other_description'];
    }

    /**
     * Sets cn22_other_description
     *
     * @param string $cn22_other_description Required if CN22Type is OTHER.  Required if the CN22 form container is present.
     *
     * @return $this
     */
    public function setCn22OtherDescription($cn22_other_description)
    {
        $this->container['cn22_other_description'] = $cn22_other_description;

        return $this;
    }

    /**
     * Gets fold_here_text
     *
     * @return string
     */
    public function getFoldHereText()
    {
        return $this->container['fold_here_text'];
    }

    /**
     * Sets fold_here_text
     *
     * @param string $fold_here_text String will replace default \"Fold Here\" text displayed on the label.
     *
     * @return $this
     */
    public function setFoldHereText($fold_here_text)
    {
        $this->container['fold_here_text'] = $fold_here_text;

        return $this;
    }

    /**
     * Gets cn22_content
     *
     * @return \UPS\Shipping\Shipping\CN22FormCN22Content[]
     */
    public function getCn22Content()
    {
        return $this->container['cn22_content'];
    }

    /**
     * Sets cn22_content
     *
     * @param \UPS\Shipping\Shipping\CN22FormCN22Content[] $cn22_content cn22_content
     *
     * @return $this
     */
    public function setCn22Content($cn22_content)
    {
        $this->container['cn22_content'] = $cn22_content;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
