<?php
/**
 * TimeInTransitRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Time In Transit
 *
 * The Time In Transit API provides estimated delivery times for various UPS shipping services, between specified locations.  Key Business Values: - **Enhanced Customer Experience**: Allows businesses provide accurate delivery estimates to their customers, enhancing customer service. - **Operational Efficiency**: Helps in logistics planning by providing transit times for different UPS services.
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\TimeInTransit\TimeInTransit;

use \ArrayAccess;
use \UPS\TimeInTransit\ObjectSerializer;

/**
 * TimeInTransitRequest Class Doc Comment
 *
 * @category Class
 * @description N/A
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TimeInTransitRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'TimeInTransitRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'origin_country_code' => 'string',
        'origin_state_province' => 'string',
        'origin_city_name' => 'string',
        'origin_town_name' => 'string',
        'origin_postal_code' => 'string',
        'destination_country_code' => 'string',
        'destination_state_province' => 'string',
        'destination_city_name' => 'string',
        'destination_town_name' => 'string',
        'destination_postal_code' => 'string',
        'residential_indicator' => 'string',
        'ship_date' => 'string',
        'ship_time' => 'string',
        'weight' => 'float',
        'weight_unit_of_measure' => 'string',
        'shipment_contents_value' => 'float',
        'shipment_contents_currency_code' => 'string',
        'bill_type' => 'string',
        'avv_flag' => 'bool',
        'number_of_packages' => 'int',
        'drop_off_at_facility_indicator' => 'int',
        'hold_for_pickup_indicator' => 'int',
        'return_unfilterd_services' => 'bool',
        'max_list' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'origin_country_code' => null,
        'origin_state_province' => null,
        'origin_city_name' => null,
        'origin_town_name' => null,
        'origin_postal_code' => null,
        'destination_country_code' => null,
        'destination_state_province' => null,
        'destination_city_name' => null,
        'destination_town_name' => null,
        'destination_postal_code' => null,
        'residential_indicator' => null,
        'ship_date' => null,
        'ship_time' => null,
        'weight' => null,
        'weight_unit_of_measure' => null,
        'shipment_contents_value' => null,
        'shipment_contents_currency_code' => null,
        'bill_type' => null,
        'avv_flag' => null,
        'number_of_packages' => null,
        'drop_off_at_facility_indicator' => null,
        'hold_for_pickup_indicator' => null,
        'return_unfilterd_services' => null,
        'max_list' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'origin_country_code' => 'originCountryCode',
        'origin_state_province' => 'originStateProvince',
        'origin_city_name' => 'originCityName',
        'origin_town_name' => 'originTownName',
        'origin_postal_code' => 'originPostalCode',
        'destination_country_code' => 'destinationCountryCode',
        'destination_state_province' => 'destinationStateProvince',
        'destination_city_name' => 'destinationCityName',
        'destination_town_name' => 'destinationTownName',
        'destination_postal_code' => 'destinationPostalCode',
        'residential_indicator' => 'residentialIndicator',
        'ship_date' => 'shipDate',
        'ship_time' => 'shipTime',
        'weight' => 'weight',
        'weight_unit_of_measure' => 'weightUnitOfMeasure',
        'shipment_contents_value' => 'shipmentContentsValue',
        'shipment_contents_currency_code' => 'shipmentContentsCurrencyCode',
        'bill_type' => 'billType',
        'avv_flag' => 'avvFlag',
        'number_of_packages' => 'numberOfPackages',
        'drop_off_at_facility_indicator' => 'dropOffAtFacilityIndicator',
        'hold_for_pickup_indicator' => 'holdForPickupIndicator',
        'return_unfilterd_services' => 'returnUnfilterdServices',
        'max_list' => 'maxList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'origin_country_code' => 'setOriginCountryCode',
        'origin_state_province' => 'setOriginStateProvince',
        'origin_city_name' => 'setOriginCityName',
        'origin_town_name' => 'setOriginTownName',
        'origin_postal_code' => 'setOriginPostalCode',
        'destination_country_code' => 'setDestinationCountryCode',
        'destination_state_province' => 'setDestinationStateProvince',
        'destination_city_name' => 'setDestinationCityName',
        'destination_town_name' => 'setDestinationTownName',
        'destination_postal_code' => 'setDestinationPostalCode',
        'residential_indicator' => 'setResidentialIndicator',
        'ship_date' => 'setShipDate',
        'ship_time' => 'setShipTime',
        'weight' => 'setWeight',
        'weight_unit_of_measure' => 'setWeightUnitOfMeasure',
        'shipment_contents_value' => 'setShipmentContentsValue',
        'shipment_contents_currency_code' => 'setShipmentContentsCurrencyCode',
        'bill_type' => 'setBillType',
        'avv_flag' => 'setAvvFlag',
        'number_of_packages' => 'setNumberOfPackages',
        'drop_off_at_facility_indicator' => 'setDropOffAtFacilityIndicator',
        'hold_for_pickup_indicator' => 'setHoldForPickupIndicator',
        'return_unfilterd_services' => 'setReturnUnfilterdServices',
        'max_list' => 'setMaxList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'origin_country_code' => 'getOriginCountryCode',
        'origin_state_province' => 'getOriginStateProvince',
        'origin_city_name' => 'getOriginCityName',
        'origin_town_name' => 'getOriginTownName',
        'origin_postal_code' => 'getOriginPostalCode',
        'destination_country_code' => 'getDestinationCountryCode',
        'destination_state_province' => 'getDestinationStateProvince',
        'destination_city_name' => 'getDestinationCityName',
        'destination_town_name' => 'getDestinationTownName',
        'destination_postal_code' => 'getDestinationPostalCode',
        'residential_indicator' => 'getResidentialIndicator',
        'ship_date' => 'getShipDate',
        'ship_time' => 'getShipTime',
        'weight' => 'getWeight',
        'weight_unit_of_measure' => 'getWeightUnitOfMeasure',
        'shipment_contents_value' => 'getShipmentContentsValue',
        'shipment_contents_currency_code' => 'getShipmentContentsCurrencyCode',
        'bill_type' => 'getBillType',
        'avv_flag' => 'getAvvFlag',
        'number_of_packages' => 'getNumberOfPackages',
        'drop_off_at_facility_indicator' => 'getDropOffAtFacilityIndicator',
        'hold_for_pickup_indicator' => 'getHoldForPickupIndicator',
        'return_unfilterd_services' => 'getReturnUnfilterdServices',
        'max_list' => 'getMaxList'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['origin_country_code'] = isset($data['origin_country_code']) ? $data['origin_country_code'] : null;
        $this->container['origin_state_province'] = isset($data['origin_state_province']) ? $data['origin_state_province'] : null;
        $this->container['origin_city_name'] = isset($data['origin_city_name']) ? $data['origin_city_name'] : null;
        $this->container['origin_town_name'] = isset($data['origin_town_name']) ? $data['origin_town_name'] : null;
        $this->container['origin_postal_code'] = isset($data['origin_postal_code']) ? $data['origin_postal_code'] : null;
        $this->container['destination_country_code'] = isset($data['destination_country_code']) ? $data['destination_country_code'] : null;
        $this->container['destination_state_province'] = isset($data['destination_state_province']) ? $data['destination_state_province'] : null;
        $this->container['destination_city_name'] = isset($data['destination_city_name']) ? $data['destination_city_name'] : null;
        $this->container['destination_town_name'] = isset($data['destination_town_name']) ? $data['destination_town_name'] : null;
        $this->container['destination_postal_code'] = isset($data['destination_postal_code']) ? $data['destination_postal_code'] : null;
        $this->container['residential_indicator'] = isset($data['residential_indicator']) ? $data['residential_indicator'] : null;
        $this->container['ship_date'] = isset($data['ship_date']) ? $data['ship_date'] : null;
        $this->container['ship_time'] = isset($data['ship_time']) ? $data['ship_time'] : null;
        $this->container['weight'] = isset($data['weight']) ? $data['weight'] : null;
        $this->container['weight_unit_of_measure'] = isset($data['weight_unit_of_measure']) ? $data['weight_unit_of_measure'] : null;
        $this->container['shipment_contents_value'] = isset($data['shipment_contents_value']) ? $data['shipment_contents_value'] : null;
        $this->container['shipment_contents_currency_code'] = isset($data['shipment_contents_currency_code']) ? $data['shipment_contents_currency_code'] : null;
        $this->container['bill_type'] = isset($data['bill_type']) ? $data['bill_type'] : null;
        $this->container['avv_flag'] = isset($data['avv_flag']) ? $data['avv_flag'] : null;
        $this->container['number_of_packages'] = isset($data['number_of_packages']) ? $data['number_of_packages'] : null;
        $this->container['drop_off_at_facility_indicator'] = isset($data['drop_off_at_facility_indicator']) ? $data['drop_off_at_facility_indicator'] : null;
        $this->container['hold_for_pickup_indicator'] = isset($data['hold_for_pickup_indicator']) ? $data['hold_for_pickup_indicator'] : null;
        $this->container['return_unfilterd_services'] = isset($data['return_unfilterd_services']) ? $data['return_unfilterd_services'] : null;
        $this->container['max_list'] = isset($data['max_list']) ? $data['max_list'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['origin_country_code'] === null) {
            $invalidProperties[] = "'origin_country_code' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets origin_country_code
     *
     * @return string
     */
    public function getOriginCountryCode()
    {
        return $this->container['origin_country_code'];
    }

    /**
     * Sets origin_country_code
     *
     * @param string $origin_country_code The country code of the origin shipment.  Valid Values:  Must conform to the ISO-defined, two-letter country or territory codes.  Refer to Country or Territory Codes in the Appendix above for valid values.
     *
     * @return $this
     */
    public function setOriginCountryCode($origin_country_code)
    {
        $this->container['origin_country_code'] = $origin_country_code;

        return $this;
    }

    /**
     * Gets origin_state_province
     *
     * @return string
     */
    public function getOriginStateProvince()
    {
        return $this->container['origin_state_province'];
    }

    /**
     * Sets origin_state_province
     *
     * @param string $origin_state_province The shipment origin state or province.  For U.S. addresses, the value must be a valid 2-character value (per U.S. Mail standards)   For non-U.S. addresses the full State or Province name should be provided.
     *
     * @return $this
     */
    public function setOriginStateProvince($origin_state_province)
    {
        $this->container['origin_state_province'] = $origin_state_province;

        return $this;
    }

    /**
     * Gets origin_city_name
     *
     * @return string
     */
    public function getOriginCityName()
    {
        return $this->container['origin_city_name'];
    }

    /**
     * Sets origin_city_name
     *
     * @param string $origin_city_name The shipment origin city. Required for International requests for those countries that do not utilize postal codes.
     *
     * @return $this
     */
    public function setOriginCityName($origin_city_name)
    {
        $this->container['origin_city_name'] = $origin_city_name;

        return $this;
    }

    /**
     * Gets origin_town_name
     *
     * @return string
     */
    public function getOriginTownName()
    {
        return $this->container['origin_town_name'];
    }

    /**
     * Sets origin_town_name
     *
     * @param string $origin_town_name The shipment origin town. Town is a subdivision of city.
     *
     * @return $this
     */
    public function setOriginTownName($origin_town_name)
    {
        $this->container['origin_town_name'] = $origin_town_name;

        return $this;
    }

    /**
     * Gets origin_postal_code
     *
     * @return string
     */
    public function getOriginPostalCode()
    {
        return $this->container['origin_postal_code'];
    }

    /**
     * Sets origin_postal_code
     *
     * @param string $origin_postal_code Required for Domestic requests.  The shipment origin postal code.   Either the 5, or 9-digit US zip codes must be used for U.S. addresses.  For non-U.S. addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setOriginPostalCode($origin_postal_code)
    {
        $this->container['origin_postal_code'] = $origin_postal_code;

        return $this;
    }

    /**
     * Gets destination_country_code
     *
     * @return string
     */
    public function getDestinationCountryCode()
    {
        return $this->container['destination_country_code'];
    }

    /**
     * Sets destination_country_code
     *
     * @param string $destination_country_code The country code of the destination.    Valid values:   Must conform to ISO-defined country codes.
     *
     * @return $this
     */
    public function setDestinationCountryCode($destination_country_code)
    {
        $this->container['destination_country_code'] = $destination_country_code;

        return $this;
    }

    /**
     * Gets destination_state_province
     *
     * @return string
     */
    public function getDestinationStateProvince()
    {
        return $this->container['destination_state_province'];
    }

    /**
     * Sets destination_state_province
     *
     * @param string $destination_state_province The shipment destination state or province.  For U.S. addresses, the value must be a valid 2-character value (per U.S. Mail standards).    For non-U.S. addresses the full State or Province name should be provided.
     *
     * @return $this
     */
    public function setDestinationStateProvince($destination_state_province)
    {
        $this->container['destination_state_province'] = $destination_state_province;

        return $this;
    }

    /**
     * Gets destination_city_name
     *
     * @return string
     */
    public function getDestinationCityName()
    {
        return $this->container['destination_city_name'];
    }

    /**
     * Sets destination_city_name
     *
     * @param string $destination_city_name The shipment destination city. Required for International Requests for those countries that do not utilize postal codes.
     *
     * @return $this
     */
    public function setDestinationCityName($destination_city_name)
    {
        $this->container['destination_city_name'] = $destination_city_name;

        return $this;
    }

    /**
     * Gets destination_town_name
     *
     * @return string
     */
    public function getDestinationTownName()
    {
        return $this->container['destination_town_name'];
    }

    /**
     * Sets destination_town_name
     *
     * @param string $destination_town_name The shipment destination town.  Town is a subdivision of city.
     *
     * @return $this
     */
    public function setDestinationTownName($destination_town_name)
    {
        $this->container['destination_town_name'] = $destination_town_name;

        return $this;
    }

    /**
     * Gets destination_postal_code
     *
     * @return string
     */
    public function getDestinationPostalCode()
    {
        return $this->container['destination_postal_code'];
    }

    /**
     * Sets destination_postal_code
     *
     * @param string $destination_postal_code The shipment destination postal code.    Required for Domestic requests. Either 5, or 9-digit U.S. zip codes must be used for U.S. addresses.  For non-U.S. addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setDestinationPostalCode($destination_postal_code)
    {
        $this->container['destination_postal_code'] = $destination_postal_code;

        return $this;
    }

    /**
     * Gets residential_indicator
     *
     * @return string
     */
    public function getResidentialIndicator()
    {
        return $this->container['residential_indicator'];
    }

    /**
     * Sets residential_indicator
     *
     * @param string $residential_indicator Indicates if address is residential or commercial. Required for Domestic requests.     Valid values: \"01\", \"02\"     01 = Residential   02 = Commercial     Defaults to commercial for International Requests.
     *
     * @return $this
     */
    public function setResidentialIndicator($residential_indicator)
    {
        $this->container['residential_indicator'] = $residential_indicator;

        return $this;
    }

    /**
     * Gets ship_date
     *
     * @return string
     */
    public function getShipDate()
    {
        return $this->container['ship_date'];
    }

    /**
     * Sets ship_date
     *
     * @param string $ship_date The date the shipment is tendered to UPS for shipping (can be dropped off at UPS or picked up by UPS).  Allowed range is up to 60 days in future and 35 days in past. This date may or may not be the UPS business date.   Format is YYYY-MM-DD.    YYYY = 4 digit year;   MM = 2 digit month, valid values 01-12;   DD = 2 digit day of month, valid values 01-31   If no value is provided, defaults to current system date.
     *
     * @return $this
     */
    public function setShipDate($ship_date)
    {
        $this->container['ship_date'] = $ship_date;

        return $this;
    }

    /**
     * Gets ship_time
     *
     * @return string
     */
    public function getShipTime()
    {
        return $this->container['ship_time'];
    }

    /**
     * Sets ship_time
     *
     * @param string $ship_time The time the shipment is tendered to UPS for shipping (can be dropped off at UPS or picked up by UPS).    Format is HH:MM:SS    Defaults to current time if not provided.
     *
     * @return $this
     */
    public function setShipTime($ship_time)
    {
        $this->container['ship_time'] = $ship_time;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float $weight The weight of the shipment. Required for International requests.     Note: If decimal values are used, valid values will be rounded to the tenths.      Note: Maximum value is 70 kilograms or 150 pounds.
     *
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets weight_unit_of_measure
     *
     * @return string
     */
    public function getWeightUnitOfMeasure()
    {
        return $this->container['weight_unit_of_measure'];
    }

    /**
     * Sets weight_unit_of_measure
     *
     * @param string $weight_unit_of_measure Required for International requests and when weight value is provided.     Valid Values: \"LBS\", \"KGS\"
     *
     * @return $this
     */
    public function setWeightUnitOfMeasure($weight_unit_of_measure)
    {
        $this->container['weight_unit_of_measure'] = $weight_unit_of_measure;

        return $this;
    }

    /**
     * Gets shipment_contents_value
     *
     * @return float
     */
    public function getShipmentContentsValue()
    {
        return $this->container['shipment_contents_value'];
    }

    /**
     * Sets shipment_contents_value
     *
     * @param float $shipment_contents_value The monetary value of shipment contents.     Required when origin country does not equal destination country and BillType is 03 (non-documented) or 04 (WWEF)     Required when origin country does not equal destination country, and destination country = CA, and BillType = 02 (document).     Note: If decimal values are used, valid values will be rounded to the tenths.
     *
     * @return $this
     */
    public function setShipmentContentsValue($shipment_contents_value)
    {
        $this->container['shipment_contents_value'] = $shipment_contents_value;

        return $this;
    }

    /**
     * Gets shipment_contents_currency_code
     *
     * @return string
     */
    public function getShipmentContentsCurrencyCode()
    {
        return $this->container['shipment_contents_currency_code'];
    }

    /**
     * Sets shipment_contents_currency_code
     *
     * @param string $shipment_contents_currency_code The unit of currency used for values. Required if ShipmentContentsValue is populated.   Valid value: must conform to ISO standards.
     *
     * @return $this
     */
    public function setShipmentContentsCurrencyCode($shipment_contents_currency_code)
    {
        $this->container['shipment_contents_currency_code'] = $shipment_contents_currency_code;

        return $this;
    }

    /**
     * Gets bill_type
     *
     * @return string
     */
    public function getBillType()
    {
        return $this->container['bill_type'];
    }

    /**
     * Sets bill_type
     *
     * @param string $bill_type Required for International Requests.   Valid values: \"02\",\"03\",\"04\"   02 - Document   03 - Non Document   04 - WWEF (Pallet)
     *
     * @return $this
     */
    public function setBillType($bill_type)
    {
        $this->container['bill_type'] = $bill_type;

        return $this;
    }

    /**
     * Gets avv_flag
     *
     * @return bool
     */
    public function getAvvFlag()
    {
        return $this->container['avv_flag'];
    }

    /**
     * Sets avv_flag
     *
     * @param bool $avv_flag Used to bypass address validation when the address has already been validated by the calling application.      Valid values: true, false     Defaults to true   Note: not to be exposed to external customers.
     *
     * @return $this
     */
    public function setAvvFlag($avv_flag)
    {
        $this->container['avv_flag'] = $avv_flag;

        return $this;
    }

    /**
     * Gets number_of_packages
     *
     * @return int
     */
    public function getNumberOfPackages()
    {
        return $this->container['number_of_packages'];
    }

    /**
     * Sets number_of_packages
     *
     * @param int $number_of_packages Sets the number of packages in shipment.  Default value is 1.
     *
     * @return $this
     */
    public function setNumberOfPackages($number_of_packages)
    {
        $this->container['number_of_packages'] = $number_of_packages;

        return $this;
    }

    /**
     * Gets drop_off_at_facility_indicator
     *
     * @return int
     */
    public function getDropOffAtFacilityIndicator()
    {
        return $this->container['drop_off_at_facility_indicator'];
    }

    /**
     * Sets drop_off_at_facility_indicator
     *
     * @param int $drop_off_at_facility_indicator Sets the indicator for an international Freight Pallet shipment that is going to be dropped off by shipper to a UPS facility.  The indicator is used when the Bill Type is \"04\".      Valid values: \"0\", \"1\".     0 = WWDTProcessIF.PICKUP_BY_UPS   1 = WWDTProcessIf.DROPOFF_BY_SHIPPER     The default value is \"0\"
     *
     * @return $this
     */
    public function setDropOffAtFacilityIndicator($drop_off_at_facility_indicator)
    {
        $this->container['drop_off_at_facility_indicator'] = $drop_off_at_facility_indicator;

        return $this;
    }

    /**
     * Gets hold_for_pickup_indicator
     *
     * @return int
     */
    public function getHoldForPickupIndicator()
    {
        return $this->container['hold_for_pickup_indicator'];
    }

    /**
     * Sets hold_for_pickup_indicator
     *
     * @param int $hold_for_pickup_indicator Sets the indicator for an international Freight Pallet shipment that is going to be pick-up by consignee in a destination facility.  The indicator is used when the Bill Type is \"04\".      Valid values: \"0\", \"1\".     0 = WWDTProcessIF.DELIVERY_BY_UPS   1 = WWDTProcessIf.PICKUP_BY_CONSIGNEE     The default value is \"0\"
     *
     * @return $this
     */
    public function setHoldForPickupIndicator($hold_for_pickup_indicator)
    {
        $this->container['hold_for_pickup_indicator'] = $hold_for_pickup_indicator;

        return $this;
    }

    /**
     * Gets return_unfilterd_services
     *
     * @return bool
     */
    public function getReturnUnfilterdServices()
    {
        return $this->container['return_unfilterd_services'];
    }

    /**
     * Sets return_unfilterd_services
     *
     * @param bool $return_unfilterd_services Used to get back a full list of services - bypassing current WWDT business rules to remove services from the list being returned to clients for US domestic that are slower than UPS Ground.      Default value is false.
     *
     * @return $this
     */
    public function setReturnUnfilterdServices($return_unfilterd_services)
    {
        $this->container['return_unfilterd_services'] = $return_unfilterd_services;

        return $this;
    }

    /**
     * Gets max_list
     *
     * @return int
     */
    public function getMaxList()
    {
        return $this->container['max_list'];
    }

    /**
     * Sets max_list
     *
     * @param int $max_list Sets the limit for the number of candidates returned in candidate list.      Default value is 200.
     *
     * @return $this
     */
    public function setMaxList($max_list)
    {
        $this->container['max_list'] = $max_list;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
