<?php
/**
 * ValidationList
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Time In Transit
 *
 * The Time In Transit API provides estimated delivery times for various UPS shipping services, between specified locations.  Key Business Values: - **Enhanced Customer Experience**: Allows businesses provide accurate delivery estimates to their customers, enhancing customer service. - **Operational Efficiency**: Helps in logistics planning by providing transit times for different UPS services.
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\TimeInTransit\TimeInTransit;

use \ArrayAccess;
use \UPS\TimeInTransit\ObjectSerializer;

/**
 * ValidationList Class Doc Comment
 *
 * @category Class
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ValidationList implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'validationList';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'invalid_field_list' => 'string[]',
        'invalid_field_list_codes' => 'string[]',
        'destination_ambiguous' => 'bool',
        'origin_ambiguous' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'invalid_field_list' => null,
        'invalid_field_list_codes' => null,
        'destination_ambiguous' => null,
        'origin_ambiguous' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'invalid_field_list' => 'invalidFieldList',
        'invalid_field_list_codes' => 'invalidFieldListCodes',
        'destination_ambiguous' => 'destinationAmbiguous',
        'origin_ambiguous' => 'originAmbiguous'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'invalid_field_list' => 'setInvalidFieldList',
        'invalid_field_list_codes' => 'setInvalidFieldListCodes',
        'destination_ambiguous' => 'setDestinationAmbiguous',
        'origin_ambiguous' => 'setOriginAmbiguous'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'invalid_field_list' => 'getInvalidFieldList',
        'invalid_field_list_codes' => 'getInvalidFieldListCodes',
        'destination_ambiguous' => 'getDestinationAmbiguous',
        'origin_ambiguous' => 'getOriginAmbiguous'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['invalid_field_list'] = isset($data['invalid_field_list']) ? $data['invalid_field_list'] : null;
        $this->container['invalid_field_list_codes'] = isset($data['invalid_field_list_codes']) ? $data['invalid_field_list_codes'] : null;
        $this->container['destination_ambiguous'] = isset($data['destination_ambiguous']) ? $data['destination_ambiguous'] : null;
        $this->container['origin_ambiguous'] = isset($data['origin_ambiguous']) ? $data['origin_ambiguous'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets invalid_field_list
     *
     * @return string[]
     */
    public function getInvalidFieldList()
    {
        return $this->container['invalid_field_list'];
    }

    /**
     * Sets invalid_field_list
     *
     * @param string[] $invalid_field_list invalid_field_list
     *
     * @return $this
     */
    public function setInvalidFieldList($invalid_field_list)
    {
        $this->container['invalid_field_list'] = $invalid_field_list;

        return $this;
    }

    /**
     * Gets invalid_field_list_codes
     *
     * @return string[]
     */
    public function getInvalidFieldListCodes()
    {
        return $this->container['invalid_field_list_codes'];
    }

    /**
     * Sets invalid_field_list_codes
     *
     * @param string[] $invalid_field_list_codes invalid_field_list_codes
     *
     * @return $this
     */
    public function setInvalidFieldListCodes($invalid_field_list_codes)
    {
        $this->container['invalid_field_list_codes'] = $invalid_field_list_codes;

        return $this;
    }

    /**
     * Gets destination_ambiguous
     *
     * @return bool
     */
    public function getDestinationAmbiguous()
    {
        return $this->container['destination_ambiguous'];
    }

    /**
     * Sets destination_ambiguous
     *
     * @param bool $destination_ambiguous Returned as true when destination address has a candidate list
     *
     * @return $this
     */
    public function setDestinationAmbiguous($destination_ambiguous)
    {
        $this->container['destination_ambiguous'] = $destination_ambiguous;

        return $this;
    }

    /**
     * Gets origin_ambiguous
     *
     * @return bool
     */
    public function getOriginAmbiguous()
    {
        return $this->container['origin_ambiguous'];
    }

    /**
     * Sets origin_ambiguous
     *
     * @param bool $origin_ambiguous Returned as true when original address has a candidate list.
     *
     * @return $this
     */
    public function setOriginAmbiguous($origin_ambiguous)
    {
        $this->container['origin_ambiguous'] = $origin_ambiguous;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
