# Tracking
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 
- Package version: 1.0.8
- Build package: io.swagger.codegen.v3.generators.php.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/abantecart/ups-tracking.git"
    }
  ],
  "require": {
    "abantecart/ups-tracking": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/Tracking/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Tracking\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Tracking\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inquiry_number = "inquiry_number_example"; // string | The tracking number for which tracking information is requested. Each inquiry number must be between 7 and 34 characters in length.
$trans_id = "trans_id_example"; // string | An identifier unique to the request.
$transaction_src = "testing"; // string | Identifies the client/source application that is calling
$locale = "en_US"; // string | Language and country code of the user, separated by an underscore. Default value is 'en_US'
$return_signature = "false"; // string | Indicator requesting that the delivery signature image be included as part of the response (by default the image will not be returned). Returns image bytecodes of the signature.
$return_milestones = "false"; // string | returnMilestones
$return_pod = "false"; // string | Return Proof of Delivery

try {
    $result = $apiInstance->getSingleTrackResponseUsingGET($inquiry_number, $trans_id, $transaction_src, $locale, $return_signature, $return_milestones, $return_pod);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->getSingleTrackResponseUsingGET: ', $e->getMessage(), PHP_EOL;
}
?>
```

## Documentation for API Endpoints

All URIs are relative to *https://wwwcie.ups.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**getSingleTrackResponseUsingGET**](docs/Api/DefaultApi.md#getsingletrackresponseusingget) | **GET** /track/v1/details/{inquiryNumber} | Tracking

## Documentation For Models

 - [AccessPointInformation](docs/Model/AccessPointInformation.md)
 - [Activity](docs/Model/Activity.md)
 - [Address](docs/Model/Address.md)
 - [AlternateTrackingNumber](docs/Model/AlternateTrackingNumber.md)
 - [DeliveryDate](docs/Model/DeliveryDate.md)
 - [DeliveryInformation](docs/Model/DeliveryInformation.md)
 - [DeliveryTime](docs/Model/DeliveryTime.md)
 - [Error](docs/Model/Error.md)
 - [ErrorResponse](docs/Model/ErrorResponse.md)
 - [InquireNumbers](docs/Model/InquireNumbers.md)
 - [Location](docs/Model/Location.md)
 - [Milestones](docs/Model/Milestones.md)
 - [POD](docs/Model/POD.md)
 - [Package](docs/Model/Package.md)
 - [PackageAddress](docs/Model/PackageAddress.md)
 - [PaymentInformation](docs/Model/PaymentInformation.md)
 - [ReferenceNumber](docs/Model/ReferenceNumber.md)
 - [Response](docs/Model/Response.md)
 - [Service](docs/Model/Service.md)
 - [Shipment](docs/Model/Shipment.md)
 - [Signature](docs/Model/Signature.md)
 - [Status](docs/Model/Status.md)
 - [SubMilestone](docs/Model/SubMilestone.md)
 - [TrackApiResponse](docs/Model/TrackApiResponse.md)
 - [TrackResponse](docs/Model/TrackResponse.md)
 - [Warning](docs/Model/Warning.md)
 - [Weight](docs/Model/Weight.md)

## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 


## Author



