# Pickup
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 
- Package version: 1.0.8
- Build package: io.swagger.codegen.v3.generators.php.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/abantecart/ups-pickup.git"
    }
  ],
  "require": {
    "abantecart/ups-pickup": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/Pickup/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$cancel_by = "cancel_by_example"; // string | Valid Values: 01 = AccountNumber, 02 = PRN
$deprecated_version = "deprecated_version_example"; // string | Version of API.  Valid values: - v1
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$prn = "prn_example"; // string | The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy = prn.Length 26

try {
    $result = $apiInstance->deprecatedPickupCancel($cancel_by, $deprecated_version, $trans_id, $transaction_src, $prn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedPickupCancel: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$deprecated_version = "deprecated_version_example"; // string | Version of the API.  Valid values: - v1 - v1607 - v1707
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->deprecatedPickupCreation($body, $deprecated_version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedPickupCreation: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$cancel_by = "cancel_by_example"; // string | Valid Values: 01 = AccountNumber, 02 = PRN
$version = "version_example"; // string | Version of API.  Valid values: - v2403
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$prn = "prn_example"; // string | The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy = prn.Length 26

try {
    $result = $apiInstance->pickupCancel($cancel_by, $version, $trans_id, $transaction_src, $prn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupCancel: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$version = "version_example"; // string | Version of the API.  Valid values: - v2403
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupCreation($body, $version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupCreation: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$version = "version_example"; // string | Version of API.  Valid values: - v1
$countrycode = "countrycode_example"; // string | Country or terrirtory for which the list will  represent.Length 2

try {
    $result = $apiInstance->pickupGetPoliticalDivision1List($trans_id, $transaction_src, $version, $countrycode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupGetPoliticalDivision1List: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$version = "version_example"; // string | Version of API.  Valid values: - v1
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupGetServiceCenterFacilities($body, $version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupGetServiceCenterFacilities: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$account_number = "account_number_example"; // string | The specific account number that belongs to the  shipper.Length 6 or 10
$version = "version_example"; // string | Version of API  Valid values: - v1
$pickuptype = "pickuptype_example"; // string | Type of pickup. Valid values: oncall smart both. Length 6
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupPendingStatus($account_number, $version, $pickuptype, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupPendingStatus: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$version = "version_example"; // string | Version of the API.  Valid values: - v1
$pickuptype = "pickuptype_example"; // string | Type of pickup. Valid values: oncall smart both. Length 6
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupRate($body, $version, $pickuptype, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupRate: ', $e->getMessage(), PHP_EOL;
}
?>
```

## Documentation for API Endpoints

All URIs are relative to *https://wwwcie.ups.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**deprecatedPickupCancel**](docs/Api/DefaultApi.md#deprecatedpickupcancel) | **DELETE** /shipments/{deprecatedVersion}/pickup/{CancelBy} | Pickup Cancel
*DefaultApi* | [**deprecatedPickupCreation**](docs/Api/DefaultApi.md#deprecatedpickupcreation) | **POST** /pickupcreation/{deprecatedVersion}/pickup | Pickup Creation
*DefaultApi* | [**pickupCancel**](docs/Api/DefaultApi.md#pickupcancel) | **DELETE** /shipments/{version}/pickup/{CancelBy} | Pickup Cancel
*DefaultApi* | [**pickupCreation**](docs/Api/DefaultApi.md#pickupcreation) | **POST** /pickupcreation/{version}/pickup | Pickup Creation
*DefaultApi* | [**pickupGetPoliticalDivision1List**](docs/Api/DefaultApi.md#pickupgetpoliticaldivision1list) | **GET** /pickup/{version}/countries/{countrycode} | Pickup Get Political Division1 List
*DefaultApi* | [**pickupGetServiceCenterFacilities**](docs/Api/DefaultApi.md#pickupgetservicecenterfacilities) | **POST** /pickup/{version}/servicecenterlocations | Pickup Get Service Center Facilities
*DefaultApi* | [**pickupPendingStatus**](docs/Api/DefaultApi.md#pickuppendingstatus) | **GET** /shipments/{version}/pickup/{pickuptype} | Pickup Pending Status
*DefaultApi* | [**pickupRate**](docs/Api/DefaultApi.md#pickuprate) | **POST** /shipments/{version}/pickup/{pickuptype} | Pickup Rate

## Documentation For Models

 - [ChargeCardCardAddress](docs/Model/ChargeCardCardAddress.md)
 - [CommonErrorResponse](docs/Model/CommonErrorResponse.md)
 - [DimensionsUnitOfMeasurement](docs/Model/DimensionsUnitOfMeasurement.md)
 - [DropOffFacilitiesAddress](docs/Model/DropOffFacilitiesAddress.md)
 - [DropOffFacilitiesDistance](docs/Model/DropOffFacilitiesDistance.md)
 - [DropOffFacilitiesFacilityTime](docs/Model/DropOffFacilitiesFacilityTime.md)
 - [DropOffFacilitiesLocalizedInstruction](docs/Model/DropOffFacilitiesLocalizedInstruction.md)
 - [ErrorMessage](docs/Model/ErrorMessage.md)
 - [ErrorResponse](docs/Model/ErrorResponse.md)
 - [FacilityTimeDayOfWeek](docs/Model/FacilityTimeDayOfWeek.md)
 - [FreightOptionsDestinationAddress](docs/Model/FreightOptionsDestinationAddress.md)
 - [FreightOptionsShipmentDetail](docs/Model/FreightOptionsShipmentDetail.md)
 - [FreightOptionsShipmentServiceOptions](docs/Model/FreightOptionsShipmentServiceOptions.md)
 - [OneOfDropOffFacilitiesAddressAddressLine](docs/Model/OneOfDropOffFacilitiesAddressAddressLine.md)
 - [OneOfPickupGetServiceCenterFacilitiesResponseServiceCenterLocationDropOffFacilities](docs/Model/OneOfPickupGetServiceCenterFacilitiesResponseServiceCenterLocationDropOffFacilities.md)
 - [OneOfPickupPendingStatusResponsePendingStatus](docs/Model/OneOfPickupPendingStatusResponsePendingStatus.md)
 - [OneOfPickupRateResponseResponseAlert](docs/Model/OneOfPickupRateResponseResponseAlert.md)
 - [OneOfServiceCenterLocationDropOffFacilitiesLocalizedInstruction](docs/Model/OneOfServiceCenterLocationDropOffFacilitiesLocalizedInstruction.md)
 - [OriginAddressOriginSearchCriteria](docs/Model/OriginAddressOriginSearchCriteria.md)
 - [PICKUPCancelRequestWrapper](docs/Model/PICKUPCancelRequestWrapper.md)
 - [PICKUPCancelResponseWrapper](docs/Model/PICKUPCancelResponseWrapper.md)
 - [PICKUPCreationRequestWrapper](docs/Model/PICKUPCreationRequestWrapper.md)
 - [PICKUPCreationResponseWrapper](docs/Model/PICKUPCreationResponseWrapper.md)
 - [PICKUPPendingRequestWrapper](docs/Model/PICKUPPendingRequestWrapper.md)
 - [PICKUPPendingResponseWrapper](docs/Model/PICKUPPendingResponseWrapper.md)
 - [PICKUPPolDivRequestWrapper](docs/Model/PICKUPPolDivRequestWrapper.md)
 - [PICKUPPolDivResponseWrapper](docs/Model/PICKUPPolDivResponseWrapper.md)
 - [PICKUPRequestWrapper](docs/Model/PICKUPRequestWrapper.md)
 - [PICKUPResponseWrapper](docs/Model/PICKUPResponseWrapper.md)
 - [PICKUPServCenterRequestWrapper](docs/Model/PICKUPServCenterRequestWrapper.md)
 - [PICKUPServCenterResponseWrapper](docs/Model/PICKUPServCenterResponseWrapper.md)
 - [PalletInformationDimensions](docs/Model/PalletInformationDimensions.md)
 - [PickupAddressPhone](docs/Model/PickupAddressPhone.md)
 - [PickupCancelRequest](docs/Model/PickupCancelRequest.md)
 - [PickupCancelRequestRequest](docs/Model/PickupCancelRequestRequest.md)
 - [PickupCancelResponse](docs/Model/PickupCancelResponse.md)
 - [PickupCancelResponseGWNStatus](docs/Model/PickupCancelResponseGWNStatus.md)
 - [PickupCancelResponseResponse](docs/Model/PickupCancelResponseResponse.md)
 - [PickupCreationRequest](docs/Model/PickupCreationRequest.md)
 - [PickupCreationRequestFreightOptions](docs/Model/PickupCreationRequestFreightOptions.md)
 - [PickupCreationRequestPickupAddress](docs/Model/PickupCreationRequestPickupAddress.md)
 - [PickupCreationRequestPickupDateInfo](docs/Model/PickupCreationRequestPickupDateInfo.md)
 - [PickupCreationRequestPickupPiece](docs/Model/PickupCreationRequestPickupPiece.md)
 - [PickupCreationRequestRequest](docs/Model/PickupCreationRequestRequest.md)
 - [PickupCreationRequestShipper](docs/Model/PickupCreationRequestShipper.md)
 - [PickupCreationRequestTotalWeight](docs/Model/PickupCreationRequestTotalWeight.md)
 - [PickupCreationRequestTrackingData](docs/Model/PickupCreationRequestTrackingData.md)
 - [PickupCreationRequestTrackingDataWithReferenceNumber](docs/Model/PickupCreationRequestTrackingDataWithReferenceNumber.md)
 - [PickupCreationResponse](docs/Model/PickupCreationResponse.md)
 - [PickupCreationResponseRateResult](docs/Model/PickupCreationResponseRateResult.md)
 - [PickupCreationResponseRateStatus](docs/Model/PickupCreationResponseRateStatus.md)
 - [PickupCreationResponseResponse](docs/Model/PickupCreationResponseResponse.md)
 - [PickupCreationResponseWeekendServiceTerritory](docs/Model/PickupCreationResponseWeekendServiceTerritory.md)
 - [PickupFacilitiesAddress](docs/Model/PickupFacilitiesAddress.md)
 - [PickupFacilitiesFacilityTime](docs/Model/PickupFacilitiesFacilityTime.md)
 - [PickupFacilitiesFacilityTimeDayOfWeek](docs/Model/PickupFacilitiesFacilityTimeDayOfWeek.md)
 - [PickupGetPoliticalDivision1ListRequest](docs/Model/PickupGetPoliticalDivision1ListRequest.md)
 - [PickupGetPoliticalDivision1ListRequestRequest](docs/Model/PickupGetPoliticalDivision1ListRequestRequest.md)
 - [PickupGetPoliticalDivision1ListResponse](docs/Model/PickupGetPoliticalDivision1ListResponse.md)
 - [PickupGetPoliticalDivision1ListResponseResponse](docs/Model/PickupGetPoliticalDivision1ListResponseResponse.md)
 - [PickupGetServiceCenterFacilitiesRequest](docs/Model/PickupGetServiceCenterFacilitiesRequest.md)
 - [PickupGetServiceCenterFacilitiesRequestDestinationAddress](docs/Model/PickupGetServiceCenterFacilitiesRequestDestinationAddress.md)
 - [PickupGetServiceCenterFacilitiesRequestOriginAddress](docs/Model/PickupGetServiceCenterFacilitiesRequestOriginAddress.md)
 - [PickupGetServiceCenterFacilitiesRequestPickupPiece](docs/Model/PickupGetServiceCenterFacilitiesRequestPickupPiece.md)
 - [PickupGetServiceCenterFacilitiesRequestRequest](docs/Model/PickupGetServiceCenterFacilitiesRequestRequest.md)
 - [PickupGetServiceCenterFacilitiesResponse](docs/Model/PickupGetServiceCenterFacilitiesResponse.md)
 - [PickupGetServiceCenterFacilitiesResponseResponse](docs/Model/PickupGetServiceCenterFacilitiesResponseResponse.md)
 - [PickupGetServiceCenterFacilitiesResponseServiceCenterLocation](docs/Model/PickupGetServiceCenterFacilitiesResponseServiceCenterLocation.md)
 - [PickupPendingStatusRequest](docs/Model/PickupPendingStatusRequest.md)
 - [PickupPendingStatusRequestRequest](docs/Model/PickupPendingStatusRequestRequest.md)
 - [PickupPendingStatusResponse](docs/Model/PickupPendingStatusResponse.md)
 - [PickupPendingStatusResponsePendingStatus](docs/Model/PickupPendingStatusResponsePendingStatus.md)
 - [PickupPendingStatusResponseResponse](docs/Model/PickupPendingStatusResponseResponse.md)
 - [PickupRateRequest](docs/Model/PickupRateRequest.md)
 - [PickupRateRequestPickupAddress](docs/Model/PickupRateRequestPickupAddress.md)
 - [PickupRateRequestPickupDateInfo](docs/Model/PickupRateRequestPickupDateInfo.md)
 - [PickupRateRequestRequest](docs/Model/PickupRateRequestRequest.md)
 - [PickupRateRequestShipperAccount](docs/Model/PickupRateRequestShipperAccount.md)
 - [PickupRateResponse](docs/Model/PickupRateResponse.md)
 - [PickupRateResponseRateResult](docs/Model/PickupRateResponseRateResult.md)
 - [PickupRateResponseResponse](docs/Model/PickupRateResponseResponse.md)
 - [PickupRateResponseWeekendServiceTerritory](docs/Model/PickupRateResponseWeekendServiceTerritory.md)
 - [RateResultChargeDetail](docs/Model/RateResultChargeDetail.md)
 - [RateResultDisclaimer](docs/Model/RateResultDisclaimer.md)
 - [RateResultTaxCharges](docs/Model/RateResultTaxCharges.md)
 - [RequestTransactionReference](docs/Model/RequestTransactionReference.md)
 - [ResponseAlert](docs/Model/ResponseAlert.md)
 - [ResponseResponseStatus](docs/Model/ResponseResponseStatus.md)
 - [ResponseTransactionReference](docs/Model/ResponseTransactionReference.md)
 - [ServiceCenterLocationDropOffFacilities](docs/Model/ServiceCenterLocationDropOffFacilities.md)
 - [ServiceCenterLocationPickupFacilities](docs/Model/ServiceCenterLocationPickupFacilities.md)
 - [ShipmentDetailPalletInformation](docs/Model/ShipmentDetailPalletInformation.md)
 - [ShipperAccount](docs/Model/ShipperAccount.md)
 - [ShipperChargeCard](docs/Model/ShipperChargeCard.md)

## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 


## Author



