# UPS\Pickup\DefaultApi

All URIs are relative to *https://wwwcie.ups.com/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deprecatedPickupCancel**](DefaultApi.md#deprecatedpickupcancel) | **DELETE** /shipments/{deprecatedVersion}/pickup/{CancelBy} | Pickup Cancel
[**deprecatedPickupCreation**](DefaultApi.md#deprecatedpickupcreation) | **POST** /pickupcreation/{deprecatedVersion}/pickup | Pickup Creation
[**pickupCancel**](DefaultApi.md#pickupcancel) | **DELETE** /shipments/{version}/pickup/{CancelBy} | Pickup Cancel
[**pickupCreation**](DefaultApi.md#pickupcreation) | **POST** /pickupcreation/{version}/pickup | Pickup Creation
[**pickupGetPoliticalDivision1List**](DefaultApi.md#pickupgetpoliticaldivision1list) | **GET** /pickup/{version}/countries/{countrycode} | Pickup Get Political Division1 List
[**pickupGetServiceCenterFacilities**](DefaultApi.md#pickupgetservicecenterfacilities) | **POST** /pickup/{version}/servicecenterlocations | Pickup Get Service Center Facilities
[**pickupPendingStatus**](DefaultApi.md#pickuppendingstatus) | **GET** /shipments/{version}/pickup/{pickuptype} | Pickup Pending Status
[**pickupRate**](DefaultApi.md#pickuprate) | **POST** /shipments/{version}/pickup/{pickuptype} | Pickup Rate

# **deprecatedPickupCancel**
> \UPS\Pickup\Pickup\PICKUPCancelResponseWrapper deprecatedPickupCancel($cancel_by, $deprecated_version, $trans_id, $transaction_src, $prn)

Pickup Cancel

Using the CancelBy endpoint of the Pickup API, users can request cancellation of a UPS on-demand package pickup. When the PRN (pickup request number), transaction ID, and the transaction source are supplied as required parameters, the endpoint returns confirmation that the pickup has been cancelled.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$cancel_by = "cancel_by_example"; // string | Valid Values: 01 = AccountNumber, 02 = PRN
$deprecated_version = "deprecated_version_example"; // string | Version of API.  Valid values: - v1
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$prn = "prn_example"; // string | The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy = prn.Length 26

try {
    $result = $apiInstance->deprecatedPickupCancel($cancel_by, $deprecated_version, $trans_id, $transaction_src, $prn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedPickupCancel: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cancel_by** | **string**| Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN |
 **deprecated_version** | **string**| Version of API.  Valid values: - v1 |
 **trans_id** | **string**| An identifier unique to the request. Length 32 | [optional]
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [optional] [default to testing]
 **prn** | **string**| The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 | [optional]

### Return type

[**\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper**](../Model/PICKUPCancelResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deprecatedPickupCreation**
> \UPS\Pickup\Pickup\PICKUPCreationResponseWrapper deprecatedPickupCreation($body, $deprecated_version, $trans_id, $transaction_src)

Pickup Creation

Using the Pickup API, applications can schedule pickups, manage previously scheduled pickups, or cancel previously scheduled pickups.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$deprecated_version = "deprecated_version_example"; // string | Version of the API.  Valid values: - v1 - v1607 - v1707
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->deprecatedPickupCreation($body, $deprecated_version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedPickupCreation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\UPS\Pickup\Pickup\PICKUPCreationRequestWrapper**](../Model/PICKUPCreationRequestWrapper.md)| Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. |
 **deprecated_version** | **string**| Version of the API.  Valid values: - v1 - v1607 - v1707 |
 **trans_id** | **string**| An identifier unique to the request. Length 32 | [optional]
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [optional] [default to testing]

### Return type

[**\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper**](../Model/PICKUPCreationResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **pickupCancel**
> \UPS\Pickup\Pickup\PICKUPCancelResponseWrapper pickupCancel($cancel_by, $version, $trans_id, $transaction_src, $prn)

Pickup Cancel

Using the CancelBy endpoint of the Pickup API, users can request cancellation of a UPS on-demand package pickup. When the PRN (pickup request number), transaction ID, and the transaction source are supplied as required parameters, the endpoint returns confirmation that the pickup has been cancelled.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$cancel_by = "cancel_by_example"; // string | Valid Values: 01 = AccountNumber, 02 = PRN
$version = "version_example"; // string | Version of API.  Valid values: - v2403
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$prn = "prn_example"; // string | The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy = prn.Length 26

try {
    $result = $apiInstance->pickupCancel($cancel_by, $version, $trans_id, $transaction_src, $prn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupCancel: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cancel_by** | **string**| Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN |
 **version** | **string**| Version of API.  Valid values: - v2403 |
 **trans_id** | **string**| An identifier unique to the request. Length 32 | [optional]
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [optional] [default to testing]
 **prn** | **string**| The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 | [optional]

### Return type

[**\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper**](../Model/PICKUPCancelResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **pickupCreation**
> \UPS\Pickup\Pickup\PICKUPCreationResponseWrapper pickupCreation($body, $version, $trans_id, $transaction_src)

Pickup Creation

Using the Pickup API, applications can schedule pickups, manage previously scheduled pickups, or cancel previously scheduled pickups.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$version = "version_example"; // string | Version of the API.  Valid values: - v2403
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupCreation($body, $version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupCreation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\UPS\Pickup\Pickup\PICKUPCreationRequestWrapper**](../Model/PICKUPCreationRequestWrapper.md)| Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. |
 **version** | **string**| Version of the API.  Valid values: - v2403 |
 **trans_id** | **string**| An identifier unique to the request. Length 32 | [optional]
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [optional] [default to testing]

### Return type

[**\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper**](../Model/PICKUPCreationResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **pickupGetPoliticalDivision1List**
> \UPS\Pickup\Pickup\PICKUPPolDivResponseWrapper pickupGetPoliticalDivision1List($trans_id, $transaction_src, $version, $countrycode)

Pickup Get Political Division1 List

The countrycode endpoint of the Pickup API helps retrieve a list of political divisions (states) in a specified country or territory.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512
$version = "version_example"; // string | Version of API.  Valid values: - v1
$countrycode = "countrycode_example"; // string | Country or terrirtory for which the list will  represent.Length 2

try {
    $result = $apiInstance->pickupGetPoliticalDivision1List($trans_id, $transaction_src, $version, $countrycode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupGetPoliticalDivision1List: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trans_id** | **string**| An identifier unique to the request. Length 32 |
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [default to testing]
 **version** | **string**| Version of API.  Valid values: - v1 |
 **countrycode** | **string**| Country or terrirtory for which the list will  represent.Length 2 |

### Return type

[**\UPS\Pickup\Pickup\PICKUPPolDivResponseWrapper**](../Model/PICKUPPolDivResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **pickupGetServiceCenterFacilities**
> \UPS\Pickup\Pickup\PICKUPServCenterResponseWrapper pickupGetServiceCenterFacilities($body, $version, $trans_id, $transaction_src)

Pickup Get Service Center Facilities

The servicecenterlocations endpoint of the Pickup API helps retrieve service center information in a specified area - including location address, phone number, SLIC (Standard Location Identification Code), and hours of operation for pick-up and drop-off requests

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$version = "version_example"; // string | Version of API.  Valid values: - v1
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupGetServiceCenterFacilities($body, $version, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupGetServiceCenterFacilities: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper**](../Model/PICKUPServCenterRequestWrapper.md)| Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. |
 **version** | **string**| Version of API.  Valid values: - v1 |
 **trans_id** | **string**| An identifier unique to the request. Length 32 | [optional]
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [optional] [default to testing]

### Return type

[**\UPS\Pickup\Pickup\PICKUPServCenterResponseWrapper**](../Model/PICKUPServCenterResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **pickupPendingStatus**
> \UPS\Pickup\Pickup\PICKUPPendingResponseWrapper pickupPendingStatus($account_number, $version, $pickuptype, $trans_id, $transaction_src)

Pickup Pending Status

Using the GET operation of the pickuptype endpoint within the Pickup API, users can retrieve the status of shipments sent via UPS pickup service. The endpoint uses the account number as a required parameter and returns a status of received/dispatched/completed/incomplete/updated ETA, or cancelled.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$account_number = "account_number_example"; // string | The specific account number that belongs to the  shipper.Length 6 or 10
$version = "version_example"; // string | Version of API  Valid values: - v1
$pickuptype = "pickuptype_example"; // string | Type of pickup. Valid values: oncall smart both. Length 6
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupPendingStatus($account_number, $version, $pickuptype, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupPendingStatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_number** | **string**| The specific account number that belongs to the  shipper.Length 6 or 10 |
 **version** | **string**| Version of API  Valid values: - v1 |
 **pickuptype** | **string**| Type of pickup. Valid values: oncall smart both. Length 6 |
 **trans_id** | **string**| An identifier unique to the request. Length 32 | [optional]
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [optional] [default to testing]

### Return type

[**\UPS\Pickup\Pickup\PICKUPPendingResponseWrapper**](../Model/PICKUPPendingResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **pickupRate**
> \UPS\Pickup\Pickup\PICKUPResponseWrapper pickupRate($body, $version, $pickuptype, $trans_id, $transaction_src)

Pickup Rate

Using the POST operation of the pickuptype endpoint within the Pickup API, users can request rates for UPS on-demand package pickup. The endpoint allows users to specify pickup details like address, date/time, and other options, and returns pricing information for booking that pickup.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\Pickup\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\Pickup\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\Pickup\Pickup\PICKUPRequestWrapper(); // \UPS\Pickup\Pickup\PICKUPRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$version = "version_example"; // string | Version of the API.  Valid values: - v1
$pickuptype = "pickuptype_example"; // string | Type of pickup. Valid values: oncall smart both. Length 6
$trans_id = "trans_id_example"; // string | An identifier unique to the request. Length 32
$transaction_src = "testing"; // string | An identifier of the client/source application that is making the request.Length 512

try {
    $result = $apiInstance->pickupRate($body, $version, $pickuptype, $trans_id, $transaction_src);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->pickupRate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\UPS\Pickup\Pickup\PICKUPRequestWrapper**](../Model/PICKUPRequestWrapper.md)| Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. |
 **version** | **string**| Version of the API.  Valid values: - v1 |
 **pickuptype** | **string**| Type of pickup. Valid values: oncall smart both. Length 6 |
 **trans_id** | **string**| An identifier unique to the request. Length 32 | [optional]
 **transaction_src** | **string**| An identifier of the client/source application that is making the request.Length 512 | [optional] [default to testing]

### Return type

[**\UPS\Pickup\Pickup\PICKUPResponseWrapper**](../Model/PICKUPResponseWrapper.md)

### Authorization

[oauth2](../../README.md#oauth2)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

