<?php
/**
 * ServiceCenterLocationDropOffFacilities
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Pickup
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Pickup\Pickup;

use \ArrayAccess;
use \UPS\Pickup\ObjectSerializer;

/**
 * ServiceCenterLocationDropOffFacilities Class Doc Comment
 *
 * @category Class
 * @description Returns information for DropOff Facilities. This includes name of facility, address, business hours, and SLIC.
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ServiceCenterLocationDropOffFacilities implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ServiceCenterLocation_DropOffFacilities';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'name' => 'string',
        'address' => '\UPS\Pickup\Pickup\DropOffFacilitiesAddress',
        'slic' => 'string',
        'type' => 'string',
        'timezone' => 'string',
        'phone' => 'string',
        'fax' => 'string',
        'facility_time' => '\UPS\Pickup\Pickup\DropOffFacilitiesFacilityTime',
        'origin_or_destination' => 'string',
        'localized_instruction' => 'OneOfServiceCenterLocationDropOffFacilitiesLocalizedInstruction',
        'distance' => '\UPS\Pickup\Pickup\DropOffFacilitiesDistance'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'name' => null,
        'address' => null,
        'slic' => null,
        'type' => null,
        'timezone' => null,
        'phone' => null,
        'fax' => null,
        'facility_time' => null,
        'origin_or_destination' => null,
        'localized_instruction' => null,
        'distance' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'Name',
        'address' => 'Address',
        'slic' => 'SLIC',
        'type' => 'Type',
        'timezone' => 'Timezone',
        'phone' => 'Phone',
        'fax' => 'Fax',
        'facility_time' => 'FacilityTime',
        'origin_or_destination' => 'OriginOrDestination',
        'localized_instruction' => 'LocalizedInstruction',
        'distance' => 'Distance'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'address' => 'setAddress',
        'slic' => 'setSlic',
        'type' => 'setType',
        'timezone' => 'setTimezone',
        'phone' => 'setPhone',
        'fax' => 'setFax',
        'facility_time' => 'setFacilityTime',
        'origin_or_destination' => 'setOriginOrDestination',
        'localized_instruction' => 'setLocalizedInstruction',
        'distance' => 'setDistance'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'address' => 'getAddress',
        'slic' => 'getSlic',
        'type' => 'getType',
        'timezone' => 'getTimezone',
        'phone' => 'getPhone',
        'fax' => 'getFax',
        'facility_time' => 'getFacilityTime',
        'origin_or_destination' => 'getOriginOrDestination',
        'localized_instruction' => 'getLocalizedInstruction',
        'distance' => 'getDistance'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['slic'] = isset($data['slic']) ? $data['slic'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['timezone'] = isset($data['timezone']) ? $data['timezone'] : null;
        $this->container['phone'] = isset($data['phone']) ? $data['phone'] : null;
        $this->container['fax'] = isset($data['fax']) ? $data['fax'] : null;
        $this->container['facility_time'] = isset($data['facility_time']) ? $data['facility_time'] : null;
        $this->container['origin_or_destination'] = isset($data['origin_or_destination']) ? $data['origin_or_destination'] : null;
        $this->container['localized_instruction'] = isset($data['localized_instruction']) ? $data['localized_instruction'] : null;
        $this->container['distance'] = isset($data['distance']) ? $data['distance'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['address'] === null) {
            $invalidProperties[] = "'address' can't be null";
        }
        if ($this->container['slic'] === null) {
            $invalidProperties[] = "'slic' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        if ($this->container['timezone'] === null) {
            $invalidProperties[] = "'timezone' can't be null";
        }
        if ($this->container['phone'] === null) {
            $invalidProperties[] = "'phone' can't be null";
        }
        if ($this->container['fax'] === null) {
            $invalidProperties[] = "'fax' can't be null";
        }
        if ($this->container['origin_or_destination'] === null) {
            $invalidProperties[] = "'origin_or_destination' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Name of the Facility.
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets address
     *
     * @return \UPS\Pickup\Pickup\DropOffFacilitiesAddress
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param \UPS\Pickup\Pickup\DropOffFacilitiesAddress $address address
     *
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets slic
     *
     * @return string
     */
    public function getSlic()
    {
        return $this->container['slic'];
    }

    /**
     * Sets slic
     *
     * @param string $slic SLIC code for the UPS Drop off facility.
     *
     * @return $this
     */
    public function setSlic($slic)
    {
        $this->container['slic'] = $slic;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type FRT for Freight or PKG for Package
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets timezone
     *
     * @return string
     */
    public function getTimezone()
    {
        return $this->container['timezone'];
    }

    /**
     * Sets timezone
     *
     * @param string $timezone Facility's Timezone. Format: - America/New_York - Asia/Hong_Kong - Europe/London
     *
     * @return $this
     */
    public function setTimezone($timezone)
    {
        $this->container['timezone'] = $timezone;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string $phone Phone Number of the Drop off Facility
     *
     * @return $this
     */
    public function setPhone($phone)
    {
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string $fax Drop off Facilities Fax Number
     *
     * @return $this
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets facility_time
     *
     * @return \UPS\Pickup\Pickup\DropOffFacilitiesFacilityTime
     */
    public function getFacilityTime()
    {
        return $this->container['facility_time'];
    }

    /**
     * Sets facility_time
     *
     * @param \UPS\Pickup\Pickup\DropOffFacilitiesFacilityTime $facility_time facility_time
     *
     * @return $this
     */
    public function setFacilityTime($facility_time)
    {
        $this->container['facility_time'] = $facility_time;

        return $this;
    }

    /**
     * Gets origin_or_destination
     *
     * @return string
     */
    public function getOriginOrDestination()
    {
        return $this->container['origin_or_destination'];
    }

    /**
     * Sets origin_or_destination
     *
     * @param string $origin_or_destination Type of Facility.
     *
     * @return $this
     */
    public function setOriginOrDestination($origin_or_destination)
    {
        $this->container['origin_or_destination'] = $origin_or_destination;

        return $this;
    }

    /**
     * Gets localized_instruction
     *
     * @return OneOfServiceCenterLocationDropOffFacilitiesLocalizedInstruction
     */
    public function getLocalizedInstruction()
    {
        return $this->container['localized_instruction'];
    }

    /**
     * Sets localized_instruction
     *
     * @param OneOfServiceCenterLocationDropOffFacilitiesLocalizedInstruction $localized_instruction localized_instruction
     *
     * @return $this
     */
    public function setLocalizedInstruction($localized_instruction)
    {
        $this->container['localized_instruction'] = $localized_instruction;

        return $this;
    }

    /**
     * Gets distance
     *
     * @return \UPS\Pickup\Pickup\DropOffFacilitiesDistance
     */
    public function getDistance()
    {
        return $this->container['distance'];
    }

    /**
     * Sets distance
     *
     * @param \UPS\Pickup\Pickup\DropOffFacilitiesDistance $distance distance
     *
     * @return $this
     */
    public function setDistance($distance)
    {
        $this->container['distance'] = $distance;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
