<?php
/**
 * DefaultApi
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Pickup
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Pickup\Request;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use UPS\Pickup\ApiException;
use UPS\Pickup\Configuration;
use UPS\Pickup\HeaderSelector;
use UPS\Pickup\ObjectSerializer;

/**
 * DefaultApi Class Doc Comment
 *
 * @category Class
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DefaultApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deprecatedPickupCancel
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $deprecated_version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPCancelResponseWrapper
     */
    public function deprecatedPickupCancel($cancel_by, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        list($response) = $this->deprecatedPickupCancelWithHttpInfo($cancel_by, $deprecated_version, $trans_id, $transaction_src, $prn);
        return $response;
    }

    /**
     * Operation deprecatedPickupCancelWithHttpInfo
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $deprecated_version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPCancelResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function deprecatedPickupCancelWithHttpInfo($cancel_by, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper';
        $request = $this->deprecatedPickupCancelRequest($cancel_by, $deprecated_version, $trans_id, $transaction_src, $prn);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deprecatedPickupCancelAsync
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $deprecated_version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedPickupCancelAsync($cancel_by, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        return $this->deprecatedPickupCancelAsyncWithHttpInfo($cancel_by, $deprecated_version, $trans_id, $transaction_src, $prn)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deprecatedPickupCancelAsyncWithHttpInfo
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $deprecated_version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedPickupCancelAsyncWithHttpInfo($cancel_by, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper';
        $request = $this->deprecatedPickupCancelRequest($cancel_by, $deprecated_version, $trans_id, $transaction_src, $prn);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deprecatedPickupCancel'
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $deprecated_version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deprecatedPickupCancelRequest($cancel_by, $deprecated_version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        // verify the required parameter 'cancel_by' is set
        if ($cancel_by === null || (is_array($cancel_by) && count($cancel_by) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cancel_by when calling deprecatedPickupCancel'
            );
        }
        // verify the required parameter 'deprecated_version' is set
        if ($deprecated_version === null || (is_array($deprecated_version) && count($deprecated_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deprecated_version when calling deprecatedPickupCancel'
            );
        }

        $resourcePath = '/shipments/{deprecatedVersion}/pickup/{CancelBy}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }
        // header params
        if ($prn !== null) {
            $headerParams['Prn'] = ObjectSerializer::toHeaderValue($prn);
        }

        // path params
        if ($cancel_by !== null) {
            $resourcePath = str_replace(
                '{' . 'CancelBy' . '}',
                ObjectSerializer::toPathValue($cancel_by),
                $resourcePath
            );
        }
        // path params
        if ($deprecated_version !== null) {
            $resourcePath = str_replace(
                '{' . 'deprecatedVersion' . '}',
                ObjectSerializer::toPathValue($deprecated_version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deprecatedPickupCreation
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of the API.  Valid values: - v1 - v1607 - v1707 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPCreationResponseWrapper
     */
    public function deprecatedPickupCreation($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing')
    {
        list($response) = $this->deprecatedPickupCreationWithHttpInfo($body, $deprecated_version, $trans_id, $transaction_src);
        return $response;
    }

    /**
     * Operation deprecatedPickupCreationWithHttpInfo
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of the API.  Valid values: - v1 - v1607 - v1707 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPCreationResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function deprecatedPickupCreationWithHttpInfo($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper';
        $request = $this->deprecatedPickupCreationRequest($body, $deprecated_version, $trans_id, $transaction_src);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deprecatedPickupCreationAsync
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of the API.  Valid values: - v1 - v1607 - v1707 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedPickupCreationAsync($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing')
    {
        return $this->deprecatedPickupCreationAsyncWithHttpInfo($body, $deprecated_version, $trans_id, $transaction_src)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deprecatedPickupCreationAsyncWithHttpInfo
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of the API.  Valid values: - v1 - v1607 - v1707 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedPickupCreationAsyncWithHttpInfo($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper';
        $request = $this->deprecatedPickupCreationRequest($body, $deprecated_version, $trans_id, $transaction_src);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deprecatedPickupCreation'
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $deprecated_version Version of the API.  Valid values: - v1 - v1607 - v1707 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deprecatedPickupCreationRequest($body, $deprecated_version, $trans_id = null, $transaction_src = 'testing')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling deprecatedPickupCreation'
            );
        }
        // verify the required parameter 'deprecated_version' is set
        if ($deprecated_version === null || (is_array($deprecated_version) && count($deprecated_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deprecated_version when calling deprecatedPickupCreation'
            );
        }

        $resourcePath = '/pickupcreation/{deprecatedVersion}/pickup';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($deprecated_version !== null) {
            $resourcePath = str_replace(
                '{' . 'deprecatedVersion' . '}',
                ObjectSerializer::toPathValue($deprecated_version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation pickupCancel
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $version Version of API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPCancelResponseWrapper
     */
    public function pickupCancel($cancel_by, $version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        list($response) = $this->pickupCancelWithHttpInfo($cancel_by, $version, $trans_id, $transaction_src, $prn);
        return $response;
    }

    /**
     * Operation pickupCancelWithHttpInfo
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $version Version of API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPCancelResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function pickupCancelWithHttpInfo($cancel_by, $version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper';
        $request = $this->pickupCancelRequest($cancel_by, $version, $trans_id, $transaction_src, $prn);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation pickupCancelAsync
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $version Version of API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupCancelAsync($cancel_by, $version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        return $this->pickupCancelAsyncWithHttpInfo($cancel_by, $version, $trans_id, $transaction_src, $prn)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation pickupCancelAsyncWithHttpInfo
     *
     * Pickup Cancel
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $version Version of API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupCancelAsyncWithHttpInfo($cancel_by, $version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCancelResponseWrapper';
        $request = $this->pickupCancelRequest($cancel_by, $version, $trans_id, $transaction_src, $prn);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'pickupCancel'
     *
     * @param  string $cancel_by Valid Values: 01 &#x3D; AccountNumber, 02 &#x3D; PRN (required)
     * @param  string $version Version of API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     * @param  string $prn The pickup equest number (PRN) generated by  UPS pickup system. Required if CancelBy &#x3D; prn.Length 26 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function pickupCancelRequest($cancel_by, $version, $trans_id = null, $transaction_src = 'testing', $prn = null)
    {
        // verify the required parameter 'cancel_by' is set
        if ($cancel_by === null || (is_array($cancel_by) && count($cancel_by) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cancel_by when calling pickupCancel'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling pickupCancel'
            );
        }

        $resourcePath = '/shipments/{version}/pickup/{CancelBy}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }
        // header params
        if ($prn !== null) {
            $headerParams['Prn'] = ObjectSerializer::toHeaderValue($prn);
        }

        // path params
        if ($cancel_by !== null) {
            $resourcePath = str_replace(
                '{' . 'CancelBy' . '}',
                ObjectSerializer::toPathValue($cancel_by),
                $resourcePath
            );
        }
        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation pickupCreation
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPCreationResponseWrapper
     */
    public function pickupCreation($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        list($response) = $this->pickupCreationWithHttpInfo($body, $version, $trans_id, $transaction_src);
        return $response;
    }

    /**
     * Operation pickupCreationWithHttpInfo
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPCreationResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function pickupCreationWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper';
        $request = $this->pickupCreationRequest($body, $version, $trans_id, $transaction_src);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation pickupCreationAsync
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupCreationAsync($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        return $this->pickupCreationAsyncWithHttpInfo($body, $version, $trans_id, $transaction_src)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation pickupCreationAsyncWithHttpInfo
     *
     * Pickup Creation
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupCreationAsyncWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPCreationResponseWrapper';
        $request = $this->pickupCreationRequest($body, $version, $trans_id, $transaction_src);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'pickupCreation'
     *
     * @param  \UPS\Pickup\Pickup\PICKUPCreationRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v2403 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function pickupCreationRequest($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling pickupCreation'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling pickupCreation'
            );
        }

        $resourcePath = '/pickupcreation/{version}/pickup';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation pickupGetPoliticalDivision1List
     *
     * Pickup Get Political Division1 List
     *
     * @param  string $trans_id An identifier unique to the request. Length 32 (required)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $countrycode Country or terrirtory for which the list will  represent.Length 2 (required)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPPolDivResponseWrapper
     */
    public function pickupGetPoliticalDivision1List($trans_id, $transaction_src, $version, $countrycode)
    {
        list($response) = $this->pickupGetPoliticalDivision1ListWithHttpInfo($trans_id, $transaction_src, $version, $countrycode);
        return $response;
    }

    /**
     * Operation pickupGetPoliticalDivision1ListWithHttpInfo
     *
     * Pickup Get Political Division1 List
     *
     * @param  string $trans_id An identifier unique to the request. Length 32 (required)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $countrycode Country or terrirtory for which the list will  represent.Length 2 (required)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPPolDivResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function pickupGetPoliticalDivision1ListWithHttpInfo($trans_id, $transaction_src, $version, $countrycode)
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPPolDivResponseWrapper';
        $request = $this->pickupGetPoliticalDivision1ListRequest($trans_id, $transaction_src, $version, $countrycode);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPPolDivResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation pickupGetPoliticalDivision1ListAsync
     *
     * Pickup Get Political Division1 List
     *
     * @param  string $trans_id An identifier unique to the request. Length 32 (required)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $countrycode Country or terrirtory for which the list will  represent.Length 2 (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupGetPoliticalDivision1ListAsync($trans_id, $transaction_src, $version, $countrycode)
    {
        return $this->pickupGetPoliticalDivision1ListAsyncWithHttpInfo($trans_id, $transaction_src, $version, $countrycode)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation pickupGetPoliticalDivision1ListAsyncWithHttpInfo
     *
     * Pickup Get Political Division1 List
     *
     * @param  string $trans_id An identifier unique to the request. Length 32 (required)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $countrycode Country or terrirtory for which the list will  represent.Length 2 (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupGetPoliticalDivision1ListAsyncWithHttpInfo($trans_id, $transaction_src, $version, $countrycode)
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPPolDivResponseWrapper';
        $request = $this->pickupGetPoliticalDivision1ListRequest($trans_id, $transaction_src, $version, $countrycode);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'pickupGetPoliticalDivision1List'
     *
     * @param  string $trans_id An identifier unique to the request. Length 32 (required)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $countrycode Country or terrirtory for which the list will  represent.Length 2 (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function pickupGetPoliticalDivision1ListRequest($trans_id, $transaction_src, $version, $countrycode)
    {
        // verify the required parameter 'trans_id' is set
        if ($trans_id === null || (is_array($trans_id) && count($trans_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $trans_id when calling pickupGetPoliticalDivision1List'
            );
        }
        // verify the required parameter 'transaction_src' is set
        if ($transaction_src === null || (is_array($transaction_src) && count($transaction_src) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transaction_src when calling pickupGetPoliticalDivision1List'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling pickupGetPoliticalDivision1List'
            );
        }
        // verify the required parameter 'countrycode' is set
        if ($countrycode === null || (is_array($countrycode) && count($countrycode) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $countrycode when calling pickupGetPoliticalDivision1List'
            );
        }

        $resourcePath = '/pickup/{version}/countries/{countrycode}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }
        // path params
        if ($countrycode !== null) {
            $resourcePath = str_replace(
                '{' . 'countrycode' . '}',
                ObjectSerializer::toPathValue($countrycode),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation pickupGetServiceCenterFacilities
     *
     * Pickup Get Service Center Facilities
     *
     * @param  \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPServCenterResponseWrapper
     */
    public function pickupGetServiceCenterFacilities($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        list($response) = $this->pickupGetServiceCenterFacilitiesWithHttpInfo($body, $version, $trans_id, $transaction_src);
        return $response;
    }

    /**
     * Operation pickupGetServiceCenterFacilitiesWithHttpInfo
     *
     * Pickup Get Service Center Facilities
     *
     * @param  \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPServCenterResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function pickupGetServiceCenterFacilitiesWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPServCenterResponseWrapper';
        $request = $this->pickupGetServiceCenterFacilitiesRequest($body, $version, $trans_id, $transaction_src);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPServCenterResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation pickupGetServiceCenterFacilitiesAsync
     *
     * Pickup Get Service Center Facilities
     *
     * @param  \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupGetServiceCenterFacilitiesAsync($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        return $this->pickupGetServiceCenterFacilitiesAsyncWithHttpInfo($body, $version, $trans_id, $transaction_src)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation pickupGetServiceCenterFacilitiesAsyncWithHttpInfo
     *
     * Pickup Get Service Center Facilities
     *
     * @param  \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupGetServiceCenterFacilitiesAsyncWithHttpInfo($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPServCenterResponseWrapper';
        $request = $this->pickupGetServiceCenterFacilitiesRequest($body, $version, $trans_id, $transaction_src);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'pickupGetServiceCenterFacilities'
     *
     * @param  \UPS\Pickup\Pickup\PICKUPServCenterRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of API.  Valid values: - v1 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function pickupGetServiceCenterFacilitiesRequest($body, $version, $trans_id = null, $transaction_src = 'testing')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling pickupGetServiceCenterFacilities'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling pickupGetServiceCenterFacilities'
            );
        }

        $resourcePath = '/pickup/{version}/servicecenterlocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation pickupPendingStatus
     *
     * Pickup Pending Status
     *
     * @param  string $account_number The specific account number that belongs to the  shipper.Length 6 or 10 (required)
     * @param  string $version Version of API  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPPendingResponseWrapper
     */
    public function pickupPendingStatus($account_number, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        list($response) = $this->pickupPendingStatusWithHttpInfo($account_number, $version, $pickuptype, $trans_id, $transaction_src);
        return $response;
    }

    /**
     * Operation pickupPendingStatusWithHttpInfo
     *
     * Pickup Pending Status
     *
     * @param  string $account_number The specific account number that belongs to the  shipper.Length 6 or 10 (required)
     * @param  string $version Version of API  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPPendingResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function pickupPendingStatusWithHttpInfo($account_number, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPPendingResponseWrapper';
        $request = $this->pickupPendingStatusRequest($account_number, $version, $pickuptype, $trans_id, $transaction_src);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPPendingResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation pickupPendingStatusAsync
     *
     * Pickup Pending Status
     *
     * @param  string $account_number The specific account number that belongs to the  shipper.Length 6 or 10 (required)
     * @param  string $version Version of API  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupPendingStatusAsync($account_number, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        return $this->pickupPendingStatusAsyncWithHttpInfo($account_number, $version, $pickuptype, $trans_id, $transaction_src)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation pickupPendingStatusAsyncWithHttpInfo
     *
     * Pickup Pending Status
     *
     * @param  string $account_number The specific account number that belongs to the  shipper.Length 6 or 10 (required)
     * @param  string $version Version of API  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupPendingStatusAsyncWithHttpInfo($account_number, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPPendingResponseWrapper';
        $request = $this->pickupPendingStatusRequest($account_number, $version, $pickuptype, $trans_id, $transaction_src);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'pickupPendingStatus'
     *
     * @param  string $account_number The specific account number that belongs to the  shipper.Length 6 or 10 (required)
     * @param  string $version Version of API  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function pickupPendingStatusRequest($account_number, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        // verify the required parameter 'account_number' is set
        if ($account_number === null || (is_array($account_number) && count($account_number) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_number when calling pickupPendingStatus'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling pickupPendingStatus'
            );
        }
        // verify the required parameter 'pickuptype' is set
        if ($pickuptype === null || (is_array($pickuptype) && count($pickuptype) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pickuptype when calling pickupPendingStatus'
            );
        }

        $resourcePath = '/shipments/{version}/pickup/{pickuptype}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }
        // header params
        if ($account_number !== null) {
            $headerParams['AccountNumber'] = ObjectSerializer::toHeaderValue($account_number);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }
        // path params
        if ($pickuptype !== null) {
            $resourcePath = str_replace(
                '{' . 'pickuptype' . '}',
                ObjectSerializer::toPathValue($pickuptype),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation pickupRate
     *
     * Pickup Rate
     *
     * @param  \UPS\Pickup\Pickup\PICKUPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\Pickup\Pickup\PICKUPResponseWrapper
     */
    public function pickupRate($body, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        list($response) = $this->pickupRateWithHttpInfo($body, $version, $pickuptype, $trans_id, $transaction_src);
        return $response;
    }

    /**
     * Operation pickupRateWithHttpInfo
     *
     * Pickup Rate
     *
     * @param  \UPS\Pickup\Pickup\PICKUPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \UPS\Pickup\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\Pickup\Pickup\PICKUPResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function pickupRateWithHttpInfo($body, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPResponseWrapper';
        $request = $this->pickupRateRequest($body, $version, $pickuptype, $trans_id, $transaction_src);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\PICKUPResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\Pickup\Pickup\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation pickupRateAsync
     *
     * Pickup Rate
     *
     * @param  \UPS\Pickup\Pickup\PICKUPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupRateAsync($body, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        return $this->pickupRateAsyncWithHttpInfo($body, $version, $pickuptype, $trans_id, $transaction_src)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation pickupRateAsyncWithHttpInfo
     *
     * Pickup Rate
     *
     * @param  \UPS\Pickup\Pickup\PICKUPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function pickupRateAsyncWithHttpInfo($body, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        $returnType = '\UPS\Pickup\Pickup\PICKUPResponseWrapper';
        $request = $this->pickupRateRequest($body, $version, $pickuptype, $trans_id, $transaction_src);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'pickupRate'
     *
     * @param  \UPS\Pickup\Pickup\PICKUPRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click &quot;Authorize&quot; and enter your application credentials, then populate the required parameters above and click &quot;Try it out&quot;. (required)
     * @param  string $version Version of the API.  Valid values: - v1 (required)
     * @param  string $pickuptype Type of pickup. Valid values: oncall smart both. Length 6 (required)
     * @param  string $trans_id An identifier unique to the request. Length 32 (optional)
     * @param  string $transaction_src An identifier of the client/source application that is making the request.Length 512 (optional, default to testing)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function pickupRateRequest($body, $version, $pickuptype, $trans_id = null, $transaction_src = 'testing')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling pickupRate'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling pickupRate'
            );
        }
        // verify the required parameter 'pickuptype' is set
        if ($pickuptype === null || (is_array($pickuptype) && count($pickuptype) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pickuptype when calling pickupRate'
            );
        }

        $resourcePath = '/shipments/{version}/pickup/{pickuptype}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($trans_id !== null) {
            $headerParams['transId'] = ObjectSerializer::toHeaderValue($trans_id);
        }
        // header params
        if ($transaction_src !== null) {
            $headerParams['transactionSrc'] = ObjectSerializer::toHeaderValue($transaction_src);
        }

        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }
        // path params
        if ($pickuptype !== null) {
            $resourcePath = str_replace(
                '{' . 'pickuptype' . '}',
                ObjectSerializer::toPathValue($pickuptype),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
