
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `admidio4315`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_announcements`
--

CREATE TABLE `[[dbprefix]]_announcements` (
  `ann_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ann_cat_id` int(10) unsigned NOT NULL,
  `ann_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `ann_headline` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `ann_description` text COLLATE utf8_unicode_ci,
  `ann_usr_id_create` int(10) unsigned DEFAULT NULL,
  `ann_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ann_usr_id_change` int(10) unsigned DEFAULT NULL,
  `ann_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ann_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ann_uuid` (`ann_uuid`),
  KEY `[[dbprefix]]_fk_ann_cat` (`ann_cat_id`),
  KEY `[[dbprefix]]_fk_ann_usr_create` (`ann_usr_id_create`),
  KEY `[[dbprefix]]_fk_ann_usr_change` (`ann_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_auto_login`
--

CREATE TABLE `[[dbprefix]]_auto_login` (
  `atl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `atl_auto_login_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `atl_session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `atl_org_id` int(10) unsigned NOT NULL,
  `atl_usr_id` int(10) unsigned NOT NULL,
  `atl_last_login` timestamp NULL DEFAULT NULL,
  `atl_number_invalid` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`atl_id`),
  KEY `[[dbprefix]]_fk_atl_usr` (`atl_usr_id`),
  KEY `[[dbprefix]]_fk_atl_org` (`atl_org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_categories`
--

CREATE TABLE `[[dbprefix]]_categories` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_org_id` int(10) unsigned DEFAULT NULL,
  `cat_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `cat_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `cat_name_intern` varchar(110) COLLATE utf8_unicode_ci NOT NULL,
  `cat_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `cat_system` tinyint(1) NOT NULL DEFAULT '0',
  `cat_default` tinyint(1) NOT NULL DEFAULT '0',
  `cat_sequence` smallint(6) NOT NULL,
  `cat_usr_id_create` int(10) unsigned DEFAULT NULL,
  `cat_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cat_usr_id_change` int(10) unsigned DEFAULT NULL,
  `cat_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`cat_id`),
  UNIQUE KEY `[[dbprefix]]_idx_cat_uuid` (`cat_uuid`),
  KEY `[[dbprefix]]_fk_cat_org` (`cat_org_id`),
  KEY `[[dbprefix]]_fk_cat_usr_create` (`cat_usr_id_create`),
  KEY `[[dbprefix]]_fk_cat_usr_change` (`cat_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]_categories`
--

INSERT INTO `[[dbprefix]]_categories` VALUES
(1, NULL, '4bb922c4-53ff-4407-a6f7-039052384d9a', 'USF', 'BASIC_DATA', 'SYS_BASIC_DATA', 1, 0, 1, 1, '[[regtime]]', NULL, NULL),
(2, NULL, '27ddb6ce-f41b-40e0-bd94-ec3e585e024a', 'USF', 'SOCIAL_NETWORKS', 'SYS_SOCIAL_NETWORKS', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(3, NULL, '85778e92-92c3-4e08-b901-d216acc14045', 'USF', 'ADDIDIONAL_DATA', 'INS_ADDIDIONAL_DATA', 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(4, 1, '3296268d-15a6-4607-aedf-dfc32fb7ce5b', 'ROL', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(5, 1, '9e55bebc-c196-4e8a-a457-43e484896837', 'ROL', 'GROUPS', 'INS_GROUPS', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(6, 1, '37059dff-9adc-4c9d-a5f6-549d1991110e', 'ROL', 'COURSES', 'INS_COURSES', 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(7, 1, '734d00f9-2fb6-4e40-9869-120ecd2c1ef7', 'ROL', 'TEAMS', 'INS_TEAMS', 0, 0, 4, 1, '[[regtime]]', NULL, NULL),
(8, 1, '03ea55a5-a6c8-4894-ab20-8fe009f27def', 'ROL', 'EVENTS', 'SYS_EVENTS_CONFIRMATION_OF_PARTICIPATION', 1, 0, 5, 1, '[[regtime]]', NULL, NULL),
(9, 1, 'b528ee64-8b9c-4b79-b1c9-fe1530ac9a0e', 'LNK', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(10, 1, 'eba15184-ea4e-4f11-a78d-0d3c1ebb6633', 'LNK', 'INTERN', 'INS_INTERN', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(11, 1, '6a3e4364-c9a2-4bf8-aec6-d23533427f6b', 'ANN', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(12, 1, 'f599ca99-dd22-4a72-8577-439b6e9d1608', 'ANN', 'IMPORTANT', 'SYS_IMPORTANT', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(13, 1, '9992b742-096c-4186-85ec-262c4cb893f8', 'EVT', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(14, 1, 'b9dc925e-89e0-4c2a-b41a-2421da4884f5', 'EVT', 'TRAINING', 'INS_TRAINING', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(15, 1, 'b88b13d1-60c8-4ba4-9436-a7690836bf06', 'EVT', 'COURSES', 'INS_COURSES', 0, 0, 3, 1, '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_category_report`
--

CREATE TABLE `[[dbprefix]]_category_report` (
  `crt_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `crt_org_id` int(10) unsigned DEFAULT NULL,
  `crt_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `crt_col_fields` text COLLATE utf8_unicode_ci,
  `crt_selection_role` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crt_selection_cat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crt_number_col` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`crt_id`),
  KEY `[[dbprefix]]_fk_crt_org` (`crt_org_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_category_report`
--

INSERT INTO `[[dbprefix]]_category_report` VALUES
(1, 1, 'General role assignment', 'p2,p1,p3,p5,r1,r3,r2', NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_components`
--

CREATE TABLE `[[dbprefix]]_components` (
  `com_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `com_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `com_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `com_name_intern` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `com_version` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `com_beta` smallint(6) NOT NULL DEFAULT '0',
  `com_update_step` int(11) NOT NULL DEFAULT '0',
  `com_update_completed` tinyint(1) NOT NULL DEFAULT '1',
  `com_timestamp_installed` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`com_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]_components`
--

INSERT INTO `[[dbprefix]]_components` VALUES
(1, 'SYSTEM', 'Admidio Core', 'CORE', '4.3.15', 0, 1260, 1, '[[regtime]]'),
(2, 'MODULE', 'SYS_ANNOUNCEMENTS', 'ANNOUNCEMENTS', '4.3.15', 0, 0, 1, '[[regtime]]'),
(3, 'MODULE', 'SYS_DATABASE_BACKUP', 'BACKUP', '4.3.15', 0, 0, 1, '[[regtime]]'),
(4, 'MODULE', 'SYS_CATEGORIES', 'CATEGORIES', '4.3.15', 0, 0, 1, '[[regtime]]'),
(5, 'MODULE', 'SYS_CATEGORY_REPORT', 'CATEGORY-REPORT', '4.3.15', 0, 0, 1, '[[regtime]]'),
(6, 'MODULE', 'SYS_EVENTS', 'EVENTS', '4.3.15', 0, 0, 1, '[[regtime]]'),
(7, 'MODULE', 'SYS_DOCUMENTS_FILES', 'DOCUMENTS-FILES', '4.3.15', 0, 0, 1, '[[regtime]]'),
(8, 'MODULE', 'GBO_GUESTBOOK', 'GUESTBOOK', '4.3.15', 0, 0, 1, '[[regtime]]'),
(9, 'MODULE', 'SYS_WEBLINKS', 'LINKS', '4.3.15', 0, 0, 1, '[[regtime]]'),
(10, 'MODULE', 'SYS_GROUPS_ROLES', 'GROUPS-ROLES', '4.3.15', 0, 0, 1, '[[regtime]]'),
(11, 'MODULE', 'SYS_CONTACTS', 'CONTACTS', '4.3.15', 0, 0, 1, '[[regtime]]'),
(12, 'MODULE', 'SYS_MESSAGES', 'MESSAGES', '4.3.15', 0, 0, 1, '[[regtime]]'),
(13, 'MODULE', 'SYS_MENU', 'MENU', '4.3.15', 0, 0, 1, '[[regtime]]'),
(14, 'MODULE', 'SYS_PHOTOS', 'PHOTOS', '4.3.15', 0, 0, 1, '[[regtime]]'),
(15, 'MODULE', 'SYS_SETTINGS', 'PREFERENCES', '4.3.15', 0, 0, 1, '[[regtime]]'),
(16, 'MODULE', 'SYS_PROFILE', 'PROFILE', '4.3.15', 0, 0, 1, '[[regtime]]'),
(17, 'MODULE', 'SYS_REGISTRATION', 'REGISTRATION', '4.3.15', 0, 0, 1, '[[regtime]]'),
(18, 'MODULE', 'SYS_ROOM_MANAGEMENT', 'ROOMS', '4.3.15', 0, 0, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_events`
--

CREATE TABLE `[[dbprefix]]_events` (
  `dat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dat_cat_id` int(10) unsigned NOT NULL,
  `dat_rol_id` int(10) unsigned DEFAULT NULL,
  `dat_room_id` int(10) unsigned DEFAULT NULL,
  `dat_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `dat_begin` timestamp NULL DEFAULT NULL,
  `dat_end` timestamp NULL DEFAULT NULL,
  `dat_all_day` tinyint(1) NOT NULL DEFAULT '0',
  `dat_headline` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `dat_description` text COLLATE utf8_unicode_ci,
  `dat_highlight` tinyint(1) NOT NULL DEFAULT '0',
  `dat_location` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dat_country` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dat_deadline` timestamp NULL DEFAULT NULL,
  `dat_max_members` int(11) NOT NULL DEFAULT '0',
  `dat_usr_id_create` int(10) unsigned DEFAULT NULL,
  `dat_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `dat_usr_id_change` int(10) unsigned DEFAULT NULL,
  `dat_timestamp_change` timestamp NULL DEFAULT NULL,
  `dat_allow_comments` tinyint(1) NOT NULL DEFAULT '0',
  `dat_additional_guests` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`dat_id`),
  UNIQUE KEY `[[dbprefix]]_idx_dat_uuid` (`dat_uuid`),
  KEY `[[dbprefix]]_fk_dat_cat` (`dat_cat_id`),
  KEY `[[dbprefix]]_fk_dat_rol` (`dat_rol_id`),
  KEY `[[dbprefix]]_fk_dat_room` (`dat_room_id`),
  KEY `[[dbprefix]]_fk_dat_usr_create` (`dat_usr_id_create`),
  KEY `[[dbprefix]]_fk_dat_usr_change` (`dat_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_files`
--

CREATE TABLE `[[dbprefix]]_files` (
  `fil_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fil_fol_id` int(10) unsigned NOT NULL,
  `fil_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `fil_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fil_description` text COLLATE utf8_unicode_ci,
  `fil_locked` tinyint(1) NOT NULL DEFAULT '0',
  `fil_counter` int(11) DEFAULT NULL,
  `fil_usr_id` int(10) unsigned DEFAULT NULL,
  `fil_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`fil_id`),
  UNIQUE KEY `[[dbprefix]]_idx_fil_uuid` (`fil_uuid`),
  KEY `[[dbprefix]]_fk_fil_fol` (`fil_fol_id`),
  KEY `[[dbprefix]]_fk_fil_usr` (`fil_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_folders`
--

CREATE TABLE `[[dbprefix]]_folders` (
  `fol_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fol_org_id` int(10) unsigned NOT NULL,
  `fol_fol_id_parent` int(10) unsigned DEFAULT NULL,
  `fol_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `fol_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `fol_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fol_description` text COLLATE utf8_unicode_ci,
  `fol_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fol_locked` tinyint(1) NOT NULL DEFAULT '0',
  `fol_public` tinyint(1) NOT NULL DEFAULT '0',
  `fol_usr_id` int(10) unsigned DEFAULT NULL,
  `fol_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`fol_id`),
  UNIQUE KEY `[[dbprefix]]_idx_fol_uuid` (`fol_uuid`),
  KEY `[[dbprefix]]_fk_fol_org` (`fol_org_id`),
  KEY `[[dbprefix]]_fk_fol_fol_parent` (`fol_fol_id_parent`),
  KEY `[[dbprefix]]_fk_fol_usr` (`fol_usr_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_folders`
--

INSERT INTO `[[dbprefix]]_folders` VALUES
(1, 1, NULL, 'bea190b2-533e-46bf-8d62-c5a6c7773bc1', 'DOCUMENTS', 'documents_[[short_site_name]]', NULL, '/adm_my_files', 0, 1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_guestbook`
--

CREATE TABLE `[[dbprefix]]_guestbook` (
  `gbo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gbo_org_id` int(10) unsigned NOT NULL,
  `gbo_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `gbo_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `gbo_text` text COLLATE utf8_unicode_ci NOT NULL,
  `gbo_email` varchar(254) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gbo_homepage` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gbo_ip_address` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `gbo_locked` tinyint(1) NOT NULL DEFAULT '0',
  `gbo_usr_id_create` int(10) unsigned DEFAULT NULL,
  `gbo_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `gbo_usr_id_change` int(10) unsigned DEFAULT NULL,
  `gbo_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`gbo_id`),
  UNIQUE KEY `[[dbprefix]]_idx_gbo_uuid` (`gbo_uuid`),
  KEY `[[dbprefix]]_fk_gbo_org` (`gbo_org_id`),
  KEY `[[dbprefix]]_fk_gbo_usr_create` (`gbo_usr_id_create`),
  KEY `[[dbprefix]]_fk_gbo_usr_change` (`gbo_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_guestbook_comments`
--

CREATE TABLE `[[dbprefix]]_guestbook_comments` (
  `gbc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gbc_gbo_id` int(10) unsigned NOT NULL,
  `gbc_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `gbc_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `gbc_text` text COLLATE utf8_unicode_ci NOT NULL,
  `gbc_email` varchar(254) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gbc_ip_address` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `gbc_locked` tinyint(1) NOT NULL DEFAULT '0',
  `gbc_usr_id_create` int(10) unsigned DEFAULT NULL,
  `gbc_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `gbc_usr_id_change` int(10) unsigned DEFAULT NULL,
  `gbc_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`gbc_id`),
  UNIQUE KEY `[[dbprefix]]_idx_gbc_uuid` (`gbc_uuid`),
  KEY `[[dbprefix]]_fk_gbc_gbo` (`gbc_gbo_id`),
  KEY `[[dbprefix]]_fk_gbc_usr_create` (`gbc_usr_id_create`),
  KEY `[[dbprefix]]_fk_gbc_usr_change` (`gbc_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ids`
--

CREATE TABLE `[[dbprefix]]_ids` (
  `ids_usr_id` int(10) unsigned NOT NULL,
  `ids_reference_id` int(10) unsigned NOT NULL,
  KEY `[[dbprefix]]_fk_ids_usr_id` (`ids_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_links`
--

CREATE TABLE `[[dbprefix]]_links` (
  `lnk_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lnk_cat_id` int(10) unsigned NOT NULL,
  `lnk_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `lnk_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lnk_description` text COLLATE utf8_unicode_ci,
  `lnk_url` varchar(2000) COLLATE utf8_unicode_ci NOT NULL,
  `lnk_counter` int(11) NOT NULL DEFAULT '0',
  `lnk_usr_id_create` int(10) unsigned DEFAULT NULL,
  `lnk_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lnk_usr_id_change` int(10) unsigned DEFAULT NULL,
  `lnk_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`lnk_id`),
  UNIQUE KEY `[[dbprefix]]_idx_lnk_uuid` (`lnk_uuid`),
  KEY `[[dbprefix]]_fk_lnk_cat` (`lnk_cat_id`),
  KEY `[[dbprefix]]_fk_lnk_usr_create` (`lnk_usr_id_create`),
  KEY `[[dbprefix]]_fk_lnk_usr_change` (`lnk_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_lists`
--

CREATE TABLE `[[dbprefix]]_lists` (
  `lst_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lst_org_id` int(10) unsigned NOT NULL,
  `lst_usr_id` int(10) unsigned NOT NULL,
  `lst_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `lst_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lst_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lst_global` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lst_id`),
  UNIQUE KEY `[[dbprefix]]_idx_lst_uuid` (`lst_uuid`),
  KEY `[[dbprefix]]_fk_lst_usr` (`lst_usr_id`),
  KEY `[[dbprefix]]_fk_lst_org` (`lst_org_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]_lists`
--

INSERT INTO `[[dbprefix]]_lists` VALUES
(1, 1, 1, '9a6f0063-08f5-4e56-ba4b-23b4da52001c', 'Address list', '[[regtime]]', 1),
(2, 1, 1, 'c7b13098-2d25-439e-80f3-e99ff645ec22', 'Phone list', '[[regtime]]', 1),
(3, 1, 1, '7521a12f-0d8b-4f17-b627-2fdd3cb1ff44', 'Contact information', '[[regtime]]', 1),
(4, 1, 1, '079b43e0-48b5-4ce4-9513-25621b26b984', 'Membership', '[[regtime]]', 1),
(5, 1, 1, '125838fb-df05-48f3-9fcf-dfbf15893d0a', 'Members', '[[regtime]]', 1),
(6, 1, 1, 'e44077bd-3e93-4b52-a432-81ec787d0eb9', 'Contacts', '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_list_columns`
--

CREATE TABLE `[[dbprefix]]_list_columns` (
  `lsc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lsc_lst_id` int(10) unsigned NOT NULL,
  `lsc_number` smallint(6) NOT NULL,
  `lsc_usf_id` int(10) unsigned DEFAULT NULL,
  `lsc_special_field` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lsc_sort` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lsc_filter` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lsc_id`),
  KEY `[[dbprefix]]_fk_lsc_lst` (`lsc_lst_id`),
  KEY `[[dbprefix]]_fk_lsc_usf` (`lsc_usf_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=38 ;

--
-- Dumping data for table `[[dbprefix]]_list_columns`
--

INSERT INTO `[[dbprefix]]_list_columns` VALUES
(1, 1, 1, 1, NULL, 'ASC', NULL),
(2, 1, 2, 2, NULL, 'ASC', NULL),
(3, 1, 3, 9, NULL, NULL, NULL),
(4, 1, 4, 3, NULL, NULL, NULL),
(5, 1, 5, 4, NULL, NULL, NULL),
(6, 1, 6, 5, NULL, NULL, NULL),
(7, 2, 1, 1, NULL, 'ASC', NULL),
(8, 2, 2, 2, NULL, 'ASC', NULL),
(9, 2, 3, 7, NULL, NULL, NULL),
(10, 2, 4, 8, NULL, NULL, NULL),
(11, 2, 5, 11, NULL, NULL, NULL),
(12, 3, 1, 1, NULL, 'ASC', NULL),
(13, 3, 2, 2, NULL, 'ASC', NULL),
(14, 3, 3, 9, NULL, NULL, NULL),
(15, 3, 4, 3, NULL, NULL, NULL),
(16, 3, 5, 4, NULL, NULL, NULL),
(17, 3, 6, 5, NULL, NULL, NULL),
(18, 3, 7, 7, NULL, NULL, NULL),
(19, 3, 8, 8, NULL, NULL, NULL),
(20, 3, 9, 11, NULL, NULL, NULL),
(21, 4, 1, 1, NULL, 'ASC', NULL),
(22, 4, 2, 2, NULL, 'ASC', NULL),
(23, 4, 3, 9, NULL, NULL, NULL),
(24, 4, 4, NULL, 'mem_begin', NULL, NULL),
(25, 4, 5, NULL, 'mem_end', NULL, NULL),
(26, 5, 1, 1, NULL, 'ASC', NULL),
(27, 5, 2, 2, NULL, 'ASC', NULL),
(28, 5, 3, NULL, 'mem_approved', NULL, NULL),
(29, 5, 4, NULL, 'mem_comment', NULL, NULL),
(30, 5, 5, NULL, 'mem_count_guests', NULL, NULL),
(31, 6, 1, 1, NULL, 'ASC', NULL),
(32, 6, 2, 2, NULL, 'ASC', NULL),
(33, 6, 3, NULL, 'usr_login_name', NULL, NULL),
(34, 6, 4, 10, NULL, NULL, NULL),
(35, 6, 5, 9, NULL, NULL, NULL),
(36, 6, 6, 5, NULL, NULL, NULL),
(37, 6, 7, NULL, 'usr_timestamp_change', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_members`
--

CREATE TABLE `[[dbprefix]]_members` (
  `mem_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mem_rol_id` int(10) unsigned NOT NULL,
  `mem_usr_id` int(10) unsigned NOT NULL,
  `mem_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `mem_begin` date NOT NULL,
  `mem_end` date NOT NULL DEFAULT '9999-12-31',
  `mem_leader` tinyint(1) NOT NULL DEFAULT '0',
  `mem_usr_id_create` int(10) unsigned DEFAULT NULL,
  `mem_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `mem_usr_id_change` int(10) unsigned DEFAULT NULL,
  `mem_timestamp_change` timestamp NULL DEFAULT NULL,
  `mem_approved` int(10) unsigned DEFAULT NULL,
  `mem_comment` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mem_count_guests` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mem_id`),
  UNIQUE KEY `[[dbprefix]]_idx_mem_uuid` (`mem_uuid`),
  KEY `[[dbprefix]]_idx_mem_rol_usr_id` (`mem_rol_id`,`mem_usr_id`),
  KEY `[[dbprefix]]_fk_mem_usr` (`mem_usr_id`),
  KEY `[[dbprefix]]_fk_mem_usr_create` (`mem_usr_id_create`),
  KEY `[[dbprefix]]_fk_mem_usr_change` (`mem_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_members`
--

INSERT INTO `[[dbprefix]]_members` VALUES
(1, 1, 2, 'a9cd185d-14e0-456e-81bc-8b20dc2ccd29', '[[date]]', '9999-12-31', 0, 1, '[[regtime]]', NULL, NULL, NULL, NULL, 0),
(2, 2, 2, '939a9c93-8436-4afa-82f5-dfe89c4ff4e5', '[[date]]', '9999-12-31', 0, 1, '[[regtime]]', NULL, NULL, NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_menu`
--

CREATE TABLE `[[dbprefix]]_menu` (
  `men_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `men_men_id_parent` int(10) unsigned DEFAULT NULL,
  `men_com_id` int(10) unsigned DEFAULT NULL,
  `men_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `men_name_intern` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_description` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_node` tinyint(1) NOT NULL DEFAULT '0',
  `men_order` int(10) unsigned DEFAULT NULL,
  `men_standard` tinyint(1) NOT NULL DEFAULT '0',
  `men_url` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_icon` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`men_id`),
  UNIQUE KEY `[[dbprefix]]_idx_men_uuid` (`men_uuid`),
  KEY `[[dbprefix]]_idx_men_men_id_parent` (`men_men_id_parent`),
  KEY `[[dbprefix]]_fk_men_com_id` (`men_com_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]_menu`
--

INSERT INTO `[[dbprefix]]_menu` VALUES
(1, NULL, NULL, 'af05df7a-74b9-4072-b136-00367bea6346', 'modules', 'SYS_MODULES', '', 1, 1, 1, NULL, ''),
(2, NULL, NULL, '2ca91647-ab60-4127-8fac-d98775c7e9f5', 'administration', 'SYS_ADMINISTRATION', '', 1, 2, 1, NULL, ''),
(3, NULL, NULL, 'f9f2b8f1-81f9-4abf-a513-00358bc6e292', 'plugins', 'SYS_PLUGINS', '', 1, 3, 1, NULL, ''),
(4, 1, NULL, '4cf46d67-cedf-4255-9af5-06f51142deee', 'overview', 'SYS_OVERVIEW', '', 0, 1, 1, '/adm_program/overview.php', 'fa-home'),
(5, 1, 2, '1220ad11-18d7-4b9d-876b-2667acc892d4', 'announcements', 'SYS_ANNOUNCEMENTS', 'SYS_ANNOUNCEMENTS_DESC', 0, 2, 1, '/adm_program/modules/announcements/announcements.php', 'fa-newspaper'),
(6, 1, 6, '3e4b4963-7139-4ed1-848d-0ba880294f6b', 'events', 'SYS_EVENTS', 'SYS_EVENTS_DESC', 0, 3, 1, '/adm_program/modules/events/events.php', 'fa-calendar-alt'),
(7, 1, 12, '0ae1940d-ee3a-497a-82c7-b489f3608dc6', 'messages', 'SYS_MESSAGES', 'SYS_MESSAGES_DESC', 0, 4, 1, '/adm_program/modules/messages/messages.php', 'fa-comments'),
(8, 1, 10, 'c9d27934-6bfc-4d1c-8dec-e254d953c338', 'groups-roles', 'SYS_GROUPS_ROLES', 'SYS_GROUPS_ROLES_DESC', 0, 5, 1, '/adm_program/modules/groups-roles/groups_roles.php', 'fa-users'),
(9, 1, 11, 'b9abc247-aa57-411b-9520-f1a493d59e83', 'contacts', 'SYS_CONTACTS', 'SYS_CONTACTS_DESC', 0, 6, 1, '/adm_program/modules/contacts/contacts.php', 'fa-address-card'),
(10, 1, 7, '0aeafbba-cc7e-443e-8538-9e3e8743d765', 'documents-files', 'SYS_DOCUMENTS_FILES', 'SYS_DOCUMENTS_FILES_DESC', 0, 7, 1, '/adm_program/modules/documents-files/documents_files.php', 'fa-file-download'),
(11, 1, 14, 'a80e0ca7-57d9-4ced-8157-d99c8dd162e4', 'photo', 'SYS_PHOTOS', 'SYS_PHOTOS_DESC', 0, 8, 1, '/adm_program/modules/photos/photos.php', 'fa-image'),
(12, 1, 5, 'f4d75949-7dc7-4ebe-85ad-3a35c70f642e', 'category-report', 'SYS_CATEGORY_REPORT', 'SYS_CATEGORY_REPORT_DESC', 0, 9, 1, '/adm_program/modules/category-report/category_report.php', 'fa-list-ul'),
(13, 1, 9, 'c89d9701-422f-4895-b80b-05295f232678', 'weblinks', 'SYS_WEBLINKS', 'SYS_WEBLINKS_DESC', 0, 10, 1, '/adm_program/modules/links/links.php', 'fa-link'),
(14, 1, 8, 'cbb904f2-3e77-4c54-9b04-6580bfe704c4', 'guestbook', 'GBO_GUESTBOOK', 'GBO_GUESTBOOK_DESC', 0, 11, 1, '/adm_program/modules/guestbook/guestbook.php', 'fa-book'),
(15, 2, 15, '7dc93c77-c660-4df8-ba0d-170b7ae42222', 'orgprop', 'SYS_SETTINGS', 'ORG_ORGANIZATION_PROPERTIES_DESC', 0, 1, 1, '/adm_program/modules/preferences/preferences.php', 'fa-cog'),
(16, 2, 17, '146b62db-d240-43da-8d47-7f47072bb8c2', 'registration', 'SYS_REGISTRATIONS', 'SYS_MANAGE_NEW_REGISTRATIONS_DESC', 0, 2, 1, '/adm_program/modules/registration/registration.php', 'fa-file-signature'),
(17, 2, 13, '0b0ff841-ac72-429c-966a-74d090f47165', 'menu', 'SYS_MENU', 'SYS_MENU_DESC', 0, 3, 1, '/adm_program/modules/menu/menu.php', 'fa-stream'),
(18, 2, 3, 'd1b725ac-5c23-4422-99b4-04289b76d3c2', 'dbback', 'SYS_DATABASE_BACKUP', 'SYS_DATABASE_BACKUP_DESC', 0, 4, 1, '/adm_program/modules/backup/backup.php', 'fa-database');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages`
--

CREATE TABLE `[[dbprefix]]_messages` (
  `msg_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msg_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `msg_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `msg_subject` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  `msg_usr_id_sender` int(10) unsigned NOT NULL,
  `msg_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `msg_read` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msg_id`),
  UNIQUE KEY `[[dbprefix]]_idx_msg_uuid` (`msg_uuid`),
  KEY `[[dbprefix]]_fk_msg_usr_sender` (`msg_usr_id_sender`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages_attachments`
--

CREATE TABLE `[[dbprefix]]_messages_attachments` (
  `msa_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msa_msg_id` int(10) unsigned NOT NULL,
  `msa_file_name` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  `msa_original_file_name` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`msa_id`),
  KEY `[[dbprefix]]_fk_msa_msg_id` (`msa_msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages_content`
--

CREATE TABLE `[[dbprefix]]_messages_content` (
  `msc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msc_msg_id` int(10) unsigned NOT NULL,
  `msc_usr_id` int(10) unsigned DEFAULT NULL,
  `msc_message` text COLLATE utf8_unicode_ci NOT NULL,
  `msc_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`msc_id`),
  KEY `[[dbprefix]]_fk_msc_msg_id` (`msc_msg_id`),
  KEY `[[dbprefix]]_fk_msc_usr_id` (`msc_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages_recipients`
--

CREATE TABLE `[[dbprefix]]_messages_recipients` (
  `msr_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msr_msg_id` int(10) unsigned NOT NULL,
  `msr_rol_id` int(10) unsigned DEFAULT NULL,
  `msr_usr_id` int(10) unsigned DEFAULT NULL,
  `msr_role_mode` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msr_id`),
  KEY `[[dbprefix]]_fk_msr_msg_id` (`msr_msg_id`),
  KEY `[[dbprefix]]_fk_msr_rol_id` (`msr_rol_id`),
  KEY `[[dbprefix]]_fk_msr_usr_id` (`msr_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_organizations`
--

CREATE TABLE `[[dbprefix]]_organizations` (
  `org_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `org_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `org_shortname` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `org_longname` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `org_org_id_parent` int(10) unsigned DEFAULT NULL,
  `org_homepage` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`org_id`),
  UNIQUE KEY `[[dbprefix]]_idx_org_shortname` (`org_shortname`),
  UNIQUE KEY `[[dbprefix]]_idx_org_uuid` (`org_uuid`),
  KEY `[[dbprefix]]_fk_org_org_parent` (`org_org_id_parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_organizations`
--

INSERT INTO `[[dbprefix]]_organizations` VALUES
(1, 'd734676c-480d-4c2d-8254-ae008705774e', '[[short_site_name]]', '[[site_name]]', NULL, '[[softurl]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_photos`
--

CREATE TABLE `[[dbprefix]]_photos` (
  `pho_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pho_org_id` int(10) unsigned NOT NULL,
  `pho_pho_id_parent` int(10) unsigned DEFAULT NULL,
  `pho_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `pho_quantity` int(10) unsigned NOT NULL DEFAULT '0',
  `pho_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `pho_begin` date NOT NULL,
  `pho_end` date NOT NULL,
  `pho_description` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pho_photographers` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pho_locked` tinyint(1) NOT NULL DEFAULT '0',
  `pho_usr_id_create` int(10) unsigned DEFAULT NULL,
  `pho_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pho_usr_id_change` int(10) unsigned DEFAULT NULL,
  `pho_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`pho_id`),
  UNIQUE KEY `[[dbprefix]]_idx_pho_uuid` (`pho_uuid`),
  KEY `[[dbprefix]]_fk_pho_pho_parent` (`pho_pho_id_parent`),
  KEY `[[dbprefix]]_fk_pho_org` (`pho_org_id`),
  KEY `[[dbprefix]]_fk_pho_usr_create` (`pho_usr_id_create`),
  KEY `[[dbprefix]]_fk_pho_usr_change` (`pho_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_preferences`
--

CREATE TABLE `[[dbprefix]]_preferences` (
  `prf_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prf_org_id` int(10) unsigned NOT NULL,
  `prf_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `prf_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`prf_id`),
  UNIQUE KEY `[[dbprefix]]_idx_prf_org_id_name` (`prf_org_id`,`prf_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=131 ;

--
-- Dumping data for table `[[dbprefix]]_preferences`
--

INSERT INTO `[[dbprefix]]_preferences` VALUES
(1, 1, 'enable_rss', '1'),
(2, 1, 'enable_auto_login', '1'),
(3, 1, 'security_login_email_address_enabled', '0'),
(4, 1, 'default_country', 'DEU'),
(5, 1, 'logout_minutes', '20'),
(6, 1, 'homepage_logout', 'adm_program/overview.php'),
(7, 1, 'homepage_login', 'adm_program/overview.php'),
(8, 1, 'theme', 'simple'),
(9, 1, 'enable_password_recovery', '1'),
(10, 1, 'system_browser_update_check', '0'),
(11, 1, 'system_cookie_note', '1'),
(12, 1, 'system_currency', '€'),
(13, 1, 'system_date', 'd.m.Y'),
(14, 1, 'system_hashing_cost', '11'),
(15, 1, 'system_js_editor_enabled', '1'),
(16, 1, 'system_js_editor_color', '#96c4cb'),
(17, 1, 'system_language', '[[language]]'),
(18, 1, 'system_search_similar', '1'),
(19, 1, 'system_show_create_edit', '1'),
(20, 1, 'system_time', 'H:i'),
(21, 1, 'system_url_imprint', ''),
(22, 1, 'system_url_data_protection', ''),
(23, 1, 'password_min_strength', '1'),
(24, 1, 'email_administrator', '[[admin_email]]'),
(25, 1, 'system_organization_select', '0'),
(26, 1, 'registration_adopt_all_data', '1'),
(27, 1, 'registration_enable_captcha', '1'),
(28, 1, 'registration_enable_module', '1'),
(29, 1, 'registration_manual_approval', '1'),
(30, 1, 'registration_send_notification_email', '1'),
(31, 1, 'mail_send_method', 'phpmail'),
(32, 1, 'mail_sending_mode', '0'),
(33, 1, 'mail_recipients_with_roles', '1'),
(34, 1, 'mail_number_recipients', '50'),
(35, 1, 'mail_into_to', '0'),
(36, 1, 'mail_character_encoding', 'utf-8'),
(37, 1, 'mail_smtp_host', ''),
(38, 1, 'mail_smtp_auth', '1'),
(39, 1, 'mail_smtp_port', '587'),
(40, 1, 'mail_smtp_secure', 'tls'),
(41, 1, 'mail_smtp_authentication_type', ''),
(42, 1, 'mail_smtp_user', ''),
(43, 1, 'mail_smtp_password', ''),
(44, 1, 'system_notifications_enabled', '1'),
(45, 1, 'system_notifications_role', '6e06b01c-528a-43b6-9314-f995e1be2d98'),
(46, 1, 'system_notifications_new_entries', '0'),
(47, 1, 'system_notifications_profile_changes', '0'),
(48, 1, 'captcha_type', 'pic'),
(49, 1, 'captcha_fonts', 'AHGBold.ttf'),
(50, 1, 'captcha_width', '215'),
(51, 1, 'captcha_lines_numbers', '5'),
(52, 1, 'captcha_perturbation', '0.75'),
(53, 1, 'captcha_background_image', ''),
(54, 1, 'captcha_background_color', '#B6D6DB'),
(55, 1, 'captcha_text_color', '#707070'),
(56, 1, 'captcha_line_color', '#707070'),
(57, 1, 'captcha_charset', '23456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxy'),
(58, 1, 'captcha_signature', 'Powered by Admidio.org'),
(59, 1, 'announcements_module_enabled', '1'),
(60, 1, 'announcements_per_page', '10'),
(61, 1, 'category_report_enable_module', '1'),
(62, 1, 'category_report_default_configuration', '1'),
(63, 1, 'contacts_field_history_days', '365'),
(64, 1, 'contacts_list_configuration', '6'),
(65, 1, 'contacts_per_page', '25'),
(66, 1, 'contacts_show_all', '1'),
(67, 1, 'contacts_user_relations_enabled', '1'),
(68, 1, 'documents_files_module_enabled', '1'),
(69, 1, 'documents_files_max_upload_size', '3'),
(70, 1, 'events_list_configuration', '5'),
(71, 1, 'events_ical_export_enabled', '1'),
(72, 1, 'events_ical_days_past', '30'),
(73, 1, 'events_ical_days_future', '365'),
(74, 1, 'events_may_take_part', '0'),
(75, 1, 'events_module_enabled', '1'),
(76, 1, 'events_per_page', '10'),
(77, 1, 'events_rooms_enabled', '0'),
(78, 1, 'events_save_cancellations', '1'),
(79, 1, 'events_show_map_link', '1'),
(80, 1, 'events_view', 'detail'),
(81, 1, 'groups_roles_default_configuration', '1'),
(82, 1, 'groups_roles_enable_module', '1'),
(83, 1, 'groups_roles_export', '1'),
(84, 1, 'groups_roles_edit_lists', '1'),
(85, 1, 'groups_roles_members_per_page', '25'),
(86, 1, 'groups_roles_show_former_members', '2'),
(87, 1, 'enable_guestbook_module', '0'),
(88, 1, 'guestbook_entries_per_page', '10'),
(89, 1, 'enable_guestbook_captcha', '1'),
(90, 1, 'flooding_protection_time', '60'),
(91, 1, 'enable_gbook_comments4all', '0'),
(92, 1, 'enable_intial_comments_loading', '0'),
(93, 1, 'enable_guestbook_moderation', '0'),
(94, 1, 'enable_mail_module', '1'),
(95, 1, 'enable_pm_module', '1'),
(96, 1, 'enable_mail_captcha', '1'),
(97, 1, 'mail_delivery_confirmation', '0'),
(98, 1, 'mail_html_registered_users', '1'),
(99, 1, 'mail_max_receiver', '10'),
(100, 1, 'mail_save_attachments', '1'),
(101, 1, 'mail_send_to_all_addresses', '1'),
(102, 1, 'mail_sendmail_address', ''),
(103, 1, 'mail_sendmail_name', ''),
(104, 1, 'mail_show_former', '1'),
(105, 1, 'mail_template', 'default.html'),
(106, 1, 'max_email_attachment_size', '1'),
(107, 1, 'photo_albums_per_page', '24'),
(108, 1, 'photo_download_enabled', '0'),
(109, 1, 'photo_ecard_enabled', '1'),
(110, 1, 'photo_ecard_scale', '500'),
(111, 1, 'photo_ecard_template', 'postcard.tpl'),
(112, 1, 'photo_image_text', '© [[domhost]]'),
(113, 1, 'photo_image_text_size', '40'),
(114, 1, 'photo_keep_original', '0'),
(115, 1, 'photo_module_enabled', '1'),
(116, 1, 'photo_show_width', '1200'),
(117, 1, 'photo_show_height', '1200'),
(118, 1, 'photo_show_mode', '1'),
(119, 1, 'photo_thumbs_page', '24'),
(120, 1, 'photo_thumbs_scale', '500'),
(121, 1, 'profile_log_edit_fields', '1'),
(122, 1, 'profile_show_map_link', '0'),
(123, 1, 'profile_show_roles', '1'),
(124, 1, 'profile_show_former_roles', '1'),
(125, 1, 'profile_show_extern_roles', '1'),
(126, 1, 'profile_photo_storage', '0'),
(127, 1, 'enable_weblinks_module', '1'),
(128, 1, 'weblinks_per_page', '0'),
(129, 1, 'weblinks_redirect_seconds', '10'),
(130, 1, 'weblinks_target', '_blank');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_registrations`
--

CREATE TABLE `[[dbprefix]]_registrations` (
  `reg_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reg_org_id` int(10) unsigned NOT NULL,
  `reg_usr_id` int(10) unsigned NOT NULL,
  `reg_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reg_validation_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`reg_id`),
  KEY `[[dbprefix]]_fk_reg_org` (`reg_org_id`),
  KEY `[[dbprefix]]_fk_reg_usr` (`reg_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_roles`
--

CREATE TABLE `[[dbprefix]]_roles` (
  `rol_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rol_cat_id` int(10) unsigned NOT NULL,
  `rol_lst_id` int(10) unsigned DEFAULT NULL,
  `rol_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `rol_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `rol_description` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rol_assign_roles` tinyint(1) NOT NULL DEFAULT '0',
  `rol_approve_users` tinyint(1) NOT NULL DEFAULT '0',
  `rol_announcements` tinyint(1) NOT NULL DEFAULT '0',
  `rol_events` tinyint(1) NOT NULL DEFAULT '0',
  `rol_documents_files` tinyint(1) NOT NULL DEFAULT '0',
  `rol_edit_user` tinyint(1) NOT NULL DEFAULT '0',
  `rol_guestbook` tinyint(1) NOT NULL DEFAULT '0',
  `rol_guestbook_comments` tinyint(1) NOT NULL DEFAULT '0',
  `rol_mail_to_all` tinyint(1) NOT NULL DEFAULT '0',
  `rol_mail_this_role` smallint(6) NOT NULL DEFAULT '0',
  `rol_photo` tinyint(1) NOT NULL DEFAULT '0',
  `rol_profile` tinyint(1) NOT NULL DEFAULT '0',
  `rol_weblinks` tinyint(1) NOT NULL DEFAULT '0',
  `rol_all_lists_view` tinyint(1) NOT NULL DEFAULT '0',
  `rol_default_registration` tinyint(1) NOT NULL DEFAULT '0',
  `rol_leader_rights` smallint(6) NOT NULL DEFAULT '0',
  `rol_view_memberships` smallint(6) NOT NULL DEFAULT '0',
  `rol_view_members_profiles` smallint(6) NOT NULL DEFAULT '0',
  `rol_start_date` date DEFAULT NULL,
  `rol_start_time` time DEFAULT NULL,
  `rol_end_date` date DEFAULT NULL,
  `rol_end_time` time DEFAULT NULL,
  `rol_weekday` smallint(6) DEFAULT NULL,
  `rol_location` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rol_max_members` int(11) DEFAULT NULL,
  `rol_cost` float DEFAULT NULL,
  `rol_cost_period` smallint(6) DEFAULT NULL,
  `rol_usr_id_create` int(10) unsigned DEFAULT NULL,
  `rol_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rol_usr_id_change` int(10) unsigned DEFAULT NULL,
  `rol_timestamp_change` timestamp NULL DEFAULT NULL,
  `rol_valid` tinyint(1) NOT NULL DEFAULT '1',
  `rol_system` tinyint(1) NOT NULL DEFAULT '0',
  `rol_administrator` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rol_id`),
  UNIQUE KEY `[[dbprefix]]_idx_rol_uuid` (`rol_uuid`),
  KEY `[[dbprefix]]_fk_rol_cat` (`rol_cat_id`),
  KEY `[[dbprefix]]_fk_rol_lst_id` (`rol_lst_id`),
  KEY `[[dbprefix]]_fk_rol_usr_create` (`rol_usr_id_create`),
  KEY `[[dbprefix]]_fk_rol_usr_change` (`rol_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]_roles`
--

INSERT INTO `[[dbprefix]]_roles` VALUES
(1, 4, NULL, '6e06b01c-528a-43b6-9314-f995e1be2d98', 'Administrator', 'Group of system administrators', 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 0, 0, 2, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '[[regtime]]', NULL, NULL, 1, 0, 1),
(2, 4, NULL, '21f8fa8d-52c9-4549-94d3-dec6079baaa5', 'Member', 'All organization members', 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '[[regtime]]', NULL, NULL, 1, 0, 0),
(3, 4, NULL, '6cb74624-d2d9-462d-82d4-7e4ad2b23290', 'Association&rsquo;s board', 'Administrative board of association', 0, 0, 1, 1, 0, 1, 0, 0, 1, 2, 0, 1, 1, 1, 0, 0, 2, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '[[regtime]]', NULL, NULL, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_roles_rights`
--

CREATE TABLE `[[dbprefix]]_roles_rights` (
  `ror_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ror_name_intern` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `ror_table` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `ror_ror_id_parent` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ror_id`),
  KEY `[[dbprefix]]_fk_ror_ror_parent` (`ror_ror_id_parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]_roles_rights`
--

INSERT INTO `[[dbprefix]]_roles_rights` VALUES
(1, 'folder_view', 'adm_folders', NULL),
(2, 'folder_upload', 'adm_folders', NULL),
(3, 'category_view', 'adm_categories', NULL),
(4, 'event_participation', 'adm_events', NULL),
(5, 'menu_view', 'adm_menu', NULL),
(6, 'category_edit', 'adm_categories', 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_roles_rights_data`
--

CREATE TABLE `[[dbprefix]]_roles_rights_data` (
  `rrd_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rrd_ror_id` int(10) unsigned NOT NULL,
  `rrd_rol_id` int(10) unsigned NOT NULL,
  `rrd_object_id` int(10) unsigned NOT NULL,
  `rrd_usr_id_create` int(10) unsigned DEFAULT NULL,
  `rrd_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`rrd_id`),
  UNIQUE KEY `[[dbprefix]]_idx_rrd_ror_rol_object_id` (`rrd_ror_id`,`rrd_rol_id`,`rrd_object_id`),
  KEY `[[dbprefix]]_fk_rrd_rol` (`rrd_rol_id`),
  KEY `[[dbprefix]]_fk_rrd_usr_create` (`rrd_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_role_dependencies`
--

CREATE TABLE `[[dbprefix]]_role_dependencies` (
  `rld_rol_id_parent` int(10) unsigned NOT NULL,
  `rld_rol_id_child` int(10) unsigned NOT NULL,
  `rld_comment` text COLLATE utf8_unicode_ci,
  `rld_usr_id` int(10) unsigned DEFAULT NULL,
  `rld_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`rld_rol_id_parent`,`rld_rol_id_child`),
  KEY `[[dbprefix]]_fk_rld_rol_child` (`rld_rol_id_child`),
  KEY `[[dbprefix]]_fk_rld_usr` (`rld_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_rooms`
--

CREATE TABLE `[[dbprefix]]_rooms` (
  `room_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `room_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `room_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `room_description` text COLLATE utf8_unicode_ci,
  `room_capacity` int(11) NOT NULL,
  `room_overhang` int(11) DEFAULT NULL,
  `room_usr_id_create` int(10) unsigned DEFAULT NULL,
  `room_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `room_usr_id_change` int(10) unsigned DEFAULT NULL,
  `room_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`room_id`),
  UNIQUE KEY `[[dbprefix]]_idx_room_uuid` (`room_uuid`),
  KEY `[[dbprefix]]_fk_room_usr_create` (`room_usr_id_create`),
  KEY `[[dbprefix]]_fk_room_usr_change` (`room_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_rooms`
--

INSERT INTO `[[dbprefix]]_rooms` VALUES
(1, 'b00fba37-7c47-4b16-aa6e-9cc4abe8ac94', 'Conference room', 'Meetings can take place here.', 15, NULL, 1, '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_sessions`
--

CREATE TABLE `[[dbprefix]]_sessions` (
  `ses_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ses_usr_id` int(10) unsigned DEFAULT NULL,
  `ses_org_id` int(10) unsigned NOT NULL,
  `ses_session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ses_begin` timestamp NULL DEFAULT NULL,
  `ses_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ses_ip_address` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `ses_binary` blob,
  `ses_reload` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ses_id`),
  KEY `[[dbprefix]]_idx_session_id` (`ses_session_id`),
  KEY `[[dbprefix]]_fk_ses_org` (`ses_org_id`),
  KEY `[[dbprefix]]_fk_ses_usr` (`ses_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_texts`
--

CREATE TABLE `[[dbprefix]]_texts` (
  `txt_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `txt_org_id` int(10) unsigned NOT NULL,
  `txt_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `txt_text` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`txt_id`),
  KEY `[[dbprefix]]_fk_txt_org` (`txt_org_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]_texts`
--

INSERT INTO `[[dbprefix]]_texts` VALUES
(1, 1, 'SYSMAIL_REGISTRATION_CONFIRMATION', '#subject# Your registration at #organization_long_name#\r\n#content# Hello #user_first_name#,\r\nwe are very glad that you have registered on our website #organization_homepage#.\r\n\r\nTo complete your registration, please click on the following link: #variable1#. By clicking on the link you will be automatically redirected to our website and your registration will be confirmed.\r\n\r\nOnce you have confirmed your registration, we will check it. You will receive a reply within a few hours whether your registration has been accepted and you can log in with your credentials or whether your registration has been rejected.\r\n\r\nBest regards\r\nThe team of #organization_long_name#'),
(2, 1, 'SYSMAIL_REGISTRATION_NEW', '#subject# New registration at #organization_long_name# website\r\n#content# A new user has registered on #organization_homepage#.\r\n\r\nSurname: #user_last_name#\r\nFirst Name: #user_first_name#\r\nE-Mail: #user_email#\r\n\r\n\r\nThis message was generated automatically.'),
(3, 1, 'SYSMAIL_REGISTRATION_APPROVED', '#subject# Registration at #organization_long_name# confirmed\r\n#content# Hello #user_first_name#,\r\n\r\nyour registration on #organization_homepage# has been confirmed.\r\n\r\nYou can now log in to the homepage with your username #user_login_name# and your password.\r\n\r\nIf you have any questions, write an email to #administrator_email#.\r\n\r\nRegards,\r\nThe team of #organization_long_name#'),
(4, 1, 'SYSMAIL_REGISTRATION_REFUSED', '#subject# in registration at #organization_long_name# rejected.\r\n#content#Hello #user_first_name#,\r\n\r\nyour registration at #organization_homepage# was rejected.\r\n\r\nRegistrations are accepted in general by our users. If you are a member and your registration was still rejected, it may be because you were not identified as member.\r\nTo clarify the reasons for the rejection please contact the administrator #administrator_email# from #organization_homepage#.\r\n\r\nRegards,\r\nThe team of #organization_long_name#'),
(5, 1, 'SYSMAIL_NEW_PASSWORD', '#subject# Login data for #organization_long_name#\r\n#content# Hello #user_first_name#,\r\n\r\nYou receive your login data for the website #organization_homepage#.\r\nUsername: #user_login_name#\r\nPassword: #variable1#\r\n\r\nThe password was generated automatically,\r\nYou should change it after logging in to #organization_homepage# in your profile.\r\n\r\nRegards,\r\nThe team of #organization_long_name#'),
(6, 1, 'SYSMAIL_PASSWORD_RESET', '#subject# Reset password for #organization_long_name#\r\n#content# Hello #user_first_name#,\r\n\r\nWe have received a request to reset your password on #organization_homepage#.\r\n\r\nIf the request came from you, you can use the following link to reset your password and set a new one: \r\n#variable1#\r\n\r\nRegards,\r\nThe team of #organization_long_name#');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_users`
--

CREATE TABLE `[[dbprefix]]_users` (
  `usr_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usr_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `usr_login_name` varchar(254) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usr_password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usr_photo` blob,
  `usr_text` text COLLATE utf8_unicode_ci,
  `usr_pw_reset_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usr_pw_reset_timestamp` timestamp NULL DEFAULT NULL,
  `usr_last_login` timestamp NULL DEFAULT NULL,
  `usr_actual_login` timestamp NULL DEFAULT NULL,
  `usr_number_login` int(11) NOT NULL DEFAULT '0',
  `usr_date_invalid` timestamp NULL DEFAULT NULL,
  `usr_number_invalid` smallint(6) NOT NULL DEFAULT '0',
  `usr_usr_id_create` int(10) unsigned DEFAULT NULL,
  `usr_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usr_usr_id_change` int(10) unsigned DEFAULT NULL,
  `usr_timestamp_change` timestamp NULL DEFAULT NULL,
  `usr_valid` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`usr_id`),
  UNIQUE KEY `[[dbprefix]]_idx_usr_uuid` (`usr_uuid`),
  UNIQUE KEY `[[dbprefix]]_idx_usr_login_name` (`usr_login_name`),
  KEY `[[dbprefix]]_fk_usr_usr_create` (`usr_usr_id_create`),
  KEY `[[dbprefix]]_fk_usr_usr_change` (`usr_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_users`
--

INSERT INTO `[[dbprefix]]_users` VALUES
(1, 'a122ab3e-49ea-46c7-ac01-ada9de8bdd02', 'System', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, '[[regtime]]', NULL, NULL, 0),
(2, '2e9c5299-3297-4ce8-89d5-f516f2fc8382', '[[admin_username]]', '[[admin_pass]]', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, 1, '[[regtime]]', NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_data`
--

CREATE TABLE `[[dbprefix]]_user_data` (
  `usd_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usd_usr_id` int(10) unsigned NOT NULL,
  `usd_usf_id` int(10) unsigned NOT NULL,
  `usd_value` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`usd_id`),
  UNIQUE KEY `[[dbprefix]]_idx_usd_usr_usf_id` (`usd_usr_id`,`usd_usf_id`),
  KEY `[[dbprefix]]_fk_usd_usf` (`usd_usf_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]_user_data`
--

INSERT INTO `[[dbprefix]]_user_data` VALUES
(1, 2, 1, '[[admin_lname]]'),
(2, 2, 2, '[[admin_fname]]'),
(3, 2, 11, '[[admin_email]]'),
(4, 1, 1, 'System');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_fields`
--

CREATE TABLE `[[dbprefix]]_user_fields` (
  `usf_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usf_cat_id` int(10) unsigned NOT NULL,
  `usf_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `usf_type` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `usf_name_intern` varchar(110) COLLATE utf8_unicode_ci NOT NULL,
  `usf_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `usf_description` text COLLATE utf8_unicode_ci,
  `usf_description_inline` tinyint(1) NOT NULL DEFAULT '0',
  `usf_value_list` text COLLATE utf8_unicode_ci,
  `usf_default_value` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_regex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_icon` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_url` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_system` tinyint(1) NOT NULL DEFAULT '0',
  `usf_disabled` tinyint(1) NOT NULL DEFAULT '0',
  `usf_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `usf_registration` tinyint(1) NOT NULL DEFAULT '0',
  `usf_required_input` smallint(6) NOT NULL DEFAULT '0',
  `usf_sequence` smallint(6) NOT NULL,
  `usf_usr_id_create` int(10) unsigned DEFAULT NULL,
  `usf_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usf_usr_id_change` int(10) unsigned DEFAULT NULL,
  `usf_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`usf_id`),
  UNIQUE KEY `[[dbprefix]]_idx_usf_name_intern` (`usf_name_intern`),
  UNIQUE KEY `[[dbprefix]]_idx_usf_uuid` (`usf_uuid`),
  KEY `[[dbprefix]]_fk_usf_cat` (`usf_cat_id`),
  KEY `[[dbprefix]]_fk_usf_usr_create` (`usf_usr_id_create`),
  KEY `[[dbprefix]]_fk_usf_usr_change` (`usf_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]_user_fields`
--

INSERT INTO `[[dbprefix]]_user_fields` VALUES
(1, 1, '947eac6d-de14-41b4-a101-b81945335a2f', 'TEXT', 'LAST_NAME', 'SYS_LASTNAME', NULL, 0, NULL, NULL, NULL, NULL, NULL, 1, 1, 0, 1, 1, 1, 1, '[[regtime]]', NULL, NULL),
(2, 1, '927b1f7b-f61a-4b56-bcbe-e57f7ed262a8', 'TEXT', 'FIRST_NAME', 'SYS_FIRSTNAME', NULL, 0, NULL, NULL, NULL, NULL, NULL, 1, 1, 0, 1, 1, 2, 1, '[[regtime]]', NULL, NULL),
(3, 1, '39f1d13d-a705-4f29-a8d0-e7d2d3eb462c', 'TEXT', 'STREET', 'SYS_STREET', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(4, 1, '7b139cee-4ecc-45db-8012-bb3b611eabca', 'TEXT', 'POSTCODE', 'SYS_POSTCODE', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 4, 1, '[[regtime]]', NULL, NULL),
(5, 1, 'e357a83c-54c6-40c0-94ae-56df3da84c44', 'TEXT', 'CITY', 'SYS_CITY', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 5, 1, '[[regtime]]', NULL, NULL),
(6, 1, '3987a716-279d-42bc-897f-b03ee6a27af2', 'TEXT', 'COUNTRY', 'SYS_COUNTRY', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 6, 1, '[[regtime]]', NULL, NULL),
(7, 1, '66cf47ae-f8db-4fa8-9c71-0676303e9350', 'PHONE', 'PHONE', 'SYS_PHONE', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 7, 1, '[[regtime]]', NULL, NULL),
(8, 1, '2f5a4a05-010d-476b-bbd4-0efc34f627f5', 'PHONE', 'MOBILE', 'SYS_MOBILE', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 8, 1, '[[regtime]]', NULL, NULL),
(9, 1, '98d839f2-93cc-4515-a780-a75ef2266cf9', 'DATE', 'BIRTHDAY', 'SYS_BIRTHDAY', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 10, 1, '[[regtime]]', NULL, NULL),
(10, 1, '3785eee9-cd5c-4732-89b0-5cfb46ff3bc4', 'RADIO_BUTTON', 'GENDER', 'SYS_GENDER', NULL, 0, 'fa-mars|SYS_MALE\nfa-venus|SYS_FEMALE\nfa-mars-stroke-v|SYS_DIVERSE', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 11, 1, '[[regtime]]', NULL, NULL),
(11, 1, '90eb1d0c-c97c-487c-a1e3-9ce968a95158', 'EMAIL', 'EMAIL', 'SYS_EMAIL', NULL, 0, NULL, NULL, NULL, NULL, NULL, 1, 0, 0, 1, 2, 12, 1, '[[regtime]]', NULL, NULL),
(12, 1, '606995e6-b6a9-4c30-8917-200e345b0d50', 'URL', 'WEBSITE', 'SYS_WEBSITE', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 13, 1, '[[regtime]]', NULL, NULL),
(13, 3, 'ac511d31-6038-4fd2-a1da-7c6e8210e848', 'CHECKBOX', 'DATA_PROTECTION_PERMISSION', 'SYS_DATA_PROTECTION_PERMISSION', 'I have read the information provided by the organization. As far as the personal data provided by me are not necessary data for the fulfillment of the contract, I declare my consent to the processing of these data. My data will be stored exclusively for the purposes of the organization and treated confidentially.', 1, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 2, 14, 1, '[[regtime]]', NULL, NULL),
(14, 2, 'c1571ac5-0028-4f4c-958b-e1ed6e94e82d', 'TEXT', 'FACEBOOK', 'SYS_FACEBOOK', 'Would you like to set a link to your #VAR1# profile? Your #VAR1# login name is required. Log in to your #VAR1# account and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your #VAR1# profile directly.', 0, NULL, NULL, NULL, 'fab fa-facebook', 'https://www.facebook.com/#user_content#', 0, 0, 0, 0, 0, 1, 1, '[[regtime]]', NULL, NULL),
(15, 2, 'a4fd8a3e-8f28-484b-aa25-e8be7f0fd1a0', 'TEXT', 'INSTAGRAM', 'SYS_INSTAGRAM', 'Would you like to set a link to your #VAR1# profile? Your #VAR1# login name is required. Log in to your #VAR1# account and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your #VAR1# profile directly.', 0, NULL, NULL, NULL, 'fab fa-instagram', 'https://www.instagram.com/#user_content#', 0, 0, 0, 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(16, 2, '207277f0-120c-460b-b436-f6b6201c5882', 'TEXT', 'LINKEDIN', 'SYS_LINKEDIN', 'Would you like to set a link to your #VAR1# profile? Your #VAR1# login name is required. Log in to your #VAR1# account and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your #VAR1# profile directly.', 0, NULL, NULL, NULL, 'fab fa-linkedin', 'https://www.linkedin.com/in/#user_content#', 0, 0, 0, 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(17, 2, '91142982-05ec-4d01-bd73-86dade7b14a8', 'TEXT', 'MASTODON', 'SYS_MASTODON', 'Would you like to set a link to your #VAR1# profile? Your #VAR1# login name is required. Log in to your #VAR1# account and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your #VAR1# profile directly.', 0, NULL, NULL, NULL, 'fab fa-mastodon', 'https://mastodon.social/#user_content#', 0, 0, 0, 0, 0, 4, 1, '[[regtime]]', NULL, NULL),
(18, 2, 'f66bdcec-2ff0-46fb-9085-2fc8750f3ea4', 'TEXT', 'SKYPE', 'SYS_SKYPE', 'Here you can enter your username that you use in this social network. Other members will then be able to find you in this network.', 0, NULL, NULL, NULL, 'fab fa-skype', NULL, 0, 0, 0, 0, 0, 5, 1, '[[regtime]]', NULL, NULL),
(19, 2, 'dede9905-5ba8-40fb-938e-2b9d23dd242f', 'TEXT', 'XING', 'SYS_XING', 'Would you like to set a link to your #VAR1# profile? Your #VAR1# login name is required. Log in to your #VAR1# account and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your #VAR1# profile directly.', 0, NULL, NULL, NULL, 'fab fa-xing', 'https://www.xing.com/profile/#user_content#', 0, 0, 0, 0, 0, 7, 1, '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_log`
--

CREATE TABLE `[[dbprefix]]_user_log` (
  `usl_id` int(11) NOT NULL AUTO_INCREMENT,
  `usl_usr_id` int(10) unsigned NOT NULL,
  `usl_usf_id` int(10) unsigned NOT NULL,
  `usl_value_old` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usl_value_new` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usl_usr_id_create` int(10) unsigned DEFAULT NULL,
  `usl_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usl_comment` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`usl_id`),
  KEY `[[dbprefix]]_fk_user_log_1` (`usl_usr_id`),
  KEY `[[dbprefix]]_fk_user_log_2` (`usl_usr_id_create`),
  KEY `[[dbprefix]]_fk_user_log_3` (`usl_usf_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_relations`
--

CREATE TABLE `[[dbprefix]]_user_relations` (
  `ure_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ure_urt_id` int(10) unsigned NOT NULL,
  `ure_usr_id1` int(10) unsigned NOT NULL,
  `ure_usr_id2` int(10) unsigned NOT NULL,
  `ure_usr_id_create` int(10) unsigned DEFAULT NULL,
  `ure_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ure_usr_id_change` int(10) unsigned DEFAULT NULL,
  `ure_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ure_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ure_urt_usr` (`ure_urt_id`,`ure_usr_id1`,`ure_usr_id2`),
  KEY `[[dbprefix]]_fk_ure_usr1` (`ure_usr_id1`),
  KEY `[[dbprefix]]_fk_ure_usr2` (`ure_usr_id2`),
  KEY `[[dbprefix]]_fk_ure_usr_change` (`ure_usr_id_change`),
  KEY `[[dbprefix]]_fk_ure_usr_create` (`ure_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_relation_types`
--

CREATE TABLE `[[dbprefix]]_user_relation_types` (
  `urt_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `urt_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `urt_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `urt_name_male` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `urt_name_female` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `urt_edit_user` tinyint(1) NOT NULL DEFAULT '0',
  `urt_id_inverse` int(10) unsigned DEFAULT NULL,
  `urt_usr_id_create` int(10) unsigned DEFAULT NULL,
  `urt_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `urt_usr_id_change` int(10) unsigned DEFAULT NULL,
  `urt_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`urt_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ure_urt_name` (`urt_name`),
  UNIQUE KEY `[[dbprefix]]_idx_urt_uuid` (`urt_uuid`),
  KEY `[[dbprefix]]_fk_urt_id_inverse` (`urt_id_inverse`),
  KEY `[[dbprefix]]_fk_urt_usr_change` (`urt_usr_id_change`),
  KEY `[[dbprefix]]_fk_urt_usr_create` (`urt_usr_id_create`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]_user_relation_types`
--

INSERT INTO `[[dbprefix]]_user_relation_types` VALUES
(1, '7990d58e-0376-43bb-9d6b-7413a8ec204e', 'Parent', 'Father', 'Mother', 0, 2, 1, '[[regtime]]', NULL, NULL),
(2, '06475db9-9b87-43b6-8f9a-8659483172a4', 'Child', 'Son', 'Daughter', 0, 1, 1, '[[regtime]]', NULL, NULL),
(3, 'c34363c7-e06e-44d1-9a28-93ec16476f7b', 'Sibling', 'Brother', 'Sister', 0, 3, 1, '[[regtime]]', NULL, NULL),
(4, 'e48491a5-b52a-4372-9d4d-6a57c3c6bbd1', 'Spouse', 'Husband', 'Wife', 0, 4, 1, '[[regtime]]', NULL, NULL),
(5, 'fa2673e1-6f89-4f00-bb09-544ed01565b8', 'Partner', 'Partner', 'Partner', 0, 5, 1, '[[regtime]]', NULL, NULL),
(6, 'be6aa462-0c54-435e-b817-4e15180cd17b', 'Companion', 'Boyfriend', 'Girlfriend', 0, 6, 1, '[[regtime]]', NULL, NULL),
(7, '5dbd7e9f-dfa0-4a05-913a-cb4eebc2aada', 'Superior', 'Male superior', 'Female superior', 0, 8, 1, '[[regtime]]', NULL, NULL),
(8, '9398ce8a-fdb4-4437-af3e-56c3010150c4', 'Subordinate', 'Male subordinate', 'Female subordinate', 0, 7, 1, '[[regtime]]', NULL, NULL);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]_announcements`
--
ALTER TABLE `[[dbprefix]]_announcements`
  ADD CONSTRAINT `[[dbprefix]]_fk_ann_cat` FOREIGN KEY (`ann_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_ann_usr_create` FOREIGN KEY (`ann_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_ann_usr_change` FOREIGN KEY (`ann_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_auto_login`
--
ALTER TABLE `[[dbprefix]]_auto_login`
  ADD CONSTRAINT `[[dbprefix]]_fk_atl_usr` FOREIGN KEY (`atl_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_atl_org` FOREIGN KEY (`atl_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_categories`
--
ALTER TABLE `[[dbprefix]]_categories`
  ADD CONSTRAINT `[[dbprefix]]_fk_cat_org` FOREIGN KEY (`cat_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_cat_usr_create` FOREIGN KEY (`cat_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_cat_usr_change` FOREIGN KEY (`cat_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_category_report`
--
ALTER TABLE `[[dbprefix]]_category_report`
  ADD CONSTRAINT `[[dbprefix]]_fk_crt_org` FOREIGN KEY (`crt_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_events`
--
ALTER TABLE `[[dbprefix]]_events`
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_cat` FOREIGN KEY (`dat_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_rol` FOREIGN KEY (`dat_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_room` FOREIGN KEY (`dat_room_id`) REFERENCES `[[dbprefix]]_rooms` (`room_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_usr_create` FOREIGN KEY (`dat_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_usr_change` FOREIGN KEY (`dat_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_files`
--
ALTER TABLE `[[dbprefix]]_files`
  ADD CONSTRAINT `[[dbprefix]]_fk_fil_fol` FOREIGN KEY (`fil_fol_id`) REFERENCES `[[dbprefix]]_folders` (`fol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fil_usr` FOREIGN KEY (`fil_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_folders`
--
ALTER TABLE `[[dbprefix]]_folders`
  ADD CONSTRAINT `[[dbprefix]]_fk_fol_org` FOREIGN KEY (`fol_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fol_fol_parent` FOREIGN KEY (`fol_fol_id_parent`) REFERENCES `[[dbprefix]]_folders` (`fol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fol_usr` FOREIGN KEY (`fol_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_guestbook`
--
ALTER TABLE `[[dbprefix]]_guestbook`
  ADD CONSTRAINT `[[dbprefix]]_fk_gbo_org` FOREIGN KEY (`gbo_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_gbo_usr_create` FOREIGN KEY (`gbo_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_gbo_usr_change` FOREIGN KEY (`gbo_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_guestbook_comments`
--
ALTER TABLE `[[dbprefix]]_guestbook_comments`
  ADD CONSTRAINT `[[dbprefix]]_fk_gbc_gbo` FOREIGN KEY (`gbc_gbo_id`) REFERENCES `[[dbprefix]]_guestbook` (`gbo_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_gbc_usr_create` FOREIGN KEY (`gbc_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_gbc_usr_change` FOREIGN KEY (`gbc_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_ids`
--
ALTER TABLE `[[dbprefix]]_ids`
  ADD CONSTRAINT `[[dbprefix]]_fk_ids_usr_id` FOREIGN KEY (`ids_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_links`
--
ALTER TABLE `[[dbprefix]]_links`
  ADD CONSTRAINT `[[dbprefix]]_fk_lnk_cat` FOREIGN KEY (`lnk_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_lnk_usr_create` FOREIGN KEY (`lnk_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_lnk_usr_change` FOREIGN KEY (`lnk_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_lists`
--
ALTER TABLE `[[dbprefix]]_lists`
  ADD CONSTRAINT `[[dbprefix]]_fk_lst_usr` FOREIGN KEY (`lst_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_lst_org` FOREIGN KEY (`lst_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_list_columns`
--
ALTER TABLE `[[dbprefix]]_list_columns`
  ADD CONSTRAINT `[[dbprefix]]_fk_lsc_lst` FOREIGN KEY (`lsc_lst_id`) REFERENCES `[[dbprefix]]_lists` (`lst_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_lsc_usf` FOREIGN KEY (`lsc_usf_id`) REFERENCES `[[dbprefix]]_user_fields` (`usf_id`);

--
-- Constraints for table `[[dbprefix]]_members`
--
ALTER TABLE `[[dbprefix]]_members`
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_rol` FOREIGN KEY (`mem_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_usr` FOREIGN KEY (`mem_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_usr_create` FOREIGN KEY (`mem_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_usr_change` FOREIGN KEY (`mem_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_menu`
--
ALTER TABLE `[[dbprefix]]_menu`
  ADD CONSTRAINT `[[dbprefix]]_fk_men_men_parent` FOREIGN KEY (`men_men_id_parent`) REFERENCES `[[dbprefix]]_menu` (`men_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_men_com_id` FOREIGN KEY (`men_com_id`) REFERENCES `[[dbprefix]]_components` (`com_id`);

--
-- Constraints for table `[[dbprefix]]_messages`
--
ALTER TABLE `[[dbprefix]]_messages`
  ADD CONSTRAINT `[[dbprefix]]_fk_msg_usr_sender` FOREIGN KEY (`msg_usr_id_sender`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_messages_attachments`
--
ALTER TABLE `[[dbprefix]]_messages_attachments`
  ADD CONSTRAINT `[[dbprefix]]_fk_msa_msg_id` FOREIGN KEY (`msa_msg_id`) REFERENCES `[[dbprefix]]_messages` (`msg_id`);

--
-- Constraints for table `[[dbprefix]]_messages_content`
--
ALTER TABLE `[[dbprefix]]_messages_content`
  ADD CONSTRAINT `[[dbprefix]]_fk_msc_msg_id` FOREIGN KEY (`msc_msg_id`) REFERENCES `[[dbprefix]]_messages` (`msg_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_msc_usr_id` FOREIGN KEY (`msc_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_messages_recipients`
--
ALTER TABLE `[[dbprefix]]_messages_recipients`
  ADD CONSTRAINT `[[dbprefix]]_fk_msr_msg_id` FOREIGN KEY (`msr_msg_id`) REFERENCES `[[dbprefix]]_messages` (`msg_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_msr_rol_id` FOREIGN KEY (`msr_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_msr_usr_id` FOREIGN KEY (`msr_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_organizations`
--
ALTER TABLE `[[dbprefix]]_organizations`
  ADD CONSTRAINT `[[dbprefix]]_fk_org_org_parent` FOREIGN KEY (`org_org_id_parent`) REFERENCES `[[dbprefix]]_organizations` (`org_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_photos`
--
ALTER TABLE `[[dbprefix]]_photos`
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_pho_parent` FOREIGN KEY (`pho_pho_id_parent`) REFERENCES `[[dbprefix]]_photos` (`pho_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_org` FOREIGN KEY (`pho_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_usr_create` FOREIGN KEY (`pho_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_usr_change` FOREIGN KEY (`pho_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_preferences`
--
ALTER TABLE `[[dbprefix]]_preferences`
  ADD CONSTRAINT `[[dbprefix]]_fk_prf_org` FOREIGN KEY (`prf_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_registrations`
--
ALTER TABLE `[[dbprefix]]_registrations`
  ADD CONSTRAINT `[[dbprefix]]_fk_reg_org` FOREIGN KEY (`reg_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_reg_usr` FOREIGN KEY (`reg_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_roles`
--
ALTER TABLE `[[dbprefix]]_roles`
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_cat` FOREIGN KEY (`rol_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_lst_id` FOREIGN KEY (`rol_lst_id`) REFERENCES `[[dbprefix]]_lists` (`lst_id`) ON DELETE SET NULL ON UPDATE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_usr_create` FOREIGN KEY (`rol_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_usr_change` FOREIGN KEY (`rol_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_roles_rights`
--
ALTER TABLE `[[dbprefix]]_roles_rights`
  ADD CONSTRAINT `[[dbprefix]]_fk_ror_ror_parent` FOREIGN KEY (`ror_ror_id_parent`) REFERENCES `[[dbprefix]]_roles_rights` (`ror_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_roles_rights_data`
--
ALTER TABLE `[[dbprefix]]_roles_rights_data`
  ADD CONSTRAINT `[[dbprefix]]_fk_rrd_ror` FOREIGN KEY (`rrd_ror_id`) REFERENCES `[[dbprefix]]_roles_rights` (`ror_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rrd_rol` FOREIGN KEY (`rrd_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rrd_usr_create` FOREIGN KEY (`rrd_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_role_dependencies`
--
ALTER TABLE `[[dbprefix]]_role_dependencies`
  ADD CONSTRAINT `[[dbprefix]]_fk_rld_rol_child` FOREIGN KEY (`rld_rol_id_child`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rld_rol_parent` FOREIGN KEY (`rld_rol_id_parent`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rld_usr` FOREIGN KEY (`rld_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_rooms`
--
ALTER TABLE `[[dbprefix]]_rooms`
  ADD CONSTRAINT `[[dbprefix]]_fk_room_usr_create` FOREIGN KEY (`room_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_room_usr_change` FOREIGN KEY (`room_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_sessions`
--
ALTER TABLE `[[dbprefix]]_sessions`
  ADD CONSTRAINT `[[dbprefix]]_fk_ses_org` FOREIGN KEY (`ses_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_ses_usr` FOREIGN KEY (`ses_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_texts`
--
ALTER TABLE `[[dbprefix]]_texts`
  ADD CONSTRAINT `[[dbprefix]]_fk_txt_org` FOREIGN KEY (`txt_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_users`
--
ALTER TABLE `[[dbprefix]]_users`
  ADD CONSTRAINT `[[dbprefix]]_fk_usr_usr_create` FOREIGN KEY (`usr_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_usr_usr_change` FOREIGN KEY (`usr_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_user_data`
--
ALTER TABLE `[[dbprefix]]_user_data`
  ADD CONSTRAINT `[[dbprefix]]_fk_usd_usf` FOREIGN KEY (`usd_usf_id`) REFERENCES `[[dbprefix]]_user_fields` (`usf_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_usd_usr` FOREIGN KEY (`usd_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_user_fields`
--
ALTER TABLE `[[dbprefix]]_user_fields`
  ADD CONSTRAINT `[[dbprefix]]_fk_usf_cat` FOREIGN KEY (`usf_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_usf_usr_create` FOREIGN KEY (`usf_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_usf_usr_change` FOREIGN KEY (`usf_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_user_log`
--
ALTER TABLE `[[dbprefix]]_user_log`
  ADD CONSTRAINT `[[dbprefix]]_fk_user_log_1` FOREIGN KEY (`usl_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_user_log_2` FOREIGN KEY (`usl_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_user_log_3` FOREIGN KEY (`usl_usf_id`) REFERENCES `[[dbprefix]]_user_fields` (`usf_id`);

--
-- Constraints for table `[[dbprefix]]_user_relations`
--
ALTER TABLE `[[dbprefix]]_user_relations`
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_urt` FOREIGN KEY (`ure_urt_id`) REFERENCES `[[dbprefix]]_user_relation_types` (`urt_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr1` FOREIGN KEY (`ure_usr_id1`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr2` FOREIGN KEY (`ure_usr_id2`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr_change` FOREIGN KEY (`ure_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr_create` FOREIGN KEY (`ure_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_user_relation_types`
--
ALTER TABLE `[[dbprefix]]_user_relation_types`
  ADD CONSTRAINT `[[dbprefix]]_fk_urt_id_inverse` FOREIGN KEY (`urt_id_inverse`) REFERENCES `[[dbprefix]]_user_relation_types` (`urt_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_urt_usr_change` FOREIGN KEY (`urt_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_urt_usr_create` FOREIGN KEY (`urt_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
