
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `agora2562`
--

-- --------------------------------------------------------

--
-- Table structure for table `ap_agora`
--

CREATE TABLE `ap_agora` (
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `lang` varchar(255) DEFAULT NULL,
  `timezone` varchar(255) DEFAULT NULL,
  `wallpaper` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `logoUrl` varchar(255) DEFAULT NULL,
  `logoConnect` varchar(255) DEFAULT NULL,
  `dateUpdateDb` datetime NOT NULL,
  `version_agora` varchar(255) DEFAULT NULL,
  `skin` varchar(255) DEFAULT 'white',
  `footerHtml` text,
  `usersLike` tinyint(4) DEFAULT NULL,
  `usersComment` tinyint(4) DEFAULT '1',
  `mapTool` varchar(255) DEFAULT 'gmap',
  `gApiKey` varchar(255) DEFAULT NULL,
  `gIdentity` tinyint(4) DEFAULT '1',
  `gIdentityClientId` varchar(255) DEFAULT NULL,
  `messengerDisplay` tinyint(4) DEFAULT '1',
  `moduleLabelDisplay` tinyint(4) DEFAULT '1',
  `folderDisplayMode` varchar(255) DEFAULT 'block',
  `personsSort` varchar(255) DEFAULT 'firstName',
  `userMailDisplay` tinyint(4) DEFAULT NULL,
  `logsTimeOut` smallint(6) DEFAULT '120',
  `visioHost` varchar(255) DEFAULT NULL,
  `visioHostAlt` varchar(255) DEFAULT NULL,
  `sendmailFrom` varchar(255) DEFAULT NULL,
  `smtpHost` varchar(255) DEFAULT NULL,
  `smtpPort` smallint(6) DEFAULT NULL,
  `smtpSecure` varchar(255) DEFAULT NULL,
  `smtpUsername` varchar(255) DEFAULT NULL,
  `smtpPass` varchar(255) DEFAULT NULL,
  `ldap_server` varchar(255) DEFAULT NULL,
  `ldap_server_port` varchar(255) DEFAULT NULL,
  `ldap_admin_login` varchar(255) DEFAULT NULL,
  `ldap_admin_pass` varchar(255) DEFAULT NULL,
  `ldap_base_dn` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_agora`
--

INSERT INTO `ap_agora` VALUES
('[[site_name]]', NULL, 'english', '-5:00', NULL, NULL, NULL, NULL, '[[regtime]]', '25.6.2', 'white', NULL, NULL, 1, 'gmap', NULL, 1, NULL, 1, 1, 'block', 'firstName', NULL, 120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_calendar`
--

CREATE TABLE `ap_calendar` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `timeSlot` varchar(255) DEFAULT NULL,
  `propositionNotify` varchar(1) DEFAULT NULL,
  `propositionGuest` varchar(1) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `ap_calendar`
--

INSERT INTO `ap_calendar` VALUES
(1, 'ressource', '[[site_name]]', 'Shared calendar of the space', NULL, NULL, NULL, NULL, 1, NULL, NULL),
(2, 'user', NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_calendarCategory`
--

CREATE TABLE `ap_calendarCategory` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idSpaces` text,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `color` varchar(255) DEFAULT NULL,
  `rank` smallint(6) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `ap_calendarCategory`
--

INSERT INTO `ap_calendarCategory` VALUES
(1, NULL, 'Rendez-vous', NULL, '#880000', NULL, NULL, NULL, NULL, NULL),
(2, NULL, 'Reunion', NULL, '#000088', NULL, NULL, NULL, NULL, NULL),
(3, NULL, 'Vacances', NULL, '#dd7700', NULL, NULL, NULL, NULL, NULL),
(4, NULL, 'Personnel', NULL, '#007700', NULL, NULL, NULL, NULL, NULL),
(5, NULL, 'Evenement periodique', NULL, '#bf0073', NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_calendarEvent`
--

CREATE TABLE `ap_calendarEvent` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4,
  `dateBegin` datetime DEFAULT NULL,
  `dateEnd` datetime DEFAULT NULL,
  `_idCat` int(11) DEFAULT NULL,
  `important` tinyint(4) DEFAULT NULL,
  `contentVisible` varchar(255) DEFAULT NULL,
  `visioUrl` varchar(255) DEFAULT NULL,
  `periodType` varchar(255) DEFAULT NULL,
  `periodValues` varchar(1000) DEFAULT NULL,
  `periodDateEnd` date DEFAULT NULL,
  `periodDateExceptions` text,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `guest` varchar(255) DEFAULT NULL,
  `guestMail` varchar(255) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_calendarEvent`
--

INSERT INTO `ap_calendarEvent` VALUES
(1, 'Welcome on Omnispace !', NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'public', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', 1, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_calendarEventAffectation`
--

CREATE TABLE `ap_calendarEventAffectation` (
  `_idEvt` int(11) NOT NULL,
  `_idCal` int(11) NOT NULL,
  `confirmed` tinyint(4) DEFAULT NULL,
  KEY `indexes` (`_idCal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_calendarEventAffectation`
--

INSERT INTO `ap_calendarEventAffectation` VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `ap_contact`
--

CREATE TABLE `ap_contact` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `civility` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `companyOrganization` text,
  `function` text,
  `adress` text,
  `postalCode` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `telmobile` varchar(255) DEFAULT NULL,
  `mail` text,
  `comment` text,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_contactFolder`
--

CREATE TABLE `ap_contactFolder` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_contactFolder`
--

INSERT INTO `ap_contactFolder` VALUES
(1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_dashboardNews`
--

CREATE TABLE `ap_dashboardNews` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text CHARACTER SET utf8mb4,
  `une` tinyint(4) DEFAULT NULL,
  `offline` tinyint(4) DEFAULT NULL,
  `dateOnline` datetime DEFAULT NULL,
  `dateOffline` datetime DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_dashboardNews`
--

INSERT INTO `ap_dashboardNews` VALUES
(1, '<h3>Welcome to your new collaborative workspace !</h3>\n											<h4 onclick="redir(''?ctrl=file'')"><img src=''app/img/file/iconSmall.png''> Share your files with your team in the file manager</h4>\n											<h4 onclick="redir(''?ctrl=calendar'')"><img src=''app/img/calendar/iconSmall.png''> Create events on your shared calendar or personal calendar</h4>\n											<h4 onclick="redir(''?ctrl=dashboard'')"><img src=''app/img/dashboard/iconSmall.png''> Use the news feed to broadcast information about your activity</h4>\n											<h4 onclick="redir(''?ctrl=forum'')"><img src=''app/img/messenger.png''> Communicate via the forum, messaging or videoconferences</h4>\n											<h4 onclick="redir(''?ctrl=task'')"><img src=''app/img/task/iconSmall.png''> Manage your tasks and projects to organize your activity</h4>\n											<h4 onclick="redir(''?ctrl=mail'')"><img src=''app/img/mail/iconSmall.png''> Send newsletters to distribute information emails about your activity.</h4>\n											<h4 onclick="lightboxOpen(''docs/DOCUMENTATION_FR.pdf?displayFile=true'')"><img src=''app/img/documentation.png''> Consult the user guide to discover your workspace</h4>\n											<h4 onclick="lightboxOpen(''?ctrl=user&action=SendInvitation'')"><img src=''app/img/mail.png''>Send email invitations to join the space</h4>', NULL, NULL, NULL, NULL, '[[regtime]]', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_dashboardPoll`
--

CREATE TABLE `ap_dashboardPoll` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `description` text CHARACTER SET utf8mb4,
  `dateEnd` date DEFAULT NULL,
  `multipleResponses` tinyint(4) DEFAULT NULL,
  `newsDisplay` tinyint(4) DEFAULT NULL,
  `publicVote` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime NOT NULL,
  `_idUser` int(11) NOT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_dashboardPoll`
--

INSERT INTO `ap_dashboardPoll` VALUES
(1, 'What do you think of the news feed ?', NULL, NULL, NULL, 1, NULL, '[[regtime]]', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_dashboardPollResponse`
--

CREATE TABLE `ap_dashboardPollResponse` (
  `_id` varchar(255) NOT NULL,
  `_idPoll` int(11) NOT NULL,
  `label` varchar(500) NOT NULL,
  `rank` smallint(6) NOT NULL,
  `fileName` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_dashboardPollResponse`
--

INSERT INTO `ap_dashboardPollResponse` VALUES
('5bd1903d3df9u8t', 1, 'Very interesting !', 1, NULL),
('5bd1903d3e041p7', 1, 'Not interesting', 3, NULL),
('5bd1903d3e11dt5', 1, 'Interesting', 2, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_dashboardPollResponseVote`
--

CREATE TABLE `ap_dashboardPollResponseVote` (
  `_idUser` int(11) NOT NULL,
  `_idResponse` varchar(255) NOT NULL,
  `_idPoll` int(11) NOT NULL,
  PRIMARY KEY (`_idUser`,`_idResponse`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ap_file`
--

CREATE TABLE `ap_file` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `octetSize` int(11) DEFAULT NULL,
  `downloadsNb` int(11) NOT NULL DEFAULT '0',
  `downloadedBy` varchar(10000) DEFAULT NULL,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `ap_file`
--

INSERT INTO `ap_file` VALUES
(1, 1, 'Documentation.pdf', 'Documentation', 228075, 1, NULL, NULL, '[[regtime]]', 1, NULL, NULL),
(2, 1, 'Photo 1.jpg', NULL, 172057, 1, NULL, NULL, '[[regtime]]', 1, NULL, NULL),
(3, 1, 'Photo 2.jpg', NULL, 214053, 1, NULL, NULL, '[[regtime]]', 1, NULL, NULL),
(4, 1, 'Photo 3.jpg', NULL, 280614, 1, NULL, NULL, '[[regtime]]', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_fileFolder`
--

CREATE TABLE `ap_fileFolder` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_fileFolder`
--

INSERT INTO `ap_fileFolder` VALUES
(1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_fileVersion`
--

CREATE TABLE `ap_fileVersion` (
  `_idFile` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `realName` text NOT NULL,
  `octetSize` int(11) NOT NULL,
  `description` text,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  KEY `indexes` (`_idFile`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_fileVersion`
--

INSERT INTO `ap_fileVersion` VALUES
(1, 'Documentation.pdf', '1_1514764800.pdf', 228075, 'Documentation', '[[regtime]]', 1),
(2, 'Photo 1.jpg', '2_1514764800.jpg', 172057, NULL, '[[regtime]]', 1),
(3, 'Photo 2.jpg', '3_1514764800.jpg', 214053, NULL, '[[regtime]]', 1),
(4, 'Photo 3.jpg', '4_1514764800.jpg', 280614, NULL, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `ap_forumMessage`
--

CREATE TABLE `ap_forumMessage` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idMessageParent` int(11) DEFAULT NULL,
  `_idContainer` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idMessageParent`,`_idContainer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_forumSubject`
--

CREATE TABLE `ap_forumSubject` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4,
  `_idTheme` int(11) DEFAULT NULL,
  `dateLastMessage` datetime DEFAULT NULL,
  `usersConsultLastMessage` varchar(10000) DEFAULT NULL,
  `usersNotifyLastMessage` varchar(10000) DEFAULT NULL,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idTheme`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_forumSubject`
--

INSERT INTO `ap_forumSubject` VALUES
(1, 'Welcome to the Omnispace forum !', 'Feel free to share your questions or discuss the topics you want to share.', NULL, NULL, NULL, NULL, NULL, '[[regtime]]', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_forumTheme`
--

CREATE TABLE `ap_forumTheme` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idSpaces` text,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `color` varchar(255) DEFAULT NULL,
  `rank` smallint(6) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_invitation`
--

CREATE TABLE `ap_invitation` (
  `_idInvitation` varchar(255) DEFAULT NULL,
  `_idSpace` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `mail` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  KEY `indexes` (`_idInvitation`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ap_joinSpaceModule`
--

CREATE TABLE `ap_joinSpaceModule` (
  `_idSpace` int(11) DEFAULT NULL,
  `moduleName` varchar(255) DEFAULT NULL,
  `rank` tinyint(4) DEFAULT NULL,
  `options` text,
  KEY `indexes` (`_idSpace`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_joinSpaceModule`
--

INSERT INTO `ap_joinSpaceModule` VALUES
(1, 'dashboard', 1, NULL),
(1, 'file', 2, NULL),
(1, 'calendar', 3, NULL),
(1, 'task', 4, NULL),
(1, 'forum', 5, NULL),
(1, 'contact', 6, NULL),
(1, 'link', 7, NULL),
(1, 'mail', 8, NULL),
(1, 'user', 9, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_joinSpaceUser`
--

CREATE TABLE `ap_joinSpaceUser` (
  `_idSpace` int(11) DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `allUsers` tinyint(4) DEFAULT NULL,
  `accessRight` varchar(255) DEFAULT NULL,
  KEY `indexes` (`_idSpace`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_joinSpaceUser`
--

INSERT INTO `ap_joinSpaceUser` VALUES
(1, NULL, 1, '1');

-- --------------------------------------------------------

--
-- Table structure for table `ap_link`
--

CREATE TABLE `ap_link` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `adress` text NOT NULL,
  `description` text,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `ap_link`
--

INSERT INTO `ap_link` VALUES
(1, 1, 'https://www.omnispace.fr', NULL, NULL, '[[regtime]]', 1, NULL, NULL),
(2, 1, 'https://fr.wikipedia.org', NULL, NULL, '[[regtime]]', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_linkFolder`
--

CREATE TABLE `ap_linkFolder` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_linkFolder`
--

INSERT INTO `ap_linkFolder` VALUES
(1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_log`
--

CREATE TABLE `ap_log` (
  `action` varchar(50) DEFAULT NULL,
  `moduleName` varchar(50) DEFAULT NULL,
  `objectType` varchar(50) DEFAULT NULL,
  `_idObject` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `_idSpace` int(11) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `comment` text CHARACTER SET utf8mb4,
  KEY `indexes` (`action`,`_idObject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ap_mail`
--

CREATE TABLE `ap_mail` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `recipients` text NOT NULL,
  `title` text,
  `description` text CHARACTER SET utf8mb4 NOT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_objectAttachedFile`
--

CREATE TABLE `ap_objectAttachedFile` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `objectType` varchar(255) NOT NULL,
  `_idObject` int(11) NOT NULL,
  `downloadsNb` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_objectComment`
--

CREATE TABLE `ap_objectComment` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `objectType` varchar(255) NOT NULL,
  `_idObject` int(11) NOT NULL,
  `_idUser` int(11) NOT NULL,
  `dateCrea` datetime NOT NULL,
  `comment` varchar(1000) NOT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_objectLike`
--

CREATE TABLE `ap_objectLike` (
  `objectType` varchar(255) NOT NULL,
  `_idObject` int(11) NOT NULL,
  `_idUser` int(11) NOT NULL,
  KEY `indexes` (`objectType`,`_idObject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ap_objectTarget`
--

CREATE TABLE `ap_objectTarget` (
  `objectType` varchar(255) NOT NULL,
  `_idObject` int(11) NOT NULL,
  `_idSpace` int(11) NOT NULL,
  `target` varchar(255) NOT NULL,
  `accessRight` float NOT NULL,
  KEY `indexes` (`objectType`,`_idObject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_objectTarget`
--

INSERT INTO `ap_objectTarget` VALUES
('calendar', 1, 1, 'spaceUsers', 1.5),
('calendar', 2, 1, 'spaceUsers', 1),
('contactFolder', 1, 1, 'spaceUsers', 2),
('linkFolder', 1, 1, 'spaceUsers', 2),
('taskFolder', 1, 1, 'spaceUsers', 2),
('fileFolder', 1, 1, 'spaceUsers', 2),
('file', 1, 1, 'spaceUsers', 1),
('file', 2, 1, 'spaceUsers', 1),
('file', 3, 1, 'spaceUsers', 1),
('file', 4, 1, 'spaceUsers', 1),
('link', 1, 1, 'spaceUsers', 1),
('link', 2, 1, 'spaceUsers', 1),
('dashboardNews', 1, 1, 'spaceUsers', 1),
('forumSubject', 1, 1, 'spaceUsers', 1.5),
('dashboardPoll', 1, 1, 'spaceUsers', 1);

-- --------------------------------------------------------

--
-- Table structure for table `ap_space`
--

CREATE TABLE `ap_space` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `public` tinyint(4) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `userInscription` tinyint(4) DEFAULT NULL,
  `userInscriptionNotify` tinyint(4) DEFAULT NULL,
  `usersInvitation` tinyint(4) DEFAULT NULL,
  `wallpaper` varchar(255) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_space`
--

INSERT INTO `ap_space` VALUES
(1, '[[site_name]]', '[[site_desc]]', 0, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_task`
--

CREATE TABLE `ap_task` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `title` text NOT NULL,
  `description` text CHARACTER SET utf8mb4,
  `_idStatus` int(11) DEFAULT NULL,
  `priority` varchar(255) DEFAULT NULL,
  `advancement` tinyint(4) DEFAULT NULL,
  `responsiblePersons` text,
  `dateBegin` date DEFAULT NULL,
  `dateEnd` date DEFAULT NULL,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_taskFolder`
--

CREATE TABLE `ap_taskFolder` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idContainer` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  `shortcut` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`),
  KEY `indexes` (`_id`,`_idContainer`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_taskFolder`
--

INSERT INTO `ap_taskFolder` VALUES
(1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_taskStatus`
--

CREATE TABLE `ap_taskStatus` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idSpaces` text,
  `title` varchar(255) NOT NULL,
  `description` text,
  `color` varchar(255) DEFAULT NULL,
  `rank` smallint(6) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `ap_taskStatus`
--

INSERT INTO `ap_taskStatus` VALUES
(1, NULL, 'To do', NULL, '#888888', 1, NULL, 1, NULL, NULL),
(2, NULL, 'In progress', NULL, '#000088', 2, NULL, 1, NULL, NULL),
(3, NULL, 'To validate', NULL, '#cc8800', 3, NULL, 1, NULL, NULL),
(4, NULL, 'Finished', NULL, '#008800', 4, NULL, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_user`
--

CREATE TABLE `ap_user` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `civility` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `login` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `adress` text,
  `postalCode` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `telmobile` varchar(255) DEFAULT NULL,
  `mail` text,
  `function` text,
  `companyOrganization` text,
  `comment` text,
  `lastConnection` int(11) DEFAULT NULL,
  `previousConnection` int(11) DEFAULT NULL,
  `generalAdmin` tinyint(4) DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  `connectionSpace` varchar(255) DEFAULT NULL,
  `calendarDisabled` tinyint(4) DEFAULT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ap_user`
--

INSERT INTO `ap_user` VALUES
(1, NULL, '[[admin_realname]]', '[[admin_fname]]', '[[admin_email]]', '[[admin_pass]]', NULL, NULL, NULL, NULL, NULL, NULL, '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '[[regtime]]', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_userAuthToken`
--

CREATE TABLE `ap_userAuthToken` (
  `_idUser` int(11) NOT NULL,
  `userAuthToken` varchar(255) NOT NULL,
  `browserId` varchar(255) DEFAULT NULL,
  `dateCrea` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ap_userGroup`
--

CREATE TABLE `ap_userGroup` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `_idSpace` int(11) NOT NULL,
  `_idUsers` text NOT NULL,
  `dateCrea` datetime DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  `dateModif` datetime DEFAULT NULL,
  `_idUserModif` int(11) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_userInscription`
--

CREATE TABLE `ap_userInscription` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `_idSpace` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `mail` varchar(255) DEFAULT NULL,
  `login` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `message` text,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ap_userLivecouter`
--

CREATE TABLE `ap_userLivecouter` (
  `_idUser` int(11) NOT NULL DEFAULT '0',
  `ipAdress` varchar(255) NOT NULL,
  `editTypeId` varchar(255) DEFAULT NULL,
  `editorDraft` text CHARACTER SET utf8mb4,
  `draftTypeId` varchar(255) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`_idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ap_userMessenger`
--

CREATE TABLE `ap_userMessenger` (
  `_idUserMessenger` int(11) NOT NULL,
  `allUsers` tinyint(4) DEFAULT NULL,
  `_idUser` int(11) DEFAULT NULL,
  KEY `indexes` (`_idUserMessenger`,`_idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ap_userMessenger`
--

INSERT INTO `ap_userMessenger` VALUES
(1, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ap_userMessengerMessage`
--

CREATE TABLE `ap_userMessengerMessage` (
  `_idUser` int(11) NOT NULL,
  `_idUsers` text NOT NULL,
  `message` text CHARACTER SET utf8mb4 NOT NULL,
  `date` int(11) DEFAULT NULL,
  KEY `indexes` (`_idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ap_userPreference`
--

CREATE TABLE `ap_userPreference` (
  `_idUser` int(11) DEFAULT NULL,
  `keyVal` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  KEY `indexes` (`_idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
