# Vite Manifest

> A parser for [Vite](https://vitejs.dev/) manifest files.

[![License](https://img.shields.io/packagist/l/idleberg/vite-manifest?style=for-the-badge&color=blue)](https://github.com/idleberg/php-vite-manifest/blob/main/LICENSE)
[![Version](https://img.shields.io/packagist/v/idleberg/vite-manifest?style=for-the-badge)](https://github.com/idleberg/php-vite-manifest/releases)
![PHP Version](https://img.shields.io/packagist/dependency-v/idleberg/vite-manifest/php?style=for-the-badge)
[![Build](https://img.shields.io/github/actions/workflow/status/idleberg/php-vite-manifest/default.yml?style=for-the-badge)](https://github.com/idleberg/php-vite-manifest/actions)

**Table of contents**

- [Installation](#installation)
- [Usage](#usage)
- [Methods](#methods)
  - [`getManifest()`](#getmanifest)
  - [`getEntrypoint()`](#getentrypoint)
  - [`getEntrypoints()`](#getentrypoints)
  - [`getImports()`](#getimports)
  - [`getStyles()`](#getstyles)
- [License](#license)

## Installation

`composer require idleberg/vite-manifest`

## Usage

To get you going, first instantiate the class exposed by this library.

```php
new Manifest(string $manifestPath, string $baseUri, string $algorithm = "sha256");
```

### Parameters

#### `$manifestPath`

Type: `string`

Specifies the path to the manifest.

#### `$baseUri`

Type: `string`

Specifies the base URI for the assets in the manifest.

#### `$algorithm`

Type: `"sha256"` |`"sha384"` |`"sha512"` | `":manifest:"`  
Default: `"sha256"`  

Specifies the algorithm used for hashing the assets. This will be used for [subsource integrity](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity) when printing script or style tags.

> [!TIP]
> You can use `":manifest:"` in conjunction with [vite-plugin-manifest-sri](https://github.com/ElMassimo/vite-plugin-manifest-sri), a plug-in that calculates the hashes at build-time and adds them to the manifest.

**Example**

```php
use Idleberg\ViteManifest\Manifest;

$baseUrl = "https://idleberg.github.io";
$manifest = "path/to/manifest.json";

$vm = new Manifest($manifest, $baseUrl);
```

### Methods

#### `getManifest()`

Usage: `getManifest()`

Returns the contents of the manifest file as a PHP array.

#### `getEntrypoint()`

Usage: `getEntrypoint(string $entrypoint, bool $hash = true)`

Returns a specific entrypoint from the manifest.

**Example**

```php
$entrypoint = $vm->getEntrypoint("index.ts");

if ($entrypoint) {
    ["url" => $url, "hash" => $hash] = $entrypoint;
    echo "<script type='module' src='$url' crossorigin integrity='$hash'></script>" . PHP_EOL;
}
```
#### `getEntrypoints()`

Usage: `getEntrypoints()`

Returns all entrypoints from the manifest.

#### `getImports()`

Usage: `getImports(string $entrypoint, bool $hash = true)`

Returns imports for a file listed in the manifest.

**Example**

```php
foreach ($vm->getImports("index.ts", false) as $import) {
    ["url" => $url] = $import;
    echo "<link rel='modulepreload' href='$url' />" . PHP_EOL;
}
```

#### `getStyles()`

Usage: `getStyles(string $entrypoint, bool $hash = true)`

Returns stylesheets for a file listed in the manifest.

**Example**

```php
foreach ($vm->getStyles("index.ts") as $style) {
    ["url" => $url, "hash" => $hash] = $style;
    echo "<link rel='stylesheet' href='$url' crossorigin integrity='$hash' />" . PHP_EOL;
}
```

## License

This work is licensed under [The MIT License](LICENSE).
