<?php

/*
 * This file is part of PhpSpec, A php toolset to drive emergent
 * design by specification.
 *
 * (c) Marcello Duarte <marcello.duarte@gmail.com>
 * (c) Konstantin Kudryashov <ever.zet@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace PhpSpec\Locator;

interface ResourceManager
{
    /**
     * @param string $query
     *
     * @return \PhpSpec\Locator\Resource[]
     */
    public function locateResources(string $query): array;

    /**
     * @param string $classname
     *
     * @return \PhpSpec\Locator\Resource
     */
    public function createResource(string $classname): \PhpSpec\Locator\Resource;
}
