<?php

return [
    'users' => [
        'sessions' => [
            'email'                  => 'Adreça de correu electrònic',
            'forget-password-link'   => 'Has oblidat la contrasenya?',
            'password'               => 'Contrasenya',
            'powered-by-description' => 'Impulsat per :bagisto, un projecte de codi obert de :webkul.',
            'submit-btn'             => 'Iniciar sessió',
            'title'                  => 'Iniciar sessió',
        ],

        'forget-password' => [
            'create'    => [
                'email'                  => 'Correu electrònic registrat',
                'email-not-exist'        => 'El correu electrònic no existeix',
                'page-title'             => 'Oblidar contrasenya',
                'powered-by-description' => 'Impulsat per :bagisto, un projecte de codi obert de :webkul.',
                'reset-link-sent'        => 'Enllaç per restablir la contrasenya enviat',
                'sign-in-link'           => 'Tornar a iniciar sessió?',
                'submit-btn'             => 'Restablir',
                'title'                  => 'Recuperar contrasenya',
            ],
        ],

        'reset-password' => [
            'back-link-title'        => 'Tornar a iniciar sessió?',
            'confirm-password'       => 'Confirmar contrasenya',
            'email'                  => 'Correu electrònic registrat',
            'password'               => 'Contrasenya',
            'powered-by-description' => 'Impulsat per :bagisto, un projecte de codi obert de :webkul.',
            'submit-btn'             => 'Restablir contrasenya',
            'title'                  => 'Restablir contrasenya',
        ],
    ],

    'notifications' => [
        'description-text' => 'Llistar totes les notificacions',
        'marked-success'   => 'Totes les notificacions s’han marcat com a llegides',
        'no-record'        => 'No s’han trobat registres',
        'of'               => 'de',
        'per-page'         => 'Per pàgina',
        'read-all'         => 'Marcar com a llegit',
        'title'            => 'Notificacions',
        'view-all'         => 'Veure totes',

        'order-status-messages' => [
            'all'             => 'Tots',
            'canceled'        => 'Comanda cancel·lada',
            'closed'          => 'Comanda tancada',
            'completed'       => 'Comanda completada',
            'pending'         => 'Comanda pendent',
            'pending-payment' => 'Pagament pendent',
            'processing'      => 'Comanda en procés',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Tornar',
            'change-password'   => 'Canviar contrasenya',
            'confirm-password'  => 'Confirmar contrasenya',
            'current-password'  => 'Contrasenya actual',
            'email'             => 'Correu electrònic',
            'general'           => 'General',
            'invalid-password'  => 'La contrasenya actual que has introduït és incorrecta.',
            'name'              => 'Nom',
            'password'          => 'Contrasenya',
            'profile-image'     => 'Imatge de perfil',
            'save-btn'          => 'Desar compte',
            'title'             => 'El meu compte',
            'update-success'    => 'Compte actualitzat amb éxit',
            'upload-image-info' => 'Carregar una imatge de perfil (110px X 110px) en format PNG o JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Afegir client',
            'add-product'                 => 'Afegir producte',
            'all-channels'                => 'Tots els canals',
            'attribute-code'              => 'Codi d\'atribut',
            'average-sale'                => 'Promig de venda per comanda',
            'color'                       => 'Color',
            'customer-info'               => 'No s\'han trobat clients amb més vendes',
            'customer-with-most-sales'    => 'Client amb més vendes',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Llindar buit',
            'empty-threshold-description' => 'No hi ha productes disponibles',
            'end-date'                    => 'Data de fi',
            'from'                        => 'Des de',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ Més imatges',
            'order'                       => ':total_orders comandes',
            'order-count'                 => ':count comandes',
            'order-id'                    => '#:id',
            'overall-details'             => 'Detalls generals',
            'pay-by'                      => 'Pagament per - :method',
            'product-count'               => ':count productes',
            'product-image'               => 'Imatge del producte',
            'product-info'                => 'Afegir productes relacionats sobre la marxa.',
            'product-number'              => 'Producte - :product_number',
            'revenue'                     => 'Ingressos :total',
            'sale-count'                  => ':count vendes',
            'sales'                       => 'Vendes',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => 'Data d\'inici',
            'stock-threshold'             => 'Límit de stock',
            'store-stats'                 => 'Estadístiques de la botiga',
            'title'                       => 'Panell de control',
            'to'                          => 'Fins a',
            'today-customers'             => 'Clients d\'avui',
            'today-details'               => 'Detalls d\'avui',
            'today-orders'                => 'Comandes d\'avui',
            'today-sales'                 => 'Vendes d\'avui',
            'top-performing-categories'   => 'Categories més destacades',
            'top-selling-products'        => 'Productes més venuts',
            'total-customers'             => 'Total de clients',
            'total-orders'                => 'Total de comandes',
            'total-sales'                 => 'Total de vendes',
            'total-stock'                 => ':total_stock en stock',
            'total-unpaid-invoices'       => 'Total de factures impagades',
            'unique-visitors'             => ':count únic',
            'user-info'                   => 'Revisa ràpidament el que està passant a la teva botiga',
            'user-name'                   => 'Hola! :user_name',
            'visitors'                    => 'Visitant',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Crea Comanda',
                'title'      => 'Ordres',

                'search-customer' => [
                    'create-btn'  => 'Crear client',
                    'empty-info'  => 'No hi ha clients disponibles per al terme de cerca.',
                    'empty-title' => 'No s\'han trobat clients',
                    'search-by'   => 'Cercar per correu electrònic o nom',
                    'title'       => 'Seleccionar client',
                ],

                'datagrid' => [
                    'canceled'        => 'Cancel·lat',
                    'channel-name'    => 'Canal',
                    'closed'          => 'Tancat',
                    'completed'       => 'Completat',
                    'customer'        => 'Client',
                    'date'            => 'Data',
                    'email'           => 'Correu electrònic',
                    'fraud'           => 'Frau',
                    'grand-total'     => 'Total general',
                    'id'              => '#:id',
                    'items'           => 'Articles',
                    'location'        => 'Ubicació',
                    'order-id'        => 'ID de comanda',
                    'pay-by'          => 'Pagar per - :method',
                    'pay-via'         => 'Pagar per',
                    'pending-payment' => 'Pagament pendent',
                    'pending'         => 'Pendent',
                    'processing'      => 'Processant',
                    'product-count'   => ':count + Més productes',
                    'status'          => 'Estat',
                    'success'         => 'Èxit',
                    'view'            => 'Veure',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'Afegir a la cistella',
                'back-btn'                => 'Tornar',
                'check-billing-address'   => 'Falta l\'adreça de facturació.',
                'check-shipping-address'  => 'Falta l\'adreça d\'enviament.',
                'configuration'           => 'Configuració',
                'coupon-already-applied'  => 'El codi de descompte ja ha estat aplicat.',
                'coupon-applied'          => 'Codi de descompte aplicat correctament.',
                'coupon-error'            => 'No es pot aplicar el codi de descompte.',
                'coupon-not-found'        => 'Codi de descompte no trobat',
                'coupon-remove'           => 'Codi de descompte eliminat correctament.',
                'error'                   => 'Alguna cosa ha anat malament',
                'minimum-order-error'     => 'No es compleix l\'import mínim de la comanda.',
                'order-placed-success'    => 'Comanda realitzada correctament.',
                'payment-not-supported'   => 'Aquest mètode de pagament no és compatible',
                'save-btn'                => 'Crear comanda',
                'specify-payment-method'  => 'Falta el mètode de pagament.',
                'specify-shipping-method' => 'Falta el mètode d\'enviament.',
                'title'                   => 'Crear comanda per a :name',

                'types' => [
                    'simple' => [
                        'none'         => 'Cap',
                        'total-amount' => 'Suma total',
                    ],

                    'configurable' => [
                        'select-options' => 'Si us plau, selecciona una opció',
                    ],

                    'bundle' => [
                        'none'         => 'Cap',
                        'total-amount' => 'Suma total',
                    ],

                    'grouped' => [
                        'name' => 'Nom',
                    ],

                    'downloadable' => [
                        'title' => 'Enllaços',
                    ],

                    'virtual' => [
                        'none'         => 'Cap',
                        'total-amount' => 'Suma total',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Producte afegit a la cistella correctament',
                    'success-remove'      => 'Element eliminat de la cistella correctament',
                    'success-update'      => 'Element de la cistella actualitzat correctament',

                    'items' => [
                        'add-product'       => 'Afegir producte',
                        'amount-per-unit'   => ':amount per unitat x :qty quantitat',
                        'delete'            => 'Eliminar',
                        'empty-description' => 'No s\'han trobat elements a la teva cistella.',
                        'empty-title'       => 'Cistella buida',
                        'excl-tax'          => 'Excl. Impost',
                        'move-to-wishlist'  => 'Moure a la llista de desitjos',
                        'see-details'       => 'Veure detalls',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => 'Subtotal - :sub_total',
                        'title'             => 'Elements de la cistella',

                        'search' => [
                            'add-to-cart'   => 'Afegir a la cistella',
                            'available-qty' => ':qty disponible',
                            'empty-info'    => 'No hi ha productes disponibles per al terme de cerca.',
                            'empty-title'   => 'No s\'han trobat productes',
                            'product-image' => 'Imatge del producte',
                            'qty'           => 'Quantitat',
                            'sku'           => 'SKU - :sku',
                            'title'         => 'Cercar productes',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Afegir adreça',
                        'add-new'          => 'Afegir nova adreça',
                        'add-new-address'  => 'Afegir nova adreça',
                        'addresses'        => 'Adreces',
                        'back'             => 'Tornar',
                        'billing-address'  => 'Adreça de facturació',
                        'city'             => 'Ciutat',
                        'company-name'     => 'Nom de l\'empresa',
                        'confirm'          => 'Confirmar',
                        'country'          => 'País',
                        'edit-btn'         => 'Editar adreça',
                        'email'            => 'Correu electrònic',
                        'first-name'       => 'Nom',
                        'last-name'        => 'Cognom',
                        'postcode'         => 'Codi postal',
                        'proceed'          => 'Continuar',
                        'same-as-billing'  => '¿Utilitzar la mateixa adreça per a l\'enviament?',
                        'save'             => 'Desar',
                        'save-address'     => 'Desar a la llibreta d\'adreces',
                        'select-country'   => 'Seleccionar país',
                        'select-state'     => 'Seleccionar estat',
                        'shipping-address' => 'Adreça d\'enviament',
                        'state'            => 'Estat',
                        'street-address'   => 'Adreça',
                        'telephone'        => 'Telèfon',
                        'title'            => 'Adreça',
                        'vat-id'           => 'NIF',
                    ],

                    'payment' => [
                        'title' => 'Pagament',
                    ],

                    'shipping' => [
                        'title' => 'Enviament',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Aplicar cupó',
                        'discount-amount'          => 'Quantitat de descompte',
                        'enter-your-code'          => 'Introdueix el teu codi',
                        'grand-total'              => 'Total',
                        'place-order'              => 'Realitzar comanda',
                        'processing'               => 'Processant',
                        'shipping-amount-excl-tax' => 'Quantitat d\'enviament (Excl. impostos)',
                        'shipping-amount-incl-tax' => 'Quantitat d\'enviament (Incl. impostos)',
                        'shipping-amount'          => 'Quantitat d\'enviament',
                        'sub-total-excl-tax'       => 'Subtotal (Excl. impostos)',
                        'sub-total-incl-tax'       => 'Subtotal (Incl. impostos)',
                        'sub-total'                => 'Subtotal',
                        'tax'                      => 'Impostos',
                        'title'                    => 'Resum de la comanda',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'Afegir a la cistella',
                    'delete'            => 'Eliminar',
                    'empty-description' => 'No s\'han trobat elements a la teva cistella.',
                    'empty-title'       => 'Cistella buida',
                    'excl-tax'          => 'Excl. Impostos: ',
                    'see-details'       => 'Veure detalls',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elements de la cistella',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'Afegir a la cistella',
                    'empty-description' => 'No s\'han trobat elements als teus últims comandes.',
                    'empty-title'       => 'Comandes buides',
                    'see-details'       => 'Veure detalls',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elements de la comanda recent',
                    'view'              => 'Veure',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'Afegir a la cistella',
                    'delete'            => 'Eliminar',
                    'empty-description' => 'No s\'han trobat elements a la teva llista de desitjos.',
                    'empty-title'       => 'Llista de desitjos buida',
                    'see-details'       => 'Veure detalls',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elements de la llista de desitjos',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'Afegir a la cistella',
                    'delete'            => 'Eliminar',
                    'empty-description' => 'No s\'han trobat elements a la teva llista de comparació.',
                    'empty-title'       => 'Llista de comparació buida',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elements de comparació',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Per Unitat x :qty Quantitat',
                'billing-address'                => 'Adreça de Facturació',
                'cancel'                         => 'Cancel·lar',
                'cancel-msg'                     => 'Estàs segur que vols cancel·lar aquesta comanda?',
                'cancel-success'                 => 'Comanda cancel·lada amb éxit',
                'canceled'                       => 'Cancel·lada',
                'channel'                        => 'Canal',
                'closed'                         => 'Tancat',
                'comment-success'                => 'Comentari afegit amb éxit.',
                'comments'                       => 'Comentaris',
                'completed'                      => 'Completada',
                'contact'                        => 'Contacte',
                'create-success'                 => 'Comanda creada amb éxit',
                'currency'                       => 'Moneda',
                'customer'                       => 'Client',
                'customer-group'                 => 'Grup de Clients',
                'customer-not-notified'          => ':date | Client <b>No Notificat</b>',
                'customer-notified'              => ':date | Client <b>Notificat</b>',
                'discount'                       => 'Descompte - :discount',
                'download-pdf'                   => 'Descarregar PDF',
                'fraud'                          => 'Fraude',
                'grand-total'                    => 'Total General - :grand_total',
                'invoice-id'                     => 'Factura #:invoice',
                'invoices'                       => 'Factures',
                'item-canceled'                  => 'Cancel·lada (:qty_canceled)',
                'item-invoice'                   => 'Facturat (:qty_invoiced)',
                'item-ordered'                   => 'Comandat (:qty_ordered)',
                'item-refunded'                  => 'Reemborsat (:qty_refunded)',
                'item-shipped'                   => 'Enviat (:qty_shipped)',
                'name'                           => 'Nom',
                'no-invoice-found'               => 'No s\'ha trobat cap factura',
                'no-refund-found'                => 'No s\'ha trobat cap reemborsament',
                'no-shipment-found'              => 'No s\'han trobat enviaments',
                'notify-customer'                => 'Notificar al Client',
                'order-date'                     => 'Data de la Comanda',
                'order-information'              => 'Informació de la Comanda',
                'order-status'                   => 'Estat de la Comanda',
                'payment-and-shipping'           => 'Pagament i Enviament',
                'payment-method'                 => 'Mètode de Pagament',
                'pending'                        => 'Pendent',
                'pending_payment'                => 'Pagament Pendent',
                'per-unit'                       => 'Per Unitat',
                'price'                          => 'Preu - :price',
                'price-excl-tax'                 => 'Preu (Excl. Impostos) - :price',
                'price-incl-tax'                 => 'Preu (Incl. Impostos) - :price',
                'processing'                     => 'Processant',
                'quantity'                       => 'Quantitat',
                'refund'                         => 'Reemborsament',
                'refund-id'                      => 'Reemborsament #:refund',
                'refunded'                       => 'Reemborsat',
                'reorder'                        => 'Reordenar',
                'ship'                           => 'Enviar',
                'shipment'                       => 'Enviament #:shipment',
                'shipments'                      => 'Enviaments',
                'shipping-address'               => 'Adreça d\'Enviament',
                'shipping-and-handling'          => 'Enviament i Manipulació',
                'shipping-and-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                'shipping-and-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                'shipping-method'                => 'Mètode d\'Enviament',
                'shipping-price'                 => 'Preu d\'Enviament',
                'sku'                            => 'SKU - :sku',
                'status'                         => 'Estat',
                'sub-total'                      => 'Subtotal - :sub_total',
                'sub-total-excl-tax'             => 'Subtotal (Excl. Impostos) - :sub_total',
                'sub-total-incl-tax'             => 'Subtotal (Incl. Impostos) - :sub_total',
                'submit-comment'                 => 'Enviar Comentari',
                'summary-discount'               => 'Descompte',
                'summary-grand-total'            => 'Total General',
                'summary-sub-total'              => 'Subtotal',
                'summary-sub-total-excl-tax'     => 'Subtotal (Excl. Impostos)',
                'summary-sub-total-incl-tax'     => 'Subtotal (Incl. Impostos)',
                'summary-tax'                    => 'Impostos',
                'tax'                            => 'Impostos (:percent) - :tax',
                'title'                          => 'Comanda #:order_id',
                'total-due'                      => 'Total a Pagar',
                'total-paid'                     => 'Total Pagat',
                'total-refund'                   => 'Total Reemborsat',
                'view'                           => 'Veure',
                'write-your-comment'             => 'Escriu el teu comentari',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Enviaments',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Font d\'Inventari',
                    'order-date'       => 'Data de la Comanda',
                    'order-id'         => 'ID de la Comanda',
                    'shipment-date'    => 'Data d\'Enviament',
                    'shipment-to'      => 'Enviament a',
                    'total-qty'        => 'Quantitat Total',
                    'view'             => 'Veure',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount Per Unitat x :qty Quantitat',
                'cancel-error'     => 'La comanda no es pot cancel·lar',
                'carrier-name'     => 'Nom de la Companyia d\'Enviament',
                'create-btn'       => 'Crear Enviament',
                'creation-error'   => 'Error en crear l\'enviament',
                'item-canceled'    => 'Cancel·lat (:qty_canceled)',
                'item-invoice'     => 'Facturat (:qty_invoiced)',
                'item-ordered'     => 'Comanda (:qty_ordered)',
                'item-refunded'    => 'Reemborsat (:qty_refunded)',
                'item-shipped'     => 'Enviat (:qty_shipped)',
                'order-error'      => 'L\'enviament no és vàlid',
                'per-unit'         => 'Per Unitat',
                'qty-available'    => 'Quantitat Disponible',
                'qty-to-ship'      => 'Quantitat a Enviar',
                'quantity-invalid' => 'Quantitat no vàlida',
                'sku'              => 'SKU - :sku',
                'source'           => 'Font',
                'success'          => 'Enviament creat amb éxit',
                'title'            => 'Crear nou Enviament',
                'tracking-number'  => 'Número de Seguiment',
            ],

            'view' => [
                'billing-address'      => 'Adreça de Facturació',
                'carrier-title'        => 'Títol de la Companyia d\'Enviament',
                'channel'              => 'Canal',
                'currency'             => 'Moneda',
                'customer'             => 'Client',
                'email'                => 'Correu Electrònic - :email',
                'inventory-source'     => 'Font d\'Inventari',
                'order-date'           => 'Data de la Comanda',
                'order-id'             => 'ID de Comanda',
                'order-information'    => 'Informació de la Comanda',
                'order-status'         => 'Estat de la Comanda',
                'ordered-items'        => 'Articles Encarregats',
                'payment-and-shipping' => 'Pagament i Enviament',
                'payment-method'       => 'Mètode de Pagament',
                'product-image'        => 'Imatge del Producte',
                'qty'                  => 'Quantitat - :qty',
                'shipping-address'     => 'Adreça d\'Enviament',
                'shipping-method'      => 'Mètode d\'Enviament',
                'shipping-price'       => 'Preu d\'Enviament',
                'sku'                  => 'SKU - :sku',
                'title'                => 'Enviament #:shipment_id',
                'tracking-number'      => 'Número de Seguiment',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Reemborsaments',

                'datagrid' => [
                    'billed-to'       => 'Facturat a',
                    'id'              => 'ID',
                    'order-id'        => 'ID de Comanda',
                    'refund-date'     => 'Data de Reembossament',
                    'refunded-amount' => 'Import Reembossat',
                    'view'            => 'Veure',
                ],
            ],

            'view' => [
                'account-information'        => 'Informació del Compte',
                'adjustment-fee'             => 'Quota d\'Ajust',
                'adjustment-refund'          => 'Reembossament d\'Ajust',
                'base-discounted-amount'     => 'Import Descomptat - :base_discounted_amount',
                'billing-address'            => 'Adreça de Facturació',
                'currency'                   => 'Moneda',
                'sub-total-amount-excl-tax'  => 'Subtotal (Excl. Impostos) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Subtotal (Incl. Impostos) - :discounted_amount',
                'sub-total-amount'           => 'Subtotal - :discounted_amount',
                'grand-total'                => 'Total General',
                'order-channel'              => 'Canal de Comanda',
                'order-date'                 => 'Data de la Comanda',
                'order-id'                   => 'ID de Comanda',
                'order-information'          => 'Informació de la Comanda',
                'order-status'               => 'Estat de la Comanda',
                'payment-information'        => 'Informació de Pagament',
                'payment-method'             => 'Mètode de Pagament',
                'price-excl-tax'             => 'Preu (Excl. Impostos) - :price',
                'price-incl-tax'             => 'Preu (Incl. Impostos) - :price',
                'price'                      => 'Preu - :price',
                'product-image'              => 'Imatge del Producte',
                'product-ordered'            => 'Productes Encarregats',
                'qty'                        => 'Quantitat - :qty',
                'refund'                     => 'Reembossament',
                'shipping-address'           => 'Adreça d\'Enviament',
                'shipping-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                'shipping-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                'shipping-handling'          => 'Enviament i Manipulació',
                'shipping-method'            => 'Mètode d\'Enviament',
                'shipping-price'             => 'Preu d\'Enviament',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => 'Subtotal (Excl. Impostos)',
                'sub-total-incl-tax'         => 'Subtotal (Incl. Impostos)',
                'sub-total'                  => 'Subtotal',
                'tax'                        => 'Impostos',
                'tax-amount'                 => 'Import d\'Impostos - :tax_amount',
                'title'                      => 'Reembossament #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Quota d\'Ajust',
                'adjustment-refund'           => 'Reembossament d\'Ajust',
                'amount-per-unit'             => ':amount Per Unitat x :qty Quantitat',
                'create-success'              => 'Reembossament creat correctament',
                'creation-error'              => 'No està permès crear reembossaments.',
                'discount-amount'             => 'Import de Descompte',
                'grand-total'                 => 'Total General',
                'invalid-qty'                 => 'S\'ha trobat una quantitat no vàlida per facturar ítems.',
                'invalid-refund-amount-error' => 'La quantitat de reembossament ha de ser diferent de zero.',
                'item-canceled'               => 'Cancel·lat (:qty_canceled)',
                'item-invoice'                => 'Facturat (:qty_invoiced)',
                'item-ordered'                => 'Encarregat (:qty_ordered)',
                'item-refunded'               => 'Reembossat (:qty_refunded)',
                'item-shipped'                => 'Enviat (:qty_shipped)',
                'per-unit'                    => 'Per Unitat',
                'price'                       => 'Preu',
                'qty-to-refund'               => 'Quantitat a Reembossar',
                'refund-btn'                  => 'Reembossar',
                'refund-limit-error'          => 'No es pot processar un import de reembossament de :amount.',
                'refund-shipping'             => 'Reembossament d\'Enviament',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => 'Subtotal',
                'tax-amount'                  => 'Import d\'Impostos',
                'title'                       => 'Crear Reembossament',
                'update-totals-btn'           => 'Actualitzar Totals',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Factures',

                'datagrid' => [
                    'action'              => 'Accions',
                    'days-left'           => 'Queden :count dia(es)',
                    'days-overdue'        => ':count dia(es) de retard',
                    'grand-total'         => 'Total General',
                    'id'                  => 'ID',
                    'invoice-date'        => 'Data de la Factura',
                    'mass-update-success' => 'Factura seleccionada actualitzada correctament.',
                    'order-id'            => 'ID de la Comanda',
                    'overdue'             => 'Endarrerit',
                    'overdue-by'          => 'Endarrerit per :count dia(es)',
                    'paid'                => 'Pagat',
                    'pending'             => 'Pendent',
                    'status'              => 'Estat',
                    'update-status'       => 'Actualitzar Estat',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Per Unitat x :qty Quantitat',
                'channel'                        => 'Canal',
                'customer-email'                 => 'Correu electrònic - :email',
                'customer'                       => 'Client',
                'discount'                       => 'Import de descompte - :discount',
                'email'                          => 'Correu electrònic',
                'grand-total'                    => 'Total General',
                'invoice-items'                  => 'Ítems de la Factura',
                'invoice-sent'                   => 'Factura enviada correctament',
                'invoice-status'                 => 'Estat de la Factura',
                'order-date'                     => 'Data de la Comanda',
                'order-id'                       => 'ID de la Comanda',
                'order-information'              => 'Informació de la Comanda',
                'order-status'                   => 'Estat de la Comanda',
                'price-excl-tax'                 => 'Preu (Excl. Impostos) - :price',
                'price-incl-tax'                 => 'Preu (Incl. Impostos) - :price',
                'price'                          => 'Preu - :price',
                'print'                          => 'Imprimir',
                'product-image'                  => 'Imatge del Producte',
                'qty'                            => 'Quantitat - :qty',
                'send-btn'                       => 'Enviar',
                'send-duplicate-invoice'         => 'Enviar Factura Duplicada',
                'send'                           => 'Enviar',
                'shipping-and-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                'shipping-and-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                'shipping-and-handling'          => 'Enviament i Manipulació',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => 'Subtotal (Excl. Impostos) - :sub_total',
                'sub-total-incl-tax'             => 'Subtotal (Incl. Impostos) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Subtotal (Excl. Impostos)',
                'sub-total-summary-incl-tax'     => 'Subtotal (Incl. Impostos)',
                'sub-total-summary'              => 'Subtotal',
                'sub-total'                      => 'Subtotal - :sub_total',
                'summary-discount'               => 'Import de descompte',
                'summary-tax'                    => 'Import d\'Impostos',
                'tax'                            => 'Import d\'Impostos - :tax',
                'title'                          => 'Factura #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount Per Unitat x :qty Quantitat',
                'create-invoice'     => 'Crear Factura',
                'create-success'     => 'Factura creada correctament',
                'create-transaction' => 'Crear Transacció',
                'creation-error'     => 'No es permet la creació de la factura de la comanda.',
                'invalid-qty'        => 'S\'ha trobat una quantitat invàlida per facturar els articles.',
                'invoice'            => 'Factura',
                'new-invoice'        => 'Nova Factura',
                'product-error'      => 'No es pot crear una factura sense productes.',
                'product-image'      => 'Imatge del Producte',
                'qty-to-invoiced'    => 'Quantitat a facturar',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Detalls Bancaris',
                'bill-to'                    => 'Facturar a',
                'contact-number'             => 'Número de Contacte',
                'contact'                    => 'Contacte',
                'date'                       => 'Data de la Factura',
                'discount'                   => 'Descompte',
                'excl-tax'                   => 'Excl. Impostos:',
                'grand-total'                => 'Total General',
                'invoice-id'                 => 'ID de Factura',
                'invoice'                    => 'Factura',
                'order-date'                 => 'Data de la Comanda',
                'order-id'                   => 'ID de Comanda',
                'payment-method'             => 'Mètode de Pagament',
                'payment-terms'              => 'Condicions de Pagament',
                'price'                      => 'Preu',
                'product-name'               => 'Nom del Producte',
                'qty'                        => 'Quantitat',
                'ship-to'                    => 'Enviar a',
                'shipping-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                'shipping-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                'shipping-handling'          => 'Enviament i Manipulació',
                'shipping-method'            => 'Mètode d\'Enviament',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => 'Subtotal (Excl. Impostos)',
                'subtotal-incl-tax'          => 'Subtotal (Incl. Impostos)',
                'subtotal'                   => 'Subtotal',
                'tax-amount'                 => 'Import d\'Impostos',
                'tax'                        => 'Impostos',
                'vat-number'                 => 'Número d\'IVA',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Data de la Transacció',
            'transaction-id'   => 'ID de la Transacció',
            'view'             => 'Veure',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => 'Crear Transacció',
                'title'      => 'Transaccions',

                'datagrid' => [
                    'completed'          => 'Completat',
                    'id'                 => 'ID',
                    'invoice-id'         => 'ID de factura',
                    'order-id'           => 'ID de comanda',
                    'paid'               => 'Pagat',
                    'pending'            => 'Pendent',
                    'status'             => 'Estat',
                    'transaction-amount' => 'Cantitat',
                    'transaction-date'   => 'Data',
                    'transaction-id'     => 'ID de transacció',
                    'view'               => 'Veure',
                ],

                'create' => [
                    'already-paid'               => 'Pagat',
                    'amount'                     => 'Import',
                    'create-transaction'         => 'Crear Transacció',
                    'invoice-id'                 => 'ID de Factura',
                    'invoice-missing'            => 'Factura Absent',
                    'payment-method'             => 'Métode de Pagament',
                    'save-transaction'           => 'Guardar Transacció',
                    'transaction-amount-exceeds' => 'L\'import de la transacció excedeix',
                    'transaction-amount-zero'    => 'Import de la transacció zero',
                    'transaction-saved'          => 'Transacció desada amb éxit.',
                ],

                'view' => [
                    'amount'           => 'Import',
                    'created-at'       => 'Data de Creació',
                    'invoice-id'       => 'Número de Factura',
                    'order-id'         => 'Número de Comanda',
                    'payment-details'  => 'Detalls de Pagament',
                    'payment-method'   => 'Mètode de Pagament',
                    'status'           => 'Estat',
                    'title'            => 'Detalls de la Transacció',
                    'transaction-id'   => 'ID de Transacció',
                ],
            ],
        ],

        'booking' => [
            'index' => [
                'datagrid' => [
                    'created-date' => 'Data de Creació',
                    'from'         => 'Des de',
                    'id'           => 'ID',
                    'order-id'     => 'ID de Comanda',
                    'qty'          => 'Quantitat',
                    'to'           => 'Fins a',
                    'view'         => 'Veure',
                ],

                'title'    => 'Reserves',
            ],

            'calendar' => [
                'booking-date'     => 'Data de Reserva',
                'booking-details'  => 'Detalls de la Reserva',
                'canceled'         => 'Cancel·lat',
                'closed'           => 'Tancat',
                'done'             => 'Fet',
                'order-id'         => 'ID de Comanda',
                'pending'          => 'Pendent',
                'price'            => 'Preu',
                'status'           => 'Estat',
                'time-slot'        => 'Franja Horària:',
                'view-details'     => 'Veure Detalls',
            ],

            'title' => 'Producte de Reserves',
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => 'El :name ja ha estat agafat.',
                'create-btn'    => 'Crear producte',
                'title'         => 'Productes',

                'create' => [
                    'back-btn'                => 'Tornar',
                    'configurable-attributes' => 'Atributs Configurables',
                    'create-btn'              => 'Crear producte',
                    'family'                  => 'Família',
                    'save-btn'                => 'Desar producte',
                    'sku'                     => 'SKU',
                    'title'                   => 'Crear nou producte',
                    'type'                    => 'Tipus',
                ],

                'datagrid' => [
                    'active'                 => 'Actiu',
                    'attribute-family'       => 'Família d\'atributs',
                    'attribute-family-value' => 'Família d\'atributs - :attribute_family',
                    'category'               => 'Categoria',
                    'channel'                => 'Canal',
                    'copy-of'                => 'Còpia de :value',
                    'copy-of-slug'           => 'copia-de-:value',
                    'delete'                 => 'Eliminar',
                    'disable'                => 'Desactivar',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => 'Imatge',
                    'mass-delete-success'    => 'Productes seleccionats eliminats amb éxit',
                    'mass-update-success'    => 'Productes seleccionats actualitzats amb éxit',
                    'name'                   => 'Nom',
                    'out-of-stock'           => 'Exhaurit',
                    'price'                  => 'Preu',
                    'product-image'          => 'Imatge del producte',
                    'qty'                    => 'Quantitat',
                    'qty-value'              => ':qty Disponible',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => 'Estat',
                    'type'                   => 'Tipus',
                    'update-status'          => 'Actualitzar estat',
                ],
            ],

            'edit' => [
                'preview'  => 'Vista prèvia',
                'remove'   => 'Eliminar',
                'save-btn' => 'Guardar producte',
                'title'    => 'Editar producte',

                'channels' => [
                    'title' => 'Canals',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Afegir preu de grup',
                        'all-groups'                => 'Totes les categories',
                        'create-btn'                => 'Afegir nou',
                        'discount-group-price-info' => 'Per a qty Quantitat amb un descompte de :price',
                        'edit-btn'                  => 'Editar',
                        'empty-info'                => 'Preus especials per a clients que pertanyen a un grup específic.',
                        'fixed-group-price-info'    => 'Per a qty Quantitat a un preu fix de :price',
                        'title'                     => 'Preu de grup de client',

                        'create' => [
                            'all-groups'     => 'Totes les categories',
                            'create-title'   => 'Crear preu de grup de client',
                            'customer-group' => 'Grup de client',
                            'delete-btn'     => 'Eliminar',
                            'discount'       => 'Descompte',
                            'fixed'          => 'Fix',
                            'price'          => 'Preu',
                            'price-type'     => 'Tipus de preu',
                            'qty'            => 'Quantitat mínima',
                            'save-btn'       => 'Desa',
                            'update-title'   => 'Actualitzar preu de grup de client',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Quantitat pendent de comanda: :qty',
                    'pending-ordered-qty-info' => 'La quantitat pendent de comanda es deduirà de la font d\'inventari respectiva després de l\'enviament. En cas de cancel·lació, la quantitat pendent estarà disponible per a la venda.',
                    'title'                    => 'Inventaris',
                ],

                'categories' => [
                    'title' => 'Categories',
                ],

                'images' => [
                    'info'  => 'La resolució de la imatge hauria de ser d\'aproximadament 560px X 609px',
                    'title' => 'Imatges',
                ],

                'videos' => [
                    'error' => 'El :attribute no ha de ser més gran que :max kilobytes. Si us plau, selecciona un fitxer més petit.',
                    'info'  => 'El mida màxima del vídeo ha de ser d\'aproximadament :size',
                    'title' => 'Vídeos',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Afegeix productes relacionats sobre la marxa.',
                        'info'       => 'A més del producte que està veient el client, se li presenten productes relacionats.',
                        'title'      => 'Productes relacionats',
                    ],

                    'up-sells' => [
                        'empty-info' => 'Afegeix productes per a upsell sobre la marxa.',
                        'info'       => 'Se li presenten al client productes de upsell, que serveixen com a una alternativa premium o de major qualitat al producte que està veient actualment.',
                        'title'      => 'Productes d\'upsell',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Afegeix productes de venda creuada sobre la marxa.',
                        'info'       => 'Juntament amb el carret de la compra, trobaràs aquests productes de "compra impulsiva" posicionats com a productes de venda creuada per complementar els articles que ja has afegit al teu carret.',
                        'title'      => 'Productes de venda creuada',
                    ],

                    'add-btn'           => 'Afegir producte',
                    'delete'            => 'Eliminar',
                    'empty-info'        => 'Per afegir productes :type sobre la marxa.',
                    'empty-title'       => 'Afegir producte',
                    'image-placeholder' => 'Imatge del producte',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'simple' => [
                        'customizable-options' => [
                            'add-btn'           => 'Afegir Opció',
                            'empty-info'        => 'Per crear opcions personalitzables sobre la marxa.',
                            'empty-title'       => 'Afegir Opció',
                            'info'              => 'Això personalitzarà el producte simple.',
                            'title'             => 'Element Personalitzable',

                            'update-create' => [
                                'is-required'               => 'És Obligatori',
                                'max-characters'            => 'Màxim de Caràcters',
                                'name'                      => 'Títol',
                                'no'                        => 'No',
                                'price'                     => 'Preu',
                                'save-btn'                  => 'Desar',
                                'supported-file-extensions' => 'Extensions de Fitxer Suportades',
                                'title'                     => 'Opció',
                                'type'                      => 'Tipus',
                                'yes'                       => 'Sí',
                            ],

                            'option' => [
                                'add-btn'     => 'Afegir Opció',
                                'delete'      => 'Eliminar',
                                'delete-btn'  => 'Eliminar',
                                'edit-btn'    => 'Editar',
                                'empty-info'  => 'Per crear diverses combinacions de productes sobre la marxa.',
                                'empty-title' => 'Afegir Opció',

                                'types' => [
                                    'text' => [
                                        'title' => 'Text',
                                    ],

                                    'textarea' => [
                                        'title' => 'Àrea de Text',
                                    ],

                                    'checkbox' => [
                                        'title' => 'Casella de Verificació',
                                    ],

                                    'radio' => [
                                        'title' => 'Ràdio',
                                    ],

                                    'select' => [
                                        'title' => 'Seleccionar',
                                    ],

                                    'multiselect' => [
                                        'title' => 'Selecció Múltiple',
                                    ],

                                    'date' => [
                                        'title' => 'Data',
                                    ],

                                    'datetime' => [
                                        'title' => 'Data i Hora',
                                    ],

                                    'time' => [
                                        'title' => 'Hora',
                                    ],

                                    'file' => [
                                        'title' => 'Fitxer',
                                    ],
                                ],

                                'items' => [
                                    'update-create' => [
                                        'label'    => 'Etiqueta',
                                        'price'    => 'Preu',
                                        'save-btn' => 'Desar',
                                        'title'    => 'Opció',
                                    ],
                                ],
                            ],

                            'validations' => [
                                'associated-product' => 'El producte ja està associat amb un producte configurable, agrupat o de paquet.',
                            ],
                        ],
                    ],

                    'configurable' => [
                        'add-btn'           => 'Afegir variant',
                        'delete-btn'        => 'Eliminar',
                        'edit-btn'          => 'Editar',
                        'empty-info'        => 'Per crear diverses combinacions de productes sobre la marxa.',
                        'empty-title'       => 'Afegir variant',
                        'image-placeholder' => ':qty Quantitat',
                        'info'              => 'Els productes de variació depenen de totes les possibles combinacions d\'atributs.',
                        'qty'               => ':qty Quantitat',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Variants',

                        'create' => [
                            'description'            => 'Descripció',
                            'name'                   => 'Nom',
                            'save-btn'               => 'Afegir',
                            'title'                  => 'Afegir variant',
                            'variant-already-exists' => 'Aquesta variant ja existeix',
                        ],

                        'edit' => [
                            'disabled'        => 'Deshabilitat',
                            'edit-info'       => 'Si voleu actualitzar la informació del producte en detall, aneu a la',
                            'edit-link-title' => 'Pàgina de detalls del producte',
                            'enabled'         => 'Habilitat',
                            'images'          => 'Imatges',
                            'name'            => 'Nom',
                            'price'           => 'Preu',
                            'quantities'      => 'Quantitats',
                            'save-btn'        => 'Desar',
                            'sku'             => 'SKU',
                            'status'          => 'Estat',
                            'title'           => 'Producte',
                            'weight'          => 'Pes',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Afegir Imatges',
                            'apply-to-all-btn'    => 'Aplicar a Tots',
                            'apply-to-all-name'   => 'Aplicar un nom a totes les variants.',
                            'apply-to-all-sku'    => 'Aplicar un preu a tots els SKU.',
                            'apply-to-all-status' => 'Aplicar un estat a totes les variants.',
                            'apply-to-all-weight' => 'Aplicar un pes a totes les variants.',
                            'edit-inventories'    => 'Editar Inventaris',
                            'edit-names'          => 'Editar Noms',
                            'edit-prices'         => 'Editar Preus',
                            'edit-sku'            => 'Editar SKU',
                            'edit-status'         => 'Editar Estat',
                            'edit-weight'         => 'Editar Pes',
                            'name'                => 'Nom',
                            'price'               => 'Preu',
                            'remove-images'       => 'Eliminar Imatges',
                            'remove-variants'     => 'Eliminar Variants',
                            'select-action'       => 'Seleccionar Acció',
                            'select-variants'     => 'Seleccionar Variants',
                            'status'              => 'Estat',
                            'variant-name'        => 'Nom de la Variant',
                            'variant-sku'         => 'SKU de la Variant',
                            'weight'              => 'Pes',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Afegir producte',
                        'default-qty'       => 'Quantitat predeterminada',
                        'delete'            => 'Eliminar',
                        'empty-info'        => 'Per crear diverses combinacions de productes sobre la marxa.',
                        'empty-title'       => 'Afegir producte',
                        'image-placeholder' => 'Imatge del producte',
                        'info'              => 'Un producte agrupat consta d\'articles independents presentats com un conjunt, el que permet variacions o coordinació per temporada o tema. Cada producte es pot comprar individualment o com a part del grup.',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Productes agrupats',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Afegir opció',
                        'empty-info'        => 'Per crear opcions de paquet sobre la marxa.',
                        'empty-title'       => 'Afegir opció',
                        'image-placeholder' => 'Imatge del producte',
                        'info'              => 'Un producte de paquet és un paquet de diversos articles o serveis que es venen junts a un preu especial, oferint valor i comoditat als clients.',
                        'title'             => 'Ítems de paquet',

                        'update-create' => [
                            'checkbox'    => 'Casella de verificació',
                            'is-required' => 'És obligatori',
                            'multiselect' => 'Selecció múltiple',
                            'name'        => 'Títol',
                            'no'          => 'No',
                            'radio'       => 'Ràdio',
                            'save-btn'    => 'Desar',
                            'select'      => 'Seleccionar',
                            'title'       => 'Opció',
                            'type'        => 'Tipus',
                            'yes'         => 'Sí',
                        ],

                        'option' => [
                            'add-btn'     => 'Afegir producte',
                            'default-qty' => 'Quantitat per defecte',
                            'delete'      => 'Eliminar',
                            'delete-btn'  => 'Eliminar',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Per crear diverses combinacions de productes sobre la marxa.',
                            'empty-title' => 'Afegir producte',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Estableix el producte per defecte utilitzant una casella de verificació.',
                                    'title' => 'Casella de verificació',
                                ],

                                'multiselect' => [
                                    'info'  => 'Estableix el producte per defecte utilitzant un botó de selecció múltiple.',
                                    'title' => 'Selecció múltiple',
                                ],

                                'radio' => [
                                    'info'  => 'Estableix el producte per defecte utilitzant un botó de selecció (radio).',
                                    'title' => 'Selecció (Radio)',
                                ],

                                'select' => [
                                    'info'  => 'Estableix el producte per defecte utilitzant un botó de selecció.',
                                    'title' => 'Seleccionar',
                                ],
                            ],
                        ],
                    ],

                    'booking' => [
                        'available-from' => 'Disponible Des de',
                        'available-to'   => 'Disponible Fins a',
                        'location'       => 'Ubicació',
                        'qty'            => 'Quantitat',
                        'title'          => 'Tipus de Reserva',

                        'available-every-week' => [
                            'no'    => 'No',
                            'title' => 'Disponible Cada Setmana',
                            'yes'   => 'Sí',
                        ],

                        'appointment' => [
                            'break-duration'         => 'Temps de Descans entre Franges (Mins)',
                            'slot-duration'          => 'Durada de la Franja (Mins)',

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Mateixa Franja per a Tots els Dies',
                                'yes'   => 'Sí',
                            ],
                        ],

                        'default' => [
                            'add'              => 'Afegir',
                            'break-duration'   => 'Temps de Descans entre Franges (Mins)',
                            'close'            => 'Tancar',
                            'description'      => 'Informació de la Reserva',
                            'description-info' => 'Segons les franges horàries, es crearà i es mostrarà la durada del temps. Serà única a totes les franges i es mostrarà a la botiga en línia.',
                            'edit'             => 'Editar',
                            'many'             => 'Moltes Reserves per a Un Dia',
                            'one'              => 'Una Reserva per a Molts Dies',
                            'open'             => 'Obrir',
                            'slot-add'         => 'Afegir Franges',
                            'slot-duration'    => 'Durada de la Franja (Mins)',
                            'slot-title'       => 'Durada de les Franges',
                            'title'            => 'Per Defecte',
                            'unavailable'      => 'No Disponible',

                            'modal'            => [
                                'slot' => [
                                    'add-title'  => 'Afegir Franges',
                                    'close'      => 'Tancar',
                                    'day'        => 'Dia',
                                    'edit-title' => 'Editar Franges',
                                    'friday'     => 'Divendres',
                                    'from'       => 'Des de',
                                    'from-day'   => 'Des del Dia',
                                    'from-time'  => 'Des de l\'Hora',
                                    'monday'     => 'Dilluns',
                                    'open'       => 'Obrir',
                                    'saturday'   => 'Dissabte',
                                    'save'       => 'Desar',
                                    'select'     => 'Seleccionar',
                                    'status'     => 'Estat',
                                    'sunday'     => 'Diumenge',
                                    'thursday'   => 'Dijous',
                                    'to'         => 'Fins a',
                                    'to-day'     => 'Fins al Dia',
                                    'to-time'    => 'Fins a l\'Hora',
                                    'tuesday'    => 'Dimarts',
                                    'wednesday'  => 'Dimecres',
                                    'week'       => ':day',
                                ],
                            ],
                        ],

                        'event' => [
                            'add'                => 'Afegir Entrades',
                            'delete'             => 'Eliminar',
                            'description'        => 'Descripció',
                            'description-info'   => 'No hi ha entrades disponibles.',
                            'edit'               => 'Editar',
                            'name'               => 'Nom',
                            'price'              => 'Preu',
                            'qty'                => 'Quantitat',
                            'special-price'      => 'Preu Especial',
                            'special-price-from' => 'Preu Especial Des de',
                            'special-price-to'   => 'Preu Especial Fins a',
                            'title'              => 'Entrades',
                            'valid-from'         => 'Vàlid Des de',
                            'valid-until'        => 'Vàlid Fins a',

                            'modal'              => [
                                'edit' => 'Editar Entrades',
                                'save' => 'Desar',
                            ],
                        ],

                        'empty-info' => [
                            'tickets' => [
                                'add' => 'Afegir Entrades',
                            ],

                            'slots'   => [
                                'add'         => 'Afegir Franges',
                                'description' => 'Franges Disponibles amb Durada de Temps.',
                            ],
                        ],

                        'rental' => [
                            'daily'                  => 'Base Diària',
                            'daily-hourly'           => 'Ambdues (Base Diària i Horària)',
                            'daily-price'            => 'Preu Diari',
                            'hourly'                 => 'Base Horària',
                            'hourly-price'           => 'Preu Horari',
                            'title'                  => 'Tipus de Lloguer',

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Mateixa Franja per a Tots els Dies',
                                'yes'   => 'Sí',
                            ],
                        ],

                        'slots' => [
                            'add'              => 'Afegir Franges',
                            'description-info' => 'Segons les franges horàries, es crearà i es mostrarà la durada del temps. Serà única a totes les franges i es mostrarà a la botiga en línia.',
                            'save'             => 'Desar',
                            'title'            => 'Durada de les Franges',
                            'unavailable'      => 'No Disponible',

                            'action' => [
                                'add' => 'Afegir',
                            ],

                            'modal' => [
                                'slot' => [
                                    'friday'     => 'Divendres',
                                    'from'       => 'Des de',
                                    'monday'     => 'Dilluns',
                                    'saturday'   => 'Dissabte',
                                    'sunday'     => 'Diumenge',
                                    'thursday'   => 'Dijous',
                                    'to'         => 'Fins a',
                                    'tuesday'    => 'Dimarts',
                                    'wednesday'  => 'Dimecres',
                                ],
                            ],
                        ],

                        'table' => [
                            'break-duration'            => 'Temps de Descans entre Franges (Mins)',
                            'guest-capacity'            => 'Capacitat de Convidats',
                            'guest-limit'               => 'Límit de Convidats per Taula',
                            'prevent-scheduling-before' => 'Evitar Programació Abans de',
                            'slot-duration'             => 'Durada de la Franja (Mins)',

                            'charged-per' => [
                                'guest'  => 'Convidat',
                                'table'  => 'Taula',
                                'title'  => 'Cobrat Per',
                            ],

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Mateixa Franja per a Tots els Dies',
                                'yes'   => 'Sí',
                            ],
                        ],

                        'type' => [
                            'appointment' => 'Reserva de Cita',
                            'default'     => 'Reserva per Defecte',
                            'event'       => 'Reserva d\'Esdeveniment',
                            'many'        => 'Molts',
                            'one'         => 'Un',
                            'rental'      => 'Reserva de Lloguer',
                            'table'       => 'Reserva de Taula',
                            'title'       => 'Tipus',
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Afegir enllaç',
                            'delete-btn'  => 'Eliminar',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Per crear un enllaç sobre la marxa.',
                            'empty-title' => 'Afegir enllaç',
                            'file'        => 'Arxiu: ',
                            'info'        => 'El tipus de producte descarregable permet vendre productes digitals com llibres electrònics, aplicacions de programari, música, jocs, etc.',
                            'sample-file' => 'Arxiu d\'exemple: ',
                            'sample-url'  => 'URL d\'exemple: ',
                            'title'       => 'Enllaços descarregables',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'downloads'   => 'Descarrega permesa',
                                'file'        => 'Arxiu',
                                'file-type'   => 'Tipus d\'arxiu',
                                'name'        => 'Títol',
                                'price'       => 'Preu',
                                'sample'      => 'Mostra',
                                'sample-type' => 'Tipus de mostra',
                                'save-btn'    => 'Desar',
                                'title'       => 'Enllaç',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Afegir mostra',
                            'delete-btn'  => 'Eliminar',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Per crear una mostra sobre la marxa.',
                            'empty-title' => 'Afegir mostra',
                            'file'        => 'Arxiu: ',
                            'info'        => 'El tipus de producte descarregable permet vendre productes digitals com llibres electrònics, aplicacions de programari, música, jocs, etc.',
                            'title'       => 'Mostres descarregables',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'file'        => 'Arxiu',
                                'file-type'   => 'Tipus d\'arxiu',
                                'name'        => 'Títol',
                                'save-btn'    => 'Desar',
                                'title'       => 'Enllaç',
                                'url'         => 'URL',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Producte creat amb éxit',
            'delete-failed'           => 'Error en eliminar el producte',
            'delete-success'          => 'Producte eliminat amb éxit',
            'product-copied'          => 'Producte copiat amb éxit',
            'saved-inventory-message' => 'Producte desat amb éxit',
            'update-success'          => 'Producte actualitzat amb éxit',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Crear Atributs',
                'title'      => 'Atributs',

                'datagrid' => [
                    'boolean'             => 'Booleà',
                    'channel-based'       => 'Basat en canal',
                    'checkbox'            => 'Casella de verificació',
                    'code'                => 'Codi',
                    'created-at'          => 'Creat el',
                    'date'                => 'Data',
                    'date-time'           => 'Data i hora',
                    'delete'              => 'Eliminar',
                    'edit'                => 'Editar',
                    'false'               => 'Fals',
                    'file'                => 'Arxiu',
                    'id'                  => 'ID',
                    'image'               => 'Imatge',
                    'locale-based'        => 'Basat en la localització',
                    'mass-delete-success' => 'Atribut seleccionat eliminat amb éxit',
                    'multiselect'         => 'Selecció múltiple',
                    'name'                => 'Nom',
                    'price'               => 'Preu',
                    'required'            => 'Requerit',
                    'select'              => 'Seleccionar',
                    'text'                => 'Text',
                    'textarea'            => 'Àrea de text',
                    'true'                => 'Verdader',
                    'type'                => 'Tipus',
                    'unique'              => 'Únic',
                ],
            ],

            'create' => [
                'add-attribute-options' => 'Afegir Opcions d\'Atribut',
                'add-option'            => 'Afegir Opció',
                'add-options-info'      => 'Per crear diverses combinacions d\'Opcions d\'Atribut al moment.',
                'add-row'               => 'Afegir Fil',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nom d\'Admin',
                'back-btn'              => 'Enrere',
                'boolean'               => 'Booleà',
                'checkbox'              => 'Casella de Verificació',
                'code'                  => 'Codi de l\'Atribut',
                'color'                 => 'Color',
                'configuration'         => 'Configuració',
                'create-empty-option'   => 'Crear opció buida per defecte',
                'date'                  => 'Data',
                'datetime'              => 'Data i Hora',
                'decimal'               => 'Decimal',
                'default-value'         => 'Valor per defecte',
                'email'                 => 'Correu electrònic',
                'enable-wysiwyg'        => 'Habilitar l\'Editor WYSIWYG',
                'file'                  => 'Arxiu',
                'general'               => 'General',
                'image'                 => 'Imatge',
                'input-options'         => 'Opcions d\'Entrada',
                'input-validation'      => 'Validació d\'Entrada',
                'is-comparable'         => 'L\'Atribut és Comparable',
                'is-configurable'       => 'Utilitzar per crear Productes Configurables',
                'is-filterable'         => 'Utilitzar en Navegació per Capes',
                'is-required'           => 'És Obligatòri',
                'is-unique'             => 'És Únic',
                'is-visible-on-front'   => 'Visible a la Pàgina de Visualització de Productes al Front-end',
                'label'                 => 'Etiqueta',
                'multiselect'           => 'Selecció Múltiple',
                'no'                    => 'No',
                'numeric'               => 'Número',
                'option-deleted'        => 'Opció eliminada amb éxit',
                'options'               => 'Opcions',
                'position'              => 'Posició',
                'price'                 => 'Preu',
                'regex'                 => 'Expressió Regular',
                'regex-info'            => 'L\'expressió ha d\'estar entre cometes dobles.',
                'save-btn'              => 'Guardar Atribut',
                'select'                => 'Seleccionar',
                'select-type'           => 'Tipus d\'Atribut de Selecció',
                'swatch'                => 'Mostra de Color',
                'text'                  => 'Text',
                'textarea'              => 'Àrea de Text',
                'title'                 => 'Afegir Atribut',
                'type'                  => 'Tipus d\'Atribut',
                'url'                   => 'URL',
                'use-in-flat'           => 'Crear en Taula Plana de Productes',
                'validations'           => 'Validacions',
                'value-per-channel'     => 'Valor per Canal',
                'value-per-locale'      => 'Valor per',
                'yes'                   => 'Sí',

                'option' => [
                    'color'    => 'Mostra de Color',
                    'dropdown' => 'Desplegable',
                    'image'    => 'Mostra d\'Imatge',
                    'save-btn' => 'Guardar Opció',
                    'text'     => 'Mostra de Text',
                ],
            ],

            'edit' => [
                'add-attribute-options'  => 'Afegir Opcions d\'Atributes',
                'add-option'             => 'Afegir Opció',
                'add-options-info'       => 'Per crear diverses combinacions d\'Opcions d\'Atributes alhora.',
                'add-row'                => 'Afegir Fil',
                'admin'                  => 'Admin',
                'admin-name'             => 'Nom de l\'Admin',
                'back-btn'               => 'Enrere',
                'boolean'                => 'Boolean',
                'checkbox'               => 'Casella de Verificació',
                'code'                   => 'Codi de l\'Atribut',
                'color'                  => 'Color',
                'configuration'          => 'Configuració',
                'create-empty-option'    => 'Crear opció buida predeterminada',
                'date'                   => 'Data',
                'datetime'               => 'Data i Hora',
                'decimal'                => 'Decimal',
                'default-value'          => 'Valor predeterminat',
                'email'                  => 'Correu Electrònic',
                'enable-wysiwyg'         => 'Habilitar l\'Editor WYSIWYG',
                'file'                   => 'Fitxer',
                'general'                => 'General',
                'image'                  => 'Imatge',
                'input-options'          => 'Opcions d\'Entrada',
                'input-validation'       => 'Validació d\'Entrada',
                'is-comparable'          => 'L\'Atribut és Comparable',
                'is-configurable'        => 'Fer servir per Crear Productes Configurables',
                'is-filterable'          => 'Fer servir en Navegació per Capes',
                'is-required'            => 'És Obligatòri',
                'is-unique'              => 'És Únic',
                'is-visible-on-front'    => 'Visible a la Pàgina de Visualització de Productes al Front-end',
                'label'                  => 'Etiqueta',
                'multiselect'            => 'Selecció Múltiple',
                'no'                     => 'No',
                'numeric'                => 'Número',
                'option-deleted'         => 'Opció eliminada amb éxit',
                'options'                => 'Opcions',
                'position'               => 'Posició',
                'price'                  => 'Preu',
                'regex'                  => 'Expressió Regular',
                'regex-info'             => 'L\'expressió ha d\'estar entre cometes dobles.',
                'save-btn'               => 'Desar Atribut',
                'select'                 => 'Seleccionar',
                'select-type'            => 'Tipus d\'Atribut de Selecció',
                'swatch'                 => 'Mostra de Color',
                'text'                   => 'Text',
                'textarea'               => 'Àrea de Text',
                'title'                  => 'Editar Atribut',
                'type'                   => 'Tipus d\'Atribut',
                'url'                    => 'URL',
                'use-in-flat'            => 'Crear en Taula Plana de Productes',
                'validations'            => 'Validacions',
                'value-per-channel'      => 'Valor per Canal',
                'value-per-locale'       => 'Valor per Localització',
                'yes'                    => 'Sí',

                'option' => [
                    'color'     => 'Mostra de Color',
                    'dropdown'  => 'Desplegable',
                    'image'     => 'Mostra d\'Imatge',
                    'save-btn'  => 'Desar Opció',
                    'text'      => 'Mostra de Text',
                ],
            ],

            'create-success'    => 'Atribut creat amb éxit',
            'delete-failed'     => 'Error en eliminar l\'atribut',
            'delete-success'    => 'Atribut eliminat amb éxit',
            'update-success'    => 'Atribut actualitzat amb éxit',
            'user-define-error' => 'No es pot eliminar l\'atribut del sistema',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'Crear Categoria',
                'title'   => 'Categoria',

                'datagrid' => [
                    'active'         => 'Actiu',
                    'delete'         => 'Eliminar',
                    'delete-success' => 'Els :resource seleccionats s\'han eliminat correctament',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'inactive'       => 'Inactiu',
                    'name'           => 'Nom',
                    'no-of-products' => 'Visible al menú',
                    'position'       => 'Posició',
                    'status'         => 'Estat',
                    'update-status'  => 'Actualitzar Estat',
                ],
            ],

            'create' => [
                'add-banner'               => 'Afegir Banner',
                'add-logo'                 => 'Afegir Logo',
                'back-btn'                 => 'Enrere',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporció de l\'aspecte del banner (1320px X 300px)',
                'description'              => 'Descripció',
                'description-and-images'   => 'Descripció i Imatges',
                'description-only'         => 'Només Descripció',
                'display-mode'             => 'Mode de Visualització',
                'enter-position'           => 'Introduir Posició',
                'filterable-attributes'    => 'Atributs Filtrables',
                'general'                  => 'General',
                'logo'                     => 'Logo',
                'logo-size'                => 'La resolució del logo ha de ser (110px X 110px)',
                'meta-description'         => 'Meta Descripció',
                'meta-keywords'            => 'Meta Paraules Clau',
                'meta-title'               => 'Meta Títol',
                'name'                     => 'Nom',
                'parent-category'          => 'Categoria Pare',
                'position'                 => 'Posició',
                'products-and-description' => 'Productes i Descripció',
                'products-only'            => 'Només Productes',
                'save-btn'                 => 'Desar Categoria',
                'select-display-mode'      => 'Seleccionar Mode de Visualització',
                'seo-details'              => 'Detalls SEO',
                'settings'                 => 'Configuracions',
                'slug'                     => 'Slug',
                'title'                    => 'Afegir Nova Categoria',
                'visible-in-menu'          => 'Visible al Menú',
            ],

            'edit' => [
                'add-banner'               => 'Afegir Banner',
                'add-logo'                 => 'Afegir Logo',
                'back-btn'                 => 'Enrere',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporció de l\'aspecte del banner (1320px X 300px)',
                'description'              => 'Descripció',
                'description-and-images'   => 'Descripció i Imatges',
                'description-only'         => 'Només Descripció',
                'display-mode'             => 'Mode de Visualització',
                'enter-position'           => 'Introduir Posició',
                'filterable-attributes'    => 'Atributs Filtrables',
                'general'                  => 'General',
                'logo'                     => 'Logo',
                'logo-size'                => 'La resolució del logo ha de ser (110px X 110px)',
                'meta-description'         => 'Meta Descripció',
                'meta-keywords'            => 'Meta Paraules Clau',
                'meta-title'               => 'Meta Títol',
                'name'                     => 'Nom',
                'position'                 => 'Posició*',
                'products-and-description' => 'Productes i Descripció',
                'products-only'            => 'Només Productes',
                'save-btn'                 => 'Desar Categoria',
                'select-display-mode'      => 'Seleccionar Mode de Visualització',
                'select-parent-category'   => 'Seleccionar Categoria Pare*',
                'seo-details'              => 'Detalls SEO',
                'settings'                 => 'Configuracions',
                'slug'                     => 'Slug',
                'title'                    => 'Editar Categoria',
                'visible-in-menu'          => 'Visible al Menú',
            ],

            'category'             => 'Categoria',
            'create-success'       => 'Categoria creada amb éxit.',
            'delete-category-root' => 'No es pot eliminar la categoria arrel.',
            'delete-failed'        => 'S\'ha produït un error en eliminar la categoria.',
            'delete-success'       => 'La categoria s\'ha eliminat amb éxit.',
            'update-success'       => 'Categoria actualitzada amb éxit.',
        ],

        'families' => [
            'index' => [
                'add'    => 'Crear Família d\'Atributs',
                'title'  => 'Famílies',

                'datagrid' => [
                    'code'           => 'Codi',
                    'delete'         => 'Eliminar',
                    'delete-success' => ':resource seleccionades s\'han eliminat correctament',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'method-error'   => 'Error. Mètode incorrecte detectat, si us plau, verifica la configuració d\'acció massiva',
                    'name'           => 'Nom',
                    'no-resource'    => 'El recurs proporcionat no és suficient per a l\'acció',
                    'partial-action' => 'Algunes accions no es van poder realitzar a causa de restriccions del sistema en :resource',
                    'update-success' => ':resource seleccionades s\'han actualitzat correctament',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Afegir Grup',
                'add-group-title'                  => 'Afegir Nou Grup',
                'back-btn'                         => 'Enrere',
                'code'                             => 'Codi',
                'column'                           => 'Columna',
                'delete-group-btn'                 => 'Eliminar Grup',
                'edit-group-info'                  => 'Feu doble clic per editar el Grup',
                'enter-code'                       => 'Introduïu el Codi',
                'enter-name'                       => 'Introduïu el Nom',
                'general'                          => 'General',
                'group-code-already-exists'        => 'Ja existeix un codi de grup d\'atributs.',
                'group-contains-system-attributes' => 'Aquest grup conté atributs del sistema. Primer moveu els atributs del sistema a un altre grup i després torneu-ho a provar.',
                'group-name-already-exists'        => 'Ja existeix un nom de grup d\'atributs.',
                'groups'                           => 'Grups',
                'groups-info'                      => 'Gestiona els grups de famílies d\'atributs',
                'main-column'                      => 'Columna Principal',
                'name'                             => 'Nom',
                'removal-not-possible'             => 'No pots eliminar atributs del sistema de la família d\'atributs.',
                'right-column'                     => 'Columna de la Dreta',
                'save-btn'                         => 'Desar Família d\'Atributs',
                'select-group'                     => 'Si us plau, selecciona un grup d\'atributs.',
                'title'                            => 'Crear Família d\'Atributs',
                'unassigned-attributes'            => 'Atributs no assignats',
                'unassigned-attributes-info'       => 'Arrossega aquests atributs per afegir-los a les columnes o grups.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Afegir Grup',
                'add-group-title'                  => 'Afegir Nou Grup',
                'back-btn'                         => 'Enrere',
                'code'                             => 'Codi',
                'column'                           => 'Columna',
                'delete-group-btn'                 => 'Eliminar Grup',
                'edit-group-info'                  => 'Feu doble clic per editar el Grup',
                'enter-code'                       => 'Introduïu el Codi',
                'enter-name'                       => 'Introduïu el Nom',
                'general'                          => 'General',
                'group-code-already-exists'        => 'Ja existeix un codi de grup d\'atributs.',
                'group-contains-system-attributes' => 'Aquest grup conté atributs del sistema. Primer moveu els atributs del sistema a un altre grup i després torneu-ho a provar.',
                'group-name-already-exists'        => 'Ja existeix un nom de grup d\'atributs.',
                'groups'                           => 'Grups',
                'groups-info'                      => 'Gestiona els grups de famílies d\'atributs',
                'main-column'                      => 'Columna Principal',
                'name'                             => 'Nom',
                'removal-not-possible'             => 'No pots eliminar atributs del sistema de la família d\'atributs.',
                'right-column'                     => 'Columna de la Dreta',
                'save-btn'                         => 'Desar Família d\'Atributs',
                'select-group'                     => 'Si us plau, selecciona un grup d\'atributs.',
                'title'                            => 'Editar Família d\'Atributs',
                'unassigned-attributes'            => 'Atributs no assignats',
                'unassigned-attributes-info'       => 'Arrossega aquests atributs per afegir-los a les columnes o grups.',
            ],

            'attribute-family'        => 'Família d\'Atributs',
            'attribute-product-error' => 'La família s\'utilitza en productes.',
            'create-success'          => 'Família creada amb éxit.',
            'delete-failed'           => 'S\'ha produït un error en eliminar la família.',
            'delete-success'          => 'Família eliminada amb éxit.',
            'family'                  => 'Família',
            'last-delete-error'       => 'Es requereix almenys una família.',
            'update-success'          => 'Família actualitzada amb éxit.',
            'user-define-error'       => 'No es pot eliminar la família d\'atributs del sistema',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Clients',
                'login-message' => 'Has iniciat sesió com a :customer_name',

                'datagrid' => [
                    'active'         => 'Actiu',
                    'address'        => ':address Adreça(es)',
                    'address-count'  => 'Quantitat d\'Adreces',
                    'channel'        => 'Canal',
                    'delete'         => 'Eliminar',
                    'delete-success' => 'Dades seleccionades eliminades correctament',
                    'email'          => 'Correu Electrònic',
                    'gender'         => 'Gènere',
                    'group'          => 'Grup',
                    'id'             => 'ID de Client',
                    'id-value'       => 'ID - :id',
                    'inactive'       => 'Inactiu',
                    'method-error'   => 'Error! Mètode incorrecte detectat, si us plau revisa la configuració de l\'acció massiva',
                    'name'           => 'Nom del Client',
                    'no-resource'    => 'El recurs proporcionat no és suficient per a l\'acció',
                    'order'          => ':order Comanda(s)',
                    'order-count'    => 'Quantitat de Comandes',
                    'order-pending'  => 'El client té comandes pendents',
                    'partial-action' => 'Algunes accions no es van realitzar a causa de restriccions del sistema a :resource',
                    'phone'          => 'Número de Contacte',
                    'revenue'        => 'Ingressos',
                    'status'         => 'Estat',
                    'suspended'      => 'Suspés',
                    'update-status'  => 'Actualizar l\'Estat',
                    'update-success' => 'Clients seleccionats actualitzats correctament',
                ],

                'create' => [
                    'contact-number'        => 'Número de Contacte',
                    'create-btn'            => 'Crear Client',
                    'create-success'        => 'Client creat amb éxit',
                    'customer-group'        => 'Grup de Clients',
                    'date-of-birth'         => 'Data de Naixement',
                    'email'                 => 'Correu Electrònic',
                    'female'                => 'Femení',
                    'first-name'            => 'Primer Nom',
                    'gender'                => 'Gènere',
                    'last-name'             => 'Cognom',
                    'male'                  => 'Masculí',
                    'other'                 => 'Altre',
                    'save-btn'              => 'Desar Client',
                    'select-customer-group' => 'Seleccionar Grup de Client',
                    'select-gender'         => 'Seleccionar Gènere',
                    'title'                 => 'Crear Nou Client',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'Estàs segur que vols eliminar aquest compte?',
                'active'                      => 'Actiu',
                'address-delete-confirmation' => 'Estàs segur que vols eliminar aquesta adreça?',
                'back-btn'                    => 'Tornar',
                'create-order'                => 'Crear Comanda',
                'customer'                    => 'Client',
                'date-of-birth'               => 'DOB - :dob',
                'default-address'             => 'Adreça per defecte',
                'delete-account'              => 'Eliminar compte',
                'delete'                      => 'Eliminar',
                'email'                       => 'Correu electrònic - :email',
                'empty-description'           => 'Crea noves adreces per al client',
                'empty-title'                 => 'Afegir adreça del client',
                'gender'                      => 'Gènere - :gender',
                'group'                       => 'Grup - :group_code',
                'inactive'                    => 'Inactiu',
                'login-as-customer'           => 'Iniciar sessió com a client',
                'note-created-success'        => 'Nota creada amb éxit',
                'order-create-confirmation'   => 'Estàs segur que vols crear una comanda per a aquest client?',
                'phone'                       => 'Telèfon - :phone',
                'set-as-default'              => 'Establir com a predeterminat',
                'suspended'                   => 'Suspès',
                'title'                       => 'Vista del client',

                'address' => [
                    'count'  => 'Adreces (:count)',

                    'create' => [
                        'city'               => 'Ciutat',
                        'company-name'       => 'Nom de l\'empresa',
                        'country'            => 'País',
                        'create-btn'         => 'Crear',
                        'create-address-btn' => 'Afegir nova adreça',
                        'default-address'    => 'Adreça per defecte',
                        'email'              => 'Correu electrònic',
                        'first-name'         => 'Nom',
                        'last-name'          => 'Cognom',
                        'phone'              => 'Telèfon',
                        'post-code'          => 'Codi postal',
                        'save-btn-title'     => 'Desar adreça',
                        'select-country'     => 'Seleccionar país',
                        'state'              => 'Estat',
                        'street-address'     => 'Adreça',
                        'title'              => 'Crear adreça',
                        'vat-id'             => 'ID d\'IVA',
                    ],

                    'edit' => [
                        'city'            => 'Ciutat',
                        'company-name'    => 'Nom de l\'empresa',
                        'country'         => 'País',
                        'default-address' => 'Adreça per defecte',
                        'edit-btn'        => 'Editar',
                        'email'           => 'Correu electrònic',
                        'first-name'      => 'Nom',
                        'last-name'       => 'Cognom',
                        'phone'           => 'Telèfon',
                        'post-code'       => 'Codi postal',
                        'save-btn-title'  => 'Desar adreça',
                        'select-country'  => 'Seleccionar país',
                        'state'           => 'Estat',
                        'street-address'  => 'Adreça',
                        'title'           => 'Editar adreça',
                        'vat-id'          => 'ID d\'IVA',
                    ],

                    'address-delete-success' => 'Adreça eliminada amb éxit',
                    'create-success'         => 'Adreça creada amb éxit',
                    'set-default-success'    => 'Adreça per defecte actualitzada amb éxit',
                    'success-mass-delete'    => 'Eliminació massiva d\'adreces finalitzada amb éxit',
                    'update-success'         => 'Adreça actualitzada amb éxit',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'No hi ha ressenyes disponibles',
                        'increment-id'   => 'ID de la factura',
                        'invoice-amount' => 'Import de la factura',
                        'invoice-date'   => 'Data de la factura',
                        'order-id'       => 'ID de la comanda',
                        'view'           => 'Veure',
                    ],

                    'orders' => [
                        'canceled'        => 'Cancel·lat',
                        'channel-name'    => 'Nom del canal',
                        'closed'          => 'Tancat',
                        'completed'       => 'Completat',
                        'customer-name'   => 'Nom del client',
                        'date'            => 'Data',
                        'empty-order'     => 'No hi ha comandes disponibles',
                        'email'           => 'Correu electrònic',
                        'fraud'           => 'Frau',
                        'grand-total'     => 'Total general',
                        'location'        => 'Ubicació',
                        'order-id'        => 'ID de la comanda',
                        'pay-via'         => 'Pagar amb',
                        'pending'         => 'Pendent',
                        'pending-payment' => 'Pagament pendent',
                        'processing'      => 'Processant',
                        'status'          => 'Estat',
                        'view'            => 'Veure',
                    ],

                    'reviews' => [
                        'approved'      => 'Aprovat',
                        'comment'       => 'Comentari',
                        'created-at'    => 'Creat el',
                        'disapproved'   => 'Desaprovat',
                        'empty-reviews' => 'No hi ha factures disponibles',
                        'id'            => 'ID',
                        'invoice-date'  => 'Data de la factura',
                        'pending'       => 'Pendent',
                        'product-id'    => 'ID del producte',
                        'product-name'  => 'Nom del producte',
                        'rating'        => 'Valoració',
                        'status'        => 'Estat',
                        'title'         => 'Títol',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Número de contacte',
                    'customer-group'        => 'Grup de clients',
                    'date-of-birth'         => 'Data de naixement',
                    'edit-btn'              => 'Editar',
                    'email'                 => 'Correu electrònic',
                    'female'                => 'Femení',
                    'first-name'            => 'Nom',
                    'gender'                => 'Gènere',
                    'last-name'             => 'Cognom',
                    'male'                  => 'Masculí',
                    'other'                 => 'Altres',
                    'save-btn'              => 'Desar client',
                    'select-customer-group' => 'Seleccionar grup de clients',
                    'select-gender'         => 'Seleccionar gènere',
                    'status'                => 'Estat',
                    'suspended'             => 'Suspès',
                    'title'                 => 'Editar client',
                ],

                'invoices' => [
                    'count'        => 'Factures (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Afegir nota',
                    'customer-not-notified' => ':date | Client <b>No notificat</b>',
                    'customer-notified'     => ':date | Client <b>Notificat</b>',
                    'note'                  => 'Nota',
                    'note-placeholder'      => 'Escriu la teva nota aquí',
                    'notify-customer'       => 'Notificar al client',
                    'submit-btn-title'      => 'Enviar nota',
                ],

                'orders' => [
                    'count'         => 'Comandes (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Ingressos totals - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'Ressenyes (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Element del carret eliminat amb éxit.',
                ],

                'wishlist' => [
                    'delete-success' => 'Element de la llista de desitjos eliminat amb éxit.',
                ],

                'compare' => [
                    'delete-success' => 'Element de comparació eliminat amb éxit.',
                ],
            ],

            'delete-failed'  => 'S\'ha produït un error en eliminar el client',
            'delete-success' => 'Client eliminat amb éxit',
            'order-pending'  => 'Hi ha comandes pendents',
            'update-success' => 'Client actualitzat amb éxit',
        ],

        'groups' => [
            'index' => [
                'title' => 'Grups',

                'create' => [
                    'code'       => 'Codi',
                    'create-btn' => 'Crear Grup',
                    'name'       => 'Nom',
                    'save-btn'   => 'Desar Grup',
                    'success'    => 'Grup creat amb éxit',
                    'title'      => 'Crear Nou Grup',
                ],

                'edit'  => [
                    'delete-failed'  => 'Error en eliminar el grup',
                    'delete-success' => 'Grup eliminat amb éxit',
                    'group-default'  => 'No es pot eliminar el grup per defecte',
                    'success'        => 'Grup actualitzat amb éxit',
                    'title'          => 'Editar Grup',
                ],

                'datagrid'  => [
                    'code'    => 'Codi',
                    'delete'  => 'Eliminar',
                    'edit'    => 'Editar',
                    'id'      => 'ID',
                    'name'    => 'Nom',
                ],
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Data',
                'description' => 'Descripció',
                'id'          => 'ID',
                'name'        => 'Nom',
                'product'     => 'Producte',
                'rating'      => 'Qualificació',
                'status'      => 'Estat',
                'title'       => 'Ressenyes',

                'edit' => [
                    'approved'       => 'Aprovada',
                    'customer'       => 'Client',
                    'date'           => 'Data',
                    'disapproved'    => 'Desaprovada',
                    'id'             => 'ID',
                    'images'         => 'Imatges',
                    'pending'        => 'Pendent',
                    'product'        => 'Producte',
                    'rating'         => 'Qualificació',
                    'review-comment' => 'Comentari',
                    'review-title'   => 'Títol',
                    'save-btn'       => 'Desar',
                    'status'         => 'Estat',
                    'title'          => 'Editar Ressenya',
                    'update-success' => 'Actualització realitzada amb éxit',
                ],

                'datagrid' => [
                    'approved'               => 'Aprovada',
                    'comment'                => 'Comentari',
                    'customer-names'         => 'Nom',
                    'date'                   => 'Data',
                    'delete'                 => 'Eliminar',
                    'delete-success'         => 'Ressenya eliminada amb éxit',
                    'disapproved'            => 'Desaprovada',
                    'edit'                   => 'Editar',
                    'id'                     => 'ID',
                    'mass-delete-error'      => 'Alguna cosa ha anat malament',
                    'mass-delete-success'    => 'Ressenyes seleccionades eliminades amb éxit',
                    'mass-update-success'    => 'Ressenyes seleccionades actualitzades amb éxit',
                    'pending'                => 'Pendent',
                    'product'                => 'Producte',
                    'rating'                 => 'Qualificació',
                    'review-id'              => 'ID - :review_id',
                    'status'                 => 'Estat',
                    'title'                  => 'Títol',
                    'update-status'          => 'Actualitzar estat',
                ],
            ],
        ],

        'gdpr' => [
            'index' => [
                'title' => 'Sol·licitud GDPR',

                'datagrid' => [
                    'completed'     => 'Completat',
                    'created-at'    => 'Creat el',
                    'customer-name' => 'Nom del Client',
                    'declined'      => 'Rebutjat',
                    'delete'        => 'Eliminar',
                    'edit'          => 'Editar',
                    'id'            => 'ID',
                    'message'       => 'Missatge',
                    'pending'       => 'Pendent',
                    'processing'    => 'Processant',
                    'revoked'       => 'Revoked',
                    'status'        => 'Estat',
                    'type'          => 'Tipus',
                ],

                'modal' => [
                    'completed'     => 'Completat',
                    'declined'      => 'Rebutjat',
                    'message'       => 'Missatge',
                    'pending'       => 'Pendent',
                    'processing'    => 'Processant',
                    'revoked'       => 'Revoked',
                    'save-btn'      => 'Desar',
                    'status'        => 'Estat',
                    'title'         => 'Editar Sol·licitud de Dades GDPR',
                    'type'          => 'Tipus',
                ],

                'update-success'              => 'Sol·licitud de Dades actualitzada amb èxit i correu electrònic enviat al client.',
                'delete-success'              => 'Sol·licitud de Dades eliminada amb èxit.',
                'attribute-reason-error'      => 'No es pot eliminar.',
                'update-success-unsent-email' => 'Sol·licitud de Dades actualitzada amb èxit però correu electrònic no enviat al client.',
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Crear Plantilla',
                    'title'      => 'Plantilles de Correu Electrònic',

                    'datagrid' => [
                        'active'   => 'Actiu',
                        'draft'    => 'Borrador',
                        'id'       => 'ID',
                        'inactive' => 'Inactiu',
                        'name'     => 'Nom',
                        'status'   => 'Estat',
                    ],
                ],

                'create' => [
                    'active'         => 'Actiu',
                    'back-btn'       => 'Endarrere',
                    'content'        => 'Contingut',
                    'create-success' => 'Plantilla de correu electrònic creada exitosament.',
                    'draft'          => 'Borrador',
                    'general'        => 'General',
                    'inactive'       => 'Inactiu',
                    'name'           => 'Nom',
                    'save-btn'       => 'Guardar Plantilla',
                    'select-status'  => 'Seleccionar Estat',
                    'status'         => 'Estat',
                    'title'          => 'Crear Plantilla',
                ],

                'edit' => [
                    'active'         => 'Actiu',
                    'back-btn'       => 'Endarrere',
                    'content'        => 'Contingut*',
                    'draft'          => 'Borrador',
                    'general'        => 'General',
                    'inactive'       => 'Inactivo',
                    'name'           => 'Nom',
                    'save-btn'       => 'Guardar Plantilla',
                    'status'         => 'Estat',
                    'title'          => 'Editar Plantilla',
                    'update-success' => 'Actualizat exitosament',
                ],

                'delete-failed'  => ':name Eliminació Fallida',
                'delete-success' => 'Plantilla eliminada exitosament',
                'email-template' => 'Plantilla de Correu Electrònic',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => 'Crear Campanya',
                    'title'      => 'Campanyes',

                    'datagrid' => [
                        'active'   => 'Actiu',
                        'delete'   => 'Eliminar',
                        'edit'     => 'Editar',
                        'id'       => 'ID',
                        'inactive' => 'Inactiu',
                        'name'     => 'Nom',
                        'status'   => 'Estat',
                        'subject'  => 'Assumpte',
                    ],
                ],

                'create' => [
                    'active'          => 'Actiu',
                    'back-btn'        => 'Endarrere',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Grup de clients',
                    'email-template'  => 'Plantilla de correu electrònic',
                    'event'           => 'Esdeveniment',
                    'general'         => 'General',
                    'inactive'        => 'Inactiu',
                    'name'            => 'Nom',
                    'save-btn'        => 'Guardar campanya',
                    'select-channel'  => 'Seleccionar canal',
                    'select-event'    => 'Seleccionar esdeveniment',
                    'select-group'    => 'Seleccionar grup',
                    'select-status'   => 'Seleccionar estat',
                    'select-template' => 'Seleccionar plantilla',
                    'setting'         => 'Configuració',
                    'status'          => 'Estat',
                    'subject'         => 'Assumpte',
                    'title'           => 'Crear campanya',
                ],

                'edit' => [
                    'active'          => 'Actiu',
                    'audience'        => 'Audiència',
                    'back-btn'        => 'Endarrere',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Grup de clients',
                    'email-template'  => 'Plantilla de correu electrònic',
                    'event'           => 'Esdeveniment',
                    'general'         => 'General',
                    'inactive'        => 'Inactiu',
                    'name'            => 'Nom',
                    'save-btn'        => 'Guardar campanya',
                    'select-event'    => 'Seleccionar esdeveniment',
                    'select-status'   => 'Seleccionar estat',
                    'select-template' => 'Seleccionar plantilla',
                    'status'          => 'Estat',
                    'subject'         => 'Assumpte',
                    'title'           => 'Editar campanya',
                ],

                'create-success' => 'Campanya creada amb éxit.',
                'delete-failed'  => ':name Eliminació fallada',
                'delete-success' => 'Campanya eliminada amb éxit',
                'email-campaign' => 'Campanya por correu electrònic',
                'update-success' => 'Campanya actualizada amb éxit.',
            ],

            'events' => [
                'index'  => [
                    'create-btn' => 'Crear Esdeveniment',
                    'event'      => 'Esdeveniment',
                    'title'      => 'Esdeveniments',

                    'datagrid' => [
                        'actions' => 'Accions',
                        'date'    => 'Data',
                        'delete'  => 'Eliminar',
                        'edit'    => 'Editar',
                        'id'      => 'ID',
                        'name'    => 'Nom',
                    ],

                    'create' => [
                        'date'           => 'Data',
                        'delete-warning' => 'Estàs segur que vols realitzar aquesta acció?',
                        'description'    => 'Descripció',
                        'general'        => 'General',
                        'name'           => 'Nom',
                        'save-btn'       => 'Desar esdeveniment',
                        'success'        => 'Esdeveniments creats amb éxit',
                        'title'          => 'Crear esdeveniments',
                    ],

                    'edit'  => [
                        'success' => 'Esdeveniments Actualizats amd Éxit',
                        'title'   => 'Editar Esdeveniments',
                    ],
                ],

                'delete-failed'  => 'Eliminació de :name fallida',
                'delete-success' => 'Esdeveniments eliminats amb éxit',
                'edit-error'     => 'No es pot editar l\'esdeveniment',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Suscripcions al butlletí',

                    'datagrid' => [
                        'actions'    => 'Accions',
                        'delete'     => 'Eliminar',
                        'edit'       => 'Editar',
                        'email'      => 'Correu electrònic',
                        'false'      => 'Fals',
                        'id'         => 'ID',
                        'subscribed' => 'Subscrit',
                        'true'       => 'Veritable',
                    ],

                    'edit' => [
                        'back-btn'      => 'Endarrere',
                        'email'         => 'Correu electrònic',
                        'false'         => 'Fals',
                        'save-btn'      => 'Guardar subscriptor',
                        'subscribed'    => 'Subscrit',
                        'success'       => 'Subscripció al butlletí actualizada amb éxit',
                        'title'         => 'Editar suscriptor del butlletí',
                        'true'          => 'Veritable',
                        'update-failed' => 'No s\'ha actualitzat la suscripció al butlletí',
                    ],
                ],

                'delete-failed'  => 'Error en eliminar el subscriptor',
                'delete-success' => 'Subscriptor eliminat amb éxit',
                'delete-warning' => 'Estàs segur que vols realitzar aquesta acció?',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'Regles de la Cistella',
                'catalog-rule-title' => 'Regles de Catàleg',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Crear Regla de la Cistella',
                    'title'      => 'Regles de la Cistella',

                    'datagrid' => [
                        'active'      => 'Actiu',
                        'copy'        => 'Copiar',
                        'copy-of'     => ':valor',
                        'coupon-code' => 'Códi de Cupó',
                        'delete'      => 'Eliminar',
                        'draft'       => 'Borrador',
                        'edit'        => 'Editar',
                        'end'         => 'Fin',
                        'id'          => 'ID',
                        'inactive'    => 'Inactiu',
                        'name'        => 'Nom',
                        'priority'    => 'Prioritat',
                        'start'       => 'Inici',
                        'status'      => 'Estat',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Tipus d\'Acció',
                    'actions'                                   => 'Accions',
                    'add-condition'                             => 'Afegir Condició',
                    'additional'                                => 'Addicional',
                    'all-conditions-true'                       => 'Totes les Condicions Són Vertaderes',
                    'any-conditions-true'                       => 'Qualsevol Condició És Vertadera',
                    'apply-to-shipping'                         => 'Aplicar a l\'Enviament',
                    'attribute-family'                          => 'Família d\'Atributs',
                    'attribute-name-children-only'              => 'Nom de l\'Atribut Només per a Fills',
                    'attribute-name-parent-only'                => 'Nom de l\'Atribut Només per a Pares',
                    'auto-generate-coupon'                      => 'Generació Automàtica de Cupó',
                    'back-btn'                                  => 'Tornar',
                    'buy-x-get-y-free'                          => 'Comprar X i Obtenir Y Gratis',
                    'buy-x-quantity'                            => 'Comprar X Quantitat',
                    'cart-attribute'                            => 'Atribut del Carro',
                    'cart-item-attribute'                       => 'Atribut de l\'Article de la Cistella',
                    'categories'                                => 'Categories',
                    'channels'                                  => 'Canals',
                    'children-categories'                       => 'Categories Filles',
                    'choose-condition-to-add'                   => 'Escollir condició per afegir',
                    'condition-type'                            => 'Tipus de Condició',
                    'conditions'                                => 'Condicions',
                    'contain'                                   => 'Conté',
                    'contains'                                  => 'Conté',
                    'coupon-code'                               => 'Codi de Cupó',
                    'coupon-type'                               => 'Tipus de Cupó',
                    'create-success'                            => 'Regla del carro creada amb éxit',
                    'customer-groups'                           => 'Grups de Clients',
                    'description'                               => 'Descripció',
                    'discount-amount'                           => 'Quantitat de Descompte',
                    'does-not-contain'                          => 'No Conté',
                    'end-of-other-rules'                        => 'Fi d\'Altres Regles',
                    'equals-or-greater-than'                    => 'És Igual o Major Que',
                    'equals-or-less-than'                       => 'És Igual o Menor Que',
                    'fixed-amount'                              => 'Quantitat Fixada',
                    'fixed-amount-whole-cart'                   => 'Quantitat Fixada per a Tot el Carro',
                    'free-shipping'                             => 'Enviament Gratuït',
                    'from'                                      => 'Des de',
                    'general'                                   => 'General',
                    'greater-than'                              => 'Major Que',
                    'is-equal-to'                               => 'És Igual a',
                    'is-not-equal-to'                           => 'No És Igual a',
                    'less-than'                                 => 'Menor Que',
                    'marketing-time'                            => 'Temps de Màrqueting',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantitat Màxima Permesa per al Descompte',
                    'name'                                      => 'Nom',
                    'no'                                        => 'No',
                    'no-coupon'                                 => 'Sense Cupó',
                    'parent-categories'                         => 'Categories Pares',
                    'payment-method'                            => 'Mètode de Pagament',
                    'percentage-product-price'                  => 'Percentatge del Preu del Producte',
                    'price-in-cart'                             => 'Preu al Carro',
                    'priority'                                  => 'Prioritat',
                    'product-attribute'                         => 'Atribut del Producte',
                    'qty-in-cart'                               => 'Quantitat al Carro',
                    'save-btn'                                  => 'Guardar Regla del Carro',
                    'settings'                                  => 'Configuració',
                    'shipping-country'                          => 'País d\'Enviament',
                    'shipping-method'                           => 'Mètode d\'Enviament',
                    'shipping-postcode'                         => 'Codi Postal d\'Enviament',
                    'shipping-state'                            => 'Estat d\'Enviament',
                    'specific-coupon'                           => 'Cupó Específic',
                    'status'                                    => 'Estat',
                    'subtotal'                                  => 'Subtotal',
                    'title'                                     => 'Crear Regla del Carro',
                    'to'                                        => 'Fins a',
                    'total-items-qty'                           => 'Quantitat Total d\'Articles',
                    'total-weight'                              => 'Pes Total',
                    'uses-per-coupon'                           => 'Usos per Cupó',
                    'uses-per-customer'                         => 'Usos per Client',
                    'uses-per-customer-control-info'            => 'S\'utilitzarà només per a clients registrats.',
                    'yes'                                       => 'Sí',
                ],

                'edit' => [
                    'action-type'                               => 'Tipus d\'Acció',
                    'actions'                                   => 'Accions',
                    'add-condition'                             => 'Afegir Condició',
                    'additional'                                => 'Addicional',
                    'all-conditions-true'                       => 'Totes les Condicions Són Vertaderes',
                    'alphabetical'                              => 'Alfabètic',
                    'alphanumeric'                              => 'Alfanumèric',
                    'any-conditions-true'                       => 'Qualsevol Condició És Vertadera',
                    'apply-to-shipping'                         => 'Aplicar a l\'Enviament',
                    'attribute-family'                          => 'Família d\'Atributs',
                    'attribute-name-children-only'              => 'Nom de l\'Atribut Només per a Fills',
                    'attribute-name-parent-only'                => 'Nom de l\'Atribut Només per a Pares',
                    'auto-generate-coupon'                      => 'Generació Automàtica de Cupó',
                    'back-btn'                                  => 'Tornar',
                    'buy-x-get-y-free'                          => 'Comprar X i Obtenir Y Gratis',
                    'buy-x-quantity'                            => 'Comprar X Quantitat',
                    'cart-attribute'                            => 'Atribut de la Cistella',
                    'cart-item-attribute'                       => 'Atribut de l\'Article de la Cistella',
                    'categories'                                => 'Categories',
                    'channels'                                  => 'Canals',
                    'children-categories'                       => 'Categories Filles',
                    'choose-condition-to-add'                   => 'Escollir condició per afegir',
                    'code-format'                               => 'Format del Codi',
                    'code-prefix'                               => 'Prefix del Codi',
                    'code-suffix'                               => 'Sufix del Codi',
                    'condition-type'                            => 'Tipus de Condició',
                    'conditions'                                => 'Condicions',
                    'contain'                                   => 'Conté',
                    'contains'                                  => 'Conté',
                    'coupon-code'                               => 'Codi de Cupó',
                    'coupon-length'                             => 'Longitud del Cupó',
                    'coupon-qty'                                => 'Quantitat de Cupons',
                    'coupon-type'                               => 'Tipus de Cupó',
                    'customer-group'                            => 'Grup de Clients',
                    'customer-groups'                           => 'Grups de Clients',
                    'description'                               => 'Descripció',
                    'discount-amount'                           => 'Quantitat de Descompte',
                    'does-not-contain'                          => 'No Conté',
                    'end-of-other-rules'                        => 'Fi d\'Altres Reglas',
                    'equals-or-greater-than'                    => 'És Igual o Major Que',
                    'equals-or-less-than'                       => 'És Igual o Menor Que',
                    'fixed-amount'                              => 'Quantitat Fixada',
                    'fixed-amount-whole-cart'                   => 'Quantitat Fixada per a Tota la Cistella',
                    'free-shipping'                             => 'Enviament Gratuït',
                    'from'                                      => 'Des de',
                    'general'                                   => 'General',
                    'generate'                                  => 'Generar',
                    'greater-than'                              => 'Major Que',
                    'is-equal-to'                               => 'És Igual a',
                    'is-not-equal-to'                           => 'No És Igual a',
                    'less-than'                                 => 'Menor Que',
                    'marketing-time'                            => 'Temps de Màrqueting',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantitat Màxima Permesa per al Descompte',
                    'name'                                      => 'Nom',
                    'no'                                        => 'No',
                    'no-coupon'                                 => 'Sense Cupó',
                    'numeric'                                   => 'Numèric',
                    'parent-categories'                         => 'Categories Pares',
                    'payment-method'                            => 'Mètode de Pagament',
                    'percentage-product-price'                  => 'Percentatge del Preu del Producte',
                    'price-in-cart'                             => 'Preu al Carro',
                    'priority'                                  => 'Prioritat',
                    'product-attribute'                         => 'Atribut del Producte',
                    'qty-in-cart'                               => 'Quantitat a la Cistella',
                    'save-btn'                                  => 'Guardar Regla de la Cistella',
                    'settings'                                  => 'Configuració',
                    'shipping-country'                          => 'País d\'Enviament',
                    'shipping-method'                           => 'Mètode d\'Enviament',
                    'shipping-postcode'                         => 'Codi Postal d\'Enviament',
                    'shipping-state'                            => 'Estat d\'Enviament',
                    'specific-coupon'                           => 'Cupó Específic',
                    'status'                                    => 'Estat',
                    'subtotal'                                  => 'Subtotal',
                    'title'                                     => 'Editar Regla de la Cistella',
                    'to'                                        => 'Fins a',
                    'total-items-qty'                           => 'Quantitat Total d\'Articles',
                    'total-weight'                              => 'Pes Total',
                    'update-success'                            => 'Regla del carro actualitzada amb éxit',
                    'uses-per-coupon'                           => 'Usos per Cupó',
                    'uses-per-customer'                         => 'Usos per Client',
                    'uses-per-customer-control-info'            => 'S\'utilitzarà només per a clients registrats.',
                    'yes'                                       => 'Sí',
                ],

                'delete-failed'  => 'L\'eliminació de la Regla de la Cistella ha Fallat',
                'delete-success' => 'Regla de la Cistella Eliminada amb Èxit',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'Crear Regla del Catàleg',
                    'title'      => 'Regles del Catàleg',

                    'datagrid' => [
                        'active'   => 'Actiu',
                        'delete'   => 'Eliminar',
                        'edit'     => 'Editar',
                        'end'      => 'Fi',
                        'id'       => 'ID',
                        'inactive' => 'Inactiu',
                        'name'     => 'Nom',
                        'priority' => 'Prioritat',
                        'start'    => 'Inici',
                        'status'   => 'Estat',
                    ],
                ],

                'create' => [
                    'action-type'              => 'Tipus d\'Acció',
                    'actions'                  => 'Accions',
                    'add-condition'            => 'Afegir Condició',
                    'all-conditions-true'      => 'Totes les Condicions Són Vertaderes',
                    'any-conditions-true'      => 'Qualsevol Condició És Vertadera',
                    'attribute-family'         => 'Família d\'Atributs',
                    'back-btn'                 => 'Tornar',
                    'categories'               => 'Categories',
                    'channels'                 => 'Canals',
                    'choose-condition-to-add'  => 'Escollir Condició per Afegir',
                    'condition-type'           => 'Tipus de Condició',
                    'conditions'               => 'Condicions',
                    'contain'                  => 'Conté',
                    'contains'                 => 'Conté',
                    'customer-groups'          => 'Grups de Clients',
                    'description'              => 'Descripció',
                    'discount-amount'          => 'Quantitat de Descompte',
                    'does-not-contain'         => 'No Conté',
                    'end-other-rules'          => 'Finalitzar Altres Regles',
                    'equals-or-greater-than'   => 'És Igual o Major Que',
                    'equals-or-less-than'      => 'És Igual o Menor Que',
                    'fixed-amount'             => 'Quantitat Fixa',
                    'from'                     => 'Des de',
                    'general'                  => 'General',
                    'greater-than'             => 'Major Que',
                    'is-equal-to'              => 'És Igual a',
                    'is-not-equal-to'          => 'No És Igual a',
                    'less-than'                => 'Menor Que',
                    'marketing-time'           => 'Temps de Màrqueting',
                    'name'                     => 'Nom',
                    'no'                       => 'No',
                    'percentage-product-price' => 'Percentatge del Preu del Producte',
                    'priority'                 => 'Prioritat',
                    'product-attribute'        => 'Atribut del Producte',
                    'save-btn'                 => 'Desa Regla del Catàleg',
                    'settings'                 => 'Configuració',
                    'status'                   => 'Estat',
                    'title'                    => 'Crear Regla del Catàleg',
                    'to'                       => 'Fins a',
                    'yes'                      => 'Sí',
                ],

                'edit' => [
                    'action-type'              => 'Tipus d\'Acció',
                    'actions'                  => 'Accions',
                    'add-condition'            => 'Afegir Condició',
                    'all-conditions-true'      => 'Totes les Condicions Són Vertaderes',
                    'any-conditions-true'      => 'Qualsevol Condició És Vertadera',
                    'back-btn'                 => 'Tornar',
                    'categories'               => 'Categories',
                    'channels'                 => 'Canals',
                    'choose-condition-to-add'  => 'Escollir Condició per Afegir',
                    'condition-type'           => 'Tipus de Condició',
                    'conditions'               => 'Condicions',
                    'contain'                  => 'Conté',
                    'contains'                 => 'Conté',
                    'customer-groups'          => 'Grups de Clients',
                    'description'              => 'Descripció',
                    'discount-amount'          => 'Quantitat de Descompte',
                    'does-not-contain'         => 'No Conté',
                    'end-other-rules'          => 'Finalitzar Altres Regles',
                    'equals-or-greater-than'   => 'És Igual o Més Gran Que',
                    'equals-or-less-than'      => 'És Igual o Menys Gran Que',
                    'fixed-amount'             => 'Quantitat Fixa',
                    'from'                     => 'Des de',
                    'general'                  => 'General',
                    'greater-than'             => 'Major Que',
                    'is-equal-to'              => 'És Igual a',
                    'is-not-equal-to'          => 'No És Igual a',
                    'less-than'                => 'Menor Que',
                    'marketing-time'           => 'Temps de Màrqueting',
                    'name'                     => 'Nom',
                    'no'                       => 'No',
                    'percentage-product-price' => 'Percentatge del Preu del Producte',
                    'priority'                 => 'Prioritat',
                    'product-attribute'        => 'Atribut del Producte',
                    'save-btn'                 => 'Desa Regla del Catàleg',
                    'settings'                 => 'Configuració',
                    'status'                   => 'Estat',
                    'title'                    => 'Editar Regla del Catàleg',
                    'to'                       => 'Fins a',
                    'yes'                      => 'Sí',
                ],

                'create-success' => 'Regla del Catàleg creada amb éxit',
                'delete-success' => 'Regla del Catàleg eliminada amb éxit',
                'update-success' => 'Regla del Catàleg actualitzada amb éxit',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'No es pot eliminar la regla de la cistella',
                'delete-success'              => 'Cupó de regla de la cistella eliminada amb éxit',
                'mass-delete-success'         => 'Elements seleccionats eliminats amb éxit',
                'success'                     => ':name creat amb éxit',

                'datagrid' => [
                    'coupon-code'     => 'Códi de cupó',
                    'created-date'    => 'Data de creació',
                    'delete'          => 'Eliminar',
                    'expiration-date' => 'Fecha de caducitat',
                    'id'              => 'ID',
                    'times-used'      => 'Vegades utilizat',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Crear terme de cerca',
                    'title'      => 'Termes de cerca',

                    'datagrid' => [
                        'actions'             => 'Accions',
                        'channel'             => 'Canal',
                        'delete'              => 'Eliminar',
                        'edit'                => 'Editar',
                        'id'                  => 'ID',
                        'locale'              => 'Localització',
                        'mass-delete-success' => 'Termes de cerca seleccionats eliminats amb éxit',
                        'redirect-url'        => 'URL de redirecció',
                        'results'             => 'Resultats',
                        'search-query'        => 'Consulta de cerca',
                        'uses'                => 'Usos',
                    ],

                    'create' => [
                        'channel'        => 'Canal',
                        'delete-warning' => 'Estàs segur que vols realitzar aquesta acció?',
                        'locale'         => 'Localització',
                        'redirect-url'   => 'URL de redirecció',
                        'results'        => 'Resultats',
                        'save-btn'       => 'Desar terme de cerca',
                        'search-query'   => 'Consulta de cerca',
                        'success'        => 'Terme de cerca creat amb éxit',
                        'title'          => 'Crear terme de cerca',
                        'uses'           => 'Usos',
                    ],

                    'edit' => [
                        'delete-success' => 'Terme de cerca eliminat amb éxit',
                        'success'        => 'Terme de cerca actualitzat amb éxit',
                        'title'          => 'Editar terme de cerca',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Crear Sinònim de Cerca',
                    'title'      => 'Sinònims de Cerca',

                    'datagrid' => [
                        'actions'             => 'Accions',
                        'delete'              => 'Eliminar',
                        'edit'                => 'Editar',
                        'id'                  => 'ID',
                        'mass-delete-success' => 'Sinònims de Cerca Seleccionats Eliminats amb Éxit',
                        'name'                => 'Nom',
                        'terms'               => 'Termes',
                    ],

                    'create' => [
                        'delete-warning' => 'Estàs segur que vols realitzar aquesta acció?',
                        'name'           => 'Nom',
                        'save-btn'       => 'Guardar Sinònim de Cerca',
                        'success'        => 'Sinònim de Cerca creat amb éxit',
                        'terms'          => 'Termes',
                        'terms-info'     => 'Introdueix els sinònims com una llista separada per comes, per exemple, "sabates, calçat". Això amplia la cerca per incloure tots els termes.',
                        'title'          => 'Crear Sinònim de Cerca',
                    ],

                    'edit' => [
                        'delete-success' => 'Sinònim de Cerca eliminat amb éxit',
                        'success'        => 'Sinònim de Cerca actualitzat amb éxit',
                        'title'          => 'Editar Sinònim de Cerca',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Crear Mapa del lloc',
                    'sitemap'    => 'Mapa del lloc',
                    'title'      => 'Mapes del lloc',

                    'datagrid' => [
                        'actions'         => 'Accions',
                        'delete'          => 'Eliminar',
                        'edit'            => 'Editar',
                        'file-name'       => 'Nom de l\'arxiu',
                        'id'              => 'ID',
                        'link-for-google' => 'Enllaç per a Google',
                        'path'            => 'Ruta',
                    ],

                    'create' => [
                        'delete-warning' => 'Estàs segur que vols realitzar aquesta acció?',
                        'file-name'      => 'Nom del fitxer',
                        'file-name-info' => 'Exemple: sitemap.xml',
                        'path'           => 'Ruta',
                        'path-info'      => 'Exemple: "/sitemap/" o "/" per a la ruta base',
                        'save-btn'       => 'Desar Mapa del lloc',
                        'success'        => 'Mapa del lloc creat amb éxit',
                        'title'          => 'Crear Mapa del lloc',

                        'edit' => [
                            'delete-success' => 'Mapa del lloc eliminat amb éxit',
                            'success'        => 'Mapa del lloc actualitzat amb éxit',
                            'title'          => 'Editar Mapa del lloc',
                        ],
                    ],

                    'edit' => [
                        'back-btn'       => 'Enrere',
                        'file-name'      => 'Nom del fitxer',
                        'file-name-info' => 'Exemple: sitemap.xml',
                        'general'        => 'General',
                        'path'           => 'Ruta',
                        'path-info'      => 'Exemple: "/sitemap/" o "/" per a la ruta base',
                        'save-btn'       => 'Desar Mapa del lloc',
                    ],

                    'delete-failed' => ':name Eliminació fallada',
                ],

                'url-rewrites' => [
                    'index' => [
                        'create-btn' => 'Crear reescritura d\'URL',
                        'title'      => 'Reescritures d\'URL',

                        'datagrid' => [
                            'actions'             => 'Accions',
                            'category'            => 'Categoria',
                            'cms-page'            => 'Pàgina de CMS',
                            'delete'              => 'Eliminar',
                            'edit'                => 'Editar',
                            'for'                 => 'Per a',
                            'id'                  => 'ID',
                            'locale'              => 'Localització',
                            'mass-delete-success' => 'Reescritures d\'URL seleccionades eliminades correctament',
                            'permanent-redirect'  => 'Permanent (301)',
                            'product'             => 'Producte',
                            'redirect-type'       => 'Tipus de redirecció',
                            'request-path'        => 'Ruta de sol·licitud',
                            'target-path'         => 'Ruta de destinació',
                            'temporary-redirect'  => 'Temporal (302)',
                        ],

                        'create' => [
                            'category'           => 'Categoria',
                            'cms-page'           => 'Pàgina de CMS',
                            'delete-warning'     => 'Esteu segur que voleu realitzar aquesta acció?',
                            'for'                => 'Per a',
                            'locale'             => 'Localització',
                            'permanent-redirect' => 'Permanent (301)',
                            'product'            => 'Producte',
                            'redirect-type'      => 'Tipus de redirecció',
                            'request-path'       => 'Ruta de sol·licitud',
                            'save-btn'           => 'Desar reescriptura de URL',
                            'success'            => 'Reescriptura de URL creada correctament',
                            'target-path'        => 'Ruta de destinació',
                            'temporary-redirect' => 'Temporal (302)',
                            'title'              => 'Crear reescriptura de URL',
                        ],

                        'edit' => [
                            'delete-success' => 'Reescriptura de URL eliminada correctament',
                            'success'        => 'Reescriptura de URL actualitzada correctament',
                            'title'          => 'Editar reescriptura de URL',
                        ],
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'El :name ja ha estat pres.',
            'channel'       => 'Canal',
            'create-btn'    => 'Crear Pàgina',
            'language'      => 'Idioma',
            'title'         => 'Pàgines',

            'datagrid' => [
                'channel'             => 'Canal',
                'delete'              => 'Eliminar',
                'edit'                => 'Editar',
                'id'                  => 'ID',
                'mass-delete-success' => 'Dades seleccionades eliminades correctament',
                'page-title'          => 'Títol de la pàgina',
                'url-key'             => 'Clau de URL',
                'view'                => 'Veure',
            ],
        ],

        'create' => [
            'channels'         => 'Canals',
            'content'          => 'Contingut',
            'description'      => 'Descripció',
            'general'          => 'General',
            'meta-description' => 'Meta Descripció',
            'meta-keywords'    => 'Meta Paraules Clau',
            'meta-title'       => 'Meta Títol',
            'page-title'       => 'Títol',
            'save-btn'         => 'Desar Pàgina',
            'seo'              => 'SEO',
            'title'            => 'Crear Pàgina',
            'url-key'          => 'Clau d\'URL',
        ],

        'edit' => [
            'back-btn'         => 'Tornar',
            'channels'         => 'Canals',
            'content'          => 'Contingut',
            'description'      => 'Descripció',
            'general'          => 'General',
            'meta-description' => 'Meta Descripció',
            'meta-keywords'    => 'Meta Paraules Clau',
            'meta-title'       => 'Meta Títol',
            'page-title'       => 'Títol de la Pàgina',
            'preview-btn'      => 'Vista Prèvia de la Pàgina',
            'save-btn'         => 'Desar Pàgina',
            'seo'              => 'SEO',
            'title'            => 'Editar Pàgina',
            'url-key'          => 'Clau de URL',
        ],

        'create-success' => 'CMS creat correctament.',
        'delete-success' => 'CMS eliminat correctament.',
        'no-resource'    => 'El recurs no existeix.',
        'update-success' => 'CMS actualitzat correctament.',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'Crear Idioma',
                'locale'     => 'Idioma',
                'logo-size'  => 'La resolució de la imatge ha de ser de 24px x 16px',
                'title'      => 'Idiomes',

                'datagrid' => [
                    'actions'   => 'Accions',
                    'code'      => 'Còdi',
                    'delete'    => 'Eliminar',
                    'direction' => 'Direcció',
                    'edit'      => 'Editar',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Nom',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Codi',
                    'direction'        => 'Direcció',
                    'locale-logo'      => 'Logotip de l\'Idioma',
                    'name'             => 'Nom',
                    'save-btn'         => 'Desar Idioma',
                    'select-direction' => 'Seleccionar direcció',
                    'title'            => 'Crear Idioma',
                ],

                'edit' => [
                    'title'   => 'Editar Idioma',
                ],

                'create-success'    => 'Idioma creat amb éxit.',
                'delete-failed'     => 'Error en eliminar l\'idioma',
                'delete-success'    => 'Idioma eliminat amb éxit.',
                'delete-warning'    => 'Estàs segur que vols realitzar aquesta acció?',
                'last-delete-error' => 'Es requereix almenys un idioma.',
                'update-success'    => 'Idioma actualitzat amb éxit.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Crear Moneda',
                'currency'   => 'Moneda',
                'title'      => 'Monedas',

                'datagrid' => [
                    'actions'        => 'Accions',
                    'code'           => 'Còdi',
                    'delete'         => 'Eliminar',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'method-error'   => 'Error! S\'ha detectat un mètode incorrecte, si us plau verifica la configuració de l\'acció massiva',
                    'name'           => 'Nom',
                    'no-resource'    => 'El recurs proporcionat no és suficient per a l\'acció',
                    'partial-action' => 'Algunes accions no s\'han realitzat a causa de restriccions del sistema en :resource',
                    'update-success' => ':resource seleccionades s\'han actualitzat correctament',
                ],

                'create' => [
                    'code'                   => 'Codi',
                    'create-btn'             => 'Crear Moneda',
                    'currency-position'      => 'Posició de la Moneda',
                    'decimal'                => 'Decimal',
                    'decimal-separator'      => 'Separador Decimal',
                    'decimal-separator-note' => 'El camp :attribute només pot acceptar els caràcters coma (,) i punt (.)',
                    'delete-warning'         => 'Estàs segur que vols realitzar aquesta acció?',
                    'general'                => 'General',
                    'group-separator'        => 'Separador de Grups',
                    'group-separator-note'   => 'El camp :attribute només pot acceptar els caràcters coma (,), punt (.), apòstrof (\') i espai ( )',
                    'name'                   => 'Nom',
                    'save-btn'               => 'Desa la Moneda',
                    'symbol'                 => 'Símbol',
                    'title'                  => 'Crear Nova Moneda',
                ],

                'edit' => [
                    'title' => 'Editar Moneda',
                ],

                'create-success'    => 'Moneda creada amb éxit.',
                'delete-failed'     => 'Error en eliminar la Moneda',
                'delete-success'    => 'Moneda eliminada amb éxit.',
                'last-delete-error' => 'Es requereix almenys una Moneda.',
                'update-success'    => 'Moneda actualitzada amb éxit.',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Acció',
                    'allowed-errors'      => 'Errors Permesos',
                    'back-btn'            => 'Enrere',
                    'create-update'       => 'Crear/Actualitzar',
                    'delete'              => 'Eliminar',
                    'download-sample'     => 'Descarregar Mostra',
                    'field-separator'     => 'Separador de Camps',
                    'file-info-example'   => 'Per exemple, en cas d\'imatges de productes, els arxius s\'han de col·locar a /project-root/storage/app/import/product-images',
                    'file-info'           => 'Utilitzar la ruta relativa a /project-root/storage/app/import, per exemple, product-images, import-images.',
                    'file'                => 'Arxiu',
                    'general'             => 'General',
                    'images-directory'    => 'Ruta del Directori d\'Imatges',
                    'process-in-queue'    => 'Processar en Cua',
                    'results'             => 'Resultats',
                    'save-btn'            => 'Desar Importació',
                    'settings'            => 'Configuracions',
                    'skip-errors'         => 'Saltar Errors',
                    'stop-on-errors'      => 'Aturar en Errors',
                    'title'               => 'Crear Importació',
                    'type'                => 'Tipus',
                    'validation-strategy' => 'Estratègia de Validació',
                ],

                'edit' => [
                    'action'              => 'Acció',
                    'allowed-errors'      => 'Errors Permesos',
                    'back-btn'            => 'Enrere',
                    'create-update'       => 'Crear/Actualitzar',
                    'current-file'        => 'Arxiu Pujat Actual',
                    'delete'              => 'Eliminar',
                    'download-sample'     => 'Descarregar Mostra',
                    'field-separator'     => 'Separador de Camps',
                    'file-info-example'   => 'Per exemple, en cas d\'imatges de productes, els arxius s\'han de col·locar a /project-root/storage/import/app/product-images.',
                    'file-info'           => 'Utilitzar la ruta relativa a /project-root/storage/app/import, per exemple, product-images, import-images.',
                    'file'                => 'Arxiu',
                    'general'             => 'General',
                    'images-directory'    => 'Ruta del Directori d\'Imatges',
                    'process-in-queue'    => 'Processar en Cua',
                    'results'             => 'Resultats',
                    'save-btn'            => 'Desar Importació',
                    'settings'            => 'Configuracions',
                    'skip-errors'         => 'Saltar Errors',
                    'stop-on-errors'      => 'Aturar en Errors',
                    'title'               => 'Editar Importació',
                    'type'                => 'Tipus',
                    'validation-strategy' => 'Estratègia de Validació',
                ],

                'index' => [
                    'button-title' => 'Crear Importació',
                    'title'        => 'Importacions',

                    'datagrid' => [
                        'actions'       => 'Accions',
                        'completed-at'  => 'Completat el',
                        'created'       => 'Creat',
                        'delete'        => 'Eliminar',
                        'deleted'       => 'Eliminat',
                        'edit'          => 'Editar',
                        'error-file'    => 'Arxiu d\'Error',
                        'id'            => 'ID',
                        'started-at'    => 'Iniciat el',
                        'state'         => 'Estat',
                        'summary'       => 'Resum',
                        'updated'       => 'Actualitzat',
                        'uploaded-file' => 'Arxiu Pujat',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Tornar',
                    'completed-batches'       => 'Total de Lots Completats:',
                    'download-error-report'   => 'Descarregar Informe Complet',
                    'edit-btn'                => 'Editar',
                    'imported-info'           => 'Enhorabona! La teva importació ha estat exitosa.',
                    'importing-info'          => 'Importació en procés',
                    'indexing-info'           => 'Indexació de Recursos (Preu, Inventari i Cerca Elàstica) en Progrés',
                    'linking-info'            => 'Vinculació de Recursos en Progrés',
                    'progress'                => 'Progrés:',
                    'title'                   => 'Importació',
                    'total-batches'           => 'Total de Lots:',
                    'total-created'           => 'Total de Registres Creats:',
                    'total-deleted'           => 'Total de Registres Eliminats:',
                    'total-errors'            => 'Total d\'Errors:',
                    'total-invalid-rows'      => 'Total de Files Invàlides:',
                    'total-rows-processed'    => 'Total de Files Processades:',
                    'total-updated'           => 'Total de Registres Actualitzats:',
                    'validate-info'           => 'Feu clic a Validar Dades per verificar la teva importació.',
                    'validate'                => 'Validar',
                    'validating-info'         => 'Les dades estan sent llegides i validades',
                    'validation-failed-info'  => 'La teva importació no és vàlida. Si us plau, corregeix els següents errors i torna a intentar-ho.',
                    'validation-success-info' => 'La teva importació és vàlida. Feu clic a Importar per iniciar el procés d\'importació',
                ],

                'create-success'    => 'Importació creada correctament.',
                'delete-failed'     => 'Error inesperat en eliminar la importació.',
                'delete-success'    => 'Importació eliminada correctament.',
                'not-valid'         => 'La importació no és vàlida',
                'nothing-to-import' => 'No hi ha recursos per importar.',
                'setup-queue-error' => 'Si us plau, canvia el teu controlador de cua a "database" o "redis" per iniciar el procés d\'importació.',
                'update-success'    => 'Importació actualitzada correctament.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Crear Tipus de Canvi',
                'exchange-rate' => 'Tipus de Canvi',
                'title'         => 'Tipus de Canvi',
                'update-rates'  => 'Actualitzar Tipus de Canvi',

                'create' => [
                    'delete-warning'         => 'Estàs segur que vols realitzar aquesta acció?',
                    'rate'                   => 'Taxa',
                    'save-btn'               => 'Desar Tipus de Canvi',
                    'select-target-currency' => 'Seleccionar moneda objectiu',
                    'source-currency'        => 'Moneda Font',
                    'target-currency'        => 'Moneda Objectiu',
                    'title'                  => 'Crear Tipus de Canvi',
                ],

                'edit' => [
                    'title'   => 'Editar Tipus de Canvi',
                ],

                'datagrid' => [
                    'actions'       => 'Accions',
                    'currency-name' => 'Nom de la Moneda',
                    'delete'        => 'Eliminar',
                    'edit'          => 'Editar',
                    'exchange-rate' => 'Tipus de Canvi',
                    'id'            => 'ID',
                ],

                'create-success' => 'Tipus de Canvi Creat Exitosament',
                'delete-error'   => 'Error en Eliminar el Tipus de Canvi',
                'delete-success' => 'Tipus de Canvi Eliminat Exitosament',
                'update-success' => 'Tipus de Canvi Actualitzat Exitosament',
            ],
        ],

        'inventory-sources' => [
            'index'  => [
                'create-btn' => 'Crear font d\'inventari',
                'title'      => 'Fonts d\'Inventari',

                'datagrid' => [
                    'active'   => 'Actiu',
                    'code'     => 'Còdi',
                    'delete'   => 'Eliminar',
                    'edit'     => 'Editar',
                    'id'       => 'ID',
                    'inactive' => 'Inactiu',
                    'name'     => 'Nom',
                    'priority' => 'Prioritat',
                    'status'   => 'Estat',
                ],
            ],

            'create' => [
                'add-title'      => 'Afegir Font d\'Inventari',
                'address'        => 'Adreça de la Font',
                'back-btn'       => 'Tornar',
                'city'           => 'Ciutat',
                'code'           => 'Codi',
                'contact-email'  => 'Correu electrònic',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informació de Contacte',
                'contact-name'   => 'Nom de contacte',
                'contact-number' => 'Número de contacte',
                'country'        => 'País',
                'description'    => 'Descripció',
                'general'        => 'General',
                'latitude'       => 'Latitud',
                'longitude'      => 'Longitud',
                'name'           => 'Nom',
                'postcode'       => 'Codi Postal',
                'priority'       => 'Prioritat',
                'save-btn'       => 'Desar Font d\'Inventari',
                'select-country' => 'Selecciona el País',
                'select-state'   => 'Selecciona l\'Estat',
                'settings'       => 'Configuració',
                'state'          => 'Estat',
                'status'         => 'Estat',
                'street'         => 'Carrer',
                'title'          => 'Fonts d\'Inventari',
            ],

            'edit' => [
                'back-btn'          => 'Tornar',
                'city'              => 'Ciutat',
                'code'              => 'Codi',
                'contact-email'     => 'Correu electrònic',
                'contact-fax'       => 'Fax',
                'contact-info'      => 'Informació de Contacte',
                'contact-name'      => 'Nom de contacte',
                'contact-number'    => 'Número de contacte',
                'country'           => 'País',
                'description'       => 'Descripció',
                'general'           => 'General',
                'latitude'          => 'Latitud',
                'longitude'         => 'Longitud',
                'name'              => 'Nom',
                'postcode'          => 'Codi Postal',
                'priority'          => 'Prioritat',
                'save-btn'          => 'Desar Fonts d\'Inventari',
                'select-country'    => 'Selecciona el País',
                'select-state'      => 'Selecciona l\'Estat',
                'settings'          => 'Configuració',
                'source-address'    => 'Adreça de la Font',
                'state'             => 'Estat',
                'status'            => 'Estat',
                'street'            => 'Carrer',
                'title'             => 'Editar Fonts d\'Inventari',
            ],

            'create-success'    => 'Font d\'Inventari creada amb éxit',
            'delete-failed'     => 'Error en eliminar les Fonts d\'Inventari',
            'delete-success'    => 'Fonts d\'Inventari eliminades amb éxit',
            'last-delete-error' => 'No es poden eliminar les últimes Fonts d\'Inventari',
            'update-success'    => 'Fonts d\'Inventari actualitzades amb éxit',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => 'Estàs segur que vols eliminar?',
                    'tax-category'   => 'Categoria d\'Impostos',
                    'title'          => 'Categories d\'Impostos',

                    'datagrid' => [
                        'actions' => 'Accions',
                        'code'    => 'Codi',
                        'delete'  => 'Eliminar',
                        'edit'    => 'Editar',
                        'id'      => 'ID',
                        'name'    => 'Nom',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Afegir Taxes d\'Impostos',
                        'code'          => 'Codi',
                        'description'   => 'Descripció',
                        'empty-text'    => 'Les Taxes d\'Impostos no estan disponibles, crea noves Taxes d\'Impostos.',
                        'general'       => 'Categoria d\'Impostos',
                        'name'          => 'Nom',
                        'save-btn'      => 'Desar Categoria d\'Impostos',
                        'select'        => 'Seleccionar',
                        'tax-rates'     => 'Taxes d\'Impostos',
                        'title'         => 'Crear Categoria d\'Impostos',
                    ],

                    'edit' => [
                        'title' => 'Editar Categories d\'Impostos',
                    ],

                    'can-not-delete' => 'No es poden eliminar les categories assignades a les taxes d\'impostos.',
                    'create-success' => 'Nova Categoria d\'Impostos Creat',
                    'delete-failed'  => 'Error en Eliminar la Categoria d\'Impostos',
                    'delete-success' => 'Categoria d\'Impostos Eliminada Correctament',
                    'update-success' => 'Categoria d\'Impostos Actualitzada Correctament',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => 'Crear taxa d\'impostos',
                    'tax-rate'     => 'Taxa d\'Impostos',
                    'title'        => 'Taxes d\'Impostos',

                    'datagrid' => [
                        'country'    => 'País',
                        'delete'     => 'Eliminar',
                        'edit'       => 'Editar',
                        'id'         => 'ID',
                        'identifier' => 'Identificador',
                        'state'      => 'Estat',
                        'tax-rate'   => 'Taxa d\'Impostos',
                        'zip-code'   => 'Codi Postal',
                        'zip-from'   => 'Des de Codi Postal',
                        'zip-to'     => 'Fins a Codi Postal',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Tornar',
                    'country'        => 'País',
                    'general'        => 'General',
                    'identifier'     => 'Identificador',
                    'is-zip'         => 'Habilitar Rango de Codi Postal',
                    'save-btn'       => 'Desar la Taxa d\'Impostos',
                    'select-country' => 'Seleccionar País',
                    'select-state'   => 'Seleccionar Estat',
                    'settings'       => 'Configuració',
                    'state'          => 'Estat',
                    'tax-rate'       => 'Taxa',
                    'title'          => 'Crear Taxa d\'Impostos',
                    'zip-code'       => 'Codi Postal',
                    'zip-from'       => 'Des de Codi Postal',
                    'zip-to'         => 'Fins a Codi Postal',
                ],

                'edit' => [
                    'back-btn'       => 'Tornar',
                    'country'        => 'País',
                    'identifier'     => 'Identificador',
                    'save-btn'       => 'Desar la Taxa d\'Impostos',
                    'select-country' => 'Seleccionar País',
                    'select-state'   => 'Seleccionar Estat',
                    'settings'       => 'Configuració',
                    'state'          => 'Estat',
                    'tax-rate'       => 'Taxa',
                    'title'          => 'Editar Taxa d\'Impostos',
                    'zip-code'       => 'Codi Postal',
                    'zip-from'       => 'Des de Codi Postal',
                    'zip-to'         => 'Fins a Codi Postal',
                ],

                'create-success' => 'Taxa d\'Impostos creada amb éxit.',
                'delete-failed'  => 'Error en eliminar la Taxa d\'Impostos',
                'delete-success' => 'Taxa d\'Impostos eliminada amb éxit',
                'update-success' => 'Taxa d\'Impostos actualitzada amb éxit',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Crear Canal',
                'delete-failed'     => 'Error en eliminar el Canal',
                'delete-success'    => 'Canal eliminat amb éxit.',
                'last-delete-error' => 'Error en eliminar l\'últim Canal.',
                'title'             => 'Canals',

                'datagrid' => [
                    'code'      => 'Codi',
                    'delete'    => 'Eliminar',
                    'edit'      => 'Editar',
                    'host-name' => 'Nom del Host',
                    'id'        => 'ID',
                    'name'      => 'Nom',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'IPs Permeses',
                'cancel'                  => 'Tornar',
                'code'                    => 'Codi',
                'create-success'          => 'Canal creat correctament.',
                'currencies'              => 'Monedes',
                'currencies-and-locales'  => 'Monedes i Localitats',
                'default-currency'        => 'Moneda per defecte',
                'default-locale'          => 'Localitat per defecte',
                'description'             => 'Descripció',
                'design'                  => 'Disseny',
                'favicon'                 => 'Favicon',
                'favicon-size'            => 'La resolució de la imatge ha de ser de 16px X 16px',
                'general'                 => 'General',
                'hostname'                => 'Nom del Host',
                'hostname-placeholder'    => 'https://www.example.com (No afegir barra al final.)',
                'inventory-sources'       => 'Fonts d\'Inventari',
                'last-delete-error'       => 'Es requereix almenys un Canal.',
                'locales'                 => 'Localitats',
                'logo'                    => 'Logo',
                'logo-size'               => 'La resolució de la imatge ha de ser de 192px X 50px',
                'maintenance-mode-text'   => 'Missatge',
                'name'                    => 'Nom',
                'root-category'           => 'Categoria Arrel',
                'save-btn'                => 'Desar Canal',
                'select-default-currency' => 'Seleccionar moneda per defecte',
                'select-default-locale'   => 'Seleccionar idioma per defecte',
                'select-root-category'    => 'Seleccionar categoria arrel',
                'select-theme'            => 'Seleccionar tema',
                'seo'                     => 'SEO de la pàgina d\'inici',
                'seo-description'         => 'Meta descripció',
                'seo-keywords'            => 'Meta paraules clau',
                'seo-title'               => 'Meta títol',
                'settings'                => 'Configuració',
                'status'                  => 'Estat',
                'theme'                   => 'Tema',
                'title'                   => 'Crear Canal',
            ],

            'edit' => [
                'allowed-ips'            => 'IPs Permeses',
                'back-btn'               => 'Tornar',
                'code'                   => 'Codi',
                'currencies'             => 'Monedes',
                'currencies-and-locales' => 'Monedes i Localitats',
                'default-currency'       => 'Moneda per defecte',
                'default-locale'         => 'Localitat per defecte',
                'description'            => 'Descripció',
                'design'                 => 'Disseny',
                'favicon'                => 'Favicon',
                'favicon-size'           => 'La resolució de la imatge ha de ser de 16px X 16px',
                'general'                => 'General',
                'hostname'               => 'Nom del Host',
                'hostname-placeholder'   => 'https://www.example.com (No afegir barra al final.)',
                'inventory-sources'      => 'Fonts d\'Inventari',
                'last-delete-error'      => 'Es requereix almenys un Canal.',
                'locales'                => 'Localitats',
                'logo'                   => 'Logo',
                'logo-size'              => 'La resolució de la imatge ha de ser de 192px X 50px',
                'maintenance-mode'       => 'Mode de manteniment',
                'maintenance-mode-text'  => 'Missatge',
                'name'                   => 'Nom',
                'root-category'          => 'Categoria Arrel',
                'save-btn'               => 'Desar Canal',
                'seo'                    => 'SEO de la pàgina d\'inici',
                'seo-description'        => 'Meta descripció',
                'seo-keywords'           => 'Meta paraules clau',
                'seo-title'              => 'Meta títol',
                'status'                 => 'Estat',
                'theme'                  => 'Tema',
                'title'                  => 'Editar Canal',
                'update-success'         => 'Canal actualitzat correctament',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Administrador',
                'title' => 'Usuaris',
                'user'  => 'Usuari',

                'create' => [
                    'confirm-password'  => 'Confirmar Contrasenya',
                    'email'             => 'Email',
                    'name'              => 'Nom',
                    'password'          => 'Contrasenya',
                    'role'              => 'Rol',
                    'save-btn'          => 'Desar Usuari',
                    'status'            => 'Estat',
                    'title'             => 'Crear Usuari',
                    'upload-image-info' => 'Puja una imatge de perfil (110px X 110px) en format PNG o JPG',
                ],

                'datagrid' => [
                    'actions'  => 'Accions',
                    'active'   => 'Actiu',
                    'delete'   => 'Borrar',
                    'edit'     => 'Editar',
                    'email'    => 'Email',
                    'id'       => 'ID',
                    'inactive' => 'Inactiu',
                    'name'     => 'Nom',
                    'role'     => 'Rol',
                    'status'   => 'Estat',
                ],

                'edit' => [
                    'title' => 'Editar Usuari',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Tornar',
                'confirm-password' => 'Confirmar Contrasenya',
                'email'            => 'Email',
                'general'          => 'General',
                'name'             => 'Nom',
                'password'         => 'Contrasenya',
                'role'             => 'Rol',
                'save-btn'         => 'Desar Usuari',
                'status'           => 'Estat',
                'title'            => 'Editar Usuari',
            ],

            'activate-warning'   => 'El teu compte encara no ha estat activat, si us plau, contacta amb l\'administrador.',
            'cannot-change'      => 'No es pot canviar l\'usuari.',
            'create-success'     => 'Usuari creat amb éxit.',
            'delete-failed'      => 'Error en eliminar l\'usuari.',
            'delete-self-error'  => 'No pots suprimir el teu propi compte.',
            'delete-success'     => 'Usuari eliminat amb éxit.',
            'delete-warning'     => 'Estàs segur que vols realitzar aquesta acció?',
            'incorrect-password' => 'Contrasenya incorrecta',
            'last-delete-error'  => 'Error en eliminar l\'últim usuari.',
            'login-error'        => 'Si us plau, verifica les teves credencials i intenta-ho de nou.',
            'update-success'     => 'Usuari actualitzat amb éxit.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Crear Rol',
                'title'      => 'Rols',

                'datagrid' => [
                    'all'               => 'Tots',
                    'custom'            => 'Personalitzat',
                    'delete'            => 'Eliminar',
                    'edit'              => 'Editar',
                    'id'                => 'Id',
                    'name'              => 'Nom',
                    'permission-type'   => 'Tipus de Permís',
                ],
            ],

            'create' => [
                'access-control' => 'Control d\'Accés',
                'all'            => 'Tots',
                'back-btn'       => 'Tornar',
                'custom'         => 'Personalitzat',
                'description'    => 'Descripció',
                'general'        => 'General',
                'name'           => 'Nom',
                'permissions'    => 'Permisos',
                'save-btn'       => 'Desar Rol',
                'title'          => 'Crear Rol',
            ],

            'edit' => [
                'access-control' => 'Control d\'Accés',
                'all'            => 'Tots',
                'back-btn'       => 'Tornar',
                'custom'         => 'Personalitzat',
                'description'    => 'Descripció',
                'general'        => 'General',
                'name'           => 'Nom',
                'permissions'    => 'Permisos',
                'save-btn'       => 'Desar Rol',
                'title'          => 'Editar Rol',
            ],

            'being-used'        => 'El Rol ja està en ús a l\'Usuari de l\'Administrador',
            'create-success'    => 'Rols creats amb éxit',
            'delete-failed'     => 'Error en eliminar el Rol',
            'delete-success'    => 'Rol eliminat amb éxit',
            'last-delete-error' => 'No es pot eliminar l\'últim Rol',
            'update-success'    => 'Rol actualitzat amb éxit',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Crear Tema',
                'title'      => 'Temes',

                'datagrid' => [
                    'active'        => 'Actiu',
                    'channel_name'  => 'Nom del Canal',
                    'change-status' => 'Canviar estat',
                    'delete'        => 'Eliminar',
                    'id'            => 'ID',
                    'inactive'      => 'Inactiu',
                    'name'          => 'Nom',
                    'sort-order'    => 'Ordre de Classificació',
                    'status'        => 'Estat',
                    'theme'         => 'Tema',
                    'type'          => 'Tipus',
                    'view'          => 'Veure',
                ],
            ],

            'create' => [
                'name'       => 'Nom',
                'save-btn'   => 'Desar tema',
                'sort-order' => 'Ordre de classificació',
                'themes'     => 'Temes',
                'title'      => 'Crear tema',

                'type' => [
                    'category-carousel' => 'Carrousel de Categoria',
                    'footer-links'      => 'Enllaços del Peu de Pàgina',
                    'image-carousel'    => 'Carrousel d\'Imatges',
                    'product-carousel'  => 'Carrousel de Productes',
                    'services-content'  => 'Contingut de Serveis',
                    'static-content'    => 'Contingut Estàtic',
                    'title'             => 'Tipus',
                ],
            ],

            'edit' => [
                'active'                        => 'Actiu',
                'add-filter-btn'                => 'Afegir Filtres',
                'add-footer-link-btn'           => 'Afegir Enllaç al Peu de Pàgina',
                'add-image-btn'                 => 'Afegir Imatge',
                'add-link'                      => 'Afegir Enllaç',
                'asc'                           => 'Asc',
                'back'                          => 'Enrere',
                'category-carousel'             => 'Carrousel de Categoria',
                'category-carousel-description' => 'Mostra categories dinàmiques de forma atractiva utilitzant un carrousel de categories adaptable.',
                'channels'                      => 'Canals',
                'column'                        => 'Columna',
                'create-filter'                 => 'Crear Filtre',
                'css'                           => 'CSS',
                'delete'                        => 'Eliminar',
                'desc'                          => 'Desc',
                'edit'                          => 'Editar',
                'featured'                      => 'Destacat',
                'filter-title'                  => 'Títol',
                'filters'                       => 'Filtres',
                'footer-link'                   => 'Enllaços del Peu de Pàgina',
                'footer-link-description'       => 'Navega pels enllaços del peu de pàgina per explorar el lloc web de manera fluïda i obtenir informació.',
                'footer-link-form-title'        => 'Enllaç al Peu de Pàgina',
                'footer-title'                  => 'Títol',
                'general'                       => 'General',
                'html'                          => 'HTML',
                'image'                         => 'Imatge',
                'image-size'                    => 'La mida de la imatge ha de ser (1920px x 700px)',
                'image-title'                   => 'Títol de la imatge',
                'image-upload-message'          => 'Només s\'admeten imatges (.jpeg, .jpg, .png, .webp, ..).',
                'inactive'                      => 'Inactiu',
                'key'                           => 'Clau: :key',
                'key-input'                     => 'Clau',
                'limit'                         => 'Límit',
                'link'                          => 'Enllaç',
                'name'                          => 'Nom',
                'new'                           => 'Nou',
                'no'                            => 'No',
                'parent-id'                     => 'ID del Pare',
                'parent-id-hint'                => 'Pots introduir múltiples ID de pare separats per comes (p. ex., 12,15,34)',
                'category-id'                   => 'ID de categoria',
                'preview'                       => 'Vista prèvia',
                'product-carousel'              => 'Carrousel de Productes',
                'product-carousel-description'  => 'Mostra productes de forma elegant amb un carrousel de productes dinàmic i adaptable.',
                'save-btn'                      => 'Desar',
                'select'                        => 'Seleccionar',
                'slider'                        => 'Lliscador',
                'slider-add-btn'                => 'Afegir Lliscador',
                'slider-description'            => 'Personalització de temes relacionada amb el lliscador.',
                'slider-image'                  => 'Imatge del Lliscador',
                'slider-required'               => 'El camp del lliscador és obligatori.',
                'sort'                          => 'Ordenar',
                'sort-order'                    => 'Ordre de Classificació',
                'static-content'                => 'Contingut Estàtic',
                'static-content-description'    => 'Millora la interacció amb contingut estàtic concís i informatiu per a la teva audiència.',
                'status'                        => 'Estat',
                'themes'                        => 'Temes',
                'title'                         => 'Editar Tema',
                'update-slider'                 => 'Actualitzar Deslizador',
                'url'                           => 'URL',
                'value'                         => 'Valor: :value',
                'value-input'                   => 'Valor',

                'services-content' => [
                    'add-btn'            => 'Afegir serveis',
                    'channels'           => 'Canals',
                    'delete'             => 'Eliminar',
                    'description'        => 'Descripció',
                    'general'            => 'General',
                    'name'               => 'Nom',
                    'save-btn'           => 'Desar',
                    'service-icon'       => 'Icona del servei',
                    'service-icon-class' => 'Classe de icona del servei',
                    'service-info'       => 'Personalització de temes relacionats amb el servei.',
                    'services'           => 'Serveis',
                    'sort-order'         => 'Ordre de classificació',
                    'status'             => 'Estat',
                    'title'              => 'Títol',
                    'update-service'     => 'Actualitzar serveis',
                ],
                'yes'                           => 'Sí',
            ],

            'create-success' => 'Tema creat amb éxit',
            'delete-success' => 'Tema eliminat amb éxit',
            'update-success' => 'Tema actualitzat amb éxit',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Cistelles Abandonades',
                'abandoned-products'            => 'Productes Abandonats',
                'abandoned-rate'                => 'Taxa d\'Abandonament',
                'abandoned-revenue'             => 'Ingressos Abandonats',
                'added-to-cart'                 => 'Afegit a la Cistella',
                'added-to-cart-info'            => 'Només :progress visitants han afegit productes a la cistella',
                'all-channels'                  => 'Tots els canals',
                'average-order-value-over-time' => 'Valor Mitjà de la Comanda al llarg del Temps',
                'average-sales'                 => 'Valor Mitjà de la Comanda',
                'count'                         => 'Comptar',
                'end-date'                      => 'Data de Finalització',
                'id'                            => 'ID',
                'interval'                      => 'Interval',
                'name'                          => 'Nom',
                'orders'                        => 'Comandes',
                'orders-over-time'              => 'Comandes al llarg del Temps',
                'payment-method'                => 'Mètode de Pagament',
                'product-views'                 => 'Vistes de Productes',
                'product-views-info'            => 'Només :progress visitants veuen productes',
                'purchase-funnel'               => 'Embut de Compra',
                'purchased'                     => 'Comprat',
                'purchased-info'                => 'Només :progress visitants realitzen compres',
                'refunds'                       => 'Reemborsaments',
                'refunds-over-time'             => 'Reemborsaments al llarg del Temps',
                'sales-over-time'               => 'Vendes al llarg del Temps',
                'shipping-collected'            => 'Enviament Recaptat',
                'shipping-collected-over-time'  => 'Enviament Recaptat al llarg del Temps',
                'start-date'                    => 'Data d\'Inici',
                'tax-collected'                 => 'Impostos Recaptats',
                'tax-collected-over-time'       => 'Impostos Recaptats al llarg del Temps',
                'title'                         => 'Vendes',
                'top-payment-methods'           => 'Principals Mètodes de Pagament',
                'top-shipping-methods'          => 'Principals Mètodes d\'Enviament',
                'top-tax-categories'            => 'Principals Categories d\'Impostos',
                'total'                         => 'Total',
                'total-orders'                  => 'Total de Comandes',
                'total-sales'                   => 'Total de Vendes',
                'total-visits'                  => 'Total de Visites',
                'total-visits-info'             => 'Total de visitants a la botiga',
                'view-details'                  => 'Veure Detalls',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Tots els Canals',
                'count'                       => 'Comptar',
                'customers'                   => 'Clients',
                'customers-over-time'         => 'Clients al llarg del Temps',
                'customers-traffic'           => 'Trànsit de Clients',
                'customers-with-most-orders'  => 'Clients amb Més Comandes',
                'customers-with-most-reviews' => 'Clients amb Més Resenyes',
                'customers-with-most-sales'   => 'Clients amb Més Vendes',
                'email'                       => 'Correu Electrònic',
                'end-date'                    => 'Data de Finalització',
                'id'                          => 'ID',
                'interval'                    => 'Interval',
                'name'                        => 'Nom',
                'orders'                      => 'Comandes',
                'reviews'                     => 'Resenyes',
                'start-date'                  => 'Data d\'Inici',
                'title'                       => 'Clients',
                'top-customer-groups'         => 'Principals Grups de Clients',
                'total'                       => 'Total',
                'total-customers'             => 'Total de Clients',
                'total-visitors'              => 'Total de Visitants',
                'traffic-over-week'           => 'Trànsit a llarg de la Setmana',
                'unique-visitors'             => 'Visitants Únics',
                'view-details'                => 'Veure Detalls',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Tots els Canals',
                'channel'                          => 'Canal',
                'end-date'                         => 'Data de Finalització',
                'id'                               => 'ID',
                'interval'                         => 'Interval',
                'last-search-terms'                => 'Últims termes de cerca',
                'locale'                           => 'Configuració regional',
                'name'                             => 'Nom',
                'orders'                           => 'Comandes',
                'price'                            => 'Preu',
                'products-added-over-time'         => 'Productes Afegits al llarg del Temps',
                'products-with-most-reviews'       => 'Productes amb Més Resenyes',
                'products-with-most-visits'        => 'Productes amb Més Visites',
                'quantities'                       => 'Quantitats',
                'quantities-sold-over-time'        => 'Quantitats Venudes al llarg del Temps',
                'results'                          => 'Resultats',
                'revenue'                          => 'Ingressos',
                'reviews'                          => 'Resenyes',
                'search-term'                      => 'Terme de cerca',
                'start-date'                       => 'Data d\'Inici',
                'title'                            => 'Productes',
                'top-search-terms'                 => 'Termes de cerca principals',
                'top-selling-products-by-quantity' => 'Productes Més Venuts per Quantitat',
                'top-selling-products-by-revenue'  => 'Productes Més Venuts per Ingressos',
                'total'                            => 'Total',
                'total-products-added-to-wishlist' => 'Productes Afegits a la Llista de Desitjos',
                'total-sold-quantities'            => 'Quantitat de Productes Venuts',
                'uses'                             => 'Usos',
                'view-details'                     => 'Veure Detalls',
                'visits'                           => 'Visites',
            ],
        ],

        'view' => [
            'all-channels'  => 'Tots els Canals',
            'day'           => 'Dia',
            'end-date'      => 'Data de Finalització',
            'export-csv'    => 'Exportar CSV',
            'export-xls'    => 'Exportar XLS',
            'month'         => 'Mes',
            'not-available' => 'No hi ha registres disponibles.',
            'start-date'    => 'Data d\'Inici',
            'year'          => 'Any',
        ],

        'empty' => [
            'info'  => 'No hi ha dades disponibles per al període seleccionat',
            'title' => 'No hi ha dades disponibles',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                      => 'Enrere',
            'delete'                        => 'Esborrar',
            'enable-at-least-one-payment'   => 'Habilita almenys un mètode de pagament.',
            'enable-at-least-one-shipping'  => 'Habilita almenys un mètode d\'enviament.',
            'no-result-found'               => 'No s\'han trobat resultats',
            'save-btn'                      => 'Desa la configuració',
            'save-message'                  => 'Configuració desada correctament',
            'search'                        => 'Cerca',
            'select-country'                => 'Selecciona el país',
            'select-state'                  => 'Selecciona l\'estat',
            'title'                         => 'Configuració',

            'general' => [
                'info'  => 'Estableix opcions d\'unitats.',
                'title' => 'General',

                'general' => [
                    'info'  => 'Estableix opcions d\'unitats.',
                    'title' => 'General',

                    'unit-options' => [
                        'info'        => 'Estableix opcions d\'unitats.',
                        'title'       => 'Opcions d\'Unitats',
                        'title-info'  => 'Configura el pes en lliures (lbs) o quilograms (kgs).',
                        'weight-unit' => 'Unitat de Pes',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Molles de Pa de la Botiga',
                        'title'      => 'Molles de Pa',
                        'title-info' => 'Habilita o deshabilita la navegació de molles de pa a la botiga.',
                    ],
                ],

                'content' => [
                    'info'  => 'Estableix opcions de comparació, opcions de llistes de desitjos, opcions de cerca d\'imatges, peu de pàgina, alterna el peu de pàgina i scripts personalitzats.',
                    'title' => 'Contingut',

                    'header-offer' => [
                        'title'             => 'Títol de l\'Oferta del Capçalera',
                        'title-info'        => 'Configura el Títol de l\'Oferta del Capçalera amb el títol de l\'oferta, títol de redirecció i enllaç de redirecció.',
                        'offer-title'       => 'Títol de l\'Oferta',
                        'redirection-title' => 'Títol de Redirecció',
                        'redirection-link'  => 'Enllaç de Redirecció',
                    ],

                    'speculation-rules' => [
                        'enable-speculation' => 'Habilita les regles d’especulació',
                        'info'               => 'Configura els paràmetres per habilitar o deshabilitar la lògica automàtica d’especulació.',
                        'title'              => 'Regles d’especulació',

                        'prerender' => [
                            'conservative'           => 'Conservador',
                            'eager'                  => 'Entusiasta',
                            'eagerness'              => 'Nivell d’entusiasme de prerender',
                            'eagerness-info'         => 'Controla com s’apliquen d’agressivament les regles d’especulació. Opcions: entusiasta (màxim), moderat (per defecte), conservador (baix).',
                            'enabled'                => 'Habilita les regles d’especulació de prerender',
                            'ignore-url-params'      => 'Ignora els paràmetres d’URL de prerender',
                            'ignore-url-params-info' => 'Especifica els paràmetres d’URL a ignorar en les regles d’especulació. Usa la barra vertical (|) per separar diversos paràmetres.',
                            'ignore-urls'            => 'Ignora els URL de prerender',
                            'ignore-urls-info'       => 'Introdueix els URL que s’han d’excloure de la lògica d’especulació. Separa múltiples URL amb la barra vertical (|).',
                            'info'                   => 'Configura l’estat de les regles d’especulació.',
                            'moderate'               => 'Moderat',
                        ],

                        'prefetch' => [
                            'conservative'           => 'Conservador',
                            'eager'                  => 'Entusiasta',
                            'eagerness'              => 'Nivell d’entusiasme de prefetch',
                            'eagerness-info'         => 'Controla com s’apliquen d’agressivament les regles d’especulació. Opcions: entusiasta (màxim), moderat (per defecte), conservador (baix).',
                            'enabled'                => 'Habilita les regles d’especulació de prefetch',
                            'ignore-url-params'      => 'Ignora els paràmetres d’URL de prefetch',
                            'ignore-url-params-info' => 'Especifica els paràmetres d’URL a ignorar en les regles d’especulació. Usa la barra vertical (|) per separar diversos paràmetres.',
                            'ignore-urls'            => 'Ignora els URL de prefetch',
                            'ignore-urls-info'       => 'Introdueix els URL que s’han d’excloure de la lògica d’especulació. Separa múltiples URL amb la barra vertical (|).',
                            'info'                   => 'Configura l’estat de les regles d’especulació.',
                            'moderate'               => 'Moderat',
                        ],
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'CSS Personalitzat',
                        'custom-javascript' => 'Javascript Personalitzat',
                        'title'             => 'Scripts Personalitzats',
                        'title-info'        => 'Els scripts personalitzats són peces de codi creades per afegir funcions o característiques específiques al programari, millorant les seves capacitats de manera única.',
                    ],
                ],

                'design' => [
                    'info'  => 'Establir logotip i icona de favicon.',
                    'title' => 'Disseny',

                    'admin-logo' => [
                        'favicon'    => 'Favicon',
                        'logo-image' => 'Imatge de Logotip',
                        'title'      => 'Logotip d\'Administrador',
                        'title-info' => 'Configura les imatges de logotip i favicon per a la interfície del teu lloc web per a una millor marca i reconeixement.',
                    ],

                    'menu-category' => [
                        'default'         => 'Menú per defecte',
                        'info'            => 'Aquesta configuració controla la visibilitat de les categories al menú de capçalera. Pots triar mostrar només les categories pare o totes les categories niades.',
                        'preview-default' => 'Previsualització del menú per defecte',
                        'preview-sidebar' => 'Previsualització del menú lateral',
                        'sidebar'         => 'Menú lateral',
                        'title'           => 'Vista de la categoria del menú',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Configurar opcions de Magic AI.',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'Clau d\'API',
                        'enabled'        => 'Habilitat',
                        'llm-api-domain' => 'Dominio d\'API LLM',
                        'organization'   => 'Organització',
                        'title'          => 'Configuració General',
                        'title-info'     => 'Millora la teva experiència amb la funció de Magic AI introduint la teva exclusiva Clau d\'API i indicant l\'Organització pertinent per a una integració sense esforços. Pren el control de les teves credencials d\'OpenAI i personalitza la configuració segons les teves necessitats específiques.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Indicación de Descripció de Categoria',
                        'cms-page-content-prompt'          => 'Indicación de Contingut de Pàgina CMS',
                        'enabled'                          => 'Habilitat',
                        'product-description-prompt'       => 'Indicación de Descripció de Producte',
                        'product-short-description-prompt' => 'Indicación de Descripció Curta de Producte',
                        'title'                            => 'Generació de Contingut',
                        'title-info'                       => 'Aquesta funció habilitarà el Magic AI per a cada editor WYSIWYG, on vulguis gestionar el contingut utilitzant la IA.<br/><br/>Quan estigui habilitat, ves a qualsevol editor per generar contingut.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Habilitat',
                        'title'      => 'Generació d\'Imatges',
                        'title-info' => 'Aquesta funció habilitarà el Magic AI per a cada càrrega d\'imatges, on vulguis generar imatges utilitzant DALL-E.<br/><br/>Quan estigui habilitat, ves a qualsevol càrrega d\'imatges per generar imatges.',
                    ],

                    'review-translation' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Habilitat',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt-4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Model',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Traducció de ressenyes',
                        'title-info'          => 'Proporciona l\'opció al client o visitant de traduir la ressenya del client a l\'anglès.<br/><br/>Quan estigui habilitat, ves a la ressenya i trobaràs el botó "Traduir a l\'anglès" si la ressenya és en un altre idioma que no sigui l\'anglès.',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],

                    'checkout-message' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Habilitat',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt 4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Model',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'prompt'              => 'Indicació',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Missatge Personalitzat de Finalització de Compra',
                        'title-info'          => 'Crea un missatge personalitzat de finalització de compra per als clients a la pàgina de gràcies, adaptant el contingut per ressonar amb les preferències individuals i millorant l\'experiència post-compra.',
                        'vicuna'              => 'Vicuna',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],
                ],

                'gdpr' => [
                    'title' => 'GDPR',
                    'info'  => 'Configuració de compliment de GDPR',

                    'settings' => [
                        'title'   => 'Configuració de compliment de GDPR',
                        'info'    => 'Gestiona la configuració de compliment de GDPR, incloent l\'acord de privadesa de dades. Habilita o deshabilita les funcions de GDPR segons sigui necessari',
                        'enabled' => 'Habilitar GDPR',
                    ],

                    'agreement' => [
                        'title'          => 'Acord de GDPR',
                        'info'           => 'Gestiona el consentiment del client segons les regulacions de GDPR. Habilita els requisits d\'acord per a la recopilació i processament de dades.',
                        'enable'         => 'Habilitar l\'acord del client',
                        'checkbox-label' => 'Etiqueta del checkbox per a l\'acord',
                        'content'        => 'Contingut de l\'acord',
                    ],

                    'cookie' => [
                        'bottom-left'  => 'Inferior esquerra',
                        'bottom-right' => 'Inferior dreta',
                        'center'       => 'Centre',
                        'description'  => 'Descripció',
                        'enable'       => 'Habilitar notificació de cookies',
                        'identifier'   => 'Identificador de bloc estàtic',
                        'info'         => 'Configura la configuració de consentiment de cookies per informar els usuaris sobre la recopilació de dades i complir amb les regulacions de privadesa.',
                        'position'     => 'Posició de visualització del bloc de cookies',
                        'title'        => 'Configuració de notificació de cookies',
                        'top-left'     => 'Superior esquerra',
                        'top-right'    => 'Superior dreta',
                    ],

                    'cookie-consent' => [
                        'title'                  => 'Gestiona les teves preferències de cookies',
                        'info'                   => 'Controla com es farà servir les teves dades seleccionant la configuració de cookies preferida. Ajusta els permisos per a diferents tipus de cookies.',
                        'strictly-necessary'     => 'Estricament necessàries',
                        'basic-interaction'      => 'Interacció bàsica i funcionalitat',
                        'experience-enhancement' => 'Millora de l\'experiència',
                        'measurement'            => 'Mesura',
                        'targeting-advertising'  => 'Orientació i publicitat',
                    ],
                ],

                'sitemap' => [
                    'info'  => 'Estableix les opcions del mapa del lloc.',
                    'title' => 'Mapa del lloc',

                    'settings' => [
                        'enabled' => 'Habilitat',
                        'info'    => 'Habilita o deshabilita el mapa del lloc per al teu lloc web per millorar l\'optimització dels motors de cerca i millorar l\'experiència de l\'usuari.',
                        'title'   => 'Configuració',
                    ],

                    'file-limits' => [
                        'info'             => 'Estableix les opcions de límits d\'arxius.',
                        'max-file-size'    => 'Mida màxima de l\'arxiu',
                        'max-url-per-file' => 'Nombre màxim d\'URL per arxiu',
                        'title'            => 'Límits d\'arxius',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Catàleg',
                'title' => 'Catàleg',

                'products' => [
                    'info'  => 'Pàgina de vista del producte, pàgina de vista de la cistella, aparador, revisió i compartir atributs a les xarxes socials.',
                    'title' => 'Productes',

                    'settings' => [
                        'compare-options'     => 'Opcions de comparació',
                        'image-search-option' => 'Opció de cerca d\'imatges',
                        'title'               => 'Configuració',
                        'title-info'          => 'La configuració fa referència a les opcions configurables que controlen el comportament d\'un sistema, aplicació o dispositiu, adaptades a les preferències i requisits de l\'usuari.',
                        'wishlist-options'    => 'Opcions de llista de desitjos',
                    ],

                    'search' => [
                        'admin-mode'            => 'Mode de cerca d\'administrador',
                        'admin-mode-info'       => 'La cerca mega, la quadrícula de dades i altres funcionalitats de cerca al panell d\'administració es basaran en el motor de cerca seleccionat.',
                        'database'              => 'Base de dades',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Longitud màxima de consulta',
                        'max-query-length-info' => 'Establir la longitud màxima de consulta per a les cerques.',
                        'min-query-length'      => 'Longitud mínima de consulta',
                        'min-query-length-info' => 'Establir la longitud mínima de consulta per a les cerques.',
                        'search-engine'         => 'Motor de cerca',
                        'storefront-mode'       => 'Mode de cerca de botiga en línia',
                        'storefront-mode-info'  => 'La funcionalitat de cerca a la botiga en línia es basarà en el motor de cerca seleccionat, incloent la pàgina de categoria, la pàgina de cerca i altres funcionalitats de cerca.',
                        'title'                 => 'Cerca',
                        'title-info'            => 'Per configurar el motor de cerca per a les cerques de productes, podeu triar entre una base de dades i Elasticsearch segons els vostres requisits. Si teniu un gran nombre de productes, es recomana Elasticsearch.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Permetre el pagament per a convidats',
                        'allow-guest-checkout-hint' => 'Suggeriment: si està activat, aquesta opció es pot configurar per a cada producte específicament.',
                        'title'                     => 'Pagament per a convidats',
                        'title-info'                => 'El pagament per a convidats permet als clients comprar productes sense crear un compte, agilitzant el procés de compra per a més comoditat i transaccions més ràpides.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Nombre permès de productes relacionats',
                        'allow-no-of-up-sells-products' => 'Nombre permès de productes de venda creuada',
                        'title'                         => 'Configuració de la pàgina de vista de producte',
                        'title-info'                    => 'La configuració de la pàgina de vista de producte implica ajustar el disseny i els elements a la pàgina de visualització d\'un producte, millorant l\'experiència de l\'usuari i la presentació de la informació.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Nombre permès de productes de venda creuada',
                        'title'                            => 'Configuració de la pàgina de vista del carret',
                        'title-info'                       => 'La configuració de la pàgina de vista del carret implica organitzar elements, detalls i opcions a la pàgina del carret de la compra, millorant la interacció de l\'usuari i el flux de compra.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Permetre als clients comprar productes directament',
                        'cheapest-first'         => 'Més barat primer',
                        'comma-separated'        => 'Separat per comes',
                        'default-list-mode'      => 'Mode de llista per defecte',
                        'expensive-first'        => 'Més car primer',
                        'from-a-z'               => 'De la A a la Z',
                        'from-z-a'               => 'De la Z a la A',
                        'grid'                   => 'Quadrícula',
                        'latest-first'           => 'Més recent primer',
                        'list'                   => 'Llista',
                        'oldest-first'           => 'Més antic primer',
                        'products-per-page'      => 'Productes per pàgina',
                        'sort-by'                => 'Ordenar per',
                        'title'                  => 'Botiga en línia',
                        'title-info'             => 'La botiga en línia és la interfície orientada al client d\'una botiga en línia, que mostra productes, categories i navegació per a una experiència de compra perfecta.',
                    ],

                    'small-image' => [
                        'height'      => 'Alçada',
                        'placeholder' => 'Marcador de posició d\'imatge petita',
                        'title'       => 'Imatge petita',
                        'title-info'  => 'La imatge petita és la interfície orientada al client d\'una botiga en línia, que mostra productes, categories i navegació per a una experiència de compra perfecta.',
                        'width'       => 'Amplada',
                    ],

                    'medium-image' => [
                        'height'      => 'Alçada',
                        'placeholder' => 'Marcador de posició d\'imatge mitjana',
                        'title'       => 'Imatge mitjana',
                        'title-info'  => 'La imatge mitjana es refereix a una imatge de mida moderada que ofereix un equilibri entre el detall i l\'espai a la pantalla, comunament utilitzada per a fins visuals.',
                        'width'       => 'Amplada',
                    ],

                    'large-image' => [
                        'height'      => 'Alçada',
                        'placeholder' => 'Marcador de posició d\'imatge gran',
                        'title'       => 'Imatge gran',
                        'title-info'  => 'La imatge gran representa una imatge d\'alta resolució que proporciona un major detall i impacte visual, sovint utilitzada per mostrar productes o gràfics.',
                        'width'       => 'Amplada',
                    ],

                    'review' => [
                        'allow-customer-review'   => 'Permetre ressenyes de clients',
                        'allow-guest-review'      => 'Permetre ressenyes d\'invitats',
                        'censoring-reviewer-name' => 'Censura del Nom del Ressenyaire',
                        'display-review-count'    => 'Mostra el recompte de ressenyes per a les valoracions.',
                        'display-star-count'      => 'Mostra el recompte d\'estrelles en les valoracions.',
                        'summary'                 => 'Resum',
                        'title'                   => 'Ressenya',
                        'title-info'              => 'Avaluació o valoració d\'alguna cosa, sovint implicant opinions i comentaris.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Mida màxima de càrrega d\'arxius (en Kb)',
                        'image-upload-size' => 'Mida màxima de càrrega d\'imatges (en Kb)',
                        'title'             => 'Atribut',
                        'title-info'        => 'Característica o propietat que defineix un objecte, influenciant el seu comportament, aparença o funció.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Configura la configuració de compartir a les xarxes socials per habilitar el compartir productes a Instagram, Twitter, WhatsApp, Facebook, Pinterest, LinkedIn i per correu electrònic.',
                        'title'                       => 'Compartir a les xarxes socials',
                        'share-message'               => 'Missatge de compartir',
                        'share'                       => 'Compartir',
                        'enable-social-share'         => 'Habilitar compartir a les xarxes socials?',
                        'enable-share-whatsapp-info'  => 'L\'enllaç per compartir a WhatsApp només apareixerà en dispositius mòbils.',
                        'enable-share-whatsapp'       => 'Habilitar compartir a WhatsApp?',
                        'enable-share-twitter'        => 'Habilitar compartir a Twitter?',
                        'enable-share-pinterest'      => 'Habilitar compartir a Pinterest?',
                        'enable-share-linkedin'       => 'Habilitar compartir a LinkedIn?',
                        'enable-share-facebook'       => 'Habilitar compartir a Facebook?',
                        'enable-share-email'          => 'Habilitar compartir per correu electrònic?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Configurar productes i categories.',
                    'title' => 'Fragments enriquits',

                    'products' => [
                        'enable'          => 'Habilitar',
                        'show-categories' => 'Mostrar categories',
                        'show-images'     => 'Mostrar imatges',
                        'show-offers'     => 'Mostrar ofertes',
                        'show-ratings'    => 'Mostrar calificacions',
                        'show-reviews'    => 'Mostrar resenyes',
                        'show-sku'        => 'Mostrar SKU',
                        'show-weight'     => 'Mostrar pes',
                        'title'           => 'Productes',
                        'info'            => 'Configura les opcions d\'estoc del producte per permetre comandes pendents, establir quantitats mínimes i màximes a la cistella, i definir limíts de falta d\'estoc.',
                    ],

                    'categories' => [
                        'enable'                  => 'Habilitar',
                        'show-search-input-field' => 'Mostrar camp d\'entrada de cerca',
                        'title'                   => 'Categories',
                        'title-info'              => '"Categories" es refereix a grups o classificacions que ajuden a organitzar i agrupar productes o articles similars per facilitar la navegació i cerca.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Inventari',
                    'title-info' => 'Configura la configuració d\'inventari per permetre comandes pendents, establir quantitats mínimes i màximes a la cistella i definir el llindar de falta d\'estoc.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Permetre comandes pendents',
                        'max-qty-allowed-in-cart' => 'Quantitat màxima permesa a la cistella de la compra',
                        'min-qty-allowed-in-cart' => 'Quantitat mínima permesa a la cistella de la compra',
                        'out-of-stock-threshold'  => 'Lindar de falta d\'estoc',
                        'title'                   => 'Opció d\'estoc de producte',
                        'info'                    => 'Configura les opcions d\'estoc de productes per permetre comandes pendents, establir quantitats mínimes i màximes a la cistella i definir llindars de falta d\'estoc.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Client',
                'title' => 'Client',

                'address' => [
                    'info'  => 'Estableix el país, l\'estat, el codi postal i les línies d\'una adreça de carrer.',
                    'title' => 'Adreça',

                    'requirements' => [
                        'city'       => 'Ciutat',
                        'country'    => 'País',
                        'state'      => 'Estat',
                        'title'      => 'Requisits',
                        'title-info' => 'Els requisits són les condicions, característiques o especificacions necessàries perquè alguna cosa es compleixi, s\'aconsegueixi o es satisfaci amb éxit.',
                        'zip'        => 'Codi Postal',
                    ],

                    'information' => [
                        'street-lines' => 'Línies en una adreça de carrer',
                        'title'        => 'Informació',
                        'title-info'   => '"Línies en una adreça de carrer" es refereix als segments individuals d\'una adreça, sovint separats per comes, que proporcionen informació d\'ubicació com número de casa, carrer, ciutat i més.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Establir la clau del lloc, clau secreta i estat.',
                    'title' => 'Captcha',

                    'credentials' => [
                        'secret-key' => 'Clau secreta',
                        'site-key'   => 'Clau del lloc',
                        'status'     => 'Estat',
                        'title'      => 'Credencials',
                        'title-info' => '"Mapa del lloc: Disseny del lloc web per a motors de cerca. Clau secreta: Codi segur per a la xifratge de dades, autenticació o protecció d\'accés a l\'API."',
                    ],

                    'validations' => [
                        'captcha'  => 'Alguna cosa ha anat malament! Si us plau, proveu-ho de nou.',
                        'required' => 'Si us plau, seleccioneu CAPTCHA',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Configura les subscripcions als butlletins, les verificacions per correu electrònic i la connexió social.',
                    'title'         => 'Configuració',

                    'login-as-customer' => [
                        'allow-option' => 'Permetre la connexió com a client',
                        'title'        => 'Connexió com a client',
                        'title-info'   => 'Activa la funcionalitat "Connexió com a client".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Permetre l\'opció de llista de desitjos',
                        'title'        => 'Llista de desitjos',
                        'title-info'   => 'Activa o desactiva l\'opció de llista de desitjos.',
                    ],

                    'login-options' => [
                        'account'          => 'Compte',
                        'home'             => 'Inici',
                        'redirect-to-page' => 'Redirigeix el client a la pàgina seleccionada',
                        'title'            => 'Opcions de connexió',
                        'title-info'       => 'Configura les opcions de connexió per determinar la pàgina de redirecció per als clients després de la connexió.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Permetre el butlletí',
                        'news-letter-info' => 'Activa l\'opció d\'subscripció al butlletí a la pàgina d\'inscripció.',
                        'title'            => 'Opcions per a la creació de nous comptes',
                        'title-info'       => 'Configura les opcions per a nous comptes, incloent l\'assignació d\'un grup de clients per defecte i l\'activació de l\'opció de subscripció al butlletí durant la inscripció.',

                        'default-group' => [
                            'general'    => 'General',
                            'guest'      => 'Convidat',
                            'title'      => 'Grup per defecte',
                            'title-info' => 'Assigna un grup de clients específic com a per defecte per als nous clients.',
                            'wholesale'  => 'Majorista',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Permetre la subscripció al butlletí',
                        'title'        => 'Subscripció al butlletí',
                        'title-info'   => '"Informacions del butlletí" conté actualitzacions, ofertes o contingut compartit regularment per correu electrònic amb els subscriptors, mantenint-los informats i compromesos.',
                    ],

                    'email' => [
                        'email-verification' => 'Permetre la verificació per correu electrònic',
                        'title'              => 'Verificació per correu electrònic',
                        'title-info'         => '"Verificació per correu electrònic" confirma l\'autenticitat d\'una adreça de correu electrònic, sovint enviant un enllaç de confirmació, millorant la seguretat del compte i la fiabilitat de la comunicació.',
                    ],

                    'social-login' => [
                        'title' => 'Connexió social',
                        'info'  => '"Connexió social" permet als usuaris accedir a un lloc web utilitzant els seus comptes de xarxes socials, simplificant els processos d\'inscripció i connexió.',

                        'google' => [
                            'enable-google' => 'Activar Google',

                            'client-id' => [
                                'title'      => 'ID de client',
                                'title-info' => 'Identificador únic proporcionat per Google en crear la teva aplicació OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secret de client',
                                'title-info' => 'Clau secreta associada al teu client OAuth de Google. Mantingues-la confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'Redirecció',
                                'title-info' => 'URL de retorn on els usuaris són redirigits després de la seva autenticació amb Google. Ha de coincidir amb la URL configurada a la teva consola de Google.',
                            ],
                        ],

                        'facebook' => [
                            'enable-facebook' => 'Activar Facebook',

                            'client-id' => [
                                'title'      => 'ID de client',
                                'title-info' => 'ID d\'aplicació proporcionat per Facebook en crear una aplicació a la seva consola de desenvolupadors.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secret de client',
                                'title-info' => 'Secret d\'aplicació associat a la teva aplicació de Facebook. Mantingues-lo segur i privat.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirecció',
                                'title-info' => 'URL de retorn on els usuaris són redirigits després d\'autenticar-se amb Facebook. Ha de coincidir amb la URL configurada als paràmetres de la teva aplicació de Facebook.',
                            ],
                        ],

                        'github' => [
                            'enable-github' => 'Activar GitHub',

                            'client-id' => [
                                'title'      => 'ID de client',
                                'title-info' => 'Identificador únic proporcionat per GitHub en crear la teva aplicació OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secret de client',
                                'title-info' => 'Clau secreta associada al teu client OAuth de GitHub. Mantingues-la confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirecció',
                                'title-info' => 'URL de retorn on els usuaris són redirigits després d\'autenticar-se amb GitHub. Ha de coincidir amb la URL configurada a la teva consola de GitHub.',
                            ],
                        ],

                        'linkedin' => [
                            'enable-linkedin' => 'Activar LinkedIn',

                            'client-id' => [
                                'title'      => 'ID de client',
                                'title-info' => 'Identificador únic proporcionat per LinkedIn en crear la teva aplicació OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secret de client',
                                'title-info' => 'Clau secreta associada al teu client OAuth de LinkedIn. Mantingues-la confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirecció',
                                'title-info' => 'URL de retorn on els usuaris són redirigits després d\'autenticar-se amb LinkedIn. Ha de coincidir amb la URL configurada a la teva consola de LinkedIn.',
                            ],
                        ],

                        'twitter' => [
                            'enable-twitter' => 'Activar Twitter',

                            'client-id' => [
                                'title'      => 'ID de client',
                                'title-info' => 'Identificador únic proporcionat per Twitter en crear la teva aplicació OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secret de client',
                                'title-info' => 'Clau secreta associada al teu client OAuth de Twitter. Mantingues-la confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirecció',
                                'title-info' => 'URL de retorn on els usuaris són redirigits després d\'autenticar-se amb Twitter. Ha de coincidir amb la URL configurada a la teva consola de Twitter.',
                            ],
                        ],
                    ],
                ],
            ],

            'email' => [
                'info'  => 'Correu electrònic',
                'title' => 'Correu electrònic',

                'email-settings' => [
                    'admin-email'           => 'Correu electrònic de l\'administrador',
                    'admin-email-tip'       => 'L\'adreça de correu electrònic de l\'administrador d\'aquest canal per rebre correus electrònics',
                    'admin-name'            => 'Nom de l\'administrador',
                    'admin-name-tip'        => 'Aquest nom es mostrarà en tots els correus electrònics de l\'administrador',
                    'admin-page-limit'      => 'Elements per pàgina per defecte (Administrador)',
                    'contact-email'         => 'Correu electrònic de contacte',
                    'contact-email-tip'     => 'L\'adreça de correu electrònic es mostrarà a la part inferior dels seus correus electrònics',
                    'contact-name'          => 'Nom de contacte',
                    'contact-name-tip'      => 'Aquest nom es mostrarà a la part inferior dels seus correus electrònics',
                    'email-sender-name'     => 'Nom del remitent del correu electrònic',
                    'email-sender-name-tip' => 'Aquest nom es mostrarà a la safata d\'entrada dels clients',
                    'info'                  => 'Establir nom del remitent del correu electrònic, adreça de correu electrònic de la botiga, nom de l\'administrador i adreça de correu electrònic de l\'administrador.',
                    'shop-email-from'       => 'Adreça de correu electrònic de la botiga',
                    'shop-email-from-tip'   => 'L\'adreça de correu electrònic d\'aquest canal per enviar correus electrònics als seus clients',
                    'title'                 => 'Configuració de correu electrònic',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Envia una notificació després de cancel·lar una comanda',
                    'cancel-order-mail-to-admin'                       => 'Envia un correu electrònic de notificació a l\'administrador després de cancel·lar una comanda',
                    'customer'                                         => 'Envia les credencials del compte del client després del registre',
                    'customer-registration-confirmation-mail-to-admin' => 'Envia un correu electrònic de confirmació a l\'administrador després del registre del client',
                    'info'                                             => 'Configura les opcions d\'estoc del producte per permetre comandes pendents, establir quantitats mínimes i màximes al carret de la compra i definir llindars de falta d\'estoc.',
                    'new-inventory-source'                             => 'Envia un correu electrònic de notificació a la font d\'estoc després de crear un enviament',
                    'new-invoice'                                      => 'Envia un correu electrònic de notificació al client després de crear una nova factura',
                    'new-invoice-mail-to-admin'                        => 'Envia un correu electrònic de notificació a l\'administrador després de crear una nova factura',
                    'new-order'                                        => 'Envia un correu electrònic de confirmació al client després de realitzar una nova comanda',
                    'new-order-mail-to-admin'                          => 'Envia un correu electrònic de confirmació a l\'administrador després de realitzar una nova comanda',
                    'new-refund'                                       => 'Envia un correu electrònic de notificació al client després de crear un reemborsament',
                    'new-refund-mail-to-admin'                         => 'Envia un correu electrònic de notificació a l\'administrador després de crear un nou reemborsament',
                    'new-shipment'                                     => 'Envia un correu electrònic de notificació al client després de crear un enviament',
                    'new-shipment-mail-to-admin'                       => 'Envia un correu electrònic de notificació a l\'administrador després de crear un nou enviament',
                    'registration'                                     => 'Envia un correu electrònic de confirmació després del registre del client',
                    'title'                                            => 'Notificacions',
                    'verification'                                     => 'Envia un correu electrònic de verificació després del registre del client',
                ],
            ],

            'sales' => [
                'info'  => 'Vendes',
                'title' => 'Vendes',

                'shipping-setting' => [
                    'info'  => 'Configura la configuració d\'enviament, incloent-hi país, estat, ciutat, adreça, codi postal, nom de la botiga, número de l\'IVA, número de contacte i detalls bancaris.',
                    'title' => 'Configuració d\'enviament',

                    'origin' => [
                        'bank-details'   => 'Detalls bancaris',
                        'city'           => 'Ciutat',
                        'contact-number' => 'Número de contacte',
                        'country'        => 'País',
                        'state'          => 'Estat',
                        'store-name'     => 'Nom de la botiga',
                        'street-address' => 'Adreça',
                        'title'          => 'Origen',
                        'title-info'     => 'L\'origen de l\'enviament fa referència al lloc on els béns o productes es generen abans de ser transportats a la seva destinació.',
                        'vat-number'     => 'Número de l\'IVA',
                        'zip'            => 'Codi postal',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Configura els mètodes d\'enviament, incloent-hi enviament gratuït, tarifa plana i opcions addicionals si és necessari.',
                    'title' => 'Mètodes d\'enviament',

                    'free-shipping' => [
                        'description' => 'Descripció',
                        'page-title'  => 'Enviament gratuït',
                        'status'      => 'Estat',
                        'title'       => 'Títol',
                        'title-info'  => '"Enviament gratuït" fa referència a un mètode d\'enviament on s\'abandona el cost d\'enviament i el venedor cobreix les despeses per lliurar els béns al comprador.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Descripció',
                        'page-title'  => 'Enviament amb tarifa plana',
                        'rate'        => 'Tarifa',
                        'status'      => 'Estat',
                        'title'       => 'Títol',
                        'title-info'  => 'L\'enviament amb tarifa plana és un mètode d\'enviament on es cobra una tarifa fixa per l\'enviament, independentment del pes, mida o distància del paquet. Això simplifica els costos d\'enviament i pot ser avantatjós tant per a compradors com per a venedors.',
                        'type'        => [
                            'per-order' => 'Per comanda',
                            'per-unit'  => 'Per unitat',
                            'title'     => 'Tipus',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Monedes acceptades',
                    'accepted-currencies-info'       => 'Afegeix codis de moneda separats per comes, per exemple, USD, INR, ...',
                    'business-account'               => 'Compte d\'empresa',
                    'cash-on-delivery'               => 'Pagament contra entrega',
                    'cash-on-delivery-info'          => 'Mètode de pagament en què els clients paguen en efectiu quan reben els béns o serveis a la seva porta.',
                    'client-id'                      => 'ID de client',
                    'client-id-info'                 => 'Utilitza "sb" per a proves.',
                    'client-secret'                  => 'Clau secreta del client',
                    'client-secret-info'             => 'Afegeix aquí la teva clau secreta',
                    'description'                    => 'Descripció',
                    'generate-invoice'               => 'Generar automàticament la factura després de realitzar una comanda',
                    'generate-invoice-applicable'    => 'Aplicable si es permet la generació automàtica de factures',
                    'info'                           => 'Configura la informació dels mètodes de pagament',
                    'instructions'                   => 'Instruccions',
                    'logo'                           => 'Logotip',
                    'logo-information'               => 'La resolució de la imatge ha de ser de 55px x 45px',
                    'mailing-address'                => 'Enviar xec a',
                    'money-transfer'                 => 'Transferència de diners',
                    'money-transfer-info'            => 'Transferència de fons d\'una persona o compte a un altre, sovint de forma electrònica, per a transaccions o remeses.',
                    'page-title'                     => 'Mètodes de pagament',
                    'paid'                           => 'Pagat',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'Botó intel·ligent de PayPal: simplifica els pagaments en línia amb botons personalitzables per a transaccions segures i multimètode en llocs web i aplicacions.',
                    'paypal-standard'                => 'PayPal estàndard',
                    'paypal-standard-info'           => 'PayPal estàndard és una opció de pagament bàsica de PayPal per a negocis en línia, que permet als clients pagar amb els seus comptes de PayPal o targetes de crèdit/dèbit.',
                    'pending'                        => 'Pendent',
                    'pending-payment'                => 'Pagament pendent',
                    'processing'                     => 'Processant',
                    'sandbox'                        => 'Entorn de proves',
                    'set-invoice-status'             => 'Establir l\'estat de la factura després de crear-la a',
                    'set-order-status'               => 'Establir l\'estat de la comanda després de crear la factura a',
                    'sort-order'                     => 'Ordre de classificació',
                    'status'                         => 'Estat',
                    'title'                          => 'Títol',
                ],

                'order-settings' => [
                    'info'               => 'Configura els números de comanda, les comandes mínimes i les comandes pendents.',
                    'title'              => 'Configuració de comandes',

                    'order-number' => [
                        'generator'   => 'Generador de números de comanda',
                        'info'        => 'Identificador únic assignat a una comanda específica d\'un client, que ajuda a fer un seguiment, la comunicació i la referència durant tot el procés de compra.',
                        'length'      => 'Longitud del número de comanda',
                        'prefix'      => 'Prefix del número de comanda',
                        'suffix'      => 'Sufix del número de comanda',
                        'title'       => 'Configuració del número de comanda',
                    ],

                    'minimum-order' => [
                        'description'             => 'Descripció',
                        'enable'                  => 'Habilitar',
                        'include-discount-amount' => 'Incloure l\'import de descompte',
                        'include-tax-amount'      => 'Incloure impost en l\'import',
                        'info'                    => 'Criteris configurats que especificen la quantitat o el valor mínim requerit per processar una comanda o qualificar per a beneficis.',
                        'minimum-order-amount'    => 'Import mínim de la comanda',
                        'title'                   => 'Configuració de la comanda mínima',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Reordenar com a administrador',
                        'admin-reorder-info' => 'Habilitar o deshabilitar la funció de reordenar per als usuaris administradors.',
                        'info'               => 'Habilitar o deshabilitar la funció de reordenar per als usuaris administradors.',
                        'shop-reorder'       => 'Reordenar com a botiga',
                        'shop-reorder-info'  => 'Habilitar o deshabilitar la funció de reordenar per als usuaris de la botiga.',
                        'title'              => 'Permetre reordenar',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Permetre comandes pendents',
                        'info'              => 'Les opcions d\'estoc són contractes d\'inversió que atorguen el dret de comprar o vendre accions d\'una empresa a un preu predeterminat, influenciant les guanys potencials.',
                        'title'             => 'Opcions d\'estoc',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Configura el número de factura, els terminis de pagament, el disseny del comprovant de factura i els recordatoris de factura.',
                    'title' => 'Configuració de factures',

                    'invoice-number' => [
                        'generator'  => 'Generador de números de factura',
                        'info'       => 'Configuració de regles o paràmetres per generar i assignar números d\'identificació únics a les factures amb fins organitzatius i de seguiment.',
                        'length'     => 'Longitud del número de factura',
                        'prefix'     => 'Prefix del número de factura',
                        'suffix'     => 'Sufix del número de factura',
                        'title'      => 'Configuració del número de factura',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Durada del venciment',
                        'due-duration-day'  => ':due-duration Dia',
                        'due-duration-days' => ':due-duration Dies',
                        'info'              => 'Condicions acordades que dicten quan i com s\'ha de fer el pagament dels béns o serveis per part del comprador al venedor.',
                        'title'             => 'Termes de Pagament',
                    ],

                    'pdf-print-outs' => [
                        'footer-text'      => 'Text del peu de pàgina',
                        'footer-text-info' => 'Introdueix el text que apareixerà al peu de pàgina del PDF.',
                        'info'             => 'Configura les impressions en PDF per mostrar l\'ID de la factura, l\'ID de la comanda a la capçalera i incloure el logotip de la factura.',
                        'invoice-id-info'  => 'Configura la visualització de l\'ID de la factura a la capçalera de la factura.',
                        'invoice-id-title' => 'Mostrar l\'ID de la factura a la capçalera',
                        'logo'             => 'Logotip',
                        'logo-info'        => 'La resolució de la imatge hauria de ser de 131px X 30px.',
                        'order-id-info'    => 'Configura la visualització de l\'ID de la comanda a la capçalera de la factura.',
                        'order-id-title'   => 'Mostrar l\'ID de la comanda a la capçalera',
                        'title'            => 'Impressions en PDF',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Notificacions o comunicacions automàtiques enviades als clients per recordar-los els pagaments pendents o propers a les factures.',
                        'interval-between-reminders' => 'Interval entre recordatoris',
                        'maximum-limit-of-reminders' => 'Límit màxim de recordatoris',
                        'title'                      => 'Recordatoris de Factura',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Impostos',
                    'title-info' => 'Els impostos són taxes obligatòries imposades pels governs sobre béns, serveis o transaccions, recaptades pels venedors i remeses a les autoritats.',

                    'categories' => [
                        'title'      => 'Categories d\'Impostos',
                        'title-info' => 'Les categories d\'impostos són classificacions per a diferents tipus d\'impostos, com ara l\'impost sobre les vendes, l\'impost sobre el valor afegit o l\'impost especial, utilitzades per categoritzar i aplicar tipus d\'impostos a productes o serveis.',
                        'product'    => 'Categoria d\'Impost per Defecte del Producte',
                        'shipping'   => 'Categoria d\'Impost d\'Enviament',
                        'none'       => 'Cap',
                    ],

                    'calculation' => [
                        'title'            => 'Configuració de Càlcul',
                        'title-info'       => 'Detalls sobre el cost dels béns o serveis, incloent el preu base, descomptes, impostos i càrrecs addicionals.',
                        'based-on'         => 'Càlcul Basat en',
                        'shipping-address' => 'Adreça d\'Enviament',
                        'billing-address'  => 'Adreça de Facturació',
                        'shipping-origin'  => 'Origen de l\'Enviament',
                        'product-prices'   => 'Preus dels Productes',
                        'shipping-prices'  => 'Preus d\'Enviament',
                        'excluding-tax'    => 'Excloent Impost',
                        'including-tax'    => 'Incloent Impost',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'País per Defecte',
                        'default-post-code' => 'Codi Postal per Defecte',
                        'default-state'     => 'Estat per Defecte',
                        'title'             => 'Càlcul de Destinació per Defecte',
                        'title-info'        => 'Determinació automàtica d\'una destinació estàndard o inicial basada en factors o configuracions predefinides.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Configuració de Visualització del Carret de la Compra',
                        'title-info'              => 'Configura la visualització dels impostos al carret de la compra',
                        'display-prices'          => 'Mostrar Preus',
                        'display-subtotal'        => 'Mostrar Subtotal',
                        'display-shipping-amount' => 'Mostrar Import d\'Enviament',
                        'excluding-tax'           => 'Excloent Impost',
                        'including-tax'           => 'Incloent Impost',
                        'both'                    => 'Excloent i Incloent Ambdós',
                    ],

                    'sales' => [
                        'title'                   => 'Configuració de Visualització de Comandes, Factures, Reemborsaments',
                        'title-info'              => 'Configura la visualització dels impostos a les comandes, factures i reemborsaments',
                        'display-prices'          => 'Mostrar Preus',
                        'display-subtotal'        => 'Mostrar Subtotal',
                        'display-shipping-amount' => 'Mostrar Import d\'Enviament',
                        'excluding-tax'           => 'Excloent Impost',
                        'including-tax'           => 'Incloent Impost',
                        'both'                    => 'Excloent i Incloent Ambdós',
                    ],
                ],

                'checkout' => [
                    'title' => 'Pagament',
                    'info'  => 'Configura el pagament per a convidats, habilita o deshabilita el Mini Carret, resum del carret.',

                    'shopping-cart' => [
                        'cart-page'              => 'Pàgina del Carret',
                        'cart-page-info'         => 'Controla la visibilitat de la pàgina del carret per millorar l\'experiència de compra de l\'usuari.',
                        'cross-sell'             => 'Productes de venda creuada',
                        'cross-sell-info'        => 'Habilita els productes de venda creuada per augmentar les oportunitats de vendes addicionals.',
                        'estimate-shipping'      => 'Enviament estimat',
                        'estimate-shipping-info' => 'Habilita l\'enviament estimat per proporcionar costos d\'enviament anticipats.',
                        'guest-checkout'         => 'Permetre el pagament per a convidats',
                        'guest-checkout-info'    => 'Habilita el pagament per a convidats per a un procés de compra més ràpid i sense complicacions.',
                        'info'                   => 'Habilita el pagament per a convidats, la pàgina del carret, els productes de venda creuada i l\'enviament estimat per millorar la comoditat de l\'usuari i agilitzar el procés de compra per augmentar les vendes.',
                        'title'                  => 'Carret de la compra',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Mostrar quantitats d\'articles',
                        'display-number-in-cart'  => 'Mostrar el nombre d\'articles al carret',
                        'info'                    => 'Habilita la configuració del Meu Carret per mostrar un resum de les quantitats d\'articles i mostrar el nombre total d\'articles al carret per a un seguiment fàcil.',
                        'summary'                 => 'Resum',
                        'title'                   => 'El meu carret',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Mostrar Mini Carret',
                        'info'                 => 'Habilita la configuració del Mini Carret per mostrar el mini carret i mostrar la informació de l\'oferta del Mini Carret per a un accés ràpid als detalls del carret i promocions.',
                        'mini-cart-offer-info' => 'Informació de l\'oferta del Mini Carret',
                        'title'                => 'Mini Carret',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Compte',
                'app-version'   => 'Versió : :version',
                'logout'        => 'Tancar sessió',
                'my-account'    => 'El meu compte',
                'notifications' => 'Notificacions',
                'visit-shop'    => 'Visitar botiga',

                'mega-search' => [
                    'categories'                      => 'Categories',
                    'customers'                       => 'Clients',
                    'explore-all-categories'          => 'Explorar totes les categories',
                    'explore-all-customers'           => 'Explorar tots els clients',
                    'explore-all-matching-categories' => 'Explorar totes les categories que coincideixen amb \":query\" (:count)',
                    'explore-all-matching-customers'  => 'Explorar tots els clients que coincideixen amb \":query\" (:count)',
                    'explore-all-matching-orders'     => 'Explorar totes les comandes que coincideixen amb \":query\" (:count)',
                    'explore-all-matching-products'   => 'Explorar tots els productes que coincideixen amb \":query\" (:count)',
                    'explore-all-orders'              => 'Explorar totes les comandes',
                    'explore-all-products'            => 'Explorar tots els productes',
                    'orders'                          => 'Comandes',
                    'products'                        => 'Productes',
                    'sku'                             => 'SKU: :sku',
                    'title'                           => 'Cerca avançada',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Famílies d\'atributs',
                'attributes'               => 'Atributs',
                'booking-product'          => 'Reserves',
                'campaigns'                => 'Campanyes',
                'catalog'                  => 'Catàleg',
                'categories'               => 'Categories',
                'channels'                 => 'Canals',
                'cms'                      => 'CMS',
                'collapse'                 => 'Col·lapsar',
                'communications'           => 'Comunicacions',
                'configure'                => 'Configurar',
                'currencies'               => 'Monedes',
                'customers'                => 'Clients',
                'dashboard'                => 'Tauler de control',
                'data-transfer'            => 'Transferència de dades',
                'discount'                 => 'Descompte',
                'email-templates'          => 'Plantilles de correu electrònic',
                'events'                   => 'Esdeveniments',
                'exchange-rates'           => 'Taxes de canvi',
                'gdpr-data-requests'       => 'Sol·licituds de dades GDPR',
                'groups'                   => 'Grups',
                'imports'                  => 'Importacions',
                'inventory-sources'        => 'Fonts d\'inventari',
                'invoices'                 => 'Factures',
                'locales'                  => 'Ubicacions',
                'marketing'                => 'Màrqueting',
                'mode'                     => 'Mode fosc',
                'newsletter-subscriptions' => 'Subscriure\'s al butlletí',
                'orders'                   => 'Comandes',
                'products'                 => 'Productes',
                'promotions'               => 'Promocions',
                'refunds'                  => 'Reemborsaments',
                'reporting'                => 'Informes',
                'reviews'                  => 'Resenyes',
                'roles'                    => 'Rols',
                'sales'                    => 'Vendes',
                'search-seo'               => 'Cerca i SEO',
                'search-synonyms'          => 'Sinònims de cerca',
                'search-terms'             => 'Termes de cerca',
                'settings'                 => 'Configuració',
                'shipments'                => 'Enviaments',
                'sitemaps'                 => 'Mapes del lloc',
                'tax-categories'           => 'Categories d\'impostos',
                'tax-rates'                => 'Taxes d\'impostos',
                'taxes'                    => 'Impostos',
                'themes'                   => 'Temes',
                'transactions'             => 'Transaccions',
                'url-rewrites'             => 'Reescriptures d\'URL',
                'users'                    => 'Usuaris',
            ],

            'powered-by' => [
                'description' => 'Desenvolupat per :bagisto, un projecte de codi obert per :webkul.',
            ],
        ],

        'datagrid' => [
            'index' => [
                'must-select-a-mass-action'        => 'Heu de seleccionar una acció massiva.',
                'must-select-a-mass-action-option' => 'Heu de seleccionar una opció d\'acció massiva.',
                'no-records-selected'              => 'No s\'han seleccionat registres.',
            ],

            'toolbar' => [
                'length-of' => ':length de',
                'of'        => 'de',
                'per-page'  => 'Per pàgina',
                'results'   => ':total Resultats',
                'selected'  => ':total Seleccionats',

                'mass-actions' => [
                    'select-action' => 'Seleccionar acció',
                    'select-option' => 'Seleccionar opció',
                    'submit'        => 'Enviar',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Aplicar filtres',
                    'back-btn'          => 'Enrere',
                    'create-new-filter' => 'Crear nou filtre',
                    'custom-filters'    => 'Filtres personalitzats',
                    'delete-error'      => 'Alguna cosa ha anat malament en eliminar el filtre, si us plau, proveu-ho de nou.',
                    'delete-success'    => 'El filtre s\'ha eliminat correctament.',
                    'empty-description' => 'No hi ha filtres seleccionats disponibles per desar. Si us plau, seleccioneu filtres per desar.',
                    'empty-title'       => 'Afegir filtres per desar',
                    'name'              => 'Nom',
                    'quick-filters'     => 'Filtres ràpids',
                    'save-btn'          => 'Desar',
                    'save-filter'       => 'Desar filtre',
                    'saved-success'     => 'El filtre s\'ha desat correctament.',
                    'selected-filters'  => 'Filtres seleccionats',
                    'title'             => 'Filtre',
                    'update'            => 'Actualitzar',
                    'update-filter'     => 'Actualitzar filtre',
                    'updated-success'   => 'El filtre s\'ha actualitzat correctament.',
                ],

                'search' => [
                    'title' => 'Cercar',
                ],
            ],

            'filters' => [
                'select' => 'Seleccionar.',
                'title'  => 'Filtres',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Escriviu almenys 2 caràcters...',
                        'no-results'        => 'No s\'han trobat resultats...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Netejar tot',
                    'title'     => 'Filtres personalitzats',
                ],

                'boolean-options' => [
                    'false' => 'Fals',
                    'true'  => 'Cert',
                ],

                'date-options' => [
                    'last-month'        => 'Mes anterior',
                    'last-six-months'   => 'Últims 6 mesos',
                    'last-three-months' => 'Últims 3 mesos',
                    'this-month'        => 'Aquest mes',
                    'this-week'         => 'Aquesta setmana',
                    'this-year'         => 'Aquest any',
                    'today'             => 'Avui',
                    'yesterday'         => 'Ahir',
                ],
            ],

            'table' => [
                'actions'              => 'Accions',
                'no-records-available' => 'No hi ha registres disponibles.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Acceptar',
                'disagree-btn' => 'Cancel·lar',
                'message'      => 'Estàs segur que vols realitzar aquesta acció?',
                'title'        => 'Estàs segur?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Afegir producte seleccionat',
                'empty-info'    => 'No hi ha productes disponibles per al terme de cerca.',
                'empty-title'   => 'No s\'han trobat productes',
                'product-image' => 'Imatge del producte',
                'qty'           => ':qty disponible',
                'sku'           => 'SKU - :sku',
                'title'         => 'Seleccionar productes',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => 'Afegir Imatge',
                'ai-add-image-btn'  => 'Màgia IA',
                'ai-btn-info'       => 'Generar Imatge',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Només es permeten arxius d\'imatge (.jpeg, .jpg, .png, ..)',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Aplicar',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => 'Generar',
                    'generating'       => 'Generant...',
                    'hd'               => 'HD',
                    'model'            => 'Model',
                    'number-of-images' => 'Número d\'Imatges',
                    'prompt'           => 'Indicació',
                    'quality'          => 'Qualitat',
                    'regenerate'       => 'Regenerar',
                    'regenerating'     => 'Regenerant...',
                    'size'             => 'Mida',
                    'standard'         => 'Estàndard',
                    'title'            => 'Generació d\'Imatges amb IA',
                ],

                'placeholders'  => [
                    'front'     => 'Frontal',
                    'next'      => 'Següent',
                    'size'      => 'Mida',
                    'use-cases' => 'Casos d\'Ús',
                    'zoom'      => 'Zoom',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Afegir Vídeo',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Només es permeten arxius de vídeo (.mp4, .mov, .ogg ..).',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Màgia IA',

            'ai-generation' => [
                'apply'                    => 'Aplicar',
                'deepseek-r1-8b'           => 'DeepSeek R1 (8b)',
                'enabled'                  => 'Habilitat',
                'gemini-2-0-flash'         => 'Gemini 2.0 Flash',
                'generate'                 => 'Generar',
                'generated-content'        => 'Contingut Generat',
                'generated-content-info'   => 'El contingut generat per IA pot ser enganyós. Si us plau, revisa el contingut generat abans d\'aplicar-lo.',
                'generating'               => 'Generant...',
                'gpt-4-turbo'              => 'OpenAI gpt-4 Turbo',
                'gpt-4o'                   => 'OpenAI gpt-4o',
                'gpt-4o-mini'              => 'OpenAI gpt-4o mini',
                'llama-groq'               => 'Llama 3.3 (Groq)',
                'llama3-1-8b'              => 'Llama 3.1 (8B)',
                'llama3-2-1b'              => 'Llama 3.2 (1B)',
                'llama3-2-3b'              => 'Llama 3.2 (3B)',
                'llama3-8b'                => 'Llama 3 (8B)',
                'llava-7b'                 => 'Llava (7b)',
                'mistral-7b'               => 'Mistral (7b)',
                'model'                    => 'Model',
                'orca-mini'                => 'Orca Mini',
                'phi3-5'                   => 'Phi 3.5',
                'prompt'                   => 'Indicació',
                'qwen2-5-0-5b'             => 'Qwen 2.5 (0.5b)',
                'qwen2-5-1-5b'             => 'Qwen 2.5 (1.5b)',
                'qwen2-5-14b'              => 'Qwen 2.5 (14b)',
                'qwen2-5-3b'               => 'Qwen 2.5 (3b)',
                'qwen2-5-7b'               => 'Qwen 2.5 (7b)',
                'starling-lm-7b'           => 'Starling-lm (7b)',
                'title'                    => 'Assistència IA',
                'vicuna-13b'               => 'Vicuna (13b)',
                'vicuna-7b'                => 'Vicuna (7b)',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Adreces',
        'attribute-families'       => 'Famílies d\'Atributs',
        'attributes'               => 'Atributs',
        'campaigns'                => 'Campanyes',
        'cancel'                   => 'Cancel·lar',
        'cart-rules'               => 'Regles del Carret',
        'catalog-rules'            => 'Regles del Catàleg',
        'catalog'                  => 'Catàleg',
        'categories'               => 'Categories',
        'channels'                 => 'Canals',
        'cms'                      => 'CMS',
        'communications'           => 'Comunicacions',
        'configure'                => 'Configurar',
        'copy'                     => 'Copiar',
        'create'                   => 'Crear',
        'currencies'               => 'Monedes',
        'customers'                => 'Clients',
        'dashboard'                => 'Tauler',
        'data-transfer'            => 'Transferència de Dades',
        'delete'                   => 'Eliminar',
        'edit'                     => 'Editar',
        'email-templates'          => 'Plantilles de Correu Electrònic',
        'events'                   => 'Esdeveniments',
        'exchange-rates'           => 'Taxes de Canvi',
        'gdpr'                     => 'RGPD',
        'groups'                   => 'Grups',
        'import'                   => 'Importar',
        'imports'                  => 'Imports',
        'inventory-sources'        => 'Fonts d\'Inventari',
        'invoices'                 => 'Factures',
        'locales'                  => 'Ubicacions',
        'marketing'                => 'Màrqueting',
        'newsletter-subscriptions' => 'Subscricpions al Butlletí',
        'note'                     => 'Nota',
        'orders'                   => 'Comandes',
        'products'                 => 'Productes',
        'promotions'               => 'Promocions',
        'refunds'                  => 'Reemborsaments',
        'reporting'                => 'Informes',
        'reviews'                  => 'Resenyes',
        'roles'                    => 'Rols',
        'sales'                    => 'Vendes',
        'search-seo'               => 'Cerca i SEO',
        'search-synonyms'          => 'Sinònims de Cerca',
        'search-terms'             => 'Termes de Cerca',
        'settings'                 => 'Configuració',
        'shipments'                => 'Enviaments',
        'sitemaps'                 => 'Mapes del lloc',
        'subscribers'              => 'Subscriptors del Butlletí',
        'tax-categories'           => 'Categories d\'Impostos',
        'tax-rates'                => 'Taxes d\'Impostos',
        'taxes'                    => 'Impostos',
        'themes'                   => 'Temes',
        'transactions'             => 'Transaccions',
        'url-rewrites'             => 'Reescriptures d\'URL',
        'users'                    => 'Usuaris',
        'view'                     => 'Veure',
    ],

    'errors' => [
        'dashboard' => 'Taulell',
        'go-back'   => 'Tornar',
        'support'   => 'Si el problema persisteix, contàctins a <a href=":link" class=":class">:email</a> per a obtenir ajuda.',

        '404' => [
            'description' => '¡Ups! La pàgina que estàs buscant està de vacacions. Sembla que no hem pogut trobar allò que buscaves.',
            'title'       => '404 Pàgina no Trobada',
        ],

        '401' => [
            'description' => '¡Ups!  Sembla que no tens permís per a accedir a aquesta pàgina. Sembla que et falten les credencials necessàries.',
            'title'       => '401 No Autoritzat',
        ],

        '403' => [
            'description' => '¡Ups! Aquesta pàgina està fòra dels límits. Sembla que no tens els permisos necessaris per a veure aquest contingut.',
            'title'       => '403 Prohibit',
        ],

        '500' => [
            'description' => '¡Ups! Alguna cosa ha sortit malament. Sembla que tenim problemes per a carregar la pàgina que estàs buscant.',
            'title'       => '500 Error Intern del Servidor',
        ],

        '503' => [
            'description' => '¡Ups! Sembla que estem temporalment fòra de servei por manteniment. Si us plau, torna a intentar-ho en una estona.',
            'title'       => '503 Servei No Disponible',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Descarregar',
        'export'     => 'Exportar',
        'no-records' => 'Res que exportar',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Aquest slug s\'està fent servir en categories o productes.',
        'slug-reserved'   => 'Aquest slug està reservat.',
    ],

    'footer' => [
        'copy-right' => 'Desenvolupat per <a href="https://bagisto.com/" target="_blank">Bagisto</a>, Un Projecte Comunitari per <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Estimat :admin_name',
        'thanks' => 'Si necessites qualsevol tipus d\'ajuda, si us plau contàctans en <a href=":link" style=":style">:email</a>.<br/>¡Gràcies!',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Has rebut aquest correu electrònic perquè hem rebut una sol·licitud per restablir la contrasenya del teu compte.',
                'greeting'       => 'Contrasenya oblidada!',
                'reset-password' => 'Restablir contrasenya',
                'subject'        => 'Correu electrònic per restablir la contrasenya',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'S\'ha creat correctament un nou compte de client. Ara poden iniciar sessió amb les seves credencials d\'adreça de correu electrònic i contrasenya. Un cop hagin iniciat sessió, tindran accés a diversos serveis, inclòs la capacitat de revisar comandes anteriors, gestionar llistes de desitjos i actualitzar la informació del seu compte.',
                'greeting'    => 'Donem una càlida benvinguda al nou client, :customer_name que s\'ha registrat amb nosaltres!',
                'subject'     => 'Registre de nou client',
            ],

            'gdpr' => [
                'new-delete-request' => 'New Request For Data Delete',
                'new-update-request' => 'New Request For Data Update',

                'new-request' => [
                    'customer-name'  => 'Nom du client : ',
                    'delete-summary' => 'Zusammenfassung der Löschanforderung',
                    'message'        => 'Message : ',
                    'request-status' => 'Request Status : ',
                    'request-type'   => 'Request Type : ',
                    'summary'        => 'Summary of Request',
                    'update-summary' => 'Zusammenfassung der Aktualisierungsanforderung',
                ],

                'status-update' => [
                    'subject'        => 'GDPR Request Has Been Updated',
                    'summary'        => 'The GDPR Request Status Has Been Updated',
                    'request-status' => 'Request Status:',
                    'request-type'   => 'Request Type:',
                    'message'        => 'Message:',
                ],
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Tens una nova comanda :order_id realitzada el :created_at',
                'subject'  => 'Confirmació de Nova Comanda',
                'summary'  => 'Resum de la Comanda',
                'title'    => 'Confirmació de Comanda!',
            ],

            'invoiced' => [
                'greeting' => 'La teva factura #:invoice_id per a la comanda :order_id s\'ha creat el :created_at',
                'subject'  => 'Confirmació de Nova Factura',
                'summary'  => 'Resum de la Factura',
                'title'    => 'Confirmació de Factura!',
            ],

            'shipped' => [
                'greeting' => 'Has enviat la comanda :order_id realitzada el :created_at',
                'subject'  => 'Confirmació de Nou Enviament',
                'summary'  => 'Resum de l\'Enviament',
                'title'    => 'Comanda Enviada!',
            ],

            'inventory-source' => [
                'greeting' => 'Has enviat la comanda :order_id realitzada el :created_at',
                'subject'  => 'Confirmació de Nou Enviament',
                'summary'  => 'Resum de l\'Enviament',
                'title'    => 'Comanda Enviada!',
            ],

            'refunded' => [
                'greeting' => 'Has reemborsat la comanda :order_id realitzada el :created_at',
                'subject'  => 'Confirmació de Nou Reemborsament',
                'summary'  => 'Resum del Reemborsament',
                'title'    => 'Comanda Reemborsada!',
            ],

            'canceled' => [
                'greeting' => 'Has cancel·lat la comanda :order_id realitzada el :created_at',
                'subject'  => 'Confirmació de Cancel·lació de Comanda',
                'summary'  => 'Resum de la Comanda',
                'title'    => 'Comanda Cancel·lada!',
            ],

            'billing-address'            => 'Adreça de Facturació',
            'carrier'                    => 'Transportista',
            'contact'                    => 'Contacte',
            'discount'                   => 'Descompte',
            'excl-tax'                   => 'Excl. Impostos: ',
            'grand-total'                => 'Total General',
            'name'                       => 'Nom',
            'payment'                    => 'Pagament',
            'price'                      => 'Preu',
            'qty'                        => 'Quantitat',
            'shipping-address'           => 'Adreça d\'Enviament',
            'shipping-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
            'shipping-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
            'shipping-handling'          => 'Enviament i Manipulació',
            'shipping'                   => 'Enviament',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Subtotal (Excl. Impostos)',
            'subtotal-incl-tax'          => 'Subtotal (Incl. Impostos)',
            'subtotal'                   => 'Subtotal',
            'tax'                        => 'Impostos',
            'tracking-number'            => 'Número de Seguiment: :tracking_number',
        ],
    ],
];
