<?php

return [
    'users' => [
        'sessions' => [
            'email'                  => 'Indirizzo Email',
            'forget-password-link'   => 'Password Dimenticata?',
            'password'               => 'Password',
            'powered-by-description' => 'Powered by :bagisto, un progetto open-source di :webkul.',
            'submit-btn'             => 'Accedi',
            'title'                  => 'Accedi',
        ],

        'forget-password' => [
            'create'    => [
                'email'                  => 'Email Registrata',
                'email-not-exist'        => 'Email Non Esistente',
                'page-title'             => 'Password Dimenticata',
                'powered-by-description' => 'Powered by :bagisto, un progetto open-source di :webkul.',
                'reset-link-sent'        => 'Link per il ripristino della password inviato',
                'sign-in-link'           => 'Torna al Login?',
                'submit-btn'             => 'Ripristina',
                'title'                  => 'Recupera Password',
            ],
        ],

        'reset-password' => [
            'back-link-title'        => 'Torna al Login?',
            'confirm-password'       => 'Conferma Password',
            'email'                  => 'Email Registrata',
            'password'               => 'Password',
            'powered-by-description' => 'Powered by :bagisto, un progetto open-source di :webkul.',
            'submit-btn'             => 'Ripristina Password',
            'title'                  => 'Ripristina Password',
        ],
    ],

    'notifications' => [
        'description-text' => 'Elenca tutte le notifiche',
        'marked-success'   => 'Tutte le notifiche sono state segnate come lette',
        'no-record'        => 'Nessun Record Trovato',
        'of'               => 'di',
        'per-page'         => 'Per pagina',
        'read-all'         => 'Segna come Letto',
        'title'            => 'Notifiche',
        'view-all'         => 'Visualizza Tutte',

        'order-status-messages' => [
            'all'             => 'Tutti',
            'canceled'        => 'Ordine Annullato',
            'closed'          => 'Ordine Chiuso',
            'completed'       => 'Ordine Completato',
            'pending'         => 'Ordine in Sospeso',
            'pending-payment' => 'Pagamento in Sospeso',
            'processing'      => 'Ordine in Elaborazione',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Indietro',
            'change-password'   => 'Cambia Password',
            'confirm-password'  => 'Conferma Password',
            'current-password'  => 'Password Attuale',
            'email'             => 'Email',
            'general'           => 'Generale',
            'invalid-password'  => 'La password attuale inserita non è corretta.',
            'name'              => 'Nome',
            'password'          => 'Password',
            'profile-image'     => 'Immagine Profilo',
            'save-btn'          => 'Salva Account',
            'title'             => 'Il Mio Account',
            'update-success'    => 'Account aggiornato con successo',
            'upload-image-info' => 'Carica un\'Immagine del Profilo (110px X 110px) in formato PNG o JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Aggiungi Cliente',
            'add-product'                 => 'Aggiungi Prodotto',
            'all-channels'                => 'Tutti i Canali',
            'attribute-code'              => 'Codice Attributo',
            'average-sale'                => 'Vendita Media Ordine',
            'color'                       => 'Colore',
            'customer-info'               => 'Nessun Cliente Trovato con Più Vendite',
            'customer-with-most-sales'    => 'Cliente con Più Vendite',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Soglia di Vuoto',
            'empty-threshold-description' => 'Non ci sono prodotti disponibili',
            'end-date'                    => 'Data di Fine',
            'from'                        => 'Da',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ Altre Immagini',
            'order'                       => ':total_orders Ordini',
            'order-count'                 => ':count Ordini',
            'order-id'                    => '#:id',
            'overall-details'             => 'Dettagli Generali',
            'pay-by'                      => 'Pagato Con - :method',
            'product-count'               => ':count Prodotti',
            'product-image'               => 'Immagine Prodotto',
            'product-info'                => 'Aggiungi prodotti correlati in modo rapido.',
            'product-number'              => 'Prodotto - :product_number',
            'revenue'                     => 'Ricavo :total',
            'sale-count'                  => ':count Vendite',
            'sales'                       => 'Vendite',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => 'Data di Inizio',
            'stock-threshold'             => 'Soglia di Stock',
            'store-stats'                 => 'Statistiche del Negozio',
            'title'                       => 'Dashboard',
            'to'                          => 'A',
            'today-customers'             => 'Clienti di Oggi',
            'today-details'               => 'Dettagli di Oggi',
            'today-orders'                => 'Ordini di Oggi',
            'today-sales'                 => 'Vendite di Oggi',
            'top-performing-categories'   => 'Categorie più Performanti',
            'top-selling-products'        => 'Prodotti più Venduti',
            'total-customers'             => 'Totale Clienti',
            'total-orders'                => 'Totale Ordini',
            'total-sales'                 => 'Totale Vendite',
            'total-stock'                 => 'Stock :total_stock',
            'total-unpaid-invoices'       => 'Totale Fatture Non Pagate',
            'unique-visitors'             => ':count unici',
            'user-info'                   => 'Rivedi rapidamente cosa sta succedendo nel tuo negozio',
            'user-name'                   => 'Ciao ! :user_name',
            'visitors'                    => 'Visitatori',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Crea Ordine',
                'title'      => 'Ordini',

                'search-customer' => [
                    'create-btn'  => 'Crea Cliente',
                    'empty-info'  => 'Nessun cliente disponibile per il termine di ricerca.',
                    'empty-title' => 'Nessun cliente trovato',
                    'search-by'   => 'Cerca per email o nome',
                    'title'       => 'Seleziona Cliente',
                ],

                'datagrid' => [
                    'canceled'        => 'Annullato',
                    'channel-name'    => 'Canale',
                    'closed'          => 'Chiuso',
                    'completed'       => 'Completato',
                    'customer'        => 'Cliente',
                    'date'            => 'Data',
                    'email'           => 'Email',
                    'fraud'           => 'Frode',
                    'grand-total'     => 'Totale Generale',
                    'id'              => '#:id',
                    'items'           => 'Prodotti',
                    'location'        => 'Posizione',
                    'order-id'        => 'ID Ordine',
                    'pay-by'          => 'Paga con - :method',
                    'pay-via'         => 'Paga tramite',
                    'pending-payment' => 'Pagamento in Sospeso',
                    'pending'         => 'In Attesa',
                    'processing'      => 'In Elaborazione',
                    'product-count'   => ':count + Altri Prodotti',
                    'status'          => 'Stato',
                    'success'         => 'Successo',
                    'view'            => 'Visualizza',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'Aggiungi al Carrello',
                'back-btn'                => 'Indietro',
                'check-billing-address'   => 'Indirizzo di fatturazione mancante.',
                'check-shipping-address'  => 'Indirizzo di spedizione mancante.',
                'configuration'           => 'Configurazione',
                'coupon-already-applied'  => 'Codice coupon già applicato.',
                'coupon-applied'          => 'Codice coupon applicato con successo.',
                'coupon-error'            => 'Impossibile applicare il codice coupon.',
                'coupon-not-found'        => 'Coupon non trovato',
                'coupon-remove'           => 'Codice coupon rimosso con successo.',
                'error'                   => 'Si è verificato un errore',
                'minimum-order-error'     => 'L\'importo minimo dell\'ordine non è stato raggiunto.',
                'order-placed-success'    => 'Ordine effettuato con successo.',
                'payment-not-supported'   => 'Questo metodo di pagamento non è supportato',
                'save-btn'                => 'Crea Ordine',
                'specify-payment-method'  => 'Metodo di pagamento mancante.',
                'specify-shipping-method' => 'Metodo di spedizione mancante.',
                'title'                   => 'Crea Ordine per :name',

                'types' => [
                    'simple' => [
                        'none'         => 'Nessuno',
                        'total-amount' => 'Importo Totale',
                    ],

                    'configurable' => [
                        'select-options' => 'Seleziona un\'opzione',
                    ],

                    'bundle' => [
                        'none'         => 'Nessuno',
                        'total-amount' => 'Importo Totale',
                    ],

                    'grouped' => [
                        'name' => 'Nome',
                    ],

                    'downloadable' => [
                        'title' => 'Link',
                    ],

                    'virtual' => [
                        'none'         => 'Nessuno',
                        'total-amount' => 'Importo Totale',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Prodotto aggiunto al carrello con successo',
                    'success-remove'      => 'Elemento rimosso dal carrello con successo',
                    'success-update'      => 'Elemento del carrello aggiornato con successo',

                    'items' => [
                        'add-product'       => 'Aggiungi Prodotto',
                        'amount-per-unit'   => ':amount Per Unità x :qty Quantità',
                        'delete'            => 'Elimina',
                        'empty-description' => 'Nessun elemento trovato nel carrello.',
                        'empty-title'       => 'Carrello Vuoto',
                        'excl-tax'          => 'Escl. IVA',
                        'move-to-wishlist'  => 'Sposta in Lista dei Desideri',
                        'see-details'       => 'Vedi Dettagli',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => 'Subtotale - :sub_total',
                        'title'             => 'Elementi del Carrello',

                        'search' => [
                            'add-to-cart'   => 'Aggiungi al Carrello',
                            'available-qty' => ':qty Disponibili',
                            'empty-info'    => 'Nessun prodotto disponibile per il termine di ricerca.',
                            'empty-title'   => 'Nessun prodotto trovato',
                            'product-image' => 'Immagine del Prodotto',
                            'qty'           => 'Quantità',
                            'sku'           => 'SKU - :sku',
                            'title'         => 'Cerca Prodotti',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Aggiungi Indirizzo',
                        'add-new'          => 'Aggiungi nuovo indirizzo',
                        'add-new-address'  => 'Aggiungi nuovo indirizzo',
                        'addresses'        => 'Indirizzi',
                        'back'             => 'Indietro',
                        'billing-address'  => 'Indirizzo di Fatturazione',
                        'city'             => 'Città',
                        'company-name'     => 'Nome Azienda',
                        'confirm'          => 'Conferma',
                        'country'          => 'Paese',
                        'edit-btn'         => 'Modifica Indirizzo',
                        'email'            => 'Email',
                        'first-name'       => 'Nome',
                        'last-name'        => 'Cognome',
                        'postcode'         => 'CAP',
                        'proceed'          => 'Procedi',
                        'same-as-billing'  => 'Usa lo stesso indirizzo per la spedizione?',
                        'save'             => 'Salva',
                        'save-address'     => 'Salva in rubrica',
                        'select-country'   => 'Seleziona Paese',
                        'select-state'     => 'Seleziona Stato',
                        'shipping-address' => 'Indirizzo di Spedizione',
                        'state'            => 'Stato',
                        'street-address'   => 'Indirizzo',
                        'telephone'        => 'Telefono',
                        'title'            => 'Indirizzo',
                        'vat-id'           => 'Partita IVA',
                    ],

                    'payment' => [
                        'title' => 'Pagamento',
                    ],

                    'shipping' => [
                        'title' => 'Spedizione',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Applica Coupon',
                        'discount-amount'          => 'Importo Sconto',
                        'enter-your-code'          => 'Inserisci il tuo codice',
                        'grand-total'              => 'Totale',
                        'place-order'              => 'Effettua Ordine',
                        'processing'               => 'Elaborazione',
                        'shipping-amount-excl-tax' => 'Importo Spedizione (Escl. IVA)',
                        'shipping-amount-incl-tax' => 'Importo Spedizione (Incl. IVA)',
                        'shipping-amount'          => 'Importo Spedizione',
                        'sub-total-excl-tax'       => 'Subtotale (Escl. IVA)',
                        'sub-total-incl-tax'       => 'Subtotale (Incl. IVA)',
                        'sub-total'                => 'Subtotale',
                        'tax'                      => 'IVA',
                        'title'                    => 'Riepilogo Ordine',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'Aggiungi al Carrello',
                    'delete'            => 'Elimina',
                    'empty-description' => 'Nessun elemento trovato nel carrello.',
                    'empty-title'       => 'Carrello Vuoto',
                    'excl-tax'          => 'Escl. IVA: ',
                    'see-details'       => 'Vedi Dettagli',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementi del Carrello',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'Aggiungi al Carrello',
                    'empty-description' => 'Nessun elemento trovato nei tuoi ordini recenti.',
                    'empty-title'       => 'Ordini Vuoti',
                    'see-details'       => 'Vedi Dettagli',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementi degli Ordini Recenti',
                    'view'              => 'Visualizza',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'Aggiungi al Carrello',
                    'delete'            => 'Elimina',
                    'empty-description' => 'Nessun elemento trovato nella tua lista dei desideri.',
                    'empty-title'       => 'Elementi della Lista dei Desideri Vuoti',
                    'see-details'       => 'Vedi Dettagli',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementi della Lista dei Desideri',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'Aggiungi al Carrello',
                    'delete'            => 'Elimina',
                    'empty-description' => 'Nessun elemento trovato nella tua lista di confronto.',
                    'empty-title'       => 'Elementi di Confronto Vuoti',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementi di Confronto',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Per Unità x :qty Quantità',
                'billing-address'                => 'Indirizzo di Fatturazione',
                'cancel'                         => 'Annulla',
                'cancel-msg'                     => 'Sei sicuro di voler annullare questo ordine',
                'cancel-success'                 => 'Ordine annullato con successo',
                'canceled'                       => 'Annullato',
                'channel'                        => 'Canale',
                'closed'                         => 'Chiuso',
                'comment-success'                => 'Commento aggiunto con successo.',
                'comments'                       => 'Commenti',
                'completed'                      => 'Completato',
                'contact'                        => 'Contatto',
                'create-success'                 => 'Ordine creato con successo',
                'currency'                       => 'Valuta',
                'customer'                       => 'Cliente',
                'customer-group'                 => 'Gruppo Cliente',
                'customer-not-notified'          => ':date | Cliente <b>Non Notificato</b>',
                'customer-notified'              => ':date | Cliente <b>Notificato</b>',
                'discount'                       => 'Sconto - :discount',
                'download-pdf'                   => 'Scarica PDF',
                'fraud'                          => 'Frode',
                'grand-total'                    => 'Totale - :grand_total',
                'invoice-id'                     => 'Fattura #:invoice',
                'invoices'                       => 'Fatture',
                'item-canceled'                  => 'Annullato (:qty_canceled)',
                'item-invoice'                   => 'Fatturato (:qty_invoiced)',
                'item-ordered'                   => 'Ordinato (:qty_ordered)',
                'item-refunded'                  => 'Rimborsato (:qty_refunded)',
                'item-shipped'                   => 'Spedito (:qty_shipped)',
                'name'                           => 'Nome',
                'no-invoice-found'               => 'Nessuna Fattura Trovata',
                'no-refund-found'                => 'Nessun Rimborso Trovato',
                'no-shipment-found'              => 'Nessuna Spedizione Trovata',
                'notify-customer'                => 'Notifica Cliente',
                'order-date'                     => 'Data Ordine',
                'order-information'              => 'Informazioni Ordine',
                'order-status'                   => 'Stato Ordine',
                'payment-and-shipping'           => 'Pagamento e Spedizione',
                'payment-method'                 => 'Metodo di Pagamento',
                'pending'                        => 'In Attesa',
                'pending_payment'                => 'Pagamento in Sospeso',
                'per-unit'                       => 'Per Unità',
                'price'                          => 'Prezzo - :price',
                'price-excl-tax'                 => 'Prezzo (Escl. Tasse) - :price',
                'price-incl-tax'                 => 'Prezzo (Incl. Tasse) - :price',
                'processing'                     => 'In Elaborazione',
                'quantity'                       => 'Quantità',
                'refund'                         => 'Rimborso',
                'refund-id'                      => 'Rimborso #:refund',
                'refunded'                       => 'Rimborsato',
                'reorder'                        => 'Riordina',
                'ship'                           => 'Spedisci',
                'shipment'                       => 'Spedizione #:shipment',
                'shipments'                      => 'Spedizioni',
                'shipping-address'               => 'Indirizzo di Spedizione',
                'shipping-and-handling'          => 'Spedizione e Gestione',
                'shipping-and-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-and-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-method'                => 'Metodo di Spedizione',
                'shipping-price'                 => 'Prezzo Spedizione',
                'sku'                            => 'SKU - :sku',
                'status'                         => 'Stato',
                'sub-total'                      => 'Sub Totale - :sub_total',
                'sub-total-excl-tax'             => 'Sub Totale (Escl. Tasse) - :sub_total',
                'sub-total-incl-tax'             => 'Sub Totale (Incl. Tasse) - :sub_total',
                'submit-comment'                 => 'Invia Commento',
                'summary-discount'               => 'Sconto',
                'summary-grand-total'            => 'Totale',
                'summary-sub-total'              => 'Sub Totale',
                'summary-sub-total-excl-tax'     => 'Sub Totale (Escl. Tasse)',
                'summary-sub-total-incl-tax'     => 'Sub Totale (Incl. Tasse)',
                'summary-tax'                    => 'Tasse',
                'tax'                            => 'Tasse (:percent) - :tax',
                'title'                          => 'Ordine #:order_id',
                'total-due'                      => 'Totale Dovuto',
                'total-paid'                     => 'Totale Pagato',
                'total-refund'                   => 'Totale Rimborso',
                'view'                           => 'Visualizza',
                'write-your-comment'             => 'Scrivi il tuo commento',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Spedizioni',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Origine Inventario',
                    'order-date'       => 'Data Ordine',
                    'order-id'         => 'ID Ordine',
                    'shipment-date'    => 'Data Spedizione',
                    'shipment-to'      => 'Spedizione a',
                    'total-qty'        => 'Quantità Totale',
                    'view'             => 'Visualizza',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount Per Unità x :qty Quantità',
                'cancel-error'     => 'L\'ordine non può essere annullato',
                'carrier-name'     => 'Nome Trasportatore',
                'create-btn'       => 'Crea Spedizione',
                'creation-error'   => 'Errore nella creazione della spedizione',
                'item-canceled'    => 'Annullato (:qty_canceled)',
                'item-invoice'     => 'Fatturato (:qty_invoiced)',
                'item-ordered'     => 'Ordinato (:qty_ordered)',
                'item-refunded'    => 'Rimborsato (:qty_refunded)',
                'item-shipped'     => 'Spedito (:qty_shipped)',
                'order-error'      => 'La spedizione non è valida',
                'per-unit'         => 'Per Unità',
                'qty-available'    => 'Quantità Disponibile',
                'qty-to-ship'      => 'Quantità da Spedire',
                'quantity-invalid' => 'Quantità Non Valida',
                'sku'              => 'SKU - :sku',
                'source'           => 'Origine',
                'success'          => 'Spedizione creata con successo',
                'title'            => 'Crea nuova Spedizione',
                'tracking-number'  => 'Numero di Tracciamento',
            ],

            'view' => [
                'billing-address'      => 'Indirizzo di Fatturazione',
                'carrier-title'        => 'Titolo del Trasportatore',
                'channel'              => 'Canale',
                'currency'             => 'Valuta',
                'customer'             => 'Cliente',
                'email'                => 'Email - :email',
                'inventory-source'     => 'Origine Inventario',
                'order-date'           => 'Data Ordine',
                'order-id'             => 'ID Ordine',
                'order-information'    => 'Informazioni sull\'Ordine',
                'order-status'         => 'Stato Ordine',
                'ordered-items'        => 'Articoli Ordinati',
                'payment-and-shipping' => 'Pagamento e Spedizione',
                'payment-method'       => 'Metodo di Pagamento',
                'product-image'        => 'Immagine Prodotto',
                'qty'                  => 'Quantità - :qty',
                'shipping-address'     => 'Indirizzo di Spedizione',
                'shipping-method'      => 'Metodo di Spedizione',
                'shipping-price'       => 'Costo Spedizione',
                'sku'                  => 'SKU - :sku ',
                'title'                => 'Spedizione #:shipment_id',
                'tracking-number'      => 'Numero di Tracciamento',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Rimborsi',

                'datagrid' => [
                    'billed-to'       => 'Fatturato a',
                    'id'              => 'ID',
                    'order-id'        => 'ID Ordine',
                    'refund-date'     => 'Data Rimborso',
                    'refunded-amount' => 'Importo Rimborsato',
                    'view'            => 'Visualizza',
                ],
            ],

            'view' => [
                'account-information'        => 'Informazioni Account',
                'adjustment-fee'             => 'Commissione di Adeguamento',
                'adjustment-refund'          => 'Rimborso di Adeguamento',
                'base-discounted-amount'     => 'Importo Scontato - :base_discounted_amount',
                'billing-address'            => 'Indirizzo di Fatturazione',
                'currency'                   => 'Valuta',
                'sub-total-amount-excl-tax'  => 'Subtotale (Escl. Tasse) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Subtotale (Incl. Tasse) - :discounted_amount',
                'sub-total-amount'           => 'Subtotale - :discounted_amount',
                'grand-total'                => 'Totale Generale',
                'order-channel'              => 'Canale Ordine',
                'order-date'                 => 'Data Ordine',
                'order-id'                   => 'ID Ordine',
                'order-information'          => 'Informazioni Ordine',
                'order-status'               => 'Stato Ordine',
                'payment-information'        => 'Informazioni Pagamento',
                'payment-method'             => 'Metodo di Pagamento',
                'price-excl-tax'             => 'Prezzo (Escl. Tasse) - :price',
                'price-incl-tax'             => 'Prezzo (Incl. Tasse) - :price',
                'price'                      => 'Prezzo - :price',
                'product-image'              => 'Immagine Prodotto',
                'product-ordered'            => 'Prodotti Ordinati',
                'qty'                        => 'Quantità - :qty',
                'refund'                     => 'Rimborso',
                'shipping-address'           => 'Indirizzo di Spedizione',
                'shipping-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-handling'          => 'Spedizione e Gestione',
                'shipping-method'            => 'Metodo di Spedizione',
                'shipping-price'             => 'Costo Spedizione',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => 'Subtotale (Escl. Tasse)',
                'sub-total-incl-tax'         => 'Subtotale (Incl. Tasse)',
                'sub-total'                  => 'Subtotale',
                'tax'                        => 'Tasse',
                'tax-amount'                 => 'Importo Tasse - :tax_amount',
                'title'                      => 'Rimborso #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Commissione di Adeguamento',
                'adjustment-refund'           => 'Rimborso di Adeguamento',
                'amount-per-unit'             => ':amount Per Unità x :qty Quantità',
                'create-success'              => 'Rimborso creato con successo',
                'creation-error'              => 'La creazione di rimborsi non è consentita.',
                'discount-amount'             => 'Importo Sconto',
                'grand-total'                 => 'Totale Generale',
                'invalid-qty'                 => 'Abbiamo riscontrato una quantità non valida per la fatturazione degli articoli.',
                'invalid-refund-amount-error' => 'L\'importo del rimborso deve essere diverso da zero.',
                'item-canceled'               => 'Annullato (:qty_canceled)',
                'item-invoice'                => 'Fatturato (:qty_invoiced)',
                'item-ordered'                => 'Ordinato (:qty_ordered)',
                'item-refunded'               => 'Rimborsato (:qty_refunded)',
                'item-shipped'                => 'Spedito (:qty_shipped)',
                'per-unit'                    => 'Per Unità',
                'price'                       => 'Prezzo',
                'qty-to-refund'               => 'QTA da rimborsare',
                'refund-btn'                  => 'Rimborsa',
                'refund-limit-error'          => 'L\'importo del rimborso :amount non può essere elaborato.',
                'refund-shipping'             => 'Rimborsa Spedizione',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => 'Subtotale',
                'tax-amount'                  => 'Importo Imposta',
                'title'                       => 'Crea Rimborso',
                'update-totals-btn'           => 'Aggiorna Totali',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Fatture',

                'datagrid' => [
                    'action'              => 'Azioni',
                    'days-left'           => 'Mancano :count giorno/i',
                    'days-overdue'        => ':count giorno/i di ritardo',
                    'grand-total'         => 'Totale Fattura',
                    'id'                  => 'ID',
                    'invoice-date'        => 'Data Fattura',
                    'mass-update-success' => 'Fatture selezionate aggiornate con successo.',
                    'order-id'            => 'ID Ordine',
                    'overdue'             => 'In Ritardo',
                    'overdue-by'          => 'In ritardo di :count giorno/i',
                    'paid'                => 'Pagato',
                    'pending'             => 'In Sospeso',
                    'status'              => 'Stato',
                    'update-status'       => 'Aggiorna stato',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Per Unità x :qty Quantità',
                'channel'                        => 'Canale',
                'customer-email'                 => 'Email - :email',
                'customer'                       => 'Cliente',
                'discount'                       => 'Importo Sconto - :discount',
                'email'                          => 'Email',
                'grand-total'                    => 'Totale Generale',
                'invoice-items'                  => 'Voci Fattura',
                'invoice-sent'                   => 'Fattura inviata con successo',
                'invoice-status'                 => 'Stato Fattura',
                'order-date'                     => 'Data Ordine',
                'order-id'                       => 'ID Ordine',
                'order-information'              => 'Informazioni Ordine',
                'order-status'                   => 'Stato Ordine',
                'price-excl-tax'                 => 'Prezzo (Escl. Tasse) - :price',
                'price-incl-tax'                 => 'Prezzo (Incl. Tasse) - :price',
                'price'                          => 'Prezzo - :price',
                'print'                          => 'Stampa',
                'product-image'                  => 'Immagine Prodotto',
                'qty'                            => 'Quantità - :qty',
                'send-btn'                       => 'Invia',
                'send-duplicate-invoice'         => 'Invia Fattura Duplicata',
                'send'                           => 'Invia',
                'shipping-and-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-and-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-and-handling'          => 'Spedizione e Gestione',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => 'Subtotale (Escl. Tasse) - :sub_total',
                'sub-total-incl-tax'             => 'Subtotale (Incl. Tasse) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Subtotale (Escl. Tasse)',
                'sub-total-summary-incl-tax'     => 'Subtotale (Incl. Tasse)',
                'sub-total-summary'              => 'Subtotale',
                'sub-total'                      => 'Subtotale - :sub_total',
                'summary-discount'               => 'Importo Sconto',
                'summary-tax'                    => 'Importo Tasse',
                'tax'                            => 'Importo Tasse - :tax',
                'title'                          => 'Fattura #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount Per Unità x :qty Quantità',
                'create-invoice'     => 'Crea Fattura',
                'create-success'     => 'Fattura creata con successo',
                'create-transaction' => 'Crea Transazione',
                'creation-error'     => 'La creazione della fattura dell\'ordine non è consentita.',
                'invalid-qty'        => 'Abbiamo trovato una quantità non valida per fatturare gli articoli.',
                'invoice'            => 'Fattura',
                'new-invoice'        => 'Nuova Fattura',
                'product-error'      => 'Impossibile creare una fattura senza prodotti.',
                'product-image'      => 'Immagine del Prodotto',
                'qty-to-invoiced'    => 'Quantità da fatturare',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Dettagli Bancari',
                'bill-to'                    => 'Fatturato a',
                'contact-number'             => 'Numero di Contatto',
                'contact'                    => 'Contatto',
                'date'                       => 'Data Fattura',
                'discount'                   => 'Sconto',
                'excl-tax'                   => 'Escl. Tasse:',
                'grand-total'                => 'Totale Generale',
                'invoice-id'                 => 'ID Fattura',
                'invoice'                    => 'Fattura',
                'order-date'                 => 'Data Ordine',
                'order-id'                   => 'ID Ordine',
                'payment-method'             => 'Metodo di Pagamento',
                'payment-terms'              => 'Termini di Pagamento',
                'price'                      => 'Prezzo',
                'product-name'               => 'Nome Prodotto',
                'qty'                        => 'Quantità',
                'ship-to'                    => 'Spedisci a',
                'shipping-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-handling'          => 'Spedizione e Gestione',
                'shipping-method'            => 'Metodo di Spedizione',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => 'Subtotale (Escl. Tasse)',
                'subtotal-incl-tax'          => 'Subtotale (Incl. Tasse)',
                'subtotal'                   => 'Subtotale',
                'tax-amount'                 => 'Importo Imposta',
                'tax'                        => 'Imposta',
                'vat-number'                 => 'Numero di Partita IVA',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Data Transazione',
            'transaction-id'   => 'ID Transazione',
            'view'             => 'Vista',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => 'Crea Transazioni',
                'title'      => 'Transazioni',

                'datagrid' => [
                    'completed'          => 'Completato',
                    'id'                 => 'ID',
                    'invoice-id'         => 'ID Fattura',
                    'order-id'           => 'ID Ordine',
                    'paid'               => 'Pagato',
                    'pending'            => 'In attesa',
                    'status'             => 'Stato',
                    'transaction-amount' => 'Importo',
                    'transaction-date'   => 'Data',
                    'transaction-id'     => 'ID Transazione',
                    'view'               => 'Vedi',
                ],

                'create' => [
                    'already-paid'               => 'Già pagato',
                    'amount'                     => 'Importo',
                    'create-transaction'         => 'Crea Transazione',
                    'invoice-id'                 => 'ID Fattura',
                    'invoice-missing'            => 'Fattura mancante',
                    'payment-method'             => 'Metodo di Pagamento',
                    'save-transaction'           => 'Salva Transazione',
                    'transaction-amount-exceeds' => 'Importo transazione supera',
                    'transaction-amount-zero'    => 'Importo transazione zero',
                    'transaction-saved'          => 'Transazione salvata con successo.',
                ],

                'view' => [
                    'amount'           => 'Importo',
                    'created-at'       => 'Creato il',
                    'invoice-id'       => 'ID Fattura',
                    'order-id'         => 'ID Ordine',
                    'payment-details'  => 'Dettagli Pagamento',
                    'payment-method'   => 'Metodo di Pagamento',
                    'status'           => 'Stato',
                    'title'            => 'Dettagli Transazione',
                    'transaction-id'   => 'ID Transazione ',
                ],
            ],
        ],

        'booking' => [
            'index' => [
                'datagrid' => [
                    'created-date' => 'Data di Creazione',
                    'from'         => 'Da',
                    'id'           => 'ID',
                    'order-id'     => 'ID Ordine',
                    'qty'          => 'QTA',
                    'to'           => 'A',
                    'view'         => 'Visualizza',
                ],

                'title'    => 'Prenotazioni',
            ],

            'calendar' => [
                'booking-date'     => 'Data di Prenotazione',
                'booking-details'  => 'Dettagli Prenotazione',
                'canceled'         => 'Annullato',
                'closed'           => 'Chiuso',
                'done'             => 'Fatto',
                'order-id'         => 'ID Ordine',
                'pending'          => 'In Attesa',
                'price'            => 'Prezzo',
                'status'           => 'Stato',
                'time-slot'        => 'Fascia Oraria:',
                'view-details'     => 'Visualizza Dettagli',
            ],

            'title' => 'Prodotti Prenotati',
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => 'Il :name è già stato preso.',
                'create-btn'    => 'Crea Prodotto',
                'title'         => 'Prodotti',

                'create' => [
                    'back-btn'                => 'Indietro',
                    'configurable-attributes' => 'Attributi Configurabili',
                    'create-btn'              => 'Crea Prodotto',
                    'family'                  => 'Famiglia',
                    'save-btn'                => 'Salva Prodotto',
                    'sku'                     => 'SKU',
                    'title'                   => 'Crea Nuovo Prodotto',
                    'type'                    => 'Tipo',
                ],

                'datagrid' => [
                    'active'                 => 'Attivo',
                    'attribute-family'       => 'Famiglia di Attributi',
                    'attribute-family-value' => 'Famiglia di Attributi - :attribute_family',
                    'category'               => 'Categoria',
                    'channel'                => 'Canale',
                    'copy-of'                => 'Copia di :value',
                    'copy-of-slug'           => 'copia-di-:value',
                    'delete'                 => 'Elimina',
                    'disable'                => 'Disabilita',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => 'Immagine',
                    'mass-delete-success'    => 'Prodotti Selezionati Eliminati con Successo',
                    'mass-update-success'    => 'Prodotti Selezionati Aggiornati con Successo',
                    'name'                   => 'Nome',
                    'out-of-stock'           => 'Esaurito',
                    'price'                  => 'Prezzo',
                    'product-image'          => 'Immagine Prodotto',
                    'qty'                    => 'Quantità',
                    'qty-value'              => ':qty Disponibili',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => 'Stato',
                    'type'                   => 'Tipo',
                    'update-status'          => 'Aggiorna Stato',
                ],
            ],

            'edit' => [
                'preview'  => 'Anteprima',
                'remove'   => 'Rimuovi',
                'save-btn' => 'Salva Prodotto',
                'title'    => 'Modifica Prodotto',

                'channels' => [
                    'title' => 'Canali',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Aggiungi Prezzo di Gruppo',
                        'all-groups'                => 'Tutti i Gruppi',
                        'create-btn'                => 'Aggiungi Nuovo',
                        'discount-group-price-info' => 'Per :qty Qtà con sconto di :price',
                        'edit-btn'                  => 'Modifica',
                        'empty-info'                => 'Prezzi speciali per i clienti appartenenti a un gruppo specifico.',
                        'fixed-group-price-info'    => 'Per :qty Qtà a prezzo fisso di :price',
                        'title'                     => 'Prezzo di Gruppo Cliente',

                        'create' => [
                            'all-groups'     => 'Tutti i Gruppi',
                            'create-title'   => 'Crea Prezzo di Gruppo Cliente',
                            'customer-group' => 'Gruppo Cliente',
                            'delete-btn'     => 'Elimina',
                            'discount'       => 'Sconto',
                            'fixed'          => 'Fisso',
                            'price'          => 'Prezzo',
                            'price-type'     => 'Tipo Prezzo',
                            'qty'            => 'Qtà Minima',
                            'save-btn'       => 'Salva',
                            'update-title'   => 'Aggiorna Prezzo di Gruppo Cliente',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Qtà Ordinata in Sospeso: :qty',
                    'pending-ordered-qty-info' => 'La quantità ordinata in sospeso verrà dedotta dalla relativa fonte di inventario dopo la spedizione. In caso di cancellazione, la quantità in sospeso sarà nuovamente disponibile per la vendita.',
                    'title'                    => 'Inventari',
                ],

                'categories' => [
                    'title' => 'Categorie',
                ],

                'images' => [
                    'info'  => 'La risoluzione dell\'immagine dovrebbe essere di circa 560px X 609px',
                    'title' => 'Immagini',
                ],

                'videos' => [
                    'error' => 'Errore: :attribute non può essere maggiore di :max kilobyte. Scegliere un file più piccolo, per favore.',
                    'info'  => 'La dimensione massima del video dovrebbe essere di :size',
                    'title' => 'Video',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Aggiungi prodotti correlati al volo.',
                        'info'       => 'Oltre al prodotto che il cliente sta visualizzando, vengono presentati prodotti correlati.',
                        'title'      => 'Prodotti Correlati',
                    ],

                    'up-sells' => [
                        'empty-info' => 'Aggiungi prodotti in vendita al volo.',
                        'info'       => 'Il cliente viene presentato con prodotti in vendita, che fungono da alternativa premium o di alta qualità al prodotto che stanno visualizzando.',
                        'title'      => 'Prodotti in Vendita',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Aggiungi prodotti suggeriti al volo.',
                        'info'       => 'Accanto al carrello della spesa, troverai questi prodotti "acquista impulsivo" posizionati come suggerimenti per completare gli articoli già aggiunti al carrello.',
                        'title'      => 'Prodotti Suggeriti',
                    ],

                    'add-btn'           => 'Aggiungi Prodotto',
                    'delete'            => 'Elimina',
                    'empty-info'        => 'Per aggiungere prodotti di tipo :type al volo.',
                    'empty-title'       => 'Aggiungi Prodotto',
                    'image-placeholder' => 'Immagine Prodotto',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'simple' => [
                        'customizable-options' => [
                            'add-btn'           => 'Aggiungi opzione',
                            'empty-info'        => 'Per creare opzioni personalizzabili rapidamente.',
                            'empty-title'       => 'Aggiungi opzione',
                            'info'              => 'Questo personalizzerà il prodotto semplice.',
                            'title'             => 'Articolo personalizzabile',

                            'update-create' => [
                                'is-required'               => 'È richiesto',
                                'max-characters'            => 'Caratteri Massimi',
                                'name'                      => 'Titolo',
                                'no'                        => 'No',
                                'price'                     => 'Prezzo',
                                'save-btn'                  => 'Salva',
                                'supported-file-extensions' => 'Estensioni file supportate',
                                'title'                     => 'Opzione',
                                'type'                      => 'Tipo',
                                'yes'                       => 'Sì',
                            ],

                            'option' => [
                                'add-btn'     => 'Aggiungi opzione',
                                'delete'      => 'Elimina',
                                'delete-btn'  => 'Elimina',
                                'edit-btn'    => 'Modifica',
                                'empty-info'  => 'Per creare varie combinazioni di prodotto rapidamente.',
                                'empty-title' => 'Aggiungi opzione',

                                'types' => [
                                    'text' => [
                                        'title' => 'Testo',
                                    ],

                                    'textarea' => [
                                        'title' => 'Area di testo',
                                    ],

                                    'checkbox' => [
                                        'title' => 'Casella di controllo',
                                    ],

                                    'radio' => [
                                        'title' => 'Radio',
                                    ],

                                    'select' => [
                                        'title' => 'Seleziona',
                                    ],

                                    'multiselect' => [
                                        'title' => 'Selezione multipla',
                                    ],

                                    'date' => [
                                        'title' => 'Data',
                                    ],

                                    'datetime' => [
                                        'title' => 'Data e ora',
                                    ],

                                    'time' => [
                                        'title' => 'Ora',
                                    ],

                                    'file' => [
                                        'title' => 'File',
                                    ],
                                ],

                                'items' => [
                                    'update-create' => [
                                        'label'    => 'Etichetta',
                                        'price'    => 'Prezzo',
                                        'save-btn' => 'Salva',
                                        'title'    => 'Opzione',
                                    ],
                                ],
                            ],

                            'validations' => [
                                'associated-product' => 'Il prodotto è già associato a un prodotto configurabile, raggruppato o in bundle.',
                            ],
                        ],
                    ],

                    'configurable' => [
                        'add-btn'           => 'Aggiungi Variante',
                        'delete-btn'        => 'Elimina',
                        'edit-btn'          => 'Modifica',
                        'empty-info'        => 'Per creare varie combinazioni di prodotti al volo.',
                        'empty-title'       => 'Aggiungi Variante',
                        'image-placeholder' => 'Immagine Prodotto',
                        'info'              => 'I prodotti a variazione dipendono da tutte le possibili combinazioni di attributi.',
                        'qty'               => ':qty Qtà',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Varianti',

                        'create' => [
                            'description'            => 'Descrizione',
                            'name'                   => 'Nome',
                            'save-btn'               => 'Aggiungi',
                            'title'                  => 'Aggiungi Variante',
                            'variant-already-exists' => 'Questa variante esiste già',
                        ],

                        'edit' => [
                            'disabled'        => 'Disabilitato',
                            'edit-info'       => 'Se desideri aggiornare le informazioni dettagliate sul prodotto, vai alla',
                            'edit-link-title' => 'Pagina Dettagli Prodotto',
                            'enabled'         => 'Abilitato',
                            'images'          => 'Immagini',
                            'name'            => 'Nome',
                            'price'           => 'Prezzo',
                            'quantities'      => 'Quantità',
                            'save-btn'        => 'Salva',
                            'sku'             => 'SKU',
                            'status'          => 'Stato',
                            'title'           => 'Prodotto',
                            'weight'          => 'Peso',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Aggiungi Immagini',
                            'apply-to-all-btn'    => 'Applica a Tutti',
                            'apply-to-all-name'   => 'Applica un nome a tutte le varianti.',
                            'apply-to-all-sku'    => 'Applica un prezzo a tutte le SKU.',
                            'apply-to-all-status' => 'Applica uno stato a tutte le varianti.',
                            'apply-to-all-weight' => 'Applica un peso a tutte le varianti.',
                            'edit-inventories'    => 'Modifica Inventari',
                            'edit-names'          => 'Modifica Nomi',
                            'edit-prices'         => 'Modifica Prezzi',
                            'edit-sku'            => 'Modifica SKU',
                            'edit-status'         => 'Modifica Stato',
                            'edit-weight'         => 'Modifica Peso',
                            'name'                => 'Nome',
                            'price'               => 'Prezzo',
                            'remove-images'       => 'Rimuovi Immagini',
                            'remove-variants'     => 'Rimuovi Varianti',
                            'select-action'       => 'Seleziona Azione',
                            'select-variants'     => 'Seleziona Varianti',
                            'status'              => 'Stato',
                            'variant-name'        => 'Nome Variante',
                            'variant-sku'         => 'SKU Variante',
                            'weight'              => 'Peso',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Aggiungi Prodotto',
                        'default-qty'       => 'Qtà Predefinita',
                        'delete'            => 'Elimina',
                        'empty-info'        => 'Per creare varie combinazioni di prodotti al volo.',
                        'empty-title'       => 'Aggiungi Prodotto',
                        'image-placeholder' => 'Immagine Prodotto',
                        'info'              => 'Un prodotto raggruppato comprende articoli autonomi presentati come un set, consentendo variazioni o coordinamenti per stagione o tema. Ogni prodotto può essere acquistato singolarmente o come parte del gruppo.',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Prodotti Raggruppati',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Aggiungi Opzione',
                        'empty-info'        => 'Per creare opzioni di bundle al volo.',
                        'empty-title'       => 'Aggiungi Opzione',
                        'image-placeholder' => 'Immagine Prodotto',
                        'info'              => 'Un prodotto bundle è un pacchetto di più articoli o servizi venduti insieme a un prezzo speciale, offrendo valore e convenienza ai clienti.',
                        'title'             => 'Articoli del Bundle',

                        'update-create' => [
                            'checkbox'    => 'Casella di Controllo',
                            'is-required' => 'È Richiesto',
                            'multiselect' => 'Selezione Multipla',
                            'name'        => 'Titolo',
                            'no'          => 'No',
                            'radio'       => 'Radio',
                            'save-btn'    => 'Salva',
                            'select'      => 'Seleziona',
                            'title'       => 'Opzione',
                            'type'        => 'Tipo',
                            'yes'         => 'Sì',
                        ],

                        'option' => [
                            'add-btn'     => 'Aggiungi Prodotto',
                            'default-qty' => 'Qtà Predefinita',
                            'delete'      => 'Elimina',
                            'delete-btn'  => 'Elimina',
                            'edit-btn'    => 'Modifica',
                            'empty-info'  => 'Per creare varie combinazioni di prodotti al volo.',
                            'empty-title' => 'Aggiungi Prodotto',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Imposta il prodotto predefinito utilizzando la casella di controllo',
                                    'title' => 'Casella di Controllo',
                                ],

                                'multiselect' => [
                                    'info'  => 'Imposta il prodotto predefinito utilizzando il pulsante della casella di controllo',
                                    'title' => 'Selezione Multipla',
                                ],

                                'radio' => [
                                    'info'  => 'Imposta il prodotto predefinito utilizzando il pulsante della radio',
                                    'title' => 'Radio',
                                ],

                                'select' => [
                                    'info'  => 'Imposta il prodotto predefinito utilizzando il pulsante della radio',
                                    'title' => 'Seleziona',
                                ],
                            ],
                        ],
                    ],

                    'booking' => [
                        'available-from' => 'Disponibile Da',
                        'available-to'   => 'Disponibile Fino',
                        'location'       => 'Posizione',
                        'qty'            => 'Quantità',
                        'title'          => 'Tipo di Prenotazione',

                        'available-every-week' => [
                            'no'    => 'No',
                            'title' => 'Disponibile Ogni Settimana',
                            'yes'   => 'Sì',
                        ],

                        'appointment' => [
                            'break-duration'         => 'Durata della Pausa tra gli Slot (Minuti)',
                            'slot-duration'          => 'Durata dello Slot (Minuti)',

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Stesso Slot per Tutti i Giorni',
                                'yes'   => 'Sì',
                            ],
                        ],

                        'default' => [
                            'add'              => 'Aggiungi',
                            'break-duration'   => 'Durata della Pausa tra gli Slot (Minuti)',
                            'close'            => 'Chiudi',
                            'description'      => 'Informazioni sulla Prenotazione',
                            'description-info' => 'La durata verrà creata e visualizzata in base agli slot. Sarà unica per tutti gli slot e visibile nella vetrina del negozio.',
                            'edit'             => 'Modifica',
                            'many'             => 'Molte Prenotazioni per un Giorno',
                            'one'              => 'Una Prenotazione per Molti Giorni',
                            'open'             => 'Apri',
                            'slot-add'         => 'Aggiungi Slot',
                            'slot-duration'    => 'Durata dello Slot (Minuti)',
                            'slot-title'       => 'Durata del Tempo degli Slot',
                            'title'            => 'Predefinito',
                            'unavailable'      => 'Non Disponibile',

                            'modal'            => [
                                'slot' => [
                                    'add-title'  => 'Aggiungi Slot',
                                    'close'      => 'Chiudi',
                                    'day'        => 'Giorno',
                                    'edit-title' => 'Modifica Slot',
                                    'friday'     => 'Venerdì',
                                    'from'       => 'Da',
                                    'from-day'   => 'Dal Giorno',
                                    'from-time'  => 'Dall\'Ora',
                                    'monday'     => 'Lunedì',
                                    'open'       => 'Apri',
                                    'saturday'   => 'Sabato',
                                    'save'       => 'Salva',
                                    'select'     => 'Seleziona',
                                    'status'     => 'Stato',
                                    'sunday'     => 'Domenica',
                                    'thursday'   => 'Giovedì',
                                    'to'         => 'A',
                                    'to-day'     => 'Al Giorno',
                                    'to-time'    => 'All\'Ora',
                                    'tuesday'    => 'Martedì',
                                    'wednesday'  => 'Mercoledì',
                                    'week'       => ':day',
                                ],
                            ],
                        ],

                        'event' => [
                            'add'                => 'Aggiungi Biglietti',
                            'delete'             => 'Elimina',
                            'description'        => 'Descrizione',
                            'description-info'   => 'Non ci sono biglietti disponibili.',
                            'edit'               => 'Modifica',
                            'name'               => 'Nome',
                            'price'              => 'Prezzo',
                            'qty'                => 'Quantità',
                            'special-price'      => 'Prezzo Speciale',
                            'special-price-from' => 'Prezzo Speciale Da',
                            'special-price-to'   => 'Prezzo Speciale Fino',
                            'title'              => 'Biglietti',
                            'valid-from'         => 'Valido Da',
                            'valid-until'        => 'Valido Fino',

                            'modal'              => [
                                'edit' => 'Modifica Biglietti',
                                'save' => 'Salva',
                            ],
                        ],

                        'empty-info' => [
                            'tickets' => [
                                'add' => 'Aggiungi Biglietti',
                            ],

                            'slots'   => [
                                'add'         => 'Aggiungi Slot',
                                'description' => 'Slot Disponibili con Durata del Tempo.',
                            ],
                        ],

                        'rental' => [
                            'daily'        => 'Base Giornaliera',
                            'daily-hourly' => 'Entrambi (Base Giornaliera e Oraria)',
                            'daily-price'  => 'Prezzo Giornaliero',
                            'hourly'       => 'Base Oraria',
                            'hourly-price' => 'Prezzo Orario',
                            'title'        => 'Tipo di Noleggio',

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Stesso Slot per Tutti i Giorni',
                                'yes'   => 'Sì',
                            ],
                        ],

                        'slots' => [
                            'add'              => 'Aggiungi Slot',
                            'description-info' => 'La durata verrà creata e visualizzata in base agli slot. Sarà unica per tutti gli slot e visibile nella vetrina del negozio.',
                            'save'             => 'Salva',
                            'title'            => 'Durata del Tempo degli Slot',
                            'unavailable'      => 'Non Disponibile',

                            'action' => [
                                'add' => 'Aggiungi',
                            ],

                            'modal' => [
                                'slot' => [
                                    'friday'     => 'Venerdì',
                                    'from'       => 'Da',
                                    'monday'     => 'Lunedì',
                                    'saturday'   => 'Sabato',
                                    'sunday'     => 'Domenica',
                                    'thursday'   => 'Giovedì',
                                    'to'         => 'A',
                                    'tuesday'    => 'Martedì',
                                    'wednesday'  => 'Mercoledì',
                                ],
                            ],
                        ],

                        'table' => [
                            'break-duration'            => 'Durata della Pausa tra gli Slot (Minuti)',
                            'guest-capacity'            => 'Capacità Ospiti',
                            'guest-limit'               => 'Limite Ospiti per Tavolo',
                            'prevent-scheduling-before' => 'Impedisci Pianificazione Prima',
                            'slot-duration'             => 'Durata dello Slot (Minuti)',

                            'charged-per' => [
                                'guest'  => 'Ospite',
                                'table'  => 'Tavolo',
                                'title'  => 'Addebitato Per',
                            ],

                            'same-slot-for-all-days'    => [
                                'no'    => 'No',
                                'title' => 'Stesso Slot per Tutti i Giorni',
                                'yes'   => 'Sì',
                            ],
                        ],

                        'type' => [
                            'appointment' => 'Prenotazione Appuntamento',
                            'default'     => 'Prenotazione Predefinita',
                            'event'       => 'Prenotazione Evento',
                            'many'        => 'Molti',
                            'one'         => 'Uno',
                            'rental'      => 'Prenotazione Noleggio',
                            'table'       => 'Prenotazione Tavolo',
                            'title'       => 'Tipo',
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Aggiungi Link',
                            'delete-btn'  => 'Elimina',
                            'edit-btn'    => 'Modifica',
                            'empty-info'  => 'Per creare link al volo.',
                            'empty-title' => 'Aggiungi Link',
                            'file'        => 'File : ',
                            'info'        => 'Il tipo di prodotto scaricabile consente di vendere prodotti digitali, come eBook, applicazioni software, musica, giochi, ecc.',
                            'sample-file' => 'File di Esempio : ',
                            'sample-url'  => 'URL di Esempio : ',
                            'title'       => 'Link Scaricabili',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'downloads'   => 'Download Consentiti',
                                'file'        => 'File',
                                'file-type'   => 'Tipo File',
                                'name'        => 'Titolo',
                                'price'       => 'Prezzo',
                                'sample'      => 'Esempio',
                                'sample-type' => 'Tipo Esempio',
                                'save-btn'    => 'Salva',
                                'title'       => 'Link',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Aggiungi Esempio',
                            'delete-btn'  => 'Elimina',
                            'edit-btn'    => 'Modifica',
                            'empty-info'  => 'Per creare esempi al volo.',
                            'empty-title' => 'Aggiungi Esempio',
                            'file'        => 'File : ',
                            'info'        => 'Il tipo di prodotto scaricabile consente di vendere prodotti digitali, come eBook, applicazioni software, musica, giochi, ecc.',
                            'title'       => 'Esempi Scaricabili',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'file'        => 'File',
                                'file-type'   => 'Tipo File',
                                'name'        => 'Titolo',
                                'save-btn'    => 'Salva',
                                'title'       => 'Link',
                                'url'         => 'URL',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Prodotto creato con successo',
            'delete-failed'           => 'Eliminazione del prodotto non riuscita',
            'delete-success'          => 'Prodotto eliminato con successo',
            'product-copied'          => 'Prodotto copiato con successo',
            'saved-inventory-message' => 'Prodotto salvato con successo',
            'update-success'          => 'Prodotto aggiornato con successo',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Crea Attributi',
                'title'      => 'Attributi',

                'datagrid' => [
                    'boolean'             => 'Booleano',
                    'channel-based'       => 'Basato sul canale',
                    'checkbox'            => 'Casella di controllo',
                    'code'                => 'Codice',
                    'created-at'          => 'Creato il',
                    'date'                => 'Data',
                    'date-time'           => 'Data e ora',
                    'delete'              => 'Elimina',
                    'edit'                => 'Modifica',
                    'false'               => 'Falso',
                    'file'                => 'File',
                    'id'                  => 'ID',
                    'image'               => 'Immagine',
                    'locale-based'        => 'Basato sulla lingua',
                    'mass-delete-success' => 'Attributi selezionati eliminati correttamente',
                    'multiselect'         => 'Selezione multipla',
                    'name'                => 'Nome',
                    'price'               => 'Prezzo',
                    'required'            => 'Obbligatorio',
                    'select'              => 'Seleziona',
                    'text'                => 'Testo',
                    'textarea'            => 'Area di testo',
                    'true'                => 'Vero',
                    'type'                => 'Tipo',
                    'unique'              => 'Unico',
                ],
            ],

            'create' => [
                'add-attribute-options' => 'Aggiungi Opzioni Attributo',
                'add-option'            => 'Aggiungi Opzione',
                'add-options-info'      => 'Per creare varie combinazioni di opzioni di attributo al volo.',
                'add-row'               => 'Aggiungi Riga',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nome Admin',
                'back-btn'              => 'Indietro',
                'boolean'               => 'Booleano',
                'checkbox'              => 'Casella di Controllo',
                'code'                  => 'Codice Attributo',
                'color'                 => 'Colore',
                'configuration'         => 'Configurazione',
                'create-empty-option'   => 'Crea opzione vuota predefinita',
                'date'                  => 'Data',
                'datetime'              => 'Data e Ora',
                'decimal'               => 'Decimale',
                'default-value'         => 'Valore Predefinito',
                'email'                 => 'Email',
                'enable-wysiwyg'        => 'Abilita Editor Wysiwyg',
                'file'                  => 'File',
                'general'               => 'Generale',
                'image'                 => 'Immagine',
                'input-options'         => 'Opzioni di Input',
                'input-validation'      => 'Validazione Input',
                'is-comparable'         => 'Attributo comparabile',
                'is-configurable'       => 'Usa per Creare Prodotto Configurabile',
                'is-filterable'         => 'Usa nella Navigazione a Livelli',
                'is-required'           => 'Richiesto',
                'is-unique'             => 'Unico',
                'is-visible-on-front'   => 'Visibile sulla Pagina di Visualizzazione del Prodotto sul Front-end',
                'label'                 => 'Etichetta',
                'multiselect'           => 'Selezione Multipla',
                'no'                    => 'No',
                'numeric'               => 'Numero',
                'option-deleted'        => 'Opzione eliminata con successo',
                'options'               => 'Opzioni',
                'position'              => 'Posizione',
                'price'                 => 'Prezzo',
                'regex'                 => 'Espressione Regolare',
                'regex-info'            => 'L\'espressione deve essere tra virgolette doppie.',
                'save-btn'              => 'Salva Attributo',
                'select'                => 'Seleziona',
                'select-type'           => 'Seleziona Tipo di Attributo',
                'swatch'                => 'Swatch',
                'text'                  => 'Testo',
                'textarea'              => 'Area di Testo',
                'title'                 => 'Aggiungi Attributo',
                'type'                  => 'Tipo di Attributo',
                'url'                   => 'URL',
                'use-in-flat'           => 'Crea nella Tabella Flat dei Prodotti',
                'validations'           => 'Validazioni',
                'value-per-channel'     => 'Valore per Canale',
                'value-per-locale'      => 'Valore per Lingua',
                'yes'                   => 'Sì',

                'option' => [
                    'color'    => 'Campione Colore',
                    'dropdown' => 'Menu a Tendina',
                    'image'    => 'Campione Immagine',
                    'save-btn' => 'Salva Opzione',
                    'text'     => 'Campione Testo',
                ],
            ],

            'edit' => [
                'add-attribute-options' => 'Aggiungi Opzioni Attributo',
                'add-option'            => 'Aggiungi Opzione',
                'add-options-info'      => 'Per creare varie combinazioni di opzioni di attributo al volo.',
                'add-row'               => 'Aggiungi Riga',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nome Admin',
                'back-btn'              => 'Indietro',
                'boolean'               => 'Booleano',
                'checkbox'              => 'Casella di Controllo',
                'code'                  => 'Codice Attributo',
                'color'                 => 'Colore',
                'configuration'         => 'Configurazione',
                'create-empty-option'   => 'Crea opzione vuota predefinita',
                'date'                  => 'Data',
                'datetime'              => 'Data e Ora',
                'decimal'               => 'Decimale',
                'default-value'         => 'Valore Predefinito',
                'email'                 => 'Email',
                'enable-wysiwyg'        => 'Abilita Editor Wysiwyg',
                'file'                  => 'File',
                'general'               => 'Generale',
                'image'                 => 'Immagine',
                'input-options'         => 'Opzioni di Input',
                'input-validation'      => 'Validazione Input',
                'is-comparable'         => 'Attributo comparabile',
                'is-configurable'       => 'Usa per Creare Prodotto Configurabile',
                'is-filterable'         => 'Usa nella Navigazione a Livelli',
                'is-required'           => 'Richiesto',
                'is-unique'             => 'Unico',
                'is-visible-on-front'   => 'Visibile sulla Pagina di Visualizzazione del Prodotto sul Front-end',
                'label'                 => 'Etichetta',
                'multiselect'           => 'Selezione Multipla',
                'no'                    => 'No',
                'numeric'               => 'Numero',
                'option-deleted'        => 'Opzione eliminata con successo',
                'options'               => 'Opzioni',
                'position'              => 'Posizione',
                'price'                 => 'Prezzo',
                'regex'                 => 'Espressione Regolare',
                'regex-info'            => 'L\'espressione deve essere tra virgolette doppie.',
                'save-btn'              => 'Salva Attributo',
                'select'                => 'Seleziona',
                'select-type'           => 'Seleziona Tipo di Attributo',
                'swatch'                => 'Swatch',
                'text'                  => 'Testo',
                'textarea'              => 'Area di Testo',
                'title'                 => 'Modifica Attributo',
                'type'                  => 'Tipo di Attributo',
                'url'                   => 'URL',
                'use-in-flat'           => 'Crea nella Tabella Flat dei Prodotti',
                'validations'           => 'Validazioni',
                'value-per-channel'     => 'Valore per Canale',
                'value-per-locale'      => 'Valore per Lingua',
                'yes'                   => 'Sì',

                'option' => [
                    'color'    => 'Campione Colore',
                    'dropdown' => 'Menu a Tendina',
                    'image'    => 'Campione Immagine',
                    'save-btn' => 'Salva Opzione',
                    'text'     => 'Campione Testo',
                ],
            ],

            'create-success'    => 'Attributo Creato con Successo',
            'delete-failed'     => 'Eliminazione dell\'Attributo Non Riuscita',
            'delete-success'    => 'Attributo Eliminato con Successo',
            'update-success'    => 'Attributo Aggiornato con Successo',
            'user-define-error' => 'Impossibile eliminare l\'Attributo di Sistema',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'Crea Categoria',
                'title'   => 'Categorie',

                'datagrid' => [
                    'active'         => 'Attiva',
                    'delete'         => 'Elimina',
                    'delete-success' => 'Le :resource selezionate sono state eliminate con successo',
                    'edit'           => 'Modifica',
                    'id'             => 'ID',
                    'inactive'       => 'Inattiva',
                    'name'           => 'Nome',
                    'no-of-products' => 'Numero di Prodotti',
                    'position'       => 'Posizione',
                    'status'         => 'Visibile Nel Menu',
                    'update-status'  => 'Aggiorna Stato',
                ],
            ],

            'create' => [
                'add-banner'               => 'Aggiungi Banner',
                'add-logo'                 => 'Aggiungi Logo',
                'back-btn'                 => 'Indietro',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporzione del banner (1320px X 300px)',
                'description'              => 'Descrizione',
                'description-and-images'   => 'Descrizione e Immagini',
                'description-only'         => 'Solo Descrizione',
                'display-mode'             => 'Modalità di Visualizzazione',
                'enter-position'           => 'Inserisci Posizione',
                'filterable-attributes'    => 'Attributi Filtrabili',
                'general'                  => 'Generale',
                'logo'                     => 'Logo',
                'logo-size'                => 'La risoluzione del logo dovrebbe essere (110px X 110px)',
                'meta-description'         => 'Meta Descrizione',
                'meta-keywords'            => 'Meta Keywords',
                'meta-title'               => 'Meta Titolo',
                'name'                     => 'Nome',
                'parent-category'          => 'Categoria Padre',
                'position'                 => 'Posizione',
                'products-and-description' => 'Prodotti e Descrizione',
                'products-only'            => 'Solo Prodotti',
                'save-btn'                 => 'Salva Categoria',
                'select-display-mode'      => 'Seleziona Modalità di Visualizzazione',
                'seo-details'              => 'Dettagli SEO',
                'settings'                 => 'Impostazioni',
                'slug'                     => 'Slug',
                'title'                    => 'Aggiungi Nuova Categoria',
                'visible-in-menu'          => 'Visibile Nel Menu',
            ],

            'edit' => [
                'add-banner'               => 'Aggiungi Banner',
                'add-logo'                 => 'Aggiungi Logo',
                'back-btn'                 => 'Indietro',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporzione del banner (1320px X 300px)',
                'description'              => 'Descrizione',
                'description-and-images'   => 'Descrizione e Immagini',
                'description-only'         => 'Solo Descrizione',
                'display-mode'             => 'Modalità di Visualizzazione',
                'enter-position'           => 'Inserisci Posizione',
                'filterable-attributes'    => 'Attributi Filtrabili',
                'general'                  => 'Generale',
                'logo'                     => 'Logo',
                'logo-size'                => 'La risoluzione del logo dovrebbe essere (110px X 110px)',
                'meta-description'         => 'Meta Descrizione',
                'meta-keywords'            => 'Meta Keywords',
                'meta-title'               => 'Meta Titolo',
                'name'                     => 'Nome',
                'position'                 => 'Posizione',
                'products-and-description' => 'Prodotti e Descrizione',
                'products-only'            => 'Solo Prodotti',
                'save-btn'                 => 'Salva Categoria',
                'select-display-mode'      => 'Seleziona Modalità di Visualizzazione',
                'select-parent-category'   => 'Seleziona Categoria Padre',
                'seo-details'              => 'Dettagli SEO',
                'settings'                 => 'Impostazioni',
                'slug'                     => 'Slug',
                'title'                    => 'Modifica Categoria',
                'visible-in-menu'          => 'Visibile Nel Menu',
            ],

            'category'             => 'Categoria',
            'create-success'       => 'Categoria creata con successo.',
            'delete-category-root' => 'La categoria principale non può essere eliminata.',
            'delete-failed'        => 'Errore durante l\'eliminazione della categoria.',
            'delete-success'       => 'La categoria è stata eliminata con successo.',
            'update-success'       => 'Categoria aggiornata con successo.',
        ],

        'families' => [
            'index' => [
                'add'   => 'Crea Famiglia di Attributi',
                'title' => 'Famiglie',

                'datagrid' => [
                    'code'           => 'Codice',
                    'delete'         => 'Elimina',
                    'delete-success' => 'Le :resource selezionate sono state eliminate con successo',
                    'edit'           => 'Modifica',
                    'id'             => 'ID',
                    'method-error'   => 'Errore! Rilevato un metodo errato, controlla la configurazione dell\'azione di massa',
                    'name'           => 'Nome',
                    'no-resource'    => 'La risorsa fornita è insufficiente per l\'azione',
                    'partial-action' => 'Alcune azioni non sono state eseguite a causa di vincoli di sistema restrittivi su :resource',
                    'update-success' => 'Le :resource selezionate sono state aggiornate con successo',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Aggiungi Gruppo',
                'add-group-title'                  => 'Aggiungi Nuovo Gruppo',
                'back-btn'                         => 'Indietro',
                'code'                             => 'Codice',
                'column'                           => 'Colonna',
                'delete-group-btn'                 => 'Elimina Gruppo',
                'edit-group-info'                  => 'Doppio clic per modificare il Gruppo',
                'enter-code'                       => 'Inserisci Codice',
                'enter-name'                       => 'Inserisci Nome',
                'general'                          => 'Generale',
                'group-code-already-exists'        => 'Il codice del gruppo attributi esiste già.',
                'group-contains-system-attributes' => 'Questo gruppo contiene attributi di sistema. Sposta prima gli attributi di sistema in un altro gruppo e riprova.',
                'group-name-already-exists'        => 'Il nome del gruppo attributi esiste già.',
                'groups'                           => 'Gruppi',
                'groups-info'                      => 'Gestisci i gruppi della famiglia di attributi',
                'main-column'                      => 'Colonna Principale',
                'name'                             => 'Nome',
                'removal-not-possible'             => 'Non puoi rimuovere attributi di sistema dalla famiglia di attributi.',
                'right-column'                     => 'Colonna Lato Destro',
                'save-btn'                         => 'Salva Famiglia di Attributi',
                'select-group'                     => 'Seleziona un gruppo di attributi.',
                'title'                            => 'Crea Famiglia di Attributi',
                'unassigned-attributes'            => 'Attributi Non Assegnati',
                'unassigned-attributes-info'       => 'Trascina questi attributi per aggiungerli alle colonne o ai gruppi.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Aggiungi Gruppo',
                'add-group-title'                  => 'Aggiungi Nuovo Gruppo',
                'back-btn'                         => 'Indietro',
                'code'                             => 'Codice',
                'column'                           => 'Colonna',
                'delete-group-btn'                 => 'Elimina Gruppo',
                'edit-group-info'                  => 'Doppio clic per modificare il Gruppo',
                'enter-code'                       => 'Inserisci Codice',
                'enter-name'                       => 'Inserisci Nome',
                'general'                          => 'Generale',
                'group-code-already-exists'        => 'Il codice del gruppo attributi esiste già.',
                'group-contains-system-attributes' => 'Questo gruppo contiene attributi di sistema. Sposta prima gli attributi di sistema in un altro gruppo e riprova.',
                'group-name-already-exists'        => 'Il nome del gruppo attributi esiste già.',
                'groups'                           => 'Gruppi',
                'groups-info'                      => 'Gestisci i gruppi della famiglia di attributi',
                'main-column'                      => 'Colonna Principale',
                'name'                             => 'Nome',
                'removal-not-possible'             => 'Non puoi rimuovere attributi di sistema dalla famiglia di attributi.',
                'right-column'                     => 'Colonna Lato Destro',
                'save-btn'                         => 'Salva Famiglia di Attributi',
                'select-group'                     => 'Seleziona un gruppo di attributi.',
                'title'                            => 'Modifica Famiglia di Attributi',
                'unassigned-attributes'            => 'Attributi Non Assegnati',
                'unassigned-attributes-info'       => 'Trascina questi attributi per aggiungerli alle colonne o ai gruppi.',
            ],

            'attribute-family'        => 'Famiglia di Attributi',
            'attribute-product-error' => 'La famiglia è utilizzata nei prodotti.',
            'create-success'          => 'Famiglia creata con successo.',
            'delete-failed'           => 'Errore durante l\'eliminazione della famiglia.',
            'delete-success'          => 'Famiglia eliminata con successo.',
            'family'                  => 'Famiglia',
            'last-delete-error'       => 'Almeno una famiglia è richiesta.',
            'update-success'          => 'Famiglia aggiornata con successo.',
            'user-define-error'       => 'Impossibile eliminare la famiglia di attributi di sistema',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Clienti',
                'login-message' => 'Accesso effettuato come :customer_name',

                'datagrid' => [
                    'active'         => 'Attivo',
                    'address'        => ':address Indirizzo(i)',
                    'address-count'  => 'Conteggio Indirizzi',
                    'channel'        => 'Canale',
                    'delete'         => 'Elimina',
                    'delete-success' => 'Dati selezionati eliminati con successo',
                    'email'          => 'Email',
                    'gender'         => 'Genere',
                    'group'          => 'Gruppo',
                    'id'             => 'ID Cliente',
                    'id-value'       => 'ID - :id',
                    'inactive'       => 'Inattivo',
                    'method-error'   => 'Errore! Rilevato un metodo errato, controllare la configurazione dell\'azione di massa',
                    'name'           => 'Nome Cliente',
                    'no-resource'    => 'La risorsa fornita è insufficiente per l\'azione',
                    'order'          => ':order Ordine(i)',
                    'order-count'    => 'Conteggio Ordini',
                    'order-pending'  => 'Il cliente ha ordini in sospeso',
                    'partial-action' => 'Alcune azioni non sono state eseguite a causa di vincoli di sistema restrittivi su :resource',
                    'phone'          => 'Numero di Contatto',
                    'revenue'        => 'Ricavo',
                    'status'         => 'Stato',
                    'suspended'      => 'Sospeso',
                    'update-status'  => 'Aggiorna Stato',
                    'update-success' => 'Clienti selezionati aggiornati con successo',
                ],

                'create' => [
                    'contact-number'        => 'Numero di Contatto',
                    'create-btn'            => 'Crea Cliente',
                    'create-success'        => 'Cliente creato con successo',
                    'customer-group'        => 'Gruppo Cliente',
                    'date-of-birth'         => 'Data di Nascita',
                    'email'                 => 'Email',
                    'female'                => 'Femminile',
                    'first-name'            => 'Nome',
                    'gender'                => 'Genere',
                    'last-name'             => 'Cognome',
                    'male'                  => 'Maschile',
                    'other'                 => 'Altro',
                    'save-btn'              => 'Salva cliente',
                    'select-customer-group' => 'Seleziona Gruppo Cliente',
                    'select-gender'         => 'Seleziona Genere',
                    'title'                 => 'Crea Nuovo Cliente',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'Sei sicuro di voler eliminare questo account?',
                'active'                      => 'Attivo',
                'address-delete-confirmation' => 'Sei sicuro di voler eliminare questo indirizzo?',
                'back-btn'                    => 'Indietro',
                'create-order'                => 'Crea Ordine',
                'customer'                    => 'Cliente',
                'date-of-birth'               => 'DOB - :dob',
                'default-address'             => 'Indirizzo predefinito',
                'delete-account'              => 'Elimina account',
                'delete'                      => 'Elimina',
                'email'                       => 'Email - :email',
                'empty-description'           => 'Crea nuovi indirizzi per il cliente',
                'empty-title'                 => 'Aggiungi indirizzo cliente',
                'gender'                      => 'Genere - :gender',
                'group'                       => 'Gruppo - :group_code',
                'inactive'                    => 'Inattivo',
                'login-as-customer'           => 'Accedi come cliente',
                'note-created-success'        => 'Nota creata con successo',
                'order-create-confirmation'   => 'Sei sicuro di voler creare un ordine per questo cliente?',
                'phone'                       => 'Telefono - :phone',
                'set-as-default'              => 'Imposta come predefinito',
                'suspended'                   => 'Sospeso',
                'title'                       => 'Vista cliente',

                'address' => [
                    'count' => 'Indirizzi (:count)',

                    'create' => [
                        'city'               => 'Città',
                        'company-name'       => 'Nome Azienda',
                        'country'            => 'Paese',
                        'create-btn'         => 'Crea',
                        'create-address-btn' => 'Aggiungi Nuovo Indirizzo',
                        'default-address'    => 'Indirizzo Predefinito',
                        'email'              => 'Email',
                        'first-name'         => 'Nome',
                        'last-name'          => 'Cognome',
                        'phone'              => 'Telefono',
                        'post-code'          => 'Codice Postale',
                        'save-btn-title'     => 'Salva Indirizzo',
                        'select-country'     => 'Seleziona Paese',
                        'state'              => 'Stato',
                        'street-address'     => 'Indirizzo',
                        'title'              => 'Crea Indirizzo',
                        'vat-id'             => 'Partita IVA',
                    ],

                    'edit' => [
                        'city'            => 'Città',
                        'company-name'    => 'Nome Azienda',
                        'country'         => 'Paese',
                        'default-address' => 'Indirizzo Predefinito',
                        'edit-btn'        => 'Modifica',
                        'email'           => 'Email',
                        'first-name'      => 'Nome',
                        'last-name'       => 'Cognome',
                        'phone'           => 'Telefono',
                        'post-code'       => 'Codice Postale',
                        'save-btn-title'  => 'Salva Indirizzo',
                        'select-country'  => 'Seleziona Paese',
                        'state'           => 'Stato',
                        'street-address'  => 'Indirizzo',
                        'title'           => 'Modifica Indirizzo',
                        'vat-id'          => 'Partita IVA',
                    ],

                    'address-delete-success' => 'Indirizzo eliminato con successo',
                    'create-success'         => 'Indirizzo creato con successo',
                    'set-default-success'    => 'Indirizzo predefinito aggiornato con successo',
                    'success-mass-delete'    => 'Eliminazione di massa degli indirizzi riuscita',
                    'update-success'         => 'Indirizzo aggiornato con successo',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'Nessuna recensione disponibile',
                        'increment-id'   => 'ID Fatture',
                        'invoice-amount' => 'Importo Fatture',
                        'invoice-date'   => 'Data Fatture',
                        'order-id'       => 'ID Ordine',
                        'view'           => 'Vista',
                    ],

                    'orders' => [
                        'canceled'        => 'Annullato',
                        'channel-name'    => 'Nome Canale',
                        'closed'          => 'Chiuso',
                        'completed'       => 'Completato',
                        'customer-name'   => 'Nome Cliente',
                        'date'            => 'Data',
                        'empty-order'     => 'Nessun ordine disponibile',
                        'email'           => 'Email',
                        'fraud'           => 'Frode',
                        'grand-total'     => 'Totale Generale',
                        'location'        => 'Posizione',
                        'order-id'        => 'ID Ordine',
                        'pay-via'         => 'Pagato Con',
                        'pending'         => 'In Attesa',
                        'pending-payment' => 'Pagamento in Sospeso',
                        'processing'      => 'In Elaborazione',
                        'status'          => 'Stato',
                        'view'            => 'Vista',
                    ],

                    'reviews' => [
                        'approved'      => 'Approvato',
                        'comment'       => 'Commento',
                        'created-at'    => 'Creato il',
                        'disapproved'   => 'Non Approvato',
                        'empty-reviews' => 'Nessuna fattura disponibile',
                        'id'            => 'ID',
                        'invoice-date'  => 'Data Fattura',
                        'pending'       => 'In Attesa',
                        'product-id'    => 'ID Prodotto',
                        'product-name'  => 'Nome Prodotto',
                        'rating'        => 'Valutazione',
                        'status'        => 'Stato',
                        'title'         => 'Titolo',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Numero di Contatto',
                    'customer-group'        => 'Gruppo Cliente',
                    'date-of-birth'         => 'Data di Nascita',
                    'edit-btn'              => 'Modifica',
                    'email'                 => 'Email',
                    'female'                => 'Femminile',
                    'first-name'            => 'Nome',
                    'gender'                => 'Genere',
                    'last-name'             => 'Cognome',
                    'male'                  => 'Maschile',
                    'other'                 => 'Altro',
                    'save-btn'              => 'Salva Cliente',
                    'select-customer-group' => 'Seleziona Gruppo Cliente',
                    'select-gender'         => 'Seleziona Genere',
                    'status'                => 'Stato',
                    'suspended'             => 'Sospeso',
                    'title'                 => 'Modifica Cliente',
                ],

                'invoices' => [
                    'count'        => 'Fatture (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Aggiungi Nota',
                    'customer-not-notified' => ':date | Cliente <b>Non Notificato</b>',
                    'customer-notified'     => ':date | Cliente <b>Notificato</b>',
                    'note'                  => 'Nota',
                    'note-placeholder'      => 'Scrivi la tua nota qui',
                    'notify-customer'       => 'Notifica Cliente',
                    'submit-btn-title'      => 'Invia Nota',
                ],

                'orders' => [
                    'count'         => 'Ordini (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Ricavo Totale - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'Recensioni (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Elemento del carrello rimosso con successo.',
                ],

                'wishlist' => [
                    'delete-success' => 'Elemento della lista dei desideri rimosso con successo.',
                ],

                'compare' => [
                    'delete-success' => 'Elemento del confronto rimosso con successo.',
                ],
            ],

            'delete-failed'  => 'Eliminazione Cliente Fallita',
            'delete-success' => 'Cliente Eliminato con Successo',
            'order-pending'  => 'Ordini in Attesa',
            'update-success' => 'Cliente Aggiornato con Successo',
        ],

        'groups' => [
            'index' => [
                'title' => 'Gruppi',

                'create' => [
                    'code'       => 'Codice',
                    'create-btn' => 'Crea Gruppo',
                    'name'       => 'Nome',
                    'save-btn'   => 'Salva Gruppo',
                    'success'    => 'Gruppo creato con successo',
                    'title'      => 'Crea nuovo Gruppo',
                ],

                'edit' => [
                    'delete-failed'  => 'Eliminazione Gruppo non riuscita',
                    'delete-success' => 'Gruppo eliminato con successo',
                    'group-default'  => 'Il Gruppo Predefinito non può essere Eliminato',
                    'success'        => 'Gruppo aggiornato con successo',
                    'title'          => 'Modifica Gruppo',
                ],

                'datagrid' => [
                    'code'   => 'Codice',
                    'delete' => 'Elimina',
                    'edit'   => 'Modifica',
                    'id'     => 'ID',
                    'name'   => 'Nome',
                ],
            ],
        ],

        'gdpr' => [
            'index' => [
                'title' => 'Richiesta GDPR',

                'datagrid' => [
                    'completed'     => 'Completato',
                    'created-at'    => 'Creato il',
                    'customer-name' => 'Nome Cliente',
                    'declined'      => 'Rifiutato',
                    'delete'        => 'Elimina',
                    'edit'          => 'Modifica',
                    'id'            => 'ID',
                    'message'       => 'Messaggio',
                    'pending'       => 'In Attesa',
                    'processing'    => 'In Elaborazione',
                    'revoked'       => 'Revocato',
                    'status'        => 'Stato',
                    'type'          => 'Tipo',
                ],

                'modal' => [
                    'completed'     => 'Completato',
                    'declined'      => 'Rifiutato',
                    'message'       => 'Messaggio',
                    'pending'       => 'In Attesa',
                    'processing'    => 'In Elaborazione',
                    'revoked'       => 'Revocato',
                    'save-btn'      => 'Salva',
                    'status'        => 'Stato',
                    'title'         => 'Modifica Richiesta Dati GDPR',
                    'type'          => 'Tipo',
                ],

                'update-success'              => 'Richiesta Dati aggiornata con successo e Email inviata al Cliente.',
                'delete-success'              => 'Richiesta Dati eliminata con successo.',
                'attribute-reason-error'      => 'Impossibile Eliminare.',
                'update-success-unsent-email' => 'Richiesta Dati aggiornata con successo ma Email non inviata al Cliente.',
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Data',
                'description' => 'Descrizione',
                'id'          => 'ID',
                'name'        => 'Nome',
                'product'     => 'Prodotto',
                'rating'      => 'Valutazione',
                'status'      => 'Stato',
                'title'       => 'Recensioni',

                'edit' => [
                    'approved'       => 'Approvato',
                    'customer'       => 'Cliente',
                    'date'           => 'Data',
                    'disapproved'    => 'Non Approvato',
                    'id'             => 'ID',
                    'images'         => 'Immagini',
                    'pending'        => 'In Sospeso',
                    'product'        => 'Prodotto',
                    'rating'         => 'Valutazione',
                    'review-comment' => 'Commento',
                    'review-title'   => 'Titolo',
                    'save-btn'       => 'Salva',
                    'status'         => 'Stato',
                    'title'          => 'Modifica Recensione',
                    'update-success' => 'Aggiornamento riuscito',
                ],

                'datagrid' => [
                    'approved'            => 'Approvato',
                    'comment'             => 'Commento',
                    'customer-names'      => 'Nome',
                    'date'                => 'Data',
                    'delete'              => 'Elimina',
                    'delete-success'      => 'Recensione eliminata con successo',
                    'disapproved'         => 'Non Approvato',
                    'edit'                => 'Modifica',
                    'id'                  => 'ID',
                    'mass-delete-error'   => 'Qualcosa è andato storto',
                    'mass-delete-success' => 'Recensioni selezionate eliminate con successo',
                    'mass-update-success' => 'Recensioni selezionate aggiornate con successo',
                    'pending'             => 'In Sospeso',
                    'product'             => 'Prodotto',
                    'rating'              => 'Valutazione',
                    'review-id'           => 'ID - :review_id',
                    'status'              => 'Stato',
                    'title'               => 'Titolo',
                    'update-status'       => 'Aggiorna Stato',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Crea Modello',
                    'title'      => 'Modelli di Email',

                    'datagrid' => [
                        'active'   => 'Attivo',
                        'draft'    => 'Bozza',
                        'id'       => 'ID',
                        'inactive' => 'Inattivo',
                        'name'     => 'Nome',
                        'status'   => 'Stato',
                    ],
                ],

                'create' => [
                    'active'         => 'Attivo',
                    'back-btn'       => 'Indietro',
                    'content'        => 'Contenuto',
                    'create-success' => 'Modello di email creato con successo.',
                    'draft'          => 'Bozza',
                    'general'        => 'Generale',
                    'inactive'       => 'Inattivo',
                    'name'           => 'Nome',
                    'save-btn'       => 'Salva Modello',
                    'select-status'  => 'Seleziona Stato',
                    'status'         => 'Stato',
                    'title'          => 'Crea Modello',
                ],

                'edit' => [
                    'active'         => 'Attivo',
                    'back-btn'       => 'Indietro',
                    'content'        => 'Contenuto',
                    'draft'          => 'Bozza',
                    'general'        => 'Generale',
                    'inactive'       => 'Inattivo',
                    'name'           => 'Nome',
                    'save-btn'       => 'Salva Modello',
                    'status'         => 'Stato',
                    'title'          => 'Modifica Modello',
                    'update-success' => 'Aggiornato con successo',
                ],

                'delete-failed'  => ':name Eliminazione non riuscita',
                'delete-success' => 'Modello eliminato con successo',
                'email-template' => 'Modello di Email',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => 'Crea Campagna',
                    'title'      => 'Campagne',

                    'datagrid' => [
                        'active'   => 'Attivo',
                        'delete'   => 'Elimina',
                        'edit'     => 'Modifica',
                        'id'       => 'ID',
                        'inactive' => 'Inattivo',
                        'name'     => 'Nome',
                        'status'   => 'Stato',
                        'subject'  => 'Oggetto',
                    ],
                ],

                'create' => [
                    'active'          => 'Attivo',
                    'back-btn'        => 'Indietro',
                    'channel'         => 'Canale',
                    'customer-group'  => 'Gruppo Cliente',
                    'email-template'  => 'Modello di Email',
                    'event'           => 'Evento',
                    'general'         => 'Generale',
                    'inactive'        => 'Inattivo',
                    'name'            => 'Nome',
                    'save-btn'        => 'Salva Campagna',
                    'select-channel'  => 'Seleziona Canale',
                    'select-event'    => 'Seleziona Evento',
                    'select-group'    => 'Seleziona Gruppo',
                    'select-status'   => 'Seleziona Stato',
                    'select-template' => 'Seleziona Modello',
                    'setting'         => 'Impostazione',
                    'status'          => 'Stato',
                    'subject'         => 'Oggetto',
                    'title'           => 'Crea Campagna',
                ],

                'edit' => [
                    'active'          => 'Attivo',
                    'audience'        => 'Pubblico',
                    'back-btn'        => 'Indietro',
                    'channel'         => 'Canale',
                    'customer-group'  => 'Gruppo Cliente',
                    'email-template'  => 'Modello di Email',
                    'event'           => 'Evento',
                    'general'         => 'Generale',
                    'inactive'        => 'Inattivo',
                    'name'            => 'Nome',
                    'save-btn'        => 'Salva Campagna',
                    'select-event'    => 'Seleziona Evento',
                    'select-status'   => 'Seleziona Stato',
                    'select-template' => 'Seleziona Modello',
                    'status'          => 'Stato',
                    'subject'         => 'Oggetto',
                    'title'           => 'Modifica Campagna',
                ],

                'create-success' => 'Campagna creata con successo.',
                'delete-failed'  => ':name Eliminazione non riuscita',
                'delete-success' => 'Campagna eliminata con successo',
                'email-campaign' => 'Campagna Email',
                'update-success' => 'Campagna aggiornata con successo.',
            ],

            'events' => [
                'index' => [
                    'create-btn' => 'Crea Evento',
                    'event'      => 'Evento',
                    'title'      => 'Eventi',

                    'datagrid' => [
                        'actions' => 'Azioni',
                        'date'    => 'Data',
                        'delete'  => 'Elimina',
                        'edit'    => 'Modifica',
                        'id'      => 'ID',
                        'name'    => 'Nome',
                    ],

                    'create' => [
                        'date'           => 'Data',
                        'delete-warning' => 'Sei sicuro di voler eseguire questa azione?',
                        'description'    => 'Descrizione',
                        'general'        => 'Generale',
                        'name'           => 'Nome',
                        'save-btn'       => 'Salva Evento',
                        'success'        => 'Eventi Creati con Successo',
                        'title'          => 'Crea Eventi',
                    ],

                    'edit' => [
                        'success' => 'Eventi Aggiornati con Successo',
                        'title'   => 'Modifica Eventi',
                    ],
                ],

                'delete-failed'  => ':name Eliminazione non riuscita',
                'delete-success' => 'Eventi Eliminati con Successo',
                'edit-error'     => 'L\'evento non può essere modificato',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Iscrizioni alla Newsletter',

                    'datagrid' => [
                        'actions'    => 'Azioni',
                        'delete'     => 'Elimina',
                        'edit'       => 'Modifica',
                        'email'      => 'Email',
                        'false'      => 'Falso',
                        'id'         => 'ID',
                        'subscribed' => 'Iscritto',
                        'true'       => 'Vero',
                    ],

                    'edit' => [
                        'back-btn'      => 'Indietro',
                        'email'         => 'Email',
                        'false'         => 'Falso',
                        'save-btn'      => 'Salva Iscritto',
                        'subscribed'    => 'Iscritto',
                        'success'       => 'Iscrizione alla newsletter aggiornata con successo',
                        'title'         => 'Modifica Iscritto alla Newsletter',
                        'true'          => 'Vero',
                        'update-failed' => 'Iscrizione alla newsletter non aggiornata',
                    ],
                ],

                'delete-failed'  => 'Eliminazione Iscritto non riuscita',
                'delete-success' => 'Iscritto Eliminato con Successo',
                'delete-warning' => 'Sei sicuro di voler eseguire questa azione?',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'Regole del Carrello',
                'catalog-rule-title' => 'Regole del Catalogo',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Crea Regola del Carrello',
                    'title'      => 'Regole del Carrello',

                    'datagrid' => [
                        'active'      => 'Attivo',
                        'copy'        => 'Copia',
                        'copy-of'     => ':value',
                        'coupon-code' => 'Codice Coupon',
                        'delete'      => 'Elimina',
                        'draft'       => 'Bozza',
                        'edit'        => 'Modifica',
                        'end'         => 'Fine',
                        'id'          => 'ID',
                        'inactive'    => 'Inattivo',
                        'name'        => 'Nome',
                        'priority'    => 'Priorità',
                        'start'       => 'Inizio',
                        'status'      => 'Stato',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Tipo di Azione',
                    'actions'                                   => 'Azioni',
                    'add-condition'                             => 'Aggiungi Condizione',
                    'additional'                                => 'Aggiuntivo',
                    'all-conditions-true'                       => 'Tutte le Condizioni sono Vere',
                    'any-conditions-true'                       => 'Almeno una Condizione è Vera',
                    'apply-to-shipping'                         => 'Applica alla Spedizione',
                    'attribute-family'                          => 'Famiglia di Attributi',
                    'attribute-name-children-only'              => 'Nome dell\'Attributo Solo Figli',
                    'attribute-name-parent-only'                => 'Nome dell\'Attributo Solo Genitori',
                    'auto-generate-coupon'                      => 'Genera Coupon Automaticamente',
                    'back-btn'                                  => 'Indietro',
                    'buy-x-get-y-free'                          => 'Compra X Ottieni Y Gratis',
                    'buy-x-quantity'                            => 'Compra Quantità X',
                    'cart-attribute'                            => 'Attributo del Carrello',
                    'cart-item-attribute'                       => 'Attributo dell\'Articolo nel Carrello',
                    'categories'                                => 'Categorie',
                    'channels'                                  => 'Canali',
                    'children-categories'                       => 'Categorie Figlie',
                    'choose-condition-to-add'                   => 'Scegli la condizione da aggiungere',
                    'condition-type'                            => 'Tipo di Condizione',
                    'conditions'                                => 'Condizioni',
                    'contain'                                   => 'Contiene',
                    'contains'                                  => 'Contiene',
                    'coupon-code'                               => 'Codice Coupon',
                    'coupon-type'                               => 'Tipo di Coupon',
                    'create-success'                            => 'Regola del carrello creata con successo',
                    'customer-groups'                           => 'Gruppi di Clienti',
                    'description'                               => 'Descrizione',
                    'discount-amount'                           => 'Importo Sconto',
                    'does-not-contain'                          => 'Non Contiene',
                    'end-of-other-rules'                        => 'Fine di Altre Regole',
                    'equals-or-greater-than'                    => 'Uguale o maggiore di',
                    'equals-or-less-than'                       => 'Uguale o minore di',
                    'fixed-amount'                              => 'Importo Fisso',
                    'fixed-amount-whole-cart'                   => 'Importo Fisso per l\'intero Carrello',
                    'free-shipping'                             => 'Spedizione Gratuita',
                    'from'                                      => 'Da',
                    'general'                                   => 'Generale',
                    'greater-than'                              => 'Maggiore di',
                    'is-equal-to'                               => 'È uguale a',
                    'is-not-equal-to'                           => 'Non è uguale a',
                    'less-than'                                 => 'Minore di',
                    'marketing-time'                            => 'Tempo di Marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantità massima consentita per lo sconto',
                    'name'                                      => 'Nome',
                    'no'                                        => 'No',
                    'no-coupon'                                 => 'Nessun Coupon',
                    'parent-categories'                         => 'Categorie Genitore',
                    'payment-method'                            => 'Metodo di Pagamento',
                    'percentage-product-price'                  => 'Percentuale del Prezzo del Prodotto',
                    'price-in-cart'                             => 'Prezzo nel Carrello',
                    'priority'                                  => 'Priorità',
                    'product-attribute'                         => 'Attributo del Prodotto',
                    'qty-in-cart'                               => 'Quantità nel Carrello',
                    'save-btn'                                  => 'Salva Regola del Carrello',
                    'settings'                                  => 'Impostazioni',
                    'shipping-country'                          => 'Paese di Spedizione',
                    'shipping-method'                           => 'Metodo di Spedizione',
                    'shipping-postcode'                         => 'Codice Postale di Spedizione',
                    'shipping-state'                            => 'Stato di Spedizione',
                    'specific-coupon'                           => 'Coupon Specifico',
                    'status'                                    => 'Stato',
                    'subtotal'                                  => 'Subtotale',
                    'title'                                     => 'Crea Regola del Carrello',
                    'to'                                        => 'A',
                    'total-items-qty'                           => 'Quantità Totale Articoli',
                    'total-weight'                              => 'Peso Totale',
                    'uses-per-coupon'                           => 'Usi per Coupon',
                    'uses-per-customer'                         => 'Usi per Cliente',
                    'uses-per-customer-control-info'            => 'Sarà utilizzato solo per i clienti autenticati.',
                    'yes'                                       => 'Sì',
                ],

                'edit' => [
                    'action-type'                               => 'Tipo di Azione',
                    'actions'                                   => 'Azioni',
                    'add-condition'                             => 'Aggiungi Condizione',
                    'additional'                                => 'Aggiuntivo',
                    'all-conditions-true'                       => 'Tutte le Condizioni sono Vere',
                    'alphabetical'                              => 'Alfabetico',
                    'alphanumeric'                              => 'Alfanumerico',
                    'any-conditions-true'                       => 'Almeno una Condizione è Vera',
                    'apply-to-shipping'                         => 'Applica alla Spedizione',
                    'attribute-family'                          => 'Famiglia di Attributi',
                    'attribute-name-children-only'              => 'Nome dell\'Attributo Solo Figli',
                    'attribute-name-parent-only'                => 'Nome dell\'Attributo Solo Genitori',
                    'auto-generate-coupon'                      => 'Genera Coupon Automaticamente',
                    'back-btn'                                  => 'Indietro',
                    'buy-x-get-y-free'                          => 'Compra X Ottieni Y Gratis',
                    'buy-x-quantity'                            => 'Compra Quantità X',
                    'cart-attribute'                            => 'Attributo del Carrello',
                    'cart-item-attribute'                       => 'Attributo dell\'Articolo nel Carrello',
                    'categories'                                => 'Categorie',
                    'channels'                                  => 'Canali',
                    'children-categories'                       => 'Categorie Figlie',
                    'choose-condition-to-add'                   => 'Scegli la condizione da aggiungere',
                    'code-format'                               => 'Formato Codice',
                    'code-prefix'                               => 'Prefisso Codice',
                    'code-suffix'                               => 'Suffisso Codice',
                    'condition-type'                            => 'Tipo di Condizione',
                    'conditions'                                => 'Condizioni',
                    'contain'                                   => 'Contiene',
                    'contains'                                  => 'Contiene',
                    'coupon-code'                               => 'Codice Coupon',
                    'coupon-length'                             => 'Lunghezza Coupon',
                    'coupon-qty'                                => 'Quantità Coupon',
                    'coupon-type'                               => 'Tipo di Coupon',
                    'customer-group'                            => 'Gruppo di Clienti',
                    'customer-groups'                           => 'Gruppi di Clienti',
                    'description'                               => 'Descrizione',
                    'discount-amount'                           => 'Importo Sconto',
                    'does-not-contain'                          => 'Non Contiene',
                    'end-of-other-rules'                        => 'Fine di Altre Regole',
                    'equals-or-greater-than'                    => 'Uguale o maggiore di',
                    'equals-or-less-than'                       => 'Uguale o minore di',
                    'fixed-amount'                              => 'Importo Fisso',
                    'fixed-amount-whole-cart'                   => 'Importo Fisso per l\'intero Carrello',
                    'free-shipping'                             => 'Spedizione Gratuita',
                    'from'                                      => 'Da',
                    'general'                                   => 'Generale',
                    'generate'                                  => 'Genera',
                    'greater-than'                              => 'Maggiore di',
                    'is-equal-to'                               => 'È uguale a',
                    'is-not-equal-to'                           => 'Non è uguale a',
                    'less-than'                                 => 'Minore di',
                    'marketing-time'                            => 'Tempo di Marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantità massima consentita per lo sconto',
                    'name'                                      => 'Nome',
                    'no'                                        => 'No',
                    'no-coupon'                                 => 'Nessun Coupon',
                    'numeric'                                   => 'Numerico',
                    'parent-categories'                         => 'Categorie Genitore',
                    'payment-method'                            => 'Metodo di Pagamento',
                    'percentage-product-price'                  => 'Percentuale del Prezzo del Prodotto',
                    'price-in-cart'                             => 'Prezzo nel Carrello',
                    'priority'                                  => 'Priorità',
                    'product-attribute'                         => 'Attributo del Prodotto',
                    'qty-in-cart'                               => 'Quantità nel Carrello',
                    'save-btn'                                  => 'Salva Regola del Carrello',
                    'settings'                                  => 'Impostazioni',
                    'shipping-country'                          => 'Paese di Spedizione',
                    'shipping-method'                           => 'Metodo di Spedizione',
                    'shipping-postcode'                         => 'Codice Postale di Spedizione',
                    'shipping-state'                            => 'Stato di Spedizione',
                    'specific-coupon'                           => 'Coupon Specifico',
                    'status'                                    => 'Stato',
                    'subtotal'                                  => 'Subtotale',
                    'title'                                     => 'Modifica Regola del Carrello',
                    'to'                                        => 'A',
                    'total-items-qty'                           => 'Quantità Totale Articoli',
                    'total-weight'                              => 'Peso Totale',
                    'update-success'                            => 'Regola del carrello aggiornata con successo',
                    'uses-per-coupon'                           => 'Usi per Coupon',
                    'uses-per-customer'                         => 'Usi per Cliente',
                    'uses-per-customer-control-info'            => 'Sarà utilizzato solo per i clienti autenticati.',
                    'yes'                                       => 'Sì',
                ],

                'delete-failed'  => 'Eliminazione Regola del Carrello Fallita',
                'delete-success' => 'Regola del Carrello Eliminata con Successo',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'Crea Regola del Catalogo',
                    'title'      => 'Regole del Catalogo',

                    'datagrid' => [
                        'active'   => 'Attivo',
                        'delete'   => 'Elimina',
                        'edit'     => 'Modifica',
                        'end'      => 'Fine',
                        'id'       => 'ID',
                        'inactive' => 'Inattivo',
                        'name'     => 'Nome',
                        'priority' => 'Priorità',
                        'start'    => 'Inizio',
                        'status'   => 'Stato',
                    ],
                ],

                'create' => [
                    'action-type'              => 'Tipo di Azione',
                    'actions'                  => 'Azioni',
                    'add-condition'            => 'Aggiungi Condizione',
                    'all-conditions-true'      => 'Tutte le condizioni sono vere',
                    'any-conditions-true'      => 'Almeno una condizione è vera',
                    'attribute-family'         => 'Famiglia di Attributi',
                    'back-btn'                 => 'Indietro',
                    'categories'               => 'Categorie',
                    'channels'                 => 'Canali',
                    'choose-condition-to-add'  => 'Scegli Condizione da Aggiungere',
                    'condition-type'           => 'Tipo di Condizione',
                    'conditions'               => 'Condizioni',
                    'contain'                  => 'Contiene',
                    'contains'                 => 'Contiene',
                    'customer-groups'          => 'Gruppi di Clienti',
                    'description'              => 'Descrizione',
                    'discount-amount'          => 'Importo Sconto',
                    'does-not-contain'         => 'Non contiene',
                    'end-other-rules'          => 'Termina altre regole',
                    'equals-or-greater-than'   => 'Uguale o maggiore di',
                    'equals-or-less-than'      => 'Uguale o minore di',
                    'fixed-amount'             => 'Importo Fisso',
                    'from'                     => 'Da',
                    'general'                  => 'Generale',
                    'greater-than'             => 'Maggiore di',
                    'is-equal-to'              => 'È uguale a',
                    'is-not-equal-to'          => 'Non è uguale a',
                    'less-than'                => 'Minore di',
                    'marketing-time'           => 'Tempo di Marketing',
                    'name'                     => 'Nome',
                    'no'                       => 'No',
                    'percentage-product-price' => 'Percentuale del Prezzo del Prodotto',
                    'priority'                 => 'Priorità',
                    'product-attribute'        => 'Attributo del Prodotto',
                    'save-btn'                 => 'Salva Regola del Catalogo',
                    'settings'                 => 'Impostazioni',
                    'status'                   => 'Stato',
                    'title'                    => 'Crea Regola del Catalogo',
                    'to'                       => 'A',
                    'yes'                      => 'Sì',
                ],

                'edit' => [
                    'action-type'              => 'Tipo di Azione',
                    'actions'                  => 'Azioni',
                    'add-condition'            => 'Aggiungi Condizione',
                    'all-conditions-true'      => 'Tutte le condizioni sono vere',
                    'any-conditions-true'      => 'Almeno una condizione è vera',
                    'back-btn'                 => 'Indietro',
                    'categories'               => 'Categorie',
                    'channels'                 => 'Canali',
                    'choose-condition-to-add'  => 'Scegli Condizione da Aggiungere',
                    'condition-type'           => 'Tipo di Condizione',
                    'conditions'               => 'Condizioni',
                    'contain'                  => 'Contiene',
                    'contains'                 => 'Contiene',
                    'customer-groups'          => 'Gruppi di Clienti',
                    'description'              => 'Descrizione',
                    'discount-amount'          => 'Importo Sconto',
                    'does-not-contain'         => 'Non contiene',
                    'end-other-rules'          => 'Termina altre regole',
                    'equals-or-greater-than'   => 'Uguale o maggiore di',
                    'equals-or-less-than'      => 'Uguale o minore di',
                    'fixed-amount'             => 'Importo Fisso',
                    'from'                     => 'Da',
                    'general'                  => 'Generale',
                    'greater-than'             => 'Maggiore di',
                    'is-equal-to'              => 'È uguale a',
                    'is-not-equal-to'          => 'Non è uguale a',
                    'less-than'                => 'Minore di',
                    'marketing-time'           => 'Tempo di Marketing',
                    'name'                     => 'Nome',
                    'no'                       => 'No',
                    'percentage-product-price' => 'Percentuale del Prezzo del Prodotto',
                    'priority'                 => 'Priorità',
                    'product-attribute'        => 'Attributo del Prodotto',
                    'save-btn'                 => 'Salva Regola del Catalogo',
                    'settings'                 => 'Impostazioni',
                    'status'                   => 'Stato',
                    'title'                    => 'Modifica Regola del Catalogo',
                    'to'                       => 'A',
                    'yes'                      => 'Sì',
                ],

                'create-success' => 'Regola del catalogo creata con successo',
                'delete-success' => 'Regola del catalogo eliminata con successo',
                'update-success' => 'Regola del catalogo aggiornata con successo',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'Impossibile eliminare la regola del carrello',
                'delete-success'              => 'Coupon della Regola del Carrello Eliminato con Successo',
                'mass-delete-success'         => 'Elementi Selezionati Eliminati con Successo',
                'success'                     => ':name Creato con Successo',

                'datagrid' => [
                    'coupon-code'     => 'Codice Coupon',
                    'created-date'    => 'Data di Creazione',
                    'delete'          => 'Elimina',
                    'expiration-date' => 'Data di Scadenza',
                    'id'              => 'ID',
                    'times-used'      => 'Volte Usato',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Crea Termine di Ricerca',
                    'title'      => 'Termini di Ricerca',

                    'datagrid' => [
                        'actions'             => 'Azioni',
                        'channel'             => 'Canale',
                        'delete'              => 'Elimina',
                        'edit'                => 'Modifica',
                        'id'                  => 'ID',
                        'locale'              => 'Località',
                        'mass-delete-success' => 'Termini di Ricerca Selezionati Eliminati con Successo',
                        'redirect-url'        => 'URL di Reindirizzamento',
                        'results'             => 'Risultati',
                        'search-query'        => 'Query di Ricerca',
                        'uses'                => 'Usi',
                    ],

                    'create' => [
                        'channel'        => 'Canale',
                        'delete-warning' => 'Sei sicuro di voler eseguire questa azione?',
                        'locale'         => 'Località',
                        'redirect-url'   => 'URL di Reindirizzamento',
                        'results'        => 'Risultati',
                        'save-btn'       => 'Salva Termine di Ricerca',
                        'search-query'   => 'Query di Ricerca',
                        'success'        => 'Termine di Ricerca creato con successo',
                        'title'          => 'Crea Termine di Ricerca',
                        'uses'           => 'Usi',
                    ],

                    'edit' => [
                        'delete-success' => 'Termine di Ricerca eliminato con successo',
                        'success'        => 'Termine di Ricerca aggiornato con successo',
                        'title'          => 'Modifica Termine di Ricerca',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Crea Sinonimo di Ricerca',
                    'title'      => 'Sinonimi di Ricerca',

                    'datagrid' => [
                        'actions'             => 'Azioni',
                        'delete'              => 'Elimina',
                        'edit'                => 'Modifica',
                        'id'                  => 'ID',
                        'mass-delete-success' => 'Sinonimi di Ricerca Selezionati Eliminati con Successo',
                        'name'                => 'Nome',
                        'terms'               => 'Termini',
                    ],

                    'create' => [
                        'delete-warning' => 'Sei sicuro di voler eseguire questa azione?',
                        'name'           => 'Nome',
                        'save-btn'       => 'Salva Sinonimo di Ricerca',
                        'success'        => 'Sinonimo di Ricerca creato con successo',
                        'terms'          => 'Termini',
                        'terms-info'     => 'Inserisci i sinonimi come lista separata da virgole, ad esempio, "scarpe,calzature." Questo espande la ricerca includendo entrambi i termini.',
                        'title'          => 'Crea Sinonimo di Ricerca',
                    ],

                    'edit' => [
                        'delete-success' => 'Sinonimo di Ricerca eliminato con successo',
                        'success'        => 'Sinonimo di Ricerca aggiornato con successo',
                        'title'          => 'Modifica Sinonimo di Ricerca',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Crea Mappa del Sito',
                    'sitemap'    => 'Mappa del Sito',
                    'title'      => 'Mappe del Sito',

                    'datagrid' => [
                        'actions'         => 'Azioni',
                        'delete'          => 'Elimina',
                        'edit'            => 'Modifica',
                        'file-name'       => 'Nome File',
                        'id'              => 'ID',
                        'link-for-google' => 'Link per Google',
                        'path'            => 'Percorso',
                    ],

                    'create' => [
                        'delete-warning' => 'Sei sicuro di voler eseguire questa azione?',
                        'file-name'      => 'Nome File',
                        'file-name-info' => 'Esempio: sitemap.xml',
                        'path'           => 'Percorso',
                        'path-info'      => 'Esempio: "/sitemap/" o "/" per il percorso di base',
                        'save-btn'       => 'Salva Mappa del Sito',
                        'success'        => 'Mappa del Sito creata con successo',
                        'title'          => 'Crea Mappa del Sito',
                    ],

                    'edit' => [
                        'delete-success' => 'Sitemap eliminata con successo',
                        'success'        => 'Sitemap aggiornata con successo',
                        'title'          => 'Modifica Sitemap',
                    ],
                ],

                'edit' => [
                    'back-btn'       => 'Indietro',
                    'file-name'      => 'Nome File',
                    'file-name-info' => 'Esempio: sitemap.xml',
                    'general'        => 'Generale',
                    'path'           => 'Percorso',
                    'path-info'      => 'Esempio: "/sitemap/" o "/" per il percorso di base',
                    'save-btn'       => 'Salva Mappa del Sito',
                ],

                'delete-failed' => ':name Eliminato Fallito',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'Crea Riscrittura URL',
                    'title'      => 'Riscritture URL',

                    'datagrid' => [
                        'actions'             => 'Azioni',
                        'category'            => 'Categoria',
                        'cms-page'            => 'Pagina CMS',
                        'delete'              => 'Elimina',
                        'edit'                => 'Modifica',
                        'for'                 => 'Per',
                        'id'                  => 'ID',
                        'locale'              => 'Località',
                        'mass-delete-success' => 'Riscritture URL Selezionate Eliminate con Successo',
                        'permanent-redirect'  => 'Permanente (301)',
                        'product'             => 'Prodotto',
                        'redirect-type'       => 'Tipo di Reindirizzamento',
                        'request-path'        => 'Percorso Richiesto',
                        'target-path'         => 'Percorso di Destinazione',
                        'temporary-redirect'  => 'Temporaneo (302)',
                    ],

                    'create' => [
                        'category'           => 'Categoria',
                        'cms-page'           => 'Pagina CMS',
                        'delete-warning'     => 'Sei sicuro di voler eseguire questa azione?',
                        'for'                => 'Per',
                        'locale'             => 'Località',
                        'permanent-redirect' => 'Permanente (301)',
                        'product'            => 'Prodotto',
                        'redirect-type'      => 'Tipo di Reindirizzamento',
                        'request-path'       => 'Percorso Richiesto',
                        'save-btn'           => 'Salva Riscrittura URL',
                        'success'            => 'Riscrittura URL creata con successo',
                        'target-path'        => 'Percorso di Destinazione',
                        'temporary-redirect' => 'Temporaneo (302)',
                        'title'              => 'Crea Riscrittura URL',
                    ],

                    'edit' => [
                        'delete-success' => 'Riscrittura URL eliminata con successo',
                        'success'        => 'Riscrittura URL aggiornata con successo',
                        'title'          => 'Modifica Riscrittura URL',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'Il :name è già stato preso.',
            'channel'       => 'Canale',
            'create-btn'    => 'Crea Pagina',
            'language'      => 'Lingua',
            'title'         => 'Pagine',

            'datagrid' => [
                'channel'             => 'Canale',
                'delete'              => 'Elimina',
                'edit'                => 'Modifica',
                'id'                  => 'ID',
                'mass-delete-success' => 'Dati Selezionati Eliminati con Successo',
                'page-title'          => 'Titolo della Pagina',
                'url-key'             => 'Chiave dell\'URL',
                'view'                => 'Vista',
            ],
        ],

        'create' => [
            'channels'         => 'Canali',
            'content'          => 'Contenuto',
            'description'      => 'Descrizione',
            'general'          => 'Generale',
            'meta-description' => 'Meta Description',
            'meta-keywords'    => 'Meta Keywords',
            'meta-title'       => 'Meta Title',
            'page-title'       => 'Titolo',
            'save-btn'         => 'Salva Pagina',
            'seo'              => 'SEO',
            'title'            => 'Crea Pagina',
            'url-key'          => 'Chiave dell\'URL',
        ],

        'edit' => [
            'back-btn'         => 'Indietro',
            'channels'         => 'Canali',
            'content'          => 'Contenuto',
            'description'      => 'Descrizione',
            'general'          => 'Generale',
            'meta-description' => 'Meta Description',
            'meta-keywords'    => 'Meta Keywords',
            'meta-title'       => 'Meta Title',
            'page-title'       => 'Titolo della Pagina',
            'preview-btn'      => 'Anteprima Pagina',
            'save-btn'         => 'Salva Pagina',
            'seo'              => 'SEO',
            'title'            => 'Modifica Pagina',
            'url-key'          => 'Chiave dell\'URL',
        ],

        'create-success' => 'CMS creato con successo.',
        'delete-success' => 'CMS eliminato con successo.',
        'no-resource'    => 'La risorsa non esiste.',
        'update-success' => 'CMS aggiornato con successo.',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'Crea Locale',
                'locale'     => 'Locale',
                'logo-size'  => 'La risoluzione dell\'immagine dovrebbe essere di 24px x 16px',
                'title'      => 'Località',

                'datagrid' => [
                    'actions'   => 'Azioni',
                    'code'      => 'Codice',
                    'delete'    => 'Elimina',
                    'direction' => 'Direzione',
                    'edit'      => 'Modifica',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Nome',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Codice',
                    'direction'        => 'Direzione',
                    'locale-logo'      => 'Logo Locale',
                    'name'             => 'Nome',
                    'save-btn'         => 'Salva Locale',
                    'select-direction' => 'Seleziona Direzione',
                    'title'            => 'Crea Locale',
                ],

                'edit' => [
                    'title' => 'Modifica Locale',
                ],

                'create-success'    => 'Locale creato con successo.',
                'delete-failed'     => 'Eliminazione del Locale fallita',
                'delete-success'    => 'Locale eliminato con successo.',
                'delete-warning'    => 'Sei sicuro di voler eseguire questa azione?',
                'last-delete-error' => 'È richiesto almeno un Locale.',
                'update-success'    => 'Locale aggiornato con successo.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Crea Valuta',
                'currency'   => 'Valuta',
                'title'      => 'Valute',

                'datagrid' => [
                    'actions'        => 'Azioni',
                    'code'           => 'Codice',
                    'delete'         => 'Elimina',
                    'edit'           => 'Modifica',
                    'id'             => 'ID',
                    'method-error'   => 'Errore! Metodo errato rilevato, controlla la configurazione delle azioni di massa',
                    'name'           => 'Nome',
                    'no-resource'    => 'La risorsa fornita è insufficiente per l\'azione',
                    'partial-action' => 'Alcune azioni non sono state eseguite a causa di vincoli di sistema restrittivi su :resource',
                    'update-success' => ':resource selezionate aggiornate con successo',
                ],

                'create' => [
                    'code'                   => 'Código',
                    'create-btn'             => 'Crear Moneda',
                    'currency-position'      => 'Posizione Valuta',
                    'decimal'                => 'Separador Decimal',
                    'decimal-separator'      => 'Separador Decimal',
                    'decimal-separator-note' => 'Il campo :attribute può accettare solo gli operatori virgola (,) e punto (.)',
                    'delete-warning'         => '¿Estás seguro de que deseas realizar esta acción?',
                    'general'                => 'General',
                    'group-separator'        => 'Separatore di Gruppo',
                    'group-separator-note'   => 'Il campo :attribute può accettare solo i caratteri virgola (,), punto (.), apostrofo (\') e spazio ( ).',
                    'name'                   => 'Nombre',
                    'save-btn'               => 'Guardar Moneda',
                    'symbol'                 => 'Símbolo',
                    'title'                  => 'Crear Nueva Moneda',
                ],

                'edit' => [
                    'title' => 'Modifica Valuta',
                ],

                'create-success'    => 'Valuta creata con successo.',
                'delete-failed'     => 'Eliminazione della Valuta fallita',
                'delete-success'    => 'Valuta eliminata con successo.',
                'last-delete-error' => 'È richiesta almeno una Valuta.',
                'update-success'    => 'Valuta aggiornata con successo.',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Azione',
                    'allowed-errors'      => 'Errori Consentiti',
                    'back-btn'            => 'Indietro',
                    'create-update'       => 'Crea/Aggiorna',
                    'delete'              => 'Elimina',
                    'download-sample'     => 'Scarica Esempio',
                    'field-separator'     => 'Separatore di Campi',
                    'file'                => 'File',
                    'file-info'           => 'Usa il percorso relativo a /project-root/storage/app/import, ad esempio: product-images, import-images.',
                    'file-info-example'   => 'Ad esempio, nel caso delle immagini del prodotto, i file dovrebbero essere collocati nella cartella /project-root/storage/app/import/product-images.',
                    'general'             => 'Generale',
                    'images-directory'    => 'Percorso Directory Immagini',
                    'process-in-queue'    => 'Elabora nella Coda',
                    'results'             => 'Risultati',
                    'save-btn'            => 'Salva Importazione',
                    'settings'            => 'Impostazioni',
                    'skip-errors'         => 'Salta Errori',
                    'stop-on-errors'      => 'Ferma su Errori',
                    'title'               => 'Crea Importazione',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Strategia di Validazione',
                ],

                'edit' => [
                    'action'              => 'Azione',
                    'allowed-errors'      => 'Errori Consentiti',
                    'back-btn'            => 'Indietro',
                    'create-update'       => 'Crea/Aggiorna',
                    'current-file'        => 'File Caricato Corrente',
                    'delete'              => 'Elimina',
                    'download-sample'     => 'Scarica Esempio',
                    'field-separator'     => 'Separatore di Campi',
                    'file'                => 'File',
                    'file-info'           => 'Usa il percorso relativo a /project-root/storage/app/import, ad esempio: product-images, import-images.',
                    'file-info-example'   => 'Ad esempio, nel caso delle immagini del prodotto, i file dovrebbero essere collocati nella cartella /project-root/storage/app/import/product-images.',
                    'general'             => 'Generale',
                    'images-directory'    => 'Percorso Directory Immagini',
                    'process-in-queue'    => 'Elabora nella Coda',
                    'results'             => 'Risultati',
                    'save-btn'            => 'Salva Importazione',
                    'settings'            => 'Impostazioni',
                    'skip-errors'         => 'Salta Errori',
                    'stop-on-errors'      => 'Ferma su Errori',
                    'title'               => 'Modifica Importazione',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Strategia di Validazione',
                ],

                'index' => [
                    'button-title' => 'Crea Importazione',
                    'title'        => 'Importazioni',

                    'datagrid' => [
                        'actions'       => 'Azioni',
                        'completed-at'  => 'Completato il',
                        'created'       => 'Creato',
                        'delete'        => 'Elimina',
                        'deleted'       => 'Eliminato',
                        'edit'          => 'Modifica',
                        'error-file'    => 'File degli Errori',
                        'id'            => 'ID',
                        'started-at'    => 'Iniziato il',
                        'state'         => 'Stato',
                        'summary'       => 'Riepilogo',
                        'updated'       => 'Aggiornato',
                        'uploaded-file' => 'File Caricato',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Indietro',
                    'completed-batches'       => 'Totale Batch Completati:',
                    'download-error-report'   => 'Scarica Rapporto Completo degli Errori',
                    'edit-btn'                => 'Modifica',
                    'imported-info'           => 'Congratulazioni! La tua importazione è stata completata con successo.',
                    'importing-info'          => 'Importazione in Corso',
                    'indexing-info'           => 'Indicizzazione delle Risorse (Prezzo, Inventario e Ricerca Elastica) in Corso',
                    'linking-info'            => 'Collegamento delle Risorse in Corso',
                    'progress'                => 'Progresso:',
                    'title'                   => 'Importazione',
                    'total-batches'           => 'Totale Batch:',
                    'total-created'           => 'Totale Record Creati:',
                    'total-deleted'           => 'Totale Record Eliminati:',
                    'total-errors'            => 'Totale Errori:',
                    'total-invalid-rows'      => 'Totale Righe Non Valide:',
                    'total-rows-processed'    => 'Totale Righe Elaborate:',
                    'total-updated'           => 'Totale Record Aggiornati:',
                    'validate-info'           => 'Clicca su "Valida Dati" per verificare la tua importazione.',
                    'validate'                => 'Valida',
                    'validating-info'         => 'Lettura e Validazione dei Dati in Corso',
                    'validation-failed-info'  => 'La tua importazione non è valida. Correggi gli errori seguenti e riprova.',
                    'validation-success-info' => 'La tua importazione è valida. Clicca su "Importa" per avviare il processo di importazione.',
                ],

                'create-success'    => 'Importazione creata con successo.',
                'delete-failed'     => 'Eliminazione Importazione fallita in modo imprevisto.',
                'delete-success'    => 'Importazione eliminata con successo.',
                'not-valid'         => 'Importazione non valida',
                'nothing-to-import' => 'Non ci sono risorse da importare.',
                'setup-queue-error' => 'Modifica il tuo gestore di code a "database" o "redis" per avviare il processo di importazione.',
                'update-success'    => 'Importazione aggiornata con successo.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Crea Tasso di Cambio',
                'exchange-rate' => 'Tasso di Cambio',
                'title'         => 'Tassi di Cambio',
                'update-rates'  => 'Aggiorna Tassi di Cambio',

                'create' => [
                    'delete-warning'         => 'Sei sicuro di voler eseguire questa azione?',
                    'rate'                   => 'Tasso',
                    'save-btn'               => 'Salva Tasso di Cambio',
                    'select-target-currency' => 'Seleziona Valuta di Destinazione',
                    'source-currency'        => 'Valuta di Origine',
                    'target-currency'        => 'Valuta di Destinazione',
                    'title'                  => 'Crea Tasso di Cambio',
                ],

                'edit' => [
                    'title' => 'Modifica Tassi di Cambio',
                ],

                'datagrid' => [
                    'actions'       => 'Azioni',
                    'currency-name' => 'Nome Valuta',
                    'delete'        => 'Elimina',
                    'edit'          => 'Modifica',
                    'exchange-rate' => 'Tasso di Cambio',
                    'id'            => 'ID',
                ],

                'create-success'  => 'Tasso di Cambio Creato con Successo',
                'delete-error'    => 'Errore durante l\'eliminazione del Tasso di Cambio',
                'delete-success'  => 'Tasso di Cambio Eliminato con Successo',
                'update-success'  => 'Tasso di Cambio Aggiornato con Successo',
            ],
        ],

        'inventory-sources' => [
            'index'  => [
                'create-btn' => 'Crea fonte inventario',
                'title'      => 'Sorgenti di Inventario',

                'datagrid' => [
                    'active'   => 'Attivo',
                    'code'     => 'Codice',
                    'delete'   => 'Elimina',
                    'edit'     => 'Modifica',
                    'id'       => 'ID',
                    'inactive' => 'Inattivo',
                    'name'     => 'Nome',
                    'priority' => 'Priorità',
                    'status'   => 'Stato',
                ],
            ],

            'create' => [
                'add-title'      => 'Aggiungi Sorgente di Inventario',
                'address'        => 'Indirizzo della Sorgente',
                'back-btn'       => 'Indietro',
                'city'           => 'Città',
                'code'           => 'Codice',
                'contact-email'  => 'Email',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informazioni di Contatto',
                'contact-name'   => 'Nome',
                'contact-number' => 'Numero di Contatto',
                'country'        => 'Paese',
                'description'    => 'Descrizione',
                'general'        => 'Generale',
                'latitude'       => 'Latitudine',
                'longitude'      => 'Longitudine',
                'name'           => 'Nome',
                'postcode'       => 'CAP',
                'priority'       => 'Priorità',
                'save-btn'       => 'Salva Sorgenti di Inventario',
                'select-country' => 'Seleziona Paese',
                'select-state'   => 'Seleziona Stato',
                'settings'       => 'Impostazioni',
                'state'          => 'Stato',
                'status'         => 'Stato',
                'street'         => 'Via',
                'title'          => 'Sorgenti di Inventario',
            ],

            'edit' => [
                'back-btn'       => 'Indietro',
                'city'           => 'Città',
                'code'           => 'Codice',
                'contact-email'  => 'Email',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informazioni di Contatto',
                'contact-name'   => 'Nome',
                'contact-number' => 'Numero di Contatto',
                'country'        => 'Paese',
                'description'    => 'Descrizione',
                'general'        => 'Generale',
                'latitude'       => 'Latitudine',
                'longitude'      => 'Longitudine',
                'name'           => 'Nome',
                'postcode'       => 'CAP',
                'priority'       => 'Priorità',
                'save-btn'       => 'Salva Sorgenti di Inventario',
                'select-country' => 'Seleziona Paese',
                'select-state'   => 'Seleziona Stato',
                'settings'       => 'Impostazioni',
                'source-address' => 'Indirizzo della Sorgente',
                'state'          => 'Stato',
                'status'         => 'Stato',
                'street'         => 'Via',
                'title'          => 'Modifica Sorgenti di Inventario',
            ],

            'create-success'    => 'Sorgente di Inventario Creata con Successo',
            'delete-failed'     => 'Eliminazione delle Sorgenti di Inventario Fallita',
            'delete-success'    => 'Sorgenti di Inventario Eliminate con Successo',
            'last-delete-error' => 'Impossibile Eliminare l\'Ultima Sorgente di Inventario',
            'update-success'    => 'Sorgenti di Inventario Aggiornate con Successo',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => 'Sei sicuro di voler eliminare?',
                    'tax-category'   => 'Categoria Fiscale',
                    'title'          => 'Categorie Fiscali',

                    'datagrid' => [
                        'actions' => 'Azioni',
                        'code'    => 'Codice',
                        'delete'  => 'Elimina',
                        'edit'    => 'Modifica',
                        'id'      => 'ID',
                        'name'    => 'Nome',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Aggiungi Aliquote Fiscali',
                        'code'          => 'Codice',
                        'description'   => 'Descrizione',
                        'empty-text'    => 'Le Aliquote Fiscali non sono disponibili, crea nuove Aliquote Fiscali.',
                        'general'       => 'Categoria Fiscale',
                        'name'          => 'Nome',
                        'save-btn'      => 'Salva Categoria Fiscale',
                        'select'        => 'Seleziona',
                        'tax-rates'     => 'Aliquote Fiscali',
                        'title'         => 'Crea Categoria Fiscale',
                    ],

                    'edit' => [
                        'title' => 'Modifica Categorie Fiscali',
                    ],

                    'can-not-delete' => 'Le categorie assegnate alle aliquote fiscali non possono essere eliminate.',
                    'create-success' => 'Nuova Categoria Fiscale Creata',
                    'delete-failed'  => 'Eliminazione Categoria Fiscale Fallita',
                    'delete-success' => 'Categoria Fiscale Eliminata con Successo',
                    'update-success' => 'Categoria Fiscale Aggiornata con Successo',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => 'Crea aliquota fiscale',
                    'tax-rate'     => 'Aliquota Fiscale',
                    'title'        => 'Aliquote Fiscali',

                    'datagrid' => [
                        'country'    => 'Paese',
                        'delete'     => 'Elimina',
                        'edit'       => 'Modifica',
                        'id'         => 'ID',
                        'identifier' => 'Identificatore',
                        'state'      => 'Stato',
                        'tax-rate'   => 'Aliquota Fiscale',
                        'zip-code'   => 'CAP',
                        'zip-from'   => 'CAP Da',
                        'zip-to'     => 'CAP A',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Indietro',
                    'country'        => 'Paese',
                    'general'        => 'Generale',
                    'identifier'     => 'Identificatore',
                    'is-zip'         => 'Abilita Intervallo CAP',
                    'save-btn'       => 'Salva Aliquota Fiscale',
                    'select-country' => 'Seleziona Paese',
                    'select-state'   => 'Seleziona Stato',
                    'settings'       => 'Impostazioni',
                    'state'          => 'Stato',
                    'tax-rate'       => 'Aliquota',
                    'title'          => 'Crea Aliquota Fiscale',
                    'zip-code'       => 'CAP',
                    'zip-from'       => 'CAP Da',
                    'zip-to'         => 'CAP A',
                ],

                'edit' => [
                    'back-btn'       => 'Indietro',
                    'country'        => 'Paese',
                    'identifier'     => 'Identificatore',
                    'save-btn'       => 'Salva Aliquota Fiscale',
                    'select-country' => 'Seleziona Paese',
                    'select-state'   => 'Seleziona Stato',
                    'settings'       => 'Impostazioni',
                    'state'          => 'Stato',
                    'tax-rate'       => 'Aliquota',
                    'title'          => 'Modifica Aliquota Fiscale',
                    'zip-code'       => 'CAP',
                    'zip-from'       => 'CAP Da',
                    'zip-to'         => 'CAP A',
                ],

                'create-success' => 'Aliquota Fiscale creata con successo.',
                'delete-failed'  => 'Eliminazione Aliquota Fiscale fallita',
                'delete-success' => 'Aliquota Fiscale eliminata con successo',
                'update-success' => 'Aggiornamento Aliquota Fiscale riuscito',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Crea Canale',
                'delete-failed'     => 'Eliminazione Canale fallita',
                'delete-success'    => 'Canale eliminato con successo.',
                'last-delete-error' => 'Ultima eliminazione Canale fallita.',
                'title'             => 'Canali',

                'datagrid' => [
                    'code'      => 'Codice',
                    'delete'    => 'Elimina',
                    'edit'      => 'Modifica',
                    'host-name' => 'Nome Host',
                    'id'        => 'ID',
                    'name'      => 'Nome',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'IP consentiti',
                'cancel'                  => 'Indietro',
                'code'                    => 'Codice',
                'create-success'          => 'Canale creato con successo.',
                'currencies'              => 'Valute',
                'currencies-and-locales'  => 'Valute e Localizzazioni',
                'default-currency'        => 'Valuta predefinita',
                'default-locale'          => 'Localizzazione predefinita',
                'description'             => 'Descrizione',
                'design'                  => 'Design',
                'favicon'                 => 'Favicon',
                'favicon-size'            => 'La risoluzione dell\'immagine dovrebbe essere di 16px X 16px',
                'general'                 => 'Generale',
                'hostname'                => 'Hostname',
                'hostname-placeholder'    => 'https://www.esempio.com (Non aggiungere la barra alla fine.)',
                'inventory-sources'       => 'Sorgenti Inventario',
                'last-delete-error'       => 'È richiesto almeno un Canale.',
                'locales'                 => 'Localizzazioni',
                'logo'                    => 'Logo',
                'logo-size'               => 'La risoluzione dell\'immagine dovrebbe essere di 192px X 50px',
                'maintenance-mode-text'   => 'Messaggio',
                'name'                    => 'Nome',
                'root-category'           => 'Categoria Radice',
                'save-btn'                => 'Salva Canale',
                'select-default-currency' => 'Seleziona Valuta Predefinita',
                'select-default-locale'   => 'Seleziona Localizzazione Predefinita',
                'select-root-category'    => 'Seleziona Categoria Radice',
                'select-theme'            => 'Seleziona Tema',
                'seo'                     => 'SEO della pagina principale',
                'seo-description'         => 'Meta descrizione',
                'seo-keywords'            => 'Meta parole chiave',
                'seo-title'               => 'Meta titolo',
                'settings'                => 'Impostazioni',
                'status'                  => 'Stato',
                'theme'                   => 'Tema',
                'title'                   => 'Crea Canale',
            ],

            'edit' => [
                'allowed-ips'            => 'IP consentiti',
                'back-btn'               => 'Indietro',
                'code'                   => 'Codice',
                'currencies'             => 'Valute',
                'currencies-and-locales' => 'Valute e Localizzazioni',
                'default-currency'       => 'Valuta predefinita',
                'default-locale'         => 'Localizzazione predefinita',
                'description'            => 'Descrizione',
                'design'                 => 'Design',
                'favicon'                => 'Favicon',
                'favicon-size'           => 'La risoluzione dell\'immagine dovrebbe essere di 16px X 16px',
                'general'                => 'Generale',
                'hostname'               => 'Hostname',
                'hostname-placeholder'   => 'https://www.esempio.com (Non aggiungere la barra alla fine.)',
                'inventory-sources'      => 'Sorgenti Inventario',
                'last-delete-error'      => 'È richiesto almeno un Canale.',
                'locales'                => 'Localizzazioni',
                'logo'                   => 'Logo',
                'logo-size'              => 'La risoluzione dell\'immagine dovrebbe essere di 192px X 50px',
                'maintenance-mode'       => 'Modalità Manutenzione',
                'maintenance-mode-text'  => 'Messaggio',
                'name'                   => 'Nome',
                'root-category'          => 'Categoria Radice',
                'save-btn'               => 'Salva Canale',
                'seo'                    => 'SEO della pagina principale',
                'seo-description'        => 'Meta descrizione',
                'seo-keywords'           => 'Meta parole chiave',
                'seo-title'              => 'Meta titolo',
                'status'                 => 'Stato',
                'theme'                  => 'Tema',
                'title'                  => 'Modifica Canale',
                'update-success'         => 'Aggiorna Canale con successo',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Admin',
                'title' => 'Utenti',
                'user'  => 'Utente',

                'create' => [
                    'confirm-password'  => 'Conferma Password',
                    'email'             => 'Email',
                    'name'              => 'Nome',
                    'password'          => 'Password',
                    'role'              => 'Ruolo',
                    'save-btn'          => 'Salva Utente',
                    'status'            => 'Stato',
                    'title'             => 'Crea Utente',
                    'upload-image-info' => 'Carica un\'immagine del profilo (110px X 110px) in formato PNG o JPG',
                ],

                'datagrid' => [
                    'actions'  => 'Azioni',
                    'active'   => 'Attivo',
                    'delete'   => 'Elimina',
                    'edit'     => 'Modifica',
                    'email'    => 'Email',
                    'id'       => 'ID',
                    'inactive' => 'Inattivo',
                    'name'     => 'Nome',
                    'role'     => 'Ruolo',
                    'status'   => 'Stato',
                ],

                'edit' => [
                    'title' => 'Modifica Utente',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Indietro',
                'confirm-password' => 'Conferma Password',
                'email'            => 'Email',
                'general'          => 'Generale',
                'name'             => 'Nome',
                'password'         => 'Password',
                'role'             => 'Ruolo',
                'save-btn'         => 'Salva Utente',
                'status'           => 'Stato',
                'title'            => 'Modifica Utente',
            ],

            'activate-warning'   => 'Il tuo account deve ancora essere attivato, contatta l\'amministratore.',
            'cannot-change'      => 'Impossibile modificare l\'utente',
            'create-success'     => 'Utente creato con successo.',
            'delete-failed'      => 'Eliminazione utente fallita.',
            'delete-self-error'  => 'Non puoi eliminare il tuo stesso account.',
            'delete-success'     => 'Utente eliminato con successo.',
            'delete-warning'     => 'Sei sicuro di voler eseguire questa azione?',
            'incorrect-password' => 'Password incorretta',
            'last-delete-error'  => 'Ultima eliminazione utente fallita',
            'login-error'        => 'Verifica le tue credenziali e riprova.',
            'update-success'     => 'Utente aggiornato con successo.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Crea Ruolo',
                'title'      => 'Ruoli',

                'datagrid' => [
                    'custom'          => 'Personalizzato',
                    'all'             => 'Tutti',
                    'permission-type' => 'Tipo di Autorizzazione',
                    'name'            => 'Nome',
                    'id'              => 'Id',
                    'edit'            => 'Modifica',
                    'delete'          => 'Elimina',
                ],
            ],

            'create' => [
                'access-control' => 'Controllo Accessi',
                'all'            => 'Tutti',
                'back-btn'       => 'Indietro',
                'custom'         => 'Personalizzato',
                'description'    => 'Descrizione',
                'general'        => 'Generale',
                'name'           => 'Nome',
                'permissions'    => 'Autorizzazioni',
                'save-btn'       => 'Salva Ruolo',
                'title'          => 'Crea Ruolo',
            ],

            'edit' => [
                'access-control' => 'Controllo Accessi',
                'all'            => 'Tutti',
                'back-btn'       => 'Indietro',
                'custom'         => 'Personalizzato',
                'description'    => 'Descrizione',
                'general'        => 'Generale',
                'name'           => 'Nome',
                'permissions'    => 'Autorizzazioni',
                'save-btn'       => 'Salva Ruolo',
                'title'          => 'Modifica Ruolo',
            ],

            'being-used'        => 'Il ruolo è già utilizzato nell\'Utente Amministratore',
            'create-success'    => 'Ruoli creati con successo',
            'delete-failed'     => 'Eliminazione ruolo fallita',
            'delete-success'    => 'Il ruolo è stato eliminato con successo',
            'last-delete-error' => 'Ultimo ruolo non può essere eliminato',
            'update-success'    => 'Il ruolo è stato aggiornato con successo',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Crea Tema',
                'title'      => 'Temi',

                'datagrid' => [
                    'active'        => 'Attivo',
                    'channel_name'  => 'Nome Canale',
                    'change-status' => 'Cambia stato',
                    'delete'        => 'Elimina',
                    'id'            => 'Id',
                    'inactive'      => 'Inattivo',
                    'name'          => 'Nome',
                    'sort-order'    => 'Ordinamento',
                    'status'        => 'Stato',
                    'theme'         => 'Tema',
                    'type'          => 'Tipo',
                    'view'          => 'Vista',
                ],
            ],

            'create' => [
                'name'       => 'Nome',
                'save-btn'   => 'Salva Tema',
                'sort-order' => 'Ordinamento',
                'themes'     => 'Temi',
                'title'      => 'Crea Tema',

                'type' => [
                    'category-carousel' => 'Carosello Categoria',
                    'footer-links'      => 'Link Piè di Pagina',
                    'image-carousel'    => 'Carosello di immagini',
                    'product-carousel'  => 'Carosello Prodotti',
                    'services-content'  => 'Contenuto Servizi',
                    'static-content'    => 'Contenuto Statico',
                    'title'             => 'Tipo',
                ],
            ],

            'edit' => [
                'active'                        => 'Attivo',
                'add-filter-btn'                => 'Aggiungi Filtro',
                'add-footer-link-btn'           => 'Aggiungi Link Piè di Pagina',
                'add-image-btn'                 => 'Aggiungi Immagine',
                'add-link'                      => 'Aggiungi Link',
                'asc'                           => 'Asc',
                'back'                          => 'Indietro',
                'category-carousel'             => 'Carosello Categoria',
                'category-carousel-description' => 'Visualizza le categorie dinamiche in modo accattivante utilizzando un carosello di categorie responsivo.',
                'channels'                      => 'Canali',
                'column'                        => 'Colonna',
                'create-filter'                 => 'Crea Filtro',
                'css'                           => 'CSS',
                'delete'                        => 'Elimina',
                'desc'                          => 'Desc',
                'edit'                          => 'Modifica',
                'featured'                      => 'In primo piano',
                'filter-title'                  => 'Titolo',
                'filters'                       => 'Filtri',
                'footer-link'                   => 'Link Piè di Pagina',
                'footer-link-description'       => 'Naviga attraverso i link nel piè di pagina per una navigazione e informazioni sul sito senza interruzioni.',
                'footer-link-form-title'        => 'Link Piè di Pagina',
                'footer-title'                  => 'Titolo',
                'general'                       => 'Generale',
                'html'                          => 'HTML',
                'image'                         => 'Immagine',
                'image-size'                    => 'La risoluzione dell\'immagine dovrebbe essere (1920px X 700px)',
                'image-title'                   => 'Titolo Immagine',
                'image-upload-message'          => 'Sono consentite solo immagini (.jpeg, .jpg, .png, .webp, ..).',
                'inactive'                      => 'Inattivo',
                'key'                           => 'Chiave: :key',
                'key-input'                     => 'Chiave',
                'limit'                         => 'Limite',
                'link'                          => 'Link',
                'name'                          => 'Nome',
                'new'                           => 'Nuovo',
                'no'                            => 'No',
                'parent-id'                     => 'ID Genitore',
                'parent-id-hint'                => 'Puoi inserire più ID genitori come valori separati da virgole (ad esempio: 12,15,34)',
                'category-id'                   => 'ID categoria',
                'preview'                       => 'Anteprima',
                'product-carousel'              => 'Carosello Prodotti',
                'product-carousel-description'  => 'Mostra i prodotti in modo elegante con un carosello di prodotti dinamico e responsivo.',
                'save-btn'                      => 'Salva',
                'select'                        => 'Seleziona',
                'slider'                        => 'Slider',
                'slider-add-btn'                => 'Aggiungi Slider',
                'slider-description'            => 'Personalizzazione del tema relativa allo slider.',
                'slider-image'                  => 'Immagine Slider',
                'slider-required'               => 'Il campo slider è obbligatorio.',
                'sort'                          => 'Ordina',
                'sort-order'                    => 'Ordinamento',
                'static-content'                => 'Contenuto Statico',
                'static-content-description'    => 'Aumenta l\'interazione con contenuti statici concisi e informativi per il tuo pubblico.',
                'status'                        => 'Stato',
                'themes'                        => 'Temi',
                'title'                         => 'Modifica Tema',
                'update-slider'                 => 'Aggiorna Slider',
                'url'                           => 'URL',
                'value'                         => 'Valore: :value',
                'value-input'                   => 'Valore',

                'services-content' => [
                    'add-btn'            => 'Aggiungi Servizio',
                    'channels'           => 'Canali',
                    'delete'             => 'Elimina',
                    'description'        => 'Descrizione',
                    'general'            => 'Generale',
                    'name'               => 'Nome',
                    'save-btn'           => 'Salva',
                    'service-icon'       => 'Icona Servizio',
                    'service-icon-class' => 'Classe Icona Servizio',
                    'service-info'       => 'Personalizzazione del tema relativa ai servizi.',
                    'services'           => 'Servizi',
                    'sort-order'         => 'Ordinamento',
                    'status'             => 'Stato',
                    'title'              => 'Titolo',
                    'update-service'     => 'Aggiorna Servizi',
                ],
                'yes'                           => 'Sì',
            ],

            'create-success' => 'Tema creato con successo',
            'delete-success' => 'Tema eliminato con successo',
            'update-success' => 'Tema aggiornato con successo',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Carrelli Abbandonati',
                'abandoned-products'            => 'Prodotti Abbandonati',
                'abandoned-rate'                => 'Tasso di Abbandono',
                'abandoned-revenue'             => 'Ricavo Abbandonato',
                'added-to-cart'                 => 'Aggiunto al Carrello',
                'added-to-cart-info'            => 'Solo :progress visitatori hanno aggiunto prodotti al carrello',
                'all-channels'                  => 'Tutti i Canali',
                'average-order-value-over-time' => 'Valore Medio Ordine Nel Tempo',
                'average-sales'                 => 'Valore Medio Ordine',
                'count'                         => 'Conteggio',
                'end-date'                      => 'Data di Fine',
                'id'                            => 'Id',
                'interval'                      => 'Intervallo',
                'name'                          => 'Nome',
                'orders'                        => 'Ordini',
                'orders-over-time'              => 'Ordini Nel Tempo',
                'payment-method'                => 'Metodo di Pagamento',
                'product-views'                 => 'Visualizzazioni Prodotto',
                'product-views-info'            => 'Solo :progress visitatori hanno visualizzato i prodotti',
                'purchase-funnel'               => 'Tunnel di Acquisto',
                'purchased'                     => 'Acquistati',
                'purchased-info'                => 'Solo :progress visitatori hanno effettuato acquisti',
                'refunds'                       => 'Rimborsi',
                'refunds-over-time'             => 'Rimborsi Nel Tempo',
                'sales-over-time'               => 'Vendite Nel Tempo',
                'shipping-collected'            => 'Spedizione Riscossa',
                'shipping-collected-over-time'  => 'Spedizione Riscossa Nel Tempo',
                'start-date'                    => 'Data di Inizio',
                'tax-collected'                 => 'Tasse Riscosse',
                'tax-collected-over-time'       => 'Tasse Riscosse Nel Tempo',
                'title'                         => 'Vendite',
                'top-payment-methods'           => 'Principali Metodi di Pagamento',
                'top-shipping-methods'          => 'Principali Metodi di Spedizione',
                'top-tax-categories'            => 'Principali Categorie Fiscali',
                'total'                         => 'Totale',
                'total-orders'                  => 'Totale Ordini',
                'total-sales'                   => 'Totale Vendite',
                'total-visits'                  => 'Totale visite',
                'total-visits-info'             => 'Totale visitatori sullo store',
                'view-details'                  => 'Visualizza Dettagli',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Tutti i Canali',
                'count'                       => 'Conteggio',
                'customers'                   => 'Clienti',
                'customers-over-time'         => 'Clienti Nel Tempo',
                'customers-traffic'           => 'Traffico Clienti',
                'customers-with-most-orders'  => 'Clienti Con Più Ordini',
                'customers-with-most-reviews' => 'Clienti Con Più Recensioni',
                'customers-with-most-sales'   => 'Clienti Con Più Vendite',
                'email'                       => 'Email',
                'end-date'                    => 'Data di Fine',
                'id'                          => 'Id',
                'interval'                    => 'Intervallo',
                'name'                        => 'Nome',
                'orders'                      => 'Ordini',
                'reviews'                     => 'Recensioni',
                'start-date'                  => 'Data di Inizio',
                'title'                       => 'Clienti',
                'top-customer-groups'         => 'Principali Gruppi di Clienti',
                'total'                       => 'Totale',
                'total-customers'             => 'Totale Clienti',
                'total-visitors'              => 'Totale Visitatori',
                'traffic-over-week'           => 'Traffico Settimanale',
                'unique-visitors'             => 'Visitatori Unici',
                'view-details'                => 'Visualizza Dettagli',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Tutti i Canali',
                'channel'                          => 'Canale',
                'end-date'                         => 'Data di Fine',
                'id'                               => 'Id',
                'interval'                         => 'Intervallo',
                'last-search-terms'                => 'Ultimi Termini di Ricerca',
                'locale'                           => 'Località',
                'name'                             => 'Nome',
                'orders'                           => 'Ordini',
                'price'                            => 'Prezzo',
                'products-added-over-time'         => 'Prodotti Aggiunti Nel Tempo',
                'products-with-most-reviews'       => 'Prodotti Con Più Recensioni',
                'products-with-most-visits'        => 'Prodotti Con Più Visite',
                'quantities'                       => 'Quantità',
                'quantities-sold-over-time'        => 'Quantità Vendute Nel Tempo',
                'results'                          => 'Risultati',
                'revenue'                          => 'Ricavo',
                'reviews'                          => 'Recensioni',
                'search-term'                      => 'Termine di Ricerca',
                'start-date'                       => 'Data di Inizio',
                'title'                            => 'Prodotti',
                'top-search-terms'                 => 'Principali Termini di Ricerca',
                'top-selling-products-by-quantity' => 'Prodotti Più Venduti per Quantità',
                'top-selling-products-by-revenue'  => 'Prodotti Più Venduti per Ricavo',
                'total'                            => 'Totale',
                'total-products-added-to-wishlist' => 'Totale Prodotti Aggiunti alla Lista dei Desideri',
                'total-sold-quantities'            => 'Totale Quantità Vendute',
                'uses'                             => 'Usi',
                'view-details'                     => 'Visualizza Dettagli',
                'visits'                           => 'Visite',
            ],
        ],

        'view' => [
            'all-channels'  => 'Tutti i Canali',
            'back-btn'      => 'Indietro',
            'day'           => 'Giorno',
            'end-date'      => 'Data di Fine',
            'export-csv'    => 'Esporta CSV',
            'export-xls'    => 'Esporta XLS',
            'month'         => 'Mese',
            'not-available' => 'Nessun Record Disponibile.',
            'start-date'    => 'Data di Inizio',
            'year'          => 'Anno',
        ],

        'empty' => [
            'info'  => 'Nessun dato disponibile per l\'intervallo selezionato',
            'title' => 'Nessun Dato Disponibile',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => 'Indietro',
            'delete'                       => 'Elimina',
            'enable-at-least-one-payment'  => 'Abilita almeno un metodo di pagamento.',
            'enable-at-least-one-shipping' => 'Abilita almeno un metodo di spedizione.',
            'no-result-found'              => 'Nessun risultato trovato',
            'save-btn'                     => 'Salva Configurazione',
            'save-message'                 => 'Configurazione salvata con successo',
            'search'                       => 'Cerca',
            'select-country'               => 'Seleziona Paese',
            'select-state'                 => 'Seleziona Stato',
            'title'                        => 'Configurazione',

            'general' => [
                'info'  => 'Imposta le opzioni delle unità.',
                'title' => 'Generale',

                'general' => [
                    'info'  => 'Imposta le opzioni delle unità e abilita o disabilita i breadcrumbs.',
                    'title' => 'Generale',

                    'unit-options' => [
                        'info'        => 'Imposta le opzioni delle unità.',
                        'title'       => 'Opzioni Unità',
                        'title-info'  => 'Configura il peso in libbre (lbs) o chilogrammi (kgs).',
                        'weight-unit' => 'Unità di Peso',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Breadcrumbs Negozio',
                        'title'      => 'Breadcrumbs',
                        'title-info' => 'Abilita o disabilita la navigazione tramite breadcrumbs nel negozio.',
                    ],
                ],

                'content' => [
                    'info'  => 'Imposta il titolo dell\'offerta dell\'intestazione e gli script personalizzati.',
                    'title' => 'Contenuto',

                    'header-offer' => [
                        'title'             => 'Titolo Offerta Intestazione',
                        'title-info'        => 'Configura il titolo dell\'offerta dell\'intestazione con il titolo dell\'offerta, il titolo di reindirizzamento e il link di reindirizzamento.',
                        'offer-title'       => 'Titolo Offerta',
                        'redirection-title' => 'Titolo Reindirizzamento',
                        'redirection-link'  => 'Link Reindirizzamento',
                    ],

                    'speculation-rules' => [
                        'enable-speculation' => 'Abilita regole di speculazione',
                        'info'               => 'Configura le impostazioni per abilitare o disabilitare la logica di speculazione automatica.',
                        'title'              => 'Regole di speculazione',

                        'prerender' => [
                            'conservative'           => 'Conservativo',
                            'eager'                  => 'Fervente',
                            'eagerness'              => 'Livello di fervore del prerender',
                            'eagerness-info'         => 'Controlla quanto aggressivamente vengono applicate le regole di speculazione. Opzioni: fervente (massimo), moderato (predefinito), conservativo (basso).',
                            'enabled'                => 'Abilita regole di speculazione prerender',
                            'ignore-url-params'      => 'Ignora parametri URL prerender',
                            'ignore-url-params-info' => 'Specifica i parametri URL da ignorare nelle regole di speculazione. Usa la barra verticale (|) per separare più parametri.',
                            'ignore-urls'            => 'Ignora URL prerender',
                            'ignore-urls-info'       => 'Inserisci gli URL da escludere dalla logica di speculazione. Separa più URL con una barra verticale (|).',
                            'info'                   => 'Imposta lo stato delle regole di speculazione.',
                            'moderate'               => 'Moderato',
                        ],

                        'prefetch' => [
                            'conservative'           => 'Conservativo',
                            'eager'                  => 'Fervente',
                            'eagerness'              => 'Livello di fervore del prefetch',
                            'eagerness-info'         => 'Controlla quanto aggressivamente vengono applicate le regole di speculazione. Opzioni: fervente (massimo), moderato (predefinito), conservativo (basso).',
                            'enabled'                => 'Abilita regole di speculazione prefetch',
                            'ignore-url-params'      => 'Ignora parametri URL prefetch',
                            'ignore-url-params-info' => 'Specifica i parametri URL da ignorare nelle regole di speculazione. Usa la barra verticale (|) per separare più parametri.',
                            'ignore-urls'            => 'Ignora URL prefetch',
                            'ignore-urls-info'       => 'Inserisci gli URL da escludere dalla logica di speculazione. Separa più URL con una barra verticale (|).',
                            'info'                   => 'Imposta lo stato delle regole di speculazione.',
                            'moderate'               => 'Moderato',
                        ],
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'CSS Personalizzato',
                        'custom-javascript' => 'Javascript Personalizzato',
                        'title'             => 'Script Personalizzati',
                        'title-info'        => 'Gli script personalizzati sono pezzi di codice personalizzati creati per aggiungere funzioni o caratteristiche specifiche al software, migliorandone le capacità in modo unico.',
                    ],
                ],

                'design' => [
                    'info'  => 'Imposta il logo e l\'icona favicon per il pannello di amministrazione.',
                    'title' => 'Design',

                    'admin-logo' => [
                        'favicon'    => 'Favicon',
                        'logo-image' => 'Immagine Logo',
                        'title'      => 'Logo Admin',
                        'title-info' => 'Configura le immagini del logo e del favicon per il front-end del tuo sito web per un miglior branding e riconoscimento.',
                    ],

                    'menu-category' => [
                        'default'         => 'Menu predefinito',
                        'info'            => 'Questa impostazione controlla la visibilità delle categorie nel menu intestazione. Puoi scegliere di mostrare solo le categorie principali o tutte le categorie annidate.',
                        'preview-default' => 'Anteprima menu predefinito',
                        'preview-sidebar' => 'Anteprima menu laterale',
                        'sidebar'         => 'Menu laterale',
                        'title'           => 'Vista categoria menu',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Imposta le opzioni di Magic AI e consenti alcune opzioni per automatizzare la creazione di contenuti.',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'Chiave API',
                        'enabled'        => 'Abilitato',
                        'llm-api-domain' => 'Dominio API LLM',
                        'organization'   => 'Organizzazione',
                        'title'          => 'Impostazioni Generali',
                        'title-info'     => 'Migliora la tua esperienza con la funzione Magic AI inserendo la tua esclusiva chiave API e indicando l\'organizzazione pertinente per un\'integrazione senza sforzo. Prendi il controllo delle tue credenziali OpenAI e personalizza le impostazioni in base alle tue esigenze specifiche.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Prompt Descrizione Categoria',
                        'cms-page-content-prompt'          => 'Prompt Contenuto Pagina CMS',
                        'enabled'                          => 'Abilitato',
                        'product-description-prompt'       => 'Prompt Descrizione Prodotto',
                        'product-short-description-prompt' => 'Prompt Breve Descrizione Prodotto',
                        'title'                            => 'Generazione Contenuto',
                        'title-info'                       => 'Questa funzione abiliterà Magic AI per ogni editor WYSIWYG, dove si desidera gestire il contenuto utilizzando l\'AI.<br/><br/>Quando è abilitato, vai a qualsiasi editor per generare contenuto.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Abilitato',
                        'title'      => 'Generazione Immagine',
                        'title-info' => 'Questa funzione abiliterà Magic AI per ogni caricamento di immagini, dove si desidera generare immagini utilizzando DALL-E.<br/><br/>Quando è abilitato, vai a qualsiasi caricamento di immagini per generare immagini.',
                    ],

                    'review-translation' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Abilitato',
                        'gemini-1-5-flash'    => 'Gemini 1.5 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt-4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modello',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Traduzione Recensione',
                        'title-info'          => 'Fornisci l\'opzione al cliente o al visitatore di tradurre la recensione del cliente in inglese.<br/><br/>Quando abilitato, vai alla recensione e troverai il pulsante "Traduci in Inglese" se la recensione è in una lingua diversa dall\'inglese.',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],

                    'checkout-message' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Abilitato',
                        'gemini-1-5-flash'    => 'Gemini 1.5 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt 4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modello',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'prompt'              => 'Prompt',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Messaggio di Checkout Personalizzato',
                        'title-info'          => 'Crea un messaggio di checkout personalizzato per i clienti sulla pagina di ringraziamento, adattando il contenuto per risuonare con le preferenze individuali e migliorare l\'esperienza post-acquisto complessiva.',
                        'vicuna'              => 'Vicuna',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],
                ],

                'gdpr' => [
                    'title' => 'GDPR',
                    'info'  => 'Impostazioni di conformità GDPR',

                    'settings' => [
                        'title'   => 'Impostazioni di conformità GDPR',
                        'info'    => 'Gestisci le impostazioni di conformità GDPR, inclusa la politica sulla privacy. Abilita o disabilita le funzionalità GDPR secondo necessità.',
                        'enabled' => 'Abilita GDPR',
                    ],

                    'agreement' => [
                        'title'          => 'Accordo GDPR',
                        'info'           => 'Gestisci il consenso dei clienti in conformità con i regolamenti GDPR. Abilita il consenso obbligatorio per la raccolta e l\'elaborazione dei dati.',
                        'enable'         => 'Abilita il consenso del cliente',
                        'checkbox-label' => 'Etichetta della casella di controllo per il consenso',
                        'content'        => 'Contenuto del consenso',
                    ],

                    'cookie' => [
                        'bottom-left'  => 'In basso a sinistra',
                        'bottom-right' => 'In basso a destra',
                        'center'       => 'Centro',
                        'description'  => 'Descrizione',
                        'enable'       => 'Abilita notifica sui cookie',
                        'identifier'   => 'Identificatore del blocco statico',
                        'info'         => 'Imposta le impostazioni di consenso sui cookie per informare gli utenti sulla raccolta dei dati e rispettare la politica sulla privacy.',
                        'position'     => 'Posizione di visualizzazione del blocco dei cookie',
                        'title'        => 'Impostazioni di notifica sui cookie',
                        'top-left'     => 'In alto a sinistra',
                        'top-right'    => 'In alto a destra',
                    ],

                    'cookie-consent' => [
                        'title'                  => 'Gestisci le tue impostazioni sui cookie',
                        'info'                   => 'Controlla l\'uso dei dati selezionando le impostazioni dei cookie desiderate. Imposta le autorizzazioni per diversi tipi di cookie.',
                        'strictly-necessary'     => 'Strettamente necessari',
                        'basic-interaction'      => 'Interazione e funzionalità di base',
                        'experience-enhancement' => 'Miglioramento dell\'esperienza',
                        'measurement'            => 'Misurazione',
                        'targeting-advertising'  => 'Targeting e pubblicità',
                    ],
                ],

                'sitemap' => [
                    'info'  => 'Impostare le opzioni della mappa del sito.',
                    'title' => 'Mappa del Sito',

                    'settings' => [
                        'enabled' => 'Abilitato',
                        'info'    => 'Abilita o disabilita la mappa del sito per il tuo sito web per migliorare l\'ottimizzazione dei motori di ricerca e migliorare l\'esperienza dell\'utente.',
                        'title'   => 'Impostazioni',
                    ],

                    'file-limits' => [
                        'info'             => 'Impostare le opzioni dei limiti di file.',
                        'max-file-size'    => 'Dimensione massima del file',
                        'max-url-per-file' => 'Numero massimo di URL per file',
                        'title'            => 'Limiti dei File',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Catalogo',
                'title' => 'Catalogo',

                'products' => [
                    'info'  => 'Pagina di visualizzazione prodotto, pagina di visualizzazione carrello, vetrina, recensione e condivisione sociale degli attributi.',
                    'title' => 'Prodotti',

                    'settings' => [
                        'compare-options'     => 'Opzioni di confronto',
                        'image-search-option' => 'Opzione di ricerca per immagini',
                        'title'               => 'Impostazioni',
                        'title-info'          => 'Le impostazioni si riferiscono alle scelte configurabili che controllano il comportamento di un sistema, di un\'applicazione o di un dispositivo, adattate alle preferenze e ai requisiti dell\'utente.',
                        'wishlist-options'    => 'Opzioni della lista dei desideri',
                    ],

                    'search' => [
                        'admin-mode'            => 'Modalità di ricerca dell\'amministratore',
                        'admin-mode-info'       => 'La ricerca Mega, la griglia dati e altre funzionalità di ricerca nel pannello di amministrazione si baseranno sul motore di ricerca selezionato.',
                        'database'              => 'Database',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Lunghezza massima della query',
                        'max-query-length-info' => 'Imposta la lunghezza massima della query per le ricerche.',
                        'min-query-length'      => 'Lunghezza minima della query',
                        'min-query-length-info' => 'Imposta la lunghezza minima della query per le ricerche.',
                        'search-engine'         => 'Motore di ricerca',
                        'storefront-mode'       => 'Modalità di ricerca del front-end del negozio',
                        'storefront-mode-info'  => 'La funzionalità di ricerca nel front-end del negozio si baserà sul motore di ricerca selezionato, inclusa la pagina delle categorie, la pagina di ricerca e altre funzionalità di ricerca.',
                        'title'                 => 'Ricerca',
                        'title-info'            => 'Per impostare il motore di ricerca per le ricerche di prodotti, puoi scegliere tra un database ed Elasticsearch in base alle tue esigenze. Se hai un grande numero di prodotti, si consiglia Elasticsearch.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Consenti il checkout per gli ospiti',
                        'allow-guest-checkout-hint' => 'Suggerimento: se attivato, questa opzione può essere configurata per ogni prodotto specificamente.',
                        'title'                     => 'Checkout per gli ospiti',
                        'title-info'                => 'Il checkout per gli ospiti consente ai clienti di acquistare prodotti senza creare un account, semplificando il processo di acquisto per comodità e transazioni più veloci.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Numero consentito di prodotti correlati',
                        'allow-no-of-up-sells-products' => 'Numero consentito di prodotti Up-Sell',
                        'title'                         => 'Configurazione della pagina di visualizzazione del prodotto',
                        'title-info'                    => 'La configurazione della pagina di visualizzazione del prodotto comporta l\'adattamento del layout e degli elementi sulla pagina di visualizzazione di un prodotto, migliorando l\'esperienza dell\'utente e la presentazione delle informazioni.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Numero consentito di prodotti Cross-Sell',
                        'title'                            => 'Configurazione della pagina del carrello',
                        'title-info'                       => 'La configurazione della pagina del carrello comporta l\'organizzazione degli articoli, dei dettagli e delle opzioni sulla pagina del carrello, migliorando l\'interazione dell\'utente e il flusso di acquisto.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Consenti ai clienti di acquistare direttamente i prodotti',
                        'cheapest-first'         => 'Meno costosi prima',
                        'comma-separated'        => 'Separati da virgola',
                        'default-list-mode'      => 'Modalità di elenco predefinita',
                        'expensive-first'        => 'Più costosi prima',
                        'from-a-z'               => 'Da A-Z',
                        'from-z-a'               => 'Da Z-A',
                        'grid'                   => 'Griglia',
                        'latest-first'           => 'Più recenti prima',
                        'list'                   => 'Elenco',
                        'oldest-first'           => 'Più vecchi prima',
                        'products-per-page'      => 'Prodotti per pagina',
                        'sort-by'                => 'Ordina per',
                        'title'                  => 'Front-end del negozio',
                        'title-info'             => 'Il front-end del negozio è l\'interfaccia rivolta al cliente di un negozio online, che mostra prodotti, categorie e navigazione per un\'esperienza di acquisto senza interruzioni.',
                    ],

                    'small-image' => [
                        'height'      => 'Altezza',
                        'placeholder' => 'Segnaposto immagine piccola',
                        'title'       => 'Immagine piccola',
                        'title-info'  => 'Il front-end del negozio è l\'interfaccia rivolta al cliente di un negozio online, che mostra prodotti, categorie e navigazione per un\'esperienza di acquisto senza interruzioni.',
                        'width'       => 'Larghezza',
                    ],

                    'medium-image' => [
                        'height'      => 'Altezza',
                        'placeholder' => 'Segnaposto immagine media',
                        'title'       => 'Immagine media',
                        'title-info'  => 'L\'immagine media si riferisce a un\'immagine di dimensioni moderate che offre un equilibrio tra dettaglio e spazio sullo schermo, comunemente utilizzata per le immagini.',
                        'width'       => 'Larghezza',
                    ],

                    'large-image' => [
                        'height'      => 'Altezza',
                        'placeholder' => 'Segnaposto immagine grande',
                        'title'       => 'Immagine grande',
                        'title-info'  => 'L\'immagine grande rappresenta un\'immagine ad alta risoluzione che fornisce dettagli e impatto visivo migliorati, spesso utilizzata per mostrare prodotti o grafiche.',
                        'width'       => 'Larghezza',
                    ],

                    'review' => [
                        'allow-customer-review'   => 'Consenti recensioni dei clienti',
                        'allow-guest-review'      => 'Consenti recensioni degli ospiti',
                        'censoring-reviewer-name' => 'Censura Nome del Recensore',
                        'display-review-count'    => 'Visualizza il numero di revisioni per le valutazioni.',
                        'display-star-count'      => 'Visualizza il numero di stelle nelle valutazioni.',
                        'summary'                 => 'Riepilogo',
                        'title'                   => 'Recensione',
                        'title-info'              => 'Valutazione o valutazione di qualcosa, spesso coinvolgendo opinioni e feedback.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Dimensione massima di caricamento file (in Kb)',
                        'image-upload-size' => 'Dimensione massima di caricamento immagine (in Kb)',
                        'title'             => 'Attributo',
                        'title-info'        => 'Caratteristica o proprietà che definisce un oggetto, influenzandone il comportamento, l\'aspetto o la funzione.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Configura le impostazioni di condivisione sui social network per abilitare la condivisione dei prodotti su Instagram, Twitter, WhatsApp, Facebook, Pinterest, LinkedIn e tramite email.',
                        'title'                       => 'Condivisione sui social network',
                        'share-message'               => 'Messaggio di condivisione',
                        'share'                       => 'Condividi',
                        'enable-social-share'         => 'Abilita condivisione sui social network?',
                        'enable-share-whatsapp-info'  => 'Il link di condivisione di WhatsApp apparirà solo sui dispositivi mobili.',
                        'enable-share-whatsapp'       => 'Abilita condivisione su WhatsApp?',
                        'enable-share-twitter'        => 'Abilita condivisione su Twitter?',
                        'enable-share-pinterest'      => 'Abilita condivisione su Pinterest?',
                        'enable-share-linkedin'       => 'Abilita condivisione su LinkedIn?',
                        'enable-share-facebook'       => 'Abilita condivisione su Facebook?',
                        'enable-share-email'          => 'Abilita condivisione tramite e-mail?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Imposta prodotti e categorie.',
                    'title' => 'Snippet ricchi',

                    'products' => [
                        'enable'          => 'Abilita',
                        'show-categories' => 'Mostra categorie',
                        'show-images'     => 'Mostra immagini',
                        'show-offers'     => 'Mostra offerte',
                        'show-ratings'    => 'Mostra valutazioni',
                        'show-reviews'    => 'Mostra recensioni',
                        'show-sku'        => 'Mostra SKU',
                        'show-weight'     => 'Mostra peso',
                        'title'           => 'Prodotti',
                        'title-info'      => 'Configurare le impostazioni del prodotto inclusi SKU, peso, categorie, immagini, recensioni, valutazioni, offerte e altro.',
                    ],

                    'categories' => [
                        'enable'                  => 'Abilita',
                        'show-search-input-field' => 'Mostra campo di input di ricerca',
                        'title'                   => 'Categorie',
                        'title-info'              => '"Categorie" si riferiscono a gruppi o classificazioni che aiutano a organizzare e raggruppare prodotti o articoli simili insieme per una navigazione e una navigazione più semplici.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Inventario',
                    'title-info' => 'Configura le impostazioni dell\'inventario per consentire ordini arretrati e definire la soglia di esaurimento scorte.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Consenti ordini in sospeso',
                        'max-qty-allowed-in-cart' => 'Quantità massima consentita nel carrello',
                        'min-qty-allowed-in-cart' => 'Quantità minima consentita nel carrello',
                        'out-of-stock-threshold'  => 'Soglia di esaurimento delle scorte',
                        'title'                   => 'Opzione di stock del prodotto',
                        'info'                    => 'Configurare le opzioni di stock del prodotto per consentire ordini in sospeso, impostare quantità minime e massime nel carrello e definire soglie di esaurimento scorte.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Cliente',
                'title' => 'Cliente',

                'address' => [
                    'info'  => 'Imposta paese, stato, CAP e linee in un indirizzo di strada.',
                    'title' => 'Indirizzo',

                    'requirements' => [
                        'city'       => 'Città',
                        'country'    => 'Paese',
                        'state'      => 'Stato',
                        'title'      => 'Requisiti',
                        'title-info' => 'I requisiti sono le condizioni, le caratteristiche o le specifiche necessarie per soddisfare, raggiungere o soddisfare con successo qualcosa.',
                        'zip'        => 'CAP',
                    ],

                    'information' => [
                        'street-lines' => 'Linee in un indirizzo di strada',
                        'title'        => 'Informazioni',
                        'title-info'   => '"Linee in un indirizzo di strada" si riferiscono a segmenti individuali di un indirizzo, spesso separati da virgole, che forniscono informazioni sulla posizione come numero civico, via, città e altro ancora.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Imposta chiave del sito, chiave segreta e stato.',
                    'title' => 'Google Captcha',

                    'credentials' => [
                        'secret-key' => 'Chiave segreta',
                        'site-key'   => 'Chiave del sito',
                        'status'     => 'Stato',
                        'title'      => 'Credenziali',
                        'title-info' => '"Sitemap: mappa del layout del sito web per i motori di ricerca. Chiave segreta: codice sicuro per la crittografia dei dati, l\'autenticazione o la protezione dell\'accesso API."',
                    ],

                    'validations' => [
                        'captcha'  => 'Qualcosa è andato storto! Riprova.',
                        'required' => 'Seleziona CAPTCHA',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Imposta lista dei desideri, reindirizzamento login, iscrizioni alla newsletter, opzione gruppo predefinito, verifiche email e accesso tramite social network.',
                    'title'         => 'Impostazioni',

                    'login-as-customer' => [
                        'allow-option' => 'Consenti accesso come cliente',
                        'title'        => 'Accesso come cliente',
                        'title-info'   => 'Abilita la funzionalità "Accesso come cliente".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Consenti opzione lista dei desideri',
                        'title'        => 'Lista dei desideri',
                        'title-info'   => 'Abilita o disabilita l\'opzione lista dei desideri.',
                    ],

                    'login-options' => [
                        'account'          => 'Account',
                        'home'             => 'Home',
                        'redirect-to-page' => 'Reindirizza il cliente alla pagina selezionata',
                        'title'            => 'Opzioni di accesso',
                        'title-info'       => 'Configura le opzioni di accesso per determinare la pagina di reindirizzamento per i clienti dopo l\'accesso.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Consenti newsletter',
                        'news-letter-info' => 'Abilita l\'opzione di iscrizione alla newsletter nella pagina di registrazione.',
                        'title'            => 'Opzioni per la creazione di un nuovo account',
                        'title-info'       => 'Imposta le opzioni per i nuovi account, inclusa l\'assegnazione di un gruppo di clienti predefinito e l\'abilitazione dell\'opzione di iscrizione alla newsletter durante la registrazione.',

                        'default-group' => [
                            'general'    => 'Generale',
                            'guest'      => 'Ospite',
                            'title'      => 'Gruppo predefinito',
                            'title-info' => 'Assegna un gruppo di clienti specifico come predefinito per i nuovi clienti.',
                            'wholesale'  => 'All\'ingrosso',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Consenti iscrizione alla newsletter',
                        'title'        => 'Iscrizione alla newsletter',
                        'title-info'   => '"Informazioni sulla newsletter" contiene aggiornamenti, offerte o contenuti condivisi regolarmente tramite e-mail agli abbonati, tenendoli informati e coinvolti.',
                    ],

                    'email' => [
                        'email-verification' => 'Consenti verifica via email',
                        'title'              => 'Verifica via email',
                        'title-info'         => '"Verifica via email" conferma l\'autenticità di un indirizzo email, spesso inviando un link di conferma, migliorando la sicurezza dell\'account e l\'affidabilità della comunicazione.',
                    ],

                    'social-login' => [
                        'title' => 'Accesso Social',
                        'info'  => '"Accesso social" consente agli utenti di accedere a un sito web utilizzando i propri account social, semplificando i processi di registrazione e accesso.',

                        'google' => [
                            'enable-google' => 'Abilita Google',

                            'client-id' => [
                                'title'      => 'ID Client',
                                'title-info' => 'Identificatore univoco fornito da Google durante la creazione dell’applicazione OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client Secret',
                                'title-info' => 'Chiave segreta associata al tuo client OAuth di Google. Mantienila riservata.',
                            ],

                            'redirect' => [
                                'title'      => 'URL di reindirizzamento',
                                'title-info' => 'URL di callback a cui gli utenti vengono reindirizzati dopo l’autenticazione con Google. Deve corrispondere all’URL configurato nella tua console Google.',
                            ],
                        ],

                        'facebook' => [
                            'enable-facebook' => 'Abilita Facebook',

                            'client-id' => [
                                'title'      => 'ID Client',
                                'title-info' => 'ID app fornito da Facebook durante la creazione di un’app nella console per sviluppatori di Facebook.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client Secret',
                                'title-info' => 'Chiave segreta associata alla tua applicazione Facebook. Mantienila sicura e privata.',
                            ],

                            'redirect' => [
                                'title'      => 'URL di reindirizzamento',
                                'title-info' => 'URL di callback a cui gli utenti vengono reindirizzati dopo l’autenticazione con Facebook. Deve corrispondere all’URL configurato nelle impostazioni della tua app Facebook.',
                            ],
                        ],

                        'github' => [
                            'enable-github' => 'Abilita GitHub',

                            'client-id' => [
                                'title'      => 'ID Client',
                                'title-info' => 'Identificatore univoco fornito da GitHub durante la creazione dell’applicazione OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client Secret',
                                'title-info' => 'Chiave segreta associata al tuo client OAuth di GitHub. Mantienila riservata.',
                            ],

                            'redirect' => [
                                'title'      => 'URL di reindirizzamento',
                                'title-info' => 'URL di callback a cui gli utenti vengono reindirizzati dopo l’autenticazione con GitHub. Deve corrispondere all’URL configurato nella tua console GitHub.',
                            ],
                        ],

                        'linkedin' => [
                            'enable-linkedin' => 'Abilita LinkedIn',

                            'client-id' => [
                                'title'      => 'ID Client',
                                'title-info' => 'Identificatore univoco fornito da LinkedIn durante la creazione dell’applicazione OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client Secret',
                                'title-info' => 'Chiave segreta associata al tuo client OAuth di LinkedIn. Mantienila riservata.',
                            ],

                            'redirect' => [
                                'title'      => 'URL di reindirizzamento',
                                'title-info' => 'URL di callback a cui gli utenti vengono reindirizzati dopo l’autenticazione con LinkedIn. Deve corrispondere all’URL configurato nella tua console LinkedIn.',
                            ],
                        ],

                        'twitter' => [
                            'enable-twitter' => 'Abilita Twitter',

                            'client-id' => [
                                'title'      => 'ID Client',
                                'title-info' => 'Identificatore univoco fornito da Twitter durante la creazione dell’applicazione OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client Secret',
                                'title-info' => 'Chiave segreta associata al tuo client OAuth di Twitter. Mantienila riservata.',
                            ],

                            'redirect' => [
                                'title'      => 'URL di reindirizzamento',
                                'title-info' => 'URL di callback a cui gli utenti vengono reindirizzati dopo l’autenticazione con Twitter. Deve corrispondere all’URL configurato nella tua console Twitter.',
                            ],
                        ],
                    ],
                ],
            ],

            'email' => [
                'info'  => 'Email',
                'title' => 'Email',

                'email-settings' => [
                    'admin-email'           => 'Email amministratore',
                    'admin-email-tip'       => 'L\'indirizzo email dell\'amministratore di questo canale per ricevere email',
                    'admin-name'            => 'Nome amministratore',
                    'admin-name-tip'        => 'Questo nome verrà visualizzato in tutte le email dell\'amministratore',
                    'admin-page-limit'      => 'Elementi predefiniti per pagina (amministratore)',
                    'contact-email'         => 'Email di contatto',
                    'contact-email-tip'     => 'L\'indirizzo email verrà mostrato in fondo alle tue email',
                    'contact-name'          => 'Nome di contatto',
                    'contact-name-tip'      => 'Questo nome verrà mostrato in fondo alle tue email',
                    'email-sender-name'     => 'Nome mittente email',
                    'email-sender-name-tip' => 'Questo nome verrà visualizzato nella casella di posta del cliente',
                    'info'                  => 'Imposta il nome del mittente email, l\'indirizzo email del negozio, il nome dell\'amministratore e l\'indirizzo email dell\'amministratore.',
                    'shop-email-from'       => 'Indirizzo email del negozio',
                    'shop-email-from-tip'   => 'The email address of this channel to send emails to your customers',
                    'title'                 => 'Email Settings',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Invia una notifica al cliente dopo l\'annullamento di un ordine',
                    'cancel-order-mail-to-admin'                       => 'Invia una e-mail di notifica all\'amministratore dopo l\'annullamento di un ordine',
                    'customer'                                         => 'Invia al cliente le credenziali del suo account dopo la registrazione',
                    'customer-registration-confirmation-mail-to-admin' => 'Invia una e-mail di conferma all\'amministratore dopo la registrazione del cliente',
                    'info'                                             => 'Configura per ricevere e-mail per la verifica dell\'account, conferme di ordini, aggiornamenti su fatture, rimborsi, spedizioni e annullamenti di ordini.',
                    'new-inventory-source'                             => 'Invia una e-mail di notifica alla fonte di inventario dopo aver creato una spedizione',
                    'new-invoice'                                      => 'Invia una e-mail di notifica al cliente dopo aver creato una nuova fattura',
                    'new-invoice-mail-to-admin'                        => 'Invia una e-mail di notifica all\'amministratore dopo aver creato una nuova fattura',
                    'new-order'                                        => 'Invia una e-mail di conferma al cliente dopo aver effettuato un nuovo ordine',
                    'new-order-mail-to-admin'                          => 'Invia una e-mail di conferma all\'amministratore dopo aver effettuato un nuovo ordine',
                    'new-refund'                                       => 'Invia una e-mail di notifica al cliente dopo aver creato un rimborso',
                    'new-refund-mail-to-admin'                         => 'Invia una e-mail di notifica all\'amministratore dopo aver creato un nuovo rimborso',
                    'new-shipment'                                     => 'Invia una e-mail di notifica al cliente dopo aver creato una spedizione',
                    'new-shipment-mail-to-admin'                       => 'Invia una e-mail di notifica all\'amministratore dopo aver creato una nuova spedizione',
                    'registration'                                     => 'Invia una e-mail di conferma dopo la registrazione del cliente',
                    'title'                                            => 'Notifiche',
                    'verification'                                     => 'Invia una e-mail di verifica dopo la registrazione del cliente',
                ],
            ],

            'sales' => [
                'info'  => 'Vendite',
                'title' => 'Vendite',

                'shipping-setting' => [
                    'info'  => 'Configurare le impostazioni di spedizione, inclusi Paese, Stato, Città, Indirizzo, CAP, Nome del Negozio, Numero di Partita IVA, Numero di Contatto e Dettagli Bancari.',
                    'title' => 'Impostazioni di Spedizione',

                    'origin' => [
                        'bank-details'   => 'Dettagli Bancari',
                        'city'           => 'Città',
                        'contact-number' => 'Numero di Contatto',
                        'country'        => 'Paese',
                        'state'          => 'Stato',
                        'store-name'     => 'Nome del Negozio',
                        'street-address' => 'Indirizzo',
                        'title'          => 'Origine',
                        'title-info'     => "L'origine della spedizione si riferisce al luogo in cui i beni o i prodotti hanno origine prima di essere trasportati alla loro destinazione.",
                        'vat-number'     => 'Numero di Partita IVA',
                        'zip'            => 'CAP',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Configurare i metodi di spedizione, inclusa la Spedizione Gratuita, la Tariffa Fissa e altre opzioni se necessario.',
                    'title' => 'Metodi di Spedizione',

                    'free-shipping' => [
                        'description' => 'Descrizione',
                        'page-title'  => 'Spedizione Gratuita',
                        'status'      => 'Stato',
                        'title'       => 'Titolo',
                        'title-info'  => '"Spedizione gratuita" si riferisce a un metodo di spedizione in cui il costo della spedizione è annullato e il venditore copre le spese di spedizione per la consegna dei beni all\'acquirente.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Descrizione',
                        'page-title'  => 'Spedizione a Tariffa Fissa',
                        'rate'        => 'Tariffa',
                        'status'      => 'Stato',
                        'title'       => 'Titolo',
                        'title-info'  => 'La spedizione a tariffa fissa è un metodo di spedizione in cui viene addebitata una tariffa fissa per la spedizione, indipendentemente dal peso, dalle dimensioni o dalla distanza del pacchetto. Questo semplifica i costi di spedizione e può essere vantaggioso sia per acquirenti che venditori.',
                        'type'        => [
                            'per-order' => 'Per Ordine',
                            'per-unit'  => 'Per Unità',
                            'title'     => 'Tipo',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Valute Accettate',
                    'accepted-currencies-info'       => 'Aggiungi codice valuta separato da virgola, ad esempio USD, INR, ...',
                    'business-account'               => 'Account Aziendale',
                    'cash-on-delivery'               => 'Contrassegno',
                    'cash-on-delivery-info'          => 'Metodo di pagamento in cui i clienti pagano in contanti al momento della consegna dei beni o dei servizi a casa loro.',
                    'client-id'                      => 'ID Cliente',
                    'client-id-info'                 => 'Utilizzare "sb" per il test.',
                    'client-secret'                  => 'Segreto del Cliente',
                    'client-secret-info'             => 'Aggiungi qui la tua chiave segreta',
                    'description'                    => 'Descrizione',
                    'generate-invoice'               => 'Genera automaticamente la fattura dopo aver effettuato un ordine',
                    'generate-invoice-applicable'    => 'Applicabile se la generazione automatica della fattura è abilitata',
                    'info'                           => 'Imposta le informazioni sui metodi di pagamento',
                    'instructions'                   => 'Istruzioni',
                    'logo'                           => 'Logo',
                    'logo-information'               => 'La risoluzione dell\'immagine dovrebbe essere di 55px X 45px',
                    'mailing-address'                => 'Invia Assegno a',
                    'money-transfer'                 => 'Bonifico Bancario',
                    'money-transfer-info'            => 'Trasferimento di fondi da una persona o un conto a un\'altra, spesso in modo elettronico, per vari scopi come transazioni o invii di denaro.',
                    'page-title'                     => 'Metodi di Pagamento',
                    'paid'                           => 'Pagato',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'PayPal Smart Button: Semplifica i pagamenti online con pulsanti personalizzabili per transazioni sicure e multimediali su siti web e app.',
                    'paypal-standard'                => 'PayPal Standard',
                    'paypal-standard-info'           => 'PayPal Standard è una semplice opzione di pagamento PayPal per le attività online, che consente ai clienti di pagare utilizzando il proprio account PayPal o le carte di credito/debito.',
                    'pending'                        => 'In Attesa',
                    'pending-payment'                => 'Pagamento in Sospeso',
                    'processing'                     => 'In Elaborazione',
                    'sandbox'                        => 'Sandbox',
                    'set-invoice-status'             => 'Imposta lo stato della fattura dopo la creazione della fattura su',
                    'set-order-status'               => 'Imposta lo stato dell\'ordine dopo la creazione della fattura su',
                    'sort-order'                     => 'Ordine di Ordinamento',
                    'status'                         => 'Stato',
                    'title'                          => 'Titolo',
                ],

                'order-settings' => [
                    'info'               => 'Imposta numeri di ordine, ordini minimi e ordini in sospeso.',
                    'title'              => 'Impostazioni Ordine',

                    'order-number' => [
                        'generator'   => 'Generatore di Numero di Ordine',
                        'info'        => 'Identificatore univoco assegnato a un ordine specifico del cliente, che aiuta nel tracciamento, nella comunicazione e nel riferimento durante il processo di acquisto.',
                        'length'      => 'Lunghezza Numero di Ordine',
                        'prefix'      => 'Prefisso Numero di Ordine',
                        'suffix'      => 'Suffisso Numero di Ordine',
                        'title'       => 'Impostazioni Numero di Ordine',
                    ],

                    'minimum-order' => [
                        'description'             => 'Descrizione',
                        'enable'                  => 'Abilita',
                        'include-discount-amount' => 'Includi Importo Sconto',
                        'include-tax-amount'      => 'Includi Importo Tasse',
                        'info'                    => 'Criteri configurati che specificano la quantità o il valore minimo richiesto per elaborare un ordine o qualificarsi per vantaggi.',
                        'minimum-order-amount'    => 'Importo Minimo dell\'Ordine',
                        'title'                   => 'Impostazioni Ordine Minimo',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Riordino Admin',
                        'admin-reorder-info' => 'Abilita o disabilita la funzione di riordino per gli utenti amministratori.',
                        'info'               => 'Abilita o disabilita la funzione di riordino per gli utenti amministratori.',
                        'shop-reorder'       => 'Riordino Negozio',
                        'shop-reorder-info'  => 'Abilita o disabilita la funzione di riordino per gli utenti del negozio.',
                        'title'              => 'Consenti Riordino',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Consenti Ordini in Sospeso',
                        'info'              => 'Le opzioni di stock sono contratti di investimento che concedono il diritto di acquistare o vendere azioni di una società a un prezzo predeterminato, influenzando i potenziali profitti.',
                        'title'             => 'Opzioni Stock',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Imposta numero di fattura, termini di pagamento, design della scheda di fattura e promemoria di fatturazione.',
                    'title' => 'Impostazioni Fattura',

                    'invoice-number' => [
                        'generator'  => 'Generatore di Numero di Fattura',
                        'info'       => 'Configurazione di regole o parametri per la generazione e l\'assegnazione di numeri di identificazione univoci alle fatture per scopi organizzativi e di tracciamento.',
                        'length'     => 'Lunghezza Numero di Fattura',
                        'prefix'     => 'Prefisso Numero di Fattura',
                        'suffix'     => 'Suffisso Numero di Fattura',
                        'title'      => 'Impostazioni Numero di Fattura',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Durata Scadenza',
                        'due-duration-day'  => ':due-duration Giorno',
                        'due-duration-days' => ':due-duration Giorni',
                        'info'              => 'Condizioni concordate che stabiliscono quando e come il pagamento per beni o servizi deve essere effettuato dall\'acquirente al venditore.',
                        'title'             => 'Termini di Pagamento',
                    ],

                    'pdf-print-outs' => [
                        'footer-text'      => 'Testo del piè di pagina',
                        'footer-text-info' => 'Inserisci il testo che apparirà nel piè di pagina del PDF.',
                        'info'             => 'Configura le Stampe PDF per visualizzare l\'ID Fattura, l\'ID Ordine nell\'intestazione e includere il logo della fattura.',
                        'invoice-id-info'  => 'Configura la visualizzazione dell\'ID Fattura nell\'Intestazione della Fattura.',
                        'invoice-id-title' => 'Visualizza ID Fattura nell\'Intestazione',
                        'logo'             => 'Logo',
                        'logo-info'        => 'La risoluzione dell\'immagine dovrebbe essere di 131px X 30px.',
                        'order-id-info'    => 'Configura la visualizzazione dell\'ID Ordine nell\'Intestazione della Fattura.',
                        'order-id-title'   => 'Visualizza ID Ordine nell\'Intestazione',
                        'title'            => 'Stampa PDF',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Notifiche o comunicazioni automatizzate inviate ai clienti per ricordare loro i pagamenti imminenti o scaduti per le fatture.',
                        'interval-between-reminders' => 'Intervallo tra i promemoria',
                        'maximum-limit-of-reminders' => 'Limite massimo dei promemoria',
                        'title'                      => 'Promemoria Fattura',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Tasse',
                    'title-info' => 'Le tasse sono tariffe obbligatorie imposte dai governi su beni, servizi o transazioni, raccolte dai venditori e versate alle autorità.',

                    'categories' => [
                        'title'      => 'Categorie Fiscale',
                        'title-info' => 'Le categorie fiscali sono classificazioni per diversi tipi di tasse, come l\'imposta sulle vendite, l\'imposta sul valore aggiunto o l\'imposta di consumo, utilizzate per categorizzare e applicare aliquote fiscali a prodotti o servizi.',
                        'product'    => 'Categoria Fiscale Predefinita Prodotto',
                        'shipping'   => 'Categoria Fiscale Spedizione',
                        'none'       => 'Nessuna',
                    ],

                    'calculation' => [
                        'title'            => 'Impostazioni di Calcolo',
                        'title-info'       => 'Dettagli sul costo di beni o servizi, inclusi il prezzo base, gli sconti, le tasse e le spese aggiuntive.',
                        'based-on'         => 'Calcolo Basato Su',
                        'shipping-address' => 'Indirizzo di Spedizione',
                        'billing-address'  => 'Indirizzo di Fatturazione',
                        'shipping-origin'  => 'Origine Spedizione',
                        'product-prices'   => 'Prezzi Prodotto',
                        'shipping-prices'  => 'Prezzi Spedizione',
                        'excluding-tax'    => 'Esclusa Tassa',
                        'including-tax'    => 'Inclusa Tassa',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'Paese Predefinito',
                        'default-post-code' => 'CAP Predefinito',
                        'default-state'     => 'Stato Predefinito',
                        'title'             => 'Calcolo Destinazione Predefinita',
                        'title-info'        => 'Determinazione automatica di una destinazione standard o iniziale basata su fattori o impostazioni predefinite.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Impostazioni Visualizzazione Carrello',
                        'title-info'              => 'Imposta la visualizzazione delle tasse nel carrello',
                        'display-prices'          => 'Visualizza Prezzi',
                        'display-subtotal'        => 'Visualizza Subtotale',
                        'display-shipping-amount' => 'Visualizza Importo Spedizione',
                        'excluding-tax'           => 'Esclusa Tassa',
                        'including-tax'           => 'Inclusa Tassa',
                        'both'                    => 'Esclusa e Inclusa',
                    ],

                    'sales' => [
                        'title'                   => 'Impostazioni Visualizzazione Ordini, Fatture, Rimborsi',
                        'title-info'              => 'Imposta la visualizzazione delle tasse negli ordini, nelle fatture e nei rimborsi',
                        'display-prices'          => 'Visualizza Prezzi',
                        'display-subtotal'        => 'Visualizza Subtotale',
                        'display-shipping-amount' => 'Visualizza Importo Spedizione',
                        'excluding-tax'           => 'Esclusa Tassa',
                        'including-tax'           => 'Inclusa Tassa',
                        'both'                    => 'Esclusa e Inclusa',
                    ],
                ],

                'checkout' => [
                    'title' => 'Checkout',
                    'info'  => 'Imposta il checkout ospite, abilita o disabilita il mini carrello, riepilogo carrello',

                    'shopping-cart' => [
                        'cart-page'              => 'Pagina Carrello',
                        'cart-page-info'         => 'Controlla la visibilità della Pagina Carrello per migliorare l\'esperienza di acquisto degli utenti.',
                        'cross-sell'             => 'Vendita Incrociata Prodotti',
                        'cross-sell-info'        => 'Abilita la vendita incrociata dei prodotti per aumentare le opportunità di vendita aggiuntive.',
                        'estimate-shipping'      => 'Spedizione Stimata',
                        'estimate-shipping-info' => 'Abilita la spedizione stimata per fornire i costi di spedizione anticipati.',
                        'guest-checkout'         => 'Consenti checkout ospite',
                        'guest-checkout-info'    => 'Abilita il checkout ospite per un processo di acquisto più veloce e senza problemi.',
                        'info'                   => 'Abilita il checkout ospite, la pagina del carrello, la vendita incrociata dei prodotti e la spedizione stimata per migliorare la comodità degli utenti e semplificare il processo di acquisto per aumentare le vendite.',
                        'title'                  => 'Carrello',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Visualizza quantità degli articoli',
                        'display-number-in-cart'  => 'Visualizza numero di articoli nel carrello',
                        'info'                    => 'Abilita le impostazioni per il Mio Carrello per mostrare un riepilogo delle quantità degli articoli e visualizzare il numero totale di articoli nel carrello per un facile monitoraggio.',
                        'summary'                 => 'Riepilogo',
                        'title'                   => 'Mio Carrello',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Visualizza Mini Carrello',
                        'info'                 => 'Abilita le impostazioni del Mini Carrello per visualizzare il mini carrello e mostrare le informazioni sull\'offerta del Mini Carrello per un accesso rapido ai dettagli del carrello e alle promozioni.',
                        'mini-cart-offer-info' => 'Informazioni sull\'offerta del Mini Carrello',
                        'title'                => 'Mini Carrello',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Account',
                'app-version'   => 'Versione : :versione',
                'logout'        => 'Logout',
                'my-account'    => 'Il mio account',
                'notifications' => 'Notifiche',
                'visit-shop'    => 'Visita il Negozio',

                'mega-search' => [
                    'categories'                      => 'Categorie',
                    'customers'                       => 'Clienti',
                    'explore-all-categories'          => 'Esplora tutte le categorie',
                    'explore-all-customers'           => 'Esplora tutti i clienti',
                    'explore-all-matching-categories' => 'Esplora tutte le categorie corrispondenti a \":query\" (:count)',
                    'explore-all-matching-customers'  => 'Esplora tutti i clienti corrispondenti a \":query\" (:count)',
                    'explore-all-matching-orders'     => 'Esplora tutti gli ordini corrispondenti a \":query\" (:count)',
                    'explore-all-matching-products'   => 'Esplora tutti i prodotti corrispondenti a \":query\" (:count)',
                    'explore-all-orders'              => 'Esplora tutti gli ordini',
                    'explore-all-products'            => 'Esplora tutti i prodotti',
                    'orders'                          => 'Ordini',
                    'products'                        => 'Prodotti',
                    'sku'                             => 'SKU: :sku',
                    'title'                           => 'Ricerca Avanzata',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Famiglie di Attributi',
                'attributes'               => 'Attributi',
                'booking-product'          => 'Prenotazioni',
                'campaigns'                => 'Campagne',
                'catalog'                  => 'Catalogo',
                'categories'               => 'Categorie',
                'channels'                 => 'Canali',
                'cms'                      => 'CMS',
                'collapse'                 => 'Comprimi',
                'communications'           => 'Comunicazioni',
                'configure'                => 'Configura',
                'currencies'               => 'Valute',
                'customers'                => 'Clienti',
                'dashboard'                => 'Dashboard',
                'data-transfer'            => 'Trasferimento dati',
                'discount'                 => 'Sconto',
                'email-templates'          => 'Modelli di Email',
                'events'                   => 'Eventi',
                'exchange-rates'           => 'Tassi di Cambio',
                'gdpr-data-requests'       => 'Richieste di Dati GDPR',
                'groups'                   => 'Gruppi',
                'imports'                  => 'Importazioni',
                'inventory-sources'        => 'Fonti di Inventario',
                'invoices'                 => 'Fatture',
                'locales'                  => 'Localizzazioni',
                'marketing'                => 'Marketing',
                'mode'                     => 'Modalità Scura',
                'newsletter-subscriptions' => 'Abbonamenti alla Newsletter',
                'orders'                   => 'Ordini',
                'products'                 => 'Prodotti',
                'promotions'               => 'Promozioni',
                'refunds'                  => 'Rimborsi',
                'reporting'                => 'Report',
                'reviews'                  => 'Recensioni',
                'roles'                    => 'Ruoli',
                'sales'                    => 'Vendite',
                'search-seo'               => 'Ricerca e SEO',
                'search-synonyms'          => 'Sinonimi di Ricerca',
                'search-terms'             => 'Termini di Ricerca',
                'settings'                 => 'Impostazioni',
                'shipments'                => 'Spedizioni',
                'sitemaps'                 => 'Sitemap',
                'tax-categories'           => 'Categorie Fiscali',
                'tax-rates'                => 'Aliquote Fiscali',
                'taxes'                    => 'Tasse',
                'themes'                   => 'Temi',
                'transactions'             => 'Transazioni',
                'url-rewrites'             => 'Riscrittura URL',
                'users'                    => 'Utenti',
            ],

            'powered-by' => [
                'description' => 'Powered by :bagisto, un progetto open-source di :webkul.',
            ],
        ],

        'datagrid' => [
            'index' => [
                'no-records-selected'              => 'Nessun record selezionato.',
                'must-select-a-mass-action-option' => 'Devi selezionare un\'opzione per l\'azione di massa.',
                'must-select-a-mass-action'        => 'Devi selezionare un\'azione di massa.',
            ],

            'toolbar' => [
                'length-of' => ':length di',
                'of'        => 'di',
                'per-page'  => 'Per Pagina',
                'results'   => ':total Risultati',
                'selected'  => ':total Selezionati',

                'mass-actions' => [
                    'select-action' => 'Seleziona Azione',
                    'select-option' => 'Seleziona Opzione',
                    'submit'        => 'Invia',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Applica filtri',
                    'back-btn'          => 'Indietro',
                    'create-new-filter' => 'Crea nuovo filtro',
                    'custom-filters'    => 'Filtri personalizzati',
                    'delete-error'      => 'Si è verificato un errore durante l\'eliminazione del filtro, per favore riprova.',
                    'delete-success'    => 'Il filtro è stato eliminato con successo.',
                    'empty-description' => 'Non ci sono filtri selezionati disponibili per il salvataggio. Selezionare i filtri da salvare.',
                    'empty-title'       => 'Aggiungi filtri da salvare',
                    'name'              => 'Nome',
                    'quick-filters'     => 'Filtri rapidi',
                    'save-btn'          => 'Salva',
                    'save-filter'       => 'Salva filtro',
                    'saved-success'     => 'Il filtro è stato salvato con successo.',
                    'selected-filters'  => 'Filtri selezionati',
                    'title'             => 'Filtro',
                    'update'            => 'Aggiorna',
                    'update-filter'     => 'Aggiorna filtro',
                    'updated-success'   => 'Il filtro è stato aggiornato con successo.',
                ],

                'search' => [
                    'title' => 'Ricerca',
                ],
            ],

            'filters' => [
                'select' => 'Seleziona',
                'title'  => 'Filtri',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Digita almeno 2 caratteri...',
                        'no-results'        => 'Nessun risultato trovato...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Cancella Tutto',
                    'title'     => 'Filtri Personalizzati',
                ],

                'boolean-options' => [
                    'false' => 'Falso',
                    'true'  => 'Vero',
                ],

                'date-options' => [
                    'last-month'        => 'Ultimo Mese',
                    'last-six-months'   => 'Ultimi 6 Mesi',
                    'last-three-months' => 'Ultimi 3 Mesi',
                    'this-month'        => 'Questo Mese',
                    'this-week'         => 'Questa Settimana',
                    'this-year'         => 'Questo Anno',
                    'today'             => 'Oggi',
                    'yesterday'         => 'Ieri',
                ],
            ],

            'table' => [
                'actions'              => 'Azioni',
                'no-records-available' => 'Nessun Record Disponibile.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Concordo',
                'disagree-btn' => 'Non Concordo',
                'message'      => 'Sei sicuro di voler eseguire questa azione?',
                'title'        => 'Sei sicuro?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Aggiungi prodotto selezionato',
                'empty-info'    => 'Nessun prodotto disponibile per il termine di ricerca.',
                'empty-title'   => 'Nessun prodotto trovato',
                'product-image' => 'Immagine del prodotto',
                'qty'           => ':qty disponibile',
                'sku'           => 'SKU - :sku',
                'title'         => 'Seleziona i prodotti',
            ],
        ],

        'media' => [
            'images' => [
                'not-allowed-error' => 'Sono consentiti solo file immagine (.jpeg, .jpg, .png, ..).',
                'allowed-types'     => 'png, jpeg, jpg',
                'ai-btn-info'       => 'Genera Immagine',
                'ai-add-image-btn'  => 'Intelligenza Artificiale',
                'add-image-btn'     => 'Aggiungi Immagine',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Applica',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => 'Genera',
                    'generating'       => 'Generazione in corso...',
                    'hd'               => 'HD',
                    'model'            => 'Modello',
                    'number-of-images' => 'Numero di Immagini',
                    'prompt'           => 'Prompt',
                    'quality'          => 'Qualità',
                    'regenerate'       => 'Rigenera',
                    'regenerating'     => 'Rigenerazione in corso...',
                    'size'             => 'Dimensione',
                    'standard'         => 'Standard',
                    'title'            => 'Generazione Immagini con AI',
                ],

                'placeholders' => [
                    'front'     => 'Frontale',
                    'next'      => 'Successiva',
                    'size'      => 'Dimensione',
                    'use-cases' => 'Casi d\'Uso',
                    'zoom'      => 'Zoom',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Aggiungi Video',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Sono consentiti solo file video (.mp4, .mov, .ogg ..).',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Magia AI',

            'ai-generation' => [
                'apply'                    => 'Applica',
                'deepseek-r1-8b'           => 'DeepSeek R1 (8b)',
                'enabled'                  => 'Abilitato',
                'gemini-2-0-flash'         => 'Gemini 2.0 Flash',
                'generate'                 => 'Genera',
                'generated-content'        => 'Contenuto Generato',
                'generated-content-info'   => 'Il contenuto generato dall\'AI può essere fuorviante. Si prega di rivedere il contenuto generato prima di applicarlo.',
                'generating'               => 'Generazione in corso...',
                'gpt-4-turbo'              => 'OpenAI gpt-4 Turbo',
                'gpt-4o'                   => 'OpenAI gpt-4o',
                'gpt-4o-mini'              => 'OpenAI gpt-4o mini',
                'llama-groq'               => 'Llama 3.3 (Groq)',
                'llama3-1-8b'              => 'Llama 3.1 (8B)',
                'llama3-2-1b'              => 'Llama 3.2 (1B)',
                'llama3-2-3b'              => 'Llama 3.2 (3B)',
                'llama3-8b'                => 'Llama 3 (8B)',
                'llava-7b'                 => 'Llava (7b)',
                'mistral-7b'               => 'Mistral (7b)',
                'model'                    => 'Modello',
                'orca-mini'                => 'Orca Mini',
                'phi3-5'                   => 'Phi 3.5',
                'prompt'                   => 'Prompt',
                'qwen2-5-0-5b'             => 'Qwen 2.5 (0.5b)',
                'qwen2-5-1-5b'             => 'Qwen 2.5 (1.5b)',
                'qwen2-5-14b'              => 'Qwen 2.5 (14b)',
                'qwen2-5-3b'               => 'Qwen 2.5 (3b)',
                'qwen2-5-7b'               => 'Qwen 2.5 (7b)',
                'starling-lm-7b'           => 'Starling-lm (7b)',
                'title'                    => 'Assistenza AI',
                'vicuna-13b'               => 'Vicuna (13b)',
                'vicuna-7b'                => 'Vicuna (7b)',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Indirizzi',
        'attribute-families'       => 'Famiglie di Attributi',
        'attributes'               => 'Attributi',
        'campaigns'                => 'Campagne',
        'cancel'                   => 'Annulla',
        'cart-rules'               => 'Regole del Carrello',
        'catalog-rules'            => 'Regole del Catalogo',
        'catalog'                  => 'Catalogo',
        'categories'               => 'Categorie',
        'channels'                 => 'Canali',
        'cms'                      => 'CMS',
        'communications'           => 'Comunicazioni',
        'configure'                => 'Configura',
        'copy'                     => 'Copia',
        'create'                   => 'Creare',
        'currencies'               => 'Valute',
        'customers'                => 'Clienti',
        'dashboard'                => 'Dashboard',
        'data-transfer'            => 'Trasferimento dati',
        'delete'                   => 'Elimina',
        'edit'                     => 'Modifica',
        'email-templates'          => 'Modelli di Email',
        'events'                   => 'Eventi',
        'exchange-rates'           => 'Tassi di Cambio',
        'gdpr'                     => 'GDPR',
        'groups'                   => 'Gruppi',
        'import'                   => 'Importare',
        'imports'                  => 'Importazioni',
        'inventory-sources'        => 'Fonti di Inventario',
        'invoices'                 => 'Fatture',
        'locales'                  => 'Localizzazioni',
        'marketing'                => 'Marketing',
        'newsletter-subscriptions' => 'Abbonamenti alla Newsletter',
        'note'                     => 'Nota',
        'orders'                   => 'Ordini',
        'products'                 => 'Prodotti',
        'promotions'               => 'Promozioni',
        'refunds'                  => 'Rimborsi',
        'reporting'                => 'Report',
        'reviews'                  => 'Recensioni',
        'roles'                    => 'Ruoli',
        'sales'                    => 'Vendite',
        'search-seo'               => 'Ricerca & SEO',
        'search-synonyms'          => 'Sinonimi di Ricerca',
        'search-terms'             => 'Termini di Ricerca',
        'settings'                 => 'Impostazioni',
        'shipments'                => 'Spedizioni',
        'sitemaps'                 => 'Sitemap',
        'subscribers'              => 'Abbonati alla Newsletter',
        'tax-categories'           => 'Categorie Fiscali',
        'tax-rates'                => 'Aliquote Fiscali',
        'taxes'                    => 'Tasse',
        'themes'                   => 'Temi',
        'transactions'             => 'Transazioni',
        'url-rewrites'             => 'Riscritture URL',
        'users'                    => 'Utenti',
        'view'                     => 'Vedi',
    ],

    'errors' => [
        'dashboard' => 'Dashboard',
        'go-back'   => 'Torna Indietro',
        'support'   => 'Se il problema persiste, contattaci su <a href=":link" class=":class">:email</a> per assistenza.',

        '404' => [
            'description' => 'Ops! La pagina che stai cercando è in vacanza. Sembra che non riusciamo a trovare quello che stavi cercando.',
            'title'       => '404 Pagina Non Trovata',
        ],

        '401' => [
            'description' => 'Ops! Sembra che tu non abbia il permesso di accedere a questa pagina. Pare che ti manchino le credenziali necessarie.',
            'title'       => '401 Non Autorizzato',
        ],

        '403' => [
            'description' => 'Ops! Questa pagina è fuori limiti. Sembra che tu non abbia le autorizzazioni necessarie per visualizzare questo contenuto.',
            'title'       => '403 Accesso Vietato',
        ],

        '500' => [
            'description' => 'Ops! Qualcosa è andato storto. Sembra che abbiamo problemi a caricare la pagina che stai cercando.',
            'title'       => '500 Errore Interno del Server',
        ],

        '503' => [
            'description' => 'Ops! Sembra che siamo temporaneamente fuori servizio per manutenzione. Riprova tra un po\'.',
            'title'       => '503 Servizio Non Disponibile',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Scarica',
        'export'     => 'Esporta',
        'no-records' => 'Niente da esportare',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Questo slug è utilizzato in categorie o prodotti.',
        'slug-reserved'   => 'Questo slug è riservato.',
    ],

    'footer' => [
        'copy-right' => 'Realizzato da <a href="https://bagisto.com/" target="_blank">Bagisto</a>, un progetto della community di <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Caro :admin_name',
        'thanks' => 'Se hai bisogno di aiuto, contattaci all\'indirizzo <a href=":link" style=":style">:email</a>.<br/>Grazie!',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Stai ricevendo questa email perché abbiamo ricevuto una richiesta di reset della password per il tuo account.',
                'greeting'       => 'Password dimenticata!',
                'reset-password' => 'Resetta Password',
                'subject'        => 'Email di Reset della Password',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'Un nuovo account cliente è stato creato con successo. Ora possono accedere utilizzando il proprio indirizzo e-mail e le credenziali della password. Una volta effettuato l`accesso, avranno accesso a vari servizi, inclusa la possibilità di rivedere gli ordini passati, gestire le liste dei desideri e aggiornare le informazioni del proprio account.',
                'greeting'    => 'Diamo un caloroso benvenuto al nuovo cliente, :customer_name che si è appena registrato con noi!',
                'subject'     => 'Nuova registrazione cliente',
            ],

            'gdpr' => [
                'new-delete-request' => 'Nuova richiesta per eliminare dati',
                'new-update-request' => 'Nuova richiesta per aggiornare dati',

                'new-request' => [
                    'customer-name'  => 'Nome del cliente : ',
                    'update-summary' => 'Riepilogo della richiesta di aggiornamento',
                    'delete-summary' => 'Riepilogo della richiesta di eliminazione',
                    'message'        => 'Messaggio : ',
                    'request-status' => 'Stato della richiesta : ',
                    'request-type'   => 'Tipo di richiesta : ',
                ],

                'status-update' => [
                    'subject'        => 'La richiesta GDPR è stata aggiornata',
                    'summary'        => 'Lo stato della richiesta GDPR è stato aggiornato',
                    'request-status' => 'Stato della richiesta:',
                    'request-type'   => 'Tipo di richiesta:',
                    'message'        => 'Messaggio:',
                ],
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Hai un nuovo ordine :order_id effettuato il :created_at',
                'subject'  => 'Nuova Conferma Ordine',
                'summary'  => 'Riepilogo dell\'Ordine',
                'title'    => 'Conferma Ordine!',
            ],

            'invoiced' => [
                'subject'  => 'Nuova Conferma Fattura',
                'title'    => 'Conferma Fattura!',
                'greeting' => 'La tua fattura #:invoice_id per l\'ordine :order_id è stata creata il :created_at',
                'summary'  => 'Riepilogo della Fattura',
            ],

            'shipped' => [
                'greeting' => 'Hai spedito l\'ordine :order_id effettuato il :created_at',
                'subject'  => 'Nuova Conferma Spedizione',
                'summary'  => 'Riepilogo della Spedizione',
                'title'    => 'Ordine Spedito!',
            ],

            'inventory-source' => [
                'greeting' => 'Hai spedito l\'ordine :order_id effettuato il :created_at',
                'subject'  => 'Nuova Conferma Spedizione',
                'summary'  => 'Riepilogo della Spedizione',
                'title'    => 'Ordine Spedito!',
            ],

            'refunded' => [
                'greeting' => 'Hai effettuato il rimborso per l\'ordine :order_id effettuato il :created_at',
                'subject'  => 'Nuova Conferma Rimborso',
                'summary'  => 'Riepilogo del Rimborso',
                'title'    => 'Ordine Rimborsato!',
            ],

            'canceled' => [
                'greeting' => 'Hai annullato l\'ordine :order_id effettuato il :created_at',
                'subject'  => 'Nuova Conferma Annullamento Ordine',
                'summary'  => 'Riepilogo dell\'Ordine',
                'title'    => 'Ordine Annullato!',
            ],

            'billing-address'            => 'Indirizzo di Fatturazione',
            'carrier'                    => 'Corriere',
            'contact'                    => 'Contatto',
            'discount'                   => 'Sconto',
            'excl-tax'                   => 'Escl. Tasse: ',
            'grand-total'                => 'Totale',
            'name'                       => 'Nome',
            'payment'                    => 'Pagamento',
            'price'                      => 'Prezzo',
            'qty'                        => 'Quantità',
            'shipping-address'           => 'Indirizzo di Spedizione',
            'shipping-handling-excl-tax' => 'Spedizione (Escl. Tasse)',
            'shipping-handling-incl-tax' => 'Spedizione (Incl. Tasse)',
            'shipping-handling'          => 'Spedizione',
            'shipping'                   => 'Spedizione',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Subtotale (Escl. Tasse)',
            'subtotal-incl-tax'          => 'Subtotale (Incl. Tasse)',
            'subtotal'                   => 'Subtotale',
            'tax'                        => 'Tasse',
            'tracking-number'            => 'Numero di Tracciamento: :tracking_number',
        ],
    ],
];
