<?php
/**
 * Name:            Unzip Script For Zip Archives
 * Version:         2.20
 * Author:          Viktor Vogel =>
 * Website:         https://joomla-extensions.kubik-rubik.de
 * Download old:    https://joomla-extensions.kubik-rubik.de/downloads/php-scripts-php-skripte/unzip-script-for-zip-archives
 * Download:        https://wiki.websitebaker.org/doku.php/en/downloads
 * License:         GPLv3
 * Description:     With this script you can unzip zip archives. This file and the archive are deleted automatically after the unzip process!
 * @link            https://websitebaker.org/
 * @license         https://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.13.x
 * @requirements    PHP 7.4 and higher
 * @download Repro  https://addon.websitebaker.org/pages/en/browse-add-ons.php?id=04D6D0F4
 * @downlaod Wiki   https://wiki.websitebaker.org/doku.php/en/downloads
 */


if (version_compare(\PHP_VERSION , '8.0.0', '<')) {
   header('Content-Type: text/html');
?><!DOCTYPE HTML>
<html lang="en" dir="ltr">
  <head>
    <title>Wrong PHP Version</title>
  </head>
  <body style="text-align:center;">
    <h3>Date:<?= "\t". date('Y-m-d H:m A')."\n" ?></h3>
    <h2 style="color: red;">You have a outdated version of PHP (<?= PHP_VERSION ;?>)</h2>
    <p style="font-size: 24px;">Please contact your Provider for update to min 8.0.0  and higher</p>
  </body>
</html>
<?php
exit;
}

// Settings - START ---------------------------------------------------
    $isWindows = (\strcasecmp(\substr(PHP_OS, 0, 3), 'WIN') === 0);
    $defaults = [
        'empty_folder'    => true,
        'empty_files'     => true,
        'delete_archive'  => true,
        'delete_unzip'    => true,
        'debug_mode'      => false,
        'bChmodMode'      => false,
        'var_dump'        => false,
        'start_unzip'     => 0,
        'aFiles'          => [],
    ];

    $args = [
        'empty_folder'   => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            ],
        'empty_files'    => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            ],
        'delete_archive' => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            ],
        'delete_unzip'   => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            ],
        'debug_mode'     => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            ],
        'var_dump'       => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            ],
        'aFile'         => [
                            'filter'   => \FILTER_SANITIZE_FULL_SPECIAL_CHARS,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            'options'  => ''
                           ],
        'can_log'      => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            'options'  => ''
                            ],
        'bChmodMode'  => [
                            'filter'   => \FILTER_VALIDATE_BOOLEAN,
                            'flags'    => \FILTER_REQUIRE_SCALAR,
                            'options'  => ''
                            ],
    ];
    $sHideVarDump = 'w3-hide';
    $aInputs       = \filter_input_array(\INPUT_POST, $args);
    $bStartUnzip   = (isset($aInputs['start_unzip']) ? $aInputs['start_unzip'] : true);
    $sZipPattern   = '*.zip';
//    $aZipFiles = \glob($sZipPattern,\GLOB_NOSORT);
// set REQUESTS to vars -----------------------------------------------
    $sLogFile =  (isset($aInputs['sLogFile']) ? $aInputs['sLogFile'] : '');
// Unzip empty folders? true - yes, false - no
    $bUnzipEmptyFolders =  ($aInputs['empty_folder'] ?? true);
// Unzip empty files? true - yes, false - no
    $bUnzipEmptyFiles   =  ($aInputs['empty_files'] ?? true);
// set REQUESTS Variable for the output -------------------------------
    $output = '';
// delete files after finish,  prevent by reset
    $bDeleteArchive     = ($aInputs['delete_archive'] ?? false);
    $bDeleteUnzip       = ($aInputs['delete_unzip'] ?? false);
    $bDebugMode         = ($aInputs['debug_mode'] ?? false);
    $bChmodMode         = ($aInputs['chmod_mode'] ?? false);
    $bVarDump           = ($aInputs['var_dump'] ?? false);
    $bCanLog            = ($aInputs['can_log'] ?? false);
    $sArchiveFiles      = ($bDebugMode ? [] : ($aInputs['aFile'] ?? ''));
// Settings - END -----------------------------------------------------
    $sChecked           = ' checked="checked"';
    $sUnzipCheckFolders = ($bUnzipEmptyFolders ? $sChecked : '');
    $sUnzipCheckFiles   = ($bUnzipEmptyFiles ? $sChecked : '');
    $sCheckArchive      = ($bDeleteArchive ? $sChecked : '');
    $sCheckUnzip        = ($bDeleteUnzip ? $sChecked : '');
    $sCheckDebug        = ($bDebugMode ? $sChecked : '');
    $sCheckVarDump      = ($bVarDump ? $sChecked : '');
    $sCheckCanLog       = ($bCanLog ? $sChecked : '');

    $iStartTime   = \microtime(true);
    $sTimeStamp   = \gmdate('Ymd_His', \time());
    $sStartTime   = \sprintf('Start unzip at %s ',\gmdate('Y-m-d - H:i:s', \time())).\PHP_EOL;

// create absolute/relative paths -------------------------------------
    $sAddonName     = \basename(__DIR__);
    $sScriptName    = str_replace('\\','/',realpath($_SERVER["SCRIPT_FILENAME"]));
    $sScriptPath    = dirname($sScriptName);
    $sAppDir        = str_replace('\\', '/',__DIR__);
    $sDocRoot       = str_replace('\\','/',realpath($_SERVER["DOCUMENT_ROOT"]));
    $iSharedHosting = ($isWindows ? 0 : (strcmp(md5($sScriptPath),md5($sAppDir))));
    $sPathPattern   = "/^(.*?\/)admin\/.*$/";
    $sLink      = \str_replace('\\','/',__DIR__).'/admin/';
    $sAppRel    = \str_replace($sDocRoot,'',\dirname($sScriptName));
    $sAppRel    = rtrim((empty($sAppRel) ? '/' : $sAppRel),'/').'/';
    $sAcpRel    = $sAppRel.'admin/';
    $sLoginRel  = $sAppRel.'admin/login/index.php';
    $sAppPath   = \preg_replace ($sPathPattern, "$1", $sLink, 1 );
    $sLogPath   = $sAppPath.'var/log/';
    $sLogFile   = (empty($sLogFile) ? 'unzip_'.$sTimeStamp.'.log' : $sLogFile);
    $sLogRel    = $sAppRel.'var/log/';
    $sOldPath   = \str_replace('\\','/',\getcwd()).'/';
    $aOptions = [
      'DOCUMENT_ROOT'   => $_SERVER["DOCUMENT_ROOT"],
      'SCRIPT_FILENAME' => $_SERVER["SCRIPT_FILENAME"],
      'ScriptName'      => $sScriptName,
      'DocRoot'         => $sDocRoot,
      'SCRIPT_PATH'     => $sScriptPath,
      'AppDir'          => $sAppDir,
      'OctalDirMode'    => (int) \octdec('0755'),
      'OctalFileMode'   => (int) \octdec('0644'),
      'isWindows'       => $isWindows,//($isWindows ? 'true' : 'false'),
      'SharedHosting'   => (int)$iSharedHosting,
      'AppPath'         => $sAppPath,
      'LogPath'         => $sLogPath,
      'LogFile'         => $sLogFile,
      'AppRel'          => $sAppRel,
      'LogRel'          => $sLogRel,
      'bCanLog'         => $bCanLog,
      'ArchiveFile'     => $sArchiveFiles,
      'bDeleteArchive'  => $bDeleteArchive,
      'bDeleteUnzip'    => $bDeleteUnzip,
      'bChmodMode'      => $bChmodMode,
      'Memory_Limit'    => ini_get('memory_limit'),
      'MaxExecutionTime'=> ini_get('max_execution_time'),

    ];

    if ($bStartUnzip===true){
//      first try to create LogFilesPath
        $oZip = new Zipper($aOptions);
        $oZip->increaseMemory('512M',600);
        if (($bCanLog===true) && ($oZip->createPath($sLogPath)===false))
        {
            $sContent = sprintf('Can\'t create Logfile in %s ',$sLogRel);
            $sRetval .=  \sprintf('<li class="w3-text-red w3-large"></li>'.PHP_EOL,$sContent);
            file_put_contents($sLogPath.$sLogFile,$sContent, \FILE_APPEND);
        }
        elseif (($bCanLog===true))
        {
            $sContent = ''
                  . 'created: ['.\date('r').']'.PHP_EOL;
            //$sContent = '/**/';
            file_put_contents($sLogPath.$sLogFile,$sContent);
            unset ($sContent);
        }
// extract archive files
        $output .= $oZip->ExtractArchive($bUnzipEmptyFolders, $bUnzipEmptyFiles);
        //$oZip->deleteArchiveFile($bDeleteArchive);
        if (!empty($aInputs) && \is_array($aInputs) && count($aInputs)){
            //$output .= $oZip->deleteArchiveFile($bDeleteArchive);
            //$output .= $oZip->deleteUnzip($bDeleteUnzip);
        }
        //$oZip->resetMaxExecutionTime();
    }

    $iRuningTime = (\microtime(true) - $iStartTime);
    $sExecutionTime = \sprintf('Execution time %.3f sec', $iRuningTime).\PHP_EOL;
    $sEndTime = \sprintf('End unzip at %s ',\gmdate('Y-m-d - H:i:s', \time())).\PHP_EOL;
// ------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------
?><!DOCTYPE HTML>
<html lang="en">
    <head>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta charset="utf-8" />
        <meta name="referrer" content="no-referrer|same-origin"/>
        <title>Unzip Script For Zip Archives</title>
        <meta name="author" content="WebsiteBaker Org e.V." />
<!-- Mobile viewport optimisation -->
        <meta name="viewport" content="width=device-width, minimum-scale=1, maximum-scale=2" />
<style>
html { height:100%; }
body { min-height:101%; }
/*-------------------------------------------------------------------------------
the needed w3css styles only
-------------------------------------------------------------------------------*/
/* W3.CSS 4.15 December 2020 by Jan Egil and Borge Refsnes */
html{box-sizing:border-box}*,*:before,*:after{box-sizing:inherit}
/* Extract from normalize.css by Nicolas Gallagher and Jonathan Neal git.io/normalize */
html{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}body{margin:0}
footer,header,main{display:block}
a{background-color:transparent}a:active,a:hover{outline-width:0}
b{font-weight:bolder}
button,input,select{font:inherit;margin:0}
button,input{overflow:visible}button,select{text-transform:none}
button,[type=reset],[type=submit]{-webkit-appearance:button}
button::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner{border-style:none;padding:0}
button:-moz-focusring,[type=reset]:-moz-focusring,[type=submit]:-moz-focusring{outline:1px dotted ButtonText}
[type=checkbox]{padding:0}
::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}
/* End extract */
html,body{font-family:Verdana,sans-serif;font-size:15px;line-height:1.5}html{overflow-x:hidden}h2{font-size:30px}h3{font-size:24px}
h2,h3{font-family:"Segoe UI",Arial,sans-serif;font-weight:400;margin:10px 0}a{color:inherit}
.w3-btn{border:none;display:inline-block;padding:8px 16px;vertical-align:middle;overflow:hidden;text-decoration:none;color:inherit;background-color:inherit;text-align:center;cursor:pointer;white-space:nowrap}
.w3-btn:hover{box-shadow:0 8px 16px 0 rgba(0,0,0,0.2),0 6px 20px 0 rgba(0,0,0,0.19)}
.w3-btn{-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}   
.w3-btn:disabled{cursor:not-allowed;opacity:0.3}:disabled *{pointer-events:none}
.w3-btn:disabled:hover{box-shadow:none}
.w3-ul{list-style-type:none;padding:0;margin:0}
.w3-input{padding:8px;display:block;border:none;border-bottom:1px solid #ccc;width:100%}
.w3-select{padding:9px 0;width:100%;border:none;border-bottom:1px solid #ccc}
.w3-check{width:24px;height:24px;position:relative;top:6px}
.w3-container:after,.w3-container:before,.w3-row:after,.w3-row:before,.w3-row-padding:after,.w3-row-padding:before,.w3-cell-row:before,.w3-cell-row:after{content:"";display:table;clear:both}
.w3-half,.w3-twothird,.w3-quarter{float:left;width:100%}
@media (min-width:601px){.w3-quarter{width:24.99999%}.w3-half{width:49.99999%}.w3-twothird{width:66.66666%}}.w3-stretch{margin-left:-16px;margin-right:-16px}
.w3-cell-row{display:table;width:100%}.w3-cell{display:table-cell}
.w3-hide{display:none!important}
.w3-row-padding,.w3-row-padding>.w3-half{padding:0 8px}
.w3-container{padding:0.01em 16px}
.w3-card{box-shadow:0 2px 5px 0 rgba(0,0,0,0.16),0 2px 10px 0 rgba(0,0,0,0.12)}
.w3-card-4{box-shadow:0 8px 16px 0 rgba(0,0,0,0.2),0 8px 20px 0 rgba(55,116,150,0.19)}.w3-large{font-size:18px!important}
.w3-xlarge{font-size:24px!important}.w3-border{border:1px solid #ccc!important}
.w3-section{margin-top:16px!important;margin-bottom:16px!important}
.w3-margin{margin:16px!important}.w3-margin-top{margin-top:16px!important}.w3-margin-bottom{margin-bottom:16px!important}
.w3-margin-left{margin-left:16px!important}.w3-padding{padding:8px 16px!important}.w3-right{float:right!important}
/* Colors */

.w3-light-blue{color:#000!important;background-color:#87CEEB!important}
.w3-hover-green:hover{color:#fff!important;background-color:#4CAF50!important}
.w3-hover-red:hover{color:#fff!important;background-color:#f44336!important}
.w3-sand{color:#000!important;background-color:#fdf5e6!important}
.w3-white{color:#000!important;background-color:#fff!important}
.w3-text-teal{color:#009688!important}
.w3-text-white{color:#fff!important}
.w3-text-gray{color:#757575!important}

input[type="checkbox"].w3-check, input[type="radio"].w3-radio {-webkit-appearance: none;-moz-appearance: none!important;appearance: none;}
input[type="checkbox"].w3-check, input[type="radio"].w3-radio {width: 24px !important;height: 24px !important;position: relative !important;top: 8px !important;background-color: #0404A9 !important;}
input[type="checkbox"].w3-check:not(:checked), input[type="radio"].w3-radio:not(:checked) {background-color: #D6D6D6 !important;z-index: 1!important;}
input[type="checkbox"].w3-check:checked + .w3-validate, input.w3-radio[type="radio"]:checked + .w3-validate {color: #3D73A8 !important;font-weight: bold !important;}
input[type="checkbox"].w3-check:checked {border: 2px #0404A9 !important;color: #0404A9 !important;}
input[type="checkbox"].w3-check {z-index: -9999 !important;}
input[type="checkbox"].w3-check + label::before {content: "\00a0" !important;display: inline-block !important;font: 12px/1.15em sans-serif !important;font-weight: bold;}
input[type="checkbox"].w3-check + label::before {border: 1px solid #959595 !important;border-radius: 0px !important;height: 24px !important;width: 24px !important;margin: 0 .5em 0 -2.5em !important;padding: 0 !important;padding: 4px !important;}
input[type="checkbox"].w3-check:checked + label::before {background: #217DA1 !important;color: #fff !important;content: "\2713" !important;text-align: center !important;border-color: #217DA1 !important;}
label, label.w3-validate {font-weight: bold !important;color: #959595;}
input[type="checkbox"].w3-check + label > span::after{content: "";}
input[type="checkbox"].w3-check:checked + label > span::after{content: "";}

.w3-select-stripped option {min-height: 24px;}
.w3-select-stripped option:hover {background-color: #FBFBE3!important;}
.w3-select-stripped option:nth-child(2n){background-color: #EAEAEA;}

.progress-bar-striped {
                overflow: hidden;
                height: 40px;
                margin-bottom: 20px;
                background-color: #f5f5f5;
                border-radius: 4px;
                -webkit-box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);
                -moz-box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);
                box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);
            }
            .progress-bar-striped > div {
                background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);
                background-size: 40px 40px;
                float: left;
                width: 0%;
                height: 100%;
                font-size: 12px;
                line-height: 2.1;
                color: #ffffff;
                text-align: center;
                -webkit-box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.15);
                -moz-box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.15);
                box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.15);
                -webkit-transition: width 3s ease;
                -moz-transition: width 3s ease;
                -o-transition: width 3s ease;
                transition: width 3s ease;
                animation: progress-bar-stripes 2s linear infinite;
                background-color: #288ade;
            }
            .progress-bar-striped p{
                margin: 0;
            }

            @keyframes progress-bar-stripes {
                0% {
                    background-position: 40px 0;
                }
                100% {
                    background-position: 0 0;
                }
            }

/*-------------------------------------------------------------------------------*/
</style>
    </head>
    <body class="" style="background: #deecf3;">
      <main class="w3-margin-bottom" style="margin-top:30px;">
          <div class="w3-white w3-container w3-card-4 w3-margin w3-border" style="width:80%;margin: auto auto!important;padding: 0!important;">
              <div class="w3-row w3-card-4 ">
                <header class="w3-cell-row w3-padding" style="height: 30px;color:#fff !important; background-color:#215a7a !important">
                  <div class="w3-cell"></div>
                  <div class="w3-container w3-cell" style="left: 300px;position: relative;">
                  <span></span> <?= $sStartTime; ?><br /> </span>
                  <span> unzip to <?= $sAppRel;?></span>
                  </div>
                </header>
<svg version="1.1" id="Ebene_1" xmlns:serif="http://www.serif.com/"
     xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="268" height="144"
     viewBox="0 0 612 180" xml:space="preserve" style="top:0px;position: absolute;">

<g>
    <g id="websiteBaker_x2B_tag">
        <g>
            <path fill="#003366" d="M149.57,100.756c0,5.35-4.176,9.555-9.58,9.555c-5.597,0-9.608-4.395-9.608-9.473
                c0-5.434,4.204-9.637,9.444-9.637C145.366,91.202,149.57,95.324,149.57,100.756z M132.291,100.838
                c0,4.477,3.548,7.697,7.643,7.697c4.259,0,7.727-3.248,7.727-7.807c0-4.613-3.687-7.754-7.727-7.754
                C135.948,92.977,132.291,96.17,132.291,100.838z"/>
            <path fill="#003366" d="M154.674,98.846c1.338-1.885,3.194-2.813,5.351-2.813c3.932,0,6.961,3.221,6.961,7.043
                c0,3.82-2.976,7.098-6.905,7.098c-2.103,0-3.932-0.873-5.405-2.648v7.207h-1.72V96.361h1.72L154.674,98.846L154.674,98.846z
                 M154.538,103.186c0,3.33,2.593,5.434,5.35,5.434c3.003,0,5.323-2.539,5.323-5.461c0-2.895-2.238-5.432-5.323-5.432
                C156.886,97.727,154.538,100.074,154.538,103.186z"/>
            <path fill="#003366" d="M171.353,103.268c0.082,3.084,2.185,5.352,5.077,5.352c2.813,0,4.149-1.584,5.132-3.223l1.447,0.766
                c-1.365,2.674-3.467,4.039-6.415,4.039c-4.449,0-7.016-3.412-7.016-7.016c0-3.686,2.703-7.125,6.905-7.125
                c3.822,0,6.906,2.758,6.961,7.207H171.353L171.353,103.268z M181.562,101.738c-0.709-2.783-2.702-4.039-5.05-4.039
                c-2.402,0-4.203,1.283-4.995,4.039H181.562z"/>
            <path fill="#003366" d="M188.386,98.791c1.393-1.828,3.058-2.756,5.051-2.756c2.947,0,4.995,2.02,4.995,6.25v7.563h-1.72v-7.314
                c0-3.168-0.982-4.914-3.604-4.914c-1.445,0-2.646,0.627-3.549,1.828c-1.01,1.311-1.174,2.646-1.174,4.75v5.65h-1.72V96.389h1.72
                L188.386,98.791L188.386,98.791z"/>
            <path fill="#003366" d="M216.42,95.297c-0.982-1.283-1.855-2.238-3.357-2.238c-1.583,0-2.457,1.119-2.457,2.293
                c0,0.982,0.573,2.021,1.611,2.813c3.412,2.539,5.923,4.285,5.923,7.205c0,2.566-2.156,4.887-5.104,4.887
                c-2.512,0-4.149-1.393-5.486-3.85l1.556-0.928c1.093,1.992,2.402,3.002,3.794,3.002c1.911,0,3.358-1.391,3.358-3.084
                c0-1.992-1.884-3.139-6.006-6.496c-0.873-0.684-1.557-2.129-1.557-3.494c0-2.512,1.938-4.26,4.396-4.26
                c2.238,0,3.576,1.339,4.75,2.977L216.42,95.297z"/>
            <path fill="#003366" d="M235.146,103.158c0,3.822-2.975,7.043-7.015,7.043s-7.016-3.221-7.016-7.043
                c0-3.85,3.003-7.123,7.016-7.123C232.171,96.035,235.146,99.309,235.146,103.158z M222.89,103.186
                c0,2.947,2.211,5.352,5.241,5.352c3.003,0,5.241-2.402,5.241-5.352c0-3.002-2.375-5.459-5.241-5.459
                C225.238,97.727,222.89,100.184,222.89,103.186z"/>
            <path fill="#003366" d="M248.14,96.389h1.829v6.961c0,4.531-2.048,6.824-5.896,6.824c-3.849,0-5.925-2.293-5.925-6.824v-6.961
                h1.829v6.551c0,1.42,0,2.594,0.382,3.387c0.628,1.363,2.021,2.154,3.714,2.154c1.229,0,2.319-0.463,3.029-1.201
                c1.064-1.145,1.037-2.43,1.037-4.365V96.389z"/>
            <path fill="#003366" d="M254.882,98.354c1.01-1.475,2.102-2.293,3.467-2.293c0.791,0,1.201,0.246,1.556,0.465L259.005,98
                c-0.191-0.109-0.52-0.246-0.901-0.246c-1.256,0-2.401,1.092-2.921,2.949c-0.218,0.871-0.271,2.266-0.271,4.066v5.104h-1.829
                V96.416h1.829v1.938H254.882L254.882,98.354z"/>
            <path fill="#003366" d="M274.263,107.143c-1.311,1.994-3.604,3.031-6.306,3.031c-4.422,0-7.397-3.193-7.397-6.936
                c0-3.957,3.085-7.205,7.534-7.205c2.593,0,4.94,1.064,6.169,3.139l-1.393,0.875c-1.201-1.584-2.84-2.32-4.858-2.32
                c-3.412,0-5.678,2.512-5.678,5.404c0,2.947,2.237,5.486,5.705,5.486c1.938,0,3.575-0.791,4.831-2.348L274.263,107.143z"/>
            <path fill="#003366" d="M278.739,103.268c0.082,3.084,2.185,5.352,5.077,5.352c2.813,0,4.149-1.584,5.132-3.223l1.447,0.766
                c-1.365,2.674-3.467,4.039-6.415,4.039c-4.449,0-7.016-3.412-7.016-7.016c0-3.686,2.703-7.125,6.906-7.125
                c3.82,0,6.905,2.758,6.961,7.207H278.739L278.739,103.268z M288.948,101.738c-0.711-2.783-2.702-4.039-5.051-4.039
                c-2.401,0-4.204,1.283-4.995,4.039H288.948z"/>
            <path fill="#003366" d="M316.846,96.115c-1.583-2.102-3.876-3.139-6.496-3.139c-4.313,0-7.917,3.193-7.917,7.834
                c0,4.504,3.438,7.809,8.024,7.809c2.539,0,4.695-1.037,6.389-3.004l1.447,1.092c-1.885,2.348-4.642,3.604-7.943,3.604
                c-6.088,0-9.8-4.285-9.8-9.635c0-5.379,4.147-9.445,9.8-9.445c3.33,0,6.169,1.311,7.943,3.82L316.846,96.115z"/>
            <path fill="#003366" d="M335.079,103.158c0,3.822-2.976,7.043-7.016,7.043c-4.039,0-7.015-3.221-7.015-7.043
                c0-3.85,3.003-7.123,7.015-7.123C332.076,96.035,335.079,99.309,335.079,103.158z M322.823,103.186
                c0,2.947,2.211,5.352,5.24,5.352c3.003,0,5.241-2.402,5.241-5.352c0-3.002-2.375-5.459-5.241-5.459
                C325.172,97.727,322.823,100.184,322.823,103.186z"/>
            <path fill="#003366" d="M339.993,98.791c1.393-1.828,3.058-2.756,5.051-2.756c2.947,0,4.994,2.02,4.994,6.25v7.563h-1.72v-7.314
                c0-3.168-0.981-4.914-3.604-4.914c-1.446,0-2.647,0.627-3.549,1.828c-1.011,1.311-1.174,2.646-1.174,4.75v5.65h-1.72V96.389h1.72
                L339.993,98.791L339.993,98.791z"/>
            <path fill="#003366" d="M355.253,91.393h1.72v5.023h2.757v1.527h-2.757v11.93h-1.72v-11.93h-2.375v-1.527h2.375V91.393z"/>
            <path fill="#003366" d="M363.442,103.268c0.082,3.084,2.186,5.352,5.078,5.352c2.813,0,4.148-1.584,5.132-3.223l1.446,0.766
                c-1.365,2.674-3.467,4.039-6.415,4.039c-4.449,0-7.015-3.412-7.015-7.016c0-3.686,2.701-7.125,6.905-7.125
                c3.821,0,6.905,2.758,6.96,7.207H363.442L363.442,103.268z M373.652,101.738c-0.71-2.783-2.703-4.039-5.051-4.039
                c-2.401,0-4.203,1.283-4.995,4.039H373.652z"/>
            <path fill="#003366" d="M380.503,98.791c1.392-1.828,3.057-2.756,5.05-2.756c2.948,0,4.995,2.02,4.995,6.25v7.563h-1.721v-7.314
                c0-3.168-0.981-4.914-3.604-4.914c-1.446,0-2.647,0.627-3.548,1.828c-1.012,1.311-1.174,2.646-1.174,4.75v5.65h-1.721V96.389
                h1.721L380.503,98.791L380.503,98.791z"/>
            <path fill="#003366" d="M395.762,91.393h1.72v5.023h2.757v1.527h-2.729v11.93h-1.721v-11.93h-2.375v-1.527h2.375v-5.023H395.762z
                "/>
            <path fill="#003366" d="M409.301,109.846l2.594-18.181h0.3l7.397,14.933l7.314-14.933h0.301l2.594,18.181h-1.774l-1.773-13.02
                l-6.441,13.02h-0.464l-6.524-13.129l-1.747,13.129H409.301z"/>
            <path fill="#003366" d="M444.815,96.389h1.692v13.457h-1.692v-2.293c-1.474,1.775-3.33,2.648-5.432,2.648
                c-3.933,0-6.879-3.275-6.879-7.1c0-3.82,3.028-7.041,6.933-7.041c2.185,0,4.04,0.928,5.378,2.813V96.389z M434.278,103.131
                c0,2.92,2.293,5.459,5.296,5.459c2.757,0,5.378-2.074,5.378-5.434c0-3.109-2.319-5.459-5.351-5.459
                C436.516,97.727,434.278,100.238,434.278,103.131z"/>
            <path fill="#003366" d="M452.13,98.791c1.393-1.828,3.058-2.756,5.05-2.756c2.948,0,4.996,2.02,4.996,6.25v7.563h-1.721v-7.314
                c0-3.168-0.982-4.914-3.604-4.914c-1.447,0-2.647,0.627-3.549,1.828c-1.01,1.311-1.174,2.646-1.174,4.75v5.65h-1.721V96.389
                h1.721L452.13,98.791L452.13,98.791z"/>
            <path fill="#003366" d="M477.572,96.389h1.692v13.457h-1.692v-2.293c-1.475,1.775-3.331,2.648-5.433,2.648
                c-3.932,0-6.879-3.275-6.879-7.1c0-3.82,3.029-7.041,6.934-7.041c2.185,0,4.04,0.928,5.378,2.813V96.389L477.572,96.389z
                 M467.033,103.131c0,2.92,2.293,5.459,5.296,5.459c2.758,0,5.378-2.074,5.378-5.434c0-3.109-2.32-5.459-5.351-5.459
                C469.273,97.727,467.033,100.238,467.033,103.131z"/>
            <path fill="#003366" d="M496.515,107.115c0,2.213-0.136,4.041-1.229,5.516c-1.146,1.557-3.14,2.457-5.704,2.457
                c-3.878,0-5.761-1.584-6.935-4.176h1.883c1.012,1.773,2.595,2.619,4.97,2.619c2.237,0,3.876-0.818,4.693-2.293
                c0.521-0.928,0.573-1.91,0.573-2.947v-1.012c-1.337,1.693-3.303,2.566-5.404,2.566c-3.713,0-6.879-2.838-6.879-6.824
                c0-4.012,3.33-6.986,6.879-6.986c2.375,0,3.985,1.01,5.404,2.674v-2.32h1.747L496.515,107.115L496.515,107.115z M484.259,103.131
                c0,2.676,1.911,5.051,5.459,5.051c2.948,0,5.132-2.021,5.132-5.16c0-3.248-2.401-5.295-5.188-5.295
                C486.634,97.727,484.259,100.02,484.259,103.131z"/>
            <path fill="#003366" d="M501.373,103.268c0.082,3.084,2.185,5.352,5.077,5.352c2.813,0,4.149-1.584,5.132-3.223l1.446,0.766
                c-1.364,2.674-3.466,4.039-6.414,4.039c-4.449,0-7.016-3.412-7.016-7.016c0-3.686,2.702-7.125,6.906-7.125
                c3.82,0,6.905,2.758,6.961,7.207H501.373L501.373,103.268z M511.582,101.738c-0.709-2.783-2.701-4.039-5.05-4.039
                c-2.401,0-4.204,1.283-4.995,4.039H511.582z"/>
            <path fill="#003366" d="M527.552,109.846h-1.72v-6.879c0-1.037-0.109-1.91-0.138-2.512c-0.082-1.475-1.256-2.729-3.028-2.729
                c-1.201,0-2.375,0.572-3.141,1.582c-0.955,1.23-1.146,2.84-1.146,4.859v5.705h-1.721V96.416h1.721v2.293
                c1.2-1.721,2.675-2.648,4.612-2.648c2.047,0,3.521,1.064,4.26,3.248c1.199-2.156,2.975-3.248,4.939-3.248
                c2.784,0,4.586,1.992,4.586,5.814v7.971h-1.72v-7.342c0-0.984-0.137-1.775-0.164-2.293c-0.082-1.201-1.229-2.514-3.029-2.514
                c-1.666,0-3.14,1.012-3.821,2.73c-0.438,1.092-0.491,2.293-0.491,3.52V109.846L527.552,109.846z"/>
            <path fill="#003366" d="M541.582,103.268c0.081,3.084,2.185,5.352,5.077,5.352c2.813,0,4.148-1.584,5.133-3.223l1.445,0.766
                c-1.364,2.674-3.467,4.039-6.415,4.039c-4.448,0-7.015-3.412-7.015-7.016c0-3.686,2.702-7.125,6.906-7.125
                c3.82,0,6.904,2.758,6.96,7.207H541.582L541.582,103.268z M551.791,101.738c-0.71-2.783-2.702-4.039-5.051-4.039
                c-2.4,0-4.203,1.283-4.995,4.039H551.791z"/>
            <path fill="#003366" d="M558.644,98.791c1.392-1.828,3.057-2.756,5.05-2.756c2.948,0,4.995,2.02,4.995,6.25v7.563h-1.72v-7.314
                c0-3.168-0.982-4.914-3.604-4.914c-1.445,0-2.646,0.627-3.548,1.828c-1.011,1.311-1.174,2.646-1.174,4.75v5.65h-1.72V96.389h1.72
                L558.644,98.791L558.644,98.791z"/>
            <path fill="#003366" d="M573.93,91.393h1.72v5.023h2.757v1.527h-2.757v11.93h-1.72v-11.93h-2.375v-1.527h2.375V91.393z"/>
        </g>
        <g>
            <path fill="#FFFFFF" d="M116.268,28.855h5.433L132.4,66.717l15.068-37.861h1.092l14.877,37.861l10.919-37.861h5.352
                l-15.097,52.602h-1.036l-15.532-39.771l-15.969,39.771h-0.955L116.268,28.855z"/>
            <path fill="#FFFFFF" d="M188.577,62.404c0.219,8.926,6.306,15.449,14.657,15.449c8.136,0,12.012-4.612,14.877-9.309l4.178,2.211
                c-3.958,7.752-10.045,11.655-18.535,11.655c-12.884,0-20.281-9.881-20.281-20.28c0-10.619,7.834-20.582,20.009-20.582
                c11.057,0,20.01,7.998,20.146,20.881h-35.05L188.577,62.404L188.577,62.404z M218.085,58.008
                c-2.047-8.053-7.834-11.654-14.576-11.654c-6.961,0-12.147,3.738-14.44,11.654H218.085z"/>
            <path fill="#FFFFFF" d="M238.258,81.43h-4.995V27.518h4.968v21.675c4.26-5.132,9.526-7.698,15.614-7.698
                c11.355,0,20.009,9.445,20.009,20.5c0,11.001-8.79,20.445-20.146,20.445c-6.307,0-11.492-2.784-15.45-8.217V81.43z
                 M268.722,61.885c0-8.436-6.661-15.832-15.396-15.832c-7.998,0-15.45,5.924-15.45,15.668c0,9.008,6.66,15.888,15.45,15.888
                C262.334,77.635,268.722,70.238,268.722,61.885z"/>
            <path fill="#FFFFFF" d="M282.343,73.322c2.483,2.785,5.214,4.313,8.135,4.313c3.821,0,7.18-2.783,7.18-6.441
                c0-2.266-1.312-4.395-3.222-5.432c-8.927-4.97-13.484-7.099-13.484-13.922c0-6.143,4.75-10.318,10.699-10.318
                c4.26,0,7.479,2.048,10.782,5.269l-3.221,3.304c-2.348-2.267-4.695-3.74-7.834-3.74c-3.221,0-5.869,2.267-5.869,5.215
                c0,1.965,1.256,4.176,3.003,5.213c8.926,5.214,13.921,7.18,13.921,14.223c0,6.088-4.694,11.491-11.71,11.491
                c-4.313,0-8.708-1.965-11.492-5.567L282.343,73.322z"/>
            <path fill="#FFFFFF" d="M317.2,30.602c0,2.267-1.911,4.178-4.177,4.178s-4.095-1.911-4.095-4.178
                c0-2.348,1.911-4.094,4.095-4.094C315.318,26.508,317.2,28.336,317.2,30.602z M310.621,42.531h4.969V81.43h-4.969V42.531z"/>
            <path fill="#FFFFFF" d="M330.385,28.037h4.969v14.494h7.998v4.396h-7.998V81.43h-4.969V46.928h-6.879v-4.396h6.879V28.037z"/>
            <path fill="#FFFFFF" d="M354.052,62.404c0.219,8.926,6.306,15.449,14.658,15.449c8.135,0,12.011-4.612,14.877-9.309l4.177,2.211
                c-3.958,7.752-10.045,11.655-18.535,11.655c-12.884,0-20.281-9.881-20.281-20.28c0-10.619,7.834-20.582,20.009-20.582
                c11.057,0,20.01,7.998,20.146,20.881h-35.05L354.052,62.404L354.052,62.404z M383.587,58.008
                c-2.048-8.053-7.834-11.654-14.576-11.654c-6.961,0-12.147,3.738-14.44,11.654H383.587z"/>
            <path fill="#FFFFFF" d="M399.338,81.457V28.855h11.137c11.056,0,16.104,5.433,16.104,12.83c0,4.613-2.211,8.57-6.741,11.055
                c7.314,2.484,11.055,7.043,11.055,13.622c0,7.834-6.087,15.095-17.143,15.095H399.338z M404.606,50.885h3.521
                c3.958,0,7.043-0.52,9.227-1.967c2.348-1.527,3.74-4.313,3.74-7.261c0-4.694-3.521-7.698-9.609-7.698h-6.879V50.885
                L404.606,50.885z M404.606,76.325h6.36c2.266,0,4.53-0.354,6.306-0.519c3.521-0.301,8.135-4.096,8.135-9.391
                c0-3.439-1.911-6.66-5.132-8.436c-3.085-1.692-7.179-1.965-12.093-1.965h-3.576V76.325L404.606,76.325z"/>
            <path fill="#FFFFFF" d="M474.268,42.531h4.914V81.43h-4.914v-6.66c-4.258,5.132-9.608,7.615-15.668,7.615
                c-11.355,0-19.927-9.445-19.927-20.5c0-11.056,8.789-20.363,20.063-20.363c6.306,0,11.655,2.701,15.531,8.135L474.268,42.531
                L474.268,42.531z M443.805,62.021c0,8.435,6.604,15.832,15.313,15.832c7.998,0,15.532-6.006,15.532-15.668
                c0-9.008-6.742-15.832-15.45-15.832C450.245,46.354,443.805,53.67,443.805,62.021z"/>
            <path fill="#FFFFFF" d="M490.536,27.518h4.969V58.2l17.962-15.669h7.396l-21.318,18.535l22.574,20.363h-7.098l-19.49-17.498
                V81.43h-4.968V27.518H490.536z"/>
            <path fill="#FFFFFF" d="M530.528,62.404c0.218,8.926,6.307,15.449,14.658,15.449c8.135,0,12.011-4.612,14.877-9.309l4.177,2.211
                c-3.958,7.752-10.046,11.655-18.534,11.655c-12.885,0-20.281-9.881-20.281-20.28c0-10.619,7.834-20.582,20.009-20.582
                c11.055,0,20.009,7.998,20.145,20.881h-35.049L530.528,62.404L530.528,62.404z M560.063,58.008
                c-2.047-8.053-7.834-11.654-14.576-11.654c-6.961,0-12.146,3.738-14.439,11.654H560.063z"/>
            <path fill="#FFFFFF" d="M578.159,48.182c2.921-4.258,6.089-6.66,10.046-6.66c2.267,0,3.439,0.736,4.478,1.311l-2.647,4.258
                c-0.572-0.3-1.528-0.736-2.647-0.736c-3.657,0-6.961,3.14-8.436,8.49c-0.654,2.482-0.818,6.522-0.818,11.791V81.43h-5.269V42.532
                h5.269v5.649H578.159L578.159,48.182z"/>
        </g>
    </g>
    <g id="hat">
        <path fill="#003366" d="M97.924,108.537v12.721c-5.705,4.229-42.557,10.508-46.05-0.738
            C48.353,109.273,83.347,106.871,97.924,108.537z"/>

            <linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="-0.3811" y1="-323.6753" x2="0.6189" y2="-323.6753" gradientTransform="matrix(87.6418 -50.6 50.6 87.6418 16445.0781 28438.0098)">
            <stop  offset="0" style="stop-color:#E8F1F8"/>
            <stop  offset="0" style="stop-color:#E8F1F8"/>
            <stop  offset="0.21" style="stop-color:#BED7EC"/>
            <stop  offset="0.46" style="stop-color:#94BDDF"/>
            <stop  offset="0.68" style="stop-color:#75AAD6"/>
            <stop  offset="0.87" style="stop-color:#629ED1"/>
            <stop  offset="1" style="stop-color:#5B9ACF"/>
        </linearGradient>
        <path fill="url(#SVGID_1_)" d="M108.952,17.691c0,0-4.806-0.301-26.151-0.547C35.823,16.6,7.625,38.137,13.33,51.403
            c7.971,18.507,38.517,69.28,38.517,69.28c1.282-15.834,56.941-10.318,56.941-10.318L108.952,17.691z"/>
    </g>
</g>
</svg>
              </div>
              <div class="w3-container w3-padding" style="position: relative;z-index: 1;">
<?php
    if ($bVarDump && ($oZip instanceof Zipper))
    {
        print $oZip->showDebug($oZip->getAllVars());
        \flush (); //.PHP_EOL;  htmlspecialchars() ;sleep(10); die();
    }
?>
                  <h2 class=" w3-xlarge w3-margin-0" style="color:#215a7a"><b>Settings PHP Version (<?= PHP_VERSION;?> )</b></h2>
                  <form id="form-unzip" action="<?= $sAppRel;?>unzip.php" method="post" enctype="multipart/form-data">
                      <input type="hidden" name="extract" value="1" />
                      <input type="hidden" name="sLogFile" value="<?=$sLogFile;?>"/>
                      <div class="w3-row">
                          <label class="w3-quarter" style="vertical-align: top;">Select Zipfiles to extract</label>
                          <select id="aFiles" name="aFile" class="w3-select w3-select-stripped w3-margin-left w3-border w3-twothird w3-select-multi" size="4" style="height: 6.9em!important;">
<?php
      $sZipPattern   = '*.zip';
      $aZipFiles = \glob($sZipPattern,\GLOB_NOSORT);
      if ((count($aZipFiles))) {
          $select = ((count($aZipFiles)==1) ? ' selected="selected"' : '');
          foreach($aZipFiles as $item){
            if (is_readable(__DIR__).'/'.$item){
                $mTime = ' from '.date ("d F Y - h:i A", filemtime(__DIR__.'/'.$item));
            }
?>
                              <option value="<?= $item;?>"<?= $select;?> ><?= $item.$mTime;?></option>
<?php     }
      }
      else
      { ?>
                              <option value="" style="font-size: 18px!important;color: red;">No Archivefile found!</option>
<?php } ?>
                          </select>
                      </div>
                      <div class="w3-row w3--hide">
                          <label class="w3-text-gray"><b class="w3-large">&nbsp;</b> </label>
                          <input type="checkbox" id="empty_folder" value="1" name="empty_folder" class="w3-check" <?= $sUnzipCheckFolders;?> />
                          <label class="w3-validate w3-large" title="" for="empty_folder">Unpack Empty Folders<span class="">&nbsp;</span></label>
                      </div>
                      <div class="w3-row w3--hide">
                          <label class="w3-text-gray"><b class="w3-large">&nbsp;</b> </label>
                          <input type="checkbox" id="empty_files" value="1" name="empty_files" class="w3-check"<?= $sUnzipCheckFiles;?>/>
                          <label class="w3-validate w3-large" title="" for="empty_files">Unpack Empty Files<span class="">&nbsp;</span></label>
                      </div>
                      <div class="w3-row">
                          <label class="w3-text-gray"><b class="w3-large">&nbsp;</b> </label>
                          <input type="checkbox" id="delete_archive" value="1" name="delete_archive" class="w3-check"<?= $sCheckArchive;?>/>
                          <label class="w3-validate w3-large" title="" for="delete_archive">Delete Archive Files<span class="">&nbsp;</span></label>
                      </div>
                      <div class="w3-row">
                          <label class="w3-text-gray"><b class="w3-large">&nbsp;</b> </label>
                          <input type="checkbox" id="delete_unzip" value="1" name="delete_unzip" class="w3-check"<?= $sCheckUnzip;?>/>
                          <label class="w3-validate w3-large" title="" for="delete_unzip">Delete Unzip File<span class="">&nbsp;</span></label>
                      </div>
                      <div class="w3-row w3-hide">
                          <label class="w3-text-gray"><b class="w3-large">&nbsp;</b> </label>
                          <input type="checkbox" id="debug_mode" value="1" name="debug_mode" class="w3-check"<?= $sCheckDebug;?>/>
                          <label class="w3-validate w3-large" title="" for="debug_mode">Debug Mode Without Extracting Archive Files- <span class="">&nbsp;</span></label>
                      </div>
                      <div class="w3-row <?= $sHideVarDump; ?>">
                          <label class="w3-text-gray"><b class="w3-large">&nbsp;</b> </label>
                          <input type="checkbox" id="var_dump" value="1" name="var_dump" class="w3-check"<?= $sCheckVarDump;?>/>
                          <label class="w3-validate w3-large" title="" for="var_dump">Show Config Array (after finishing unzip) <span class="">&nbsp;</span></label>
                      </div>
                      <div class="w3-row">
                          <label class="w3-text-gray"><b class="w3-large">&nbsp;</b> </label>
                          <input type="checkbox" id="can_log" value="1" name="can_log" class="w3-check"<?= $sCheckCanLog;?>/>
                          <label class="w3-validate w3-large" title="" for="can_log">Create Logfile (<?=$sLogRel.$sLogFile;?>) <span class="">&nbsp;</span></label>
                      </div>
                      <div class="w3-row-padding w3-section w3-stretch">
                          <div class="w3-half">
                              <button id="start_unzip" name="start_unzip" type="submit" class=" w3-large w3-input w3-btn w3-padding w3-hover-green w3-margin-top" value="1" style="min-width: 10em;color:#fff !important; background-color:#215a7a !important">Start Unzip</button>
                          </div>
                          <div class="w3-half">
                              <button formaction="<?= $sAppRel;?>unzip.php" formmethod="post" id="start_reset" name="start_reset" type="reset" class=" w3-large w3-input w3-btn w3-padding w3-hover-red w3-margin-top" style="min-width: 10em;color:#fff !important; background-color:#377496 !important">Reset</button>
                          </div>
                      </div>
                  </form>
              </div>

              <div class="w3-container w3-padding">
                <div id="ProgressBar" class="progress-bar-striped w3-hide">
                    <div style="width: 100%;"><b><p class="w3-text-white w3-large w3-padding-0">Extracting Archive(s)</p></b></div>
                </div>
                <ol class="w3-ul">
                  <?= $output; ?>
                </ol>
                <h3 class="w3-large"><?= $sExecutionTime; ?></h3>
              </div>
              <div class="w3-row w3-card-4">
                  <footer class="w3-container" style="height: 80px;color:#fff !important; background-color:#215a7a !important">
                      <div class="w3-row">
                        <div class="w3-half">
                          <h3 class="w3-large w3-padding"><?= $sEndTime; ?></h3>
                        </div>
                        <div class="w3-half">
<?php if (is_readable($sAppPath.'/admin/login/index.php')){ ?>
                          <div class="w3-right">
                              <h3 class="w3-large w3-text-white w3-padding"><a class="w3-btn w3-card w3-light-blue w3-hover-green w3-large" href="<?= $sLoginRel;?>" rel="noopener"><span class="w3-padding w3-xlarge">&#x2699;</span><span style="vertical-align: text-bottom;"> Backend</span></a></h3>
<?php }
      else
      { ?>
                              <div class="w3-right">
                                  <h3 class="w3-large w3-text-white w3-padding">Error::Missing Backend Login <?= $sAcpRel;?></h3>
<?php } ?>
                              </div>
                          </div>
                        </div>
                      </div>
                  </footer>
              </div>
          </div>
      </main>
      <div class="w3-container w3-margin-top">
          <div class="w3-row">
              <p style="text-align: center;margin-bottom: 10px;">©&nbsp;<?= date('Y');?> WebsiteBaker Org e.V.
              <a href="https://www.websitebaker.org/" style="font-weight: normal;" target="_blank" rel="noopener">WebsiteBaker</a>
          </div>
      </div>
<script>
    document.addEventListener("DOMContentLoaded", function () {

        function changeProgressbar(){
            var selectedValue = document.querySelector("#progress-value").value;
            document.querySelector(".progress-bar-striped > div").textContent = selectedValue + "%";
            document.querySelector(".progress-bar-striped > div").style.width = selectedValue + "%";
        }

        let unzipForm = document.getElementById('form-unzip');
        unzipForm.addEventListener (
            "submit",
            function (evt) {
//console.log(evt);
              let progress = document.getElementById('ProgressBar');
//console.log(progress);
              progress.classList.remove("w3-hide");
//                evt.preventDefault();
        });

        let fieldsreset = document.getElementById('start_reset');
        fieldsreset.addEventListener (
            "click",
            function (evt) {
//                deleteUnzip.checked = false;
//                deleteArchive.checked = false;
                let url = window.location.protocol +'//'+ window.location.host + window.location.pathname;
                window.location.href = url;
                evt.preventDefault();
        });

    });

</script>
    </body>
</html>
<?php

    class Zipper
    {
        private $oZip;
        private $bIsAddon;
        private $sOldPath;
        private $aConfig = [];

        public function __construct($aOptions)
        {
            $this->init($aOptions);
        }

        public function __destruct()
        {
            ini_restore('memory_limit');
            ini_restore('max_execution_time');
        }


        public function __isset($name)
        {
            return isset($this->aConfig[$name]);
        }

         public function __set($name, $value)
         {
    //         throw new \Exception('Tried to set a readonly or nonexisting property ['.$name.']!!');
             return $this->aConfig[$name] = $value;
         }

        public function __get($name)
        {
            $retval = null;
            if (!$this->__isset($name))
            {
                throw new \Exception('Tried to get nonexisting property ['.$name.']');
            }
                $retval = $this->aConfig[$name];
            return $retval;
        }

        public function set($name, $value = '')
        {
            $this->aConfig[$name] = $value;
        }

        public function get($name)
        {
            return $this->$name;
//            if (!$this->aConfig[$name]){throw new \Exception('Tried to get nonexisting property ['.$name.']');;}
//            return $this->aConfig[$name];
        }

        protected function init($aOptions)
        {
            $this->clearCache();
            //$this->oZip = new \ZipArchive;
            $this->aConfig['oZip'] = new \ZipArchive;
            foreach ($aOptions as $key=>$value){
                switch ($key):
                    case 'AppUrl':
                        $this->aConfig['FilesRootUrl'] = $value;
                        break;
                    case 'TargetDir':
                        $this->aConfig['CopyFilesTo'] = $value;
                        break;
                    case 'CsvSourceFile':
                        $this->aConfig['CsvFileName'] = $this->removeExtension($value);
                    default:
                        $this->aConfig[$key] = $value;
                endswitch;
            }
        }

        protected function setError($Message)
        {
            $this->error[] = $message;
            $this->error_type = 'unknown';
        }

        /**
         * CopyFilesTo::removeExtension()
         *
         * @param mixed $sFilename
         * @return
         */
        public function removeExtension ($sFilename)
        {
            return \preg_replace('#^.*?([^\/]*?)\.[^\.]*$#i', '\1', $sFilename);
        }

        /**
         * CopyFilesTo::createPath()
         *
         * @param mixed $sFilename
         * @return
         */
        public function createPath($sFilename)
        {
            $bRetval = true;
            $sFilename = (\is_file($sFilename) ? \dirname($sFilename) : $sFilename);
            $sFilename = (rtrim($sFilename, '/')).'/';
            if (!\is_readable($sFilename)){
                $iOldUmask = \umask(0);
                $bRetval = @\mkdir($sFilename, $this->OctalDirMode,true);
                \umask($iOldUmask);
            }
            return $bRetval;
        }

        public function rmoveFullPath($sBasedir='', $bPreserveBaseFolder = false)
        {
            $bRetval = true;
            $sPath = \rtrim($sBasedir, '\\\\/').'/';
            if (\is_readable($sPath)) {
                $oHandle = \opendir($sPath);
                while (false !== ($sFile = \readdir($oHandle))) {
                    if (($sFile != '.') && ($sFile != '..')) {
                        $sFileName = $sPath . '/' . $sFile;
                        if (\is_dir($sFileName)) {
                            $bRetval = rm_full_dir($sFileName, false);
                        } else {
                            $bRetval = \unlink($sFileName);
                        }
                        if (!$bRetval) { break; }
                    }
                }  // end while
                \closedir($oHandle);
                if (!$bPreserveBaseFolder && $bRetval) { $bRetval = \rmdir($sPath); }
            }
            return $bRetval;
        }

        protected function clearCache(){
            clearstatcache();
        }

        public function convertToArray ($mList)
        {
            $retVal = $mList;
            if (!is_array($mList)){
                $retVal = preg_split('/[\s,=+\;\:\/\.\|]+/', $mList, -1, PREG_SPLIT_NO_EMPTY);
            }
            return $retVal;
        }

          public function convertToByte ($iniSet='memory_limit')
          {
              $aMatch = [];
              $iMemoryLimit = (ini_get($iniSet));
              if ((int)$iMemoryLimit !== -1) {
                  \preg_match('/^\s*([0-9]+)([a-z])?\s*(_)?\s*$/i', $iMemoryLimit.'_', $aMatch);
                  $iMemoryLimit = (int)$aMatch[1];
                  switch ($aMatch[2]) {
                       case 'g': case 'G':
                          $iMemoryLimit *= 1024;
                      case 'm': case 'M':
                          $iMemoryLimit *= 1024;
                      case 'k': case 'K':
                          $iMemoryLimit *= 1024;
                          break;
                      default:
                          break;
                  }
                  unset($aMatch);
              }
              //$this->aConfig['iMemoryLimit'] = $iMemoryLimit;
              return $iMemoryLimit;
          }

          private function convertByteToUnit ($size, $roundup = 5, $decimals = 2)
          {
              $sRetval = "0K";
              $aFilesizeUnits = ["", "K", "M", "G", "T", "P", "E", "Z", "Y"];
              $addition = ((($roundup > 0) && ($decimals == 0)) ? 0.45 : 0);
              $sRetval = (($size > 0) ? \round($size / pow(1024,($i = \floor(log($size, 1024))))+$addition, $decimals).$aFilesizeUnits[$i] : $sRetval);
              return $sRetval;
          }

        public function setMaxExecutionTime($mMemoryLimit='300')
        {
            $iMaxMemoryLimit = ini_get('max_execution_time');
            $this->mMemory_Limit = $mMemoryLimit;
            if ((int)$iMaxMemoryLimit < (int)$mMemoryLimit){
              \ini_set('max_execution_time', $mMemoryLimit); // 7 minutes
            }
        }

        public function resetMaxExecutionTime()
        {
    //        \ini_set('max_execution_time', $this->MaxMemoryLimit);
    //        \ini_set('memory_limit', $this->Memory_Limit);
            ini_restore('memory_limit');
            ini_restore('max_execution_time');
        }

        public function increaseMemory($sMemoryLimit='256M',$MaxExecutionTime='600')
        {
    //        TODO Ssnitize parameter
            $iDefautLimit = 245 * 1024 * 1024;
            \ini_set("gd.jpeg_ignore_warning", 1);
            $this->aConfig['sMemoryLimit'] = $sMemoryLimit;
            $this->aConfig['iMaxExecutionTime'] = $MaxExecutionTime;
            $iMemoryLimit = $this->convertToByte("memory_limit");
            if ($iMemoryLimit < $iDefautLimit) {
                \ini_set("memory_limit", $iMemoryLimit);
            }
            $this->setMaxExecutionTime($MaxExecutionTime);
        }

    //  extracts the content of a string variable from a string (save alternative to including files)
        public function get_variable_content($search='', $data='', $striptags=true, $convert_to_entities=true)
        {
            $match   = [];
            $mRetval = null;
            // search for $variable followed by 0-n whitespace then by = then by 0-n whitespace
            // then either " or ' then 0-n characters then either " or ' followed by 0-n whitespace and ;
            // the variable name is returned in $match[1], the content in $match[3]
            if (\preg_match('/(\$' .$search .')\s*=\s*("|\')(.*)\2\s*;/i', $data, $match))
            {
                if (\strip_tags(\trim($match[1])) == '$' .$search) {
                    // variable name matches, return it's value
                    $mRetval = (($striptags == true) ? \strip_tags($match[3]) : $match[3]);
                    $mRetval = ($convert_to_entities == true) ? \htmlentities($match[3]) : $match[3];
    //                return $match[3];
                }
            }
            return $mRetval;
        }

        public function deleteArchiveFile($bDelete = false)
        {
            $bDelete = ($bDelete ?? false);
            $sFile = str_replace($this->AppPath, '',$this->ArchiveFile);
            $sFile = (empty($sFile) ? 'No Archive found' : $sFile);
            if ($bDelete && is_file($this->ArchiveFile) && \unlink(realpath($this->AppPath.$this->ArchiveFile)))
            {
                $sRetval = \sprintf('<li class="w3-text-green w3-large">Installation archive %s successfully deleted</li>'.PHP_EOL,$this->AppRel.$this->ArchiveFile);
                $sError = \sprintf("\n[%03d] Installation archive %s successfully deleted\n",__LINE__, $sFile);
           }
           else
           {
                $sMsg = ($bDelete ? 'Archive File could not be deleted' : 'Archive File prevent from deleting');
                $sRetval = \sprintf('<li class="w3-text-red w3-large">Archive %s %s</li>'.PHP_EOL,$this->ArchiveFile,$sMsg);
                $sError = \sprintf("\n[%03d] %s\n",__LINE__, $sMsg);
            }
            if ($this->bCanLog===true) {
                \file_put_contents($this->LogPath.$this->LogFile,$sError, \FILE_APPEND);
            }
            return $sRetval;
        }

        function deleteUnzip($bDelete=false)
        {
            $sFile = str_replace($this->AppPath, '','unzip.php');
            if ($bDelete && \unlink(\realpath($this->AppPath.'unzip.php'))){
                $sRetval = \sprintf('<li class="w3-text-green w3-large">Unzip file successfully deleted</li>'.PHP_EOL);
                $sError = \sprintf("\n[%03d] Unzip file successfully deleted:",__LINE__, $sFile);
            }
            else
            {
                $sMsg = ($bDelete ? 'Unzip.php could not be deleted' : 'Unzip.php prevent from deleting');
                $sRetval = \sprintf('<li class="w3-text-red w3-large">Unzip file %s</li>'.PHP_EOL,$sMsg);
                $sError = \sprintf("[%03d] %s\n",__LINE__, $sMsg);
            }
            if ($this->bCanLog===true) {
                \file_put_contents($this->LogPath.$this->LogFile,$sError, \FILE_APPEND);
            }
            return $sRetval;
        }

        public function getAllVars()
        {
            return $this->aConfig;
        }

        // Cross-platform use of the %e placeholder
        protected function getTimeFormat($sFormat)
        {
          $sRetval = $sFormat;
    // Check for Windows to replace the %e placeholder correctly
          if (\strtoupper(\substr(\PHP_OS, 0, 3)) == 'WIN') {
              $format = \preg_replace('#(?<!%)((?:%%)*)%e#', '\1%#d', $sRetval);
          }
          return $sRetval;
        }

        public function showDebug($value)
        {
            ob_start();
            print "<pre>\n";
            print_r( $value );
            print "</pre>"; flush (); //  sleep(10); die();
            return ob_get_clean();
        }

        protected function isWrongArchive($sFilename)
        {
            $mList  = null;
            $sError = '';
            $aError = [
                  'numFiles' => 0,
                  'files'    => 0,
                  'folders'  => 0,
                  'error'    => '',
            ];
            try {
                $this->oZip = new \ZipArchive();
                if ($this->oZip->open(\realpath($sFilename)))
                {
                    $aError['numFiles'] = $this->oZip->count();
                    for ($i=0; $i < $this->oZip->numFiles;$i++) {
                        $aItem = $this->oZip->statIndex($i);
                        $sItem = $aItem['name'];
                        $sDestination = $this->AppPath.$sItem;
                        if ($sItem == 'info.php'){
                            if ($oZip->getFromIndex($i)===false){
                                if (is_writeable($sDestination)) {
                                  \rename($sDestination,$sDestination.'.copy');
                                }
                                $aError['files']++;
                            } else {
                              $sData = (($this->oZip->getFromIndex($i)) ?: 'Error loading Content from '.$sItem);
                              $module_name   = get_variable_content ('module_name', $sData);
                              $template_name = get_variable_content ('template_name', $sData);
                              $mList = (isset($module_name) ? $module_name : (isset($template_name) ? $template_name : null));
                            }
                            break;
                        }
                    }
                }
            } catch(\ErrorException $ex){
                /* place to insert different error/logfile messages */
                $sError = $aError['error'] = '$sContent = '.$ex->getMessage();
                $sFile = str_replace($this->AppPath, '',$sItem);
                //$sError = \sprintf('[%03d] File %s could not be processed:',__LINE__, $sFile);
                if ($this->bCanLog===true) {
                    \file_put_contents($this->LogPath.$this->LogFile,$sError, \FILE_APPEND);
                }
            }
            $this->oZip->close();
            return $mList;
        }

        protected function extractTo($pathto, $files = null)
        {
            return $this->oZip->extractTo($pathto, $files);
        }

        protected function unzipArchive ($sFilename='', $bUnzipEmptyFolders = true, $bUnzipEmptyFiles = true)
        {
            $sError = '';
            $aError = [
                  'numFiles' => 0,
                  'files'    => 0,
                  'folders'  => 0,
                  'error'    => '',
            ];
            $aUnzip = [
                  'numFiles' => 0,
                  'file'     => 0,
                  'folder'   => 0,
                  'error'    => '',
            ];
            try {
                $this->aConfig['oZip'] = new \ZipArchive();
                if ($this->oZip->open(\realpath($sFilename)))
                {
                    $aError['numFiles'] = $this->oZip->count();
                    $aUnzip['numFiles'] = $aError['numFiles'];
                    $this->extractTo($this->AppPath);

                    for ($i=0; $i < $this->oZip->numFiles;$i++)
                    {
                        $aItem = $this->oZip->statIndex($i);

                        $sItem = $aItem['name'];
                        $sDestination = $this->AppPath.$sItem;
                        $isDir = ((\substr($sItem, -1) === '/') ? true : false);
                        if ($isDir)
                        {
                //echo \nl2br(\sprintf("---+> <b>[%04d]</b> touch(%s) <b>%s</b> \n",__LINE__,$sDestination,date('Y-m-d H:i:s',$aItem['mtime']))); //
       //                  Returns the entry contents using its index
                          // backup from file
                            if (($this->oZip->getFromIndex($i) === false))
                            {
                                if (is_writeable($sDestination))
                                {
                                    \copy($sDestination,$sDestination.'.copy');
                                }
                                $aError['files']++;
                            }
                            else
                            {
                                if (is_writable($this->AppPath.$sItem)){
                                  \touch($this->AppPath.$sItem,$aItem['mtime']);
                                  if (($this->bChmodMode)){\chmod($this->AppPath.$sItem,(int)\octdec('755'));}
                                  $sFile = str_replace($this->AppPath, '',$sItem);
                                  ++$aUnzip['folder'];
                                  $sError = \sprintf("[%03d] Folder %s set MTime to %s successfully processed:\n",__LINE__, $sFile,date('Y-m-d H:i:s e',$aItem['mtime']));
                                }
                                else
                                {
                                    $sFile = str_replace($this->AppPath, '',$sItem);
                                    $sError = \sprintf("[%03d] Folder %s could not be processed:\n",__LINE__, $sFile);
                                }
                                if ($this->bCanLog===true)
                                {
                                    \file_put_contents($this->LogPath.$this->LogFile,$sError, \FILE_APPEND);
                                }
                            }
                        }//isDir
                        else
                        {
                            if (($this->bChmodMode)){\chmod($sDestination, (int)\octdec('644'));}
                            ++$aUnzip['file'];
                        }
                   }//for numFiles
            }
        } catch(\ErrorException $ex){
            /* place to insert different error/logfile messages */
            $aError['error'] = '$scontent = '.$ex->getMessage();
            $aUnzip['error'] = $aError['error'];
        }
        $this->oZip->close();
        return $aUnzip;
        }

        public function ExtractArchive($bEmptyFolders=false, $bEmptyFiles=false)
        {
          $sRetval = '';
    // Search and load the first zip archive
            if (is_string($this->ArchiveFile) )
            {
                $aArchiveFiles = [$this->ArchiveFile];
            }
            if (isset($this->ArchiveFile) && (!empty($aArchiveFiles)))
            {
                foreach($aArchiveFiles as $sArchiveFile)
                {
                    if (is_file($this->AppPath.$sArchiveFile))
                    {
                        \chdir($this->AppPath);
    // Extract the archive
                        $mList = $this->isWrongArchive($this->AppPath.$sArchiveFile);
                        if (is_null($mList))
                        {
                            $aUnzip = $this->unzipArchive($this->AppPath.$sArchiveFile, $bEmptyFolders, $bEmptyFiles);
                            if (empty($aUnzip['error'])){
                                $sContent = sprintf('%d files and %d folders (%d total) from %s were successfully unpacked',$aUnzip['file'],$aUnzip['folder'],$aUnzip['numFiles'], $sArchiveFile);
                                $sRetval .= \sprintf('<li class="w3-text-green w3-large"> %s'.PHP_EOL,$sContent);
                                $sMsg     = sprintf("[%03d] %s",__LINE__,$sContent);
                            }
                            else
                            {
                                $sContent = \sprintf('Errors %d have occurred:', $aUnzip['error']);
                                $sRetval .= \sprintf('<li class="w3-text-red w3-large">Errors %d have occurred:'.PHP_EOL,$sContent);
                                $sMsg     = sprintf("[%03d] %s",__LINE__,$sContent);
                                //file_put_contents($$this->LogPath.$this->LogFile,$sMsg, \FILE_APPEND);
                            }
                            if ($this->bCanLog===true) {
                                \file_put_contents($this->LogPath.$this->LogFile,$sMsg, \FILE_APPEND);
                            }

    /*
    // Set permission rights './'
                        $sRetval .= '<ul class="w3-ul">'.PHP_EOL;
                        $permission_rights = fileList($sAppPath, $sArchiveFile,0,!empty($aUnzip['error']));
                        if (empty($permission_rights)){
                            $sRetval .= \sprintf('<li class="w3-text-green w3-large">File and directory rights completely set</li>'.PHP_EOL);
                        }else{
                            $sRetval .= \sprintf('<li class="w3-text-red w3-large">Errors have occurred::%s</li>'.PHP_EOL,$permission_rights);
                        }
                        $sRetval .= '</ul>'.PHP_EOL;
    */

    /* Delete zip archive */
                            $sRetval .= $this->deleteArchiveFile($this->bDeleteArchive,$this->ArchiveFile);
                            $sRetval .= $this->deleteUnzip($this->bDeleteUnzip);
    //              $sRetval .= '</li>'.PHP_EOL;
                        } // end of isWrongArchive
                        else
                        {
                            $sContent = \sprintf("[%03d] Can\'t unzip %s package, please extract Archive and upload per FTP\n",__LINE__,$mList);
                            $sRetval .= \sprintf('<li class="w3-text-red w3-large">%s</li>'."\n",$sContent );
                            if ($this->bCanLog===true) {
                                \file_put_contents($this->LogPath.$this->LogFile,$sContent, \FILE_APPEND);
                            }
                        }
                    }//is_file
                } // foreach Archivfile
            } else {
                $sContent = sprintf("[%03d] No existing archivefile found in AppPath %s \n",__LINE__,$this->AppRel);
                $sRetval .=  \sprintf('<li class="w3-text-red w3-large">%s </li>'.PHP_EOL, $sContent);
                if ($this->bCanLog===true) {
                    \file_put_contents($this->LogPath.$this->LogFile,$sContent, \FILE_APPEND);
                }
            }
    //    }
        return $sRetval;
        } // end of function ExtractArchive


    // Set correct permission rights - folder 0755, files 0644
        public function fileList($startdir = './', $file = false, $bError = false)
        {
            static $error = '';
            $ignoredDirectory = ['.', '..', 'unzip.php'];
            if (!empty($file)){
                $ignoredDirectory[] = $file;
            }
            $string_file_mode = '0644';
            \defined('OCTAL_FILE_MODE') ? : \define('OCTAL_FILE_MODE', (int) \octdec($string_file_mode));
            $string_dir_mode = '0755';
            \defined('OCTAL_DIR_MODE')  ? : \define('OCTAL_DIR_MODE',  (int) \octdec($string_dir_mode));

            if (\is_dir($startdir)){
                if ($dh = \opendir($startdir)){
                    while(($file = \readdir($dh)) !== false)
                    {
                        if (!(\array_search($file, $ignoredDirectory) > -1)){
                            if (\is_dir($startdir.$file.'/')){
                                $bError = fileList($startdir.$file.'/', 0, $bError);
                            }
                            $filetype = \filetype($startdir.$file);
                            if (($filetype == 'dir')){
                                if ((!$bError && $this->bChmodMode && (\chmod($startdir.$file, OCTAL_DIR_MODE) == false))){
                                    $error .= 'Directory rights could not be set: '.$startdir.$file.'<br />';
                                }
                            }elseif (($filetype == 'file')){
                                if ((!$bError && $this->bChmodMode && (\chmod($startdir.$file, OCTAL_FILE_MODE) == false))){
                                    $error .= 'File rights could not be set: '.$startdir.$file.'<br />';
                                }
                            }
                        }
                    }
                    \closedir($dh);
                }
            }
            return ($error);
        }

    }// end of class Zipper


