<?php
/**
 *
 * @category        modules
 * @package         form
 * @author          WebsiteBaker Project
 * @copyright       WebsiteBaker Org. e.V.
 * @link            https://websitebaker.org/
 * @license         https://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.12.x
 * @requirements    PHP 5.6 and higher
 * @version         $Id: view_submission.php 284 2019-03-22 08:13:16Z Luisehahne $
 * @filesource      $HeadURL: svn://isteam.dynxs.de/wb/2.12.x/branches/main/modules/form/view_submission.php $
 * @lastmodified    $Date: 2019-03-22 09:13:16 +0100 (Fr, 22. Mrz 2019) $
 * @description
 */

use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck};
//use vendor\phplib\Template;


//if (!defined('WB_PATH') ){require(dirname(__DIR__,2).'/config.php');}
    $sAddonFile   = \str_replace('\\','/',__FILE__);
    $sFolder      = \basename(\dirname($sAddonFile));
    switch ($sFolder):
        case 'cmd':
          $sAddonPath   = \dirname($sAddonFile,2).'/';
          break;
        default :
          $sAddonPath   = (\dirname($sAddonFile)).'/';
    endswitch;

    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = \basename($sModulesPath);
    $sAddonName   = \basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = \preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    if (! \defined('SYSTEM_RUN') && \is_readable($sAppPath.'config.php')) {
        require($sAppPath.'config.php');
    }
/* -------------------------------------------------------- */
    $bLocalDebug  = (\is_readable($sAddonPath.'.setDebug'));
    $bSecureToken = (!\is_readable($sAddonPath.'.setToken'));
    $bFrontendCss = (!\is_readable($sAddonPath.'.setFrontend.inc'));
    $sPHP_EOL     = ($bLocalDebug ? "\n" : '');
    $sqlEOL       = ($bLocalDebug ? "\n" : "");
/* ------------------------------------------------------------------ */

    $print_info_banner = true;
//Include WB admin wrapper script
    require($sModulesPath.'admin.php');
/* -------------------------------------------------------- */
try {
// settings needs a admin object
    $oReg     = WbAdaptor::getInstance();
    $oDb      = $oReg->getDatabase();
    $oTrans   = $oReg->getTranslate();
    $oRequest = $oReg->getRequester();
    $oApp     = $oReg->getApplication();
    $isAuth   = $oApp->is_authenticated();
/* ----------set to deprecated-----------------------------
// load module language file
    if (is_readable($sAddonPath.'languages/EN.php')) {require($sAddonPath.'languages/EN.php');}
    if (is_readable($sAddonPath.'languages/'.DEFAULT_LANGUAGE.'.php')) {require($sAddonPath.'languages/'.DEFAULT_LANGUAGE.'.php');}
    if (is_readable($sAddonPath.'languages/'.LANGUAGE.'.php')) {require($sAddonPath.'languages/'.LANGUAGE.'.php');}
*/
/* -------------------------------------------------------- */
    $sCallingScript = $oRequest->getServerVar('SCRIPT_NAME');
    $ModuleUrl      = $oReg->AppUrl.$ModuleRel;
    $sAddonUrl      = $oReg->AppUrl.$sAddonRel;
    $sDomain        = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);
/* -------------------------------------------------------- */
    $sBacklink = $oReg->AcpUrl.'pages/modify.php?page_id='.$page_id;

    $sDateFormat = ($oReg->DateFormat ?? 'system_default');
    $sDateFormat = ($sDateFormat == 'system_default') ? $oReg->DefaultDateFormat : $oReg->DateFormat;
    $sTimeFormat = ($oReg->TimeFormat ?? 'system_default');
    $sTimeFormat = ($sTimeFormat == 'system_default') ? $oReg->DefaultTimeFormat : $oReg->TimeFormat;
    //$sDateFormat = PreCheck::dateFormatToStrftime($sDateFormat);

//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $aRequestVars ); print '</pre>'; \flush (); //  sleep(10); die();

//    $sAddonName = basename(__DIR__);
    $bGetOldSecureToken = (SecureTokens::checkFTAN());
    // to put in form input hidden fields, dont forgget the php echo tag round the variables
    $aFtan = \bin\SecureTokens::getFTAN();
    // for $_GET Querystring
    $sFtanQuery = $aFtan['name'].'='.$aFtan['value'];

// check FTAN
    if ($bSecureToken && !$bGetOldSecureToken){
        $aMessage = \sprintf($oTrans->MESSAGE_GENERIC_SECURITY_ACCESS);
        throw new \Exception ($aMessage);
    }
    $sSubId = ($oRequest->getParam('submission_id') ?? $submission_id);
//  Get id
    if (!($submission_id = $oApp->getIdFromRequest($sSubId))){
      throw new \Exception ($oTrans->MESSAGE_GENERIC_SECURITY_ACCESS);
   }
    $sAction = ($oRequest->getParam('action') ?? 'show');
    $options=['options'=>['default'=>1, 'min_range'=>0, 'max_range'=>1]];
    $iActive = ($oRequest->getParam('sub_delete',FILTER_VALIDATE_INT,$options));
    if ($sAction === 'save_sub') {
        $sql  = '
            UPDATE `'.$oDb->TablePrefix.'mod_form_submissions` SET
            `sub_delete` = '.(int)$iActive.'
            WHERE `submission_id` = '.$submission_id.'
        ';
    if ($oDb->query($sql)){
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sql));
    } else {
        echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$oDb->get_error()));
    }
    } // end save
/* ---------------------------------------------------------------------------------*/
// Get submission details
    $sql  = '
    SELECT * FROM `'.$oDb->TablePrefix.'mod_form_submissions`
    WHERE `submission_id` = '.$submission_id.' ';
    if ($query_content = $oDb->query($sql)) {
        $submission = $query_content->fetchRow(MYSQLI_ASSOC);
    }
//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $sql ); print '</pre>'; \flush (); //  sleep(10); die();

// Get the user details of whoever did this submission
$sql  = 'SELECT `username`,`display_name`, `email` FROM `'.$oDb->TablePrefix.'users` '
      . 'WHERE `user_id` = '.$submission['submitted_by'];
    if ($get_user = $oDb->query($sql)) {
        if ($get_user->numRows() != 0) {
            $user = $get_user->fetchRow(MYSQLI_ASSOC);
        } else {
            $user['display_name'] = $oTrans->TEXT_GUEST;
            $user['username'] = $oTrans->TEXT_UNKNOWN;
            $user['email'] = '';
        }
    }
    $sBody = $submission['body'];
    if (!empty($sBody) && empty($user['email'])){
        $regex = "/[a-z0-9\-_]?[a-z0-9.\-_]+[a-z0-9\-_]?@[a-z0-9.-]+\.[a-z]{2,}/i";
        \preg_match ($regex, $sBody, $output);
// workout if output is empty
        $user['email'] = ($output['0'] ?? $oTrans->TEXT['UNKNOWN']);
    }
    $sSectionIdPrefix = 'submissions';
    $sSubmittedWhen = PreCheck::getStrftime($sDateFormat, $submission['submitted_when']+TIMEZONE)
               . ', '.PreCheck::getStrftime($sTimeFormat, $submission['submitted_when']+TIMEZONE);
    $checked =  (((int)$submission['sub_delete']===1) ? ' checked="checked"' : '');
    $sPrevDeleteTxt     = ((int)$submission['sub_delete'] == 0 ? $oTrans->TEXT_DELETE_TITLE : $oTrans->TEXT_DELETE_TITLE_DONE);
    $sSubmissionIdKey = $admin->getIDKEY($submission_id);

    $aDebugArray = [
        'submission_id'=>$submission_id,
        'action'=>$sAction,
        'sub_delete'=>$iActive,
        'page_id'=>$page_id,
        'gettype' =>gettype($iActive),
        'sFtanQuery'=>$sFtanQuery,
        'submission_id' => $submission_id,
        '$sBacklink' => $sBacklink,
        'checked' => $checked,
    ];

//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $aDebugArray ); print '</pre>'; \flush (); //  sleep(10); die();

// TODO remove html to a template
?>
<div class="w3-container sub_mission_block" style="margin: 0 1em;">
    <form action="<?= $sAddonUrl;?>view_submission.php" id="save-sub" method="post">
        <input id="p<?php echo $section_id; ?>" type="hidden" name="section_id" value="<?php echo $section_id; ?>">
        <input id="p<?php echo $page_id; ?>" type="hidden" name="page_id" value="<?php echo $page_id; ?>">
        <input type="hidden" name="<?php echo $aFtan['name'];?>" value="<?php echo $aFtan['value']; ?>">
        <input type="hidden" name="submission_id" value="<?= SecureTokens::getIDKEY($submission_id);?>">
        <table class="frm-submission w3-table-all">
            <tbody>
                <tr>
                    <th><span class="w3-bold"><?php echo $oTrans->TEXT_SUBMISSION_ID; ?></span></th>
                    <td><?php echo $submission['submission_id']; ?></td>
                </tr>
                <tr>
                    <th><span class="w3-bold"><?php echo $oTrans->TEXT_SUBMITTED; ?></span></th>
                    <td><?php echo $sSubmittedWhen; ?></td>
                </tr>
                <tr>
                    <th><span class="w3-bold"><?php echo $oTrans->TEXT_USER.' '; ?></span></th>
                    <td><?php echo $user['display_name'].' '; ?></td>
                </tr>
                <tr>
                    <th><span class="w3-bold"><?php echo $oTrans->TEXT_EMAIL.' '; ?></span></th>
                    <td><?php echo $user['email'].' '; ?></td>
                </tr>
                <tr>
                    <th><span class="w3-bold"><?php echo $sPrevDeleteTxt.' '; ?></span></th>
                    <td>
                      <label class="switch" lang="de">
                          <input name="sub_delete" value="1" type="checkbox" <?= $checked; ?> >
                          <span>&nbsp;</span>
                      </label>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <hr>
                    </td>
                </tr>
                <tr class="w3-sand">
                    <td colspan="2">
                        <?php echo nl2br($submission['body']); ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <div style="margin: 1em 0;">
            <input type="hidden" name="action" value="save_sub" >
            <button class="w3-btn w3-blue-wb w3-hover-green w3-medium w3-padding-4"
            type="submit"
            name="submission_id"
            value="<?php echo $sSubmissionIdKey;?>" >
            <?php echo $oTrans->TEXT_SAVE; ?>
            </button>
<?php
            if ($submission['sub_delete']) {
?>
                <button
                class="w3-btn w3-blue-wb w3-hover-red w3-medium w3-padding-4"
                type="submit"
                name="action"
                value="modal_sub"
                formaction="<?= $sAddonUrl;?>delete_submission.php"
                style="width: 150px; margin: 5px;"><?php echo $oTrans->TEXT_DELETE; ?></button>
<?php
            }
?>
            <button name="page_id" value="<?php echo $page_id;?>" class="url-close w3-btn w3-blue-wb w3-hover-red w3-medium w3-padding-4" type="button" data-overview="<?php echo ADMIN_DIRECTORY; ?>/pages/modify.php?page_id=<?= $page_id; ?>" >
                <i class="fa fa-times w3-left-align">&nbsp;</i>
                <span class="w3-padding--0"><?php echo $TEXT['CLOSE']; ?></span>
            </button>
        </div>
    </form>

</div>
<?php
    }catch (\Exception $ex) {
        $sErrMsg = PreCheck::xnl2br(sprintf('[%d] %s', $ex->getLine(), $ex->getMessage()));
        $admin->print_error ($sErrMsg, $sBacklink);
        exit;
    }

// Print admin footer
$admin->print_footer();

/*

    [submission_id] => 5
    [action] => save_sub
    [sub_delete] => 1
    [gettype] => integer
    [sFtanQuery] => c05632bbd1e076fd=Z6XL7D3hdPZuudBzw1yKIw
    [submission_idKey] => e0a03bce07bba26b
    [checked] =>  checked="checked"

    [page_id] => 5
    [section_id] => 17
    [c05632bbd1e076fd] => Z6XL7D3hdPZuudBzw1yKIw
    [sub_delete] => 1
    [submission_id] => e7287597876c6ed4


*/







