<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of admin/media/upload.php
 *
 * @package      Core
 * @copyright    Manuela v.d.Decken <manuela@isteam.de>
 * @author       Manuela v.d.Decken <manuela@isteam.de>
 * @license      GNU General Public License 2.0
 * @version      2.0.1
 * @revision     $Id: upload.php 285 2019-03-26 14:42:18Z Luisehahne $
 * @since        File available since 04.10.2017
 * @deprecated   no
 * @description  xxx
 */
declare(strict_types = 1);
//declare(encoding = 'UTF-8');

//namespace ;

use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck,PNGType};
use bin\requester\HttpRequester;
use bin\media\WbGif;
use vendor\pclzip\PclZip;
use bin\media\inc\PhpThumbFactory;
use App\Utils\ImageSizeCalc;

//use Verot\Upload\Upload;
//use Zebra_Image\ZebraImage; //

    $sAddonPath   = str_replace('\\','/',__DIR__).'/';
    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = basename($sModulesPath);
    $sAddonName   = basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    if (!defined('SYSTEM_RUN')) {require($sAppPath.'config.php');}

        // suppress to print the header
    $admin = new \admin('Media', 'media_upload', false);

    $oReg    = WbAdaptor::getInstance();
    $oApp    = $oReg->getApplication();
    $oTrans  = $oReg->getTranslate();
    $sDomain = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);

    ini_set('upload_max_filesize', '400M');
    ini_set('post_max_size', '440M');
    ini_set('memory_limit', '512M');
    ini_set('zlib.output_compression','1');
    ini_set('zlib.output_compression_level','9');
/* */
    PreCheck::increaseMemory('512M');
    $iMaxSize = PRECHECK::convertToByte('upload_max_filesize');
    $sMaxSize = PreCheck::convertByteToUnit($iMaxSize);
    $UploadOldMaxFilesize= ini_set('upload_max_filesize','512M');
    $UploadMaxFilesize = ini_get('upload_max_filesize');

    $iPostMaxSize = PRECHECK::convertToByte('post_max_size');
    $sPostMaxSize = PRECHECK::convertByteToUnit($iPostMaxSize);
    //$sPostMaxSize = PRECHECK::getPostMaxSize();
// Include the PclZip constant file
    if (!\defined('PCLZIP_ERR_NO_ERROR')) { require($sAppPath.'include/pclzip/Constants.php'); }

try {

    $aOptions = ['options' => [ 'flags' => FILTER_NULL_ON_FAILURE]];
    $sTemp = ($oReg->Request->getParam('upload_target',FILTER_SANITIZE_FULL_SPECIAL_CHARS,$aOptions));
    $bOverwrite  = ($oReg->Request->getParam('overwrite',FILTER_VALIDATE_BOOL,$aOptions));
    $bDeleteZip  = ($oReg->Request->issetParam('delzip'));
    $MaxFileSize = ($oReg->Request->getParam('max_file_size',FILTER_SANITIZE_NUMBER_INT) ?? $UploadMaxFilesize);
    $MaxPostSize = ($oReg->Request->getParam('max_post_size',FILTER_SANITIZE_NUMBER_INT) ?? $iPostMaxSize);
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sTemp));
    if (empty($sTemp)) {
        $sBacklinkUrl  = $oReg->AcpUrl.''.'media/index.php?dir=';
        $sMessage = \sprintf($oTrans->MESSAGE_UPLOAD_ERR_POST_MAX_SIZE."\n",get_cfg_var('post_max_size'));
        throw new \Exception ($sMessage);
    }
    else
    {
        $sTarget       = \str_replace($oReg->MediaDir,'', $sTemp);
        $sBacklinkUrl  =  $oReg->AcpUrl.''.'media/index.php?dir='.$sTemp;
        $sAddonBackUrl =  $oReg->AcpUrl.''.'media/index.php?dir='.$sTemp;
        // Create relative path of the target location for the file
        $aTmpFiles = ($_FILES['file'] ?? []);
        if (empty($aTmpFiles)) {
            $sMessage = \sprintf($oTrans->MESSAGE_UPLOAD_ERR_POST_MAX_SIZE."\n",get_cfg_var('post_max_size'));
            throw new \Exception ($sMessage);
        }
    }
/* */
    if (!\bin\SecureTokens::checkFTAN ()) {
        throw new \Exception ($oTrans->MESSAGE_GENERIC_SECURITY_ACCESS);
    }

    if (!\function_exists('__unserialize')){require(__DIR__.'/parameters.php');}

    $aMessage     = [];
    $aFiles       = [];
    $aFilesFailed = [];
    $pathsettings = [];

    $count           = 0;
    $sum_dirs        = 0;
    $sum_files       = 0;
    $iFolder         = 0;
    $iFiles          = 0;
    $good_uploads    = 0;
    $iTotaluploads   = 0;
    $iUploadedsFiles = 0;

    $sAllowedFileTypes  = 'bmp|gif|jpg|ico|jpeg|png|webp';
    // get from settings and add to forbidden list
    $forbidden_file_types  = \preg_replace( '/\s*[,;\|#]\s*/','|',RENAME_FILES_ON_UPLOAD);

    // Get the current dir   .str_replace(MEDIA_DIRECTORY,'',$directory)
    $directory = (($sTarget === '/') ?  '' : $sTarget);

    $resizepath    = trim(\str_replace(['/',' '],'_', $sTarget),'_');
    $sParentPath   = $resizepath;

    $sMediaDir  = ($oReg->MediaDir);
    $sMedia     = \basename($sMediaDir); //
    $resizepath = (($resizepath=='/')||empty($resizepath) ? $sMedia : $resizepath);

    $relative      = ''.trim($sTarget,'/').''; //$sMediaAbsPath.
    $bIncludeMedia = \stristr($sMedia,$relative) >0;
    $sMediaAbsPath = str_replace('\\','/',$oReg->AppPath.($bIncludeMedia ? '' : $oReg->MediaDir)).''; //

/*
    // Check to see if target contains ../
    if (!check_media_path($relative, true)) {
        throw new \Exception ($oTrans->MESSAGE_MEDIA_TARGET_DOT_DOT_SLASH);
    }
*/
/* ------------------------------  ------------------------------------------ */
    $jpegQuality    = $database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_compress\' ');
    //$aOptions = ['options' => ['filter' => FILTER_VALIDATE_BOOL, 'flags' => FILTER_NULL_ON_FAILURE]];
    $aOptions = ['options' => [ 'flags' => FILTER_NULL_ON_FAILURE]];
    //$bDoResize   = $oReg->Request->getParam('resize_up',\FILTER_VALIDATE_BOOL,\FILTER_NULL_ON_FAILURE);
    $sMediaSettings = $database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'mediasettings\' ');
    $pathsettings   = getPathsettings($sMediaSettings, $oReg);

    if (!isset($pathsettings['global'])){
        $pathsettings['global'] =
          ['show_thumbs' => 0,
          'admin_only' => 1,
          'resize_up' => 1,
          ];
    }
    $bDoResize   = (bool)\filter_var($pathsettings['global']['resize_up'],\FILTER_VALIDATE_BOOL,\FILTER_NULL_ON_FAILURE);

// checking and setting given folder size
        $width  = 0;
        $height = 0;
        $iTargetWidth   = 0;
        $iTargetHeight  = 0;
        $aDir = explode('/',$directory);
        $sMediaDir = trim($oReg->MediaDir,'/');
        //mediadir without trailing slash is the first parent
        $aDir[0] =  (empty($aDir[0]) ? $sMediaDir : $aDir[0]);

        if (true === $bDoResize) {
            $width  = (int)$database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_width\' ');
            $height = (int)$database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_height\' ');
            if (($width  !== 0)) {$iTargetWidth  = $width;}
            if (($height !== 0)) {$iTargetHeight = $height;}
            //inialize the parent path to check for size values
            $sPath   = $sMediaDir;
            $sTarget = '';
            $aSize   = ['width'=>0,'height'=>0];
            foreach ($aDir as $index => $item) {
              $item = trim(\str_replace(['/',' ','.'],'_',$item),'_');
              // check for virtual mediadir else the other folder
              if (trim($item,'/') !== $sMediaDir){
                  $sPath  .= (trim($item,'/')).'_';
              }
              //check if there is a given size if null set parent size
              if (isset($pathsettings[trim($sPath,'_')])) {
                  $aSize['width']  = ($pathsettings[trim($sPath,'_')]['width']  ?? $iTargetWidth);
                  $aSize['height'] = ($pathsettings[trim($sPath,'_')]['height'] ?? $iTargetHeight);
              }
              if ($sPath===$sMediaDir){$sPath = '';}
//              $sTarget = '';
              if (((int)($aSize['width'])  !== 0)) {$iTargetWidth  = (int)$aSize['width'];}
              if (((int)($aSize['height']) !== 0)) {$iTargetHeight = (int)$aSize['height'];}
        }//foreach
    }

    $aUploadOptions = [
        'resizeUp'              => $bDoResize,
        'jpegQuality'           => $jpegQuality ?? 85,
        'correctPermissions'    => false,
        'preserveAlpha'         => true,
        'alphaMaskColor'        => [255, 255, 255],
        'preserveTransparency'  => true,
        'transparencyMaskColor' => [0, 0, 0],
        'interlace'             => null
    ];

        $aDebugArray = [
          //'global' => $pathsettings['global'],
          //'getimagesize' => $aImg,
          //'ImageInfo' => $aImageInfo,
          //'bIsAlphaPng' => ($bIsAlphaPng ? 'true' :'false'),
          'resizeUp' => ($aUploadOptions['resizeUp'] ? 'true' : 'false'),
          'global width' => ($width ?? 'not set'),
          'global height' => ($height ?? 'not set'),
          'media' => $sMediaDir,
          'media width'  => ($pathsettings[$sMediaDir]['width']  ?? 'not set'),
          'media height' => ($pathsettings[$sMediaDir]['height'] ?? 'not set'),
          'dir' => $directory,
          'aDir' => $aDir,
          'folder' => $resizepath,
          'folder width' => $iTargetWidth,//$pathsettings[$resizepath]['width'],
          'folder height' => $iTargetHeight,//$pathsettings[$resizepath]['height'],
        ];

    $resizeImages =  (function (string $sSourceFile, $ext) use ($resizepath,$iTargetWidth,$iTargetHeight,$aUploadOptions,$sAllowedFileTypes)
    {
        $oReg    = WbAdaptor::getInstance();
        $oApp    = $oReg->getApplication();
        $oTrans  = $oReg->getTranslate();
        $sDomain = $oApp->getDirNamespace(__DIR__);
        $oTrans->enableAddon($sDomain);
        if (empty($ext)){$ext = PreCheck::getExtension($sSourceFile);}
        $sFilename = (basename($sSourceFile));
        $bValidFile = (($sFilename !== '') && \preg_match('/' . $sAllowedFileTypes . '$/i', $ext) && !(WbGif::isAnimatet($sSourceFile)));
        if (\is_readable($sSourceFile) && $bValidFile ) {
        // allow resizing image
            if (false !== ($aImg = \getimagesize($sSourceFile))) {
                $iSourceWidth  = $aImg[0];
                $iSourceHeight = $aImg[1];
                $is_alpha_png = false;
                $fRatio = $aImg[0] / $aImg[1];
                if ($aImg['mime'] === 'image/png'){
/** determines whether the PNG image contains alpha or not:
  * The color type of PNG image is stored at byte offset 25. Possible values of that 25'th byte is:
  * 0 - greyscale
  * 2 - RGB
  * 3 - RGB with palette
  * 4 - greyscale + alpha
  * 6 - RGB + alpha
  */
                    $is_alpha_png = PNGType::usesTransparency($sSourceFile);
                }
/* don't resize'
                  if (false === $aUploadOptions['resizeUp'] || $is_alpha_png) { // &&
                      $iTargetWidth  = $iSourceWidth;
                      $iTargetHeight = $iSourceHeight;
                  }
*/
            }//end getimagesize
            $bIsAlphaPng  = $is_alpha_png;
            $bCanResize   = false;
            $bResizeSmaller   = false;

            if ($iTargetWidth === 0 && $iTargetHeight > 0) {
                $iTargetWidth = (int)(\round($iTargetHeight * $fRatio));
            }elseif ($iTargetWidth > 0 && $iTargetHeight === 0) {
                $iTargetHeight = (int)(\round($iTargetWidth / $fRatio));
            }elseif ($iTargetWidth === 0 && $iTargetHeight === 0) {
                $iTargetWidth  = $iSourceWidth;
                $iTargetHeight = $iSourceHeight;
            } else {
                $iTargetHeight = (int)(\round($iTargetWidth / $fRatio));
            }

            $bResizeSmaller = (((int)$iTargetWidth < (int)$iSourceWidth) || ((int)$iTargetHeight < (int)$iSourceHeight));

            $aDebugArray = [
              'sSourceFile' => $sSourceFile,
              'ext' => $ext,
              'image width'  => $iSourceWidth,
              'image height' => $iSourceHeight,
              'fRatio' => $fRatio,
              'getimagesize' => $aImg,
              'bIsAlphaPng' => ($bIsAlphaPng ? 'true' :'false'),
              'resizeUp' => ($aUploadOptions['resizeUp'] ? 'true' : 'false'),
              '$bValidFile' => ($bValidFile ? 'true' :'false'),
              'folder' => $resizepath,
              'folder width'  => $iTargetWidth,//$pathsettings[$resizepath]['width'],
              'folder height' => $iTargetHeight,//$pathsettings[$resizepath]['height'],
            ];

            if (($aUploadOptions['resizeUp']) && (!$is_alpha_png)) {  //
                $bCanResize   = true;
            }
            elseif($aUploadOptions['resizeUp'] && $is_alpha_png && $bResizeSmaller){
                $aDebugSizes = [
                    '$iSourceWidth'=>$iSourceWidth,
                    '$iSourceHeight'=>$iSourceHeight,
                    '$iTargetWidth'=>$iTargetWidth,
                    '$iTargetHeight'=>$iTargetHeight
                ];
                $bCanResize   = true;
            }
            if ($bCanResize === true){
                $rimg = PhpThumbFactory::create($sSourceFile,$aUploadOptions);
                $rimg->resize((int)$iTargetWidth,(int)$iTargetHeight,$sSourceFile);
                $rimg->save($sSourceFile);
            }
        } // end of $bValidFile
    });
/* ---------------------------------------------------------------------------------- */
    // Loop through the files
    $aTmpFiles = ($_FILES['file'] ?? []);
    if (empty($aTmpFiles)) {
        $sMessage = \sprintf($oTrans->MESSAGE_UPLOAD_ERR_POST_MAX_SIZE."\n",$sPostMaxSize);
        throw new \Exception ($sMessage);
    }

    //  prepare file array for upload handling
    $aTmpLoop  = $aTmpFiles['error'];
    $aFiles['file'] = [];
    $aErrorFiles = [];
    $key=0;
    foreach ($aTmpLoop as $index=>$item)
    {
        if (($item===\UPLOAD_ERR_OK)) {
            $aFiles['file'][$key]['name'] = media_filename($aTmpFiles['name'][$index]);
            $aFiles['file'][$key]['type'] = $aTmpFiles['type'][$index];
            $aFiles['file'][$key]['size'] = $aTmpFiles['size'][$index];
            $aFiles['file'][$key]['tmp_name'] = $aTmpFiles['tmp_name'][$index];
            $aFiles['file'][$key]['error'] = $item;

            $sNewFilename = ($sMediaAbsPath).$relative.'/'.$aFiles['file'][$key]['name'];  //
            $bFileExists = \is_readable($sNewFilename) && !$bOverwrite;

            if ($bFileExists){
//echo nl2br(sprintf("<div class='w3-border w3-padding w3-margin-left'>[%04d] sNewFilename =  %s</div>\n",__LINE__,$sNewFilename));
                $sUploadedFile = $aTmpFiles['name'][$index];
                $sMessage = \sprintf(($oTrans->MESSAGE_UPLOAD_ERR_FILE_EXISTS),__LINE__,$aTmpFiles['name'][$index]);
                $aMessage[$sUploadedFile] = $sMessage;
                $aFilesFailed[] = $relative.'/'.$sUploadedFile;
//                \trigger_error($sMessage, E_USER_NOTICE);
            }
            //$aFiles['file'][$key]['name'] = media_filename($aTmpFiles['name'][$index]);
            $iUploadedsFiles++;
        } elseif (in_array($item,[1,2,3,6,7,8])){
//            $aErrorFiles[] = $aTmpFiles['error'][$key].' File '.$aTmpFiles['name'][$key];
              switch ($item) {
                  case \UPLOAD_ERR_INI_SIZE:
                      $aErrorFiles[] = sprintf($errorTypes[$item], $aTmpFiles['name'][$key], $UploadMaxFilesize);
                      break;
                  case \UPLOAD_ERR_FORM_SIZE:
                      $aErrorFiles[] = sprintf($errorTypes[$item], $aTmpFiles['name'][$key], $MaxFileSize);
                      break;
                  case \UPLOAD_ERR_PARTIAL:
                  case \UPLOAD_ERR_CANT_WRITE:
                  case \UPLOAD_ERR_EXTENSION:
                      $aErrorFiles[] = sprintf($errorTypes[$item], $aTmpFiles['name'][$key], '');
                      break;
                  case \UPLOAD_ERR_NO_TMP_DIR:
                      $aErrorFiles[] = sprintf($errorTypes[$item], '', '');
                      break;
              }// end switch
        }
        $key++;
    } //foreach $aTmpLoop (error) prepare $aFiles['file']

    foreach ($aFiles['file'] as $index=>$item)
    {
        if (($item['error']==0)) {
            $relative = trim($relative,'/');
            $sOrgFilename = $sMediaAbsPath.$relative.'/'.media_filename($aTmpFiles['name'][$index]);//
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sMediaAbsPath.$relative));
            // If file was upload to tmp
            if (!empty($item['name']))
            {
                //$sNewFilename = $sMediaAbsPath.$relative.'/'.$item['name'];
                $sNewFilename = str_replace('//','/',$sMediaAbsPath.$relative.'/'.$item['name']); //

//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sMediaAbsPath.$relative.'/'.$item['name']));
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sNewFilename));
                $info      = \pathinfo($sNewFilename);
                $ext       = $info['extension'] ?? '';
                //$pathsettings = getPathsettings($sMediaSettings, $oReg);
                if (($sNewFilename) && (\substr($sNewFilename, 0, 1) !== '.') && !\preg_match("/".$forbidden_file_types."$/i", $ext) )
                {
                    $iTotaluploads++;
//    \trigger_error(sprintf('[%d] Sanitize directory %s',__LINE__, $relative.$filename), E_USER_NOTICE);
                    // Move to relative path (in media folder)
/*
print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
print_r( [$bDoResize,$sNewFilename,$sOrgFilename,$ext,$resizepath,$pathsettings[$resizepath]] ); print '</pre>'; \flush (); //  sleep(10); die();
*/
                    if (\is_readable($sNewFilename) && ($bOverwrite === true)) {
                        //$sTmpName = $item['tmp_name'];
                        if (\move_uploaded_file($item['tmp_name'], $sNewFilename)) {
                            $good_uploads++;
                            $iFiles++;
                            // Chmod the uploaded file
                            change_mode($sNewFilename);
                            $resizeImages($sNewFilename, $ext);
                        }
                    } elseif (!\is_readable($sNewFilename)) {
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sNewFilename));
                        if (\move_uploaded_file($item['tmp_name'], $sNewFilename)) {
                          // $sNewFilename = str_replace('//','/',$sNewFilename);
                            $good_uploads++;
                            $iFiles++;
                            // Chmod the uploaded file
                            change_mode($sNewFilename);
//echo \nl2br(\sprintf("---- [%04d] resizeImages %s \n",__LINE__,'!\is_readable'));
                            $resizeImages($sNewFilename, $ext);
                        } else {
                          $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NO_FILE_UPLOADED,$sNewFilename, $iUploadedsFiles );
                          throw new \Exception ($sMessage);
                        }
                    } //!\is_readable($sNewFilename)

                    // store file name of first file for possible unzip action
                    if (($count == 0)) {
                        $sZipFile = ($sOrgFilename);
                        $sParentPath = ($sMediaDir );
                        $aDebugArray = [
                          'count' => $count,
                          'sOrgFilename' => $sOrgFilename,
                          'sNewFilename' => $sNewFilename,
                          'sZipFile' => $sZipFile,
                          'bDoNotResize' => $bDoResize,
                          'ext' => $ext,
                          'sParentPath' => $sParentPath,
                          //'resizepath' => $resizepath,
                          //'pathsettings' => $pathsettings[$resizepath],
                          'unzip' => $oReg->Request->issetParam('unzip')&& (isset($sZipFile) && is_readable($sZipFile))
                        ];
/*
print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
print_r($aDebugArray); print '</pre>'; \flush (); //  sleep(10); die();
*/
                    }
                    $count++;
                } else {
                    $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NAME_FILETYPE,'',$sNewFilename, $index);
                    throw new \Exception ($sMessage);
                }
            $count++;
            } // not empty
        } // error == 0

    } //  end foreach $aFiles['file']

    if (((int)$iFiles === 0) && ((int)$iUploadedsFiles===0)) {
        $sErrMsg  = PreCheck::xnl2br($aErrorFiles);
        $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NO_FILE_UPLOADED."\n".$sErrMsg,$iUploadedsFiles);
        throw new \Exception ($sMessage);
    } elseif (((int)$iFiles !== (int)$iUploadedsFiles) && (count($aFilesFailed) > 0)) {
        $sErrMsg = PreCheck::xnl2br($aErrorFiles);
        $sTmp = '<br><ol><li>'.\implode('<li>', $aFilesFailed).'</li></ol>';
        $sMessage = \sprintf(($oTrans->MESSAGE_UPLOAD_ERR_FILE_EXISTS)."\n".$sErrMsg."\n",$sTmp);
        throw new \Exception ($sMessage);
    }
/* ------------------------------------------------------------------------------------------- */
// BEGIN Zip calls
/* ------------------------------------------------------------------------------------------- */
    // If the user chose to unzip the first file, unzip into the current folder
    if ($oReg->Request->issetParam('unzip') && (isset($sZipFile) && is_readable($sZipFile)) )
    {
/*
print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
print_r( [$sZipFile,$sNewFilename] ); print '</pre>'; \flush (); //  sleep(10); die();
*/
    /*
     * Callback function to skip files in black-list
        $p_header['filename'] = media_filename($p_header['filename']);
     */
    function pclzipCheckValidFile($p_event, &$p_header)
    {
        global $forbidden_file_types;
// ---- all files are skiped
        $bRetVal = false;
        $aMatches= [];
// Check for potentially malicious files
        $info = \pathinfo($p_header['filename']);
        $ext = isset($info['extension']) ? $info['extension'] : '';
        $sBasename = ($info['basename']);
        $dots = (\substr($sBasename, 0, 1) == '.');
        if (($dots !== '.')) {
            $bRetVal = !\preg_match('#^.*?\.('.$forbidden_file_types.')?$#is', $p_header['filename'], $aMatches);
        }
        return (int)$bRetVal;
    }
/* -------------------------------------------------------------------------- */
    function callbackPostExtract($p_event, &$p_header)
    {
         return 1;
    }
/* -------------------------------------------------------------------------- */
//     '/'.$forbidden_file_types.'$/i'
    $forbidden_file_types  = \preg_replace( '/\s*[,;\|#]\s*/','|',RENAME_FILES_ON_UPLOAD);
    // Required to unzip file.
    $archive = new PclZip($sZipFile);
    if (($list = $archive->extract(
        PCLZIP_OPT_PATH, $sMediaAbsPath.$relative
        ,PCLZIP_OPT_EXTRACT_DIR_RESTRICTION, str_replace('//','/',$sMediaAbsPath)
        ,PCLZIP_CB_PRE_EXTRACT, 'pclzipCheckValidFile'
        ,PCLZIP_CB_POST_EXTRACT, 'callbackPostExtract'
        ,PCLZIP_OPT_REPLACE_NEWER
    )) === 0) {
       throw new RuntimeException('Could not extract zip file [PclZip].');
    }

/*
print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
print_r( [$list] ); print '</pre>'; \flush (); //  sleep(10); die();
*/
        $iFiles = 0;
        $iFolder = 0;
        $good_uploads = (\is_array($list) ? \sizeof($list) : 0);
        if( $archive->errorCode() !== 0 ) {
            // error while trying to extract the archive (most likely wrong format)
            $admin->print_error('UNABLE TO UNZIP FILE' . $archive->errorInfo(true));
        } else {
            // resize files
            $sArchivFile = '';
            for( $x = 0; $x < $good_uploads; $x++)
            {
                if ($list[$x]['status'] == 'skipped'){continue;}
                $sArchivFile = ($list[$x]['filename']);
//echo sprintf('[%d] %s <br />Folder %d / Dateien %d <br />',__LINE__, $sArchivFile, $iFolder,$iFiles);
                $info = \pathinfo($sArchivFile);
                $ext = isset($info['extension']) ? $info['extension'] : '';

                $sTmp =  \str_replace(\str_replace('\\','/',$oReg->AppPath.$oReg->MediaDir),'',$sArchivFile);
//echo \nl2br(\sprintf("\n---- [%04d] %s \n",__LINE__,$sTmp));
                $bValidFile = ((!empty($sArchivFile)) && \preg_match('/' . $sAllowedFileTypes . '$/i', $ext) && !(WbGif::isAnimatet($sArchivFile)));
/* seems that is not needed
                $sChildPath = '_'.(\trim((\is_dir($sTmp) ? $sTmp : \dirname($sTmp)),'/'));
                $sChildPath = \str_replace(['/',' '],'_',$sChildPath);
                $bChildIsEmpty = (isset($pathsettings[$sChildPath]) && empty($pathsettings[$sChildPath])) || !isset($pathsettings[$sChildPath]);
                $resizepath = ($bChildIsEmpty ? $sParentPath : $sChildPath);
echo sprintf('[%d] %s',__LINE__,$resizepath.'/'.\basename($sArchivFile)).'<br />';
*/
// count folder and files
                if (($list[$x]['folder']==1)) {$iFolder++;} else {}
                if (($list[$x]['status'] == 'newer_exist') && $bOverwrite && $bValidFile){
                    $iFiles++;
                    $resizeImages($sArchivFile,$ext);
                } elseif (($list[$x]['status'] == 'ok') && $bValidFile){
                    $iFiles++;
                    $resizeImages($sArchivFile,$ext);
                }
/*
print '<pre  class="mod-pre rounded">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.\basename(__FILE__).'</span>  line: '.__LINE__.' -> <br />';
\print_r( $list[$x] ); print '</pre>'.PHP_EOL; \flush (); //  ob_flush();;sleep(10); die();
echo sprintf('[%d] %s <br />Breite %d px x Höhe %d px<br />',__LINE__, $sArchivFile, $pathsettings[$resizepath]['width'],$pathsettings[$resizepath]['height']);
echo sprintf('[%d] %s <br />Breite %d px x Höhe %d px<br />',__LINE__, $sArchivFile, $width,$height);

echo sprintf('[%d] resizeUp %s <br />Breite %d px x Höhe %d px<br />',__LINE__, (int)$this->options['resizeUp'], $maxWidth,$maxHeight);
echo sprintf('[%d] resizeUp %s <br />Breite %d px x Höhe %d px<br />',__LINE__, (int)$this->options['resizeUp'], $this->maxWidth,$this->maxHeight);
echo sprintf('[%d] resizeUp %s <br />Breite %d px x Höhe %d px<br />',__LINE__, (int)$this->options['resizeUp'], $this->maxWidth,$this->maxHeight);
*/
           }  // end for $list[$x]
        }
        if ($oReg->Request->issetParam('delzip') && is_readable($sZipFile)) { unlink($sZipFile); }
        unset($list);
    }    // end extract archiv
/* ------------------------------------------------------------------------------------------- */
// END Zip calls
/* ------------------------------------------------------------------------------------------- */
// single upload success

        if (($iFiles == 1)) {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sMessage = (!($oReg->Request->issetParam('unzip'))
            ? \sprintf($oTrans->MESSAGE_MEDIA_SINGLE_UPLOADED."\n".$sErrMsg,$iFiles)
            : \sprintf($oTrans->MESSAGE_MEDIA_ZIP_UPLOADED."\n".$sErrMsg,$iFolder,$iFiles));
        } elseif(($iFiles > 1)) {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sMessage = (!($oReg->Request->issetParam('unzip'))
            ? \sprintf($oTrans->MESSAGE_MEDIA_MULTI_UPLOADED."\n".$sErrMsg,$iFiles)
            : \sprintf($oTrans->MESSAGE_MEDIA_ZIP_UPLOADED."\n".$sErrMsg,$iFolder,$iFiles));
        } elseif (($iFiles !== $iUploadedsFiles) && (count($aFilesFailed) > 0)) {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sTmp = '<br><ol><li>'.\implode('<li>', $aFilesFailed).'</li></ol>';
            $sMessage = \sprintf(($oTrans->MESSAGE_UPLOAD_ERR_FILE_EXISTS)."\n".$sErrMsg."\n",__LINE__,$sTmp);
            throw new \Exception ($sMessage);
        } else {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NO_FILE_UPLOADED."\n".$sErrMsg,$iFiles, $iTotaluploads );
            throw new \Exception ($sMessage);
        }
        $admin->print_header();
        $admin->print_success($sMessage,$sAddonBackUrl);

    } catch (\Exception $ex) {
        $admin->print_header();
        $sAddonBackUrl = ($sAddonBackUrl ?? $oReg->AcpUrl.''.'media/index.php?dir=');
        $sErrMsg = PreCheck::xnl2br(\sprintf('[%d] %s', $ex->getLine(), $ex->getMessage()));
        $admin->print_error ($sErrMsg, $sAddonBackUrl);
        exit;
}

// Print admin
$admin->print_footer();

