<?php
/**
 *
 * @category        modules
 * @package         captcha_control
 * @author          WebsiteBaker Project
 * @copyright       Ryan Djurovich
 * @copyright       WebsiteBaker Org. e.V.
 * @link            https://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.3
 * @requirements    PHP 5.6 and higher
 * @version         $Id: install.php 311 2019-03-27 23:37:34Z Luisehahne $
 * @filesource      $HeadURL: svn://isteam.dynxs.de/wb/2.12.x/branches/main/modules/captcha_control/install.php $
 * @lastmodified    $Date: 2019-03-28 00:37:34 +0100 (Do, 28. Mrz 2019) $
 *
 */

use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck,msgQueue};
use src\Security\{CsfrTokens,Randomizer};
use src\Interfaces\Requester;
use bin\Requester\HttpRequester;

if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; flush(); exit; }

    $msg = [];
    $sErrorMsg = null;
    $sAddonPath = \str_replace(DIRECTORY_SEPARATOR, '/', __DIR__);
    $sAddonName = basename($sAddonPath);
// check if upgrade startet by upgrade-script to echo a message
    $globalStarted = preg_match('/upgrade\-script\.php$/', $_SERVER["SCRIPT_NAME"]);
    $sWbVersion = ($globalStarted && defined('VERSION') ? VERSION : WB_VERSION);
    $sModulePlatform = PreCheck::getAddonVariable($sAddonName,'platform');
    if (version_compare($sWbVersion, $sModulePlatform, '<')){
        $msg[] = $sErrorMsg = sprintf('It is not possible to install from WebsiteBaker Versions before %s',$sModulePlatform);
        if ($globalStarted){
            echo $sErrorMsg;
        }else{
            throw new \Exception ($sErrorMsg);
        }
    } else {
        // create tables from sql dump file
//        $oReg->Db->addReplacement('XTABLE_ENGINE','Engine=MyISAM CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
//        $oReg->Db->addReplacement('XFIELD_COLLATION','COLLATE utf8mb4_unicode_ci');
        if (is_readable($sAddonPath.'/install-struct.sql.php')) {
            $oReg->Db->SqlImport($sAddonPath.'/install-struct.sql.php', TABLE_PREFIX, 'install' );
        }
        if (is_readable($sAddonPath.'/install-data.sql.php')) {
            $oReg->Db->SqlImport($sAddonPath.'/install-data.sql.php', TABLE_PREFIX, 'install' );
        }
        if ($oReg->Db->is_error()){
            $msg[] = 'captcha_control::'.$oReg->Db->get_error();
        }
    }

