<?php
/**
 *
 * @category        admin
 * @package         media
 * @author          Ryan Djurovich, WebsiteBaker Project
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.10.1
 * @requirements    PHP 5.3.6 and higher
 * @version         $Id: parameters.php 145 2025-07-20 10:00:06Z Uwe $
 * @filesource      $HeadURL: svn://isteam.dynxs.de/wb/2.12.x/branches/main/admin/media/parameters.php $
 * @lastmodified    $Date: 2025-07-20 12:00:06 +0200 (So, 20 Jul 2025) $
 *
 */

// Must include code to stop this file being access directly
if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}

    function getPathsettings($sMediaSettings, bin\WbAdaptor $oReg)
    {
        //global $oReg;
        $admin = new \admin('Media', 'media', false);
        $aRetval = [];
        $aDirs    = directory_list($oReg->AppPath.$oReg->MediaDir);
        //$dirs    = directory_list(WB_PATH.MEDIA_DIRECTORY);
        $sMediaDir = trim($oReg->MediaDir,'/');
        \array_unshift($aDirs, $oReg->AppPath.$oReg->MediaDir);
        $aDirs = \array_unique ($aDirs);
        foreach($aDirs as $name) {
            $sTmp = \ltrim(\str_replace('\\','/',str_replace($oReg->AppPath, '', $name)),'/');
//            $sTmp = str_replace(MEDIA_DIRECTORY,'',$sTmp);
            $r    = trim(\str_replace(['/',' ','.'],'_',$sTmp),'_');
//    \trigger_error(\sprintf('[%d] Sanitize directory %s',__LINE__, $r), E_USER_NOTICE);
// get serialize from settings
            $aPathSettings = __unserialize($sMediaSettings);
// set all pathsettings to default
            $pathsettings[$r]['width'] = 0;
            $pathsettings[$r]['height']= 0;
        }  // end foreach
// Replaces elements from passed arrays into the first array
        $aRetval = \array_merge($pathsettings,$aPathSettings);
/*
print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
print_r( $aRetval ); print '</pre>'; \flush (); //  sleep(10); die();
*/
        return $aRetval;
    }

        function getCustomPathsettings($sMediaSettings, bin\WbAdaptor $oReg) {
            $admin = new \admin('Media', 'media', false);
            $aDirs = directory_list($oReg->AppPath . $oReg->MediaDir);
            $sMediaDir = trim($oReg->MediaDir, '/');
            \array_unshift($aDirs, $oReg->AppPath . $oReg->MediaDir);
            $aDirs = \array_unique($aDirs);

            // Hole die gespeicherten Einstellungen
            $aPathSettings = my_custom_unserialize($sMediaSettings);

            // Default-Werte für alle Ordner initialisieren
            $pathsettings = [];
            foreach ($aDirs as $name) {
                $sTmp = \ltrim(\str_replace('\\', '/', str_replace($oReg->AppPath, '', $name)), '/');
                $r = trim(str_replace(['/', ' ', '.'], '_', $sTmp), '_');
                $pathsettings[$r] = ['width' => 0, 'height' => 0];
            }

            // Werte aus den gespeicherten Einstellungen überschreiben
            foreach ($aPathSettings as $key => $value) {
                $pathsettings[$key] = $value;
            }

            return $pathsettings;
        }

function __unserialize($sObject) {  // found in php manual :-)
    $aRetval = [];
    $sObject = stripslashes($sObject);
        if ($sObject){
            $_ret = preg_replace_callback(
                        '!s:(\d+):"(.*?)";!',
                        function($matches) {return 's:'.strlen($matches[2]).':"'.$matches[2].'";';},
                        $sObject
                     );
            if ($_ret) {$aRetval = @\unserialize($_ret);}
        }
        return $aRetval;
    }
    
    function my_custom_unserialize($sObject) {
        $aRetval = [];
        $sObject = stripslashes($sObject);
        if ($sObject){
            $_ret = preg_replace_callback(
                '!s:(\d+):"(.*?)";!',
                function($matches) {
                    return 's:'.strlen($matches[2]).':"'.$matches[2].'";';
                },
                $sObject
            );
            if ($_ret) {
                $aRetval = @unserialize($_ret);
            }
        }
        return $aRetval;
    }

/*
    $pathsettings = [];
    $sqlMedia = 'SELECT `value` FROM `'.TABLE_PREFIX.'settings` '
              . 'WHERE `name` = \'mediasettings\' '
              . '';
    if (!($sMediaSettings = $database->get_one($sqlMedia))){
    } else {
        $pathsettings = __unserialize($sMediaSettings);
    }
*/
