<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of admin/pages/index.php
 *
 * @package      Core
 * @copyright    Manuela v.d.Decken <manuela@isteam.de>
 * @author       Manuela v.d.Decken <manuela@isteam.de>
 * @license      GNU General Public License 2.0
 * @version      2.0.1
 * @revision     $Id: index.php 145 2025-07-20 10:00:06Z Uwe $
 * @since        File available since 04.10.2017
 * @deprecated   no
 * @description  xxx
 */
declare(strict_types = 1);
//declare(encoding = 'UTF-8');

//namespace ;

use bin\{WbAdaptor,SecureTokens,Sanitize};
use vendor\phplib\Template;
use App\Utils\Helpers;


    if (!defined('SYSTEM_RUN') ){ require  dirname(__DIR__,2).'/config.php'; }
    $admin = new \admin('Pages', 'pages');
/* -------------------------------------------------------- */
    $oReg     = WbAdaptor::getInstance();
    $oRequest = $oReg->getRequester();
    $aVarnames = $oRequest->getParamNames();
    foreach ($aVarnames as $sName) {
        $aRequestVars[$sName] = $oReg->Request->getParam($sName);
    }
/* -------------------------------------------------------- */
    $sCallingScript = $oReg->Request->getServerVar('SCRIPT_NAME');
/* -------------------------------------------------------- */
    $oApp     = $oReg->getApplication();
    $oDb      = $oReg->getDatabase();
    $oTrans   = $oReg->getTranslate();
    $sDomain  = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);
    $isAuth   = $oApp->is_authenticated();

/* -------------------------------------------------------- */

    $sAbsAddonPath = str_replace('\\','/',__DIR__).'/';
/*
SELECT  COUNT(*) `iNumRows` FROM `wb_pages` `x`

    if (\is_readable($sAbsAddonPath.'languages/EN.php')) {require($sAbsAddonPath.'/languages/EN.php');}
    if (\is_readable($sAbsAddonPath.'languages/'.DEFAULT_LANGUAGE.'.php')) {require($sAbsAddonPath.'/languages/'.DEFAULT_LANGUAGE.'.php');}
    if (\is_readable($sAbsAddonPath.'languages/'.LANGUAGE.'.php')) {require($sAbsAddonPath.'/languages/'.LANGUAGE.'.php');}
*/
// fixes A URI contains impermissible characters or quotes around the URI are not closed.
//    $MESSAGE['PAGES_DELETE_CONFIRM'] = ($MESSAGE['PAGES_DELETE_CONFIRM']);

/**
 * set_node()
 *
 * @return
 */
    function set_node ($parent,& $par)
    {
        $retval = '';
        if ($par['num_subs'] )
        {
            $retval .= "\n".'<ul id="p'.$parent.'"';
            if ($parent != 0)
            {
                $retval .= ' class="page_list draggable"';
                if (isset ($_COOKIE['p'.$parent]) && $_COOKIE['p'.$parent] == '1')
                {
                     $retval .= ' style="display:block"';
                }
            } else {
                $retval .= ' class="draggable"';
            }
            $retval .= '>';
        }
        $retval .= ''."\n";
        return $retval;
    } // end of function set_node

/**
 * make_list()
 *
 * @return
 */
    function make_list($parent = 0, $editable_pages = 0) {
        //Get objects and vars from outside this function
        //global $template,$admin, $database;
        //global  $TEXT, $MESSAGE, $HEADING,
        global $par;
// settings needs a admin object
        $oReg     = WbAdaptor::getInstance();
        $oDb      = $oReg->getDatabase();
        $oTrans   = $oReg->getTranslate();
        $oRequest = $oReg->getRequester();
        $oApp     = $oReg->getApplication();
        $isAuth   = $oApp->is_authenticated();

        echo set_node ($parent,$par);

        // Get page list from database
        $oSqlMode = new \SqlMode($oDb);
        $oSqlMode->remove('ONLY_FULL_GROUP_BY');
        $sql  = "
        SELECT ( SELECT COUNT(*)
        FROM `".$oDb->TablePrefix."pages` `x` WHERE x.`parent`=p.`page_id`) `children`,
        MAX(s.`publ_start` + s.`publ_end`) published,
        p.`link`, p.`position`, p.`page_trail`,
        (SELECT MAX(`position`) FROM `".$oDb->TablePrefix."pages` WHERE `parent`= ".$parent.") `max_position`, 0 `min_position`,
        p.`page_id`, p.`root_parent`, p.`parent`, p.`level`, p.`language`, p.`admin_groups`, p.`admin_users`, p.`viewing_groups`, p.`viewing_users`, p.`visibility`, p.`menu_title`, p.`page_title`,
        GROUP_CONCAT(CAST(CONCAT(s.`section_id`, ' - ', s.`module`, ' ', s.`title`) AS CHAR) ORDER BY s.`position` SEPARATOR '\n') `section_list`
        FROM `".$oDb->TablePrefix."pages` p
        INNER JOIN `".$oDb->TablePrefix."sections` s ON p.`page_id`=s.`page_id` WHERE `parent`=".$parent."
        GROUP BY p.`page_id`
        ORDER BY p.`position`, p.`page_trail`
        ";
        $get_pages = $oDb->query($sql);
        $iTotalPages = $get_pages->numRows();
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sql));
        // Insert values into main page list
        if($get_pages->numRows() > 0)
        {
            while($page = $get_pages->fetchAssoc())
            {
                // Get user perms
//                $admin_groups = explode(',', str_replace('_', '', $page['admin_groups']));
//                $admin_users  = explode(',', str_replace('_', '', $page['admin_users']));
                $admin_groups = explode(',', $page['admin_groups']);
                $admin_users  = explode(',', $page['admin_users']);
                $in_group = $oApp->ami_group_member($admin_groups);

                if (($in_group) || (in_array($oApp->getUserId(), $admin_users)))
                {
                    if ($page['visibility'] === 'deleted')
                    {
                        if (PAGE_TRASH == 'inline')
                        {
                            $can_modify = true;
                            $editable_pages = $editable_pages+1;
                        } else {
                            $can_modify = false;
                        }
                    } elseif($page['visibility'] !== 'deleted')
                    {
                        $can_modify = true;
                        $editable_pages = $editable_pages+1;
                    }
                } else {
                    if ($page['visibility'] === 'private')
                    {
                        continue;
                    } else {
                        $can_modify = false;
                    }
                }
                // Work out if we should show a plus or not ,`admin_groups`,`admin_users`
                $sql  = 'SELECT `page_id` FROM `'.$oDb->TablePrefix.'pages` WHERE `parent` = '.$page['page_id'].' ';
                $sql .= (PAGE_TRASH != 'inline') ?  'AND `visibility` != \'deleted\' ' : ' ';
                // $sql .= ' ORDER BY `position` ASC';
                $get_page_subs = $oDb->query($sql);
                $num_subs = $get_page_subs->numRows();
                $par['num_subs'] = $num_subs;
//                $display_plus = $get_page_subs->numRows() > 0;
                if ($get_page_subs->numRows() > 0) {
                    $display_plus = true;
                } else {
                    $display_plus = false;
                }
                // Work out how many pages there are for this parent
                $num_pages = $get_pages->numRows();
                $sToggleId = 'p'.$page['page_id'];
                $sToggleIcon = (isset($_COOKIE['p'.$page['page_id']]) && $_COOKIE['p'.$page['page_id']] === '1' ? 'minus' : 'plus');

                $iLevel = $page['level'];
                $iPaddingLeft = 10;
                $iCursorLeft  = 0;
                $iCellWidth = 28;
                $iSpanPaddingLeft = 0;

                switch ($iLevel):
                    case '0':
//                        $iPaddingLeft = 10;  // 10
                        $iPaddingLeft = 10;  // 0
                        break;
                    case '1':
//                        $iPaddingLeft = $iLevel * ($display_plus ? 32 : 12 ); // 64 oder 24
                        $iPaddingLeft = ($iLevel * 21)+10; // 21
                        break;
                    case '2':
//                        $iPaddingLeft = $iLevel * ($display_plus ? 26 : 16 ); // 78 oder 48
                        $iPaddingLeft = ($iLevel * 21)+10;  // 42
                        break;
                    case '3':
//                        $iPaddingLeft = ($display_plus ? 66 : 50 ); // 66 oder 50
                        $iPaddingLeft = ($iLevel * 21)+10;  // 63
                        break;
                    case '4':
//                        $iPaddingLeft = $iLevel * ($display_plus ? 22 : 16 ); // 88 oder 64
                        $iPaddingLeft = ($iLevel * 21)+10;  // 84
                        break;
                    case '5':
//                        $iPaddingLeft = $iLevel * 22; // 110
                        $iPaddingLeft = ($iLevel * 21)+10;  // 105
                        break;
                    default:
                        $iPaddingLeft = ($iLevel * 21)+10; // 126
                endswitch;
?>
                <li class="p<?php echo $page['parent']; ?>">
<?php
                require 'dataRowsTable.php';
                if ( $page['parent'] == 0)
                {
                    $page_tmp_id = $page['page_id'];
                }
                // Get subs
                $editable_pages =  make_list($page['page_id'], $editable_pages);
                echo ''."\n";
?>
                </li>
<?php
            }
        }
        $output = ($par['num_subs'] )? '</ul>'."\n" : '';
        $par['num_subs'] = (empty($output) ) ?  1 : $par['num_subs'];
        echo $output;
        return $editable_pages;
    }// end of function make_list

// Generate pages list
    if ($admin->get_permission('pages_view') == true) {
?>

      <!-- -->
<article class="pages-block w3-margin">

        <h2 ><?php echo $oTrans->HEADING_MODIFY_DELETE_PAGE; ?></h2>
        <div class="jsadmin hide"></div>
        <div class="pages_tree">
        <div class="pages_list block-outer" >
        <table class="pages_list">
            <thead>
                <tr class="pages_list_header">
                    <th class="list_menu_title"  colspan="3">&nbsp;
                        <?php echo $oTrans->TEXT_VISIBILITY .' / ' .$oTrans->TEXT_MENU_TITLE; ?>:
                    </th>
                    <th class="list_page_title" style="color:#fff">
                        <?php echo $oTrans->TEXT_PAGE_TITLE; ?>:
                    </th>
                    <th class="list_page_id">
                        PID:
                    </th>
                    <th class="list_actions">
                        <?php echo $oTrans->TEXT_ACTIONS; ?>:
                    </th>
                    <th class="list_actions"></th>
                    <th class="list_actions"></th>
                    <th class="list_actions"></th>
                    <th class="list_actions"></th>
                    <th class="list_actions"></th>
                    <th class="list_actions"></th>
                    <th class="list_actions"></th>
                </tr>
            </thead>
        </table> 
<?php
    // Work-out if we should check for existing page_code
    $field_set = $oDb->field_exists($oDb->TablePrefix.'pages', 'page_code');
if ($oDb->get_one('SELECT  COUNT(*) `iNumRows` FROM `'.$oDb->TablePrefix.'pages` `x`') > 100){
?>
        <div id="ProgressBar" class="progress-bar-striped" style="margin: 5% auto;">
            <div style="width: 100%;"><p class="w3-text-white w3-large w3-padding-0"><?php echo $oTrans->TEXT_LOAD_PAGETREE;?></p></div>
        </div>
<?php
} else {
?>
        <div id="ProgressBar" ></div>
<?php
}
        $par = [];
        $par['num_subs'] = 1;
        $editable_pages = make_list(0, 0);
    } else {
        $editable_pages = 0;
    }
// eggsurplus: add child pages for a specific page
 ?></div>
<!--
</article>
-->

<script src="<?php echo $oReg->AcpUrl; ?>pages/eggsurplus.js"></script>
<?php

    if (intval($editable_pages) == 0 ) {
?>
        <div class="empty_list">
            <?php echo $oTrans->TEXT_NONE_FOUND; ?>
        </div>
<?php
    }
// Setup template object, parse vars to it, then parse it
// Create new template object
    $template = new Template(dirname($oApp->correct_theme_source('pages.htt')));
//    $template->setDebug(0);
    $template->set_file('page', 'pages.htt');
    $template->set_block('page', 'main_block', 'main');
// Insert values into the add page form
    $template->set_var('FTAN', $oApp->getFTAN());

// Group list 1

    $query = "SELECT * FROM `".$oDb->TablePrefix."groups`";
    $get_groups = $oDb->query($query);
    $template->set_block('main_block', 'group_list_block', 'group_list');
    // Insert admin group and current group first
    $admin_group_name = $get_groups->fetchRow(MYSQLI_ASSOC);
    $template->set_var([
                          'ID' => 1,
                          'TOGGLE' => '1',
                          'DISABLED' => ' disabled="disabled"',
                          'LINK_COLOR' => '000000',
                          'CURSOR' => 'default',
                          'NAME' => $admin_group_name['name'],
                          'CHECKED' => ' checked="checked"'
                          ]
                      );
    $template->parse('group_list', 'group_list_block', true);

    while($group = $get_groups->fetchAssoc()) {
        // check if the user is a member of this group
        $flag_disabled = '';
        $flag_checked =  '';
        $flag_cursor =   'pointer';
        $flag_color =    '';
        if (in_array($group["group_id"], $admin->get_groups_id())) {
            $flag_disabled = ''; //' disabled';
            $flag_checked =  ' checked="checked"';
            $flag_cursor =   'default';
            $flag_color =    '000000';
        }

        // Check if the group is allowed to edit pages
        $system_permissions = explode(',', $group['system_permissions']);
        if (is_numeric(array_search('pages_modify', $system_permissions))) {
            $template->set_var([
                                  'ID' => $group['group_id'],
                                  'TOGGLE' => $group['group_id'],
                                  'CHECKED' => $flag_checked,
                                  'DISABLED' => $flag_disabled,
                                  'LINK_COLOR' => $flag_color,
                                  'CURSOR' => $flag_checked,
                                  'NAME' => $group['name'],
                                  ]
                                    );
            $template->parse('group_list', 'group_list_block', true);
        }
    }
// Group list 2

    $query = "SELECT * FROM `".$oDb->TablePrefix."groups`";

    $get_groups = $oDb->query($query);
    $template->set_block('main_block', 'group_list_block2', 'group_list2');
    // Insert admin group and current group first
    $admin_group_name = $get_groups->fetchRow(MYSQLI_ASSOC);
    $template->set_var([
                'ID' => 1,
                'TOGGLE' => '1',
                'DISABLED' => ' disabled="disabled"',
                'LINK_COLOR' => '000000',
                'CURSOR' => 'default',
                'NAME' => $admin_group_name['name'],
                'CHECKED' => ' checked="checked"'
                ]
              );
    $template->parse('group_list2', 'group_list_block2', true);

    while($group = $get_groups->fetchRow(MYSQLI_ASSOC)) {
        // check if the user is a member of this group
        $flag_disabled = '';
        $flag_checked =  '';
        $flag_cursor =   'pointer';
        $flag_color =    '';
        if (in_array($group["group_id"], $admin->get_groups_id())) {
            $flag_disabled = ''; //' disabled';
            $flag_checked =  ' checked="checked"';
            $flag_cursor =   'default';
            $flag_color =    '000000';
        }

        $template->set_var([
                            'ID' => $group['group_id'],
                            'TOGGLE' => $group['group_id'],
                            'CHECKED' => $flag_checked,
                            'DISABLED' => $flag_disabled,
                            'LINK_COLOR' => $flag_color,
                            'CURSOR' => $flag_cursor,
                            'NAME' => $group['name'],
                            ]
                        );
        $template->parse('group_list2', 'group_list_block2', true);
    }

// Parent page list
// $database = new database();
/**
 * parent_list()
 *
 * @return
 */
    function parent_list($parent)
    {
        global $oApp, $oDb, $template, $field_set;
        //global $field_set;
        $query = 'SELECT * FROM `'.$oDb->TablePrefix.'pages` '
              . 'WHERE `parent` = '.$parent.' '
              .   'AND `visibility` !=\'deleted\' '
              . 'ORDER BY `position` ';
        $get_pages = $oDb->query($query);
        while($page = $get_pages->fetchRow(MYSQLI_ASSOC)) {
            if($oApp->page_is_visible($page)==false) {continue;}
    /* deprecated
            // if parent = 0 set flag_icon
            $template->set_var('FLAG_ADD_ICON','none');
            if( $page['parent'] == 0 && $field_set) {
                $template->set_var('FLAG_ADD_ICON', strtolower($page['language']));
            }
    */
            // Stop users from adding pages with a level of more than the set page level limit
            if( $page['level'] <= PAGE_LEVEL_LIMIT + 1 ) {
                // Get user perms
//                $admin_groups = explode(',', str_replace('_', '', $page['admin_groups']));
//                $admin_users = explode(',', str_replace('_', '', $page['admin_users']));
                $admin_groups = explode(',',  $page['admin_groups']);
                $admin_users  = explode(',',  $page['admin_users']);
                $in_group = $oApp->ami_group_member($admin_groups);
                foreach($oApp->get_groups_id() as $cur_gid) {
                    if (in_array($cur_gid, $admin_groups)) {
                        $in_group = TRUE;
                    }
                }
                if (($in_group) || (in_array($oApp->getUserId(), $admin_users)))
                {
                    $can_modify = true;
                } else {
                    $can_modify = false;
                }
                // Title -'s prefix
                $title_prefix = '';
                for($i = 1; $i <= $page['level']; $i++) { $title_prefix .= ' - - &nbsp;'; }
                    $template->set_var([
                                    'ID' => $page['page_id'],
                                    'TITLE' => ($title_prefix.$page['menu_title']),
                                    'MENU-TITLE' => ($title_prefix.$page['menu_title']),
                                    'PAGE-TITLE' => ($title_prefix.$page['page_title'])
                                    ]);
                    if($can_modify == true) {
                        $template->set_var('DISABLED', '');
                    } else {
                        $template->set_var('DISABLED', ' disabled="disabled" class="disabled"');
                    }
                    $template->parse('page_list2', 'page_list_block2', true);
            }
            parent_list($page['page_id']);
        }
    }// end of function parent_list
    $template->set_block('main_block', 'page_list_block2', 'page_list2');
    if($oApp->get_permission('pages_add_l0') == true) {
        $template->set_var(
                            [
                                'ID' => '0',
                                'TITLE' => $oTrans->TEXT_NONE,
                                'SELECTED' => ' selected="selected"',
                                'DISABLED' => ''
                            ]
                    );
        $template->parse('page_list2', 'page_list_block2', true);
    }
    parent_list(0);
// Explode module permissions
    $module_permissions = $_SESSION['MODULE_PERMISSIONS'];
// Modules list
    $template->set_block('main_block', 'module_list_block', 'module_list');
    $result = $oDb->query("SELECT * FROM `".$oDb->TablePrefix."addons` WHERE `type` = 'module' AND `function` = 'page' ORDER BY `name`");
    if($result->numRows() > 0) {
        while ($module = $result->fetchRow(MYSQLI_ASSOC)) {
            // Check if user is allowed to use this module
            if (!is_numeric(array_search($module['directory'], $module_permissions))) {
                $template->set_var('VALUE', $module['directory']);
                $template->set_var('NAME', $module['name']);
                if($module['directory'] == 'wysiwyg') {
                    $template->set_var('SELECTED', ' selected="selected"');
                } else {
                    $template->set_var('SELECTED', '');
                }
                $template->parse('module_list', 'module_list_block', true);
            }
        }
    }
// Insert urls
    $template->set_var([
                                'THEME_URL' => $oReg->ThemeUrl,
                                'WB_URL' => $oReg->AppUrl,
                                'ADMIN_URL' => $oReg->AcpUrl,
                                ]
                        );
// Insert language headings
    $template->set_var([
                          'HEADING_ADD_PAGE' => $oTrans->HEADING_ADD_PAGE,
                          'HEADING_MODIFY_INTRO_PAGE' => $oTrans->HEADING_MODIFY_INTRO_PAGE
                          ]
                        );
// Insert language text and messages
    $template->set_var([
                        'TEXT_TITLE' => $oTrans->TEXT_TITLE,
                        'TEXT_TYPE' => $oTrans->TEXT_TYPE,
                        'TEXT_PARENT' => $oTrans->TEXT_PARENT,
                        'TEXT_VISIBILITY' => $oTrans->TEXT_VISIBILITY,
                        'TEXT_PUBLIC' => $oTrans->TEXT_PUBLIC,
                        'TEXT_PRIVATE' => $oTrans->TEXT_PRIVATE,
                        'TEXT_REGISTERED' => $oTrans->TEXT_REGISTERED,
                        'TEXT_HIDDEN' => $oTrans->TEXT_HIDDEN,
                        'TEXT_NONE' => $oTrans->TEXT_NONE,
                        'COLOR' => 'public',
                        'TEXT_MARKED_PUBLIC' => $oTrans->TEXT_MARKED_PUBLIC,
                        'TEXT_MARKED_PRIVATE' => $oTrans->TEXT_MARKED_PRIVATE,
                        'TEXT_MARKED_REGISTERED' => $oTrans->TEXT_MARKED_REGISTERED,
                        'TEXT_MARKED_HIDDEN' => $oTrans->TEXT_MARKED_HIDDEN,
                        'TEXT_MARKED_NONE' => $oTrans->TEXT_MARKED_NONE,
                        'TEXT_NONE_FOUND' => $oTrans->TEXT_NONE_FOUND,
                        'TEXT_ADD' => $oTrans->TEXT_ADD,
                        'TEXT_RESET' => $oTrans->TEXT_RESET,
                        'TEXT_ADMINISTRATORS' => $oTrans->TEXT_ADMINISTRATORS,
                        'TEXT_PRIVATE_VIEWERS' => $oTrans->TEXT_PRIVATE_VIEWERS,
                        'TEXT_REGISTERED_VIEWERS' => $oTrans->TEXT_REGISTERED_VIEWERS,
                        'INTRO_LINK' => $oTrans->MESSAGE_PAGES_INTRO_LINK,
                        ]
                        );

    $template->set_block('main_block', 'add_block', 'add');
    $template->set_block('main_block', 'intro_block', 'intro');
// Insert permissions values
    if($admin->get_permission('pages_add') != true) {
        $template->set_var('DISPLAY_ADD', 'hide');
        $template->set_block('add', '', '');
    } elseif($admin->get_permission('pages_add_l0') != true && $editable_pages == 0) {
        $template->set_var('DISPLAY_ADD', 'hide');
        $template->set_block('add', '', '');
    } else {
        $template->parse('add', 'add_block', true);
    }
    if($admin->get_permission('pages_intro') != true || INTRO_PAGE != 'enabled') {
        $template->set_var('DISPLAY_INTRO', 'hide');
        $template->set_block('intro', '', '');
    } else {
        $template->parse('intro', 'intro_block', true);
    }
// Parse template object
    $template->parse('main', 'main_block', false);
    $template->pparse('output', 'page');
// Print admin
    $admin->print_footer(true);
    exit;