<?php
/**
 *
 * @category        admin
 * @package         login
 * @author          Ryan Djurovich, WebsiteBaker Project
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.4
 * @requirements    PHP 5.4 and higher
 * @version         $Id: userlogin.php 145 2025-07-20 10:00:06Z Uwe $
 * @filesource      $HeadURL: svn://isteam.dynxs.de/wb/2.12.x/branches/main/admin/settings/locking.php $
 * @lastmodified    $Date: 2025-07-20 12:00:06 +0200 (So, 20 Jul 2025) $
 *
 */
if (!\defined('SYSTEM_RUN')) {
    $sStartupFile = \dirname(\dirname(__DIR__)).'/config.php';
    if (\is_readable($sStartupFile)) {
        require($sStartupFile);
    } else {
        throw new \Exception(
                            'tried to read a nonexisting or not readable startup file ['
                          . \basename(\dirname($sStartupFile)).'/'.\basename($sStartupFile).']!!'
        );
    }
}

//$oDb = \database::getInstance();
$oTrans = \Translate::getInstance();
$oTrans->enableAddon(ADMIN_DIRECTORY.'/settings');

$admin = new \admin('Start', 'settings', false, false);

if ($admin->ami_group_member('1')) {
    $val = (((int)(\defined('USER_LOGIN') ? USER_LOGIN : 0)) + 1) & 1;
    db_update_key_value('settings', 'user_login', (($val==0) ? 'false' : 'true' ));
}

/*  */
// redirect to backend
\header('Location: ' . ADMIN_URL . '/index.php');
exit();

