<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of Unbenannt 1
 *
 * @package      core
 * @copyright    Dietmar Wöllbrink <dietmar.woellbrink@websitebaker.org>
 * @author       Dietmar Wöllbrink <dietmar.woellbrink@websitebaker.org>
 * @license      GNU General Public License 2.0
 * @version      0.0.1
 * @revision     $Id: PNGType.php 145 2025-07-20 10:00:06Z Uwe $
 * @since        File available since 12.11.2017
 * @deprecated   no / since 0000/00/00
 * @description  xxx
 */
declare(strict_types = 1);
//declare(encoding = 'UTF-8');

namespace bin\helpers;

//use this

/**
 * PNGType
 *
 * @package   WebsiteBaker wb213x4
 * @copyright 2023
 * @version   $Id: PNGType.php 145 2025-07-20 10:00:06Z Uwe $
 * @access    public
 * @link      https://christianwood.net/posts/png-files-are-complicate/
 */
class PNGType
{
  const GRAYSCALE = 0;
  const RGB = 2;
  const PALETTE = 3;
  const GRAYSCALE_ALPHA = 4;
  const RGBA = 6;

  // Bit offsets
  const ColorTypeOffset = 25;

    public static function usesTransparency(string $file): bool {
        if ($colorTypeByte = \file_get_contents($file, false, null, self::ColorTypeOffset, 1)) {
            $type = \ord($colorTypeByte);
            $image = \imagecreatefrompng($file);

            // Palette-based PNGs may have one or more values that correspond to the color to use as transparent
            // PHP returns the first fully transparent color for palette-based images
            $transparentColor = \imagecolortransparent($image);

            // Grayscale, RGB, and Palette-based images must define a color that will be used for transparency
            // if none is set, we can bail early because we know it is a fully opaque image
            if (($transparentColor === -1) && \in_array($type, [self::GRAYSCALE, self::RGB, self::PALETTE])) {
              return false;
            }

            $xs = \imagesx($image);
            $ys = \imagesy($image);

            for ($x = 0; $x < $xs; $x++) {
              for ($y = 0; $y < $ys; $y++) {
                $color = \imagecolorat($image, $x, $y);

                if ($transparentColor === -1) {
                  $shift = $type === self::RGBA ? 3 : 1;
                  $transparency = ($color >> ($shift * 8)) & 0x7F;

                  if (
                    ($type === self::RGBA && $transparency !== 0) ||
                    (($type === self::GRAYSCALE_ALPHA) && ($transparency === 0))
                  ) {
                    return true;
                  }
                } else if ($color === $transparentColor) {
                  return true;
                }
              }
            }// end for
        }// $colorTypeByte
    return false;
    }
}//end of class

// end of file
