<?php
//:Shows the parent page_title or menu_title of a page tree
//:Use [[ShowRootParent?show=m]] shows menu_title
//:Use [[ShowRootParent]] or [[ShowRootParent?show=p]] shows page_tile
/*
 * possible return values:
 *  if current page is a real root page = 'own title'
 *  if current page is root page after a language page = 'own title'
 *  all others shows the root page/menu title of the current branch
 *  if page_id = 0, the default_page[$title] is loaded
 *  language pages in root are ignored and show the default_page[$title]
 */
// process selection
$title = (($show ?? 'p') == 'm'  ? 'menue_title' : 'page_title');
$oReg = \bin\WbAdaptor::getInstance();
$oApp = $oReg->getApplication();
$iCurrPageId = $GLOBALS['page_id'];
$sRetval = '';
if ($iCurrPageId) { // if current page > 0
    $aPage = $oApp->getPage($iCurrPageId);
    if ($aPage) {
        $aPageTrail = \explode(',', $aPage['page_trail']);
        if (($oReg->PageLanguages ?? 0)) {
            \array_shift($aPageTrail); // remove language level
        }
        if (\count($aPageTrail)) { // if at least one page exists (root or root after language)
            $iRootPageId = \array_shift($aPageTrail);
            $aPage = $oApp->getPage($iRootPageId);
            if ($aPage) {
                $sRetval = $aPage[$title];
            }
        }
    }
}
// try to load the default page if an error occurred before
if (!$sRetval) {
    $iDefaultPageId = ($oApp->default_page_id ?? 0);
    if ($iDefaultPageId) {
        $aPage = $oApp->getPage($iDefaultPageId);
        if ($aPage) {
            $sRetval = $aPage[$title];
        }
    }
}
return $sRetval;
