/* https://www.alistapart.com/articles/zebratables/ */
function removeClassName (elem, className) {
    elem.className = elem.className.replace(className, "").trim();
}

function addCSSClass (elem, className) {
    removeClassName (elem, className);
    elem.className = (elem.className + " " + className).trim();
}

String.prototype.trim = function() {
    return this.replace( /^\s+|\s+$/, "" );
}

function stripedTable() {
    return false;
    if (document.getElementById && document.getElementsByTagName) {
        var allTables = document.getElementsByTagName('table');
        if (!allTables) { return; }

        for (var i = 0; i < allTables.length; i++) {
            if (allTables[i].className.match(/[\w\s ]*scrollTable[\w\s ]*/)) {
                var trs = allTables[i].getElementsByTagName("tr");
                for (var j = 0; j < trs.length; j++) {
                    removeClassName(trs[j], 'alternateRow');
                    addCSSClass(trs[j], 'normalRow');
                }
                for (var k = 0; k < trs.length; k += 2) {
                    removeClassName(trs[k], 'normalRow');
                    addCSSClass(trs[k], 'alternateRow');
                }
            }
        }
    }
}

window.onload = function() { stripedTable(); }
