<?php

declare(strict_types=1);

use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck,csvHelper,StopWatch};

/* -------------------------------------------------------- */
if ( !defined( 'SYSTEM_RUN' ) ){ require( dirname(__DIR__,2).'/config.php' ); }
/*
$sAddonPath = (__DIR__);
$sAddonName = basename($sAddonPath);
$sAddonRel = '/modules/'.$sAddonName.'/data/layouts/';
*/
    $sAddonPath   = str_replace('\\','/',__DIR__).'/';
    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = basename($sModulesPath);
    $sAddonName   = basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = preg_replace ($sPattern, "$1", $sModulesPath, 1 );

    $aJsonRespond = [];
    $aMessage = [];

    $bGetOldSecureToken = (SecureTokens::checkFTAN());
    // to put in form input hidden fields, dont forgget the php echo tag round the variables
    $aFtan = \bin\SecureTokens::getFTAN();
    // <input type="hidden" name="$aFtan['name']" value="$aFtan['value']">

    // for $_GET Querystring
    $sFtanQuery = $aFtan['name'].'='.$aFtan['value'];

    $section_name = 'Modules';
    $section_permission = 'modules_view';

    $print_info_banner = true;
    $admin_header = false;
// Tells script to update when this page was last updated
//$update_when_modified = true;
// Include WB admin wrapper script
    require(WB_PATH.'/modules/admin.php');

/* -------------------------------------------------------- */
    $oDb  = $oReg->getDatabase();
    $oApp = $oReg->getApplication();
    $sCallingScript = $oRequest->getServerVar('SCRIPT_NAME');
    $ModuleUrl    = $oReg->AppUrl.$ModuleRel;
    $sAddonUrl    = $oReg->AppUrl.$sAddonRel;
    $sTargetPath  = $sAddonPath.'data/layouts/';
    $sDomain      = $oApp->getDirNamespace(__DIR__);

    try{
//    $oApp = new admin('Modules', 'module_view', FALSE, FALSE);
    $file = $oApp->StripCodeFromText(urldecode(isset($aRequestVars['file'])?$aRequestVars['file']:''));

        if (file_exists($sTargetPath.$file) && (!empty($file))) {
            header('Content-Description: File Transfer');
            header("Content-Type: text/xml");
            header("Content-Disposition: attachment; filename=$file");
            header("Content-Length: ". filesize($sTargetPath.$file));
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            readfile($sTargetPath.$file);
            $aJsonRespond['success'] = true;
            $sJsonRespond['ftan'] = $sFtanQuery;
            exit;
        } else {
            $aMessage[] = sprintf('%1$.04d ) No file %2$s for download is selected.', __LINE__, $file);
        }
    } catch (FormException $e) {
        $aJsonRespond['message'] = $e->getMessage();
        $aJsonRespond['success'] = false;
        exit;
    }
//    echo the json_respond to the ajax function
//    exit(json_encode($aJsonRespond));
//    require(WB_PATH.'/modules/admin.php');
    $backUrl = ADMIN_URL.'/pages/modify.php?page_id='.$page_id;

    $sBacklink = $oReg->AcpUrl.'pages/modify.php?page_id='.$page_id;
    $sQueryString = '?page_id='.$page_id.'&section_id='.$section_id.'';
    $sBacklinkSetting = $sAddonUrl.'modify_settings.php'.$sQueryString;

    $admin->print_error(implode('<br>',$aMessage), $sBacklinkSetting.'&'.$sFtanQuery.'#layout-setting');
    exit;
// Print admin footer
    $admin->print_footer();
    class FormException extends \Exception { }
