<?php
/**
 *
 * @category        modules
 * @package         JsAdmin
 * @author          WebsiteBaker Project, modified by Swen Uth for Website Baker 2.7
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.3
 * @requirements    PHP 5.3.6 and higher
 * @version         $Id: tool.php 145 2025-07-20 10:00:06Z Uwe $
 * @filesource      $HeadURL: svn://isteam.dynxs.de/wb/2.12.x/branches/main/modules/jsadmin/tool.php $
 * @lastmodified    $Date: 2025-07-20 12:00:06 +0200 (So, 20 Jul 2025) $
 *
*/
declare(strict_types=1);

use bin\{WbAdaptor,Sanitize,SecureTokens};

/* -------------------------------------------------------- */
// Must include code to stop this file being accessed directly
if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; flush(); exit;}
/* -------------------------------------------------------- */
    $sAddonName = \basename(__DIR__);
    $bExcecuteCommand = false;
/*******************************************************************************************/
//      SimpleCommandDispatcher
/*******************************************************************************************/
//    set the name of the addon
    $sAddonName = basename(__DIR__);
// Prevent SimpleCommandDispatcher from calling cmd scripts
//    $bExcecuteCommand = true|false;
    $sModulesPath = str_replace('\\','/',dirname(__DIR__)).'/';
    $sDispatcherFile = $sModulesPath.'SimpleCommandDispatcher.inc.php';
    if (is_readable($sDispatcherFile) ){
//echo \nl2br(\sprintf("---- [%04d] inluded %s \n",__LINE__,$sDispatcherFile));
      include($sDispatcherFile);
    }

// check if module language file exists for the language set by the user (e.g. DE, EN)
    $sAddonName = basename(__DIR__);
    $sModulName = $sAddonName;
    if (\is_readable(__DIR__.'/languages/EN.php')) {require(__DIR__.'/languages/EN.php');}
    if (\is_readable(__DIR__.'/languages/'.DEFAULT_LANGUAGE.'.php')) {require(__DIR__.'/languages/'.DEFAULT_LANGUAGE.'.php');}
    if (\is_readable(__DIR__.'/languages/'.LANGUAGE.'.php')) {require(__DIR__.'/languages/'.LANGUAGE.'.php');}

    $oTrans = \Translate::getInstance();
    $oTrans->enableAddon('modules/'.basename(__DIR__));

    $sActionUrl = ADMIN_URL.'/admintools/tool.php';
    $ToolQuery  = '?tool='.$sAddonName;
    $ToolRel    = '/admintools/tool.php'.$ToolQuery;
    $js_back    = $sActionUrl;
    $ToolUrl    = $sActionUrl.'?tool='.$sAddonName;
    $sAdminToolRel = ADMIN_DIRECTORY.'/admintools/index.php';
    $sAdminToolUrl = $oReg->AcpUrl.$sAdminToolRel;
    if (!$admin->get_permission($sModulName,'module' ) ) {
        $admin->print_error($MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES'], $js_back);
    }

    if (!\function_exists('get_setting')) {require(WB_PATH.'/modules/'.basename(__DIR__).'/jsadmin.php');}

// Check if user selected what add-ons to reload
// Display form
    $aSelect['persist_order']       = (get_setting('mod_jsadmin_persist_order' ) ? 'checked="checked"' : '');
    $aSelect['ajax_order_pages']    = (get_setting('mod_jsadmin_ajax_order_pages'  ) ? 'checked="checked"' : '');
    $aSelect['ajax_order_sections'] = (get_setting('mod_jsadmin_ajax_order_sections' ) ? 'checked="checked"' : '');

// THIS ROUTINE CHECKS THE EXISTING OFF ALL NEEDED YUI FILES
  $YUI_ERROR=false; // ist there an Error
  $YUI_PUT ='';   // String with javascipt includes
  $YUI_PUT_MISSING_Files=''; // String with missing files
  reset($js_yui_scripts);
    foreach($js_yui_scripts as $script) {
        if (!\file_exists(WB_PATH.$script)){
            $YUI_ERROR=true;
            $YUI_PUT_MISSING_Files =$YUI_PUT_MISSING_Files."- ".WB_URL.$script."<br />";   // catch all missing files
        }
    }
    if($YUI_ERROR) {
?>
    <div id="jsadmin_install" style="border: solid 2px #c99; background: #ffd; padding: 0.5em; margin-top: 1em">
     <?php echo $MOD_JSADMIN['TXT_ERROR_INSTALLINFO_B'].$YUI_PUT_MISSING_Files; ?>
    </div>
<?php
  } else {
    if(!$admin_header) { $admin->print_header(); }
    $sGetOldSecureToken = (SecureTokens::checkFTAN());
    $sFtan = SecureTokens::getFTAN();
    //$sFtanQuery = $sFtan['name'].'='.$sFtan['value'];

    if ($doSave) {

        if (!$sGetOldSecureToken) {
//            if(!$admin_header) { $admin->print_header(); }
//          show title if not function 'save' is requested
            echo $admin->format_message($MESSAGE['GENERIC_SECURITY_ACCESS'],'error',$ToolUrl);
        }
        else
        {
/* */
            $persist_order = (int)filter_var($admin->get_post('persist_order'), FILTER_VALIDATE_BOOLEAN);
            $ajax_order_pages = (int)filter_var($admin->get_post('ajax_order_pages'), FILTER_VALIDATE_BOOLEAN);
            $ajax_order_sections = (int)filter_var($admin->get_post('ajax_order_sections'), FILTER_VALIDATE_BOOLEAN);

            $aSql = [];
            $aSql[] = save_setting('mod_jsadmin_persist_order', (string)$persist_order);
            $aSql[] = save_setting('mod_jsadmin_ajax_order_pages', (string)$ajax_order_pages);
            $aSql[] = save_setting('mod_jsadmin_ajax_order_sections', (string)$ajax_order_sections);
            if($database->is_error()) {
                echo $admin->format_message($database->get_error(),'error', $ToolUrl);
//                $admin->print_error($database->get_error(), $ToolUrl);
            } else {
                echo $admin->format_message($MESSAGE['PAGES_SAVED'],'ok', $ToolUrl);
//                $admin->print_success($MESSAGE['PAGES_SAVED'], $ToolUrl);
            }

//        if(!$admin_header) { $admin->print_header(); }
//          show title if not function 'save' is requested
                print '<h4 style="margin:0!important;font-size:1.25em!important;"><a href="'.$sAdminToolUrl.'" '.
                      'title="'.$HEADING['ADMINISTRATION_TOOLS'].'">'.
                      $HEADING['ADMINISTRATION_TOOLS'].'</a>'.
                      '&nbsp;&raquo;&nbsp;'.$toolName.'</h4>'."\n";

        } //ftan error
    } // do save

        // check if there is a database error, otherwise say successful implode('<br />',$aSql ).
            $aSelect['persist_order']       = (get_setting('mod_jsadmin_persist_order' ) ? 'checked="checked"' : '');
            $aSelect['ajax_order_pages']    = (get_setting('mod_jsadmin_ajax_order_pages'  ) ? 'checked="checked"' : '');
            $aSelect['ajax_order_sections'] = (get_setting('mod_jsadmin_ajax_order_sections' ) ? 'checked="checked"' : '');

?>
<div class="block-outer">
    <h5 class="w3-panel w3-note w3-row w3-padding"><?= $MOD_JSADMIN['TXT_HEADING_B']; ?></h5>
    <form id="jsadmin_form" style="margin-top: 1em; display: true;" action="<?= $sActionUrl;?>" method="post">
      <input type="hidden" name="tool" value="<?= basename(__DIR__); ?>" />
      <input type="hidden" name="action" value="save" />
      <input type="hidden" name="SaveSettings" value="1" />
      <input type="hidden" name="<?= $sFtan['name']; ?>" value="<?= $sFtan['value']; ?>" />
            <div class="w3-content w3-margin">
             <input class="w3-check" type="checkbox" name="persist_order" id="persist_order" value="true" <?php echo $aSelect['persist_order']; ?>/>
             <label class="w3-validate" for="persist_order"><?php echo $MOD_JSADMIN['TXT_PERSIST_ORDER_B']; ?></label>
            </div>

            <div class="w3-content w3-margin">
             <input class="w3-check" type="checkbox" name="ajax_order_pages" id="ajax_order_pages" value="true" <?php echo $aSelect['ajax_order_pages']; ?>/>
             <label class="w3-validate" for="ajax_order_pages"><?php echo $MOD_JSADMIN['TXT_AJAX_ORDER_PAGES_B']; ?></label>
            </div>

            <div class="w3-content w3-margin">
             <input class="w3-check" type="checkbox" name="ajax_order_sections" id="ajax_order_sections" value="true" <?php echo $aSelect['ajax_order_sections']; ?>/>
             <label class="w3-validate" for="ajax_order_sections"><?php echo $MOD_JSADMIN['TXT_AJAX_ORDER_SECTIONS_B']; ?></label>
            </div>

            <div class="w3-content w3-margin">
                <div class="w3-quarter"></div>
                <input class="w3-btn w3-btn-default w3-blue-wb w3-hover-green w3--medium w3-btn-min-width" type="submit" name="SaveSettings" value="<?php echo $TEXT['SAVE']; ?>" />
                <button class="w3-btn w3-btn-default w3-blue-wb w3-hover-red w3--medium w3-btn-min-width url-close" data-overview="<?= $sAdminToolRel;?>" type="button"><?= $TEXT['CLOSE'];?></button>

            </div>
   </form>
</div>
 <?php
}
