<?php
/**
 *
 * @category        modules
 * @package         output_filter
 * @copyright       WebsiteBaker Org. e.V.
 * @author          Manuela v.d.Decken <manuela@isteam.de>
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.3
 * @requirements    PHP 5.3.6 and higher
 * @version         $Id: Install.inc.php 145 2025-07-20 10:00:06Z Uwe $
 * @filesource      $HeadURL: svn://isteam.dynxs.de/wb/2.12.x/tags/2.12.1/modules/output_filter/cmd/cmdInstall.inc $
 * @lastmodified    $Date: 2025-07-20 12:00:06 +0200 (So, 20 Jul 2025) $
 *
 */

use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck,msgQueue};
use src\Security\{CsfrTokens,Randomizer};
use src\Interfaces\Requester;
use bin\Requester\HttpRequester;

/* -------------------------------------------------------- */
// Must include code to stop this file being accessed directly
if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
/* -------------------------------------------------------- */

    $oReg = WbAdaptor::getInstance();
    $msg = '';
    $sErrorMsg = null;
    $sAddonPath = \str_replace('\\', '/', dirname(__DIR__));
    $sAddonName = basename($sAddonPath);
    $globalStarted = preg_match('/upgrade\-script\.php$/', $_SERVER["SCRIPT_NAME"]);
    $sWbVersion = ($globalStarted && defined('VERSION') ? VERSION : WB_VERSION);
    $sModulePlatform = PreCheck::getAddonVariable($sAddonName,'platform');
    if (\version_compare($sWbVersion, $sModulePlatform, '<')){
        $msg = $sErrorMsg = \sprintf('It is not possible to install from WebsiteBaker Versions before %s',$sModulePlatform).PHP_EOL;
        if ($globalStarted){
            echo $sErrorMsg.PHP_EOL;
        }else{
            throw new \Exception ($sErrorMsg);
        }
    } else {
        Translate::getInstance()->disableAddon ('modules\\'.$sAddonName);
        Translate::getInstance()->enableAddon(ADMIN_DIRECTORY.'/addons');
        if (\is_writable(WB_PATH.'/temp/cache')) {
            Translate::getInstance()->clearCache();
        }
        $sTable = TABLE_PREFIX.'mod_output_filter';
        $i = (!isset($i) ? 1 : $i);
        $OK   = "<span class=\"ok\">OK</span>";
        $FAIL = "<span class=\"error\">FAILED</span>";
        $iErr = false;
        $msg .= '<div style="margin:1em auto;font-size:1.1em;">'.PHP_EOL;
        $msg .= '<h4>Step '.$i++.': Installing Output Filter Settings</h4>'.PHP_EOL;
/*
        if (\is_writable($sAddonPath.'/Filters/filterShortUrl.php')){
            \unlink($sAddonPath.'/Filters/filterShortUrl.php');
        }
*/
    // create tables from sql dump file
        $sInstallStruct = $sAddonPath.'/install-struct.sql.php';
        if (!\is_readable($sInstallStruct)) {
            $sInstallStruct = $sAddonPath.'/install-struct.sql';
        }
        if ( !\is_readable($sInstallStruct)) {
            $msg .= \sprintf('<strong>missing or not readable file [%s]</strong> %s<br /> ',basename($sInstallStruct),$FAIL);
            $iErr = true;
        } else {

                $aFiles = \glob($sAddonPath.'/Filters/*', \GLOB_NOSORT);
                $getDefaultSettings = (function() use ( $aFiles ){
                    $aDefaults = [];
                    $aAutoFilter = [
                        'WbLink' => 1,
                        'ReplaceSysvar' => 1,
                        'CssToHead' => 1,
                        'CleanUp' => 1,
                        'ShortUrl' => 1,
                        'SnippetCss' => 1,
                        'FrontendCss' => 1,
                    ];

                    $SettingsDenied = [
                        'at_replacement',
                        'dot_replacement',
                        'email_filter',
                        'mailto_filter',
                        'OutputFilterMode',
                        'W3Css_force',
                        'WbLink',
                        'ReplaceSysvar',
                        'CssToHead',
                        'ShortUrl',
                        'Short_force',
                        'edit_force',
                        'CleanUp',
                        'Abstract'
                    ];

                    $aExtendedDefaults = [
                        'at_replacement'  => '[at]',
                        'dot_replacement' => '[dot]',
                        'email_filter'    => 0,
                        'mailto_filter'   => 1,
                        'Short_force'=> 0,
                        'edit_force'=> 0,
                        'W3Css_force'=> 0,
                        'OutputFilterMode' => 0,
                    ];

                    $aInactiveList = ['OpF', 'RelUrl','Jquery', 'JqueryUI','W3Css_force','W3Css','WbLinkXXL']; //
                    $aOldSettings  = (getOutputFilterSettings());
                    \array_walk(
                        $aFiles,
                        function (& $sItem, $iKey) use (& $aDefaults,$aInactiveList) {
                            $sItem = \str_replace(['%filter', '%'], '', '%'.\basename($sItem, '.php'));
                            $aDefaults[$sItem] = (in_array($sItem, $aInactiveList) ? 0 : 1);
                        }
                    );
                    $aDefaults = \array_merge($aDefaults, $aExtendedDefaults,$aAutoFilter );
                    \ksort($aDefaults, \SORT_NATURAL | \SORT_FLAG_CASE );
                    $aAllowedFilters  = \array_keys ( $aDefaults );
                    $aFilterExists    = \array_diff ( $aAllowedFilters, $SettingsDenied );
/* */
                    foreach ( $aFiles  as $sFilterFile) {
                        if (\substr(\str_replace('\\', '/', $sFilterFile), -1) == '/') {
                            $key = \basename($sFilterFile);
                        } else {
                            $key = \preg_replace('=^.*?filter([^\.\/\\\\]+)(\.[^\.]+)?$=is', '\1', $sFilterFile);
                        }
                        if (in_array($key, ['Abstract'])){
//                        echo nl2br(sprintf("%s\n \n",$key));
                          continue;
                        }
                        if (\in_array($key,$aInactiveList)){
                            //echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,));
                            $aDefaults[$key] = (isset($aOldSettings[$key]) && ($aOldSettings[$key] ==='1') ? '1' : '0');
                        } else {
                            //$aDefaults[$key] = '1';
                        }
                    }
                  \ksort($aDefaults);
                  return $aDefaults;
                }); // $getDefaultSettings

            $aDefaults =  $getDefaultSettings();
            if ($database->SqlImport($sInstallStruct, TABLE_PREFIX, 'install')){
                if (count($aDefaults)) {
                // restore old settings if there any
                    $sNameValPairs = '';
                    foreach ($aDefaults as $index => $val) {
                        $sNameValPairs .= ', (\''.$index.'\', \''.$database->escapeString($val).'\')';
                    }
                    $sValues = ltrim($sNameValPairs, ', ');
                    $sql = 'INSERT INTO `'.$sTable.'` (`name`, `value`) '
                         . 'VALUES '.$sValues;
                    if (!$database->query($sql)) {
                        $msg .= '<strong>Output Filter install settings</strong> '.$FAIL.PHP_EOL;
                        $msg .= $database->get_error().'';
                        $iErr = true;
                    } else {
                        $msg .= '<strong>Output Filter settings successful installed</strong> '.$OK.PHP_EOL;
                    }
                }
                unset($getDefaultSettings);
            } else {
                $msg .= '<strong>Output Filter install settings</strong> '.$FAIL.PHP_EOL;
                $msg .= $database->get_error().PHP_EOL;
            }
        }
        $msg .= '</div>'.PHP_EOL;
        if ($globalStarted){echo nl2br($msg)."<br />";}
    }