<?php
/**
 * FINAL VERSION - WITH HTACCESS BLOCK RESTORED
 */

// Kein ob_start() mehr nötig, da das Problem im Framework selbst lag.
// Wir halten uns an die Architektur des funktionierenden Moduls.

use bin\{WbAdaptor,SecureTokens,Sanitize};
use vendor\phplib\Template;

/* -------------------------------------------------------- */
// Must include code to stop this file being accessed directly
if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
/* -------------------------------------------------------- */

// --- GRUNDLEGENDE INITIALISIERUNG ---
$sAddonFile   = \str_replace('\\','/',__FILE__);
$sFolder      = basename(\dirname($sAddonFile));
switch ($sFolder):
    case 'cmd':
      $sAddonPath   = (\dirname($sAddonFile,2)).'/';
      break;
    default :
      $sAddonPath   = (\dirname($sAddonFile)).'/';
endswitch;
$sModuleName  = basename(dirname($sAddonPath));
$sAddonName   = basename($sAddonPath);
$sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
$sAppPath     = preg_replace ($sPattern, "$1", dirname($sAddonPath).'/', 1 );

$oReg = WbAdaptor::getInstance();
$oRequest = $oReg->getRequester();
$database = $oReg->getDatabase();
$oTrans   = $oReg->getTranslate();
$oApp     = $oReg->getApplication();
$sDomain  = $oApp->getDirNamespace(dirname(__DIR__));
$oTrans->enableAddon($sDomain);
$aRequestVars = $oApp->getRequestVars();

// --- DATEN-INITIALISIERUNG FÜR Save.inc.php ---
if (\is_readable($sAddonPath.'OutputFilterApi.php')) {
    if (!\function_exists('getOutputFilterSettings')) { require($sAddonPath.'OutputFilterApi.php'); }
}
if (!isset($module_description) && \is_readable($sAddonPath.'info.php')) {require $sAddonPath.'info.php';}
createMissingValues();
$aExentedDefaults = ['OutputFilterMode' => 0, 'W3Css_force' => 0, 'Short_force' => 0, 'edit_force' => 0];
$aEmailDefaults = ['at_replacement'  => '@', 'dot_replacement' => '.', 'Email' => 0, 'email_filter' => 0, 'mailto_filter' => 0];
$aAutoFilter = ['WbLink' => 1, 'ReplaceSysvar' => 1, 'CssToHead' => 1, 'CleanUp' => 1, 'SnippetCss' => 1, 'FrontendCss' => 1];
$aDefaultSettings = [];
$aFiles = \glob($sAddonPath.'Filters/*', \GLOB_NOSORT);
array_walk(
    $aFiles,
    function (& $sItem, $iKey) use (& $aDefaultSettings) {
        $sItem = \str_replace(['%filter', '%'], '', '%'.\basename($sItem, '.php'));
        $aDefaultSettings[$sItem] = 0;
    }
);
if (isset($aDefaultSettings['FilterAbstract'])){unset($aDefaultSettings['FilterAbstract']);}
$aDefaultSettings = \array_merge($aDefaultSettings, $aExentedDefaults, $aAutoFilter, $aEmailDefaults);
$aAllowedFilters  = \array_keys($aDefaultSettings);


// --- SPEICHER-LOGIK ---
$msgTxt = '';
$msgCls = 'sand';
if (isset($aRequestVars['SaveSettings'])) {
    $aFilterSettings = getOutputFilterSettings();
    include(__DIR__.'/Save.inc.php');
}

// --- AB HIER BEGINNT DIE ANZEIGE-LOGIK ---

if (!$admin->get_permission($sAddonName,'module' ) ) {
    $admin->print_error($oTrans->MESSAGE_ADMIN_INSUFFICIENT_PRIVELLIGES, $oReg->AcpUrl.'admintools/index.php');
}

$aFilterSettings = getOutputFilterSettings();

// --- TEMPLATE-AUFBAU ---
$oTpl = new Template( $sAddonThemePath );
$oTpl->setDebug(0);
$aFiles = ['page' => 'tool.htt', 'page1' => 'htaccess_form.htt'];
$oTpl->set_file($aFiles);
$oTpl->loadfile('page');
$oTpl->set_block('page', 'main_block', 'main');

$TEXT_CUSTOM = (isset($aRequestVars['SaveSettings']) ? $oTrans->TEXT_BACK : $oTrans->TEXT_CLOSE);

$aFtan = \bin\SecureTokens::getFTAN();
$oTpl->set_var('FTAN_NAME', $aFtan['name']);
$oTpl->set_var('FTAN_VALUE', $aFtan['value']);

if (empty($msgTxt)) {
    $msgTxt = $module_description;
    $msgCls = 'sand';
}

$ToolUrl = $oReg->AcpUrl.'admintools/tool.php?tool='.$sAddonName;
$oTpl->set_var([
    'CUSTOM'        => $TEXT_CUSTOM,
    'ADMIN_URL'     => $oReg->AcpUrl,
    'MODULE_NAME'   => $sAddonName,
    'TOOL_NAME'     => $toolName,
    'REQUEST_URI'   => $_SERVER['REQUEST_URI'],
    'CANCEL_URL'    => ADMIN_DIRECTORY.'/admintools/index.php',
    'TOOL_URL'      => $ToolUrl,
    'WB_URL'        => $oReg->AppUrl,
    'DISPLAY'       => 'block',
]);
$oTpl->set_var($aoutput_filterLang);

$oTpl->set_block('main_block', 'headline_block', 'headline');
$oTpl->set_block('main_block', 'info_message_block', 'info_message');
$oTpl->set_block('main_block', 'success_message_block', 'success_message');
if (isset($aRequestVars['SaveSettings'])) {
    $oTpl->parse('headline', 'headline_block', true);
    $oTpl->set_block('info_message_block', '');
    if ($msgTxt != '') {
        $oTpl->set_var('MSGTXT', $msgTxt);
        $oTpl->set_var('MSGCOLOR', $msgCls);
        $oTpl->parse('success_message', 'success_message_block', true);
    } else {
        $oTpl->set_block('success_message_block', '');
    }
} else {
    $oTpl->set_block('headline', '');
    $oTpl->set_block('success_message_block', '');
    if ($msgTxt != '') {
        $oTpl->set_var('MSGTXT', $msgTxt);
        $oTpl->set_var('MSGCOLOR', $msgCls);
        $oTpl->parse('info_message', 'info_message_block', true);
    } else {
        $oTpl->set_block('info_message_block', '');
    }
}

$aAliasFilterNames = ['Jquery' => 'jQuery','JqueryUI' => 'jQueryUI'];
$SettingsDenied = [
    'at_replacement', 'dot_replacement', 'email_filter', 'mailto_filter', 'OutputFilterMode', 'W3Css_force',
    'WbLink', 'ReplaceSysvar', 'CssToHead', 'ShortUrl', 'Short_force', 'edit_force', 'CleanUp', 'FilterCleanUp',
    'FilterAbstract', 'content_output_filter'
];

$oTpl->set_block('main_block', 'submit_list_block', 'submit_list');
$oTpl->set_var('MOD_MAIL_FILTER_WARNING', $oTrans->MOD_MAIL_FILTER_WARNING);
$oTpl->set_var('TEXT_SAVE_LIST', $oTrans->TEXT_SAVE_LIST);
$oTpl->set_var('TEXT_EMPTY_LIST', $oTrans->TEXT_EMPTY_LIST);
$oTpl->set_block('submit_list_block', '');

$oTpl->set_block('main_block', 'own_list_block', 'own_list');
$oTpl->set_block('own_list_block', '');
$aHiddenFilter = [
'ScriptVars', 'LoadOnFly', 'Jquery', 'SnippetJs', 'FrontendJs', 'SnippetBodyJs',
'FrontendBodyJs', 'SnippetCss', 'FrontendCss',
];
$oTpl->set_var($aFilterSettings);
$oTpl->set_block('main_block', 'filter_block', 'filter_list');
foreach($aFilterSettings as $sFilterName => $sFilterValue)
{
    $sFilterAlias = ($aAliasFilterNames[$sFilterName] ?? $sFilterName);
    $sHelpMsg = ($output_filter_help[$sFilterName] ?? $MOD_MAIL_FILTER['HELP_MISSING']);
    if (\in_array( $sFilterName, $SettingsDenied)) { continue; }
    $oTpl->set_var('TITLE', $sHelpMsg);
    $oTpl->set_var('FVALUE', $sFilterValue);
    $oTpl->set_var('FNAME', $sFilterName);
    $oTpl->set_var('RGMF', (in_array($sFilterName,$aHiddenFilter) ? 'register-mod-files' : ''));
    $oTpl->set_var('FALIAS', $sFilterAlias);
    $oTpl->set_var('FCHECKED', (($sFilterValue=='1') ? ' checked="checked"' : '') );
    $oTpl->parse('filter_list', 'filter_block', true);
}

$oTpl->set_block('main_block', 'filter_email_block', 'filter_email');
if (isset($aFilterSettings['Email']) && $aFilterSettings['Email']) {
    $oTpl->set_var('EMAIL_FILTER_CHECK',  (($aFilterSettings['email_filter']) ? ' checked="checked"' : '') );
    $oTpl->set_var('MAILTO_FILTER_CHECK', (($aFilterSettings['mailto_filter']) ? ' checked="checked"' : '') );
} else {
    $oTpl->set_var('EMAIL_FILTER_CHECK', '');
    $oTpl->set_var('MAILTO_FILTER_CHECK', '');
}
$oTpl->parse('filter_email', 'filter_email_block', true);

$bSpecialAdminRights = ($oApp->getUserId()=='1');

$oTpl->set_block('main_block', 'force_short_block', 'force_short');
if ($bSpecialAdminRights)
{
    $bShortForce = ($aFilterSettings['Short_force'] ?? 0);
    $bShortUrlFile = is_readable($sAppPath.'short.php');
    $sChecked      = (($bShortUrlFile) ? ' checked="checked"' : '');
    if ($bShortForce)
    {
        $oTpl->set_var('LOAD_SHORT_URL', $oTrans->MOD_MAIL_FILTER_DELETE_SHORT_URL);
        $oTpl->set_var('Short_force_FILTER_CHECK',  ' checked="checked"' );
    } else {
        $oTpl->set_var('LOAD_SHORT_URL', $oTrans->MOD_MAIL_FILTER_LOAD_SHORT_URL);
        $oTpl->set_var('Short_force_FILTER_CHECK', $sChecked );
    }
    $oTpl->parse('force_short', 'force_short_block', true);
}
else
{
    $oTpl->set_block('force_short_block', '');
}

$oTpl->set_block('main_block', 'edit_short_block', 'edit_short');
if ($bSpecialAdminRights)
{
    // KORREKTUR: Die Logik zur Anzeigeerzwingung wird wiederhergestellt
    $bShortForce = ($aFilterSettings['Short_force'] ?? 0);
    $bEditForce  = ($aFilterSettings['edit_force'] ?? 0) | $bShortForce;
    $bEditForce = true;  // WIEDERHERGESTELLT: Diese Zeile erzwingt die Anzeige des htaccess-Blocks.

    if ($bEditForce)
    {
        $oTpl->loadfile('page1');
        $oTpl->set_block('modal', 'show_modal_block', 'show_modal');
        $sHtaccesTemplate = 'themes/default/htaccess_form.htt';
        if (is_readable($sAddonPath.$sHtaccesTemplate)) {
            $sTemplate = file_get_contents($sAddonPath.$sHtaccesTemplate);
            $oTpl->set_var('INCL_HTACCESS',($sTemplate));
        }

        $sHtaccesFile = '.htaccess';
        $oTpl->set_var('Edit_force_FILTER_CHECK', ' checked="checked"' );
        if (is_writable($oReg->AppPath.$sHtaccesFile)){
            $oTpl->set_var('W3_HIDE','w3-show');
            $oTpl->set_var('EDIT_HTACCESS_FILE', $oTrans->MOD_MAIL_FILTER_LOAD_EDIT_URL);
            $content = file_get_contents($oReg->AppPath.$sHtaccesFile);
        } else {
            $oTpl->set_var('W3_HIDE','w3-hide');
            $oTpl->set_var('EDIT_HTACCESS_FILE', $oTrans->MOD_MAIL_FILTER_ADD_EDIT_URL);
            $content = '';
        }
        $aHtaccessBlocks = glob($sAppPath.'install/htaccess/*', \GLOB_NOSORT);
        $aDefaultHtaccess = [];
        array_walk(
            $aHtaccessBlocks,
            function (& $sItem, $iKey) use (& $aDefaultHtaccess)
            {
                $sKey = \str_replace(['%redirect', '%'], '', '%'.\basename($sItem, '.inc'));
                $sItem = \str_replace(['%redirect', '%'], 'Redirect ', '%'.\basename($sItem, '.inc'));
                $aDefaultHtaccess[$sKey] = $sItem;
            }
        );
        $oTpl->set_var($aDefaultHtaccess);
        $sOptions = '';
        foreach ($aDefaultHtaccess as $sKey => $sValue) {
            $sOptions .= (sprintf('<option value="%s">%s</option>'."\n",$sKey,$sValue));
        }
        $oTpl->set_var('OPTION',$sOptions);
        if (is_readable($oReg->AppPath.'short.php')){
            $sFilename = $oReg->AppPath.'install/htaccess/redirectShortUrl.inc';
            if (is_readable($sFilename)){
              $content = (!empty(($content)) ? ($content) : file_get_contents($sFilename));
            }
            else
            {
              $content = (!empty(($content)) ? ($content) : $oTrans->MOD_MAIL_FILTER_HTACCESS_CODES);
            }
        }
        $aSerchesChars = ['{','}','pages','admin','media','modules'];
        $aReplaceChars = ['{','}',trim($oReg->PagesDir,'/'),trim($oReg->AcpDir,'/'),trim($oReg->MediaDir,'/'),trim($oReg->ModuleDir,'/')];
        $sContent = str_replace($aSerchesChars,$aReplaceChars,$content);
        $aEditAreaData = [
            'HTACCES_FILE'          => $sHtaccesFile,
            'ADDON_NAME'            => $sAddonName,
            'PAGE_ID'               => ($page_id ?? -1),
            'SECTION_ID'            => ($section_id ?? -1),
            'WB_URL'                => $oReg->AppUrl,
            'CONTENT'               => $sContent,
            'TEXT_SAVE'             => (is_readable($oReg->AppPath.'.htaccess') ? ($TEXT['SAVE'] ?? 'Save') : ($TEXT['ADD'] ?? 'Add')),
            'TEXT_BACK'             => ($TEXT['BACK'] ?? 'Back'),
            'TEXT_CANCEL'           => ($TEXT['CANCEL'] ?? 'Cancel'),
            'SECTION'               => ($section_id ?? -1),
            'FTAN'                  => $admin->getFTAN()
        ];
        $oTpl->set_var($aEditAreaData);
        $oTpl->parse('edit_short', 'edit_short_block', true);
    } else {
        $oTpl->set_var('Edit_force_FILTER_CHECK', '' );
        $oTpl->set_block('edit_short_block', '');
    }
}
else
{
    $oTpl->set_block('edit_short_block', '');
}

$oTpl->set_block('main_block', 'force_w3css_block', 'force_w3css');
if (isset($aFilterSettings['W3Css']) && $aFilterSettings['W3Css_force']) // Korrigierte Großschreibung
{
    $oTpl->set_var('W3Css_force_FILTER_CHECK',  ' checked="checked"' );
} else {
    $oTpl->set_var('W3Css_force_FILTER_CHECK',  '' ); // Sicherstellen, dass hier nichts ausgegeben wird, wenn die Bedingung nicht zutrifft
}
$oTpl->parse('force_w3css', 'force_w3css_block', true);

$oTpl->set_var($oTrans->getLangArray());

// --- SEITE AUSGEBEN ---
if(!$admin_header) { $admin->print_header(); }
if ($bSpecialAdminRights) {
    $oTpl->parse('show_modal', 'show_modal_block', true);
}
$oTpl->parse('main', 'main_block', true);
$oTpl->pparse('output', 'page');