<?php
/**
 *
 * @category        modules
 * @package         output_filter
 * @copyright        Manuela v.d.Decken <manuela@isteam.de>
 * @author          $Author$
 * @license         GNU General Public License 2.0
 * @version         4.0.1
 * @revision        $Revision$
 * @since           $Date$
 * @lastmodified    $Date$
 * @deprecated      no
 * @description     CoreTranslation -  All translations by Google AI
 * @svn-id          $Header$
 *
 */


// Set the language information
$language_code     = 'DE';
$language_name     = 'Deutsch';
$language_version  = '4.0.1';
$language_platform = '2.11.0';
$language_author   = 'Jacobi22';// All translations by Google AI
$language_license  = 'GNU General Public License 2.0';

// Modulbeschreibung auf Deutsch
$module_description  = 'Dieses Modul ermöglicht die Filterung von Inhalten, bevor sie im Frontend angezeigt werden. Unterstützt das Filtern von E-Mail-Adressen in Mailto-Links und im Text.';
$module_description .= '<span id="help-modfiles" style="visibility:hidden;"> <b>Achtung!</b> RegisterModfiles ist aktiviert, daher können einige Filter nicht geändert werden. Um alle Filter individuell einstellen zu können, muss RegisterModfiles deaktiviert werden.</span>';

// Überschriften und Textausgabe
$MOD_MAIL_FILTER['HEADING']    = 'Optionen: Ausgabe-Filterung';
$MOD_MAIL_FILTER['HOWTO']      = 'Die Ausgabe-Filterung kann über folgende Optionen konfiguriert werden.<b>Tipp: </b>Mailto-Links können mit einer Javascript-Routine verschlüsselt werden!';
$MOD_MAIL_FILTER['W3CSS']      = 'Mit den folgenden Optionen kann der Filter W3Css konfiguriert werden. <b>Die externe w3.css kann mit dieser Einstellung dauerhaft geladen werden!</b>.';
$MOD_MAIL_FILTER['WARNING']    = 'Geben Sie eigene Filter in der Reihenfolge ein, in der sie verarbeitet werden sollen. Diese private Liste ist optional, wird beim Upgrade nicht überschrieben und an die Liste der Standardfilter angehängt. Hinweis: Bei einer leeren privaten Filterliste bleiben die Standardfilter erhalten.';

// Texte aus Formularelementen
$MOD_MAIL_FILTER['SET_ACTIVE']        = 'Filter aktivieren/deaktivieren';
$MOD_MAIL_FILTER['CLICK_HELP']        = 'Für Hilfe auf die Bezeichnung klicken';
$MOD_MAIL_FILTER['BASIC_CONF']        = 'Grundeinstellungen';
$MOD_MAIL_FILTER['SYS_REL']           = 'Frontend-Ausgabe mit relativen URLs';
$MOD_MAIL_FILTER['opf']               = 'Ausgabe-Filter Dashboard';
$MOD_MAIL_FILTER['EMAIL_FILTER']      = 'E-Mail-Adressen im Text filtern';
$MOD_MAIL_FILTER['MAILTO_FILTER']     = 'E-Mail-Adressen in Mailto filtern';
$MOD_MAIL_FILTER['ENABLED']           = 'Aktiviert';
$MOD_MAIL_FILTER['DISABLED']          = 'Deaktiviert';
$MOD_MAIL_FILTER['LOAD_W3CSS']        = 'W3CSS dauerhaft laden';
$MOD_MAIL_FILTER['REPLACEMENT_CONF']  = 'E-Mail-Ersetzungen';
$MOD_MAIL_FILTER['AT_REPLACEMENT']    = '"@" ersetzen durch';
$MOD_MAIL_FILTER['DOT_REPLACEMENT']   = '"." ersetzen durch';
$MOD_MAIL_FILTER['ACTIVE_MODFILES']   = "Achtung! RegisterModfiles ist aktiviert, daher können einige Filter nicht geändert werden. Um alle Filter individuell einstellen zu können, muss RegisterModfiles deaktiviert werden.";

$TEXT['SAVE_LIST']  = 'Liste speichern';
$TEXT['ADD_LIST']   = 'Liste erstellen';
$TEXT['EMPTY_LIST'] = 'Liste leeren';

$output_filter_help = [
    'Droplets'=>'Führt Droplets aus',
    'Email'=>'E-Mail-Links werden schwerer lesbar und schwerer auszuspionieren.',
    'SnippetCss'=>'Lädt externe Snippet-/Tool-Styles mit <code>register_frontend_modfiles("css")</code> in den HEAD',
    'FrontendCss'=>'Lädt externe Seitenmodul-Styles mit <code>register_frontend_modfiles("css")</code> in den HEAD',
    'ScriptVars'=>'Setzt Javascript-Variablen zur Weiterverarbeitung im HEAD',
    'FrontendJs'=>'Lädt externe Seitenmodul-Skripte in den HEAD',
    'SnippetBodyJs'=>'Lädt externe Snippet-/Tool-Skripte mit <code>register_frontend_modfiles_body("js")</code> vor dem Ende des BODY.<br />'
                    . 'Es ist nicht notwendig, den Filter RegisterModFiles zu aktivieren.',
    'LoadOnFly'=>'Lädt DomReady und LoadOnFly-Skripte in den HEAD zum dynamischen Nachladen externer Styles',
    'Jquery'=>'Ermöglicht die Integration von jQuery<br />'
             . '<ol start="1">'
             . '<li>1) RegisterModFiles aktiviert (altes Verfahren)</li>'
             . '<ul style="padding-left: 1.525em;">'
             . '<li>Laden von jQuery in den HEAD mit <code>register_frontend_modfiles("jquery")</code></li>'
             . '<li>Laden von jQuery vor dem BODY-Ende mit <code>register_frontend_modfiles_body("jquery")</code></li>'
             . '<li>Setzen der jQuery-Checkbox ist nicht erforderlich</li>'
             . '</ul>'
             . '<li>2) RegisterModFiles deaktiviert (neues Verfahren)</li>'
             . '<ul style="padding-left: 1.525em;">'
             . '<li>Laden von jQuery in den HEAD mit </li>'
             . '<li><code>register_frontend_modfiles("css")</code></li>'
             . '<li>Setzen der jQuery-Checkbox ist erforderlich</li>'
             . '</ul>'
             . '</ol>',
    'JqueryUI'=>'Aktiviert jQueryUI für jQuery',
    'SnippetJs'=>'Lädt externe Snippet-/Tool-Skripte in den HEAD',
    'FrontendBodyJs'=>'Lädt externe Seitenmodul-Skripte mit <code>register_frontend_modfiles_body("js")</code> vor dem Ende des BODY.<br />'
                    . 'Es ist nicht notwendig, RegisterModFiles zu aktivieren.',
    'OpF'=>'Ausgabe-Filter Dashboard',
    'RegisterModFiles'=>'<p>Zur Unterstützung älterer Templates und zur Rückwärtskompatibilität<br />'
                        . 'werden die Funktionen <code>register_frontend_modfiles...</code> verwendet</p>'
                        . '<ol>'
                        . '<li style="font-weight:bold;">1) RegisterModFiles aktiviert (altes Verfahren)</li>'
                        . '<ul style="padding-left: 1.525em;">'
                        . '<li>Setzen der Checkboxen ist nicht erforderlich und hat keinen Einfluss auf das Einfügen</li>'
                        . '<li>Laden externer Styles mit <code>register_frontend_modfiles("css")</code>.</li>'
                        . '<li>Laden externer Skripte mit <code>register_frontend_modfiles("js")</code>.</li>'
                        . '<li>Laden von jQuery mit <code>register_frontend_modfiles("jquery")</code>.</li>'
                        . '<li>Zusätzlich Laden von <code>ScriptVar, domReady.js und LoadOnFly.js</code>.</li>'
                        . '<li>&nbsp;</li>'
                        . '<li>Laden der front_body.js-Skripte vor dem BODY-Ende <br />'
                        . '<code>register_frontend_modfiles_body("jquery")</code> und<br />'
                        . '<code>register_frontend_modfiles_body("js")</code><br />'
                        . '</li>'
                        . '</ul>'
                        . '<li style="font-weight:bold;">2) RegisterModFiles deaktiviert (neues Verfahren)</li>'
                        . '<ul style="padding-left: 1.525em;">'
                        . '<li>Lädt alle externen Styles/Skripte über <code>register_frontend_modfiles("css")</code> in den HEAD</li>'
                        . '<li>Durch Setzen der Checkboxen bestimmen Sie selbst, was eingebunden werden soll</li>'
                        . '</ul>'
                        . '</ol>',
    'at_replacement'=>'',
    'dot_replacement'=>'',
    'RelUrl'=>'Wandelt absolute in relative URLs um',
    'OutputFilterMode'=>'',
    'ReplaceSysvar'=>'',
    'WbLink'=>'Ersetzt den wblink-Platzhalter durch absolute URLs',
    'email_filter'=>'',
    'mailto_filter'=>'',
    'CssToHead'=> 'Sucht den Inhalt nach Style-Blöcken und Link-CSS-Tags'
                  . ' und verschiebt diese in den HEAD-Bereich!',
    'W3Css' => 'Gilt für nicht-W3Css-kompatible Templates und Module, die mit W3Css gestylt sind<br />'
               . 'Durchsucht den Inhalt nach dem ersten W3Css-Klassen-Selektor'
               . ' und lädt die benötigte externe w3.css in den HEAD-Bereich!<br />'
               . '</b>Wenn der Filter aktiviert ist, kann dies die Ausgabe im Frontend beeinflussen!</b>',
];

$MOD_MAIL_FILTER['HELP_MISSING'] = 'Für diesen Filter ist noch keine Hilfe vorhanden';

/* Alle Shorturl- und htaccess-Sprachvariablen */
$MOD_MAIL_FILTER['LOAD_SHORT_URL']    = 'ShortUrl aktivieren';
$MOD_MAIL_FILTER['WHITHOUT_HTACCESS'] = '(ohne htaccess)';
$MOD_MAIL_FILTER['DELETE_SHORT_URL']  = 'ShortUrl deaktivieren';
$MOD_MAIL_FILTER['ADD_EDIT_URL']      = 'Neue .htaccess bearbeiten';
$MOD_MAIL_FILTER['LOAD_EDIT_URL']     = 'Vorhandene .htaccess bearbeiten';
$MOD_MAIL_FILTER['DELETE_EDIT_URL']   = '.htaccess löschen';
$TEXT['DELETE_HTACCESS']              = '.htaccess löschen';
$TEXT['RESET_HTACCESS']               = 'Eingaben verwerfen';
$TEXT['IMPORT_HTACCESS']              = 'Importieren';
$TEXT['PLEASE_SELECT_HTACCESS']       = 'Textblock auswählen';
$MOD_MAIL_FILTER['SHORT_URL']         = 'Die ShortUrl kann über folgende Optionen konfiguriert werden. Aktivieren der Checkbox erzeugt die <b>short.php im Anwendungsordner</b>. Deaktivieren entfernt die short.php wieder!';
$MOD_MAIL_FILTER['HTACCESS_URL']      = 'Die .htaccess kann über folgende Optionen konfiguriert werden. Der ShortUrl-Codeabschnitt wird hinzugefügt und die Datei wird erstellt, wenn sie nicht vorhanden ist. Eine vorhandene .htaccess kann bearbeitet, angepasst oder gelöscht werden!';
$MOD_MAIL_FILTER['HTACCES']           = '.htaccess-Datei erstellen, löschen und bearbeiten';

$MOD_MAIL_FILTER['REDIRECT_CODE'] =
'## eingefügt aus der Sprachdatei
## diese Zeile darf nur einmal in der .htaccess erscheinen und sollte die erste aktive Zeile sein
RewriteEngine On
## Weiterleitung auf https einfügen ------------------------------
RewriteCond %{HTTP_HOST} ^www\.(.*)$ [NC]
RewriteRule ^(.*)$ https://%1/$1 [R=301,L]
RewriteCond %{HTTPS} !on
RewriteRule (.*) https://%{HTTP_HOST}%{REQUEST_URI} [R=301,L]';

$MOD_MAIL_FILTER['HTACCESS_CODES'] =
'## eingefügt aus der Sprachdatei
## diese Zeile darf nur einmal in der .htaccess erscheinen und sollte die erste aktive Zeile sein
RewriteEngine On
## BEGIN SHORTURL -----------------------------------------
## Wenn alte URLs direkt aufgerufen werden – Weiterleitung zur ShortUrl-Version
RewriteCond %{REQUEST_URI} !/pages/intro.php
RewriteCond %{REQUEST_URI} /pages
RewriteRule ^pages/(.*).php$ /$1/ [R=301,L]

## Anfrage an short.php zur Verarbeitung weiterleiten
RewriteCond %{REQUEST_URI} !^/(pages|account|admin|framework|include|languages|media|modules|search|temp|templates|var|vendor)/.*$
RewriteCond %{REQUEST_FILENAME} !-d
RewriteCond %{REQUEST_FILENAME} !-f
RewriteRule ^([\/\sa-zA-Z0-9._-]+)$ /short.php?_wb=$1 [QSA,L]
## END SHORTURL -------------------------------------------
';