<?php
// All available TLDs
Configure::set('Opensrs.tlds', [
    '.abogado',
    '.ac',
    '.academy',
    '.accountant',
    '.accountants',
    '.actor',
    '.adult',
    '.ae',
    '.aero',
    '.af',
    '.africa',
    '.ag',
    '.agency',
    '.ai',
    '.airforce',
    '.alsace',
    '.am',
    '.amsterdam',
    '.apartments',
    '.app',
    '.ar',
    '.archi',
    '.army',
    '.art',
    '.as',
    '.asia',
    '.associates',
    '.at',
    '.attorney',
    '.au',
    '.auction',
    '.audio',
    '.auto',
    '.baby',
    '.band',
    '.bar',
    '.barcelona',
    '.bargains',
    '.bayern',
    '.be',
    '.beauty',
    '.beer',
    '.berlin',
    '.best',
    '.bet',
    '.bid',
    '.bike',
    '.bingo',
    '.bio',
    '.biz',
    '.black',
    '.blackfriday',
    '.blog',
    '.blue',
    '.boston',
    '.boutique',
    '.br',
    '.brussels',
    '.build',
    '.builders',
    '.business',
    '.buzz',
    '.bz',
    '.bzh',
    '.ca',
    '.cab',
    '.cafe',
    '.camera',
    '.camp',
    '.capetown',
    '.capital',
    '.car',
    '.cards',
    '.care',
    '.careers',
    '.cars',
    '.casa',
    '.cash',
    '.casino',
    '.cat',
    '.catering',
    '.cc',
    '.cd',
    '.center',
    '.ceo',
    '.ch',
    '.charity',
    '.chat',
    '.cheap',
    '.christmas',
    '.church',
    '.city',
    '.cl',
    '.claims',
    '.cleaning',
    '.click',
    '.clinic',
    '.clothing',
    '.cloud',
    '.club',
    '.cm',
    '.cn',
    '.co',
    '.coach',
    '.codes',
    '.coffee',
    '.college',
    '.cologne',
    '.com',
    '.community',
    '.company',
    '.computer',
    '.condos',
    '.construction',
    '.consulting',
    '.contractors',
    '.cooking',
    '.cool',
    '.coop',
    '.corsica',
    '.country',
    '.coupons',
    '.courses',
    '.credit',
    '.creditcard',
    '.cricket',
    '.cruises',
    '.cx',
    '.cymru',
    '.cz',
    '.dance',
    '.date',
    '.dating',
    '.de',
    '.deals',
    '.degree',
    '.delivery',
    '.democrat',
    '.dental',
    '.dentist',
    '.desi',
    '.dev',
    '.design',
    '.diamonds',
    '.diet',
    '.digital',
    '.direct',
    '.directory',
    '.discount',
    '.dk',
    '.doctor',
    '.dog',
    '.domains',
    '.download',
    '.durban',
    '.earth',
    '.ec',
    '.education',
    '.email',
    '.energy',
    '.engineer',
    '.engineering',
    '.enterprises',
    '.equipment',
    '.es',
    '.estate',
    '.eu',
    '.events',
    '.exchange',
    '.expert',
    '.exposed',
    '.express',
    '.fail',
    '.faith',
    '.family',
    '.fan',
    '.fans',
    '.farm',
    '.fashion',
    '.feedback',
    '.fi',
    '.film',
    '.finance',
    '.financial',
    '.fish',
    '.fishing',
    '.fit',
    '.fitness',
    '.flights',
    '.florist',
    '.flowers',
    '.fm',
    '.football',
    '.forsale',
    '.foundation',
    '.fr',
    '.frl',
    '.fun',
    '.fund',
    '.furniture',
    '.futbol',
    '.fyi',
    '.gallery',
    '.game',
    '.games',
    '.garden',
    '.gay',
    '.gd',
    '.gg',
    '.gift',
    '.gifts',
    '.gives',
    '.gl',
    '.glass',
    '.global',
    '.gmbh',
    '.gold',
    '.golf',
    '.gr',
    '.graphics',
    '.gratis',
    '.green',
    '.gripe',
    '.group',
    '.gs',
    '.guide',
    '.guitars',
    '.guru',
    '.gy',
    '.hair',
    '.hamburg',
    '.haus',
    '.health',
    '.healthcare',
    '.help',
    '.hiphop',
    '.hiv',
    '.hk',
    '.hm',
    '.hn',
    '.hockey',
    '.holdings',
    '.holiday',
    '.homes*',
    '.horse',
    '.hospital',
    '.host',
    '.hosting',
    '.house',
    '.how',
    '.hr',
    '.ht',
    '.hu',
    '.il',
    '.im',
    '.immo',
    '.immobilien',
    '.in',
    '.inc',
    '.industries',
    '.info',
    '.ink',
    '.institute',
    '.insure',
    '.international',
    '.investments',
    '.io',
    '.irish',
    '.is',
    '.ist',
    '.istanbul',
    '.it',
    '.je',
    '.jetzt',
    '.jewelry',
    '.jobs',
    '.joburg',
    '.jp',
    '.juegos',
    '.kaufen',
    '.kg',
    '.ki',
    '.kim',
    '.kitchen',
    '.kiwi',
    '.koeln',
    '.kr',
    '.la',
    '.land',
    '.law',
    '.lawyer',
    '.lc',
    '.lease',
    '.legal',
    '.lgbt',
    '.li',
    '.life',
    '.lighting',
    '.limited',
    '.limo',
    '.link',
    '.live',
    '.llc',
    '.loan ',
    '.loans',
    '.lol',
    '.london',
    '.love',
    '.lt',
    '.ltd ',
    '.ltda',
    '.lu',
    '.luxury',
    '.lv',
    '.ly',
    '.ma',
    '.maison',
    '.management',
    '.makeup',
    '.market',
    '.marketing',
    '.mba',
    '.md',
    '.me',
    '.media',
    '.melbourne',
    '.memorial',
    '.men',
    '.menu',
    '.miami',
    '.mn',
    '.mobi',
    '.moda',
    '.moe',
    '.mom',
    '.money',
    '.monster',
    '.mortgage',
    '.movie',
    '.ms',
    '.mu',
    '.mx',
    '.my',
    '.nagoya',
    '.name',
    '.navy',
    '.net',
    '.network',
    '.news',
    '.ngo/.ong',
    '.ninja',
    '.nl',
    '.no',
    '.nrw',
    '.nu',
    '.nyc',
    '.nz',
    '.observer',
    '.one',
    '.online',
    '.org',
    '.organic',
    '.page*',
    '.paris',
    '.partners',
    '.parts',
    '.party',
    '.pe',
    '.pet',
    '.ph',
    '.photo',
    '.photography',
    '.photos',
    '.physio',
    '.pics',
    '.pictures',
    '.pink',
    '.pizza',
    '.pl',
    '.place',
    '.plumbing',
    '.plus',
    '.pm',
    '.poker',
    '.porn',
    '.pr',
    '.press',
    '.pro',
    '.productions',
    '.promo',
    '.properties',
    '.property',
    '.protection',
    '.pt',
    '.pub',
    '.pw',
    '.qa',
    '.quebec',
    '.quest',
    '.racing',
    '.re',
    '.realestate',
    '.realty',
    '.recipes',
    '.red',
    '.rehab',
    '.reise',
    '.reisen',
    '.rent',
    '.rentals',
    '.repair',
    '.report',
    '.republican',
    '.rest',
    '.restaurant',
    '.review',
    '.reviews',
    '.rio',
    '.rip',
    '.ro',
    '.rocks',
    '.rodeo',
    '.ru',
    '.ruhr',
    '.run',
    '.sale',
    '.salon',
    '.sarl',
    '.sb',
    '.sc',
    '.school',
    '.schule',
    '.science',
    '.scot',
    '.se',
    '.security',
    '.services',
    '.sex',
    '.sexy',
    '.sg',
    '.sh',
    '.shiksha',
    '.shoes',
    '.shop',
    '.shopping',
    '.show',
    '.si',
    '.singles',
    '.site',
    '.ski',
    '.skin',
    '.so',
    '.soccer',
    '.social',
    '.software',
    '.solar',
    '.solutions',
    '.soy',
    '.space',
    '.sport',
    '.sr',
    '.srl',
    '.st',
    '.storage',
    '.store',
    '.stream',
    '.studio',
    '.study',
    '.style',
    '.sucks',
    '.supplies',
    '.supply',
    '.support',
    '.surf',
    '.surgery',
    '.sx',
    '.sydney',
    '.systems',
    '.tattoo',
    '.tax',
    '.taxi',
    '.tc',
    '.team',
    '.tech',
    '.technology',
    '.tel',
    '.tennis',
    '.tf',
    '.theater',
    '.theatre',
    '.tienda',
    '.tips',
    '.tires',
    '.tirol',
    '.tk',
    '.tl',
    '.tm',
    '.to',
    '.today',
    '.tokyo',
    '.tools',
    '.top',
    '.tours',
    '.town',
    '.trade',
    '.training',
    '.travel',
    '.tube',
    '.tv',
    '.tw',
    '.ua',
    '.uk',
    '.university',
    '.uno',
    '.us',
    '.uy',
    '.vacations',
    '.vc',
    '.ve',
    '.vegas',
    '.ventures',
    '.vet',
    '.vg',
    '.viajes',
    '.video',
    '.villas',
    '.vin',
    '.vip',
    '.vision',
    '.vlaanderen',
    '.vodka',
    '.vote',
    '.voto',
    '.voyage',
    '.wales',
    '.watch',
    '.webcam',
    '.website',
    '.wedding',
    '.wf',
    '.wien',
    '.wiki',
    '.win',
    '.wine',
    '.work',
    '.works',
    '.world',
    '.ws',
    '.wtf',
    '.xxx',
    '.xyz',
    '.yoga',
    '.yokohama',
    '.yt',
    '.za',
    '.zone'
]);

// Transfer fields
Configure::set('Opensrs.transfer_fields', [
    'domain' => [
        'label' => Language::_('Opensrs.transfer.domain', true),
        'type' => 'text'
    ],
    'auth_info' => [
        'label' => Language::_('Opensrs.transfer.auth_info', true),
        'type' => 'text'
    ]
]);

// Domain fields
Configure::set('Opensrs.domain_fields', [
    'domain' => [
        'label' => Language::_('Opensrs.domain.domain', true),
        'type' => 'text'
    ],
]);

// Nameserver fields
Configure::set('Opensrs.nameserver_fields', [
    'nameserver_list[0][name]' => [
        'label' => Language::_('Opensrs.nameserver.ns1', true),
        'type' => 'text'
    ],
    'nameserver_list[1][name]' => [
        'label' => Language::_('Opensrs.nameserver.ns2', true),
        'type' => 'text'
    ],
    'nameserver_list[2][name]' => [
        'label' => Language::_('Opensrs.nameserver.ns3', true),
        'type' => 'text'
    ],
    'nameserver_list[3][name]' => [
        'label' => Language::_('Opensrs.nameserver.ns4', true),
        'type' => 'text'
    ],
    'custom_nameservers' => [
        'type' => 'hidden',
        'options' => '1'
    ],
    'custom_transfer_nameservers' => [
        'type' => 'hidden',
        'options' => '1'
    ]
]);

// Whois fields
Configure::set('Opensrs.whois_fields', [
    'contact_set[owner][first_name]' => [
        'label' => Language::_('Opensrs.whois.owner.first_name', true),
        'type' => 'text'
    ],
    'contact_set[owner][last_name]' => [
        'label' => Language::_('Opensrs.whois.owner.last_name', true),
        'type' => 'text'
    ],
    'contact_set[owner][org_name]' => [
        'label' => Language::_('Opensrs.whois.owner.org_name', true),
        'type' => 'text'
    ],
    'contact_set[owner][address1]' => [
        'label' => Language::_('Opensrs.whois.owner.address1', true),
        'type' => 'text'
    ],
    'contact_set[owner][address2]' => [
        'label' => Language::_('Opensrs.whois.owner.address2', true),
        'type' => 'text'
    ],
    'contact_set[owner][city]' => [
        'label' => Language::_('Opensrs.whois.owner.city', true),
        'type' => 'text'
    ],
    'contact_set[owner][state]' => [
        'label' => Language::_('Opensrs.whois.owner.state', true),
        'type' => 'text'
    ],
    'contact_set[owner][postal_code]' => [
        'label' => Language::_('Opensrs.whois.owner.postal_code', true),
        'type' => 'text'
    ],
    'contact_set[owner][country]' => [
        'label' => Language::_('Opensrs.whois.owner.country', true),
        'type' => 'text'
    ],
    'contact_set[owner][phone]' => [
        'label' => Language::_('Opensrs.whois.owner.phone', true),
        'type' => 'text'
    ],
    'contact_set[owner][email]' => [
        'label' => Language::_('Opensrs.whois.owner.email', true),
        'type' => 'text'
    ],
    'contact_set[tech][first_name]' => [
        'label' => Language::_('Opensrs.whois.tech.first_name', true),
        'type' => 'text'
    ],
    'contact_set[tech][last_name]' => [
        'label' => Language::_('Opensrs.whois.tech.last_name', true),
        'type' => 'text'
    ],
    'contact_set[tech][org_name]' => [
        'label' => Language::_('Opensrs.whois.tech.org_name', true),
        'type' => 'text'
    ],
    'contact_set[tech][address1]' => [
        'label' => Language::_('Opensrs.whois.tech.address1', true),
        'type' => 'text'
    ],
    'contact_set[tech][address2]' => [
        'label' => Language::_('Opensrs.whois.tech.address2', true),
        'type' => 'text'
    ],
    'contact_set[tech][city]' => [
        'label' => Language::_('Opensrs.whois.tech.city', true),
        'type' => 'text'
    ],
    'contact_set[tech][state]' => [
        'label' => Language::_('Opensrs.whois.tech.state', true),
        'type' => 'text'
    ],
    'contact_set[tech][postal_code]' => [
        'label' => Language::_('Opensrs.whois.tech.postal_code', true),
        'type' => 'text'
    ],
    'contact_set[tech][country]' => [
        'label' => Language::_('Opensrs.whois.tech.country', true),
        'type' => 'text'
    ],
    'contact_set[tech][phone]' => [
        'label' => Language::_('Opensrs.whois.tech.phone', true),
        'type' => 'text'
    ],
    'contact_set[tech][email]' => [
        'label' => Language::_('Opensrs.whois.tech.email', true),
        'type' => 'text'
    ],
    'contact_set[admin][first_name]' => [
        'label' => Language::_('Opensrs.whois.admin.first_name', true),
        'type' => 'text'
    ],
    'contact_set[admin][last_name]' => [
        'label' => Language::_('Opensrs.whois.admin.last_name', true),
        'type' => 'text'
    ],
    'contact_set[admin][org_name]' => [
        'label' => Language::_('Opensrs.whois.admin.org_name', true),
        'type' => 'text'
    ],
    'contact_set[admin][address1]' => [
        'label' => Language::_('Opensrs.whois.admin.address1', true),
        'type' => 'text'
    ],
    'contact_set[admin][address2]' => [
        'label' => Language::_('Opensrs.whois.admin.address2', true),
        'type' => 'text'
    ],
    'contact_set[admin][city]' => [
        'label' => Language::_('Opensrs.whois.admin.city', true),
        'type' => 'text'
    ],
    'contact_set[admin][state]' => [
        'label' => Language::_('Opensrs.whois.admin.state', true),
        'type' => 'text'
    ],
    'contact_set[admin][postal_code]' => [
        'label' => Language::_('Opensrs.whois.admin.postal_code', true),
        'type' => 'text'
    ],
    'contact_set[admin][country]' => [
        'label' => Language::_('Opensrs.whois.admin.country', true),
        'type' => 'text'
    ],
    'contact_set[admin][phone]' => [
        'label' => Language::_('Opensrs.whois.admin.phone', true),
        'type' => 'text'
    ],
    'contact_set[admin][email]' => [
        'label' => Language::_('Opensrs.whois.admin.email', true),
        'type' => 'text'
    ],
    'contact_set[billing][first_name]' => [
        'label' => Language::_('Opensrs.whois.billing.first_name', true),
        'type' => 'text'
    ],
    'contact_set[billing][last_name]' => [
        'label' => Language::_('Opensrs.whois.billing.last_name', true),
        'type' => 'text'
    ],
    'contact_set[billing][org_name]' => [
        'label' => Language::_('Opensrs.whois.billing.org_name', true),
        'type' => 'text'
    ],
    'contact_set[billing][address1]' => [
        'label' => Language::_('Opensrs.whois.billing.address1', true),
        'type' => 'text'
    ],
    'contact_set[billing][address2]' => [
        'label' => Language::_('Opensrs.whois.billing.address2', true),
        'type' => 'text'
    ],
    'contact_set[billing][city]' => [
        'label' => Language::_('Opensrs.whois.billing.city', true),
        'type' => 'text'
    ],
    'contact_set[billing][state]' => [
        'label' => Language::_('Opensrs.whois.billing.state', true),
        'type' => 'text'
    ],
    'contact_set[billing][postal_code]' => [
        'label' => Language::_('Opensrs.whois.billing.postal_code', true),
        'type' => 'text'
    ],
    'contact_set[billing][country]' => [
        'label' => Language::_('Opensrs.whois.billing.country', true),
        'type' => 'text'
    ],
    'contact_set[billing][phone]' => [
        'label' => Language::_('Opensrs.whois.billing.phone', true),
        'type' => 'text'
    ],
    'contact_set[billing][email]' => [
        'label' => Language::_('Opensrs.whois.billing.email', true),
        'type' => 'text'
    ]
]);

// .US
Configure::set('Opensrs.domain_fields.us', [
    'tld_data[nexus][category]' => [
        'label' => Language::_('Opensrs.domain.category', true),
        'type' => 'select',
        'options' => [
            'C11' => Language::_('Opensrs.domain.category.c11', true),
            'C12' => Language::_('Opensrs.domain.category.c12', true),
            'C21' => Language::_('Opensrs.domain.category.c21', true),
            'C31' => Language::_('Opensrs.domain.category.c31', true),
            'C32' => Language::_('Opensrs.domain.category.c32', true)
        ]
    ],
    'tld_data[nexus][app_purpose]' => [
        'label' => Language::_('Opensrs.domain.app_purpose', true),
        'type' => 'select',
        'options' => [
            'P1' => Language::_('Opensrs.domain.app_purpose.p1', true),
            'P2' => Language::_('Opensrs.domain.app_purpose.p2', true),
            'P3' => Language::_('Opensrs.domain.app_purpose.p3', true),
            'P4' => Language::_('Opensrs.domain.app_purpose.p4', true),
            'P5' => Language::_('Opensrs.domain.app_purpose.p5', true)
        ]
    ]
]);

// .EU
Configure::set('Opensrs.domain_fields.eu', [
    'owner_confirm_address' => [
        'label' => Language::_('Opensrs.domain.owner_confirm_address', true),
        'type' => 'text'
    ]
]);

// .CA
Configure::set('Opensrs.domain_fields.ca', [
    'registrant_extra_info[legal_type]' => [
        'label' => Language::_('Opensrs.domain.legal_type', true),
        'type' => 'select',
        'options' => [
            'CCO' => Language::_('Opensrs.domain.legal_type.cco', true),
            'CCT' => Language::_('Opensrs.domain.legal_type.cct', true),
            'RES' => Language::_('Opensrs.domain.legal_type.res', true),
            'GOV' => Language::_('Opensrs.domain.legal_type.gov', true),
            'EDU' => Language::_('Opensrs.domain.legal_type.edu', true),
            'ASS' => Language::_('Opensrs.domain.legal_type.ass', true),
            'HOP' => Language::_('Opensrs.domain.legal_type.hop', true),
            'PRT' => Language::_('Opensrs.domain.legal_type.prt', true),
            'TDM' => Language::_('Opensrs.domain.legal_type.tdm', true),
            'TRD' => Language::_('Opensrs.domain.legal_type.trd', true),
            'PLT' => Language::_('Opensrs.domain.legal_type.plt', true),
            'LAM' => Language::_('Opensrs.domain.legal_type.lam', true),
            'TRS' => Language::_('Opensrs.domain.legal_type.trs', true),
            'ABO' => Language::_('Opensrs.domain.legal_type.abo', true),
            'INB' => Language::_('Opensrs.domain.legal_type.inb', true),
            'LGR' => Language::_('Opensrs.domain.legal_type.lgr', true),
            'OMK' => Language::_('Opensrs.domain.legal_type.omk', true),
            'MAJ' => Language::_('Opensrs.domain.legal_type.maj', true)
        ]
    ]
]);

// .UK
Configure::set('Opensrs.domain_fields.uk', [
    'registrant_extra_info[registrant_type]' => [
        'label' => Language::_('Opensrs.domain.registrant_type', true),
        'type' => 'select',
        'options' => [
            'IND' => Language::_('Opensrs.domain.registrant_type.ind', true),
            'FIND' => Language::_('Opensrs.domain.registrant_type.find', true),
            'LTD' => Language::_('Opensrs.domain.registrant_type.ltd', true),
            'PLC' => Language::_('Opensrs.domain.registrant_type.plc', true),
            'PTNR' => Language::_('Opensrs.domain.registrant_type.ptnr', true),
            'LLP' => Language::_('Opensrs.domain.registrant_type.llp', true),
            'IP' => Language::_('Opensrs.domain.registrant_type.ip', true),
            'STRA' => Language::_('Opensrs.domain.registrant_type.stra', true),
            'SCH' => Language::_('Opensrs.domain.registrant_type.sch', true),
            'RCHAR' => Language::_('Opensrs.domain.registrant_type.rchar', true),
            'GOV' => Language::_('Opensrs.domain.registrant_type.gov', true),
            'OTHER' => Language::_('Opensrs.domain.registrant_type.other', true),
            'CRC' => Language::_('Opensrs.domain.registrant_type.crc', true),
            'FCORP' => Language::_('Opensrs.domain.registrant_type.fcorp', true),
            'STAT' => Language::_('Opensrs.domain.registrant_type.stat', true),
            'FOTHER' => Language::_('Opensrs.domain.registrant_type.fother', true)
        ]
    ],
    'registrant_extra_info[registration_number]' => [
        'label' => Language::_('Opensrs.domain.registration_number', true),
        'type' => 'text'
    ],
    'registrant_extra_info[trading_name]' => [
        'label' => Language::_('Opensrs.domain.trading_name', true),
        'type' => 'text'
    ]
]);

// .ASIA
Configure::set('Opensrs.domain_fields.asia', [
    'tld_data[ced_info][locality_country]' => [
        'type' => 'hidden',
        'options' => null
    ],
    'tld_data[ced_info][legal_entity_type]' => [
        'label' => Language::_('Opensrs.domain.legal_entity_type', true),
        'type' => 'select',
        'options' => [
            'corporation' => Language::_('Opensrs.domain.legal_entity_type.corporation', true),
            'cooperative' => Language::_('Opensrs.domain.legal_entity_type.cooperative', true),
            'partnership' => Language::_('Opensrs.domain.legal_entity_type.partnership', true),
            'government' => Language::_('Opensrs.domain.legal_entity_type.government', true),
            'politicalParty' => Language::_('Opensrs.domain.legal_entity_type.politicalParty', true),
            'society' => Language::_('Opensrs.domain.legal_entity_type.society', true),
            'institution' => Language::_('Opensrs.domain.legal_entity_type.institution', true),
            'naturalPerson' => Language::_('Opensrs.domain.legal_entity_type.naturalPerson', true)
        ]
    ],
    'tld_data[ced_info][id_type]' => [
        'label' => Language::_('Opensrs.domain.id_type', true),
        'type' => 'select',
        'options' => [
            'certificate' => Language::_('Opensrs.domain.id_type.certificate', true),
            'legislation' => Language::_('Opensrs.domain.id_type.legislation', true),
            'societyRegistry' => Language::_('Opensrs.domain.id_type.societyRegistry', true),
            'politicalPartyRegistry' => Language::_('Opensrs.domain.id_type.politicalPartyRegistry', true),
            'passport' => Language::_('Opensrs.domain.id_type.passport', true)
        ]
    ],
    'tld_data[ced_info][id_number]' => [
        'label' => Language::_('Opensrs.domain.id_number', true),
        'type' => 'text'
    ],
    'tld_data[ced_info][contact_type]' => [
        'type' => 'hidden',
        'options' => 'admin'
    ]
]);

// .DE
Configure::set('Opensrs.domain_fields.de', [
    'owner_confirm_address' => [
        'label' => Language::_('Opensrs.domain.owner_confirm_address', true),
        'type' => 'text'
    ]
]);

// .FR
Configure::set('Opensrs.domain_fields.fr', [
    'tld_data[registrant_extra_info][registrant_type]' => [
        'label' => Language::_('Opensrs.domain.registrant_type', true),
        'type' => 'select',
        'options' => [
            'individual' => Language::_('Opensrs.domain.registrant_type.individual', true),
            'organization' => Language::_('Opensrs.domain.registrant_type.company', true),
        ]
    ],
    'tld_data[registrant_extra_info][registrant_vat_id]' => [
        'label' => Language::_('Opensrs.domain.registrant_vat_id', true),
        'type' => 'text'
    ],
    'tld_data[registrant_extra_info][siren_siret]' => [
        'label' => Language::_('Opensrs.domain.siren_siret', true),
        'type' => 'text'
    ],
    'tld_data[registrant_extra_info][trademark_number]' => [
        'label' => Language::_('Opensrs.domain.trademark_number', true),
        'type' => 'text'
    ]
]);

// .IT
Configure::set('Opensrs.domain_fields.it', [
    'tld_data[it_registrant_info][nationality_code]' => [
        'type' => 'hidden',
        'options' => 'IT'
    ],
    'tld_data[it_registrant_info][reg_code]' => [
        'label' => Language::_('Opensrs.domain.reg_code', true),
        'type' => 'hidden',
        'options' => 'IT'
    ],
    'tld_data[it_registrant_info][entity_type]' => [
        'label' => Language::_('Opensrs.domain.entity_type', true),
        'type' => 'select',
        'options' => [
            '1' => Language::_('Opensrs.domain.entity_type.1', true),
            '2' => Language::_('Opensrs.domain.entity_type.2', true),
        ]
    ]
]);

// .LAW
Configure::set('Opensrs.domain_fields.law', [
    'tld_data[registrant_extra_info][icm_membership_id]' => [
        'label' => Language::_('Opensrs.domain.qli_accreditation_id', true),
        'type' => 'text'
    ],
    'tld_data[registrant_extra_info][qli_accreditation_body]' => [
        'label' => Language::_('Opensrs.domain.qli_accreditation_body', true),
        'type' => 'text'
    ],
    'tld_data[registrant_extra_info][qli_jurisdiction_country]' => [
        'label' => Language::_('Opensrs.domain.qli_jurisdiction_country', true),
        'type' => 'text'
    ],
    'tld_data[registrant_extra_info][qli_jurisdiction_state]' => [
        'label' => Language::_('Opensrs.domain.qli_jurisdiction_state', true),
        'type' => 'text'
    ],
    'tld_data[registrant_extra_info][qli_accreditation_year]' => [
        'label' => Language::_('Opensrs.domain.qli_accreditation_year', true),
        'type' => 'text'
    ]
]);
Configure::set('Opensrs.domain_fields.abogado', Configure::get('Opensrs.domain_fields.law'));

// .XXX
Configure::set('Opensrs.domain_fields.xxx', [
    'tld_data[ipr_data][icm_membership_id]' => [
        'label' => Language::_('Opensrs.domain.icm_membership_id', true),
        'type' => 'text'
    ]
]);

// Email templates
Configure::set('Opensrs.email_templates', [
    'en_us' => [
        'lang' => 'en_us',
        'text' => 'Your new domain has been successfully registered!

Domain: {service.domain}

Thank you for your business!',
        'html' => '<p>Your new domain has been successfully registered!</p>
<p>Domain: {service.domain}</p>
<p>Thank you for your business!</p>'
    ]
]);
