<?php
/**
 * ZoneRecordServiceApi
 * PHP version 5
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Dns
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * DNS
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0-beta
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.0.3
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Openprovider\Api\Rest\Client\Dns\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Openprovider\Api\Rest\Client\Base\ApiException;
use Openprovider\Api\Rest\Client\Base\Configuration;
use Openprovider\Api\Rest\Client\Base\HeaderSelector;
use Openprovider\Api\Rest\Client\Base\ObjectSerializer;

/**
 * ZoneRecordServiceApi Class Doc Comment
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Dns
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ZoneRecordServiceApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation listZoneRecords
     *
     * List zone records
     *
     * @param  string $name DNS record name (required)
     * @param  int $zone_id DNS zone ID. (optional)
     * @param  int $limit How many records to retrieve (default: 100, max 500). (optional, default to 100)
     * @param  int $offset From which record to retrieve (default: 0). (optional)
     * @param  string $order_by_type Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_name Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_value Sorting type (asc/desc). (optional)
     * @param  string $order_by_ttl Sorting type (asc/desc). (optional)
     * @param  string $order_by_prio Sorting type (asc/desc). (optional)
     * @param  string $record_name_pattern DNS record name pattern. Wildcard (*) can be used. (optional)
     * @param  string $value_pattern DNS record value pattern. Wildcard (*) can be used. (optional)
     * @param  string $type DNS record type. (optional)
     * @param  int $prio DNS record priority. (optional)
     * @param  int $ttl DNS record TTL. (optional)
     * @param  string $zone_provider Name of the DNS provider. Set zone_provider&#x3D;sectigo in case of only sectigo premium DNS zone records should be retrieved. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Dns\Model\RecordListZoneRecordsResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError
     */
    public function listZoneRecords($name, $zone_id = null, $limit = 100, $offset = null, $order_by_type = 'asc', $order_by_name = 'asc', $order_by_value = null, $order_by_ttl = null, $order_by_prio = null, $record_name_pattern = null, $value_pattern = null, $type = null, $prio = null, $ttl = null, $zone_provider = null)
    {
        list($response) = $this->listZoneRecordsWithHttpInfo($name, $zone_id, $limit, $offset, $order_by_type, $order_by_name, $order_by_value, $order_by_ttl, $order_by_prio, $record_name_pattern, $value_pattern, $type, $prio, $ttl, $zone_provider);
        return $response;
    }

    /**
     * Operation listZoneRecordsWithHttpInfo
     *
     * List zone records
     *
     * @param  string $name DNS record name (required)
     * @param  int $zone_id DNS zone ID. (optional)
     * @param  int $limit How many records to retrieve (default: 100, max 500). (optional, default to 100)
     * @param  int $offset From which record to retrieve (default: 0). (optional)
     * @param  string $order_by_type Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_name Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_value Sorting type (asc/desc). (optional)
     * @param  string $order_by_ttl Sorting type (asc/desc). (optional)
     * @param  string $order_by_prio Sorting type (asc/desc). (optional)
     * @param  string $record_name_pattern DNS record name pattern. Wildcard (*) can be used. (optional)
     * @param  string $value_pattern DNS record value pattern. Wildcard (*) can be used. (optional)
     * @param  string $type DNS record type. (optional)
     * @param  int $prio DNS record priority. (optional)
     * @param  int $ttl DNS record TTL. (optional)
     * @param  string $zone_provider Name of the DNS provider. Set zone_provider&#x3D;sectigo in case of only sectigo premium DNS zone records should be retrieved. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Dns\Model\RecordListZoneRecordsResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listZoneRecordsWithHttpInfo($name, $zone_id = null, $limit = 100, $offset = null, $order_by_type = 'asc', $order_by_name = 'asc', $order_by_value = null, $order_by_ttl = null, $order_by_prio = null, $record_name_pattern = null, $value_pattern = null, $type = null, $prio = null, $ttl = null, $zone_provider = null)
    {
        $request = $this->listZoneRecordsRequest($name, $zone_id, $limit, $offset, $order_by_type, $order_by_name, $order_by_value, $order_by_ttl, $order_by_prio, $record_name_pattern, $value_pattern, $type, $prio, $ttl, $zone_provider);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\RecordListZoneRecordsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\RecordListZoneRecordsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\RecordListZoneRecordsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\RecordListZoneRecordsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listZoneRecordsAsync
     *
     * List zone records
     *
     * @param  string $name DNS record name (required)
     * @param  int $zone_id DNS zone ID. (optional)
     * @param  int $limit How many records to retrieve (default: 100, max 500). (optional, default to 100)
     * @param  int $offset From which record to retrieve (default: 0). (optional)
     * @param  string $order_by_type Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_name Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_value Sorting type (asc/desc). (optional)
     * @param  string $order_by_ttl Sorting type (asc/desc). (optional)
     * @param  string $order_by_prio Sorting type (asc/desc). (optional)
     * @param  string $record_name_pattern DNS record name pattern. Wildcard (*) can be used. (optional)
     * @param  string $value_pattern DNS record value pattern. Wildcard (*) can be used. (optional)
     * @param  string $type DNS record type. (optional)
     * @param  int $prio DNS record priority. (optional)
     * @param  int $ttl DNS record TTL. (optional)
     * @param  string $zone_provider Name of the DNS provider. Set zone_provider&#x3D;sectigo in case of only sectigo premium DNS zone records should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listZoneRecordsAsync($name, $zone_id = null, $limit = 100, $offset = null, $order_by_type = 'asc', $order_by_name = 'asc', $order_by_value = null, $order_by_ttl = null, $order_by_prio = null, $record_name_pattern = null, $value_pattern = null, $type = null, $prio = null, $ttl = null, $zone_provider = null)
    {
        return $this->listZoneRecordsAsyncWithHttpInfo($name, $zone_id, $limit, $offset, $order_by_type, $order_by_name, $order_by_value, $order_by_ttl, $order_by_prio, $record_name_pattern, $value_pattern, $type, $prio, $ttl, $zone_provider)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listZoneRecordsAsyncWithHttpInfo
     *
     * List zone records
     *
     * @param  string $name DNS record name (required)
     * @param  int $zone_id DNS zone ID. (optional)
     * @param  int $limit How many records to retrieve (default: 100, max 500). (optional, default to 100)
     * @param  int $offset From which record to retrieve (default: 0). (optional)
     * @param  string $order_by_type Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_name Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_value Sorting type (asc/desc). (optional)
     * @param  string $order_by_ttl Sorting type (asc/desc). (optional)
     * @param  string $order_by_prio Sorting type (asc/desc). (optional)
     * @param  string $record_name_pattern DNS record name pattern. Wildcard (*) can be used. (optional)
     * @param  string $value_pattern DNS record value pattern. Wildcard (*) can be used. (optional)
     * @param  string $type DNS record type. (optional)
     * @param  int $prio DNS record priority. (optional)
     * @param  int $ttl DNS record TTL. (optional)
     * @param  string $zone_provider Name of the DNS provider. Set zone_provider&#x3D;sectigo in case of only sectigo premium DNS zone records should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listZoneRecordsAsyncWithHttpInfo($name, $zone_id = null, $limit = 100, $offset = null, $order_by_type = 'asc', $order_by_name = 'asc', $order_by_value = null, $order_by_ttl = null, $order_by_prio = null, $record_name_pattern = null, $value_pattern = null, $type = null, $prio = null, $ttl = null, $zone_provider = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\RecordListZoneRecordsResponse';
        $request = $this->listZoneRecordsRequest($name, $zone_id, $limit, $offset, $order_by_type, $order_by_name, $order_by_value, $order_by_ttl, $order_by_prio, $record_name_pattern, $value_pattern, $type, $prio, $ttl, $zone_provider);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listZoneRecords'
     *
     * @param  string $name DNS record name (required)
     * @param  int $zone_id DNS zone ID. (optional)
     * @param  int $limit How many records to retrieve (default: 100, max 500). (optional, default to 100)
     * @param  int $offset From which record to retrieve (default: 0). (optional)
     * @param  string $order_by_type Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_name Sorting type (asc/desc). (optional, default to 'asc')
     * @param  string $order_by_value Sorting type (asc/desc). (optional)
     * @param  string $order_by_ttl Sorting type (asc/desc). (optional)
     * @param  string $order_by_prio Sorting type (asc/desc). (optional)
     * @param  string $record_name_pattern DNS record name pattern. Wildcard (*) can be used. (optional)
     * @param  string $value_pattern DNS record value pattern. Wildcard (*) can be used. (optional)
     * @param  string $type DNS record type. (optional)
     * @param  int $prio DNS record priority. (optional)
     * @param  int $ttl DNS record TTL. (optional)
     * @param  string $zone_provider Name of the DNS provider. Set zone_provider&#x3D;sectigo in case of only sectigo premium DNS zone records should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listZoneRecordsRequest($name, $zone_id = null, $limit = 100, $offset = null, $order_by_type = 'asc', $order_by_name = 'asc', $order_by_value = null, $order_by_ttl = null, $order_by_prio = null, $record_name_pattern = null, $value_pattern = null, $type = null, $prio = null, $ttl = null, $zone_provider = null)
    {
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling listZoneRecords'
            );
        }

        $resourcePath = '/v1beta/dns/zones/{name}/records';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($zone_id !== null) {
            $queryParams['zone_id'] = ObjectSerializer::toQueryValue($zone_id);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($order_by_type !== null) {
            $queryParams['order_by.type'] = ObjectSerializer::toQueryValue($order_by_type);
        }
        // query params
        if ($order_by_name !== null) {
            $queryParams['order_by.name'] = ObjectSerializer::toQueryValue($order_by_name);
        }
        // query params
        if ($order_by_value !== null) {
            $queryParams['order_by.value'] = ObjectSerializer::toQueryValue($order_by_value);
        }
        // query params
        if ($order_by_ttl !== null) {
            $queryParams['order_by.ttl'] = ObjectSerializer::toQueryValue($order_by_ttl);
        }
        // query params
        if ($order_by_prio !== null) {
            $queryParams['order_by.prio'] = ObjectSerializer::toQueryValue($order_by_prio);
        }
        // query params
        if ($record_name_pattern !== null) {
            $queryParams['record_name_pattern'] = ObjectSerializer::toQueryValue($record_name_pattern);
        }
        // query params
        if ($value_pattern !== null) {
            $queryParams['value_pattern'] = ObjectSerializer::toQueryValue($value_pattern);
        }
        // query params
        if ($type !== null) {
            $queryParams['type'] = ObjectSerializer::toQueryValue($type);
        }
        // query params
        if ($prio !== null) {
            $queryParams['prio'] = ObjectSerializer::toQueryValue($prio);
        }
        // query params
        if ($ttl !== null) {
            $queryParams['ttl'] = ObjectSerializer::toQueryValue($ttl);
        }
        // query params
        if ($zone_provider !== null) {
            $queryParams['zone_provider'] = ObjectSerializer::toQueryValue($zone_provider);
        }

        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
