<?php
// Domain fields
Configure::set('RealtimeRegister.domain_fields', [
    'domain' => [
        'label' => Language::_('RealtimeRegister.service_fields.domain', true),
        'type' => 'text'
    ]
]);

// Transfer fields
Configure::set('RealtimeRegister.transfer_fields', [
    'authcode' => [
        'label' => Language::_('RealtimeRegister.service_fields.authcode', true),
        'type' => 'text'
    ]
]);

// Nameserver fields
Configure::set('RealtimeRegister.nameserver_fields', [
    'ns[1]' => [
        'label' => Language::_('RealtimeRegister.service_fields.ns1', true),
        'type' => 'text'
    ],
    'ns[2]' => [
        'label' => Language::_('RealtimeRegister.service_fields.ns2', true),
        'type' => 'text'
    ],
    'ns[3]' => [
        'label' => Language::_('RealtimeRegister.service_fields.ns3', true),
        'type' => 'text'
    ],
    'ns[4]' => [
        'label' => Language::_('RealtimeRegister.service_fields.ns4', true),
        'type' => 'text'
    ],
    'ns[5]' => [
        'label' => Language::_('RealtimeRegister.service_fields.ns5', true),
        'type' => 'text'
    ]
]);

// All available TLDs
Configure::set('RealtimeRegister.tlds', [
    '.fr',
    '.pm',
    '.re',
    '.tf',
    '.wf',
    '.yt',
    '.bot',
    '.deal',
    '.moi',
    '.now',
    '.am',
    '.ryukyu',
    '.okinawa',
    '.bayern',
    '.berlin',
    '.ac.cn',
    '.ac.xn--fiqs8s',
    '.ah.cn',
    '.ah.xn--fiqs8s',
    '.bj.cn',
    '.bj.xn--fiqs8s',
    '.cn',
    '.com.cn',
    '.com.xn--fiqs8s',
    '.cq.cn',
    '.cq.xn--fiqs8s',
    '.fj.cn',
    '.fj.xn--fiqs8s',
    '.gd.cn',
    '.gd.xn--fiqs8s',
    '.gs.cn',
    '.gs.xn--fiqs8s',
    '.gx.cn',
    '.gx.xn--fiqs8s',
    '.gz.cn',
    '.gz.xn--fiqs8s',
    '.ha.cn',
    '.ha.xn--fiqs8s',
    '.hb.cn',
    '.hb.xn--fiqs8s',
    '.he.cn',
    '.he.xn--fiqs8s',
    '.hi.cn',
    '.hi.xn--fiqs8s',
    '.hl.cn',
    '.hl.xn--fiqs8s',
    '.hn.cn',
    '.hn.xn--fiqs8s',
    '.jl.cn',
    '.jl.xn--fiqs8s',
    '.js.cn',
    '.js.xn--fiqs8s',
    '.jx.cn',
    '.jx.xn--fiqs8s',
    '.ln.cn',
    '.ln.xn--fiqs8s',
    '.net.cn',
    '.net.xn--fiqs8s',
    '.nm.cn',
    '.nm.xn--fiqs8s',
    '.nx.cn',
    '.nx.xn--fiqs8s',
    '.org.cn',
    '.org.xn--fiqs8s',
    '.qh.cn',
    '.qh.xn--fiqs8s',
    '.sc.cn',
    '.sc.xn--fiqs8s',
    '.sd.cn',
    '.sd.xn--fiqs8s',
    '.sh.cn',
    '.sh.xn--fiqs8s',
    '.sn.cn',
    '.sn.xn--fiqs8s',
    '.sx.cn',
    '.sx.xn--fiqs8s',
    '.tj.cn',
    '.tj.xn--fiqs8s',
    '.tw.cn',
    '.tw.xn--fiqs8s',
    '.xj.cn',
    '.xj.xn--fiqs8s',
    '.xn--fiqs8s',
    '.xz.cn',
    '.xz.xn--fiqs8s',
    '.yn.cn',
    '.yn.xn--fiqs8s',
    '.zj.cn',
    '.zj.xn--fiqs8s',
    '.best',
    '.mom',
    '.website',
    '.ooo',
    '.ceo',
    '.flowers',
    '.fans',
    '.reit',
    '.makeup',
    '.audio',
    '.london',
    '.inc',
    '.dealer',
    '.college',
    '.site',
    '.hair',
    '.pw',
    '.autos',
    '.boats',
    '.bond',
    '.build',
    '.case',
    '.cfd',
    '.cyou',
    '.desi',
    '.gd',
    '.help',
    '.homes',
    '.luxury',
    '.motorcycles',
    '.sbs',
    '.spreadbetting',
    '.yachts',
    '.theatre',
    '.tickets',
    '.skin',
    '.art',
    '.fun',
    '.gl',
    '.diet',
    '.cars',
    '.qpon',
    '.christmas',
    '.hosting',
    '.uno',
    '.auto',
    '.space',
    '.blog',
    '.security',
    '.host',
    '.protection',
    '.saarland',
    '.guitars',
    '.beauty',
    '.press',
    '.quest',
    '.online',
    '.storage',
    '.car',
    '.lat',
    '.fo',
    '.pics',
    '.tech',
    '.store',
    '.frl',
    '.monster',
    '.game',
    '.icu',
    '.lol',
    '.rent',
    '.baby',
    '.bh',
    '.biz.bh',
    '.cc.bh',
    '.com.bh',
    '.edu.bh',
    '.cam',
    '.xyz',
    '.gent',
    '.gg',
    '.je',
    '.gs',
    '.cx',
    '.gy',
    '.hn',
    '.ki',
    '.nf',
    '.sb',
    '.tl',
    '.af',
    '.ht',
    '.barcelona',
    '.cat',
    '.eus',
    '.radio',
    '.scot',
    '.sport',
    '.de',
    '.dk',
    '.lu',
    '.com.pt',
    '.pt',
    '.be',
    '.brussels',
    '.vlaanderen',
    '.lt',
    '.archi',
    '.bet',
    '.black',
    '.blue',
    '.broker',
    '.forex',
    '.green',
    '.kim',
    '.lgbt',
    '.llc',
    '.lotto',
    '.markets',
    '.organic',
    '.pet',
    '.pink',
    '.poker',
    '.promo',
    '.red',
    '.shiksha',
    '.trading',
    '.vote',
    '.voto',
    '.travel',
    '.spa',
    '.me',
    '.asia',
    '.ai',
    '.watches',
    '.info',
    '.aero',
    '.bz',
    '.co.bz',
    '.com.bz',
    '.net.bz',
    '.mn',
    '.kids',
    '.co.lc',
    '.com.lc',
    '.l.lc',
    '.lc',
    '.net.lc',
    '.org.lc',
    '.p.lc',
    '.mobi',
    '.xn--6frz82g',
    '.sc',
    '.pro',
    '.ac.mu',
    '.co.mu',
    '.com.mu',
    '.edu.mu',
    '.mu',
    '.net.mu',
    '.nom.mu',
    '.or.mu',
    '.org.mu',
    '.ag',
    '.co.ag',
    '.com.ag',
    '.net.ag',
    '.nom.ag',
    '.org.ag',
    '.stockholm',
    '.sh',
    '.ac',
    '.io',
    '.academy',
    '.accountants',
    '.actor',
    '.agency',
    '.airforce',
    '.apartments',
    '.army',
    '.associates',
    '.attorney',
    '.auction',
    '.band',
    '.bargains',
    '.bike',
    '.bingo',
    '.boutique',
    '.builders',
    '.business',
    '.cab',
    '.cafe',
    '.camera',
    '.camp',
    '.capital',
    '.cards',
    '.care',
    '.careers',
    '.cash',
    '.casino',
    '.catering',
    '.center',
    '.chat',
    '.cheap',
    '.church',
    '.city',
    '.claims',
    '.cleaning',
    '.clinic',
    '.clothing',
    '.coach',
    '.codes',
    '.coffee',
    '.community',
    '.company',
    '.computer',
    '.condos',
    '.construction',
    '.consulting',
    '.contractors',
    '.cool',
    '.coupons',
    '.credit',
    '.creditcard',
    '.cruises',
    '.dance',
    '.dating',
    '.deals',
    '.degree',
    '.delivery',
    '.democrat',
    '.dental',
    '.dentist',
    '.diamonds',
    '.digital',
    '.direct',
    '.directory',
    '.discount',
    '.doctor',
    '.dog',
    '.domains',
    '.education',
    '.email',
    '.energy',
    '.engineer',
    '.engineering',
    '.enterprises',
    '.equipment',
    '.estate',
    '.events',
    '.exchange',
    '.expert',
    '.exposed',
    '.express',
    '.fail',
    '.family',
    '.fan',
    '.farm',
    '.finance',
    '.financial',
    '.fish',
    '.fitness',
    '.flights',
    '.florist',
    '.football',
    '.forsale',
    '.fund',
    '.furniture',
    '.futbol',
    '.fyi',
    '.gallery',
    '.games',
    '.gifts',
    '.glass',
    '.gmbh',
    '.gold',
    '.golf',
    '.graphics',
    '.gratis',
    '.gripe',
    '.group',
    '.guide',
    '.guru',
    '.haus',
    '.healthcare',
    '.hockey',
    '.holdings',
    '.holiday',
    '.hospital',
    '.house',
    '.immo',
    '.immobilien',
    '.industries',
    '.institute',
    '.insure',
    '.international',
    '.investments',
    '.irish',
    '.jetzt',
    '.jewelry',
    '.kaufen',
    '.kitchen',
    '.land',
    '.lawyer',
    '.lease',
    '.legal',
    '.life',
    '.lighting',
    '.limited',
    '.limo',
    '.live',
    '.loans',
    '.ltd',
    '.maison',
    '.management',
    '.market',
    '.marketing',
    '.mba',
    '.media',
    '.memorial',
    '.moda',
    '.money',
    '.mortgage',
    '.movie',
    '.navy',
    '.network',
    '.news',
    '.ninja',
    '.partners',
    '.parts',
    '.photography',
    '.photos',
    '.pictures',
    '.pizza',
    '.place',
    '.plumbing',
    '.plus',
    '.productions',
    '.properties',
    '.pub',
    '.recipes',
    '.rehab',
    '.reise',
    '.reisen',
    '.rentals',
    '.repair',
    '.report',
    '.republican',
    '.restaurant',
    '.reviews',
    '.rip',
    '.rocks',
    '.run',
    '.sale',
    '.salon',
    '.sarl',
    '.school',
    '.schule',
    '.services',
    '.shoes',
    '.shopping',
    '.show',
    '.singles',
    '.soccer',
    '.social',
    '.software',
    '.solar',
    '.solutions',
    '.studio',
    '.style',
    '.supplies',
    '.supply',
    '.support',
    '.surgery',
    '.systems',
    '.tax',
    '.taxi',
    '.team',
    '.technology',
    '.tennis',
    '.theater',
    '.tienda',
    '.tips',
    '.tires',
    '.today',
    '.tools',
    '.tours',
    '.town',
    '.toys',
    '.training',
    '.university',
    '.vacations',
    '.ventures',
    '.vet',
    '.viajes',
    '.video',
    '.villas',
    '.vin',
    '.vision',
    '.voyage',
    '.watch',
    '.wine',
    '.works',
    '.world',
    '.wtf',
    '.xn--czrs0t',
    '.xn--fjq720a',
    '.xn--unup4y',
    '.xn--vhquv',
    '.zone',
    '.contact',
    '.ist',
    '.istanbul',
    '.ltda',
    '.srl',
    '.vegas',
    '.com.vc',
    '.net.vc',
    '.org.vc',
    '.vc',
    '.xn--5tzm5g',
    '.global',
    '.bio',
    '.ski',
    '.amsterdam',
    '.ph',
    '.fm',
    '.com.es',
    '.es',
    '.nom.es',
    '.org.es',
    '.xn--e1a4c',
    '.eu',
    '.xn--qxa6a',
    '.fi',
    '.eco',
    '.sx',
    '.yokohama',
    '.tokyo',
    '.nagoya',
    '.jp',
    '.kyoto',
    '.shop',
    '.page',
    '.dad',
    '.esq',
    '.foo',
    '.ing',
    '.meme',
    '.mov',
    '.nexus',
    '.phd',
    '.prof',
    '.zip',
    '.boo',
    '.soy',
    '.channel',
    '.rsvp',
    '.app',
    '.dev',
    '.day',
    '.xn--q9jyb4c',
    '.how',
    '.new',
    '.hamburg',
    '.ie',
    '.nu',
    '.se',
    '.cymru',
    '.jobs',
    '.realestate',
    '.wales',
    '.to',
    '.agro.pl',
    '.aid.pl',
    '.atm.pl',
    '.augustow.pl',
    '.auto.pl',
    '.babia-gora.pl',
    '.bedzin.pl',
    '.beskidy.pl',
    '.bialowieza.pl',
    '.bialystok.pl',
    '.bielawa.pl',
    '.bieszczady.pl',
    '.biz.pl',
    '.boleslawiec.pl',
    '.bydgoszcz.pl',
    '.bytom.pl',
    '.cieszyn.pl',
    '.com.pl',
    '.czeladz.pl',
    '.czest.pl',
    '.dlugoleka.pl',
    '.edu.pl',
    '.elblag.pl',
    '.elk.pl',
    '.glogow.pl',
    '.gmina.pl',
    '.gniezno.pl',
    '.gorlice.pl',
    '.grajewo.pl',
    '.gsm.pl',
    '.ilawa.pl',
    '.info.pl',
    '.jaworzno.pl',
    '.jelenia-gora.pl',
    '.jgora.pl',
    '.kalisz.pl',
    '.karpacz.pl',
    '.kartuzy.pl',
    '.kaszuby.pl',
    '.katowice.pl',
    '.kazimierz-dolny.pl',
    '.kepno.pl',
    '.ketrzyn.pl',
    '.klodzko.pl',
    '.kobierzyce.pl',
    '.kolobrzeg.pl',
    '.konin.pl',
    '.konskowola.pl',
    '.kutno.pl',
    '.lapy.pl',
    '.lebork.pl',
    '.legnica.pl',
    '.lezajsk.pl',
    '.limanowa.pl',
    '.lomza.pl',
    '.lowicz.pl',
    '.lubin.pl',
    '.lukow.pl',
    '.mail.pl',
    '.malbork.pl',
    '.malopolska.pl',
    '.mazowsze.pl',
    '.mazury.pl',
    '.media.pl',
    '.miasta.pl',
    '.mielec.pl',
    '.mielno.pl',
    '.mil.pl',
    '.mragowo.pl',
    '.naklo.pl',
    '.net.pl',
    '.nieruchomosci.pl',
    '.nom.pl',
    '.nowaruda.pl',
    '.nysa.pl',
    '.olawa.pl',
    '.olecko.pl',
    '.olkusz.pl',
    '.olsztyn.pl',
    '.opoczno.pl',
    '.opole.pl',
    '.org.pl',
    '.ostroda.pl',
    '.ostroleka.pl',
    '.ostrowiec.pl',
    '.ostrowwlkp.pl',
    '.pc.pl',
    '.pila.pl',
    '.pisz.pl',
    '.pl',
    '.podhale.pl',
    '.podlasie.pl',
    '.polkowice.pl',
    '.pomorskie.pl',
    '.pomorze.pl',
    '.powiat.pl',
    '.priv.pl',
    '.prochowice.pl',
    '.pruszkow.pl',
    '.przeworsk.pl',
    '.pulawy.pl',
    '.radom.pl',
    '.rawa-maz.pl',
    '.realestate.pl',
    '.rel.pl',
    '.rybnik.pl',
    '.rzeszow.pl',
    '.sanok.pl',
    '.sejny.pl',
    '.sex.pl',
    '.shop.pl',
    '.sklep.pl',
    '.skoczow.pl',
    '.slask.pl',
    '.slupsk.pl',
    '.sos.pl',
    '.sosnowiec.pl',
    '.stalowa-wola.pl',
    '.starachowice.pl',
    '.stargard.pl',
    '.suwalki.pl',
    '.swidnica.pl',
    '.swiebodzin.pl',
    '.swinoujscie.pl',
    '.szczecin.pl',
    '.szczytno.pl',
    '.szkola.pl',
    '.targi.pl',
    '.tarnobrzeg.pl',
    '.tgory.pl',
    '.tm.pl',
    '.tourism.pl',
    '.travel.pl',
    '.turek.pl',
    '.turystyka.pl',
    '.tychy.pl',
    '.ustka.pl',
    '.walbrzych.pl',
    '.warmia.pl',
    '.warszawa.pl',
    '.waw.pl',
    '.wegrow.pl',
    '.wielun.pl',
    '.wlocl.pl',
    '.wloclawek.pl',
    '.wodzislaw.pl',
    '.wolomin.pl',
    '.wroclaw.pl',
    '.zachpomor.pl',
    '.zagan.pl',
    '.zarow.pl',
    '.zgora.pl',
    '.zgorzelec.pl',
    '.club.tw',
    '.com.tw',
    '.ebiz.tw',
    '.game.tw',
    '.idv.tw',
    '.org.tw',
    '.tw',
    '.one',
    '.accountant',
    '.adult',
    '.basketball',
    '.beer',
    '.bible',
    '.bid',
    '.blackfriday',
    '.boston',
    '.buzz',
    '.casa',
    '.compare',
    '.cooking',
    '.cricket',
    '.date',
    '.design',
    '.download',
    '.earth',
    '.faith',
    '.fashion',
    '.film',
    '.fishing',
    '.fit',
    '.garden',
    '.gay',
    '.health',
    '.horse',
    '.ink',
    '.loan',
    '.luxe',
    '.melbourne',
    '.men',
    '.menu',
    '.miami',
    '.moe',
    '.osaka',
    '.party',
    '.photo',
    '.porn',
    '.racing',
    '.review',
    '.rodeo',
    '.rugby',
    '.science',
    '.select',
    '.sex',
    '.stream',
    '.sucks',
    '.surf',
    '.sydney',
    '.tattoo',
    '.trade',
    '.tube',
    '.vip',
    '.vodka',
    '.webcam',
    '.wedding',
    '.wiki',
    '.win',
    '.work',
    '.xxx',
    '.yoga',
    '.nrw',
    '.abogado',
    '.law',
    '.tv',
    '.biz',
    '.nyc',
    '.vu',
    '.us',
    '.courses',
    '.study',
    '.club',
    '.co',
    '.com.co',
    '.net.co',
    '.xn--d9b2bf3g1k.xn--s9brj9c',
    '.xn--d9b7cb3a6a.xn--s9brj9c',
    '.xn--s9brj9c',
    '.xn--x8b5axg2ab21a.xn--s9brj9c',
    '.xn--45brj9c',
    '.xn--b5b2au3c8d7b2b.xn--45brj9c',
    '.xn--p5b2bfp1g0b0b.xn--45brj9c',
    '.xn--p5b2bfp5fh3fra.xn--45brj9c',
    '.xn--p5b7cb3a6a.xn--45brj9c',
    '.xn--p5b9de2ac9f.xn--45brj9c',
    '.xn--r5b0alaxhm0qzbe.xn--45brj9c',
    '.xn--goc1b4ch5i8a.xn--mgbbh1a71e',
    '.xn--mgbbh1a71e',
    '.xn--mgbtbf5f.xn--mgbbh1a71e',
    '.xn--pgb4a7ae88d.xn--mgbbh1a71e',
    '.xn--0dc7cb3a6a.xn--gecrj9c',
    '.xn--gecrj9c',
    '.xn--hdc1b4ch5i.xn--gecrj9c',
    '.xn--iecsq2bc9f.xn--gecrj9c',
    '.xn--fpcrj9c3d',
    '.xn--goc1b4ch5i8a.xn--fpcrj9c3d',
    '.xn--goc1eramo6a1free.xn--fpcrj9c3d',
    '.xn--hpcsq2bc9f.xn--fpcrj9c3d',
    '.xn--11b7cb3a6a.xn--h2brj9c',
    '.xn--h2brj9c',
    '.xn--i1b1b4ch5i.xn--h2brj9c',
    '.xn--j2bsq2bc9f.xn--h2brj9c',
    '.5g.in',
    '.6g.in',
    '.ahmdabad.in',
    '.ai.in',
    '.am.in',
    '.bihar.in',
    '.biz.in',
    '.business.in',
    '.cn.in',
    '.co.in',
    '.com.in',
    '.coop.in',
    '.cs.in',
    '.delhi.in',
    '.dr.in',
    '.er.in',
    '.firm.in',
    '.gen.in',
    '.gujarat.in',
    '.in',
    '.ind.in',
    '.info.in',
    '.int.in',
    '.internet.in',
    '.io.in',
    '.me.in',
    '.net.in',
    '.org.in',
    '.pg.in',
    '.post.in',
    '.pro.in',
    '.travel.in',
    '.tv.in',
    '.uk.in',
    '.up.in',
    '.us.in',
    '.xn--clc2dj4b0d.xn--xkc2dl3a5ee0h',
    '.xn--vkc6b7c7c.xn--xkc2dl3a5ee0h',
    '.xn--vlccpku2dp3h.xn--xkc2dl3a5ee0h',
    '.xn--xkc2dl3a5ee0h',
    '.museum',
    '.paris',
    '.lv',
    '.at',
    '.co.at',
    '.or.at',
    '.biz.id',
    '.co.id',
    '.id',
    '.my.id',
    '.web.id',
    '.it',
    '.co.uk',
    '.ltd.uk',
    '.me.uk',
    '.net.uk',
    '.org.uk',
    '.plc.uk',
    '.uk',
    '.no',
    '.com.cv',
    '.cv',
    '.edu.cv',
    '.int.cv',
    '.net.cv',
    '.nome.cv',
    '.org.cv',
    '.publ.cv',
    '.ngo',
    '.xn--nqv7f',
    '.xn--i1b6b1a6a2e',
    '.charity',
    '.foundation',
    '.gives',
    '.giving',
    '.ong',
    '.org',
    '.xn--c1avg',
    '.ae',
    '.al',
    '.com.al',
    '.ao',
    '.co.ao',
    '.ar',
    '.com.ar',
    '.as',
    '.au',
    '.com.au',
    '.id.au',
    '.net.au',
    '.org.au',
    '.aw',
    '.ax',
    '.az',
    '.co.az',
    '.com.az',
    '.ba',
    '.bb',
    '.ac.bd',
    '.bd',
    '.biz.bd',
    '.co.bd',
    '.com.bd',
    '.info.bd',
    '.net.bd',
    '.org.bd',
    '.bg',
    '.bi',
    '.co.bi',
    '.com.bi',
    '.edu.bi',
    '.info.bi',
    '.or.bi',
    '.org.bi',
    '.bj',
    '.bm',
    '.bn',
    '.com.bn',
    '.bo',
    '.com.bo',
    '.net.bo',
    '.org.bo',
    '.br',
    '.com.br',
    '.net.br',
    '.org.br',
    '.bs',
    '.bt',
    '.com.bt',
    '.bw',
    '.co.bw',
    '.org.bw',
    '.by',
    '.ca',
    '.cd',
    '.cf',
    '.cg',
    '.ci',
    '.ck',
    '.co.ck',
    '.cl',
    '.cm',
    '.co.cm',
    '.com.cm',
    '.net.cm',
    '.co.cr',
    '.cr',
    '.or.cr',
    '.com.cu',
    '.cu',
    '.com.cw',
    '.cw',
    '.net.cw',
    '.com.cy',
    '.cy',
    '.cz',
    '.dj',
    '.dm',
    '.com.do',
    '.do',
    '.dz',
    '.com.ec',
    '.ec',
    '.net.ec',
    '.ee',
    '.com.eg',
    '.eg',
    '.biz.fj',
    '.com.fj',
    '.fj',
    '.info.fj',
    '.net.fj',
    '.org.fj',
    '.ga',
    '.com.ge',
    '.ge',
    '.gf',
    '.com.gh',
    '.gh',
    '.com.gi',
    '.gi',
    '.ltd.gi',
    '.org.gi',
    '.gm',
    '.gp',
    '.gq',
    '.com.gr',
    '.gr',
    '.com.gt',
    '.gt',
    '.com.gu',
    '.gu',
    '.gw',
    '.com.hk',
    '.hk',
    '.hm',
    '.com.hr',
    '.hr',
    '.2000.hu',
    '.agrar.hu',
    '.bolt.hu',
    '.casino.hu',
    '.city.hu',
    '.co.hu',
    '.erotica.hu',
    '.erotika.hu',
    '.film.hu',
    '.forum.hu',
    '.games.hu',
    '.hotel.hu',
    '.hu',
    '.info.hu',
    '.ingatlan.hu',
    '.jogasz.hu',
    '.konyvelo.hu',
    '.lakas.hu',
    '.media.hu',
    '.news.hu',
    '.org.hu',
    '.priv.hu',
    '.reklam.hu',
    '.sex.hu',
    '.shop.hu',
    '.sport.hu',
    '.suli.hu',
    '.szex.hu',
    '.tm.hu',
    '.tozsde.hu',
    '.utazas.hu',
    '.video.hu',
    '.co.il',
    '.il',
    '.org.il',
    '.im',
    '.ir',
    '.is',
    '.jo',
    '.co.ke',
    '.ke',
    '.kg',
    '.com.kh',
    '.kh',
    '.kn',
    '.co.kr',
    '.kr',
    '.or.kr',
    '.com.kw',
    '.kw',
    '.ky',
    '.kz',
    '.la',
    '.com.lb',
    '.lb',
    '.com.lk',
    '.edu.lk',
    '.lk',
    '.org.lk',
    '.com.ly',
    '.ly',
    '.ac.ma',
    '.co.ma',
    '.ma',
    '.net.ma',
    '.org.ma',
    '.press.ma',
    '.mc',
    '.md',
    '.mg',
    '.com.mk',
    '.mk',
    '.ml',
    '.biz.mm',
    '.com.mm',
    '.mm',
    '.org.mm',
    '.co.ms',
    '.com.ms',
    '.ms',
    '.com.mt',
    '.mt',
    '.com.mv',
    '.mv',
    '.mw',
    '.com.mx',
    '.mx',
    '.net.mx',
    '.org.mx',
    '.com.my',
    '.my',
    '.name.my',
    '.net.my',
    '.org.my',
    '.com.ng',
    '.edu.ng',
    '.net.ng',
    '.ng',
    '.org.ng',
    '.co.ni',
    '.com.ni',
    '.net.ni',
    '.ni',
    '.nr',
    '.co.nz',
    '.kiwi.nz',
    '.net.nz',
    '.nz',
    '.org.nz',
    '.com.pa',
    '.pa',
    '.com.pe',
    '.net.pe',
    '.nom.pe',
    '.org.pe',
    '.pe',
    '.com.pk',
    '.net.pk',
    '.org.pk',
    '.pk',
    '.com.pr',
    '.pr',
    '.com.ps',
    '.net.ps',
    '.org.ps',
    '.ps',
    '.com.py',
    '.py',
    '.qa',
    '.arts.ro',
    '.com.ro',
    '.firm.ro',
    '.info.ro',
    '.nom.ro',
    '.nt.ro',
    '.org.ro',
    '.rec.ro',
    '.ro',
    '.store.ro',
    '.tm.ro',
    '.www.ro',
    '.rs',
    '.rw',
    '.com.sa',
    '.sa',
    '.sd',
    '.com.sg',
    '.sg',
    '.si',
    '.com.sl',
    '.net.sl',
    '.org.sl',
    '.sl',
    '.sm',
    '.sn',
    '.so',
    '.sr',
    '.st',
    '.su',
    '.com.sv',
    '.sv',
    '.tc',
    '.td',
    '.co.th',
    '.in.th',
    '.th',
    '.com.tj',
    '.tj',
    '.tk',
    '.tm',
    '.com.tn',
    '.tn',
    '.bbs.tr',
    '.biz.tr',
    '.com.tr',
    '.gen.tr',
    '.info.tr',
    '.name.tr',
    '.net.tr',
    '.org.tr',
    '.tel.tr',
    '.tr',
    '.tv.tr',
    '.web.tr',
    '.co.tt',
    '.com.tt',
    '.net.tt',
    '.org.tt',
    '.tt',
    '.co.tz',
    '.tz',
    '.com.ua',
    '.ua',
    '.ug',
    '.com.uy',
    '.uy',
    '.uz',
    '.co.ve',
    '.com.ve',
    '.info.ve',
    '.net.ve',
    '.org.ve',
    '.ve',
    '.web.ve',
    '.vg',
    '.ac.vn',
    '.biz.vn',
    '.com.vn',
    '.info.vn',
    '.name.vn',
    '.net.vn',
    '.org.vn',
    '.pro.vn',
    '.vn',
    '.wien',
    '.cologne',
    '.koeln',
    '.tirol',
    '.africa',
    '.capetown',
    '.durban',
    '.joburg',
    '.org.sk',
    '.sk',
    '.nl',
    '.li',
    '.ch',
    '.xn--p1ai',
    '.net.ru',
    '.ru',
    '.tel',
    '.country',
    '.click',
    '.diy',
    '.food',
    '.gift',
    '.hiv',
    '.juegos',
    '.lifestyle',
    '.link',
    '.living',
    '.property',
    '.sexy',
    '.vana',
    '.bar',
    '.rest',
    '.observer',
    '.realty',
    '.feedback',
    '.forum',
    '.cloud',
    '.coop',
    '.creditunion',
    '.hiphop',
    '.locker',
    '.love',
    '.music',
    '.com',
    '.net',
    '.cc',
    '.name',
    '.ws',
    '.co.za',
    '.net.za',
    '.org.za',
    '.web.za',
    '.za',
    '.top',
    '.wang',
    '.xn--45q11c',
    '.xn--czru2d',
    '.xn--hxt814e'
]);

// .US
Configure::set('RealtimeRegister.domain_fields.us', [
    'RegistrantNexus' => [
        'label' => Language::_('RealtimeRegister.domain.RegistrantNexus', true),
        'type' => 'select',
        'options' => [
            'C11' => Language::_('RealtimeRegister.domain.RegistrantNexus.c11', true),
            'C12' => Language::_('RealtimeRegister.domain.RegistrantNexus.c12', true),
            'C21' => Language::_('RealtimeRegister.domain.RegistrantNexus.c21', true),
            'C31' => Language::_('RealtimeRegister.domain.RegistrantNexus.c31', true),
            'C32' => Language::_('RealtimeRegister.domain.RegistrantNexus.c32', true)
        ]
    ],
    'RegistrantPurpose' => [
        'label' => Language::_('RealtimeRegister.domain.RegistrantPurpose', true),
        'type' => 'select',
        'options' => [
            'P1' => Language::_('RealtimeRegister.domain.RegistrantPurpose.p1', true),
            'P2' => Language::_('RealtimeRegister.domain.RegistrantPurpose.p2', true),
            'P3' => Language::_('RealtimeRegister.domain.RegistrantPurpose.p3', true),
            'P4' => Language::_('RealtimeRegister.domain.RegistrantPurpose.p4', true),
            'P5' => Language::_('RealtimeRegister.domain.RegistrantPurpose.p5', true)
        ]
    ]
]);

// .EU
Configure::set('RealtimeRegister.domain_fields.eu', [
    'EUAgreeWhoisPolicy' => [
        'label' => Language::_('RealtimeRegister.domain.EUAgreeWhoisPolicy', true),
        'type' => 'checkbox',
        'options' => [
            'YES' => Language::_('RealtimeRegister.domain.EUAgreeWhoisPolicy.yes', true)
        ]
    ],
    'EUAgreeDeletePolicy' => [
        'label' => Language::_('RealtimeRegister.domain.EUAgreeDeletePolicy', true),
        'type' => 'checkbox',
        'options' => [
            'YES' => Language::_('RealtimeRegister.domain.EUAgreeDeletePolicy.yes', true)
        ]
    ]
]);

// .CA
Configure::set('RealtimeRegister.domain_fields.ca', [
    'CIRALegalType' => [
        'label' => Language::_('RealtimeRegister.domain.CIRALegalType', true),
        'type' => 'select',
        'options' => [
            'CCO' => Language::_('RealtimeRegister.domain.RegistrantPurpose.cco', true),
            'CCT' => Language::_('RealtimeRegister.domain.RegistrantPurpose.cct', true),
            'RES' => Language::_('RealtimeRegister.domain.RegistrantPurpose.res', true),
            'GOV' => Language::_('RealtimeRegister.domain.RegistrantPurpose.gov', true),
            'EDU' => Language::_('RealtimeRegister.domain.RegistrantPurpose.edu', true),
            'ASS' => Language::_('RealtimeRegister.domain.RegistrantPurpose.ass', true),
            'HOP' => Language::_('RealtimeRegister.domain.RegistrantPurpose.hop', true),
            'PRT' => Language::_('RealtimeRegister.domain.RegistrantPurpose.prt', true),
            'TDM' => Language::_('RealtimeRegister.domain.RegistrantPurpose.tdm', true),
            'TRD' => Language::_('RealtimeRegister.domain.RegistrantPurpose.trd', true),
            'PLT' => Language::_('RealtimeRegister.domain.RegistrantPurpose.plt', true),
            'LAM' => Language::_('RealtimeRegister.domain.RegistrantPurpose.lam', true),
            'TRS' => Language::_('RealtimeRegister.domain.RegistrantPurpose.trs', true),
            'ABO' => Language::_('RealtimeRegister.domain.RegistrantPurpose.abo', true),
            'INB' => Language::_('RealtimeRegister.domain.RegistrantPurpose.inb', true),
            'LGR' => Language::_('RealtimeRegister.domain.RegistrantPurpose.lgr', true),
            'OMK' => Language::_('RealtimeRegister.domain.RegistrantPurpose.omk', true),
            'MAJ' => Language::_('RealtimeRegister.domain.RegistrantPurpose.maj', true)
        ]
    ],
    'CIRAWhoisDisplay' => [
        'label' => Language::_('RealtimeRegister.domain.CIRAWhoisDisplay', true),
        'type' => 'select',
        'options' => [
            'Full' => Language::_('RealtimeRegister.domain.CIRAWhoisDisplay.full', true),
            'Private' => Language::_('RealtimeRegister.domain.CIRAWhoisDisplay.private', true),
        ]
    ],
    'CIRAAgreementVersion' => [
        'type' => 'hidden',
        'options' => '2.0'
    ],
    'CIRAAgreementValue' => [
        'type' => 'hidden',
        'options' => 'Y'
    ]
]);

// .CO.UK
Configure::set('RealtimeRegister.domain_fields.co.uk', [
    'COUKLegalType' => [
        'label' => Language::_('RealtimeRegister.domain.COUKLegalType', true),
        'type' => 'select',
        'options' => [
            'IND' => Language::_('RealtimeRegister.domain.COUKLegalType.ind', true),
            'FIND' => Language::_('RealtimeRegister.domain.COUKLegalType.find', true),
            'LTD' => Language::_('RealtimeRegister.domain.COUKLegalType.ltd', true),
            'PLC' => Language::_('RealtimeRegister.domain.COUKLegalType.plc', true),
            'PTNR' => Language::_('RealtimeRegister.domain.COUKLegalType.ptnr', true),
            'LLP' => Language::_('RealtimeRegister.domain.COUKLegalType.llp', true),
            'IP' => Language::_('RealtimeRegister.domain.COUKLegalType.ip', true),
            'STRA' => Language::_('RealtimeRegister.domain.COUKLegalType.stra', true),
            'SCH' => Language::_('RealtimeRegister.domain.COUKLegalType.sch', true),
            'RCHAR' => Language::_('RealtimeRegister.domain.COUKLegalType.rchar', true),
            'GOV' => Language::_('RealtimeRegister.domain.COUKLegalType.gov', true),
            'OTHER' => Language::_('RealtimeRegister.domain.COUKLegalType.other', true),
            'CRC' => Language::_('RealtimeRegister.domain.COUKLegalType.crc', true),
            'FCORP' => Language::_('RealtimeRegister.domain.COUKLegalType.fcorp', true),
            'STAT' => Language::_('RealtimeRegister.domain.COUKLegalType.stat', true),
            'FOTHER' => Language::_('RealtimeRegister.domain.COUKLegalType.fother', true)
        ]
    ],
    'COUKCompanyID' => [
        'label' => Language::_('RealtimeRegister.domain.COUKCompanyID', true),
        'type' => 'text'
    ],
    'COUKRegisteredfor' => [
        'label' => Language::_('RealtimeRegister.domain.COUKRegisteredfor', true),
        'type' => 'text'
    ]
]);

// .ME.UK
Configure::set('RealtimeRegister.domain_fields.me.uk', [
    'MEUKLegalType' => [
        'label' => Language::_('RealtimeRegister.domain.MEUKLegalType', true),
        'type' => 'select',
        'options' => [
            'IND' => Language::_('RealtimeRegister.domain.MEUKLegalType.ind', true),
            'FIND' => Language::_('RealtimeRegister.domain.MEUKLegalType.find', true),
            'LTD' => Language::_('RealtimeRegister.domain.MEUKLegalType.ltd', true),
            'PLC' => Language::_('RealtimeRegister.domain.MEUKLegalType.plc', true),
            'PTNR' => Language::_('RealtimeRegister.domain.MEUKLegalType.ptnr', true),
            'LLP' => Language::_('RealtimeRegister.domain.MEUKLegalType.llp', true),
            'IP' => Language::_('RealtimeRegister.domain.MEUKLegalType.ip', true),
            'STRA' => Language::_('RealtimeRegister.domain.MEUKLegalType.stra', true),
            'SCH' => Language::_('RealtimeRegister.domain.MEUKLegalType.sch', true),
            'RCHAR' => Language::_('RealtimeRegister.domain.MEUKLegalType.rchar', true),
            'GOV' => Language::_('RealtimeRegister.domain.MEUKLegalType.gov', true),
            'OTHER' => Language::_('RealtimeRegister.domain.MEUKLegalType.other', true),
            'CRC' => Language::_('RealtimeRegister.domain.MEUKLegalType.crc', true),
            'FCORP' => Language::_('RealtimeRegister.domain.MEUKLegalType.fcorp', true),
            'STAT' => Language::_('RealtimeRegister.domain.MEUKLegalType.stat', true),
            'FOTHER' => Language::_('RealtimeRegister.domain.MEUKLegalType.fother', true)
        ]
    ],
    'MEUKCompanyID' => [
        'label' => Language::_('RealtimeRegister.domain.MEUKCompanyID', true),
        'type' => 'text'
    ],
    'MEUKRegisteredfor' => [
        'label' => Language::_('RealtimeRegister.domain.MEUKRegisteredfor', true),
        'type' => 'text'
    ]
]);

// .ORG.UK
Configure::set('RealtimeRegister.domain_fields.org.uk', [
    'ORGUKLegalType' => [
        'label' => Language::_('RealtimeRegister.domain.ORGUKLegalType', true),
        'type' => 'select',
        'options' => [
            'IND' => Language::_('RealtimeRegister.domain.ORGUKLegalType.ind', true),
            'FIND' => Language::_('RealtimeRegister.domain.ORGUKLegalType.find', true),
            'LTD' => Language::_('RealtimeRegister.domain.ORGUKLegalType.ltd', true),
            'PLC' => Language::_('RealtimeRegister.domain.ORGUKLegalType.plc', true),
            'PTNR' => Language::_('RealtimeRegister.domain.ORGUKLegalType.ptnr', true),
            'LLP' => Language::_('RealtimeRegister.domain.ORGUKLegalType.llp', true),
            'IP' => Language::_('RealtimeRegister.domain.ORGUKLegalType.ip', true),
            'STRA' => Language::_('RealtimeRegister.domain.ORGUKLegalType.stra', true),
            'SCH' => Language::_('RealtimeRegister.domain.ORGUKLegalType.sch', true),
            'RCHAR' => Language::_('RealtimeRegister.domain.ORGUKLegalType.rchar', true),
            'GOV' => Language::_('RealtimeRegister.domain.ORGUKLegalType.gov', true),
            'OTHER' => Language::_('RealtimeRegister.domain.ORGUKLegalType.other', true),
            'CRC' => Language::_('RealtimeRegister.domain.ORGUKLegalType.crc', true),
            'FCORP' => Language::_('RealtimeRegister.domain.ORGUKLegalType.fcorp', true),
            'STAT' => Language::_('RealtimeRegister.domain.ORGUKLegalType.stat', true),
            'FOTHER' => Language::_('RealtimeRegister.domain.ORGUKLegalType.fother', true)
        ]
    ],
    'ORGUKCompanyID' => [
        'label' => Language::_('RealtimeRegister.domain.ORGUKCompanyID', true),
        'type' => 'text'
    ],
    'ORGUKRegisteredfor' => [
        'label' => Language::_('RealtimeRegister.domain.ORGUKRegisteredfor', true),
        'type' => 'text'
    ]
]);

// .ASIA
Configure::set('RealtimeRegister.domain_fields.asia', [
    'ASIACCLocality' => [
        'type' => 'hidden',
        'options' => null
    ],
    'ASIALegalEntityType' => [
        'label' => Language::_('RealtimeRegister.domain.ASIALegalEntityType', true),
        'type' => 'select',
        'options' => [
            'corporation' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.corporation', true),
            'cooperative' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.cooperative', true),
            'partnership' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.partnership', true),
            'government' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.government', true),
            'politicalParty' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.politicalParty', true),
            'society' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.society', true),
            'institution' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.institution', true),
            'naturalPerson' => Language::_('RealtimeRegister.domain.ASIALegalEntityType.naturalPerson', true)
        ]
    ],
    'ASIAIdentForm' => [
        'label' => Language::_('RealtimeRegister.domain.ASIAIdentForm', true),
        'type' => 'select',
        'options' => [
            'certificate' => Language::_('RealtimeRegister.domain.ASIAIdentForm.certificate', true),
            'legislation' => Language::_('RealtimeRegister.domain.ASIAIdentForm.legislation', true),
            'societyRegistry' => Language::_('RealtimeRegister.domain.ASIAIdentForm.societyRegistry', true),
            'politicalPartyRegistry' => Language::_('RealtimeRegister.domain.ASIAIdentForm.politicalPartyRegistry', true),
            'passport' => Language::_('RealtimeRegister.domain.ASIAIdentForm.passport', true)
        ]
    ],
    'ASIAIdentNumber' => [
        'label' => Language::_('RealtimeRegister.domain.ASIAIdentNumber', true),
        'type' => 'text'
    ]
]);

// .DE
Configure::set('RealtimeRegister.domain_fields.de', [
    'DEConfirmAddress' => [
        'type' => 'hidden',
        'options' => 'DE'
    ],
    'DEAgreeDelete' => [
        'type' => 'hidden',
        'options' => 'YES'
    ]
]);

// .FR
Configure::set('RealtimeRegister.domain_fields.fr', [
    'FRLegalType' => [
        'label' => Language::_('RealtimeRegister.domain.FRLegalType', true),
        'type' => 'select',
        'options' => [
            'Individual' => Language::_('RealtimeRegister.domain.FRLegalType.individual', true),
            'Company' => Language::_('RealtimeRegister.domain.FRLegalType.company', true),
        ]
    ],
    'FRRegistrantBirthDate' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantBirthDate', true),
        'type' => 'text',
        'tooltip' => Language::_('RealtimeRegister.!tooltip.FRRegistrantBirthDate', true)
    ],
    'FRRegistrantBirthplace' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantBirthplace', true),
        'type' => 'text'
    ],
    'FRRegistrantLegalId' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantLegalId', true),
        'type' => 'text',
        'tooltip' => Language::_('RealtimeRegister.!tooltip.FRRegistrantLegalId', true)
    ],
    'FRRegistrantTradeNumber' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantTradeNumber', true),
        'type' => 'text'
    ],
    'FRRegistrantDunsNumber' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantDunsNumber', true),
        'type' => 'text',
        'tooltip' => Language::_('RealtimeRegister.!tooltip.FRRegistrantDunsNumber', true)
    ],
    'FRRegistrantLocalId' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantLocalId', true),
        'type' => 'text'
    ],
    'FRRegistrantJoDateDec' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantJoDateDec', true),
        'type' => 'text',
        'tooltip' => Language::_('RealtimeRegister.!tooltip.FRRegistrantJoDateDec', true)
    ],
    'FRRegistrantJoDatePub' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantJoDatePub', true),
        'type' => 'text',
        'tooltip' => Language::_('RealtimeRegister.!tooltip.FRRegistrantJoDatePub', true)
    ],
    'FRRegistrantJoNumber' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantJoNumber', true),
        'type' => 'text'
    ],
    'FRRegistrantJoPage' => [
        'label' => Language::_('RealtimeRegister.domain.FRRegistrantJoPage', true),
        'type' => 'text'
    ]
]);

// Welcome Email templates
Configure::set('RealtimeRegister.email_templates', [
    'en_us' => [
        'lang' => 'en_us',
        'text' => 'Your new domain is being processed and will be registered soon!

Domain: {service.domain}

Thank you for your business!',
        'html' => '<p>Your new domain is being processed and will be registered soon!</p>
<p>Domain: {service.domain}</p>
<p>Thank you for your business!</p>'
    ]
]);

