<?php
/**
 * TldServiceApi
 * PHP version 5
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Tld
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * TLD
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0-beta
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.0.3
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Openprovider\Api\Rest\Client\Tld\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Openprovider\Api\Rest\Client\Base\ApiException;
use Openprovider\Api\Rest\Client\Base\Configuration;
use Openprovider\Api\Rest\Client\Base\HeaderSelector;
use Openprovider\Api\Rest\Client\Base\ObjectSerializer;

/**
 * TldServiceApi Class Doc Comment
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Tld
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TldServiceApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getTld
     *
     * Get tld
     *
     * @param  string $name Extension name (required)
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $status Extension status. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Tld\Model\TldGetTldResponse|\Openprovider\Api\Rest\Client\Tld\Model\ErrorError
     */
    public function getTld($name, $limit = null, $offset = null, $with_description = null, $with_restrictions = null, $with_price = null, $with_level_prices = null, $with_usage_count = null, $status = null)
    {
        list($response) = $this->getTldWithHttpInfo($name, $limit, $offset, $with_description, $with_restrictions, $with_price, $with_level_prices, $with_usage_count, $status);
        return $response;
    }

    /**
     * Operation getTldWithHttpInfo
     *
     * Get tld
     *
     * @param  string $name Extension name (required)
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $status Extension status. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Tld\Model\TldGetTldResponse|\Openprovider\Api\Rest\Client\Tld\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTldWithHttpInfo($name, $limit = null, $offset = null, $with_description = null, $with_restrictions = null, $with_price = null, $with_level_prices = null, $with_usage_count = null, $status = null)
    {
        $request = $this->getTldRequest($name, $limit, $offset, $with_description, $with_restrictions, $with_price, $with_level_prices, $with_usage_count, $status);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Tld\Model\TldGetTldResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Tld\Model\TldGetTldResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Tld\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Tld\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Tld\Model\TldGetTldResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Tld\Model\TldGetTldResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Tld\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTldAsync
     *
     * Get tld
     *
     * @param  string $name Extension name (required)
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $status Extension status. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTldAsync($name, $limit = null, $offset = null, $with_description = null, $with_restrictions = null, $with_price = null, $with_level_prices = null, $with_usage_count = null, $status = null)
    {
        return $this->getTldAsyncWithHttpInfo($name, $limit, $offset, $with_description, $with_restrictions, $with_price, $with_level_prices, $with_usage_count, $status)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTldAsyncWithHttpInfo
     *
     * Get tld
     *
     * @param  string $name Extension name (required)
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $status Extension status. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTldAsyncWithHttpInfo($name, $limit = null, $offset = null, $with_description = null, $with_restrictions = null, $with_price = null, $with_level_prices = null, $with_usage_count = null, $status = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Tld\Model\TldGetTldResponse';
        $request = $this->getTldRequest($name, $limit, $offset, $with_description, $with_restrictions, $with_price, $with_level_prices, $with_usage_count, $status);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTld'
     *
     * @param  string $name Extension name (required)
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $status Extension status. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getTldRequest($name, $limit = null, $offset = null, $with_description = null, $with_restrictions = null, $with_price = null, $with_level_prices = null, $with_usage_count = null, $status = null)
    {
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getTld'
            );
        }

        $resourcePath = '/v1beta/tlds/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($with_description !== null) {
            $queryParams['with_description'] = ObjectSerializer::toQueryValue($with_description);
        }
        // query params
        if ($with_restrictions !== null) {
            $queryParams['with_restrictions'] = ObjectSerializer::toQueryValue($with_restrictions);
        }
        // query params
        if ($with_price !== null) {
            $queryParams['with_price'] = ObjectSerializer::toQueryValue($with_price);
        }
        // query params
        if ($with_level_prices !== null) {
            $queryParams['with_level_prices'] = ObjectSerializer::toQueryValue($with_level_prices);
        }
        // query params
        if ($with_usage_count !== null) {
            $queryParams['with_usage_count'] = ObjectSerializer::toQueryValue($with_usage_count);
        }
        // query params
        if (is_array($status)) {
            $status = ObjectSerializer::serializeCollection($status, 'multi', true);
        }
        if ($status !== null) {
            $queryParams['status'] = ObjectSerializer::toQueryValue($status);
        }

        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listTlds
     *
     * List tlds
     *
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  string $order Sorts output ASC or DESC. (optional)
     * @param  string $order_by Sorts output by a field. (optional)
     * @param  string[] $extensions Array of extensions. (optional)
     * @param  string $name_pattern Extension name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $only_names Returns only extension names in the output. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $with_application_mode Array of extension application modes. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $is_active Indicates, if extension is active. (optional)
     * @param  bool $is_new_gtld Indicates, if extension is a newGTLD. (optional)
     * @param  string $status Extension status. (optional)
     * @param  string $application_mode Pre-registration mode. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Tld\Model\TldListTldsResponse|\Openprovider\Api\Rest\Client\Tld\Model\ErrorError
     */
    public function listTlds($limit = null, $offset = null, $order = null, $order_by = null, $extensions = null, $name_pattern = null, $only_names = null, $with_description = null, $with_restrictions = null, $with_usage_count = null, $with_application_mode = null, $with_price = null, $with_level_prices = null, $is_active = null, $is_new_gtld = null, $status = null, $application_mode = null)
    {
        list($response) = $this->listTldsWithHttpInfo($limit, $offset, $order, $order_by, $extensions, $name_pattern, $only_names, $with_description, $with_restrictions, $with_usage_count, $with_application_mode, $with_price, $with_level_prices, $is_active, $is_new_gtld, $status, $application_mode);
        return $response;
    }

    /**
     * Operation listTldsWithHttpInfo
     *
     * List tlds
     *
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  string $order Sorts output ASC or DESC. (optional)
     * @param  string $order_by Sorts output by a field. (optional)
     * @param  string[] $extensions Array of extensions. (optional)
     * @param  string $name_pattern Extension name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $only_names Returns only extension names in the output. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $with_application_mode Array of extension application modes. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $is_active Indicates, if extension is active. (optional)
     * @param  bool $is_new_gtld Indicates, if extension is a newGTLD. (optional)
     * @param  string $status Extension status. (optional)
     * @param  string $application_mode Pre-registration mode. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Tld\Model\TldListTldsResponse|\Openprovider\Api\Rest\Client\Tld\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTldsWithHttpInfo($limit = null, $offset = null, $order = null, $order_by = null, $extensions = null, $name_pattern = null, $only_names = null, $with_description = null, $with_restrictions = null, $with_usage_count = null, $with_application_mode = null, $with_price = null, $with_level_prices = null, $is_active = null, $is_new_gtld = null, $status = null, $application_mode = null)
    {
        $request = $this->listTldsRequest($limit, $offset, $order, $order_by, $extensions, $name_pattern, $only_names, $with_description, $with_restrictions, $with_usage_count, $with_application_mode, $with_price, $with_level_prices, $is_active, $is_new_gtld, $status, $application_mode);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Tld\Model\TldListTldsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Tld\Model\TldListTldsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Tld\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Tld\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Tld\Model\TldListTldsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Tld\Model\TldListTldsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Tld\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listTldsAsync
     *
     * List tlds
     *
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  string $order Sorts output ASC or DESC. (optional)
     * @param  string $order_by Sorts output by a field. (optional)
     * @param  string[] $extensions Array of extensions. (optional)
     * @param  string $name_pattern Extension name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $only_names Returns only extension names in the output. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $with_application_mode Array of extension application modes. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $is_active Indicates, if extension is active. (optional)
     * @param  bool $is_new_gtld Indicates, if extension is a newGTLD. (optional)
     * @param  string $status Extension status. (optional)
     * @param  string $application_mode Pre-registration mode. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listTldsAsync($limit = null, $offset = null, $order = null, $order_by = null, $extensions = null, $name_pattern = null, $only_names = null, $with_description = null, $with_restrictions = null, $with_usage_count = null, $with_application_mode = null, $with_price = null, $with_level_prices = null, $is_active = null, $is_new_gtld = null, $status = null, $application_mode = null)
    {
        return $this->listTldsAsyncWithHttpInfo($limit, $offset, $order, $order_by, $extensions, $name_pattern, $only_names, $with_description, $with_restrictions, $with_usage_count, $with_application_mode, $with_price, $with_level_prices, $is_active, $is_new_gtld, $status, $application_mode)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listTldsAsyncWithHttpInfo
     *
     * List tlds
     *
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  string $order Sorts output ASC or DESC. (optional)
     * @param  string $order_by Sorts output by a field. (optional)
     * @param  string[] $extensions Array of extensions. (optional)
     * @param  string $name_pattern Extension name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $only_names Returns only extension names in the output. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $with_application_mode Array of extension application modes. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $is_active Indicates, if extension is active. (optional)
     * @param  bool $is_new_gtld Indicates, if extension is a newGTLD. (optional)
     * @param  string $status Extension status. (optional)
     * @param  string $application_mode Pre-registration mode. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listTldsAsyncWithHttpInfo($limit = null, $offset = null, $order = null, $order_by = null, $extensions = null, $name_pattern = null, $only_names = null, $with_description = null, $with_restrictions = null, $with_usage_count = null, $with_application_mode = null, $with_price = null, $with_level_prices = null, $is_active = null, $is_new_gtld = null, $status = null, $application_mode = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Tld\Model\TldListTldsResponse';
        $request = $this->listTldsRequest($limit, $offset, $order, $order_by, $extensions, $name_pattern, $only_names, $with_description, $with_restrictions, $with_usage_count, $with_application_mode, $with_price, $with_level_prices, $is_active, $is_new_gtld, $status, $application_mode);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listTlds'
     *
     * @param  int $limit Search query limit. (optional)
     * @param  int $offset Search query offset. (optional)
     * @param  string $order Sorts output ASC or DESC. (optional)
     * @param  string $order_by Sorts output by a field. (optional)
     * @param  string[] $extensions Array of extensions. (optional)
     * @param  string $name_pattern Extension name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $only_names Returns only extension names in the output. (optional)
     * @param  bool $with_description Returns additional extension description. (optional)
     * @param  bool $with_restrictions Returns list of extension restrictions. (optional)
     * @param  bool $with_usage_count Returns number of domains using specified extension in this account. (optional)
     * @param  string[] $with_application_mode Array of extension application modes. (optional)
     * @param  bool $with_price Returns extension prices. (optional)
     * @param  bool $with_level_prices Returns extension prices for each Openprovider discount tier. (optional)
     * @param  bool $is_active Indicates, if extension is active. (optional)
     * @param  bool $is_new_gtld Indicates, if extension is a newGTLD. (optional)
     * @param  string $status Extension status. (optional)
     * @param  string $application_mode Pre-registration mode. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listTldsRequest($limit = null, $offset = null, $order = null, $order_by = null, $extensions = null, $name_pattern = null, $only_names = null, $with_description = null, $with_restrictions = null, $with_usage_count = null, $with_application_mode = null, $with_price = null, $with_level_prices = null, $is_active = null, $is_new_gtld = null, $status = null, $application_mode = null)
    {

        $resourcePath = '/v1beta/tlds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = ObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($order_by !== null) {
            $queryParams['order_by'] = ObjectSerializer::toQueryValue($order_by);
        }
        // query params
        if ($extensions !== null) {
            $queryParams['extensions'] = call_user_func(function ($value) {
                if (is_array($value)) {
                    return $value;
                }

                return ObjectSerializer::toQueryValue($value);
            }, $extensions);
        }
        // query params
        if ($name_pattern !== null) {
            $queryParams['name_pattern'] = ObjectSerializer::toQueryValue($name_pattern);
        }
        // query params
        if ($only_names !== null) {
            $queryParams['only_names'] = ObjectSerializer::toQueryValue($only_names);
        }
        // query params
        if ($with_description !== null) {
            $queryParams['with_description'] = ObjectSerializer::toQueryValue($with_description);
        }
        // query params
        if ($with_restrictions !== null) {
            $queryParams['with_restrictions'] = ObjectSerializer::toQueryValue($with_restrictions);
        }
        // query params
        if ($with_usage_count !== null) {
            $queryParams['with_usage_count'] = ObjectSerializer::toQueryValue($with_usage_count);
        }
        // query params
        if (is_array($with_application_mode)) {
            $with_application_mode = ObjectSerializer::serializeCollection($with_application_mode, 'multi', true);
        }
        if ($with_application_mode !== null) {
            $queryParams['with_application_mode'] = ObjectSerializer::toQueryValue($with_application_mode);
        }
        // query params
        if ($with_price !== null) {
            $queryParams['with_price'] = ObjectSerializer::toQueryValue($with_price);
        }
        // query params
        if ($with_level_prices !== null) {
            $queryParams['with_level_prices'] = ObjectSerializer::toQueryValue($with_level_prices);
        }
        // query params
        if ($is_active !== null) {
            $queryParams['is_active'] = ObjectSerializer::toQueryValue($is_active);
        }
        // query params
        if ($is_new_gtld !== null) {
            $queryParams['is_new_gtld'] = ObjectSerializer::toQueryValue($is_new_gtld);
        }
        // query params
        if ($status !== null) {
            $queryParams['status'] = ObjectSerializer::toQueryValue($status);
        }
        // query params
        if ($application_mode !== null) {
            $queryParams['application_mode'] = ObjectSerializer::toQueryValue($application_mode);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
