#!/usr/bin/php
<?php
/*
* Load json and convert it to PHP object:
*/
$rowstr = var_export(
    json_decode(
        file_get_contents(
            'https://raw.githubusercontent.com/opawg/podcast-rss-useragents/master/src/rss-ua.json'
        ),
        true
    ),
    true
);

// autogenerate database
print <<<EOT
<?php
namespace Opawg\UserAgentsV2Php;

/* Autogenerated.  Do not edit */
 
class UserAgentsRSS {
    public static function find(\$userAgent)
    {
        \$serviceFound = null;
        //Search for current HTTP_USER_AGENT:
        foreach (self::\$db as \$service) {
            //Does the HTTP_USER_AGENT match this regexp:
            if (strpos(\$userAgent, \$service['pattern']) !== false) {
                \$serviceFound = [
                    'name' => isset(\$service['name']) ? \$service['name'] : '',
                    'slug' => isset(\$service['slug']) ? \$service['slug'] : '',
                    'url' => isset(\$service['url']) ? \$service['url'] : '',
                ];
                //We found it!
                break 1;
            }
        }
        return \$serviceFound;
    }

    public static function getName(\$slug)
    {
        \$name = null;
        //Search for current HTTP_USER_AGENT:
        foreach (self::\$db as \$service) {
            if (\$slug === \$service['slug']) {
                \$name = \$service['name'];
                //We found it!
                break 1;
            }
        }
        return \$name;
    }


EOT;
print "    static public \$db = ";
print $rowstr;
print ";\n";
print "}\n";

