/**
 * Plupload - multi-runtime File Uploader
 * v3.1.2
 *
 * Copyright 2018, Ephox
 * Released under AGPLv3 License.
 *
 * License: http://www.plupload.com/license
 * Contributing: http://www.plupload.com/contributing
 *
 * Date: 2018-02-20
 */
!function(t,e){var i=function(){var t={};return e.apply(t,arguments),t.plupload};"function"==typeof define&&define.amd?define("plupload",["./moxie"],i):"object"==typeof module&&module.exports?module.exports=i(require("./moxie")):t.plupload=i(t.moxie)}(this||window,function(t){!function(e,i){"use strict";function n(t,e){for(var i,n=[],r=0;r<t.length;++r){if(i=a[t[r]]||s(t[r]),!i)throw"module definition dependecy not found: "+t[r];n.push(i)}e.apply(null,n)}function r(t,e,r){if("string"!=typeof t)throw"invalid module definition, module id must be defined and be a string";if(e===i)throw"invalid module definition, dependencies must be specified";if(r===i)throw"invalid module definition, definition function must be specified";n(e,function(){a[t]=r.apply(null,arguments)})}function s(t){for(var i=e,n=t.split(/[.\/]/),r=0;r<n.length;++r){if(!i[n[r]])return;i=i[n[r]]}return i}function o(t){for(var n=0;n<t.length;n++){for(var r=e,s=t[n],o=s.split(/[.\/]/),u=0;u<o.length-1;++u)r[o[u]]===i&&(r[o[u]]={}),r=r[o[u]];r[o[o.length-1]]=a[s]}}var a={};r("plupload",[],function(){var e=t,i=e.core.utils;return i.Env.global_event_dispatcher="plupload.EventTarget.instance.dispatchEvent",{VERSION:"3.1.2",STOPPED:1,STARTED:2,QUEUED:1,UPLOADING:2,FAILED:4,DONE:5,GENERIC_ERROR:-100,HTTP_ERROR:-200,IO_ERROR:-300,SECURITY_ERROR:-400,INIT_ERROR:-500,FILE_SIZE_ERROR:-600,FILE_EXTENSION_ERROR:-601,FILE_DUPLICATE_ERROR:-602,IMAGE_FORMAT_ERROR:-700,MEMORY_ERROR:-701,IMAGE_DIMENSIONS_ERROR:-702,OPTION_ERROR:-800,moxie:e,ua:i.Env,typeOf:i.Basic.typeOf,clone:i.Basic.clone,inherit:i.Basic.inherit,extend:i.Basic.extend,extendImmutable:i.Basic.extendImmutable,extendIf:i.Basic.extendIf,inSeries:i.Basic.inSeries,inParallel:i.Basic.inParallel,guid:i.Basic.guid,getAll:function(t){var e,n=[];"array"!==i.Basic.typeOf(t)&&(t=[t]);for(var r=t.length;r--;)e=i.Dom.get(t[r]),e&&n.push(e);return n.length?n:null},get:i.Dom.get,each:i.Basic.each,getPos:i.Dom.getPos,getSize:i.Dom.getSize,xmlEncode:function(t){var e={"<":"lt",">":"gt","&":"amp",'"':"quot","'":"#39"},i=/[<>&\"\']/g;return t?(""+t).replace(i,function(t){return e[t]?"&"+e[t]+";":t}):t},toArray:i.Basic.toArray,inArray:i.Basic.inArray,addI18n:e.core.I18n.addI18n,translate:e.core.I18n.translate,sprintf:i.Basic.sprintf,isEmptyObj:i.Basic.isEmptyObj,hasClass:i.Dom.hasClass,addClass:i.Dom.addClass,removeClass:i.Dom.removeClass,getStyle:i.Dom.getStyle,addEvent:i.Events.addEvent,removeEvent:i.Events.removeEvent,removeAllEvents:i.Events.removeAllEvents,cleanName:function(t){var e,i;for(i=[/[\300-\306]/g,"A",/[\340-\346]/g,"a",/\307/g,"C",/\347/g,"c",/[\310-\313]/g,"E",/[\350-\353]/g,"e",/[\314-\317]/g,"I",/[\354-\357]/g,"i",/\321/g,"N",/\361/g,"n",/[\322-\330]/g,"O",/[\362-\370]/g,"o",/[\331-\334]/g,"U",/[\371-\374]/g,"u"],e=0;e<i.length;e+=2)t=t.replace(i[e],i[e+1]);return t=t.replace(/\s+/g,"_"),t=t.replace(/[^a-z0-9_\-\.]+/gi,"")},buildUrl:function(t,e){var n="";return i.Basic.each(e,function(t,e){n+=(n?"&":"")+encodeURIComponent(e)+"="+encodeURIComponent(t)}),n&&(t+=(t.indexOf("?")>0?"&":"?")+n),t},formatSize:function(t){function e(t,e){return Math.round(t*Math.pow(10,e))/Math.pow(10,e)}var i=this;if(t=parseInt(t,10),isNaN(t))return i.translate("N/A");var n=Math.pow(1024,4);return t>n?e(t/n,1)+" "+i.translate("tb"):t>(n/=1024)?e(t/n,1)+" "+i.translate("gb"):t>(n/=1024)?e(t/n,1)+" "+i.translate("mb"):t>1024?Math.round(t/1024)+" "+i.translate("kb"):t+" "+i.translate("b")},mimes2extList:t.core.utils.Mime.mimes2extList,resolveUrl:i.Url.resolveUrl,parseSize:i.Basic.parseSizeStr,delay:i.Basic.delay,EventTarget:t.core.EventTarget,Runtime:t.runtime.Runtime,FileInput:t.file.FileInput,FileReader:t.file.FileReader}}),r("plupload/core/Collection",["plupload"],function(){var t=function(){function e(){var t;for(t in n);return n[t]}var i,n={},r=0;plupload.extend(this,{count:function(){return r},hasKey:function(t){return n.hasOwnProperty(t)},get:function(t){return n[t]},first:function(){for(var t in n)return n[t]},last:function(){return i},toObject:function(){return n},add:function(t,e){var s=this;return"object"!=typeof t||e?n.hasOwnProperty(t)?s.update.apply(s,arguments):(n[t]=i=e,r++,void 0):plupload.each(t,function(t,e){s.add(e,t)})},remove:function(t){if(this.hasKey(t)){var s=n[t];delete n[t],r--,i===s&&(i=e())}},extract:function(t){var e=this.get(t);return this.remove(t),e},shift:function(){var t,e,i=this;for(e in n)return t=n[e],i.remove(e),t},update:function(t,e){n[t]=e},each:function(t){plupload.each(n,t)},combineWith:function(){var e=new t;return e.add(n),plupload.each(arguments,function(i){i instanceof t&&e.add(i.toObject())}),e},clear:function(){n={},i=null,r=0}})};return t}),r("plupload/core/ArrCollection",["plupload"],function(t){var e=function(){var e=[];t.extend(this,{count:function(){return e.length},hasKey:function(t){return this.getIdx(t)>-1},get:function(t){var i=this.getIdx(t);return i>-1?e[i]:null},getIdx:function(t){for(var i=0,n=e.length;n>i;i++)if(e[i].uid===t)return i;return-1},getByIdx:function(t){return e[t]},first:function(){return e[0]},last:function(){return e[e.length-1]},add:function(t){t=arguments[1]||t;var i=this.getIdx(t.uid);return i>-1?(e[i]=t,i):(e.push(t),e.length-1)},remove:function(t){return!!this.extract(t)},splice:function(i,n){return i="undefinded"===t.typeOf(i)?0:Math.max(i,0),n="undefinded"!==t.typeOf(n)&&i+n<e.length?n:e.length-i,e.splice(i,n)},extract:function(t){var i=this.getIdx(t);return i>-1?e.splice(i,1):null},shift:function(){return e.shift()},update:function(t,i){var n=this.getIdx(t);return n>-1?(e[n]=i,!0):!1},each:function(i){t.each(e,i)},combineWith:function(){return Array.prototype.concat.apply(this.toArray(),arguments)},sort:function(t){e.sort(t||function(t,e){return t.priority-e.priority})},clear:function(){e=[]},toObject:function(){for(var t={},i=0,n=e.length;n>i;i++)t[e[i].uid]=e[i];return t},toArray:function(){return Array.prototype.slice.call(e)}})};return e}),r("plupload/core/Optionable",["plupload"],function(e){var i=t.core.EventTarget;return function(t){function i(){t.apply(this,arguments),this._options={}}return e.inherit(i,t),e.extend(i.prototype,{setOption:function(t,i,n){var r,s=this;return"object"==typeof t?(n=i,e.each(t,function(t,e){s.setOption(e,t,n)}),void 0):((!n||s._options.hasOwnProperty(t))&&(r=e.clone(s._options[t]),"object"===e.typeOf(i)&&"object"===e.typeOf(s._options[t])?e.extend(s._options[t],i):s._options[t]=i,s.trigger("OptionChanged",t,i,r)),void 0)},getOption:function(t){if(!t)return this._options;var i=this._options[t];return e.inArray(e.typeOf(i),["array","object"])>-1?e.extendImmutable({},i):i},setOptions:function(t,e){"object"==typeof t&&this.setOption(t,e)},getOptions:function(){return this.getOption()}}),i}(i)}),r("plupload/core/Queueable",["plupload","plupload/core/Optionable"],function(t,e){return function(e){function i(){e.apply(this,arguments),this.uid=t.guid(),this.state=i.IDLE,this.processed=0,this.total=0,this.percent=0,this.retries=0,this.priority=0,this.startedTimestamp=0,this.processedTimestamp=0}return i.IDLE=1,i.PROCESSING=2,i.PAUSED=6,i.RESUMED=7,i.DONE=5,i.FAILED=4,i.DESTROYED=8,t.inherit(i,e),t.extend(i.prototype,{start:function(){var t=this.state;return this.state===i.PROCESSING?!1:(this.startedTimestamp||(this.startedTimestamp=+new Date),this.state=i.PROCESSING,this.trigger("statechanged",this.state,t),this.trigger("started"),!0)},pause:function(){var e=this.state;return-1===t.inArray(this.state,[i.IDLE,i.RESUMED,i.PROCESSING])?!1:(this.processed=this.percent=0,this.loaded=this.processed,this.state=i.PAUSED,this.trigger("statechanged",this.state,e),this.trigger("paused"),!0)},resume:function(){var t=this.state;return this.state!==i.PAUSED&&this.state!==i.RESUMED?!1:(this.state=i.RESUMED,this.trigger("statechanged",this.state,t),this.trigger("resumed"),!0)},stop:function(){var t=this.state;return this.state===i.IDLE?!1:(this.processed=this.percent=0,this.loaded=this.processed,this.startedTimestamp=0,this.state=i.IDLE,this.trigger("statechanged",this.state,t),this.trigger("stopped"),!0)},done:function(t){var e=this.state;return this.state===i.DONE?!1:(this.processed=this.total,this.loaded=this.processed,this.percent=100,this.processedTimestamp=+new Date,this.state=i.DONE,this.trigger("statechanged",this.state,e),this.trigger("done",t),this.trigger("processed"),!0)},failed:function(t){var e=this.state;return this.state===i.FAILED?!1:(this.processed=this.percent=0,this.loaded=this.processed,this.processedTimestamp=+new Date,this.state=i.FAILED,this.trigger("statechanged",this.state,e),this.trigger("failed",t),this.trigger("processed"),!0)},progress:function(t,e){e&&(this.total=e),this.processed=Math.min(t,this.total),this.loaded=this.processed,this.percent=Math.ceil(100*(this.processed/this.total)),this.trigger({type:"progress",loaded:this.processed,total:this.total})},destroy:function(){var t=this.state;return this.state===i.DESTROYED?!1:(this.state=i.DESTROYED,this.trigger("statechanged",this.state,t),this.trigger("destroy"),this.unbindAll(),!0)}}),i}(e)}),r("plupload/core/Stats",[],function(){return function(){var t=this;t.size=0,t.total=0,t.loaded=0,t.uploaded=0,t.done=0,t.failed=0,t.queued=0,t.paused=0,t.processing=0,t.paused=0,t.percent=0,t.bytesPerSec=0,t.processedPerSec=0,t.reset=function(){t.size=t.total=t.loaded=t.processed=t.uploaded=t.done=t.failed=t.queued=t.processing=t.paused=t.percent=t.bytesPerSec=t.processedPerSec=0}}}),r("plupload/core/Queue",["plupload","plupload/core/ArrCollection","plupload/core/Queueable","plupload/core/Stats"],function(t,e,i,n){return function(r){function s(i){r.apply(this,arguments),this._queue=new e,this.stats=new n,this._options=t.extend({},this._options,{max_slots:1,max_retries:0,auto_start:!1,finish_active:!1},i)}function o(){var t;return this.forEachItem(function(e){return e.state===i.IDLE||e.state===i.RESUMED?(t=e,!1):void 0}),t?t:null}function a(){var t;if(this.state!==i.PROCESSING&&this.state!==i.PAUSED)return!1;if(this.stats.processing<this.getOption("max_slots")&&(t=o.call(this))){if(t.trigger("beforestart"))return t.setOptions(this.getOptions()),t.start();t.pause(),a.call(this)}return!1}return t.inherit(s,r),t.extend(s.prototype,{count:function(){return this._queue.count()},start:function(){return s.parent.start.call(this)?a.call(this):!1},pause:function(){return s.parent.pause.call(this)?(this.forEachItem(function(t){t.pause()}),void 0):!1},stop:function(){return!s.parent.stop.call(this)||this.getOption("finish_active")?!1:(this.isActive()&&this.forEachItem(function(t){t.stop()}),void 0)},forEachItem:function(t){this._queue.each(t)},getItem:function(t){return this._queue.get(t)},addItem:function(e){var n=this;e.bind("Started",function(){n.calcStats()&&t.delay.call(n,a)}),e.bind("Resumed",function(){n.start()}),e.bind("Paused",function(){n.calcStats()&&t.delay.call(n,function(){a.call(n)||n.stats.processing||n.pause()})}),e.bind("Processed Stopped",function(){n.calcStats()&&t.delay.call(n,function(){a.call(n)||this.isStopped()||this.isActive()||n.stop()})}),e.bind("Progress",function(){n.calcStats()&&n.trigger("Progress",n.stats.processed,n.stats.total,n.stats)}),e.bind("Failed",function(){n.getOption("max_retries")&&this.retries<n.getOption("max_retries")&&(this.stop(),this.retries++)}),this._queue.add(e.uid,e),this.calcStats(),e.trigger("Queued"),(n.getOption("auto_start")||n.state===i.PAUSED)&&t.delay.call(this,this.start)},extractItem:function(t){var e=this._queue.get(t);return e&&(this.stopItem(e.uid),this._queue.remove(t),this.calcStats()),e},removeItem:function(t){var e=this.extractItem(t);return e?(e.destroy(),!0):!1},stopItem:function(t){var e=this._queue.get(t);return e?e.stop():!1},pauseItem:function(t){var e=this._queue.get(t);return e?e.pause():!1},resumeItem:function(e){var i=this._queue.get(e);return i?(t.delay.call(this,function(){this.start()}),i.resume()):!1},splice:function(t,e){return this._queue.splice(t,e)},isActive:function(){return this.stats&&(this.stats.processing||this.stats.paused)},isStopped:function(){return this.state===i.IDLE||this.state===i.DESTROYED},countSpareSlots:function(){return Math.max(this.getOption("max_slots")-this.stats.processing,0)},toArray:function(){return this._queue.toArray()},clear:function(){var t=this;return t.state!==i.IDLE?(t.bindOnce("Stopped",function(){t.clear()}),t.stop()):(t._queue.clear(),t.stats.reset(),void 0)},calcStats:function(){var t=this,e=t.stats,n=0,r=0;return e?(e.reset(),t.forEachItem(function(s){switch(s.state){case i.DONE:e.done++,e.uploaded=e.done;break;case i.FAILED:e.failed++;break;case i.PROCESSING:e.processing++;break;case i.PAUSED:e.paused++;break;default:e.queued++}n+=s.processed,(!s.processedTimestamp||s.processedTimestamp>t.startedTimestamp)&&(r+=n),e.processedPerSec=Math.ceil(r/((+new Date-t.startedTimestamp||1)/1e3)),e.processed=n,e.total+=s.total,e.total&&(e.percent=Math.ceil(100*(e.processed/e.total)))}),t.percent=e.percent,e.loaded=e.processed,e.size=e.total,e.bytesPerSec=e.processedPerSec,!0):!1},destroy:function(){var e=this;return e.state===i.DESTROYED?!1:e.state!==i.IDLE?(e.bindOnce("Stopped",function(){t.delay.call(e,e.destroy)}),e.stop()):(e.clear(),s.parent.destroy.call(this),e._queue=e.stats=null,!0)}}),s}(i)}),r("plupload/QueueUpload",["plupload","plupload/core/Queue"],function(t,e){return function(i){function n(t){e.call(this,{max_slots:1,max_retries:0,auto_start:!1,finish_active:!1,url:!1,chunk_size:0,multipart:!0,http_method:"POST",params:{},headers:!1,file_data_name:"file",send_file_name:!0,stop_on_fail:!0}),this.setOption=function(t,e){"object"!=typeof t&&"max_upload_slots"==t&&(t="max_slots"),n.prototype.setOption.call(this,t,e,!0)},this.setOptions(t)}return t.inherit(n,i),n}(e)}),r("plupload/QueueResize",["plupload","plupload/core/Queue"],function(t,e){return function(i){function n(t){e.call(this,{max_slots:1,max_retries:0,auto_start:!1,finish_active:!1,resize:{}}),this.setOption=function(t,e){"object"!=typeof t&&"max_resize_slots"==t&&(t="max_slots"),n.prototype.setOption.call(this,t,e,!0)},this.setOptions(t)}return t.inherit(n,i),n}(e)}),r("plupload/ChunkUploader",["plupload","plupload/core/Collection","plupload/core/Queueable"],function(e,i,n){function r(t){function i(t,i){var n="";return e.each(i,function(t,e){n+=(n?"&":"")+encodeURIComponent(e)+"="+encodeURIComponent(t)}),n&&(t+=(t.indexOf("?")>0?"&":"?")+n),t}var a;n.call(this),this._options={file_data_name:"file",headers:!1,http_method:"POST",multipart:!0,params:{},send_file_name:!0,url:!1},e.extend(this,{start:function(){var r,u,l=this,p=this.state,c=l._options;if(this.state===n.PROCESSING)return!1;this.startedTimestamp||(this.startedTimestamp=+new Date),this.state=n.PROCESSING,this.trigger("statechanged",this.state,p),a=new s,a.upload&&(a.upload.onprogress=function(t){l.progress(t.loaded,t.total)}),a.onload=function(){var t={response:this.responseText,status:this.status,responseHeaders:this.getAllResponseHeaders()};return this.status<200||this.status>=400?l.failed(t):(l.done(t),void 0)},a.onerror=function(){l.failed()},a.onloadend=function(){setTimeout(function(){a&&(a.destroy(),a=null)},1)};try{r=c.multipart?c.url:i(c.url,c.params),a.open(c.http_method,r,!0),e.isEmptyObj(c.headers)||e.each(c.headers,function(t,e){a.setRequestHeader(e,t)}),c.multipart?(u=new o,e.isEmptyObj(c.params)||e.each(c.params,function(t,e){u.append(e,t)}),u.append(c.file_data_name,t),a.send(u)):((e.isEmptyObj(c.headers)||!a.hasRequestHeader("content-type"))&&a.setRequestHeader("content-type","application/octet-stream"),a.send(t)),this.trigger("started")}catch(d){l.failed()}},stop:function(){a&&(a.abort(),a.destroy(),a=null),r.prototype.stop.call(this)},setOption:function(t,e){r.prototype.setOption.call(this,t,e,!0)},setOptions:function(t){r.prototype.setOption.call(this,t,!0)},destroy:function(){this.stop(),r.prototype.destroy.call(this)}})}var s=t.xhr.XMLHttpRequest,o=t.xhr.FormData;return e.inherit(r,n),r}),r("plupload/FileUploader",["plupload","plupload/core/Collection","plupload/core/Queueable","plupload/ChunkUploader"],function(t,e,i,n){function r(s,o){function a(){var t=0;return l.each(function(e){e.state===i.DONE&&(t+=e.end-e.start)}),t}function u(){for(var t=0;p>t&&l.hasKey(t);)t++;return t}var l=new e,p=1;i.call(this),this._options={chunk_size:0,params:{},send_file_name:!0,stop_on_fail:!0},t.extend(this,{name:s.name,start:function(){var t,e=this,r=this.state;return this.state===i.PROCESSING?!1:(this.startedTimestamp||(this.startedTimestamp=+new Date),this.state=i.PROCESSING,this.trigger("statechanged",this.state,r),e._options.send_file_name&&(e._options.params.name=e.target_name||e.name),e._options.chunk_size?(p=Math.ceil(s.size/e._options.chunk_size),e.uploadChunk(!1,!0)):(t=new n(s),t.bind("progress",function(t){e.progress(t.loaded,t.total)}),t.bind("done",function(t,i){e.done(i)}),t.bind("failed",function(t,i){e.failed(i)}),t.setOptions(e._options),o.addItem(t)),this.trigger("started"),void 0)},uploadChunk:function(e,r){var c,d,h=this,f=this.getOption("chunk_size"),g={};return g.seq=parseInt(e,10)||u(),g.start=g.seq*f,g.end=Math.min(g.start+f,s.size),g.total=s.size,g.start<0||g.start>=s.size?!1:(d=t.extendImmutable({},this.getOptions(),{params:{chunk:g.seq,chunks:p}}),c=new n(s.slice(g.start,g.end,s.type)),c.bind("progress",function(t){h.progress(a()+t.loaded,s.size)}),c.bind("failed",function(e,n){l.add(g.seq,t.extend({state:i.FAILED},g)),h.trigger("chunkuploadfailed",t.extendImmutable({},g,n)),d.stop_on_fail&&h.failed(n)}),c.bind("done",function(e,n){l.add(g.seq,t.extend({state:i.DONE},g)),h.trigger("chunkuploaded",t.extendImmutable({},g,n)),a()>=s.size?(h.progress(s.size,s.size),h.done(n)):r&&t.delay(function(){h.uploadChunk(u(),r)})}),c.bind("processed",function(){this.destroy()}),c.setOptions(d),l.add(g.seq,t.extend({state:i.PROCESSING},g)),o.addItem(c),r&&o.countSpareSlots()&&h.uploadChunk(u(),r),!0)},destroy:function(){r.prototype.destroy.call(this),l.clear()}})}return t.inherit(r,i),r}),r("plupload/ImageResizer",["plupload","plupload/core/Queueable"],function(e,i){function n(t){i.call(this),this._options={type:"image/jpeg",quality:90,crop:!1,fit:!0,preserveHeaders:!0,resample:"default",multipass:!0},this.setOption=function(t){("object"==typeof t||this._options.hasOwnProperty(t))&&n.prototype.setOption.apply(this,arguments)},this.start=function(e){var i,n=this;e&&this.setOptions(e.resize),i=new r,i.bind("load",function(){this.resize(n.getOptions())}),i.bind("resize",function(){n.done(this.getAsBlob(n.getOption("type"),n.getOption("quality"))),this.destroy()}),i.bind("error",function(){n.failed(),this.destroy()}),i.load(t,n.getOption("runtimeOptions"))}}var r=t.image.Image;return e.inherit(n,i),e.Image=r,n}),r("plupload/File",["plupload","plupload/core/Queueable","plupload/FileUploader","plupload/ImageResizer"],function(t,e,i,n){function r(a,u,l){e.call(this),t.extend(this,{id:this.uid,name:a.name,target_name:null,type:a.type,size:a.size,origSize:a.size,start:function(){var i=this.state;return this.state===e.PROCESSING?!1:(this.state=e.PROCESSING,this.trigger("statechanged",this.state,i),this.trigger("started"),!t.isEmptyObj(this._options.resize)&&s(this.type)&&o(a,"send_binary_string")?this.resizeAndUpload():this.upload(),!0)},getSource:function(){return a},getNative:function(){return this.getFile().getSource()},resizeAndUpload:function(){var t=this,e=t.getOptions(),i=new n(a);i.bind("progress",function(e){t.progress(e.loaded,e.total)}),i.bind("done",function(e,i){i=i,t.upload()}),i.bind("failed",function(){t.upload()}),i.setOption("runtimeOptions",{runtime_order:e.runtimes,required_caps:e.required_features,preferred_caps:e.preferred_caps,swf_url:e.flash_swf_url,xap_url:e.silverlight_xap_url}),l.addItem(i)},upload:function(){var t=this,e=new i(a,u);e.bind("paused",function(){t.pause()}),e.bind("resumed",function(){this.start()}),e.bind("started",function(){t.trigger("startupload")}),e.bind("progress",function(e){t.progress(e.loaded,e.total)}),e.bind("done",function(e,i){t.done(i)}),e.bind("failed",function(e,i){t.failed(i)}),e.setOptions(t.getOptions()),e.start()},destroy:function(){r.prototype.destroy.call(this),a=null}})}function s(e){return t.inArray(e,["image/jpeg","image/png"])>-1}function o(e,i){if(e.ruid){var n=t.Runtime.getInfo(e.ruid);if(n)return n.can(i)}return!1}return t.inherit(r,e),r}),r("plupload/Uploader",["plupload","plupload/core/Collection","plupload/core/Queue","plupload/QueueUpload","plupload/QueueResize","plupload/File"],function(e,i,n,r,s,o){function a(i){function u(){var t=O[0]||b[0];return t?t.getRuntime().uid:!1}function c(){this.bind("FilesAdded FilesRemoved",function(t){t.trigger("QueueChanged"),t.refresh()},this,999),this.bind("BeforeUpload",g),this.bind("Stopped",function(t){t.trigger("UploadComplete")}),this.bind("Error",m),this.bind("Destroy",_)}function d(i){var n=this,r=0,s=[],o={runtime_order:n.getOption("runtimes"),required_caps:n.getOption("required_features"),preferred_caps:n.getOption("preferred_caps"),swf_url:n.getOption("flash_swf_url"),xap_url:n.getOption("silverlight_xap_url")};e.each(n.getOption("runtimes").split(/\s*,\s*/),function(t){n.getOption(t)&&(o[t]=n.getOption(t))}),n.getOption("browse_button")&&e.each(n.getOption("browse_button"),function(i){s.push(function(s){var a=new t.file.FileInput(e.extend({},o,{accept:n.getOption("filters").mime_types,name:n.getOption("file_data_name"),multiple:n.getOption("multi_selection"),container:n.getOption("container"),browse_button:i}));a.onready=function(){var t=e.Runtime.getInfo(this.ruid);e.extend(n.features,{chunks:t.can("slice_blob"),multipart:t.can("send_multipart"),multi_selection:t.can("select_multiple")}),r++,O.push(this),s()},a.onchange=function(){n.addFile(this.files)},a.bind("mouseenter mouseleave mousedown mouseup",function(t){R||(n.getOption("browse_button_hover")&&("mouseenter"===t.type?e.addClass(i,n.getOption("browse_button_hover")):"mouseleave"===t.type&&e.removeClass(i,n.getOption("browse_button_hover"))),n.getOption("browse_button_active")&&("mousedown"===t.type?e.addClass(i,n.getOption("browse_button_active")):"mouseup"===t.type&&e.removeClass(i,n.getOption("browse_button_active"))))}),a.bind("mousedown",function(){n.trigger("Browse")}),a.bind("error runtimeerror",function(){a=null,s()}),a.init()})}),n.getOption("drop_element")&&e.each(n.getOption("drop_element"),function(i){s.push(function(s){var a=new t.file.FileDrop(e.extend({},o,{drop_zone:i}));a.onready=function(){var t=e.Runtime.getInfo(this.ruid);e.extend(n.features,{chunks:t.can("slice_blob"),multipart:t.can("send_multipart"),dragdrop:t.can("drag_and_drop")}),r++,b.push(this),s()},a.ondrop=function(){n.addFile(this.files)},a.bind("error runtimeerror",function(){a=null,s()}),a.init()})}),e.inParallel(s,function(){"function"==typeof i&&i(r)})}function g(t,e){if(t.getOption("unique_names")){var i=e.name.match(/\.([^.]+)$/),n="part";i&&(n=i[1]),e.target_name=e.id+"."+n}}function m(t,i){i.code===e.INIT_ERROR?t.destroy():i.code===e.HTTP_ERROR&&t.state==e.STARTED&&t.trigger("CancelUpload")}function _(t){t.forEachItem(function(t){t.destroy()}),O.length&&(e.each(O,function(t){t.destroy()}),O=[]),b.length&&(e.each(b,function(t){t.destroy()}),b=[]),E=!1,y&&y.destroy(),v&&v.destroy(),I=y=v=null}var y,v,O=[],b=[],E=!1,R=!1,I=l(e.extend({backward_compatibility:!0,chunk_size:0,file_data_name:"file",filters:{mime_types:"*",prevent_duplicates:!1,max_file_size:0},flash_swf_url:"js/Moxie.swf",http_method:"POST",max_resize_slots:1,max_retries:0,max_upload_slots:1,multipart:!0,multipart_params:{},multi_selection:!0,params:{},resize:!1,runtimes:e.Runtime.order,send_chunk_number:!0,send_file_name:!0,silverlight_xap_url:"js/Moxie.xap",required_features:!1,preferred_caps:!1},i));n.call(this),e.extend(this,{_options:I,id:this.uid,state:e.STOPPED,features:{},settings:I,runtime:null,files:[],total:this.stats,init:function(){var t,i,n=this;return t=n.getOption("preinit"),"function"==typeof t?t(n):e.each(t,function(t,e){n.bind(e,t)}),c.call(n),e.each(["container","browse_button","drop_element"],function(t){return null===n.getOption(t)?(i={code:e.INIT_ERROR,message:e.sprintf(e.translate("%s specified, but cannot be found."),t)},!1):void 0}),i?n.trigger("Error",i):n.getOption("browse_button")||n.getOption("drop_element")?(d.call(n,function(t){var i,o=n.getOption("init"),a=e.extendImmutable({},n.getOption(),{auto_start:!0});"function"==typeof o?o(n):e.each(o,function(t,e){n.bind(e,t)}),t?(E=!0,i=e.Runtime.getInfo(u()),y=new r(a),v=new s(a),n.trigger("Init",{ruid:i.uid,runtime:n.runtime=i.type}),n.trigger("PostInit")):n.trigger("Error",{code:e.INIT_ERROR,message:e.translate("Init error.")})}),void 0):n.trigger("Error",{code:e.INIT_ERROR,message:e.translate("You must specify either browse_button or drop_element.")})},setOption:function(t,i){return E&&e.inArray(t,["container","browse_button","drop_element","runtimes","multi_selection","flash_swf_url","silverlight_xap_url"])>-1?this.trigger("Error",{code:e.OPTION_ERROR,message:e.sprintf(e.translate("%s option cannot be changed.")),option:t}):("object"!=typeof t&&(i=p(t,i,this._options),y&&y.setOption(t,i),v&&v.setOption(t,i)),a.prototype.setOption.call(this,t,i),void 0)},refresh:function(){O.length&&e.each(O,function(t){t.trigger("Refresh")}),b.length&&e.each(b,function(t){t.trigger("Refresh")}),this.trigger("Refresh")},stop:function(){a.prototype.stop.call(this)&&this.state!=e.STOPPED&&this.trigger("CancelUpload")},disableBrowse:function(){R=arguments[0]!==h?arguments[0]:!0,O.length&&e.each(O,function(t){t.disable(R)}),this.trigger("DisableBrowse",R)},getFile:function(t){return this.getItem(t)},addFile:function(i,n){function r(t){t.bind("beforestart",function(t){return p.trigger("BeforeUpload",t.target)}),t.bind("startupload",function(){p.trigger("UploadFile",this)}),t.bind("progress",function(){p.trigger("UploadProgress",this)}),t.bind("done",function(t,e){p.trigger("FileUploaded",this,e)}),t.bind("failed",function(t,i){p.trigger("Error",e.extend({code:e.HTTP_ERROR,message:e.translate("HTTP Error."),file:this},i))})}function s(t,i){var n=[];e.each(p.getOption("filters"),function(e,i){f[i]&&n.push(function(n){f[i].call(p,e,t,function(t){n(!t)})})}),e.inParallel(n,i)}function a(i){var u=e.typeOf(i);if(i instanceof t.file.File){if(!i.ruid&&!i.isDetached()){if(!l)return!1;i.ruid=l,i.connectRuntime(l)}c.push(function(t){s(i,function(s){var a;s||(a=new o(i,y,v),n&&(a.name=n),r(a),p.addItem(a),d.push(a),p.trigger("FileFiltered",a)),e.delay(t)})})}else i instanceof t.file.Blob?(a(i.getSource()),i.destroy()):-1!==e.inArray(u,["file","blob"])?a(new t.file.File(null,i)):"node"===u&&"filelist"===e.typeOf(i.files)?e.each(i.files,a):"array"===u&&(n=null,e.each(i,a))}var l,p=this,c=[],d=[];l=u(),a(i),c.length&&e.inParallel(c,function(){d.length&&p.trigger("FilesAdded",d)})},removeFile:function(t){var e=this.extractItem("string"==typeof t?t:t.uid);e&&(this.trigger("FilesRemoved",[e]),e.destroy())},splice:function(){var t=0,i=e.STARTED==this.state,r=n.prototype.splice.apply(this,arguments);if(r.length){for(this.trigger("FilesRemoved",r),i&&this.stop(),t=0;t<r.length;t++)r[t].destroy();i&&this.start()}},dispatchEvent:function(t){var e,i;if(t=t.toLowerCase(),e=this.hasEventListener(t)){e.sort(function(t,e){return e.priority-t.priority}),i=[].slice.call(arguments),i.shift(),i.unshift(this);for(var n=0;n<e.length;n++)if(e[n].fn.apply(e[n].scope,i)===!1)return!1}return!0},bind:function(t,i,n,r){e.Uploader.prototype.bind.call(this,t,i,r,n)}}),I.backward_compatibility&&(this.bind("FilesAdded FilesRemoved",function(t){t.files=t.toArray()},this,999),this.bind("OptionChanged",function(t,i,n){t.settings[i]="object"==typeof n?e.extend({},n):n},this,999))}function u(t){function i(t,e,i){var n={chunks:"slice_blob",jpgresize:"send_binary_string",pngresize:"send_binary_string",progress:"report_upload_progress",multi_selection:"select_multiple",dragdrop:"drag_and_drop",drop_element:"drag_and_drop",headers:"send_custom_headers",urlstream_upload:"send_binary_string",canSendBinary:"send_binary",triggerDialog:"summon_file_dialog"};n[t]?r[n[t]]=e:i||(r[t]=e)}var n=t.required_features,r={};return"string"==typeof n?e.each(n.split(/\s*,\s*/),function(t){i(t,!0)}):"object"==typeof n?e.each(n,function(t,e){i(e,t)}):n===!0&&(t.chunk_size&&t.chunk_size>0&&(r.slice_blob=!0),e.isEmptyObj(t.resize)&&t.multipart!==!1||(r.send_binary_string=!0),t.http_method&&(r.use_http_method=t.http_method),e.each(t,function(t,e){i(e,!!t,!0)})),r}function l(t){return e.each(t,function(e,i){t[i]=p(i,e,t)}),t}function p(t,i,n){switch(t){case"chunk_size":(i=e.parseSize(i))&&(n.send_file_name=!0);break;case"headers":var r={};return"object"==typeof i&&e.each(i,function(t,e){r[e.toLowerCase()]=t}),r;case"http_method":return"PUT"===i.toUpperCase()?"PUT":"POST";case"filters":return"array"===e.typeOf(i)&&(i={mime_types:i}),i.mime_types&&("string"===e.typeOf(i.mime_types)&&(i.mime_types=e.mimes2extList(i.mime_types)),n.re_ext_filter=function(t){var i=[];return e.each(t,function(t){e.each(t.extensions.split(/,/),function(t){/^\s*\*\s*$/.test(t)?i.push("\\.*"):i.push("\\."+t.replace(new RegExp("["+"/^$.*+?|()[]{}\\".replace(/./g,"\\$&")+"]","g"),"\\$&"))})}),new RegExp("("+i.join("|")+")$","i")}(i.mime_types)),i;case"max_file_size":n&&!n.filters&&(n.filters={}),n.filters.max_file_size=i;break;case"multipart":i||(n.send_file_name=!0);break;case"multipart_params":n.params=n.multipart_params=i;break;case"resize":return i?e.extend({preserve_headers:!0,crop:!1},i):!1;case"prevent_duplicates":n&&!n.filters&&(n.filters={}),n.filters.prevent_duplicates=!!i;break;case"unique_names":i&&(n.send_file_name=!0);break;case"required_features":return u(e.extend({},n));case"preferred_caps":return u(e.extend({},n,{required_features:!0}));case"container":case"browse_button":case"drop_element":return"container"===t?e.get(i):e.getAll(i)}return i}function c(t,e){f[t]=e}function d(t,i){var n,r;return n=new a(t),r=e.Runtime.thatCan(n.getOption("required_features"),i||t.runtimes),n.destroy(),r}var h,f={};return c("mime_types",function(t,i,n){t.length&&!this.getOption("re_ext_filter").test(i.name)?(this.trigger("Error",{code:e.FILE_EXTENSION_ERROR,message:e.translate("File extension error."),file:i}),n(!1)):n(!0)}),c("max_file_size",function(t,i,n){var r;t=e.parseSize(t),i.size!==r&&t&&i.size>t?(this.trigger("Error",{code:e.FILE_SIZE_ERROR,message:e.translate("File size error."),file:i}),n(!1)):n(!0)}),c("prevent_duplicates",function(t,i,n){var r=this;t&&this.forEachItem(function(t){return i.name===t.name&&i.size===t.size?(r.trigger("Error",{code:e.FILE_DUPLICATE_ERROR,message:e.translate("Duplicate file error."),file:i}),n(!1),void 0):void 0}),n(!0)}),c("prevent_empty",function(t,i,n){t&&!i.size&&i.size!==h?(this.trigger("Error",{code:e.FILE_SIZE_ERROR,message:e.translate("File size error."),file:i}),n(!1)):n(!0)}),a.addFileFilter=c,e.inherit(a,n),e.addFileFilter=c,e.predictRuntime=d,a}),o(["plupload","plupload/core/Collection","plupload/core/ArrCollection","plupload/core/Optionable","plupload/core/Queueable","plupload/core/Stats","plupload/core/Queue","plupload/QueueUpload","plupload/QueueResize","plupload/ChunkUploader","plupload/FileUploader","plupload/ImageResizer","plupload/File","plupload/Uploader"])}(this)});