## Interfaces:

**OAuthConsumer** is a data type that represents the identity of the Consumer via its shared secret with the Service Provider.

OAuthConsumer
  - `key : str`
  - `secret : str`

**OAuthToken** is a data type that represents an End User via either an access or request token

OAuthToken
  - `token : str`
  - `secret : str`
  - `to_string() -> str`
  - `(static) from_string() -> OAuthToken`

**OAuthSignatureMethod** is a strategy class that implements a signature method

OAuthSignatureMethod
  - `get_name() -> str`
  - `build_signature (OAuthRequest, OAuthConsumer, OAuthToken) -> str`

**OAuthRequest** represents the request and can be seriali

OAuthRequest:
  - `OAuthRequest(str http_method, str http_url, [dict parameters]) -> constructor`
  - `set_parameter(str parameter, str value) -> void`
    - `example parameters: oauth_consumer_key, foo`
  - `get_parameter(str parameter) -> str`
  - `get_parameters() -> dict`

  - `get_normalized_http_method() -> str`
  - `get_normalized_http_url() -> str`
  - `get_signable_params() -> dict`

  - `to_header () -> str   // serialize as a header for an HTTPAuth request`
  - `to_postdata () -> str // serialize as post data for a POST request`
  - `to_url () -> str      // serialize as a url for a GET request`
  - `sign_request(OAuthSignatureMethod, OAuthConsumer, OAuthToken) -> void`
  - `build_signature(OAuthSignatureMethod, OAuthConsumer, OAuthToken) -> str`
  - `(static) from_request([str http_method, str http_url, dict parameters])`
  - `(static) from_consumer_and_token(OAuthConsumer, OAuthToken, str http_method, str http_url, [dict parameters]) -> OAuthRequest`


**OAuthServer** is a worker to check a requests validity against a data store

OAuthServer:
  - `OAuthServer(OAuthDataStore) -> constructor`
  - `set_data_store(OAuthDataStore) -> void`
  - `get_data_store() -> OAuthDataStore`

  - `fetch_request_token (OAuthRequest) -> OAuthToken`
  - `fetch_access_token (OAuthRequest) -> OAuthToken`
  - `verify_request (OAuthRequest) -> OAuthToken`

**OAuthClient** is a worker to attempt to execute a request

OAuthClient:
  - `OAuthClient(OAuthConsumer, OAuthToken) -> constructor`
  - `get_consumer() -> OAuthConsumer`
  - `get_token() -> OAuthToken`

  - `fetch_request_token (OAuthRequest) -> OAuthToken`
  - `fetch_access_token (OAuthRequest) -> OAuthToken`

**OAuthDataStore** is a database abstraction used to lookup consumers and tokens

OAuthDataStore:
  - `lookup_consumer(str key) -> OAuthConsumer`
  - `lookup_token(OAuthConsumer, str token_type, str token_token) -> OAuthToken`
  - `lookup_nonce(OAuthConsumer, OAuthToken, str nonce, int timestamp) -> OAuthToken`
  - `fetch_request_token(OAuthConsumer) -> OAuthToken`
  - `fetch_access_token(OAuthConsumer, OAuthToken) -> OAuthToken`
