<?php

/*
 * This file is part of the PHPExifTool package.
 *
 * (c) Alchemy <support@alchemy.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace PHPExiftool\Driver\Tag\MOBI;

use JMS\Serializer\Annotation\ExclusionPolicy;
use PHPExiftool\Driver\AbstractTag;

/**
 * @ExclusionPolicy("all")
 */
class MobiType extends AbstractTag
{

    protected $Id = 6;

    protected $Name = 'MobiType';

    protected $FullName = 'Palm::MOBI';

    protected $GroupName = 'MOBI';

    protected $g0 = 'Palm';

    protected $g1 = 'MOBI';

    protected $g2 = 'Document';

    protected $Type = 'int32u';

    protected $Writable = false;

    protected $Description = 'Mobi Type';

    protected $Values = array(
        2 => array(
            'Id' => 2,
            'Label' => 'Mobipocket Book',
        ),
        3 => array(
            'Id' => 3,
            'Label' => 'PalmDoc Book',
        ),
        4 => array(
            'Id' => 4,
            'Label' => 'Audio',
        ),
        232 => array(
            'Id' => 232,
            'Label' => 'mobipocket? generated by kindlegen1.2',
        ),
        248 => array(
            'Id' => 248,
            'Label' => 'KF8: generated by kindlegen2',
        ),
        257 => array(
            'Id' => 257,
            'Label' => 'News',
        ),
        258 => array(
            'Id' => 258,
            'Label' => 'News_Feed',
        ),
        259 => array(
            'Id' => 259,
            'Label' => 'News_Magazine',
        ),
        513 => array(
            'Id' => 513,
            'Label' => 'PICS',
        ),
        514 => array(
            'Id' => 514,
            'Label' => 'WORD',
        ),
        515 => array(
            'Id' => 515,
            'Label' => 'XLS',
        ),
        516 => array(
            'Id' => 516,
            'Label' => 'PPT',
        ),
        517 => array(
            'Id' => 517,
            'Label' => 'TEXT',
        ),
        518 => array(
            'Id' => 518,
            'Label' => 'HTML',
        ),
    );

}
