<?php

/*
 * This file is part of the Sonata Project package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\BlockBundle\Cache;

use Sonata\BlockBundle\Block\BlockContextInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\FilterResponseEvent;

interface HttpCacheHandlerInterface
{
    /**
     * Add valid http cache information.
     *
     * The Response object is the final object returned to the client
     *
     * @param Response $response
     */
    public function alterResponse(Response $response);

    /**
     * This function can update a state to store the final ttl used for the page
     * The response object point to the Response generated by a block service and
     * not the final response rendered to the client.
     *
     * @param Response              $response
     * @param BlockContextInterface $blockContext
     */
    public function updateMetadata(Response $response, BlockContextInterface $blockContext = null);

    /**
     * @param FilterResponseEvent $event
     *
     * @return mixed
     */
    public function onKernelResponse(FilterResponseEvent $event);
}
