DROP TABLE IF EXISTS `%table_prefix%albums`;
CREATE TABLE `%table_prefix%albums` (
  `album_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `album_name` VARCHAR(100) NOT NULL,
  `album_user_id` INT UNSIGNED DEFAULT NULL,
  `album_date` DATETIME NOT NULL,
  `album_date_gmt` DATETIME NOT NULL,
  `album_creation_ip` VARCHAR(255) NOT NULL,
  `album_privacy` ENUM('public','password','private','private_but_link','custom') DEFAULT 'public',
  `album_privacy_extra` TEXT,
  `album_password` TEXT,
  `album_image_count` INT UNSIGNED NOT NULL DEFAULT '0',
  `album_description` TEXT,
  `album_likes` INT UNSIGNED NOT NULL DEFAULT '0',
  `album_views` INT UNSIGNED NOT NULL DEFAULT '0',
  `album_cover_id` INT UNSIGNED DEFAULT NULL,
  `album_parent_id` INT UNSIGNED DEFAULT NULL,
  `album_cta_enable` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `album_cta` TEXT,
  PRIMARY KEY (`album_id`),
  KEY `album_name` (`album_name`),
  KEY `album_user_id` (`album_user_id`),
  KEY `album_date_gmt` (`album_date_gmt`),
  KEY `album_privacy` (`album_privacy`),
  KEY `album_image_count` (`album_image_count`),
  KEY `album_creation_ip` (`album_creation_ip`),
  KEY `album_likes` (`album_likes`),
  KEY `album_views` (`album_views`),
  KEY `album_parent_id` (`album_parent_id`),
  KEY `album_user_id_parent_id_name` (`album_user_id`, `album_parent_id`, `album_name`),
  FULLTEXT KEY `searchindex` (`album_name`,`album_description`)
) ENGINE=%table_engine% DEFAULT CHARSET=utf8mb4;
