<?php

declare (strict_types=1);
/*
 * This file is part of PHP CS Fixer.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *     Dariusz Rumiński <dariusz.ruminski@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */
namespace PhpCsFixer\Console\Command;

/**
 * @internal
 */
final class DescribeNameNotFoundException extends \InvalidArgumentException
{
    /**
     * @var string
     */
    private $name;
    /**
     * 'rule'|'set'.
     * @var string
     */
    private $type;
    public function __construct(string $name, string $type)
    {
        $this->name = $name;
        $this->type = $type;
        parent::__construct();
    }
    public function getName() : string
    {
        return $this->name;
    }
    public function getType() : string
    {
        return $this->type;
    }
}
