<?php

/**
 * Unit test class for the IncludingFile sniff.
 *
 * @author    Greg Sherwood <gsherwood@squiz.net>
 * @copyright 2006-2015 Squiz Pty Ltd (ABN 77 084 670 600)
 * @license   https://github.com/PHPCSStandards/PHP_CodeSniffer/blob/master/licence.txt BSD Licence
 */
namespace PHP_CodeSniffer\Standards\PEAR\Tests\Files;

use PHP_CodeSniffer\Tests\Standards\AbstractSniffUnitTest;
/**
 * Unit test class for the IncludingFile sniff.
 *
 * @covers \PHP_CodeSniffer\Standards\PEAR\Sniffs\Files\IncludingFileSniff
 */
final class IncludingFileUnitTest extends AbstractSniffUnitTest
{
    /**
     * Returns the lines where errors should occur.
     *
     * The key of the array should represent the line number and the value
     * should represent the number of errors that should occur on that line.
     *
     * @return array<int, int>
     */
    public function getErrorList()
    {
        return [4 => 1, 5 => 1, 11 => 1, 12 => 1, 16 => 1, 17 => 1, 33 => 1, 34 => 1, 47 => 1, 48 => 1, 64 => 1, 65 => 1, 73 => 1, 74 => 1, 85 => 1, 86 => 1, 98 => 1, 99 => 2];
    }
    //end getErrorList()
    /**
     * Returns the lines where warnings should occur.
     *
     * The key of the array should represent the line number and the value
     * should represent the number of warnings that should occur on that line.
     *
     * @return array<int, int>
     */
    public function getWarningList()
    {
        return [];
    }
    //end getWarningList()
}
//end class
